/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

// Protobuf Java Version: 3.25.2
package com.google.cloudbuild.v1;

/** Protobuf type {@code google.devtools.cloudbuild.v1.GitHubEnterpriseConfig} */
public final class GitHubEnterpriseConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.GitHubEnterpriseConfig)
    GitHubEnterpriseConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GitHubEnterpriseConfig.newBuilder() to construct.
  private GitHubEnterpriseConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GitHubEnterpriseConfig() {
    name_ = "";
    hostUrl_ = "";
    webhookKey_ = "";
    peeredNetwork_ = "";
    displayName_ = "";
    sslCa_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GitHubEnterpriseConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_GitHubEnterpriseConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_GitHubEnterpriseConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.GitHubEnterpriseConfig.class,
            com.google.cloudbuild.v1.GitHubEnterpriseConfig.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The full resource name for the GitHubEnterpriseConfig
   * For example:
   * "projects/{$project_id}/locations/{$location_id}/githubEnterpriseConfigs/{$config_id}"
   * </pre>
   *
   * <code>string name = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The full resource name for the GitHubEnterpriseConfig
   * For example:
   * "projects/{$project_id}/locations/{$location_id}/githubEnterpriseConfigs/{$config_id}"
   * </pre>
   *
   * <code>string name = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HOST_URL_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object hostUrl_ = "";
  /**
   *
   *
   * <pre>
   * The URL of the github enterprise host the configuration is for.
   * </pre>
   *
   * <code>string host_url = 3;</code>
   *
   * @return The hostUrl.
   */
  @java.lang.Override
  public java.lang.String getHostUrl() {
    java.lang.Object ref = hostUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      hostUrl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL of the github enterprise host the configuration is for.
   * </pre>
   *
   * <code>string host_url = 3;</code>
   *
   * @return The bytes for hostUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHostUrlBytes() {
    java.lang.Object ref = hostUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      hostUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APP_ID_FIELD_NUMBER = 4;
  private long appId_ = 0L;
  /**
   *
   *
   * <pre>
   * Required. The GitHub app id of the Cloud Build app on the GitHub Enterprise
   * server.
   * </pre>
   *
   * <code>int64 app_id = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The appId.
   */
  @java.lang.Override
  public long getAppId() {
    return appId_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the installation was associated with the project.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the installation was associated with the project.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the installation was associated with the project.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int WEBHOOK_KEY_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object webhookKey_ = "";
  /**
   *
   *
   * <pre>
   * The key that should be attached to webhook calls to the ReceiveWebhook
   * endpoint.
   * </pre>
   *
   * <code>string webhook_key = 8;</code>
   *
   * @return The webhookKey.
   */
  @java.lang.Override
  public java.lang.String getWebhookKey() {
    java.lang.Object ref = webhookKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      webhookKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The key that should be attached to webhook calls to the ReceiveWebhook
   * endpoint.
   * </pre>
   *
   * <code>string webhook_key = 8;</code>
   *
   * @return The bytes for webhookKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWebhookKeyBytes() {
    java.lang.Object ref = webhookKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      webhookKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PEERED_NETWORK_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object peeredNetwork_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The network to be used when reaching out to the GitHub
   * Enterprise server. The VPC network must be enabled for private
   * service connection. This should be set if the GitHub Enterprise server is
   * hosted on-premises and not reachable by public internet.
   * If this field is left empty, no network peering will occur and calls to
   * the GitHub Enterprise server will be made over the public internet.
   * Must be in the format
   * `projects/{project}/global/networks/{network}`, where {project}
   * is a project number or id and {network} is the name of a
   * VPC network in the project.
   * </pre>
   *
   * <code>
   * string peered_network = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The peeredNetwork.
   */
  @java.lang.Override
  public java.lang.String getPeeredNetwork() {
    java.lang.Object ref = peeredNetwork_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      peeredNetwork_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The network to be used when reaching out to the GitHub
   * Enterprise server. The VPC network must be enabled for private
   * service connection. This should be set if the GitHub Enterprise server is
   * hosted on-premises and not reachable by public internet.
   * If this field is left empty, no network peering will occur and calls to
   * the GitHub Enterprise server will be made over the public internet.
   * Must be in the format
   * `projects/{project}/global/networks/{network}`, where {project}
   * is a project number or id and {network} is the name of a
   * VPC network in the project.
   * </pre>
   *
   * <code>
   * string peered_network = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for peeredNetwork.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPeeredNetworkBytes() {
    java.lang.Object ref = peeredNetwork_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      peeredNetwork_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SECRETS_FIELD_NUMBER = 10;
  private com.google.cloudbuild.v1.GitHubEnterpriseSecrets secrets_;
  /**
   *
   *
   * <pre>
   * Names of secrets in Secret Manager.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.GitHubEnterpriseSecrets secrets = 10;</code>
   *
   * @return Whether the secrets field is set.
   */
  @java.lang.Override
  public boolean hasSecrets() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Names of secrets in Secret Manager.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.GitHubEnterpriseSecrets secrets = 10;</code>
   *
   * @return The secrets.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.GitHubEnterpriseSecrets getSecrets() {
    return secrets_ == null
        ? com.google.cloudbuild.v1.GitHubEnterpriseSecrets.getDefaultInstance()
        : secrets_;
  }
  /**
   *
   *
   * <pre>
   * Names of secrets in Secret Manager.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.GitHubEnterpriseSecrets secrets = 10;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.GitHubEnterpriseSecretsOrBuilder getSecretsOrBuilder() {
    return secrets_ == null
        ? com.google.cloudbuild.v1.GitHubEnterpriseSecrets.getDefaultInstance()
        : secrets_;
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Name to display for this config.
   * </pre>
   *
   * <code>string display_name = 11;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name to display for this config.
   * </pre>
   *
   * <code>string display_name = 11;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SSL_CA_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sslCa_ = "";
  /**
   *
   *
   * <pre>
   * Optional. SSL certificate to use for requests to GitHub Enterprise.
   * </pre>
   *
   * <code>string ssl_ca = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The sslCa.
   */
  @java.lang.Override
  public java.lang.String getSslCa() {
    java.lang.Object ref = sslCa_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sslCa_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. SSL certificate to use for requests to GitHub Enterprise.
   * </pre>
   *
   * <code>string ssl_ca = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for sslCa.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSslCaBytes() {
    java.lang.Object ref = sslCa_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sslCa_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostUrl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, hostUrl_);
    }
    if (appId_ != 0L) {
      output.writeInt64(4, appId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(webhookKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, webhookKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(peeredNetwork_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, peeredNetwork_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(10, getSecrets());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sslCa_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, sslCa_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostUrl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, hostUrl_);
    }
    if (appId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, appId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(webhookKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, webhookKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(peeredNetwork_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, peeredNetwork_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getSecrets());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sslCa_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, sslCa_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.GitHubEnterpriseConfig)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.GitHubEnterpriseConfig other =
        (com.google.cloudbuild.v1.GitHubEnterpriseConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getHostUrl().equals(other.getHostUrl())) return false;
    if (getAppId() != other.getAppId()) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getWebhookKey().equals(other.getWebhookKey())) return false;
    if (!getPeeredNetwork().equals(other.getPeeredNetwork())) return false;
    if (hasSecrets() != other.hasSecrets()) return false;
    if (hasSecrets()) {
      if (!getSecrets().equals(other.getSecrets())) return false;
    }
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getSslCa().equals(other.getSslCa())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + HOST_URL_FIELD_NUMBER;
    hash = (53 * hash) + getHostUrl().hashCode();
    hash = (37 * hash) + APP_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAppId());
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + WEBHOOK_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getWebhookKey().hashCode();
    hash = (37 * hash) + PEERED_NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getPeeredNetwork().hashCode();
    if (hasSecrets()) {
      hash = (37 * hash) + SECRETS_FIELD_NUMBER;
      hash = (53 * hash) + getSecrets().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + SSL_CA_FIELD_NUMBER;
    hash = (53 * hash) + getSslCa().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.GitHubEnterpriseConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.GitHubEnterpriseConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.GitHubEnterpriseConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.GitHubEnterpriseConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.GitHubEnterpriseConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.GitHubEnterpriseConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.GitHubEnterpriseConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.GitHubEnterpriseConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.GitHubEnterpriseConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.GitHubEnterpriseConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.GitHubEnterpriseConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.GitHubEnterpriseConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.GitHubEnterpriseConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /** Protobuf type {@code google.devtools.cloudbuild.v1.GitHubEnterpriseConfig} */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.GitHubEnterpriseConfig)
      com.google.cloudbuild.v1.GitHubEnterpriseConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_GitHubEnterpriseConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_GitHubEnterpriseConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.GitHubEnterpriseConfig.class,
              com.google.cloudbuild.v1.GitHubEnterpriseConfig.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.GitHubEnterpriseConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getSecretsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      hostUrl_ = "";
      appId_ = 0L;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      webhookKey_ = "";
      peeredNetwork_ = "";
      secrets_ = null;
      if (secretsBuilder_ != null) {
        secretsBuilder_.dispose();
        secretsBuilder_ = null;
      }
      displayName_ = "";
      sslCa_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_GitHubEnterpriseConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.GitHubEnterpriseConfig getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.GitHubEnterpriseConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.GitHubEnterpriseConfig build() {
      com.google.cloudbuild.v1.GitHubEnterpriseConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.GitHubEnterpriseConfig buildPartial() {
      com.google.cloudbuild.v1.GitHubEnterpriseConfig result =
          new com.google.cloudbuild.v1.GitHubEnterpriseConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloudbuild.v1.GitHubEnterpriseConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.hostUrl_ = hostUrl_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.appId_ = appId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.webhookKey_ = webhookKey_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.peeredNetwork_ = peeredNetwork_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.secrets_ = secretsBuilder_ == null ? secrets_ : secretsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.sslCa_ = sslCa_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.GitHubEnterpriseConfig) {
        return mergeFrom((com.google.cloudbuild.v1.GitHubEnterpriseConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.GitHubEnterpriseConfig other) {
      if (other == com.google.cloudbuild.v1.GitHubEnterpriseConfig.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getHostUrl().isEmpty()) {
        hostUrl_ = other.hostUrl_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getAppId() != 0L) {
        setAppId(other.getAppId());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (!other.getWebhookKey().isEmpty()) {
        webhookKey_ = other.webhookKey_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getPeeredNetwork().isEmpty()) {
        peeredNetwork_ = other.peeredNetwork_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasSecrets()) {
        mergeSecrets(other.getSecrets());
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getSslCa().isEmpty()) {
        sslCa_ = other.sslCa_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26:
              {
                hostUrl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 32:
              {
                appId_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 50
            case 58:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 58
            case 66:
              {
                webhookKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 66
            case 74:
              {
                peeredNetwork_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getSecretsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 82
            case 90:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 90
            case 98:
              {
                sslCa_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The full resource name for the GitHubEnterpriseConfig
     * For example:
     * "projects/{$project_id}/locations/{$location_id}/githubEnterpriseConfigs/{$config_id}"
     * </pre>
     *
     * <code>string name = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The full resource name for the GitHubEnterpriseConfig
     * For example:
     * "projects/{$project_id}/locations/{$location_id}/githubEnterpriseConfigs/{$config_id}"
     * </pre>
     *
     * <code>string name = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The full resource name for the GitHubEnterpriseConfig
     * For example:
     * "projects/{$project_id}/locations/{$location_id}/githubEnterpriseConfigs/{$config_id}"
     * </pre>
     *
     * <code>string name = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The full resource name for the GitHubEnterpriseConfig
     * For example:
     * "projects/{$project_id}/locations/{$location_id}/githubEnterpriseConfigs/{$config_id}"
     * </pre>
     *
     * <code>string name = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The full resource name for the GitHubEnterpriseConfig
     * For example:
     * "projects/{$project_id}/locations/{$location_id}/githubEnterpriseConfigs/{$config_id}"
     * </pre>
     *
     * <code>string name = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object hostUrl_ = "";
    /**
     *
     *
     * <pre>
     * The URL of the github enterprise host the configuration is for.
     * </pre>
     *
     * <code>string host_url = 3;</code>
     *
     * @return The hostUrl.
     */
    public java.lang.String getHostUrl() {
      java.lang.Object ref = hostUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        hostUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of the github enterprise host the configuration is for.
     * </pre>
     *
     * <code>string host_url = 3;</code>
     *
     * @return The bytes for hostUrl.
     */
    public com.google.protobuf.ByteString getHostUrlBytes() {
      java.lang.Object ref = hostUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        hostUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of the github enterprise host the configuration is for.
     * </pre>
     *
     * <code>string host_url = 3;</code>
     *
     * @param value The hostUrl to set.
     * @return This builder for chaining.
     */
    public Builder setHostUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      hostUrl_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of the github enterprise host the configuration is for.
     * </pre>
     *
     * <code>string host_url = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHostUrl() {
      hostUrl_ = getDefaultInstance().getHostUrl();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of the github enterprise host the configuration is for.
     * </pre>
     *
     * <code>string host_url = 3;</code>
     *
     * @param value The bytes for hostUrl to set.
     * @return This builder for chaining.
     */
    public Builder setHostUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      hostUrl_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private long appId_;
    /**
     *
     *
     * <pre>
     * Required. The GitHub app id of the Cloud Build app on the GitHub Enterprise
     * server.
     * </pre>
     *
     * <code>int64 app_id = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The appId.
     */
    @java.lang.Override
    public long getAppId() {
      return appId_;
    }
    /**
     *
     *
     * <pre>
     * Required. The GitHub app id of the Cloud Build app on the GitHub Enterprise
     * server.
     * </pre>
     *
     * <code>int64 app_id = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The appId to set.
     * @return This builder for chaining.
     */
    public Builder setAppId(long value) {

      appId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The GitHub app id of the Cloud Build app on the GitHub Enterprise
     * server.
     * </pre>
     *
     * <code>int64 app_id = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAppId() {
      bitField0_ = (bitField0_ & ~0x00000004);
      appId_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the installation was associated with the project.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the installation was associated with the project.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the installation was associated with the project.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the installation was associated with the project.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the installation was associated with the project.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the installation was associated with the project.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the installation was associated with the project.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the installation was associated with the project.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the installation was associated with the project.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private java.lang.Object webhookKey_ = "";
    /**
     *
     *
     * <pre>
     * The key that should be attached to webhook calls to the ReceiveWebhook
     * endpoint.
     * </pre>
     *
     * <code>string webhook_key = 8;</code>
     *
     * @return The webhookKey.
     */
    public java.lang.String getWebhookKey() {
      java.lang.Object ref = webhookKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        webhookKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The key that should be attached to webhook calls to the ReceiveWebhook
     * endpoint.
     * </pre>
     *
     * <code>string webhook_key = 8;</code>
     *
     * @return The bytes for webhookKey.
     */
    public com.google.protobuf.ByteString getWebhookKeyBytes() {
      java.lang.Object ref = webhookKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        webhookKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The key that should be attached to webhook calls to the ReceiveWebhook
     * endpoint.
     * </pre>
     *
     * <code>string webhook_key = 8;</code>
     *
     * @param value The webhookKey to set.
     * @return This builder for chaining.
     */
    public Builder setWebhookKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      webhookKey_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key that should be attached to webhook calls to the ReceiveWebhook
     * endpoint.
     * </pre>
     *
     * <code>string webhook_key = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWebhookKey() {
      webhookKey_ = getDefaultInstance().getWebhookKey();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key that should be attached to webhook calls to the ReceiveWebhook
     * endpoint.
     * </pre>
     *
     * <code>string webhook_key = 8;</code>
     *
     * @param value The bytes for webhookKey to set.
     * @return This builder for chaining.
     */
    public Builder setWebhookKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      webhookKey_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object peeredNetwork_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The network to be used when reaching out to the GitHub
     * Enterprise server. The VPC network must be enabled for private
     * service connection. This should be set if the GitHub Enterprise server is
     * hosted on-premises and not reachable by public internet.
     * If this field is left empty, no network peering will occur and calls to
     * the GitHub Enterprise server will be made over the public internet.
     * Must be in the format
     * `projects/{project}/global/networks/{network}`, where {project}
     * is a project number or id and {network} is the name of a
     * VPC network in the project.
     * </pre>
     *
     * <code>
     * string peered_network = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The peeredNetwork.
     */
    public java.lang.String getPeeredNetwork() {
      java.lang.Object ref = peeredNetwork_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        peeredNetwork_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The network to be used when reaching out to the GitHub
     * Enterprise server. The VPC network must be enabled for private
     * service connection. This should be set if the GitHub Enterprise server is
     * hosted on-premises and not reachable by public internet.
     * If this field is left empty, no network peering will occur and calls to
     * the GitHub Enterprise server will be made over the public internet.
     * Must be in the format
     * `projects/{project}/global/networks/{network}`, where {project}
     * is a project number or id and {network} is the name of a
     * VPC network in the project.
     * </pre>
     *
     * <code>
     * string peered_network = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for peeredNetwork.
     */
    public com.google.protobuf.ByteString getPeeredNetworkBytes() {
      java.lang.Object ref = peeredNetwork_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        peeredNetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The network to be used when reaching out to the GitHub
     * Enterprise server. The VPC network must be enabled for private
     * service connection. This should be set if the GitHub Enterprise server is
     * hosted on-premises and not reachable by public internet.
     * If this field is left empty, no network peering will occur and calls to
     * the GitHub Enterprise server will be made over the public internet.
     * Must be in the format
     * `projects/{project}/global/networks/{network}`, where {project}
     * is a project number or id and {network} is the name of a
     * VPC network in the project.
     * </pre>
     *
     * <code>
     * string peered_network = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The peeredNetwork to set.
     * @return This builder for chaining.
     */
    public Builder setPeeredNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      peeredNetwork_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The network to be used when reaching out to the GitHub
     * Enterprise server. The VPC network must be enabled for private
     * service connection. This should be set if the GitHub Enterprise server is
     * hosted on-premises and not reachable by public internet.
     * If this field is left empty, no network peering will occur and calls to
     * the GitHub Enterprise server will be made over the public internet.
     * Must be in the format
     * `projects/{project}/global/networks/{network}`, where {project}
     * is a project number or id and {network} is the name of a
     * VPC network in the project.
     * </pre>
     *
     * <code>
     * string peered_network = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeeredNetwork() {
      peeredNetwork_ = getDefaultInstance().getPeeredNetwork();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The network to be used when reaching out to the GitHub
     * Enterprise server. The VPC network must be enabled for private
     * service connection. This should be set if the GitHub Enterprise server is
     * hosted on-premises and not reachable by public internet.
     * If this field is left empty, no network peering will occur and calls to
     * the GitHub Enterprise server will be made over the public internet.
     * Must be in the format
     * `projects/{project}/global/networks/{network}`, where {project}
     * is a project number or id and {network} is the name of a
     * VPC network in the project.
     * </pre>
     *
     * <code>
     * string peered_network = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for peeredNetwork to set.
     * @return This builder for chaining.
     */
    public Builder setPeeredNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      peeredNetwork_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloudbuild.v1.GitHubEnterpriseSecrets secrets_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.GitHubEnterpriseSecrets,
            com.google.cloudbuild.v1.GitHubEnterpriseSecrets.Builder,
            com.google.cloudbuild.v1.GitHubEnterpriseSecretsOrBuilder>
        secretsBuilder_;
    /**
     *
     *
     * <pre>
     * Names of secrets in Secret Manager.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEnterpriseSecrets secrets = 10;</code>
     *
     * @return Whether the secrets field is set.
     */
    public boolean hasSecrets() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Names of secrets in Secret Manager.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEnterpriseSecrets secrets = 10;</code>
     *
     * @return The secrets.
     */
    public com.google.cloudbuild.v1.GitHubEnterpriseSecrets getSecrets() {
      if (secretsBuilder_ == null) {
        return secrets_ == null
            ? com.google.cloudbuild.v1.GitHubEnterpriseSecrets.getDefaultInstance()
            : secrets_;
      } else {
        return secretsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Names of secrets in Secret Manager.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEnterpriseSecrets secrets = 10;</code>
     */
    public Builder setSecrets(com.google.cloudbuild.v1.GitHubEnterpriseSecrets value) {
      if (secretsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        secrets_ = value;
      } else {
        secretsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Names of secrets in Secret Manager.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEnterpriseSecrets secrets = 10;</code>
     */
    public Builder setSecrets(
        com.google.cloudbuild.v1.GitHubEnterpriseSecrets.Builder builderForValue) {
      if (secretsBuilder_ == null) {
        secrets_ = builderForValue.build();
      } else {
        secretsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Names of secrets in Secret Manager.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEnterpriseSecrets secrets = 10;</code>
     */
    public Builder mergeSecrets(com.google.cloudbuild.v1.GitHubEnterpriseSecrets value) {
      if (secretsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && secrets_ != null
            && secrets_ != com.google.cloudbuild.v1.GitHubEnterpriseSecrets.getDefaultInstance()) {
          getSecretsBuilder().mergeFrom(value);
        } else {
          secrets_ = value;
        }
      } else {
        secretsBuilder_.mergeFrom(value);
      }
      if (secrets_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Names of secrets in Secret Manager.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEnterpriseSecrets secrets = 10;</code>
     */
    public Builder clearSecrets() {
      bitField0_ = (bitField0_ & ~0x00000040);
      secrets_ = null;
      if (secretsBuilder_ != null) {
        secretsBuilder_.dispose();
        secretsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Names of secrets in Secret Manager.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEnterpriseSecrets secrets = 10;</code>
     */
    public com.google.cloudbuild.v1.GitHubEnterpriseSecrets.Builder getSecretsBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getSecretsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Names of secrets in Secret Manager.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEnterpriseSecrets secrets = 10;</code>
     */
    public com.google.cloudbuild.v1.GitHubEnterpriseSecretsOrBuilder getSecretsOrBuilder() {
      if (secretsBuilder_ != null) {
        return secretsBuilder_.getMessageOrBuilder();
      } else {
        return secrets_ == null
            ? com.google.cloudbuild.v1.GitHubEnterpriseSecrets.getDefaultInstance()
            : secrets_;
      }
    }
    /**
     *
     *
     * <pre>
     * Names of secrets in Secret Manager.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEnterpriseSecrets secrets = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.GitHubEnterpriseSecrets,
            com.google.cloudbuild.v1.GitHubEnterpriseSecrets.Builder,
            com.google.cloudbuild.v1.GitHubEnterpriseSecretsOrBuilder>
        getSecretsFieldBuilder() {
      if (secretsBuilder_ == null) {
        secretsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.GitHubEnterpriseSecrets,
                com.google.cloudbuild.v1.GitHubEnterpriseSecrets.Builder,
                com.google.cloudbuild.v1.GitHubEnterpriseSecretsOrBuilder>(
                getSecrets(), getParentForChildren(), isClean());
        secrets_ = null;
      }
      return secretsBuilder_;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Name to display for this config.
     * </pre>
     *
     * <code>string display_name = 11;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name to display for this config.
     * </pre>
     *
     * <code>string display_name = 11;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name to display for this config.
     * </pre>
     *
     * <code>string display_name = 11;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name to display for this config.
     * </pre>
     *
     * <code>string display_name = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name to display for this config.
     * </pre>
     *
     * <code>string display_name = 11;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object sslCa_ = "";
    /**
     *
     *
     * <pre>
     * Optional. SSL certificate to use for requests to GitHub Enterprise.
     * </pre>
     *
     * <code>string ssl_ca = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The sslCa.
     */
    public java.lang.String getSslCa() {
      java.lang.Object ref = sslCa_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sslCa_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. SSL certificate to use for requests to GitHub Enterprise.
     * </pre>
     *
     * <code>string ssl_ca = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for sslCa.
     */
    public com.google.protobuf.ByteString getSslCaBytes() {
      java.lang.Object ref = sslCa_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sslCa_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. SSL certificate to use for requests to GitHub Enterprise.
     * </pre>
     *
     * <code>string ssl_ca = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The sslCa to set.
     * @return This builder for chaining.
     */
    public Builder setSslCa(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sslCa_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. SSL certificate to use for requests to GitHub Enterprise.
     * </pre>
     *
     * <code>string ssl_ca = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSslCa() {
      sslCa_ = getDefaultInstance().getSslCa();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. SSL certificate to use for requests to GitHub Enterprise.
     * </pre>
     *
     * <code>string ssl_ca = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for sslCa to set.
     * @return This builder for chaining.
     */
    public Builder setSslCaBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sslCa_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.GitHubEnterpriseConfig)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.GitHubEnterpriseConfig)
  private static final com.google.cloudbuild.v1.GitHubEnterpriseConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.GitHubEnterpriseConfig();
  }

  public static com.google.cloudbuild.v1.GitHubEnterpriseConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GitHubEnterpriseConfig> PARSER =
      new com.google.protobuf.AbstractParser<GitHubEnterpriseConfig>() {
        @java.lang.Override
        public GitHubEnterpriseConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GitHubEnterpriseConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GitHubEnterpriseConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.GitHubEnterpriseConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
