/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

// Protobuf Java Version: 3.25.2
package com.google.cloudbuild.v1;

public interface GitHubEnterpriseConfigOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.devtools.cloudbuild.v1.GitHubEnterpriseConfig)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Optional. The full resource name for the GitHubEnterpriseConfig
   * For example:
   * "projects/{$project_id}/locations/{$location_id}/githubEnterpriseConfigs/{$config_id}"
   * </pre>
   *
   * <code>string name = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Optional. The full resource name for the GitHubEnterpriseConfig
   * For example:
   * "projects/{$project_id}/locations/{$location_id}/githubEnterpriseConfigs/{$config_id}"
   * </pre>
   *
   * <code>string name = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The URL of the github enterprise host the configuration is for.
   * </pre>
   *
   * <code>string host_url = 3;</code>
   *
   * @return The hostUrl.
   */
  java.lang.String getHostUrl();
  /**
   *
   *
   * <pre>
   * The URL of the github enterprise host the configuration is for.
   * </pre>
   *
   * <code>string host_url = 3;</code>
   *
   * @return The bytes for hostUrl.
   */
  com.google.protobuf.ByteString getHostUrlBytes();

  /**
   *
   *
   * <pre>
   * Required. The GitHub app id of the Cloud Build app on the GitHub Enterprise
   * server.
   * </pre>
   *
   * <code>int64 app_id = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The appId.
   */
  long getAppId();

  /**
   *
   *
   * <pre>
   * Output only. Time when the installation was associated with the project.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Time when the installation was associated with the project.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Time when the installation was associated with the project.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * The key that should be attached to webhook calls to the ReceiveWebhook
   * endpoint.
   * </pre>
   *
   * <code>string webhook_key = 8;</code>
   *
   * @return The webhookKey.
   */
  java.lang.String getWebhookKey();
  /**
   *
   *
   * <pre>
   * The key that should be attached to webhook calls to the ReceiveWebhook
   * endpoint.
   * </pre>
   *
   * <code>string webhook_key = 8;</code>
   *
   * @return The bytes for webhookKey.
   */
  com.google.protobuf.ByteString getWebhookKeyBytes();

  /**
   *
   *
   * <pre>
   * Optional. The network to be used when reaching out to the GitHub
   * Enterprise server. The VPC network must be enabled for private
   * service connection. This should be set if the GitHub Enterprise server is
   * hosted on-premises and not reachable by public internet.
   * If this field is left empty, no network peering will occur and calls to
   * the GitHub Enterprise server will be made over the public internet.
   * Must be in the format
   * `projects/{project}/global/networks/{network}`, where {project}
   * is a project number or id and {network} is the name of a
   * VPC network in the project.
   * </pre>
   *
   * <code>
   * string peered_network = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The peeredNetwork.
   */
  java.lang.String getPeeredNetwork();
  /**
   *
   *
   * <pre>
   * Optional. The network to be used when reaching out to the GitHub
   * Enterprise server. The VPC network must be enabled for private
   * service connection. This should be set if the GitHub Enterprise server is
   * hosted on-premises and not reachable by public internet.
   * If this field is left empty, no network peering will occur and calls to
   * the GitHub Enterprise server will be made over the public internet.
   * Must be in the format
   * `projects/{project}/global/networks/{network}`, where {project}
   * is a project number or id and {network} is the name of a
   * VPC network in the project.
   * </pre>
   *
   * <code>
   * string peered_network = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for peeredNetwork.
   */
  com.google.protobuf.ByteString getPeeredNetworkBytes();

  /**
   *
   *
   * <pre>
   * Names of secrets in Secret Manager.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.GitHubEnterpriseSecrets secrets = 10;</code>
   *
   * @return Whether the secrets field is set.
   */
  boolean hasSecrets();
  /**
   *
   *
   * <pre>
   * Names of secrets in Secret Manager.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.GitHubEnterpriseSecrets secrets = 10;</code>
   *
   * @return The secrets.
   */
  com.google.cloudbuild.v1.GitHubEnterpriseSecrets getSecrets();
  /**
   *
   *
   * <pre>
   * Names of secrets in Secret Manager.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.GitHubEnterpriseSecrets secrets = 10;</code>
   */
  com.google.cloudbuild.v1.GitHubEnterpriseSecretsOrBuilder getSecretsOrBuilder();

  /**
   *
   *
   * <pre>
   * Name to display for this config.
   * </pre>
   *
   * <code>string display_name = 11;</code>
   *
   * @return The displayName.
   */
  java.lang.String getDisplayName();
  /**
   *
   *
   * <pre>
   * Name to display for this config.
   * </pre>
   *
   * <code>string display_name = 11;</code>
   *
   * @return The bytes for displayName.
   */
  com.google.protobuf.ByteString getDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * Optional. SSL certificate to use for requests to GitHub Enterprise.
   * </pre>
   *
   * <code>string ssl_ca = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The sslCa.
   */
  java.lang.String getSslCa();
  /**
   *
   *
   * <pre>
   * Optional. SSL certificate to use for requests to GitHub Enterprise.
   * </pre>
   *
   * <code>string ssl_ca = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for sslCa.
   */
  com.google.protobuf.ByteString getSslCaBytes();
}
