/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

// Protobuf Java Version: 3.25.2
package com.google.cloudbuild.v1;

/**
 *
 *
 * <pre>
 * GitHubEventsConfig describes the configuration of a trigger that creates a
 * build whenever a GitHub event is received.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v1.GitHubEventsConfig}
 */
public final class GitHubEventsConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.GitHubEventsConfig)
    GitHubEventsConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GitHubEventsConfig.newBuilder() to construct.
  private GitHubEventsConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GitHubEventsConfig() {
    owner_ = "";
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GitHubEventsConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_GitHubEventsConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_GitHubEventsConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.GitHubEventsConfig.class,
            com.google.cloudbuild.v1.GitHubEventsConfig.Builder.class);
  }

  private int eventCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object event_;

  public enum EventCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PULL_REQUEST(4),
    PUSH(5),
    EVENT_NOT_SET(0);
    private final int value;

    private EventCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EventCase valueOf(int value) {
      return forNumber(value);
    }

    public static EventCase forNumber(int value) {
      switch (value) {
        case 4:
          return PULL_REQUEST;
        case 5:
          return PUSH;
        case 0:
          return EVENT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public EventCase getEventCase() {
    return EventCase.forNumber(eventCase_);
  }

  public static final int INSTALLATION_ID_FIELD_NUMBER = 1;
  private long installationId_ = 0L;
  /**
   *
   *
   * <pre>
   * The installationID that emits the GitHub event.
   * </pre>
   *
   * <code>int64 installation_id = 1 [deprecated = true];</code>
   *
   * @deprecated google.devtools.cloudbuild.v1.GitHubEventsConfig.installation_id is deprecated. See
   *     google/devtools/cloudbuild/v1/cloudbuild.proto;l=1876
   * @return The installationId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public long getInstallationId() {
    return installationId_;
  }

  public static final int OWNER_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object owner_ = "";
  /**
   *
   *
   * <pre>
   * Owner of the repository. For example: The owner for
   * https://github.com/googlecloudplatform/cloud-builders is
   * "googlecloudplatform".
   * </pre>
   *
   * <code>string owner = 6;</code>
   *
   * @return The owner.
   */
  @java.lang.Override
  public java.lang.String getOwner() {
    java.lang.Object ref = owner_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      owner_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Owner of the repository. For example: The owner for
   * https://github.com/googlecloudplatform/cloud-builders is
   * "googlecloudplatform".
   * </pre>
   *
   * <code>string owner = 6;</code>
   *
   * @return The bytes for owner.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOwnerBytes() {
    java.lang.Object ref = owner_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      owner_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of the repository. For example: The name for
   * https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
   * </pre>
   *
   * <code>string name = 7;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the repository. For example: The name for
   * https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
   * </pre>
   *
   * <code>string name = 7;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PULL_REQUEST_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * filter to match changes in pull requests.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 4;</code>
   *
   * @return Whether the pullRequest field is set.
   */
  @java.lang.Override
  public boolean hasPullRequest() {
    return eventCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * filter to match changes in pull requests.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 4;</code>
   *
   * @return The pullRequest.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.PullRequestFilter getPullRequest() {
    if (eventCase_ == 4) {
      return (com.google.cloudbuild.v1.PullRequestFilter) event_;
    }
    return com.google.cloudbuild.v1.PullRequestFilter.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * filter to match changes in pull requests.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 4;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.PullRequestFilterOrBuilder getPullRequestOrBuilder() {
    if (eventCase_ == 4) {
      return (com.google.cloudbuild.v1.PullRequestFilter) event_;
    }
    return com.google.cloudbuild.v1.PullRequestFilter.getDefaultInstance();
  }

  public static final int PUSH_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * filter to match changes in refs like branches, tags.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.PushFilter push = 5;</code>
   *
   * @return Whether the push field is set.
   */
  @java.lang.Override
  public boolean hasPush() {
    return eventCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * filter to match changes in refs like branches, tags.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.PushFilter push = 5;</code>
   *
   * @return The push.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.PushFilter getPush() {
    if (eventCase_ == 5) {
      return (com.google.cloudbuild.v1.PushFilter) event_;
    }
    return com.google.cloudbuild.v1.PushFilter.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * filter to match changes in refs like branches, tags.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.PushFilter push = 5;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.PushFilterOrBuilder getPushOrBuilder() {
    if (eventCase_ == 5) {
      return (com.google.cloudbuild.v1.PushFilter) event_;
    }
    return com.google.cloudbuild.v1.PushFilter.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (installationId_ != 0L) {
      output.writeInt64(1, installationId_);
    }
    if (eventCase_ == 4) {
      output.writeMessage(4, (com.google.cloudbuild.v1.PullRequestFilter) event_);
    }
    if (eventCase_ == 5) {
      output.writeMessage(5, (com.google.cloudbuild.v1.PushFilter) event_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(owner_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, owner_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, name_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (installationId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, installationId_);
    }
    if (eventCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloudbuild.v1.PullRequestFilter) event_);
    }
    if (eventCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloudbuild.v1.PushFilter) event_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(owner_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, owner_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, name_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.GitHubEventsConfig)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.GitHubEventsConfig other =
        (com.google.cloudbuild.v1.GitHubEventsConfig) obj;

    if (getInstallationId() != other.getInstallationId()) return false;
    if (!getOwner().equals(other.getOwner())) return false;
    if (!getName().equals(other.getName())) return false;
    if (!getEventCase().equals(other.getEventCase())) return false;
    switch (eventCase_) {
      case 4:
        if (!getPullRequest().equals(other.getPullRequest())) return false;
        break;
      case 5:
        if (!getPush().equals(other.getPush())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INSTALLATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getInstallationId());
    hash = (37 * hash) + OWNER_FIELD_NUMBER;
    hash = (53 * hash) + getOwner().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    switch (eventCase_) {
      case 4:
        hash = (37 * hash) + PULL_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getPullRequest().hashCode();
        break;
      case 5:
        hash = (37 * hash) + PUSH_FIELD_NUMBER;
        hash = (53 * hash) + getPush().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.GitHubEventsConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.GitHubEventsConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.GitHubEventsConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.GitHubEventsConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.GitHubEventsConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.GitHubEventsConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.GitHubEventsConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.GitHubEventsConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.GitHubEventsConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.GitHubEventsConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.GitHubEventsConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.GitHubEventsConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.GitHubEventsConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * GitHubEventsConfig describes the configuration of a trigger that creates a
   * build whenever a GitHub event is received.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.GitHubEventsConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.GitHubEventsConfig)
      com.google.cloudbuild.v1.GitHubEventsConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_GitHubEventsConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_GitHubEventsConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.GitHubEventsConfig.class,
              com.google.cloudbuild.v1.GitHubEventsConfig.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.GitHubEventsConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      installationId_ = 0L;
      owner_ = "";
      name_ = "";
      if (pullRequestBuilder_ != null) {
        pullRequestBuilder_.clear();
      }
      if (pushBuilder_ != null) {
        pushBuilder_.clear();
      }
      eventCase_ = 0;
      event_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_GitHubEventsConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.GitHubEventsConfig getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.GitHubEventsConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.GitHubEventsConfig build() {
      com.google.cloudbuild.v1.GitHubEventsConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.GitHubEventsConfig buildPartial() {
      com.google.cloudbuild.v1.GitHubEventsConfig result =
          new com.google.cloudbuild.v1.GitHubEventsConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloudbuild.v1.GitHubEventsConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.installationId_ = installationId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.owner_ = owner_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.name_ = name_;
      }
    }

    private void buildPartialOneofs(com.google.cloudbuild.v1.GitHubEventsConfig result) {
      result.eventCase_ = eventCase_;
      result.event_ = this.event_;
      if (eventCase_ == 4 && pullRequestBuilder_ != null) {
        result.event_ = pullRequestBuilder_.build();
      }
      if (eventCase_ == 5 && pushBuilder_ != null) {
        result.event_ = pushBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.GitHubEventsConfig) {
        return mergeFrom((com.google.cloudbuild.v1.GitHubEventsConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.GitHubEventsConfig other) {
      if (other == com.google.cloudbuild.v1.GitHubEventsConfig.getDefaultInstance()) return this;
      if (other.getInstallationId() != 0L) {
        setInstallationId(other.getInstallationId());
      }
      if (!other.getOwner().isEmpty()) {
        owner_ = other.owner_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      switch (other.getEventCase()) {
        case PULL_REQUEST:
          {
            mergePullRequest(other.getPullRequest());
            break;
          }
        case PUSH:
          {
            mergePush(other.getPush());
            break;
          }
        case EVENT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                installationId_ = input.readInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 34:
              {
                input.readMessage(getPullRequestFieldBuilder().getBuilder(), extensionRegistry);
                eventCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getPushFieldBuilder().getBuilder(), extensionRegistry);
                eventCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                owner_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 50
            case 58:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int eventCase_ = 0;
    private java.lang.Object event_;

    public EventCase getEventCase() {
      return EventCase.forNumber(eventCase_);
    }

    public Builder clearEvent() {
      eventCase_ = 0;
      event_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private long installationId_;
    /**
     *
     *
     * <pre>
     * The installationID that emits the GitHub event.
     * </pre>
     *
     * <code>int64 installation_id = 1 [deprecated = true];</code>
     *
     * @deprecated google.devtools.cloudbuild.v1.GitHubEventsConfig.installation_id is deprecated.
     *     See google/devtools/cloudbuild/v1/cloudbuild.proto;l=1876
     * @return The installationId.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public long getInstallationId() {
      return installationId_;
    }
    /**
     *
     *
     * <pre>
     * The installationID that emits the GitHub event.
     * </pre>
     *
     * <code>int64 installation_id = 1 [deprecated = true];</code>
     *
     * @deprecated google.devtools.cloudbuild.v1.GitHubEventsConfig.installation_id is deprecated.
     *     See google/devtools/cloudbuild/v1/cloudbuild.proto;l=1876
     * @param value The installationId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setInstallationId(long value) {

      installationId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The installationID that emits the GitHub event.
     * </pre>
     *
     * <code>int64 installation_id = 1 [deprecated = true];</code>
     *
     * @deprecated google.devtools.cloudbuild.v1.GitHubEventsConfig.installation_id is deprecated.
     *     See google/devtools/cloudbuild/v1/cloudbuild.proto;l=1876
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearInstallationId() {
      bitField0_ = (bitField0_ & ~0x00000001);
      installationId_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object owner_ = "";
    /**
     *
     *
     * <pre>
     * Owner of the repository. For example: The owner for
     * https://github.com/googlecloudplatform/cloud-builders is
     * "googlecloudplatform".
     * </pre>
     *
     * <code>string owner = 6;</code>
     *
     * @return The owner.
     */
    public java.lang.String getOwner() {
      java.lang.Object ref = owner_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        owner_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Owner of the repository. For example: The owner for
     * https://github.com/googlecloudplatform/cloud-builders is
     * "googlecloudplatform".
     * </pre>
     *
     * <code>string owner = 6;</code>
     *
     * @return The bytes for owner.
     */
    public com.google.protobuf.ByteString getOwnerBytes() {
      java.lang.Object ref = owner_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        owner_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Owner of the repository. For example: The owner for
     * https://github.com/googlecloudplatform/cloud-builders is
     * "googlecloudplatform".
     * </pre>
     *
     * <code>string owner = 6;</code>
     *
     * @param value The owner to set.
     * @return This builder for chaining.
     */
    public Builder setOwner(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      owner_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Owner of the repository. For example: The owner for
     * https://github.com/googlecloudplatform/cloud-builders is
     * "googlecloudplatform".
     * </pre>
     *
     * <code>string owner = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOwner() {
      owner_ = getDefaultInstance().getOwner();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Owner of the repository. For example: The owner for
     * https://github.com/googlecloudplatform/cloud-builders is
     * "googlecloudplatform".
     * </pre>
     *
     * <code>string owner = 6;</code>
     *
     * @param value The bytes for owner to set.
     * @return This builder for chaining.
     */
    public Builder setOwnerBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      owner_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the repository. For example: The name for
     * https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
     * </pre>
     *
     * <code>string name = 7;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the repository. For example: The name for
     * https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
     * </pre>
     *
     * <code>string name = 7;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the repository. For example: The name for
     * https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
     * </pre>
     *
     * <code>string name = 7;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the repository. For example: The name for
     * https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
     * </pre>
     *
     * <code>string name = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the repository. For example: The name for
     * https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
     * </pre>
     *
     * <code>string name = 7;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.PullRequestFilter,
            com.google.cloudbuild.v1.PullRequestFilter.Builder,
            com.google.cloudbuild.v1.PullRequestFilterOrBuilder>
        pullRequestBuilder_;
    /**
     *
     *
     * <pre>
     * filter to match changes in pull requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 4;</code>
     *
     * @return Whether the pullRequest field is set.
     */
    @java.lang.Override
    public boolean hasPullRequest() {
      return eventCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * filter to match changes in pull requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 4;</code>
     *
     * @return The pullRequest.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.PullRequestFilter getPullRequest() {
      if (pullRequestBuilder_ == null) {
        if (eventCase_ == 4) {
          return (com.google.cloudbuild.v1.PullRequestFilter) event_;
        }
        return com.google.cloudbuild.v1.PullRequestFilter.getDefaultInstance();
      } else {
        if (eventCase_ == 4) {
          return pullRequestBuilder_.getMessage();
        }
        return com.google.cloudbuild.v1.PullRequestFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * filter to match changes in pull requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 4;</code>
     */
    public Builder setPullRequest(com.google.cloudbuild.v1.PullRequestFilter value) {
      if (pullRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        event_ = value;
        onChanged();
      } else {
        pullRequestBuilder_.setMessage(value);
      }
      eventCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * filter to match changes in pull requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 4;</code>
     */
    public Builder setPullRequest(
        com.google.cloudbuild.v1.PullRequestFilter.Builder builderForValue) {
      if (pullRequestBuilder_ == null) {
        event_ = builderForValue.build();
        onChanged();
      } else {
        pullRequestBuilder_.setMessage(builderForValue.build());
      }
      eventCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * filter to match changes in pull requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 4;</code>
     */
    public Builder mergePullRequest(com.google.cloudbuild.v1.PullRequestFilter value) {
      if (pullRequestBuilder_ == null) {
        if (eventCase_ == 4
            && event_ != com.google.cloudbuild.v1.PullRequestFilter.getDefaultInstance()) {
          event_ =
              com.google.cloudbuild.v1.PullRequestFilter.newBuilder(
                      (com.google.cloudbuild.v1.PullRequestFilter) event_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          event_ = value;
        }
        onChanged();
      } else {
        if (eventCase_ == 4) {
          pullRequestBuilder_.mergeFrom(value);
        } else {
          pullRequestBuilder_.setMessage(value);
        }
      }
      eventCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * filter to match changes in pull requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 4;</code>
     */
    public Builder clearPullRequest() {
      if (pullRequestBuilder_ == null) {
        if (eventCase_ == 4) {
          eventCase_ = 0;
          event_ = null;
          onChanged();
        }
      } else {
        if (eventCase_ == 4) {
          eventCase_ = 0;
          event_ = null;
        }
        pullRequestBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * filter to match changes in pull requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 4;</code>
     */
    public com.google.cloudbuild.v1.PullRequestFilter.Builder getPullRequestBuilder() {
      return getPullRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * filter to match changes in pull requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 4;</code>
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.PullRequestFilterOrBuilder getPullRequestOrBuilder() {
      if ((eventCase_ == 4) && (pullRequestBuilder_ != null)) {
        return pullRequestBuilder_.getMessageOrBuilder();
      } else {
        if (eventCase_ == 4) {
          return (com.google.cloudbuild.v1.PullRequestFilter) event_;
        }
        return com.google.cloudbuild.v1.PullRequestFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * filter to match changes in pull requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.PullRequestFilter,
            com.google.cloudbuild.v1.PullRequestFilter.Builder,
            com.google.cloudbuild.v1.PullRequestFilterOrBuilder>
        getPullRequestFieldBuilder() {
      if (pullRequestBuilder_ == null) {
        if (!(eventCase_ == 4)) {
          event_ = com.google.cloudbuild.v1.PullRequestFilter.getDefaultInstance();
        }
        pullRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.PullRequestFilter,
                com.google.cloudbuild.v1.PullRequestFilter.Builder,
                com.google.cloudbuild.v1.PullRequestFilterOrBuilder>(
                (com.google.cloudbuild.v1.PullRequestFilter) event_,
                getParentForChildren(),
                isClean());
        event_ = null;
      }
      eventCase_ = 4;
      onChanged();
      return pullRequestBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.PushFilter,
            com.google.cloudbuild.v1.PushFilter.Builder,
            com.google.cloudbuild.v1.PushFilterOrBuilder>
        pushBuilder_;
    /**
     *
     *
     * <pre>
     * filter to match changes in refs like branches, tags.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PushFilter push = 5;</code>
     *
     * @return Whether the push field is set.
     */
    @java.lang.Override
    public boolean hasPush() {
      return eventCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * filter to match changes in refs like branches, tags.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PushFilter push = 5;</code>
     *
     * @return The push.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.PushFilter getPush() {
      if (pushBuilder_ == null) {
        if (eventCase_ == 5) {
          return (com.google.cloudbuild.v1.PushFilter) event_;
        }
        return com.google.cloudbuild.v1.PushFilter.getDefaultInstance();
      } else {
        if (eventCase_ == 5) {
          return pushBuilder_.getMessage();
        }
        return com.google.cloudbuild.v1.PushFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * filter to match changes in refs like branches, tags.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PushFilter push = 5;</code>
     */
    public Builder setPush(com.google.cloudbuild.v1.PushFilter value) {
      if (pushBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        event_ = value;
        onChanged();
      } else {
        pushBuilder_.setMessage(value);
      }
      eventCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * filter to match changes in refs like branches, tags.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PushFilter push = 5;</code>
     */
    public Builder setPush(com.google.cloudbuild.v1.PushFilter.Builder builderForValue) {
      if (pushBuilder_ == null) {
        event_ = builderForValue.build();
        onChanged();
      } else {
        pushBuilder_.setMessage(builderForValue.build());
      }
      eventCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * filter to match changes in refs like branches, tags.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PushFilter push = 5;</code>
     */
    public Builder mergePush(com.google.cloudbuild.v1.PushFilter value) {
      if (pushBuilder_ == null) {
        if (eventCase_ == 5 && event_ != com.google.cloudbuild.v1.PushFilter.getDefaultInstance()) {
          event_ =
              com.google.cloudbuild.v1.PushFilter.newBuilder(
                      (com.google.cloudbuild.v1.PushFilter) event_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          event_ = value;
        }
        onChanged();
      } else {
        if (eventCase_ == 5) {
          pushBuilder_.mergeFrom(value);
        } else {
          pushBuilder_.setMessage(value);
        }
      }
      eventCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * filter to match changes in refs like branches, tags.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PushFilter push = 5;</code>
     */
    public Builder clearPush() {
      if (pushBuilder_ == null) {
        if (eventCase_ == 5) {
          eventCase_ = 0;
          event_ = null;
          onChanged();
        }
      } else {
        if (eventCase_ == 5) {
          eventCase_ = 0;
          event_ = null;
        }
        pushBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * filter to match changes in refs like branches, tags.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PushFilter push = 5;</code>
     */
    public com.google.cloudbuild.v1.PushFilter.Builder getPushBuilder() {
      return getPushFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * filter to match changes in refs like branches, tags.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PushFilter push = 5;</code>
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.PushFilterOrBuilder getPushOrBuilder() {
      if ((eventCase_ == 5) && (pushBuilder_ != null)) {
        return pushBuilder_.getMessageOrBuilder();
      } else {
        if (eventCase_ == 5) {
          return (com.google.cloudbuild.v1.PushFilter) event_;
        }
        return com.google.cloudbuild.v1.PushFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * filter to match changes in refs like branches, tags.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PushFilter push = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.PushFilter,
            com.google.cloudbuild.v1.PushFilter.Builder,
            com.google.cloudbuild.v1.PushFilterOrBuilder>
        getPushFieldBuilder() {
      if (pushBuilder_ == null) {
        if (!(eventCase_ == 5)) {
          event_ = com.google.cloudbuild.v1.PushFilter.getDefaultInstance();
        }
        pushBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.PushFilter,
                com.google.cloudbuild.v1.PushFilter.Builder,
                com.google.cloudbuild.v1.PushFilterOrBuilder>(
                (com.google.cloudbuild.v1.PushFilter) event_, getParentForChildren(), isClean());
        event_ = null;
      }
      eventCase_ = 5;
      onChanged();
      return pushBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.GitHubEventsConfig)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.GitHubEventsConfig)
  private static final com.google.cloudbuild.v1.GitHubEventsConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.GitHubEventsConfig();
  }

  public static com.google.cloudbuild.v1.GitHubEventsConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GitHubEventsConfig> PARSER =
      new com.google.protobuf.AbstractParser<GitHubEventsConfig>() {
        @java.lang.Override
        public GitHubEventsConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GitHubEventsConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GitHubEventsConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.GitHubEventsConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
