/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

// Protobuf Java Version: 3.25.2
package com.google.cloudbuild.v1;

public interface GitSourceOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.devtools.cloudbuild.v1.GitSource)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Location of the Git repo to build.
   *
   * This will be used as a `git remote`, see
   * https://git-scm.com/docs/git-remote.
   * </pre>
   *
   * <code>string url = 1;</code>
   *
   * @return The url.
   */
  java.lang.String getUrl();
  /**
   *
   *
   * <pre>
   * Location of the Git repo to build.
   *
   * This will be used as a `git remote`, see
   * https://git-scm.com/docs/git-remote.
   * </pre>
   *
   * <code>string url = 1;</code>
   *
   * @return The bytes for url.
   */
  com.google.protobuf.ByteString getUrlBytes();

  /**
   *
   *
   * <pre>
   * Directory, relative to the source root, in which to run the build.
   *
   * This must be a relative path. If a step's `dir` is specified and is an
   * absolute path, this value is ignored for that step's execution.
   * </pre>
   *
   * <code>string dir = 5;</code>
   *
   * @return The dir.
   */
  java.lang.String getDir();
  /**
   *
   *
   * <pre>
   * Directory, relative to the source root, in which to run the build.
   *
   * This must be a relative path. If a step's `dir` is specified and is an
   * absolute path, this value is ignored for that step's execution.
   * </pre>
   *
   * <code>string dir = 5;</code>
   *
   * @return The bytes for dir.
   */
  com.google.protobuf.ByteString getDirBytes();

  /**
   *
   *
   * <pre>
   * The revision to fetch from the Git repository such as a branch, a tag, a
   * commit SHA, or any Git ref.
   *
   * Cloud Build uses `git fetch` to fetch the revision from the Git
   * repository; therefore make sure that the string you provide for `revision`
   * is parsable  by the command. For information on string values accepted by
   * `git fetch`, see
   * https://git-scm.com/docs/gitrevisions#_specifying_revisions. For
   * information on `git fetch`, see https://git-scm.com/docs/git-fetch.
   * </pre>
   *
   * <code>string revision = 6;</code>
   *
   * @return The revision.
   */
  java.lang.String getRevision();
  /**
   *
   *
   * <pre>
   * The revision to fetch from the Git repository such as a branch, a tag, a
   * commit SHA, or any Git ref.
   *
   * Cloud Build uses `git fetch` to fetch the revision from the Git
   * repository; therefore make sure that the string you provide for `revision`
   * is parsable  by the command. For information on string values accepted by
   * `git fetch`, see
   * https://git-scm.com/docs/gitrevisions#_specifying_revisions. For
   * information on `git fetch`, see https://git-scm.com/docs/git-fetch.
   * </pre>
   *
   * <code>string revision = 6;</code>
   *
   * @return The bytes for revision.
   */
  com.google.protobuf.ByteString getRevisionBytes();
}
