/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloudbuild.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BuildTriggerName
implements ResourceName {
    private static final PathTemplate PROJECT_TRIGGER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/triggers/{trigger}");
    private static final PathTemplate PROJECT_LOCATION_TRIGGER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/triggers/{trigger}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String trigger;
    private final String location;

    @Deprecated
    protected BuildTriggerName() {
        this.project = null;
        this.trigger = null;
        this.location = null;
    }

    private BuildTriggerName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.trigger = (String)Preconditions.checkNotNull((Object)builder.getTrigger());
        this.location = null;
        this.pathTemplate = PROJECT_TRIGGER;
    }

    private BuildTriggerName(ProjectLocationTriggerBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.trigger = (String)Preconditions.checkNotNull((Object)builder.getTrigger());
        this.pathTemplate = PROJECT_LOCATION_TRIGGER;
    }

    public String getProject() {
        return this.project;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectTriggerBuilder() {
        return new Builder();
    }

    public static ProjectLocationTriggerBuilder newProjectLocationTriggerBuilder() {
        return new ProjectLocationTriggerBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BuildTriggerName of(String project, String trigger) {
        return BuildTriggerName.newBuilder().setProject(project).setTrigger(trigger).build();
    }

    public static BuildTriggerName ofProjectTriggerName(String project, String trigger) {
        return BuildTriggerName.newBuilder().setProject(project).setTrigger(trigger).build();
    }

    public static BuildTriggerName ofProjectLocationTriggerName(String project, String location, String trigger) {
        return BuildTriggerName.newProjectLocationTriggerBuilder().setProject(project).setLocation(location).setTrigger(trigger).build();
    }

    public static String format(String project, String trigger) {
        return BuildTriggerName.newBuilder().setProject(project).setTrigger(trigger).build().toString();
    }

    public static String formatProjectTriggerName(String project, String trigger) {
        return BuildTriggerName.newBuilder().setProject(project).setTrigger(trigger).build().toString();
    }

    public static String formatProjectLocationTriggerName(String project, String location, String trigger) {
        return BuildTriggerName.newProjectLocationTriggerBuilder().setProject(project).setLocation(location).setTrigger(trigger).build().toString();
    }

    public static BuildTriggerName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_TRIGGER.matches(formattedString)) {
            Map matchMap = PROJECT_TRIGGER.match(formattedString);
            return BuildTriggerName.ofProjectTriggerName((String)matchMap.get("project"), (String)matchMap.get("trigger"));
        }
        if (PROJECT_LOCATION_TRIGGER.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_TRIGGER.match(formattedString);
            return BuildTriggerName.ofProjectLocationTriggerName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("trigger"));
        }
        throw new ValidationException("BuildTriggerName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<BuildTriggerName> parseList(List<String> formattedStrings) {
        ArrayList<BuildTriggerName> list = new ArrayList<BuildTriggerName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BuildTriggerName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BuildTriggerName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BuildTriggerName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_TRIGGER.matches(formattedString) || PROJECT_LOCATION_TRIGGER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BuildTriggerName buildTriggerName = this;
            synchronized (buildTriggerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.trigger != null) {
                        fieldMapBuilder.put((Object)"trigger", (Object)this.trigger);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BuildTriggerName that = (BuildTriggerName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.trigger, that.trigger) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.trigger);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class ProjectLocationTriggerBuilder {
        private String project;
        private String location;
        private String trigger;

        protected ProjectLocationTriggerBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTrigger() {
            return this.trigger;
        }

        public ProjectLocationTriggerBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationTriggerBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationTriggerBuilder setTrigger(String trigger) {
            this.trigger = trigger;
            return this;
        }

        public BuildTriggerName build() {
            return new BuildTriggerName(this);
        }
    }

    public static class Builder {
        private String project;
        private String trigger;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getTrigger() {
            return this.trigger;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTrigger(String trigger) {
            this.trigger = trigger;
            return this;
        }

        private Builder(BuildTriggerName buildTriggerName) {
            Preconditions.checkArgument((boolean)Objects.equals(buildTriggerName.pathTemplate, PROJECT_TRIGGER), (Object)"toBuilder is only supported when BuildTriggerName has the pattern of projects/{project}/triggers/{trigger}");
            this.project = buildTriggerName.project;
            this.trigger = buildTriggerName.trigger;
        }

        public BuildTriggerName build() {
            return new BuildTriggerName(this);
        }
    }
}

