/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

// Protobuf Java Version: 3.25.5
package com.google.cloudbuild.v1;

/**
 *
 *
 * <pre>
 * ApprovalResult describes the decision and associated metadata of a manual
 * approval of a build.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v1.ApprovalResult}
 */
public final class ApprovalResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.ApprovalResult)
    ApprovalResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ApprovalResult.newBuilder() to construct.
  private ApprovalResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ApprovalResult() {
    approverAccount_ = "";
    decision_ = 0;
    comment_ = "";
    url_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ApprovalResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_ApprovalResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_ApprovalResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.ApprovalResult.class,
            com.google.cloudbuild.v1.ApprovalResult.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies whether or not this manual approval result is to approve
   * or reject a build.
   * </pre>
   *
   * Protobuf enum {@code google.devtools.cloudbuild.v1.ApprovalResult.Decision}
   */
  public enum Decision implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default enum type. This should not be used.
     * </pre>
     *
     * <code>DECISION_UNSPECIFIED = 0;</code>
     */
    DECISION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Build is approved.
     * </pre>
     *
     * <code>APPROVED = 1;</code>
     */
    APPROVED(1),
    /**
     *
     *
     * <pre>
     * Build is rejected.
     * </pre>
     *
     * <code>REJECTED = 2;</code>
     */
    REJECTED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default enum type. This should not be used.
     * </pre>
     *
     * <code>DECISION_UNSPECIFIED = 0;</code>
     */
    public static final int DECISION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Build is approved.
     * </pre>
     *
     * <code>APPROVED = 1;</code>
     */
    public static final int APPROVED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Build is rejected.
     * </pre>
     *
     * <code>REJECTED = 2;</code>
     */
    public static final int REJECTED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Decision valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Decision forNumber(int value) {
      switch (value) {
        case 0:
          return DECISION_UNSPECIFIED;
        case 1:
          return APPROVED;
        case 2:
          return REJECTED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Decision> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Decision> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Decision>() {
          public Decision findValueByNumber(int number) {
            return Decision.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloudbuild.v1.ApprovalResult.getDescriptor().getEnumTypes().get(0);
    }

    private static final Decision[] VALUES = values();

    public static Decision valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Decision(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.devtools.cloudbuild.v1.ApprovalResult.Decision)
  }

  private int bitField0_;
  public static final int APPROVER_ACCOUNT_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object approverAccount_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Email of the user that called the ApproveBuild API to
   * approve or reject a build at the time that the API was called.
   * </pre>
   *
   * <code>string approver_account = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The approverAccount.
   */
  @java.lang.Override
  public java.lang.String getApproverAccount() {
    java.lang.Object ref = approverAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      approverAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Email of the user that called the ApproveBuild API to
   * approve or reject a build at the time that the API was called.
   * </pre>
   *
   * <code>string approver_account = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for approverAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getApproverAccountBytes() {
    java.lang.Object ref = approverAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      approverAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APPROVAL_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp approvalTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the approval decision was made.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp approval_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the approvalTime field is set.
   */
  @java.lang.Override
  public boolean hasApprovalTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the approval decision was made.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp approval_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The approvalTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getApprovalTime() {
    return approvalTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : approvalTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the approval decision was made.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp approval_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getApprovalTimeOrBuilder() {
    return approvalTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : approvalTime_;
  }

  public static final int DECISION_FIELD_NUMBER = 4;
  private int decision_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The decision of this manual approval.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.ApprovalResult.Decision decision = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for decision.
   */
  @java.lang.Override
  public int getDecisionValue() {
    return decision_;
  }
  /**
   *
   *
   * <pre>
   * Required. The decision of this manual approval.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.ApprovalResult.Decision decision = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The decision.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.ApprovalResult.Decision getDecision() {
    com.google.cloudbuild.v1.ApprovalResult.Decision result =
        com.google.cloudbuild.v1.ApprovalResult.Decision.forNumber(decision_);
    return result == null ? com.google.cloudbuild.v1.ApprovalResult.Decision.UNRECOGNIZED : result;
  }

  public static final int COMMENT_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object comment_ = "";
  /**
   *
   *
   * <pre>
   * Optional. An optional comment for this manual approval result.
   * </pre>
   *
   * <code>string comment = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The comment.
   */
  @java.lang.Override
  public java.lang.String getComment() {
    java.lang.Object ref = comment_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      comment_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. An optional comment for this manual approval result.
   * </pre>
   *
   * <code>string comment = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for comment.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCommentBytes() {
    java.lang.Object ref = comment_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      comment_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int URL_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object url_ = "";
  /**
   *
   *
   * <pre>
   * Optional. An optional URL tied to this manual approval result. This field
   * is essentially the same as comment, except that it will be rendered by the
   * UI differently. An example use case is a link to an external job that
   * approved this Build.
   * </pre>
   *
   * <code>string url = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The url.
   */
  @java.lang.Override
  public java.lang.String getUrl() {
    java.lang.Object ref = url_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      url_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. An optional URL tied to this manual approval result. This field
   * is essentially the same as comment, except that it will be rendered by the
   * UI differently. An example use case is a link to an external job that
   * approved this Build.
   * </pre>
   *
   * <code>string url = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for url.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUrlBytes() {
    java.lang.Object ref = url_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      url_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(approverAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, approverAccount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getApprovalTime());
    }
    if (decision_
        != com.google.cloudbuild.v1.ApprovalResult.Decision.DECISION_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, decision_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(comment_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, comment_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, url_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(approverAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, approverAccount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getApprovalTime());
    }
    if (decision_
        != com.google.cloudbuild.v1.ApprovalResult.Decision.DECISION_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, decision_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(comment_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, comment_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, url_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.ApprovalResult)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.ApprovalResult other = (com.google.cloudbuild.v1.ApprovalResult) obj;

    if (!getApproverAccount().equals(other.getApproverAccount())) return false;
    if (hasApprovalTime() != other.hasApprovalTime()) return false;
    if (hasApprovalTime()) {
      if (!getApprovalTime().equals(other.getApprovalTime())) return false;
    }
    if (decision_ != other.decision_) return false;
    if (!getComment().equals(other.getComment())) return false;
    if (!getUrl().equals(other.getUrl())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + APPROVER_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getApproverAccount().hashCode();
    if (hasApprovalTime()) {
      hash = (37 * hash) + APPROVAL_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getApprovalTime().hashCode();
    }
    hash = (37 * hash) + DECISION_FIELD_NUMBER;
    hash = (53 * hash) + decision_;
    hash = (37 * hash) + COMMENT_FIELD_NUMBER;
    hash = (53 * hash) + getComment().hashCode();
    hash = (37 * hash) + URL_FIELD_NUMBER;
    hash = (53 * hash) + getUrl().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.ApprovalResult parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.ApprovalResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.ApprovalResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.ApprovalResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.ApprovalResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.ApprovalResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.ApprovalResult parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.ApprovalResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.ApprovalResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.ApprovalResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.ApprovalResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.ApprovalResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.ApprovalResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * ApprovalResult describes the decision and associated metadata of a manual
   * approval of a build.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.ApprovalResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.ApprovalResult)
      com.google.cloudbuild.v1.ApprovalResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_ApprovalResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_ApprovalResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.ApprovalResult.class,
              com.google.cloudbuild.v1.ApprovalResult.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.ApprovalResult.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getApprovalTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      approverAccount_ = "";
      approvalTime_ = null;
      if (approvalTimeBuilder_ != null) {
        approvalTimeBuilder_.dispose();
        approvalTimeBuilder_ = null;
      }
      decision_ = 0;
      comment_ = "";
      url_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_ApprovalResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.ApprovalResult getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.ApprovalResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.ApprovalResult build() {
      com.google.cloudbuild.v1.ApprovalResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.ApprovalResult buildPartial() {
      com.google.cloudbuild.v1.ApprovalResult result =
          new com.google.cloudbuild.v1.ApprovalResult(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloudbuild.v1.ApprovalResult result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.approverAccount_ = approverAccount_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.approvalTime_ =
            approvalTimeBuilder_ == null ? approvalTime_ : approvalTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.decision_ = decision_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.comment_ = comment_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.url_ = url_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.ApprovalResult) {
        return mergeFrom((com.google.cloudbuild.v1.ApprovalResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.ApprovalResult other) {
      if (other == com.google.cloudbuild.v1.ApprovalResult.getDefaultInstance()) return this;
      if (!other.getApproverAccount().isEmpty()) {
        approverAccount_ = other.approverAccount_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasApprovalTime()) {
        mergeApprovalTime(other.getApprovalTime());
      }
      if (other.decision_ != 0) {
        setDecisionValue(other.getDecisionValue());
      }
      if (!other.getComment().isEmpty()) {
        comment_ = other.comment_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getUrl().isEmpty()) {
        url_ = other.url_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                approverAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getApprovalTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 32:
              {
                decision_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            case 42:
              {
                comment_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                url_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object approverAccount_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Email of the user that called the ApproveBuild API to
     * approve or reject a build at the time that the API was called.
     * </pre>
     *
     * <code>string approver_account = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The approverAccount.
     */
    public java.lang.String getApproverAccount() {
      java.lang.Object ref = approverAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        approverAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Email of the user that called the ApproveBuild API to
     * approve or reject a build at the time that the API was called.
     * </pre>
     *
     * <code>string approver_account = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for approverAccount.
     */
    public com.google.protobuf.ByteString getApproverAccountBytes() {
      java.lang.Object ref = approverAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        approverAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Email of the user that called the ApproveBuild API to
     * approve or reject a build at the time that the API was called.
     * </pre>
     *
     * <code>string approver_account = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The approverAccount to set.
     * @return This builder for chaining.
     */
    public Builder setApproverAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      approverAccount_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Email of the user that called the ApproveBuild API to
     * approve or reject a build at the time that the API was called.
     * </pre>
     *
     * <code>string approver_account = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearApproverAccount() {
      approverAccount_ = getDefaultInstance().getApproverAccount();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Email of the user that called the ApproveBuild API to
     * approve or reject a build at the time that the API was called.
     * </pre>
     *
     * <code>string approver_account = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for approverAccount to set.
     * @return This builder for chaining.
     */
    public Builder setApproverAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      approverAccount_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp approvalTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        approvalTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the approval decision was made.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp approval_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the approvalTime field is set.
     */
    public boolean hasApprovalTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the approval decision was made.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp approval_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The approvalTime.
     */
    public com.google.protobuf.Timestamp getApprovalTime() {
      if (approvalTimeBuilder_ == null) {
        return approvalTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : approvalTime_;
      } else {
        return approvalTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the approval decision was made.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp approval_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setApprovalTime(com.google.protobuf.Timestamp value) {
      if (approvalTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        approvalTime_ = value;
      } else {
        approvalTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the approval decision was made.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp approval_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setApprovalTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (approvalTimeBuilder_ == null) {
        approvalTime_ = builderForValue.build();
      } else {
        approvalTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the approval decision was made.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp approval_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeApprovalTime(com.google.protobuf.Timestamp value) {
      if (approvalTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && approvalTime_ != null
            && approvalTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getApprovalTimeBuilder().mergeFrom(value);
        } else {
          approvalTime_ = value;
        }
      } else {
        approvalTimeBuilder_.mergeFrom(value);
      }
      if (approvalTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the approval decision was made.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp approval_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearApprovalTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      approvalTime_ = null;
      if (approvalTimeBuilder_ != null) {
        approvalTimeBuilder_.dispose();
        approvalTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the approval decision was made.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp approval_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getApprovalTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getApprovalTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the approval decision was made.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp approval_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getApprovalTimeOrBuilder() {
      if (approvalTimeBuilder_ != null) {
        return approvalTimeBuilder_.getMessageOrBuilder();
      } else {
        return approvalTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : approvalTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the approval decision was made.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp approval_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getApprovalTimeFieldBuilder() {
      if (approvalTimeBuilder_ == null) {
        approvalTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getApprovalTime(), getParentForChildren(), isClean());
        approvalTime_ = null;
      }
      return approvalTimeBuilder_;
    }

    private int decision_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The decision of this manual approval.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.ApprovalResult.Decision decision = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for decision.
     */
    @java.lang.Override
    public int getDecisionValue() {
      return decision_;
    }
    /**
     *
     *
     * <pre>
     * Required. The decision of this manual approval.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.ApprovalResult.Decision decision = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for decision to set.
     * @return This builder for chaining.
     */
    public Builder setDecisionValue(int value) {
      decision_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The decision of this manual approval.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.ApprovalResult.Decision decision = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The decision.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.ApprovalResult.Decision getDecision() {
      com.google.cloudbuild.v1.ApprovalResult.Decision result =
          com.google.cloudbuild.v1.ApprovalResult.Decision.forNumber(decision_);
      return result == null
          ? com.google.cloudbuild.v1.ApprovalResult.Decision.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The decision of this manual approval.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.ApprovalResult.Decision decision = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The decision to set.
     * @return This builder for chaining.
     */
    public Builder setDecision(com.google.cloudbuild.v1.ApprovalResult.Decision value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      decision_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The decision of this manual approval.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.ApprovalResult.Decision decision = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDecision() {
      bitField0_ = (bitField0_ & ~0x00000004);
      decision_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object comment_ = "";
    /**
     *
     *
     * <pre>
     * Optional. An optional comment for this manual approval result.
     * </pre>
     *
     * <code>string comment = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The comment.
     */
    public java.lang.String getComment() {
      java.lang.Object ref = comment_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        comment_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional comment for this manual approval result.
     * </pre>
     *
     * <code>string comment = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for comment.
     */
    public com.google.protobuf.ByteString getCommentBytes() {
      java.lang.Object ref = comment_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        comment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional comment for this manual approval result.
     * </pre>
     *
     * <code>string comment = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The comment to set.
     * @return This builder for chaining.
     */
    public Builder setComment(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      comment_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional comment for this manual approval result.
     * </pre>
     *
     * <code>string comment = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearComment() {
      comment_ = getDefaultInstance().getComment();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional comment for this manual approval result.
     * </pre>
     *
     * <code>string comment = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for comment to set.
     * @return This builder for chaining.
     */
    public Builder setCommentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      comment_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object url_ = "";
    /**
     *
     *
     * <pre>
     * Optional. An optional URL tied to this manual approval result. This field
     * is essentially the same as comment, except that it will be rendered by the
     * UI differently. An example use case is a link to an external job that
     * approved this Build.
     * </pre>
     *
     * <code>string url = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The url.
     */
    public java.lang.String getUrl() {
      java.lang.Object ref = url_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        url_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional URL tied to this manual approval result. This field
     * is essentially the same as comment, except that it will be rendered by the
     * UI differently. An example use case is a link to an external job that
     * approved this Build.
     * </pre>
     *
     * <code>string url = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for url.
     */
    public com.google.protobuf.ByteString getUrlBytes() {
      java.lang.Object ref = url_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        url_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional URL tied to this manual approval result. This field
     * is essentially the same as comment, except that it will be rendered by the
     * UI differently. An example use case is a link to an external job that
     * approved this Build.
     * </pre>
     *
     * <code>string url = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The url to set.
     * @return This builder for chaining.
     */
    public Builder setUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      url_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional URL tied to this manual approval result. This field
     * is essentially the same as comment, except that it will be rendered by the
     * UI differently. An example use case is a link to an external job that
     * approved this Build.
     * </pre>
     *
     * <code>string url = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUrl() {
      url_ = getDefaultInstance().getUrl();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional URL tied to this manual approval result. This field
     * is essentially the same as comment, except that it will be rendered by the
     * UI differently. An example use case is a link to an external job that
     * approved this Build.
     * </pre>
     *
     * <code>string url = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for url to set.
     * @return This builder for chaining.
     */
    public Builder setUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      url_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.ApprovalResult)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.ApprovalResult)
  private static final com.google.cloudbuild.v1.ApprovalResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.ApprovalResult();
  }

  public static com.google.cloudbuild.v1.ApprovalResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ApprovalResult> PARSER =
      new com.google.protobuf.AbstractParser<ApprovalResult>() {
        @java.lang.Override
        public ApprovalResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ApprovalResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ApprovalResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.ApprovalResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
