/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

// Protobuf Java Version: 3.25.5
package com.google.cloudbuild.v1;

/**
 *
 *
 * <pre>
 * Artifacts produced by a build that should be uploaded upon
 * successful completion of all build steps.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v1.Artifacts}
 */
public final class Artifacts extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.Artifacts)
    ArtifactsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Artifacts.newBuilder() to construct.
  private Artifacts(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Artifacts() {
    images_ = com.google.protobuf.LazyStringArrayList.emptyList();
    mavenArtifacts_ = java.util.Collections.emptyList();
    goModules_ = java.util.Collections.emptyList();
    pythonPackages_ = java.util.Collections.emptyList();
    npmPackages_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Artifacts();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_Artifacts_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_Artifacts_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.Artifacts.class,
            com.google.cloudbuild.v1.Artifacts.Builder.class);
  }

  public interface ArtifactObjectsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Cloud Storage bucket and optional object path, in the form
     * "gs://bucket/path/to/somewhere/". (see [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     *
     * Files in the workspace matching any path pattern will be uploaded to
     * Cloud Storage with this location as a prefix.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The location.
     */
    java.lang.String getLocation();
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket and optional object path, in the form
     * "gs://bucket/path/to/somewhere/". (see [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     *
     * Files in the workspace matching any path pattern will be uploaded to
     * Cloud Storage with this location as a prefix.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The bytes for location.
     */
    com.google.protobuf.ByteString getLocationBytes();

    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @return A list containing the paths.
     */
    java.util.List<java.lang.String> getPathsList();
    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @return The count of paths.
     */
    int getPathsCount();
    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The paths at the given index.
     */
    java.lang.String getPaths(int index);
    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the paths at the given index.
     */
    com.google.protobuf.ByteString getPathsBytes(int index);

    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pushing all artifact objects.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the timing field is set.
     */
    boolean hasTiming();
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pushing all artifact objects.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The timing.
     */
    com.google.cloudbuild.v1.TimeSpan getTiming();
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pushing all artifact objects.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloudbuild.v1.TimeSpanOrBuilder getTimingOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Files in the workspace to upload to Cloud Storage upon successful
   * completion of all build steps.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects}
   */
  public static final class ArtifactObjects extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects)
      ArtifactObjectsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ArtifactObjects.newBuilder() to construct.
    private ArtifactObjects(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ArtifactObjects() {
      location_ = "";
      paths_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ArtifactObjects();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Artifacts_ArtifactObjects_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Artifacts_ArtifactObjects_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.Artifacts.ArtifactObjects.class,
              com.google.cloudbuild.v1.Artifacts.ArtifactObjects.Builder.class);
    }

    private int bitField0_;
    public static final int LOCATION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object location_ = "";
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket and optional object path, in the form
     * "gs://bucket/path/to/somewhere/". (see [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     *
     * Files in the workspace matching any path pattern will be uploaded to
     * Cloud Storage with this location as a prefix.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The location.
     */
    @java.lang.Override
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket and optional object path, in the form
     * "gs://bucket/path/to/somewhere/". (see [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     *
     * Files in the workspace matching any path pattern will be uploaded to
     * Cloud Storage with this location as a prefix.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The bytes for location.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATHS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList paths_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @return A list containing the paths.
     */
    public com.google.protobuf.ProtocolStringList getPathsList() {
      return paths_;
    }
    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @return The count of paths.
     */
    public int getPathsCount() {
      return paths_.size();
    }
    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The paths at the given index.
     */
    public java.lang.String getPaths(int index) {
      return paths_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the paths at the given index.
     */
    public com.google.protobuf.ByteString getPathsBytes(int index) {
      return paths_.getByteString(index);
    }

    public static final int TIMING_FIELD_NUMBER = 3;
    private com.google.cloudbuild.v1.TimeSpan timing_;
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pushing all artifact objects.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the timing field is set.
     */
    @java.lang.Override
    public boolean hasTiming() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pushing all artifact objects.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The timing.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.TimeSpan getTiming() {
      return timing_ == null ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance() : timing_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pushing all artifact objects.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.TimeSpanOrBuilder getTimingOrBuilder() {
      return timing_ == null ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance() : timing_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, location_);
      }
      for (int i = 0; i < paths_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, paths_.getRaw(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getTiming());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, location_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < paths_.size(); i++) {
          dataSize += computeStringSizeNoTag(paths_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getPathsList().size();
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTiming());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloudbuild.v1.Artifacts.ArtifactObjects)) {
        return super.equals(obj);
      }
      com.google.cloudbuild.v1.Artifacts.ArtifactObjects other =
          (com.google.cloudbuild.v1.Artifacts.ArtifactObjects) obj;

      if (!getLocation().equals(other.getLocation())) return false;
      if (!getPathsList().equals(other.getPathsList())) return false;
      if (hasTiming() != other.hasTiming()) return false;
      if (hasTiming()) {
        if (!getTiming().equals(other.getTiming())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
      if (getPathsCount() > 0) {
        hash = (37 * hash) + PATHS_FIELD_NUMBER;
        hash = (53 * hash) + getPathsList().hashCode();
      }
      if (hasTiming()) {
        hash = (37 * hash) + TIMING_FIELD_NUMBER;
        hash = (53 * hash) + getTiming().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloudbuild.v1.Artifacts.ArtifactObjects prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Files in the workspace to upload to Cloud Storage upon successful
     * completion of all build steps.
     * </pre>
     *
     * Protobuf type {@code google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects)
        com.google.cloudbuild.v1.Artifacts.ArtifactObjectsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Artifacts_ArtifactObjects_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Artifacts_ArtifactObjects_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloudbuild.v1.Artifacts.ArtifactObjects.class,
                com.google.cloudbuild.v1.Artifacts.ArtifactObjects.Builder.class);
      }

      // Construct using com.google.cloudbuild.v1.Artifacts.ArtifactObjects.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getTimingFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        location_ = "";
        paths_ = com.google.protobuf.LazyStringArrayList.emptyList();
        timing_ = null;
        if (timingBuilder_ != null) {
          timingBuilder_.dispose();
          timingBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Artifacts_ArtifactObjects_descriptor;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Artifacts.ArtifactObjects getDefaultInstanceForType() {
        return com.google.cloudbuild.v1.Artifacts.ArtifactObjects.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Artifacts.ArtifactObjects build() {
        com.google.cloudbuild.v1.Artifacts.ArtifactObjects result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Artifacts.ArtifactObjects buildPartial() {
        com.google.cloudbuild.v1.Artifacts.ArtifactObjects result =
            new com.google.cloudbuild.v1.Artifacts.ArtifactObjects(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloudbuild.v1.Artifacts.ArtifactObjects result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.location_ = location_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          paths_.makeImmutable();
          result.paths_ = paths_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.timing_ = timingBuilder_ == null ? timing_ : timingBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloudbuild.v1.Artifacts.ArtifactObjects) {
          return mergeFrom((com.google.cloudbuild.v1.Artifacts.ArtifactObjects) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloudbuild.v1.Artifacts.ArtifactObjects other) {
        if (other == com.google.cloudbuild.v1.Artifacts.ArtifactObjects.getDefaultInstance())
          return this;
        if (!other.getLocation().isEmpty()) {
          location_ = other.location_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.paths_.isEmpty()) {
          if (paths_.isEmpty()) {
            paths_ = other.paths_;
            bitField0_ |= 0x00000002;
          } else {
            ensurePathsIsMutable();
            paths_.addAll(other.paths_);
          }
          onChanged();
        }
        if (other.hasTiming()) {
          mergeTiming(other.getTiming());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  location_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensurePathsIsMutable();
                  paths_.add(s);
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getTimingFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object location_ = "";
      /**
       *
       *
       * <pre>
       * Cloud Storage bucket and optional object path, in the form
       * "gs://bucket/path/to/somewhere/". (see [Bucket Name
       * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
       *
       * Files in the workspace matching any path pattern will be uploaded to
       * Cloud Storage with this location as a prefix.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return The location.
       */
      public java.lang.String getLocation() {
        java.lang.Object ref = location_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          location_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage bucket and optional object path, in the form
       * "gs://bucket/path/to/somewhere/". (see [Bucket Name
       * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
       *
       * Files in the workspace matching any path pattern will be uploaded to
       * Cloud Storage with this location as a prefix.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return The bytes for location.
       */
      public com.google.protobuf.ByteString getLocationBytes() {
        java.lang.Object ref = location_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          location_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage bucket and optional object path, in the form
       * "gs://bucket/path/to/somewhere/". (see [Bucket Name
       * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
       *
       * Files in the workspace matching any path pattern will be uploaded to
       * Cloud Storage with this location as a prefix.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @param value The location to set.
       * @return This builder for chaining.
       */
      public Builder setLocation(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        location_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage bucket and optional object path, in the form
       * "gs://bucket/path/to/somewhere/". (see [Bucket Name
       * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
       *
       * Files in the workspace matching any path pattern will be uploaded to
       * Cloud Storage with this location as a prefix.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLocation() {
        location_ = getDefaultInstance().getLocation();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage bucket and optional object path, in the form
       * "gs://bucket/path/to/somewhere/". (see [Bucket Name
       * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
       *
       * Files in the workspace matching any path pattern will be uploaded to
       * Cloud Storage with this location as a prefix.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @param value The bytes for location to set.
       * @return This builder for chaining.
       */
      public Builder setLocationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        location_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList paths_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensurePathsIsMutable() {
        if (!paths_.isModifiable()) {
          paths_ = new com.google.protobuf.LazyStringArrayList(paths_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @return A list containing the paths.
       */
      public com.google.protobuf.ProtocolStringList getPathsList() {
        paths_.makeImmutable();
        return paths_;
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @return The count of paths.
       */
      public int getPathsCount() {
        return paths_.size();
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The paths at the given index.
       */
      public java.lang.String getPaths(int index) {
        return paths_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the paths at the given index.
       */
      public com.google.protobuf.ByteString getPathsBytes(int index) {
        return paths_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The paths to set.
       * @return This builder for chaining.
       */
      public Builder setPaths(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePathsIsMutable();
        paths_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @param value The paths to add.
       * @return This builder for chaining.
       */
      public Builder addPaths(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePathsIsMutable();
        paths_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @param values The paths to add.
       * @return This builder for chaining.
       */
      public Builder addAllPaths(java.lang.Iterable<java.lang.String> values) {
        ensurePathsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, paths_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPaths() {
        paths_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @param value The bytes of the paths to add.
       * @return This builder for chaining.
       */
      public Builder addPathsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensurePathsIsMutable();
        paths_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.cloudbuild.v1.TimeSpan timing_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloudbuild.v1.TimeSpan,
              com.google.cloudbuild.v1.TimeSpan.Builder,
              com.google.cloudbuild.v1.TimeSpanOrBuilder>
          timingBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. Stores timing information for pushing all artifact objects.
       * </pre>
       *
       * <code>
       * .google.devtools.cloudbuild.v1.TimeSpan timing = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the timing field is set.
       */
      public boolean hasTiming() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. Stores timing information for pushing all artifact objects.
       * </pre>
       *
       * <code>
       * .google.devtools.cloudbuild.v1.TimeSpan timing = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The timing.
       */
      public com.google.cloudbuild.v1.TimeSpan getTiming() {
        if (timingBuilder_ == null) {
          return timing_ == null ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance() : timing_;
        } else {
          return timingBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Stores timing information for pushing all artifact objects.
       * </pre>
       *
       * <code>
       * .google.devtools.cloudbuild.v1.TimeSpan timing = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setTiming(com.google.cloudbuild.v1.TimeSpan value) {
        if (timingBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timing_ = value;
        } else {
          timingBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Stores timing information for pushing all artifact objects.
       * </pre>
       *
       * <code>
       * .google.devtools.cloudbuild.v1.TimeSpan timing = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setTiming(com.google.cloudbuild.v1.TimeSpan.Builder builderForValue) {
        if (timingBuilder_ == null) {
          timing_ = builderForValue.build();
        } else {
          timingBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Stores timing information for pushing all artifact objects.
       * </pre>
       *
       * <code>
       * .google.devtools.cloudbuild.v1.TimeSpan timing = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeTiming(com.google.cloudbuild.v1.TimeSpan value) {
        if (timingBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && timing_ != null
              && timing_ != com.google.cloudbuild.v1.TimeSpan.getDefaultInstance()) {
            getTimingBuilder().mergeFrom(value);
          } else {
            timing_ = value;
          }
        } else {
          timingBuilder_.mergeFrom(value);
        }
        if (timing_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Stores timing information for pushing all artifact objects.
       * </pre>
       *
       * <code>
       * .google.devtools.cloudbuild.v1.TimeSpan timing = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearTiming() {
        bitField0_ = (bitField0_ & ~0x00000004);
        timing_ = null;
        if (timingBuilder_ != null) {
          timingBuilder_.dispose();
          timingBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Stores timing information for pushing all artifact objects.
       * </pre>
       *
       * <code>
       * .google.devtools.cloudbuild.v1.TimeSpan timing = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloudbuild.v1.TimeSpan.Builder getTimingBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getTimingFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. Stores timing information for pushing all artifact objects.
       * </pre>
       *
       * <code>
       * .google.devtools.cloudbuild.v1.TimeSpan timing = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloudbuild.v1.TimeSpanOrBuilder getTimingOrBuilder() {
        if (timingBuilder_ != null) {
          return timingBuilder_.getMessageOrBuilder();
        } else {
          return timing_ == null ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance() : timing_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Stores timing information for pushing all artifact objects.
       * </pre>
       *
       * <code>
       * .google.devtools.cloudbuild.v1.TimeSpan timing = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloudbuild.v1.TimeSpan,
              com.google.cloudbuild.v1.TimeSpan.Builder,
              com.google.cloudbuild.v1.TimeSpanOrBuilder>
          getTimingFieldBuilder() {
        if (timingBuilder_ == null) {
          timingBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloudbuild.v1.TimeSpan,
                  com.google.cloudbuild.v1.TimeSpan.Builder,
                  com.google.cloudbuild.v1.TimeSpanOrBuilder>(
                  getTiming(), getParentForChildren(), isClean());
          timing_ = null;
        }
        return timingBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects)
    }

    // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects)
    private static final com.google.cloudbuild.v1.Artifacts.ArtifactObjects DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloudbuild.v1.Artifacts.ArtifactObjects();
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ArtifactObjects> PARSER =
        new com.google.protobuf.AbstractParser<ArtifactObjects>() {
          @java.lang.Override
          public ArtifactObjects parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ArtifactObjects> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ArtifactObjects> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Artifacts.ArtifactObjects getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MavenArtifactOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.devtools.cloudbuild.v1.Artifacts.MavenArtifact)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Artifact Registry repository, in the form
     * "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY"
     *
     * Artifact in the workspace specified by path will be uploaded to
     * Artifact Registry with this location as a prefix.
     * </pre>
     *
     * <code>string repository = 1;</code>
     *
     * @return The repository.
     */
    java.lang.String getRepository();
    /**
     *
     *
     * <pre>
     * Artifact Registry repository, in the form
     * "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY"
     *
     * Artifact in the workspace specified by path will be uploaded to
     * Artifact Registry with this location as a prefix.
     * </pre>
     *
     * <code>string repository = 1;</code>
     *
     * @return The bytes for repository.
     */
    com.google.protobuf.ByteString getRepositoryBytes();

    /**
     *
     *
     * <pre>
     * Path to an artifact in the build's workspace to be uploaded to
     * Artifact Registry.
     * This can be either an absolute path,
     * e.g. /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar
     * or a relative path from /workspace,
     * e.g. my-app/target/my-app-1.0.SNAPSHOT.jar.
     * </pre>
     *
     * <code>string path = 2;</code>
     *
     * @return The path.
     */
    java.lang.String getPath();
    /**
     *
     *
     * <pre>
     * Path to an artifact in the build's workspace to be uploaded to
     * Artifact Registry.
     * This can be either an absolute path,
     * e.g. /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar
     * or a relative path from /workspace,
     * e.g. my-app/target/my-app-1.0.SNAPSHOT.jar.
     * </pre>
     *
     * <code>string path = 2;</code>
     *
     * @return The bytes for path.
     */
    com.google.protobuf.ByteString getPathBytes();

    /**
     *
     *
     * <pre>
     * Maven `artifactId` value used when uploading the artifact to Artifact
     * Registry.
     * </pre>
     *
     * <code>string artifact_id = 3;</code>
     *
     * @return The artifactId.
     */
    java.lang.String getArtifactId();
    /**
     *
     *
     * <pre>
     * Maven `artifactId` value used when uploading the artifact to Artifact
     * Registry.
     * </pre>
     *
     * <code>string artifact_id = 3;</code>
     *
     * @return The bytes for artifactId.
     */
    com.google.protobuf.ByteString getArtifactIdBytes();

    /**
     *
     *
     * <pre>
     * Maven `groupId` value used when uploading the artifact to Artifact
     * Registry.
     * </pre>
     *
     * <code>string group_id = 4;</code>
     *
     * @return The groupId.
     */
    java.lang.String getGroupId();
    /**
     *
     *
     * <pre>
     * Maven `groupId` value used when uploading the artifact to Artifact
     * Registry.
     * </pre>
     *
     * <code>string group_id = 4;</code>
     *
     * @return The bytes for groupId.
     */
    com.google.protobuf.ByteString getGroupIdBytes();

    /**
     *
     *
     * <pre>
     * Maven `version` value used when uploading the artifact to Artifact
     * Registry.
     * </pre>
     *
     * <code>string version = 5;</code>
     *
     * @return The version.
     */
    java.lang.String getVersion();
    /**
     *
     *
     * <pre>
     * Maven `version` value used when uploading the artifact to Artifact
     * Registry.
     * </pre>
     *
     * <code>string version = 5;</code>
     *
     * @return The bytes for version.
     */
    com.google.protobuf.ByteString getVersionBytes();
  }
  /**
   *
   *
   * <pre>
   * A Maven artifact to upload to Artifact Registry upon successful completion
   * of all build steps.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.Artifacts.MavenArtifact}
   */
  public static final class MavenArtifact extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.Artifacts.MavenArtifact)
      MavenArtifactOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MavenArtifact.newBuilder() to construct.
    private MavenArtifact(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MavenArtifact() {
      repository_ = "";
      path_ = "";
      artifactId_ = "";
      groupId_ = "";
      version_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MavenArtifact();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Artifacts_MavenArtifact_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Artifacts_MavenArtifact_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.Artifacts.MavenArtifact.class,
              com.google.cloudbuild.v1.Artifacts.MavenArtifact.Builder.class);
    }

    public static final int REPOSITORY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object repository_ = "";
    /**
     *
     *
     * <pre>
     * Artifact Registry repository, in the form
     * "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY"
     *
     * Artifact in the workspace specified by path will be uploaded to
     * Artifact Registry with this location as a prefix.
     * </pre>
     *
     * <code>string repository = 1;</code>
     *
     * @return The repository.
     */
    @java.lang.Override
    public java.lang.String getRepository() {
      java.lang.Object ref = repository_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        repository_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Artifact Registry repository, in the form
     * "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY"
     *
     * Artifact in the workspace specified by path will be uploaded to
     * Artifact Registry with this location as a prefix.
     * </pre>
     *
     * <code>string repository = 1;</code>
     *
     * @return The bytes for repository.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRepositoryBytes() {
      java.lang.Object ref = repository_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        repository_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATH_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object path_ = "";
    /**
     *
     *
     * <pre>
     * Path to an artifact in the build's workspace to be uploaded to
     * Artifact Registry.
     * This can be either an absolute path,
     * e.g. /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar
     * or a relative path from /workspace,
     * e.g. my-app/target/my-app-1.0.SNAPSHOT.jar.
     * </pre>
     *
     * <code>string path = 2;</code>
     *
     * @return The path.
     */
    @java.lang.Override
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Path to an artifact in the build's workspace to be uploaded to
     * Artifact Registry.
     * This can be either an absolute path,
     * e.g. /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar
     * or a relative path from /workspace,
     * e.g. my-app/target/my-app-1.0.SNAPSHOT.jar.
     * </pre>
     *
     * <code>string path = 2;</code>
     *
     * @return The bytes for path.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ARTIFACT_ID_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object artifactId_ = "";
    /**
     *
     *
     * <pre>
     * Maven `artifactId` value used when uploading the artifact to Artifact
     * Registry.
     * </pre>
     *
     * <code>string artifact_id = 3;</code>
     *
     * @return The artifactId.
     */
    @java.lang.Override
    public java.lang.String getArtifactId() {
      java.lang.Object ref = artifactId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        artifactId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Maven `artifactId` value used when uploading the artifact to Artifact
     * Registry.
     * </pre>
     *
     * <code>string artifact_id = 3;</code>
     *
     * @return The bytes for artifactId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getArtifactIdBytes() {
      java.lang.Object ref = artifactId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        artifactId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GROUP_ID_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object groupId_ = "";
    /**
     *
     *
     * <pre>
     * Maven `groupId` value used when uploading the artifact to Artifact
     * Registry.
     * </pre>
     *
     * <code>string group_id = 4;</code>
     *
     * @return The groupId.
     */
    @java.lang.Override
    public java.lang.String getGroupId() {
      java.lang.Object ref = groupId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        groupId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Maven `groupId` value used when uploading the artifact to Artifact
     * Registry.
     * </pre>
     *
     * <code>string group_id = 4;</code>
     *
     * @return The bytes for groupId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGroupIdBytes() {
      java.lang.Object ref = groupId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        groupId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VERSION_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * Maven `version` value used when uploading the artifact to Artifact
     * Registry.
     * </pre>
     *
     * <code>string version = 5;</code>
     *
     * @return The version.
     */
    @java.lang.Override
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Maven `version` value used when uploading the artifact to Artifact
     * Registry.
     * </pre>
     *
     * <code>string version = 5;</code>
     *
     * @return The bytes for version.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(repository_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, repository_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, path_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(artifactId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, artifactId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(groupId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, groupId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, version_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(repository_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, repository_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, path_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(artifactId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, artifactId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(groupId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, groupId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, version_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloudbuild.v1.Artifacts.MavenArtifact)) {
        return super.equals(obj);
      }
      com.google.cloudbuild.v1.Artifacts.MavenArtifact other =
          (com.google.cloudbuild.v1.Artifacts.MavenArtifact) obj;

      if (!getRepository().equals(other.getRepository())) return false;
      if (!getPath().equals(other.getPath())) return false;
      if (!getArtifactId().equals(other.getArtifactId())) return false;
      if (!getGroupId().equals(other.getGroupId())) return false;
      if (!getVersion().equals(other.getVersion())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + REPOSITORY_FIELD_NUMBER;
      hash = (53 * hash) + getRepository().hashCode();
      hash = (37 * hash) + PATH_FIELD_NUMBER;
      hash = (53 * hash) + getPath().hashCode();
      hash = (37 * hash) + ARTIFACT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getArtifactId().hashCode();
      hash = (37 * hash) + GROUP_ID_FIELD_NUMBER;
      hash = (53 * hash) + getGroupId().hashCode();
      hash = (37 * hash) + VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getVersion().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloudbuild.v1.Artifacts.MavenArtifact parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Artifacts.MavenArtifact parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.MavenArtifact parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Artifacts.MavenArtifact parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.MavenArtifact parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Artifacts.MavenArtifact parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.MavenArtifact parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Artifacts.MavenArtifact parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.MavenArtifact parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Artifacts.MavenArtifact parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.MavenArtifact parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Artifacts.MavenArtifact parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloudbuild.v1.Artifacts.MavenArtifact prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A Maven artifact to upload to Artifact Registry upon successful completion
     * of all build steps.
     * </pre>
     *
     * Protobuf type {@code google.devtools.cloudbuild.v1.Artifacts.MavenArtifact}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.Artifacts.MavenArtifact)
        com.google.cloudbuild.v1.Artifacts.MavenArtifactOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Artifacts_MavenArtifact_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Artifacts_MavenArtifact_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloudbuild.v1.Artifacts.MavenArtifact.class,
                com.google.cloudbuild.v1.Artifacts.MavenArtifact.Builder.class);
      }

      // Construct using com.google.cloudbuild.v1.Artifacts.MavenArtifact.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        repository_ = "";
        path_ = "";
        artifactId_ = "";
        groupId_ = "";
        version_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Artifacts_MavenArtifact_descriptor;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Artifacts.MavenArtifact getDefaultInstanceForType() {
        return com.google.cloudbuild.v1.Artifacts.MavenArtifact.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Artifacts.MavenArtifact build() {
        com.google.cloudbuild.v1.Artifacts.MavenArtifact result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Artifacts.MavenArtifact buildPartial() {
        com.google.cloudbuild.v1.Artifacts.MavenArtifact result =
            new com.google.cloudbuild.v1.Artifacts.MavenArtifact(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloudbuild.v1.Artifacts.MavenArtifact result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.repository_ = repository_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.path_ = path_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.artifactId_ = artifactId_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.groupId_ = groupId_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.version_ = version_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloudbuild.v1.Artifacts.MavenArtifact) {
          return mergeFrom((com.google.cloudbuild.v1.Artifacts.MavenArtifact) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloudbuild.v1.Artifacts.MavenArtifact other) {
        if (other == com.google.cloudbuild.v1.Artifacts.MavenArtifact.getDefaultInstance())
          return this;
        if (!other.getRepository().isEmpty()) {
          repository_ = other.repository_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getPath().isEmpty()) {
          path_ = other.path_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getArtifactId().isEmpty()) {
          artifactId_ = other.artifactId_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getGroupId().isEmpty()) {
          groupId_ = other.groupId_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getVersion().isEmpty()) {
          version_ = other.version_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  repository_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  path_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  artifactId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  groupId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  version_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object repository_ = "";
      /**
       *
       *
       * <pre>
       * Artifact Registry repository, in the form
       * "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY"
       *
       * Artifact in the workspace specified by path will be uploaded to
       * Artifact Registry with this location as a prefix.
       * </pre>
       *
       * <code>string repository = 1;</code>
       *
       * @return The repository.
       */
      public java.lang.String getRepository() {
        java.lang.Object ref = repository_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          repository_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Artifact Registry repository, in the form
       * "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY"
       *
       * Artifact in the workspace specified by path will be uploaded to
       * Artifact Registry with this location as a prefix.
       * </pre>
       *
       * <code>string repository = 1;</code>
       *
       * @return The bytes for repository.
       */
      public com.google.protobuf.ByteString getRepositoryBytes() {
        java.lang.Object ref = repository_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          repository_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Artifact Registry repository, in the form
       * "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY"
       *
       * Artifact in the workspace specified by path will be uploaded to
       * Artifact Registry with this location as a prefix.
       * </pre>
       *
       * <code>string repository = 1;</code>
       *
       * @param value The repository to set.
       * @return This builder for chaining.
       */
      public Builder setRepository(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        repository_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Artifact Registry repository, in the form
       * "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY"
       *
       * Artifact in the workspace specified by path will be uploaded to
       * Artifact Registry with this location as a prefix.
       * </pre>
       *
       * <code>string repository = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRepository() {
        repository_ = getDefaultInstance().getRepository();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Artifact Registry repository, in the form
       * "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY"
       *
       * Artifact in the workspace specified by path will be uploaded to
       * Artifact Registry with this location as a prefix.
       * </pre>
       *
       * <code>string repository = 1;</code>
       *
       * @param value The bytes for repository to set.
       * @return This builder for chaining.
       */
      public Builder setRepositoryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        repository_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object path_ = "";
      /**
       *
       *
       * <pre>
       * Path to an artifact in the build's workspace to be uploaded to
       * Artifact Registry.
       * This can be either an absolute path,
       * e.g. /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar
       * or a relative path from /workspace,
       * e.g. my-app/target/my-app-1.0.SNAPSHOT.jar.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @return The path.
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          path_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Path to an artifact in the build's workspace to be uploaded to
       * Artifact Registry.
       * This can be either an absolute path,
       * e.g. /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar
       * or a relative path from /workspace,
       * e.g. my-app/target/my-app-1.0.SNAPSHOT.jar.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @return The bytes for path.
       */
      public com.google.protobuf.ByteString getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Path to an artifact in the build's workspace to be uploaded to
       * Artifact Registry.
       * This can be either an absolute path,
       * e.g. /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar
       * or a relative path from /workspace,
       * e.g. my-app/target/my-app-1.0.SNAPSHOT.jar.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        path_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Path to an artifact in the build's workspace to be uploaded to
       * Artifact Registry.
       * This can be either an absolute path,
       * e.g. /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar
       * or a relative path from /workspace,
       * e.g. my-app/target/my-app-1.0.SNAPSHOT.jar.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPath() {
        path_ = getDefaultInstance().getPath();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Path to an artifact in the build's workspace to be uploaded to
       * Artifact Registry.
       * This can be either an absolute path,
       * e.g. /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar
       * or a relative path from /workspace,
       * e.g. my-app/target/my-app-1.0.SNAPSHOT.jar.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        path_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object artifactId_ = "";
      /**
       *
       *
       * <pre>
       * Maven `artifactId` value used when uploading the artifact to Artifact
       * Registry.
       * </pre>
       *
       * <code>string artifact_id = 3;</code>
       *
       * @return The artifactId.
       */
      public java.lang.String getArtifactId() {
        java.lang.Object ref = artifactId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          artifactId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Maven `artifactId` value used when uploading the artifact to Artifact
       * Registry.
       * </pre>
       *
       * <code>string artifact_id = 3;</code>
       *
       * @return The bytes for artifactId.
       */
      public com.google.protobuf.ByteString getArtifactIdBytes() {
        java.lang.Object ref = artifactId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          artifactId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Maven `artifactId` value used when uploading the artifact to Artifact
       * Registry.
       * </pre>
       *
       * <code>string artifact_id = 3;</code>
       *
       * @param value The artifactId to set.
       * @return This builder for chaining.
       */
      public Builder setArtifactId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        artifactId_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Maven `artifactId` value used when uploading the artifact to Artifact
       * Registry.
       * </pre>
       *
       * <code>string artifact_id = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearArtifactId() {
        artifactId_ = getDefaultInstance().getArtifactId();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Maven `artifactId` value used when uploading the artifact to Artifact
       * Registry.
       * </pre>
       *
       * <code>string artifact_id = 3;</code>
       *
       * @param value The bytes for artifactId to set.
       * @return This builder for chaining.
       */
      public Builder setArtifactIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        artifactId_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object groupId_ = "";
      /**
       *
       *
       * <pre>
       * Maven `groupId` value used when uploading the artifact to Artifact
       * Registry.
       * </pre>
       *
       * <code>string group_id = 4;</code>
       *
       * @return The groupId.
       */
      public java.lang.String getGroupId() {
        java.lang.Object ref = groupId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          groupId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Maven `groupId` value used when uploading the artifact to Artifact
       * Registry.
       * </pre>
       *
       * <code>string group_id = 4;</code>
       *
       * @return The bytes for groupId.
       */
      public com.google.protobuf.ByteString getGroupIdBytes() {
        java.lang.Object ref = groupId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          groupId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Maven `groupId` value used when uploading the artifact to Artifact
       * Registry.
       * </pre>
       *
       * <code>string group_id = 4;</code>
       *
       * @param value The groupId to set.
       * @return This builder for chaining.
       */
      public Builder setGroupId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        groupId_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Maven `groupId` value used when uploading the artifact to Artifact
       * Registry.
       * </pre>
       *
       * <code>string group_id = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGroupId() {
        groupId_ = getDefaultInstance().getGroupId();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Maven `groupId` value used when uploading the artifact to Artifact
       * Registry.
       * </pre>
       *
       * <code>string group_id = 4;</code>
       *
       * @param value The bytes for groupId to set.
       * @return This builder for chaining.
       */
      public Builder setGroupIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        groupId_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object version_ = "";
      /**
       *
       *
       * <pre>
       * Maven `version` value used when uploading the artifact to Artifact
       * Registry.
       * </pre>
       *
       * <code>string version = 5;</code>
       *
       * @return The version.
       */
      public java.lang.String getVersion() {
        java.lang.Object ref = version_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          version_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Maven `version` value used when uploading the artifact to Artifact
       * Registry.
       * </pre>
       *
       * <code>string version = 5;</code>
       *
       * @return The bytes for version.
       */
      public com.google.protobuf.ByteString getVersionBytes() {
        java.lang.Object ref = version_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          version_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Maven `version` value used when uploading the artifact to Artifact
       * Registry.
       * </pre>
       *
       * <code>string version = 5;</code>
       *
       * @param value The version to set.
       * @return This builder for chaining.
       */
      public Builder setVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        version_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Maven `version` value used when uploading the artifact to Artifact
       * Registry.
       * </pre>
       *
       * <code>string version = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVersion() {
        version_ = getDefaultInstance().getVersion();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Maven `version` value used when uploading the artifact to Artifact
       * Registry.
       * </pre>
       *
       * <code>string version = 5;</code>
       *
       * @param value The bytes for version to set.
       * @return This builder for chaining.
       */
      public Builder setVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        version_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.Artifacts.MavenArtifact)
    }

    // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.Artifacts.MavenArtifact)
    private static final com.google.cloudbuild.v1.Artifacts.MavenArtifact DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloudbuild.v1.Artifacts.MavenArtifact();
    }

    public static com.google.cloudbuild.v1.Artifacts.MavenArtifact getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MavenArtifact> PARSER =
        new com.google.protobuf.AbstractParser<MavenArtifact>() {
          @java.lang.Override
          public MavenArtifact parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MavenArtifact> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MavenArtifact> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Artifacts.MavenArtifact getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GoModuleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.devtools.cloudbuild.v1.Artifacts.GoModule)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Artifact Registry repository name.
     *
     * Specified Go modules will be zipped and uploaded to Artifact Registry
     * with this location as a prefix.
     * e.g. my-go-repo
     * </pre>
     *
     * <code>string repository_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The repositoryName.
     */
    java.lang.String getRepositoryName();
    /**
     *
     *
     * <pre>
     * Optional. Artifact Registry repository name.
     *
     * Specified Go modules will be zipped and uploaded to Artifact Registry
     * with this location as a prefix.
     * e.g. my-go-repo
     * </pre>
     *
     * <code>string repository_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for repositoryName.
     */
    com.google.protobuf.ByteString getRepositoryNameBytes();

    /**
     *
     *
     * <pre>
     * Optional. Location of the Artifact Registry repository. i.e. us-east1
     * Defaults to the build’s location.
     * </pre>
     *
     * <code>string repository_location = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The repositoryLocation.
     */
    java.lang.String getRepositoryLocation();
    /**
     *
     *
     * <pre>
     * Optional. Location of the Artifact Registry repository. i.e. us-east1
     * Defaults to the build’s location.
     * </pre>
     *
     * <code>string repository_location = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for repositoryLocation.
     */
    com.google.protobuf.ByteString getRepositoryLocationBytes();

    /**
     *
     *
     * <pre>
     * Optional. Project ID of the Artifact Registry repository.
     * Defaults to the build project.
     * </pre>
     *
     * <code>string repository_project_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The repositoryProjectId.
     */
    java.lang.String getRepositoryProjectId();
    /**
     *
     *
     * <pre>
     * Optional. Project ID of the Artifact Registry repository.
     * Defaults to the build project.
     * </pre>
     *
     * <code>string repository_project_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for repositoryProjectId.
     */
    com.google.protobuf.ByteString getRepositoryProjectIdBytes();

    /**
     *
     *
     * <pre>
     * Optional. Source path of the go.mod file in the build's workspace. If not
     * specified, this will default to the current directory.
     * e.g. ~/code/go/mypackage
     * </pre>
     *
     * <code>string source_path = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The sourcePath.
     */
    java.lang.String getSourcePath();
    /**
     *
     *
     * <pre>
     * Optional. Source path of the go.mod file in the build's workspace. If not
     * specified, this will default to the current directory.
     * e.g. ~/code/go/mypackage
     * </pre>
     *
     * <code>string source_path = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for sourcePath.
     */
    com.google.protobuf.ByteString getSourcePathBytes();

    /**
     *
     *
     * <pre>
     * Optional. The Go module's "module path".
     * e.g. example.com/foo/v2
     * </pre>
     *
     * <code>string module_path = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The modulePath.
     */
    java.lang.String getModulePath();
    /**
     *
     *
     * <pre>
     * Optional. The Go module's "module path".
     * e.g. example.com/foo/v2
     * </pre>
     *
     * <code>string module_path = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for modulePath.
     */
    com.google.protobuf.ByteString getModulePathBytes();

    /**
     *
     *
     * <pre>
     * Optional. The Go module's semantic version in the form vX.Y.Z. e.g.
     * v0.1.1 Pre-release identifiers can also be added by appending a dash and
     * dot separated ASCII alphanumeric characters and hyphens.
     * e.g. v0.2.3-alpha.x.12m.5
     * </pre>
     *
     * <code>string module_version = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The moduleVersion.
     */
    java.lang.String getModuleVersion();
    /**
     *
     *
     * <pre>
     * Optional. The Go module's semantic version in the form vX.Y.Z. e.g.
     * v0.1.1 Pre-release identifiers can also be added by appending a dash and
     * dot separated ASCII alphanumeric characters and hyphens.
     * e.g. v0.2.3-alpha.x.12m.5
     * </pre>
     *
     * <code>string module_version = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for moduleVersion.
     */
    com.google.protobuf.ByteString getModuleVersionBytes();
  }
  /**
   *
   *
   * <pre>
   * Go module to upload to Artifact Registry upon successful completion of all
   * build steps. A module refers to all dependencies in a go.mod file.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.Artifacts.GoModule}
   */
  public static final class GoModule extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.Artifacts.GoModule)
      GoModuleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GoModule.newBuilder() to construct.
    private GoModule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GoModule() {
      repositoryName_ = "";
      repositoryLocation_ = "";
      repositoryProjectId_ = "";
      sourcePath_ = "";
      modulePath_ = "";
      moduleVersion_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GoModule();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Artifacts_GoModule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Artifacts_GoModule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.Artifacts.GoModule.class,
              com.google.cloudbuild.v1.Artifacts.GoModule.Builder.class);
    }

    public static final int REPOSITORY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object repositoryName_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Artifact Registry repository name.
     *
     * Specified Go modules will be zipped and uploaded to Artifact Registry
     * with this location as a prefix.
     * e.g. my-go-repo
     * </pre>
     *
     * <code>string repository_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The repositoryName.
     */
    @java.lang.Override
    public java.lang.String getRepositoryName() {
      java.lang.Object ref = repositoryName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        repositoryName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Artifact Registry repository name.
     *
     * Specified Go modules will be zipped and uploaded to Artifact Registry
     * with this location as a prefix.
     * e.g. my-go-repo
     * </pre>
     *
     * <code>string repository_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for repositoryName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRepositoryNameBytes() {
      java.lang.Object ref = repositoryName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        repositoryName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REPOSITORY_LOCATION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object repositoryLocation_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Location of the Artifact Registry repository. i.e. us-east1
     * Defaults to the build’s location.
     * </pre>
     *
     * <code>string repository_location = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The repositoryLocation.
     */
    @java.lang.Override
    public java.lang.String getRepositoryLocation() {
      java.lang.Object ref = repositoryLocation_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        repositoryLocation_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Location of the Artifact Registry repository. i.e. us-east1
     * Defaults to the build’s location.
     * </pre>
     *
     * <code>string repository_location = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for repositoryLocation.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRepositoryLocationBytes() {
      java.lang.Object ref = repositoryLocation_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        repositoryLocation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REPOSITORY_PROJECT_ID_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object repositoryProjectId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Project ID of the Artifact Registry repository.
     * Defaults to the build project.
     * </pre>
     *
     * <code>string repository_project_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The repositoryProjectId.
     */
    @java.lang.Override
    public java.lang.String getRepositoryProjectId() {
      java.lang.Object ref = repositoryProjectId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        repositoryProjectId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Project ID of the Artifact Registry repository.
     * Defaults to the build project.
     * </pre>
     *
     * <code>string repository_project_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for repositoryProjectId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRepositoryProjectIdBytes() {
      java.lang.Object ref = repositoryProjectId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        repositoryProjectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SOURCE_PATH_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object sourcePath_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Source path of the go.mod file in the build's workspace. If not
     * specified, this will default to the current directory.
     * e.g. ~/code/go/mypackage
     * </pre>
     *
     * <code>string source_path = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The sourcePath.
     */
    @java.lang.Override
    public java.lang.String getSourcePath() {
      java.lang.Object ref = sourcePath_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourcePath_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Source path of the go.mod file in the build's workspace. If not
     * specified, this will default to the current directory.
     * e.g. ~/code/go/mypackage
     * </pre>
     *
     * <code>string source_path = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for sourcePath.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSourcePathBytes() {
      java.lang.Object ref = sourcePath_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourcePath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MODULE_PATH_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object modulePath_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Go module's "module path".
     * e.g. example.com/foo/v2
     * </pre>
     *
     * <code>string module_path = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The modulePath.
     */
    @java.lang.Override
    public java.lang.String getModulePath() {
      java.lang.Object ref = modulePath_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modulePath_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Go module's "module path".
     * e.g. example.com/foo/v2
     * </pre>
     *
     * <code>string module_path = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for modulePath.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModulePathBytes() {
      java.lang.Object ref = modulePath_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modulePath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MODULE_VERSION_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object moduleVersion_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Go module's semantic version in the form vX.Y.Z. e.g.
     * v0.1.1 Pre-release identifiers can also be added by appending a dash and
     * dot separated ASCII alphanumeric characters and hyphens.
     * e.g. v0.2.3-alpha.x.12m.5
     * </pre>
     *
     * <code>string module_version = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The moduleVersion.
     */
    @java.lang.Override
    public java.lang.String getModuleVersion() {
      java.lang.Object ref = moduleVersion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        moduleVersion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Go module's semantic version in the form vX.Y.Z. e.g.
     * v0.1.1 Pre-release identifiers can also be added by appending a dash and
     * dot separated ASCII alphanumeric characters and hyphens.
     * e.g. v0.2.3-alpha.x.12m.5
     * </pre>
     *
     * <code>string module_version = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for moduleVersion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModuleVersionBytes() {
      java.lang.Object ref = moduleVersion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        moduleVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(repositoryName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, repositoryName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(repositoryLocation_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, repositoryLocation_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(repositoryProjectId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, repositoryProjectId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourcePath_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, sourcePath_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modulePath_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, modulePath_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(moduleVersion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, moduleVersion_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(repositoryName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, repositoryName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(repositoryLocation_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, repositoryLocation_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(repositoryProjectId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, repositoryProjectId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourcePath_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, sourcePath_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modulePath_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, modulePath_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(moduleVersion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, moduleVersion_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloudbuild.v1.Artifacts.GoModule)) {
        return super.equals(obj);
      }
      com.google.cloudbuild.v1.Artifacts.GoModule other =
          (com.google.cloudbuild.v1.Artifacts.GoModule) obj;

      if (!getRepositoryName().equals(other.getRepositoryName())) return false;
      if (!getRepositoryLocation().equals(other.getRepositoryLocation())) return false;
      if (!getRepositoryProjectId().equals(other.getRepositoryProjectId())) return false;
      if (!getSourcePath().equals(other.getSourcePath())) return false;
      if (!getModulePath().equals(other.getModulePath())) return false;
      if (!getModuleVersion().equals(other.getModuleVersion())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + REPOSITORY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getRepositoryName().hashCode();
      hash = (37 * hash) + REPOSITORY_LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getRepositoryLocation().hashCode();
      hash = (37 * hash) + REPOSITORY_PROJECT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getRepositoryProjectId().hashCode();
      hash = (37 * hash) + SOURCE_PATH_FIELD_NUMBER;
      hash = (53 * hash) + getSourcePath().hashCode();
      hash = (37 * hash) + MODULE_PATH_FIELD_NUMBER;
      hash = (53 * hash) + getModulePath().hashCode();
      hash = (37 * hash) + MODULE_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getModuleVersion().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloudbuild.v1.Artifacts.GoModule parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Artifacts.GoModule parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.GoModule parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Artifacts.GoModule parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.GoModule parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Artifacts.GoModule parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.GoModule parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Artifacts.GoModule parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.GoModule parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Artifacts.GoModule parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.GoModule parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Artifacts.GoModule parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloudbuild.v1.Artifacts.GoModule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Go module to upload to Artifact Registry upon successful completion of all
     * build steps. A module refers to all dependencies in a go.mod file.
     * </pre>
     *
     * Protobuf type {@code google.devtools.cloudbuild.v1.Artifacts.GoModule}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.Artifacts.GoModule)
        com.google.cloudbuild.v1.Artifacts.GoModuleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Artifacts_GoModule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Artifacts_GoModule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloudbuild.v1.Artifacts.GoModule.class,
                com.google.cloudbuild.v1.Artifacts.GoModule.Builder.class);
      }

      // Construct using com.google.cloudbuild.v1.Artifacts.GoModule.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        repositoryName_ = "";
        repositoryLocation_ = "";
        repositoryProjectId_ = "";
        sourcePath_ = "";
        modulePath_ = "";
        moduleVersion_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Artifacts_GoModule_descriptor;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Artifacts.GoModule getDefaultInstanceForType() {
        return com.google.cloudbuild.v1.Artifacts.GoModule.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Artifacts.GoModule build() {
        com.google.cloudbuild.v1.Artifacts.GoModule result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Artifacts.GoModule buildPartial() {
        com.google.cloudbuild.v1.Artifacts.GoModule result =
            new com.google.cloudbuild.v1.Artifacts.GoModule(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloudbuild.v1.Artifacts.GoModule result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.repositoryName_ = repositoryName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.repositoryLocation_ = repositoryLocation_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.repositoryProjectId_ = repositoryProjectId_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.sourcePath_ = sourcePath_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.modulePath_ = modulePath_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.moduleVersion_ = moduleVersion_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloudbuild.v1.Artifacts.GoModule) {
          return mergeFrom((com.google.cloudbuild.v1.Artifacts.GoModule) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloudbuild.v1.Artifacts.GoModule other) {
        if (other == com.google.cloudbuild.v1.Artifacts.GoModule.getDefaultInstance()) return this;
        if (!other.getRepositoryName().isEmpty()) {
          repositoryName_ = other.repositoryName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getRepositoryLocation().isEmpty()) {
          repositoryLocation_ = other.repositoryLocation_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getRepositoryProjectId().isEmpty()) {
          repositoryProjectId_ = other.repositoryProjectId_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getSourcePath().isEmpty()) {
          sourcePath_ = other.sourcePath_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getModulePath().isEmpty()) {
          modulePath_ = other.modulePath_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (!other.getModuleVersion().isEmpty()) {
          moduleVersion_ = other.moduleVersion_;
          bitField0_ |= 0x00000020;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  repositoryName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  repositoryLocation_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  repositoryProjectId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  sourcePath_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  modulePath_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  moduleVersion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object repositoryName_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Artifact Registry repository name.
       *
       * Specified Go modules will be zipped and uploaded to Artifact Registry
       * with this location as a prefix.
       * e.g. my-go-repo
       * </pre>
       *
       * <code>string repository_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The repositoryName.
       */
      public java.lang.String getRepositoryName() {
        java.lang.Object ref = repositoryName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          repositoryName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Artifact Registry repository name.
       *
       * Specified Go modules will be zipped and uploaded to Artifact Registry
       * with this location as a prefix.
       * e.g. my-go-repo
       * </pre>
       *
       * <code>string repository_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for repositoryName.
       */
      public com.google.protobuf.ByteString getRepositoryNameBytes() {
        java.lang.Object ref = repositoryName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          repositoryName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Artifact Registry repository name.
       *
       * Specified Go modules will be zipped and uploaded to Artifact Registry
       * with this location as a prefix.
       * e.g. my-go-repo
       * </pre>
       *
       * <code>string repository_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The repositoryName to set.
       * @return This builder for chaining.
       */
      public Builder setRepositoryName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        repositoryName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Artifact Registry repository name.
       *
       * Specified Go modules will be zipped and uploaded to Artifact Registry
       * with this location as a prefix.
       * e.g. my-go-repo
       * </pre>
       *
       * <code>string repository_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRepositoryName() {
        repositoryName_ = getDefaultInstance().getRepositoryName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Artifact Registry repository name.
       *
       * Specified Go modules will be zipped and uploaded to Artifact Registry
       * with this location as a prefix.
       * e.g. my-go-repo
       * </pre>
       *
       * <code>string repository_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for repositoryName to set.
       * @return This builder for chaining.
       */
      public Builder setRepositoryNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        repositoryName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object repositoryLocation_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Location of the Artifact Registry repository. i.e. us-east1
       * Defaults to the build’s location.
       * </pre>
       *
       * <code>string repository_location = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The repositoryLocation.
       */
      public java.lang.String getRepositoryLocation() {
        java.lang.Object ref = repositoryLocation_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          repositoryLocation_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Location of the Artifact Registry repository. i.e. us-east1
       * Defaults to the build’s location.
       * </pre>
       *
       * <code>string repository_location = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for repositoryLocation.
       */
      public com.google.protobuf.ByteString getRepositoryLocationBytes() {
        java.lang.Object ref = repositoryLocation_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          repositoryLocation_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Location of the Artifact Registry repository. i.e. us-east1
       * Defaults to the build’s location.
       * </pre>
       *
       * <code>string repository_location = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The repositoryLocation to set.
       * @return This builder for chaining.
       */
      public Builder setRepositoryLocation(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        repositoryLocation_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Location of the Artifact Registry repository. i.e. us-east1
       * Defaults to the build’s location.
       * </pre>
       *
       * <code>string repository_location = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRepositoryLocation() {
        repositoryLocation_ = getDefaultInstance().getRepositoryLocation();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Location of the Artifact Registry repository. i.e. us-east1
       * Defaults to the build’s location.
       * </pre>
       *
       * <code>string repository_location = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for repositoryLocation to set.
       * @return This builder for chaining.
       */
      public Builder setRepositoryLocationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        repositoryLocation_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object repositoryProjectId_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Project ID of the Artifact Registry repository.
       * Defaults to the build project.
       * </pre>
       *
       * <code>string repository_project_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The repositoryProjectId.
       */
      public java.lang.String getRepositoryProjectId() {
        java.lang.Object ref = repositoryProjectId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          repositoryProjectId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Project ID of the Artifact Registry repository.
       * Defaults to the build project.
       * </pre>
       *
       * <code>string repository_project_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for repositoryProjectId.
       */
      public com.google.protobuf.ByteString getRepositoryProjectIdBytes() {
        java.lang.Object ref = repositoryProjectId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          repositoryProjectId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Project ID of the Artifact Registry repository.
       * Defaults to the build project.
       * </pre>
       *
       * <code>string repository_project_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The repositoryProjectId to set.
       * @return This builder for chaining.
       */
      public Builder setRepositoryProjectId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        repositoryProjectId_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Project ID of the Artifact Registry repository.
       * Defaults to the build project.
       * </pre>
       *
       * <code>string repository_project_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRepositoryProjectId() {
        repositoryProjectId_ = getDefaultInstance().getRepositoryProjectId();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Project ID of the Artifact Registry repository.
       * Defaults to the build project.
       * </pre>
       *
       * <code>string repository_project_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for repositoryProjectId to set.
       * @return This builder for chaining.
       */
      public Builder setRepositoryProjectIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        repositoryProjectId_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object sourcePath_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Source path of the go.mod file in the build's workspace. If not
       * specified, this will default to the current directory.
       * e.g. ~/code/go/mypackage
       * </pre>
       *
       * <code>string source_path = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The sourcePath.
       */
      public java.lang.String getSourcePath() {
        java.lang.Object ref = sourcePath_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sourcePath_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Source path of the go.mod file in the build's workspace. If not
       * specified, this will default to the current directory.
       * e.g. ~/code/go/mypackage
       * </pre>
       *
       * <code>string source_path = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for sourcePath.
       */
      public com.google.protobuf.ByteString getSourcePathBytes() {
        java.lang.Object ref = sourcePath_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          sourcePath_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Source path of the go.mod file in the build's workspace. If not
       * specified, this will default to the current directory.
       * e.g. ~/code/go/mypackage
       * </pre>
       *
       * <code>string source_path = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The sourcePath to set.
       * @return This builder for chaining.
       */
      public Builder setSourcePath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourcePath_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Source path of the go.mod file in the build's workspace. If not
       * specified, this will default to the current directory.
       * e.g. ~/code/go/mypackage
       * </pre>
       *
       * <code>string source_path = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSourcePath() {
        sourcePath_ = getDefaultInstance().getSourcePath();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Source path of the go.mod file in the build's workspace. If not
       * specified, this will default to the current directory.
       * e.g. ~/code/go/mypackage
       * </pre>
       *
       * <code>string source_path = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for sourcePath to set.
       * @return This builder for chaining.
       */
      public Builder setSourcePathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        sourcePath_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object modulePath_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The Go module's "module path".
       * e.g. example.com/foo/v2
       * </pre>
       *
       * <code>string module_path = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The modulePath.
       */
      public java.lang.String getModulePath() {
        java.lang.Object ref = modulePath_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modulePath_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The Go module's "module path".
       * e.g. example.com/foo/v2
       * </pre>
       *
       * <code>string module_path = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for modulePath.
       */
      public com.google.protobuf.ByteString getModulePathBytes() {
        java.lang.Object ref = modulePath_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modulePath_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The Go module's "module path".
       * e.g. example.com/foo/v2
       * </pre>
       *
       * <code>string module_path = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The modulePath to set.
       * @return This builder for chaining.
       */
      public Builder setModulePath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        modulePath_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The Go module's "module path".
       * e.g. example.com/foo/v2
       * </pre>
       *
       * <code>string module_path = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModulePath() {
        modulePath_ = getDefaultInstance().getModulePath();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The Go module's "module path".
       * e.g. example.com/foo/v2
       * </pre>
       *
       * <code>string module_path = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for modulePath to set.
       * @return This builder for chaining.
       */
      public Builder setModulePathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        modulePath_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private java.lang.Object moduleVersion_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The Go module's semantic version in the form vX.Y.Z. e.g.
       * v0.1.1 Pre-release identifiers can also be added by appending a dash and
       * dot separated ASCII alphanumeric characters and hyphens.
       * e.g. v0.2.3-alpha.x.12m.5
       * </pre>
       *
       * <code>string module_version = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The moduleVersion.
       */
      public java.lang.String getModuleVersion() {
        java.lang.Object ref = moduleVersion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          moduleVersion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The Go module's semantic version in the form vX.Y.Z. e.g.
       * v0.1.1 Pre-release identifiers can also be added by appending a dash and
       * dot separated ASCII alphanumeric characters and hyphens.
       * e.g. v0.2.3-alpha.x.12m.5
       * </pre>
       *
       * <code>string module_version = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for moduleVersion.
       */
      public com.google.protobuf.ByteString getModuleVersionBytes() {
        java.lang.Object ref = moduleVersion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          moduleVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The Go module's semantic version in the form vX.Y.Z. e.g.
       * v0.1.1 Pre-release identifiers can also be added by appending a dash and
       * dot separated ASCII alphanumeric characters and hyphens.
       * e.g. v0.2.3-alpha.x.12m.5
       * </pre>
       *
       * <code>string module_version = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The moduleVersion to set.
       * @return This builder for chaining.
       */
      public Builder setModuleVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        moduleVersion_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The Go module's semantic version in the form vX.Y.Z. e.g.
       * v0.1.1 Pre-release identifiers can also be added by appending a dash and
       * dot separated ASCII alphanumeric characters and hyphens.
       * e.g. v0.2.3-alpha.x.12m.5
       * </pre>
       *
       * <code>string module_version = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModuleVersion() {
        moduleVersion_ = getDefaultInstance().getModuleVersion();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The Go module's semantic version in the form vX.Y.Z. e.g.
       * v0.1.1 Pre-release identifiers can also be added by appending a dash and
       * dot separated ASCII alphanumeric characters and hyphens.
       * e.g. v0.2.3-alpha.x.12m.5
       * </pre>
       *
       * <code>string module_version = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for moduleVersion to set.
       * @return This builder for chaining.
       */
      public Builder setModuleVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        moduleVersion_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.Artifacts.GoModule)
    }

    // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.Artifacts.GoModule)
    private static final com.google.cloudbuild.v1.Artifacts.GoModule DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloudbuild.v1.Artifacts.GoModule();
    }

    public static com.google.cloudbuild.v1.Artifacts.GoModule getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GoModule> PARSER =
        new com.google.protobuf.AbstractParser<GoModule>() {
          @java.lang.Override
          public GoModule parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GoModule> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GoModule> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Artifacts.GoModule getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PythonPackageOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.devtools.cloudbuild.v1.Artifacts.PythonPackage)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Artifact Registry repository, in the form
     * "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY"
     *
     * Files in the workspace matching any path pattern will be uploaded to
     * Artifact Registry with this location as a prefix.
     * </pre>
     *
     * <code>string repository = 1;</code>
     *
     * @return The repository.
     */
    java.lang.String getRepository();
    /**
     *
     *
     * <pre>
     * Artifact Registry repository, in the form
     * "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY"
     *
     * Files in the workspace matching any path pattern will be uploaded to
     * Artifact Registry with this location as a prefix.
     * </pre>
     *
     * <code>string repository = 1;</code>
     *
     * @return The bytes for repository.
     */
    com.google.protobuf.ByteString getRepositoryBytes();

    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace. For Python/
     * Twine, this is usually `dist/&#42;`, and sometimes additionally an `.asc`
     * file.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @return A list containing the paths.
     */
    java.util.List<java.lang.String> getPathsList();
    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace. For Python/
     * Twine, this is usually `dist/&#42;`, and sometimes additionally an `.asc`
     * file.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @return The count of paths.
     */
    int getPathsCount();
    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace. For Python/
     * Twine, this is usually `dist/&#42;`, and sometimes additionally an `.asc`
     * file.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The paths at the given index.
     */
    java.lang.String getPaths(int index);
    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace. For Python/
     * Twine, this is usually `dist/&#42;`, and sometimes additionally an `.asc`
     * file.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the paths at the given index.
     */
    com.google.protobuf.ByteString getPathsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Python package to upload to Artifact Registry upon successful completion
   * of all build steps. A package can encapsulate multiple objects to be
   * uploaded to a single repository.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.Artifacts.PythonPackage}
   */
  public static final class PythonPackage extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.Artifacts.PythonPackage)
      PythonPackageOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PythonPackage.newBuilder() to construct.
    private PythonPackage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PythonPackage() {
      repository_ = "";
      paths_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PythonPackage();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Artifacts_PythonPackage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Artifacts_PythonPackage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.Artifacts.PythonPackage.class,
              com.google.cloudbuild.v1.Artifacts.PythonPackage.Builder.class);
    }

    public static final int REPOSITORY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object repository_ = "";
    /**
     *
     *
     * <pre>
     * Artifact Registry repository, in the form
     * "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY"
     *
     * Files in the workspace matching any path pattern will be uploaded to
     * Artifact Registry with this location as a prefix.
     * </pre>
     *
     * <code>string repository = 1;</code>
     *
     * @return The repository.
     */
    @java.lang.Override
    public java.lang.String getRepository() {
      java.lang.Object ref = repository_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        repository_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Artifact Registry repository, in the form
     * "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY"
     *
     * Files in the workspace matching any path pattern will be uploaded to
     * Artifact Registry with this location as a prefix.
     * </pre>
     *
     * <code>string repository = 1;</code>
     *
     * @return The bytes for repository.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRepositoryBytes() {
      java.lang.Object ref = repository_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        repository_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATHS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList paths_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace. For Python/
     * Twine, this is usually `dist/&#42;`, and sometimes additionally an `.asc`
     * file.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @return A list containing the paths.
     */
    public com.google.protobuf.ProtocolStringList getPathsList() {
      return paths_;
    }
    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace. For Python/
     * Twine, this is usually `dist/&#42;`, and sometimes additionally an `.asc`
     * file.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @return The count of paths.
     */
    public int getPathsCount() {
      return paths_.size();
    }
    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace. For Python/
     * Twine, this is usually `dist/&#42;`, and sometimes additionally an `.asc`
     * file.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The paths at the given index.
     */
    public java.lang.String getPaths(int index) {
      return paths_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace. For Python/
     * Twine, this is usually `dist/&#42;`, and sometimes additionally an `.asc`
     * file.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the paths at the given index.
     */
    public com.google.protobuf.ByteString getPathsBytes(int index) {
      return paths_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(repository_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, repository_);
      }
      for (int i = 0; i < paths_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, paths_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(repository_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, repository_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < paths_.size(); i++) {
          dataSize += computeStringSizeNoTag(paths_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getPathsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloudbuild.v1.Artifacts.PythonPackage)) {
        return super.equals(obj);
      }
      com.google.cloudbuild.v1.Artifacts.PythonPackage other =
          (com.google.cloudbuild.v1.Artifacts.PythonPackage) obj;

      if (!getRepository().equals(other.getRepository())) return false;
      if (!getPathsList().equals(other.getPathsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + REPOSITORY_FIELD_NUMBER;
      hash = (53 * hash) + getRepository().hashCode();
      if (getPathsCount() > 0) {
        hash = (37 * hash) + PATHS_FIELD_NUMBER;
        hash = (53 * hash) + getPathsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloudbuild.v1.Artifacts.PythonPackage parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Artifacts.PythonPackage parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.PythonPackage parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Artifacts.PythonPackage parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.PythonPackage parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Artifacts.PythonPackage parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.PythonPackage parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Artifacts.PythonPackage parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.PythonPackage parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Artifacts.PythonPackage parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.PythonPackage parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Artifacts.PythonPackage parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloudbuild.v1.Artifacts.PythonPackage prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Python package to upload to Artifact Registry upon successful completion
     * of all build steps. A package can encapsulate multiple objects to be
     * uploaded to a single repository.
     * </pre>
     *
     * Protobuf type {@code google.devtools.cloudbuild.v1.Artifacts.PythonPackage}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.Artifacts.PythonPackage)
        com.google.cloudbuild.v1.Artifacts.PythonPackageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Artifacts_PythonPackage_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Artifacts_PythonPackage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloudbuild.v1.Artifacts.PythonPackage.class,
                com.google.cloudbuild.v1.Artifacts.PythonPackage.Builder.class);
      }

      // Construct using com.google.cloudbuild.v1.Artifacts.PythonPackage.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        repository_ = "";
        paths_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Artifacts_PythonPackage_descriptor;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Artifacts.PythonPackage getDefaultInstanceForType() {
        return com.google.cloudbuild.v1.Artifacts.PythonPackage.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Artifacts.PythonPackage build() {
        com.google.cloudbuild.v1.Artifacts.PythonPackage result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Artifacts.PythonPackage buildPartial() {
        com.google.cloudbuild.v1.Artifacts.PythonPackage result =
            new com.google.cloudbuild.v1.Artifacts.PythonPackage(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloudbuild.v1.Artifacts.PythonPackage result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.repository_ = repository_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          paths_.makeImmutable();
          result.paths_ = paths_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloudbuild.v1.Artifacts.PythonPackage) {
          return mergeFrom((com.google.cloudbuild.v1.Artifacts.PythonPackage) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloudbuild.v1.Artifacts.PythonPackage other) {
        if (other == com.google.cloudbuild.v1.Artifacts.PythonPackage.getDefaultInstance())
          return this;
        if (!other.getRepository().isEmpty()) {
          repository_ = other.repository_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.paths_.isEmpty()) {
          if (paths_.isEmpty()) {
            paths_ = other.paths_;
            bitField0_ |= 0x00000002;
          } else {
            ensurePathsIsMutable();
            paths_.addAll(other.paths_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  repository_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensurePathsIsMutable();
                  paths_.add(s);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object repository_ = "";
      /**
       *
       *
       * <pre>
       * Artifact Registry repository, in the form
       * "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY"
       *
       * Files in the workspace matching any path pattern will be uploaded to
       * Artifact Registry with this location as a prefix.
       * </pre>
       *
       * <code>string repository = 1;</code>
       *
       * @return The repository.
       */
      public java.lang.String getRepository() {
        java.lang.Object ref = repository_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          repository_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Artifact Registry repository, in the form
       * "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY"
       *
       * Files in the workspace matching any path pattern will be uploaded to
       * Artifact Registry with this location as a prefix.
       * </pre>
       *
       * <code>string repository = 1;</code>
       *
       * @return The bytes for repository.
       */
      public com.google.protobuf.ByteString getRepositoryBytes() {
        java.lang.Object ref = repository_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          repository_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Artifact Registry repository, in the form
       * "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY"
       *
       * Files in the workspace matching any path pattern will be uploaded to
       * Artifact Registry with this location as a prefix.
       * </pre>
       *
       * <code>string repository = 1;</code>
       *
       * @param value The repository to set.
       * @return This builder for chaining.
       */
      public Builder setRepository(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        repository_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Artifact Registry repository, in the form
       * "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY"
       *
       * Files in the workspace matching any path pattern will be uploaded to
       * Artifact Registry with this location as a prefix.
       * </pre>
       *
       * <code>string repository = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRepository() {
        repository_ = getDefaultInstance().getRepository();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Artifact Registry repository, in the form
       * "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY"
       *
       * Files in the workspace matching any path pattern will be uploaded to
       * Artifact Registry with this location as a prefix.
       * </pre>
       *
       * <code>string repository = 1;</code>
       *
       * @param value The bytes for repository to set.
       * @return This builder for chaining.
       */
      public Builder setRepositoryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        repository_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList paths_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensurePathsIsMutable() {
        if (!paths_.isModifiable()) {
          paths_ = new com.google.protobuf.LazyStringArrayList(paths_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace. For Python/
       * Twine, this is usually `dist/&#42;`, and sometimes additionally an `.asc`
       * file.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @return A list containing the paths.
       */
      public com.google.protobuf.ProtocolStringList getPathsList() {
        paths_.makeImmutable();
        return paths_;
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace. For Python/
       * Twine, this is usually `dist/&#42;`, and sometimes additionally an `.asc`
       * file.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @return The count of paths.
       */
      public int getPathsCount() {
        return paths_.size();
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace. For Python/
       * Twine, this is usually `dist/&#42;`, and sometimes additionally an `.asc`
       * file.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The paths at the given index.
       */
      public java.lang.String getPaths(int index) {
        return paths_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace. For Python/
       * Twine, this is usually `dist/&#42;`, and sometimes additionally an `.asc`
       * file.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the paths at the given index.
       */
      public com.google.protobuf.ByteString getPathsBytes(int index) {
        return paths_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace. For Python/
       * Twine, this is usually `dist/&#42;`, and sometimes additionally an `.asc`
       * file.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The paths to set.
       * @return This builder for chaining.
       */
      public Builder setPaths(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePathsIsMutable();
        paths_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace. For Python/
       * Twine, this is usually `dist/&#42;`, and sometimes additionally an `.asc`
       * file.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @param value The paths to add.
       * @return This builder for chaining.
       */
      public Builder addPaths(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePathsIsMutable();
        paths_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace. For Python/
       * Twine, this is usually `dist/&#42;`, and sometimes additionally an `.asc`
       * file.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @param values The paths to add.
       * @return This builder for chaining.
       */
      public Builder addAllPaths(java.lang.Iterable<java.lang.String> values) {
        ensurePathsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, paths_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace. For Python/
       * Twine, this is usually `dist/&#42;`, and sometimes additionally an `.asc`
       * file.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPaths() {
        paths_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace. For Python/
       * Twine, this is usually `dist/&#42;`, and sometimes additionally an `.asc`
       * file.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @param value The bytes of the paths to add.
       * @return This builder for chaining.
       */
      public Builder addPathsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensurePathsIsMutable();
        paths_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.Artifacts.PythonPackage)
    }

    // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.Artifacts.PythonPackage)
    private static final com.google.cloudbuild.v1.Artifacts.PythonPackage DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloudbuild.v1.Artifacts.PythonPackage();
    }

    public static com.google.cloudbuild.v1.Artifacts.PythonPackage getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PythonPackage> PARSER =
        new com.google.protobuf.AbstractParser<PythonPackage>() {
          @java.lang.Override
          public PythonPackage parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PythonPackage> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PythonPackage> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Artifacts.PythonPackage getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NpmPackageOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.devtools.cloudbuild.v1.Artifacts.NpmPackage)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Artifact Registry repository, in the form
     * "https://$REGION-npm.pkg.dev/$PROJECT/$REPOSITORY"
     *
     * Npm package in the workspace specified by path will be zipped and
     * uploaded to Artifact Registry with this location as a prefix.
     * </pre>
     *
     * <code>string repository = 1;</code>
     *
     * @return The repository.
     */
    java.lang.String getRepository();
    /**
     *
     *
     * <pre>
     * Artifact Registry repository, in the form
     * "https://$REGION-npm.pkg.dev/$PROJECT/$REPOSITORY"
     *
     * Npm package in the workspace specified by path will be zipped and
     * uploaded to Artifact Registry with this location as a prefix.
     * </pre>
     *
     * <code>string repository = 1;</code>
     *
     * @return The bytes for repository.
     */
    com.google.protobuf.ByteString getRepositoryBytes();

    /**
     *
     *
     * <pre>
     * Path to the package.json.
     * e.g. workspace/path/to/package
     * </pre>
     *
     * <code>string package_path = 2;</code>
     *
     * @return The packagePath.
     */
    java.lang.String getPackagePath();
    /**
     *
     *
     * <pre>
     * Path to the package.json.
     * e.g. workspace/path/to/package
     * </pre>
     *
     * <code>string package_path = 2;</code>
     *
     * @return The bytes for packagePath.
     */
    com.google.protobuf.ByteString getPackagePathBytes();
  }
  /**
   *
   *
   * <pre>
   * Npm package to upload to Artifact Registry upon successful completion
   * of all build steps.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.Artifacts.NpmPackage}
   */
  public static final class NpmPackage extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.Artifacts.NpmPackage)
      NpmPackageOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use NpmPackage.newBuilder() to construct.
    private NpmPackage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NpmPackage() {
      repository_ = "";
      packagePath_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new NpmPackage();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Artifacts_NpmPackage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Artifacts_NpmPackage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.Artifacts.NpmPackage.class,
              com.google.cloudbuild.v1.Artifacts.NpmPackage.Builder.class);
    }

    public static final int REPOSITORY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object repository_ = "";
    /**
     *
     *
     * <pre>
     * Artifact Registry repository, in the form
     * "https://$REGION-npm.pkg.dev/$PROJECT/$REPOSITORY"
     *
     * Npm package in the workspace specified by path will be zipped and
     * uploaded to Artifact Registry with this location as a prefix.
     * </pre>
     *
     * <code>string repository = 1;</code>
     *
     * @return The repository.
     */
    @java.lang.Override
    public java.lang.String getRepository() {
      java.lang.Object ref = repository_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        repository_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Artifact Registry repository, in the form
     * "https://$REGION-npm.pkg.dev/$PROJECT/$REPOSITORY"
     *
     * Npm package in the workspace specified by path will be zipped and
     * uploaded to Artifact Registry with this location as a prefix.
     * </pre>
     *
     * <code>string repository = 1;</code>
     *
     * @return The bytes for repository.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRepositoryBytes() {
      java.lang.Object ref = repository_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        repository_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PACKAGE_PATH_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object packagePath_ = "";
    /**
     *
     *
     * <pre>
     * Path to the package.json.
     * e.g. workspace/path/to/package
     * </pre>
     *
     * <code>string package_path = 2;</code>
     *
     * @return The packagePath.
     */
    @java.lang.Override
    public java.lang.String getPackagePath() {
      java.lang.Object ref = packagePath_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        packagePath_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Path to the package.json.
     * e.g. workspace/path/to/package
     * </pre>
     *
     * <code>string package_path = 2;</code>
     *
     * @return The bytes for packagePath.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPackagePathBytes() {
      java.lang.Object ref = packagePath_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        packagePath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(repository_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, repository_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(packagePath_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, packagePath_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(repository_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, repository_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(packagePath_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, packagePath_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloudbuild.v1.Artifacts.NpmPackage)) {
        return super.equals(obj);
      }
      com.google.cloudbuild.v1.Artifacts.NpmPackage other =
          (com.google.cloudbuild.v1.Artifacts.NpmPackage) obj;

      if (!getRepository().equals(other.getRepository())) return false;
      if (!getPackagePath().equals(other.getPackagePath())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + REPOSITORY_FIELD_NUMBER;
      hash = (53 * hash) + getRepository().hashCode();
      hash = (37 * hash) + PACKAGE_PATH_FIELD_NUMBER;
      hash = (53 * hash) + getPackagePath().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloudbuild.v1.Artifacts.NpmPackage parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Artifacts.NpmPackage parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.NpmPackage parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Artifacts.NpmPackage parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.NpmPackage parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Artifacts.NpmPackage parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.NpmPackage parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Artifacts.NpmPackage parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.NpmPackage parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Artifacts.NpmPackage parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.NpmPackage parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Artifacts.NpmPackage parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloudbuild.v1.Artifacts.NpmPackage prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Npm package to upload to Artifact Registry upon successful completion
     * of all build steps.
     * </pre>
     *
     * Protobuf type {@code google.devtools.cloudbuild.v1.Artifacts.NpmPackage}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.Artifacts.NpmPackage)
        com.google.cloudbuild.v1.Artifacts.NpmPackageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Artifacts_NpmPackage_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Artifacts_NpmPackage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloudbuild.v1.Artifacts.NpmPackage.class,
                com.google.cloudbuild.v1.Artifacts.NpmPackage.Builder.class);
      }

      // Construct using com.google.cloudbuild.v1.Artifacts.NpmPackage.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        repository_ = "";
        packagePath_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Artifacts_NpmPackage_descriptor;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Artifacts.NpmPackage getDefaultInstanceForType() {
        return com.google.cloudbuild.v1.Artifacts.NpmPackage.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Artifacts.NpmPackage build() {
        com.google.cloudbuild.v1.Artifacts.NpmPackage result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Artifacts.NpmPackage buildPartial() {
        com.google.cloudbuild.v1.Artifacts.NpmPackage result =
            new com.google.cloudbuild.v1.Artifacts.NpmPackage(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloudbuild.v1.Artifacts.NpmPackage result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.repository_ = repository_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.packagePath_ = packagePath_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloudbuild.v1.Artifacts.NpmPackage) {
          return mergeFrom((com.google.cloudbuild.v1.Artifacts.NpmPackage) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloudbuild.v1.Artifacts.NpmPackage other) {
        if (other == com.google.cloudbuild.v1.Artifacts.NpmPackage.getDefaultInstance())
          return this;
        if (!other.getRepository().isEmpty()) {
          repository_ = other.repository_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getPackagePath().isEmpty()) {
          packagePath_ = other.packagePath_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  repository_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  packagePath_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object repository_ = "";
      /**
       *
       *
       * <pre>
       * Artifact Registry repository, in the form
       * "https://$REGION-npm.pkg.dev/$PROJECT/$REPOSITORY"
       *
       * Npm package in the workspace specified by path will be zipped and
       * uploaded to Artifact Registry with this location as a prefix.
       * </pre>
       *
       * <code>string repository = 1;</code>
       *
       * @return The repository.
       */
      public java.lang.String getRepository() {
        java.lang.Object ref = repository_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          repository_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Artifact Registry repository, in the form
       * "https://$REGION-npm.pkg.dev/$PROJECT/$REPOSITORY"
       *
       * Npm package in the workspace specified by path will be zipped and
       * uploaded to Artifact Registry with this location as a prefix.
       * </pre>
       *
       * <code>string repository = 1;</code>
       *
       * @return The bytes for repository.
       */
      public com.google.protobuf.ByteString getRepositoryBytes() {
        java.lang.Object ref = repository_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          repository_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Artifact Registry repository, in the form
       * "https://$REGION-npm.pkg.dev/$PROJECT/$REPOSITORY"
       *
       * Npm package in the workspace specified by path will be zipped and
       * uploaded to Artifact Registry with this location as a prefix.
       * </pre>
       *
       * <code>string repository = 1;</code>
       *
       * @param value The repository to set.
       * @return This builder for chaining.
       */
      public Builder setRepository(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        repository_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Artifact Registry repository, in the form
       * "https://$REGION-npm.pkg.dev/$PROJECT/$REPOSITORY"
       *
       * Npm package in the workspace specified by path will be zipped and
       * uploaded to Artifact Registry with this location as a prefix.
       * </pre>
       *
       * <code>string repository = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRepository() {
        repository_ = getDefaultInstance().getRepository();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Artifact Registry repository, in the form
       * "https://$REGION-npm.pkg.dev/$PROJECT/$REPOSITORY"
       *
       * Npm package in the workspace specified by path will be zipped and
       * uploaded to Artifact Registry with this location as a prefix.
       * </pre>
       *
       * <code>string repository = 1;</code>
       *
       * @param value The bytes for repository to set.
       * @return This builder for chaining.
       */
      public Builder setRepositoryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        repository_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object packagePath_ = "";
      /**
       *
       *
       * <pre>
       * Path to the package.json.
       * e.g. workspace/path/to/package
       * </pre>
       *
       * <code>string package_path = 2;</code>
       *
       * @return The packagePath.
       */
      public java.lang.String getPackagePath() {
        java.lang.Object ref = packagePath_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          packagePath_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Path to the package.json.
       * e.g. workspace/path/to/package
       * </pre>
       *
       * <code>string package_path = 2;</code>
       *
       * @return The bytes for packagePath.
       */
      public com.google.protobuf.ByteString getPackagePathBytes() {
        java.lang.Object ref = packagePath_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          packagePath_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Path to the package.json.
       * e.g. workspace/path/to/package
       * </pre>
       *
       * <code>string package_path = 2;</code>
       *
       * @param value The packagePath to set.
       * @return This builder for chaining.
       */
      public Builder setPackagePath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        packagePath_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Path to the package.json.
       * e.g. workspace/path/to/package
       * </pre>
       *
       * <code>string package_path = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPackagePath() {
        packagePath_ = getDefaultInstance().getPackagePath();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Path to the package.json.
       * e.g. workspace/path/to/package
       * </pre>
       *
       * <code>string package_path = 2;</code>
       *
       * @param value The bytes for packagePath to set.
       * @return This builder for chaining.
       */
      public Builder setPackagePathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        packagePath_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.Artifacts.NpmPackage)
    }

    // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.Artifacts.NpmPackage)
    private static final com.google.cloudbuild.v1.Artifacts.NpmPackage DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloudbuild.v1.Artifacts.NpmPackage();
    }

    public static com.google.cloudbuild.v1.Artifacts.NpmPackage getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<NpmPackage> PARSER =
        new com.google.protobuf.AbstractParser<NpmPackage>() {
          @java.lang.Override
          public NpmPackage parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<NpmPackage> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NpmPackage> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Artifacts.NpmPackage getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int IMAGES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList images_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of images to be pushed upon the successful completion of all build
   * steps.
   *
   * The images will be pushed using the builder service account's credentials.
   *
   * The digests of the pushed images will be stored in the Build resource's
   * results field.
   *
   * If any of the images fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated string images = 1;</code>
   *
   * @return A list containing the images.
   */
  public com.google.protobuf.ProtocolStringList getImagesList() {
    return images_;
  }
  /**
   *
   *
   * <pre>
   * A list of images to be pushed upon the successful completion of all build
   * steps.
   *
   * The images will be pushed using the builder service account's credentials.
   *
   * The digests of the pushed images will be stored in the Build resource's
   * results field.
   *
   * If any of the images fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated string images = 1;</code>
   *
   * @return The count of images.
   */
  public int getImagesCount() {
    return images_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of images to be pushed upon the successful completion of all build
   * steps.
   *
   * The images will be pushed using the builder service account's credentials.
   *
   * The digests of the pushed images will be stored in the Build resource's
   * results field.
   *
   * If any of the images fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated string images = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The images at the given index.
   */
  public java.lang.String getImages(int index) {
    return images_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of images to be pushed upon the successful completion of all build
   * steps.
   *
   * The images will be pushed using the builder service account's credentials.
   *
   * The digests of the pushed images will be stored in the Build resource's
   * results field.
   *
   * If any of the images fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated string images = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the images at the given index.
   */
  public com.google.protobuf.ByteString getImagesBytes(int index) {
    return images_.getByteString(index);
  }

  public static final int OBJECTS_FIELD_NUMBER = 2;
  private com.google.cloudbuild.v1.Artifacts.ArtifactObjects objects_;
  /**
   *
   *
   * <pre>
   * A list of objects to be uploaded to Cloud Storage upon successful
   * completion of all build steps.
   *
   * Files in the workspace matching specified paths globs will be uploaded to
   * the specified Cloud Storage location using the builder service account's
   * credentials.
   *
   * The location and generation of the uploaded objects will be stored in the
   * Build resource's results field.
   *
   * If any objects fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
   *
   * @return Whether the objects field is set.
   */
  @java.lang.Override
  public boolean hasObjects() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * A list of objects to be uploaded to Cloud Storage upon successful
   * completion of all build steps.
   *
   * Files in the workspace matching specified paths globs will be uploaded to
   * the specified Cloud Storage location using the builder service account's
   * credentials.
   *
   * The location and generation of the uploaded objects will be stored in the
   * Build resource's results field.
   *
   * If any objects fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
   *
   * @return The objects.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Artifacts.ArtifactObjects getObjects() {
    return objects_ == null
        ? com.google.cloudbuild.v1.Artifacts.ArtifactObjects.getDefaultInstance()
        : objects_;
  }
  /**
   *
   *
   * <pre>
   * A list of objects to be uploaded to Cloud Storage upon successful
   * completion of all build steps.
   *
   * Files in the workspace matching specified paths globs will be uploaded to
   * the specified Cloud Storage location using the builder service account's
   * credentials.
   *
   * The location and generation of the uploaded objects will be stored in the
   * Build resource's results field.
   *
   * If any objects fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Artifacts.ArtifactObjectsOrBuilder getObjectsOrBuilder() {
    return objects_ == null
        ? com.google.cloudbuild.v1.Artifacts.ArtifactObjects.getDefaultInstance()
        : objects_;
  }

  public static final int MAVEN_ARTIFACTS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloudbuild.v1.Artifacts.MavenArtifact> mavenArtifacts_;
  /**
   *
   *
   * <pre>
   * A list of Maven artifacts to be uploaded to Artifact Registry upon
   * successful completion of all build steps.
   *
   * Artifacts in the workspace matching specified paths globs will be uploaded
   * to the specified Artifact Registry repository using the builder service
   * account's credentials.
   *
   * If any artifacts fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloudbuild.v1.Artifacts.MavenArtifact> getMavenArtifactsList() {
    return mavenArtifacts_;
  }
  /**
   *
   *
   * <pre>
   * A list of Maven artifacts to be uploaded to Artifact Registry upon
   * successful completion of all build steps.
   *
   * Artifacts in the workspace matching specified paths globs will be uploaded
   * to the specified Artifact Registry repository using the builder service
   * account's credentials.
   *
   * If any artifacts fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloudbuild.v1.Artifacts.MavenArtifactOrBuilder>
      getMavenArtifactsOrBuilderList() {
    return mavenArtifacts_;
  }
  /**
   *
   *
   * <pre>
   * A list of Maven artifacts to be uploaded to Artifact Registry upon
   * successful completion of all build steps.
   *
   * Artifacts in the workspace matching specified paths globs will be uploaded
   * to the specified Artifact Registry repository using the builder service
   * account's credentials.
   *
   * If any artifacts fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
   * </code>
   */
  @java.lang.Override
  public int getMavenArtifactsCount() {
    return mavenArtifacts_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of Maven artifacts to be uploaded to Artifact Registry upon
   * successful completion of all build steps.
   *
   * Artifacts in the workspace matching specified paths globs will be uploaded
   * to the specified Artifact Registry repository using the builder service
   * account's credentials.
   *
   * If any artifacts fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Artifacts.MavenArtifact getMavenArtifacts(int index) {
    return mavenArtifacts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of Maven artifacts to be uploaded to Artifact Registry upon
   * successful completion of all build steps.
   *
   * Artifacts in the workspace matching specified paths globs will be uploaded
   * to the specified Artifact Registry repository using the builder service
   * account's credentials.
   *
   * If any artifacts fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Artifacts.MavenArtifactOrBuilder getMavenArtifactsOrBuilder(
      int index) {
    return mavenArtifacts_.get(index);
  }

  public static final int GO_MODULES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloudbuild.v1.Artifacts.GoModule> goModules_;
  /**
   *
   *
   * <pre>
   * Optional. A list of Go modules to be uploaded to Artifact Registry upon
   * successful completion of all build steps.
   *
   * If any objects fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>
   * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloudbuild.v1.Artifacts.GoModule> getGoModulesList() {
    return goModules_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of Go modules to be uploaded to Artifact Registry upon
   * successful completion of all build steps.
   *
   * If any objects fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>
   * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloudbuild.v1.Artifacts.GoModuleOrBuilder>
      getGoModulesOrBuilderList() {
    return goModules_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of Go modules to be uploaded to Artifact Registry upon
   * successful completion of all build steps.
   *
   * If any objects fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>
   * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getGoModulesCount() {
    return goModules_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of Go modules to be uploaded to Artifact Registry upon
   * successful completion of all build steps.
   *
   * If any objects fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>
   * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Artifacts.GoModule getGoModules(int index) {
    return goModules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of Go modules to be uploaded to Artifact Registry upon
   * successful completion of all build steps.
   *
   * If any objects fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>
   * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Artifacts.GoModuleOrBuilder getGoModulesOrBuilder(int index) {
    return goModules_.get(index);
  }

  public static final int PYTHON_PACKAGES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloudbuild.v1.Artifacts.PythonPackage> pythonPackages_;
  /**
   *
   *
   * <pre>
   * A list of Python packages to be uploaded to Artifact Registry upon
   * successful completion of all build steps.
   *
   * The build service account credentials will be used to perform the upload.
   *
   * If any objects fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloudbuild.v1.Artifacts.PythonPackage> getPythonPackagesList() {
    return pythonPackages_;
  }
  /**
   *
   *
   * <pre>
   * A list of Python packages to be uploaded to Artifact Registry upon
   * successful completion of all build steps.
   *
   * The build service account credentials will be used to perform the upload.
   *
   * If any objects fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloudbuild.v1.Artifacts.PythonPackageOrBuilder>
      getPythonPackagesOrBuilderList() {
    return pythonPackages_;
  }
  /**
   *
   *
   * <pre>
   * A list of Python packages to be uploaded to Artifact Registry upon
   * successful completion of all build steps.
   *
   * The build service account credentials will be used to perform the upload.
   *
   * If any objects fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
   * </code>
   */
  @java.lang.Override
  public int getPythonPackagesCount() {
    return pythonPackages_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of Python packages to be uploaded to Artifact Registry upon
   * successful completion of all build steps.
   *
   * The build service account credentials will be used to perform the upload.
   *
   * If any objects fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Artifacts.PythonPackage getPythonPackages(int index) {
    return pythonPackages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of Python packages to be uploaded to Artifact Registry upon
   * successful completion of all build steps.
   *
   * The build service account credentials will be used to perform the upload.
   *
   * If any objects fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Artifacts.PythonPackageOrBuilder getPythonPackagesOrBuilder(
      int index) {
    return pythonPackages_.get(index);
  }

  public static final int NPM_PACKAGES_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloudbuild.v1.Artifacts.NpmPackage> npmPackages_;
  /**
   *
   *
   * <pre>
   * A list of npm packages to be uploaded to Artifact Registry upon
   * successful completion of all build steps.
   *
   * Npm packages in the specified paths will be uploaded
   * to the specified Artifact Registry repository using the builder service
   * account's credentials.
   *
   * If any packages fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloudbuild.v1.Artifacts.NpmPackage> getNpmPackagesList() {
    return npmPackages_;
  }
  /**
   *
   *
   * <pre>
   * A list of npm packages to be uploaded to Artifact Registry upon
   * successful completion of all build steps.
   *
   * Npm packages in the specified paths will be uploaded
   * to the specified Artifact Registry repository using the builder service
   * account's credentials.
   *
   * If any packages fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloudbuild.v1.Artifacts.NpmPackageOrBuilder>
      getNpmPackagesOrBuilderList() {
    return npmPackages_;
  }
  /**
   *
   *
   * <pre>
   * A list of npm packages to be uploaded to Artifact Registry upon
   * successful completion of all build steps.
   *
   * Npm packages in the specified paths will be uploaded
   * to the specified Artifact Registry repository using the builder service
   * account's credentials.
   *
   * If any packages fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
   */
  @java.lang.Override
  public int getNpmPackagesCount() {
    return npmPackages_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of npm packages to be uploaded to Artifact Registry upon
   * successful completion of all build steps.
   *
   * Npm packages in the specified paths will be uploaded
   * to the specified Artifact Registry repository using the builder service
   * account's credentials.
   *
   * If any packages fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Artifacts.NpmPackage getNpmPackages(int index) {
    return npmPackages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of npm packages to be uploaded to Artifact Registry upon
   * successful completion of all build steps.
   *
   * Npm packages in the specified paths will be uploaded
   * to the specified Artifact Registry repository using the builder service
   * account's credentials.
   *
   * If any packages fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Artifacts.NpmPackageOrBuilder getNpmPackagesOrBuilder(int index) {
    return npmPackages_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < images_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, images_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getObjects());
    }
    for (int i = 0; i < mavenArtifacts_.size(); i++) {
      output.writeMessage(3, mavenArtifacts_.get(i));
    }
    for (int i = 0; i < goModules_.size(); i++) {
      output.writeMessage(4, goModules_.get(i));
    }
    for (int i = 0; i < pythonPackages_.size(); i++) {
      output.writeMessage(5, pythonPackages_.get(i));
    }
    for (int i = 0; i < npmPackages_.size(); i++) {
      output.writeMessage(6, npmPackages_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < images_.size(); i++) {
        dataSize += computeStringSizeNoTag(images_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getImagesList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getObjects());
    }
    for (int i = 0; i < mavenArtifacts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, mavenArtifacts_.get(i));
    }
    for (int i = 0; i < goModules_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, goModules_.get(i));
    }
    for (int i = 0; i < pythonPackages_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, pythonPackages_.get(i));
    }
    for (int i = 0; i < npmPackages_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, npmPackages_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.Artifacts)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.Artifacts other = (com.google.cloudbuild.v1.Artifacts) obj;

    if (!getImagesList().equals(other.getImagesList())) return false;
    if (hasObjects() != other.hasObjects()) return false;
    if (hasObjects()) {
      if (!getObjects().equals(other.getObjects())) return false;
    }
    if (!getMavenArtifactsList().equals(other.getMavenArtifactsList())) return false;
    if (!getGoModulesList().equals(other.getGoModulesList())) return false;
    if (!getPythonPackagesList().equals(other.getPythonPackagesList())) return false;
    if (!getNpmPackagesList().equals(other.getNpmPackagesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getImagesCount() > 0) {
      hash = (37 * hash) + IMAGES_FIELD_NUMBER;
      hash = (53 * hash) + getImagesList().hashCode();
    }
    if (hasObjects()) {
      hash = (37 * hash) + OBJECTS_FIELD_NUMBER;
      hash = (53 * hash) + getObjects().hashCode();
    }
    if (getMavenArtifactsCount() > 0) {
      hash = (37 * hash) + MAVEN_ARTIFACTS_FIELD_NUMBER;
      hash = (53 * hash) + getMavenArtifactsList().hashCode();
    }
    if (getGoModulesCount() > 0) {
      hash = (37 * hash) + GO_MODULES_FIELD_NUMBER;
      hash = (53 * hash) + getGoModulesList().hashCode();
    }
    if (getPythonPackagesCount() > 0) {
      hash = (37 * hash) + PYTHON_PACKAGES_FIELD_NUMBER;
      hash = (53 * hash) + getPythonPackagesList().hashCode();
    }
    if (getNpmPackagesCount() > 0) {
      hash = (37 * hash) + NPM_PACKAGES_FIELD_NUMBER;
      hash = (53 * hash) + getNpmPackagesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.Artifacts parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.Artifacts parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Artifacts parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.Artifacts parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Artifacts parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.Artifacts parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Artifacts parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.Artifacts parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Artifacts parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.Artifacts parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Artifacts parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.Artifacts parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.Artifacts prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Artifacts produced by a build that should be uploaded upon
   * successful completion of all build steps.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.Artifacts}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.Artifacts)
      com.google.cloudbuild.v1.ArtifactsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Artifacts_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Artifacts_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.Artifacts.class,
              com.google.cloudbuild.v1.Artifacts.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.Artifacts.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getObjectsFieldBuilder();
        getMavenArtifactsFieldBuilder();
        getGoModulesFieldBuilder();
        getPythonPackagesFieldBuilder();
        getNpmPackagesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      images_ = com.google.protobuf.LazyStringArrayList.emptyList();
      objects_ = null;
      if (objectsBuilder_ != null) {
        objectsBuilder_.dispose();
        objectsBuilder_ = null;
      }
      if (mavenArtifactsBuilder_ == null) {
        mavenArtifacts_ = java.util.Collections.emptyList();
      } else {
        mavenArtifacts_ = null;
        mavenArtifactsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (goModulesBuilder_ == null) {
        goModules_ = java.util.Collections.emptyList();
      } else {
        goModules_ = null;
        goModulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (pythonPackagesBuilder_ == null) {
        pythonPackages_ = java.util.Collections.emptyList();
      } else {
        pythonPackages_ = null;
        pythonPackagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (npmPackagesBuilder_ == null) {
        npmPackages_ = java.util.Collections.emptyList();
      } else {
        npmPackages_ = null;
        npmPackagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Artifacts_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Artifacts getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.Artifacts.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Artifacts build() {
      com.google.cloudbuild.v1.Artifacts result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Artifacts buildPartial() {
      com.google.cloudbuild.v1.Artifacts result = new com.google.cloudbuild.v1.Artifacts(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloudbuild.v1.Artifacts result) {
      if (mavenArtifactsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          mavenArtifacts_ = java.util.Collections.unmodifiableList(mavenArtifacts_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.mavenArtifacts_ = mavenArtifacts_;
      } else {
        result.mavenArtifacts_ = mavenArtifactsBuilder_.build();
      }
      if (goModulesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          goModules_ = java.util.Collections.unmodifiableList(goModules_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.goModules_ = goModules_;
      } else {
        result.goModules_ = goModulesBuilder_.build();
      }
      if (pythonPackagesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          pythonPackages_ = java.util.Collections.unmodifiableList(pythonPackages_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.pythonPackages_ = pythonPackages_;
      } else {
        result.pythonPackages_ = pythonPackagesBuilder_.build();
      }
      if (npmPackagesBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          npmPackages_ = java.util.Collections.unmodifiableList(npmPackages_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.npmPackages_ = npmPackages_;
      } else {
        result.npmPackages_ = npmPackagesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloudbuild.v1.Artifacts result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        images_.makeImmutable();
        result.images_ = images_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.objects_ = objectsBuilder_ == null ? objects_ : objectsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.Artifacts) {
        return mergeFrom((com.google.cloudbuild.v1.Artifacts) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.Artifacts other) {
      if (other == com.google.cloudbuild.v1.Artifacts.getDefaultInstance()) return this;
      if (!other.images_.isEmpty()) {
        if (images_.isEmpty()) {
          images_ = other.images_;
          bitField0_ |= 0x00000001;
        } else {
          ensureImagesIsMutable();
          images_.addAll(other.images_);
        }
        onChanged();
      }
      if (other.hasObjects()) {
        mergeObjects(other.getObjects());
      }
      if (mavenArtifactsBuilder_ == null) {
        if (!other.mavenArtifacts_.isEmpty()) {
          if (mavenArtifacts_.isEmpty()) {
            mavenArtifacts_ = other.mavenArtifacts_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureMavenArtifactsIsMutable();
            mavenArtifacts_.addAll(other.mavenArtifacts_);
          }
          onChanged();
        }
      } else {
        if (!other.mavenArtifacts_.isEmpty()) {
          if (mavenArtifactsBuilder_.isEmpty()) {
            mavenArtifactsBuilder_.dispose();
            mavenArtifactsBuilder_ = null;
            mavenArtifacts_ = other.mavenArtifacts_;
            bitField0_ = (bitField0_ & ~0x00000004);
            mavenArtifactsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMavenArtifactsFieldBuilder()
                    : null;
          } else {
            mavenArtifactsBuilder_.addAllMessages(other.mavenArtifacts_);
          }
        }
      }
      if (goModulesBuilder_ == null) {
        if (!other.goModules_.isEmpty()) {
          if (goModules_.isEmpty()) {
            goModules_ = other.goModules_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureGoModulesIsMutable();
            goModules_.addAll(other.goModules_);
          }
          onChanged();
        }
      } else {
        if (!other.goModules_.isEmpty()) {
          if (goModulesBuilder_.isEmpty()) {
            goModulesBuilder_.dispose();
            goModulesBuilder_ = null;
            goModules_ = other.goModules_;
            bitField0_ = (bitField0_ & ~0x00000008);
            goModulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGoModulesFieldBuilder()
                    : null;
          } else {
            goModulesBuilder_.addAllMessages(other.goModules_);
          }
        }
      }
      if (pythonPackagesBuilder_ == null) {
        if (!other.pythonPackages_.isEmpty()) {
          if (pythonPackages_.isEmpty()) {
            pythonPackages_ = other.pythonPackages_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensurePythonPackagesIsMutable();
            pythonPackages_.addAll(other.pythonPackages_);
          }
          onChanged();
        }
      } else {
        if (!other.pythonPackages_.isEmpty()) {
          if (pythonPackagesBuilder_.isEmpty()) {
            pythonPackagesBuilder_.dispose();
            pythonPackagesBuilder_ = null;
            pythonPackages_ = other.pythonPackages_;
            bitField0_ = (bitField0_ & ~0x00000010);
            pythonPackagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPythonPackagesFieldBuilder()
                    : null;
          } else {
            pythonPackagesBuilder_.addAllMessages(other.pythonPackages_);
          }
        }
      }
      if (npmPackagesBuilder_ == null) {
        if (!other.npmPackages_.isEmpty()) {
          if (npmPackages_.isEmpty()) {
            npmPackages_ = other.npmPackages_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureNpmPackagesIsMutable();
            npmPackages_.addAll(other.npmPackages_);
          }
          onChanged();
        }
      } else {
        if (!other.npmPackages_.isEmpty()) {
          if (npmPackagesBuilder_.isEmpty()) {
            npmPackagesBuilder_.dispose();
            npmPackagesBuilder_ = null;
            npmPackages_ = other.npmPackages_;
            bitField0_ = (bitField0_ & ~0x00000020);
            npmPackagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNpmPackagesFieldBuilder()
                    : null;
          } else {
            npmPackagesBuilder_.addAllMessages(other.npmPackages_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureImagesIsMutable();
                images_.add(s);
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getObjectsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloudbuild.v1.Artifacts.MavenArtifact m =
                    input.readMessage(
                        com.google.cloudbuild.v1.Artifacts.MavenArtifact.parser(),
                        extensionRegistry);
                if (mavenArtifactsBuilder_ == null) {
                  ensureMavenArtifactsIsMutable();
                  mavenArtifacts_.add(m);
                } else {
                  mavenArtifactsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                com.google.cloudbuild.v1.Artifacts.GoModule m =
                    input.readMessage(
                        com.google.cloudbuild.v1.Artifacts.GoModule.parser(), extensionRegistry);
                if (goModulesBuilder_ == null) {
                  ensureGoModulesIsMutable();
                  goModules_.add(m);
                } else {
                  goModulesBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                com.google.cloudbuild.v1.Artifacts.PythonPackage m =
                    input.readMessage(
                        com.google.cloudbuild.v1.Artifacts.PythonPackage.parser(),
                        extensionRegistry);
                if (pythonPackagesBuilder_ == null) {
                  ensurePythonPackagesIsMutable();
                  pythonPackages_.add(m);
                } else {
                  pythonPackagesBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                com.google.cloudbuild.v1.Artifacts.NpmPackage m =
                    input.readMessage(
                        com.google.cloudbuild.v1.Artifacts.NpmPackage.parser(), extensionRegistry);
                if (npmPackagesBuilder_ == null) {
                  ensureNpmPackagesIsMutable();
                  npmPackages_.add(m);
                } else {
                  npmPackagesBuilder_.addMessage(m);
                }
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList images_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureImagesIsMutable() {
      if (!images_.isModifiable()) {
        images_ = new com.google.protobuf.LazyStringArrayList(images_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     *
     * The images will be pushed using the builder service account's credentials.
     *
     * The digests of the pushed images will be stored in the Build resource's
     * results field.
     *
     * If any of the images fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated string images = 1;</code>
     *
     * @return A list containing the images.
     */
    public com.google.protobuf.ProtocolStringList getImagesList() {
      images_.makeImmutable();
      return images_;
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     *
     * The images will be pushed using the builder service account's credentials.
     *
     * The digests of the pushed images will be stored in the Build resource's
     * results field.
     *
     * If any of the images fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated string images = 1;</code>
     *
     * @return The count of images.
     */
    public int getImagesCount() {
      return images_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     *
     * The images will be pushed using the builder service account's credentials.
     *
     * The digests of the pushed images will be stored in the Build resource's
     * results field.
     *
     * If any of the images fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated string images = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The images at the given index.
     */
    public java.lang.String getImages(int index) {
      return images_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     *
     * The images will be pushed using the builder service account's credentials.
     *
     * The digests of the pushed images will be stored in the Build resource's
     * results field.
     *
     * If any of the images fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated string images = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the images at the given index.
     */
    public com.google.protobuf.ByteString getImagesBytes(int index) {
      return images_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     *
     * The images will be pushed using the builder service account's credentials.
     *
     * The digests of the pushed images will be stored in the Build resource's
     * results field.
     *
     * If any of the images fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated string images = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The images to set.
     * @return This builder for chaining.
     */
    public Builder setImages(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureImagesIsMutable();
      images_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     *
     * The images will be pushed using the builder service account's credentials.
     *
     * The digests of the pushed images will be stored in the Build resource's
     * results field.
     *
     * If any of the images fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated string images = 1;</code>
     *
     * @param value The images to add.
     * @return This builder for chaining.
     */
    public Builder addImages(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureImagesIsMutable();
      images_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     *
     * The images will be pushed using the builder service account's credentials.
     *
     * The digests of the pushed images will be stored in the Build resource's
     * results field.
     *
     * If any of the images fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated string images = 1;</code>
     *
     * @param values The images to add.
     * @return This builder for chaining.
     */
    public Builder addAllImages(java.lang.Iterable<java.lang.String> values) {
      ensureImagesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, images_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     *
     * The images will be pushed using the builder service account's credentials.
     *
     * The digests of the pushed images will be stored in the Build resource's
     * results field.
     *
     * If any of the images fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated string images = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImages() {
      images_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     *
     * The images will be pushed using the builder service account's credentials.
     *
     * The digests of the pushed images will be stored in the Build resource's
     * results field.
     *
     * If any of the images fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated string images = 1;</code>
     *
     * @param value The bytes of the images to add.
     * @return This builder for chaining.
     */
    public Builder addImagesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureImagesIsMutable();
      images_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloudbuild.v1.Artifacts.ArtifactObjects objects_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Artifacts.ArtifactObjects,
            com.google.cloudbuild.v1.Artifacts.ArtifactObjects.Builder,
            com.google.cloudbuild.v1.Artifacts.ArtifactObjectsOrBuilder>
        objectsBuilder_;
    /**
     *
     *
     * <pre>
     * A list of objects to be uploaded to Cloud Storage upon successful
     * completion of all build steps.
     *
     * Files in the workspace matching specified paths globs will be uploaded to
     * the specified Cloud Storage location using the builder service account's
     * credentials.
     *
     * The location and generation of the uploaded objects will be stored in the
     * Build resource's results field.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
     *
     * @return Whether the objects field is set.
     */
    public boolean hasObjects() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * A list of objects to be uploaded to Cloud Storage upon successful
     * completion of all build steps.
     *
     * Files in the workspace matching specified paths globs will be uploaded to
     * the specified Cloud Storage location using the builder service account's
     * credentials.
     *
     * The location and generation of the uploaded objects will be stored in the
     * Build resource's results field.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
     *
     * @return The objects.
     */
    public com.google.cloudbuild.v1.Artifacts.ArtifactObjects getObjects() {
      if (objectsBuilder_ == null) {
        return objects_ == null
            ? com.google.cloudbuild.v1.Artifacts.ArtifactObjects.getDefaultInstance()
            : objects_;
      } else {
        return objectsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of objects to be uploaded to Cloud Storage upon successful
     * completion of all build steps.
     *
     * Files in the workspace matching specified paths globs will be uploaded to
     * the specified Cloud Storage location using the builder service account's
     * credentials.
     *
     * The location and generation of the uploaded objects will be stored in the
     * Build resource's results field.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
     */
    public Builder setObjects(com.google.cloudbuild.v1.Artifacts.ArtifactObjects value) {
      if (objectsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        objects_ = value;
      } else {
        objectsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of objects to be uploaded to Cloud Storage upon successful
     * completion of all build steps.
     *
     * Files in the workspace matching specified paths globs will be uploaded to
     * the specified Cloud Storage location using the builder service account's
     * credentials.
     *
     * The location and generation of the uploaded objects will be stored in the
     * Build resource's results field.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
     */
    public Builder setObjects(
        com.google.cloudbuild.v1.Artifacts.ArtifactObjects.Builder builderForValue) {
      if (objectsBuilder_ == null) {
        objects_ = builderForValue.build();
      } else {
        objectsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of objects to be uploaded to Cloud Storage upon successful
     * completion of all build steps.
     *
     * Files in the workspace matching specified paths globs will be uploaded to
     * the specified Cloud Storage location using the builder service account's
     * credentials.
     *
     * The location and generation of the uploaded objects will be stored in the
     * Build resource's results field.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
     */
    public Builder mergeObjects(com.google.cloudbuild.v1.Artifacts.ArtifactObjects value) {
      if (objectsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && objects_ != null
            && objects_
                != com.google.cloudbuild.v1.Artifacts.ArtifactObjects.getDefaultInstance()) {
          getObjectsBuilder().mergeFrom(value);
        } else {
          objects_ = value;
        }
      } else {
        objectsBuilder_.mergeFrom(value);
      }
      if (objects_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of objects to be uploaded to Cloud Storage upon successful
     * completion of all build steps.
     *
     * Files in the workspace matching specified paths globs will be uploaded to
     * the specified Cloud Storage location using the builder service account's
     * credentials.
     *
     * The location and generation of the uploaded objects will be stored in the
     * Build resource's results field.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
     */
    public Builder clearObjects() {
      bitField0_ = (bitField0_ & ~0x00000002);
      objects_ = null;
      if (objectsBuilder_ != null) {
        objectsBuilder_.dispose();
        objectsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of objects to be uploaded to Cloud Storage upon successful
     * completion of all build steps.
     *
     * Files in the workspace matching specified paths globs will be uploaded to
     * the specified Cloud Storage location using the builder service account's
     * credentials.
     *
     * The location and generation of the uploaded objects will be stored in the
     * Build resource's results field.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
     */
    public com.google.cloudbuild.v1.Artifacts.ArtifactObjects.Builder getObjectsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getObjectsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A list of objects to be uploaded to Cloud Storage upon successful
     * completion of all build steps.
     *
     * Files in the workspace matching specified paths globs will be uploaded to
     * the specified Cloud Storage location using the builder service account's
     * credentials.
     *
     * The location and generation of the uploaded objects will be stored in the
     * Build resource's results field.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
     */
    public com.google.cloudbuild.v1.Artifacts.ArtifactObjectsOrBuilder getObjectsOrBuilder() {
      if (objectsBuilder_ != null) {
        return objectsBuilder_.getMessageOrBuilder();
      } else {
        return objects_ == null
            ? com.google.cloudbuild.v1.Artifacts.ArtifactObjects.getDefaultInstance()
            : objects_;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of objects to be uploaded to Cloud Storage upon successful
     * completion of all build steps.
     *
     * Files in the workspace matching specified paths globs will be uploaded to
     * the specified Cloud Storage location using the builder service account's
     * credentials.
     *
     * The location and generation of the uploaded objects will be stored in the
     * Build resource's results field.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Artifacts.ArtifactObjects,
            com.google.cloudbuild.v1.Artifacts.ArtifactObjects.Builder,
            com.google.cloudbuild.v1.Artifacts.ArtifactObjectsOrBuilder>
        getObjectsFieldBuilder() {
      if (objectsBuilder_ == null) {
        objectsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.Artifacts.ArtifactObjects,
                com.google.cloudbuild.v1.Artifacts.ArtifactObjects.Builder,
                com.google.cloudbuild.v1.Artifacts.ArtifactObjectsOrBuilder>(
                getObjects(), getParentForChildren(), isClean());
        objects_ = null;
      }
      return objectsBuilder_;
    }

    private java.util.List<com.google.cloudbuild.v1.Artifacts.MavenArtifact> mavenArtifacts_ =
        java.util.Collections.emptyList();

    private void ensureMavenArtifactsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        mavenArtifacts_ =
            new java.util.ArrayList<com.google.cloudbuild.v1.Artifacts.MavenArtifact>(
                mavenArtifacts_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.Artifacts.MavenArtifact,
            com.google.cloudbuild.v1.Artifacts.MavenArtifact.Builder,
            com.google.cloudbuild.v1.Artifacts.MavenArtifactOrBuilder>
        mavenArtifactsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of Maven artifacts to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Artifacts in the workspace matching specified paths globs will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any artifacts fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
     * </code>
     */
    public java.util.List<com.google.cloudbuild.v1.Artifacts.MavenArtifact>
        getMavenArtifactsList() {
      if (mavenArtifactsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(mavenArtifacts_);
      } else {
        return mavenArtifactsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Maven artifacts to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Artifacts in the workspace matching specified paths globs will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any artifacts fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
     * </code>
     */
    public int getMavenArtifactsCount() {
      if (mavenArtifactsBuilder_ == null) {
        return mavenArtifacts_.size();
      } else {
        return mavenArtifactsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Maven artifacts to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Artifacts in the workspace matching specified paths globs will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any artifacts fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
     * </code>
     */
    public com.google.cloudbuild.v1.Artifacts.MavenArtifact getMavenArtifacts(int index) {
      if (mavenArtifactsBuilder_ == null) {
        return mavenArtifacts_.get(index);
      } else {
        return mavenArtifactsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Maven artifacts to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Artifacts in the workspace matching specified paths globs will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any artifacts fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
     * </code>
     */
    public Builder setMavenArtifacts(
        int index, com.google.cloudbuild.v1.Artifacts.MavenArtifact value) {
      if (mavenArtifactsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMavenArtifactsIsMutable();
        mavenArtifacts_.set(index, value);
        onChanged();
      } else {
        mavenArtifactsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Maven artifacts to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Artifacts in the workspace matching specified paths globs will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any artifacts fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
     * </code>
     */
    public Builder setMavenArtifacts(
        int index, com.google.cloudbuild.v1.Artifacts.MavenArtifact.Builder builderForValue) {
      if (mavenArtifactsBuilder_ == null) {
        ensureMavenArtifactsIsMutable();
        mavenArtifacts_.set(index, builderForValue.build());
        onChanged();
      } else {
        mavenArtifactsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Maven artifacts to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Artifacts in the workspace matching specified paths globs will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any artifacts fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
     * </code>
     */
    public Builder addMavenArtifacts(com.google.cloudbuild.v1.Artifacts.MavenArtifact value) {
      if (mavenArtifactsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMavenArtifactsIsMutable();
        mavenArtifacts_.add(value);
        onChanged();
      } else {
        mavenArtifactsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Maven artifacts to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Artifacts in the workspace matching specified paths globs will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any artifacts fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
     * </code>
     */
    public Builder addMavenArtifacts(
        int index, com.google.cloudbuild.v1.Artifacts.MavenArtifact value) {
      if (mavenArtifactsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMavenArtifactsIsMutable();
        mavenArtifacts_.add(index, value);
        onChanged();
      } else {
        mavenArtifactsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Maven artifacts to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Artifacts in the workspace matching specified paths globs will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any artifacts fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
     * </code>
     */
    public Builder addMavenArtifacts(
        com.google.cloudbuild.v1.Artifacts.MavenArtifact.Builder builderForValue) {
      if (mavenArtifactsBuilder_ == null) {
        ensureMavenArtifactsIsMutable();
        mavenArtifacts_.add(builderForValue.build());
        onChanged();
      } else {
        mavenArtifactsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Maven artifacts to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Artifacts in the workspace matching specified paths globs will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any artifacts fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
     * </code>
     */
    public Builder addMavenArtifacts(
        int index, com.google.cloudbuild.v1.Artifacts.MavenArtifact.Builder builderForValue) {
      if (mavenArtifactsBuilder_ == null) {
        ensureMavenArtifactsIsMutable();
        mavenArtifacts_.add(index, builderForValue.build());
        onChanged();
      } else {
        mavenArtifactsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Maven artifacts to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Artifacts in the workspace matching specified paths globs will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any artifacts fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
     * </code>
     */
    public Builder addAllMavenArtifacts(
        java.lang.Iterable<? extends com.google.cloudbuild.v1.Artifacts.MavenArtifact> values) {
      if (mavenArtifactsBuilder_ == null) {
        ensureMavenArtifactsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, mavenArtifacts_);
        onChanged();
      } else {
        mavenArtifactsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Maven artifacts to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Artifacts in the workspace matching specified paths globs will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any artifacts fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
     * </code>
     */
    public Builder clearMavenArtifacts() {
      if (mavenArtifactsBuilder_ == null) {
        mavenArtifacts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        mavenArtifactsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Maven artifacts to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Artifacts in the workspace matching specified paths globs will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any artifacts fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
     * </code>
     */
    public Builder removeMavenArtifacts(int index) {
      if (mavenArtifactsBuilder_ == null) {
        ensureMavenArtifactsIsMutable();
        mavenArtifacts_.remove(index);
        onChanged();
      } else {
        mavenArtifactsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Maven artifacts to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Artifacts in the workspace matching specified paths globs will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any artifacts fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
     * </code>
     */
    public com.google.cloudbuild.v1.Artifacts.MavenArtifact.Builder getMavenArtifactsBuilder(
        int index) {
      return getMavenArtifactsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of Maven artifacts to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Artifacts in the workspace matching specified paths globs will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any artifacts fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
     * </code>
     */
    public com.google.cloudbuild.v1.Artifacts.MavenArtifactOrBuilder getMavenArtifactsOrBuilder(
        int index) {
      if (mavenArtifactsBuilder_ == null) {
        return mavenArtifacts_.get(index);
      } else {
        return mavenArtifactsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Maven artifacts to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Artifacts in the workspace matching specified paths globs will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any artifacts fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
     * </code>
     */
    public java.util.List<? extends com.google.cloudbuild.v1.Artifacts.MavenArtifactOrBuilder>
        getMavenArtifactsOrBuilderList() {
      if (mavenArtifactsBuilder_ != null) {
        return mavenArtifactsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(mavenArtifacts_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Maven artifacts to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Artifacts in the workspace matching specified paths globs will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any artifacts fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
     * </code>
     */
    public com.google.cloudbuild.v1.Artifacts.MavenArtifact.Builder addMavenArtifactsBuilder() {
      return getMavenArtifactsFieldBuilder()
          .addBuilder(com.google.cloudbuild.v1.Artifacts.MavenArtifact.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of Maven artifacts to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Artifacts in the workspace matching specified paths globs will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any artifacts fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
     * </code>
     */
    public com.google.cloudbuild.v1.Artifacts.MavenArtifact.Builder addMavenArtifactsBuilder(
        int index) {
      return getMavenArtifactsFieldBuilder()
          .addBuilder(index, com.google.cloudbuild.v1.Artifacts.MavenArtifact.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of Maven artifacts to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Artifacts in the workspace matching specified paths globs will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any artifacts fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;
     * </code>
     */
    public java.util.List<com.google.cloudbuild.v1.Artifacts.MavenArtifact.Builder>
        getMavenArtifactsBuilderList() {
      return getMavenArtifactsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.Artifacts.MavenArtifact,
            com.google.cloudbuild.v1.Artifacts.MavenArtifact.Builder,
            com.google.cloudbuild.v1.Artifacts.MavenArtifactOrBuilder>
        getMavenArtifactsFieldBuilder() {
      if (mavenArtifactsBuilder_ == null) {
        mavenArtifactsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloudbuild.v1.Artifacts.MavenArtifact,
                com.google.cloudbuild.v1.Artifacts.MavenArtifact.Builder,
                com.google.cloudbuild.v1.Artifacts.MavenArtifactOrBuilder>(
                mavenArtifacts_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        mavenArtifacts_ = null;
      }
      return mavenArtifactsBuilder_;
    }

    private java.util.List<com.google.cloudbuild.v1.Artifacts.GoModule> goModules_ =
        java.util.Collections.emptyList();

    private void ensureGoModulesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        goModules_ =
            new java.util.ArrayList<com.google.cloudbuild.v1.Artifacts.GoModule>(goModules_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.Artifacts.GoModule,
            com.google.cloudbuild.v1.Artifacts.GoModule.Builder,
            com.google.cloudbuild.v1.Artifacts.GoModuleOrBuilder>
        goModulesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A list of Go modules to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloudbuild.v1.Artifacts.GoModule> getGoModulesList() {
      if (goModulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(goModules_);
      } else {
        return goModulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of Go modules to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getGoModulesCount() {
      if (goModulesBuilder_ == null) {
        return goModules_.size();
      } else {
        return goModulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of Go modules to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloudbuild.v1.Artifacts.GoModule getGoModules(int index) {
      if (goModulesBuilder_ == null) {
        return goModules_.get(index);
      } else {
        return goModulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of Go modules to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGoModules(int index, com.google.cloudbuild.v1.Artifacts.GoModule value) {
      if (goModulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGoModulesIsMutable();
        goModules_.set(index, value);
        onChanged();
      } else {
        goModulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of Go modules to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGoModules(
        int index, com.google.cloudbuild.v1.Artifacts.GoModule.Builder builderForValue) {
      if (goModulesBuilder_ == null) {
        ensureGoModulesIsMutable();
        goModules_.set(index, builderForValue.build());
        onChanged();
      } else {
        goModulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of Go modules to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addGoModules(com.google.cloudbuild.v1.Artifacts.GoModule value) {
      if (goModulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGoModulesIsMutable();
        goModules_.add(value);
        onChanged();
      } else {
        goModulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of Go modules to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addGoModules(int index, com.google.cloudbuild.v1.Artifacts.GoModule value) {
      if (goModulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGoModulesIsMutable();
        goModules_.add(index, value);
        onChanged();
      } else {
        goModulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of Go modules to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addGoModules(
        com.google.cloudbuild.v1.Artifacts.GoModule.Builder builderForValue) {
      if (goModulesBuilder_ == null) {
        ensureGoModulesIsMutable();
        goModules_.add(builderForValue.build());
        onChanged();
      } else {
        goModulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of Go modules to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addGoModules(
        int index, com.google.cloudbuild.v1.Artifacts.GoModule.Builder builderForValue) {
      if (goModulesBuilder_ == null) {
        ensureGoModulesIsMutable();
        goModules_.add(index, builderForValue.build());
        onChanged();
      } else {
        goModulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of Go modules to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllGoModules(
        java.lang.Iterable<? extends com.google.cloudbuild.v1.Artifacts.GoModule> values) {
      if (goModulesBuilder_ == null) {
        ensureGoModulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, goModules_);
        onChanged();
      } else {
        goModulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of Go modules to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGoModules() {
      if (goModulesBuilder_ == null) {
        goModules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        goModulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of Go modules to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeGoModules(int index) {
      if (goModulesBuilder_ == null) {
        ensureGoModulesIsMutable();
        goModules_.remove(index);
        onChanged();
      } else {
        goModulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of Go modules to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloudbuild.v1.Artifacts.GoModule.Builder getGoModulesBuilder(int index) {
      return getGoModulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of Go modules to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloudbuild.v1.Artifacts.GoModuleOrBuilder getGoModulesOrBuilder(int index) {
      if (goModulesBuilder_ == null) {
        return goModules_.get(index);
      } else {
        return goModulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of Go modules to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloudbuild.v1.Artifacts.GoModuleOrBuilder>
        getGoModulesOrBuilderList() {
      if (goModulesBuilder_ != null) {
        return goModulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(goModules_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of Go modules to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloudbuild.v1.Artifacts.GoModule.Builder addGoModulesBuilder() {
      return getGoModulesFieldBuilder()
          .addBuilder(com.google.cloudbuild.v1.Artifacts.GoModule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of Go modules to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloudbuild.v1.Artifacts.GoModule.Builder addGoModulesBuilder(int index) {
      return getGoModulesFieldBuilder()
          .addBuilder(index, com.google.cloudbuild.v1.Artifacts.GoModule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of Go modules to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Artifacts.GoModule go_modules = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloudbuild.v1.Artifacts.GoModule.Builder>
        getGoModulesBuilderList() {
      return getGoModulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.Artifacts.GoModule,
            com.google.cloudbuild.v1.Artifacts.GoModule.Builder,
            com.google.cloudbuild.v1.Artifacts.GoModuleOrBuilder>
        getGoModulesFieldBuilder() {
      if (goModulesBuilder_ == null) {
        goModulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloudbuild.v1.Artifacts.GoModule,
                com.google.cloudbuild.v1.Artifacts.GoModule.Builder,
                com.google.cloudbuild.v1.Artifacts.GoModuleOrBuilder>(
                goModules_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        goModules_ = null;
      }
      return goModulesBuilder_;
    }

    private java.util.List<com.google.cloudbuild.v1.Artifacts.PythonPackage> pythonPackages_ =
        java.util.Collections.emptyList();

    private void ensurePythonPackagesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        pythonPackages_ =
            new java.util.ArrayList<com.google.cloudbuild.v1.Artifacts.PythonPackage>(
                pythonPackages_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.Artifacts.PythonPackage,
            com.google.cloudbuild.v1.Artifacts.PythonPackage.Builder,
            com.google.cloudbuild.v1.Artifacts.PythonPackageOrBuilder>
        pythonPackagesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of Python packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * The build service account credentials will be used to perform the upload.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
     * </code>
     */
    public java.util.List<com.google.cloudbuild.v1.Artifacts.PythonPackage>
        getPythonPackagesList() {
      if (pythonPackagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(pythonPackages_);
      } else {
        return pythonPackagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Python packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * The build service account credentials will be used to perform the upload.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
     * </code>
     */
    public int getPythonPackagesCount() {
      if (pythonPackagesBuilder_ == null) {
        return pythonPackages_.size();
      } else {
        return pythonPackagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Python packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * The build service account credentials will be used to perform the upload.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
     * </code>
     */
    public com.google.cloudbuild.v1.Artifacts.PythonPackage getPythonPackages(int index) {
      if (pythonPackagesBuilder_ == null) {
        return pythonPackages_.get(index);
      } else {
        return pythonPackagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Python packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * The build service account credentials will be used to perform the upload.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
     * </code>
     */
    public Builder setPythonPackages(
        int index, com.google.cloudbuild.v1.Artifacts.PythonPackage value) {
      if (pythonPackagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePythonPackagesIsMutable();
        pythonPackages_.set(index, value);
        onChanged();
      } else {
        pythonPackagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Python packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * The build service account credentials will be used to perform the upload.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
     * </code>
     */
    public Builder setPythonPackages(
        int index, com.google.cloudbuild.v1.Artifacts.PythonPackage.Builder builderForValue) {
      if (pythonPackagesBuilder_ == null) {
        ensurePythonPackagesIsMutable();
        pythonPackages_.set(index, builderForValue.build());
        onChanged();
      } else {
        pythonPackagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Python packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * The build service account credentials will be used to perform the upload.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
     * </code>
     */
    public Builder addPythonPackages(com.google.cloudbuild.v1.Artifacts.PythonPackage value) {
      if (pythonPackagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePythonPackagesIsMutable();
        pythonPackages_.add(value);
        onChanged();
      } else {
        pythonPackagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Python packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * The build service account credentials will be used to perform the upload.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
     * </code>
     */
    public Builder addPythonPackages(
        int index, com.google.cloudbuild.v1.Artifacts.PythonPackage value) {
      if (pythonPackagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePythonPackagesIsMutable();
        pythonPackages_.add(index, value);
        onChanged();
      } else {
        pythonPackagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Python packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * The build service account credentials will be used to perform the upload.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
     * </code>
     */
    public Builder addPythonPackages(
        com.google.cloudbuild.v1.Artifacts.PythonPackage.Builder builderForValue) {
      if (pythonPackagesBuilder_ == null) {
        ensurePythonPackagesIsMutable();
        pythonPackages_.add(builderForValue.build());
        onChanged();
      } else {
        pythonPackagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Python packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * The build service account credentials will be used to perform the upload.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
     * </code>
     */
    public Builder addPythonPackages(
        int index, com.google.cloudbuild.v1.Artifacts.PythonPackage.Builder builderForValue) {
      if (pythonPackagesBuilder_ == null) {
        ensurePythonPackagesIsMutable();
        pythonPackages_.add(index, builderForValue.build());
        onChanged();
      } else {
        pythonPackagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Python packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * The build service account credentials will be used to perform the upload.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
     * </code>
     */
    public Builder addAllPythonPackages(
        java.lang.Iterable<? extends com.google.cloudbuild.v1.Artifacts.PythonPackage> values) {
      if (pythonPackagesBuilder_ == null) {
        ensurePythonPackagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pythonPackages_);
        onChanged();
      } else {
        pythonPackagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Python packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * The build service account credentials will be used to perform the upload.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
     * </code>
     */
    public Builder clearPythonPackages() {
      if (pythonPackagesBuilder_ == null) {
        pythonPackages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        pythonPackagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Python packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * The build service account credentials will be used to perform the upload.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
     * </code>
     */
    public Builder removePythonPackages(int index) {
      if (pythonPackagesBuilder_ == null) {
        ensurePythonPackagesIsMutable();
        pythonPackages_.remove(index);
        onChanged();
      } else {
        pythonPackagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Python packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * The build service account credentials will be used to perform the upload.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
     * </code>
     */
    public com.google.cloudbuild.v1.Artifacts.PythonPackage.Builder getPythonPackagesBuilder(
        int index) {
      return getPythonPackagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of Python packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * The build service account credentials will be used to perform the upload.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
     * </code>
     */
    public com.google.cloudbuild.v1.Artifacts.PythonPackageOrBuilder getPythonPackagesOrBuilder(
        int index) {
      if (pythonPackagesBuilder_ == null) {
        return pythonPackages_.get(index);
      } else {
        return pythonPackagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Python packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * The build service account credentials will be used to perform the upload.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
     * </code>
     */
    public java.util.List<? extends com.google.cloudbuild.v1.Artifacts.PythonPackageOrBuilder>
        getPythonPackagesOrBuilderList() {
      if (pythonPackagesBuilder_ != null) {
        return pythonPackagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(pythonPackages_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Python packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * The build service account credentials will be used to perform the upload.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
     * </code>
     */
    public com.google.cloudbuild.v1.Artifacts.PythonPackage.Builder addPythonPackagesBuilder() {
      return getPythonPackagesFieldBuilder()
          .addBuilder(com.google.cloudbuild.v1.Artifacts.PythonPackage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of Python packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * The build service account credentials will be used to perform the upload.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
     * </code>
     */
    public com.google.cloudbuild.v1.Artifacts.PythonPackage.Builder addPythonPackagesBuilder(
        int index) {
      return getPythonPackagesFieldBuilder()
          .addBuilder(index, com.google.cloudbuild.v1.Artifacts.PythonPackage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of Python packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * The build service account credentials will be used to perform the upload.
     *
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;
     * </code>
     */
    public java.util.List<com.google.cloudbuild.v1.Artifacts.PythonPackage.Builder>
        getPythonPackagesBuilderList() {
      return getPythonPackagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.Artifacts.PythonPackage,
            com.google.cloudbuild.v1.Artifacts.PythonPackage.Builder,
            com.google.cloudbuild.v1.Artifacts.PythonPackageOrBuilder>
        getPythonPackagesFieldBuilder() {
      if (pythonPackagesBuilder_ == null) {
        pythonPackagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloudbuild.v1.Artifacts.PythonPackage,
                com.google.cloudbuild.v1.Artifacts.PythonPackage.Builder,
                com.google.cloudbuild.v1.Artifacts.PythonPackageOrBuilder>(
                pythonPackages_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        pythonPackages_ = null;
      }
      return pythonPackagesBuilder_;
    }

    private java.util.List<com.google.cloudbuild.v1.Artifacts.NpmPackage> npmPackages_ =
        java.util.Collections.emptyList();

    private void ensureNpmPackagesIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        npmPackages_ =
            new java.util.ArrayList<com.google.cloudbuild.v1.Artifacts.NpmPackage>(npmPackages_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.Artifacts.NpmPackage,
            com.google.cloudbuild.v1.Artifacts.NpmPackage.Builder,
            com.google.cloudbuild.v1.Artifacts.NpmPackageOrBuilder>
        npmPackagesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of npm packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Npm packages in the specified paths will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any packages fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.Artifacts.NpmPackage> getNpmPackagesList() {
      if (npmPackagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(npmPackages_);
      } else {
        return npmPackagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of npm packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Npm packages in the specified paths will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any packages fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
     */
    public int getNpmPackagesCount() {
      if (npmPackagesBuilder_ == null) {
        return npmPackages_.size();
      } else {
        return npmPackagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of npm packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Npm packages in the specified paths will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any packages fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
     */
    public com.google.cloudbuild.v1.Artifacts.NpmPackage getNpmPackages(int index) {
      if (npmPackagesBuilder_ == null) {
        return npmPackages_.get(index);
      } else {
        return npmPackagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of npm packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Npm packages in the specified paths will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any packages fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
     */
    public Builder setNpmPackages(int index, com.google.cloudbuild.v1.Artifacts.NpmPackage value) {
      if (npmPackagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNpmPackagesIsMutable();
        npmPackages_.set(index, value);
        onChanged();
      } else {
        npmPackagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of npm packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Npm packages in the specified paths will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any packages fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
     */
    public Builder setNpmPackages(
        int index, com.google.cloudbuild.v1.Artifacts.NpmPackage.Builder builderForValue) {
      if (npmPackagesBuilder_ == null) {
        ensureNpmPackagesIsMutable();
        npmPackages_.set(index, builderForValue.build());
        onChanged();
      } else {
        npmPackagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of npm packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Npm packages in the specified paths will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any packages fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
     */
    public Builder addNpmPackages(com.google.cloudbuild.v1.Artifacts.NpmPackage value) {
      if (npmPackagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNpmPackagesIsMutable();
        npmPackages_.add(value);
        onChanged();
      } else {
        npmPackagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of npm packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Npm packages in the specified paths will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any packages fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
     */
    public Builder addNpmPackages(int index, com.google.cloudbuild.v1.Artifacts.NpmPackage value) {
      if (npmPackagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNpmPackagesIsMutable();
        npmPackages_.add(index, value);
        onChanged();
      } else {
        npmPackagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of npm packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Npm packages in the specified paths will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any packages fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
     */
    public Builder addNpmPackages(
        com.google.cloudbuild.v1.Artifacts.NpmPackage.Builder builderForValue) {
      if (npmPackagesBuilder_ == null) {
        ensureNpmPackagesIsMutable();
        npmPackages_.add(builderForValue.build());
        onChanged();
      } else {
        npmPackagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of npm packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Npm packages in the specified paths will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any packages fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
     */
    public Builder addNpmPackages(
        int index, com.google.cloudbuild.v1.Artifacts.NpmPackage.Builder builderForValue) {
      if (npmPackagesBuilder_ == null) {
        ensureNpmPackagesIsMutable();
        npmPackages_.add(index, builderForValue.build());
        onChanged();
      } else {
        npmPackagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of npm packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Npm packages in the specified paths will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any packages fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
     */
    public Builder addAllNpmPackages(
        java.lang.Iterable<? extends com.google.cloudbuild.v1.Artifacts.NpmPackage> values) {
      if (npmPackagesBuilder_ == null) {
        ensureNpmPackagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, npmPackages_);
        onChanged();
      } else {
        npmPackagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of npm packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Npm packages in the specified paths will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any packages fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
     */
    public Builder clearNpmPackages() {
      if (npmPackagesBuilder_ == null) {
        npmPackages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        npmPackagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of npm packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Npm packages in the specified paths will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any packages fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
     */
    public Builder removeNpmPackages(int index) {
      if (npmPackagesBuilder_ == null) {
        ensureNpmPackagesIsMutable();
        npmPackages_.remove(index);
        onChanged();
      } else {
        npmPackagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of npm packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Npm packages in the specified paths will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any packages fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
     */
    public com.google.cloudbuild.v1.Artifacts.NpmPackage.Builder getNpmPackagesBuilder(int index) {
      return getNpmPackagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of npm packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Npm packages in the specified paths will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any packages fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
     */
    public com.google.cloudbuild.v1.Artifacts.NpmPackageOrBuilder getNpmPackagesOrBuilder(
        int index) {
      if (npmPackagesBuilder_ == null) {
        return npmPackages_.get(index);
      } else {
        return npmPackagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of npm packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Npm packages in the specified paths will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any packages fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
     */
    public java.util.List<? extends com.google.cloudbuild.v1.Artifacts.NpmPackageOrBuilder>
        getNpmPackagesOrBuilderList() {
      if (npmPackagesBuilder_ != null) {
        return npmPackagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(npmPackages_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of npm packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Npm packages in the specified paths will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any packages fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
     */
    public com.google.cloudbuild.v1.Artifacts.NpmPackage.Builder addNpmPackagesBuilder() {
      return getNpmPackagesFieldBuilder()
          .addBuilder(com.google.cloudbuild.v1.Artifacts.NpmPackage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of npm packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Npm packages in the specified paths will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any packages fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
     */
    public com.google.cloudbuild.v1.Artifacts.NpmPackage.Builder addNpmPackagesBuilder(int index) {
      return getNpmPackagesFieldBuilder()
          .addBuilder(index, com.google.cloudbuild.v1.Artifacts.NpmPackage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of npm packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     *
     * Npm packages in the specified paths will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     *
     * If any packages fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.Artifacts.NpmPackage.Builder>
        getNpmPackagesBuilderList() {
      return getNpmPackagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.Artifacts.NpmPackage,
            com.google.cloudbuild.v1.Artifacts.NpmPackage.Builder,
            com.google.cloudbuild.v1.Artifacts.NpmPackageOrBuilder>
        getNpmPackagesFieldBuilder() {
      if (npmPackagesBuilder_ == null) {
        npmPackagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloudbuild.v1.Artifacts.NpmPackage,
                com.google.cloudbuild.v1.Artifacts.NpmPackage.Builder,
                com.google.cloudbuild.v1.Artifacts.NpmPackageOrBuilder>(
                npmPackages_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        npmPackages_ = null;
      }
      return npmPackagesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.Artifacts)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.Artifacts)
  private static final com.google.cloudbuild.v1.Artifacts DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.Artifacts();
  }

  public static com.google.cloudbuild.v1.Artifacts getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Artifacts> PARSER =
      new com.google.protobuf.AbstractParser<Artifacts>() {
        @java.lang.Override
        public Artifacts parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Artifacts> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Artifacts> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.Artifacts getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
