/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

// Protobuf Java Version: 3.25.5
package com.google.cloudbuild.v1;

/**
 *
 *
 * <pre>
 * Configuration for an automated build in response to source repository
 * changes.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v1.BuildTrigger}
 */
public final class BuildTrigger extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.BuildTrigger)
    BuildTriggerOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BuildTrigger.newBuilder() to construct.
  private BuildTrigger(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BuildTrigger() {
    resourceName_ = "";
    id_ = "";
    description_ = "";
    name_ = "";
    tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
    ignoredFiles_ = com.google.protobuf.LazyStringArrayList.emptyList();
    includedFiles_ = com.google.protobuf.LazyStringArrayList.emptyList();
    filter_ = "";
    serviceAccount_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BuildTrigger();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_BuildTrigger_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 11:
        return internalGetSubstitutions();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_BuildTrigger_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.BuildTrigger.class,
            com.google.cloudbuild.v1.BuildTrigger.Builder.class);
  }

  private int bitField0_;
  private int buildTemplateCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object buildTemplate_;

  public enum BuildTemplateCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AUTODETECT(18),
    BUILD(4),
    FILENAME(8),
    GIT_FILE_SOURCE(24),
    BUILDTEMPLATE_NOT_SET(0);
    private final int value;

    private BuildTemplateCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BuildTemplateCase valueOf(int value) {
      return forNumber(value);
    }

    public static BuildTemplateCase forNumber(int value) {
      switch (value) {
        case 18:
          return AUTODETECT;
        case 4:
          return BUILD;
        case 8:
          return FILENAME;
        case 24:
          return GIT_FILE_SOURCE;
        case 0:
          return BUILDTEMPLATE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public BuildTemplateCase getBuildTemplateCase() {
    return BuildTemplateCase.forNumber(buildTemplateCase_);
  }

  public static final int RESOURCE_NAME_FIELD_NUMBER = 34;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceName_ = "";
  /**
   *
   *
   * <pre>
   * The `Trigger` name with format:
   * `projects/{project}/locations/{location}/triggers/{trigger}`, where
   * {trigger} is a unique identifier generated by the service.
   * </pre>
   *
   * <code>string resource_name = 34;</code>
   *
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The `Trigger` name with format:
   * `projects/{project}/locations/{location}/triggers/{trigger}`, where
   * {trigger} is a unique identifier generated by the service.
   * </pre>
   *
   * <code>string resource_name = 34;</code>
   *
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the trigger.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the trigger.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Human-readable description of this trigger.
   * </pre>
   *
   * <code>string description = 10;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Human-readable description of this trigger.
   * </pre>
   *
   * <code>string description = 10;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 21;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * User-assigned name of the trigger. Must be unique within the project.
   * Trigger names must meet the following requirements:
   *
   * + They must contain only alphanumeric characters and dashes.
   * + They can be 1-64 characters long.
   * + They must begin and end with an alphanumeric character.
   * </pre>
   *
   * <code>string name = 21;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User-assigned name of the trigger. Must be unique within the project.
   * Trigger names must meet the following requirements:
   *
   * + They must contain only alphanumeric characters and dashes.
   * + They can be 1-64 characters long.
   * + They must begin and end with an alphanumeric character.
   * </pre>
   *
   * <code>string name = 21;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TAGS_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList tags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Tags for annotation of a `BuildTrigger`
   * </pre>
   *
   * <code>repeated string tags = 19;</code>
   *
   * @return A list containing the tags.
   */
  public com.google.protobuf.ProtocolStringList getTagsList() {
    return tags_;
  }
  /**
   *
   *
   * <pre>
   * Tags for annotation of a `BuildTrigger`
   * </pre>
   *
   * <code>repeated string tags = 19;</code>
   *
   * @return The count of tags.
   */
  public int getTagsCount() {
    return tags_.size();
  }
  /**
   *
   *
   * <pre>
   * Tags for annotation of a `BuildTrigger`
   * </pre>
   *
   * <code>repeated string tags = 19;</code>
   *
   * @param index The index of the element to return.
   * @return The tags at the given index.
   */
  public java.lang.String getTags(int index) {
    return tags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Tags for annotation of a `BuildTrigger`
   * </pre>
   *
   * <code>repeated string tags = 19;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tags at the given index.
   */
  public com.google.protobuf.ByteString getTagsBytes(int index) {
    return tags_.getByteString(index);
  }

  public static final int TRIGGER_TEMPLATE_FIELD_NUMBER = 7;
  private com.google.cloudbuild.v1.RepoSource triggerTemplate_;
  /**
   *
   *
   * <pre>
   * Template describing the types of source changes to trigger a build.
   *
   * Branch and tag names in trigger templates are interpreted as regular
   * expressions. Any branch or tag change that matches that regular expression
   * will trigger a build.
   *
   * Mutually exclusive with `github`.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
   *
   * @return Whether the triggerTemplate field is set.
   */
  @java.lang.Override
  public boolean hasTriggerTemplate() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Template describing the types of source changes to trigger a build.
   *
   * Branch and tag names in trigger templates are interpreted as regular
   * expressions. Any branch or tag change that matches that regular expression
   * will trigger a build.
   *
   * Mutually exclusive with `github`.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
   *
   * @return The triggerTemplate.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.RepoSource getTriggerTemplate() {
    return triggerTemplate_ == null
        ? com.google.cloudbuild.v1.RepoSource.getDefaultInstance()
        : triggerTemplate_;
  }
  /**
   *
   *
   * <pre>
   * Template describing the types of source changes to trigger a build.
   *
   * Branch and tag names in trigger templates are interpreted as regular
   * expressions. Any branch or tag change that matches that regular expression
   * will trigger a build.
   *
   * Mutually exclusive with `github`.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.RepoSourceOrBuilder getTriggerTemplateOrBuilder() {
    return triggerTemplate_ == null
        ? com.google.cloudbuild.v1.RepoSource.getDefaultInstance()
        : triggerTemplate_;
  }

  public static final int GITHUB_FIELD_NUMBER = 13;
  private com.google.cloudbuild.v1.GitHubEventsConfig github_;
  /**
   *
   *
   * <pre>
   * GitHubEventsConfig describes the configuration of a trigger that creates
   * a build whenever a GitHub event is received.
   *
   * Mutually exclusive with `trigger_template`.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
   *
   * @return Whether the github field is set.
   */
  @java.lang.Override
  public boolean hasGithub() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * GitHubEventsConfig describes the configuration of a trigger that creates
   * a build whenever a GitHub event is received.
   *
   * Mutually exclusive with `trigger_template`.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
   *
   * @return The github.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.GitHubEventsConfig getGithub() {
    return github_ == null
        ? com.google.cloudbuild.v1.GitHubEventsConfig.getDefaultInstance()
        : github_;
  }
  /**
   *
   *
   * <pre>
   * GitHubEventsConfig describes the configuration of a trigger that creates
   * a build whenever a GitHub event is received.
   *
   * Mutually exclusive with `trigger_template`.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.GitHubEventsConfigOrBuilder getGithubOrBuilder() {
    return github_ == null
        ? com.google.cloudbuild.v1.GitHubEventsConfig.getDefaultInstance()
        : github_;
  }

  public static final int PUBSUB_CONFIG_FIELD_NUMBER = 29;
  private com.google.cloudbuild.v1.PubsubConfig pubsubConfig_;
  /**
   *
   *
   * <pre>
   * PubsubConfig describes the configuration of a trigger that
   * creates a build whenever a Pub/Sub message is published.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.PubsubConfig pubsub_config = 29;</code>
   *
   * @return Whether the pubsubConfig field is set.
   */
  @java.lang.Override
  public boolean hasPubsubConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * PubsubConfig describes the configuration of a trigger that
   * creates a build whenever a Pub/Sub message is published.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.PubsubConfig pubsub_config = 29;</code>
   *
   * @return The pubsubConfig.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.PubsubConfig getPubsubConfig() {
    return pubsubConfig_ == null
        ? com.google.cloudbuild.v1.PubsubConfig.getDefaultInstance()
        : pubsubConfig_;
  }
  /**
   *
   *
   * <pre>
   * PubsubConfig describes the configuration of a trigger that
   * creates a build whenever a Pub/Sub message is published.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.PubsubConfig pubsub_config = 29;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.PubsubConfigOrBuilder getPubsubConfigOrBuilder() {
    return pubsubConfig_ == null
        ? com.google.cloudbuild.v1.PubsubConfig.getDefaultInstance()
        : pubsubConfig_;
  }

  public static final int WEBHOOK_CONFIG_FIELD_NUMBER = 31;
  private com.google.cloudbuild.v1.WebhookConfig webhookConfig_;
  /**
   *
   *
   * <pre>
   * WebhookConfig describes the configuration of a trigger that
   * creates a build whenever a webhook is sent to a trigger's webhook URL.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.WebhookConfig webhook_config = 31;</code>
   *
   * @return Whether the webhookConfig field is set.
   */
  @java.lang.Override
  public boolean hasWebhookConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * WebhookConfig describes the configuration of a trigger that
   * creates a build whenever a webhook is sent to a trigger's webhook URL.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.WebhookConfig webhook_config = 31;</code>
   *
   * @return The webhookConfig.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.WebhookConfig getWebhookConfig() {
    return webhookConfig_ == null
        ? com.google.cloudbuild.v1.WebhookConfig.getDefaultInstance()
        : webhookConfig_;
  }
  /**
   *
   *
   * <pre>
   * WebhookConfig describes the configuration of a trigger that
   * creates a build whenever a webhook is sent to a trigger's webhook URL.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.WebhookConfig webhook_config = 31;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.WebhookConfigOrBuilder getWebhookConfigOrBuilder() {
    return webhookConfig_ == null
        ? com.google.cloudbuild.v1.WebhookConfig.getDefaultInstance()
        : webhookConfig_;
  }

  public static final int AUTODETECT_FIELD_NUMBER = 18;
  /**
   *
   *
   * <pre>
   * Autodetect build configuration.  The following precedence is used (case
   * insensitive):
   *
   * 1. cloudbuild.yaml
   * 2. cloudbuild.yml
   * 3. cloudbuild.json
   * 4. Dockerfile
   *
   * Currently only available for GitHub App Triggers.
   * </pre>
   *
   * <code>bool autodetect = 18;</code>
   *
   * @return Whether the autodetect field is set.
   */
  @java.lang.Override
  public boolean hasAutodetect() {
    return buildTemplateCase_ == 18;
  }
  /**
   *
   *
   * <pre>
   * Autodetect build configuration.  The following precedence is used (case
   * insensitive):
   *
   * 1. cloudbuild.yaml
   * 2. cloudbuild.yml
   * 3. cloudbuild.json
   * 4. Dockerfile
   *
   * Currently only available for GitHub App Triggers.
   * </pre>
   *
   * <code>bool autodetect = 18;</code>
   *
   * @return The autodetect.
   */
  @java.lang.Override
  public boolean getAutodetect() {
    if (buildTemplateCase_ == 18) {
      return (java.lang.Boolean) buildTemplate_;
    }
    return false;
  }

  public static final int BUILD_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Contents of the build template.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
   *
   * @return Whether the build field is set.
   */
  @java.lang.Override
  public boolean hasBuild() {
    return buildTemplateCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Contents of the build template.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
   *
   * @return The build.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Build getBuild() {
    if (buildTemplateCase_ == 4) {
      return (com.google.cloudbuild.v1.Build) buildTemplate_;
    }
    return com.google.cloudbuild.v1.Build.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Contents of the build template.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.BuildOrBuilder getBuildOrBuilder() {
    if (buildTemplateCase_ == 4) {
      return (com.google.cloudbuild.v1.Build) buildTemplate_;
    }
    return com.google.cloudbuild.v1.Build.getDefaultInstance();
  }

  public static final int FILENAME_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Path, from the source root, to the build configuration file
   * (i.e. cloudbuild.yaml).
   * </pre>
   *
   * <code>string filename = 8;</code>
   *
   * @return Whether the filename field is set.
   */
  public boolean hasFilename() {
    return buildTemplateCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Path, from the source root, to the build configuration file
   * (i.e. cloudbuild.yaml).
   * </pre>
   *
   * <code>string filename = 8;</code>
   *
   * @return The filename.
   */
  public java.lang.String getFilename() {
    java.lang.Object ref = "";
    if (buildTemplateCase_ == 8) {
      ref = buildTemplate_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (buildTemplateCase_ == 8) {
        buildTemplate_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Path, from the source root, to the build configuration file
   * (i.e. cloudbuild.yaml).
   * </pre>
   *
   * <code>string filename = 8;</code>
   *
   * @return The bytes for filename.
   */
  public com.google.protobuf.ByteString getFilenameBytes() {
    java.lang.Object ref = "";
    if (buildTemplateCase_ == 8) {
      ref = buildTemplate_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (buildTemplateCase_ == 8) {
        buildTemplate_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GIT_FILE_SOURCE_FIELD_NUMBER = 24;
  /**
   *
   *
   * <pre>
   * The file source describing the local or remote Build template.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.GitFileSource git_file_source = 24;</code>
   *
   * @return Whether the gitFileSource field is set.
   */
  @java.lang.Override
  public boolean hasGitFileSource() {
    return buildTemplateCase_ == 24;
  }
  /**
   *
   *
   * <pre>
   * The file source describing the local or remote Build template.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.GitFileSource git_file_source = 24;</code>
   *
   * @return The gitFileSource.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.GitFileSource getGitFileSource() {
    if (buildTemplateCase_ == 24) {
      return (com.google.cloudbuild.v1.GitFileSource) buildTemplate_;
    }
    return com.google.cloudbuild.v1.GitFileSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The file source describing the local or remote Build template.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.GitFileSource git_file_source = 24;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.GitFileSourceOrBuilder getGitFileSourceOrBuilder() {
    if (buildTemplateCase_ == 24) {
      return (com.google.cloudbuild.v1.GitFileSource) buildTemplate_;
    }
    return com.google.cloudbuild.v1.GitFileSource.getDefaultInstance();
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the trigger was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the trigger was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the trigger was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int DISABLED_FIELD_NUMBER = 9;
  private boolean disabled_ = false;
  /**
   *
   *
   * <pre>
   * If true, the trigger will never automatically execute a build.
   * </pre>
   *
   * <code>bool disabled = 9;</code>
   *
   * @return The disabled.
   */
  @java.lang.Override
  public boolean getDisabled() {
    return disabled_;
  }

  public static final int SUBSTITUTIONS_FIELD_NUMBER = 11;

  private static final class SubstitutionsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloudbuild.v1.Cloudbuild
                .internal_static_google_devtools_cloudbuild_v1_BuildTrigger_SubstitutionsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> substitutions_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetSubstitutions() {
    if (substitutions_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          SubstitutionsDefaultEntryHolder.defaultEntry);
    }
    return substitutions_;
  }

  public int getSubstitutionsCount() {
    return internalGetSubstitutions().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Substitutions for Build resource. The keys must match the following
   * regular expression: `^_[A-Z0-9_]+$`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; substitutions = 11;</code>
   */
  @java.lang.Override
  public boolean containsSubstitutions(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetSubstitutions().getMap().containsKey(key);
  }
  /** Use {@link #getSubstitutionsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getSubstitutions() {
    return getSubstitutionsMap();
  }
  /**
   *
   *
   * <pre>
   * Substitutions for Build resource. The keys must match the following
   * regular expression: `^_[A-Z0-9_]+$`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; substitutions = 11;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getSubstitutionsMap() {
    return internalGetSubstitutions().getMap();
  }
  /**
   *
   *
   * <pre>
   * Substitutions for Build resource. The keys must match the following
   * regular expression: `^_[A-Z0-9_]+$`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; substitutions = 11;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getSubstitutionsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetSubstitutions().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Substitutions for Build resource. The keys must match the following
   * regular expression: `^_[A-Z0-9_]+$`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; substitutions = 11;</code>
   */
  @java.lang.Override
  public java.lang.String getSubstitutionsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetSubstitutions().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int IGNORED_FILES_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList ignoredFiles_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * ignored_files and included_files are file glob matches using
   * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
   *
   * If ignored_files and changed files are both empty, then they are
   * not used to determine whether or not to trigger a build.
   *
   * If ignored_files is not empty, then we ignore any files that match
   * any of the ignored_file globs. If the change has no files that are
   * outside of the ignored_files globs, then we do not trigger a build.
   * </pre>
   *
   * <code>repeated string ignored_files = 15;</code>
   *
   * @return A list containing the ignoredFiles.
   */
  public com.google.protobuf.ProtocolStringList getIgnoredFilesList() {
    return ignoredFiles_;
  }
  /**
   *
   *
   * <pre>
   * ignored_files and included_files are file glob matches using
   * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
   *
   * If ignored_files and changed files are both empty, then they are
   * not used to determine whether or not to trigger a build.
   *
   * If ignored_files is not empty, then we ignore any files that match
   * any of the ignored_file globs. If the change has no files that are
   * outside of the ignored_files globs, then we do not trigger a build.
   * </pre>
   *
   * <code>repeated string ignored_files = 15;</code>
   *
   * @return The count of ignoredFiles.
   */
  public int getIgnoredFilesCount() {
    return ignoredFiles_.size();
  }
  /**
   *
   *
   * <pre>
   * ignored_files and included_files are file glob matches using
   * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
   *
   * If ignored_files and changed files are both empty, then they are
   * not used to determine whether or not to trigger a build.
   *
   * If ignored_files is not empty, then we ignore any files that match
   * any of the ignored_file globs. If the change has no files that are
   * outside of the ignored_files globs, then we do not trigger a build.
   * </pre>
   *
   * <code>repeated string ignored_files = 15;</code>
   *
   * @param index The index of the element to return.
   * @return The ignoredFiles at the given index.
   */
  public java.lang.String getIgnoredFiles(int index) {
    return ignoredFiles_.get(index);
  }
  /**
   *
   *
   * <pre>
   * ignored_files and included_files are file glob matches using
   * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
   *
   * If ignored_files and changed files are both empty, then they are
   * not used to determine whether or not to trigger a build.
   *
   * If ignored_files is not empty, then we ignore any files that match
   * any of the ignored_file globs. If the change has no files that are
   * outside of the ignored_files globs, then we do not trigger a build.
   * </pre>
   *
   * <code>repeated string ignored_files = 15;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the ignoredFiles at the given index.
   */
  public com.google.protobuf.ByteString getIgnoredFilesBytes(int index) {
    return ignoredFiles_.getByteString(index);
  }

  public static final int INCLUDED_FILES_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList includedFiles_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * If any of the files altered in the commit pass the ignored_files
   * filter and included_files is empty, then as far as this filter is
   * concerned, we should trigger the build.
   *
   * If any of the files altered in the commit pass the ignored_files
   * filter and included_files is not empty, then we make sure that at
   * least one of those files matches a included_files glob. If not,
   * then we do not trigger a build.
   * </pre>
   *
   * <code>repeated string included_files = 16;</code>
   *
   * @return A list containing the includedFiles.
   */
  public com.google.protobuf.ProtocolStringList getIncludedFilesList() {
    return includedFiles_;
  }
  /**
   *
   *
   * <pre>
   * If any of the files altered in the commit pass the ignored_files
   * filter and included_files is empty, then as far as this filter is
   * concerned, we should trigger the build.
   *
   * If any of the files altered in the commit pass the ignored_files
   * filter and included_files is not empty, then we make sure that at
   * least one of those files matches a included_files glob. If not,
   * then we do not trigger a build.
   * </pre>
   *
   * <code>repeated string included_files = 16;</code>
   *
   * @return The count of includedFiles.
   */
  public int getIncludedFilesCount() {
    return includedFiles_.size();
  }
  /**
   *
   *
   * <pre>
   * If any of the files altered in the commit pass the ignored_files
   * filter and included_files is empty, then as far as this filter is
   * concerned, we should trigger the build.
   *
   * If any of the files altered in the commit pass the ignored_files
   * filter and included_files is not empty, then we make sure that at
   * least one of those files matches a included_files glob. If not,
   * then we do not trigger a build.
   * </pre>
   *
   * <code>repeated string included_files = 16;</code>
   *
   * @param index The index of the element to return.
   * @return The includedFiles at the given index.
   */
  public java.lang.String getIncludedFiles(int index) {
    return includedFiles_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If any of the files altered in the commit pass the ignored_files
   * filter and included_files is empty, then as far as this filter is
   * concerned, we should trigger the build.
   *
   * If any of the files altered in the commit pass the ignored_files
   * filter and included_files is not empty, then we make sure that at
   * least one of those files matches a included_files glob. If not,
   * then we do not trigger a build.
   * </pre>
   *
   * <code>repeated string included_files = 16;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the includedFiles at the given index.
   */
  public com.google.protobuf.ByteString getIncludedFilesBytes(int index) {
    return includedFiles_.getByteString(index);
  }

  public static final int FILTER_FIELD_NUMBER = 30;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A Common Expression Language string.
   * </pre>
   *
   * <code>string filter = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A Common Expression Language string.
   * </pre>
   *
   * <code>string filter = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_TO_BUILD_FIELD_NUMBER = 26;
  private com.google.cloudbuild.v1.GitRepoSource sourceToBuild_;
  /**
   *
   *
   * <pre>
   * The repo and ref of the repository from which to build. This field
   * is used only for those triggers that do not respond to SCM events.
   * Triggers that respond to such events build source at whatever commit
   * caused the event.
   * This field is currently only used by Webhook, Pub/Sub, Manual, and Cron
   * triggers.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.GitRepoSource source_to_build = 26;</code>
   *
   * @return Whether the sourceToBuild field is set.
   */
  @java.lang.Override
  public boolean hasSourceToBuild() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * The repo and ref of the repository from which to build. This field
   * is used only for those triggers that do not respond to SCM events.
   * Triggers that respond to such events build source at whatever commit
   * caused the event.
   * This field is currently only used by Webhook, Pub/Sub, Manual, and Cron
   * triggers.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.GitRepoSource source_to_build = 26;</code>
   *
   * @return The sourceToBuild.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.GitRepoSource getSourceToBuild() {
    return sourceToBuild_ == null
        ? com.google.cloudbuild.v1.GitRepoSource.getDefaultInstance()
        : sourceToBuild_;
  }
  /**
   *
   *
   * <pre>
   * The repo and ref of the repository from which to build. This field
   * is used only for those triggers that do not respond to SCM events.
   * Triggers that respond to such events build source at whatever commit
   * caused the event.
   * This field is currently only used by Webhook, Pub/Sub, Manual, and Cron
   * triggers.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.GitRepoSource source_to_build = 26;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.GitRepoSourceOrBuilder getSourceToBuildOrBuilder() {
    return sourceToBuild_ == null
        ? com.google.cloudbuild.v1.GitRepoSource.getDefaultInstance()
        : sourceToBuild_;
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 33;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * The service account used for all user-controlled operations including
   * UpdateBuildTrigger, RunBuildTrigger, CreateBuild, and CancelBuild.
   * If no service account is set, then the standard Cloud Build service account
   * ([PROJECT_NUM]&#64;system.gserviceaccount.com) will be used instead.
   * Format: `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_ID_OR_EMAIL}`
   * </pre>
   *
   * <code>string service_account = 33 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The service account used for all user-controlled operations including
   * UpdateBuildTrigger, RunBuildTrigger, CreateBuild, and CancelBuild.
   * If no service account is set, then the standard Cloud Build service account
   * ([PROJECT_NUM]&#64;system.gserviceaccount.com) will be used instead.
   * Format: `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_ID_OR_EMAIL}`
   * </pre>
   *
   * <code>string service_account = 33 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REPOSITORY_EVENT_CONFIG_FIELD_NUMBER = 39;
  private com.google.cloudbuild.v1.RepositoryEventConfig repositoryEventConfig_;
  /**
   *
   *
   * <pre>
   * The configuration of a trigger that creates a build whenever an event from
   * Repo API is received.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.RepositoryEventConfig repository_event_config = 39;</code>
   *
   * @return Whether the repositoryEventConfig field is set.
   */
  @java.lang.Override
  public boolean hasRepositoryEventConfig() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * The configuration of a trigger that creates a build whenever an event from
   * Repo API is received.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.RepositoryEventConfig repository_event_config = 39;</code>
   *
   * @return The repositoryEventConfig.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.RepositoryEventConfig getRepositoryEventConfig() {
    return repositoryEventConfig_ == null
        ? com.google.cloudbuild.v1.RepositoryEventConfig.getDefaultInstance()
        : repositoryEventConfig_;
  }
  /**
   *
   *
   * <pre>
   * The configuration of a trigger that creates a build whenever an event from
   * Repo API is received.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.RepositoryEventConfig repository_event_config = 39;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.RepositoryEventConfigOrBuilder
      getRepositoryEventConfigOrBuilder() {
    return repositoryEventConfig_ == null
        ? com.google.cloudbuild.v1.RepositoryEventConfig.getDefaultInstance()
        : repositoryEventConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (buildTemplateCase_ == 4) {
      output.writeMessage(4, (com.google.cloudbuild.v1.Build) buildTemplate_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getTriggerTemplate());
    }
    if (buildTemplateCase_ == 8) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, buildTemplate_);
    }
    if (disabled_ != false) {
      output.writeBool(9, disabled_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, description_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetSubstitutions(), SubstitutionsDefaultEntryHolder.defaultEntry, 11);
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(13, getGithub());
    }
    for (int i = 0; i < ignoredFiles_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, ignoredFiles_.getRaw(i));
    }
    for (int i = 0; i < includedFiles_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, includedFiles_.getRaw(i));
    }
    if (buildTemplateCase_ == 18) {
      output.writeBool(18, (boolean) ((java.lang.Boolean) buildTemplate_));
    }
    for (int i = 0; i < tags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, tags_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 21, name_);
    }
    if (buildTemplateCase_ == 24) {
      output.writeMessage(24, (com.google.cloudbuild.v1.GitFileSource) buildTemplate_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(26, getSourceToBuild());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(29, getPubsubConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30, filter_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(31, getWebhookConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 33, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 34, resourceName_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(39, getRepositoryEventConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (buildTemplateCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloudbuild.v1.Build) buildTemplate_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getTriggerTemplate());
    }
    if (buildTemplateCase_ == 8) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, buildTemplate_);
    }
    if (disabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, disabled_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, description_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetSubstitutions().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> substitutions__ =
          SubstitutionsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, substitutions__);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getGithub());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < ignoredFiles_.size(); i++) {
        dataSize += computeStringSizeNoTag(ignoredFiles_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getIgnoredFilesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < includedFiles_.size(); i++) {
        dataSize += computeStringSizeNoTag(includedFiles_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getIncludedFilesList().size();
    }
    if (buildTemplateCase_ == 18) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              18, (boolean) ((java.lang.Boolean) buildTemplate_));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < tags_.size(); i++) {
        dataSize += computeStringSizeNoTag(tags_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getTagsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(21, name_);
    }
    if (buildTemplateCase_ == 24) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              24, (com.google.cloudbuild.v1.GitFileSource) buildTemplate_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(26, getSourceToBuild());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(29, getPubsubConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(30, filter_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(31, getWebhookConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(33, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(34, resourceName_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(39, getRepositoryEventConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.BuildTrigger)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.BuildTrigger other = (com.google.cloudbuild.v1.BuildTrigger) obj;

    if (!getResourceName().equals(other.getResourceName())) return false;
    if (!getId().equals(other.getId())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getName().equals(other.getName())) return false;
    if (!getTagsList().equals(other.getTagsList())) return false;
    if (hasTriggerTemplate() != other.hasTriggerTemplate()) return false;
    if (hasTriggerTemplate()) {
      if (!getTriggerTemplate().equals(other.getTriggerTemplate())) return false;
    }
    if (hasGithub() != other.hasGithub()) return false;
    if (hasGithub()) {
      if (!getGithub().equals(other.getGithub())) return false;
    }
    if (hasPubsubConfig() != other.hasPubsubConfig()) return false;
    if (hasPubsubConfig()) {
      if (!getPubsubConfig().equals(other.getPubsubConfig())) return false;
    }
    if (hasWebhookConfig() != other.hasWebhookConfig()) return false;
    if (hasWebhookConfig()) {
      if (!getWebhookConfig().equals(other.getWebhookConfig())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (getDisabled() != other.getDisabled()) return false;
    if (!internalGetSubstitutions().equals(other.internalGetSubstitutions())) return false;
    if (!getIgnoredFilesList().equals(other.getIgnoredFilesList())) return false;
    if (!getIncludedFilesList().equals(other.getIncludedFilesList())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (hasSourceToBuild() != other.hasSourceToBuild()) return false;
    if (hasSourceToBuild()) {
      if (!getSourceToBuild().equals(other.getSourceToBuild())) return false;
    }
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (hasRepositoryEventConfig() != other.hasRepositoryEventConfig()) return false;
    if (hasRepositoryEventConfig()) {
      if (!getRepositoryEventConfig().equals(other.getRepositoryEventConfig())) return false;
    }
    if (!getBuildTemplateCase().equals(other.getBuildTemplateCase())) return false;
    switch (buildTemplateCase_) {
      case 18:
        if (getAutodetect() != other.getAutodetect()) return false;
        break;
      case 4:
        if (!getBuild().equals(other.getBuild())) return false;
        break;
      case 8:
        if (!getFilename().equals(other.getFilename())) return false;
        break;
      case 24:
        if (!getGitFileSource().equals(other.getGitFileSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getTagsCount() > 0) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTagsList().hashCode();
    }
    if (hasTriggerTemplate()) {
      hash = (37 * hash) + TRIGGER_TEMPLATE_FIELD_NUMBER;
      hash = (53 * hash) + getTriggerTemplate().hashCode();
    }
    if (hasGithub()) {
      hash = (37 * hash) + GITHUB_FIELD_NUMBER;
      hash = (53 * hash) + getGithub().hashCode();
    }
    if (hasPubsubConfig()) {
      hash = (37 * hash) + PUBSUB_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPubsubConfig().hashCode();
    }
    if (hasWebhookConfig()) {
      hash = (37 * hash) + WEBHOOK_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getWebhookConfig().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + DISABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
    if (!internalGetSubstitutions().getMap().isEmpty()) {
      hash = (37 * hash) + SUBSTITUTIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetSubstitutions().hashCode();
    }
    if (getIgnoredFilesCount() > 0) {
      hash = (37 * hash) + IGNORED_FILES_FIELD_NUMBER;
      hash = (53 * hash) + getIgnoredFilesList().hashCode();
    }
    if (getIncludedFilesCount() > 0) {
      hash = (37 * hash) + INCLUDED_FILES_FIELD_NUMBER;
      hash = (53 * hash) + getIncludedFilesList().hashCode();
    }
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    if (hasSourceToBuild()) {
      hash = (37 * hash) + SOURCE_TO_BUILD_FIELD_NUMBER;
      hash = (53 * hash) + getSourceToBuild().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    if (hasRepositoryEventConfig()) {
      hash = (37 * hash) + REPOSITORY_EVENT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRepositoryEventConfig().hashCode();
    }
    switch (buildTemplateCase_) {
      case 18:
        hash = (37 * hash) + AUTODETECT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAutodetect());
        break;
      case 4:
        hash = (37 * hash) + BUILD_FIELD_NUMBER;
        hash = (53 * hash) + getBuild().hashCode();
        break;
      case 8:
        hash = (37 * hash) + FILENAME_FIELD_NUMBER;
        hash = (53 * hash) + getFilename().hashCode();
        break;
      case 24:
        hash = (37 * hash) + GIT_FILE_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGitFileSource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.BuildTrigger prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for an automated build in response to source repository
   * changes.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.BuildTrigger}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.BuildTrigger)
      com.google.cloudbuild.v1.BuildTriggerOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_BuildTrigger_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 11:
          return internalGetSubstitutions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 11:
          return internalGetMutableSubstitutions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_BuildTrigger_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.BuildTrigger.class,
              com.google.cloudbuild.v1.BuildTrigger.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.BuildTrigger.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTriggerTemplateFieldBuilder();
        getGithubFieldBuilder();
        getPubsubConfigFieldBuilder();
        getWebhookConfigFieldBuilder();
        getCreateTimeFieldBuilder();
        getSourceToBuildFieldBuilder();
        getRepositoryEventConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceName_ = "";
      id_ = "";
      description_ = "";
      name_ = "";
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      triggerTemplate_ = null;
      if (triggerTemplateBuilder_ != null) {
        triggerTemplateBuilder_.dispose();
        triggerTemplateBuilder_ = null;
      }
      github_ = null;
      if (githubBuilder_ != null) {
        githubBuilder_.dispose();
        githubBuilder_ = null;
      }
      pubsubConfig_ = null;
      if (pubsubConfigBuilder_ != null) {
        pubsubConfigBuilder_.dispose();
        pubsubConfigBuilder_ = null;
      }
      webhookConfig_ = null;
      if (webhookConfigBuilder_ != null) {
        webhookConfigBuilder_.dispose();
        webhookConfigBuilder_ = null;
      }
      if (buildBuilder_ != null) {
        buildBuilder_.clear();
      }
      if (gitFileSourceBuilder_ != null) {
        gitFileSourceBuilder_.clear();
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      disabled_ = false;
      internalGetMutableSubstitutions().clear();
      ignoredFiles_ = com.google.protobuf.LazyStringArrayList.emptyList();
      includedFiles_ = com.google.protobuf.LazyStringArrayList.emptyList();
      filter_ = "";
      sourceToBuild_ = null;
      if (sourceToBuildBuilder_ != null) {
        sourceToBuildBuilder_.dispose();
        sourceToBuildBuilder_ = null;
      }
      serviceAccount_ = "";
      repositoryEventConfig_ = null;
      if (repositoryEventConfigBuilder_ != null) {
        repositoryEventConfigBuilder_.dispose();
        repositoryEventConfigBuilder_ = null;
      }
      buildTemplateCase_ = 0;
      buildTemplate_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_BuildTrigger_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.BuildTrigger getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.BuildTrigger.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.BuildTrigger build() {
      com.google.cloudbuild.v1.BuildTrigger result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.BuildTrigger buildPartial() {
      com.google.cloudbuild.v1.BuildTrigger result =
          new com.google.cloudbuild.v1.BuildTrigger(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloudbuild.v1.BuildTrigger result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceName_ = resourceName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        tags_.makeImmutable();
        result.tags_ = tags_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.triggerTemplate_ =
            triggerTemplateBuilder_ == null ? triggerTemplate_ : triggerTemplateBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.github_ = githubBuilder_ == null ? github_ : githubBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.pubsubConfig_ =
            pubsubConfigBuilder_ == null ? pubsubConfig_ : pubsubConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.webhookConfig_ =
            webhookConfigBuilder_ == null ? webhookConfig_ : webhookConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.disabled_ = disabled_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.substitutions_ = internalGetSubstitutions();
        result.substitutions_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        ignoredFiles_.makeImmutable();
        result.ignoredFiles_ = ignoredFiles_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        includedFiles_.makeImmutable();
        result.includedFiles_ = includedFiles_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.sourceToBuild_ =
            sourceToBuildBuilder_ == null ? sourceToBuild_ : sourceToBuildBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.repositoryEventConfig_ =
            repositoryEventConfigBuilder_ == null
                ? repositoryEventConfig_
                : repositoryEventConfigBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloudbuild.v1.BuildTrigger result) {
      result.buildTemplateCase_ = buildTemplateCase_;
      result.buildTemplate_ = this.buildTemplate_;
      if (buildTemplateCase_ == 4 && buildBuilder_ != null) {
        result.buildTemplate_ = buildBuilder_.build();
      }
      if (buildTemplateCase_ == 24 && gitFileSourceBuilder_ != null) {
        result.buildTemplate_ = gitFileSourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.BuildTrigger) {
        return mergeFrom((com.google.cloudbuild.v1.BuildTrigger) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.BuildTrigger other) {
      if (other == com.google.cloudbuild.v1.BuildTrigger.getDefaultInstance()) return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.tags_.isEmpty()) {
        if (tags_.isEmpty()) {
          tags_ = other.tags_;
          bitField0_ |= 0x00000010;
        } else {
          ensureTagsIsMutable();
          tags_.addAll(other.tags_);
        }
        onChanged();
      }
      if (other.hasTriggerTemplate()) {
        mergeTriggerTemplate(other.getTriggerTemplate());
      }
      if (other.hasGithub()) {
        mergeGithub(other.getGithub());
      }
      if (other.hasPubsubConfig()) {
        mergePubsubConfig(other.getPubsubConfig());
      }
      if (other.hasWebhookConfig()) {
        mergeWebhookConfig(other.getWebhookConfig());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.getDisabled() != false) {
        setDisabled(other.getDisabled());
      }
      internalGetMutableSubstitutions().mergeFrom(other.internalGetSubstitutions());
      bitField0_ |= 0x00008000;
      if (!other.ignoredFiles_.isEmpty()) {
        if (ignoredFiles_.isEmpty()) {
          ignoredFiles_ = other.ignoredFiles_;
          bitField0_ |= 0x00010000;
        } else {
          ensureIgnoredFilesIsMutable();
          ignoredFiles_.addAll(other.ignoredFiles_);
        }
        onChanged();
      }
      if (!other.includedFiles_.isEmpty()) {
        if (includedFiles_.isEmpty()) {
          includedFiles_ = other.includedFiles_;
          bitField0_ |= 0x00020000;
        } else {
          ensureIncludedFilesIsMutable();
          includedFiles_.addAll(other.includedFiles_);
        }
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.hasSourceToBuild()) {
        mergeSourceToBuild(other.getSourceToBuild());
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00100000;
        onChanged();
      }
      if (other.hasRepositoryEventConfig()) {
        mergeRepositoryEventConfig(other.getRepositoryEventConfig());
      }
      switch (other.getBuildTemplateCase()) {
        case AUTODETECT:
          {
            setAutodetect(other.getAutodetect());
            break;
          }
        case BUILD:
          {
            mergeBuild(other.getBuild());
            break;
          }
        case FILENAME:
          {
            buildTemplateCase_ = 8;
            buildTemplate_ = other.buildTemplate_;
            onChanged();
            break;
          }
        case GIT_FILE_SOURCE:
          {
            mergeGitFileSource(other.getGitFileSource());
            break;
          }
        case BUILDTEMPLATE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 34:
              {
                input.readMessage(getBuildFieldBuilder().getBuilder(), extensionRegistry);
                buildTemplateCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 42
            case 58:
              {
                input.readMessage(getTriggerTemplateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                java.lang.String s = input.readStringRequireUtf8();
                buildTemplateCase_ = 8;
                buildTemplate_ = s;
                break;
              } // case 66
            case 72:
              {
                disabled_ = input.readBool();
                bitField0_ |= 0x00004000;
                break;
              } // case 72
            case 82:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 82
            case 90:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> substitutions__ =
                    input.readMessage(
                        SubstitutionsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableSubstitutions()
                    .getMutableMap()
                    .put(substitutions__.getKey(), substitutions__.getValue());
                bitField0_ |= 0x00008000;
                break;
              } // case 90
            case 106:
              {
                input.readMessage(getGithubFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 106
            case 122:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIgnoredFilesIsMutable();
                ignoredFiles_.add(s);
                break;
              } // case 122
            case 130:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIncludedFilesIsMutable();
                includedFiles_.add(s);
                break;
              } // case 130
            case 144:
              {
                buildTemplate_ = input.readBool();
                buildTemplateCase_ = 18;
                break;
              } // case 144
            case 154:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTagsIsMutable();
                tags_.add(s);
                break;
              } // case 154
            case 170:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 170
            case 194:
              {
                input.readMessage(getGitFileSourceFieldBuilder().getBuilder(), extensionRegistry);
                buildTemplateCase_ = 24;
                break;
              } // case 194
            case 210:
              {
                input.readMessage(getSourceToBuildFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 210
            case 234:
              {
                input.readMessage(getPubsubConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 234
            case 242:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case 242
            case 250:
              {
                input.readMessage(getWebhookConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 250
            case 266:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00100000;
                break;
              } // case 266
            case 274:
              {
                resourceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 274
            case 314:
              {
                input.readMessage(
                    getRepositoryEventConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00200000;
                break;
              } // case 314
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int buildTemplateCase_ = 0;
    private java.lang.Object buildTemplate_;

    public BuildTemplateCase getBuildTemplateCase() {
      return BuildTemplateCase.forNumber(buildTemplateCase_);
    }

    public Builder clearBuildTemplate() {
      buildTemplateCase_ = 0;
      buildTemplate_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object resourceName_ = "";
    /**
     *
     *
     * <pre>
     * The `Trigger` name with format:
     * `projects/{project}/locations/{location}/triggers/{trigger}`, where
     * {trigger} is a unique identifier generated by the service.
     * </pre>
     *
     * <code>string resource_name = 34;</code>
     *
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The `Trigger` name with format:
     * `projects/{project}/locations/{location}/triggers/{trigger}`, where
     * {trigger} is a unique identifier generated by the service.
     * </pre>
     *
     * <code>string resource_name = 34;</code>
     *
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The `Trigger` name with format:
     * `projects/{project}/locations/{location}/triggers/{trigger}`, where
     * {trigger} is a unique identifier generated by the service.
     * </pre>
     *
     * <code>string resource_name = 34;</code>
     *
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `Trigger` name with format:
     * `projects/{project}/locations/{location}/triggers/{trigger}`, where
     * {trigger} is a unique identifier generated by the service.
     * </pre>
     *
     * <code>string resource_name = 34;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      resourceName_ = getDefaultInstance().getResourceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `Trigger` name with format:
     * `projects/{project}/locations/{location}/triggers/{trigger}`, where
     * {trigger} is a unique identifier generated by the service.
     * </pre>
     *
     * <code>string resource_name = 34;</code>
     *
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the trigger.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the trigger.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the trigger.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the trigger.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the trigger.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Human-readable description of this trigger.
     * </pre>
     *
     * <code>string description = 10;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Human-readable description of this trigger.
     * </pre>
     *
     * <code>string description = 10;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Human-readable description of this trigger.
     * </pre>
     *
     * <code>string description = 10;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Human-readable description of this trigger.
     * </pre>
     *
     * <code>string description = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Human-readable description of this trigger.
     * </pre>
     *
     * <code>string description = 10;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * User-assigned name of the trigger. Must be unique within the project.
     * Trigger names must meet the following requirements:
     *
     * + They must contain only alphanumeric characters and dashes.
     * + They can be 1-64 characters long.
     * + They must begin and end with an alphanumeric character.
     * </pre>
     *
     * <code>string name = 21;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-assigned name of the trigger. Must be unique within the project.
     * Trigger names must meet the following requirements:
     *
     * + They must contain only alphanumeric characters and dashes.
     * + They can be 1-64 characters long.
     * + They must begin and end with an alphanumeric character.
     * </pre>
     *
     * <code>string name = 21;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-assigned name of the trigger. Must be unique within the project.
     * Trigger names must meet the following requirements:
     *
     * + They must contain only alphanumeric characters and dashes.
     * + They can be 1-64 characters long.
     * + They must begin and end with an alphanumeric character.
     * </pre>
     *
     * <code>string name = 21;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-assigned name of the trigger. Must be unique within the project.
     * Trigger names must meet the following requirements:
     *
     * + They must contain only alphanumeric characters and dashes.
     * + They can be 1-64 characters long.
     * + They must begin and end with an alphanumeric character.
     * </pre>
     *
     * <code>string name = 21;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-assigned name of the trigger. Must be unique within the project.
     * Trigger names must meet the following requirements:
     *
     * + They must contain only alphanumeric characters and dashes.
     * + They can be 1-64 characters long.
     * + They must begin and end with an alphanumeric character.
     * </pre>
     *
     * <code>string name = 21;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList tags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTagsIsMutable() {
      if (!tags_.isModifiable()) {
        tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `BuildTrigger`
     * </pre>
     *
     * <code>repeated string tags = 19;</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      tags_.makeImmutable();
      return tags_;
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `BuildTrigger`
     * </pre>
     *
     * <code>repeated string tags = 19;</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `BuildTrigger`
     * </pre>
     *
     * <code>repeated string tags = 19;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `BuildTrigger`
     * </pre>
     *
     * <code>repeated string tags = 19;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `BuildTrigger`
     * </pre>
     *
     * <code>repeated string tags = 19;</code>
     *
     * @param index The index to set the value at.
     * @param value The tags to set.
     * @return This builder for chaining.
     */
    public Builder setTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `BuildTrigger`
     * </pre>
     *
     * <code>repeated string tags = 19;</code>
     *
     * @param value The tags to add.
     * @return This builder for chaining.
     */
    public Builder addTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `BuildTrigger`
     * </pre>
     *
     * <code>repeated string tags = 19;</code>
     *
     * @param values The tags to add.
     * @return This builder for chaining.
     */
    public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
      ensureTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `BuildTrigger`
     * </pre>
     *
     * <code>repeated string tags = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTags() {
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `BuildTrigger`
     * </pre>
     *
     * <code>repeated string tags = 19;</code>
     *
     * @param value The bytes of the tags to add.
     * @return This builder for chaining.
     */
    public Builder addTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.cloudbuild.v1.RepoSource triggerTemplate_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.RepoSource,
            com.google.cloudbuild.v1.RepoSource.Builder,
            com.google.cloudbuild.v1.RepoSourceOrBuilder>
        triggerTemplateBuilder_;
    /**
     *
     *
     * <pre>
     * Template describing the types of source changes to trigger a build.
     *
     * Branch and tag names in trigger templates are interpreted as regular
     * expressions. Any branch or tag change that matches that regular expression
     * will trigger a build.
     *
     * Mutually exclusive with `github`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
     *
     * @return Whether the triggerTemplate field is set.
     */
    public boolean hasTriggerTemplate() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Template describing the types of source changes to trigger a build.
     *
     * Branch and tag names in trigger templates are interpreted as regular
     * expressions. Any branch or tag change that matches that regular expression
     * will trigger a build.
     *
     * Mutually exclusive with `github`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
     *
     * @return The triggerTemplate.
     */
    public com.google.cloudbuild.v1.RepoSource getTriggerTemplate() {
      if (triggerTemplateBuilder_ == null) {
        return triggerTemplate_ == null
            ? com.google.cloudbuild.v1.RepoSource.getDefaultInstance()
            : triggerTemplate_;
      } else {
        return triggerTemplateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Template describing the types of source changes to trigger a build.
     *
     * Branch and tag names in trigger templates are interpreted as regular
     * expressions. Any branch or tag change that matches that regular expression
     * will trigger a build.
     *
     * Mutually exclusive with `github`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
     */
    public Builder setTriggerTemplate(com.google.cloudbuild.v1.RepoSource value) {
      if (triggerTemplateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        triggerTemplate_ = value;
      } else {
        triggerTemplateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Template describing the types of source changes to trigger a build.
     *
     * Branch and tag names in trigger templates are interpreted as regular
     * expressions. Any branch or tag change that matches that regular expression
     * will trigger a build.
     *
     * Mutually exclusive with `github`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
     */
    public Builder setTriggerTemplate(com.google.cloudbuild.v1.RepoSource.Builder builderForValue) {
      if (triggerTemplateBuilder_ == null) {
        triggerTemplate_ = builderForValue.build();
      } else {
        triggerTemplateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Template describing the types of source changes to trigger a build.
     *
     * Branch and tag names in trigger templates are interpreted as regular
     * expressions. Any branch or tag change that matches that regular expression
     * will trigger a build.
     *
     * Mutually exclusive with `github`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
     */
    public Builder mergeTriggerTemplate(com.google.cloudbuild.v1.RepoSource value) {
      if (triggerTemplateBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && triggerTemplate_ != null
            && triggerTemplate_ != com.google.cloudbuild.v1.RepoSource.getDefaultInstance()) {
          getTriggerTemplateBuilder().mergeFrom(value);
        } else {
          triggerTemplate_ = value;
        }
      } else {
        triggerTemplateBuilder_.mergeFrom(value);
      }
      if (triggerTemplate_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Template describing the types of source changes to trigger a build.
     *
     * Branch and tag names in trigger templates are interpreted as regular
     * expressions. Any branch or tag change that matches that regular expression
     * will trigger a build.
     *
     * Mutually exclusive with `github`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
     */
    public Builder clearTriggerTemplate() {
      bitField0_ = (bitField0_ & ~0x00000020);
      triggerTemplate_ = null;
      if (triggerTemplateBuilder_ != null) {
        triggerTemplateBuilder_.dispose();
        triggerTemplateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Template describing the types of source changes to trigger a build.
     *
     * Branch and tag names in trigger templates are interpreted as regular
     * expressions. Any branch or tag change that matches that regular expression
     * will trigger a build.
     *
     * Mutually exclusive with `github`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
     */
    public com.google.cloudbuild.v1.RepoSource.Builder getTriggerTemplateBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getTriggerTemplateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Template describing the types of source changes to trigger a build.
     *
     * Branch and tag names in trigger templates are interpreted as regular
     * expressions. Any branch or tag change that matches that regular expression
     * will trigger a build.
     *
     * Mutually exclusive with `github`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
     */
    public com.google.cloudbuild.v1.RepoSourceOrBuilder getTriggerTemplateOrBuilder() {
      if (triggerTemplateBuilder_ != null) {
        return triggerTemplateBuilder_.getMessageOrBuilder();
      } else {
        return triggerTemplate_ == null
            ? com.google.cloudbuild.v1.RepoSource.getDefaultInstance()
            : triggerTemplate_;
      }
    }
    /**
     *
     *
     * <pre>
     * Template describing the types of source changes to trigger a build.
     *
     * Branch and tag names in trigger templates are interpreted as regular
     * expressions. Any branch or tag change that matches that regular expression
     * will trigger a build.
     *
     * Mutually exclusive with `github`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.RepoSource,
            com.google.cloudbuild.v1.RepoSource.Builder,
            com.google.cloudbuild.v1.RepoSourceOrBuilder>
        getTriggerTemplateFieldBuilder() {
      if (triggerTemplateBuilder_ == null) {
        triggerTemplateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.RepoSource,
                com.google.cloudbuild.v1.RepoSource.Builder,
                com.google.cloudbuild.v1.RepoSourceOrBuilder>(
                getTriggerTemplate(), getParentForChildren(), isClean());
        triggerTemplate_ = null;
      }
      return triggerTemplateBuilder_;
    }

    private com.google.cloudbuild.v1.GitHubEventsConfig github_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.GitHubEventsConfig,
            com.google.cloudbuild.v1.GitHubEventsConfig.Builder,
            com.google.cloudbuild.v1.GitHubEventsConfigOrBuilder>
        githubBuilder_;
    /**
     *
     *
     * <pre>
     * GitHubEventsConfig describes the configuration of a trigger that creates
     * a build whenever a GitHub event is received.
     *
     * Mutually exclusive with `trigger_template`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
     *
     * @return Whether the github field is set.
     */
    public boolean hasGithub() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * GitHubEventsConfig describes the configuration of a trigger that creates
     * a build whenever a GitHub event is received.
     *
     * Mutually exclusive with `trigger_template`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
     *
     * @return The github.
     */
    public com.google.cloudbuild.v1.GitHubEventsConfig getGithub() {
      if (githubBuilder_ == null) {
        return github_ == null
            ? com.google.cloudbuild.v1.GitHubEventsConfig.getDefaultInstance()
            : github_;
      } else {
        return githubBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * GitHubEventsConfig describes the configuration of a trigger that creates
     * a build whenever a GitHub event is received.
     *
     * Mutually exclusive with `trigger_template`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
     */
    public Builder setGithub(com.google.cloudbuild.v1.GitHubEventsConfig value) {
      if (githubBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        github_ = value;
      } else {
        githubBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * GitHubEventsConfig describes the configuration of a trigger that creates
     * a build whenever a GitHub event is received.
     *
     * Mutually exclusive with `trigger_template`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
     */
    public Builder setGithub(com.google.cloudbuild.v1.GitHubEventsConfig.Builder builderForValue) {
      if (githubBuilder_ == null) {
        github_ = builderForValue.build();
      } else {
        githubBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * GitHubEventsConfig describes the configuration of a trigger that creates
     * a build whenever a GitHub event is received.
     *
     * Mutually exclusive with `trigger_template`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
     */
    public Builder mergeGithub(com.google.cloudbuild.v1.GitHubEventsConfig value) {
      if (githubBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && github_ != null
            && github_ != com.google.cloudbuild.v1.GitHubEventsConfig.getDefaultInstance()) {
          getGithubBuilder().mergeFrom(value);
        } else {
          github_ = value;
        }
      } else {
        githubBuilder_.mergeFrom(value);
      }
      if (github_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * GitHubEventsConfig describes the configuration of a trigger that creates
     * a build whenever a GitHub event is received.
     *
     * Mutually exclusive with `trigger_template`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
     */
    public Builder clearGithub() {
      bitField0_ = (bitField0_ & ~0x00000040);
      github_ = null;
      if (githubBuilder_ != null) {
        githubBuilder_.dispose();
        githubBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * GitHubEventsConfig describes the configuration of a trigger that creates
     * a build whenever a GitHub event is received.
     *
     * Mutually exclusive with `trigger_template`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
     */
    public com.google.cloudbuild.v1.GitHubEventsConfig.Builder getGithubBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getGithubFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * GitHubEventsConfig describes the configuration of a trigger that creates
     * a build whenever a GitHub event is received.
     *
     * Mutually exclusive with `trigger_template`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
     */
    public com.google.cloudbuild.v1.GitHubEventsConfigOrBuilder getGithubOrBuilder() {
      if (githubBuilder_ != null) {
        return githubBuilder_.getMessageOrBuilder();
      } else {
        return github_ == null
            ? com.google.cloudbuild.v1.GitHubEventsConfig.getDefaultInstance()
            : github_;
      }
    }
    /**
     *
     *
     * <pre>
     * GitHubEventsConfig describes the configuration of a trigger that creates
     * a build whenever a GitHub event is received.
     *
     * Mutually exclusive with `trigger_template`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.GitHubEventsConfig,
            com.google.cloudbuild.v1.GitHubEventsConfig.Builder,
            com.google.cloudbuild.v1.GitHubEventsConfigOrBuilder>
        getGithubFieldBuilder() {
      if (githubBuilder_ == null) {
        githubBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.GitHubEventsConfig,
                com.google.cloudbuild.v1.GitHubEventsConfig.Builder,
                com.google.cloudbuild.v1.GitHubEventsConfigOrBuilder>(
                getGithub(), getParentForChildren(), isClean());
        github_ = null;
      }
      return githubBuilder_;
    }

    private com.google.cloudbuild.v1.PubsubConfig pubsubConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.PubsubConfig,
            com.google.cloudbuild.v1.PubsubConfig.Builder,
            com.google.cloudbuild.v1.PubsubConfigOrBuilder>
        pubsubConfigBuilder_;
    /**
     *
     *
     * <pre>
     * PubsubConfig describes the configuration of a trigger that
     * creates a build whenever a Pub/Sub message is published.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PubsubConfig pubsub_config = 29;</code>
     *
     * @return Whether the pubsubConfig field is set.
     */
    public boolean hasPubsubConfig() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * PubsubConfig describes the configuration of a trigger that
     * creates a build whenever a Pub/Sub message is published.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PubsubConfig pubsub_config = 29;</code>
     *
     * @return The pubsubConfig.
     */
    public com.google.cloudbuild.v1.PubsubConfig getPubsubConfig() {
      if (pubsubConfigBuilder_ == null) {
        return pubsubConfig_ == null
            ? com.google.cloudbuild.v1.PubsubConfig.getDefaultInstance()
            : pubsubConfig_;
      } else {
        return pubsubConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * PubsubConfig describes the configuration of a trigger that
     * creates a build whenever a Pub/Sub message is published.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PubsubConfig pubsub_config = 29;</code>
     */
    public Builder setPubsubConfig(com.google.cloudbuild.v1.PubsubConfig value) {
      if (pubsubConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pubsubConfig_ = value;
      } else {
        pubsubConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * PubsubConfig describes the configuration of a trigger that
     * creates a build whenever a Pub/Sub message is published.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PubsubConfig pubsub_config = 29;</code>
     */
    public Builder setPubsubConfig(com.google.cloudbuild.v1.PubsubConfig.Builder builderForValue) {
      if (pubsubConfigBuilder_ == null) {
        pubsubConfig_ = builderForValue.build();
      } else {
        pubsubConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * PubsubConfig describes the configuration of a trigger that
     * creates a build whenever a Pub/Sub message is published.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PubsubConfig pubsub_config = 29;</code>
     */
    public Builder mergePubsubConfig(com.google.cloudbuild.v1.PubsubConfig value) {
      if (pubsubConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && pubsubConfig_ != null
            && pubsubConfig_ != com.google.cloudbuild.v1.PubsubConfig.getDefaultInstance()) {
          getPubsubConfigBuilder().mergeFrom(value);
        } else {
          pubsubConfig_ = value;
        }
      } else {
        pubsubConfigBuilder_.mergeFrom(value);
      }
      if (pubsubConfig_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * PubsubConfig describes the configuration of a trigger that
     * creates a build whenever a Pub/Sub message is published.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PubsubConfig pubsub_config = 29;</code>
     */
    public Builder clearPubsubConfig() {
      bitField0_ = (bitField0_ & ~0x00000080);
      pubsubConfig_ = null;
      if (pubsubConfigBuilder_ != null) {
        pubsubConfigBuilder_.dispose();
        pubsubConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * PubsubConfig describes the configuration of a trigger that
     * creates a build whenever a Pub/Sub message is published.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PubsubConfig pubsub_config = 29;</code>
     */
    public com.google.cloudbuild.v1.PubsubConfig.Builder getPubsubConfigBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getPubsubConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * PubsubConfig describes the configuration of a trigger that
     * creates a build whenever a Pub/Sub message is published.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PubsubConfig pubsub_config = 29;</code>
     */
    public com.google.cloudbuild.v1.PubsubConfigOrBuilder getPubsubConfigOrBuilder() {
      if (pubsubConfigBuilder_ != null) {
        return pubsubConfigBuilder_.getMessageOrBuilder();
      } else {
        return pubsubConfig_ == null
            ? com.google.cloudbuild.v1.PubsubConfig.getDefaultInstance()
            : pubsubConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * PubsubConfig describes the configuration of a trigger that
     * creates a build whenever a Pub/Sub message is published.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PubsubConfig pubsub_config = 29;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.PubsubConfig,
            com.google.cloudbuild.v1.PubsubConfig.Builder,
            com.google.cloudbuild.v1.PubsubConfigOrBuilder>
        getPubsubConfigFieldBuilder() {
      if (pubsubConfigBuilder_ == null) {
        pubsubConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.PubsubConfig,
                com.google.cloudbuild.v1.PubsubConfig.Builder,
                com.google.cloudbuild.v1.PubsubConfigOrBuilder>(
                getPubsubConfig(), getParentForChildren(), isClean());
        pubsubConfig_ = null;
      }
      return pubsubConfigBuilder_;
    }

    private com.google.cloudbuild.v1.WebhookConfig webhookConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.WebhookConfig,
            com.google.cloudbuild.v1.WebhookConfig.Builder,
            com.google.cloudbuild.v1.WebhookConfigOrBuilder>
        webhookConfigBuilder_;
    /**
     *
     *
     * <pre>
     * WebhookConfig describes the configuration of a trigger that
     * creates a build whenever a webhook is sent to a trigger's webhook URL.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WebhookConfig webhook_config = 31;</code>
     *
     * @return Whether the webhookConfig field is set.
     */
    public boolean hasWebhookConfig() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * WebhookConfig describes the configuration of a trigger that
     * creates a build whenever a webhook is sent to a trigger's webhook URL.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WebhookConfig webhook_config = 31;</code>
     *
     * @return The webhookConfig.
     */
    public com.google.cloudbuild.v1.WebhookConfig getWebhookConfig() {
      if (webhookConfigBuilder_ == null) {
        return webhookConfig_ == null
            ? com.google.cloudbuild.v1.WebhookConfig.getDefaultInstance()
            : webhookConfig_;
      } else {
        return webhookConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * WebhookConfig describes the configuration of a trigger that
     * creates a build whenever a webhook is sent to a trigger's webhook URL.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WebhookConfig webhook_config = 31;</code>
     */
    public Builder setWebhookConfig(com.google.cloudbuild.v1.WebhookConfig value) {
      if (webhookConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        webhookConfig_ = value;
      } else {
        webhookConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * WebhookConfig describes the configuration of a trigger that
     * creates a build whenever a webhook is sent to a trigger's webhook URL.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WebhookConfig webhook_config = 31;</code>
     */
    public Builder setWebhookConfig(
        com.google.cloudbuild.v1.WebhookConfig.Builder builderForValue) {
      if (webhookConfigBuilder_ == null) {
        webhookConfig_ = builderForValue.build();
      } else {
        webhookConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * WebhookConfig describes the configuration of a trigger that
     * creates a build whenever a webhook is sent to a trigger's webhook URL.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WebhookConfig webhook_config = 31;</code>
     */
    public Builder mergeWebhookConfig(com.google.cloudbuild.v1.WebhookConfig value) {
      if (webhookConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && webhookConfig_ != null
            && webhookConfig_ != com.google.cloudbuild.v1.WebhookConfig.getDefaultInstance()) {
          getWebhookConfigBuilder().mergeFrom(value);
        } else {
          webhookConfig_ = value;
        }
      } else {
        webhookConfigBuilder_.mergeFrom(value);
      }
      if (webhookConfig_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * WebhookConfig describes the configuration of a trigger that
     * creates a build whenever a webhook is sent to a trigger's webhook URL.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WebhookConfig webhook_config = 31;</code>
     */
    public Builder clearWebhookConfig() {
      bitField0_ = (bitField0_ & ~0x00000100);
      webhookConfig_ = null;
      if (webhookConfigBuilder_ != null) {
        webhookConfigBuilder_.dispose();
        webhookConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * WebhookConfig describes the configuration of a trigger that
     * creates a build whenever a webhook is sent to a trigger's webhook URL.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WebhookConfig webhook_config = 31;</code>
     */
    public com.google.cloudbuild.v1.WebhookConfig.Builder getWebhookConfigBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getWebhookConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * WebhookConfig describes the configuration of a trigger that
     * creates a build whenever a webhook is sent to a trigger's webhook URL.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WebhookConfig webhook_config = 31;</code>
     */
    public com.google.cloudbuild.v1.WebhookConfigOrBuilder getWebhookConfigOrBuilder() {
      if (webhookConfigBuilder_ != null) {
        return webhookConfigBuilder_.getMessageOrBuilder();
      } else {
        return webhookConfig_ == null
            ? com.google.cloudbuild.v1.WebhookConfig.getDefaultInstance()
            : webhookConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * WebhookConfig describes the configuration of a trigger that
     * creates a build whenever a webhook is sent to a trigger's webhook URL.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WebhookConfig webhook_config = 31;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.WebhookConfig,
            com.google.cloudbuild.v1.WebhookConfig.Builder,
            com.google.cloudbuild.v1.WebhookConfigOrBuilder>
        getWebhookConfigFieldBuilder() {
      if (webhookConfigBuilder_ == null) {
        webhookConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.WebhookConfig,
                com.google.cloudbuild.v1.WebhookConfig.Builder,
                com.google.cloudbuild.v1.WebhookConfigOrBuilder>(
                getWebhookConfig(), getParentForChildren(), isClean());
        webhookConfig_ = null;
      }
      return webhookConfigBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Autodetect build configuration.  The following precedence is used (case
     * insensitive):
     *
     * 1. cloudbuild.yaml
     * 2. cloudbuild.yml
     * 3. cloudbuild.json
     * 4. Dockerfile
     *
     * Currently only available for GitHub App Triggers.
     * </pre>
     *
     * <code>bool autodetect = 18;</code>
     *
     * @return Whether the autodetect field is set.
     */
    public boolean hasAutodetect() {
      return buildTemplateCase_ == 18;
    }
    /**
     *
     *
     * <pre>
     * Autodetect build configuration.  The following precedence is used (case
     * insensitive):
     *
     * 1. cloudbuild.yaml
     * 2. cloudbuild.yml
     * 3. cloudbuild.json
     * 4. Dockerfile
     *
     * Currently only available for GitHub App Triggers.
     * </pre>
     *
     * <code>bool autodetect = 18;</code>
     *
     * @return The autodetect.
     */
    public boolean getAutodetect() {
      if (buildTemplateCase_ == 18) {
        return (java.lang.Boolean) buildTemplate_;
      }
      return false;
    }
    /**
     *
     *
     * <pre>
     * Autodetect build configuration.  The following precedence is used (case
     * insensitive):
     *
     * 1. cloudbuild.yaml
     * 2. cloudbuild.yml
     * 3. cloudbuild.json
     * 4. Dockerfile
     *
     * Currently only available for GitHub App Triggers.
     * </pre>
     *
     * <code>bool autodetect = 18;</code>
     *
     * @param value The autodetect to set.
     * @return This builder for chaining.
     */
    public Builder setAutodetect(boolean value) {

      buildTemplateCase_ = 18;
      buildTemplate_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Autodetect build configuration.  The following precedence is used (case
     * insensitive):
     *
     * 1. cloudbuild.yaml
     * 2. cloudbuild.yml
     * 3. cloudbuild.json
     * 4. Dockerfile
     *
     * Currently only available for GitHub App Triggers.
     * </pre>
     *
     * <code>bool autodetect = 18;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutodetect() {
      if (buildTemplateCase_ == 18) {
        buildTemplateCase_ = 0;
        buildTemplate_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Build,
            com.google.cloudbuild.v1.Build.Builder,
            com.google.cloudbuild.v1.BuildOrBuilder>
        buildBuilder_;
    /**
     *
     *
     * <pre>
     * Contents of the build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
     *
     * @return Whether the build field is set.
     */
    @java.lang.Override
    public boolean hasBuild() {
      return buildTemplateCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Contents of the build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
     *
     * @return The build.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.Build getBuild() {
      if (buildBuilder_ == null) {
        if (buildTemplateCase_ == 4) {
          return (com.google.cloudbuild.v1.Build) buildTemplate_;
        }
        return com.google.cloudbuild.v1.Build.getDefaultInstance();
      } else {
        if (buildTemplateCase_ == 4) {
          return buildBuilder_.getMessage();
        }
        return com.google.cloudbuild.v1.Build.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Contents of the build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
     */
    public Builder setBuild(com.google.cloudbuild.v1.Build value) {
      if (buildBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        buildTemplate_ = value;
        onChanged();
      } else {
        buildBuilder_.setMessage(value);
      }
      buildTemplateCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contents of the build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
     */
    public Builder setBuild(com.google.cloudbuild.v1.Build.Builder builderForValue) {
      if (buildBuilder_ == null) {
        buildTemplate_ = builderForValue.build();
        onChanged();
      } else {
        buildBuilder_.setMessage(builderForValue.build());
      }
      buildTemplateCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contents of the build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
     */
    public Builder mergeBuild(com.google.cloudbuild.v1.Build value) {
      if (buildBuilder_ == null) {
        if (buildTemplateCase_ == 4
            && buildTemplate_ != com.google.cloudbuild.v1.Build.getDefaultInstance()) {
          buildTemplate_ =
              com.google.cloudbuild.v1.Build.newBuilder(
                      (com.google.cloudbuild.v1.Build) buildTemplate_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          buildTemplate_ = value;
        }
        onChanged();
      } else {
        if (buildTemplateCase_ == 4) {
          buildBuilder_.mergeFrom(value);
        } else {
          buildBuilder_.setMessage(value);
        }
      }
      buildTemplateCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contents of the build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
     */
    public Builder clearBuild() {
      if (buildBuilder_ == null) {
        if (buildTemplateCase_ == 4) {
          buildTemplateCase_ = 0;
          buildTemplate_ = null;
          onChanged();
        }
      } else {
        if (buildTemplateCase_ == 4) {
          buildTemplateCase_ = 0;
          buildTemplate_ = null;
        }
        buildBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contents of the build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
     */
    public com.google.cloudbuild.v1.Build.Builder getBuildBuilder() {
      return getBuildFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Contents of the build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.BuildOrBuilder getBuildOrBuilder() {
      if ((buildTemplateCase_ == 4) && (buildBuilder_ != null)) {
        return buildBuilder_.getMessageOrBuilder();
      } else {
        if (buildTemplateCase_ == 4) {
          return (com.google.cloudbuild.v1.Build) buildTemplate_;
        }
        return com.google.cloudbuild.v1.Build.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Contents of the build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Build,
            com.google.cloudbuild.v1.Build.Builder,
            com.google.cloudbuild.v1.BuildOrBuilder>
        getBuildFieldBuilder() {
      if (buildBuilder_ == null) {
        if (!(buildTemplateCase_ == 4)) {
          buildTemplate_ = com.google.cloudbuild.v1.Build.getDefaultInstance();
        }
        buildBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.Build,
                com.google.cloudbuild.v1.Build.Builder,
                com.google.cloudbuild.v1.BuildOrBuilder>(
                (com.google.cloudbuild.v1.Build) buildTemplate_, getParentForChildren(), isClean());
        buildTemplate_ = null;
      }
      buildTemplateCase_ = 4;
      onChanged();
      return buildBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Path, from the source root, to the build configuration file
     * (i.e. cloudbuild.yaml).
     * </pre>
     *
     * <code>string filename = 8;</code>
     *
     * @return Whether the filename field is set.
     */
    @java.lang.Override
    public boolean hasFilename() {
      return buildTemplateCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Path, from the source root, to the build configuration file
     * (i.e. cloudbuild.yaml).
     * </pre>
     *
     * <code>string filename = 8;</code>
     *
     * @return The filename.
     */
    @java.lang.Override
    public java.lang.String getFilename() {
      java.lang.Object ref = "";
      if (buildTemplateCase_ == 8) {
        ref = buildTemplate_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (buildTemplateCase_ == 8) {
          buildTemplate_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Path, from the source root, to the build configuration file
     * (i.e. cloudbuild.yaml).
     * </pre>
     *
     * <code>string filename = 8;</code>
     *
     * @return The bytes for filename.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFilenameBytes() {
      java.lang.Object ref = "";
      if (buildTemplateCase_ == 8) {
        ref = buildTemplate_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (buildTemplateCase_ == 8) {
          buildTemplate_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Path, from the source root, to the build configuration file
     * (i.e. cloudbuild.yaml).
     * </pre>
     *
     * <code>string filename = 8;</code>
     *
     * @param value The filename to set.
     * @return This builder for chaining.
     */
    public Builder setFilename(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      buildTemplateCase_ = 8;
      buildTemplate_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Path, from the source root, to the build configuration file
     * (i.e. cloudbuild.yaml).
     * </pre>
     *
     * <code>string filename = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilename() {
      if (buildTemplateCase_ == 8) {
        buildTemplateCase_ = 0;
        buildTemplate_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Path, from the source root, to the build configuration file
     * (i.e. cloudbuild.yaml).
     * </pre>
     *
     * <code>string filename = 8;</code>
     *
     * @param value The bytes for filename to set.
     * @return This builder for chaining.
     */
    public Builder setFilenameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      buildTemplateCase_ = 8;
      buildTemplate_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.GitFileSource,
            com.google.cloudbuild.v1.GitFileSource.Builder,
            com.google.cloudbuild.v1.GitFileSourceOrBuilder>
        gitFileSourceBuilder_;
    /**
     *
     *
     * <pre>
     * The file source describing the local or remote Build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitFileSource git_file_source = 24;</code>
     *
     * @return Whether the gitFileSource field is set.
     */
    @java.lang.Override
    public boolean hasGitFileSource() {
      return buildTemplateCase_ == 24;
    }
    /**
     *
     *
     * <pre>
     * The file source describing the local or remote Build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitFileSource git_file_source = 24;</code>
     *
     * @return The gitFileSource.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.GitFileSource getGitFileSource() {
      if (gitFileSourceBuilder_ == null) {
        if (buildTemplateCase_ == 24) {
          return (com.google.cloudbuild.v1.GitFileSource) buildTemplate_;
        }
        return com.google.cloudbuild.v1.GitFileSource.getDefaultInstance();
      } else {
        if (buildTemplateCase_ == 24) {
          return gitFileSourceBuilder_.getMessage();
        }
        return com.google.cloudbuild.v1.GitFileSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The file source describing the local or remote Build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitFileSource git_file_source = 24;</code>
     */
    public Builder setGitFileSource(com.google.cloudbuild.v1.GitFileSource value) {
      if (gitFileSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        buildTemplate_ = value;
        onChanged();
      } else {
        gitFileSourceBuilder_.setMessage(value);
      }
      buildTemplateCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The file source describing the local or remote Build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitFileSource git_file_source = 24;</code>
     */
    public Builder setGitFileSource(
        com.google.cloudbuild.v1.GitFileSource.Builder builderForValue) {
      if (gitFileSourceBuilder_ == null) {
        buildTemplate_ = builderForValue.build();
        onChanged();
      } else {
        gitFileSourceBuilder_.setMessage(builderForValue.build());
      }
      buildTemplateCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The file source describing the local or remote Build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitFileSource git_file_source = 24;</code>
     */
    public Builder mergeGitFileSource(com.google.cloudbuild.v1.GitFileSource value) {
      if (gitFileSourceBuilder_ == null) {
        if (buildTemplateCase_ == 24
            && buildTemplate_ != com.google.cloudbuild.v1.GitFileSource.getDefaultInstance()) {
          buildTemplate_ =
              com.google.cloudbuild.v1.GitFileSource.newBuilder(
                      (com.google.cloudbuild.v1.GitFileSource) buildTemplate_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          buildTemplate_ = value;
        }
        onChanged();
      } else {
        if (buildTemplateCase_ == 24) {
          gitFileSourceBuilder_.mergeFrom(value);
        } else {
          gitFileSourceBuilder_.setMessage(value);
        }
      }
      buildTemplateCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The file source describing the local or remote Build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitFileSource git_file_source = 24;</code>
     */
    public Builder clearGitFileSource() {
      if (gitFileSourceBuilder_ == null) {
        if (buildTemplateCase_ == 24) {
          buildTemplateCase_ = 0;
          buildTemplate_ = null;
          onChanged();
        }
      } else {
        if (buildTemplateCase_ == 24) {
          buildTemplateCase_ = 0;
          buildTemplate_ = null;
        }
        gitFileSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The file source describing the local or remote Build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitFileSource git_file_source = 24;</code>
     */
    public com.google.cloudbuild.v1.GitFileSource.Builder getGitFileSourceBuilder() {
      return getGitFileSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The file source describing the local or remote Build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitFileSource git_file_source = 24;</code>
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.GitFileSourceOrBuilder getGitFileSourceOrBuilder() {
      if ((buildTemplateCase_ == 24) && (gitFileSourceBuilder_ != null)) {
        return gitFileSourceBuilder_.getMessageOrBuilder();
      } else {
        if (buildTemplateCase_ == 24) {
          return (com.google.cloudbuild.v1.GitFileSource) buildTemplate_;
        }
        return com.google.cloudbuild.v1.GitFileSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The file source describing the local or remote Build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitFileSource git_file_source = 24;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.GitFileSource,
            com.google.cloudbuild.v1.GitFileSource.Builder,
            com.google.cloudbuild.v1.GitFileSourceOrBuilder>
        getGitFileSourceFieldBuilder() {
      if (gitFileSourceBuilder_ == null) {
        if (!(buildTemplateCase_ == 24)) {
          buildTemplate_ = com.google.cloudbuild.v1.GitFileSource.getDefaultInstance();
        }
        gitFileSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.GitFileSource,
                com.google.cloudbuild.v1.GitFileSource.Builder,
                com.google.cloudbuild.v1.GitFileSourceOrBuilder>(
                (com.google.cloudbuild.v1.GitFileSource) buildTemplate_,
                getParentForChildren(),
                isClean());
        buildTemplate_ = null;
      }
      buildTemplateCase_ = 24;
      onChanged();
      return gitFileSourceBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the trigger was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the trigger was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the trigger was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the trigger was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the trigger was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the trigger was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00002000);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the trigger was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the trigger was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the trigger was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private boolean disabled_;
    /**
     *
     *
     * <pre>
     * If true, the trigger will never automatically execute a build.
     * </pre>
     *
     * <code>bool disabled = 9;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }
    /**
     *
     *
     * <pre>
     * If true, the trigger will never automatically execute a build.
     * </pre>
     *
     * <code>bool disabled = 9;</code>
     *
     * @param value The disabled to set.
     * @return This builder for chaining.
     */
    public Builder setDisabled(boolean value) {

      disabled_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, the trigger will never automatically execute a build.
     * </pre>
     *
     * <code>bool disabled = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisabled() {
      bitField0_ = (bitField0_ & ~0x00004000);
      disabled_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> substitutions_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetSubstitutions() {
      if (substitutions_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            SubstitutionsDefaultEntryHolder.defaultEntry);
      }
      return substitutions_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableSubstitutions() {
      if (substitutions_ == null) {
        substitutions_ =
            com.google.protobuf.MapField.newMapField(SubstitutionsDefaultEntryHolder.defaultEntry);
      }
      if (!substitutions_.isMutable()) {
        substitutions_ = substitutions_.copy();
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return substitutions_;
    }

    public int getSubstitutionsCount() {
      return internalGetSubstitutions().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Substitutions for Build resource. The keys must match the following
     * regular expression: `^_[A-Z0-9_]+$`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 11;</code>
     */
    @java.lang.Override
    public boolean containsSubstitutions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetSubstitutions().getMap().containsKey(key);
    }
    /** Use {@link #getSubstitutionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getSubstitutions() {
      return getSubstitutionsMap();
    }
    /**
     *
     *
     * <pre>
     * Substitutions for Build resource. The keys must match the following
     * regular expression: `^_[A-Z0-9_]+$`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 11;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getSubstitutionsMap() {
      return internalGetSubstitutions().getMap();
    }
    /**
     *
     *
     * <pre>
     * Substitutions for Build resource. The keys must match the following
     * regular expression: `^_[A-Z0-9_]+$`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 11;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getSubstitutionsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetSubstitutions().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Substitutions for Build resource. The keys must match the following
     * regular expression: `^_[A-Z0-9_]+$`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 11;</code>
     */
    @java.lang.Override
    public java.lang.String getSubstitutionsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetSubstitutions().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearSubstitutions() {
      bitField0_ = (bitField0_ & ~0x00008000);
      internalGetMutableSubstitutions().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Substitutions for Build resource. The keys must match the following
     * regular expression: `^_[A-Z0-9_]+$`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 11;</code>
     */
    public Builder removeSubstitutions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableSubstitutions().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableSubstitutions() {
      bitField0_ |= 0x00008000;
      return internalGetMutableSubstitutions().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Substitutions for Build resource. The keys must match the following
     * regular expression: `^_[A-Z0-9_]+$`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 11;</code>
     */
    public Builder putSubstitutions(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableSubstitutions().getMutableMap().put(key, value);
      bitField0_ |= 0x00008000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Substitutions for Build resource. The keys must match the following
     * regular expression: `^_[A-Z0-9_]+$`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 11;</code>
     */
    public Builder putAllSubstitutions(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableSubstitutions().getMutableMap().putAll(values);
      bitField0_ |= 0x00008000;
      return this;
    }

    private com.google.protobuf.LazyStringArrayList ignoredFiles_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureIgnoredFilesIsMutable() {
      if (!ignoredFiles_.isModifiable()) {
        ignoredFiles_ = new com.google.protobuf.LazyStringArrayList(ignoredFiles_);
      }
      bitField0_ |= 0x00010000;
    }
    /**
     *
     *
     * <pre>
     * ignored_files and included_files are file glob matches using
     * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
     *
     * If ignored_files and changed files are both empty, then they are
     * not used to determine whether or not to trigger a build.
     *
     * If ignored_files is not empty, then we ignore any files that match
     * any of the ignored_file globs. If the change has no files that are
     * outside of the ignored_files globs, then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string ignored_files = 15;</code>
     *
     * @return A list containing the ignoredFiles.
     */
    public com.google.protobuf.ProtocolStringList getIgnoredFilesList() {
      ignoredFiles_.makeImmutable();
      return ignoredFiles_;
    }
    /**
     *
     *
     * <pre>
     * ignored_files and included_files are file glob matches using
     * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
     *
     * If ignored_files and changed files are both empty, then they are
     * not used to determine whether or not to trigger a build.
     *
     * If ignored_files is not empty, then we ignore any files that match
     * any of the ignored_file globs. If the change has no files that are
     * outside of the ignored_files globs, then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string ignored_files = 15;</code>
     *
     * @return The count of ignoredFiles.
     */
    public int getIgnoredFilesCount() {
      return ignoredFiles_.size();
    }
    /**
     *
     *
     * <pre>
     * ignored_files and included_files are file glob matches using
     * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
     *
     * If ignored_files and changed files are both empty, then they are
     * not used to determine whether or not to trigger a build.
     *
     * If ignored_files is not empty, then we ignore any files that match
     * any of the ignored_file globs. If the change has no files that are
     * outside of the ignored_files globs, then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string ignored_files = 15;</code>
     *
     * @param index The index of the element to return.
     * @return The ignoredFiles at the given index.
     */
    public java.lang.String getIgnoredFiles(int index) {
      return ignoredFiles_.get(index);
    }
    /**
     *
     *
     * <pre>
     * ignored_files and included_files are file glob matches using
     * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
     *
     * If ignored_files and changed files are both empty, then they are
     * not used to determine whether or not to trigger a build.
     *
     * If ignored_files is not empty, then we ignore any files that match
     * any of the ignored_file globs. If the change has no files that are
     * outside of the ignored_files globs, then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string ignored_files = 15;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ignoredFiles at the given index.
     */
    public com.google.protobuf.ByteString getIgnoredFilesBytes(int index) {
      return ignoredFiles_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * ignored_files and included_files are file glob matches using
     * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
     *
     * If ignored_files and changed files are both empty, then they are
     * not used to determine whether or not to trigger a build.
     *
     * If ignored_files is not empty, then we ignore any files that match
     * any of the ignored_file globs. If the change has no files that are
     * outside of the ignored_files globs, then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string ignored_files = 15;</code>
     *
     * @param index The index to set the value at.
     * @param value The ignoredFiles to set.
     * @return This builder for chaining.
     */
    public Builder setIgnoredFiles(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIgnoredFilesIsMutable();
      ignoredFiles_.set(index, value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ignored_files and included_files are file glob matches using
     * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
     *
     * If ignored_files and changed files are both empty, then they are
     * not used to determine whether or not to trigger a build.
     *
     * If ignored_files is not empty, then we ignore any files that match
     * any of the ignored_file globs. If the change has no files that are
     * outside of the ignored_files globs, then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string ignored_files = 15;</code>
     *
     * @param value The ignoredFiles to add.
     * @return This builder for chaining.
     */
    public Builder addIgnoredFiles(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIgnoredFilesIsMutable();
      ignoredFiles_.add(value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ignored_files and included_files are file glob matches using
     * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
     *
     * If ignored_files and changed files are both empty, then they are
     * not used to determine whether or not to trigger a build.
     *
     * If ignored_files is not empty, then we ignore any files that match
     * any of the ignored_file globs. If the change has no files that are
     * outside of the ignored_files globs, then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string ignored_files = 15;</code>
     *
     * @param values The ignoredFiles to add.
     * @return This builder for chaining.
     */
    public Builder addAllIgnoredFiles(java.lang.Iterable<java.lang.String> values) {
      ensureIgnoredFilesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ignoredFiles_);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ignored_files and included_files are file glob matches using
     * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
     *
     * If ignored_files and changed files are both empty, then they are
     * not used to determine whether or not to trigger a build.
     *
     * If ignored_files is not empty, then we ignore any files that match
     * any of the ignored_file globs. If the change has no files that are
     * outside of the ignored_files globs, then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string ignored_files = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIgnoredFiles() {
      ignoredFiles_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00010000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ignored_files and included_files are file glob matches using
     * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
     *
     * If ignored_files and changed files are both empty, then they are
     * not used to determine whether or not to trigger a build.
     *
     * If ignored_files is not empty, then we ignore any files that match
     * any of the ignored_file globs. If the change has no files that are
     * outside of the ignored_files globs, then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string ignored_files = 15;</code>
     *
     * @param value The bytes of the ignoredFiles to add.
     * @return This builder for chaining.
     */
    public Builder addIgnoredFilesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIgnoredFilesIsMutable();
      ignoredFiles_.add(value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList includedFiles_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureIncludedFilesIsMutable() {
      if (!includedFiles_.isModifiable()) {
        includedFiles_ = new com.google.protobuf.LazyStringArrayList(includedFiles_);
      }
      bitField0_ |= 0x00020000;
    }
    /**
     *
     *
     * <pre>
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is empty, then as far as this filter is
     * concerned, we should trigger the build.
     *
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is not empty, then we make sure that at
     * least one of those files matches a included_files glob. If not,
     * then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string included_files = 16;</code>
     *
     * @return A list containing the includedFiles.
     */
    public com.google.protobuf.ProtocolStringList getIncludedFilesList() {
      includedFiles_.makeImmutable();
      return includedFiles_;
    }
    /**
     *
     *
     * <pre>
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is empty, then as far as this filter is
     * concerned, we should trigger the build.
     *
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is not empty, then we make sure that at
     * least one of those files matches a included_files glob. If not,
     * then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string included_files = 16;</code>
     *
     * @return The count of includedFiles.
     */
    public int getIncludedFilesCount() {
      return includedFiles_.size();
    }
    /**
     *
     *
     * <pre>
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is empty, then as far as this filter is
     * concerned, we should trigger the build.
     *
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is not empty, then we make sure that at
     * least one of those files matches a included_files glob. If not,
     * then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string included_files = 16;</code>
     *
     * @param index The index of the element to return.
     * @return The includedFiles at the given index.
     */
    public java.lang.String getIncludedFiles(int index) {
      return includedFiles_.get(index);
    }
    /**
     *
     *
     * <pre>
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is empty, then as far as this filter is
     * concerned, we should trigger the build.
     *
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is not empty, then we make sure that at
     * least one of those files matches a included_files glob. If not,
     * then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string included_files = 16;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the includedFiles at the given index.
     */
    public com.google.protobuf.ByteString getIncludedFilesBytes(int index) {
      return includedFiles_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is empty, then as far as this filter is
     * concerned, we should trigger the build.
     *
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is not empty, then we make sure that at
     * least one of those files matches a included_files glob. If not,
     * then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string included_files = 16;</code>
     *
     * @param index The index to set the value at.
     * @param value The includedFiles to set.
     * @return This builder for chaining.
     */
    public Builder setIncludedFiles(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncludedFilesIsMutable();
      includedFiles_.set(index, value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is empty, then as far as this filter is
     * concerned, we should trigger the build.
     *
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is not empty, then we make sure that at
     * least one of those files matches a included_files glob. If not,
     * then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string included_files = 16;</code>
     *
     * @param value The includedFiles to add.
     * @return This builder for chaining.
     */
    public Builder addIncludedFiles(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncludedFilesIsMutable();
      includedFiles_.add(value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is empty, then as far as this filter is
     * concerned, we should trigger the build.
     *
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is not empty, then we make sure that at
     * least one of those files matches a included_files glob. If not,
     * then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string included_files = 16;</code>
     *
     * @param values The includedFiles to add.
     * @return This builder for chaining.
     */
    public Builder addAllIncludedFiles(java.lang.Iterable<java.lang.String> values) {
      ensureIncludedFilesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, includedFiles_);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is empty, then as far as this filter is
     * concerned, we should trigger the build.
     *
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is not empty, then we make sure that at
     * least one of those files matches a included_files glob. If not,
     * then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string included_files = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludedFiles() {
      includedFiles_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00020000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is empty, then as far as this filter is
     * concerned, we should trigger the build.
     *
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is not empty, then we make sure that at
     * least one of those files matches a included_files glob. If not,
     * then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string included_files = 16;</code>
     *
     * @param value The bytes of the includedFiles to add.
     * @return This builder for chaining.
     */
    public Builder addIncludedFilesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIncludedFilesIsMutable();
      includedFiles_.add(value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A Common Expression Language string.
     * </pre>
     *
     * <code>string filter = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A Common Expression Language string.
     * </pre>
     *
     * <code>string filter = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A Common Expression Language string.
     * </pre>
     *
     * <code>string filter = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A Common Expression Language string.
     * </pre>
     *
     * <code>string filter = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A Common Expression Language string.
     * </pre>
     *
     * <code>string filter = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private com.google.cloudbuild.v1.GitRepoSource sourceToBuild_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.GitRepoSource,
            com.google.cloudbuild.v1.GitRepoSource.Builder,
            com.google.cloudbuild.v1.GitRepoSourceOrBuilder>
        sourceToBuildBuilder_;
    /**
     *
     *
     * <pre>
     * The repo and ref of the repository from which to build. This field
     * is used only for those triggers that do not respond to SCM events.
     * Triggers that respond to such events build source at whatever commit
     * caused the event.
     * This field is currently only used by Webhook, Pub/Sub, Manual, and Cron
     * triggers.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitRepoSource source_to_build = 26;</code>
     *
     * @return Whether the sourceToBuild field is set.
     */
    public boolean hasSourceToBuild() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The repo and ref of the repository from which to build. This field
     * is used only for those triggers that do not respond to SCM events.
     * Triggers that respond to such events build source at whatever commit
     * caused the event.
     * This field is currently only used by Webhook, Pub/Sub, Manual, and Cron
     * triggers.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitRepoSource source_to_build = 26;</code>
     *
     * @return The sourceToBuild.
     */
    public com.google.cloudbuild.v1.GitRepoSource getSourceToBuild() {
      if (sourceToBuildBuilder_ == null) {
        return sourceToBuild_ == null
            ? com.google.cloudbuild.v1.GitRepoSource.getDefaultInstance()
            : sourceToBuild_;
      } else {
        return sourceToBuildBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The repo and ref of the repository from which to build. This field
     * is used only for those triggers that do not respond to SCM events.
     * Triggers that respond to such events build source at whatever commit
     * caused the event.
     * This field is currently only used by Webhook, Pub/Sub, Manual, and Cron
     * triggers.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitRepoSource source_to_build = 26;</code>
     */
    public Builder setSourceToBuild(com.google.cloudbuild.v1.GitRepoSource value) {
      if (sourceToBuildBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceToBuild_ = value;
      } else {
        sourceToBuildBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The repo and ref of the repository from which to build. This field
     * is used only for those triggers that do not respond to SCM events.
     * Triggers that respond to such events build source at whatever commit
     * caused the event.
     * This field is currently only used by Webhook, Pub/Sub, Manual, and Cron
     * triggers.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitRepoSource source_to_build = 26;</code>
     */
    public Builder setSourceToBuild(
        com.google.cloudbuild.v1.GitRepoSource.Builder builderForValue) {
      if (sourceToBuildBuilder_ == null) {
        sourceToBuild_ = builderForValue.build();
      } else {
        sourceToBuildBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The repo and ref of the repository from which to build. This field
     * is used only for those triggers that do not respond to SCM events.
     * Triggers that respond to such events build source at whatever commit
     * caused the event.
     * This field is currently only used by Webhook, Pub/Sub, Manual, and Cron
     * triggers.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitRepoSource source_to_build = 26;</code>
     */
    public Builder mergeSourceToBuild(com.google.cloudbuild.v1.GitRepoSource value) {
      if (sourceToBuildBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && sourceToBuild_ != null
            && sourceToBuild_ != com.google.cloudbuild.v1.GitRepoSource.getDefaultInstance()) {
          getSourceToBuildBuilder().mergeFrom(value);
        } else {
          sourceToBuild_ = value;
        }
      } else {
        sourceToBuildBuilder_.mergeFrom(value);
      }
      if (sourceToBuild_ != null) {
        bitField0_ |= 0x00080000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The repo and ref of the repository from which to build. This field
     * is used only for those triggers that do not respond to SCM events.
     * Triggers that respond to such events build source at whatever commit
     * caused the event.
     * This field is currently only used by Webhook, Pub/Sub, Manual, and Cron
     * triggers.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitRepoSource source_to_build = 26;</code>
     */
    public Builder clearSourceToBuild() {
      bitField0_ = (bitField0_ & ~0x00080000);
      sourceToBuild_ = null;
      if (sourceToBuildBuilder_ != null) {
        sourceToBuildBuilder_.dispose();
        sourceToBuildBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The repo and ref of the repository from which to build. This field
     * is used only for those triggers that do not respond to SCM events.
     * Triggers that respond to such events build source at whatever commit
     * caused the event.
     * This field is currently only used by Webhook, Pub/Sub, Manual, and Cron
     * triggers.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitRepoSource source_to_build = 26;</code>
     */
    public com.google.cloudbuild.v1.GitRepoSource.Builder getSourceToBuildBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getSourceToBuildFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The repo and ref of the repository from which to build. This field
     * is used only for those triggers that do not respond to SCM events.
     * Triggers that respond to such events build source at whatever commit
     * caused the event.
     * This field is currently only used by Webhook, Pub/Sub, Manual, and Cron
     * triggers.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitRepoSource source_to_build = 26;</code>
     */
    public com.google.cloudbuild.v1.GitRepoSourceOrBuilder getSourceToBuildOrBuilder() {
      if (sourceToBuildBuilder_ != null) {
        return sourceToBuildBuilder_.getMessageOrBuilder();
      } else {
        return sourceToBuild_ == null
            ? com.google.cloudbuild.v1.GitRepoSource.getDefaultInstance()
            : sourceToBuild_;
      }
    }
    /**
     *
     *
     * <pre>
     * The repo and ref of the repository from which to build. This field
     * is used only for those triggers that do not respond to SCM events.
     * Triggers that respond to such events build source at whatever commit
     * caused the event.
     * This field is currently only used by Webhook, Pub/Sub, Manual, and Cron
     * triggers.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitRepoSource source_to_build = 26;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.GitRepoSource,
            com.google.cloudbuild.v1.GitRepoSource.Builder,
            com.google.cloudbuild.v1.GitRepoSourceOrBuilder>
        getSourceToBuildFieldBuilder() {
      if (sourceToBuildBuilder_ == null) {
        sourceToBuildBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.GitRepoSource,
                com.google.cloudbuild.v1.GitRepoSource.Builder,
                com.google.cloudbuild.v1.GitRepoSourceOrBuilder>(
                getSourceToBuild(), getParentForChildren(), isClean());
        sourceToBuild_ = null;
      }
      return sourceToBuildBuilder_;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * The service account used for all user-controlled operations including
     * UpdateBuildTrigger, RunBuildTrigger, CreateBuild, and CancelBuild.
     * If no service account is set, then the standard Cloud Build service account
     * ([PROJECT_NUM]&#64;system.gserviceaccount.com) will be used instead.
     * Format: `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_ID_OR_EMAIL}`
     * </pre>
     *
     * <code>string service_account = 33 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service account used for all user-controlled operations including
     * UpdateBuildTrigger, RunBuildTrigger, CreateBuild, and CancelBuild.
     * If no service account is set, then the standard Cloud Build service account
     * ([PROJECT_NUM]&#64;system.gserviceaccount.com) will be used instead.
     * Format: `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_ID_OR_EMAIL}`
     * </pre>
     *
     * <code>string service_account = 33 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service account used for all user-controlled operations including
     * UpdateBuildTrigger, RunBuildTrigger, CreateBuild, and CancelBuild.
     * If no service account is set, then the standard Cloud Build service account
     * ([PROJECT_NUM]&#64;system.gserviceaccount.com) will be used instead.
     * Format: `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_ID_OR_EMAIL}`
     * </pre>
     *
     * <code>string service_account = 33 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service account used for all user-controlled operations including
     * UpdateBuildTrigger, RunBuildTrigger, CreateBuild, and CancelBuild.
     * If no service account is set, then the standard Cloud Build service account
     * ([PROJECT_NUM]&#64;system.gserviceaccount.com) will be used instead.
     * Format: `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_ID_OR_EMAIL}`
     * </pre>
     *
     * <code>string service_account = 33 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00100000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service account used for all user-controlled operations including
     * UpdateBuildTrigger, RunBuildTrigger, CreateBuild, and CancelBuild.
     * If no service account is set, then the standard Cloud Build service account
     * ([PROJECT_NUM]&#64;system.gserviceaccount.com) will be used instead.
     * Format: `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_ID_OR_EMAIL}`
     * </pre>
     *
     * <code>string service_account = 33 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    private com.google.cloudbuild.v1.RepositoryEventConfig repositoryEventConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.RepositoryEventConfig,
            com.google.cloudbuild.v1.RepositoryEventConfig.Builder,
            com.google.cloudbuild.v1.RepositoryEventConfigOrBuilder>
        repositoryEventConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The configuration of a trigger that creates a build whenever an event from
     * Repo API is received.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepositoryEventConfig repository_event_config = 39;
     * </code>
     *
     * @return Whether the repositoryEventConfig field is set.
     */
    public boolean hasRepositoryEventConfig() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The configuration of a trigger that creates a build whenever an event from
     * Repo API is received.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepositoryEventConfig repository_event_config = 39;
     * </code>
     *
     * @return The repositoryEventConfig.
     */
    public com.google.cloudbuild.v1.RepositoryEventConfig getRepositoryEventConfig() {
      if (repositoryEventConfigBuilder_ == null) {
        return repositoryEventConfig_ == null
            ? com.google.cloudbuild.v1.RepositoryEventConfig.getDefaultInstance()
            : repositoryEventConfig_;
      } else {
        return repositoryEventConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration of a trigger that creates a build whenever an event from
     * Repo API is received.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepositoryEventConfig repository_event_config = 39;
     * </code>
     */
    public Builder setRepositoryEventConfig(com.google.cloudbuild.v1.RepositoryEventConfig value) {
      if (repositoryEventConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        repositoryEventConfig_ = value;
      } else {
        repositoryEventConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration of a trigger that creates a build whenever an event from
     * Repo API is received.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepositoryEventConfig repository_event_config = 39;
     * </code>
     */
    public Builder setRepositoryEventConfig(
        com.google.cloudbuild.v1.RepositoryEventConfig.Builder builderForValue) {
      if (repositoryEventConfigBuilder_ == null) {
        repositoryEventConfig_ = builderForValue.build();
      } else {
        repositoryEventConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration of a trigger that creates a build whenever an event from
     * Repo API is received.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepositoryEventConfig repository_event_config = 39;
     * </code>
     */
    public Builder mergeRepositoryEventConfig(
        com.google.cloudbuild.v1.RepositoryEventConfig value) {
      if (repositoryEventConfigBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)
            && repositoryEventConfig_ != null
            && repositoryEventConfig_
                != com.google.cloudbuild.v1.RepositoryEventConfig.getDefaultInstance()) {
          getRepositoryEventConfigBuilder().mergeFrom(value);
        } else {
          repositoryEventConfig_ = value;
        }
      } else {
        repositoryEventConfigBuilder_.mergeFrom(value);
      }
      if (repositoryEventConfig_ != null) {
        bitField0_ |= 0x00200000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration of a trigger that creates a build whenever an event from
     * Repo API is received.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepositoryEventConfig repository_event_config = 39;
     * </code>
     */
    public Builder clearRepositoryEventConfig() {
      bitField0_ = (bitField0_ & ~0x00200000);
      repositoryEventConfig_ = null;
      if (repositoryEventConfigBuilder_ != null) {
        repositoryEventConfigBuilder_.dispose();
        repositoryEventConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration of a trigger that creates a build whenever an event from
     * Repo API is received.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepositoryEventConfig repository_event_config = 39;
     * </code>
     */
    public com.google.cloudbuild.v1.RepositoryEventConfig.Builder
        getRepositoryEventConfigBuilder() {
      bitField0_ |= 0x00200000;
      onChanged();
      return getRepositoryEventConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The configuration of a trigger that creates a build whenever an event from
     * Repo API is received.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepositoryEventConfig repository_event_config = 39;
     * </code>
     */
    public com.google.cloudbuild.v1.RepositoryEventConfigOrBuilder
        getRepositoryEventConfigOrBuilder() {
      if (repositoryEventConfigBuilder_ != null) {
        return repositoryEventConfigBuilder_.getMessageOrBuilder();
      } else {
        return repositoryEventConfig_ == null
            ? com.google.cloudbuild.v1.RepositoryEventConfig.getDefaultInstance()
            : repositoryEventConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration of a trigger that creates a build whenever an event from
     * Repo API is received.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepositoryEventConfig repository_event_config = 39;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.RepositoryEventConfig,
            com.google.cloudbuild.v1.RepositoryEventConfig.Builder,
            com.google.cloudbuild.v1.RepositoryEventConfigOrBuilder>
        getRepositoryEventConfigFieldBuilder() {
      if (repositoryEventConfigBuilder_ == null) {
        repositoryEventConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.RepositoryEventConfig,
                com.google.cloudbuild.v1.RepositoryEventConfig.Builder,
                com.google.cloudbuild.v1.RepositoryEventConfigOrBuilder>(
                getRepositoryEventConfig(), getParentForChildren(), isClean());
        repositoryEventConfig_ = null;
      }
      return repositoryEventConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.BuildTrigger)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.BuildTrigger)
  private static final com.google.cloudbuild.v1.BuildTrigger DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.BuildTrigger();
  }

  public static com.google.cloudbuild.v1.BuildTrigger getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BuildTrigger> PARSER =
      new com.google.protobuf.AbstractParser<BuildTrigger>() {
        @java.lang.Override
        public BuildTrigger parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BuildTrigger> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BuildTrigger> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.BuildTrigger getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
