/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

// Protobuf Java Version: 3.25.5
package com.google.cloudbuild.v1;

/**
 *
 *
 * <pre>
 * Configuration for a V1 `PrivatePool`.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v1.PrivatePoolV1Config}
 */
public final class PrivatePoolV1Config extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.PrivatePoolV1Config)
    PrivatePoolV1ConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PrivatePoolV1Config.newBuilder() to construct.
  private PrivatePoolV1Config(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PrivatePoolV1Config() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PrivatePoolV1Config();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_PrivatePoolV1Config_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_PrivatePoolV1Config_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.PrivatePoolV1Config.class,
            com.google.cloudbuild.v1.PrivatePoolV1Config.Builder.class);
  }

  public interface WorkerConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.devtools.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Machine type of a worker, such as `e2-medium`.
     * See [Worker pool config
     * file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema).
     * If left blank, Cloud Build will use a sensible default.
     * </pre>
     *
     * <code>string machine_type = 1;</code>
     *
     * @return The machineType.
     */
    java.lang.String getMachineType();
    /**
     *
     *
     * <pre>
     * Machine type of a worker, such as `e2-medium`.
     * See [Worker pool config
     * file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema).
     * If left blank, Cloud Build will use a sensible default.
     * </pre>
     *
     * <code>string machine_type = 1;</code>
     *
     * @return The bytes for machineType.
     */
    com.google.protobuf.ByteString getMachineTypeBytes();

    /**
     *
     *
     * <pre>
     * Size of the disk attached to the worker, in GB.
     * See [Worker pool config
     * file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema).
     * Specify a value of up to 2000. If `0` is specified, Cloud Build will use
     * a standard disk size.
     * </pre>
     *
     * <code>int64 disk_size_gb = 2;</code>
     *
     * @return The diskSizeGb.
     */
    long getDiskSizeGb();
  }
  /**
   *
   *
   * <pre>
   * Defines the configuration to be used for creating workers in
   * the pool.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig}
   */
  public static final class WorkerConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig)
      WorkerConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use WorkerConfig.newBuilder() to construct.
    private WorkerConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private WorkerConfig() {
      machineType_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new WorkerConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_PrivatePoolV1Config_WorkerConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_PrivatePoolV1Config_WorkerConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig.class,
              com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig.Builder.class);
    }

    public static final int MACHINE_TYPE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object machineType_ = "";
    /**
     *
     *
     * <pre>
     * Machine type of a worker, such as `e2-medium`.
     * See [Worker pool config
     * file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema).
     * If left blank, Cloud Build will use a sensible default.
     * </pre>
     *
     * <code>string machine_type = 1;</code>
     *
     * @return The machineType.
     */
    @java.lang.Override
    public java.lang.String getMachineType() {
      java.lang.Object ref = machineType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Machine type of a worker, such as `e2-medium`.
     * See [Worker pool config
     * file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema).
     * If left blank, Cloud Build will use a sensible default.
     * </pre>
     *
     * <code>string machine_type = 1;</code>
     *
     * @return The bytes for machineType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMachineTypeBytes() {
      java.lang.Object ref = machineType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DISK_SIZE_GB_FIELD_NUMBER = 2;
    private long diskSizeGb_ = 0L;
    /**
     *
     *
     * <pre>
     * Size of the disk attached to the worker, in GB.
     * See [Worker pool config
     * file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema).
     * Specify a value of up to 2000. If `0` is specified, Cloud Build will use
     * a standard disk size.
     * </pre>
     *
     * <code>int64 disk_size_gb = 2;</code>
     *
     * @return The diskSizeGb.
     */
    @java.lang.Override
    public long getDiskSizeGb() {
      return diskSizeGb_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, machineType_);
      }
      if (diskSizeGb_ != 0L) {
        output.writeInt64(2, diskSizeGb_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, machineType_);
      }
      if (diskSizeGb_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, diskSizeGb_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig)) {
        return super.equals(obj);
      }
      com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig other =
          (com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig) obj;

      if (!getMachineType().equals(other.getMachineType())) return false;
      if (getDiskSizeGb() != other.getDiskSizeGb()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MACHINE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getMachineType().hashCode();
      hash = (37 * hash) + DISK_SIZE_GB_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getDiskSizeGb());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Defines the configuration to be used for creating workers in
     * the pool.
     * </pre>
     *
     * Protobuf type {@code google.devtools.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig)
        com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_PrivatePoolV1Config_WorkerConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_PrivatePoolV1Config_WorkerConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig.class,
                com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig.Builder.class);
      }

      // Construct using com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        machineType_ = "";
        diskSizeGb_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_PrivatePoolV1Config_WorkerConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig getDefaultInstanceForType() {
        return com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig build() {
        com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig buildPartial() {
        com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig result =
            new com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.machineType_ = machineType_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.diskSizeGb_ = diskSizeGb_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig) {
          return mergeFrom((com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig other) {
        if (other == com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig.getDefaultInstance())
          return this;
        if (!other.getMachineType().isEmpty()) {
          machineType_ = other.machineType_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getDiskSizeGb() != 0L) {
          setDiskSizeGb(other.getDiskSizeGb());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  machineType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  diskSizeGb_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object machineType_ = "";
      /**
       *
       *
       * <pre>
       * Machine type of a worker, such as `e2-medium`.
       * See [Worker pool config
       * file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema).
       * If left blank, Cloud Build will use a sensible default.
       * </pre>
       *
       * <code>string machine_type = 1;</code>
       *
       * @return The machineType.
       */
      public java.lang.String getMachineType() {
        java.lang.Object ref = machineType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          machineType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Machine type of a worker, such as `e2-medium`.
       * See [Worker pool config
       * file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema).
       * If left blank, Cloud Build will use a sensible default.
       * </pre>
       *
       * <code>string machine_type = 1;</code>
       *
       * @return The bytes for machineType.
       */
      public com.google.protobuf.ByteString getMachineTypeBytes() {
        java.lang.Object ref = machineType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          machineType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Machine type of a worker, such as `e2-medium`.
       * See [Worker pool config
       * file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema).
       * If left blank, Cloud Build will use a sensible default.
       * </pre>
       *
       * <code>string machine_type = 1;</code>
       *
       * @param value The machineType to set.
       * @return This builder for chaining.
       */
      public Builder setMachineType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        machineType_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Machine type of a worker, such as `e2-medium`.
       * See [Worker pool config
       * file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema).
       * If left blank, Cloud Build will use a sensible default.
       * </pre>
       *
       * <code>string machine_type = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMachineType() {
        machineType_ = getDefaultInstance().getMachineType();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Machine type of a worker, such as `e2-medium`.
       * See [Worker pool config
       * file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema).
       * If left blank, Cloud Build will use a sensible default.
       * </pre>
       *
       * <code>string machine_type = 1;</code>
       *
       * @param value The bytes for machineType to set.
       * @return This builder for chaining.
       */
      public Builder setMachineTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        machineType_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private long diskSizeGb_;
      /**
       *
       *
       * <pre>
       * Size of the disk attached to the worker, in GB.
       * See [Worker pool config
       * file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema).
       * Specify a value of up to 2000. If `0` is specified, Cloud Build will use
       * a standard disk size.
       * </pre>
       *
       * <code>int64 disk_size_gb = 2;</code>
       *
       * @return The diskSizeGb.
       */
      @java.lang.Override
      public long getDiskSizeGb() {
        return diskSizeGb_;
      }
      /**
       *
       *
       * <pre>
       * Size of the disk attached to the worker, in GB.
       * See [Worker pool config
       * file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema).
       * Specify a value of up to 2000. If `0` is specified, Cloud Build will use
       * a standard disk size.
       * </pre>
       *
       * <code>int64 disk_size_gb = 2;</code>
       *
       * @param value The diskSizeGb to set.
       * @return This builder for chaining.
       */
      public Builder setDiskSizeGb(long value) {

        diskSizeGb_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Size of the disk attached to the worker, in GB.
       * See [Worker pool config
       * file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema).
       * Specify a value of up to 2000. If `0` is specified, Cloud Build will use
       * a standard disk size.
       * </pre>
       *
       * <code>int64 disk_size_gb = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDiskSizeGb() {
        bitField0_ = (bitField0_ & ~0x00000002);
        diskSizeGb_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig)
    }

    // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig)
    private static final com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig();
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WorkerConfig> PARSER =
        new com.google.protobuf.AbstractParser<WorkerConfig>() {
          @java.lang.Override
          public WorkerConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<WorkerConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WorkerConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NetworkConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Immutable. The network definition that the workers are peered
     * to. If this section is left empty, the workers will be peered to
     * `WorkerPool.project_id` on the service producer network. Must be in the
     * format `projects/{project}/global/networks/{network}`, where `{project}`
     * is a project number, such as `12345`, and `{network}` is the name of a
     * VPC network in the project. See
     * [Understanding network configuration
     * options](https://cloud.google.com/build/docs/private-pools/set-up-private-pool-environment)
     * </pre>
     *
     * <code>
     * string peered_network = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The peeredNetwork.
     */
    java.lang.String getPeeredNetwork();
    /**
     *
     *
     * <pre>
     * Required. Immutable. The network definition that the workers are peered
     * to. If this section is left empty, the workers will be peered to
     * `WorkerPool.project_id` on the service producer network. Must be in the
     * format `projects/{project}/global/networks/{network}`, where `{project}`
     * is a project number, such as `12345`, and `{network}` is the name of a
     * VPC network in the project. See
     * [Understanding network configuration
     * options](https://cloud.google.com/build/docs/private-pools/set-up-private-pool-environment)
     * </pre>
     *
     * <code>
     * string peered_network = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for peeredNetwork.
     */
    com.google.protobuf.ByteString getPeeredNetworkBytes();

    /**
     *
     *
     * <pre>
     * Option to configure network egress for the workers.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption egress_option = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for egressOption.
     */
    int getEgressOptionValue();
    /**
     *
     *
     * <pre>
     * Option to configure network egress for the workers.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption egress_option = 2;
     * </code>
     *
     * @return The egressOption.
     */
    com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption getEgressOption();

    /**
     *
     *
     * <pre>
     * Immutable. Subnet IP range within the peered network. This is specified
     * in CIDR notation with a slash and the subnet prefix size. You can
     * optionally specify an IP address before the subnet prefix value. e.g.
     * `192.168.0.0/29` would specify an IP range starting at 192.168.0.0 with a
     * prefix size of 29 bits.
     * `/16` would specify a prefix size of 16 bits, with an automatically
     * determined IP within the peered VPC.
     * If unspecified, a value of `/24` will be used.
     * </pre>
     *
     * <code>string peered_network_ip_range = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The peeredNetworkIpRange.
     */
    java.lang.String getPeeredNetworkIpRange();
    /**
     *
     *
     * <pre>
     * Immutable. Subnet IP range within the peered network. This is specified
     * in CIDR notation with a slash and the subnet prefix size. You can
     * optionally specify an IP address before the subnet prefix value. e.g.
     * `192.168.0.0/29` would specify an IP range starting at 192.168.0.0 with a
     * prefix size of 29 bits.
     * `/16` would specify a prefix size of 16 bits, with an automatically
     * determined IP within the peered VPC.
     * If unspecified, a value of `/24` will be used.
     * </pre>
     *
     * <code>string peered_network_ip_range = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for peeredNetworkIpRange.
     */
    com.google.protobuf.ByteString getPeeredNetworkIpRangeBytes();
  }
  /**
   *
   *
   * <pre>
   * Defines the network configuration for the pool.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig}
   */
  public static final class NetworkConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig)
      NetworkConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use NetworkConfig.newBuilder() to construct.
    private NetworkConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NetworkConfig() {
      peeredNetwork_ = "";
      egressOption_ = 0;
      peeredNetworkIpRange_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new NetworkConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_PrivatePoolV1Config_NetworkConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_PrivatePoolV1Config_NetworkConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.class,
              com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Defines the egress option for the pool.
     * </pre>
     *
     * Protobuf enum {@code
     * google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption}
     */
    public enum EgressOption implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * If set, defaults to PUBLIC_EGRESS.
       * </pre>
       *
       * <code>EGRESS_OPTION_UNSPECIFIED = 0;</code>
       */
      EGRESS_OPTION_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * If set, workers are created without any public address, which prevents
       * network egress to public IPs unless a network proxy is configured.
       * </pre>
       *
       * <code>NO_PUBLIC_EGRESS = 1;</code>
       */
      NO_PUBLIC_EGRESS(1),
      /**
       *
       *
       * <pre>
       * If set, workers are created with a public address which allows for
       * public internet egress.
       * </pre>
       *
       * <code>PUBLIC_EGRESS = 2;</code>
       */
      PUBLIC_EGRESS(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * If set, defaults to PUBLIC_EGRESS.
       * </pre>
       *
       * <code>EGRESS_OPTION_UNSPECIFIED = 0;</code>
       */
      public static final int EGRESS_OPTION_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * If set, workers are created without any public address, which prevents
       * network egress to public IPs unless a network proxy is configured.
       * </pre>
       *
       * <code>NO_PUBLIC_EGRESS = 1;</code>
       */
      public static final int NO_PUBLIC_EGRESS_VALUE = 1;
      /**
       *
       *
       * <pre>
       * If set, workers are created with a public address which allows for
       * public internet egress.
       * </pre>
       *
       * <code>PUBLIC_EGRESS = 2;</code>
       */
      public static final int PUBLIC_EGRESS_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static EgressOption valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static EgressOption forNumber(int value) {
        switch (value) {
          case 0:
            return EGRESS_OPTION_UNSPECIFIED;
          case 1:
            return NO_PUBLIC_EGRESS;
          case 2:
            return PUBLIC_EGRESS;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<EgressOption> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<EgressOption> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<EgressOption>() {
            public EgressOption findValueByNumber(int number) {
              return EgressOption.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final EgressOption[] VALUES = values();

      public static EgressOption valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private EgressOption(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption)
    }

    public static final int PEERED_NETWORK_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object peeredNetwork_ = "";
    /**
     *
     *
     * <pre>
     * Required. Immutable. The network definition that the workers are peered
     * to. If this section is left empty, the workers will be peered to
     * `WorkerPool.project_id` on the service producer network. Must be in the
     * format `projects/{project}/global/networks/{network}`, where `{project}`
     * is a project number, such as `12345`, and `{network}` is the name of a
     * VPC network in the project. See
     * [Understanding network configuration
     * options](https://cloud.google.com/build/docs/private-pools/set-up-private-pool-environment)
     * </pre>
     *
     * <code>
     * string peered_network = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The peeredNetwork.
     */
    @java.lang.Override
    public java.lang.String getPeeredNetwork() {
      java.lang.Object ref = peeredNetwork_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        peeredNetwork_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The network definition that the workers are peered
     * to. If this section is left empty, the workers will be peered to
     * `WorkerPool.project_id` on the service producer network. Must be in the
     * format `projects/{project}/global/networks/{network}`, where `{project}`
     * is a project number, such as `12345`, and `{network}` is the name of a
     * VPC network in the project. See
     * [Understanding network configuration
     * options](https://cloud.google.com/build/docs/private-pools/set-up-private-pool-environment)
     * </pre>
     *
     * <code>
     * string peered_network = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for peeredNetwork.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPeeredNetworkBytes() {
      java.lang.Object ref = peeredNetwork_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        peeredNetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int EGRESS_OPTION_FIELD_NUMBER = 2;
    private int egressOption_ = 0;
    /**
     *
     *
     * <pre>
     * Option to configure network egress for the workers.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption egress_option = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for egressOption.
     */
    @java.lang.Override
    public int getEgressOptionValue() {
      return egressOption_;
    }
    /**
     *
     *
     * <pre>
     * Option to configure network egress for the workers.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption egress_option = 2;
     * </code>
     *
     * @return The egressOption.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption
        getEgressOption() {
      com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption result =
          com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption.forNumber(
              egressOption_);
      return result == null
          ? com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption.UNRECOGNIZED
          : result;
    }

    public static final int PEERED_NETWORK_IP_RANGE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object peeredNetworkIpRange_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Subnet IP range within the peered network. This is specified
     * in CIDR notation with a slash and the subnet prefix size. You can
     * optionally specify an IP address before the subnet prefix value. e.g.
     * `192.168.0.0/29` would specify an IP range starting at 192.168.0.0 with a
     * prefix size of 29 bits.
     * `/16` would specify a prefix size of 16 bits, with an automatically
     * determined IP within the peered VPC.
     * If unspecified, a value of `/24` will be used.
     * </pre>
     *
     * <code>string peered_network_ip_range = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The peeredNetworkIpRange.
     */
    @java.lang.Override
    public java.lang.String getPeeredNetworkIpRange() {
      java.lang.Object ref = peeredNetworkIpRange_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        peeredNetworkIpRange_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Subnet IP range within the peered network. This is specified
     * in CIDR notation with a slash and the subnet prefix size. You can
     * optionally specify an IP address before the subnet prefix value. e.g.
     * `192.168.0.0/29` would specify an IP range starting at 192.168.0.0 with a
     * prefix size of 29 bits.
     * `/16` would specify a prefix size of 16 bits, with an automatically
     * determined IP within the peered VPC.
     * If unspecified, a value of `/24` will be used.
     * </pre>
     *
     * <code>string peered_network_ip_range = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for peeredNetworkIpRange.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPeeredNetworkIpRangeBytes() {
      java.lang.Object ref = peeredNetworkIpRange_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        peeredNetworkIpRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(peeredNetwork_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, peeredNetwork_);
      }
      if (egressOption_
          != com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption
              .EGRESS_OPTION_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, egressOption_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(peeredNetworkIpRange_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, peeredNetworkIpRange_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(peeredNetwork_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, peeredNetwork_);
      }
      if (egressOption_
          != com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption
              .EGRESS_OPTION_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, egressOption_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(peeredNetworkIpRange_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, peeredNetworkIpRange_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig)) {
        return super.equals(obj);
      }
      com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig other =
          (com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig) obj;

      if (!getPeeredNetwork().equals(other.getPeeredNetwork())) return false;
      if (egressOption_ != other.egressOption_) return false;
      if (!getPeeredNetworkIpRange().equals(other.getPeeredNetworkIpRange())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PEERED_NETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getPeeredNetwork().hashCode();
      hash = (37 * hash) + EGRESS_OPTION_FIELD_NUMBER;
      hash = (53 * hash) + egressOption_;
      hash = (37 * hash) + PEERED_NETWORK_IP_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getPeeredNetworkIpRange().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Defines the network configuration for the pool.
     * </pre>
     *
     * Protobuf type {@code google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig)
        com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_PrivatePoolV1Config_NetworkConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_PrivatePoolV1Config_NetworkConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.class,
                com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.Builder.class);
      }

      // Construct using com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        peeredNetwork_ = "";
        egressOption_ = 0;
        peeredNetworkIpRange_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_PrivatePoolV1Config_NetworkConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig
          getDefaultInstanceForType() {
        return com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig build() {
        com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig buildPartial() {
        com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig result =
            new com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.peeredNetwork_ = peeredNetwork_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.egressOption_ = egressOption_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.peeredNetworkIpRange_ = peeredNetworkIpRange_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig) {
          return mergeFrom((com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig other) {
        if (other
            == com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.getDefaultInstance())
          return this;
        if (!other.getPeeredNetwork().isEmpty()) {
          peeredNetwork_ = other.peeredNetwork_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.egressOption_ != 0) {
          setEgressOptionValue(other.getEgressOptionValue());
        }
        if (!other.getPeeredNetworkIpRange().isEmpty()) {
          peeredNetworkIpRange_ = other.peeredNetworkIpRange_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  peeredNetwork_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  egressOption_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  peeredNetworkIpRange_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object peeredNetwork_ = "";
      /**
       *
       *
       * <pre>
       * Required. Immutable. The network definition that the workers are peered
       * to. If this section is left empty, the workers will be peered to
       * `WorkerPool.project_id` on the service producer network. Must be in the
       * format `projects/{project}/global/networks/{network}`, where `{project}`
       * is a project number, such as `12345`, and `{network}` is the name of a
       * VPC network in the project. See
       * [Understanding network configuration
       * options](https://cloud.google.com/build/docs/private-pools/set-up-private-pool-environment)
       * </pre>
       *
       * <code>
       * string peered_network = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The peeredNetwork.
       */
      public java.lang.String getPeeredNetwork() {
        java.lang.Object ref = peeredNetwork_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          peeredNetwork_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. The network definition that the workers are peered
       * to. If this section is left empty, the workers will be peered to
       * `WorkerPool.project_id` on the service producer network. Must be in the
       * format `projects/{project}/global/networks/{network}`, where `{project}`
       * is a project number, such as `12345`, and `{network}` is the name of a
       * VPC network in the project. See
       * [Understanding network configuration
       * options](https://cloud.google.com/build/docs/private-pools/set-up-private-pool-environment)
       * </pre>
       *
       * <code>
       * string peered_network = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for peeredNetwork.
       */
      public com.google.protobuf.ByteString getPeeredNetworkBytes() {
        java.lang.Object ref = peeredNetwork_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          peeredNetwork_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. The network definition that the workers are peered
       * to. If this section is left empty, the workers will be peered to
       * `WorkerPool.project_id` on the service producer network. Must be in the
       * format `projects/{project}/global/networks/{network}`, where `{project}`
       * is a project number, such as `12345`, and `{network}` is the name of a
       * VPC network in the project. See
       * [Understanding network configuration
       * options](https://cloud.google.com/build/docs/private-pools/set-up-private-pool-environment)
       * </pre>
       *
       * <code>
       * string peered_network = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The peeredNetwork to set.
       * @return This builder for chaining.
       */
      public Builder setPeeredNetwork(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        peeredNetwork_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. The network definition that the workers are peered
       * to. If this section is left empty, the workers will be peered to
       * `WorkerPool.project_id` on the service producer network. Must be in the
       * format `projects/{project}/global/networks/{network}`, where `{project}`
       * is a project number, such as `12345`, and `{network}` is the name of a
       * VPC network in the project. See
       * [Understanding network configuration
       * options](https://cloud.google.com/build/docs/private-pools/set-up-private-pool-environment)
       * </pre>
       *
       * <code>
       * string peered_network = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPeeredNetwork() {
        peeredNetwork_ = getDefaultInstance().getPeeredNetwork();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. The network definition that the workers are peered
       * to. If this section is left empty, the workers will be peered to
       * `WorkerPool.project_id` on the service producer network. Must be in the
       * format `projects/{project}/global/networks/{network}`, where `{project}`
       * is a project number, such as `12345`, and `{network}` is the name of a
       * VPC network in the project. See
       * [Understanding network configuration
       * options](https://cloud.google.com/build/docs/private-pools/set-up-private-pool-environment)
       * </pre>
       *
       * <code>
       * string peered_network = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for peeredNetwork to set.
       * @return This builder for chaining.
       */
      public Builder setPeeredNetworkBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        peeredNetwork_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int egressOption_ = 0;
      /**
       *
       *
       * <pre>
       * Option to configure network egress for the workers.
       * </pre>
       *
       * <code>
       * .google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption egress_option = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for egressOption.
       */
      @java.lang.Override
      public int getEgressOptionValue() {
        return egressOption_;
      }
      /**
       *
       *
       * <pre>
       * Option to configure network egress for the workers.
       * </pre>
       *
       * <code>
       * .google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption egress_option = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for egressOption to set.
       * @return This builder for chaining.
       */
      public Builder setEgressOptionValue(int value) {
        egressOption_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Option to configure network egress for the workers.
       * </pre>
       *
       * <code>
       * .google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption egress_option = 2;
       * </code>
       *
       * @return The egressOption.
       */
      @java.lang.Override
      public com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption
          getEgressOption() {
        com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption result =
            com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption.forNumber(
                egressOption_);
        return result == null
            ? com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Option to configure network egress for the workers.
       * </pre>
       *
       * <code>
       * .google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption egress_option = 2;
       * </code>
       *
       * @param value The egressOption to set.
       * @return This builder for chaining.
       */
      public Builder setEgressOption(
          com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        egressOption_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Option to configure network egress for the workers.
       * </pre>
       *
       * <code>
       * .google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.EgressOption egress_option = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEgressOption() {
        bitField0_ = (bitField0_ & ~0x00000002);
        egressOption_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object peeredNetworkIpRange_ = "";
      /**
       *
       *
       * <pre>
       * Immutable. Subnet IP range within the peered network. This is specified
       * in CIDR notation with a slash and the subnet prefix size. You can
       * optionally specify an IP address before the subnet prefix value. e.g.
       * `192.168.0.0/29` would specify an IP range starting at 192.168.0.0 with a
       * prefix size of 29 bits.
       * `/16` would specify a prefix size of 16 bits, with an automatically
       * determined IP within the peered VPC.
       * If unspecified, a value of `/24` will be used.
       * </pre>
       *
       * <code>string peered_network_ip_range = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return The peeredNetworkIpRange.
       */
      public java.lang.String getPeeredNetworkIpRange() {
        java.lang.Object ref = peeredNetworkIpRange_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          peeredNetworkIpRange_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Immutable. Subnet IP range within the peered network. This is specified
       * in CIDR notation with a slash and the subnet prefix size. You can
       * optionally specify an IP address before the subnet prefix value. e.g.
       * `192.168.0.0/29` would specify an IP range starting at 192.168.0.0 with a
       * prefix size of 29 bits.
       * `/16` would specify a prefix size of 16 bits, with an automatically
       * determined IP within the peered VPC.
       * If unspecified, a value of `/24` will be used.
       * </pre>
       *
       * <code>string peered_network_ip_range = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return The bytes for peeredNetworkIpRange.
       */
      public com.google.protobuf.ByteString getPeeredNetworkIpRangeBytes() {
        java.lang.Object ref = peeredNetworkIpRange_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          peeredNetworkIpRange_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Immutable. Subnet IP range within the peered network. This is specified
       * in CIDR notation with a slash and the subnet prefix size. You can
       * optionally specify an IP address before the subnet prefix value. e.g.
       * `192.168.0.0/29` would specify an IP range starting at 192.168.0.0 with a
       * prefix size of 29 bits.
       * `/16` would specify a prefix size of 16 bits, with an automatically
       * determined IP within the peered VPC.
       * If unspecified, a value of `/24` will be used.
       * </pre>
       *
       * <code>string peered_network_ip_range = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @param value The peeredNetworkIpRange to set.
       * @return This builder for chaining.
       */
      public Builder setPeeredNetworkIpRange(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        peeredNetworkIpRange_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Immutable. Subnet IP range within the peered network. This is specified
       * in CIDR notation with a slash and the subnet prefix size. You can
       * optionally specify an IP address before the subnet prefix value. e.g.
       * `192.168.0.0/29` would specify an IP range starting at 192.168.0.0 with a
       * prefix size of 29 bits.
       * `/16` would specify a prefix size of 16 bits, with an automatically
       * determined IP within the peered VPC.
       * If unspecified, a value of `/24` will be used.
       * </pre>
       *
       * <code>string peered_network_ip_range = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPeeredNetworkIpRange() {
        peeredNetworkIpRange_ = getDefaultInstance().getPeeredNetworkIpRange();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Immutable. Subnet IP range within the peered network. This is specified
       * in CIDR notation with a slash and the subnet prefix size. You can
       * optionally specify an IP address before the subnet prefix value. e.g.
       * `192.168.0.0/29` would specify an IP range starting at 192.168.0.0 with a
       * prefix size of 29 bits.
       * `/16` would specify a prefix size of 16 bits, with an automatically
       * determined IP within the peered VPC.
       * If unspecified, a value of `/24` will be used.
       * </pre>
       *
       * <code>string peered_network_ip_range = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @param value The bytes for peeredNetworkIpRange to set.
       * @return This builder for chaining.
       */
      public Builder setPeeredNetworkIpRangeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        peeredNetworkIpRange_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig)
    }

    // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig)
    private static final com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig();
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<NetworkConfig> PARSER =
        new com.google.protobuf.AbstractParser<NetworkConfig>() {
          @java.lang.Override
          public NetworkConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<NetworkConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NetworkConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PrivateServiceConnectOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.devtools.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Immutable. The network attachment that the worker network
     * interface is peered to. Must be in the format
     * `projects/{project}/regions/{region}/networkAttachments/{networkAttachment}`.
     * The region of network attachment must be the same as the worker pool.
     * See [Network
     * Attachments](https://cloud.google.com/vpc/docs/about-network-attachments)
     * </pre>
     *
     * <code>
     * string network_attachment = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The networkAttachment.
     */
    java.lang.String getNetworkAttachment();
    /**
     *
     *
     * <pre>
     * Required. Immutable. The network attachment that the worker network
     * interface is peered to. Must be in the format
     * `projects/{project}/regions/{region}/networkAttachments/{networkAttachment}`.
     * The region of network attachment must be the same as the worker pool.
     * See [Network
     * Attachments](https://cloud.google.com/vpc/docs/about-network-attachments)
     * </pre>
     *
     * <code>
     * string network_attachment = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for networkAttachment.
     */
    com.google.protobuf.ByteString getNetworkAttachmentBytes();

    /**
     *
     *
     * <pre>
     * Required. Immutable. Disable public IP on the primary network interface.
     *
     * If true, workers are created without any public address, which prevents
     * network egress to public IPs unless a network proxy is configured.
     * If false, workers are created with a public address which allows for
     * public internet egress. The public address only applies to traffic
     * through the primary network interface.
     * If `route_all_traffic` is set to true, all traffic will go through the
     * non-primary network interface, this boolean has no effect.
     * </pre>
     *
     * <code>
     * bool public_ip_address_disabled = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The publicIpAddressDisabled.
     */
    boolean getPublicIpAddressDisabled();

    /**
     *
     *
     * <pre>
     * Immutable. Route all traffic through PSC interface. Enable this if you
     * want full control of traffic in the private pool. Configure Cloud NAT for
     * the subnet of network attachment if you need to access public Internet.
     *
     * If false, Only route private IPs, e.g. 10.0.0.0/8, 172.16.0.0/12, and
     * 192.168.0.0/16 through PSC interface.
     * </pre>
     *
     * <code>bool route_all_traffic = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The routeAllTraffic.
     */
    boolean getRouteAllTraffic();
  }
  /**
   *
   *
   * <pre>
   * Defines the Private Service Connect network configuration for the pool.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect}
   */
  public static final class PrivateServiceConnect extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect)
      PrivateServiceConnectOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PrivateServiceConnect.newBuilder() to construct.
    private PrivateServiceConnect(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PrivateServiceConnect() {
      networkAttachment_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PrivateServiceConnect();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_PrivatePoolV1Config_PrivateServiceConnect_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_PrivatePoolV1Config_PrivateServiceConnect_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect.class,
              com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect.Builder.class);
    }

    public static final int NETWORK_ATTACHMENT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object networkAttachment_ = "";
    /**
     *
     *
     * <pre>
     * Required. Immutable. The network attachment that the worker network
     * interface is peered to. Must be in the format
     * `projects/{project}/regions/{region}/networkAttachments/{networkAttachment}`.
     * The region of network attachment must be the same as the worker pool.
     * See [Network
     * Attachments](https://cloud.google.com/vpc/docs/about-network-attachments)
     * </pre>
     *
     * <code>
     * string network_attachment = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The networkAttachment.
     */
    @java.lang.Override
    public java.lang.String getNetworkAttachment() {
      java.lang.Object ref = networkAttachment_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        networkAttachment_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The network attachment that the worker network
     * interface is peered to. Must be in the format
     * `projects/{project}/regions/{region}/networkAttachments/{networkAttachment}`.
     * The region of network attachment must be the same as the worker pool.
     * See [Network
     * Attachments](https://cloud.google.com/vpc/docs/about-network-attachments)
     * </pre>
     *
     * <code>
     * string network_attachment = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for networkAttachment.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNetworkAttachmentBytes() {
      java.lang.Object ref = networkAttachment_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        networkAttachment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PUBLIC_IP_ADDRESS_DISABLED_FIELD_NUMBER = 2;
    private boolean publicIpAddressDisabled_ = false;
    /**
     *
     *
     * <pre>
     * Required. Immutable. Disable public IP on the primary network interface.
     *
     * If true, workers are created without any public address, which prevents
     * network egress to public IPs unless a network proxy is configured.
     * If false, workers are created with a public address which allows for
     * public internet egress. The public address only applies to traffic
     * through the primary network interface.
     * If `route_all_traffic` is set to true, all traffic will go through the
     * non-primary network interface, this boolean has no effect.
     * </pre>
     *
     * <code>
     * bool public_ip_address_disabled = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The publicIpAddressDisabled.
     */
    @java.lang.Override
    public boolean getPublicIpAddressDisabled() {
      return publicIpAddressDisabled_;
    }

    public static final int ROUTE_ALL_TRAFFIC_FIELD_NUMBER = 3;
    private boolean routeAllTraffic_ = false;
    /**
     *
     *
     * <pre>
     * Immutable. Route all traffic through PSC interface. Enable this if you
     * want full control of traffic in the private pool. Configure Cloud NAT for
     * the subnet of network attachment if you need to access public Internet.
     *
     * If false, Only route private IPs, e.g. 10.0.0.0/8, 172.16.0.0/12, and
     * 192.168.0.0/16 through PSC interface.
     * </pre>
     *
     * <code>bool route_all_traffic = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The routeAllTraffic.
     */
    @java.lang.Override
    public boolean getRouteAllTraffic() {
      return routeAllTraffic_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkAttachment_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, networkAttachment_);
      }
      if (publicIpAddressDisabled_ != false) {
        output.writeBool(2, publicIpAddressDisabled_);
      }
      if (routeAllTraffic_ != false) {
        output.writeBool(3, routeAllTraffic_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkAttachment_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, networkAttachment_);
      }
      if (publicIpAddressDisabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, publicIpAddressDisabled_);
      }
      if (routeAllTraffic_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, routeAllTraffic_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect)) {
        return super.equals(obj);
      }
      com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect other =
          (com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect) obj;

      if (!getNetworkAttachment().equals(other.getNetworkAttachment())) return false;
      if (getPublicIpAddressDisabled() != other.getPublicIpAddressDisabled()) return false;
      if (getRouteAllTraffic() != other.getRouteAllTraffic()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NETWORK_ATTACHMENT_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkAttachment().hashCode();
      hash = (37 * hash) + PUBLIC_IP_ADDRESS_DISABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPublicIpAddressDisabled());
      hash = (37 * hash) + ROUTE_ALL_TRAFFIC_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRouteAllTraffic());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Defines the Private Service Connect network configuration for the pool.
     * </pre>
     *
     * Protobuf type {@code google.devtools.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect)
        com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnectOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_PrivatePoolV1Config_PrivateServiceConnect_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_PrivatePoolV1Config_PrivateServiceConnect_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect.class,
                com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect.Builder.class);
      }

      // Construct using
      // com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        networkAttachment_ = "";
        publicIpAddressDisabled_ = false;
        routeAllTraffic_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_PrivatePoolV1Config_PrivateServiceConnect_descriptor;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect
          getDefaultInstanceForType() {
        return com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect build() {
        com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect buildPartial() {
        com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect result =
            new com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.networkAttachment_ = networkAttachment_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.publicIpAddressDisabled_ = publicIpAddressDisabled_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.routeAllTraffic_ = routeAllTraffic_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect) {
          return mergeFrom(
              (com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect other) {
        if (other
            == com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect
                .getDefaultInstance()) return this;
        if (!other.getNetworkAttachment().isEmpty()) {
          networkAttachment_ = other.networkAttachment_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getPublicIpAddressDisabled() != false) {
          setPublicIpAddressDisabled(other.getPublicIpAddressDisabled());
        }
        if (other.getRouteAllTraffic() != false) {
          setRouteAllTraffic(other.getRouteAllTraffic());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  networkAttachment_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  publicIpAddressDisabled_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  routeAllTraffic_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object networkAttachment_ = "";
      /**
       *
       *
       * <pre>
       * Required. Immutable. The network attachment that the worker network
       * interface is peered to. Must be in the format
       * `projects/{project}/regions/{region}/networkAttachments/{networkAttachment}`.
       * The region of network attachment must be the same as the worker pool.
       * See [Network
       * Attachments](https://cloud.google.com/vpc/docs/about-network-attachments)
       * </pre>
       *
       * <code>
       * string network_attachment = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The networkAttachment.
       */
      public java.lang.String getNetworkAttachment() {
        java.lang.Object ref = networkAttachment_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          networkAttachment_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. The network attachment that the worker network
       * interface is peered to. Must be in the format
       * `projects/{project}/regions/{region}/networkAttachments/{networkAttachment}`.
       * The region of network attachment must be the same as the worker pool.
       * See [Network
       * Attachments](https://cloud.google.com/vpc/docs/about-network-attachments)
       * </pre>
       *
       * <code>
       * string network_attachment = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for networkAttachment.
       */
      public com.google.protobuf.ByteString getNetworkAttachmentBytes() {
        java.lang.Object ref = networkAttachment_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          networkAttachment_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. The network attachment that the worker network
       * interface is peered to. Must be in the format
       * `projects/{project}/regions/{region}/networkAttachments/{networkAttachment}`.
       * The region of network attachment must be the same as the worker pool.
       * See [Network
       * Attachments](https://cloud.google.com/vpc/docs/about-network-attachments)
       * </pre>
       *
       * <code>
       * string network_attachment = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The networkAttachment to set.
       * @return This builder for chaining.
       */
      public Builder setNetworkAttachment(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        networkAttachment_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. The network attachment that the worker network
       * interface is peered to. Must be in the format
       * `projects/{project}/regions/{region}/networkAttachments/{networkAttachment}`.
       * The region of network attachment must be the same as the worker pool.
       * See [Network
       * Attachments](https://cloud.google.com/vpc/docs/about-network-attachments)
       * </pre>
       *
       * <code>
       * string network_attachment = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNetworkAttachment() {
        networkAttachment_ = getDefaultInstance().getNetworkAttachment();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. The network attachment that the worker network
       * interface is peered to. Must be in the format
       * `projects/{project}/regions/{region}/networkAttachments/{networkAttachment}`.
       * The region of network attachment must be the same as the worker pool.
       * See [Network
       * Attachments](https://cloud.google.com/vpc/docs/about-network-attachments)
       * </pre>
       *
       * <code>
       * string network_attachment = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for networkAttachment to set.
       * @return This builder for chaining.
       */
      public Builder setNetworkAttachmentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        networkAttachment_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private boolean publicIpAddressDisabled_;
      /**
       *
       *
       * <pre>
       * Required. Immutable. Disable public IP on the primary network interface.
       *
       * If true, workers are created without any public address, which prevents
       * network egress to public IPs unless a network proxy is configured.
       * If false, workers are created with a public address which allows for
       * public internet egress. The public address only applies to traffic
       * through the primary network interface.
       * If `route_all_traffic` is set to true, all traffic will go through the
       * non-primary network interface, this boolean has no effect.
       * </pre>
       *
       * <code>
       * bool public_ip_address_disabled = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
       * </code>
       *
       * @return The publicIpAddressDisabled.
       */
      @java.lang.Override
      public boolean getPublicIpAddressDisabled() {
        return publicIpAddressDisabled_;
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. Disable public IP on the primary network interface.
       *
       * If true, workers are created without any public address, which prevents
       * network egress to public IPs unless a network proxy is configured.
       * If false, workers are created with a public address which allows for
       * public internet egress. The public address only applies to traffic
       * through the primary network interface.
       * If `route_all_traffic` is set to true, all traffic will go through the
       * non-primary network interface, this boolean has no effect.
       * </pre>
       *
       * <code>
       * bool public_ip_address_disabled = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
       * </code>
       *
       * @param value The publicIpAddressDisabled to set.
       * @return This builder for chaining.
       */
      public Builder setPublicIpAddressDisabled(boolean value) {

        publicIpAddressDisabled_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. Disable public IP on the primary network interface.
       *
       * If true, workers are created without any public address, which prevents
       * network egress to public IPs unless a network proxy is configured.
       * If false, workers are created with a public address which allows for
       * public internet egress. The public address only applies to traffic
       * through the primary network interface.
       * If `route_all_traffic` is set to true, all traffic will go through the
       * non-primary network interface, this boolean has no effect.
       * </pre>
       *
       * <code>
       * bool public_ip_address_disabled = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPublicIpAddressDisabled() {
        bitField0_ = (bitField0_ & ~0x00000002);
        publicIpAddressDisabled_ = false;
        onChanged();
        return this;
      }

      private boolean routeAllTraffic_;
      /**
       *
       *
       * <pre>
       * Immutable. Route all traffic through PSC interface. Enable this if you
       * want full control of traffic in the private pool. Configure Cloud NAT for
       * the subnet of network attachment if you need to access public Internet.
       *
       * If false, Only route private IPs, e.g. 10.0.0.0/8, 172.16.0.0/12, and
       * 192.168.0.0/16 through PSC interface.
       * </pre>
       *
       * <code>bool route_all_traffic = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return The routeAllTraffic.
       */
      @java.lang.Override
      public boolean getRouteAllTraffic() {
        return routeAllTraffic_;
      }
      /**
       *
       *
       * <pre>
       * Immutable. Route all traffic through PSC interface. Enable this if you
       * want full control of traffic in the private pool. Configure Cloud NAT for
       * the subnet of network attachment if you need to access public Internet.
       *
       * If false, Only route private IPs, e.g. 10.0.0.0/8, 172.16.0.0/12, and
       * 192.168.0.0/16 through PSC interface.
       * </pre>
       *
       * <code>bool route_all_traffic = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @param value The routeAllTraffic to set.
       * @return This builder for chaining.
       */
      public Builder setRouteAllTraffic(boolean value) {

        routeAllTraffic_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Immutable. Route all traffic through PSC interface. Enable this if you
       * want full control of traffic in the private pool. Configure Cloud NAT for
       * the subnet of network attachment if you need to access public Internet.
       *
       * If false, Only route private IPs, e.g. 10.0.0.0/8, 172.16.0.0/12, and
       * 192.168.0.0/16 through PSC interface.
       * </pre>
       *
       * <code>bool route_all_traffic = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRouteAllTraffic() {
        bitField0_ = (bitField0_ & ~0x00000004);
        routeAllTraffic_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect)
    }

    // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect)
    private static final com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect();
    }

    public static com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PrivateServiceConnect> PARSER =
        new com.google.protobuf.AbstractParser<PrivateServiceConnect>() {
          @java.lang.Override
          public PrivateServiceConnect parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PrivateServiceConnect> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PrivateServiceConnect> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int WORKER_CONFIG_FIELD_NUMBER = 1;
  private com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig workerConfig_;
  /**
   *
   *
   * <pre>
   * Machine configuration for the workers in the pool.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig worker_config = 1;</code>
   *
   * @return Whether the workerConfig field is set.
   */
  @java.lang.Override
  public boolean hasWorkerConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Machine configuration for the workers in the pool.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig worker_config = 1;</code>
   *
   * @return The workerConfig.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig getWorkerConfig() {
    return workerConfig_ == null
        ? com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig.getDefaultInstance()
        : workerConfig_;
  }
  /**
   *
   *
   * <pre>
   * Machine configuration for the workers in the pool.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig worker_config = 1;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfigOrBuilder
      getWorkerConfigOrBuilder() {
    return workerConfig_ == null
        ? com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig.getDefaultInstance()
        : workerConfig_;
  }

  public static final int NETWORK_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig networkConfig_;
  /**
   *
   *
   * <pre>
   * Network configuration for the pool.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig network_config = 2;
   * </code>
   *
   * @return Whether the networkConfig field is set.
   */
  @java.lang.Override
  public boolean hasNetworkConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Network configuration for the pool.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig network_config = 2;
   * </code>
   *
   * @return The networkConfig.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig getNetworkConfig() {
    return networkConfig_ == null
        ? com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.getDefaultInstance()
        : networkConfig_;
  }
  /**
   *
   *
   * <pre>
   * Network configuration for the pool.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig network_config = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfigOrBuilder
      getNetworkConfigOrBuilder() {
    return networkConfig_ == null
        ? com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.getDefaultInstance()
        : networkConfig_;
  }

  public static final int PRIVATE_SERVICE_CONNECT_FIELD_NUMBER = 5;
  private com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect privateServiceConnect_;
  /**
   *
   *
   * <pre>
   * Immutable. Private Service Connect(PSC) Network configuration for the pool.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect private_service_connect = 5 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the privateServiceConnect field is set.
   */
  @java.lang.Override
  public boolean hasPrivateServiceConnect() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Immutable. Private Service Connect(PSC) Network configuration for the pool.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect private_service_connect = 5 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The privateServiceConnect.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect
      getPrivateServiceConnect() {
    return privateServiceConnect_ == null
        ? com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect.getDefaultInstance()
        : privateServiceConnect_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. Private Service Connect(PSC) Network configuration for the pool.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect private_service_connect = 5 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnectOrBuilder
      getPrivateServiceConnectOrBuilder() {
    return privateServiceConnect_ == null
        ? com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect.getDefaultInstance()
        : privateServiceConnect_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getWorkerConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getNetworkConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getPrivateServiceConnect());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getWorkerConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getNetworkConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, getPrivateServiceConnect());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.PrivatePoolV1Config)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.PrivatePoolV1Config other =
        (com.google.cloudbuild.v1.PrivatePoolV1Config) obj;

    if (hasWorkerConfig() != other.hasWorkerConfig()) return false;
    if (hasWorkerConfig()) {
      if (!getWorkerConfig().equals(other.getWorkerConfig())) return false;
    }
    if (hasNetworkConfig() != other.hasNetworkConfig()) return false;
    if (hasNetworkConfig()) {
      if (!getNetworkConfig().equals(other.getNetworkConfig())) return false;
    }
    if (hasPrivateServiceConnect() != other.hasPrivateServiceConnect()) return false;
    if (hasPrivateServiceConnect()) {
      if (!getPrivateServiceConnect().equals(other.getPrivateServiceConnect())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasWorkerConfig()) {
      hash = (37 * hash) + WORKER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getWorkerConfig().hashCode();
    }
    if (hasNetworkConfig()) {
      hash = (37 * hash) + NETWORK_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkConfig().hashCode();
    }
    if (hasPrivateServiceConnect()) {
      hash = (37 * hash) + PRIVATE_SERVICE_CONNECT_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateServiceConnect().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.PrivatePoolV1Config parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.PrivatePoolV1Config parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.PrivatePoolV1Config parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.PrivatePoolV1Config parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.PrivatePoolV1Config parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.PrivatePoolV1Config parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.PrivatePoolV1Config parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.PrivatePoolV1Config parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.PrivatePoolV1Config parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.PrivatePoolV1Config parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.PrivatePoolV1Config parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.PrivatePoolV1Config parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.PrivatePoolV1Config prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for a V1 `PrivatePool`.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.PrivatePoolV1Config}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.PrivatePoolV1Config)
      com.google.cloudbuild.v1.PrivatePoolV1ConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_PrivatePoolV1Config_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_PrivatePoolV1Config_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.PrivatePoolV1Config.class,
              com.google.cloudbuild.v1.PrivatePoolV1Config.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.PrivatePoolV1Config.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getWorkerConfigFieldBuilder();
        getNetworkConfigFieldBuilder();
        getPrivateServiceConnectFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      workerConfig_ = null;
      if (workerConfigBuilder_ != null) {
        workerConfigBuilder_.dispose();
        workerConfigBuilder_ = null;
      }
      networkConfig_ = null;
      if (networkConfigBuilder_ != null) {
        networkConfigBuilder_.dispose();
        networkConfigBuilder_ = null;
      }
      privateServiceConnect_ = null;
      if (privateServiceConnectBuilder_ != null) {
        privateServiceConnectBuilder_.dispose();
        privateServiceConnectBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_PrivatePoolV1Config_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.PrivatePoolV1Config getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.PrivatePoolV1Config.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.PrivatePoolV1Config build() {
      com.google.cloudbuild.v1.PrivatePoolV1Config result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.PrivatePoolV1Config buildPartial() {
      com.google.cloudbuild.v1.PrivatePoolV1Config result =
          new com.google.cloudbuild.v1.PrivatePoolV1Config(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloudbuild.v1.PrivatePoolV1Config result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.workerConfig_ =
            workerConfigBuilder_ == null ? workerConfig_ : workerConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.networkConfig_ =
            networkConfigBuilder_ == null ? networkConfig_ : networkConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.privateServiceConnect_ =
            privateServiceConnectBuilder_ == null
                ? privateServiceConnect_
                : privateServiceConnectBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.PrivatePoolV1Config) {
        return mergeFrom((com.google.cloudbuild.v1.PrivatePoolV1Config) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.PrivatePoolV1Config other) {
      if (other == com.google.cloudbuild.v1.PrivatePoolV1Config.getDefaultInstance()) return this;
      if (other.hasWorkerConfig()) {
        mergeWorkerConfig(other.getWorkerConfig());
      }
      if (other.hasNetworkConfig()) {
        mergeNetworkConfig(other.getNetworkConfig());
      }
      if (other.hasPrivateServiceConnect()) {
        mergePrivateServiceConnect(other.getPrivateServiceConnect());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getWorkerConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getNetworkConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 42:
              {
                input.readMessage(
                    getPrivateServiceConnectFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig workerConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig,
            com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig.Builder,
            com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfigOrBuilder>
        workerConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Machine configuration for the workers in the pool.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig worker_config = 1;
     * </code>
     *
     * @return Whether the workerConfig field is set.
     */
    public boolean hasWorkerConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Machine configuration for the workers in the pool.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig worker_config = 1;
     * </code>
     *
     * @return The workerConfig.
     */
    public com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig getWorkerConfig() {
      if (workerConfigBuilder_ == null) {
        return workerConfig_ == null
            ? com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig.getDefaultInstance()
            : workerConfig_;
      } else {
        return workerConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Machine configuration for the workers in the pool.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig worker_config = 1;
     * </code>
     */
    public Builder setWorkerConfig(
        com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig value) {
      if (workerConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        workerConfig_ = value;
      } else {
        workerConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Machine configuration for the workers in the pool.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig worker_config = 1;
     * </code>
     */
    public Builder setWorkerConfig(
        com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig.Builder builderForValue) {
      if (workerConfigBuilder_ == null) {
        workerConfig_ = builderForValue.build();
      } else {
        workerConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Machine configuration for the workers in the pool.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig worker_config = 1;
     * </code>
     */
    public Builder mergeWorkerConfig(
        com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig value) {
      if (workerConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && workerConfig_ != null
            && workerConfig_
                != com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig.getDefaultInstance()) {
          getWorkerConfigBuilder().mergeFrom(value);
        } else {
          workerConfig_ = value;
        }
      } else {
        workerConfigBuilder_.mergeFrom(value);
      }
      if (workerConfig_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Machine configuration for the workers in the pool.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig worker_config = 1;
     * </code>
     */
    public Builder clearWorkerConfig() {
      bitField0_ = (bitField0_ & ~0x00000001);
      workerConfig_ = null;
      if (workerConfigBuilder_ != null) {
        workerConfigBuilder_.dispose();
        workerConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Machine configuration for the workers in the pool.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig worker_config = 1;
     * </code>
     */
    public com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig.Builder
        getWorkerConfigBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getWorkerConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Machine configuration for the workers in the pool.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig worker_config = 1;
     * </code>
     */
    public com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfigOrBuilder
        getWorkerConfigOrBuilder() {
      if (workerConfigBuilder_ != null) {
        return workerConfigBuilder_.getMessageOrBuilder();
      } else {
        return workerConfig_ == null
            ? com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig.getDefaultInstance()
            : workerConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Machine configuration for the workers in the pool.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig worker_config = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig,
            com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig.Builder,
            com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfigOrBuilder>
        getWorkerConfigFieldBuilder() {
      if (workerConfigBuilder_ == null) {
        workerConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig,
                com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfig.Builder,
                com.google.cloudbuild.v1.PrivatePoolV1Config.WorkerConfigOrBuilder>(
                getWorkerConfig(), getParentForChildren(), isClean());
        workerConfig_ = null;
      }
      return workerConfigBuilder_;
    }

    private com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig networkConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig,
            com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.Builder,
            com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfigOrBuilder>
        networkConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Network configuration for the pool.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig network_config = 2;
     * </code>
     *
     * @return Whether the networkConfig field is set.
     */
    public boolean hasNetworkConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Network configuration for the pool.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig network_config = 2;
     * </code>
     *
     * @return The networkConfig.
     */
    public com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig getNetworkConfig() {
      if (networkConfigBuilder_ == null) {
        return networkConfig_ == null
            ? com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.getDefaultInstance()
            : networkConfig_;
      } else {
        return networkConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Network configuration for the pool.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig network_config = 2;
     * </code>
     */
    public Builder setNetworkConfig(
        com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig value) {
      if (networkConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        networkConfig_ = value;
      } else {
        networkConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network configuration for the pool.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig network_config = 2;
     * </code>
     */
    public Builder setNetworkConfig(
        com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.Builder builderForValue) {
      if (networkConfigBuilder_ == null) {
        networkConfig_ = builderForValue.build();
      } else {
        networkConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network configuration for the pool.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig network_config = 2;
     * </code>
     */
    public Builder mergeNetworkConfig(
        com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig value) {
      if (networkConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && networkConfig_ != null
            && networkConfig_
                != com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig
                    .getDefaultInstance()) {
          getNetworkConfigBuilder().mergeFrom(value);
        } else {
          networkConfig_ = value;
        }
      } else {
        networkConfigBuilder_.mergeFrom(value);
      }
      if (networkConfig_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network configuration for the pool.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig network_config = 2;
     * </code>
     */
    public Builder clearNetworkConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      networkConfig_ = null;
      if (networkConfigBuilder_ != null) {
        networkConfigBuilder_.dispose();
        networkConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network configuration for the pool.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig network_config = 2;
     * </code>
     */
    public com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.Builder
        getNetworkConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getNetworkConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Network configuration for the pool.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig network_config = 2;
     * </code>
     */
    public com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfigOrBuilder
        getNetworkConfigOrBuilder() {
      if (networkConfigBuilder_ != null) {
        return networkConfigBuilder_.getMessageOrBuilder();
      } else {
        return networkConfig_ == null
            ? com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.getDefaultInstance()
            : networkConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Network configuration for the pool.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig network_config = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig,
            com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.Builder,
            com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfigOrBuilder>
        getNetworkConfigFieldBuilder() {
      if (networkConfigBuilder_ == null) {
        networkConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig,
                com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfig.Builder,
                com.google.cloudbuild.v1.PrivatePoolV1Config.NetworkConfigOrBuilder>(
                getNetworkConfig(), getParentForChildren(), isClean());
        networkConfig_ = null;
      }
      return networkConfigBuilder_;
    }

    private com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect
        privateServiceConnect_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect,
            com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect.Builder,
            com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnectOrBuilder>
        privateServiceConnectBuilder_;
    /**
     *
     *
     * <pre>
     * Immutable. Private Service Connect(PSC) Network configuration for the pool.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect private_service_connect = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the privateServiceConnect field is set.
     */
    public boolean hasPrivateServiceConnect() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Immutable. Private Service Connect(PSC) Network configuration for the pool.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect private_service_connect = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The privateServiceConnect.
     */
    public com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect
        getPrivateServiceConnect() {
      if (privateServiceConnectBuilder_ == null) {
        return privateServiceConnect_ == null
            ? com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect
                .getDefaultInstance()
            : privateServiceConnect_;
      } else {
        return privateServiceConnectBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Private Service Connect(PSC) Network configuration for the pool.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect private_service_connect = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setPrivateServiceConnect(
        com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect value) {
      if (privateServiceConnectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        privateServiceConnect_ = value;
      } else {
        privateServiceConnectBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Private Service Connect(PSC) Network configuration for the pool.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect private_service_connect = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setPrivateServiceConnect(
        com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect.Builder
            builderForValue) {
      if (privateServiceConnectBuilder_ == null) {
        privateServiceConnect_ = builderForValue.build();
      } else {
        privateServiceConnectBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Private Service Connect(PSC) Network configuration for the pool.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect private_service_connect = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergePrivateServiceConnect(
        com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect value) {
      if (privateServiceConnectBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && privateServiceConnect_ != null
            && privateServiceConnect_
                != com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect
                    .getDefaultInstance()) {
          getPrivateServiceConnectBuilder().mergeFrom(value);
        } else {
          privateServiceConnect_ = value;
        }
      } else {
        privateServiceConnectBuilder_.mergeFrom(value);
      }
      if (privateServiceConnect_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Private Service Connect(PSC) Network configuration for the pool.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect private_service_connect = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearPrivateServiceConnect() {
      bitField0_ = (bitField0_ & ~0x00000004);
      privateServiceConnect_ = null;
      if (privateServiceConnectBuilder_ != null) {
        privateServiceConnectBuilder_.dispose();
        privateServiceConnectBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Private Service Connect(PSC) Network configuration for the pool.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect private_service_connect = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect.Builder
        getPrivateServiceConnectBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getPrivateServiceConnectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Immutable. Private Service Connect(PSC) Network configuration for the pool.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect private_service_connect = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnectOrBuilder
        getPrivateServiceConnectOrBuilder() {
      if (privateServiceConnectBuilder_ != null) {
        return privateServiceConnectBuilder_.getMessageOrBuilder();
      } else {
        return privateServiceConnect_ == null
            ? com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect
                .getDefaultInstance()
            : privateServiceConnect_;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Private Service Connect(PSC) Network configuration for the pool.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect private_service_connect = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect,
            com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect.Builder,
            com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnectOrBuilder>
        getPrivateServiceConnectFieldBuilder() {
      if (privateServiceConnectBuilder_ == null) {
        privateServiceConnectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect,
                com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnect.Builder,
                com.google.cloudbuild.v1.PrivatePoolV1Config.PrivateServiceConnectOrBuilder>(
                getPrivateServiceConnect(), getParentForChildren(), isClean());
        privateServiceConnect_ = null;
      }
      return privateServiceConnectBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.PrivatePoolV1Config)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.PrivatePoolV1Config)
  private static final com.google.cloudbuild.v1.PrivatePoolV1Config DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.PrivatePoolV1Config();
  }

  public static com.google.cloudbuild.v1.PrivatePoolV1Config getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PrivatePoolV1Config> PARSER =
      new com.google.protobuf.AbstractParser<PrivatePoolV1Config>() {
        @java.lang.Override
        public PrivatePoolV1Config parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PrivatePoolV1Config> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PrivatePoolV1Config> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.PrivatePoolV1Config getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
