/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

// Protobuf Java Version: 3.25.5
package com.google.cloudbuild.v1;

/**
 *
 *
 * <pre>
 * Artifacts created by the build pipeline.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v1.Results}
 */
public final class Results extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.Results)
    ResultsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Results.newBuilder() to construct.
  private Results(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Results() {
    images_ = java.util.Collections.emptyList();
    buildStepImages_ = com.google.protobuf.LazyStringArrayList.emptyList();
    artifactManifest_ = "";
    buildStepOutputs_ = emptyList(com.google.protobuf.ByteString.class);
    pythonPackages_ = java.util.Collections.emptyList();
    mavenArtifacts_ = java.util.Collections.emptyList();
    goModules_ = java.util.Collections.emptyList();
    npmPackages_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Results();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_Results_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_Results_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.Results.class, com.google.cloudbuild.v1.Results.Builder.class);
  }

  private int bitField0_;
  public static final int IMAGES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloudbuild.v1.BuiltImage> images_;
  /**
   *
   *
   * <pre>
   * Container images that were built as a part of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloudbuild.v1.BuiltImage> getImagesList() {
    return images_;
  }
  /**
   *
   *
   * <pre>
   * Container images that were built as a part of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloudbuild.v1.BuiltImageOrBuilder>
      getImagesOrBuilderList() {
    return images_;
  }
  /**
   *
   *
   * <pre>
   * Container images that were built as a part of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
   */
  @java.lang.Override
  public int getImagesCount() {
    return images_.size();
  }
  /**
   *
   *
   * <pre>
   * Container images that were built as a part of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.BuiltImage getImages(int index) {
    return images_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Container images that were built as a part of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.BuiltImageOrBuilder getImagesOrBuilder(int index) {
    return images_.get(index);
  }

  public static final int BUILD_STEP_IMAGES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList buildStepImages_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * List of build step digests, in the order corresponding to build step
   * indices.
   * </pre>
   *
   * <code>repeated string build_step_images = 3;</code>
   *
   * @return A list containing the buildStepImages.
   */
  public com.google.protobuf.ProtocolStringList getBuildStepImagesList() {
    return buildStepImages_;
  }
  /**
   *
   *
   * <pre>
   * List of build step digests, in the order corresponding to build step
   * indices.
   * </pre>
   *
   * <code>repeated string build_step_images = 3;</code>
   *
   * @return The count of buildStepImages.
   */
  public int getBuildStepImagesCount() {
    return buildStepImages_.size();
  }
  /**
   *
   *
   * <pre>
   * List of build step digests, in the order corresponding to build step
   * indices.
   * </pre>
   *
   * <code>repeated string build_step_images = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The buildStepImages at the given index.
   */
  public java.lang.String getBuildStepImages(int index) {
    return buildStepImages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of build step digests, in the order corresponding to build step
   * indices.
   * </pre>
   *
   * <code>repeated string build_step_images = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the buildStepImages at the given index.
   */
  public com.google.protobuf.ByteString getBuildStepImagesBytes(int index) {
    return buildStepImages_.getByteString(index);
  }

  public static final int ARTIFACT_MANIFEST_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object artifactManifest_ = "";
  /**
   *
   *
   * <pre>
   * Path to the artifact manifest for non-container artifacts uploaded to Cloud
   * Storage. Only populated when artifacts are uploaded to Cloud Storage.
   * </pre>
   *
   * <code>string artifact_manifest = 4;</code>
   *
   * @return The artifactManifest.
   */
  @java.lang.Override
  public java.lang.String getArtifactManifest() {
    java.lang.Object ref = artifactManifest_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      artifactManifest_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Path to the artifact manifest for non-container artifacts uploaded to Cloud
   * Storage. Only populated when artifacts are uploaded to Cloud Storage.
   * </pre>
   *
   * <code>string artifact_manifest = 4;</code>
   *
   * @return The bytes for artifactManifest.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getArtifactManifestBytes() {
    java.lang.Object ref = artifactManifest_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      artifactManifest_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NUM_ARTIFACTS_FIELD_NUMBER = 5;
  private long numArtifacts_ = 0L;
  /**
   *
   *
   * <pre>
   * Number of non-container artifacts uploaded to Cloud Storage. Only populated
   * when artifacts are uploaded to Cloud Storage.
   * </pre>
   *
   * <code>int64 num_artifacts = 5;</code>
   *
   * @return The numArtifacts.
   */
  @java.lang.Override
  public long getNumArtifacts() {
    return numArtifacts_;
  }

  public static final int BUILD_STEP_OUTPUTS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.ProtobufList<com.google.protobuf.ByteString>
      buildStepOutputs_ = emptyList(com.google.protobuf.ByteString.class);
  /**
   *
   *
   * <pre>
   * List of build step outputs, produced by builder images, in the order
   * corresponding to build step indices.
   *
   * [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
   * can produce this output by writing to `$BUILDER_OUTPUT/output`.
   * Only the first 4KB of data is stored.
   * </pre>
   *
   * <code>repeated bytes build_step_outputs = 6;</code>
   *
   * @return A list containing the buildStepOutputs.
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.ByteString> getBuildStepOutputsList() {
    return buildStepOutputs_;
  }
  /**
   *
   *
   * <pre>
   * List of build step outputs, produced by builder images, in the order
   * corresponding to build step indices.
   *
   * [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
   * can produce this output by writing to `$BUILDER_OUTPUT/output`.
   * Only the first 4KB of data is stored.
   * </pre>
   *
   * <code>repeated bytes build_step_outputs = 6;</code>
   *
   * @return The count of buildStepOutputs.
   */
  public int getBuildStepOutputsCount() {
    return buildStepOutputs_.size();
  }
  /**
   *
   *
   * <pre>
   * List of build step outputs, produced by builder images, in the order
   * corresponding to build step indices.
   *
   * [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
   * can produce this output by writing to `$BUILDER_OUTPUT/output`.
   * Only the first 4KB of data is stored.
   * </pre>
   *
   * <code>repeated bytes build_step_outputs = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The buildStepOutputs at the given index.
   */
  public com.google.protobuf.ByteString getBuildStepOutputs(int index) {
    return buildStepOutputs_.get(index);
  }

  public static final int ARTIFACT_TIMING_FIELD_NUMBER = 7;
  private com.google.cloudbuild.v1.TimeSpan artifactTiming_;
  /**
   *
   *
   * <pre>
   * Time to push all non-container artifacts to Cloud Storage.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
   *
   * @return Whether the artifactTiming field is set.
   */
  @java.lang.Override
  public boolean hasArtifactTiming() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Time to push all non-container artifacts to Cloud Storage.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
   *
   * @return The artifactTiming.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.TimeSpan getArtifactTiming() {
    return artifactTiming_ == null
        ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance()
        : artifactTiming_;
  }
  /**
   *
   *
   * <pre>
   * Time to push all non-container artifacts to Cloud Storage.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.TimeSpanOrBuilder getArtifactTimingOrBuilder() {
    return artifactTiming_ == null
        ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance()
        : artifactTiming_;
  }

  public static final int PYTHON_PACKAGES_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloudbuild.v1.UploadedPythonPackage> pythonPackages_;
  /**
   *
   *
   * <pre>
   * Python artifacts uploaded to Artifact Registry at the end of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloudbuild.v1.UploadedPythonPackage> getPythonPackagesList() {
    return pythonPackages_;
  }
  /**
   *
   *
   * <pre>
   * Python artifacts uploaded to Artifact Registry at the end of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloudbuild.v1.UploadedPythonPackageOrBuilder>
      getPythonPackagesOrBuilderList() {
    return pythonPackages_;
  }
  /**
   *
   *
   * <pre>
   * Python artifacts uploaded to Artifact Registry at the end of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;</code>
   */
  @java.lang.Override
  public int getPythonPackagesCount() {
    return pythonPackages_.size();
  }
  /**
   *
   *
   * <pre>
   * Python artifacts uploaded to Artifact Registry at the end of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.UploadedPythonPackage getPythonPackages(int index) {
    return pythonPackages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Python artifacts uploaded to Artifact Registry at the end of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.UploadedPythonPackageOrBuilder getPythonPackagesOrBuilder(
      int index) {
    return pythonPackages_.get(index);
  }

  public static final int MAVEN_ARTIFACTS_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloudbuild.v1.UploadedMavenArtifact> mavenArtifacts_;
  /**
   *
   *
   * <pre>
   * Maven artifacts uploaded to Artifact Registry at the end of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloudbuild.v1.UploadedMavenArtifact> getMavenArtifactsList() {
    return mavenArtifacts_;
  }
  /**
   *
   *
   * <pre>
   * Maven artifacts uploaded to Artifact Registry at the end of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloudbuild.v1.UploadedMavenArtifactOrBuilder>
      getMavenArtifactsOrBuilderList() {
    return mavenArtifacts_;
  }
  /**
   *
   *
   * <pre>
   * Maven artifacts uploaded to Artifact Registry at the end of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;</code>
   */
  @java.lang.Override
  public int getMavenArtifactsCount() {
    return mavenArtifacts_.size();
  }
  /**
   *
   *
   * <pre>
   * Maven artifacts uploaded to Artifact Registry at the end of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.UploadedMavenArtifact getMavenArtifacts(int index) {
    return mavenArtifacts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Maven artifacts uploaded to Artifact Registry at the end of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.UploadedMavenArtifactOrBuilder getMavenArtifactsOrBuilder(
      int index) {
    return mavenArtifacts_.get(index);
  }

  public static final int GO_MODULES_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloudbuild.v1.UploadedGoModule> goModules_;
  /**
   *
   *
   * <pre>
   * Optional. Go module artifacts uploaded to Artifact Registry at the end of
   * the build.
   * </pre>
   *
   * <code>
   * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloudbuild.v1.UploadedGoModule> getGoModulesList() {
    return goModules_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Go module artifacts uploaded to Artifact Registry at the end of
   * the build.
   * </pre>
   *
   * <code>
   * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloudbuild.v1.UploadedGoModuleOrBuilder>
      getGoModulesOrBuilderList() {
    return goModules_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Go module artifacts uploaded to Artifact Registry at the end of
   * the build.
   * </pre>
   *
   * <code>
   * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getGoModulesCount() {
    return goModules_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Go module artifacts uploaded to Artifact Registry at the end of
   * the build.
   * </pre>
   *
   * <code>
   * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.UploadedGoModule getGoModules(int index) {
    return goModules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Go module artifacts uploaded to Artifact Registry at the end of
   * the build.
   * </pre>
   *
   * <code>
   * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.UploadedGoModuleOrBuilder getGoModulesOrBuilder(int index) {
    return goModules_.get(index);
  }

  public static final int NPM_PACKAGES_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloudbuild.v1.UploadedNpmPackage> npmPackages_;
  /**
   *
   *
   * <pre>
   * Npm packages uploaded to Artifact Registry at the end of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloudbuild.v1.UploadedNpmPackage> getNpmPackagesList() {
    return npmPackages_;
  }
  /**
   *
   *
   * <pre>
   * Npm packages uploaded to Artifact Registry at the end of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloudbuild.v1.UploadedNpmPackageOrBuilder>
      getNpmPackagesOrBuilderList() {
    return npmPackages_;
  }
  /**
   *
   *
   * <pre>
   * Npm packages uploaded to Artifact Registry at the end of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
   */
  @java.lang.Override
  public int getNpmPackagesCount() {
    return npmPackages_.size();
  }
  /**
   *
   *
   * <pre>
   * Npm packages uploaded to Artifact Registry at the end of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.UploadedNpmPackage getNpmPackages(int index) {
    return npmPackages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Npm packages uploaded to Artifact Registry at the end of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.UploadedNpmPackageOrBuilder getNpmPackagesOrBuilder(int index) {
    return npmPackages_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < images_.size(); i++) {
      output.writeMessage(2, images_.get(i));
    }
    for (int i = 0; i < buildStepImages_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, buildStepImages_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(artifactManifest_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, artifactManifest_);
    }
    if (numArtifacts_ != 0L) {
      output.writeInt64(5, numArtifacts_);
    }
    for (int i = 0; i < buildStepOutputs_.size(); i++) {
      output.writeBytes(6, buildStepOutputs_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getArtifactTiming());
    }
    for (int i = 0; i < pythonPackages_.size(); i++) {
      output.writeMessage(8, pythonPackages_.get(i));
    }
    for (int i = 0; i < mavenArtifacts_.size(); i++) {
      output.writeMessage(9, mavenArtifacts_.get(i));
    }
    for (int i = 0; i < goModules_.size(); i++) {
      output.writeMessage(10, goModules_.get(i));
    }
    for (int i = 0; i < npmPackages_.size(); i++) {
      output.writeMessage(12, npmPackages_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < images_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, images_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < buildStepImages_.size(); i++) {
        dataSize += computeStringSizeNoTag(buildStepImages_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getBuildStepImagesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(artifactManifest_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, artifactManifest_);
    }
    if (numArtifacts_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(5, numArtifacts_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < buildStepOutputs_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeBytesSizeNoTag(buildStepOutputs_.get(i));
      }
      size += dataSize;
      size += 1 * getBuildStepOutputsList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getArtifactTiming());
    }
    for (int i = 0; i < pythonPackages_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, pythonPackages_.get(i));
    }
    for (int i = 0; i < mavenArtifacts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, mavenArtifacts_.get(i));
    }
    for (int i = 0; i < goModules_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, goModules_.get(i));
    }
    for (int i = 0; i < npmPackages_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, npmPackages_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.Results)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.Results other = (com.google.cloudbuild.v1.Results) obj;

    if (!getImagesList().equals(other.getImagesList())) return false;
    if (!getBuildStepImagesList().equals(other.getBuildStepImagesList())) return false;
    if (!getArtifactManifest().equals(other.getArtifactManifest())) return false;
    if (getNumArtifacts() != other.getNumArtifacts()) return false;
    if (!getBuildStepOutputsList().equals(other.getBuildStepOutputsList())) return false;
    if (hasArtifactTiming() != other.hasArtifactTiming()) return false;
    if (hasArtifactTiming()) {
      if (!getArtifactTiming().equals(other.getArtifactTiming())) return false;
    }
    if (!getPythonPackagesList().equals(other.getPythonPackagesList())) return false;
    if (!getMavenArtifactsList().equals(other.getMavenArtifactsList())) return false;
    if (!getGoModulesList().equals(other.getGoModulesList())) return false;
    if (!getNpmPackagesList().equals(other.getNpmPackagesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getImagesCount() > 0) {
      hash = (37 * hash) + IMAGES_FIELD_NUMBER;
      hash = (53 * hash) + getImagesList().hashCode();
    }
    if (getBuildStepImagesCount() > 0) {
      hash = (37 * hash) + BUILD_STEP_IMAGES_FIELD_NUMBER;
      hash = (53 * hash) + getBuildStepImagesList().hashCode();
    }
    hash = (37 * hash) + ARTIFACT_MANIFEST_FIELD_NUMBER;
    hash = (53 * hash) + getArtifactManifest().hashCode();
    hash = (37 * hash) + NUM_ARTIFACTS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getNumArtifacts());
    if (getBuildStepOutputsCount() > 0) {
      hash = (37 * hash) + BUILD_STEP_OUTPUTS_FIELD_NUMBER;
      hash = (53 * hash) + getBuildStepOutputsList().hashCode();
    }
    if (hasArtifactTiming()) {
      hash = (37 * hash) + ARTIFACT_TIMING_FIELD_NUMBER;
      hash = (53 * hash) + getArtifactTiming().hashCode();
    }
    if (getPythonPackagesCount() > 0) {
      hash = (37 * hash) + PYTHON_PACKAGES_FIELD_NUMBER;
      hash = (53 * hash) + getPythonPackagesList().hashCode();
    }
    if (getMavenArtifactsCount() > 0) {
      hash = (37 * hash) + MAVEN_ARTIFACTS_FIELD_NUMBER;
      hash = (53 * hash) + getMavenArtifactsList().hashCode();
    }
    if (getGoModulesCount() > 0) {
      hash = (37 * hash) + GO_MODULES_FIELD_NUMBER;
      hash = (53 * hash) + getGoModulesList().hashCode();
    }
    if (getNpmPackagesCount() > 0) {
      hash = (37 * hash) + NPM_PACKAGES_FIELD_NUMBER;
      hash = (53 * hash) + getNpmPackagesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.Results parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.Results parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Results parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.Results parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Results parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.Results parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Results parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.Results parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Results parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.Results parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Results parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.Results parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.Results prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Artifacts created by the build pipeline.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.Results}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.Results)
      com.google.cloudbuild.v1.ResultsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Results_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Results_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.Results.class,
              com.google.cloudbuild.v1.Results.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.Results.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getImagesFieldBuilder();
        getArtifactTimingFieldBuilder();
        getPythonPackagesFieldBuilder();
        getMavenArtifactsFieldBuilder();
        getGoModulesFieldBuilder();
        getNpmPackagesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (imagesBuilder_ == null) {
        images_ = java.util.Collections.emptyList();
      } else {
        images_ = null;
        imagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      buildStepImages_ = com.google.protobuf.LazyStringArrayList.emptyList();
      artifactManifest_ = "";
      numArtifacts_ = 0L;
      buildStepOutputs_ = emptyList(com.google.protobuf.ByteString.class);
      artifactTiming_ = null;
      if (artifactTimingBuilder_ != null) {
        artifactTimingBuilder_.dispose();
        artifactTimingBuilder_ = null;
      }
      if (pythonPackagesBuilder_ == null) {
        pythonPackages_ = java.util.Collections.emptyList();
      } else {
        pythonPackages_ = null;
        pythonPackagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      if (mavenArtifactsBuilder_ == null) {
        mavenArtifacts_ = java.util.Collections.emptyList();
      } else {
        mavenArtifacts_ = null;
        mavenArtifactsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      if (goModulesBuilder_ == null) {
        goModules_ = java.util.Collections.emptyList();
      } else {
        goModules_ = null;
        goModulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      if (npmPackagesBuilder_ == null) {
        npmPackages_ = java.util.Collections.emptyList();
      } else {
        npmPackages_ = null;
        npmPackagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Results_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Results getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.Results.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Results build() {
      com.google.cloudbuild.v1.Results result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Results buildPartial() {
      com.google.cloudbuild.v1.Results result = new com.google.cloudbuild.v1.Results(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloudbuild.v1.Results result) {
      if (imagesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          images_ = java.util.Collections.unmodifiableList(images_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.images_ = images_;
      } else {
        result.images_ = imagesBuilder_.build();
      }
      if (pythonPackagesBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          pythonPackages_ = java.util.Collections.unmodifiableList(pythonPackages_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.pythonPackages_ = pythonPackages_;
      } else {
        result.pythonPackages_ = pythonPackagesBuilder_.build();
      }
      if (mavenArtifactsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          mavenArtifacts_ = java.util.Collections.unmodifiableList(mavenArtifacts_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.mavenArtifacts_ = mavenArtifacts_;
      } else {
        result.mavenArtifacts_ = mavenArtifactsBuilder_.build();
      }
      if (goModulesBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          goModules_ = java.util.Collections.unmodifiableList(goModules_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.goModules_ = goModules_;
      } else {
        result.goModules_ = goModulesBuilder_.build();
      }
      if (npmPackagesBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          npmPackages_ = java.util.Collections.unmodifiableList(npmPackages_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.npmPackages_ = npmPackages_;
      } else {
        result.npmPackages_ = npmPackagesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloudbuild.v1.Results result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        buildStepImages_.makeImmutable();
        result.buildStepImages_ = buildStepImages_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.artifactManifest_ = artifactManifest_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.numArtifacts_ = numArtifacts_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        buildStepOutputs_.makeImmutable();
        result.buildStepOutputs_ = buildStepOutputs_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.artifactTiming_ =
            artifactTimingBuilder_ == null ? artifactTiming_ : artifactTimingBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.Results) {
        return mergeFrom((com.google.cloudbuild.v1.Results) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.Results other) {
      if (other == com.google.cloudbuild.v1.Results.getDefaultInstance()) return this;
      if (imagesBuilder_ == null) {
        if (!other.images_.isEmpty()) {
          if (images_.isEmpty()) {
            images_ = other.images_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureImagesIsMutable();
            images_.addAll(other.images_);
          }
          onChanged();
        }
      } else {
        if (!other.images_.isEmpty()) {
          if (imagesBuilder_.isEmpty()) {
            imagesBuilder_.dispose();
            imagesBuilder_ = null;
            images_ = other.images_;
            bitField0_ = (bitField0_ & ~0x00000001);
            imagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getImagesFieldBuilder()
                    : null;
          } else {
            imagesBuilder_.addAllMessages(other.images_);
          }
        }
      }
      if (!other.buildStepImages_.isEmpty()) {
        if (buildStepImages_.isEmpty()) {
          buildStepImages_ = other.buildStepImages_;
          bitField0_ |= 0x00000002;
        } else {
          ensureBuildStepImagesIsMutable();
          buildStepImages_.addAll(other.buildStepImages_);
        }
        onChanged();
      }
      if (!other.getArtifactManifest().isEmpty()) {
        artifactManifest_ = other.artifactManifest_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getNumArtifacts() != 0L) {
        setNumArtifacts(other.getNumArtifacts());
      }
      if (!other.buildStepOutputs_.isEmpty()) {
        if (buildStepOutputs_.isEmpty()) {
          buildStepOutputs_ = other.buildStepOutputs_;
          buildStepOutputs_.makeImmutable();
          bitField0_ |= 0x00000010;
        } else {
          ensureBuildStepOutputsIsMutable();
          buildStepOutputs_.addAll(other.buildStepOutputs_);
        }
        onChanged();
      }
      if (other.hasArtifactTiming()) {
        mergeArtifactTiming(other.getArtifactTiming());
      }
      if (pythonPackagesBuilder_ == null) {
        if (!other.pythonPackages_.isEmpty()) {
          if (pythonPackages_.isEmpty()) {
            pythonPackages_ = other.pythonPackages_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensurePythonPackagesIsMutable();
            pythonPackages_.addAll(other.pythonPackages_);
          }
          onChanged();
        }
      } else {
        if (!other.pythonPackages_.isEmpty()) {
          if (pythonPackagesBuilder_.isEmpty()) {
            pythonPackagesBuilder_.dispose();
            pythonPackagesBuilder_ = null;
            pythonPackages_ = other.pythonPackages_;
            bitField0_ = (bitField0_ & ~0x00000040);
            pythonPackagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPythonPackagesFieldBuilder()
                    : null;
          } else {
            pythonPackagesBuilder_.addAllMessages(other.pythonPackages_);
          }
        }
      }
      if (mavenArtifactsBuilder_ == null) {
        if (!other.mavenArtifacts_.isEmpty()) {
          if (mavenArtifacts_.isEmpty()) {
            mavenArtifacts_ = other.mavenArtifacts_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureMavenArtifactsIsMutable();
            mavenArtifacts_.addAll(other.mavenArtifacts_);
          }
          onChanged();
        }
      } else {
        if (!other.mavenArtifacts_.isEmpty()) {
          if (mavenArtifactsBuilder_.isEmpty()) {
            mavenArtifactsBuilder_.dispose();
            mavenArtifactsBuilder_ = null;
            mavenArtifacts_ = other.mavenArtifacts_;
            bitField0_ = (bitField0_ & ~0x00000080);
            mavenArtifactsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMavenArtifactsFieldBuilder()
                    : null;
          } else {
            mavenArtifactsBuilder_.addAllMessages(other.mavenArtifacts_);
          }
        }
      }
      if (goModulesBuilder_ == null) {
        if (!other.goModules_.isEmpty()) {
          if (goModules_.isEmpty()) {
            goModules_ = other.goModules_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureGoModulesIsMutable();
            goModules_.addAll(other.goModules_);
          }
          onChanged();
        }
      } else {
        if (!other.goModules_.isEmpty()) {
          if (goModulesBuilder_.isEmpty()) {
            goModulesBuilder_.dispose();
            goModulesBuilder_ = null;
            goModules_ = other.goModules_;
            bitField0_ = (bitField0_ & ~0x00000100);
            goModulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGoModulesFieldBuilder()
                    : null;
          } else {
            goModulesBuilder_.addAllMessages(other.goModules_);
          }
        }
      }
      if (npmPackagesBuilder_ == null) {
        if (!other.npmPackages_.isEmpty()) {
          if (npmPackages_.isEmpty()) {
            npmPackages_ = other.npmPackages_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureNpmPackagesIsMutable();
            npmPackages_.addAll(other.npmPackages_);
          }
          onChanged();
        }
      } else {
        if (!other.npmPackages_.isEmpty()) {
          if (npmPackagesBuilder_.isEmpty()) {
            npmPackagesBuilder_.dispose();
            npmPackagesBuilder_ = null;
            npmPackages_ = other.npmPackages_;
            bitField0_ = (bitField0_ & ~0x00000200);
            npmPackagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNpmPackagesFieldBuilder()
                    : null;
          } else {
            npmPackagesBuilder_.addAllMessages(other.npmPackages_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                com.google.cloudbuild.v1.BuiltImage m =
                    input.readMessage(
                        com.google.cloudbuild.v1.BuiltImage.parser(), extensionRegistry);
                if (imagesBuilder_ == null) {
                  ensureImagesIsMutable();
                  images_.add(m);
                } else {
                  imagesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureBuildStepImagesIsMutable();
                buildStepImages_.add(s);
                break;
              } // case 26
            case 34:
              {
                artifactManifest_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 40:
              {
                numArtifacts_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            case 50:
              {
                com.google.protobuf.ByteString v = input.readBytes();
                ensureBuildStepOutputsIsMutable();
                buildStepOutputs_.add(v);
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getArtifactTimingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                com.google.cloudbuild.v1.UploadedPythonPackage m =
                    input.readMessage(
                        com.google.cloudbuild.v1.UploadedPythonPackage.parser(), extensionRegistry);
                if (pythonPackagesBuilder_ == null) {
                  ensurePythonPackagesIsMutable();
                  pythonPackages_.add(m);
                } else {
                  pythonPackagesBuilder_.addMessage(m);
                }
                break;
              } // case 66
            case 74:
              {
                com.google.cloudbuild.v1.UploadedMavenArtifact m =
                    input.readMessage(
                        com.google.cloudbuild.v1.UploadedMavenArtifact.parser(), extensionRegistry);
                if (mavenArtifactsBuilder_ == null) {
                  ensureMavenArtifactsIsMutable();
                  mavenArtifacts_.add(m);
                } else {
                  mavenArtifactsBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 82:
              {
                com.google.cloudbuild.v1.UploadedGoModule m =
                    input.readMessage(
                        com.google.cloudbuild.v1.UploadedGoModule.parser(), extensionRegistry);
                if (goModulesBuilder_ == null) {
                  ensureGoModulesIsMutable();
                  goModules_.add(m);
                } else {
                  goModulesBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 98:
              {
                com.google.cloudbuild.v1.UploadedNpmPackage m =
                    input.readMessage(
                        com.google.cloudbuild.v1.UploadedNpmPackage.parser(), extensionRegistry);
                if (npmPackagesBuilder_ == null) {
                  ensureNpmPackagesIsMutable();
                  npmPackages_.add(m);
                } else {
                  npmPackagesBuilder_.addMessage(m);
                }
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloudbuild.v1.BuiltImage> images_ =
        java.util.Collections.emptyList();

    private void ensureImagesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        images_ = new java.util.ArrayList<com.google.cloudbuild.v1.BuiltImage>(images_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.BuiltImage,
            com.google.cloudbuild.v1.BuiltImage.Builder,
            com.google.cloudbuild.v1.BuiltImageOrBuilder>
        imagesBuilder_;

    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.BuiltImage> getImagesList() {
      if (imagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(images_);
      } else {
        return imagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public int getImagesCount() {
      if (imagesBuilder_ == null) {
        return images_.size();
      } else {
        return imagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public com.google.cloudbuild.v1.BuiltImage getImages(int index) {
      if (imagesBuilder_ == null) {
        return images_.get(index);
      } else {
        return imagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public Builder setImages(int index, com.google.cloudbuild.v1.BuiltImage value) {
      if (imagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureImagesIsMutable();
        images_.set(index, value);
        onChanged();
      } else {
        imagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public Builder setImages(
        int index, com.google.cloudbuild.v1.BuiltImage.Builder builderForValue) {
      if (imagesBuilder_ == null) {
        ensureImagesIsMutable();
        images_.set(index, builderForValue.build());
        onChanged();
      } else {
        imagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public Builder addImages(com.google.cloudbuild.v1.BuiltImage value) {
      if (imagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureImagesIsMutable();
        images_.add(value);
        onChanged();
      } else {
        imagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public Builder addImages(int index, com.google.cloudbuild.v1.BuiltImage value) {
      if (imagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureImagesIsMutable();
        images_.add(index, value);
        onChanged();
      } else {
        imagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public Builder addImages(com.google.cloudbuild.v1.BuiltImage.Builder builderForValue) {
      if (imagesBuilder_ == null) {
        ensureImagesIsMutable();
        images_.add(builderForValue.build());
        onChanged();
      } else {
        imagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public Builder addImages(
        int index, com.google.cloudbuild.v1.BuiltImage.Builder builderForValue) {
      if (imagesBuilder_ == null) {
        ensureImagesIsMutable();
        images_.add(index, builderForValue.build());
        onChanged();
      } else {
        imagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public Builder addAllImages(
        java.lang.Iterable<? extends com.google.cloudbuild.v1.BuiltImage> values) {
      if (imagesBuilder_ == null) {
        ensureImagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, images_);
        onChanged();
      } else {
        imagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public Builder clearImages() {
      if (imagesBuilder_ == null) {
        images_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        imagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public Builder removeImages(int index) {
      if (imagesBuilder_ == null) {
        ensureImagesIsMutable();
        images_.remove(index);
        onChanged();
      } else {
        imagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public com.google.cloudbuild.v1.BuiltImage.Builder getImagesBuilder(int index) {
      return getImagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public com.google.cloudbuild.v1.BuiltImageOrBuilder getImagesOrBuilder(int index) {
      if (imagesBuilder_ == null) {
        return images_.get(index);
      } else {
        return imagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public java.util.List<? extends com.google.cloudbuild.v1.BuiltImageOrBuilder>
        getImagesOrBuilderList() {
      if (imagesBuilder_ != null) {
        return imagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(images_);
      }
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public com.google.cloudbuild.v1.BuiltImage.Builder addImagesBuilder() {
      return getImagesFieldBuilder()
          .addBuilder(com.google.cloudbuild.v1.BuiltImage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public com.google.cloudbuild.v1.BuiltImage.Builder addImagesBuilder(int index) {
      return getImagesFieldBuilder()
          .addBuilder(index, com.google.cloudbuild.v1.BuiltImage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.BuiltImage.Builder> getImagesBuilderList() {
      return getImagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.BuiltImage,
            com.google.cloudbuild.v1.BuiltImage.Builder,
            com.google.cloudbuild.v1.BuiltImageOrBuilder>
        getImagesFieldBuilder() {
      if (imagesBuilder_ == null) {
        imagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloudbuild.v1.BuiltImage,
                com.google.cloudbuild.v1.BuiltImage.Builder,
                com.google.cloudbuild.v1.BuiltImageOrBuilder>(
                images_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        images_ = null;
      }
      return imagesBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList buildStepImages_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureBuildStepImagesIsMutable() {
      if (!buildStepImages_.isModifiable()) {
        buildStepImages_ = new com.google.protobuf.LazyStringArrayList(buildStepImages_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * List of build step digests, in the order corresponding to build step
     * indices.
     * </pre>
     *
     * <code>repeated string build_step_images = 3;</code>
     *
     * @return A list containing the buildStepImages.
     */
    public com.google.protobuf.ProtocolStringList getBuildStepImagesList() {
      buildStepImages_.makeImmutable();
      return buildStepImages_;
    }
    /**
     *
     *
     * <pre>
     * List of build step digests, in the order corresponding to build step
     * indices.
     * </pre>
     *
     * <code>repeated string build_step_images = 3;</code>
     *
     * @return The count of buildStepImages.
     */
    public int getBuildStepImagesCount() {
      return buildStepImages_.size();
    }
    /**
     *
     *
     * <pre>
     * List of build step digests, in the order corresponding to build step
     * indices.
     * </pre>
     *
     * <code>repeated string build_step_images = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The buildStepImages at the given index.
     */
    public java.lang.String getBuildStepImages(int index) {
      return buildStepImages_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of build step digests, in the order corresponding to build step
     * indices.
     * </pre>
     *
     * <code>repeated string build_step_images = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the buildStepImages at the given index.
     */
    public com.google.protobuf.ByteString getBuildStepImagesBytes(int index) {
      return buildStepImages_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of build step digests, in the order corresponding to build step
     * indices.
     * </pre>
     *
     * <code>repeated string build_step_images = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The buildStepImages to set.
     * @return This builder for chaining.
     */
    public Builder setBuildStepImages(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBuildStepImagesIsMutable();
      buildStepImages_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of build step digests, in the order corresponding to build step
     * indices.
     * </pre>
     *
     * <code>repeated string build_step_images = 3;</code>
     *
     * @param value The buildStepImages to add.
     * @return This builder for chaining.
     */
    public Builder addBuildStepImages(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBuildStepImagesIsMutable();
      buildStepImages_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of build step digests, in the order corresponding to build step
     * indices.
     * </pre>
     *
     * <code>repeated string build_step_images = 3;</code>
     *
     * @param values The buildStepImages to add.
     * @return This builder for chaining.
     */
    public Builder addAllBuildStepImages(java.lang.Iterable<java.lang.String> values) {
      ensureBuildStepImagesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, buildStepImages_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of build step digests, in the order corresponding to build step
     * indices.
     * </pre>
     *
     * <code>repeated string build_step_images = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBuildStepImages() {
      buildStepImages_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of build step digests, in the order corresponding to build step
     * indices.
     * </pre>
     *
     * <code>repeated string build_step_images = 3;</code>
     *
     * @param value The bytes of the buildStepImages to add.
     * @return This builder for chaining.
     */
    public Builder addBuildStepImagesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureBuildStepImagesIsMutable();
      buildStepImages_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object artifactManifest_ = "";
    /**
     *
     *
     * <pre>
     * Path to the artifact manifest for non-container artifacts uploaded to Cloud
     * Storage. Only populated when artifacts are uploaded to Cloud Storage.
     * </pre>
     *
     * <code>string artifact_manifest = 4;</code>
     *
     * @return The artifactManifest.
     */
    public java.lang.String getArtifactManifest() {
      java.lang.Object ref = artifactManifest_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        artifactManifest_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Path to the artifact manifest for non-container artifacts uploaded to Cloud
     * Storage. Only populated when artifacts are uploaded to Cloud Storage.
     * </pre>
     *
     * <code>string artifact_manifest = 4;</code>
     *
     * @return The bytes for artifactManifest.
     */
    public com.google.protobuf.ByteString getArtifactManifestBytes() {
      java.lang.Object ref = artifactManifest_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        artifactManifest_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Path to the artifact manifest for non-container artifacts uploaded to Cloud
     * Storage. Only populated when artifacts are uploaded to Cloud Storage.
     * </pre>
     *
     * <code>string artifact_manifest = 4;</code>
     *
     * @param value The artifactManifest to set.
     * @return This builder for chaining.
     */
    public Builder setArtifactManifest(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      artifactManifest_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Path to the artifact manifest for non-container artifacts uploaded to Cloud
     * Storage. Only populated when artifacts are uploaded to Cloud Storage.
     * </pre>
     *
     * <code>string artifact_manifest = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArtifactManifest() {
      artifactManifest_ = getDefaultInstance().getArtifactManifest();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Path to the artifact manifest for non-container artifacts uploaded to Cloud
     * Storage. Only populated when artifacts are uploaded to Cloud Storage.
     * </pre>
     *
     * <code>string artifact_manifest = 4;</code>
     *
     * @param value The bytes for artifactManifest to set.
     * @return This builder for chaining.
     */
    public Builder setArtifactManifestBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      artifactManifest_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private long numArtifacts_;
    /**
     *
     *
     * <pre>
     * Number of non-container artifacts uploaded to Cloud Storage. Only populated
     * when artifacts are uploaded to Cloud Storage.
     * </pre>
     *
     * <code>int64 num_artifacts = 5;</code>
     *
     * @return The numArtifacts.
     */
    @java.lang.Override
    public long getNumArtifacts() {
      return numArtifacts_;
    }
    /**
     *
     *
     * <pre>
     * Number of non-container artifacts uploaded to Cloud Storage. Only populated
     * when artifacts are uploaded to Cloud Storage.
     * </pre>
     *
     * <code>int64 num_artifacts = 5;</code>
     *
     * @param value The numArtifacts to set.
     * @return This builder for chaining.
     */
    public Builder setNumArtifacts(long value) {

      numArtifacts_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of non-container artifacts uploaded to Cloud Storage. Only populated
     * when artifacts are uploaded to Cloud Storage.
     * </pre>
     *
     * <code>int64 num_artifacts = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNumArtifacts() {
      bitField0_ = (bitField0_ & ~0x00000008);
      numArtifacts_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.ProtobufList<com.google.protobuf.ByteString>
        buildStepOutputs_ = emptyList(com.google.protobuf.ByteString.class);

    private void ensureBuildStepOutputsIsMutable() {
      if (!buildStepOutputs_.isModifiable()) {
        buildStepOutputs_ = makeMutableCopy(buildStepOutputs_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * List of build step outputs, produced by builder images, in the order
     * corresponding to build step indices.
     *
     * [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
     * can produce this output by writing to `$BUILDER_OUTPUT/output`.
     * Only the first 4KB of data is stored.
     * </pre>
     *
     * <code>repeated bytes build_step_outputs = 6;</code>
     *
     * @return A list containing the buildStepOutputs.
     */
    public java.util.List<com.google.protobuf.ByteString> getBuildStepOutputsList() {
      buildStepOutputs_.makeImmutable();
      return buildStepOutputs_;
    }
    /**
     *
     *
     * <pre>
     * List of build step outputs, produced by builder images, in the order
     * corresponding to build step indices.
     *
     * [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
     * can produce this output by writing to `$BUILDER_OUTPUT/output`.
     * Only the first 4KB of data is stored.
     * </pre>
     *
     * <code>repeated bytes build_step_outputs = 6;</code>
     *
     * @return The count of buildStepOutputs.
     */
    public int getBuildStepOutputsCount() {
      return buildStepOutputs_.size();
    }
    /**
     *
     *
     * <pre>
     * List of build step outputs, produced by builder images, in the order
     * corresponding to build step indices.
     *
     * [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
     * can produce this output by writing to `$BUILDER_OUTPUT/output`.
     * Only the first 4KB of data is stored.
     * </pre>
     *
     * <code>repeated bytes build_step_outputs = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The buildStepOutputs at the given index.
     */
    public com.google.protobuf.ByteString getBuildStepOutputs(int index) {
      return buildStepOutputs_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of build step outputs, produced by builder images, in the order
     * corresponding to build step indices.
     *
     * [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
     * can produce this output by writing to `$BUILDER_OUTPUT/output`.
     * Only the first 4KB of data is stored.
     * </pre>
     *
     * <code>repeated bytes build_step_outputs = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The buildStepOutputs to set.
     * @return This builder for chaining.
     */
    public Builder setBuildStepOutputs(int index, com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBuildStepOutputsIsMutable();
      buildStepOutputs_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of build step outputs, produced by builder images, in the order
     * corresponding to build step indices.
     *
     * [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
     * can produce this output by writing to `$BUILDER_OUTPUT/output`.
     * Only the first 4KB of data is stored.
     * </pre>
     *
     * <code>repeated bytes build_step_outputs = 6;</code>
     *
     * @param value The buildStepOutputs to add.
     * @return This builder for chaining.
     */
    public Builder addBuildStepOutputs(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBuildStepOutputsIsMutable();
      buildStepOutputs_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of build step outputs, produced by builder images, in the order
     * corresponding to build step indices.
     *
     * [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
     * can produce this output by writing to `$BUILDER_OUTPUT/output`.
     * Only the first 4KB of data is stored.
     * </pre>
     *
     * <code>repeated bytes build_step_outputs = 6;</code>
     *
     * @param values The buildStepOutputs to add.
     * @return This builder for chaining.
     */
    public Builder addAllBuildStepOutputs(
        java.lang.Iterable<? extends com.google.protobuf.ByteString> values) {
      ensureBuildStepOutputsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, buildStepOutputs_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of build step outputs, produced by builder images, in the order
     * corresponding to build step indices.
     *
     * [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
     * can produce this output by writing to `$BUILDER_OUTPUT/output`.
     * Only the first 4KB of data is stored.
     * </pre>
     *
     * <code>repeated bytes build_step_outputs = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBuildStepOutputs() {
      buildStepOutputs_ = emptyList(com.google.protobuf.ByteString.class);
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    private com.google.cloudbuild.v1.TimeSpan artifactTiming_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.TimeSpan,
            com.google.cloudbuild.v1.TimeSpan.Builder,
            com.google.cloudbuild.v1.TimeSpanOrBuilder>
        artifactTimingBuilder_;
    /**
     *
     *
     * <pre>
     * Time to push all non-container artifacts to Cloud Storage.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
     *
     * @return Whether the artifactTiming field is set.
     */
    public boolean hasArtifactTiming() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time to push all non-container artifacts to Cloud Storage.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
     *
     * @return The artifactTiming.
     */
    public com.google.cloudbuild.v1.TimeSpan getArtifactTiming() {
      if (artifactTimingBuilder_ == null) {
        return artifactTiming_ == null
            ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance()
            : artifactTiming_;
      } else {
        return artifactTimingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time to push all non-container artifacts to Cloud Storage.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
     */
    public Builder setArtifactTiming(com.google.cloudbuild.v1.TimeSpan value) {
      if (artifactTimingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        artifactTiming_ = value;
      } else {
        artifactTimingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time to push all non-container artifacts to Cloud Storage.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
     */
    public Builder setArtifactTiming(com.google.cloudbuild.v1.TimeSpan.Builder builderForValue) {
      if (artifactTimingBuilder_ == null) {
        artifactTiming_ = builderForValue.build();
      } else {
        artifactTimingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time to push all non-container artifacts to Cloud Storage.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
     */
    public Builder mergeArtifactTiming(com.google.cloudbuild.v1.TimeSpan value) {
      if (artifactTimingBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && artifactTiming_ != null
            && artifactTiming_ != com.google.cloudbuild.v1.TimeSpan.getDefaultInstance()) {
          getArtifactTimingBuilder().mergeFrom(value);
        } else {
          artifactTiming_ = value;
        }
      } else {
        artifactTimingBuilder_.mergeFrom(value);
      }
      if (artifactTiming_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time to push all non-container artifacts to Cloud Storage.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
     */
    public Builder clearArtifactTiming() {
      bitField0_ = (bitField0_ & ~0x00000020);
      artifactTiming_ = null;
      if (artifactTimingBuilder_ != null) {
        artifactTimingBuilder_.dispose();
        artifactTimingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time to push all non-container artifacts to Cloud Storage.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
     */
    public com.google.cloudbuild.v1.TimeSpan.Builder getArtifactTimingBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getArtifactTimingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time to push all non-container artifacts to Cloud Storage.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
     */
    public com.google.cloudbuild.v1.TimeSpanOrBuilder getArtifactTimingOrBuilder() {
      if (artifactTimingBuilder_ != null) {
        return artifactTimingBuilder_.getMessageOrBuilder();
      } else {
        return artifactTiming_ == null
            ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance()
            : artifactTiming_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time to push all non-container artifacts to Cloud Storage.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.TimeSpan,
            com.google.cloudbuild.v1.TimeSpan.Builder,
            com.google.cloudbuild.v1.TimeSpanOrBuilder>
        getArtifactTimingFieldBuilder() {
      if (artifactTimingBuilder_ == null) {
        artifactTimingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.TimeSpan,
                com.google.cloudbuild.v1.TimeSpan.Builder,
                com.google.cloudbuild.v1.TimeSpanOrBuilder>(
                getArtifactTiming(), getParentForChildren(), isClean());
        artifactTiming_ = null;
      }
      return artifactTimingBuilder_;
    }

    private java.util.List<com.google.cloudbuild.v1.UploadedPythonPackage> pythonPackages_ =
        java.util.Collections.emptyList();

    private void ensurePythonPackagesIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        pythonPackages_ =
            new java.util.ArrayList<com.google.cloudbuild.v1.UploadedPythonPackage>(
                pythonPackages_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.UploadedPythonPackage,
            com.google.cloudbuild.v1.UploadedPythonPackage.Builder,
            com.google.cloudbuild.v1.UploadedPythonPackageOrBuilder>
        pythonPackagesBuilder_;

    /**
     *
     *
     * <pre>
     * Python artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;
     * </code>
     */
    public java.util.List<com.google.cloudbuild.v1.UploadedPythonPackage> getPythonPackagesList() {
      if (pythonPackagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(pythonPackages_);
      } else {
        return pythonPackagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Python artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;
     * </code>
     */
    public int getPythonPackagesCount() {
      if (pythonPackagesBuilder_ == null) {
        return pythonPackages_.size();
      } else {
        return pythonPackagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Python artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;
     * </code>
     */
    public com.google.cloudbuild.v1.UploadedPythonPackage getPythonPackages(int index) {
      if (pythonPackagesBuilder_ == null) {
        return pythonPackages_.get(index);
      } else {
        return pythonPackagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Python artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;
     * </code>
     */
    public Builder setPythonPackages(
        int index, com.google.cloudbuild.v1.UploadedPythonPackage value) {
      if (pythonPackagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePythonPackagesIsMutable();
        pythonPackages_.set(index, value);
        onChanged();
      } else {
        pythonPackagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Python artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;
     * </code>
     */
    public Builder setPythonPackages(
        int index, com.google.cloudbuild.v1.UploadedPythonPackage.Builder builderForValue) {
      if (pythonPackagesBuilder_ == null) {
        ensurePythonPackagesIsMutable();
        pythonPackages_.set(index, builderForValue.build());
        onChanged();
      } else {
        pythonPackagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Python artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;
     * </code>
     */
    public Builder addPythonPackages(com.google.cloudbuild.v1.UploadedPythonPackage value) {
      if (pythonPackagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePythonPackagesIsMutable();
        pythonPackages_.add(value);
        onChanged();
      } else {
        pythonPackagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Python artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;
     * </code>
     */
    public Builder addPythonPackages(
        int index, com.google.cloudbuild.v1.UploadedPythonPackage value) {
      if (pythonPackagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePythonPackagesIsMutable();
        pythonPackages_.add(index, value);
        onChanged();
      } else {
        pythonPackagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Python artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;
     * </code>
     */
    public Builder addPythonPackages(
        com.google.cloudbuild.v1.UploadedPythonPackage.Builder builderForValue) {
      if (pythonPackagesBuilder_ == null) {
        ensurePythonPackagesIsMutable();
        pythonPackages_.add(builderForValue.build());
        onChanged();
      } else {
        pythonPackagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Python artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;
     * </code>
     */
    public Builder addPythonPackages(
        int index, com.google.cloudbuild.v1.UploadedPythonPackage.Builder builderForValue) {
      if (pythonPackagesBuilder_ == null) {
        ensurePythonPackagesIsMutable();
        pythonPackages_.add(index, builderForValue.build());
        onChanged();
      } else {
        pythonPackagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Python artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;
     * </code>
     */
    public Builder addAllPythonPackages(
        java.lang.Iterable<? extends com.google.cloudbuild.v1.UploadedPythonPackage> values) {
      if (pythonPackagesBuilder_ == null) {
        ensurePythonPackagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pythonPackages_);
        onChanged();
      } else {
        pythonPackagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Python artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;
     * </code>
     */
    public Builder clearPythonPackages() {
      if (pythonPackagesBuilder_ == null) {
        pythonPackages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        pythonPackagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Python artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;
     * </code>
     */
    public Builder removePythonPackages(int index) {
      if (pythonPackagesBuilder_ == null) {
        ensurePythonPackagesIsMutable();
        pythonPackages_.remove(index);
        onChanged();
      } else {
        pythonPackagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Python artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;
     * </code>
     */
    public com.google.cloudbuild.v1.UploadedPythonPackage.Builder getPythonPackagesBuilder(
        int index) {
      return getPythonPackagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Python artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;
     * </code>
     */
    public com.google.cloudbuild.v1.UploadedPythonPackageOrBuilder getPythonPackagesOrBuilder(
        int index) {
      if (pythonPackagesBuilder_ == null) {
        return pythonPackages_.get(index);
      } else {
        return pythonPackagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Python artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;
     * </code>
     */
    public java.util.List<? extends com.google.cloudbuild.v1.UploadedPythonPackageOrBuilder>
        getPythonPackagesOrBuilderList() {
      if (pythonPackagesBuilder_ != null) {
        return pythonPackagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(pythonPackages_);
      }
    }
    /**
     *
     *
     * <pre>
     * Python artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;
     * </code>
     */
    public com.google.cloudbuild.v1.UploadedPythonPackage.Builder addPythonPackagesBuilder() {
      return getPythonPackagesFieldBuilder()
          .addBuilder(com.google.cloudbuild.v1.UploadedPythonPackage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Python artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;
     * </code>
     */
    public com.google.cloudbuild.v1.UploadedPythonPackage.Builder addPythonPackagesBuilder(
        int index) {
      return getPythonPackagesFieldBuilder()
          .addBuilder(index, com.google.cloudbuild.v1.UploadedPythonPackage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Python artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedPythonPackage python_packages = 8;
     * </code>
     */
    public java.util.List<com.google.cloudbuild.v1.UploadedPythonPackage.Builder>
        getPythonPackagesBuilderList() {
      return getPythonPackagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.UploadedPythonPackage,
            com.google.cloudbuild.v1.UploadedPythonPackage.Builder,
            com.google.cloudbuild.v1.UploadedPythonPackageOrBuilder>
        getPythonPackagesFieldBuilder() {
      if (pythonPackagesBuilder_ == null) {
        pythonPackagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloudbuild.v1.UploadedPythonPackage,
                com.google.cloudbuild.v1.UploadedPythonPackage.Builder,
                com.google.cloudbuild.v1.UploadedPythonPackageOrBuilder>(
                pythonPackages_,
                ((bitField0_ & 0x00000040) != 0),
                getParentForChildren(),
                isClean());
        pythonPackages_ = null;
      }
      return pythonPackagesBuilder_;
    }

    private java.util.List<com.google.cloudbuild.v1.UploadedMavenArtifact> mavenArtifacts_ =
        java.util.Collections.emptyList();

    private void ensureMavenArtifactsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        mavenArtifacts_ =
            new java.util.ArrayList<com.google.cloudbuild.v1.UploadedMavenArtifact>(
                mavenArtifacts_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.UploadedMavenArtifact,
            com.google.cloudbuild.v1.UploadedMavenArtifact.Builder,
            com.google.cloudbuild.v1.UploadedMavenArtifactOrBuilder>
        mavenArtifactsBuilder_;

    /**
     *
     *
     * <pre>
     * Maven artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;
     * </code>
     */
    public java.util.List<com.google.cloudbuild.v1.UploadedMavenArtifact> getMavenArtifactsList() {
      if (mavenArtifactsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(mavenArtifacts_);
      } else {
        return mavenArtifactsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Maven artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;
     * </code>
     */
    public int getMavenArtifactsCount() {
      if (mavenArtifactsBuilder_ == null) {
        return mavenArtifacts_.size();
      } else {
        return mavenArtifactsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Maven artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;
     * </code>
     */
    public com.google.cloudbuild.v1.UploadedMavenArtifact getMavenArtifacts(int index) {
      if (mavenArtifactsBuilder_ == null) {
        return mavenArtifacts_.get(index);
      } else {
        return mavenArtifactsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Maven artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;
     * </code>
     */
    public Builder setMavenArtifacts(
        int index, com.google.cloudbuild.v1.UploadedMavenArtifact value) {
      if (mavenArtifactsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMavenArtifactsIsMutable();
        mavenArtifacts_.set(index, value);
        onChanged();
      } else {
        mavenArtifactsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maven artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;
     * </code>
     */
    public Builder setMavenArtifacts(
        int index, com.google.cloudbuild.v1.UploadedMavenArtifact.Builder builderForValue) {
      if (mavenArtifactsBuilder_ == null) {
        ensureMavenArtifactsIsMutable();
        mavenArtifacts_.set(index, builderForValue.build());
        onChanged();
      } else {
        mavenArtifactsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maven artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;
     * </code>
     */
    public Builder addMavenArtifacts(com.google.cloudbuild.v1.UploadedMavenArtifact value) {
      if (mavenArtifactsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMavenArtifactsIsMutable();
        mavenArtifacts_.add(value);
        onChanged();
      } else {
        mavenArtifactsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maven artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;
     * </code>
     */
    public Builder addMavenArtifacts(
        int index, com.google.cloudbuild.v1.UploadedMavenArtifact value) {
      if (mavenArtifactsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMavenArtifactsIsMutable();
        mavenArtifacts_.add(index, value);
        onChanged();
      } else {
        mavenArtifactsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maven artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;
     * </code>
     */
    public Builder addMavenArtifacts(
        com.google.cloudbuild.v1.UploadedMavenArtifact.Builder builderForValue) {
      if (mavenArtifactsBuilder_ == null) {
        ensureMavenArtifactsIsMutable();
        mavenArtifacts_.add(builderForValue.build());
        onChanged();
      } else {
        mavenArtifactsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maven artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;
     * </code>
     */
    public Builder addMavenArtifacts(
        int index, com.google.cloudbuild.v1.UploadedMavenArtifact.Builder builderForValue) {
      if (mavenArtifactsBuilder_ == null) {
        ensureMavenArtifactsIsMutable();
        mavenArtifacts_.add(index, builderForValue.build());
        onChanged();
      } else {
        mavenArtifactsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maven artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;
     * </code>
     */
    public Builder addAllMavenArtifacts(
        java.lang.Iterable<? extends com.google.cloudbuild.v1.UploadedMavenArtifact> values) {
      if (mavenArtifactsBuilder_ == null) {
        ensureMavenArtifactsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, mavenArtifacts_);
        onChanged();
      } else {
        mavenArtifactsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maven artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;
     * </code>
     */
    public Builder clearMavenArtifacts() {
      if (mavenArtifactsBuilder_ == null) {
        mavenArtifacts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        mavenArtifactsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maven artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;
     * </code>
     */
    public Builder removeMavenArtifacts(int index) {
      if (mavenArtifactsBuilder_ == null) {
        ensureMavenArtifactsIsMutable();
        mavenArtifacts_.remove(index);
        onChanged();
      } else {
        mavenArtifactsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maven artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;
     * </code>
     */
    public com.google.cloudbuild.v1.UploadedMavenArtifact.Builder getMavenArtifactsBuilder(
        int index) {
      return getMavenArtifactsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Maven artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;
     * </code>
     */
    public com.google.cloudbuild.v1.UploadedMavenArtifactOrBuilder getMavenArtifactsOrBuilder(
        int index) {
      if (mavenArtifactsBuilder_ == null) {
        return mavenArtifacts_.get(index);
      } else {
        return mavenArtifactsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Maven artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;
     * </code>
     */
    public java.util.List<? extends com.google.cloudbuild.v1.UploadedMavenArtifactOrBuilder>
        getMavenArtifactsOrBuilderList() {
      if (mavenArtifactsBuilder_ != null) {
        return mavenArtifactsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(mavenArtifacts_);
      }
    }
    /**
     *
     *
     * <pre>
     * Maven artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;
     * </code>
     */
    public com.google.cloudbuild.v1.UploadedMavenArtifact.Builder addMavenArtifactsBuilder() {
      return getMavenArtifactsFieldBuilder()
          .addBuilder(com.google.cloudbuild.v1.UploadedMavenArtifact.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Maven artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;
     * </code>
     */
    public com.google.cloudbuild.v1.UploadedMavenArtifact.Builder addMavenArtifactsBuilder(
        int index) {
      return getMavenArtifactsFieldBuilder()
          .addBuilder(index, com.google.cloudbuild.v1.UploadedMavenArtifact.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Maven artifacts uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedMavenArtifact maven_artifacts = 9;
     * </code>
     */
    public java.util.List<com.google.cloudbuild.v1.UploadedMavenArtifact.Builder>
        getMavenArtifactsBuilderList() {
      return getMavenArtifactsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.UploadedMavenArtifact,
            com.google.cloudbuild.v1.UploadedMavenArtifact.Builder,
            com.google.cloudbuild.v1.UploadedMavenArtifactOrBuilder>
        getMavenArtifactsFieldBuilder() {
      if (mavenArtifactsBuilder_ == null) {
        mavenArtifactsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloudbuild.v1.UploadedMavenArtifact,
                com.google.cloudbuild.v1.UploadedMavenArtifact.Builder,
                com.google.cloudbuild.v1.UploadedMavenArtifactOrBuilder>(
                mavenArtifacts_,
                ((bitField0_ & 0x00000080) != 0),
                getParentForChildren(),
                isClean());
        mavenArtifacts_ = null;
      }
      return mavenArtifactsBuilder_;
    }

    private java.util.List<com.google.cloudbuild.v1.UploadedGoModule> goModules_ =
        java.util.Collections.emptyList();

    private void ensureGoModulesIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        goModules_ = new java.util.ArrayList<com.google.cloudbuild.v1.UploadedGoModule>(goModules_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.UploadedGoModule,
            com.google.cloudbuild.v1.UploadedGoModule.Builder,
            com.google.cloudbuild.v1.UploadedGoModuleOrBuilder>
        goModulesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Go module artifacts uploaded to Artifact Registry at the end of
     * the build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloudbuild.v1.UploadedGoModule> getGoModulesList() {
      if (goModulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(goModules_);
      } else {
        return goModulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Go module artifacts uploaded to Artifact Registry at the end of
     * the build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getGoModulesCount() {
      if (goModulesBuilder_ == null) {
        return goModules_.size();
      } else {
        return goModulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Go module artifacts uploaded to Artifact Registry at the end of
     * the build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloudbuild.v1.UploadedGoModule getGoModules(int index) {
      if (goModulesBuilder_ == null) {
        return goModules_.get(index);
      } else {
        return goModulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Go module artifacts uploaded to Artifact Registry at the end of
     * the build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGoModules(int index, com.google.cloudbuild.v1.UploadedGoModule value) {
      if (goModulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGoModulesIsMutable();
        goModules_.set(index, value);
        onChanged();
      } else {
        goModulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Go module artifacts uploaded to Artifact Registry at the end of
     * the build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGoModules(
        int index, com.google.cloudbuild.v1.UploadedGoModule.Builder builderForValue) {
      if (goModulesBuilder_ == null) {
        ensureGoModulesIsMutable();
        goModules_.set(index, builderForValue.build());
        onChanged();
      } else {
        goModulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Go module artifacts uploaded to Artifact Registry at the end of
     * the build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addGoModules(com.google.cloudbuild.v1.UploadedGoModule value) {
      if (goModulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGoModulesIsMutable();
        goModules_.add(value);
        onChanged();
      } else {
        goModulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Go module artifacts uploaded to Artifact Registry at the end of
     * the build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addGoModules(int index, com.google.cloudbuild.v1.UploadedGoModule value) {
      if (goModulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGoModulesIsMutable();
        goModules_.add(index, value);
        onChanged();
      } else {
        goModulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Go module artifacts uploaded to Artifact Registry at the end of
     * the build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addGoModules(com.google.cloudbuild.v1.UploadedGoModule.Builder builderForValue) {
      if (goModulesBuilder_ == null) {
        ensureGoModulesIsMutable();
        goModules_.add(builderForValue.build());
        onChanged();
      } else {
        goModulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Go module artifacts uploaded to Artifact Registry at the end of
     * the build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addGoModules(
        int index, com.google.cloudbuild.v1.UploadedGoModule.Builder builderForValue) {
      if (goModulesBuilder_ == null) {
        ensureGoModulesIsMutable();
        goModules_.add(index, builderForValue.build());
        onChanged();
      } else {
        goModulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Go module artifacts uploaded to Artifact Registry at the end of
     * the build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllGoModules(
        java.lang.Iterable<? extends com.google.cloudbuild.v1.UploadedGoModule> values) {
      if (goModulesBuilder_ == null) {
        ensureGoModulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, goModules_);
        onChanged();
      } else {
        goModulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Go module artifacts uploaded to Artifact Registry at the end of
     * the build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGoModules() {
      if (goModulesBuilder_ == null) {
        goModules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        goModulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Go module artifacts uploaded to Artifact Registry at the end of
     * the build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeGoModules(int index) {
      if (goModulesBuilder_ == null) {
        ensureGoModulesIsMutable();
        goModules_.remove(index);
        onChanged();
      } else {
        goModulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Go module artifacts uploaded to Artifact Registry at the end of
     * the build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloudbuild.v1.UploadedGoModule.Builder getGoModulesBuilder(int index) {
      return getGoModulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Go module artifacts uploaded to Artifact Registry at the end of
     * the build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloudbuild.v1.UploadedGoModuleOrBuilder getGoModulesOrBuilder(int index) {
      if (goModulesBuilder_ == null) {
        return goModules_.get(index);
      } else {
        return goModulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Go module artifacts uploaded to Artifact Registry at the end of
     * the build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloudbuild.v1.UploadedGoModuleOrBuilder>
        getGoModulesOrBuilderList() {
      if (goModulesBuilder_ != null) {
        return goModulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(goModules_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Go module artifacts uploaded to Artifact Registry at the end of
     * the build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloudbuild.v1.UploadedGoModule.Builder addGoModulesBuilder() {
      return getGoModulesFieldBuilder()
          .addBuilder(com.google.cloudbuild.v1.UploadedGoModule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Go module artifacts uploaded to Artifact Registry at the end of
     * the build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloudbuild.v1.UploadedGoModule.Builder addGoModulesBuilder(int index) {
      return getGoModulesFieldBuilder()
          .addBuilder(index, com.google.cloudbuild.v1.UploadedGoModule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Go module artifacts uploaded to Artifact Registry at the end of
     * the build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.UploadedGoModule go_modules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloudbuild.v1.UploadedGoModule.Builder>
        getGoModulesBuilderList() {
      return getGoModulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.UploadedGoModule,
            com.google.cloudbuild.v1.UploadedGoModule.Builder,
            com.google.cloudbuild.v1.UploadedGoModuleOrBuilder>
        getGoModulesFieldBuilder() {
      if (goModulesBuilder_ == null) {
        goModulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloudbuild.v1.UploadedGoModule,
                com.google.cloudbuild.v1.UploadedGoModule.Builder,
                com.google.cloudbuild.v1.UploadedGoModuleOrBuilder>(
                goModules_, ((bitField0_ & 0x00000100) != 0), getParentForChildren(), isClean());
        goModules_ = null;
      }
      return goModulesBuilder_;
    }

    private java.util.List<com.google.cloudbuild.v1.UploadedNpmPackage> npmPackages_ =
        java.util.Collections.emptyList();

    private void ensureNpmPackagesIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        npmPackages_ =
            new java.util.ArrayList<com.google.cloudbuild.v1.UploadedNpmPackage>(npmPackages_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.UploadedNpmPackage,
            com.google.cloudbuild.v1.UploadedNpmPackage.Builder,
            com.google.cloudbuild.v1.UploadedNpmPackageOrBuilder>
        npmPackagesBuilder_;

    /**
     *
     *
     * <pre>
     * Npm packages uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.UploadedNpmPackage> getNpmPackagesList() {
      if (npmPackagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(npmPackages_);
      } else {
        return npmPackagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Npm packages uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
     */
    public int getNpmPackagesCount() {
      if (npmPackagesBuilder_ == null) {
        return npmPackages_.size();
      } else {
        return npmPackagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Npm packages uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
     */
    public com.google.cloudbuild.v1.UploadedNpmPackage getNpmPackages(int index) {
      if (npmPackagesBuilder_ == null) {
        return npmPackages_.get(index);
      } else {
        return npmPackagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Npm packages uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
     */
    public Builder setNpmPackages(int index, com.google.cloudbuild.v1.UploadedNpmPackage value) {
      if (npmPackagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNpmPackagesIsMutable();
        npmPackages_.set(index, value);
        onChanged();
      } else {
        npmPackagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Npm packages uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
     */
    public Builder setNpmPackages(
        int index, com.google.cloudbuild.v1.UploadedNpmPackage.Builder builderForValue) {
      if (npmPackagesBuilder_ == null) {
        ensureNpmPackagesIsMutable();
        npmPackages_.set(index, builderForValue.build());
        onChanged();
      } else {
        npmPackagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Npm packages uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
     */
    public Builder addNpmPackages(com.google.cloudbuild.v1.UploadedNpmPackage value) {
      if (npmPackagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNpmPackagesIsMutable();
        npmPackages_.add(value);
        onChanged();
      } else {
        npmPackagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Npm packages uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
     */
    public Builder addNpmPackages(int index, com.google.cloudbuild.v1.UploadedNpmPackage value) {
      if (npmPackagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNpmPackagesIsMutable();
        npmPackages_.add(index, value);
        onChanged();
      } else {
        npmPackagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Npm packages uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
     */
    public Builder addNpmPackages(
        com.google.cloudbuild.v1.UploadedNpmPackage.Builder builderForValue) {
      if (npmPackagesBuilder_ == null) {
        ensureNpmPackagesIsMutable();
        npmPackages_.add(builderForValue.build());
        onChanged();
      } else {
        npmPackagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Npm packages uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
     */
    public Builder addNpmPackages(
        int index, com.google.cloudbuild.v1.UploadedNpmPackage.Builder builderForValue) {
      if (npmPackagesBuilder_ == null) {
        ensureNpmPackagesIsMutable();
        npmPackages_.add(index, builderForValue.build());
        onChanged();
      } else {
        npmPackagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Npm packages uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
     */
    public Builder addAllNpmPackages(
        java.lang.Iterable<? extends com.google.cloudbuild.v1.UploadedNpmPackage> values) {
      if (npmPackagesBuilder_ == null) {
        ensureNpmPackagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, npmPackages_);
        onChanged();
      } else {
        npmPackagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Npm packages uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
     */
    public Builder clearNpmPackages() {
      if (npmPackagesBuilder_ == null) {
        npmPackages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        npmPackagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Npm packages uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
     */
    public Builder removeNpmPackages(int index) {
      if (npmPackagesBuilder_ == null) {
        ensureNpmPackagesIsMutable();
        npmPackages_.remove(index);
        onChanged();
      } else {
        npmPackagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Npm packages uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
     */
    public com.google.cloudbuild.v1.UploadedNpmPackage.Builder getNpmPackagesBuilder(int index) {
      return getNpmPackagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Npm packages uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
     */
    public com.google.cloudbuild.v1.UploadedNpmPackageOrBuilder getNpmPackagesOrBuilder(int index) {
      if (npmPackagesBuilder_ == null) {
        return npmPackages_.get(index);
      } else {
        return npmPackagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Npm packages uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
     */
    public java.util.List<? extends com.google.cloudbuild.v1.UploadedNpmPackageOrBuilder>
        getNpmPackagesOrBuilderList() {
      if (npmPackagesBuilder_ != null) {
        return npmPackagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(npmPackages_);
      }
    }
    /**
     *
     *
     * <pre>
     * Npm packages uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
     */
    public com.google.cloudbuild.v1.UploadedNpmPackage.Builder addNpmPackagesBuilder() {
      return getNpmPackagesFieldBuilder()
          .addBuilder(com.google.cloudbuild.v1.UploadedNpmPackage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Npm packages uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
     */
    public com.google.cloudbuild.v1.UploadedNpmPackage.Builder addNpmPackagesBuilder(int index) {
      return getNpmPackagesFieldBuilder()
          .addBuilder(index, com.google.cloudbuild.v1.UploadedNpmPackage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Npm packages uploaded to Artifact Registry at the end of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.UploadedNpmPackage npm_packages = 12;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.UploadedNpmPackage.Builder>
        getNpmPackagesBuilderList() {
      return getNpmPackagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.UploadedNpmPackage,
            com.google.cloudbuild.v1.UploadedNpmPackage.Builder,
            com.google.cloudbuild.v1.UploadedNpmPackageOrBuilder>
        getNpmPackagesFieldBuilder() {
      if (npmPackagesBuilder_ == null) {
        npmPackagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloudbuild.v1.UploadedNpmPackage,
                com.google.cloudbuild.v1.UploadedNpmPackage.Builder,
                com.google.cloudbuild.v1.UploadedNpmPackageOrBuilder>(
                npmPackages_, ((bitField0_ & 0x00000200) != 0), getParentForChildren(), isClean());
        npmPackages_ = null;
      }
      return npmPackagesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.Results)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.Results)
  private static final com.google.cloudbuild.v1.Results DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.Results();
  }

  public static com.google.cloudbuild.v1.Results getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Results> PARSER =
      new com.google.protobuf.AbstractParser<Results>() {
        @java.lang.Override
        public Results parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Results> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Results> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.Results getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
