/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v2/repositories.proto

package com.google.cloudbuild.v2;

/**
 *
 *
 * <pre>
 * Configuration for connections to an instance of GitHub Enterprise.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v2.GitHubEnterpriseConfig}
 */
public final class GitHubEnterpriseConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v2.GitHubEnterpriseConfig)
    GitHubEnterpriseConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GitHubEnterpriseConfig.newBuilder() to construct.
  private GitHubEnterpriseConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GitHubEnterpriseConfig() {
    hostUri_ = "";
    apiKey_ = "";
    appSlug_ = "";
    privateKeySecretVersion_ = "";
    webhookSecretSecretVersion_ = "";
    sslCa_ = "";
    serverVersion_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GitHubEnterpriseConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v2.RepositoryManagerProto
        .internal_static_google_devtools_cloudbuild_v2_GitHubEnterpriseConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v2.RepositoryManagerProto
        .internal_static_google_devtools_cloudbuild_v2_GitHubEnterpriseConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v2.GitHubEnterpriseConfig.class,
            com.google.cloudbuild.v2.GitHubEnterpriseConfig.Builder.class);
  }

  public static final int HOST_URI_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object hostUri_ = "";
  /**
   *
   *
   * <pre>
   * Required. The URI of the GitHub Enterprise host this connection is for.
   * </pre>
   *
   * <code>string host_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The hostUri.
   */
  @java.lang.Override
  public java.lang.String getHostUri() {
    java.lang.Object ref = hostUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      hostUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The URI of the GitHub Enterprise host this connection is for.
   * </pre>
   *
   * <code>string host_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for hostUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHostUriBytes() {
    java.lang.Object ref = hostUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      hostUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int API_KEY_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object apiKey_ = "";
  /**
   *
   *
   * <pre>
   * Required. API Key used for authentication of webhook events.
   * </pre>
   *
   * <code>string api_key = 12 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The apiKey.
   */
  @java.lang.Override
  public java.lang.String getApiKey() {
    java.lang.Object ref = apiKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      apiKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. API Key used for authentication of webhook events.
   * </pre>
   *
   * <code>string api_key = 12 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for apiKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getApiKeyBytes() {
    java.lang.Object ref = apiKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      apiKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APP_ID_FIELD_NUMBER = 2;
  private long appId_ = 0L;
  /**
   *
   *
   * <pre>
   * Id of the GitHub App created from the manifest.
   * </pre>
   *
   * <code>int64 app_id = 2;</code>
   *
   * @return The appId.
   */
  @java.lang.Override
  public long getAppId() {
    return appId_;
  }

  public static final int APP_SLUG_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object appSlug_ = "";
  /**
   *
   *
   * <pre>
   * The URL-friendly name of the GitHub App.
   * </pre>
   *
   * <code>string app_slug = 13;</code>
   *
   * @return The appSlug.
   */
  @java.lang.Override
  public java.lang.String getAppSlug() {
    java.lang.Object ref = appSlug_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      appSlug_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL-friendly name of the GitHub App.
   * </pre>
   *
   * <code>string app_slug = 13;</code>
   *
   * @return The bytes for appSlug.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAppSlugBytes() {
    java.lang.Object ref = appSlug_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      appSlug_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRIVATE_KEY_SECRET_VERSION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object privateKeySecretVersion_ = "";
  /**
   *
   *
   * <pre>
   * SecretManager resource containing the private key of the GitHub App,
   * formatted as `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
   * </pre>
   *
   * <code>string private_key_secret_version = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The privateKeySecretVersion.
   */
  @java.lang.Override
  public java.lang.String getPrivateKeySecretVersion() {
    java.lang.Object ref = privateKeySecretVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      privateKeySecretVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * SecretManager resource containing the private key of the GitHub App,
   * formatted as `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
   * </pre>
   *
   * <code>string private_key_secret_version = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for privateKeySecretVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrivateKeySecretVersionBytes() {
    java.lang.Object ref = privateKeySecretVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      privateKeySecretVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WEBHOOK_SECRET_SECRET_VERSION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object webhookSecretSecretVersion_ = "";
  /**
   *
   *
   * <pre>
   * SecretManager resource containing the webhook secret of the GitHub App,
   * formatted as `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
   * </pre>
   *
   * <code>string webhook_secret_secret_version = 5 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The webhookSecretSecretVersion.
   */
  @java.lang.Override
  public java.lang.String getWebhookSecretSecretVersion() {
    java.lang.Object ref = webhookSecretSecretVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      webhookSecretSecretVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * SecretManager resource containing the webhook secret of the GitHub App,
   * formatted as `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
   * </pre>
   *
   * <code>string webhook_secret_secret_version = 5 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for webhookSecretSecretVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWebhookSecretSecretVersionBytes() {
    java.lang.Object ref = webhookSecretSecretVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      webhookSecretSecretVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APP_INSTALLATION_ID_FIELD_NUMBER = 9;
  private long appInstallationId_ = 0L;
  /**
   *
   *
   * <pre>
   * ID of the installation of the GitHub App.
   * </pre>
   *
   * <code>int64 app_installation_id = 9;</code>
   *
   * @return The appInstallationId.
   */
  @java.lang.Override
  public long getAppInstallationId() {
    return appInstallationId_;
  }

  public static final int SERVICE_DIRECTORY_CONFIG_FIELD_NUMBER = 10;
  private com.google.cloudbuild.v2.ServiceDirectoryConfig serviceDirectoryConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for using Service Directory to privately connect to a GitHub
   * Enterprise server. This should only be set if the GitHub Enterprise server
   * is hosted on-premises and not reachable by public internet. If this field
   * is left empty, calls to the GitHub Enterprise server will be made over the
   * public internet.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 10;
   * </code>
   *
   * @return Whether the serviceDirectoryConfig field is set.
   */
  @java.lang.Override
  public boolean hasServiceDirectoryConfig() {
    return serviceDirectoryConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Configuration for using Service Directory to privately connect to a GitHub
   * Enterprise server. This should only be set if the GitHub Enterprise server
   * is hosted on-premises and not reachable by public internet. If this field
   * is left empty, calls to the GitHub Enterprise server will be made over the
   * public internet.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 10;
   * </code>
   *
   * @return The serviceDirectoryConfig.
   */
  @java.lang.Override
  public com.google.cloudbuild.v2.ServiceDirectoryConfig getServiceDirectoryConfig() {
    return serviceDirectoryConfig_ == null
        ? com.google.cloudbuild.v2.ServiceDirectoryConfig.getDefaultInstance()
        : serviceDirectoryConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for using Service Directory to privately connect to a GitHub
   * Enterprise server. This should only be set if the GitHub Enterprise server
   * is hosted on-premises and not reachable by public internet. If this field
   * is left empty, calls to the GitHub Enterprise server will be made over the
   * public internet.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v2.ServiceDirectoryConfigOrBuilder
      getServiceDirectoryConfigOrBuilder() {
    return serviceDirectoryConfig_ == null
        ? com.google.cloudbuild.v2.ServiceDirectoryConfig.getDefaultInstance()
        : serviceDirectoryConfig_;
  }

  public static final int SSL_CA_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sslCa_ = "";
  /**
   *
   *
   * <pre>
   * SSL certificate to use for requests to GitHub Enterprise.
   * </pre>
   *
   * <code>string ssl_ca = 11;</code>
   *
   * @return The sslCa.
   */
  @java.lang.Override
  public java.lang.String getSslCa() {
    java.lang.Object ref = sslCa_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sslCa_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * SSL certificate to use for requests to GitHub Enterprise.
   * </pre>
   *
   * <code>string ssl_ca = 11;</code>
   *
   * @return The bytes for sslCa.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSslCaBytes() {
    java.lang.Object ref = sslCa_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sslCa_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVER_VERSION_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serverVersion_ = "";
  /**
   *
   *
   * <pre>
   * Output only. GitHub Enterprise version installed at the host_uri.
   * </pre>
   *
   * <code>string server_version = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The serverVersion.
   */
  @java.lang.Override
  public java.lang.String getServerVersion() {
    java.lang.Object ref = serverVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serverVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. GitHub Enterprise version installed at the host_uri.
   * </pre>
   *
   * <code>string server_version = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for serverVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServerVersionBytes() {
    java.lang.Object ref = serverVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serverVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, hostUri_);
    }
    if (appId_ != 0L) {
      output.writeInt64(2, appId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(privateKeySecretVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, privateKeySecretVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(webhookSecretSecretVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, webhookSecretSecretVersion_);
    }
    if (appInstallationId_ != 0L) {
      output.writeInt64(9, appInstallationId_);
    }
    if (serviceDirectoryConfig_ != null) {
      output.writeMessage(10, getServiceDirectoryConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sslCa_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, sslCa_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(apiKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, apiKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(appSlug_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, appSlug_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serverVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, serverVersion_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, hostUri_);
    }
    if (appId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, appId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(privateKeySecretVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, privateKeySecretVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(webhookSecretSecretVersion_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(5, webhookSecretSecretVersion_);
    }
    if (appInstallationId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(9, appInstallationId_);
    }
    if (serviceDirectoryConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(10, getServiceDirectoryConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sslCa_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, sslCa_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(apiKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, apiKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(appSlug_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, appSlug_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serverVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, serverVersion_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v2.GitHubEnterpriseConfig)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v2.GitHubEnterpriseConfig other =
        (com.google.cloudbuild.v2.GitHubEnterpriseConfig) obj;

    if (!getHostUri().equals(other.getHostUri())) return false;
    if (!getApiKey().equals(other.getApiKey())) return false;
    if (getAppId() != other.getAppId()) return false;
    if (!getAppSlug().equals(other.getAppSlug())) return false;
    if (!getPrivateKeySecretVersion().equals(other.getPrivateKeySecretVersion())) return false;
    if (!getWebhookSecretSecretVersion().equals(other.getWebhookSecretSecretVersion()))
      return false;
    if (getAppInstallationId() != other.getAppInstallationId()) return false;
    if (hasServiceDirectoryConfig() != other.hasServiceDirectoryConfig()) return false;
    if (hasServiceDirectoryConfig()) {
      if (!getServiceDirectoryConfig().equals(other.getServiceDirectoryConfig())) return false;
    }
    if (!getSslCa().equals(other.getSslCa())) return false;
    if (!getServerVersion().equals(other.getServerVersion())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + HOST_URI_FIELD_NUMBER;
    hash = (53 * hash) + getHostUri().hashCode();
    hash = (37 * hash) + API_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getApiKey().hashCode();
    hash = (37 * hash) + APP_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAppId());
    hash = (37 * hash) + APP_SLUG_FIELD_NUMBER;
    hash = (53 * hash) + getAppSlug().hashCode();
    hash = (37 * hash) + PRIVATE_KEY_SECRET_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getPrivateKeySecretVersion().hashCode();
    hash = (37 * hash) + WEBHOOK_SECRET_SECRET_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getWebhookSecretSecretVersion().hashCode();
    hash = (37 * hash) + APP_INSTALLATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAppInstallationId());
    if (hasServiceDirectoryConfig()) {
      hash = (37 * hash) + SERVICE_DIRECTORY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getServiceDirectoryConfig().hashCode();
    }
    hash = (37 * hash) + SSL_CA_FIELD_NUMBER;
    hash = (53 * hash) + getSslCa().hashCode();
    hash = (37 * hash) + SERVER_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getServerVersion().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v2.GitHubEnterpriseConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v2.GitHubEnterpriseConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v2.GitHubEnterpriseConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v2.GitHubEnterpriseConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v2.GitHubEnterpriseConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v2.GitHubEnterpriseConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v2.GitHubEnterpriseConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v2.GitHubEnterpriseConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v2.GitHubEnterpriseConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v2.GitHubEnterpriseConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v2.GitHubEnterpriseConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v2.GitHubEnterpriseConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v2.GitHubEnterpriseConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for connections to an instance of GitHub Enterprise.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v2.GitHubEnterpriseConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v2.GitHubEnterpriseConfig)
      com.google.cloudbuild.v2.GitHubEnterpriseConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v2.RepositoryManagerProto
          .internal_static_google_devtools_cloudbuild_v2_GitHubEnterpriseConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v2.RepositoryManagerProto
          .internal_static_google_devtools_cloudbuild_v2_GitHubEnterpriseConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v2.GitHubEnterpriseConfig.class,
              com.google.cloudbuild.v2.GitHubEnterpriseConfig.Builder.class);
    }

    // Construct using com.google.cloudbuild.v2.GitHubEnterpriseConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      hostUri_ = "";
      apiKey_ = "";
      appId_ = 0L;
      appSlug_ = "";
      privateKeySecretVersion_ = "";
      webhookSecretSecretVersion_ = "";
      appInstallationId_ = 0L;
      serviceDirectoryConfig_ = null;
      if (serviceDirectoryConfigBuilder_ != null) {
        serviceDirectoryConfigBuilder_.dispose();
        serviceDirectoryConfigBuilder_ = null;
      }
      sslCa_ = "";
      serverVersion_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v2.RepositoryManagerProto
          .internal_static_google_devtools_cloudbuild_v2_GitHubEnterpriseConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v2.GitHubEnterpriseConfig getDefaultInstanceForType() {
      return com.google.cloudbuild.v2.GitHubEnterpriseConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v2.GitHubEnterpriseConfig build() {
      com.google.cloudbuild.v2.GitHubEnterpriseConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v2.GitHubEnterpriseConfig buildPartial() {
      com.google.cloudbuild.v2.GitHubEnterpriseConfig result =
          new com.google.cloudbuild.v2.GitHubEnterpriseConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloudbuild.v2.GitHubEnterpriseConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.hostUri_ = hostUri_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.apiKey_ = apiKey_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.appId_ = appId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.appSlug_ = appSlug_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.privateKeySecretVersion_ = privateKeySecretVersion_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.webhookSecretSecretVersion_ = webhookSecretSecretVersion_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.appInstallationId_ = appInstallationId_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.serviceDirectoryConfig_ =
            serviceDirectoryConfigBuilder_ == null
                ? serviceDirectoryConfig_
                : serviceDirectoryConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.sslCa_ = sslCa_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.serverVersion_ = serverVersion_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v2.GitHubEnterpriseConfig) {
        return mergeFrom((com.google.cloudbuild.v2.GitHubEnterpriseConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v2.GitHubEnterpriseConfig other) {
      if (other == com.google.cloudbuild.v2.GitHubEnterpriseConfig.getDefaultInstance())
        return this;
      if (!other.getHostUri().isEmpty()) {
        hostUri_ = other.hostUri_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getApiKey().isEmpty()) {
        apiKey_ = other.apiKey_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getAppId() != 0L) {
        setAppId(other.getAppId());
      }
      if (!other.getAppSlug().isEmpty()) {
        appSlug_ = other.appSlug_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getPrivateKeySecretVersion().isEmpty()) {
        privateKeySecretVersion_ = other.privateKeySecretVersion_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getWebhookSecretSecretVersion().isEmpty()) {
        webhookSecretSecretVersion_ = other.webhookSecretSecretVersion_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.getAppInstallationId() != 0L) {
        setAppInstallationId(other.getAppInstallationId());
      }
      if (other.hasServiceDirectoryConfig()) {
        mergeServiceDirectoryConfig(other.getServiceDirectoryConfig());
      }
      if (!other.getSslCa().isEmpty()) {
        sslCa_ = other.sslCa_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getServerVersion().isEmpty()) {
        serverVersion_ = other.serverVersion_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                hostUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                appId_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 16
            case 34:
              {
                privateKeySecretVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                webhookSecretSecretVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 72:
              {
                appInstallationId_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 72
            case 82:
              {
                input.readMessage(
                    getServiceDirectoryConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 82
            case 90:
              {
                sslCa_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 90
            case 98:
              {
                apiKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 98
            case 106:
              {
                appSlug_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 106
            case 114:
              {
                serverVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object hostUri_ = "";
    /**
     *
     *
     * <pre>
     * Required. The URI of the GitHub Enterprise host this connection is for.
     * </pre>
     *
     * <code>string host_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The hostUri.
     */
    public java.lang.String getHostUri() {
      java.lang.Object ref = hostUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        hostUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The URI of the GitHub Enterprise host this connection is for.
     * </pre>
     *
     * <code>string host_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for hostUri.
     */
    public com.google.protobuf.ByteString getHostUriBytes() {
      java.lang.Object ref = hostUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        hostUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The URI of the GitHub Enterprise host this connection is for.
     * </pre>
     *
     * <code>string host_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The hostUri to set.
     * @return This builder for chaining.
     */
    public Builder setHostUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      hostUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The URI of the GitHub Enterprise host this connection is for.
     * </pre>
     *
     * <code>string host_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHostUri() {
      hostUri_ = getDefaultInstance().getHostUri();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The URI of the GitHub Enterprise host this connection is for.
     * </pre>
     *
     * <code>string host_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for hostUri to set.
     * @return This builder for chaining.
     */
    public Builder setHostUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      hostUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object apiKey_ = "";
    /**
     *
     *
     * <pre>
     * Required. API Key used for authentication of webhook events.
     * </pre>
     *
     * <code>string api_key = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The apiKey.
     */
    public java.lang.String getApiKey() {
      java.lang.Object ref = apiKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        apiKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. API Key used for authentication of webhook events.
     * </pre>
     *
     * <code>string api_key = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for apiKey.
     */
    public com.google.protobuf.ByteString getApiKeyBytes() {
      java.lang.Object ref = apiKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        apiKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. API Key used for authentication of webhook events.
     * </pre>
     *
     * <code>string api_key = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The apiKey to set.
     * @return This builder for chaining.
     */
    public Builder setApiKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      apiKey_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. API Key used for authentication of webhook events.
     * </pre>
     *
     * <code>string api_key = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearApiKey() {
      apiKey_ = getDefaultInstance().getApiKey();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. API Key used for authentication of webhook events.
     * </pre>
     *
     * <code>string api_key = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for apiKey to set.
     * @return This builder for chaining.
     */
    public Builder setApiKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      apiKey_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private long appId_;
    /**
     *
     *
     * <pre>
     * Id of the GitHub App created from the manifest.
     * </pre>
     *
     * <code>int64 app_id = 2;</code>
     *
     * @return The appId.
     */
    @java.lang.Override
    public long getAppId() {
      return appId_;
    }
    /**
     *
     *
     * <pre>
     * Id of the GitHub App created from the manifest.
     * </pre>
     *
     * <code>int64 app_id = 2;</code>
     *
     * @param value The appId to set.
     * @return This builder for chaining.
     */
    public Builder setAppId(long value) {

      appId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Id of the GitHub App created from the manifest.
     * </pre>
     *
     * <code>int64 app_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAppId() {
      bitField0_ = (bitField0_ & ~0x00000004);
      appId_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object appSlug_ = "";
    /**
     *
     *
     * <pre>
     * The URL-friendly name of the GitHub App.
     * </pre>
     *
     * <code>string app_slug = 13;</code>
     *
     * @return The appSlug.
     */
    public java.lang.String getAppSlug() {
      java.lang.Object ref = appSlug_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        appSlug_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL-friendly name of the GitHub App.
     * </pre>
     *
     * <code>string app_slug = 13;</code>
     *
     * @return The bytes for appSlug.
     */
    public com.google.protobuf.ByteString getAppSlugBytes() {
      java.lang.Object ref = appSlug_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        appSlug_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL-friendly name of the GitHub App.
     * </pre>
     *
     * <code>string app_slug = 13;</code>
     *
     * @param value The appSlug to set.
     * @return This builder for chaining.
     */
    public Builder setAppSlug(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      appSlug_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL-friendly name of the GitHub App.
     * </pre>
     *
     * <code>string app_slug = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAppSlug() {
      appSlug_ = getDefaultInstance().getAppSlug();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL-friendly name of the GitHub App.
     * </pre>
     *
     * <code>string app_slug = 13;</code>
     *
     * @param value The bytes for appSlug to set.
     * @return This builder for chaining.
     */
    public Builder setAppSlugBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      appSlug_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object privateKeySecretVersion_ = "";
    /**
     *
     *
     * <pre>
     * SecretManager resource containing the private key of the GitHub App,
     * formatted as `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * </pre>
     *
     * <code>string private_key_secret_version = 4 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The privateKeySecretVersion.
     */
    public java.lang.String getPrivateKeySecretVersion() {
      java.lang.Object ref = privateKeySecretVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        privateKeySecretVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * SecretManager resource containing the private key of the GitHub App,
     * formatted as `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * </pre>
     *
     * <code>string private_key_secret_version = 4 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for privateKeySecretVersion.
     */
    public com.google.protobuf.ByteString getPrivateKeySecretVersionBytes() {
      java.lang.Object ref = privateKeySecretVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        privateKeySecretVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * SecretManager resource containing the private key of the GitHub App,
     * formatted as `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * </pre>
     *
     * <code>string private_key_secret_version = 4 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The privateKeySecretVersion to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateKeySecretVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      privateKeySecretVersion_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * SecretManager resource containing the private key of the GitHub App,
     * formatted as `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * </pre>
     *
     * <code>string private_key_secret_version = 4 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrivateKeySecretVersion() {
      privateKeySecretVersion_ = getDefaultInstance().getPrivateKeySecretVersion();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * SecretManager resource containing the private key of the GitHub App,
     * formatted as `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * </pre>
     *
     * <code>string private_key_secret_version = 4 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for privateKeySecretVersion to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateKeySecretVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      privateKeySecretVersion_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object webhookSecretSecretVersion_ = "";
    /**
     *
     *
     * <pre>
     * SecretManager resource containing the webhook secret of the GitHub App,
     * formatted as `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * </pre>
     *
     * <code>string webhook_secret_secret_version = 5 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The webhookSecretSecretVersion.
     */
    public java.lang.String getWebhookSecretSecretVersion() {
      java.lang.Object ref = webhookSecretSecretVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        webhookSecretSecretVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * SecretManager resource containing the webhook secret of the GitHub App,
     * formatted as `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * </pre>
     *
     * <code>string webhook_secret_secret_version = 5 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for webhookSecretSecretVersion.
     */
    public com.google.protobuf.ByteString getWebhookSecretSecretVersionBytes() {
      java.lang.Object ref = webhookSecretSecretVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        webhookSecretSecretVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * SecretManager resource containing the webhook secret of the GitHub App,
     * formatted as `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * </pre>
     *
     * <code>string webhook_secret_secret_version = 5 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The webhookSecretSecretVersion to set.
     * @return This builder for chaining.
     */
    public Builder setWebhookSecretSecretVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      webhookSecretSecretVersion_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * SecretManager resource containing the webhook secret of the GitHub App,
     * formatted as `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * </pre>
     *
     * <code>string webhook_secret_secret_version = 5 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWebhookSecretSecretVersion() {
      webhookSecretSecretVersion_ = getDefaultInstance().getWebhookSecretSecretVersion();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * SecretManager resource containing the webhook secret of the GitHub App,
     * formatted as `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * </pre>
     *
     * <code>string webhook_secret_secret_version = 5 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for webhookSecretSecretVersion to set.
     * @return This builder for chaining.
     */
    public Builder setWebhookSecretSecretVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      webhookSecretSecretVersion_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private long appInstallationId_;
    /**
     *
     *
     * <pre>
     * ID of the installation of the GitHub App.
     * </pre>
     *
     * <code>int64 app_installation_id = 9;</code>
     *
     * @return The appInstallationId.
     */
    @java.lang.Override
    public long getAppInstallationId() {
      return appInstallationId_;
    }
    /**
     *
     *
     * <pre>
     * ID of the installation of the GitHub App.
     * </pre>
     *
     * <code>int64 app_installation_id = 9;</code>
     *
     * @param value The appInstallationId to set.
     * @return This builder for chaining.
     */
    public Builder setAppInstallationId(long value) {

      appInstallationId_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ID of the installation of the GitHub App.
     * </pre>
     *
     * <code>int64 app_installation_id = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAppInstallationId() {
      bitField0_ = (bitField0_ & ~0x00000040);
      appInstallationId_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloudbuild.v2.ServiceDirectoryConfig serviceDirectoryConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v2.ServiceDirectoryConfig,
            com.google.cloudbuild.v2.ServiceDirectoryConfig.Builder,
            com.google.cloudbuild.v2.ServiceDirectoryConfigOrBuilder>
        serviceDirectoryConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for using Service Directory to privately connect to a GitHub
     * Enterprise server. This should only be set if the GitHub Enterprise server
     * is hosted on-premises and not reachable by public internet. If this field
     * is left empty, calls to the GitHub Enterprise server will be made over the
     * public internet.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 10;
     * </code>
     *
     * @return Whether the serviceDirectoryConfig field is set.
     */
    public boolean hasServiceDirectoryConfig() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for using Service Directory to privately connect to a GitHub
     * Enterprise server. This should only be set if the GitHub Enterprise server
     * is hosted on-premises and not reachable by public internet. If this field
     * is left empty, calls to the GitHub Enterprise server will be made over the
     * public internet.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 10;
     * </code>
     *
     * @return The serviceDirectoryConfig.
     */
    public com.google.cloudbuild.v2.ServiceDirectoryConfig getServiceDirectoryConfig() {
      if (serviceDirectoryConfigBuilder_ == null) {
        return serviceDirectoryConfig_ == null
            ? com.google.cloudbuild.v2.ServiceDirectoryConfig.getDefaultInstance()
            : serviceDirectoryConfig_;
      } else {
        return serviceDirectoryConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for using Service Directory to privately connect to a GitHub
     * Enterprise server. This should only be set if the GitHub Enterprise server
     * is hosted on-premises and not reachable by public internet. If this field
     * is left empty, calls to the GitHub Enterprise server will be made over the
     * public internet.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 10;
     * </code>
     */
    public Builder setServiceDirectoryConfig(
        com.google.cloudbuild.v2.ServiceDirectoryConfig value) {
      if (serviceDirectoryConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceDirectoryConfig_ = value;
      } else {
        serviceDirectoryConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for using Service Directory to privately connect to a GitHub
     * Enterprise server. This should only be set if the GitHub Enterprise server
     * is hosted on-premises and not reachable by public internet. If this field
     * is left empty, calls to the GitHub Enterprise server will be made over the
     * public internet.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 10;
     * </code>
     */
    public Builder setServiceDirectoryConfig(
        com.google.cloudbuild.v2.ServiceDirectoryConfig.Builder builderForValue) {
      if (serviceDirectoryConfigBuilder_ == null) {
        serviceDirectoryConfig_ = builderForValue.build();
      } else {
        serviceDirectoryConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for using Service Directory to privately connect to a GitHub
     * Enterprise server. This should only be set if the GitHub Enterprise server
     * is hosted on-premises and not reachable by public internet. If this field
     * is left empty, calls to the GitHub Enterprise server will be made over the
     * public internet.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 10;
     * </code>
     */
    public Builder mergeServiceDirectoryConfig(
        com.google.cloudbuild.v2.ServiceDirectoryConfig value) {
      if (serviceDirectoryConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && serviceDirectoryConfig_ != null
            && serviceDirectoryConfig_
                != com.google.cloudbuild.v2.ServiceDirectoryConfig.getDefaultInstance()) {
          getServiceDirectoryConfigBuilder().mergeFrom(value);
        } else {
          serviceDirectoryConfig_ = value;
        }
      } else {
        serviceDirectoryConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for using Service Directory to privately connect to a GitHub
     * Enterprise server. This should only be set if the GitHub Enterprise server
     * is hosted on-premises and not reachable by public internet. If this field
     * is left empty, calls to the GitHub Enterprise server will be made over the
     * public internet.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 10;
     * </code>
     */
    public Builder clearServiceDirectoryConfig() {
      bitField0_ = (bitField0_ & ~0x00000080);
      serviceDirectoryConfig_ = null;
      if (serviceDirectoryConfigBuilder_ != null) {
        serviceDirectoryConfigBuilder_.dispose();
        serviceDirectoryConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for using Service Directory to privately connect to a GitHub
     * Enterprise server. This should only be set if the GitHub Enterprise server
     * is hosted on-premises and not reachable by public internet. If this field
     * is left empty, calls to the GitHub Enterprise server will be made over the
     * public internet.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 10;
     * </code>
     */
    public com.google.cloudbuild.v2.ServiceDirectoryConfig.Builder
        getServiceDirectoryConfigBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getServiceDirectoryConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for using Service Directory to privately connect to a GitHub
     * Enterprise server. This should only be set if the GitHub Enterprise server
     * is hosted on-premises and not reachable by public internet. If this field
     * is left empty, calls to the GitHub Enterprise server will be made over the
     * public internet.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 10;
     * </code>
     */
    public com.google.cloudbuild.v2.ServiceDirectoryConfigOrBuilder
        getServiceDirectoryConfigOrBuilder() {
      if (serviceDirectoryConfigBuilder_ != null) {
        return serviceDirectoryConfigBuilder_.getMessageOrBuilder();
      } else {
        return serviceDirectoryConfig_ == null
            ? com.google.cloudbuild.v2.ServiceDirectoryConfig.getDefaultInstance()
            : serviceDirectoryConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for using Service Directory to privately connect to a GitHub
     * Enterprise server. This should only be set if the GitHub Enterprise server
     * is hosted on-premises and not reachable by public internet. If this field
     * is left empty, calls to the GitHub Enterprise server will be made over the
     * public internet.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 10;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v2.ServiceDirectoryConfig,
            com.google.cloudbuild.v2.ServiceDirectoryConfig.Builder,
            com.google.cloudbuild.v2.ServiceDirectoryConfigOrBuilder>
        getServiceDirectoryConfigFieldBuilder() {
      if (serviceDirectoryConfigBuilder_ == null) {
        serviceDirectoryConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v2.ServiceDirectoryConfig,
                com.google.cloudbuild.v2.ServiceDirectoryConfig.Builder,
                com.google.cloudbuild.v2.ServiceDirectoryConfigOrBuilder>(
                getServiceDirectoryConfig(), getParentForChildren(), isClean());
        serviceDirectoryConfig_ = null;
      }
      return serviceDirectoryConfigBuilder_;
    }

    private java.lang.Object sslCa_ = "";
    /**
     *
     *
     * <pre>
     * SSL certificate to use for requests to GitHub Enterprise.
     * </pre>
     *
     * <code>string ssl_ca = 11;</code>
     *
     * @return The sslCa.
     */
    public java.lang.String getSslCa() {
      java.lang.Object ref = sslCa_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sslCa_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * SSL certificate to use for requests to GitHub Enterprise.
     * </pre>
     *
     * <code>string ssl_ca = 11;</code>
     *
     * @return The bytes for sslCa.
     */
    public com.google.protobuf.ByteString getSslCaBytes() {
      java.lang.Object ref = sslCa_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sslCa_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * SSL certificate to use for requests to GitHub Enterprise.
     * </pre>
     *
     * <code>string ssl_ca = 11;</code>
     *
     * @param value The sslCa to set.
     * @return This builder for chaining.
     */
    public Builder setSslCa(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sslCa_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * SSL certificate to use for requests to GitHub Enterprise.
     * </pre>
     *
     * <code>string ssl_ca = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSslCa() {
      sslCa_ = getDefaultInstance().getSslCa();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * SSL certificate to use for requests to GitHub Enterprise.
     * </pre>
     *
     * <code>string ssl_ca = 11;</code>
     *
     * @param value The bytes for sslCa to set.
     * @return This builder for chaining.
     */
    public Builder setSslCaBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sslCa_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object serverVersion_ = "";
    /**
     *
     *
     * <pre>
     * Output only. GitHub Enterprise version installed at the host_uri.
     * </pre>
     *
     * <code>string server_version = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The serverVersion.
     */
    public java.lang.String getServerVersion() {
      java.lang.Object ref = serverVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serverVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. GitHub Enterprise version installed at the host_uri.
     * </pre>
     *
     * <code>string server_version = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for serverVersion.
     */
    public com.google.protobuf.ByteString getServerVersionBytes() {
      java.lang.Object ref = serverVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serverVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. GitHub Enterprise version installed at the host_uri.
     * </pre>
     *
     * <code>string server_version = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The serverVersion to set.
     * @return This builder for chaining.
     */
    public Builder setServerVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serverVersion_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. GitHub Enterprise version installed at the host_uri.
     * </pre>
     *
     * <code>string server_version = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServerVersion() {
      serverVersion_ = getDefaultInstance().getServerVersion();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. GitHub Enterprise version installed at the host_uri.
     * </pre>
     *
     * <code>string server_version = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for serverVersion to set.
     * @return This builder for chaining.
     */
    public Builder setServerVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serverVersion_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v2.GitHubEnterpriseConfig)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v2.GitHubEnterpriseConfig)
  private static final com.google.cloudbuild.v2.GitHubEnterpriseConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v2.GitHubEnterpriseConfig();
  }

  public static com.google.cloudbuild.v2.GitHubEnterpriseConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GitHubEnterpriseConfig> PARSER =
      new com.google.protobuf.AbstractParser<GitHubEnterpriseConfig>() {
        @java.lang.Override
        public GitHubEnterpriseConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GitHubEnterpriseConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GitHubEnterpriseConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v2.GitHubEnterpriseConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
