/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v2/repositories.proto

package com.google.cloudbuild.v2;

/**
 *
 *
 * <pre>
 * Configuration for connections to gitlab.com or an instance of GitLab
 * Enterprise.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v2.GitLabConfig}
 */
public final class GitLabConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v2.GitLabConfig)
    GitLabConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GitLabConfig.newBuilder() to construct.
  private GitLabConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GitLabConfig() {
    hostUri_ = "";
    webhookSecretSecretVersion_ = "";
    sslCa_ = "";
    serverVersion_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GitLabConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v2.RepositoryManagerProto
        .internal_static_google_devtools_cloudbuild_v2_GitLabConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v2.RepositoryManagerProto
        .internal_static_google_devtools_cloudbuild_v2_GitLabConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v2.GitLabConfig.class,
            com.google.cloudbuild.v2.GitLabConfig.Builder.class);
  }

  public static final int HOST_URI_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object hostUri_ = "";
  /**
   *
   *
   * <pre>
   * The URI of the GitLab Enterprise host this connection is for.
   * If not specified, the default value is https://gitlab.com.
   * </pre>
   *
   * <code>string host_uri = 1;</code>
   *
   * @return The hostUri.
   */
  @java.lang.Override
  public java.lang.String getHostUri() {
    java.lang.Object ref = hostUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      hostUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URI of the GitLab Enterprise host this connection is for.
   * If not specified, the default value is https://gitlab.com.
   * </pre>
   *
   * <code>string host_uri = 1;</code>
   *
   * @return The bytes for hostUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHostUriBytes() {
    java.lang.Object ref = hostUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      hostUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WEBHOOK_SECRET_SECRET_VERSION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object webhookSecretSecretVersion_ = "";
  /**
   *
   *
   * <pre>
   * Required. Immutable. SecretManager resource containing the webhook secret
   * of a GitLab Enterprise project, formatted as
   * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
   * </pre>
   *
   * <code>
   * string webhook_secret_secret_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The webhookSecretSecretVersion.
   */
  @java.lang.Override
  public java.lang.String getWebhookSecretSecretVersion() {
    java.lang.Object ref = webhookSecretSecretVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      webhookSecretSecretVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. SecretManager resource containing the webhook secret
   * of a GitLab Enterprise project, formatted as
   * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
   * </pre>
   *
   * <code>
   * string webhook_secret_secret_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for webhookSecretSecretVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWebhookSecretSecretVersionBytes() {
    java.lang.Object ref = webhookSecretSecretVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      webhookSecretSecretVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int READ_AUTHORIZER_CREDENTIAL_FIELD_NUMBER = 3;
  private com.google.cloudbuild.v2.UserCredential readAuthorizerCredential_;
  /**
   *
   *
   * <pre>
   * Required. A GitLab personal access token with the minimum `read_api` scope
   * access.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v2.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the readAuthorizerCredential field is set.
   */
  @java.lang.Override
  public boolean hasReadAuthorizerCredential() {
    return readAuthorizerCredential_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. A GitLab personal access token with the minimum `read_api` scope
   * access.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v2.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The readAuthorizerCredential.
   */
  @java.lang.Override
  public com.google.cloudbuild.v2.UserCredential getReadAuthorizerCredential() {
    return readAuthorizerCredential_ == null
        ? com.google.cloudbuild.v2.UserCredential.getDefaultInstance()
        : readAuthorizerCredential_;
  }
  /**
   *
   *
   * <pre>
   * Required. A GitLab personal access token with the minimum `read_api` scope
   * access.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v2.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v2.UserCredentialOrBuilder getReadAuthorizerCredentialOrBuilder() {
    return readAuthorizerCredential_ == null
        ? com.google.cloudbuild.v2.UserCredential.getDefaultInstance()
        : readAuthorizerCredential_;
  }

  public static final int AUTHORIZER_CREDENTIAL_FIELD_NUMBER = 4;
  private com.google.cloudbuild.v2.UserCredential authorizerCredential_;
  /**
   *
   *
   * <pre>
   * Required. A GitLab personal access token with the `api` scope access.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v2.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the authorizerCredential field is set.
   */
  @java.lang.Override
  public boolean hasAuthorizerCredential() {
    return authorizerCredential_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. A GitLab personal access token with the `api` scope access.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v2.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The authorizerCredential.
   */
  @java.lang.Override
  public com.google.cloudbuild.v2.UserCredential getAuthorizerCredential() {
    return authorizerCredential_ == null
        ? com.google.cloudbuild.v2.UserCredential.getDefaultInstance()
        : authorizerCredential_;
  }
  /**
   *
   *
   * <pre>
   * Required. A GitLab personal access token with the `api` scope access.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v2.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v2.UserCredentialOrBuilder getAuthorizerCredentialOrBuilder() {
    return authorizerCredential_ == null
        ? com.google.cloudbuild.v2.UserCredential.getDefaultInstance()
        : authorizerCredential_;
  }

  public static final int SERVICE_DIRECTORY_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloudbuild.v2.ServiceDirectoryConfig serviceDirectoryConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for using Service Directory to privately connect to a GitLab
   * Enterprise server. This should only be set if the GitLab Enterprise server
   * is hosted on-premises and not reachable by public internet. If this field
   * is left empty, calls to the GitLab Enterprise server will be made over the
   * public internet.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 5;
   * </code>
   *
   * @return Whether the serviceDirectoryConfig field is set.
   */
  @java.lang.Override
  public boolean hasServiceDirectoryConfig() {
    return serviceDirectoryConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Configuration for using Service Directory to privately connect to a GitLab
   * Enterprise server. This should only be set if the GitLab Enterprise server
   * is hosted on-premises and not reachable by public internet. If this field
   * is left empty, calls to the GitLab Enterprise server will be made over the
   * public internet.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 5;
   * </code>
   *
   * @return The serviceDirectoryConfig.
   */
  @java.lang.Override
  public com.google.cloudbuild.v2.ServiceDirectoryConfig getServiceDirectoryConfig() {
    return serviceDirectoryConfig_ == null
        ? com.google.cloudbuild.v2.ServiceDirectoryConfig.getDefaultInstance()
        : serviceDirectoryConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for using Service Directory to privately connect to a GitLab
   * Enterprise server. This should only be set if the GitLab Enterprise server
   * is hosted on-premises and not reachable by public internet. If this field
   * is left empty, calls to the GitLab Enterprise server will be made over the
   * public internet.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v2.ServiceDirectoryConfigOrBuilder
      getServiceDirectoryConfigOrBuilder() {
    return serviceDirectoryConfig_ == null
        ? com.google.cloudbuild.v2.ServiceDirectoryConfig.getDefaultInstance()
        : serviceDirectoryConfig_;
  }

  public static final int SSL_CA_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sslCa_ = "";
  /**
   *
   *
   * <pre>
   * SSL certificate to use for requests to GitLab Enterprise.
   * </pre>
   *
   * <code>string ssl_ca = 6;</code>
   *
   * @return The sslCa.
   */
  @java.lang.Override
  public java.lang.String getSslCa() {
    java.lang.Object ref = sslCa_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sslCa_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * SSL certificate to use for requests to GitLab Enterprise.
   * </pre>
   *
   * <code>string ssl_ca = 6;</code>
   *
   * @return The bytes for sslCa.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSslCaBytes() {
    java.lang.Object ref = sslCa_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sslCa_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVER_VERSION_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serverVersion_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Version of the GitLab Enterprise server running on the
   * `host_uri`.
   * </pre>
   *
   * <code>string server_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The serverVersion.
   */
  @java.lang.Override
  public java.lang.String getServerVersion() {
    java.lang.Object ref = serverVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serverVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Version of the GitLab Enterprise server running on the
   * `host_uri`.
   * </pre>
   *
   * <code>string server_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for serverVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServerVersionBytes() {
    java.lang.Object ref = serverVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serverVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, hostUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(webhookSecretSecretVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, webhookSecretSecretVersion_);
    }
    if (readAuthorizerCredential_ != null) {
      output.writeMessage(3, getReadAuthorizerCredential());
    }
    if (authorizerCredential_ != null) {
      output.writeMessage(4, getAuthorizerCredential());
    }
    if (serviceDirectoryConfig_ != null) {
      output.writeMessage(5, getServiceDirectoryConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sslCa_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, sslCa_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serverVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, serverVersion_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, hostUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(webhookSecretSecretVersion_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(2, webhookSecretSecretVersion_);
    }
    if (readAuthorizerCredential_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, getReadAuthorizerCredential());
    }
    if (authorizerCredential_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, getAuthorizerCredential());
    }
    if (serviceDirectoryConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, getServiceDirectoryConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sslCa_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, sslCa_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serverVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, serverVersion_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v2.GitLabConfig)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v2.GitLabConfig other = (com.google.cloudbuild.v2.GitLabConfig) obj;

    if (!getHostUri().equals(other.getHostUri())) return false;
    if (!getWebhookSecretSecretVersion().equals(other.getWebhookSecretSecretVersion()))
      return false;
    if (hasReadAuthorizerCredential() != other.hasReadAuthorizerCredential()) return false;
    if (hasReadAuthorizerCredential()) {
      if (!getReadAuthorizerCredential().equals(other.getReadAuthorizerCredential())) return false;
    }
    if (hasAuthorizerCredential() != other.hasAuthorizerCredential()) return false;
    if (hasAuthorizerCredential()) {
      if (!getAuthorizerCredential().equals(other.getAuthorizerCredential())) return false;
    }
    if (hasServiceDirectoryConfig() != other.hasServiceDirectoryConfig()) return false;
    if (hasServiceDirectoryConfig()) {
      if (!getServiceDirectoryConfig().equals(other.getServiceDirectoryConfig())) return false;
    }
    if (!getSslCa().equals(other.getSslCa())) return false;
    if (!getServerVersion().equals(other.getServerVersion())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + HOST_URI_FIELD_NUMBER;
    hash = (53 * hash) + getHostUri().hashCode();
    hash = (37 * hash) + WEBHOOK_SECRET_SECRET_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getWebhookSecretSecretVersion().hashCode();
    if (hasReadAuthorizerCredential()) {
      hash = (37 * hash) + READ_AUTHORIZER_CREDENTIAL_FIELD_NUMBER;
      hash = (53 * hash) + getReadAuthorizerCredential().hashCode();
    }
    if (hasAuthorizerCredential()) {
      hash = (37 * hash) + AUTHORIZER_CREDENTIAL_FIELD_NUMBER;
      hash = (53 * hash) + getAuthorizerCredential().hashCode();
    }
    if (hasServiceDirectoryConfig()) {
      hash = (37 * hash) + SERVICE_DIRECTORY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getServiceDirectoryConfig().hashCode();
    }
    hash = (37 * hash) + SSL_CA_FIELD_NUMBER;
    hash = (53 * hash) + getSslCa().hashCode();
    hash = (37 * hash) + SERVER_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getServerVersion().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v2.GitLabConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v2.GitLabConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v2.GitLabConfig parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v2.GitLabConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v2.GitLabConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v2.GitLabConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v2.GitLabConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v2.GitLabConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v2.GitLabConfig parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v2.GitLabConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v2.GitLabConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v2.GitLabConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v2.GitLabConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for connections to gitlab.com or an instance of GitLab
   * Enterprise.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v2.GitLabConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v2.GitLabConfig)
      com.google.cloudbuild.v2.GitLabConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v2.RepositoryManagerProto
          .internal_static_google_devtools_cloudbuild_v2_GitLabConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v2.RepositoryManagerProto
          .internal_static_google_devtools_cloudbuild_v2_GitLabConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v2.GitLabConfig.class,
              com.google.cloudbuild.v2.GitLabConfig.Builder.class);
    }

    // Construct using com.google.cloudbuild.v2.GitLabConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      hostUri_ = "";
      webhookSecretSecretVersion_ = "";
      readAuthorizerCredential_ = null;
      if (readAuthorizerCredentialBuilder_ != null) {
        readAuthorizerCredentialBuilder_.dispose();
        readAuthorizerCredentialBuilder_ = null;
      }
      authorizerCredential_ = null;
      if (authorizerCredentialBuilder_ != null) {
        authorizerCredentialBuilder_.dispose();
        authorizerCredentialBuilder_ = null;
      }
      serviceDirectoryConfig_ = null;
      if (serviceDirectoryConfigBuilder_ != null) {
        serviceDirectoryConfigBuilder_.dispose();
        serviceDirectoryConfigBuilder_ = null;
      }
      sslCa_ = "";
      serverVersion_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v2.RepositoryManagerProto
          .internal_static_google_devtools_cloudbuild_v2_GitLabConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v2.GitLabConfig getDefaultInstanceForType() {
      return com.google.cloudbuild.v2.GitLabConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v2.GitLabConfig build() {
      com.google.cloudbuild.v2.GitLabConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v2.GitLabConfig buildPartial() {
      com.google.cloudbuild.v2.GitLabConfig result =
          new com.google.cloudbuild.v2.GitLabConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloudbuild.v2.GitLabConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.hostUri_ = hostUri_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.webhookSecretSecretVersion_ = webhookSecretSecretVersion_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.readAuthorizerCredential_ =
            readAuthorizerCredentialBuilder_ == null
                ? readAuthorizerCredential_
                : readAuthorizerCredentialBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.authorizerCredential_ =
            authorizerCredentialBuilder_ == null
                ? authorizerCredential_
                : authorizerCredentialBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.serviceDirectoryConfig_ =
            serviceDirectoryConfigBuilder_ == null
                ? serviceDirectoryConfig_
                : serviceDirectoryConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.sslCa_ = sslCa_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.serverVersion_ = serverVersion_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v2.GitLabConfig) {
        return mergeFrom((com.google.cloudbuild.v2.GitLabConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v2.GitLabConfig other) {
      if (other == com.google.cloudbuild.v2.GitLabConfig.getDefaultInstance()) return this;
      if (!other.getHostUri().isEmpty()) {
        hostUri_ = other.hostUri_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getWebhookSecretSecretVersion().isEmpty()) {
        webhookSecretSecretVersion_ = other.webhookSecretSecretVersion_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasReadAuthorizerCredential()) {
        mergeReadAuthorizerCredential(other.getReadAuthorizerCredential());
      }
      if (other.hasAuthorizerCredential()) {
        mergeAuthorizerCredential(other.getAuthorizerCredential());
      }
      if (other.hasServiceDirectoryConfig()) {
        mergeServiceDirectoryConfig(other.getServiceDirectoryConfig());
      }
      if (!other.getSslCa().isEmpty()) {
        sslCa_ = other.sslCa_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getServerVersion().isEmpty()) {
        serverVersion_ = other.serverVersion_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                hostUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                webhookSecretSecretVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getReadAuthorizerCredentialFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getAuthorizerCredentialFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getServiceDirectoryConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                sslCa_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                serverVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object hostUri_ = "";
    /**
     *
     *
     * <pre>
     * The URI of the GitLab Enterprise host this connection is for.
     * If not specified, the default value is https://gitlab.com.
     * </pre>
     *
     * <code>string host_uri = 1;</code>
     *
     * @return The hostUri.
     */
    public java.lang.String getHostUri() {
      java.lang.Object ref = hostUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        hostUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of the GitLab Enterprise host this connection is for.
     * If not specified, the default value is https://gitlab.com.
     * </pre>
     *
     * <code>string host_uri = 1;</code>
     *
     * @return The bytes for hostUri.
     */
    public com.google.protobuf.ByteString getHostUriBytes() {
      java.lang.Object ref = hostUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        hostUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of the GitLab Enterprise host this connection is for.
     * If not specified, the default value is https://gitlab.com.
     * </pre>
     *
     * <code>string host_uri = 1;</code>
     *
     * @param value The hostUri to set.
     * @return This builder for chaining.
     */
    public Builder setHostUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      hostUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI of the GitLab Enterprise host this connection is for.
     * If not specified, the default value is https://gitlab.com.
     * </pre>
     *
     * <code>string host_uri = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHostUri() {
      hostUri_ = getDefaultInstance().getHostUri();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI of the GitLab Enterprise host this connection is for.
     * If not specified, the default value is https://gitlab.com.
     * </pre>
     *
     * <code>string host_uri = 1;</code>
     *
     * @param value The bytes for hostUri to set.
     * @return This builder for chaining.
     */
    public Builder setHostUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      hostUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object webhookSecretSecretVersion_ = "";
    /**
     *
     *
     * <pre>
     * Required. Immutable. SecretManager resource containing the webhook secret
     * of a GitLab Enterprise project, formatted as
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * </pre>
     *
     * <code>
     * string webhook_secret_secret_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The webhookSecretSecretVersion.
     */
    public java.lang.String getWebhookSecretSecretVersion() {
      java.lang.Object ref = webhookSecretSecretVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        webhookSecretSecretVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. SecretManager resource containing the webhook secret
     * of a GitLab Enterprise project, formatted as
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * </pre>
     *
     * <code>
     * string webhook_secret_secret_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for webhookSecretSecretVersion.
     */
    public com.google.protobuf.ByteString getWebhookSecretSecretVersionBytes() {
      java.lang.Object ref = webhookSecretSecretVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        webhookSecretSecretVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. SecretManager resource containing the webhook secret
     * of a GitLab Enterprise project, formatted as
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * </pre>
     *
     * <code>
     * string webhook_secret_secret_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The webhookSecretSecretVersion to set.
     * @return This builder for chaining.
     */
    public Builder setWebhookSecretSecretVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      webhookSecretSecretVersion_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. SecretManager resource containing the webhook secret
     * of a GitLab Enterprise project, formatted as
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * </pre>
     *
     * <code>
     * string webhook_secret_secret_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWebhookSecretSecretVersion() {
      webhookSecretSecretVersion_ = getDefaultInstance().getWebhookSecretSecretVersion();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. SecretManager resource containing the webhook secret
     * of a GitLab Enterprise project, formatted as
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * </pre>
     *
     * <code>
     * string webhook_secret_secret_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for webhookSecretSecretVersion to set.
     * @return This builder for chaining.
     */
    public Builder setWebhookSecretSecretVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      webhookSecretSecretVersion_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloudbuild.v2.UserCredential readAuthorizerCredential_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v2.UserCredential,
            com.google.cloudbuild.v2.UserCredential.Builder,
            com.google.cloudbuild.v2.UserCredentialOrBuilder>
        readAuthorizerCredentialBuilder_;
    /**
     *
     *
     * <pre>
     * Required. A GitLab personal access token with the minimum `read_api` scope
     * access.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the readAuthorizerCredential field is set.
     */
    public boolean hasReadAuthorizerCredential() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. A GitLab personal access token with the minimum `read_api` scope
     * access.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The readAuthorizerCredential.
     */
    public com.google.cloudbuild.v2.UserCredential getReadAuthorizerCredential() {
      if (readAuthorizerCredentialBuilder_ == null) {
        return readAuthorizerCredential_ == null
            ? com.google.cloudbuild.v2.UserCredential.getDefaultInstance()
            : readAuthorizerCredential_;
      } else {
        return readAuthorizerCredentialBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A GitLab personal access token with the minimum `read_api` scope
     * access.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setReadAuthorizerCredential(com.google.cloudbuild.v2.UserCredential value) {
      if (readAuthorizerCredentialBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readAuthorizerCredential_ = value;
      } else {
        readAuthorizerCredentialBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A GitLab personal access token with the minimum `read_api` scope
     * access.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setReadAuthorizerCredential(
        com.google.cloudbuild.v2.UserCredential.Builder builderForValue) {
      if (readAuthorizerCredentialBuilder_ == null) {
        readAuthorizerCredential_ = builderForValue.build();
      } else {
        readAuthorizerCredentialBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A GitLab personal access token with the minimum `read_api` scope
     * access.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeReadAuthorizerCredential(com.google.cloudbuild.v2.UserCredential value) {
      if (readAuthorizerCredentialBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && readAuthorizerCredential_ != null
            && readAuthorizerCredential_
                != com.google.cloudbuild.v2.UserCredential.getDefaultInstance()) {
          getReadAuthorizerCredentialBuilder().mergeFrom(value);
        } else {
          readAuthorizerCredential_ = value;
        }
      } else {
        readAuthorizerCredentialBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A GitLab personal access token with the minimum `read_api` scope
     * access.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearReadAuthorizerCredential() {
      bitField0_ = (bitField0_ & ~0x00000004);
      readAuthorizerCredential_ = null;
      if (readAuthorizerCredentialBuilder_ != null) {
        readAuthorizerCredentialBuilder_.dispose();
        readAuthorizerCredentialBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A GitLab personal access token with the minimum `read_api` scope
     * access.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloudbuild.v2.UserCredential.Builder getReadAuthorizerCredentialBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getReadAuthorizerCredentialFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. A GitLab personal access token with the minimum `read_api` scope
     * access.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloudbuild.v2.UserCredentialOrBuilder getReadAuthorizerCredentialOrBuilder() {
      if (readAuthorizerCredentialBuilder_ != null) {
        return readAuthorizerCredentialBuilder_.getMessageOrBuilder();
      } else {
        return readAuthorizerCredential_ == null
            ? com.google.cloudbuild.v2.UserCredential.getDefaultInstance()
            : readAuthorizerCredential_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A GitLab personal access token with the minimum `read_api` scope
     * access.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v2.UserCredential,
            com.google.cloudbuild.v2.UserCredential.Builder,
            com.google.cloudbuild.v2.UserCredentialOrBuilder>
        getReadAuthorizerCredentialFieldBuilder() {
      if (readAuthorizerCredentialBuilder_ == null) {
        readAuthorizerCredentialBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v2.UserCredential,
                com.google.cloudbuild.v2.UserCredential.Builder,
                com.google.cloudbuild.v2.UserCredentialOrBuilder>(
                getReadAuthorizerCredential(), getParentForChildren(), isClean());
        readAuthorizerCredential_ = null;
      }
      return readAuthorizerCredentialBuilder_;
    }

    private com.google.cloudbuild.v2.UserCredential authorizerCredential_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v2.UserCredential,
            com.google.cloudbuild.v2.UserCredential.Builder,
            com.google.cloudbuild.v2.UserCredentialOrBuilder>
        authorizerCredentialBuilder_;
    /**
     *
     *
     * <pre>
     * Required. A GitLab personal access token with the `api` scope access.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the authorizerCredential field is set.
     */
    public boolean hasAuthorizerCredential() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. A GitLab personal access token with the `api` scope access.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The authorizerCredential.
     */
    public com.google.cloudbuild.v2.UserCredential getAuthorizerCredential() {
      if (authorizerCredentialBuilder_ == null) {
        return authorizerCredential_ == null
            ? com.google.cloudbuild.v2.UserCredential.getDefaultInstance()
            : authorizerCredential_;
      } else {
        return authorizerCredentialBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A GitLab personal access token with the `api` scope access.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAuthorizerCredential(com.google.cloudbuild.v2.UserCredential value) {
      if (authorizerCredentialBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authorizerCredential_ = value;
      } else {
        authorizerCredentialBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A GitLab personal access token with the `api` scope access.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAuthorizerCredential(
        com.google.cloudbuild.v2.UserCredential.Builder builderForValue) {
      if (authorizerCredentialBuilder_ == null) {
        authorizerCredential_ = builderForValue.build();
      } else {
        authorizerCredentialBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A GitLab personal access token with the `api` scope access.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeAuthorizerCredential(com.google.cloudbuild.v2.UserCredential value) {
      if (authorizerCredentialBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && authorizerCredential_ != null
            && authorizerCredential_
                != com.google.cloudbuild.v2.UserCredential.getDefaultInstance()) {
          getAuthorizerCredentialBuilder().mergeFrom(value);
        } else {
          authorizerCredential_ = value;
        }
      } else {
        authorizerCredentialBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A GitLab personal access token with the `api` scope access.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearAuthorizerCredential() {
      bitField0_ = (bitField0_ & ~0x00000008);
      authorizerCredential_ = null;
      if (authorizerCredentialBuilder_ != null) {
        authorizerCredentialBuilder_.dispose();
        authorizerCredentialBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A GitLab personal access token with the `api` scope access.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloudbuild.v2.UserCredential.Builder getAuthorizerCredentialBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getAuthorizerCredentialFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. A GitLab personal access token with the `api` scope access.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloudbuild.v2.UserCredentialOrBuilder getAuthorizerCredentialOrBuilder() {
      if (authorizerCredentialBuilder_ != null) {
        return authorizerCredentialBuilder_.getMessageOrBuilder();
      } else {
        return authorizerCredential_ == null
            ? com.google.cloudbuild.v2.UserCredential.getDefaultInstance()
            : authorizerCredential_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A GitLab personal access token with the `api` scope access.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v2.UserCredential,
            com.google.cloudbuild.v2.UserCredential.Builder,
            com.google.cloudbuild.v2.UserCredentialOrBuilder>
        getAuthorizerCredentialFieldBuilder() {
      if (authorizerCredentialBuilder_ == null) {
        authorizerCredentialBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v2.UserCredential,
                com.google.cloudbuild.v2.UserCredential.Builder,
                com.google.cloudbuild.v2.UserCredentialOrBuilder>(
                getAuthorizerCredential(), getParentForChildren(), isClean());
        authorizerCredential_ = null;
      }
      return authorizerCredentialBuilder_;
    }

    private com.google.cloudbuild.v2.ServiceDirectoryConfig serviceDirectoryConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v2.ServiceDirectoryConfig,
            com.google.cloudbuild.v2.ServiceDirectoryConfig.Builder,
            com.google.cloudbuild.v2.ServiceDirectoryConfigOrBuilder>
        serviceDirectoryConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for using Service Directory to privately connect to a GitLab
     * Enterprise server. This should only be set if the GitLab Enterprise server
     * is hosted on-premises and not reachable by public internet. If this field
     * is left empty, calls to the GitLab Enterprise server will be made over the
     * public internet.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 5;
     * </code>
     *
     * @return Whether the serviceDirectoryConfig field is set.
     */
    public boolean hasServiceDirectoryConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for using Service Directory to privately connect to a GitLab
     * Enterprise server. This should only be set if the GitLab Enterprise server
     * is hosted on-premises and not reachable by public internet. If this field
     * is left empty, calls to the GitLab Enterprise server will be made over the
     * public internet.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 5;
     * </code>
     *
     * @return The serviceDirectoryConfig.
     */
    public com.google.cloudbuild.v2.ServiceDirectoryConfig getServiceDirectoryConfig() {
      if (serviceDirectoryConfigBuilder_ == null) {
        return serviceDirectoryConfig_ == null
            ? com.google.cloudbuild.v2.ServiceDirectoryConfig.getDefaultInstance()
            : serviceDirectoryConfig_;
      } else {
        return serviceDirectoryConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for using Service Directory to privately connect to a GitLab
     * Enterprise server. This should only be set if the GitLab Enterprise server
     * is hosted on-premises and not reachable by public internet. If this field
     * is left empty, calls to the GitLab Enterprise server will be made over the
     * public internet.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 5;
     * </code>
     */
    public Builder setServiceDirectoryConfig(
        com.google.cloudbuild.v2.ServiceDirectoryConfig value) {
      if (serviceDirectoryConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceDirectoryConfig_ = value;
      } else {
        serviceDirectoryConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for using Service Directory to privately connect to a GitLab
     * Enterprise server. This should only be set if the GitLab Enterprise server
     * is hosted on-premises and not reachable by public internet. If this field
     * is left empty, calls to the GitLab Enterprise server will be made over the
     * public internet.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 5;
     * </code>
     */
    public Builder setServiceDirectoryConfig(
        com.google.cloudbuild.v2.ServiceDirectoryConfig.Builder builderForValue) {
      if (serviceDirectoryConfigBuilder_ == null) {
        serviceDirectoryConfig_ = builderForValue.build();
      } else {
        serviceDirectoryConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for using Service Directory to privately connect to a GitLab
     * Enterprise server. This should only be set if the GitLab Enterprise server
     * is hosted on-premises and not reachable by public internet. If this field
     * is left empty, calls to the GitLab Enterprise server will be made over the
     * public internet.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 5;
     * </code>
     */
    public Builder mergeServiceDirectoryConfig(
        com.google.cloudbuild.v2.ServiceDirectoryConfig value) {
      if (serviceDirectoryConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && serviceDirectoryConfig_ != null
            && serviceDirectoryConfig_
                != com.google.cloudbuild.v2.ServiceDirectoryConfig.getDefaultInstance()) {
          getServiceDirectoryConfigBuilder().mergeFrom(value);
        } else {
          serviceDirectoryConfig_ = value;
        }
      } else {
        serviceDirectoryConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for using Service Directory to privately connect to a GitLab
     * Enterprise server. This should only be set if the GitLab Enterprise server
     * is hosted on-premises and not reachable by public internet. If this field
     * is left empty, calls to the GitLab Enterprise server will be made over the
     * public internet.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 5;
     * </code>
     */
    public Builder clearServiceDirectoryConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      serviceDirectoryConfig_ = null;
      if (serviceDirectoryConfigBuilder_ != null) {
        serviceDirectoryConfigBuilder_.dispose();
        serviceDirectoryConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for using Service Directory to privately connect to a GitLab
     * Enterprise server. This should only be set if the GitLab Enterprise server
     * is hosted on-premises and not reachable by public internet. If this field
     * is left empty, calls to the GitLab Enterprise server will be made over the
     * public internet.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 5;
     * </code>
     */
    public com.google.cloudbuild.v2.ServiceDirectoryConfig.Builder
        getServiceDirectoryConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getServiceDirectoryConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for using Service Directory to privately connect to a GitLab
     * Enterprise server. This should only be set if the GitLab Enterprise server
     * is hosted on-premises and not reachable by public internet. If this field
     * is left empty, calls to the GitLab Enterprise server will be made over the
     * public internet.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 5;
     * </code>
     */
    public com.google.cloudbuild.v2.ServiceDirectoryConfigOrBuilder
        getServiceDirectoryConfigOrBuilder() {
      if (serviceDirectoryConfigBuilder_ != null) {
        return serviceDirectoryConfigBuilder_.getMessageOrBuilder();
      } else {
        return serviceDirectoryConfig_ == null
            ? com.google.cloudbuild.v2.ServiceDirectoryConfig.getDefaultInstance()
            : serviceDirectoryConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for using Service Directory to privately connect to a GitLab
     * Enterprise server. This should only be set if the GitLab Enterprise server
     * is hosted on-premises and not reachable by public internet. If this field
     * is left empty, calls to the GitLab Enterprise server will be made over the
     * public internet.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v2.ServiceDirectoryConfig,
            com.google.cloudbuild.v2.ServiceDirectoryConfig.Builder,
            com.google.cloudbuild.v2.ServiceDirectoryConfigOrBuilder>
        getServiceDirectoryConfigFieldBuilder() {
      if (serviceDirectoryConfigBuilder_ == null) {
        serviceDirectoryConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v2.ServiceDirectoryConfig,
                com.google.cloudbuild.v2.ServiceDirectoryConfig.Builder,
                com.google.cloudbuild.v2.ServiceDirectoryConfigOrBuilder>(
                getServiceDirectoryConfig(), getParentForChildren(), isClean());
        serviceDirectoryConfig_ = null;
      }
      return serviceDirectoryConfigBuilder_;
    }

    private java.lang.Object sslCa_ = "";
    /**
     *
     *
     * <pre>
     * SSL certificate to use for requests to GitLab Enterprise.
     * </pre>
     *
     * <code>string ssl_ca = 6;</code>
     *
     * @return The sslCa.
     */
    public java.lang.String getSslCa() {
      java.lang.Object ref = sslCa_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sslCa_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * SSL certificate to use for requests to GitLab Enterprise.
     * </pre>
     *
     * <code>string ssl_ca = 6;</code>
     *
     * @return The bytes for sslCa.
     */
    public com.google.protobuf.ByteString getSslCaBytes() {
      java.lang.Object ref = sslCa_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sslCa_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * SSL certificate to use for requests to GitLab Enterprise.
     * </pre>
     *
     * <code>string ssl_ca = 6;</code>
     *
     * @param value The sslCa to set.
     * @return This builder for chaining.
     */
    public Builder setSslCa(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sslCa_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * SSL certificate to use for requests to GitLab Enterprise.
     * </pre>
     *
     * <code>string ssl_ca = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSslCa() {
      sslCa_ = getDefaultInstance().getSslCa();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * SSL certificate to use for requests to GitLab Enterprise.
     * </pre>
     *
     * <code>string ssl_ca = 6;</code>
     *
     * @param value The bytes for sslCa to set.
     * @return This builder for chaining.
     */
    public Builder setSslCaBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sslCa_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object serverVersion_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Version of the GitLab Enterprise server running on the
     * `host_uri`.
     * </pre>
     *
     * <code>string server_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The serverVersion.
     */
    public java.lang.String getServerVersion() {
      java.lang.Object ref = serverVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serverVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Version of the GitLab Enterprise server running on the
     * `host_uri`.
     * </pre>
     *
     * <code>string server_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for serverVersion.
     */
    public com.google.protobuf.ByteString getServerVersionBytes() {
      java.lang.Object ref = serverVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serverVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Version of the GitLab Enterprise server running on the
     * `host_uri`.
     * </pre>
     *
     * <code>string server_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The serverVersion to set.
     * @return This builder for chaining.
     */
    public Builder setServerVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serverVersion_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Version of the GitLab Enterprise server running on the
     * `host_uri`.
     * </pre>
     *
     * <code>string server_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServerVersion() {
      serverVersion_ = getDefaultInstance().getServerVersion();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Version of the GitLab Enterprise server running on the
     * `host_uri`.
     * </pre>
     *
     * <code>string server_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for serverVersion to set.
     * @return This builder for chaining.
     */
    public Builder setServerVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serverVersion_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v2.GitLabConfig)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v2.GitLabConfig)
  private static final com.google.cloudbuild.v2.GitLabConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v2.GitLabConfig();
  }

  public static com.google.cloudbuild.v2.GitLabConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GitLabConfig> PARSER =
      new com.google.protobuf.AbstractParser<GitLabConfig>() {
        @java.lang.Override
        public GitLabConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GitLabConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GitLabConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v2.GitLabConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
