/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v2/repositories.proto

package com.google.cloudbuild.v2;

/**
 *
 *
 * <pre>
 * A connection to a SCM like GitHub, GitHub Enterprise, Bitbucket Server or
 * GitLab.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v2.Connection}
 */
public final class Connection extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v2.Connection)
    ConnectionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Connection.newBuilder() to construct.
  private Connection(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Connection() {
    name_ = "";
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Connection();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v2.RepositoryManagerProto
        .internal_static_google_devtools_cloudbuild_v2_Connection_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 15:
        return internalGetAnnotations();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v2.RepositoryManagerProto
        .internal_static_google_devtools_cloudbuild_v2_Connection_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v2.Connection.class,
            com.google.cloudbuild.v2.Connection.Builder.class);
  }

  private int connectionConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object connectionConfig_;

  public enum ConnectionConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GITHUB_CONFIG(5),
    GITHUB_ENTERPRISE_CONFIG(6),
    GITLAB_CONFIG(7),
    CONNECTIONCONFIG_NOT_SET(0);
    private final int value;

    private ConnectionConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConnectionConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConnectionConfigCase forNumber(int value) {
      switch (value) {
        case 5:
          return GITHUB_CONFIG;
        case 6:
          return GITHUB_ENTERPRISE_CONFIG;
        case 7:
          return GITLAB_CONFIG;
        case 0:
          return CONNECTIONCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConnectionConfigCase getConnectionConfigCase() {
    return ConnectionConfigCase.forNumber(connectionConfigCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the connection, in the format
   * `projects/{project}/locations/{location}/connections/{connection_id}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the connection, in the format
   * `projects/{project}/locations/{location}/connections/{connection_id}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Server assigned timestamp for when the connection was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Server assigned timestamp for when the connection was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Server assigned timestamp for when the connection was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Server assigned timestamp for when the connection was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Server assigned timestamp for when the connection was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Server assigned timestamp for when the connection was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int GITHUB_CONFIG_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Configuration for connections to github.com.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v2.GitHubConfig github_config = 5;</code>
   *
   * @return Whether the githubConfig field is set.
   */
  @java.lang.Override
  public boolean hasGithubConfig() {
    return connectionConfigCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Configuration for connections to github.com.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v2.GitHubConfig github_config = 5;</code>
   *
   * @return The githubConfig.
   */
  @java.lang.Override
  public com.google.cloudbuild.v2.GitHubConfig getGithubConfig() {
    if (connectionConfigCase_ == 5) {
      return (com.google.cloudbuild.v2.GitHubConfig) connectionConfig_;
    }
    return com.google.cloudbuild.v2.GitHubConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for connections to github.com.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v2.GitHubConfig github_config = 5;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v2.GitHubConfigOrBuilder getGithubConfigOrBuilder() {
    if (connectionConfigCase_ == 5) {
      return (com.google.cloudbuild.v2.GitHubConfig) connectionConfig_;
    }
    return com.google.cloudbuild.v2.GitHubConfig.getDefaultInstance();
  }

  public static final int GITHUB_ENTERPRISE_CONFIG_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Configuration for connections to an instance of GitHub Enterprise.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v2.GitHubEnterpriseConfig github_enterprise_config = 6;
   * </code>
   *
   * @return Whether the githubEnterpriseConfig field is set.
   */
  @java.lang.Override
  public boolean hasGithubEnterpriseConfig() {
    return connectionConfigCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Configuration for connections to an instance of GitHub Enterprise.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v2.GitHubEnterpriseConfig github_enterprise_config = 6;
   * </code>
   *
   * @return The githubEnterpriseConfig.
   */
  @java.lang.Override
  public com.google.cloudbuild.v2.GitHubEnterpriseConfig getGithubEnterpriseConfig() {
    if (connectionConfigCase_ == 6) {
      return (com.google.cloudbuild.v2.GitHubEnterpriseConfig) connectionConfig_;
    }
    return com.google.cloudbuild.v2.GitHubEnterpriseConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for connections to an instance of GitHub Enterprise.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v2.GitHubEnterpriseConfig github_enterprise_config = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v2.GitHubEnterpriseConfigOrBuilder
      getGithubEnterpriseConfigOrBuilder() {
    if (connectionConfigCase_ == 6) {
      return (com.google.cloudbuild.v2.GitHubEnterpriseConfig) connectionConfig_;
    }
    return com.google.cloudbuild.v2.GitHubEnterpriseConfig.getDefaultInstance();
  }

  public static final int GITLAB_CONFIG_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Configuration for connections to gitlab.com or an instance of GitLab
   * Enterprise.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v2.GitLabConfig gitlab_config = 7;</code>
   *
   * @return Whether the gitlabConfig field is set.
   */
  @java.lang.Override
  public boolean hasGitlabConfig() {
    return connectionConfigCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Configuration for connections to gitlab.com or an instance of GitLab
   * Enterprise.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v2.GitLabConfig gitlab_config = 7;</code>
   *
   * @return The gitlabConfig.
   */
  @java.lang.Override
  public com.google.cloudbuild.v2.GitLabConfig getGitlabConfig() {
    if (connectionConfigCase_ == 7) {
      return (com.google.cloudbuild.v2.GitLabConfig) connectionConfig_;
    }
    return com.google.cloudbuild.v2.GitLabConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for connections to gitlab.com or an instance of GitLab
   * Enterprise.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v2.GitLabConfig gitlab_config = 7;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v2.GitLabConfigOrBuilder getGitlabConfigOrBuilder() {
    if (connectionConfigCase_ == 7) {
      return (com.google.cloudbuild.v2.GitLabConfig) connectionConfig_;
    }
    return com.google.cloudbuild.v2.GitLabConfig.getDefaultInstance();
  }

  public static final int INSTALLATION_STATE_FIELD_NUMBER = 12;
  private com.google.cloudbuild.v2.InstallationState installationState_;
  /**
   *
   *
   * <pre>
   * Output only. Installation state of the Connection.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v2.InstallationState installation_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the installationState field is set.
   */
  @java.lang.Override
  public boolean hasInstallationState() {
    return installationState_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Installation state of the Connection.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v2.InstallationState installation_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The installationState.
   */
  @java.lang.Override
  public com.google.cloudbuild.v2.InstallationState getInstallationState() {
    return installationState_ == null
        ? com.google.cloudbuild.v2.InstallationState.getDefaultInstance()
        : installationState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Installation state of the Connection.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v2.InstallationState installation_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v2.InstallationStateOrBuilder getInstallationStateOrBuilder() {
    return installationState_ == null
        ? com.google.cloudbuild.v2.InstallationState.getDefaultInstance()
        : installationState_;
  }

  public static final int DISABLED_FIELD_NUMBER = 13;
  private boolean disabled_ = false;
  /**
   *
   *
   * <pre>
   * If disabled is set to true, functionality is disabled for this connection.
   * Repository based API methods and webhooks processing for repositories in
   * this connection will be disabled.
   * </pre>
   *
   * <code>bool disabled = 13;</code>
   *
   * @return The disabled.
   */
  @java.lang.Override
  public boolean getDisabled() {
    return disabled_;
  }

  public static final int RECONCILING_FIELD_NUMBER = 14;
  private boolean reconciling_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Set to true when the connection is being set up or updated in
   * the background.
   * </pre>
   *
   * <code>bool reconciling = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The reconciling.
   */
  @java.lang.Override
  public boolean getReconciling() {
    return reconciling_;
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 15;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloudbuild.v2.RepositoryManagerProto
                .internal_static_google_devtools_cloudbuild_v2_Connection_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Allows clients to store small amounts of arbitrary data.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 15;</code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }
  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }
  /**
   *
   *
   * <pre>
   * Allows clients to store small amounts of arbitrary data.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 15;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }
  /**
   *
   *
   * <pre>
   * Allows clients to store small amounts of arbitrary data.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 15;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Allows clients to store small amounts of arbitrary data.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 15;</code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ETAG_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 16;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 16;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(4, getUpdateTime());
    }
    if (connectionConfigCase_ == 5) {
      output.writeMessage(5, (com.google.cloudbuild.v2.GitHubConfig) connectionConfig_);
    }
    if (connectionConfigCase_ == 6) {
      output.writeMessage(6, (com.google.cloudbuild.v2.GitHubEnterpriseConfig) connectionConfig_);
    }
    if (connectionConfigCase_ == 7) {
      output.writeMessage(7, (com.google.cloudbuild.v2.GitLabConfig) connectionConfig_);
    }
    if (installationState_ != null) {
      output.writeMessage(12, getInstallationState());
    }
    if (disabled_ != false) {
      output.writeBool(13, disabled_);
    }
    if (reconciling_ != false) {
      output.writeBool(14, reconciling_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 15);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, etag_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    if (connectionConfigCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloudbuild.v2.GitHubConfig) connectionConfig_);
    }
    if (connectionConfigCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloudbuild.v2.GitHubEnterpriseConfig) connectionConfig_);
    }
    if (connectionConfigCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloudbuild.v2.GitLabConfig) connectionConfig_);
    }
    if (installationState_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getInstallationState());
    }
    if (disabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, disabled_);
    }
    if (reconciling_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(14, reconciling_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, annotations__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, etag_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v2.Connection)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v2.Connection other = (com.google.cloudbuild.v2.Connection) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasInstallationState() != other.hasInstallationState()) return false;
    if (hasInstallationState()) {
      if (!getInstallationState().equals(other.getInstallationState())) return false;
    }
    if (getDisabled() != other.getDisabled()) return false;
    if (getReconciling() != other.getReconciling()) return false;
    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getConnectionConfigCase().equals(other.getConnectionConfigCase())) return false;
    switch (connectionConfigCase_) {
      case 5:
        if (!getGithubConfig().equals(other.getGithubConfig())) return false;
        break;
      case 6:
        if (!getGithubEnterpriseConfig().equals(other.getGithubEnterpriseConfig())) return false;
        break;
      case 7:
        if (!getGitlabConfig().equals(other.getGitlabConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasInstallationState()) {
      hash = (37 * hash) + INSTALLATION_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getInstallationState().hashCode();
    }
    hash = (37 * hash) + DISABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
    hash = (37 * hash) + RECONCILING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReconciling());
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    switch (connectionConfigCase_) {
      case 5:
        hash = (37 * hash) + GITHUB_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getGithubConfig().hashCode();
        break;
      case 6:
        hash = (37 * hash) + GITHUB_ENTERPRISE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getGithubEnterpriseConfig().hashCode();
        break;
      case 7:
        hash = (37 * hash) + GITLAB_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getGitlabConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v2.Connection parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v2.Connection parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v2.Connection parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v2.Connection parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v2.Connection parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v2.Connection parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v2.Connection parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v2.Connection parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v2.Connection parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v2.Connection parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v2.Connection parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v2.Connection parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v2.Connection prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A connection to a SCM like GitHub, GitHub Enterprise, Bitbucket Server or
   * GitLab.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v2.Connection}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v2.Connection)
      com.google.cloudbuild.v2.ConnectionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v2.RepositoryManagerProto
          .internal_static_google_devtools_cloudbuild_v2_Connection_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 15:
          return internalGetAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 15:
          return internalGetMutableAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v2.RepositoryManagerProto
          .internal_static_google_devtools_cloudbuild_v2_Connection_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v2.Connection.class,
              com.google.cloudbuild.v2.Connection.Builder.class);
    }

    // Construct using com.google.cloudbuild.v2.Connection.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      if (githubConfigBuilder_ != null) {
        githubConfigBuilder_.clear();
      }
      if (githubEnterpriseConfigBuilder_ != null) {
        githubEnterpriseConfigBuilder_.clear();
      }
      if (gitlabConfigBuilder_ != null) {
        gitlabConfigBuilder_.clear();
      }
      installationState_ = null;
      if (installationStateBuilder_ != null) {
        installationStateBuilder_.dispose();
        installationStateBuilder_ = null;
      }
      disabled_ = false;
      reconciling_ = false;
      internalGetMutableAnnotations().clear();
      etag_ = "";
      connectionConfigCase_ = 0;
      connectionConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v2.RepositoryManagerProto
          .internal_static_google_devtools_cloudbuild_v2_Connection_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v2.Connection getDefaultInstanceForType() {
      return com.google.cloudbuild.v2.Connection.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v2.Connection build() {
      com.google.cloudbuild.v2.Connection result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v2.Connection buildPartial() {
      com.google.cloudbuild.v2.Connection result = new com.google.cloudbuild.v2.Connection(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloudbuild.v2.Connection result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.installationState_ =
            installationStateBuilder_ == null
                ? installationState_
                : installationStateBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.disabled_ = disabled_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.reconciling_ = reconciling_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.etag_ = etag_;
      }
    }

    private void buildPartialOneofs(com.google.cloudbuild.v2.Connection result) {
      result.connectionConfigCase_ = connectionConfigCase_;
      result.connectionConfig_ = this.connectionConfig_;
      if (connectionConfigCase_ == 5 && githubConfigBuilder_ != null) {
        result.connectionConfig_ = githubConfigBuilder_.build();
      }
      if (connectionConfigCase_ == 6 && githubEnterpriseConfigBuilder_ != null) {
        result.connectionConfig_ = githubEnterpriseConfigBuilder_.build();
      }
      if (connectionConfigCase_ == 7 && gitlabConfigBuilder_ != null) {
        result.connectionConfig_ = gitlabConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v2.Connection) {
        return mergeFrom((com.google.cloudbuild.v2.Connection) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v2.Connection other) {
      if (other == com.google.cloudbuild.v2.Connection.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasInstallationState()) {
        mergeInstallationState(other.getInstallationState());
      }
      if (other.getDisabled() != false) {
        setDisabled(other.getDisabled());
      }
      if (other.getReconciling() != false) {
        setReconciling(other.getReconciling());
      }
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000200;
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      switch (other.getConnectionConfigCase()) {
        case GITHUB_CONFIG:
          {
            mergeGithubConfig(other.getGithubConfig());
            break;
          }
        case GITHUB_ENTERPRISE_CONFIG:
          {
            mergeGithubEnterpriseConfig(other.getGithubEnterpriseConfig());
            break;
          }
        case GITLAB_CONFIG:
          {
            mergeGitlabConfig(other.getGitlabConfig());
            break;
          }
        case CONNECTIONCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getGithubConfigFieldBuilder().getBuilder(), extensionRegistry);
                connectionConfigCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getGithubEnterpriseConfigFieldBuilder().getBuilder(), extensionRegistry);
                connectionConfigCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getGitlabConfigFieldBuilder().getBuilder(), extensionRegistry);
                connectionConfigCase_ = 7;
                break;
              } // case 58
            case 98:
              {
                input.readMessage(
                    getInstallationStateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 98
            case 104:
              {
                disabled_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 104
            case 112:
              {
                reconciling_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 112
            case 122:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000200;
                break;
              } // case 122
            case 130:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 130
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int connectionConfigCase_ = 0;
    private java.lang.Object connectionConfig_;

    public ConnectionConfigCase getConnectionConfigCase() {
      return ConnectionConfigCase.forNumber(connectionConfigCase_);
    }

    public Builder clearConnectionConfig() {
      connectionConfigCase_ = 0;
      connectionConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the connection, in the format
     * `projects/{project}/locations/{location}/connections/{connection_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the connection, in the format
     * `projects/{project}/locations/{location}/connections/{connection_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the connection, in the format
     * `projects/{project}/locations/{location}/connections/{connection_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the connection, in the format
     * `projects/{project}/locations/{location}/connections/{connection_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the connection, in the format
     * `projects/{project}/locations/{location}/connections/{connection_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Server assigned timestamp for when the connection was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned timestamp for when the connection was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned timestamp for when the connection was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned timestamp for when the connection was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned timestamp for when the connection was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned timestamp for when the connection was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned timestamp for when the connection was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned timestamp for when the connection was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned timestamp for when the connection was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Server assigned timestamp for when the connection was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned timestamp for when the connection was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned timestamp for when the connection was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned timestamp for when the connection was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned timestamp for when the connection was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned timestamp for when the connection was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned timestamp for when the connection was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned timestamp for when the connection was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned timestamp for when the connection was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v2.GitHubConfig,
            com.google.cloudbuild.v2.GitHubConfig.Builder,
            com.google.cloudbuild.v2.GitHubConfigOrBuilder>
        githubConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for connections to github.com.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitHubConfig github_config = 5;</code>
     *
     * @return Whether the githubConfig field is set.
     */
    @java.lang.Override
    public boolean hasGithubConfig() {
      return connectionConfigCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to github.com.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitHubConfig github_config = 5;</code>
     *
     * @return The githubConfig.
     */
    @java.lang.Override
    public com.google.cloudbuild.v2.GitHubConfig getGithubConfig() {
      if (githubConfigBuilder_ == null) {
        if (connectionConfigCase_ == 5) {
          return (com.google.cloudbuild.v2.GitHubConfig) connectionConfig_;
        }
        return com.google.cloudbuild.v2.GitHubConfig.getDefaultInstance();
      } else {
        if (connectionConfigCase_ == 5) {
          return githubConfigBuilder_.getMessage();
        }
        return com.google.cloudbuild.v2.GitHubConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to github.com.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitHubConfig github_config = 5;</code>
     */
    public Builder setGithubConfig(com.google.cloudbuild.v2.GitHubConfig value) {
      if (githubConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectionConfig_ = value;
        onChanged();
      } else {
        githubConfigBuilder_.setMessage(value);
      }
      connectionConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to github.com.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitHubConfig github_config = 5;</code>
     */
    public Builder setGithubConfig(com.google.cloudbuild.v2.GitHubConfig.Builder builderForValue) {
      if (githubConfigBuilder_ == null) {
        connectionConfig_ = builderForValue.build();
        onChanged();
      } else {
        githubConfigBuilder_.setMessage(builderForValue.build());
      }
      connectionConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to github.com.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitHubConfig github_config = 5;</code>
     */
    public Builder mergeGithubConfig(com.google.cloudbuild.v2.GitHubConfig value) {
      if (githubConfigBuilder_ == null) {
        if (connectionConfigCase_ == 5
            && connectionConfig_ != com.google.cloudbuild.v2.GitHubConfig.getDefaultInstance()) {
          connectionConfig_ =
              com.google.cloudbuild.v2.GitHubConfig.newBuilder(
                      (com.google.cloudbuild.v2.GitHubConfig) connectionConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          connectionConfig_ = value;
        }
        onChanged();
      } else {
        if (connectionConfigCase_ == 5) {
          githubConfigBuilder_.mergeFrom(value);
        } else {
          githubConfigBuilder_.setMessage(value);
        }
      }
      connectionConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to github.com.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitHubConfig github_config = 5;</code>
     */
    public Builder clearGithubConfig() {
      if (githubConfigBuilder_ == null) {
        if (connectionConfigCase_ == 5) {
          connectionConfigCase_ = 0;
          connectionConfig_ = null;
          onChanged();
        }
      } else {
        if (connectionConfigCase_ == 5) {
          connectionConfigCase_ = 0;
          connectionConfig_ = null;
        }
        githubConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to github.com.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitHubConfig github_config = 5;</code>
     */
    public com.google.cloudbuild.v2.GitHubConfig.Builder getGithubConfigBuilder() {
      return getGithubConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to github.com.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitHubConfig github_config = 5;</code>
     */
    @java.lang.Override
    public com.google.cloudbuild.v2.GitHubConfigOrBuilder getGithubConfigOrBuilder() {
      if ((connectionConfigCase_ == 5) && (githubConfigBuilder_ != null)) {
        return githubConfigBuilder_.getMessageOrBuilder();
      } else {
        if (connectionConfigCase_ == 5) {
          return (com.google.cloudbuild.v2.GitHubConfig) connectionConfig_;
        }
        return com.google.cloudbuild.v2.GitHubConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to github.com.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitHubConfig github_config = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v2.GitHubConfig,
            com.google.cloudbuild.v2.GitHubConfig.Builder,
            com.google.cloudbuild.v2.GitHubConfigOrBuilder>
        getGithubConfigFieldBuilder() {
      if (githubConfigBuilder_ == null) {
        if (!(connectionConfigCase_ == 5)) {
          connectionConfig_ = com.google.cloudbuild.v2.GitHubConfig.getDefaultInstance();
        }
        githubConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v2.GitHubConfig,
                com.google.cloudbuild.v2.GitHubConfig.Builder,
                com.google.cloudbuild.v2.GitHubConfigOrBuilder>(
                (com.google.cloudbuild.v2.GitHubConfig) connectionConfig_,
                getParentForChildren(),
                isClean());
        connectionConfig_ = null;
      }
      connectionConfigCase_ = 5;
      onChanged();
      return githubConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v2.GitHubEnterpriseConfig,
            com.google.cloudbuild.v2.GitHubEnterpriseConfig.Builder,
            com.google.cloudbuild.v2.GitHubEnterpriseConfigOrBuilder>
        githubEnterpriseConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for connections to an instance of GitHub Enterprise.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitHubEnterpriseConfig github_enterprise_config = 6;
     * </code>
     *
     * @return Whether the githubEnterpriseConfig field is set.
     */
    @java.lang.Override
    public boolean hasGithubEnterpriseConfig() {
      return connectionConfigCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to an instance of GitHub Enterprise.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitHubEnterpriseConfig github_enterprise_config = 6;
     * </code>
     *
     * @return The githubEnterpriseConfig.
     */
    @java.lang.Override
    public com.google.cloudbuild.v2.GitHubEnterpriseConfig getGithubEnterpriseConfig() {
      if (githubEnterpriseConfigBuilder_ == null) {
        if (connectionConfigCase_ == 6) {
          return (com.google.cloudbuild.v2.GitHubEnterpriseConfig) connectionConfig_;
        }
        return com.google.cloudbuild.v2.GitHubEnterpriseConfig.getDefaultInstance();
      } else {
        if (connectionConfigCase_ == 6) {
          return githubEnterpriseConfigBuilder_.getMessage();
        }
        return com.google.cloudbuild.v2.GitHubEnterpriseConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to an instance of GitHub Enterprise.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitHubEnterpriseConfig github_enterprise_config = 6;
     * </code>
     */
    public Builder setGithubEnterpriseConfig(
        com.google.cloudbuild.v2.GitHubEnterpriseConfig value) {
      if (githubEnterpriseConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectionConfig_ = value;
        onChanged();
      } else {
        githubEnterpriseConfigBuilder_.setMessage(value);
      }
      connectionConfigCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to an instance of GitHub Enterprise.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitHubEnterpriseConfig github_enterprise_config = 6;
     * </code>
     */
    public Builder setGithubEnterpriseConfig(
        com.google.cloudbuild.v2.GitHubEnterpriseConfig.Builder builderForValue) {
      if (githubEnterpriseConfigBuilder_ == null) {
        connectionConfig_ = builderForValue.build();
        onChanged();
      } else {
        githubEnterpriseConfigBuilder_.setMessage(builderForValue.build());
      }
      connectionConfigCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to an instance of GitHub Enterprise.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitHubEnterpriseConfig github_enterprise_config = 6;
     * </code>
     */
    public Builder mergeGithubEnterpriseConfig(
        com.google.cloudbuild.v2.GitHubEnterpriseConfig value) {
      if (githubEnterpriseConfigBuilder_ == null) {
        if (connectionConfigCase_ == 6
            && connectionConfig_
                != com.google.cloudbuild.v2.GitHubEnterpriseConfig.getDefaultInstance()) {
          connectionConfig_ =
              com.google.cloudbuild.v2.GitHubEnterpriseConfig.newBuilder(
                      (com.google.cloudbuild.v2.GitHubEnterpriseConfig) connectionConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          connectionConfig_ = value;
        }
        onChanged();
      } else {
        if (connectionConfigCase_ == 6) {
          githubEnterpriseConfigBuilder_.mergeFrom(value);
        } else {
          githubEnterpriseConfigBuilder_.setMessage(value);
        }
      }
      connectionConfigCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to an instance of GitHub Enterprise.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitHubEnterpriseConfig github_enterprise_config = 6;
     * </code>
     */
    public Builder clearGithubEnterpriseConfig() {
      if (githubEnterpriseConfigBuilder_ == null) {
        if (connectionConfigCase_ == 6) {
          connectionConfigCase_ = 0;
          connectionConfig_ = null;
          onChanged();
        }
      } else {
        if (connectionConfigCase_ == 6) {
          connectionConfigCase_ = 0;
          connectionConfig_ = null;
        }
        githubEnterpriseConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to an instance of GitHub Enterprise.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitHubEnterpriseConfig github_enterprise_config = 6;
     * </code>
     */
    public com.google.cloudbuild.v2.GitHubEnterpriseConfig.Builder
        getGithubEnterpriseConfigBuilder() {
      return getGithubEnterpriseConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to an instance of GitHub Enterprise.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitHubEnterpriseConfig github_enterprise_config = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloudbuild.v2.GitHubEnterpriseConfigOrBuilder
        getGithubEnterpriseConfigOrBuilder() {
      if ((connectionConfigCase_ == 6) && (githubEnterpriseConfigBuilder_ != null)) {
        return githubEnterpriseConfigBuilder_.getMessageOrBuilder();
      } else {
        if (connectionConfigCase_ == 6) {
          return (com.google.cloudbuild.v2.GitHubEnterpriseConfig) connectionConfig_;
        }
        return com.google.cloudbuild.v2.GitHubEnterpriseConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to an instance of GitHub Enterprise.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitHubEnterpriseConfig github_enterprise_config = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v2.GitHubEnterpriseConfig,
            com.google.cloudbuild.v2.GitHubEnterpriseConfig.Builder,
            com.google.cloudbuild.v2.GitHubEnterpriseConfigOrBuilder>
        getGithubEnterpriseConfigFieldBuilder() {
      if (githubEnterpriseConfigBuilder_ == null) {
        if (!(connectionConfigCase_ == 6)) {
          connectionConfig_ = com.google.cloudbuild.v2.GitHubEnterpriseConfig.getDefaultInstance();
        }
        githubEnterpriseConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v2.GitHubEnterpriseConfig,
                com.google.cloudbuild.v2.GitHubEnterpriseConfig.Builder,
                com.google.cloudbuild.v2.GitHubEnterpriseConfigOrBuilder>(
                (com.google.cloudbuild.v2.GitHubEnterpriseConfig) connectionConfig_,
                getParentForChildren(),
                isClean());
        connectionConfig_ = null;
      }
      connectionConfigCase_ = 6;
      onChanged();
      return githubEnterpriseConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v2.GitLabConfig,
            com.google.cloudbuild.v2.GitLabConfig.Builder,
            com.google.cloudbuild.v2.GitLabConfigOrBuilder>
        gitlabConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for connections to gitlab.com or an instance of GitLab
     * Enterprise.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitLabConfig gitlab_config = 7;</code>
     *
     * @return Whether the gitlabConfig field is set.
     */
    @java.lang.Override
    public boolean hasGitlabConfig() {
      return connectionConfigCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to gitlab.com or an instance of GitLab
     * Enterprise.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitLabConfig gitlab_config = 7;</code>
     *
     * @return The gitlabConfig.
     */
    @java.lang.Override
    public com.google.cloudbuild.v2.GitLabConfig getGitlabConfig() {
      if (gitlabConfigBuilder_ == null) {
        if (connectionConfigCase_ == 7) {
          return (com.google.cloudbuild.v2.GitLabConfig) connectionConfig_;
        }
        return com.google.cloudbuild.v2.GitLabConfig.getDefaultInstance();
      } else {
        if (connectionConfigCase_ == 7) {
          return gitlabConfigBuilder_.getMessage();
        }
        return com.google.cloudbuild.v2.GitLabConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to gitlab.com or an instance of GitLab
     * Enterprise.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitLabConfig gitlab_config = 7;</code>
     */
    public Builder setGitlabConfig(com.google.cloudbuild.v2.GitLabConfig value) {
      if (gitlabConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectionConfig_ = value;
        onChanged();
      } else {
        gitlabConfigBuilder_.setMessage(value);
      }
      connectionConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to gitlab.com or an instance of GitLab
     * Enterprise.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitLabConfig gitlab_config = 7;</code>
     */
    public Builder setGitlabConfig(com.google.cloudbuild.v2.GitLabConfig.Builder builderForValue) {
      if (gitlabConfigBuilder_ == null) {
        connectionConfig_ = builderForValue.build();
        onChanged();
      } else {
        gitlabConfigBuilder_.setMessage(builderForValue.build());
      }
      connectionConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to gitlab.com or an instance of GitLab
     * Enterprise.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitLabConfig gitlab_config = 7;</code>
     */
    public Builder mergeGitlabConfig(com.google.cloudbuild.v2.GitLabConfig value) {
      if (gitlabConfigBuilder_ == null) {
        if (connectionConfigCase_ == 7
            && connectionConfig_ != com.google.cloudbuild.v2.GitLabConfig.getDefaultInstance()) {
          connectionConfig_ =
              com.google.cloudbuild.v2.GitLabConfig.newBuilder(
                      (com.google.cloudbuild.v2.GitLabConfig) connectionConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          connectionConfig_ = value;
        }
        onChanged();
      } else {
        if (connectionConfigCase_ == 7) {
          gitlabConfigBuilder_.mergeFrom(value);
        } else {
          gitlabConfigBuilder_.setMessage(value);
        }
      }
      connectionConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to gitlab.com or an instance of GitLab
     * Enterprise.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitLabConfig gitlab_config = 7;</code>
     */
    public Builder clearGitlabConfig() {
      if (gitlabConfigBuilder_ == null) {
        if (connectionConfigCase_ == 7) {
          connectionConfigCase_ = 0;
          connectionConfig_ = null;
          onChanged();
        }
      } else {
        if (connectionConfigCase_ == 7) {
          connectionConfigCase_ = 0;
          connectionConfig_ = null;
        }
        gitlabConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to gitlab.com or an instance of GitLab
     * Enterprise.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitLabConfig gitlab_config = 7;</code>
     */
    public com.google.cloudbuild.v2.GitLabConfig.Builder getGitlabConfigBuilder() {
      return getGitlabConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to gitlab.com or an instance of GitLab
     * Enterprise.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitLabConfig gitlab_config = 7;</code>
     */
    @java.lang.Override
    public com.google.cloudbuild.v2.GitLabConfigOrBuilder getGitlabConfigOrBuilder() {
      if ((connectionConfigCase_ == 7) && (gitlabConfigBuilder_ != null)) {
        return gitlabConfigBuilder_.getMessageOrBuilder();
      } else {
        if (connectionConfigCase_ == 7) {
          return (com.google.cloudbuild.v2.GitLabConfig) connectionConfig_;
        }
        return com.google.cloudbuild.v2.GitLabConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for connections to gitlab.com or an instance of GitLab
     * Enterprise.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v2.GitLabConfig gitlab_config = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v2.GitLabConfig,
            com.google.cloudbuild.v2.GitLabConfig.Builder,
            com.google.cloudbuild.v2.GitLabConfigOrBuilder>
        getGitlabConfigFieldBuilder() {
      if (gitlabConfigBuilder_ == null) {
        if (!(connectionConfigCase_ == 7)) {
          connectionConfig_ = com.google.cloudbuild.v2.GitLabConfig.getDefaultInstance();
        }
        gitlabConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v2.GitLabConfig,
                com.google.cloudbuild.v2.GitLabConfig.Builder,
                com.google.cloudbuild.v2.GitLabConfigOrBuilder>(
                (com.google.cloudbuild.v2.GitLabConfig) connectionConfig_,
                getParentForChildren(),
                isClean());
        connectionConfig_ = null;
      }
      connectionConfigCase_ = 7;
      onChanged();
      return gitlabConfigBuilder_;
    }

    private com.google.cloudbuild.v2.InstallationState installationState_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v2.InstallationState,
            com.google.cloudbuild.v2.InstallationState.Builder,
            com.google.cloudbuild.v2.InstallationStateOrBuilder>
        installationStateBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Installation state of the Connection.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.InstallationState installation_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the installationState field is set.
     */
    public boolean hasInstallationState() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Installation state of the Connection.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.InstallationState installation_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The installationState.
     */
    public com.google.cloudbuild.v2.InstallationState getInstallationState() {
      if (installationStateBuilder_ == null) {
        return installationState_ == null
            ? com.google.cloudbuild.v2.InstallationState.getDefaultInstance()
            : installationState_;
      } else {
        return installationStateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Installation state of the Connection.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.InstallationState installation_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setInstallationState(com.google.cloudbuild.v2.InstallationState value) {
      if (installationStateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        installationState_ = value;
      } else {
        installationStateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Installation state of the Connection.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.InstallationState installation_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setInstallationState(
        com.google.cloudbuild.v2.InstallationState.Builder builderForValue) {
      if (installationStateBuilder_ == null) {
        installationState_ = builderForValue.build();
      } else {
        installationStateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Installation state of the Connection.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.InstallationState installation_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeInstallationState(com.google.cloudbuild.v2.InstallationState value) {
      if (installationStateBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && installationState_ != null
            && installationState_
                != com.google.cloudbuild.v2.InstallationState.getDefaultInstance()) {
          getInstallationStateBuilder().mergeFrom(value);
        } else {
          installationState_ = value;
        }
      } else {
        installationStateBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Installation state of the Connection.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.InstallationState installation_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearInstallationState() {
      bitField0_ = (bitField0_ & ~0x00000040);
      installationState_ = null;
      if (installationStateBuilder_ != null) {
        installationStateBuilder_.dispose();
        installationStateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Installation state of the Connection.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.InstallationState installation_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v2.InstallationState.Builder getInstallationStateBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getInstallationStateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Installation state of the Connection.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.InstallationState installation_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v2.InstallationStateOrBuilder getInstallationStateOrBuilder() {
      if (installationStateBuilder_ != null) {
        return installationStateBuilder_.getMessageOrBuilder();
      } else {
        return installationState_ == null
            ? com.google.cloudbuild.v2.InstallationState.getDefaultInstance()
            : installationState_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Installation state of the Connection.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v2.InstallationState installation_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v2.InstallationState,
            com.google.cloudbuild.v2.InstallationState.Builder,
            com.google.cloudbuild.v2.InstallationStateOrBuilder>
        getInstallationStateFieldBuilder() {
      if (installationStateBuilder_ == null) {
        installationStateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v2.InstallationState,
                com.google.cloudbuild.v2.InstallationState.Builder,
                com.google.cloudbuild.v2.InstallationStateOrBuilder>(
                getInstallationState(), getParentForChildren(), isClean());
        installationState_ = null;
      }
      return installationStateBuilder_;
    }

    private boolean disabled_;
    /**
     *
     *
     * <pre>
     * If disabled is set to true, functionality is disabled for this connection.
     * Repository based API methods and webhooks processing for repositories in
     * this connection will be disabled.
     * </pre>
     *
     * <code>bool disabled = 13;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }
    /**
     *
     *
     * <pre>
     * If disabled is set to true, functionality is disabled for this connection.
     * Repository based API methods and webhooks processing for repositories in
     * this connection will be disabled.
     * </pre>
     *
     * <code>bool disabled = 13;</code>
     *
     * @param value The disabled to set.
     * @return This builder for chaining.
     */
    public Builder setDisabled(boolean value) {

      disabled_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If disabled is set to true, functionality is disabled for this connection.
     * Repository based API methods and webhooks processing for repositories in
     * this connection will be disabled.
     * </pre>
     *
     * <code>bool disabled = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisabled() {
      bitField0_ = (bitField0_ & ~0x00000080);
      disabled_ = false;
      onChanged();
      return this;
    }

    private boolean reconciling_;
    /**
     *
     *
     * <pre>
     * Output only. Set to true when the connection is being set up or updated in
     * the background.
     * </pre>
     *
     * <code>bool reconciling = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The reconciling.
     */
    @java.lang.Override
    public boolean getReconciling() {
      return reconciling_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Set to true when the connection is being set up or updated in
     * the background.
     * </pre>
     *
     * <code>bool reconciling = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The reconciling to set.
     * @return This builder for chaining.
     */
    public Builder setReconciling(boolean value) {

      reconciling_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Set to true when the connection is being set up or updated in
     * the background.
     * </pre>
     *
     * <code>bool reconciling = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReconciling() {
      bitField0_ = (bitField0_ & ~0x00000100);
      reconciling_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Allows clients to store small amounts of arbitrary data.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 15;</code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }
    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }
    /**
     *
     *
     * <pre>
     * Allows clients to store small amounts of arbitrary data.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 15;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }
    /**
     *
     *
     * <pre>
     * Allows clients to store small amounts of arbitrary data.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 15;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Allows clients to store small amounts of arbitrary data.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 15;</code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000200);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows clients to store small amounts of arbitrary data.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 15;</code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000200;
      return internalGetMutableAnnotations().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Allows clients to store small amounts of arbitrary data.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 15;</code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000200;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows clients to store small amounts of arbitrary data.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 15;</code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000200;
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 16;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 16;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 16;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 16;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v2.Connection)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v2.Connection)
  private static final com.google.cloudbuild.v2.Connection DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v2.Connection();
  }

  public static com.google.cloudbuild.v2.Connection getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Connection> PARSER =
      new com.google.protobuf.AbstractParser<Connection>() {
        @java.lang.Override
        public Connection parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Connection> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Connection> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v2.Connection getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
