/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.channel.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReportJobName
implements ResourceName {
    private static final PathTemplate ACCOUNT_REPORT_JOB = PathTemplate.createWithoutUrlEncoding((String)"accounts/{account}/reportJobs/{report_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String account;
    private final String reportJob;

    @Deprecated
    protected ReportJobName() {
        this.account = null;
        this.reportJob = null;
    }

    private ReportJobName(Builder builder) {
        this.account = (String)Preconditions.checkNotNull((Object)builder.getAccount());
        this.reportJob = (String)Preconditions.checkNotNull((Object)builder.getReportJob());
    }

    public String getAccount() {
        return this.account;
    }

    public String getReportJob() {
        return this.reportJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ReportJobName of(String account, String reportJob) {
        return ReportJobName.newBuilder().setAccount(account).setReportJob(reportJob).build();
    }

    public static String format(String account, String reportJob) {
        return ReportJobName.newBuilder().setAccount(account).setReportJob(reportJob).build().toString();
    }

    public static ReportJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ACCOUNT_REPORT_JOB.validatedMatch(formattedString, "ReportJobName.parse: formattedString not in valid format");
        return ReportJobName.of((String)matchMap.get("account"), (String)matchMap.get("report_job"));
    }

    public static List<ReportJobName> parseList(List<String> formattedStrings) {
        ArrayList<ReportJobName> list = new ArrayList<ReportJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReportJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReportJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReportJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ACCOUNT_REPORT_JOB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReportJobName reportJobName = this;
            synchronized (reportJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.account != null) {
                        fieldMapBuilder.put((Object)"account", (Object)this.account);
                    }
                    if (this.reportJob != null) {
                        fieldMapBuilder.put((Object)"report_job", (Object)this.reportJob);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ACCOUNT_REPORT_JOB.instantiate(new String[]{"account", this.account, "report_job", this.reportJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ReportJobName that = (ReportJobName)o;
            return Objects.equals(this.account, that.account) && Objects.equals(this.reportJob, that.reportJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.account);
        h *= 1000003;
        return h ^= Objects.hashCode(this.reportJob);
    }

    public static class Builder {
        private String account;
        private String reportJob;

        protected Builder() {
        }

        public String getAccount() {
            return this.account;
        }

        public String getReportJob() {
            return this.reportJob;
        }

        public Builder setAccount(String account) {
            this.account = account;
            return this;
        }

        public Builder setReportJob(String reportJob) {
            this.reportJob = reportJob;
            return this;
        }

        private Builder(ReportJobName reportJobName) {
            this.account = reportJobName.account;
            this.reportJob = reportJobName.reportJob;
        }

        public ReportJobName build() {
            return new ReportJobName(this);
        }
    }
}

