/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.channel.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EntitlementName
implements ResourceName {
    private static final PathTemplate ACCOUNT_CUSTOMER_ENTITLEMENT = PathTemplate.createWithoutUrlEncoding((String)"accounts/{account}/customers/{customer}/entitlements/{entitlement}");
    private volatile Map<String, String> fieldValuesMap;
    private final String account;
    private final String customer;
    private final String entitlement;

    @Deprecated
    protected EntitlementName() {
        this.account = null;
        this.customer = null;
        this.entitlement = null;
    }

    private EntitlementName(Builder builder) {
        this.account = (String)Preconditions.checkNotNull((Object)builder.getAccount());
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.entitlement = (String)Preconditions.checkNotNull((Object)builder.getEntitlement());
    }

    public String getAccount() {
        return this.account;
    }

    public String getCustomer() {
        return this.customer;
    }

    public String getEntitlement() {
        return this.entitlement;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EntitlementName of(String account, String customer, String entitlement) {
        return EntitlementName.newBuilder().setAccount(account).setCustomer(customer).setEntitlement(entitlement).build();
    }

    public static String format(String account, String customer, String entitlement) {
        return EntitlementName.newBuilder().setAccount(account).setCustomer(customer).setEntitlement(entitlement).build().toString();
    }

    public static EntitlementName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ACCOUNT_CUSTOMER_ENTITLEMENT.validatedMatch(formattedString, "EntitlementName.parse: formattedString not in valid format");
        return EntitlementName.of((String)matchMap.get("account"), (String)matchMap.get("customer"), (String)matchMap.get("entitlement"));
    }

    public static List<EntitlementName> parseList(List<String> formattedStrings) {
        ArrayList<EntitlementName> list = new ArrayList<EntitlementName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EntitlementName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EntitlementName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EntitlementName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ACCOUNT_CUSTOMER_ENTITLEMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EntitlementName entitlementName = this;
            synchronized (entitlementName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.account != null) {
                        fieldMapBuilder.put((Object)"account", (Object)this.account);
                    }
                    if (this.customer != null) {
                        fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    }
                    if (this.entitlement != null) {
                        fieldMapBuilder.put((Object)"entitlement", (Object)this.entitlement);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ACCOUNT_CUSTOMER_ENTITLEMENT.instantiate(new String[]{"account", this.account, "customer", this.customer, "entitlement", this.entitlement});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EntitlementName that = (EntitlementName)o;
            return Objects.equals(this.account, that.account) && Objects.equals(this.customer, that.customer) && Objects.equals(this.entitlement, that.entitlement);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.account);
        h *= 1000003;
        h ^= Objects.hashCode(this.customer);
        h *= 1000003;
        return h ^= Objects.hashCode(this.entitlement);
    }

    public static class Builder {
        private String account;
        private String customer;
        private String entitlement;

        protected Builder() {
        }

        public String getAccount() {
            return this.account;
        }

        public String getCustomer() {
            return this.customer;
        }

        public String getEntitlement() {
            return this.entitlement;
        }

        public Builder setAccount(String account) {
            this.account = account;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setEntitlement(String entitlement) {
            this.entitlement = entitlement;
            return this;
        }

        private Builder(EntitlementName entitlementName) {
            this.account = entitlementName.account;
            this.customer = entitlementName.customer;
            this.entitlement = entitlementName.entitlement;
        }

        public EntitlementName build() {
            return new EntitlementName(this);
        }
    }
}

