/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.channel.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomerName
implements ResourceName {
    private static final PathTemplate ACCOUNT_CUSTOMER = PathTemplate.createWithoutUrlEncoding((String)"accounts/{account}/customers/{customer}");
    private volatile Map<String, String> fieldValuesMap;
    private final String account;
    private final String customer;

    @Deprecated
    protected CustomerName() {
        this.account = null;
        this.customer = null;
    }

    private CustomerName(Builder builder) {
        this.account = (String)Preconditions.checkNotNull((Object)builder.getAccount());
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
    }

    public String getAccount() {
        return this.account;
    }

    public String getCustomer() {
        return this.customer;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomerName of(String account, String customer) {
        return CustomerName.newBuilder().setAccount(account).setCustomer(customer).build();
    }

    public static String format(String account, String customer) {
        return CustomerName.newBuilder().setAccount(account).setCustomer(customer).build().toString();
    }

    public static CustomerName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ACCOUNT_CUSTOMER.validatedMatch(formattedString, "CustomerName.parse: formattedString not in valid format");
        return CustomerName.of((String)matchMap.get("account"), (String)matchMap.get("customer"));
    }

    public static List<CustomerName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerName> list = new ArrayList<CustomerName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ACCOUNT_CUSTOMER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerName customerName = this;
            synchronized (customerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.account != null) {
                        fieldMapBuilder.put((Object)"account", (Object)this.account);
                    }
                    if (this.customer != null) {
                        fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ACCOUNT_CUSTOMER.instantiate(new String[]{"account", this.account, "customer", this.customer});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CustomerName that = (CustomerName)o;
            return Objects.equals(this.account, that.account) && Objects.equals(this.customer, that.customer);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.account);
        h *= 1000003;
        return h ^= Objects.hashCode(this.customer);
    }

    public static class Builder {
        private String account;
        private String customer;

        protected Builder() {
        }

        public String getAccount() {
            return this.account;
        }

        public String getCustomer() {
            return this.customer;
        }

        public Builder setAccount(String account) {
            this.account = account;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        private Builder(CustomerName customerName) {
            this.account = customerName.account;
            this.customer = customerName.customer;
        }

        public CustomerName build() {
            return new CustomerName(this);
        }
    }
}

