/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.channel.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ChannelPartnerLinkName
implements ResourceName {
    private static final PathTemplate ACCOUNT_CHANNEL_PARTNER_LINK = PathTemplate.createWithoutUrlEncoding((String)"accounts/{account}/channelPartnerLinks/{channel_partner_link}");
    private volatile Map<String, String> fieldValuesMap;
    private final String account;
    private final String channelPartnerLink;

    @Deprecated
    protected ChannelPartnerLinkName() {
        this.account = null;
        this.channelPartnerLink = null;
    }

    private ChannelPartnerLinkName(Builder builder) {
        this.account = (String)Preconditions.checkNotNull((Object)builder.getAccount());
        this.channelPartnerLink = (String)Preconditions.checkNotNull((Object)builder.getChannelPartnerLink());
    }

    public String getAccount() {
        return this.account;
    }

    public String getChannelPartnerLink() {
        return this.channelPartnerLink;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ChannelPartnerLinkName of(String account, String channelPartnerLink) {
        return ChannelPartnerLinkName.newBuilder().setAccount(account).setChannelPartnerLink(channelPartnerLink).build();
    }

    public static String format(String account, String channelPartnerLink) {
        return ChannelPartnerLinkName.newBuilder().setAccount(account).setChannelPartnerLink(channelPartnerLink).build().toString();
    }

    public static ChannelPartnerLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ACCOUNT_CHANNEL_PARTNER_LINK.validatedMatch(formattedString, "ChannelPartnerLinkName.parse: formattedString not in valid format");
        return ChannelPartnerLinkName.of((String)matchMap.get("account"), (String)matchMap.get("channel_partner_link"));
    }

    public static List<ChannelPartnerLinkName> parseList(List<String> formattedStrings) {
        ArrayList<ChannelPartnerLinkName> list = new ArrayList<ChannelPartnerLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ChannelPartnerLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ChannelPartnerLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ChannelPartnerLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ACCOUNT_CHANNEL_PARTNER_LINK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ChannelPartnerLinkName channelPartnerLinkName = this;
            synchronized (channelPartnerLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.account != null) {
                        fieldMapBuilder.put((Object)"account", (Object)this.account);
                    }
                    if (this.channelPartnerLink != null) {
                        fieldMapBuilder.put((Object)"channel_partner_link", (Object)this.channelPartnerLink);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ACCOUNT_CHANNEL_PARTNER_LINK.instantiate(new String[]{"account", this.account, "channel_partner_link", this.channelPartnerLink});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ChannelPartnerLinkName that = (ChannelPartnerLinkName)o;
            return Objects.equals(this.account, that.account) && Objects.equals(this.channelPartnerLink, that.channelPartnerLink);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.account);
        h *= 1000003;
        return h ^= Objects.hashCode(this.channelPartnerLink);
    }

    public static class Builder {
        private String account;
        private String channelPartnerLink;

        protected Builder() {
        }

        public String getAccount() {
            return this.account;
        }

        public String getChannelPartnerLink() {
            return this.channelPartnerLink;
        }

        public Builder setAccount(String account) {
            this.account = account;
            return this;
        }

        public Builder setChannelPartnerLink(String channelPartnerLink) {
            this.channelPartnerLink = channelPartnerLink;
            return this;
        }

        private Builder(ChannelPartnerLinkName channelPartnerLinkName) {
            this.account = channelPartnerLinkName.account;
            this.channelPartnerLink = channelPartnerLinkName.channelPartnerLink;
        }

        public ChannelPartnerLinkName build() {
            return new ChannelPartnerLinkName(this);
        }
    }
}

