/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/action_status.proto

// Protobuf Java Version: 3.25.4
package com.google.chat.v1;

/**
 *
 *
 * <pre>
 * Represents the status for a request to either invoke or submit a
 * [dialog](https://developers.google.com/workspace/chat/dialogs).
 * </pre>
 *
 * Protobuf type {@code google.chat.v1.ActionStatus}
 */
public final class ActionStatus extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.ActionStatus)
    ActionStatusOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ActionStatus.newBuilder() to construct.
  private ActionStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ActionStatus() {
    statusCode_ = 0;
    userFacingMessage_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ActionStatus();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.ActionStatusProto
        .internal_static_google_chat_v1_ActionStatus_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.ActionStatusProto
        .internal_static_google_chat_v1_ActionStatus_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.ActionStatus.class, com.google.chat.v1.ActionStatus.Builder.class);
  }

  public static final int STATUS_CODE_FIELD_NUMBER = 1;
  private int statusCode_ = 0;
  /**
   *
   *
   * <pre>
   * The status code.
   * </pre>
   *
   * <code>.google.rpc.Code status_code = 1;</code>
   *
   * @return The enum numeric value on the wire for statusCode.
   */
  @java.lang.Override
  public int getStatusCodeValue() {
    return statusCode_;
  }
  /**
   *
   *
   * <pre>
   * The status code.
   * </pre>
   *
   * <code>.google.rpc.Code status_code = 1;</code>
   *
   * @return The statusCode.
   */
  @java.lang.Override
  public com.google.rpc.Code getStatusCode() {
    com.google.rpc.Code result = com.google.rpc.Code.forNumber(statusCode_);
    return result == null ? com.google.rpc.Code.UNRECOGNIZED : result;
  }

  public static final int USER_FACING_MESSAGE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object userFacingMessage_ = "";
  /**
   *
   *
   * <pre>
   * The message to send users about the status of their request.
   * If unset, a generic message based on the `status_code` is sent.
   * </pre>
   *
   * <code>string user_facing_message = 2;</code>
   *
   * @return The userFacingMessage.
   */
  @java.lang.Override
  public java.lang.String getUserFacingMessage() {
    java.lang.Object ref = userFacingMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userFacingMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The message to send users about the status of their request.
   * If unset, a generic message based on the `status_code` is sent.
   * </pre>
   *
   * <code>string user_facing_message = 2;</code>
   *
   * @return The bytes for userFacingMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserFacingMessageBytes() {
    java.lang.Object ref = userFacingMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userFacingMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (statusCode_ != com.google.rpc.Code.OK.getNumber()) {
      output.writeEnum(1, statusCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userFacingMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, userFacingMessage_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (statusCode_ != com.google.rpc.Code.OK.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, statusCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userFacingMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, userFacingMessage_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.ActionStatus)) {
      return super.equals(obj);
    }
    com.google.chat.v1.ActionStatus other = (com.google.chat.v1.ActionStatus) obj;

    if (statusCode_ != other.statusCode_) return false;
    if (!getUserFacingMessage().equals(other.getUserFacingMessage())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + STATUS_CODE_FIELD_NUMBER;
    hash = (53 * hash) + statusCode_;
    hash = (37 * hash) + USER_FACING_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getUserFacingMessage().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.ActionStatus parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.ActionStatus parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.ActionStatus parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.ActionStatus parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.ActionStatus parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.ActionStatus parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.ActionStatus parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.ActionStatus parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.ActionStatus parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.ActionStatus parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.ActionStatus parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.ActionStatus parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.ActionStatus prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the status for a request to either invoke or submit a
   * [dialog](https://developers.google.com/workspace/chat/dialogs).
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.ActionStatus}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.ActionStatus)
      com.google.chat.v1.ActionStatusOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.ActionStatusProto
          .internal_static_google_chat_v1_ActionStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.ActionStatusProto
          .internal_static_google_chat_v1_ActionStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.ActionStatus.class, com.google.chat.v1.ActionStatus.Builder.class);
    }

    // Construct using com.google.chat.v1.ActionStatus.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      statusCode_ = 0;
      userFacingMessage_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.ActionStatusProto
          .internal_static_google_chat_v1_ActionStatus_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.ActionStatus getDefaultInstanceForType() {
      return com.google.chat.v1.ActionStatus.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.ActionStatus build() {
      com.google.chat.v1.ActionStatus result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.ActionStatus buildPartial() {
      com.google.chat.v1.ActionStatus result = new com.google.chat.v1.ActionStatus(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.chat.v1.ActionStatus result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.statusCode_ = statusCode_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.userFacingMessage_ = userFacingMessage_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.ActionStatus) {
        return mergeFrom((com.google.chat.v1.ActionStatus) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.ActionStatus other) {
      if (other == com.google.chat.v1.ActionStatus.getDefaultInstance()) return this;
      if (other.statusCode_ != 0) {
        setStatusCodeValue(other.getStatusCodeValue());
      }
      if (!other.getUserFacingMessage().isEmpty()) {
        userFacingMessage_ = other.userFacingMessage_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                statusCode_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                userFacingMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int statusCode_ = 0;
    /**
     *
     *
     * <pre>
     * The status code.
     * </pre>
     *
     * <code>.google.rpc.Code status_code = 1;</code>
     *
     * @return The enum numeric value on the wire for statusCode.
     */
    @java.lang.Override
    public int getStatusCodeValue() {
      return statusCode_;
    }
    /**
     *
     *
     * <pre>
     * The status code.
     * </pre>
     *
     * <code>.google.rpc.Code status_code = 1;</code>
     *
     * @param value The enum numeric value on the wire for statusCode to set.
     * @return This builder for chaining.
     */
    public Builder setStatusCodeValue(int value) {
      statusCode_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The status code.
     * </pre>
     *
     * <code>.google.rpc.Code status_code = 1;</code>
     *
     * @return The statusCode.
     */
    @java.lang.Override
    public com.google.rpc.Code getStatusCode() {
      com.google.rpc.Code result = com.google.rpc.Code.forNumber(statusCode_);
      return result == null ? com.google.rpc.Code.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The status code.
     * </pre>
     *
     * <code>.google.rpc.Code status_code = 1;</code>
     *
     * @param value The statusCode to set.
     * @return This builder for chaining.
     */
    public Builder setStatusCode(com.google.rpc.Code value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      statusCode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The status code.
     * </pre>
     *
     * <code>.google.rpc.Code status_code = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatusCode() {
      bitField0_ = (bitField0_ & ~0x00000001);
      statusCode_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object userFacingMessage_ = "";
    /**
     *
     *
     * <pre>
     * The message to send users about the status of their request.
     * If unset, a generic message based on the `status_code` is sent.
     * </pre>
     *
     * <code>string user_facing_message = 2;</code>
     *
     * @return The userFacingMessage.
     */
    public java.lang.String getUserFacingMessage() {
      java.lang.Object ref = userFacingMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userFacingMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The message to send users about the status of their request.
     * If unset, a generic message based on the `status_code` is sent.
     * </pre>
     *
     * <code>string user_facing_message = 2;</code>
     *
     * @return The bytes for userFacingMessage.
     */
    public com.google.protobuf.ByteString getUserFacingMessageBytes() {
      java.lang.Object ref = userFacingMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        userFacingMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The message to send users about the status of their request.
     * If unset, a generic message based on the `status_code` is sent.
     * </pre>
     *
     * <code>string user_facing_message = 2;</code>
     *
     * @param value The userFacingMessage to set.
     * @return This builder for chaining.
     */
    public Builder setUserFacingMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      userFacingMessage_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The message to send users about the status of their request.
     * If unset, a generic message based on the `status_code` is sent.
     * </pre>
     *
     * <code>string user_facing_message = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserFacingMessage() {
      userFacingMessage_ = getDefaultInstance().getUserFacingMessage();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The message to send users about the status of their request.
     * If unset, a generic message based on the `status_code` is sent.
     * </pre>
     *
     * <code>string user_facing_message = 2;</code>
     *
     * @param value The bytes for userFacingMessage to set.
     * @return This builder for chaining.
     */
    public Builder setUserFacingMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      userFacingMessage_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.ActionStatus)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.ActionStatus)
  private static final com.google.chat.v1.ActionStatus DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.ActionStatus();
  }

  public static com.google.chat.v1.ActionStatus getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ActionStatus> PARSER =
      new com.google.protobuf.AbstractParser<ActionStatus>() {
        @java.lang.Override
        public ActionStatus parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ActionStatus> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ActionStatus> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.ActionStatus getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
