/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/message.proto

// Protobuf Java Version: 3.25.4
package com.google.chat.v1;

/**
 *
 *
 * <pre>
 * Creates a message.
 * </pre>
 *
 * Protobuf type {@code google.chat.v1.CreateMessageRequest}
 */
public final class CreateMessageRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.CreateMessageRequest)
    CreateMessageRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreateMessageRequest.newBuilder() to construct.
  private CreateMessageRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateMessageRequest() {
    parent_ = "";
    threadKey_ = "";
    requestId_ = "";
    messageReplyOption_ = 0;
    messageId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateMessageRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.MessageProto
        .internal_static_google_chat_v1_CreateMessageRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.MessageProto
        .internal_static_google_chat_v1_CreateMessageRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.CreateMessageRequest.class,
            com.google.chat.v1.CreateMessageRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies how to reply to a message.
   * More states might be added in the future.
   * </pre>
   *
   * Protobuf enum {@code google.chat.v1.CreateMessageRequest.MessageReplyOption}
   */
  public enum MessageReplyOption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default. Starts a new thread. Using this option ignores any [thread
     * ID][google.chat.v1.Thread.name] or
     * [`thread_key`][google.chat.v1.Thread.thread_key] that's included.
     * </pre>
     *
     * <code>MESSAGE_REPLY_OPTION_UNSPECIFIED = 0;</code>
     */
    MESSAGE_REPLY_OPTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Creates the message as a reply to the thread specified by [thread
     * ID][google.chat.v1.Thread.name] or
     * [`thread_key`][google.chat.v1.Thread.thread_key]. If it fails, the
     * message starts a new thread instead.
     * </pre>
     *
     * <code>REPLY_MESSAGE_FALLBACK_TO_NEW_THREAD = 1;</code>
     */
    REPLY_MESSAGE_FALLBACK_TO_NEW_THREAD(1),
    /**
     *
     *
     * <pre>
     * Creates the message as a reply to the thread specified by [thread
     * ID][google.chat.v1.Thread.name] or
     * [`thread_key`][google.chat.v1.Thread.thread_key]. If a new `thread_key`
     * is used, a new thread is created. If the message creation fails, a
     * `NOT_FOUND` error is returned instead.
     * </pre>
     *
     * <code>REPLY_MESSAGE_OR_FAIL = 2;</code>
     */
    REPLY_MESSAGE_OR_FAIL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default. Starts a new thread. Using this option ignores any [thread
     * ID][google.chat.v1.Thread.name] or
     * [`thread_key`][google.chat.v1.Thread.thread_key] that's included.
     * </pre>
     *
     * <code>MESSAGE_REPLY_OPTION_UNSPECIFIED = 0;</code>
     */
    public static final int MESSAGE_REPLY_OPTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Creates the message as a reply to the thread specified by [thread
     * ID][google.chat.v1.Thread.name] or
     * [`thread_key`][google.chat.v1.Thread.thread_key]. If it fails, the
     * message starts a new thread instead.
     * </pre>
     *
     * <code>REPLY_MESSAGE_FALLBACK_TO_NEW_THREAD = 1;</code>
     */
    public static final int REPLY_MESSAGE_FALLBACK_TO_NEW_THREAD_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Creates the message as a reply to the thread specified by [thread
     * ID][google.chat.v1.Thread.name] or
     * [`thread_key`][google.chat.v1.Thread.thread_key]. If a new `thread_key`
     * is used, a new thread is created. If the message creation fails, a
     * `NOT_FOUND` error is returned instead.
     * </pre>
     *
     * <code>REPLY_MESSAGE_OR_FAIL = 2;</code>
     */
    public static final int REPLY_MESSAGE_OR_FAIL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MessageReplyOption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MessageReplyOption forNumber(int value) {
      switch (value) {
        case 0:
          return MESSAGE_REPLY_OPTION_UNSPECIFIED;
        case 1:
          return REPLY_MESSAGE_FALLBACK_TO_NEW_THREAD;
        case 2:
          return REPLY_MESSAGE_OR_FAIL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MessageReplyOption>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MessageReplyOption>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<MessageReplyOption>() {
              public MessageReplyOption findValueByNumber(int number) {
                return MessageReplyOption.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.chat.v1.CreateMessageRequest.getDescriptor().getEnumTypes().get(0);
    }

    private static final MessageReplyOption[] VALUES = values();

    public static MessageReplyOption valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MessageReplyOption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.chat.v1.CreateMessageRequest.MessageReplyOption)
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the space in which to create a message.
   *
   * Format: `spaces/{space}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the space in which to create a message.
   *
   * Format: `spaces/{space}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MESSAGE_FIELD_NUMBER = 4;
  private com.google.chat.v1.Message message_;
  /**
   *
   *
   * <pre>
   * Required. Message body.
   * </pre>
   *
   * <code>.google.chat.v1.Message message = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the message field is set.
   */
  @java.lang.Override
  public boolean hasMessage() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Message body.
   * </pre>
   *
   * <code>.google.chat.v1.Message message = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The message.
   */
  @java.lang.Override
  public com.google.chat.v1.Message getMessage() {
    return message_ == null ? com.google.chat.v1.Message.getDefaultInstance() : message_;
  }
  /**
   *
   *
   * <pre>
   * Required. Message body.
   * </pre>
   *
   * <code>.google.chat.v1.Message message = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public com.google.chat.v1.MessageOrBuilder getMessageOrBuilder() {
    return message_ == null ? com.google.chat.v1.Message.getDefaultInstance() : message_;
  }

  public static final int THREAD_KEY_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object threadKey_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Deprecated: Use
   * [thread.thread_key][google.chat.v1.Thread.thread_key] instead. ID for the
   * thread. Supports up to 4000 characters. To start or add to a thread, create
   * a message and specify a `threadKey` or the
   * [thread.name][google.chat.v1.Thread.name]. For example usage, see [Start or
   * reply to a message
   * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
   * </pre>
   *
   * <code>string thread_key = 6 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @deprecated google.chat.v1.CreateMessageRequest.thread_key is deprecated. See
   *     google/chat/v1/message.proto;l=503
   * @return The threadKey.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getThreadKey() {
    java.lang.Object ref = threadKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      threadKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Deprecated: Use
   * [thread.thread_key][google.chat.v1.Thread.thread_key] instead. ID for the
   * thread. Supports up to 4000 characters. To start or add to a thread, create
   * a message and specify a `threadKey` or the
   * [thread.name][google.chat.v1.Thread.name]. For example usage, see [Start or
   * reply to a message
   * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
   * </pre>
   *
   * <code>string thread_key = 6 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @deprecated google.chat.v1.CreateMessageRequest.thread_key is deprecated. See
   *     google/chat/v1/message.proto;l=503
   * @return The bytes for threadKey.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getThreadKeyBytes() {
    java.lang.Object ref = threadKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      threadKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A unique request ID for this message. Specifying an existing
   * request ID returns the message created with that ID instead of creating a
   * new message.
   * </pre>
   *
   * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A unique request ID for this message. Specifying an existing
   * request ID returns the message created with that ID instead of creating a
   * new message.
   * </pre>
   *
   * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MESSAGE_REPLY_OPTION_FIELD_NUMBER = 8;
  private int messageReplyOption_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Specifies whether a message starts a thread or replies to one.
   * Only supported in named spaces.
   * </pre>
   *
   * <code>
   * .google.chat.v1.CreateMessageRequest.MessageReplyOption message_reply_option = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for messageReplyOption.
   */
  @java.lang.Override
  public int getMessageReplyOptionValue() {
    return messageReplyOption_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies whether a message starts a thread or replies to one.
   * Only supported in named spaces.
   * </pre>
   *
   * <code>
   * .google.chat.v1.CreateMessageRequest.MessageReplyOption message_reply_option = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The messageReplyOption.
   */
  @java.lang.Override
  public com.google.chat.v1.CreateMessageRequest.MessageReplyOption getMessageReplyOption() {
    com.google.chat.v1.CreateMessageRequest.MessageReplyOption result =
        com.google.chat.v1.CreateMessageRequest.MessageReplyOption.forNumber(messageReplyOption_);
    return result == null
        ? com.google.chat.v1.CreateMessageRequest.MessageReplyOption.UNRECOGNIZED
        : result;
  }

  public static final int MESSAGE_ID_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object messageId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A custom ID for a message. Lets Chat apps get, update, or delete
   * a message without needing to store the system-assigned ID in the message's
   * resource name (represented in the message `name` field).
   *
   * The value for this field must meet the following requirements:
   *
   * * Begins with `client-`. For example, `client-custom-name` is a valid
   *   custom ID, but `custom-name` is not.
   * * Contains up to 63 characters and only lowercase letters, numbers, and
   *   hyphens.
   * * Is unique within a space. A Chat app can't use the same custom ID for
   * different messages.
   *
   * For details, see [Name a
   * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
   * </pre>
   *
   * <code>string message_id = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The messageId.
   */
  @java.lang.Override
  public java.lang.String getMessageId() {
    java.lang.Object ref = messageId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      messageId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A custom ID for a message. Lets Chat apps get, update, or delete
   * a message without needing to store the system-assigned ID in the message's
   * resource name (represented in the message `name` field).
   *
   * The value for this field must meet the following requirements:
   *
   * * Begins with `client-`. For example, `client-custom-name` is a valid
   *   custom ID, but `custom-name` is not.
   * * Contains up to 63 characters and only lowercase letters, numbers, and
   *   hyphens.
   * * Is unique within a space. A Chat app can't use the same custom ID for
   * different messages.
   *
   * For details, see [Name a
   * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
   * </pre>
   *
   * <code>string message_id = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for messageId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMessageIdBytes() {
    java.lang.Object ref = messageId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      messageId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getMessage());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(threadKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, threadKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, requestId_);
    }
    if (messageReplyOption_
        != com.google.chat.v1.CreateMessageRequest.MessageReplyOption
            .MESSAGE_REPLY_OPTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, messageReplyOption_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(messageId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, messageId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getMessage());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(threadKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, threadKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, requestId_);
    }
    if (messageReplyOption_
        != com.google.chat.v1.CreateMessageRequest.MessageReplyOption
            .MESSAGE_REPLY_OPTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, messageReplyOption_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(messageId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, messageId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.CreateMessageRequest)) {
      return super.equals(obj);
    }
    com.google.chat.v1.CreateMessageRequest other = (com.google.chat.v1.CreateMessageRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasMessage() != other.hasMessage()) return false;
    if (hasMessage()) {
      if (!getMessage().equals(other.getMessage())) return false;
    }
    if (!getThreadKey().equals(other.getThreadKey())) return false;
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (messageReplyOption_ != other.messageReplyOption_) return false;
    if (!getMessageId().equals(other.getMessageId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasMessage()) {
      hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getMessage().hashCode();
    }
    hash = (37 * hash) + THREAD_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getThreadKey().hashCode();
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (37 * hash) + MESSAGE_REPLY_OPTION_FIELD_NUMBER;
    hash = (53 * hash) + messageReplyOption_;
    hash = (37 * hash) + MESSAGE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getMessageId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.CreateMessageRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.CreateMessageRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.CreateMessageRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.CreateMessageRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.CreateMessageRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.CreateMessageRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.CreateMessageRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.CreateMessageRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.CreateMessageRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.CreateMessageRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.CreateMessageRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.CreateMessageRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.CreateMessageRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Creates a message.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.CreateMessageRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.CreateMessageRequest)
      com.google.chat.v1.CreateMessageRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.MessageProto
          .internal_static_google_chat_v1_CreateMessageRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.MessageProto
          .internal_static_google_chat_v1_CreateMessageRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.CreateMessageRequest.class,
              com.google.chat.v1.CreateMessageRequest.Builder.class);
    }

    // Construct using com.google.chat.v1.CreateMessageRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMessageFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      message_ = null;
      if (messageBuilder_ != null) {
        messageBuilder_.dispose();
        messageBuilder_ = null;
      }
      threadKey_ = "";
      requestId_ = "";
      messageReplyOption_ = 0;
      messageId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.MessageProto
          .internal_static_google_chat_v1_CreateMessageRequest_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.CreateMessageRequest getDefaultInstanceForType() {
      return com.google.chat.v1.CreateMessageRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.CreateMessageRequest build() {
      com.google.chat.v1.CreateMessageRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.CreateMessageRequest buildPartial() {
      com.google.chat.v1.CreateMessageRequest result =
          new com.google.chat.v1.CreateMessageRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.chat.v1.CreateMessageRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.message_ = messageBuilder_ == null ? message_ : messageBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.threadKey_ = threadKey_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.requestId_ = requestId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.messageReplyOption_ = messageReplyOption_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.messageId_ = messageId_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.CreateMessageRequest) {
        return mergeFrom((com.google.chat.v1.CreateMessageRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.CreateMessageRequest other) {
      if (other == com.google.chat.v1.CreateMessageRequest.getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasMessage()) {
        mergeMessage(other.getMessage());
      }
      if (!other.getThreadKey().isEmpty()) {
        threadKey_ = other.threadKey_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.messageReplyOption_ != 0) {
        setMessageReplyOptionValue(other.getMessageReplyOptionValue());
      }
      if (!other.getMessageId().isEmpty()) {
        messageId_ = other.messageId_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 34:
              {
                input.readMessage(getMessageFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 34
            case 50:
              {
                threadKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 50
            case 58:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 58
            case 64:
              {
                messageReplyOption_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 64
            case 74:
              {
                messageId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the space in which to create a message.
     *
     * Format: `spaces/{space}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the space in which to create a message.
     *
     * Format: `spaces/{space}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the space in which to create a message.
     *
     * Format: `spaces/{space}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the space in which to create a message.
     *
     * Format: `spaces/{space}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the space in which to create a message.
     *
     * Format: `spaces/{space}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.chat.v1.Message message_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Message,
            com.google.chat.v1.Message.Builder,
            com.google.chat.v1.MessageOrBuilder>
        messageBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Message body.
     * </pre>
     *
     * <code>.google.chat.v1.Message message = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the message field is set.
     */
    public boolean hasMessage() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Message body.
     * </pre>
     *
     * <code>.google.chat.v1.Message message = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The message.
     */
    public com.google.chat.v1.Message getMessage() {
      if (messageBuilder_ == null) {
        return message_ == null ? com.google.chat.v1.Message.getDefaultInstance() : message_;
      } else {
        return messageBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Message body.
     * </pre>
     *
     * <code>.google.chat.v1.Message message = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setMessage(com.google.chat.v1.Message value) {
      if (messageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        message_ = value;
      } else {
        messageBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Message body.
     * </pre>
     *
     * <code>.google.chat.v1.Message message = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setMessage(com.google.chat.v1.Message.Builder builderForValue) {
      if (messageBuilder_ == null) {
        message_ = builderForValue.build();
      } else {
        messageBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Message body.
     * </pre>
     *
     * <code>.google.chat.v1.Message message = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder mergeMessage(com.google.chat.v1.Message value) {
      if (messageBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && message_ != null
            && message_ != com.google.chat.v1.Message.getDefaultInstance()) {
          getMessageBuilder().mergeFrom(value);
        } else {
          message_ = value;
        }
      } else {
        messageBuilder_.mergeFrom(value);
      }
      if (message_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Message body.
     * </pre>
     *
     * <code>.google.chat.v1.Message message = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder clearMessage() {
      bitField0_ = (bitField0_ & ~0x00000002);
      message_ = null;
      if (messageBuilder_ != null) {
        messageBuilder_.dispose();
        messageBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Message body.
     * </pre>
     *
     * <code>.google.chat.v1.Message message = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.chat.v1.Message.Builder getMessageBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getMessageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Message body.
     * </pre>
     *
     * <code>.google.chat.v1.Message message = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.chat.v1.MessageOrBuilder getMessageOrBuilder() {
      if (messageBuilder_ != null) {
        return messageBuilder_.getMessageOrBuilder();
      } else {
        return message_ == null ? com.google.chat.v1.Message.getDefaultInstance() : message_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Message body.
     * </pre>
     *
     * <code>.google.chat.v1.Message message = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Message,
            com.google.chat.v1.Message.Builder,
            com.google.chat.v1.MessageOrBuilder>
        getMessageFieldBuilder() {
      if (messageBuilder_ == null) {
        messageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.Message,
                com.google.chat.v1.Message.Builder,
                com.google.chat.v1.MessageOrBuilder>(
                getMessage(), getParentForChildren(), isClean());
        message_ = null;
      }
      return messageBuilder_;
    }

    private java.lang.Object threadKey_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Deprecated: Use
     * [thread.thread_key][google.chat.v1.Thread.thread_key] instead. ID for the
     * thread. Supports up to 4000 characters. To start or add to a thread, create
     * a message and specify a `threadKey` or the
     * [thread.name][google.chat.v1.Thread.name]. For example usage, see [Start or
     * reply to a message
     * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
     * </pre>
     *
     * <code>string thread_key = 6 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.chat.v1.CreateMessageRequest.thread_key is deprecated. See
     *     google/chat/v1/message.proto;l=503
     * @return The threadKey.
     */
    @java.lang.Deprecated
    public java.lang.String getThreadKey() {
      java.lang.Object ref = threadKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        threadKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Deprecated: Use
     * [thread.thread_key][google.chat.v1.Thread.thread_key] instead. ID for the
     * thread. Supports up to 4000 characters. To start or add to a thread, create
     * a message and specify a `threadKey` or the
     * [thread.name][google.chat.v1.Thread.name]. For example usage, see [Start or
     * reply to a message
     * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
     * </pre>
     *
     * <code>string thread_key = 6 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.chat.v1.CreateMessageRequest.thread_key is deprecated. See
     *     google/chat/v1/message.proto;l=503
     * @return The bytes for threadKey.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getThreadKeyBytes() {
      java.lang.Object ref = threadKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        threadKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Deprecated: Use
     * [thread.thread_key][google.chat.v1.Thread.thread_key] instead. ID for the
     * thread. Supports up to 4000 characters. To start or add to a thread, create
     * a message and specify a `threadKey` or the
     * [thread.name][google.chat.v1.Thread.name]. For example usage, see [Start or
     * reply to a message
     * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
     * </pre>
     *
     * <code>string thread_key = 6 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.chat.v1.CreateMessageRequest.thread_key is deprecated. See
     *     google/chat/v1/message.proto;l=503
     * @param value The threadKey to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setThreadKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      threadKey_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deprecated: Use
     * [thread.thread_key][google.chat.v1.Thread.thread_key] instead. ID for the
     * thread. Supports up to 4000 characters. To start or add to a thread, create
     * a message and specify a `threadKey` or the
     * [thread.name][google.chat.v1.Thread.name]. For example usage, see [Start or
     * reply to a message
     * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
     * </pre>
     *
     * <code>string thread_key = 6 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.chat.v1.CreateMessageRequest.thread_key is deprecated. See
     *     google/chat/v1/message.proto;l=503
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearThreadKey() {
      threadKey_ = getDefaultInstance().getThreadKey();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deprecated: Use
     * [thread.thread_key][google.chat.v1.Thread.thread_key] instead. ID for the
     * thread. Supports up to 4000 characters. To start or add to a thread, create
     * a message and specify a `threadKey` or the
     * [thread.name][google.chat.v1.Thread.name]. For example usage, see [Start or
     * reply to a message
     * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
     * </pre>
     *
     * <code>string thread_key = 6 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.chat.v1.CreateMessageRequest.thread_key is deprecated. See
     *     google/chat/v1/message.proto;l=503
     * @param value The bytes for threadKey to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setThreadKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      threadKey_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A unique request ID for this message. Specifying an existing
     * request ID returns the message created with that ID instead of creating a
     * new message.
     * </pre>
     *
     * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique request ID for this message. Specifying an existing
     * request ID returns the message created with that ID instead of creating a
     * new message.
     * </pre>
     *
     * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique request ID for this message. Specifying an existing
     * request ID returns the message created with that ID instead of creating a
     * new message.
     * </pre>
     *
     * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique request ID for this message. Specifying an existing
     * request ID returns the message created with that ID instead of creating a
     * new message.
     * </pre>
     *
     * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique request ID for this message. Specifying an existing
     * request ID returns the message created with that ID instead of creating a
     * new message.
     * </pre>
     *
     * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int messageReplyOption_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Specifies whether a message starts a thread or replies to one.
     * Only supported in named spaces.
     * </pre>
     *
     * <code>
     * .google.chat.v1.CreateMessageRequest.MessageReplyOption message_reply_option = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for messageReplyOption.
     */
    @java.lang.Override
    public int getMessageReplyOptionValue() {
      return messageReplyOption_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies whether a message starts a thread or replies to one.
     * Only supported in named spaces.
     * </pre>
     *
     * <code>
     * .google.chat.v1.CreateMessageRequest.MessageReplyOption message_reply_option = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for messageReplyOption to set.
     * @return This builder for chaining.
     */
    public Builder setMessageReplyOptionValue(int value) {
      messageReplyOption_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies whether a message starts a thread or replies to one.
     * Only supported in named spaces.
     * </pre>
     *
     * <code>
     * .google.chat.v1.CreateMessageRequest.MessageReplyOption message_reply_option = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The messageReplyOption.
     */
    @java.lang.Override
    public com.google.chat.v1.CreateMessageRequest.MessageReplyOption getMessageReplyOption() {
      com.google.chat.v1.CreateMessageRequest.MessageReplyOption result =
          com.google.chat.v1.CreateMessageRequest.MessageReplyOption.forNumber(messageReplyOption_);
      return result == null
          ? com.google.chat.v1.CreateMessageRequest.MessageReplyOption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies whether a message starts a thread or replies to one.
     * Only supported in named spaces.
     * </pre>
     *
     * <code>
     * .google.chat.v1.CreateMessageRequest.MessageReplyOption message_reply_option = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The messageReplyOption to set.
     * @return This builder for chaining.
     */
    public Builder setMessageReplyOption(
        com.google.chat.v1.CreateMessageRequest.MessageReplyOption value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      messageReplyOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies whether a message starts a thread or replies to one.
     * Only supported in named spaces.
     * </pre>
     *
     * <code>
     * .google.chat.v1.CreateMessageRequest.MessageReplyOption message_reply_option = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMessageReplyOption() {
      bitField0_ = (bitField0_ & ~0x00000010);
      messageReplyOption_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object messageId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A custom ID for a message. Lets Chat apps get, update, or delete
     * a message without needing to store the system-assigned ID in the message's
     * resource name (represented in the message `name` field).
     *
     * The value for this field must meet the following requirements:
     *
     * * Begins with `client-`. For example, `client-custom-name` is a valid
     *   custom ID, but `custom-name` is not.
     * * Contains up to 63 characters and only lowercase letters, numbers, and
     *   hyphens.
     * * Is unique within a space. A Chat app can't use the same custom ID for
     * different messages.
     *
     * For details, see [Name a
     * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     * </pre>
     *
     * <code>string message_id = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The messageId.
     */
    public java.lang.String getMessageId() {
      java.lang.Object ref = messageId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        messageId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A custom ID for a message. Lets Chat apps get, update, or delete
     * a message without needing to store the system-assigned ID in the message's
     * resource name (represented in the message `name` field).
     *
     * The value for this field must meet the following requirements:
     *
     * * Begins with `client-`. For example, `client-custom-name` is a valid
     *   custom ID, but `custom-name` is not.
     * * Contains up to 63 characters and only lowercase letters, numbers, and
     *   hyphens.
     * * Is unique within a space. A Chat app can't use the same custom ID for
     * different messages.
     *
     * For details, see [Name a
     * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     * </pre>
     *
     * <code>string message_id = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for messageId.
     */
    public com.google.protobuf.ByteString getMessageIdBytes() {
      java.lang.Object ref = messageId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        messageId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A custom ID for a message. Lets Chat apps get, update, or delete
     * a message without needing to store the system-assigned ID in the message's
     * resource name (represented in the message `name` field).
     *
     * The value for this field must meet the following requirements:
     *
     * * Begins with `client-`. For example, `client-custom-name` is a valid
     *   custom ID, but `custom-name` is not.
     * * Contains up to 63 characters and only lowercase letters, numbers, and
     *   hyphens.
     * * Is unique within a space. A Chat app can't use the same custom ID for
     * different messages.
     *
     * For details, see [Name a
     * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     * </pre>
     *
     * <code>string message_id = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The messageId to set.
     * @return This builder for chaining.
     */
    public Builder setMessageId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      messageId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A custom ID for a message. Lets Chat apps get, update, or delete
     * a message without needing to store the system-assigned ID in the message's
     * resource name (represented in the message `name` field).
     *
     * The value for this field must meet the following requirements:
     *
     * * Begins with `client-`. For example, `client-custom-name` is a valid
     *   custom ID, but `custom-name` is not.
     * * Contains up to 63 characters and only lowercase letters, numbers, and
     *   hyphens.
     * * Is unique within a space. A Chat app can't use the same custom ID for
     * different messages.
     *
     * For details, see [Name a
     * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     * </pre>
     *
     * <code>string message_id = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMessageId() {
      messageId_ = getDefaultInstance().getMessageId();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A custom ID for a message. Lets Chat apps get, update, or delete
     * a message without needing to store the system-assigned ID in the message's
     * resource name (represented in the message `name` field).
     *
     * The value for this field must meet the following requirements:
     *
     * * Begins with `client-`. For example, `client-custom-name` is a valid
     *   custom ID, but `custom-name` is not.
     * * Contains up to 63 characters and only lowercase letters, numbers, and
     *   hyphens.
     * * Is unique within a space. A Chat app can't use the same custom ID for
     * different messages.
     *
     * For details, see [Name a
     * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     * </pre>
     *
     * <code>string message_id = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for messageId to set.
     * @return This builder for chaining.
     */
    public Builder setMessageIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      messageId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.CreateMessageRequest)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.CreateMessageRequest)
  private static final com.google.chat.v1.CreateMessageRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.CreateMessageRequest();
  }

  public static com.google.chat.v1.CreateMessageRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateMessageRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateMessageRequest>() {
        @java.lang.Override
        public CreateMessageRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateMessageRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateMessageRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.CreateMessageRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
