/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/message.proto

// Protobuf Java Version: 3.25.4
package com.google.chat.v1;

public interface CreateMessageRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.chat.v1.CreateMessageRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The resource name of the space in which to create a message.
   *
   * Format: `spaces/{space}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();
  /**
   *
   *
   * <pre>
   * Required. The resource name of the space in which to create a message.
   *
   * Format: `spaces/{space}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Required. Message body.
   * </pre>
   *
   * <code>.google.chat.v1.Message message = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the message field is set.
   */
  boolean hasMessage();
  /**
   *
   *
   * <pre>
   * Required. Message body.
   * </pre>
   *
   * <code>.google.chat.v1.Message message = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The message.
   */
  com.google.chat.v1.Message getMessage();
  /**
   *
   *
   * <pre>
   * Required. Message body.
   * </pre>
   *
   * <code>.google.chat.v1.Message message = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  com.google.chat.v1.MessageOrBuilder getMessageOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Deprecated: Use
   * [thread.thread_key][google.chat.v1.Thread.thread_key] instead. ID for the
   * thread. Supports up to 4000 characters. To start or add to a thread, create
   * a message and specify a `threadKey` or the
   * [thread.name][google.chat.v1.Thread.name]. For example usage, see [Start or
   * reply to a message
   * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
   * </pre>
   *
   * <code>string thread_key = 6 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @deprecated google.chat.v1.CreateMessageRequest.thread_key is deprecated. See
   *     google/chat/v1/message.proto;l=503
   * @return The threadKey.
   */
  @java.lang.Deprecated
  java.lang.String getThreadKey();
  /**
   *
   *
   * <pre>
   * Optional. Deprecated: Use
   * [thread.thread_key][google.chat.v1.Thread.thread_key] instead. ID for the
   * thread. Supports up to 4000 characters. To start or add to a thread, create
   * a message and specify a `threadKey` or the
   * [thread.name][google.chat.v1.Thread.name]. For example usage, see [Start or
   * reply to a message
   * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
   * </pre>
   *
   * <code>string thread_key = 6 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @deprecated google.chat.v1.CreateMessageRequest.thread_key is deprecated. See
   *     google/chat/v1/message.proto;l=503
   * @return The bytes for threadKey.
   */
  @java.lang.Deprecated
  com.google.protobuf.ByteString getThreadKeyBytes();

  /**
   *
   *
   * <pre>
   * Optional. A unique request ID for this message. Specifying an existing
   * request ID returns the message created with that ID instead of creating a
   * new message.
   * </pre>
   *
   * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestId.
   */
  java.lang.String getRequestId();
  /**
   *
   *
   * <pre>
   * Optional. A unique request ID for this message. Specifying an existing
   * request ID returns the message created with that ID instead of creating a
   * new message.
   * </pre>
   *
   * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestId.
   */
  com.google.protobuf.ByteString getRequestIdBytes();

  /**
   *
   *
   * <pre>
   * Optional. Specifies whether a message starts a thread or replies to one.
   * Only supported in named spaces.
   * </pre>
   *
   * <code>
   * .google.chat.v1.CreateMessageRequest.MessageReplyOption message_reply_option = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for messageReplyOption.
   */
  int getMessageReplyOptionValue();
  /**
   *
   *
   * <pre>
   * Optional. Specifies whether a message starts a thread or replies to one.
   * Only supported in named spaces.
   * </pre>
   *
   * <code>
   * .google.chat.v1.CreateMessageRequest.MessageReplyOption message_reply_option = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The messageReplyOption.
   */
  com.google.chat.v1.CreateMessageRequest.MessageReplyOption getMessageReplyOption();

  /**
   *
   *
   * <pre>
   * Optional. A custom ID for a message. Lets Chat apps get, update, or delete
   * a message without needing to store the system-assigned ID in the message's
   * resource name (represented in the message `name` field).
   *
   * The value for this field must meet the following requirements:
   *
   * * Begins with `client-`. For example, `client-custom-name` is a valid
   *   custom ID, but `custom-name` is not.
   * * Contains up to 63 characters and only lowercase letters, numbers, and
   *   hyphens.
   * * Is unique within a space. A Chat app can't use the same custom ID for
   * different messages.
   *
   * For details, see [Name a
   * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
   * </pre>
   *
   * <code>string message_id = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The messageId.
   */
  java.lang.String getMessageId();
  /**
   *
   *
   * <pre>
   * Optional. A custom ID for a message. Lets Chat apps get, update, or delete
   * a message without needing to store the system-assigned ID in the message's
   * resource name (represented in the message `name` field).
   *
   * The value for this field must meet the following requirements:
   *
   * * Begins with `client-`. For example, `client-custom-name` is a valid
   *   custom ID, but `custom-name` is not.
   * * Contains up to 63 characters and only lowercase letters, numbers, and
   *   hyphens.
   * * Is unique within a space. A Chat app can't use the same custom ID for
   * different messages.
   *
   * For details, see [Name a
   * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
   * </pre>
   *
   * <code>string message_id = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for messageId.
   */
  com.google.protobuf.ByteString getMessageIdBytes();
}
