/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/space.proto

// Protobuf Java Version: 3.25.4
package com.google.chat.v1;

/**
 *
 *
 * <pre>
 * A request to create a named space.
 * </pre>
 *
 * Protobuf type {@code google.chat.v1.CreateSpaceRequest}
 */
public final class CreateSpaceRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.CreateSpaceRequest)
    CreateSpaceRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreateSpaceRequest.newBuilder() to construct.
  private CreateSpaceRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateSpaceRequest() {
    requestId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateSpaceRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.SpaceProto
        .internal_static_google_chat_v1_CreateSpaceRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.SpaceProto
        .internal_static_google_chat_v1_CreateSpaceRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.CreateSpaceRequest.class,
            com.google.chat.v1.CreateSpaceRequest.Builder.class);
  }

  private int bitField0_;
  public static final int SPACE_FIELD_NUMBER = 1;
  private com.google.chat.v1.Space space_;
  /**
   *
   *
   * <pre>
   * Required. The `displayName` and `spaceType` fields must be populated.  Only
   * `SpaceType.SPACE` is supported.
   *
   * If you receive the error message `ALREADY_EXISTS` when creating a space,
   * try a different `displayName`. An existing space within the Google
   * Workspace organization might already use this display name.
   *
   * The space `name` is assigned on the server so anything specified in this
   * field will be ignored.
   * </pre>
   *
   * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the space field is set.
   */
  @java.lang.Override
  public boolean hasSpace() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The `displayName` and `spaceType` fields must be populated.  Only
   * `SpaceType.SPACE` is supported.
   *
   * If you receive the error message `ALREADY_EXISTS` when creating a space,
   * try a different `displayName`. An existing space within the Google
   * Workspace organization might already use this display name.
   *
   * The space `name` is assigned on the server so anything specified in this
   * field will be ignored.
   * </pre>
   *
   * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The space.
   */
  @java.lang.Override
  public com.google.chat.v1.Space getSpace() {
    return space_ == null ? com.google.chat.v1.Space.getDefaultInstance() : space_;
  }
  /**
   *
   *
   * <pre>
   * Required. The `displayName` and `spaceType` fields must be populated.  Only
   * `SpaceType.SPACE` is supported.
   *
   * If you receive the error message `ALREADY_EXISTS` when creating a space,
   * try a different `displayName`. An existing space within the Google
   * Workspace organization might already use this display name.
   *
   * The space `name` is assigned on the server so anything specified in this
   * field will be ignored.
   * </pre>
   *
   * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public com.google.chat.v1.SpaceOrBuilder getSpaceOrBuilder() {
    return space_ == null ? com.google.chat.v1.Space.getDefaultInstance() : space_;
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for this request.
   * A random UUID is recommended.
   * Specifying an existing request ID returns the space created with that ID
   * instead of creating a new space.
   * Specifying an existing request ID from the same Chat app with a different
   * authenticated user returns an error.
   * </pre>
   *
   * <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for this request.
   * A random UUID is recommended.
   * Specifying an existing request ID returns the space created with that ID
   * instead of creating a new space.
   * Specifying an existing request ID from the same Chat app with a different
   * authenticated user returns an error.
   * </pre>
   *
   * <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getSpace());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, requestId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSpace());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, requestId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.CreateSpaceRequest)) {
      return super.equals(obj);
    }
    com.google.chat.v1.CreateSpaceRequest other = (com.google.chat.v1.CreateSpaceRequest) obj;

    if (hasSpace() != other.hasSpace()) return false;
    if (hasSpace()) {
      if (!getSpace().equals(other.getSpace())) return false;
    }
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasSpace()) {
      hash = (37 * hash) + SPACE_FIELD_NUMBER;
      hash = (53 * hash) + getSpace().hashCode();
    }
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.CreateSpaceRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.CreateSpaceRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.CreateSpaceRequest parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.CreateSpaceRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.CreateSpaceRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.CreateSpaceRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.CreateSpaceRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.CreateSpaceRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.CreateSpaceRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.CreateSpaceRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.CreateSpaceRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.CreateSpaceRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.CreateSpaceRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A request to create a named space.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.CreateSpaceRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.CreateSpaceRequest)
      com.google.chat.v1.CreateSpaceRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_CreateSpaceRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_CreateSpaceRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.CreateSpaceRequest.class,
              com.google.chat.v1.CreateSpaceRequest.Builder.class);
    }

    // Construct using com.google.chat.v1.CreateSpaceRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSpaceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      space_ = null;
      if (spaceBuilder_ != null) {
        spaceBuilder_.dispose();
        spaceBuilder_ = null;
      }
      requestId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_CreateSpaceRequest_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.CreateSpaceRequest getDefaultInstanceForType() {
      return com.google.chat.v1.CreateSpaceRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.CreateSpaceRequest build() {
      com.google.chat.v1.CreateSpaceRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.CreateSpaceRequest buildPartial() {
      com.google.chat.v1.CreateSpaceRequest result =
          new com.google.chat.v1.CreateSpaceRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.chat.v1.CreateSpaceRequest result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.space_ = spaceBuilder_ == null ? space_ : spaceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.requestId_ = requestId_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.CreateSpaceRequest) {
        return mergeFrom((com.google.chat.v1.CreateSpaceRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.CreateSpaceRequest other) {
      if (other == com.google.chat.v1.CreateSpaceRequest.getDefaultInstance()) return this;
      if (other.hasSpace()) {
        mergeSpace(other.getSpace());
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getSpaceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.chat.v1.Space space_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Space,
            com.google.chat.v1.Space.Builder,
            com.google.chat.v1.SpaceOrBuilder>
        spaceBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The `displayName` and `spaceType` fields must be populated.  Only
     * `SpaceType.SPACE` is supported.
     *
     * If you receive the error message `ALREADY_EXISTS` when creating a space,
     * try a different `displayName`. An existing space within the Google
     * Workspace organization might already use this display name.
     *
     * The space `name` is assigned on the server so anything specified in this
     * field will be ignored.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the space field is set.
     */
    public boolean hasSpace() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The `displayName` and `spaceType` fields must be populated.  Only
     * `SpaceType.SPACE` is supported.
     *
     * If you receive the error message `ALREADY_EXISTS` when creating a space,
     * try a different `displayName`. An existing space within the Google
     * Workspace organization might already use this display name.
     *
     * The space `name` is assigned on the server so anything specified in this
     * field will be ignored.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The space.
     */
    public com.google.chat.v1.Space getSpace() {
      if (spaceBuilder_ == null) {
        return space_ == null ? com.google.chat.v1.Space.getDefaultInstance() : space_;
      } else {
        return spaceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The `displayName` and `spaceType` fields must be populated.  Only
     * `SpaceType.SPACE` is supported.
     *
     * If you receive the error message `ALREADY_EXISTS` when creating a space,
     * try a different `displayName`. An existing space within the Google
     * Workspace organization might already use this display name.
     *
     * The space `name` is assigned on the server so anything specified in this
     * field will be ignored.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setSpace(com.google.chat.v1.Space value) {
      if (spaceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        space_ = value;
      } else {
        spaceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `displayName` and `spaceType` fields must be populated.  Only
     * `SpaceType.SPACE` is supported.
     *
     * If you receive the error message `ALREADY_EXISTS` when creating a space,
     * try a different `displayName`. An existing space within the Google
     * Workspace organization might already use this display name.
     *
     * The space `name` is assigned on the server so anything specified in this
     * field will be ignored.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setSpace(com.google.chat.v1.Space.Builder builderForValue) {
      if (spaceBuilder_ == null) {
        space_ = builderForValue.build();
      } else {
        spaceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `displayName` and `spaceType` fields must be populated.  Only
     * `SpaceType.SPACE` is supported.
     *
     * If you receive the error message `ALREADY_EXISTS` when creating a space,
     * try a different `displayName`. An existing space within the Google
     * Workspace organization might already use this display name.
     *
     * The space `name` is assigned on the server so anything specified in this
     * field will be ignored.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder mergeSpace(com.google.chat.v1.Space value) {
      if (spaceBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && space_ != null
            && space_ != com.google.chat.v1.Space.getDefaultInstance()) {
          getSpaceBuilder().mergeFrom(value);
        } else {
          space_ = value;
        }
      } else {
        spaceBuilder_.mergeFrom(value);
      }
      if (space_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `displayName` and `spaceType` fields must be populated.  Only
     * `SpaceType.SPACE` is supported.
     *
     * If you receive the error message `ALREADY_EXISTS` when creating a space,
     * try a different `displayName`. An existing space within the Google
     * Workspace organization might already use this display name.
     *
     * The space `name` is assigned on the server so anything specified in this
     * field will be ignored.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder clearSpace() {
      bitField0_ = (bitField0_ & ~0x00000001);
      space_ = null;
      if (spaceBuilder_ != null) {
        spaceBuilder_.dispose();
        spaceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `displayName` and `spaceType` fields must be populated.  Only
     * `SpaceType.SPACE` is supported.
     *
     * If you receive the error message `ALREADY_EXISTS` when creating a space,
     * try a different `displayName`. An existing space within the Google
     * Workspace organization might already use this display name.
     *
     * The space `name` is assigned on the server so anything specified in this
     * field will be ignored.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.chat.v1.Space.Builder getSpaceBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getSpaceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The `displayName` and `spaceType` fields must be populated.  Only
     * `SpaceType.SPACE` is supported.
     *
     * If you receive the error message `ALREADY_EXISTS` when creating a space,
     * try a different `displayName`. An existing space within the Google
     * Workspace organization might already use this display name.
     *
     * The space `name` is assigned on the server so anything specified in this
     * field will be ignored.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.chat.v1.SpaceOrBuilder getSpaceOrBuilder() {
      if (spaceBuilder_ != null) {
        return spaceBuilder_.getMessageOrBuilder();
      } else {
        return space_ == null ? com.google.chat.v1.Space.getDefaultInstance() : space_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The `displayName` and `spaceType` fields must be populated.  Only
     * `SpaceType.SPACE` is supported.
     *
     * If you receive the error message `ALREADY_EXISTS` when creating a space,
     * try a different `displayName`. An existing space within the Google
     * Workspace organization might already use this display name.
     *
     * The space `name` is assigned on the server so anything specified in this
     * field will be ignored.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Space,
            com.google.chat.v1.Space.Builder,
            com.google.chat.v1.SpaceOrBuilder>
        getSpaceFieldBuilder() {
      if (spaceBuilder_ == null) {
        spaceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.Space,
                com.google.chat.v1.Space.Builder,
                com.google.chat.v1.SpaceOrBuilder>(getSpace(), getParentForChildren(), isClean());
        space_ = null;
      }
      return spaceBuilder_;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request.
     * A random UUID is recommended.
     * Specifying an existing request ID returns the space created with that ID
     * instead of creating a new space.
     * Specifying an existing request ID from the same Chat app with a different
     * authenticated user returns an error.
     * </pre>
     *
     * <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request.
     * A random UUID is recommended.
     * Specifying an existing request ID returns the space created with that ID
     * instead of creating a new space.
     * Specifying an existing request ID from the same Chat app with a different
     * authenticated user returns an error.
     * </pre>
     *
     * <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request.
     * A random UUID is recommended.
     * Specifying an existing request ID returns the space created with that ID
     * instead of creating a new space.
     * Specifying an existing request ID from the same Chat app with a different
     * authenticated user returns an error.
     * </pre>
     *
     * <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request.
     * A random UUID is recommended.
     * Specifying an existing request ID returns the space created with that ID
     * instead of creating a new space.
     * Specifying an existing request ID from the same Chat app with a different
     * authenticated user returns an error.
     * </pre>
     *
     * <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request.
     * A random UUID is recommended.
     * Specifying an existing request ID returns the space created with that ID
     * instead of creating a new space.
     * Specifying an existing request ID from the same Chat app with a different
     * authenticated user returns an error.
     * </pre>
     *
     * <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.CreateSpaceRequest)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.CreateSpaceRequest)
  private static final com.google.chat.v1.CreateSpaceRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.CreateSpaceRequest();
  }

  public static com.google.chat.v1.CreateSpaceRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateSpaceRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateSpaceRequest>() {
        @java.lang.Override
        public CreateSpaceRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateSpaceRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateSpaceRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.CreateSpaceRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
