/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/reaction.proto

// Protobuf Java Version: 3.25.4
package com.google.chat.v1;

/**
 *
 *
 * <pre>
 * Response to a list reactions request.
 * </pre>
 *
 * Protobuf type {@code google.chat.v1.ListReactionsResponse}
 */
public final class ListReactionsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.ListReactionsResponse)
    ListReactionsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListReactionsResponse.newBuilder() to construct.
  private ListReactionsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListReactionsResponse() {
    reactions_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListReactionsResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.ReactionProto
        .internal_static_google_chat_v1_ListReactionsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.ReactionProto
        .internal_static_google_chat_v1_ListReactionsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.ListReactionsResponse.class,
            com.google.chat.v1.ListReactionsResponse.Builder.class);
  }

  public static final int REACTIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.chat.v1.Reaction> reactions_;
  /**
   *
   *
   * <pre>
   * List of reactions in the requested (or first) page.
   * </pre>
   *
   * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.chat.v1.Reaction> getReactionsList() {
    return reactions_;
  }
  /**
   *
   *
   * <pre>
   * List of reactions in the requested (or first) page.
   * </pre>
   *
   * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.chat.v1.ReactionOrBuilder>
      getReactionsOrBuilderList() {
    return reactions_;
  }
  /**
   *
   *
   * <pre>
   * List of reactions in the requested (or first) page.
   * </pre>
   *
   * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
   */
  @java.lang.Override
  public int getReactionsCount() {
    return reactions_.size();
  }
  /**
   *
   *
   * <pre>
   * List of reactions in the requested (or first) page.
   * </pre>
   *
   * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.Reaction getReactions(int index) {
    return reactions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of reactions in the requested (or first) page.
   * </pre>
   *
   * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.ReactionOrBuilder getReactionsOrBuilder(int index) {
    return reactions_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";
  /**
   *
   *
   * <pre>
   * Continuation token to retrieve the next page of results. It's empty
   * for the last page of results.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Continuation token to retrieve the next page of results. It's empty
   * for the last page of results.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < reactions_.size(); i++) {
      output.writeMessage(1, reactions_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < reactions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, reactions_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.ListReactionsResponse)) {
      return super.equals(obj);
    }
    com.google.chat.v1.ListReactionsResponse other = (com.google.chat.v1.ListReactionsResponse) obj;

    if (!getReactionsList().equals(other.getReactionsList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getReactionsCount() > 0) {
      hash = (37 * hash) + REACTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getReactionsList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.ListReactionsResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.ListReactionsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.ListReactionsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.ListReactionsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.ListReactionsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.ListReactionsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.ListReactionsResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.ListReactionsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.ListReactionsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.ListReactionsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.ListReactionsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.ListReactionsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.ListReactionsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response to a list reactions request.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.ListReactionsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.ListReactionsResponse)
      com.google.chat.v1.ListReactionsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.ReactionProto
          .internal_static_google_chat_v1_ListReactionsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.ReactionProto
          .internal_static_google_chat_v1_ListReactionsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.ListReactionsResponse.class,
              com.google.chat.v1.ListReactionsResponse.Builder.class);
    }

    // Construct using com.google.chat.v1.ListReactionsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (reactionsBuilder_ == null) {
        reactions_ = java.util.Collections.emptyList();
      } else {
        reactions_ = null;
        reactionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.ReactionProto
          .internal_static_google_chat_v1_ListReactionsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.ListReactionsResponse getDefaultInstanceForType() {
      return com.google.chat.v1.ListReactionsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.ListReactionsResponse build() {
      com.google.chat.v1.ListReactionsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.ListReactionsResponse buildPartial() {
      com.google.chat.v1.ListReactionsResponse result =
          new com.google.chat.v1.ListReactionsResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.chat.v1.ListReactionsResponse result) {
      if (reactionsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          reactions_ = java.util.Collections.unmodifiableList(reactions_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.reactions_ = reactions_;
      } else {
        result.reactions_ = reactionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.chat.v1.ListReactionsResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.ListReactionsResponse) {
        return mergeFrom((com.google.chat.v1.ListReactionsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.ListReactionsResponse other) {
      if (other == com.google.chat.v1.ListReactionsResponse.getDefaultInstance()) return this;
      if (reactionsBuilder_ == null) {
        if (!other.reactions_.isEmpty()) {
          if (reactions_.isEmpty()) {
            reactions_ = other.reactions_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureReactionsIsMutable();
            reactions_.addAll(other.reactions_);
          }
          onChanged();
        }
      } else {
        if (!other.reactions_.isEmpty()) {
          if (reactionsBuilder_.isEmpty()) {
            reactionsBuilder_.dispose();
            reactionsBuilder_ = null;
            reactions_ = other.reactions_;
            bitField0_ = (bitField0_ & ~0x00000001);
            reactionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getReactionsFieldBuilder()
                    : null;
          } else {
            reactionsBuilder_.addAllMessages(other.reactions_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.chat.v1.Reaction m =
                    input.readMessage(com.google.chat.v1.Reaction.parser(), extensionRegistry);
                if (reactionsBuilder_ == null) {
                  ensureReactionsIsMutable();
                  reactions_.add(m);
                } else {
                  reactionsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.chat.v1.Reaction> reactions_ =
        java.util.Collections.emptyList();

    private void ensureReactionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        reactions_ = new java.util.ArrayList<com.google.chat.v1.Reaction>(reactions_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.chat.v1.Reaction,
            com.google.chat.v1.Reaction.Builder,
            com.google.chat.v1.ReactionOrBuilder>
        reactionsBuilder_;

    /**
     *
     *
     * <pre>
     * List of reactions in the requested (or first) page.
     * </pre>
     *
     * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
     */
    public java.util.List<com.google.chat.v1.Reaction> getReactionsList() {
      if (reactionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(reactions_);
      } else {
        return reactionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of reactions in the requested (or first) page.
     * </pre>
     *
     * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
     */
    public int getReactionsCount() {
      if (reactionsBuilder_ == null) {
        return reactions_.size();
      } else {
        return reactionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of reactions in the requested (or first) page.
     * </pre>
     *
     * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
     */
    public com.google.chat.v1.Reaction getReactions(int index) {
      if (reactionsBuilder_ == null) {
        return reactions_.get(index);
      } else {
        return reactionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of reactions in the requested (or first) page.
     * </pre>
     *
     * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
     */
    public Builder setReactions(int index, com.google.chat.v1.Reaction value) {
      if (reactionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReactionsIsMutable();
        reactions_.set(index, value);
        onChanged();
      } else {
        reactionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of reactions in the requested (or first) page.
     * </pre>
     *
     * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
     */
    public Builder setReactions(int index, com.google.chat.v1.Reaction.Builder builderForValue) {
      if (reactionsBuilder_ == null) {
        ensureReactionsIsMutable();
        reactions_.set(index, builderForValue.build());
        onChanged();
      } else {
        reactionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of reactions in the requested (or first) page.
     * </pre>
     *
     * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
     */
    public Builder addReactions(com.google.chat.v1.Reaction value) {
      if (reactionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReactionsIsMutable();
        reactions_.add(value);
        onChanged();
      } else {
        reactionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of reactions in the requested (or first) page.
     * </pre>
     *
     * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
     */
    public Builder addReactions(int index, com.google.chat.v1.Reaction value) {
      if (reactionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReactionsIsMutable();
        reactions_.add(index, value);
        onChanged();
      } else {
        reactionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of reactions in the requested (or first) page.
     * </pre>
     *
     * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
     */
    public Builder addReactions(com.google.chat.v1.Reaction.Builder builderForValue) {
      if (reactionsBuilder_ == null) {
        ensureReactionsIsMutable();
        reactions_.add(builderForValue.build());
        onChanged();
      } else {
        reactionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of reactions in the requested (or first) page.
     * </pre>
     *
     * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
     */
    public Builder addReactions(int index, com.google.chat.v1.Reaction.Builder builderForValue) {
      if (reactionsBuilder_ == null) {
        ensureReactionsIsMutable();
        reactions_.add(index, builderForValue.build());
        onChanged();
      } else {
        reactionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of reactions in the requested (or first) page.
     * </pre>
     *
     * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
     */
    public Builder addAllReactions(
        java.lang.Iterable<? extends com.google.chat.v1.Reaction> values) {
      if (reactionsBuilder_ == null) {
        ensureReactionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, reactions_);
        onChanged();
      } else {
        reactionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of reactions in the requested (or first) page.
     * </pre>
     *
     * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
     */
    public Builder clearReactions() {
      if (reactionsBuilder_ == null) {
        reactions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        reactionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of reactions in the requested (or first) page.
     * </pre>
     *
     * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
     */
    public Builder removeReactions(int index) {
      if (reactionsBuilder_ == null) {
        ensureReactionsIsMutable();
        reactions_.remove(index);
        onChanged();
      } else {
        reactionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of reactions in the requested (or first) page.
     * </pre>
     *
     * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
     */
    public com.google.chat.v1.Reaction.Builder getReactionsBuilder(int index) {
      return getReactionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of reactions in the requested (or first) page.
     * </pre>
     *
     * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
     */
    public com.google.chat.v1.ReactionOrBuilder getReactionsOrBuilder(int index) {
      if (reactionsBuilder_ == null) {
        return reactions_.get(index);
      } else {
        return reactionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of reactions in the requested (or first) page.
     * </pre>
     *
     * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
     */
    public java.util.List<? extends com.google.chat.v1.ReactionOrBuilder>
        getReactionsOrBuilderList() {
      if (reactionsBuilder_ != null) {
        return reactionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(reactions_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of reactions in the requested (or first) page.
     * </pre>
     *
     * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
     */
    public com.google.chat.v1.Reaction.Builder addReactionsBuilder() {
      return getReactionsFieldBuilder()
          .addBuilder(com.google.chat.v1.Reaction.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of reactions in the requested (or first) page.
     * </pre>
     *
     * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
     */
    public com.google.chat.v1.Reaction.Builder addReactionsBuilder(int index) {
      return getReactionsFieldBuilder()
          .addBuilder(index, com.google.chat.v1.Reaction.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of reactions in the requested (or first) page.
     * </pre>
     *
     * <code>repeated .google.chat.v1.Reaction reactions = 1;</code>
     */
    public java.util.List<com.google.chat.v1.Reaction.Builder> getReactionsBuilderList() {
      return getReactionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.chat.v1.Reaction,
            com.google.chat.v1.Reaction.Builder,
            com.google.chat.v1.ReactionOrBuilder>
        getReactionsFieldBuilder() {
      if (reactionsBuilder_ == null) {
        reactionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.chat.v1.Reaction,
                com.google.chat.v1.Reaction.Builder,
                com.google.chat.v1.ReactionOrBuilder>(
                reactions_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        reactions_ = null;
      }
      return reactionsBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * Continuation token to retrieve the next page of results. It's empty
     * for the last page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Continuation token to retrieve the next page of results. It's empty
     * for the last page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Continuation token to retrieve the next page of results. It's empty
     * for the last page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Continuation token to retrieve the next page of results. It's empty
     * for the last page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Continuation token to retrieve the next page of results. It's empty
     * for the last page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.ListReactionsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.ListReactionsResponse)
  private static final com.google.chat.v1.ListReactionsResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.ListReactionsResponse();
  }

  public static com.google.chat.v1.ListReactionsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListReactionsResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListReactionsResponse>() {
        @java.lang.Override
        public ListReactionsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListReactionsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListReactionsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.ListReactionsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
