/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/space_event.proto

// Protobuf Java Version: 3.25.4
package com.google.chat.v1;

public interface ListSpaceEventsRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.chat.v1.ListSpaceEventsRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. Resource name of the [Google Chat
   * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
   * where the events occurred.
   *
   * Format: `spaces/{space}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();
  /**
   *
   *
   * <pre>
   * Required. Resource name of the [Google Chat
   * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
   * where the events occurred.
   *
   * Format: `spaces/{space}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Optional. The maximum number of space events returned. The service might
   * return fewer than this value.
   *
   * Negative values return an `INVALID_ARGUMENT` error.
   * </pre>
   *
   * <code>int32 page_size = 5;</code>
   *
   * @return The pageSize.
   */
  int getPageSize();

  /**
   *
   *
   * <pre>
   * A page token, received from a previous list space events call. Provide this
   * to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided to list space events must
   * match the call that provided the page token. Passing different values to
   * the other parameters might lead to unexpected results.
   * </pre>
   *
   * <code>string page_token = 6;</code>
   *
   * @return The pageToken.
   */
  java.lang.String getPageToken();
  /**
   *
   *
   * <pre>
   * A page token, received from a previous list space events call. Provide this
   * to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided to list space events must
   * match the call that provided the page token. Passing different values to
   * the other parameters might lead to unexpected results.
   * </pre>
   *
   * <code>string page_token = 6;</code>
   *
   * @return The bytes for pageToken.
   */
  com.google.protobuf.ByteString getPageTokenBytes();

  /**
   *
   *
   * <pre>
   * Required. A query filter.
   *
   * You must specify at least one event type (`event_type`)
   * using the has `:` operator. To filter by multiple event types, use the `OR`
   * operator. Omit batch event types in your filter. The request automatically
   * returns any related batch events. For example, if you filter by new
   * reactions
   * (`google.workspace.chat.reaction.v1.created`), the server also returns
   * batch new reactions events
   * (`google.workspace.chat.reaction.v1.batchCreated`). For a list of supported
   * event types, see the [`SpaceEvents` reference
   * documentation](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.spaceEvents#SpaceEvent.FIELDS.event_type).
   *
   * Optionally, you can also filter by start time (`start_time`) and
   * end time (`end_time`):
   *
   * * `start_time`: Exclusive timestamp from which to start listing space
   * events.
   *  You can list events that occurred up to 28 days ago. If unspecified, lists
   *  space events from the past 28 days.
   * * `end_time`: Inclusive timestamp until which space events are listed.
   *  If unspecified, lists events up to the time of the request.
   *
   * To specify a start or end time, use the equals `=` operator and format in
   * [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339). To filter by both
   * `start_time` and `end_time`, use the `AND` operator.
   *
   * For example, the following queries are valid:
   *
   * ```
   * start_time="2023-08-23T19:20:33+00:00" AND
   * end_time="2023-08-23T19:21:54+00:00"
   * ```
   * ```
   * start_time="2023-08-23T19:20:33+00:00" AND
   * (event_types:"google.workspace.chat.space.v1.updated" OR
   * event_types:"google.workspace.chat.message.v1.created")
   * ```
   *
   * The following queries are invalid:
   *
   * ```
   * start_time="2023-08-23T19:20:33+00:00" OR
   * end_time="2023-08-23T19:21:54+00:00"
   * ```
   * ```
   * event_types:"google.workspace.chat.space.v1.updated" AND
   * event_types:"google.workspace.chat.message.v1.created"
   * ```
   *
   * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
   * error.
   * </pre>
   *
   * <code>string filter = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The filter.
   */
  java.lang.String getFilter();
  /**
   *
   *
   * <pre>
   * Required. A query filter.
   *
   * You must specify at least one event type (`event_type`)
   * using the has `:` operator. To filter by multiple event types, use the `OR`
   * operator. Omit batch event types in your filter. The request automatically
   * returns any related batch events. For example, if you filter by new
   * reactions
   * (`google.workspace.chat.reaction.v1.created`), the server also returns
   * batch new reactions events
   * (`google.workspace.chat.reaction.v1.batchCreated`). For a list of supported
   * event types, see the [`SpaceEvents` reference
   * documentation](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.spaceEvents#SpaceEvent.FIELDS.event_type).
   *
   * Optionally, you can also filter by start time (`start_time`) and
   * end time (`end_time`):
   *
   * * `start_time`: Exclusive timestamp from which to start listing space
   * events.
   *  You can list events that occurred up to 28 days ago. If unspecified, lists
   *  space events from the past 28 days.
   * * `end_time`: Inclusive timestamp until which space events are listed.
   *  If unspecified, lists events up to the time of the request.
   *
   * To specify a start or end time, use the equals `=` operator and format in
   * [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339). To filter by both
   * `start_time` and `end_time`, use the `AND` operator.
   *
   * For example, the following queries are valid:
   *
   * ```
   * start_time="2023-08-23T19:20:33+00:00" AND
   * end_time="2023-08-23T19:21:54+00:00"
   * ```
   * ```
   * start_time="2023-08-23T19:20:33+00:00" AND
   * (event_types:"google.workspace.chat.space.v1.updated" OR
   * event_types:"google.workspace.chat.message.v1.created")
   * ```
   *
   * The following queries are invalid:
   *
   * ```
   * start_time="2023-08-23T19:20:33+00:00" OR
   * end_time="2023-08-23T19:21:54+00:00"
   * ```
   * ```
   * event_types:"google.workspace.chat.space.v1.updated" AND
   * event_types:"google.workspace.chat.message.v1.created"
   * ```
   *
   * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
   * error.
   * </pre>
   *
   * <code>string filter = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for filter.
   */
  com.google.protobuf.ByteString getFilterBytes();
}
