/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/space.proto

// Protobuf Java Version: 3.25.4
package com.google.chat.v1;

/**
 *
 *
 * <pre>
 * A space in Google Chat. Spaces are conversations between two or more users
 * or 1:1 messages between a user and a Chat app.
 * </pre>
 *
 * Protobuf type {@code google.chat.v1.Space}
 */
public final class Space extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.Space)
    SpaceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Space.newBuilder() to construct.
  private Space(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Space() {
    name_ = "";
    type_ = 0;
    spaceType_ = 0;
    displayName_ = "";
    spaceThreadingState_ = 0;
    spaceHistoryState_ = 0;
    spaceUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Space();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.SpaceProto.internal_static_google_chat_v1_Space_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.SpaceProto.internal_static_google_chat_v1_Space_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.Space.class, com.google.chat.v1.Space.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Deprecated: Use `SpaceType` instead.
   * </pre>
   *
   * Protobuf enum {@code google.chat.v1.Space.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Reserved.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Conversations between two or more humans.
     * </pre>
     *
     * <code>ROOM = 1;</code>
     */
    ROOM(1),
    /**
     *
     *
     * <pre>
     * 1:1 Direct Message between a human and a Chat app, where all messages are
     * flat. Note that this doesn't include direct messages between two humans.
     * </pre>
     *
     * <code>DM = 2;</code>
     */
    DM(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Reserved.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Conversations between two or more humans.
     * </pre>
     *
     * <code>ROOM = 1;</code>
     */
    public static final int ROOM_VALUE = 1;
    /**
     *
     *
     * <pre>
     * 1:1 Direct Message between a human and a Chat app, where all messages are
     * flat. Note that this doesn't include direct messages between two humans.
     * </pre>
     *
     * <code>DM = 2;</code>
     */
    public static final int DM_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return ROOM;
        case 2:
          return DM;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.chat.v1.Space.getDescriptor().getEnumTypes().get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.chat.v1.Space.Type)
  }

  /**
   *
   *
   * <pre>
   * The type of space. Required when creating or updating a space. Output only
   * for other usage.
   * </pre>
   *
   * Protobuf enum {@code google.chat.v1.Space.SpaceType}
   */
  public enum SpaceType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Reserved.
     * </pre>
     *
     * <code>SPACE_TYPE_UNSPECIFIED = 0;</code>
     */
    SPACE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * A place where people send messages, share files, and collaborate.
     * A `SPACE` can include Chat apps.
     * </pre>
     *
     * <code>SPACE = 1;</code>
     */
    SPACE(1),
    /**
     *
     *
     * <pre>
     * Group conversations between 3 or more people.
     * A `GROUP_CHAT` can include Chat apps.
     * </pre>
     *
     * <code>GROUP_CHAT = 2;</code>
     */
    GROUP_CHAT(2),
    /**
     *
     *
     * <pre>
     * 1:1 messages between two humans or a human and a Chat app.
     * </pre>
     *
     * <code>DIRECT_MESSAGE = 3;</code>
     */
    DIRECT_MESSAGE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Reserved.
     * </pre>
     *
     * <code>SPACE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int SPACE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * A place where people send messages, share files, and collaborate.
     * A `SPACE` can include Chat apps.
     * </pre>
     *
     * <code>SPACE = 1;</code>
     */
    public static final int SPACE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Group conversations between 3 or more people.
     * A `GROUP_CHAT` can include Chat apps.
     * </pre>
     *
     * <code>GROUP_CHAT = 2;</code>
     */
    public static final int GROUP_CHAT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * 1:1 messages between two humans or a human and a Chat app.
     * </pre>
     *
     * <code>DIRECT_MESSAGE = 3;</code>
     */
    public static final int DIRECT_MESSAGE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SpaceType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SpaceType forNumber(int value) {
      switch (value) {
        case 0:
          return SPACE_TYPE_UNSPECIFIED;
        case 1:
          return SPACE;
        case 2:
          return GROUP_CHAT;
        case 3:
          return DIRECT_MESSAGE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SpaceType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SpaceType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<SpaceType>() {
          public SpaceType findValueByNumber(int number) {
            return SpaceType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.chat.v1.Space.getDescriptor().getEnumTypes().get(1);
    }

    private static final SpaceType[] VALUES = values();

    public static SpaceType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SpaceType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.chat.v1.Space.SpaceType)
  }

  /**
   *
   *
   * <pre>
   * Specifies the type of threading state in the Chat space.
   * </pre>
   *
   * Protobuf enum {@code google.chat.v1.Space.SpaceThreadingState}
   */
  public enum SpaceThreadingState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Reserved.
     * </pre>
     *
     * <code>SPACE_THREADING_STATE_UNSPECIFIED = 0;</code>
     */
    SPACE_THREADING_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Named spaces that support message threads. When users respond to a
     * message, they can reply in-thread, which keeps their response in the
     * context of the original message.
     * </pre>
     *
     * <code>THREADED_MESSAGES = 2;</code>
     */
    THREADED_MESSAGES(2),
    /**
     *
     *
     * <pre>
     * Named spaces where the conversation is organized by topic. Topics and
     * their replies are grouped together.
     * </pre>
     *
     * <code>GROUPED_MESSAGES = 3;</code>
     */
    GROUPED_MESSAGES(3),
    /**
     *
     *
     * <pre>
     * Direct messages (DMs) between two people and group conversations between
     * 3 or more people.
     * </pre>
     *
     * <code>UNTHREADED_MESSAGES = 4;</code>
     */
    UNTHREADED_MESSAGES(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Reserved.
     * </pre>
     *
     * <code>SPACE_THREADING_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int SPACE_THREADING_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Named spaces that support message threads. When users respond to a
     * message, they can reply in-thread, which keeps their response in the
     * context of the original message.
     * </pre>
     *
     * <code>THREADED_MESSAGES = 2;</code>
     */
    public static final int THREADED_MESSAGES_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Named spaces where the conversation is organized by topic. Topics and
     * their replies are grouped together.
     * </pre>
     *
     * <code>GROUPED_MESSAGES = 3;</code>
     */
    public static final int GROUPED_MESSAGES_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Direct messages (DMs) between two people and group conversations between
     * 3 or more people.
     * </pre>
     *
     * <code>UNTHREADED_MESSAGES = 4;</code>
     */
    public static final int UNTHREADED_MESSAGES_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SpaceThreadingState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SpaceThreadingState forNumber(int value) {
      switch (value) {
        case 0:
          return SPACE_THREADING_STATE_UNSPECIFIED;
        case 2:
          return THREADED_MESSAGES;
        case 3:
          return GROUPED_MESSAGES;
        case 4:
          return UNTHREADED_MESSAGES;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SpaceThreadingState>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SpaceThreadingState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SpaceThreadingState>() {
              public SpaceThreadingState findValueByNumber(int number) {
                return SpaceThreadingState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.chat.v1.Space.getDescriptor().getEnumTypes().get(2);
    }

    private static final SpaceThreadingState[] VALUES = values();

    public static SpaceThreadingState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SpaceThreadingState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.chat.v1.Space.SpaceThreadingState)
  }

  public interface SpaceDetailsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.chat.v1.Space.SpaceDetails)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. A description of the space. For example, describe the space's
     * discussion topic, functional purpose, or participants.
     *
     * Supports up to 150 characters.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return The description.
     */
    java.lang.String getDescription();
    /**
     *
     *
     * <pre>
     * Optional. A description of the space. For example, describe the space's
     * discussion topic, functional purpose, or participants.
     *
     * Supports up to 150 characters.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString getDescriptionBytes();

    /**
     *
     *
     * <pre>
     * Optional. The space's rules, expectations, and etiquette.
     *
     * Supports up to 5,000 characters.
     * </pre>
     *
     * <code>string guidelines = 2;</code>
     *
     * @return The guidelines.
     */
    java.lang.String getGuidelines();
    /**
     *
     *
     * <pre>
     * Optional. The space's rules, expectations, and etiquette.
     *
     * Supports up to 5,000 characters.
     * </pre>
     *
     * <code>string guidelines = 2;</code>
     *
     * @return The bytes for guidelines.
     */
    com.google.protobuf.ByteString getGuidelinesBytes();
  }
  /**
   *
   *
   * <pre>
   * Details about the space including description and rules.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.Space.SpaceDetails}
   */
  public static final class SpaceDetails extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.chat.v1.Space.SpaceDetails)
      SpaceDetailsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SpaceDetails.newBuilder() to construct.
    private SpaceDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SpaceDetails() {
      description_ = "";
      guidelines_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SpaceDetails();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_Space_SpaceDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_Space_SpaceDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.Space.SpaceDetails.class,
              com.google.chat.v1.Space.SpaceDetails.Builder.class);
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A description of the space. For example, describe the space's
     * discussion topic, functional purpose, or participants.
     *
     * Supports up to 150 characters.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of the space. For example, describe the space's
     * discussion topic, functional purpose, or participants.
     *
     * Supports up to 150 characters.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GUIDELINES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object guidelines_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The space's rules, expectations, and etiquette.
     *
     * Supports up to 5,000 characters.
     * </pre>
     *
     * <code>string guidelines = 2;</code>
     *
     * @return The guidelines.
     */
    @java.lang.Override
    public java.lang.String getGuidelines() {
      java.lang.Object ref = guidelines_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        guidelines_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The space's rules, expectations, and etiquette.
     *
     * Supports up to 5,000 characters.
     * </pre>
     *
     * <code>string guidelines = 2;</code>
     *
     * @return The bytes for guidelines.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGuidelinesBytes() {
      java.lang.Object ref = guidelines_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        guidelines_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, description_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(guidelines_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, guidelines_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, description_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(guidelines_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, guidelines_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.chat.v1.Space.SpaceDetails)) {
        return super.equals(obj);
      }
      com.google.chat.v1.Space.SpaceDetails other = (com.google.chat.v1.Space.SpaceDetails) obj;

      if (!getDescription().equals(other.getDescription())) return false;
      if (!getGuidelines().equals(other.getGuidelines())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      hash = (37 * hash) + GUIDELINES_FIELD_NUMBER;
      hash = (53 * hash) + getGuidelines().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.chat.v1.Space.SpaceDetails parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.chat.v1.Space.SpaceDetails prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Details about the space including description and rules.
     * </pre>
     *
     * Protobuf type {@code google.chat.v1.Space.SpaceDetails}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.chat.v1.Space.SpaceDetails)
        com.google.chat.v1.Space.SpaceDetailsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.chat.v1.SpaceProto
            .internal_static_google_chat_v1_Space_SpaceDetails_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.chat.v1.SpaceProto
            .internal_static_google_chat_v1_Space_SpaceDetails_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.chat.v1.Space.SpaceDetails.class,
                com.google.chat.v1.Space.SpaceDetails.Builder.class);
      }

      // Construct using com.google.chat.v1.Space.SpaceDetails.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        description_ = "";
        guidelines_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.chat.v1.SpaceProto
            .internal_static_google_chat_v1_Space_SpaceDetails_descriptor;
      }

      @java.lang.Override
      public com.google.chat.v1.Space.SpaceDetails getDefaultInstanceForType() {
        return com.google.chat.v1.Space.SpaceDetails.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.chat.v1.Space.SpaceDetails build() {
        com.google.chat.v1.Space.SpaceDetails result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.chat.v1.Space.SpaceDetails buildPartial() {
        com.google.chat.v1.Space.SpaceDetails result =
            new com.google.chat.v1.Space.SpaceDetails(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.chat.v1.Space.SpaceDetails result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.description_ = description_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.guidelines_ = guidelines_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.chat.v1.Space.SpaceDetails) {
          return mergeFrom((com.google.chat.v1.Space.SpaceDetails) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.chat.v1.Space.SpaceDetails other) {
        if (other == com.google.chat.v1.Space.SpaceDetails.getDefaultInstance()) return this;
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getGuidelines().isEmpty()) {
          guidelines_ = other.guidelines_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  description_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  guidelines_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object description_ = "";
      /**
       *
       *
       * <pre>
       * Optional. A description of the space. For example, describe the space's
       * discussion topic, functional purpose, or participants.
       *
       * Supports up to 150 characters.
       * </pre>
       *
       * <code>string description = 1;</code>
       *
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A description of the space. For example, describe the space's
       * discussion topic, functional purpose, or participants.
       *
       * Supports up to 150 characters.
       * </pre>
       *
       * <code>string description = 1;</code>
       *
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A description of the space. For example, describe the space's
       * discussion topic, functional purpose, or participants.
       *
       * Supports up to 150 characters.
       * </pre>
       *
       * <code>string description = 1;</code>
       *
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        description_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A description of the space. For example, describe the space's
       * discussion topic, functional purpose, or participants.
       *
       * Supports up to 150 characters.
       * </pre>
       *
       * <code>string description = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A description of the space. For example, describe the space's
       * discussion topic, functional purpose, or participants.
       *
       * Supports up to 150 characters.
       * </pre>
       *
       * <code>string description = 1;</code>
       *
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object guidelines_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The space's rules, expectations, and etiquette.
       *
       * Supports up to 5,000 characters.
       * </pre>
       *
       * <code>string guidelines = 2;</code>
       *
       * @return The guidelines.
       */
      public java.lang.String getGuidelines() {
        java.lang.Object ref = guidelines_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          guidelines_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The space's rules, expectations, and etiquette.
       *
       * Supports up to 5,000 characters.
       * </pre>
       *
       * <code>string guidelines = 2;</code>
       *
       * @return The bytes for guidelines.
       */
      public com.google.protobuf.ByteString getGuidelinesBytes() {
        java.lang.Object ref = guidelines_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          guidelines_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The space's rules, expectations, and etiquette.
       *
       * Supports up to 5,000 characters.
       * </pre>
       *
       * <code>string guidelines = 2;</code>
       *
       * @param value The guidelines to set.
       * @return This builder for chaining.
       */
      public Builder setGuidelines(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        guidelines_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The space's rules, expectations, and etiquette.
       *
       * Supports up to 5,000 characters.
       * </pre>
       *
       * <code>string guidelines = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGuidelines() {
        guidelines_ = getDefaultInstance().getGuidelines();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The space's rules, expectations, and etiquette.
       *
       * Supports up to 5,000 characters.
       * </pre>
       *
       * <code>string guidelines = 2;</code>
       *
       * @param value The bytes for guidelines to set.
       * @return This builder for chaining.
       */
      public Builder setGuidelinesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        guidelines_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.chat.v1.Space.SpaceDetails)
    }

    // @@protoc_insertion_point(class_scope:google.chat.v1.Space.SpaceDetails)
    private static final com.google.chat.v1.Space.SpaceDetails DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.chat.v1.Space.SpaceDetails();
    }

    public static com.google.chat.v1.Space.SpaceDetails getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SpaceDetails> PARSER =
        new com.google.protobuf.AbstractParser<SpaceDetails>() {
          @java.lang.Override
          public SpaceDetails parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SpaceDetails> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SpaceDetails> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.chat.v1.Space.SpaceDetails getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AccessSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.chat.v1.Space.AccessSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Indicates the access state of the space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings.AccessState access_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for accessState.
     */
    int getAccessStateValue();
    /**
     *
     *
     * <pre>
     * Output only. Indicates the access state of the space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings.AccessState access_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The accessState.
     */
    com.google.chat.v1.Space.AccessSettings.AccessState getAccessState();

    /**
     *
     *
     * <pre>
     * Optional. The resource name of the [target
     * audience](https://support.google.com/a/answer/9934697) who can discover
     * the space, join the space, and preview the messages in the space. For
     * details, see [Make a space discoverable to a target
     * audience](https://developers.google.com/workspace/chat/space-target-audience).
     *
     * Format: `audiences/{audience}`
     *
     * To use the default target audience for the Google Workspace organization,
     * set to `audiences/default`.
     * </pre>
     *
     * <code>string audience = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The audience.
     */
    java.lang.String getAudience();
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the [target
     * audience](https://support.google.com/a/answer/9934697) who can discover
     * the space, join the space, and preview the messages in the space. For
     * details, see [Make a space discoverable to a target
     * audience](https://developers.google.com/workspace/chat/space-target-audience).
     *
     * Format: `audiences/{audience}`
     *
     * To use the default target audience for the Google Workspace organization,
     * set to `audiences/default`.
     * </pre>
     *
     * <code>string audience = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for audience.
     */
    com.google.protobuf.ByteString getAudienceBytes();
  }
  /**
   *
   *
   * <pre>
   * Represents the [access
   * setting](https://support.google.com/chat/answer/11971020) of the space.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.Space.AccessSettings}
   */
  public static final class AccessSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.chat.v1.Space.AccessSettings)
      AccessSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AccessSettings.newBuilder() to construct.
    private AccessSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AccessSettings() {
      accessState_ = 0;
      audience_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AccessSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_Space_AccessSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_Space_AccessSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.Space.AccessSettings.class,
              com.google.chat.v1.Space.AccessSettings.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Represents the access state of the space.
     * </pre>
     *
     * Protobuf enum {@code google.chat.v1.Space.AccessSettings.AccessState}
     */
    public enum AccessState implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Access state is unknown or not supported in this API.
       * </pre>
       *
       * <code>ACCESS_STATE_UNSPECIFIED = 0;</code>
       */
      ACCESS_STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Space is discoverable by added or invited members or groups.
       * </pre>
       *
       * <code>PRIVATE = 1;</code>
       */
      PRIVATE(1),
      /**
       *
       *
       * <pre>
       * Space is discoverable by the selected [target
       * audience](https://support.google.com/a/answer/9934697), as well as
       * added or invited members or groups.
       * </pre>
       *
       * <code>DISCOVERABLE = 2;</code>
       */
      DISCOVERABLE(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Access state is unknown or not supported in this API.
       * </pre>
       *
       * <code>ACCESS_STATE_UNSPECIFIED = 0;</code>
       */
      public static final int ACCESS_STATE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Space is discoverable by added or invited members or groups.
       * </pre>
       *
       * <code>PRIVATE = 1;</code>
       */
      public static final int PRIVATE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Space is discoverable by the selected [target
       * audience](https://support.google.com/a/answer/9934697), as well as
       * added or invited members or groups.
       * </pre>
       *
       * <code>DISCOVERABLE = 2;</code>
       */
      public static final int DISCOVERABLE_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static AccessState valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static AccessState forNumber(int value) {
        switch (value) {
          case 0:
            return ACCESS_STATE_UNSPECIFIED;
          case 1:
            return PRIVATE;
          case 2:
            return DISCOVERABLE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<AccessState> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<AccessState> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<AccessState>() {
            public AccessState findValueByNumber(int number) {
              return AccessState.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.chat.v1.Space.AccessSettings.getDescriptor().getEnumTypes().get(0);
      }

      private static final AccessState[] VALUES = values();

      public static AccessState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private AccessState(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.chat.v1.Space.AccessSettings.AccessState)
    }

    public static final int ACCESS_STATE_FIELD_NUMBER = 1;
    private int accessState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Indicates the access state of the space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings.AccessState access_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for accessState.
     */
    @java.lang.Override
    public int getAccessStateValue() {
      return accessState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates the access state of the space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings.AccessState access_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The accessState.
     */
    @java.lang.Override
    public com.google.chat.v1.Space.AccessSettings.AccessState getAccessState() {
      com.google.chat.v1.Space.AccessSettings.AccessState result =
          com.google.chat.v1.Space.AccessSettings.AccessState.forNumber(accessState_);
      return result == null
          ? com.google.chat.v1.Space.AccessSettings.AccessState.UNRECOGNIZED
          : result;
    }

    public static final int AUDIENCE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object audience_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the [target
     * audience](https://support.google.com/a/answer/9934697) who can discover
     * the space, join the space, and preview the messages in the space. For
     * details, see [Make a space discoverable to a target
     * audience](https://developers.google.com/workspace/chat/space-target-audience).
     *
     * Format: `audiences/{audience}`
     *
     * To use the default target audience for the Google Workspace organization,
     * set to `audiences/default`.
     * </pre>
     *
     * <code>string audience = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The audience.
     */
    @java.lang.Override
    public java.lang.String getAudience() {
      java.lang.Object ref = audience_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        audience_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the [target
     * audience](https://support.google.com/a/answer/9934697) who can discover
     * the space, join the space, and preview the messages in the space. For
     * details, see [Make a space discoverable to a target
     * audience](https://developers.google.com/workspace/chat/space-target-audience).
     *
     * Format: `audiences/{audience}`
     *
     * To use the default target audience for the Google Workspace organization,
     * set to `audiences/default`.
     * </pre>
     *
     * <code>string audience = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for audience.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAudienceBytes() {
      java.lang.Object ref = audience_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        audience_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (accessState_
          != com.google.chat.v1.Space.AccessSettings.AccessState.ACCESS_STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, accessState_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audience_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, audience_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (accessState_
          != com.google.chat.v1.Space.AccessSettings.AccessState.ACCESS_STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, accessState_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audience_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, audience_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.chat.v1.Space.AccessSettings)) {
        return super.equals(obj);
      }
      com.google.chat.v1.Space.AccessSettings other = (com.google.chat.v1.Space.AccessSettings) obj;

      if (accessState_ != other.accessState_) return false;
      if (!getAudience().equals(other.getAudience())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ACCESS_STATE_FIELD_NUMBER;
      hash = (53 * hash) + accessState_;
      hash = (37 * hash) + AUDIENCE_FIELD_NUMBER;
      hash = (53 * hash) + getAudience().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.chat.v1.Space.AccessSettings parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.Space.AccessSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.Space.AccessSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.Space.AccessSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.Space.AccessSettings parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.Space.AccessSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.Space.AccessSettings parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.Space.AccessSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.Space.AccessSettings parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.Space.AccessSettings parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.Space.AccessSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.Space.AccessSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.chat.v1.Space.AccessSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * </pre>
     *
     * Protobuf type {@code google.chat.v1.Space.AccessSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.chat.v1.Space.AccessSettings)
        com.google.chat.v1.Space.AccessSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.chat.v1.SpaceProto
            .internal_static_google_chat_v1_Space_AccessSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.chat.v1.SpaceProto
            .internal_static_google_chat_v1_Space_AccessSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.chat.v1.Space.AccessSettings.class,
                com.google.chat.v1.Space.AccessSettings.Builder.class);
      }

      // Construct using com.google.chat.v1.Space.AccessSettings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        accessState_ = 0;
        audience_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.chat.v1.SpaceProto
            .internal_static_google_chat_v1_Space_AccessSettings_descriptor;
      }

      @java.lang.Override
      public com.google.chat.v1.Space.AccessSettings getDefaultInstanceForType() {
        return com.google.chat.v1.Space.AccessSettings.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.chat.v1.Space.AccessSettings build() {
        com.google.chat.v1.Space.AccessSettings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.chat.v1.Space.AccessSettings buildPartial() {
        com.google.chat.v1.Space.AccessSettings result =
            new com.google.chat.v1.Space.AccessSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.chat.v1.Space.AccessSettings result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.accessState_ = accessState_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.audience_ = audience_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.chat.v1.Space.AccessSettings) {
          return mergeFrom((com.google.chat.v1.Space.AccessSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.chat.v1.Space.AccessSettings other) {
        if (other == com.google.chat.v1.Space.AccessSettings.getDefaultInstance()) return this;
        if (other.accessState_ != 0) {
          setAccessStateValue(other.getAccessStateValue());
        }
        if (!other.getAudience().isEmpty()) {
          audience_ = other.audience_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  accessState_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 26:
                {
                  audience_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int accessState_ = 0;
      /**
       *
       *
       * <pre>
       * Output only. Indicates the access state of the space.
       * </pre>
       *
       * <code>
       * .google.chat.v1.Space.AccessSettings.AccessState access_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for accessState.
       */
      @java.lang.Override
      public int getAccessStateValue() {
        return accessState_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Indicates the access state of the space.
       * </pre>
       *
       * <code>
       * .google.chat.v1.Space.AccessSettings.AccessState access_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for accessState to set.
       * @return This builder for chaining.
       */
      public Builder setAccessStateValue(int value) {
        accessState_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Indicates the access state of the space.
       * </pre>
       *
       * <code>
       * .google.chat.v1.Space.AccessSettings.AccessState access_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The accessState.
       */
      @java.lang.Override
      public com.google.chat.v1.Space.AccessSettings.AccessState getAccessState() {
        com.google.chat.v1.Space.AccessSettings.AccessState result =
            com.google.chat.v1.Space.AccessSettings.AccessState.forNumber(accessState_);
        return result == null
            ? com.google.chat.v1.Space.AccessSettings.AccessState.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Output only. Indicates the access state of the space.
       * </pre>
       *
       * <code>
       * .google.chat.v1.Space.AccessSettings.AccessState access_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The accessState to set.
       * @return This builder for chaining.
       */
      public Builder setAccessState(com.google.chat.v1.Space.AccessSettings.AccessState value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        accessState_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Indicates the access state of the space.
       * </pre>
       *
       * <code>
       * .google.chat.v1.Space.AccessSettings.AccessState access_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAccessState() {
        bitField0_ = (bitField0_ & ~0x00000001);
        accessState_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object audience_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The resource name of the [target
       * audience](https://support.google.com/a/answer/9934697) who can discover
       * the space, join the space, and preview the messages in the space. For
       * details, see [Make a space discoverable to a target
       * audience](https://developers.google.com/workspace/chat/space-target-audience).
       *
       * Format: `audiences/{audience}`
       *
       * To use the default target audience for the Google Workspace organization,
       * set to `audiences/default`.
       * </pre>
       *
       * <code>string audience = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The audience.
       */
      public java.lang.String getAudience() {
        java.lang.Object ref = audience_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          audience_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The resource name of the [target
       * audience](https://support.google.com/a/answer/9934697) who can discover
       * the space, join the space, and preview the messages in the space. For
       * details, see [Make a space discoverable to a target
       * audience](https://developers.google.com/workspace/chat/space-target-audience).
       *
       * Format: `audiences/{audience}`
       *
       * To use the default target audience for the Google Workspace organization,
       * set to `audiences/default`.
       * </pre>
       *
       * <code>string audience = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for audience.
       */
      public com.google.protobuf.ByteString getAudienceBytes() {
        java.lang.Object ref = audience_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          audience_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The resource name of the [target
       * audience](https://support.google.com/a/answer/9934697) who can discover
       * the space, join the space, and preview the messages in the space. For
       * details, see [Make a space discoverable to a target
       * audience](https://developers.google.com/workspace/chat/space-target-audience).
       *
       * Format: `audiences/{audience}`
       *
       * To use the default target audience for the Google Workspace organization,
       * set to `audiences/default`.
       * </pre>
       *
       * <code>string audience = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The audience to set.
       * @return This builder for chaining.
       */
      public Builder setAudience(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        audience_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The resource name of the [target
       * audience](https://support.google.com/a/answer/9934697) who can discover
       * the space, join the space, and preview the messages in the space. For
       * details, see [Make a space discoverable to a target
       * audience](https://developers.google.com/workspace/chat/space-target-audience).
       *
       * Format: `audiences/{audience}`
       *
       * To use the default target audience for the Google Workspace organization,
       * set to `audiences/default`.
       * </pre>
       *
       * <code>string audience = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAudience() {
        audience_ = getDefaultInstance().getAudience();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The resource name of the [target
       * audience](https://support.google.com/a/answer/9934697) who can discover
       * the space, join the space, and preview the messages in the space. For
       * details, see [Make a space discoverable to a target
       * audience](https://developers.google.com/workspace/chat/space-target-audience).
       *
       * Format: `audiences/{audience}`
       *
       * To use the default target audience for the Google Workspace organization,
       * set to `audiences/default`.
       * </pre>
       *
       * <code>string audience = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for audience to set.
       * @return This builder for chaining.
       */
      public Builder setAudienceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        audience_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.chat.v1.Space.AccessSettings)
    }

    // @@protoc_insertion_point(class_scope:google.chat.v1.Space.AccessSettings)
    private static final com.google.chat.v1.Space.AccessSettings DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.chat.v1.Space.AccessSettings();
    }

    public static com.google.chat.v1.Space.AccessSettings getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AccessSettings> PARSER =
        new com.google.protobuf.AbstractParser<AccessSettings>() {
          @java.lang.Override
          public AccessSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AccessSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AccessSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.chat.v1.Space.AccessSettings getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Resource name of the space.
   *
   * Format: `spaces/{space}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resource name of the space.
   *
   * Format: `spaces/{space}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Deprecated: Use `space_type` instead.
   * The type of a space.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.chat.v1.Space.type is deprecated. See google/chat/v1/space.proto;l=145
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Deprecated: Use `space_type` instead.
   * The type of a space.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.chat.v1.Space.type is deprecated. See google/chat/v1/space.proto;l=145
   * @return The type.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.chat.v1.Space.Type getType() {
    com.google.chat.v1.Space.Type result = com.google.chat.v1.Space.Type.forNumber(type_);
    return result == null ? com.google.chat.v1.Space.Type.UNRECOGNIZED : result;
  }

  public static final int SPACE_TYPE_FIELD_NUMBER = 10;
  private int spaceType_ = 0;
  /**
   *
   *
   * <pre>
   * The type of space. Required when creating a space or updating the space
   * type of a space. Output only for other usage.
   * </pre>
   *
   * <code>.google.chat.v1.Space.SpaceType space_type = 10;</code>
   *
   * @return The enum numeric value on the wire for spaceType.
   */
  @java.lang.Override
  public int getSpaceTypeValue() {
    return spaceType_;
  }
  /**
   *
   *
   * <pre>
   * The type of space. Required when creating a space or updating the space
   * type of a space. Output only for other usage.
   * </pre>
   *
   * <code>.google.chat.v1.Space.SpaceType space_type = 10;</code>
   *
   * @return The spaceType.
   */
  @java.lang.Override
  public com.google.chat.v1.Space.SpaceType getSpaceType() {
    com.google.chat.v1.Space.SpaceType result =
        com.google.chat.v1.Space.SpaceType.forNumber(spaceType_);
    return result == null ? com.google.chat.v1.Space.SpaceType.UNRECOGNIZED : result;
  }

  public static final int SINGLE_USER_BOT_DM_FIELD_NUMBER = 4;
  private boolean singleUserBotDm_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Whether the space is a DM between a Chat app and a single
   * human.
   * </pre>
   *
   * <code>bool single_user_bot_dm = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The singleUserBotDm.
   */
  @java.lang.Override
  public boolean getSingleUserBotDm() {
    return singleUserBotDm_;
  }

  public static final int THREADED_FIELD_NUMBER = 5;
  private boolean threaded_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Deprecated: Use `spaceThreadingState` instead.
   * Whether messages are threaded in this space.
   * </pre>
   *
   * <code>bool threaded = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @deprecated google.chat.v1.Space.threaded is deprecated. See google/chat/v1/space.proto;l=157
   * @return The threaded.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean getThreaded() {
    return threaded_;
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The space's display name. Required when [creating a
   * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create).
   * If you receive the error message `ALREADY_EXISTS` when creating a space or
   * updating the `displayName`, try a different `displayName`. An
   * existing space within the Google Workspace organization might already use
   * this display name.
   *
   * For direct messages, this field might be empty.
   *
   * Supports up to 128 characters.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The space's display name. Required when [creating a
   * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create).
   * If you receive the error message `ALREADY_EXISTS` when creating a space or
   * updating the `displayName`, try a different `displayName`. An
   * existing space within the Google Workspace organization might already use
   * this display name.
   *
   * For direct messages, this field might be empty.
   *
   * Supports up to 128 characters.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXTERNAL_USER_ALLOWED_FIELD_NUMBER = 8;
  private boolean externalUserAllowed_ = false;
  /**
   *
   *
   * <pre>
   * Immutable. Whether this space permits any Google Chat user as a member.
   * Input when creating a space in a Google Workspace organization. Omit this
   * field when creating spaces in the following conditions:
   *
   *   * The authenticated user uses a consumer account (unmanaged user
   *     account). By default, a space created by a consumer account permits any
   *     Google Chat user.
   *
   *   * The space is used to [import data to Google Chat]
   *     (https://developers.google.com/chat/api/guides/import-data-overview)
   *     because import mode spaces must only permit members from the same
   *     Google Workspace organization. However, as part of the [Google
   *     Workspace Developer Preview
   *     Program](https://developers.google.com/workspace/preview), import mode
   *     spaces can permit any Google Chat user so this field can then be set
   *     for import mode spaces.
   *
   * For existing spaces, this field is output only.
   * </pre>
   *
   * <code>bool external_user_allowed = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The externalUserAllowed.
   */
  @java.lang.Override
  public boolean getExternalUserAllowed() {
    return externalUserAllowed_;
  }

  public static final int SPACE_THREADING_STATE_FIELD_NUMBER = 9;
  private int spaceThreadingState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The threading state in the Chat space.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for spaceThreadingState.
   */
  @java.lang.Override
  public int getSpaceThreadingStateValue() {
    return spaceThreadingState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The threading state in the Chat space.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The spaceThreadingState.
   */
  @java.lang.Override
  public com.google.chat.v1.Space.SpaceThreadingState getSpaceThreadingState() {
    com.google.chat.v1.Space.SpaceThreadingState result =
        com.google.chat.v1.Space.SpaceThreadingState.forNumber(spaceThreadingState_);
    return result == null ? com.google.chat.v1.Space.SpaceThreadingState.UNRECOGNIZED : result;
  }

  public static final int SPACE_DETAILS_FIELD_NUMBER = 11;
  private com.google.chat.v1.Space.SpaceDetails spaceDetails_;
  /**
   *
   *
   * <pre>
   * Details about the space including description and rules.
   * </pre>
   *
   * <code>.google.chat.v1.Space.SpaceDetails space_details = 11;</code>
   *
   * @return Whether the spaceDetails field is set.
   */
  @java.lang.Override
  public boolean hasSpaceDetails() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Details about the space including description and rules.
   * </pre>
   *
   * <code>.google.chat.v1.Space.SpaceDetails space_details = 11;</code>
   *
   * @return The spaceDetails.
   */
  @java.lang.Override
  public com.google.chat.v1.Space.SpaceDetails getSpaceDetails() {
    return spaceDetails_ == null
        ? com.google.chat.v1.Space.SpaceDetails.getDefaultInstance()
        : spaceDetails_;
  }
  /**
   *
   *
   * <pre>
   * Details about the space including description and rules.
   * </pre>
   *
   * <code>.google.chat.v1.Space.SpaceDetails space_details = 11;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.Space.SpaceDetailsOrBuilder getSpaceDetailsOrBuilder() {
    return spaceDetails_ == null
        ? com.google.chat.v1.Space.SpaceDetails.getDefaultInstance()
        : spaceDetails_;
  }

  public static final int SPACE_HISTORY_STATE_FIELD_NUMBER = 13;
  private int spaceHistoryState_ = 0;
  /**
   *
   *
   * <pre>
   * The message history state for messages and threads in this space.
   * </pre>
   *
   * <code>.google.chat.v1.HistoryState space_history_state = 13;</code>
   *
   * @return The enum numeric value on the wire for spaceHistoryState.
   */
  @java.lang.Override
  public int getSpaceHistoryStateValue() {
    return spaceHistoryState_;
  }
  /**
   *
   *
   * <pre>
   * The message history state for messages and threads in this space.
   * </pre>
   *
   * <code>.google.chat.v1.HistoryState space_history_state = 13;</code>
   *
   * @return The spaceHistoryState.
   */
  @java.lang.Override
  public com.google.chat.v1.HistoryState getSpaceHistoryState() {
    com.google.chat.v1.HistoryState result =
        com.google.chat.v1.HistoryState.forNumber(spaceHistoryState_);
    return result == null ? com.google.chat.v1.HistoryState.UNRECOGNIZED : result;
  }

  public static final int IMPORT_MODE_FIELD_NUMBER = 16;
  private boolean importMode_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Whether this space is created in `Import Mode` as part of a data
   * migration into Google Workspace. While spaces are being imported, they
   * aren't visible to users until the import is complete.
   * </pre>
   *
   * <code>bool import_mode = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The importMode.
   */
  @java.lang.Override
  public boolean getImportMode() {
    return importMode_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 17;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Optional. Immutable. For spaces created in Chat, the time the space was
   * created. This field is output only, except when used in import mode spaces.
   *
   * For import mode spaces, set this field to the historical timestamp at which
   * the space was created in the source in order to preserve the original
   * creation time.
   *
   * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Immutable. For spaces created in Chat, the time the space was
   * created. This field is output only, except when used in import mode spaces.
   *
   * For import mode spaces, set this field to the historical timestamp at which
   * the space was created in the source in order to preserve the original
   * creation time.
   *
   * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Immutable. For spaces created in Chat, the time the space was
   * created. This field is output only, except when used in import mode spaces.
   *
   * For import mode spaces, set this field to the historical timestamp at which
   * the space was created in the source in order to preserve the original
   * creation time.
   *
   * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int ADMIN_INSTALLED_FIELD_NUMBER = 19;
  private boolean adminInstalled_ = false;
  /**
   *
   *
   * <pre>
   * Output only. For direct message (DM) spaces with a Chat app, whether the
   * space was created by a Google Workspace administrator. Administrators can
   * install and set up a direct message with a Chat app on behalf of users in
   * their organization.
   *
   * To support admin install, your Chat app must feature direct messaging.
   * </pre>
   *
   * <code>bool admin_installed = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The adminInstalled.
   */
  @java.lang.Override
  public boolean getAdminInstalled() {
    return adminInstalled_;
  }

  public static final int ACCESS_SETTINGS_FIELD_NUMBER = 23;
  private com.google.chat.v1.Space.AccessSettings accessSettings_;
  /**
   *
   *
   * <pre>
   * Optional. Specifies the [access
   * setting](https://support.google.com/chat/answer/11971020) of the space.
   * Only populated when the `space_type` is `SPACE`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the accessSettings field is set.
   */
  @java.lang.Override
  public boolean hasAccessSettings() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies the [access
   * setting](https://support.google.com/chat/answer/11971020) of the space.
   * Only populated when the `space_type` is `SPACE`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The accessSettings.
   */
  @java.lang.Override
  public com.google.chat.v1.Space.AccessSettings getAccessSettings() {
    return accessSettings_ == null
        ? com.google.chat.v1.Space.AccessSettings.getDefaultInstance()
        : accessSettings_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies the [access
   * setting](https://support.google.com/chat/answer/11971020) of the space.
   * Only populated when the `space_type` is `SPACE`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.Space.AccessSettingsOrBuilder getAccessSettingsOrBuilder() {
    return accessSettings_ == null
        ? com.google.chat.v1.Space.AccessSettings.getDefaultInstance()
        : accessSettings_;
  }

  public static final int SPACE_URI_FIELD_NUMBER = 25;

  @SuppressWarnings("serial")
  private volatile java.lang.Object spaceUri_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The URI for a user to access the space.
   * </pre>
   *
   * <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The spaceUri.
   */
  @java.lang.Override
  public java.lang.String getSpaceUri() {
    java.lang.Object ref = spaceUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      spaceUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The URI for a user to access the space.
   * </pre>
   *
   * <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for spaceUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSpaceUriBytes() {
    java.lang.Object ref = spaceUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      spaceUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (type_ != com.google.chat.v1.Space.Type.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
    }
    if (singleUserBotDm_ != false) {
      output.writeBool(4, singleUserBotDm_);
    }
    if (threaded_ != false) {
      output.writeBool(5, threaded_);
    }
    if (externalUserAllowed_ != false) {
      output.writeBool(8, externalUserAllowed_);
    }
    if (spaceThreadingState_
        != com.google.chat.v1.Space.SpaceThreadingState.SPACE_THREADING_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(9, spaceThreadingState_);
    }
    if (spaceType_ != com.google.chat.v1.Space.SpaceType.SPACE_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(10, spaceType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(11, getSpaceDetails());
    }
    if (spaceHistoryState_
        != com.google.chat.v1.HistoryState.HISTORY_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(13, spaceHistoryState_);
    }
    if (importMode_ != false) {
      output.writeBool(16, importMode_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(17, getCreateTime());
    }
    if (adminInstalled_ != false) {
      output.writeBool(19, adminInstalled_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(23, getAccessSettings());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(spaceUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 25, spaceUri_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (type_ != com.google.chat.v1.Space.Type.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
    }
    if (singleUserBotDm_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, singleUserBotDm_);
    }
    if (threaded_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, threaded_);
    }
    if (externalUserAllowed_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, externalUserAllowed_);
    }
    if (spaceThreadingState_
        != com.google.chat.v1.Space.SpaceThreadingState.SPACE_THREADING_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, spaceThreadingState_);
    }
    if (spaceType_ != com.google.chat.v1.Space.SpaceType.SPACE_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, spaceType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getSpaceDetails());
    }
    if (spaceHistoryState_
        != com.google.chat.v1.HistoryState.HISTORY_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(13, spaceHistoryState_);
    }
    if (importMode_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(16, importMode_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getCreateTime());
    }
    if (adminInstalled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(19, adminInstalled_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getAccessSettings());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(spaceUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(25, spaceUri_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.Space)) {
      return super.equals(obj);
    }
    com.google.chat.v1.Space other = (com.google.chat.v1.Space) obj;

    if (!getName().equals(other.getName())) return false;
    if (type_ != other.type_) return false;
    if (spaceType_ != other.spaceType_) return false;
    if (getSingleUserBotDm() != other.getSingleUserBotDm()) return false;
    if (getThreaded() != other.getThreaded()) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (getExternalUserAllowed() != other.getExternalUserAllowed()) return false;
    if (spaceThreadingState_ != other.spaceThreadingState_) return false;
    if (hasSpaceDetails() != other.hasSpaceDetails()) return false;
    if (hasSpaceDetails()) {
      if (!getSpaceDetails().equals(other.getSpaceDetails())) return false;
    }
    if (spaceHistoryState_ != other.spaceHistoryState_) return false;
    if (getImportMode() != other.getImportMode()) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (getAdminInstalled() != other.getAdminInstalled()) return false;
    if (hasAccessSettings() != other.hasAccessSettings()) return false;
    if (hasAccessSettings()) {
      if (!getAccessSettings().equals(other.getAccessSettings())) return false;
    }
    if (!getSpaceUri().equals(other.getSpaceUri())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + SPACE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + spaceType_;
    hash = (37 * hash) + SINGLE_USER_BOT_DM_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSingleUserBotDm());
    hash = (37 * hash) + THREADED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getThreaded());
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + EXTERNAL_USER_ALLOWED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExternalUserAllowed());
    hash = (37 * hash) + SPACE_THREADING_STATE_FIELD_NUMBER;
    hash = (53 * hash) + spaceThreadingState_;
    if (hasSpaceDetails()) {
      hash = (37 * hash) + SPACE_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getSpaceDetails().hashCode();
    }
    hash = (37 * hash) + SPACE_HISTORY_STATE_FIELD_NUMBER;
    hash = (53 * hash) + spaceHistoryState_;
    hash = (37 * hash) + IMPORT_MODE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getImportMode());
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + ADMIN_INSTALLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAdminInstalled());
    if (hasAccessSettings()) {
      hash = (37 * hash) + ACCESS_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getAccessSettings().hashCode();
    }
    hash = (37 * hash) + SPACE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getSpaceUri().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.Space parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.Space parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.Space parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.Space parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.Space parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.Space parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.Space parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.Space parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.Space parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.Space parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.Space parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.Space parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.Space prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A space in Google Chat. Spaces are conversations between two or more users
   * or 1:1 messages between a user and a Chat app.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.Space}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.Space)
      com.google.chat.v1.SpaceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.SpaceProto.internal_static_google_chat_v1_Space_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.SpaceProto.internal_static_google_chat_v1_Space_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.Space.class, com.google.chat.v1.Space.Builder.class);
    }

    // Construct using com.google.chat.v1.Space.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSpaceDetailsFieldBuilder();
        getCreateTimeFieldBuilder();
        getAccessSettingsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      type_ = 0;
      spaceType_ = 0;
      singleUserBotDm_ = false;
      threaded_ = false;
      displayName_ = "";
      externalUserAllowed_ = false;
      spaceThreadingState_ = 0;
      spaceDetails_ = null;
      if (spaceDetailsBuilder_ != null) {
        spaceDetailsBuilder_.dispose();
        spaceDetailsBuilder_ = null;
      }
      spaceHistoryState_ = 0;
      importMode_ = false;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      adminInstalled_ = false;
      accessSettings_ = null;
      if (accessSettingsBuilder_ != null) {
        accessSettingsBuilder_.dispose();
        accessSettingsBuilder_ = null;
      }
      spaceUri_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.SpaceProto.internal_static_google_chat_v1_Space_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.Space getDefaultInstanceForType() {
      return com.google.chat.v1.Space.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.Space build() {
      com.google.chat.v1.Space result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.Space buildPartial() {
      com.google.chat.v1.Space result = new com.google.chat.v1.Space(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.chat.v1.Space result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.spaceType_ = spaceType_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.singleUserBotDm_ = singleUserBotDm_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.threaded_ = threaded_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.externalUserAllowed_ = externalUserAllowed_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.spaceThreadingState_ = spaceThreadingState_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.spaceDetails_ =
            spaceDetailsBuilder_ == null ? spaceDetails_ : spaceDetailsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.spaceHistoryState_ = spaceHistoryState_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.importMode_ = importMode_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.adminInstalled_ = adminInstalled_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.accessSettings_ =
            accessSettingsBuilder_ == null ? accessSettings_ : accessSettingsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.spaceUri_ = spaceUri_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.Space) {
        return mergeFrom((com.google.chat.v1.Space) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.Space other) {
      if (other == com.google.chat.v1.Space.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.spaceType_ != 0) {
        setSpaceTypeValue(other.getSpaceTypeValue());
      }
      if (other.getSingleUserBotDm() != false) {
        setSingleUserBotDm(other.getSingleUserBotDm());
      }
      if (other.getThreaded() != false) {
        setThreaded(other.getThreaded());
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.getExternalUserAllowed() != false) {
        setExternalUserAllowed(other.getExternalUserAllowed());
      }
      if (other.spaceThreadingState_ != 0) {
        setSpaceThreadingStateValue(other.getSpaceThreadingStateValue());
      }
      if (other.hasSpaceDetails()) {
        mergeSpaceDetails(other.getSpaceDetails());
      }
      if (other.spaceHistoryState_ != 0) {
        setSpaceHistoryStateValue(other.getSpaceHistoryStateValue());
      }
      if (other.getImportMode() != false) {
        setImportMode(other.getImportMode());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.getAdminInstalled() != false) {
        setAdminInstalled(other.getAdminInstalled());
      }
      if (other.hasAccessSettings()) {
        mergeAccessSettings(other.getAccessSettings());
      }
      if (!other.getSpaceUri().isEmpty()) {
        spaceUri_ = other.spaceUri_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 26
            case 32:
              {
                singleUserBotDm_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                threaded_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 64:
              {
                externalUserAllowed_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 64
            case 72:
              {
                spaceThreadingState_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 72
            case 80:
              {
                spaceType_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 80
            case 90:
              {
                input.readMessage(getSpaceDetailsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 90
            case 104:
              {
                spaceHistoryState_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 104
            case 128:
              {
                importMode_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 128
            case 138:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 138
            case 152:
              {
                adminInstalled_ = input.readBool();
                bitField0_ |= 0x00001000;
                break;
              } // case 152
            case 186:
              {
                input.readMessage(getAccessSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 186
            case 202:
              {
                spaceUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 202
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Resource name of the space.
     *
     * Format: `spaces/{space}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of the space.
     *
     * Format: `spaces/{space}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of the space.
     *
     * Format: `spaces/{space}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of the space.
     *
     * Format: `spaces/{space}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of the space.
     *
     * Format: `spaces/{space}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Deprecated: Use `space_type` instead.
     * The type of a space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.chat.v1.Space.type is deprecated. See google/chat/v1/space.proto;l=145
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated: Use `space_type` instead.
     * The type of a space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.chat.v1.Space.type is deprecated. See google/chat/v1/space.proto;l=145
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated: Use `space_type` instead.
     * The type of a space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.chat.v1.Space.type is deprecated. See google/chat/v1/space.proto;l=145
     * @return The type.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.chat.v1.Space.Type getType() {
      com.google.chat.v1.Space.Type result = com.google.chat.v1.Space.Type.forNumber(type_);
      return result == null ? com.google.chat.v1.Space.Type.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated: Use `space_type` instead.
     * The type of a space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.chat.v1.Space.type is deprecated. See google/chat/v1/space.proto;l=145
     * @param value The type to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setType(com.google.chat.v1.Space.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated: Use `space_type` instead.
     * The type of a space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.chat.v1.Space.type is deprecated. See google/chat/v1/space.proto;l=145
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      type_ = 0;
      onChanged();
      return this;
    }

    private int spaceType_ = 0;
    /**
     *
     *
     * <pre>
     * The type of space. Required when creating a space or updating the space
     * type of a space. Output only for other usage.
     * </pre>
     *
     * <code>.google.chat.v1.Space.SpaceType space_type = 10;</code>
     *
     * @return The enum numeric value on the wire for spaceType.
     */
    @java.lang.Override
    public int getSpaceTypeValue() {
      return spaceType_;
    }
    /**
     *
     *
     * <pre>
     * The type of space. Required when creating a space or updating the space
     * type of a space. Output only for other usage.
     * </pre>
     *
     * <code>.google.chat.v1.Space.SpaceType space_type = 10;</code>
     *
     * @param value The enum numeric value on the wire for spaceType to set.
     * @return This builder for chaining.
     */
    public Builder setSpaceTypeValue(int value) {
      spaceType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of space. Required when creating a space or updating the space
     * type of a space. Output only for other usage.
     * </pre>
     *
     * <code>.google.chat.v1.Space.SpaceType space_type = 10;</code>
     *
     * @return The spaceType.
     */
    @java.lang.Override
    public com.google.chat.v1.Space.SpaceType getSpaceType() {
      com.google.chat.v1.Space.SpaceType result =
          com.google.chat.v1.Space.SpaceType.forNumber(spaceType_);
      return result == null ? com.google.chat.v1.Space.SpaceType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The type of space. Required when creating a space or updating the space
     * type of a space. Output only for other usage.
     * </pre>
     *
     * <code>.google.chat.v1.Space.SpaceType space_type = 10;</code>
     *
     * @param value The spaceType to set.
     * @return This builder for chaining.
     */
    public Builder setSpaceType(com.google.chat.v1.Space.SpaceType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      spaceType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of space. Required when creating a space or updating the space
     * type of a space. Output only for other usage.
     * </pre>
     *
     * <code>.google.chat.v1.Space.SpaceType space_type = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpaceType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      spaceType_ = 0;
      onChanged();
      return this;
    }

    private boolean singleUserBotDm_;
    /**
     *
     *
     * <pre>
     * Optional. Whether the space is a DM between a Chat app and a single
     * human.
     * </pre>
     *
     * <code>bool single_user_bot_dm = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The singleUserBotDm.
     */
    @java.lang.Override
    public boolean getSingleUserBotDm() {
      return singleUserBotDm_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether the space is a DM between a Chat app and a single
     * human.
     * </pre>
     *
     * <code>bool single_user_bot_dm = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The singleUserBotDm to set.
     * @return This builder for chaining.
     */
    public Builder setSingleUserBotDm(boolean value) {

      singleUserBotDm_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether the space is a DM between a Chat app and a single
     * human.
     * </pre>
     *
     * <code>bool single_user_bot_dm = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSingleUserBotDm() {
      bitField0_ = (bitField0_ & ~0x00000008);
      singleUserBotDm_ = false;
      onChanged();
      return this;
    }

    private boolean threaded_;
    /**
     *
     *
     * <pre>
     * Output only. Deprecated: Use `spaceThreadingState` instead.
     * Whether messages are threaded in this space.
     * </pre>
     *
     * <code>bool threaded = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.chat.v1.Space.threaded is deprecated. See google/chat/v1/space.proto;l=157
     * @return The threaded.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean getThreaded() {
      return threaded_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated: Use `spaceThreadingState` instead.
     * Whether messages are threaded in this space.
     * </pre>
     *
     * <code>bool threaded = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.chat.v1.Space.threaded is deprecated. See google/chat/v1/space.proto;l=157
     * @param value The threaded to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setThreaded(boolean value) {

      threaded_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated: Use `spaceThreadingState` instead.
     * Whether messages are threaded in this space.
     * </pre>
     *
     * <code>bool threaded = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.chat.v1.Space.threaded is deprecated. See google/chat/v1/space.proto;l=157
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearThreaded() {
      bitField0_ = (bitField0_ & ~0x00000010);
      threaded_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The space's display name. Required when [creating a
     * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create).
     * If you receive the error message `ALREADY_EXISTS` when creating a space or
     * updating the `displayName`, try a different `displayName`. An
     * existing space within the Google Workspace organization might already use
     * this display name.
     *
     * For direct messages, this field might be empty.
     *
     * Supports up to 128 characters.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The space's display name. Required when [creating a
     * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create).
     * If you receive the error message `ALREADY_EXISTS` when creating a space or
     * updating the `displayName`, try a different `displayName`. An
     * existing space within the Google Workspace organization might already use
     * this display name.
     *
     * For direct messages, this field might be empty.
     *
     * Supports up to 128 characters.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The space's display name. Required when [creating a
     * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create).
     * If you receive the error message `ALREADY_EXISTS` when creating a space or
     * updating the `displayName`, try a different `displayName`. An
     * existing space within the Google Workspace organization might already use
     * this display name.
     *
     * For direct messages, this field might be empty.
     *
     * Supports up to 128 characters.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The space's display name. Required when [creating a
     * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create).
     * If you receive the error message `ALREADY_EXISTS` when creating a space or
     * updating the `displayName`, try a different `displayName`. An
     * existing space within the Google Workspace organization might already use
     * this display name.
     *
     * For direct messages, this field might be empty.
     *
     * Supports up to 128 characters.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The space's display name. Required when [creating a
     * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create).
     * If you receive the error message `ALREADY_EXISTS` when creating a space or
     * updating the `displayName`, try a different `displayName`. An
     * existing space within the Google Workspace organization might already use
     * this display name.
     *
     * For direct messages, this field might be empty.
     *
     * Supports up to 128 characters.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private boolean externalUserAllowed_;
    /**
     *
     *
     * <pre>
     * Immutable. Whether this space permits any Google Chat user as a member.
     * Input when creating a space in a Google Workspace organization. Omit this
     * field when creating spaces in the following conditions:
     *
     *   * The authenticated user uses a consumer account (unmanaged user
     *     account). By default, a space created by a consumer account permits any
     *     Google Chat user.
     *
     *   * The space is used to [import data to Google Chat]
     *     (https://developers.google.com/chat/api/guides/import-data-overview)
     *     because import mode spaces must only permit members from the same
     *     Google Workspace organization. However, as part of the [Google
     *     Workspace Developer Preview
     *     Program](https://developers.google.com/workspace/preview), import mode
     *     spaces can permit any Google Chat user so this field can then be set
     *     for import mode spaces.
     *
     * For existing spaces, this field is output only.
     * </pre>
     *
     * <code>bool external_user_allowed = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The externalUserAllowed.
     */
    @java.lang.Override
    public boolean getExternalUserAllowed() {
      return externalUserAllowed_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Whether this space permits any Google Chat user as a member.
     * Input when creating a space in a Google Workspace organization. Omit this
     * field when creating spaces in the following conditions:
     *
     *   * The authenticated user uses a consumer account (unmanaged user
     *     account). By default, a space created by a consumer account permits any
     *     Google Chat user.
     *
     *   * The space is used to [import data to Google Chat]
     *     (https://developers.google.com/chat/api/guides/import-data-overview)
     *     because import mode spaces must only permit members from the same
     *     Google Workspace organization. However, as part of the [Google
     *     Workspace Developer Preview
     *     Program](https://developers.google.com/workspace/preview), import mode
     *     spaces can permit any Google Chat user so this field can then be set
     *     for import mode spaces.
     *
     * For existing spaces, this field is output only.
     * </pre>
     *
     * <code>bool external_user_allowed = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The externalUserAllowed to set.
     * @return This builder for chaining.
     */
    public Builder setExternalUserAllowed(boolean value) {

      externalUserAllowed_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Whether this space permits any Google Chat user as a member.
     * Input when creating a space in a Google Workspace organization. Omit this
     * field when creating spaces in the following conditions:
     *
     *   * The authenticated user uses a consumer account (unmanaged user
     *     account). By default, a space created by a consumer account permits any
     *     Google Chat user.
     *
     *   * The space is used to [import data to Google Chat]
     *     (https://developers.google.com/chat/api/guides/import-data-overview)
     *     because import mode spaces must only permit members from the same
     *     Google Workspace organization. However, as part of the [Google
     *     Workspace Developer Preview
     *     Program](https://developers.google.com/workspace/preview), import mode
     *     spaces can permit any Google Chat user so this field can then be set
     *     for import mode spaces.
     *
     * For existing spaces, this field is output only.
     * </pre>
     *
     * <code>bool external_user_allowed = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExternalUserAllowed() {
      bitField0_ = (bitField0_ & ~0x00000040);
      externalUserAllowed_ = false;
      onChanged();
      return this;
    }

    private int spaceThreadingState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The threading state in the Chat space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for spaceThreadingState.
     */
    @java.lang.Override
    public int getSpaceThreadingStateValue() {
      return spaceThreadingState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The threading state in the Chat space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for spaceThreadingState to set.
     * @return This builder for chaining.
     */
    public Builder setSpaceThreadingStateValue(int value) {
      spaceThreadingState_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The threading state in the Chat space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The spaceThreadingState.
     */
    @java.lang.Override
    public com.google.chat.v1.Space.SpaceThreadingState getSpaceThreadingState() {
      com.google.chat.v1.Space.SpaceThreadingState result =
          com.google.chat.v1.Space.SpaceThreadingState.forNumber(spaceThreadingState_);
      return result == null ? com.google.chat.v1.Space.SpaceThreadingState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The threading state in the Chat space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The spaceThreadingState to set.
     * @return This builder for chaining.
     */
    public Builder setSpaceThreadingState(com.google.chat.v1.Space.SpaceThreadingState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      spaceThreadingState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The threading state in the Chat space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpaceThreadingState() {
      bitField0_ = (bitField0_ & ~0x00000080);
      spaceThreadingState_ = 0;
      onChanged();
      return this;
    }

    private com.google.chat.v1.Space.SpaceDetails spaceDetails_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Space.SpaceDetails,
            com.google.chat.v1.Space.SpaceDetails.Builder,
            com.google.chat.v1.Space.SpaceDetailsOrBuilder>
        spaceDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details about the space including description and rules.
     * </pre>
     *
     * <code>.google.chat.v1.Space.SpaceDetails space_details = 11;</code>
     *
     * @return Whether the spaceDetails field is set.
     */
    public boolean hasSpaceDetails() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Details about the space including description and rules.
     * </pre>
     *
     * <code>.google.chat.v1.Space.SpaceDetails space_details = 11;</code>
     *
     * @return The spaceDetails.
     */
    public com.google.chat.v1.Space.SpaceDetails getSpaceDetails() {
      if (spaceDetailsBuilder_ == null) {
        return spaceDetails_ == null
            ? com.google.chat.v1.Space.SpaceDetails.getDefaultInstance()
            : spaceDetails_;
      } else {
        return spaceDetailsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Details about the space including description and rules.
     * </pre>
     *
     * <code>.google.chat.v1.Space.SpaceDetails space_details = 11;</code>
     */
    public Builder setSpaceDetails(com.google.chat.v1.Space.SpaceDetails value) {
      if (spaceDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        spaceDetails_ = value;
      } else {
        spaceDetailsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the space including description and rules.
     * </pre>
     *
     * <code>.google.chat.v1.Space.SpaceDetails space_details = 11;</code>
     */
    public Builder setSpaceDetails(com.google.chat.v1.Space.SpaceDetails.Builder builderForValue) {
      if (spaceDetailsBuilder_ == null) {
        spaceDetails_ = builderForValue.build();
      } else {
        spaceDetailsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the space including description and rules.
     * </pre>
     *
     * <code>.google.chat.v1.Space.SpaceDetails space_details = 11;</code>
     */
    public Builder mergeSpaceDetails(com.google.chat.v1.Space.SpaceDetails value) {
      if (spaceDetailsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && spaceDetails_ != null
            && spaceDetails_ != com.google.chat.v1.Space.SpaceDetails.getDefaultInstance()) {
          getSpaceDetailsBuilder().mergeFrom(value);
        } else {
          spaceDetails_ = value;
        }
      } else {
        spaceDetailsBuilder_.mergeFrom(value);
      }
      if (spaceDetails_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the space including description and rules.
     * </pre>
     *
     * <code>.google.chat.v1.Space.SpaceDetails space_details = 11;</code>
     */
    public Builder clearSpaceDetails() {
      bitField0_ = (bitField0_ & ~0x00000100);
      spaceDetails_ = null;
      if (spaceDetailsBuilder_ != null) {
        spaceDetailsBuilder_.dispose();
        spaceDetailsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about the space including description and rules.
     * </pre>
     *
     * <code>.google.chat.v1.Space.SpaceDetails space_details = 11;</code>
     */
    public com.google.chat.v1.Space.SpaceDetails.Builder getSpaceDetailsBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getSpaceDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details about the space including description and rules.
     * </pre>
     *
     * <code>.google.chat.v1.Space.SpaceDetails space_details = 11;</code>
     */
    public com.google.chat.v1.Space.SpaceDetailsOrBuilder getSpaceDetailsOrBuilder() {
      if (spaceDetailsBuilder_ != null) {
        return spaceDetailsBuilder_.getMessageOrBuilder();
      } else {
        return spaceDetails_ == null
            ? com.google.chat.v1.Space.SpaceDetails.getDefaultInstance()
            : spaceDetails_;
      }
    }
    /**
     *
     *
     * <pre>
     * Details about the space including description and rules.
     * </pre>
     *
     * <code>.google.chat.v1.Space.SpaceDetails space_details = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Space.SpaceDetails,
            com.google.chat.v1.Space.SpaceDetails.Builder,
            com.google.chat.v1.Space.SpaceDetailsOrBuilder>
        getSpaceDetailsFieldBuilder() {
      if (spaceDetailsBuilder_ == null) {
        spaceDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.Space.SpaceDetails,
                com.google.chat.v1.Space.SpaceDetails.Builder,
                com.google.chat.v1.Space.SpaceDetailsOrBuilder>(
                getSpaceDetails(), getParentForChildren(), isClean());
        spaceDetails_ = null;
      }
      return spaceDetailsBuilder_;
    }

    private int spaceHistoryState_ = 0;
    /**
     *
     *
     * <pre>
     * The message history state for messages and threads in this space.
     * </pre>
     *
     * <code>.google.chat.v1.HistoryState space_history_state = 13;</code>
     *
     * @return The enum numeric value on the wire for spaceHistoryState.
     */
    @java.lang.Override
    public int getSpaceHistoryStateValue() {
      return spaceHistoryState_;
    }
    /**
     *
     *
     * <pre>
     * The message history state for messages and threads in this space.
     * </pre>
     *
     * <code>.google.chat.v1.HistoryState space_history_state = 13;</code>
     *
     * @param value The enum numeric value on the wire for spaceHistoryState to set.
     * @return This builder for chaining.
     */
    public Builder setSpaceHistoryStateValue(int value) {
      spaceHistoryState_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The message history state for messages and threads in this space.
     * </pre>
     *
     * <code>.google.chat.v1.HistoryState space_history_state = 13;</code>
     *
     * @return The spaceHistoryState.
     */
    @java.lang.Override
    public com.google.chat.v1.HistoryState getSpaceHistoryState() {
      com.google.chat.v1.HistoryState result =
          com.google.chat.v1.HistoryState.forNumber(spaceHistoryState_);
      return result == null ? com.google.chat.v1.HistoryState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The message history state for messages and threads in this space.
     * </pre>
     *
     * <code>.google.chat.v1.HistoryState space_history_state = 13;</code>
     *
     * @param value The spaceHistoryState to set.
     * @return This builder for chaining.
     */
    public Builder setSpaceHistoryState(com.google.chat.v1.HistoryState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      spaceHistoryState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The message history state for messages and threads in this space.
     * </pre>
     *
     * <code>.google.chat.v1.HistoryState space_history_state = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpaceHistoryState() {
      bitField0_ = (bitField0_ & ~0x00000200);
      spaceHistoryState_ = 0;
      onChanged();
      return this;
    }

    private boolean importMode_;
    /**
     *
     *
     * <pre>
     * Optional. Whether this space is created in `Import Mode` as part of a data
     * migration into Google Workspace. While spaces are being imported, they
     * aren't visible to users until the import is complete.
     * </pre>
     *
     * <code>bool import_mode = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The importMode.
     */
    @java.lang.Override
    public boolean getImportMode() {
      return importMode_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether this space is created in `Import Mode` as part of a data
     * migration into Google Workspace. While spaces are being imported, they
     * aren't visible to users until the import is complete.
     * </pre>
     *
     * <code>bool import_mode = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The importMode to set.
     * @return This builder for chaining.
     */
    public Builder setImportMode(boolean value) {

      importMode_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether this space is created in `Import Mode` as part of a data
     * migration into Google Workspace. While spaces are being imported, they
     * aren't visible to users until the import is complete.
     * </pre>
     *
     * <code>bool import_mode = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportMode() {
      bitField0_ = (bitField0_ & ~0x00000400);
      importMode_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     *
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     *
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     *
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     *
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     *
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     *
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000800);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     *
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     *
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     *
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private boolean adminInstalled_;
    /**
     *
     *
     * <pre>
     * Output only. For direct message (DM) spaces with a Chat app, whether the
     * space was created by a Google Workspace administrator. Administrators can
     * install and set up a direct message with a Chat app on behalf of users in
     * their organization.
     *
     * To support admin install, your Chat app must feature direct messaging.
     * </pre>
     *
     * <code>bool admin_installed = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The adminInstalled.
     */
    @java.lang.Override
    public boolean getAdminInstalled() {
      return adminInstalled_;
    }
    /**
     *
     *
     * <pre>
     * Output only. For direct message (DM) spaces with a Chat app, whether the
     * space was created by a Google Workspace administrator. Administrators can
     * install and set up a direct message with a Chat app on behalf of users in
     * their organization.
     *
     * To support admin install, your Chat app must feature direct messaging.
     * </pre>
     *
     * <code>bool admin_installed = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The adminInstalled to set.
     * @return This builder for chaining.
     */
    public Builder setAdminInstalled(boolean value) {

      adminInstalled_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For direct message (DM) spaces with a Chat app, whether the
     * space was created by a Google Workspace administrator. Administrators can
     * install and set up a direct message with a Chat app on behalf of users in
     * their organization.
     *
     * To support admin install, your Chat app must feature direct messaging.
     * </pre>
     *
     * <code>bool admin_installed = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdminInstalled() {
      bitField0_ = (bitField0_ & ~0x00001000);
      adminInstalled_ = false;
      onChanged();
      return this;
    }

    private com.google.chat.v1.Space.AccessSettings accessSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Space.AccessSettings,
            com.google.chat.v1.Space.AccessSettings.Builder,
            com.google.chat.v1.Space.AccessSettingsOrBuilder>
        accessSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the accessSettings field is set.
     */
    public boolean hasAccessSettings() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The accessSettings.
     */
    public com.google.chat.v1.Space.AccessSettings getAccessSettings() {
      if (accessSettingsBuilder_ == null) {
        return accessSettings_ == null
            ? com.google.chat.v1.Space.AccessSettings.getDefaultInstance()
            : accessSettings_;
      } else {
        return accessSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAccessSettings(com.google.chat.v1.Space.AccessSettings value) {
      if (accessSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        accessSettings_ = value;
      } else {
        accessSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAccessSettings(
        com.google.chat.v1.Space.AccessSettings.Builder builderForValue) {
      if (accessSettingsBuilder_ == null) {
        accessSettings_ = builderForValue.build();
      } else {
        accessSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAccessSettings(com.google.chat.v1.Space.AccessSettings value) {
      if (accessSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && accessSettings_ != null
            && accessSettings_ != com.google.chat.v1.Space.AccessSettings.getDefaultInstance()) {
          getAccessSettingsBuilder().mergeFrom(value);
        } else {
          accessSettings_ = value;
        }
      } else {
        accessSettingsBuilder_.mergeFrom(value);
      }
      if (accessSettings_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAccessSettings() {
      bitField0_ = (bitField0_ & ~0x00002000);
      accessSettings_ = null;
      if (accessSettingsBuilder_ != null) {
        accessSettingsBuilder_.dispose();
        accessSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.Space.AccessSettings.Builder getAccessSettingsBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getAccessSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.Space.AccessSettingsOrBuilder getAccessSettingsOrBuilder() {
      if (accessSettingsBuilder_ != null) {
        return accessSettingsBuilder_.getMessageOrBuilder();
      } else {
        return accessSettings_ == null
            ? com.google.chat.v1.Space.AccessSettings.getDefaultInstance()
            : accessSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Space.AccessSettings,
            com.google.chat.v1.Space.AccessSettings.Builder,
            com.google.chat.v1.Space.AccessSettingsOrBuilder>
        getAccessSettingsFieldBuilder() {
      if (accessSettingsBuilder_ == null) {
        accessSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.Space.AccessSettings,
                com.google.chat.v1.Space.AccessSettings.Builder,
                com.google.chat.v1.Space.AccessSettingsOrBuilder>(
                getAccessSettings(), getParentForChildren(), isClean());
        accessSettings_ = null;
      }
      return accessSettingsBuilder_;
    }

    private java.lang.Object spaceUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The URI for a user to access the space.
     * </pre>
     *
     * <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The spaceUri.
     */
    public java.lang.String getSpaceUri() {
      java.lang.Object ref = spaceUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        spaceUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The URI for a user to access the space.
     * </pre>
     *
     * <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for spaceUri.
     */
    public com.google.protobuf.ByteString getSpaceUriBytes() {
      java.lang.Object ref = spaceUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        spaceUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The URI for a user to access the space.
     * </pre>
     *
     * <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The spaceUri to set.
     * @return This builder for chaining.
     */
    public Builder setSpaceUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      spaceUri_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The URI for a user to access the space.
     * </pre>
     *
     * <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpaceUri() {
      spaceUri_ = getDefaultInstance().getSpaceUri();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The URI for a user to access the space.
     * </pre>
     *
     * <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for spaceUri to set.
     * @return This builder for chaining.
     */
    public Builder setSpaceUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      spaceUri_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.Space)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.Space)
  private static final com.google.chat.v1.Space DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.Space();
  }

  public static com.google.chat.v1.Space getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Space> PARSER =
      new com.google.protobuf.AbstractParser<Space>() {
        @java.lang.Override
        public Space parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Space> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Space> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.Space getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
