/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/widgets.proto

// Protobuf Java Version: 3.25.4
package com.google.chat.v1;

/**
 *
 *
 * <pre>
 * A widget is a UI element that presents text and images.
 * </pre>
 *
 * Protobuf type {@code google.chat.v1.WidgetMarkup}
 */
public final class WidgetMarkup extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.WidgetMarkup)
    WidgetMarkupOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WidgetMarkup.newBuilder() to construct.
  private WidgetMarkup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WidgetMarkup() {
    buttons_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WidgetMarkup();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.WidgetsProto.internal_static_google_chat_v1_WidgetMarkup_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.WidgetsProto
        .internal_static_google_chat_v1_WidgetMarkup_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.WidgetMarkup.class, com.google.chat.v1.WidgetMarkup.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The set of supported icons.
   * </pre>
   *
   * Protobuf enum {@code google.chat.v1.WidgetMarkup.Icon}
   */
  public enum Icon implements com.google.protobuf.ProtocolMessageEnum {
    /** <code>ICON_UNSPECIFIED = 0;</code> */
    ICON_UNSPECIFIED(0),
    /** <code>AIRPLANE = 1;</code> */
    AIRPLANE(1),
    /** <code>BOOKMARK = 26;</code> */
    BOOKMARK(26),
    /** <code>BUS = 25;</code> */
    BUS(25),
    /** <code>CAR = 9;</code> */
    CAR(9),
    /** <code>CLOCK = 2;</code> */
    CLOCK(2),
    /** <code>CONFIRMATION_NUMBER_ICON = 12;</code> */
    CONFIRMATION_NUMBER_ICON(12),
    /** <code>DOLLAR = 14;</code> */
    DOLLAR(14),
    /** <code>DESCRIPTION = 27;</code> */
    DESCRIPTION(27),
    /** <code>EMAIL = 10;</code> */
    EMAIL(10),
    /** <code>EVENT_PERFORMER = 20;</code> */
    EVENT_PERFORMER(20),
    /** <code>EVENT_SEAT = 21;</code> */
    EVENT_SEAT(21),
    /** <code>FLIGHT_ARRIVAL = 16;</code> */
    FLIGHT_ARRIVAL(16),
    /** <code>FLIGHT_DEPARTURE = 15;</code> */
    FLIGHT_DEPARTURE(15),
    /** <code>HOTEL = 6;</code> */
    HOTEL(6),
    /** <code>HOTEL_ROOM_TYPE = 17;</code> */
    HOTEL_ROOM_TYPE(17),
    /** <code>INVITE = 19;</code> */
    INVITE(19),
    /** <code>MAP_PIN = 3;</code> */
    MAP_PIN(3),
    /** <code>MEMBERSHIP = 24;</code> */
    MEMBERSHIP(24),
    /** <code>MULTIPLE_PEOPLE = 18;</code> */
    MULTIPLE_PEOPLE(18),
    /** <code>OFFER = 30;</code> */
    OFFER(30),
    /** <code>PERSON = 11;</code> */
    PERSON(11),
    /** <code>PHONE = 13;</code> */
    PHONE(13),
    /** <code>RESTAURANT_ICON = 7;</code> */
    RESTAURANT_ICON(7),
    /** <code>SHOPPING_CART = 8;</code> */
    SHOPPING_CART(8),
    /** <code>STAR = 5;</code> */
    STAR(5),
    /** <code>STORE = 22;</code> */
    STORE(22),
    /** <code>TICKET = 4;</code> */
    TICKET(4),
    /** <code>TRAIN = 23;</code> */
    TRAIN(23),
    /** <code>VIDEO_CAMERA = 28;</code> */
    VIDEO_CAMERA(28),
    /** <code>VIDEO_PLAY = 29;</code> */
    VIDEO_PLAY(29),
    UNRECOGNIZED(-1),
    ;

    /** <code>ICON_UNSPECIFIED = 0;</code> */
    public static final int ICON_UNSPECIFIED_VALUE = 0;
    /** <code>AIRPLANE = 1;</code> */
    public static final int AIRPLANE_VALUE = 1;
    /** <code>BOOKMARK = 26;</code> */
    public static final int BOOKMARK_VALUE = 26;
    /** <code>BUS = 25;</code> */
    public static final int BUS_VALUE = 25;
    /** <code>CAR = 9;</code> */
    public static final int CAR_VALUE = 9;
    /** <code>CLOCK = 2;</code> */
    public static final int CLOCK_VALUE = 2;
    /** <code>CONFIRMATION_NUMBER_ICON = 12;</code> */
    public static final int CONFIRMATION_NUMBER_ICON_VALUE = 12;
    /** <code>DOLLAR = 14;</code> */
    public static final int DOLLAR_VALUE = 14;
    /** <code>DESCRIPTION = 27;</code> */
    public static final int DESCRIPTION_VALUE = 27;
    /** <code>EMAIL = 10;</code> */
    public static final int EMAIL_VALUE = 10;
    /** <code>EVENT_PERFORMER = 20;</code> */
    public static final int EVENT_PERFORMER_VALUE = 20;
    /** <code>EVENT_SEAT = 21;</code> */
    public static final int EVENT_SEAT_VALUE = 21;
    /** <code>FLIGHT_ARRIVAL = 16;</code> */
    public static final int FLIGHT_ARRIVAL_VALUE = 16;
    /** <code>FLIGHT_DEPARTURE = 15;</code> */
    public static final int FLIGHT_DEPARTURE_VALUE = 15;
    /** <code>HOTEL = 6;</code> */
    public static final int HOTEL_VALUE = 6;
    /** <code>HOTEL_ROOM_TYPE = 17;</code> */
    public static final int HOTEL_ROOM_TYPE_VALUE = 17;
    /** <code>INVITE = 19;</code> */
    public static final int INVITE_VALUE = 19;
    /** <code>MAP_PIN = 3;</code> */
    public static final int MAP_PIN_VALUE = 3;
    /** <code>MEMBERSHIP = 24;</code> */
    public static final int MEMBERSHIP_VALUE = 24;
    /** <code>MULTIPLE_PEOPLE = 18;</code> */
    public static final int MULTIPLE_PEOPLE_VALUE = 18;
    /** <code>OFFER = 30;</code> */
    public static final int OFFER_VALUE = 30;
    /** <code>PERSON = 11;</code> */
    public static final int PERSON_VALUE = 11;
    /** <code>PHONE = 13;</code> */
    public static final int PHONE_VALUE = 13;
    /** <code>RESTAURANT_ICON = 7;</code> */
    public static final int RESTAURANT_ICON_VALUE = 7;
    /** <code>SHOPPING_CART = 8;</code> */
    public static final int SHOPPING_CART_VALUE = 8;
    /** <code>STAR = 5;</code> */
    public static final int STAR_VALUE = 5;
    /** <code>STORE = 22;</code> */
    public static final int STORE_VALUE = 22;
    /** <code>TICKET = 4;</code> */
    public static final int TICKET_VALUE = 4;
    /** <code>TRAIN = 23;</code> */
    public static final int TRAIN_VALUE = 23;
    /** <code>VIDEO_CAMERA = 28;</code> */
    public static final int VIDEO_CAMERA_VALUE = 28;
    /** <code>VIDEO_PLAY = 29;</code> */
    public static final int VIDEO_PLAY_VALUE = 29;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Icon valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Icon forNumber(int value) {
      switch (value) {
        case 0:
          return ICON_UNSPECIFIED;
        case 1:
          return AIRPLANE;
        case 26:
          return BOOKMARK;
        case 25:
          return BUS;
        case 9:
          return CAR;
        case 2:
          return CLOCK;
        case 12:
          return CONFIRMATION_NUMBER_ICON;
        case 14:
          return DOLLAR;
        case 27:
          return DESCRIPTION;
        case 10:
          return EMAIL;
        case 20:
          return EVENT_PERFORMER;
        case 21:
          return EVENT_SEAT;
        case 16:
          return FLIGHT_ARRIVAL;
        case 15:
          return FLIGHT_DEPARTURE;
        case 6:
          return HOTEL;
        case 17:
          return HOTEL_ROOM_TYPE;
        case 19:
          return INVITE;
        case 3:
          return MAP_PIN;
        case 24:
          return MEMBERSHIP;
        case 18:
          return MULTIPLE_PEOPLE;
        case 30:
          return OFFER;
        case 11:
          return PERSON;
        case 13:
          return PHONE;
        case 7:
          return RESTAURANT_ICON;
        case 8:
          return SHOPPING_CART;
        case 5:
          return STAR;
        case 22:
          return STORE;
        case 4:
          return TICKET;
        case 23:
          return TRAIN;
        case 28:
          return VIDEO_CAMERA;
        case 29:
          return VIDEO_PLAY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Icon> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Icon> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Icon>() {
          public Icon findValueByNumber(int number) {
            return Icon.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.chat.v1.WidgetMarkup.getDescriptor().getEnumTypes().get(0);
    }

    private static final Icon[] VALUES = values();

    public static Icon valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Icon(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.chat.v1.WidgetMarkup.Icon)
  }

  public interface TextParagraphOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.chat.v1.WidgetMarkup.TextParagraph)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    java.lang.String getText();
    /**
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    com.google.protobuf.ByteString getTextBytes();
  }
  /**
   *
   *
   * <pre>
   * A paragraph of text. Formatted text supported. For more information
   * about formatting text, see
   * [Formatting text in Google Chat
   * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
   * and
   * [Formatting
   * text in Google Workspace
   * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.WidgetMarkup.TextParagraph}
   */
  public static final class TextParagraph extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.chat.v1.WidgetMarkup.TextParagraph)
      TextParagraphOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TextParagraph.newBuilder() to construct.
    private TextParagraph(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TextParagraph() {
      text_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TextParagraph();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.WidgetsProto
          .internal_static_google_chat_v1_WidgetMarkup_TextParagraph_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.WidgetsProto
          .internal_static_google_chat_v1_WidgetMarkup_TextParagraph_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.WidgetMarkup.TextParagraph.class,
              com.google.chat.v1.WidgetMarkup.TextParagraph.Builder.class);
    }

    public static final int TEXT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object text_ = "";
    /**
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    @java.lang.Override
    public java.lang.String getText() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        text_ = s;
        return s;
      }
    }
    /**
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        text_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, text_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, text_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.chat.v1.WidgetMarkup.TextParagraph)) {
        return super.equals(obj);
      }
      com.google.chat.v1.WidgetMarkup.TextParagraph other =
          (com.google.chat.v1.WidgetMarkup.TextParagraph) obj;

      if (!getText().equals(other.getText())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getText().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.chat.v1.WidgetMarkup.TextParagraph parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.TextParagraph parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.TextParagraph parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.TextParagraph parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.TextParagraph parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.TextParagraph parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.TextParagraph parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.TextParagraph parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.TextParagraph parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.TextParagraph parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.TextParagraph parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.TextParagraph parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.chat.v1.WidgetMarkup.TextParagraph prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A paragraph of text. Formatted text supported. For more information
     * about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     * </pre>
     *
     * Protobuf type {@code google.chat.v1.WidgetMarkup.TextParagraph}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.chat.v1.WidgetMarkup.TextParagraph)
        com.google.chat.v1.WidgetMarkup.TextParagraphOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_TextParagraph_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_TextParagraph_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.chat.v1.WidgetMarkup.TextParagraph.class,
                com.google.chat.v1.WidgetMarkup.TextParagraph.Builder.class);
      }

      // Construct using com.google.chat.v1.WidgetMarkup.TextParagraph.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        text_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_TextParagraph_descriptor;
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.TextParagraph getDefaultInstanceForType() {
        return com.google.chat.v1.WidgetMarkup.TextParagraph.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.TextParagraph build() {
        com.google.chat.v1.WidgetMarkup.TextParagraph result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.TextParagraph buildPartial() {
        com.google.chat.v1.WidgetMarkup.TextParagraph result =
            new com.google.chat.v1.WidgetMarkup.TextParagraph(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.chat.v1.WidgetMarkup.TextParagraph result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.text_ = text_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.chat.v1.WidgetMarkup.TextParagraph) {
          return mergeFrom((com.google.chat.v1.WidgetMarkup.TextParagraph) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.chat.v1.WidgetMarkup.TextParagraph other) {
        if (other == com.google.chat.v1.WidgetMarkup.TextParagraph.getDefaultInstance())
          return this;
        if (!other.getText().isEmpty()) {
          text_ = other.text_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  text_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object text_ = "";
      /**
       * <code>string text = 1;</code>
       *
       * @return The text.
       */
      public java.lang.String getText() {
        java.lang.Object ref = text_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          text_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string text = 1;</code>
       *
       * @return The bytes for text.
       */
      public com.google.protobuf.ByteString getTextBytes() {
        java.lang.Object ref = text_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          text_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string text = 1;</code>
       *
       * @param value The text to set.
       * @return This builder for chaining.
       */
      public Builder setText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        text_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>string text = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearText() {
        text_ = getDefaultInstance().getText();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <code>string text = 1;</code>
       *
       * @param value The bytes for text to set.
       * @return This builder for chaining.
       */
      public Builder setTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        text_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.chat.v1.WidgetMarkup.TextParagraph)
    }

    // @@protoc_insertion_point(class_scope:google.chat.v1.WidgetMarkup.TextParagraph)
    private static final com.google.chat.v1.WidgetMarkup.TextParagraph DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.chat.v1.WidgetMarkup.TextParagraph();
    }

    public static com.google.chat.v1.WidgetMarkup.TextParagraph getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TextParagraph> PARSER =
        new com.google.protobuf.AbstractParser<TextParagraph>() {
          @java.lang.Override
          public TextParagraph parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TextParagraph> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TextParagraph> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.TextParagraph getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ButtonOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.chat.v1.WidgetMarkup.Button)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A button with text and `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.TextButton text_button = 1;</code>
     *
     * @return Whether the textButton field is set.
     */
    boolean hasTextButton();
    /**
     *
     *
     * <pre>
     * A button with text and `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.TextButton text_button = 1;</code>
     *
     * @return The textButton.
     */
    com.google.chat.v1.WidgetMarkup.TextButton getTextButton();
    /**
     *
     *
     * <pre>
     * A button with text and `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.TextButton text_button = 1;</code>
     */
    com.google.chat.v1.WidgetMarkup.TextButtonOrBuilder getTextButtonOrBuilder();

    /**
     *
     *
     * <pre>
     * A button with image and `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.ImageButton image_button = 2;</code>
     *
     * @return Whether the imageButton field is set.
     */
    boolean hasImageButton();
    /**
     *
     *
     * <pre>
     * A button with image and `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.ImageButton image_button = 2;</code>
     *
     * @return The imageButton.
     */
    com.google.chat.v1.WidgetMarkup.ImageButton getImageButton();
    /**
     *
     *
     * <pre>
     * A button with image and `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.ImageButton image_button = 2;</code>
     */
    com.google.chat.v1.WidgetMarkup.ImageButtonOrBuilder getImageButtonOrBuilder();

    com.google.chat.v1.WidgetMarkup.Button.TypeCase getTypeCase();
  }
  /**
   *
   *
   * <pre>
   * A button. Can be a text button or an image button.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.WidgetMarkup.Button}
   */
  public static final class Button extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.chat.v1.WidgetMarkup.Button)
      ButtonOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Button.newBuilder() to construct.
    private Button(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Button() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Button();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.WidgetsProto
          .internal_static_google_chat_v1_WidgetMarkup_Button_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.WidgetsProto
          .internal_static_google_chat_v1_WidgetMarkup_Button_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.WidgetMarkup.Button.class,
              com.google.chat.v1.WidgetMarkup.Button.Builder.class);
    }

    private int typeCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object type_;

    public enum TypeCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      TEXT_BUTTON(1),
      IMAGE_BUTTON(2),
      TYPE_NOT_SET(0);
      private final int value;

      private TypeCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static TypeCase valueOf(int value) {
        return forNumber(value);
      }

      public static TypeCase forNumber(int value) {
        switch (value) {
          case 1:
            return TEXT_BUTTON;
          case 2:
            return IMAGE_BUTTON;
          case 0:
            return TYPE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public TypeCase getTypeCase() {
      return TypeCase.forNumber(typeCase_);
    }

    public static final int TEXT_BUTTON_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * A button with text and `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.TextButton text_button = 1;</code>
     *
     * @return Whether the textButton field is set.
     */
    @java.lang.Override
    public boolean hasTextButton() {
      return typeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * A button with text and `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.TextButton text_button = 1;</code>
     *
     * @return The textButton.
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.TextButton getTextButton() {
      if (typeCase_ == 1) {
        return (com.google.chat.v1.WidgetMarkup.TextButton) type_;
      }
      return com.google.chat.v1.WidgetMarkup.TextButton.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A button with text and `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.TextButton text_button = 1;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.TextButtonOrBuilder getTextButtonOrBuilder() {
      if (typeCase_ == 1) {
        return (com.google.chat.v1.WidgetMarkup.TextButton) type_;
      }
      return com.google.chat.v1.WidgetMarkup.TextButton.getDefaultInstance();
    }

    public static final int IMAGE_BUTTON_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * A button with image and `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.ImageButton image_button = 2;</code>
     *
     * @return Whether the imageButton field is set.
     */
    @java.lang.Override
    public boolean hasImageButton() {
      return typeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A button with image and `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.ImageButton image_button = 2;</code>
     *
     * @return The imageButton.
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.ImageButton getImageButton() {
      if (typeCase_ == 2) {
        return (com.google.chat.v1.WidgetMarkup.ImageButton) type_;
      }
      return com.google.chat.v1.WidgetMarkup.ImageButton.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A button with image and `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.ImageButton image_button = 2;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.ImageButtonOrBuilder getImageButtonOrBuilder() {
      if (typeCase_ == 2) {
        return (com.google.chat.v1.WidgetMarkup.ImageButton) type_;
      }
      return com.google.chat.v1.WidgetMarkup.ImageButton.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (typeCase_ == 1) {
        output.writeMessage(1, (com.google.chat.v1.WidgetMarkup.TextButton) type_);
      }
      if (typeCase_ == 2) {
        output.writeMessage(2, (com.google.chat.v1.WidgetMarkup.ImageButton) type_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (typeCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.chat.v1.WidgetMarkup.TextButton) type_);
      }
      if (typeCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.chat.v1.WidgetMarkup.ImageButton) type_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.chat.v1.WidgetMarkup.Button)) {
        return super.equals(obj);
      }
      com.google.chat.v1.WidgetMarkup.Button other = (com.google.chat.v1.WidgetMarkup.Button) obj;

      if (!getTypeCase().equals(other.getTypeCase())) return false;
      switch (typeCase_) {
        case 1:
          if (!getTextButton().equals(other.getTextButton())) return false;
          break;
        case 2:
          if (!getImageButton().equals(other.getImageButton())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (typeCase_) {
        case 1:
          hash = (37 * hash) + TEXT_BUTTON_FIELD_NUMBER;
          hash = (53 * hash) + getTextButton().hashCode();
          break;
        case 2:
          hash = (37 * hash) + IMAGE_BUTTON_FIELD_NUMBER;
          hash = (53 * hash) + getImageButton().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.chat.v1.WidgetMarkup.Button parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.Button parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.Button parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.Button parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.Button parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.Button parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.Button parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.Button parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.Button parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.Button parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.Button parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.Button parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.chat.v1.WidgetMarkup.Button prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A button. Can be a text button or an image button.
     * </pre>
     *
     * Protobuf type {@code google.chat.v1.WidgetMarkup.Button}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.chat.v1.WidgetMarkup.Button)
        com.google.chat.v1.WidgetMarkup.ButtonOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_Button_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_Button_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.chat.v1.WidgetMarkup.Button.class,
                com.google.chat.v1.WidgetMarkup.Button.Builder.class);
      }

      // Construct using com.google.chat.v1.WidgetMarkup.Button.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (textButtonBuilder_ != null) {
          textButtonBuilder_.clear();
        }
        if (imageButtonBuilder_ != null) {
          imageButtonBuilder_.clear();
        }
        typeCase_ = 0;
        type_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_Button_descriptor;
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.Button getDefaultInstanceForType() {
        return com.google.chat.v1.WidgetMarkup.Button.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.Button build() {
        com.google.chat.v1.WidgetMarkup.Button result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.Button buildPartial() {
        com.google.chat.v1.WidgetMarkup.Button result =
            new com.google.chat.v1.WidgetMarkup.Button(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.chat.v1.WidgetMarkup.Button result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(com.google.chat.v1.WidgetMarkup.Button result) {
        result.typeCase_ = typeCase_;
        result.type_ = this.type_;
        if (typeCase_ == 1 && textButtonBuilder_ != null) {
          result.type_ = textButtonBuilder_.build();
        }
        if (typeCase_ == 2 && imageButtonBuilder_ != null) {
          result.type_ = imageButtonBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.chat.v1.WidgetMarkup.Button) {
          return mergeFrom((com.google.chat.v1.WidgetMarkup.Button) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.chat.v1.WidgetMarkup.Button other) {
        if (other == com.google.chat.v1.WidgetMarkup.Button.getDefaultInstance()) return this;
        switch (other.getTypeCase()) {
          case TEXT_BUTTON:
            {
              mergeTextButton(other.getTextButton());
              break;
            }
          case IMAGE_BUTTON:
            {
              mergeImageButton(other.getImageButton());
              break;
            }
          case TYPE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getTextButtonFieldBuilder().getBuilder(), extensionRegistry);
                  typeCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getImageButtonFieldBuilder().getBuilder(), extensionRegistry);
                  typeCase_ = 2;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int typeCase_ = 0;
      private java.lang.Object type_;

      public TypeCase getTypeCase() {
        return TypeCase.forNumber(typeCase_);
      }

      public Builder clearType() {
        typeCase_ = 0;
        type_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.WidgetMarkup.TextButton,
              com.google.chat.v1.WidgetMarkup.TextButton.Builder,
              com.google.chat.v1.WidgetMarkup.TextButtonOrBuilder>
          textButtonBuilder_;
      /**
       *
       *
       * <pre>
       * A button with text and `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.TextButton text_button = 1;</code>
       *
       * @return Whether the textButton field is set.
       */
      @java.lang.Override
      public boolean hasTextButton() {
        return typeCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * A button with text and `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.TextButton text_button = 1;</code>
       *
       * @return The textButton.
       */
      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.TextButton getTextButton() {
        if (textButtonBuilder_ == null) {
          if (typeCase_ == 1) {
            return (com.google.chat.v1.WidgetMarkup.TextButton) type_;
          }
          return com.google.chat.v1.WidgetMarkup.TextButton.getDefaultInstance();
        } else {
          if (typeCase_ == 1) {
            return textButtonBuilder_.getMessage();
          }
          return com.google.chat.v1.WidgetMarkup.TextButton.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A button with text and `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.TextButton text_button = 1;</code>
       */
      public Builder setTextButton(com.google.chat.v1.WidgetMarkup.TextButton value) {
        if (textButtonBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          type_ = value;
          onChanged();
        } else {
          textButtonBuilder_.setMessage(value);
        }
        typeCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A button with text and `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.TextButton text_button = 1;</code>
       */
      public Builder setTextButton(
          com.google.chat.v1.WidgetMarkup.TextButton.Builder builderForValue) {
        if (textButtonBuilder_ == null) {
          type_ = builderForValue.build();
          onChanged();
        } else {
          textButtonBuilder_.setMessage(builderForValue.build());
        }
        typeCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A button with text and `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.TextButton text_button = 1;</code>
       */
      public Builder mergeTextButton(com.google.chat.v1.WidgetMarkup.TextButton value) {
        if (textButtonBuilder_ == null) {
          if (typeCase_ == 1
              && type_ != com.google.chat.v1.WidgetMarkup.TextButton.getDefaultInstance()) {
            type_ =
                com.google.chat.v1.WidgetMarkup.TextButton.newBuilder(
                        (com.google.chat.v1.WidgetMarkup.TextButton) type_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            type_ = value;
          }
          onChanged();
        } else {
          if (typeCase_ == 1) {
            textButtonBuilder_.mergeFrom(value);
          } else {
            textButtonBuilder_.setMessage(value);
          }
        }
        typeCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A button with text and `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.TextButton text_button = 1;</code>
       */
      public Builder clearTextButton() {
        if (textButtonBuilder_ == null) {
          if (typeCase_ == 1) {
            typeCase_ = 0;
            type_ = null;
            onChanged();
          }
        } else {
          if (typeCase_ == 1) {
            typeCase_ = 0;
            type_ = null;
          }
          textButtonBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A button with text and `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.TextButton text_button = 1;</code>
       */
      public com.google.chat.v1.WidgetMarkup.TextButton.Builder getTextButtonBuilder() {
        return getTextButtonFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A button with text and `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.TextButton text_button = 1;</code>
       */
      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.TextButtonOrBuilder getTextButtonOrBuilder() {
        if ((typeCase_ == 1) && (textButtonBuilder_ != null)) {
          return textButtonBuilder_.getMessageOrBuilder();
        } else {
          if (typeCase_ == 1) {
            return (com.google.chat.v1.WidgetMarkup.TextButton) type_;
          }
          return com.google.chat.v1.WidgetMarkup.TextButton.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A button with text and `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.TextButton text_button = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.WidgetMarkup.TextButton,
              com.google.chat.v1.WidgetMarkup.TextButton.Builder,
              com.google.chat.v1.WidgetMarkup.TextButtonOrBuilder>
          getTextButtonFieldBuilder() {
        if (textButtonBuilder_ == null) {
          if (!(typeCase_ == 1)) {
            type_ = com.google.chat.v1.WidgetMarkup.TextButton.getDefaultInstance();
          }
          textButtonBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.chat.v1.WidgetMarkup.TextButton,
                  com.google.chat.v1.WidgetMarkup.TextButton.Builder,
                  com.google.chat.v1.WidgetMarkup.TextButtonOrBuilder>(
                  (com.google.chat.v1.WidgetMarkup.TextButton) type_,
                  getParentForChildren(),
                  isClean());
          type_ = null;
        }
        typeCase_ = 1;
        onChanged();
        return textButtonBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.WidgetMarkup.ImageButton,
              com.google.chat.v1.WidgetMarkup.ImageButton.Builder,
              com.google.chat.v1.WidgetMarkup.ImageButtonOrBuilder>
          imageButtonBuilder_;
      /**
       *
       *
       * <pre>
       * A button with image and `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.ImageButton image_button = 2;</code>
       *
       * @return Whether the imageButton field is set.
       */
      @java.lang.Override
      public boolean hasImageButton() {
        return typeCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * A button with image and `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.ImageButton image_button = 2;</code>
       *
       * @return The imageButton.
       */
      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.ImageButton getImageButton() {
        if (imageButtonBuilder_ == null) {
          if (typeCase_ == 2) {
            return (com.google.chat.v1.WidgetMarkup.ImageButton) type_;
          }
          return com.google.chat.v1.WidgetMarkup.ImageButton.getDefaultInstance();
        } else {
          if (typeCase_ == 2) {
            return imageButtonBuilder_.getMessage();
          }
          return com.google.chat.v1.WidgetMarkup.ImageButton.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A button with image and `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.ImageButton image_button = 2;</code>
       */
      public Builder setImageButton(com.google.chat.v1.WidgetMarkup.ImageButton value) {
        if (imageButtonBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          type_ = value;
          onChanged();
        } else {
          imageButtonBuilder_.setMessage(value);
        }
        typeCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A button with image and `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.ImageButton image_button = 2;</code>
       */
      public Builder setImageButton(
          com.google.chat.v1.WidgetMarkup.ImageButton.Builder builderForValue) {
        if (imageButtonBuilder_ == null) {
          type_ = builderForValue.build();
          onChanged();
        } else {
          imageButtonBuilder_.setMessage(builderForValue.build());
        }
        typeCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A button with image and `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.ImageButton image_button = 2;</code>
       */
      public Builder mergeImageButton(com.google.chat.v1.WidgetMarkup.ImageButton value) {
        if (imageButtonBuilder_ == null) {
          if (typeCase_ == 2
              && type_ != com.google.chat.v1.WidgetMarkup.ImageButton.getDefaultInstance()) {
            type_ =
                com.google.chat.v1.WidgetMarkup.ImageButton.newBuilder(
                        (com.google.chat.v1.WidgetMarkup.ImageButton) type_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            type_ = value;
          }
          onChanged();
        } else {
          if (typeCase_ == 2) {
            imageButtonBuilder_.mergeFrom(value);
          } else {
            imageButtonBuilder_.setMessage(value);
          }
        }
        typeCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A button with image and `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.ImageButton image_button = 2;</code>
       */
      public Builder clearImageButton() {
        if (imageButtonBuilder_ == null) {
          if (typeCase_ == 2) {
            typeCase_ = 0;
            type_ = null;
            onChanged();
          }
        } else {
          if (typeCase_ == 2) {
            typeCase_ = 0;
            type_ = null;
          }
          imageButtonBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A button with image and `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.ImageButton image_button = 2;</code>
       */
      public com.google.chat.v1.WidgetMarkup.ImageButton.Builder getImageButtonBuilder() {
        return getImageButtonFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A button with image and `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.ImageButton image_button = 2;</code>
       */
      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.ImageButtonOrBuilder getImageButtonOrBuilder() {
        if ((typeCase_ == 2) && (imageButtonBuilder_ != null)) {
          return imageButtonBuilder_.getMessageOrBuilder();
        } else {
          if (typeCase_ == 2) {
            return (com.google.chat.v1.WidgetMarkup.ImageButton) type_;
          }
          return com.google.chat.v1.WidgetMarkup.ImageButton.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A button with image and `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.ImageButton image_button = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.WidgetMarkup.ImageButton,
              com.google.chat.v1.WidgetMarkup.ImageButton.Builder,
              com.google.chat.v1.WidgetMarkup.ImageButtonOrBuilder>
          getImageButtonFieldBuilder() {
        if (imageButtonBuilder_ == null) {
          if (!(typeCase_ == 2)) {
            type_ = com.google.chat.v1.WidgetMarkup.ImageButton.getDefaultInstance();
          }
          imageButtonBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.chat.v1.WidgetMarkup.ImageButton,
                  com.google.chat.v1.WidgetMarkup.ImageButton.Builder,
                  com.google.chat.v1.WidgetMarkup.ImageButtonOrBuilder>(
                  (com.google.chat.v1.WidgetMarkup.ImageButton) type_,
                  getParentForChildren(),
                  isClean());
          type_ = null;
        }
        typeCase_ = 2;
        onChanged();
        return imageButtonBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.chat.v1.WidgetMarkup.Button)
    }

    // @@protoc_insertion_point(class_scope:google.chat.v1.WidgetMarkup.Button)
    private static final com.google.chat.v1.WidgetMarkup.Button DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.chat.v1.WidgetMarkup.Button();
    }

    public static com.google.chat.v1.WidgetMarkup.Button getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Button> PARSER =
        new com.google.protobuf.AbstractParser<Button>() {
          @java.lang.Override
          public Button parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Button> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Button> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.Button getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TextButtonOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.chat.v1.WidgetMarkup.TextButton)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The text of the button.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    java.lang.String getText();
    /**
     *
     *
     * <pre>
     * The text of the button.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    com.google.protobuf.ByteString getTextBytes();

    /**
     *
     *
     * <pre>
     * The `onclick` action of the button.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
     *
     * @return Whether the onClick field is set.
     */
    boolean hasOnClick();
    /**
     *
     *
     * <pre>
     * The `onclick` action of the button.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
     *
     * @return The onClick.
     */
    com.google.chat.v1.WidgetMarkup.OnClick getOnClick();
    /**
     *
     *
     * <pre>
     * The `onclick` action of the button.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
     */
    com.google.chat.v1.WidgetMarkup.OnClickOrBuilder getOnClickOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A button with text and `onclick` action.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.WidgetMarkup.TextButton}
   */
  public static final class TextButton extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.chat.v1.WidgetMarkup.TextButton)
      TextButtonOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TextButton.newBuilder() to construct.
    private TextButton(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TextButton() {
      text_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TextButton();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.WidgetsProto
          .internal_static_google_chat_v1_WidgetMarkup_TextButton_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.WidgetsProto
          .internal_static_google_chat_v1_WidgetMarkup_TextButton_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.WidgetMarkup.TextButton.class,
              com.google.chat.v1.WidgetMarkup.TextButton.Builder.class);
    }

    private int bitField0_;
    public static final int TEXT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object text_ = "";
    /**
     *
     *
     * <pre>
     * The text of the button.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    @java.lang.Override
    public java.lang.String getText() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        text_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The text of the button.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        text_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ON_CLICK_FIELD_NUMBER = 2;
    private com.google.chat.v1.WidgetMarkup.OnClick onClick_;
    /**
     *
     *
     * <pre>
     * The `onclick` action of the button.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
     *
     * @return Whether the onClick field is set.
     */
    @java.lang.Override
    public boolean hasOnClick() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The `onclick` action of the button.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
     *
     * @return The onClick.
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.OnClick getOnClick() {
      return onClick_ == null
          ? com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance()
          : onClick_;
    }
    /**
     *
     *
     * <pre>
     * The `onclick` action of the button.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.OnClickOrBuilder getOnClickOrBuilder() {
      return onClick_ == null
          ? com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance()
          : onClick_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, text_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getOnClick());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, text_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOnClick());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.chat.v1.WidgetMarkup.TextButton)) {
        return super.equals(obj);
      }
      com.google.chat.v1.WidgetMarkup.TextButton other =
          (com.google.chat.v1.WidgetMarkup.TextButton) obj;

      if (!getText().equals(other.getText())) return false;
      if (hasOnClick() != other.hasOnClick()) return false;
      if (hasOnClick()) {
        if (!getOnClick().equals(other.getOnClick())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getText().hashCode();
      if (hasOnClick()) {
        hash = (37 * hash) + ON_CLICK_FIELD_NUMBER;
        hash = (53 * hash) + getOnClick().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.chat.v1.WidgetMarkup.TextButton parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.TextButton parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.TextButton parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.TextButton parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.TextButton parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.TextButton parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.TextButton parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.TextButton parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.TextButton parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.TextButton parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.TextButton parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.TextButton parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.chat.v1.WidgetMarkup.TextButton prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A button with text and `onclick` action.
     * </pre>
     *
     * Protobuf type {@code google.chat.v1.WidgetMarkup.TextButton}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.chat.v1.WidgetMarkup.TextButton)
        com.google.chat.v1.WidgetMarkup.TextButtonOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_TextButton_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_TextButton_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.chat.v1.WidgetMarkup.TextButton.class,
                com.google.chat.v1.WidgetMarkup.TextButton.Builder.class);
      }

      // Construct using com.google.chat.v1.WidgetMarkup.TextButton.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getOnClickFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        text_ = "";
        onClick_ = null;
        if (onClickBuilder_ != null) {
          onClickBuilder_.dispose();
          onClickBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_TextButton_descriptor;
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.TextButton getDefaultInstanceForType() {
        return com.google.chat.v1.WidgetMarkup.TextButton.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.TextButton build() {
        com.google.chat.v1.WidgetMarkup.TextButton result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.TextButton buildPartial() {
        com.google.chat.v1.WidgetMarkup.TextButton result =
            new com.google.chat.v1.WidgetMarkup.TextButton(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.chat.v1.WidgetMarkup.TextButton result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.text_ = text_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.onClick_ = onClickBuilder_ == null ? onClick_ : onClickBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.chat.v1.WidgetMarkup.TextButton) {
          return mergeFrom((com.google.chat.v1.WidgetMarkup.TextButton) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.chat.v1.WidgetMarkup.TextButton other) {
        if (other == com.google.chat.v1.WidgetMarkup.TextButton.getDefaultInstance()) return this;
        if (!other.getText().isEmpty()) {
          text_ = other.text_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasOnClick()) {
          mergeOnClick(other.getOnClick());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  text_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getOnClickFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object text_ = "";
      /**
       *
       *
       * <pre>
       * The text of the button.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The text.
       */
      public java.lang.String getText() {
        java.lang.Object ref = text_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          text_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The text of the button.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The bytes for text.
       */
      public com.google.protobuf.ByteString getTextBytes() {
        java.lang.Object ref = text_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          text_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The text of the button.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @param value The text to set.
       * @return This builder for chaining.
       */
      public Builder setText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        text_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The text of the button.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearText() {
        text_ = getDefaultInstance().getText();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The text of the button.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @param value The bytes for text to set.
       * @return This builder for chaining.
       */
      public Builder setTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        text_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.chat.v1.WidgetMarkup.OnClick onClick_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.WidgetMarkup.OnClick,
              com.google.chat.v1.WidgetMarkup.OnClick.Builder,
              com.google.chat.v1.WidgetMarkup.OnClickOrBuilder>
          onClickBuilder_;
      /**
       *
       *
       * <pre>
       * The `onclick` action of the button.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       *
       * @return Whether the onClick field is set.
       */
      public boolean hasOnClick() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action of the button.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       *
       * @return The onClick.
       */
      public com.google.chat.v1.WidgetMarkup.OnClick getOnClick() {
        if (onClickBuilder_ == null) {
          return onClick_ == null
              ? com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance()
              : onClick_;
        } else {
          return onClickBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action of the button.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       */
      public Builder setOnClick(com.google.chat.v1.WidgetMarkup.OnClick value) {
        if (onClickBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          onClick_ = value;
        } else {
          onClickBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action of the button.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       */
      public Builder setOnClick(com.google.chat.v1.WidgetMarkup.OnClick.Builder builderForValue) {
        if (onClickBuilder_ == null) {
          onClick_ = builderForValue.build();
        } else {
          onClickBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action of the button.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       */
      public Builder mergeOnClick(com.google.chat.v1.WidgetMarkup.OnClick value) {
        if (onClickBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && onClick_ != null
              && onClick_ != com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance()) {
            getOnClickBuilder().mergeFrom(value);
          } else {
            onClick_ = value;
          }
        } else {
          onClickBuilder_.mergeFrom(value);
        }
        if (onClick_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action of the button.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       */
      public Builder clearOnClick() {
        bitField0_ = (bitField0_ & ~0x00000002);
        onClick_ = null;
        if (onClickBuilder_ != null) {
          onClickBuilder_.dispose();
          onClickBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action of the button.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       */
      public com.google.chat.v1.WidgetMarkup.OnClick.Builder getOnClickBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getOnClickFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action of the button.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       */
      public com.google.chat.v1.WidgetMarkup.OnClickOrBuilder getOnClickOrBuilder() {
        if (onClickBuilder_ != null) {
          return onClickBuilder_.getMessageOrBuilder();
        } else {
          return onClick_ == null
              ? com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance()
              : onClick_;
        }
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action of the button.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.WidgetMarkup.OnClick,
              com.google.chat.v1.WidgetMarkup.OnClick.Builder,
              com.google.chat.v1.WidgetMarkup.OnClickOrBuilder>
          getOnClickFieldBuilder() {
        if (onClickBuilder_ == null) {
          onClickBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.chat.v1.WidgetMarkup.OnClick,
                  com.google.chat.v1.WidgetMarkup.OnClick.Builder,
                  com.google.chat.v1.WidgetMarkup.OnClickOrBuilder>(
                  getOnClick(), getParentForChildren(), isClean());
          onClick_ = null;
        }
        return onClickBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.chat.v1.WidgetMarkup.TextButton)
    }

    // @@protoc_insertion_point(class_scope:google.chat.v1.WidgetMarkup.TextButton)
    private static final com.google.chat.v1.WidgetMarkup.TextButton DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.chat.v1.WidgetMarkup.TextButton();
    }

    public static com.google.chat.v1.WidgetMarkup.TextButton getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TextButton> PARSER =
        new com.google.protobuf.AbstractParser<TextButton>() {
          @java.lang.Override
          public TextButton parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TextButton> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TextButton> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.TextButton getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface KeyValueOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.chat.v1.WidgetMarkup.KeyValue)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * An enum value that's replaced by the Chat API with the
     * corresponding icon image.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
     *
     * @return Whether the icon field is set.
     */
    boolean hasIcon();
    /**
     *
     *
     * <pre>
     * An enum value that's replaced by the Chat API with the
     * corresponding icon image.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
     *
     * @return The enum numeric value on the wire for icon.
     */
    int getIconValue();
    /**
     *
     *
     * <pre>
     * An enum value that's replaced by the Chat API with the
     * corresponding icon image.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
     *
     * @return The icon.
     */
    com.google.chat.v1.WidgetMarkup.Icon getIcon();

    /**
     *
     *
     * <pre>
     * The icon specified by a URL.
     * </pre>
     *
     * <code>string icon_url = 2;</code>
     *
     * @return Whether the iconUrl field is set.
     */
    boolean hasIconUrl();
    /**
     *
     *
     * <pre>
     * The icon specified by a URL.
     * </pre>
     *
     * <code>string icon_url = 2;</code>
     *
     * @return The iconUrl.
     */
    java.lang.String getIconUrl();
    /**
     *
     *
     * <pre>
     * The icon specified by a URL.
     * </pre>
     *
     * <code>string icon_url = 2;</code>
     *
     * @return The bytes for iconUrl.
     */
    com.google.protobuf.ByteString getIconUrlBytes();

    /**
     *
     *
     * <pre>
     * The text of the top label. Formatted text supported. For more information
     * about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     * </pre>
     *
     * <code>string top_label = 3;</code>
     *
     * @return The topLabel.
     */
    java.lang.String getTopLabel();
    /**
     *
     *
     * <pre>
     * The text of the top label. Formatted text supported. For more information
     * about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     * </pre>
     *
     * <code>string top_label = 3;</code>
     *
     * @return The bytes for topLabel.
     */
    com.google.protobuf.ByteString getTopLabelBytes();

    /**
     *
     *
     * <pre>
     * The text of the content. Formatted text supported and always required.
     * For more information
     * about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     * </pre>
     *
     * <code>string content = 4;</code>
     *
     * @return The content.
     */
    java.lang.String getContent();
    /**
     *
     *
     * <pre>
     * The text of the content. Formatted text supported and always required.
     * For more information
     * about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     * </pre>
     *
     * <code>string content = 4;</code>
     *
     * @return The bytes for content.
     */
    com.google.protobuf.ByteString getContentBytes();

    /**
     *
     *
     * <pre>
     * If the content should be multiline.
     * </pre>
     *
     * <code>bool content_multiline = 9;</code>
     *
     * @return The contentMultiline.
     */
    boolean getContentMultiline();

    /**
     *
     *
     * <pre>
     * The text of the bottom label. Formatted text supported. For more
     * information about formatting text, see [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     * </pre>
     *
     * <code>string bottom_label = 5;</code>
     *
     * @return The bottomLabel.
     */
    java.lang.String getBottomLabel();
    /**
     *
     *
     * <pre>
     * The text of the bottom label. Formatted text supported. For more
     * information about formatting text, see [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     * </pre>
     *
     * <code>string bottom_label = 5;</code>
     *
     * @return The bytes for bottomLabel.
     */
    com.google.protobuf.ByteString getBottomLabelBytes();

    /**
     *
     *
     * <pre>
     * The `onclick` action. Only the top label, bottom label, and content
     * region are clickable.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 6;</code>
     *
     * @return Whether the onClick field is set.
     */
    boolean hasOnClick();
    /**
     *
     *
     * <pre>
     * The `onclick` action. Only the top label, bottom label, and content
     * region are clickable.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 6;</code>
     *
     * @return The onClick.
     */
    com.google.chat.v1.WidgetMarkup.OnClick getOnClick();
    /**
     *
     *
     * <pre>
     * The `onclick` action. Only the top label, bottom label, and content
     * region are clickable.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 6;</code>
     */
    com.google.chat.v1.WidgetMarkup.OnClickOrBuilder getOnClickOrBuilder();

    /**
     *
     *
     * <pre>
     * A button that can be clicked to trigger an action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Button button = 7;</code>
     *
     * @return Whether the button field is set.
     */
    boolean hasButton();
    /**
     *
     *
     * <pre>
     * A button that can be clicked to trigger an action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Button button = 7;</code>
     *
     * @return The button.
     */
    com.google.chat.v1.WidgetMarkup.Button getButton();
    /**
     *
     *
     * <pre>
     * A button that can be clicked to trigger an action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Button button = 7;</code>
     */
    com.google.chat.v1.WidgetMarkup.ButtonOrBuilder getButtonOrBuilder();

    com.google.chat.v1.WidgetMarkup.KeyValue.IconsCase getIconsCase();

    com.google.chat.v1.WidgetMarkup.KeyValue.ControlCase getControlCase();
  }
  /**
   *
   *
   * <pre>
   * A UI element contains a key (label) and a value (content). This
   * element can also contain some actions such as `onclick` button.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.WidgetMarkup.KeyValue}
   */
  public static final class KeyValue extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.chat.v1.WidgetMarkup.KeyValue)
      KeyValueOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use KeyValue.newBuilder() to construct.
    private KeyValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private KeyValue() {
      topLabel_ = "";
      content_ = "";
      bottomLabel_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new KeyValue();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.WidgetsProto
          .internal_static_google_chat_v1_WidgetMarkup_KeyValue_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.WidgetsProto
          .internal_static_google_chat_v1_WidgetMarkup_KeyValue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.WidgetMarkup.KeyValue.class,
              com.google.chat.v1.WidgetMarkup.KeyValue.Builder.class);
    }

    private int bitField0_;
    private int iconsCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object icons_;

    public enum IconsCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      ICON(1),
      ICON_URL(2),
      ICONS_NOT_SET(0);
      private final int value;

      private IconsCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static IconsCase valueOf(int value) {
        return forNumber(value);
      }

      public static IconsCase forNumber(int value) {
        switch (value) {
          case 1:
            return ICON;
          case 2:
            return ICON_URL;
          case 0:
            return ICONS_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public IconsCase getIconsCase() {
      return IconsCase.forNumber(iconsCase_);
    }

    private int controlCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object control_;

    public enum ControlCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      BUTTON(7),
      CONTROL_NOT_SET(0);
      private final int value;

      private ControlCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ControlCase valueOf(int value) {
        return forNumber(value);
      }

      public static ControlCase forNumber(int value) {
        switch (value) {
          case 7:
            return BUTTON;
          case 0:
            return CONTROL_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ControlCase getControlCase() {
      return ControlCase.forNumber(controlCase_);
    }

    public static final int ICON_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * An enum value that's replaced by the Chat API with the
     * corresponding icon image.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
     *
     * @return Whether the icon field is set.
     */
    public boolean hasIcon() {
      return iconsCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * An enum value that's replaced by the Chat API with the
     * corresponding icon image.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
     *
     * @return The enum numeric value on the wire for icon.
     */
    public int getIconValue() {
      if (iconsCase_ == 1) {
        return (java.lang.Integer) icons_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * An enum value that's replaced by the Chat API with the
     * corresponding icon image.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
     *
     * @return The icon.
     */
    public com.google.chat.v1.WidgetMarkup.Icon getIcon() {
      if (iconsCase_ == 1) {
        com.google.chat.v1.WidgetMarkup.Icon result =
            com.google.chat.v1.WidgetMarkup.Icon.forNumber((java.lang.Integer) icons_);
        return result == null ? com.google.chat.v1.WidgetMarkup.Icon.UNRECOGNIZED : result;
      }
      return com.google.chat.v1.WidgetMarkup.Icon.ICON_UNSPECIFIED;
    }

    public static final int ICON_URL_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * The icon specified by a URL.
     * </pre>
     *
     * <code>string icon_url = 2;</code>
     *
     * @return Whether the iconUrl field is set.
     */
    public boolean hasIconUrl() {
      return iconsCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The icon specified by a URL.
     * </pre>
     *
     * <code>string icon_url = 2;</code>
     *
     * @return The iconUrl.
     */
    public java.lang.String getIconUrl() {
      java.lang.Object ref = "";
      if (iconsCase_ == 2) {
        ref = icons_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (iconsCase_ == 2) {
          icons_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The icon specified by a URL.
     * </pre>
     *
     * <code>string icon_url = 2;</code>
     *
     * @return The bytes for iconUrl.
     */
    public com.google.protobuf.ByteString getIconUrlBytes() {
      java.lang.Object ref = "";
      if (iconsCase_ == 2) {
        ref = icons_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (iconsCase_ == 2) {
          icons_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TOP_LABEL_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object topLabel_ = "";
    /**
     *
     *
     * <pre>
     * The text of the top label. Formatted text supported. For more information
     * about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     * </pre>
     *
     * <code>string top_label = 3;</code>
     *
     * @return The topLabel.
     */
    @java.lang.Override
    public java.lang.String getTopLabel() {
      java.lang.Object ref = topLabel_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        topLabel_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The text of the top label. Formatted text supported. For more information
     * about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     * </pre>
     *
     * <code>string top_label = 3;</code>
     *
     * @return The bytes for topLabel.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTopLabelBytes() {
      java.lang.Object ref = topLabel_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        topLabel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONTENT_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object content_ = "";
    /**
     *
     *
     * <pre>
     * The text of the content. Formatted text supported and always required.
     * For more information
     * about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     * </pre>
     *
     * <code>string content = 4;</code>
     *
     * @return The content.
     */
    @java.lang.Override
    public java.lang.String getContent() {
      java.lang.Object ref = content_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        content_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The text of the content. Formatted text supported and always required.
     * For more information
     * about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     * </pre>
     *
     * <code>string content = 4;</code>
     *
     * @return The bytes for content.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getContentBytes() {
      java.lang.Object ref = content_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        content_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONTENT_MULTILINE_FIELD_NUMBER = 9;
    private boolean contentMultiline_ = false;
    /**
     *
     *
     * <pre>
     * If the content should be multiline.
     * </pre>
     *
     * <code>bool content_multiline = 9;</code>
     *
     * @return The contentMultiline.
     */
    @java.lang.Override
    public boolean getContentMultiline() {
      return contentMultiline_;
    }

    public static final int BOTTOM_LABEL_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object bottomLabel_ = "";
    /**
     *
     *
     * <pre>
     * The text of the bottom label. Formatted text supported. For more
     * information about formatting text, see [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     * </pre>
     *
     * <code>string bottom_label = 5;</code>
     *
     * @return The bottomLabel.
     */
    @java.lang.Override
    public java.lang.String getBottomLabel() {
      java.lang.Object ref = bottomLabel_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bottomLabel_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The text of the bottom label. Formatted text supported. For more
     * information about formatting text, see [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     * </pre>
     *
     * <code>string bottom_label = 5;</code>
     *
     * @return The bytes for bottomLabel.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBottomLabelBytes() {
      java.lang.Object ref = bottomLabel_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bottomLabel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ON_CLICK_FIELD_NUMBER = 6;
    private com.google.chat.v1.WidgetMarkup.OnClick onClick_;
    /**
     *
     *
     * <pre>
     * The `onclick` action. Only the top label, bottom label, and content
     * region are clickable.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 6;</code>
     *
     * @return Whether the onClick field is set.
     */
    @java.lang.Override
    public boolean hasOnClick() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The `onclick` action. Only the top label, bottom label, and content
     * region are clickable.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 6;</code>
     *
     * @return The onClick.
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.OnClick getOnClick() {
      return onClick_ == null
          ? com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance()
          : onClick_;
    }
    /**
     *
     *
     * <pre>
     * The `onclick` action. Only the top label, bottom label, and content
     * region are clickable.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 6;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.OnClickOrBuilder getOnClickOrBuilder() {
      return onClick_ == null
          ? com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance()
          : onClick_;
    }

    public static final int BUTTON_FIELD_NUMBER = 7;
    /**
     *
     *
     * <pre>
     * A button that can be clicked to trigger an action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Button button = 7;</code>
     *
     * @return Whether the button field is set.
     */
    @java.lang.Override
    public boolean hasButton() {
      return controlCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * A button that can be clicked to trigger an action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Button button = 7;</code>
     *
     * @return The button.
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.Button getButton() {
      if (controlCase_ == 7) {
        return (com.google.chat.v1.WidgetMarkup.Button) control_;
      }
      return com.google.chat.v1.WidgetMarkup.Button.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A button that can be clicked to trigger an action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Button button = 7;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.ButtonOrBuilder getButtonOrBuilder() {
      if (controlCase_ == 7) {
        return (com.google.chat.v1.WidgetMarkup.Button) control_;
      }
      return com.google.chat.v1.WidgetMarkup.Button.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (iconsCase_ == 1) {
        output.writeEnum(1, ((java.lang.Integer) icons_));
      }
      if (iconsCase_ == 2) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, icons_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topLabel_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, topLabel_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, content_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bottomLabel_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, bottomLabel_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(6, getOnClick());
      }
      if (controlCase_ == 7) {
        output.writeMessage(7, (com.google.chat.v1.WidgetMarkup.Button) control_);
      }
      if (contentMultiline_ != false) {
        output.writeBool(9, contentMultiline_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (iconsCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeEnumSize(1, ((java.lang.Integer) icons_));
      }
      if (iconsCase_ == 2) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, icons_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topLabel_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, topLabel_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, content_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bottomLabel_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, bottomLabel_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getOnClick());
      }
      if (controlCase_ == 7) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                7, (com.google.chat.v1.WidgetMarkup.Button) control_);
      }
      if (contentMultiline_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, contentMultiline_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.chat.v1.WidgetMarkup.KeyValue)) {
        return super.equals(obj);
      }
      com.google.chat.v1.WidgetMarkup.KeyValue other =
          (com.google.chat.v1.WidgetMarkup.KeyValue) obj;

      if (!getTopLabel().equals(other.getTopLabel())) return false;
      if (!getContent().equals(other.getContent())) return false;
      if (getContentMultiline() != other.getContentMultiline()) return false;
      if (!getBottomLabel().equals(other.getBottomLabel())) return false;
      if (hasOnClick() != other.hasOnClick()) return false;
      if (hasOnClick()) {
        if (!getOnClick().equals(other.getOnClick())) return false;
      }
      if (!getIconsCase().equals(other.getIconsCase())) return false;
      switch (iconsCase_) {
        case 1:
          if (getIconValue() != other.getIconValue()) return false;
          break;
        case 2:
          if (!getIconUrl().equals(other.getIconUrl())) return false;
          break;
        case 0:
        default:
      }
      if (!getControlCase().equals(other.getControlCase())) return false;
      switch (controlCase_) {
        case 7:
          if (!getButton().equals(other.getButton())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TOP_LABEL_FIELD_NUMBER;
      hash = (53 * hash) + getTopLabel().hashCode();
      hash = (37 * hash) + CONTENT_FIELD_NUMBER;
      hash = (53 * hash) + getContent().hashCode();
      hash = (37 * hash) + CONTENT_MULTILINE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getContentMultiline());
      hash = (37 * hash) + BOTTOM_LABEL_FIELD_NUMBER;
      hash = (53 * hash) + getBottomLabel().hashCode();
      if (hasOnClick()) {
        hash = (37 * hash) + ON_CLICK_FIELD_NUMBER;
        hash = (53 * hash) + getOnClick().hashCode();
      }
      switch (iconsCase_) {
        case 1:
          hash = (37 * hash) + ICON_FIELD_NUMBER;
          hash = (53 * hash) + getIconValue();
          break;
        case 2:
          hash = (37 * hash) + ICON_URL_FIELD_NUMBER;
          hash = (53 * hash) + getIconUrl().hashCode();
          break;
        case 0:
        default:
      }
      switch (controlCase_) {
        case 7:
          hash = (37 * hash) + BUTTON_FIELD_NUMBER;
          hash = (53 * hash) + getButton().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.chat.v1.WidgetMarkup.KeyValue parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.KeyValue parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.KeyValue parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.KeyValue parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.KeyValue parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.KeyValue parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.KeyValue parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.KeyValue parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.KeyValue parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.KeyValue parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.KeyValue parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.KeyValue parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.chat.v1.WidgetMarkup.KeyValue prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A UI element contains a key (label) and a value (content). This
     * element can also contain some actions such as `onclick` button.
     * </pre>
     *
     * Protobuf type {@code google.chat.v1.WidgetMarkup.KeyValue}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.chat.v1.WidgetMarkup.KeyValue)
        com.google.chat.v1.WidgetMarkup.KeyValueOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_KeyValue_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_KeyValue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.chat.v1.WidgetMarkup.KeyValue.class,
                com.google.chat.v1.WidgetMarkup.KeyValue.Builder.class);
      }

      // Construct using com.google.chat.v1.WidgetMarkup.KeyValue.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getOnClickFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        topLabel_ = "";
        content_ = "";
        contentMultiline_ = false;
        bottomLabel_ = "";
        onClick_ = null;
        if (onClickBuilder_ != null) {
          onClickBuilder_.dispose();
          onClickBuilder_ = null;
        }
        if (buttonBuilder_ != null) {
          buttonBuilder_.clear();
        }
        iconsCase_ = 0;
        icons_ = null;
        controlCase_ = 0;
        control_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_KeyValue_descriptor;
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.KeyValue getDefaultInstanceForType() {
        return com.google.chat.v1.WidgetMarkup.KeyValue.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.KeyValue build() {
        com.google.chat.v1.WidgetMarkup.KeyValue result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.KeyValue buildPartial() {
        com.google.chat.v1.WidgetMarkup.KeyValue result =
            new com.google.chat.v1.WidgetMarkup.KeyValue(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.chat.v1.WidgetMarkup.KeyValue result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.topLabel_ = topLabel_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.content_ = content_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.contentMultiline_ = contentMultiline_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.bottomLabel_ = bottomLabel_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.onClick_ = onClickBuilder_ == null ? onClick_ : onClickBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(com.google.chat.v1.WidgetMarkup.KeyValue result) {
        result.iconsCase_ = iconsCase_;
        result.icons_ = this.icons_;
        result.controlCase_ = controlCase_;
        result.control_ = this.control_;
        if (controlCase_ == 7 && buttonBuilder_ != null) {
          result.control_ = buttonBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.chat.v1.WidgetMarkup.KeyValue) {
          return mergeFrom((com.google.chat.v1.WidgetMarkup.KeyValue) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.chat.v1.WidgetMarkup.KeyValue other) {
        if (other == com.google.chat.v1.WidgetMarkup.KeyValue.getDefaultInstance()) return this;
        if (!other.getTopLabel().isEmpty()) {
          topLabel_ = other.topLabel_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getContent().isEmpty()) {
          content_ = other.content_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (other.getContentMultiline() != false) {
          setContentMultiline(other.getContentMultiline());
        }
        if (!other.getBottomLabel().isEmpty()) {
          bottomLabel_ = other.bottomLabel_;
          bitField0_ |= 0x00000020;
          onChanged();
        }
        if (other.hasOnClick()) {
          mergeOnClick(other.getOnClick());
        }
        switch (other.getIconsCase()) {
          case ICON:
            {
              setIconValue(other.getIconValue());
              break;
            }
          case ICON_URL:
            {
              iconsCase_ = 2;
              icons_ = other.icons_;
              onChanged();
              break;
            }
          case ICONS_NOT_SET:
            {
              break;
            }
        }
        switch (other.getControlCase()) {
          case BUTTON:
            {
              mergeButton(other.getButton());
              break;
            }
          case CONTROL_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  int rawValue = input.readEnum();
                  iconsCase_ = 1;
                  icons_ = rawValue;
                  break;
                } // case 8
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  iconsCase_ = 2;
                  icons_ = s;
                  break;
                } // case 18
              case 26:
                {
                  topLabel_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  content_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  bottomLabel_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(getOnClickFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000040;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(getButtonFieldBuilder().getBuilder(), extensionRegistry);
                  controlCase_ = 7;
                  break;
                } // case 58
              case 72:
                {
                  contentMultiline_ = input.readBool();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 72
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int iconsCase_ = 0;
      private java.lang.Object icons_;

      public IconsCase getIconsCase() {
        return IconsCase.forNumber(iconsCase_);
      }

      public Builder clearIcons() {
        iconsCase_ = 0;
        icons_ = null;
        onChanged();
        return this;
      }

      private int controlCase_ = 0;
      private java.lang.Object control_;

      public ControlCase getControlCase() {
        return ControlCase.forNumber(controlCase_);
      }

      public Builder clearControl() {
        controlCase_ = 0;
        control_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * An enum value that's replaced by the Chat API with the
       * corresponding icon image.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
       *
       * @return Whether the icon field is set.
       */
      @java.lang.Override
      public boolean hasIcon() {
        return iconsCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * An enum value that's replaced by the Chat API with the
       * corresponding icon image.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
       *
       * @return The enum numeric value on the wire for icon.
       */
      @java.lang.Override
      public int getIconValue() {
        if (iconsCase_ == 1) {
          return ((java.lang.Integer) icons_).intValue();
        }
        return 0;
      }
      /**
       *
       *
       * <pre>
       * An enum value that's replaced by the Chat API with the
       * corresponding icon image.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
       *
       * @param value The enum numeric value on the wire for icon to set.
       * @return This builder for chaining.
       */
      public Builder setIconValue(int value) {
        iconsCase_ = 1;
        icons_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An enum value that's replaced by the Chat API with the
       * corresponding icon image.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
       *
       * @return The icon.
       */
      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.Icon getIcon() {
        if (iconsCase_ == 1) {
          com.google.chat.v1.WidgetMarkup.Icon result =
              com.google.chat.v1.WidgetMarkup.Icon.forNumber((java.lang.Integer) icons_);
          return result == null ? com.google.chat.v1.WidgetMarkup.Icon.UNRECOGNIZED : result;
        }
        return com.google.chat.v1.WidgetMarkup.Icon.ICON_UNSPECIFIED;
      }
      /**
       *
       *
       * <pre>
       * An enum value that's replaced by the Chat API with the
       * corresponding icon image.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
       *
       * @param value The icon to set.
       * @return This builder for chaining.
       */
      public Builder setIcon(com.google.chat.v1.WidgetMarkup.Icon value) {
        if (value == null) {
          throw new NullPointerException();
        }
        iconsCase_ = 1;
        icons_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An enum value that's replaced by the Chat API with the
       * corresponding icon image.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIcon() {
        if (iconsCase_ == 1) {
          iconsCase_ = 0;
          icons_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The icon specified by a URL.
       * </pre>
       *
       * <code>string icon_url = 2;</code>
       *
       * @return Whether the iconUrl field is set.
       */
      @java.lang.Override
      public boolean hasIconUrl() {
        return iconsCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The icon specified by a URL.
       * </pre>
       *
       * <code>string icon_url = 2;</code>
       *
       * @return The iconUrl.
       */
      @java.lang.Override
      public java.lang.String getIconUrl() {
        java.lang.Object ref = "";
        if (iconsCase_ == 2) {
          ref = icons_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (iconsCase_ == 2) {
            icons_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The icon specified by a URL.
       * </pre>
       *
       * <code>string icon_url = 2;</code>
       *
       * @return The bytes for iconUrl.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getIconUrlBytes() {
        java.lang.Object ref = "";
        if (iconsCase_ == 2) {
          ref = icons_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (iconsCase_ == 2) {
            icons_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The icon specified by a URL.
       * </pre>
       *
       * <code>string icon_url = 2;</code>
       *
       * @param value The iconUrl to set.
       * @return This builder for chaining.
       */
      public Builder setIconUrl(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        iconsCase_ = 2;
        icons_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The icon specified by a URL.
       * </pre>
       *
       * <code>string icon_url = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIconUrl() {
        if (iconsCase_ == 2) {
          iconsCase_ = 0;
          icons_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The icon specified by a URL.
       * </pre>
       *
       * <code>string icon_url = 2;</code>
       *
       * @param value The bytes for iconUrl to set.
       * @return This builder for chaining.
       */
      public Builder setIconUrlBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        iconsCase_ = 2;
        icons_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object topLabel_ = "";
      /**
       *
       *
       * <pre>
       * The text of the top label. Formatted text supported. For more information
       * about formatting text, see
       * [Formatting text in Google Chat
       * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
       * and
       * [Formatting
       * text in Google Workspace
       * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
       * </pre>
       *
       * <code>string top_label = 3;</code>
       *
       * @return The topLabel.
       */
      public java.lang.String getTopLabel() {
        java.lang.Object ref = topLabel_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          topLabel_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The text of the top label. Formatted text supported. For more information
       * about formatting text, see
       * [Formatting text in Google Chat
       * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
       * and
       * [Formatting
       * text in Google Workspace
       * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
       * </pre>
       *
       * <code>string top_label = 3;</code>
       *
       * @return The bytes for topLabel.
       */
      public com.google.protobuf.ByteString getTopLabelBytes() {
        java.lang.Object ref = topLabel_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          topLabel_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The text of the top label. Formatted text supported. For more information
       * about formatting text, see
       * [Formatting text in Google Chat
       * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
       * and
       * [Formatting
       * text in Google Workspace
       * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
       * </pre>
       *
       * <code>string top_label = 3;</code>
       *
       * @param value The topLabel to set.
       * @return This builder for chaining.
       */
      public Builder setTopLabel(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        topLabel_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The text of the top label. Formatted text supported. For more information
       * about formatting text, see
       * [Formatting text in Google Chat
       * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
       * and
       * [Formatting
       * text in Google Workspace
       * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
       * </pre>
       *
       * <code>string top_label = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTopLabel() {
        topLabel_ = getDefaultInstance().getTopLabel();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The text of the top label. Formatted text supported. For more information
       * about formatting text, see
       * [Formatting text in Google Chat
       * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
       * and
       * [Formatting
       * text in Google Workspace
       * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
       * </pre>
       *
       * <code>string top_label = 3;</code>
       *
       * @param value The bytes for topLabel to set.
       * @return This builder for chaining.
       */
      public Builder setTopLabelBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        topLabel_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object content_ = "";
      /**
       *
       *
       * <pre>
       * The text of the content. Formatted text supported and always required.
       * For more information
       * about formatting text, see
       * [Formatting text in Google Chat
       * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
       * and
       * [Formatting
       * text in Google Workspace
       * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
       * </pre>
       *
       * <code>string content = 4;</code>
       *
       * @return The content.
       */
      public java.lang.String getContent() {
        java.lang.Object ref = content_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          content_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The text of the content. Formatted text supported and always required.
       * For more information
       * about formatting text, see
       * [Formatting text in Google Chat
       * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
       * and
       * [Formatting
       * text in Google Workspace
       * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
       * </pre>
       *
       * <code>string content = 4;</code>
       *
       * @return The bytes for content.
       */
      public com.google.protobuf.ByteString getContentBytes() {
        java.lang.Object ref = content_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          content_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The text of the content. Formatted text supported and always required.
       * For more information
       * about formatting text, see
       * [Formatting text in Google Chat
       * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
       * and
       * [Formatting
       * text in Google Workspace
       * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
       * </pre>
       *
       * <code>string content = 4;</code>
       *
       * @param value The content to set.
       * @return This builder for chaining.
       */
      public Builder setContent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        content_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The text of the content. Formatted text supported and always required.
       * For more information
       * about formatting text, see
       * [Formatting text in Google Chat
       * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
       * and
       * [Formatting
       * text in Google Workspace
       * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
       * </pre>
       *
       * <code>string content = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContent() {
        content_ = getDefaultInstance().getContent();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The text of the content. Formatted text supported and always required.
       * For more information
       * about formatting text, see
       * [Formatting text in Google Chat
       * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
       * and
       * [Formatting
       * text in Google Workspace
       * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
       * </pre>
       *
       * <code>string content = 4;</code>
       *
       * @param value The bytes for content to set.
       * @return This builder for chaining.
       */
      public Builder setContentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        content_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private boolean contentMultiline_;
      /**
       *
       *
       * <pre>
       * If the content should be multiline.
       * </pre>
       *
       * <code>bool content_multiline = 9;</code>
       *
       * @return The contentMultiline.
       */
      @java.lang.Override
      public boolean getContentMultiline() {
        return contentMultiline_;
      }
      /**
       *
       *
       * <pre>
       * If the content should be multiline.
       * </pre>
       *
       * <code>bool content_multiline = 9;</code>
       *
       * @param value The contentMultiline to set.
       * @return This builder for chaining.
       */
      public Builder setContentMultiline(boolean value) {

        contentMultiline_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the content should be multiline.
       * </pre>
       *
       * <code>bool content_multiline = 9;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContentMultiline() {
        bitField0_ = (bitField0_ & ~0x00000010);
        contentMultiline_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object bottomLabel_ = "";
      /**
       *
       *
       * <pre>
       * The text of the bottom label. Formatted text supported. For more
       * information about formatting text, see [Formatting text in Google Chat
       * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
       * and
       * [Formatting
       * text in Google Workspace
       * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
       * </pre>
       *
       * <code>string bottom_label = 5;</code>
       *
       * @return The bottomLabel.
       */
      public java.lang.String getBottomLabel() {
        java.lang.Object ref = bottomLabel_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          bottomLabel_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The text of the bottom label. Formatted text supported. For more
       * information about formatting text, see [Formatting text in Google Chat
       * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
       * and
       * [Formatting
       * text in Google Workspace
       * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
       * </pre>
       *
       * <code>string bottom_label = 5;</code>
       *
       * @return The bytes for bottomLabel.
       */
      public com.google.protobuf.ByteString getBottomLabelBytes() {
        java.lang.Object ref = bottomLabel_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          bottomLabel_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The text of the bottom label. Formatted text supported. For more
       * information about formatting text, see [Formatting text in Google Chat
       * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
       * and
       * [Formatting
       * text in Google Workspace
       * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
       * </pre>
       *
       * <code>string bottom_label = 5;</code>
       *
       * @param value The bottomLabel to set.
       * @return This builder for chaining.
       */
      public Builder setBottomLabel(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bottomLabel_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The text of the bottom label. Formatted text supported. For more
       * information about formatting text, see [Formatting text in Google Chat
       * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
       * and
       * [Formatting
       * text in Google Workspace
       * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
       * </pre>
       *
       * <code>string bottom_label = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBottomLabel() {
        bottomLabel_ = getDefaultInstance().getBottomLabel();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The text of the bottom label. Formatted text supported. For more
       * information about formatting text, see [Formatting text in Google Chat
       * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
       * and
       * [Formatting
       * text in Google Workspace
       * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
       * </pre>
       *
       * <code>string bottom_label = 5;</code>
       *
       * @param value The bytes for bottomLabel to set.
       * @return This builder for chaining.
       */
      public Builder setBottomLabelBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        bottomLabel_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      private com.google.chat.v1.WidgetMarkup.OnClick onClick_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.WidgetMarkup.OnClick,
              com.google.chat.v1.WidgetMarkup.OnClick.Builder,
              com.google.chat.v1.WidgetMarkup.OnClickOrBuilder>
          onClickBuilder_;
      /**
       *
       *
       * <pre>
       * The `onclick` action. Only the top label, bottom label, and content
       * region are clickable.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 6;</code>
       *
       * @return Whether the onClick field is set.
       */
      public boolean hasOnClick() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action. Only the top label, bottom label, and content
       * region are clickable.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 6;</code>
       *
       * @return The onClick.
       */
      public com.google.chat.v1.WidgetMarkup.OnClick getOnClick() {
        if (onClickBuilder_ == null) {
          return onClick_ == null
              ? com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance()
              : onClick_;
        } else {
          return onClickBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action. Only the top label, bottom label, and content
       * region are clickable.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 6;</code>
       */
      public Builder setOnClick(com.google.chat.v1.WidgetMarkup.OnClick value) {
        if (onClickBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          onClick_ = value;
        } else {
          onClickBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action. Only the top label, bottom label, and content
       * region are clickable.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 6;</code>
       */
      public Builder setOnClick(com.google.chat.v1.WidgetMarkup.OnClick.Builder builderForValue) {
        if (onClickBuilder_ == null) {
          onClick_ = builderForValue.build();
        } else {
          onClickBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action. Only the top label, bottom label, and content
       * region are clickable.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 6;</code>
       */
      public Builder mergeOnClick(com.google.chat.v1.WidgetMarkup.OnClick value) {
        if (onClickBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)
              && onClick_ != null
              && onClick_ != com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance()) {
            getOnClickBuilder().mergeFrom(value);
          } else {
            onClick_ = value;
          }
        } else {
          onClickBuilder_.mergeFrom(value);
        }
        if (onClick_ != null) {
          bitField0_ |= 0x00000040;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action. Only the top label, bottom label, and content
       * region are clickable.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 6;</code>
       */
      public Builder clearOnClick() {
        bitField0_ = (bitField0_ & ~0x00000040);
        onClick_ = null;
        if (onClickBuilder_ != null) {
          onClickBuilder_.dispose();
          onClickBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action. Only the top label, bottom label, and content
       * region are clickable.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 6;</code>
       */
      public com.google.chat.v1.WidgetMarkup.OnClick.Builder getOnClickBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getOnClickFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action. Only the top label, bottom label, and content
       * region are clickable.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 6;</code>
       */
      public com.google.chat.v1.WidgetMarkup.OnClickOrBuilder getOnClickOrBuilder() {
        if (onClickBuilder_ != null) {
          return onClickBuilder_.getMessageOrBuilder();
        } else {
          return onClick_ == null
              ? com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance()
              : onClick_;
        }
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action. Only the top label, bottom label, and content
       * region are clickable.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.WidgetMarkup.OnClick,
              com.google.chat.v1.WidgetMarkup.OnClick.Builder,
              com.google.chat.v1.WidgetMarkup.OnClickOrBuilder>
          getOnClickFieldBuilder() {
        if (onClickBuilder_ == null) {
          onClickBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.chat.v1.WidgetMarkup.OnClick,
                  com.google.chat.v1.WidgetMarkup.OnClick.Builder,
                  com.google.chat.v1.WidgetMarkup.OnClickOrBuilder>(
                  getOnClick(), getParentForChildren(), isClean());
          onClick_ = null;
        }
        return onClickBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.WidgetMarkup.Button,
              com.google.chat.v1.WidgetMarkup.Button.Builder,
              com.google.chat.v1.WidgetMarkup.ButtonOrBuilder>
          buttonBuilder_;
      /**
       *
       *
       * <pre>
       * A button that can be clicked to trigger an action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.Button button = 7;</code>
       *
       * @return Whether the button field is set.
       */
      @java.lang.Override
      public boolean hasButton() {
        return controlCase_ == 7;
      }
      /**
       *
       *
       * <pre>
       * A button that can be clicked to trigger an action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.Button button = 7;</code>
       *
       * @return The button.
       */
      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.Button getButton() {
        if (buttonBuilder_ == null) {
          if (controlCase_ == 7) {
            return (com.google.chat.v1.WidgetMarkup.Button) control_;
          }
          return com.google.chat.v1.WidgetMarkup.Button.getDefaultInstance();
        } else {
          if (controlCase_ == 7) {
            return buttonBuilder_.getMessage();
          }
          return com.google.chat.v1.WidgetMarkup.Button.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A button that can be clicked to trigger an action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.Button button = 7;</code>
       */
      public Builder setButton(com.google.chat.v1.WidgetMarkup.Button value) {
        if (buttonBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          control_ = value;
          onChanged();
        } else {
          buttonBuilder_.setMessage(value);
        }
        controlCase_ = 7;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A button that can be clicked to trigger an action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.Button button = 7;</code>
       */
      public Builder setButton(com.google.chat.v1.WidgetMarkup.Button.Builder builderForValue) {
        if (buttonBuilder_ == null) {
          control_ = builderForValue.build();
          onChanged();
        } else {
          buttonBuilder_.setMessage(builderForValue.build());
        }
        controlCase_ = 7;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A button that can be clicked to trigger an action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.Button button = 7;</code>
       */
      public Builder mergeButton(com.google.chat.v1.WidgetMarkup.Button value) {
        if (buttonBuilder_ == null) {
          if (controlCase_ == 7
              && control_ != com.google.chat.v1.WidgetMarkup.Button.getDefaultInstance()) {
            control_ =
                com.google.chat.v1.WidgetMarkup.Button.newBuilder(
                        (com.google.chat.v1.WidgetMarkup.Button) control_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            control_ = value;
          }
          onChanged();
        } else {
          if (controlCase_ == 7) {
            buttonBuilder_.mergeFrom(value);
          } else {
            buttonBuilder_.setMessage(value);
          }
        }
        controlCase_ = 7;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A button that can be clicked to trigger an action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.Button button = 7;</code>
       */
      public Builder clearButton() {
        if (buttonBuilder_ == null) {
          if (controlCase_ == 7) {
            controlCase_ = 0;
            control_ = null;
            onChanged();
          }
        } else {
          if (controlCase_ == 7) {
            controlCase_ = 0;
            control_ = null;
          }
          buttonBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A button that can be clicked to trigger an action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.Button button = 7;</code>
       */
      public com.google.chat.v1.WidgetMarkup.Button.Builder getButtonBuilder() {
        return getButtonFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A button that can be clicked to trigger an action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.Button button = 7;</code>
       */
      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.ButtonOrBuilder getButtonOrBuilder() {
        if ((controlCase_ == 7) && (buttonBuilder_ != null)) {
          return buttonBuilder_.getMessageOrBuilder();
        } else {
          if (controlCase_ == 7) {
            return (com.google.chat.v1.WidgetMarkup.Button) control_;
          }
          return com.google.chat.v1.WidgetMarkup.Button.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A button that can be clicked to trigger an action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.Button button = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.WidgetMarkup.Button,
              com.google.chat.v1.WidgetMarkup.Button.Builder,
              com.google.chat.v1.WidgetMarkup.ButtonOrBuilder>
          getButtonFieldBuilder() {
        if (buttonBuilder_ == null) {
          if (!(controlCase_ == 7)) {
            control_ = com.google.chat.v1.WidgetMarkup.Button.getDefaultInstance();
          }
          buttonBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.chat.v1.WidgetMarkup.Button,
                  com.google.chat.v1.WidgetMarkup.Button.Builder,
                  com.google.chat.v1.WidgetMarkup.ButtonOrBuilder>(
                  (com.google.chat.v1.WidgetMarkup.Button) control_,
                  getParentForChildren(),
                  isClean());
          control_ = null;
        }
        controlCase_ = 7;
        onChanged();
        return buttonBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.chat.v1.WidgetMarkup.KeyValue)
    }

    // @@protoc_insertion_point(class_scope:google.chat.v1.WidgetMarkup.KeyValue)
    private static final com.google.chat.v1.WidgetMarkup.KeyValue DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.chat.v1.WidgetMarkup.KeyValue();
    }

    public static com.google.chat.v1.WidgetMarkup.KeyValue getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<KeyValue> PARSER =
        new com.google.protobuf.AbstractParser<KeyValue>() {
          @java.lang.Override
          public KeyValue parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<KeyValue> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<KeyValue> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.KeyValue getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ImageOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.chat.v1.WidgetMarkup.Image)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The URL of the image.
     * </pre>
     *
     * <code>string image_url = 1;</code>
     *
     * @return The imageUrl.
     */
    java.lang.String getImageUrl();
    /**
     *
     *
     * <pre>
     * The URL of the image.
     * </pre>
     *
     * <code>string image_url = 1;</code>
     *
     * @return The bytes for imageUrl.
     */
    com.google.protobuf.ByteString getImageUrlBytes();

    /**
     *
     *
     * <pre>
     * The `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
     *
     * @return Whether the onClick field is set.
     */
    boolean hasOnClick();
    /**
     *
     *
     * <pre>
     * The `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
     *
     * @return The onClick.
     */
    com.google.chat.v1.WidgetMarkup.OnClick getOnClick();
    /**
     *
     *
     * <pre>
     * The `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
     */
    com.google.chat.v1.WidgetMarkup.OnClickOrBuilder getOnClickOrBuilder();

    /**
     *
     *
     * <pre>
     * The aspect ratio of this image (width and height). This field lets you
     * reserve the right height for the image while waiting for it to load.
     * It's not meant to override the built-in aspect ratio of the image.
     * If unset, the server fills it by prefetching the image.
     * </pre>
     *
     * <code>double aspect_ratio = 3;</code>
     *
     * @return The aspectRatio.
     */
    double getAspectRatio();
  }
  /**
   *
   *
   * <pre>
   * An image that's specified by a URL and can have an `onclick` action.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.WidgetMarkup.Image}
   */
  public static final class Image extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.chat.v1.WidgetMarkup.Image)
      ImageOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Image.newBuilder() to construct.
    private Image(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Image() {
      imageUrl_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Image();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.WidgetsProto
          .internal_static_google_chat_v1_WidgetMarkup_Image_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.WidgetsProto
          .internal_static_google_chat_v1_WidgetMarkup_Image_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.WidgetMarkup.Image.class,
              com.google.chat.v1.WidgetMarkup.Image.Builder.class);
    }

    private int bitField0_;
    public static final int IMAGE_URL_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object imageUrl_ = "";
    /**
     *
     *
     * <pre>
     * The URL of the image.
     * </pre>
     *
     * <code>string image_url = 1;</code>
     *
     * @return The imageUrl.
     */
    @java.lang.Override
    public java.lang.String getImageUrl() {
      java.lang.Object ref = imageUrl_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        imageUrl_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of the image.
     * </pre>
     *
     * <code>string image_url = 1;</code>
     *
     * @return The bytes for imageUrl.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getImageUrlBytes() {
      java.lang.Object ref = imageUrl_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        imageUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ON_CLICK_FIELD_NUMBER = 2;
    private com.google.chat.v1.WidgetMarkup.OnClick onClick_;
    /**
     *
     *
     * <pre>
     * The `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
     *
     * @return Whether the onClick field is set.
     */
    @java.lang.Override
    public boolean hasOnClick() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
     *
     * @return The onClick.
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.OnClick getOnClick() {
      return onClick_ == null
          ? com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance()
          : onClick_;
    }
    /**
     *
     *
     * <pre>
     * The `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.OnClickOrBuilder getOnClickOrBuilder() {
      return onClick_ == null
          ? com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance()
          : onClick_;
    }

    public static final int ASPECT_RATIO_FIELD_NUMBER = 3;
    private double aspectRatio_ = 0D;
    /**
     *
     *
     * <pre>
     * The aspect ratio of this image (width and height). This field lets you
     * reserve the right height for the image while waiting for it to load.
     * It's not meant to override the built-in aspect ratio of the image.
     * If unset, the server fills it by prefetching the image.
     * </pre>
     *
     * <code>double aspect_ratio = 3;</code>
     *
     * @return The aspectRatio.
     */
    @java.lang.Override
    public double getAspectRatio() {
      return aspectRatio_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUrl_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, imageUrl_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getOnClick());
      }
      if (java.lang.Double.doubleToRawLongBits(aspectRatio_) != 0) {
        output.writeDouble(3, aspectRatio_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUrl_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, imageUrl_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOnClick());
      }
      if (java.lang.Double.doubleToRawLongBits(aspectRatio_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, aspectRatio_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.chat.v1.WidgetMarkup.Image)) {
        return super.equals(obj);
      }
      com.google.chat.v1.WidgetMarkup.Image other = (com.google.chat.v1.WidgetMarkup.Image) obj;

      if (!getImageUrl().equals(other.getImageUrl())) return false;
      if (hasOnClick() != other.hasOnClick()) return false;
      if (hasOnClick()) {
        if (!getOnClick().equals(other.getOnClick())) return false;
      }
      if (java.lang.Double.doubleToLongBits(getAspectRatio())
          != java.lang.Double.doubleToLongBits(other.getAspectRatio())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + IMAGE_URL_FIELD_NUMBER;
      hash = (53 * hash) + getImageUrl().hashCode();
      if (hasOnClick()) {
        hash = (37 * hash) + ON_CLICK_FIELD_NUMBER;
        hash = (53 * hash) + getOnClick().hashCode();
      }
      hash = (37 * hash) + ASPECT_RATIO_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getAspectRatio()));
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.chat.v1.WidgetMarkup.Image parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.Image parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.Image parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.Image parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.Image parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.Image parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.Image parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.Image parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.Image parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.Image parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.Image parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.Image parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.chat.v1.WidgetMarkup.Image prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An image that's specified by a URL and can have an `onclick` action.
     * </pre>
     *
     * Protobuf type {@code google.chat.v1.WidgetMarkup.Image}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.chat.v1.WidgetMarkup.Image)
        com.google.chat.v1.WidgetMarkup.ImageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_Image_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_Image_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.chat.v1.WidgetMarkup.Image.class,
                com.google.chat.v1.WidgetMarkup.Image.Builder.class);
      }

      // Construct using com.google.chat.v1.WidgetMarkup.Image.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getOnClickFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        imageUrl_ = "";
        onClick_ = null;
        if (onClickBuilder_ != null) {
          onClickBuilder_.dispose();
          onClickBuilder_ = null;
        }
        aspectRatio_ = 0D;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_Image_descriptor;
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.Image getDefaultInstanceForType() {
        return com.google.chat.v1.WidgetMarkup.Image.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.Image build() {
        com.google.chat.v1.WidgetMarkup.Image result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.Image buildPartial() {
        com.google.chat.v1.WidgetMarkup.Image result =
            new com.google.chat.v1.WidgetMarkup.Image(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.chat.v1.WidgetMarkup.Image result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.imageUrl_ = imageUrl_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.onClick_ = onClickBuilder_ == null ? onClick_ : onClickBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.aspectRatio_ = aspectRatio_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.chat.v1.WidgetMarkup.Image) {
          return mergeFrom((com.google.chat.v1.WidgetMarkup.Image) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.chat.v1.WidgetMarkup.Image other) {
        if (other == com.google.chat.v1.WidgetMarkup.Image.getDefaultInstance()) return this;
        if (!other.getImageUrl().isEmpty()) {
          imageUrl_ = other.imageUrl_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasOnClick()) {
          mergeOnClick(other.getOnClick());
        }
        if (other.getAspectRatio() != 0D) {
          setAspectRatio(other.getAspectRatio());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  imageUrl_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getOnClickFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 25:
                {
                  aspectRatio_ = input.readDouble();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 25
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object imageUrl_ = "";
      /**
       *
       *
       * <pre>
       * The URL of the image.
       * </pre>
       *
       * <code>string image_url = 1;</code>
       *
       * @return The imageUrl.
       */
      public java.lang.String getImageUrl() {
        java.lang.Object ref = imageUrl_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          imageUrl_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The URL of the image.
       * </pre>
       *
       * <code>string image_url = 1;</code>
       *
       * @return The bytes for imageUrl.
       */
      public com.google.protobuf.ByteString getImageUrlBytes() {
        java.lang.Object ref = imageUrl_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          imageUrl_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The URL of the image.
       * </pre>
       *
       * <code>string image_url = 1;</code>
       *
       * @param value The imageUrl to set.
       * @return This builder for chaining.
       */
      public Builder setImageUrl(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        imageUrl_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The URL of the image.
       * </pre>
       *
       * <code>string image_url = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearImageUrl() {
        imageUrl_ = getDefaultInstance().getImageUrl();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The URL of the image.
       * </pre>
       *
       * <code>string image_url = 1;</code>
       *
       * @param value The bytes for imageUrl to set.
       * @return This builder for chaining.
       */
      public Builder setImageUrlBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        imageUrl_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.chat.v1.WidgetMarkup.OnClick onClick_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.WidgetMarkup.OnClick,
              com.google.chat.v1.WidgetMarkup.OnClick.Builder,
              com.google.chat.v1.WidgetMarkup.OnClickOrBuilder>
          onClickBuilder_;
      /**
       *
       *
       * <pre>
       * The `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       *
       * @return Whether the onClick field is set.
       */
      public boolean hasOnClick() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       *
       * @return The onClick.
       */
      public com.google.chat.v1.WidgetMarkup.OnClick getOnClick() {
        if (onClickBuilder_ == null) {
          return onClick_ == null
              ? com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance()
              : onClick_;
        } else {
          return onClickBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       */
      public Builder setOnClick(com.google.chat.v1.WidgetMarkup.OnClick value) {
        if (onClickBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          onClick_ = value;
        } else {
          onClickBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       */
      public Builder setOnClick(com.google.chat.v1.WidgetMarkup.OnClick.Builder builderForValue) {
        if (onClickBuilder_ == null) {
          onClick_ = builderForValue.build();
        } else {
          onClickBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       */
      public Builder mergeOnClick(com.google.chat.v1.WidgetMarkup.OnClick value) {
        if (onClickBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && onClick_ != null
              && onClick_ != com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance()) {
            getOnClickBuilder().mergeFrom(value);
          } else {
            onClick_ = value;
          }
        } else {
          onClickBuilder_.mergeFrom(value);
        }
        if (onClick_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       */
      public Builder clearOnClick() {
        bitField0_ = (bitField0_ & ~0x00000002);
        onClick_ = null;
        if (onClickBuilder_ != null) {
          onClickBuilder_.dispose();
          onClickBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       */
      public com.google.chat.v1.WidgetMarkup.OnClick.Builder getOnClickBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getOnClickFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       */
      public com.google.chat.v1.WidgetMarkup.OnClickOrBuilder getOnClickOrBuilder() {
        if (onClickBuilder_ != null) {
          return onClickBuilder_.getMessageOrBuilder();
        } else {
          return onClick_ == null
              ? com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance()
              : onClick_;
        }
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.WidgetMarkup.OnClick,
              com.google.chat.v1.WidgetMarkup.OnClick.Builder,
              com.google.chat.v1.WidgetMarkup.OnClickOrBuilder>
          getOnClickFieldBuilder() {
        if (onClickBuilder_ == null) {
          onClickBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.chat.v1.WidgetMarkup.OnClick,
                  com.google.chat.v1.WidgetMarkup.OnClick.Builder,
                  com.google.chat.v1.WidgetMarkup.OnClickOrBuilder>(
                  getOnClick(), getParentForChildren(), isClean());
          onClick_ = null;
        }
        return onClickBuilder_;
      }

      private double aspectRatio_;
      /**
       *
       *
       * <pre>
       * The aspect ratio of this image (width and height). This field lets you
       * reserve the right height for the image while waiting for it to load.
       * It's not meant to override the built-in aspect ratio of the image.
       * If unset, the server fills it by prefetching the image.
       * </pre>
       *
       * <code>double aspect_ratio = 3;</code>
       *
       * @return The aspectRatio.
       */
      @java.lang.Override
      public double getAspectRatio() {
        return aspectRatio_;
      }
      /**
       *
       *
       * <pre>
       * The aspect ratio of this image (width and height). This field lets you
       * reserve the right height for the image while waiting for it to load.
       * It's not meant to override the built-in aspect ratio of the image.
       * If unset, the server fills it by prefetching the image.
       * </pre>
       *
       * <code>double aspect_ratio = 3;</code>
       *
       * @param value The aspectRatio to set.
       * @return This builder for chaining.
       */
      public Builder setAspectRatio(double value) {

        aspectRatio_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The aspect ratio of this image (width and height). This field lets you
       * reserve the right height for the image while waiting for it to load.
       * It's not meant to override the built-in aspect ratio of the image.
       * If unset, the server fills it by prefetching the image.
       * </pre>
       *
       * <code>double aspect_ratio = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAspectRatio() {
        bitField0_ = (bitField0_ & ~0x00000004);
        aspectRatio_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.chat.v1.WidgetMarkup.Image)
    }

    // @@protoc_insertion_point(class_scope:google.chat.v1.WidgetMarkup.Image)
    private static final com.google.chat.v1.WidgetMarkup.Image DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.chat.v1.WidgetMarkup.Image();
    }

    public static com.google.chat.v1.WidgetMarkup.Image getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Image> PARSER =
        new com.google.protobuf.AbstractParser<Image>() {
          @java.lang.Override
          public Image parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Image> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Image> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.Image getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ImageButtonOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.chat.v1.WidgetMarkup.ImageButton)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The icon specified by an `enum` that indices to an icon provided by
     * Chat API.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
     *
     * @return Whether the icon field is set.
     */
    boolean hasIcon();
    /**
     *
     *
     * <pre>
     * The icon specified by an `enum` that indices to an icon provided by
     * Chat API.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
     *
     * @return The enum numeric value on the wire for icon.
     */
    int getIconValue();
    /**
     *
     *
     * <pre>
     * The icon specified by an `enum` that indices to an icon provided by
     * Chat API.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
     *
     * @return The icon.
     */
    com.google.chat.v1.WidgetMarkup.Icon getIcon();

    /**
     *
     *
     * <pre>
     * The icon specified by a URL.
     * </pre>
     *
     * <code>string icon_url = 3;</code>
     *
     * @return Whether the iconUrl field is set.
     */
    boolean hasIconUrl();
    /**
     *
     *
     * <pre>
     * The icon specified by a URL.
     * </pre>
     *
     * <code>string icon_url = 3;</code>
     *
     * @return The iconUrl.
     */
    java.lang.String getIconUrl();
    /**
     *
     *
     * <pre>
     * The icon specified by a URL.
     * </pre>
     *
     * <code>string icon_url = 3;</code>
     *
     * @return The bytes for iconUrl.
     */
    com.google.protobuf.ByteString getIconUrlBytes();

    /**
     *
     *
     * <pre>
     * The `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
     *
     * @return Whether the onClick field is set.
     */
    boolean hasOnClick();
    /**
     *
     *
     * <pre>
     * The `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
     *
     * @return The onClick.
     */
    com.google.chat.v1.WidgetMarkup.OnClick getOnClick();
    /**
     *
     *
     * <pre>
     * The `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
     */
    com.google.chat.v1.WidgetMarkup.OnClickOrBuilder getOnClickOrBuilder();

    /**
     *
     *
     * <pre>
     * The name of this `image_button` that's used for accessibility.
     * Default value is provided if this name isn't specified.
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * The name of this `image_button` that's used for accessibility.
     * Default value is provided if this name isn't specified.
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    com.google.chat.v1.WidgetMarkup.ImageButton.IconsCase getIconsCase();
  }
  /**
   *
   *
   * <pre>
   * An image button with an `onclick` action.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.WidgetMarkup.ImageButton}
   */
  public static final class ImageButton extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.chat.v1.WidgetMarkup.ImageButton)
      ImageButtonOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ImageButton.newBuilder() to construct.
    private ImageButton(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ImageButton() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ImageButton();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.WidgetsProto
          .internal_static_google_chat_v1_WidgetMarkup_ImageButton_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.WidgetsProto
          .internal_static_google_chat_v1_WidgetMarkup_ImageButton_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.WidgetMarkup.ImageButton.class,
              com.google.chat.v1.WidgetMarkup.ImageButton.Builder.class);
    }

    private int bitField0_;
    private int iconsCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object icons_;

    public enum IconsCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      ICON(1),
      ICON_URL(3),
      ICONS_NOT_SET(0);
      private final int value;

      private IconsCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static IconsCase valueOf(int value) {
        return forNumber(value);
      }

      public static IconsCase forNumber(int value) {
        switch (value) {
          case 1:
            return ICON;
          case 3:
            return ICON_URL;
          case 0:
            return ICONS_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public IconsCase getIconsCase() {
      return IconsCase.forNumber(iconsCase_);
    }

    public static final int ICON_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * The icon specified by an `enum` that indices to an icon provided by
     * Chat API.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
     *
     * @return Whether the icon field is set.
     */
    public boolean hasIcon() {
      return iconsCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The icon specified by an `enum` that indices to an icon provided by
     * Chat API.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
     *
     * @return The enum numeric value on the wire for icon.
     */
    public int getIconValue() {
      if (iconsCase_ == 1) {
        return (java.lang.Integer) icons_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * The icon specified by an `enum` that indices to an icon provided by
     * Chat API.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
     *
     * @return The icon.
     */
    public com.google.chat.v1.WidgetMarkup.Icon getIcon() {
      if (iconsCase_ == 1) {
        com.google.chat.v1.WidgetMarkup.Icon result =
            com.google.chat.v1.WidgetMarkup.Icon.forNumber((java.lang.Integer) icons_);
        return result == null ? com.google.chat.v1.WidgetMarkup.Icon.UNRECOGNIZED : result;
      }
      return com.google.chat.v1.WidgetMarkup.Icon.ICON_UNSPECIFIED;
    }

    public static final int ICON_URL_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * The icon specified by a URL.
     * </pre>
     *
     * <code>string icon_url = 3;</code>
     *
     * @return Whether the iconUrl field is set.
     */
    public boolean hasIconUrl() {
      return iconsCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The icon specified by a URL.
     * </pre>
     *
     * <code>string icon_url = 3;</code>
     *
     * @return The iconUrl.
     */
    public java.lang.String getIconUrl() {
      java.lang.Object ref = "";
      if (iconsCase_ == 3) {
        ref = icons_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (iconsCase_ == 3) {
          icons_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The icon specified by a URL.
     * </pre>
     *
     * <code>string icon_url = 3;</code>
     *
     * @return The bytes for iconUrl.
     */
    public com.google.protobuf.ByteString getIconUrlBytes() {
      java.lang.Object ref = "";
      if (iconsCase_ == 3) {
        ref = icons_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (iconsCase_ == 3) {
          icons_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ON_CLICK_FIELD_NUMBER = 2;
    private com.google.chat.v1.WidgetMarkup.OnClick onClick_;
    /**
     *
     *
     * <pre>
     * The `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
     *
     * @return Whether the onClick field is set.
     */
    @java.lang.Override
    public boolean hasOnClick() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
     *
     * @return The onClick.
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.OnClick getOnClick() {
      return onClick_ == null
          ? com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance()
          : onClick_;
    }
    /**
     *
     *
     * <pre>
     * The `onclick` action.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.OnClickOrBuilder getOnClickOrBuilder() {
      return onClick_ == null
          ? com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance()
          : onClick_;
    }

    public static final int NAME_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of this `image_button` that's used for accessibility.
     * Default value is provided if this name isn't specified.
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of this `image_button` that's used for accessibility.
     * Default value is provided if this name isn't specified.
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (iconsCase_ == 1) {
        output.writeEnum(1, ((java.lang.Integer) icons_));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getOnClick());
      }
      if (iconsCase_ == 3) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, icons_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, name_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (iconsCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeEnumSize(1, ((java.lang.Integer) icons_));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOnClick());
      }
      if (iconsCase_ == 3) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, icons_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, name_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.chat.v1.WidgetMarkup.ImageButton)) {
        return super.equals(obj);
      }
      com.google.chat.v1.WidgetMarkup.ImageButton other =
          (com.google.chat.v1.WidgetMarkup.ImageButton) obj;

      if (hasOnClick() != other.hasOnClick()) return false;
      if (hasOnClick()) {
        if (!getOnClick().equals(other.getOnClick())) return false;
      }
      if (!getName().equals(other.getName())) return false;
      if (!getIconsCase().equals(other.getIconsCase())) return false;
      switch (iconsCase_) {
        case 1:
          if (getIconValue() != other.getIconValue()) return false;
          break;
        case 3:
          if (!getIconUrl().equals(other.getIconUrl())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasOnClick()) {
        hash = (37 * hash) + ON_CLICK_FIELD_NUMBER;
        hash = (53 * hash) + getOnClick().hashCode();
      }
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      switch (iconsCase_) {
        case 1:
          hash = (37 * hash) + ICON_FIELD_NUMBER;
          hash = (53 * hash) + getIconValue();
          break;
        case 3:
          hash = (37 * hash) + ICON_URL_FIELD_NUMBER;
          hash = (53 * hash) + getIconUrl().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.chat.v1.WidgetMarkup.ImageButton parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.ImageButton parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.ImageButton parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.ImageButton parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.ImageButton parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.ImageButton parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.ImageButton parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.ImageButton parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.ImageButton parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.ImageButton parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.ImageButton parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.ImageButton parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.chat.v1.WidgetMarkup.ImageButton prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An image button with an `onclick` action.
     * </pre>
     *
     * Protobuf type {@code google.chat.v1.WidgetMarkup.ImageButton}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.chat.v1.WidgetMarkup.ImageButton)
        com.google.chat.v1.WidgetMarkup.ImageButtonOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_ImageButton_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_ImageButton_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.chat.v1.WidgetMarkup.ImageButton.class,
                com.google.chat.v1.WidgetMarkup.ImageButton.Builder.class);
      }

      // Construct using com.google.chat.v1.WidgetMarkup.ImageButton.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getOnClickFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        onClick_ = null;
        if (onClickBuilder_ != null) {
          onClickBuilder_.dispose();
          onClickBuilder_ = null;
        }
        name_ = "";
        iconsCase_ = 0;
        icons_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_ImageButton_descriptor;
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.ImageButton getDefaultInstanceForType() {
        return com.google.chat.v1.WidgetMarkup.ImageButton.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.ImageButton build() {
        com.google.chat.v1.WidgetMarkup.ImageButton result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.ImageButton buildPartial() {
        com.google.chat.v1.WidgetMarkup.ImageButton result =
            new com.google.chat.v1.WidgetMarkup.ImageButton(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.chat.v1.WidgetMarkup.ImageButton result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.onClick_ = onClickBuilder_ == null ? onClick_ : onClickBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.name_ = name_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(com.google.chat.v1.WidgetMarkup.ImageButton result) {
        result.iconsCase_ = iconsCase_;
        result.icons_ = this.icons_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.chat.v1.WidgetMarkup.ImageButton) {
          return mergeFrom((com.google.chat.v1.WidgetMarkup.ImageButton) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.chat.v1.WidgetMarkup.ImageButton other) {
        if (other == com.google.chat.v1.WidgetMarkup.ImageButton.getDefaultInstance()) return this;
        if (other.hasOnClick()) {
          mergeOnClick(other.getOnClick());
        }
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        switch (other.getIconsCase()) {
          case ICON:
            {
              setIconValue(other.getIconValue());
              break;
            }
          case ICON_URL:
            {
              iconsCase_ = 3;
              icons_ = other.icons_;
              onChanged();
              break;
            }
          case ICONS_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  int rawValue = input.readEnum();
                  iconsCase_ = 1;
                  icons_ = rawValue;
                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(getOnClickFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  iconsCase_ = 3;
                  icons_ = s;
                  break;
                } // case 26
              case 34:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int iconsCase_ = 0;
      private java.lang.Object icons_;

      public IconsCase getIconsCase() {
        return IconsCase.forNumber(iconsCase_);
      }

      public Builder clearIcons() {
        iconsCase_ = 0;
        icons_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * The icon specified by an `enum` that indices to an icon provided by
       * Chat API.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
       *
       * @return Whether the icon field is set.
       */
      @java.lang.Override
      public boolean hasIcon() {
        return iconsCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * The icon specified by an `enum` that indices to an icon provided by
       * Chat API.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
       *
       * @return The enum numeric value on the wire for icon.
       */
      @java.lang.Override
      public int getIconValue() {
        if (iconsCase_ == 1) {
          return ((java.lang.Integer) icons_).intValue();
        }
        return 0;
      }
      /**
       *
       *
       * <pre>
       * The icon specified by an `enum` that indices to an icon provided by
       * Chat API.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
       *
       * @param value The enum numeric value on the wire for icon to set.
       * @return This builder for chaining.
       */
      public Builder setIconValue(int value) {
        iconsCase_ = 1;
        icons_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The icon specified by an `enum` that indices to an icon provided by
       * Chat API.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
       *
       * @return The icon.
       */
      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.Icon getIcon() {
        if (iconsCase_ == 1) {
          com.google.chat.v1.WidgetMarkup.Icon result =
              com.google.chat.v1.WidgetMarkup.Icon.forNumber((java.lang.Integer) icons_);
          return result == null ? com.google.chat.v1.WidgetMarkup.Icon.UNRECOGNIZED : result;
        }
        return com.google.chat.v1.WidgetMarkup.Icon.ICON_UNSPECIFIED;
      }
      /**
       *
       *
       * <pre>
       * The icon specified by an `enum` that indices to an icon provided by
       * Chat API.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
       *
       * @param value The icon to set.
       * @return This builder for chaining.
       */
      public Builder setIcon(com.google.chat.v1.WidgetMarkup.Icon value) {
        if (value == null) {
          throw new NullPointerException();
        }
        iconsCase_ = 1;
        icons_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The icon specified by an `enum` that indices to an icon provided by
       * Chat API.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.Icon icon = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIcon() {
        if (iconsCase_ == 1) {
          iconsCase_ = 0;
          icons_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The icon specified by a URL.
       * </pre>
       *
       * <code>string icon_url = 3;</code>
       *
       * @return Whether the iconUrl field is set.
       */
      @java.lang.Override
      public boolean hasIconUrl() {
        return iconsCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * The icon specified by a URL.
       * </pre>
       *
       * <code>string icon_url = 3;</code>
       *
       * @return The iconUrl.
       */
      @java.lang.Override
      public java.lang.String getIconUrl() {
        java.lang.Object ref = "";
        if (iconsCase_ == 3) {
          ref = icons_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (iconsCase_ == 3) {
            icons_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The icon specified by a URL.
       * </pre>
       *
       * <code>string icon_url = 3;</code>
       *
       * @return The bytes for iconUrl.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getIconUrlBytes() {
        java.lang.Object ref = "";
        if (iconsCase_ == 3) {
          ref = icons_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (iconsCase_ == 3) {
            icons_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The icon specified by a URL.
       * </pre>
       *
       * <code>string icon_url = 3;</code>
       *
       * @param value The iconUrl to set.
       * @return This builder for chaining.
       */
      public Builder setIconUrl(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        iconsCase_ = 3;
        icons_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The icon specified by a URL.
       * </pre>
       *
       * <code>string icon_url = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIconUrl() {
        if (iconsCase_ == 3) {
          iconsCase_ = 0;
          icons_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The icon specified by a URL.
       * </pre>
       *
       * <code>string icon_url = 3;</code>
       *
       * @param value The bytes for iconUrl to set.
       * @return This builder for chaining.
       */
      public Builder setIconUrlBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        iconsCase_ = 3;
        icons_ = value;
        onChanged();
        return this;
      }

      private com.google.chat.v1.WidgetMarkup.OnClick onClick_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.WidgetMarkup.OnClick,
              com.google.chat.v1.WidgetMarkup.OnClick.Builder,
              com.google.chat.v1.WidgetMarkup.OnClickOrBuilder>
          onClickBuilder_;
      /**
       *
       *
       * <pre>
       * The `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       *
       * @return Whether the onClick field is set.
       */
      public boolean hasOnClick() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       *
       * @return The onClick.
       */
      public com.google.chat.v1.WidgetMarkup.OnClick getOnClick() {
        if (onClickBuilder_ == null) {
          return onClick_ == null
              ? com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance()
              : onClick_;
        } else {
          return onClickBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       */
      public Builder setOnClick(com.google.chat.v1.WidgetMarkup.OnClick value) {
        if (onClickBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          onClick_ = value;
        } else {
          onClickBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       */
      public Builder setOnClick(com.google.chat.v1.WidgetMarkup.OnClick.Builder builderForValue) {
        if (onClickBuilder_ == null) {
          onClick_ = builderForValue.build();
        } else {
          onClickBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       */
      public Builder mergeOnClick(com.google.chat.v1.WidgetMarkup.OnClick value) {
        if (onClickBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && onClick_ != null
              && onClick_ != com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance()) {
            getOnClickBuilder().mergeFrom(value);
          } else {
            onClick_ = value;
          }
        } else {
          onClickBuilder_.mergeFrom(value);
        }
        if (onClick_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       */
      public Builder clearOnClick() {
        bitField0_ = (bitField0_ & ~0x00000004);
        onClick_ = null;
        if (onClickBuilder_ != null) {
          onClickBuilder_.dispose();
          onClickBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       */
      public com.google.chat.v1.WidgetMarkup.OnClick.Builder getOnClickBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getOnClickFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       */
      public com.google.chat.v1.WidgetMarkup.OnClickOrBuilder getOnClickOrBuilder() {
        if (onClickBuilder_ != null) {
          return onClickBuilder_.getMessageOrBuilder();
        } else {
          return onClick_ == null
              ? com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance()
              : onClick_;
        }
      }
      /**
       *
       *
       * <pre>
       * The `onclick` action.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OnClick on_click = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.WidgetMarkup.OnClick,
              com.google.chat.v1.WidgetMarkup.OnClick.Builder,
              com.google.chat.v1.WidgetMarkup.OnClickOrBuilder>
          getOnClickFieldBuilder() {
        if (onClickBuilder_ == null) {
          onClickBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.chat.v1.WidgetMarkup.OnClick,
                  com.google.chat.v1.WidgetMarkup.OnClick.Builder,
                  com.google.chat.v1.WidgetMarkup.OnClickOrBuilder>(
                  getOnClick(), getParentForChildren(), isClean());
          onClick_ = null;
        }
        return onClickBuilder_;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * The name of this `image_button` that's used for accessibility.
       * Default value is provided if this name isn't specified.
       * </pre>
       *
       * <code>string name = 4;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of this `image_button` that's used for accessibility.
       * Default value is provided if this name isn't specified.
       * </pre>
       *
       * <code>string name = 4;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of this `image_button` that's used for accessibility.
       * Default value is provided if this name isn't specified.
       * </pre>
       *
       * <code>string name = 4;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of this `image_button` that's used for accessibility.
       * Default value is provided if this name isn't specified.
       * </pre>
       *
       * <code>string name = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of this `image_button` that's used for accessibility.
       * Default value is provided if this name isn't specified.
       * </pre>
       *
       * <code>string name = 4;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.chat.v1.WidgetMarkup.ImageButton)
    }

    // @@protoc_insertion_point(class_scope:google.chat.v1.WidgetMarkup.ImageButton)
    private static final com.google.chat.v1.WidgetMarkup.ImageButton DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.chat.v1.WidgetMarkup.ImageButton();
    }

    public static com.google.chat.v1.WidgetMarkup.ImageButton getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ImageButton> PARSER =
        new com.google.protobuf.AbstractParser<ImageButton>() {
          @java.lang.Override
          public ImageButton parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ImageButton> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ImageButton> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.ImageButton getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface OnClickOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.chat.v1.WidgetMarkup.OnClick)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A form action is triggered by this `onclick` action if specified.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.FormAction action = 1;</code>
     *
     * @return Whether the action field is set.
     */
    boolean hasAction();
    /**
     *
     *
     * <pre>
     * A form action is triggered by this `onclick` action if specified.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.FormAction action = 1;</code>
     *
     * @return The action.
     */
    com.google.chat.v1.WidgetMarkup.FormAction getAction();
    /**
     *
     *
     * <pre>
     * A form action is triggered by this `onclick` action if specified.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.FormAction action = 1;</code>
     */
    com.google.chat.v1.WidgetMarkup.FormActionOrBuilder getActionOrBuilder();

    /**
     *
     *
     * <pre>
     * This `onclick` action triggers an open link action if specified.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OpenLink open_link = 2;</code>
     *
     * @return Whether the openLink field is set.
     */
    boolean hasOpenLink();
    /**
     *
     *
     * <pre>
     * This `onclick` action triggers an open link action if specified.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OpenLink open_link = 2;</code>
     *
     * @return The openLink.
     */
    com.google.chat.v1.WidgetMarkup.OpenLink getOpenLink();
    /**
     *
     *
     * <pre>
     * This `onclick` action triggers an open link action if specified.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OpenLink open_link = 2;</code>
     */
    com.google.chat.v1.WidgetMarkup.OpenLinkOrBuilder getOpenLinkOrBuilder();

    com.google.chat.v1.WidgetMarkup.OnClick.DataCase getDataCase();
  }
  /**
   *
   *
   * <pre>
   * An `onclick` action (for example, open a link).
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.WidgetMarkup.OnClick}
   */
  public static final class OnClick extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.chat.v1.WidgetMarkup.OnClick)
      OnClickOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OnClick.newBuilder() to construct.
    private OnClick(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OnClick() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OnClick();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.WidgetsProto
          .internal_static_google_chat_v1_WidgetMarkup_OnClick_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.WidgetsProto
          .internal_static_google_chat_v1_WidgetMarkup_OnClick_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.WidgetMarkup.OnClick.class,
              com.google.chat.v1.WidgetMarkup.OnClick.Builder.class);
    }

    private int dataCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object data_;

    public enum DataCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      ACTION(1),
      OPEN_LINK(2),
      DATA_NOT_SET(0);
      private final int value;

      private DataCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DataCase valueOf(int value) {
        return forNumber(value);
      }

      public static DataCase forNumber(int value) {
        switch (value) {
          case 1:
            return ACTION;
          case 2:
            return OPEN_LINK;
          case 0:
            return DATA_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public DataCase getDataCase() {
      return DataCase.forNumber(dataCase_);
    }

    public static final int ACTION_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * A form action is triggered by this `onclick` action if specified.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.FormAction action = 1;</code>
     *
     * @return Whether the action field is set.
     */
    @java.lang.Override
    public boolean hasAction() {
      return dataCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * A form action is triggered by this `onclick` action if specified.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.FormAction action = 1;</code>
     *
     * @return The action.
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.FormAction getAction() {
      if (dataCase_ == 1) {
        return (com.google.chat.v1.WidgetMarkup.FormAction) data_;
      }
      return com.google.chat.v1.WidgetMarkup.FormAction.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A form action is triggered by this `onclick` action if specified.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.FormAction action = 1;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.FormActionOrBuilder getActionOrBuilder() {
      if (dataCase_ == 1) {
        return (com.google.chat.v1.WidgetMarkup.FormAction) data_;
      }
      return com.google.chat.v1.WidgetMarkup.FormAction.getDefaultInstance();
    }

    public static final int OPEN_LINK_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * This `onclick` action triggers an open link action if specified.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OpenLink open_link = 2;</code>
     *
     * @return Whether the openLink field is set.
     */
    @java.lang.Override
    public boolean hasOpenLink() {
      return dataCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * This `onclick` action triggers an open link action if specified.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OpenLink open_link = 2;</code>
     *
     * @return The openLink.
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.OpenLink getOpenLink() {
      if (dataCase_ == 2) {
        return (com.google.chat.v1.WidgetMarkup.OpenLink) data_;
      }
      return com.google.chat.v1.WidgetMarkup.OpenLink.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * This `onclick` action triggers an open link action if specified.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.OpenLink open_link = 2;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.OpenLinkOrBuilder getOpenLinkOrBuilder() {
      if (dataCase_ == 2) {
        return (com.google.chat.v1.WidgetMarkup.OpenLink) data_;
      }
      return com.google.chat.v1.WidgetMarkup.OpenLink.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (dataCase_ == 1) {
        output.writeMessage(1, (com.google.chat.v1.WidgetMarkup.FormAction) data_);
      }
      if (dataCase_ == 2) {
        output.writeMessage(2, (com.google.chat.v1.WidgetMarkup.OpenLink) data_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (dataCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.chat.v1.WidgetMarkup.FormAction) data_);
      }
      if (dataCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.chat.v1.WidgetMarkup.OpenLink) data_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.chat.v1.WidgetMarkup.OnClick)) {
        return super.equals(obj);
      }
      com.google.chat.v1.WidgetMarkup.OnClick other = (com.google.chat.v1.WidgetMarkup.OnClick) obj;

      if (!getDataCase().equals(other.getDataCase())) return false;
      switch (dataCase_) {
        case 1:
          if (!getAction().equals(other.getAction())) return false;
          break;
        case 2:
          if (!getOpenLink().equals(other.getOpenLink())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (dataCase_) {
        case 1:
          hash = (37 * hash) + ACTION_FIELD_NUMBER;
          hash = (53 * hash) + getAction().hashCode();
          break;
        case 2:
          hash = (37 * hash) + OPEN_LINK_FIELD_NUMBER;
          hash = (53 * hash) + getOpenLink().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.chat.v1.WidgetMarkup.OnClick parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.OnClick parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.OnClick parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.OnClick parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.OnClick parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.OnClick parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.OnClick parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.OnClick parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.OnClick parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.OnClick parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.OnClick parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.OnClick parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.chat.v1.WidgetMarkup.OnClick prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An `onclick` action (for example, open a link).
     * </pre>
     *
     * Protobuf type {@code google.chat.v1.WidgetMarkup.OnClick}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.chat.v1.WidgetMarkup.OnClick)
        com.google.chat.v1.WidgetMarkup.OnClickOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_OnClick_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_OnClick_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.chat.v1.WidgetMarkup.OnClick.class,
                com.google.chat.v1.WidgetMarkup.OnClick.Builder.class);
      }

      // Construct using com.google.chat.v1.WidgetMarkup.OnClick.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (actionBuilder_ != null) {
          actionBuilder_.clear();
        }
        if (openLinkBuilder_ != null) {
          openLinkBuilder_.clear();
        }
        dataCase_ = 0;
        data_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_OnClick_descriptor;
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.OnClick getDefaultInstanceForType() {
        return com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.OnClick build() {
        com.google.chat.v1.WidgetMarkup.OnClick result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.OnClick buildPartial() {
        com.google.chat.v1.WidgetMarkup.OnClick result =
            new com.google.chat.v1.WidgetMarkup.OnClick(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.chat.v1.WidgetMarkup.OnClick result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(com.google.chat.v1.WidgetMarkup.OnClick result) {
        result.dataCase_ = dataCase_;
        result.data_ = this.data_;
        if (dataCase_ == 1 && actionBuilder_ != null) {
          result.data_ = actionBuilder_.build();
        }
        if (dataCase_ == 2 && openLinkBuilder_ != null) {
          result.data_ = openLinkBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.chat.v1.WidgetMarkup.OnClick) {
          return mergeFrom((com.google.chat.v1.WidgetMarkup.OnClick) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.chat.v1.WidgetMarkup.OnClick other) {
        if (other == com.google.chat.v1.WidgetMarkup.OnClick.getDefaultInstance()) return this;
        switch (other.getDataCase()) {
          case ACTION:
            {
              mergeAction(other.getAction());
              break;
            }
          case OPEN_LINK:
            {
              mergeOpenLink(other.getOpenLink());
              break;
            }
          case DATA_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getActionFieldBuilder().getBuilder(), extensionRegistry);
                  dataCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getOpenLinkFieldBuilder().getBuilder(), extensionRegistry);
                  dataCase_ = 2;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int dataCase_ = 0;
      private java.lang.Object data_;

      public DataCase getDataCase() {
        return DataCase.forNumber(dataCase_);
      }

      public Builder clearData() {
        dataCase_ = 0;
        data_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.WidgetMarkup.FormAction,
              com.google.chat.v1.WidgetMarkup.FormAction.Builder,
              com.google.chat.v1.WidgetMarkup.FormActionOrBuilder>
          actionBuilder_;
      /**
       *
       *
       * <pre>
       * A form action is triggered by this `onclick` action if specified.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.FormAction action = 1;</code>
       *
       * @return Whether the action field is set.
       */
      @java.lang.Override
      public boolean hasAction() {
        return dataCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * A form action is triggered by this `onclick` action if specified.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.FormAction action = 1;</code>
       *
       * @return The action.
       */
      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.FormAction getAction() {
        if (actionBuilder_ == null) {
          if (dataCase_ == 1) {
            return (com.google.chat.v1.WidgetMarkup.FormAction) data_;
          }
          return com.google.chat.v1.WidgetMarkup.FormAction.getDefaultInstance();
        } else {
          if (dataCase_ == 1) {
            return actionBuilder_.getMessage();
          }
          return com.google.chat.v1.WidgetMarkup.FormAction.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A form action is triggered by this `onclick` action if specified.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.FormAction action = 1;</code>
       */
      public Builder setAction(com.google.chat.v1.WidgetMarkup.FormAction value) {
        if (actionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          data_ = value;
          onChanged();
        } else {
          actionBuilder_.setMessage(value);
        }
        dataCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A form action is triggered by this `onclick` action if specified.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.FormAction action = 1;</code>
       */
      public Builder setAction(com.google.chat.v1.WidgetMarkup.FormAction.Builder builderForValue) {
        if (actionBuilder_ == null) {
          data_ = builderForValue.build();
          onChanged();
        } else {
          actionBuilder_.setMessage(builderForValue.build());
        }
        dataCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A form action is triggered by this `onclick` action if specified.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.FormAction action = 1;</code>
       */
      public Builder mergeAction(com.google.chat.v1.WidgetMarkup.FormAction value) {
        if (actionBuilder_ == null) {
          if (dataCase_ == 1
              && data_ != com.google.chat.v1.WidgetMarkup.FormAction.getDefaultInstance()) {
            data_ =
                com.google.chat.v1.WidgetMarkup.FormAction.newBuilder(
                        (com.google.chat.v1.WidgetMarkup.FormAction) data_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            data_ = value;
          }
          onChanged();
        } else {
          if (dataCase_ == 1) {
            actionBuilder_.mergeFrom(value);
          } else {
            actionBuilder_.setMessage(value);
          }
        }
        dataCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A form action is triggered by this `onclick` action if specified.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.FormAction action = 1;</code>
       */
      public Builder clearAction() {
        if (actionBuilder_ == null) {
          if (dataCase_ == 1) {
            dataCase_ = 0;
            data_ = null;
            onChanged();
          }
        } else {
          if (dataCase_ == 1) {
            dataCase_ = 0;
            data_ = null;
          }
          actionBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A form action is triggered by this `onclick` action if specified.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.FormAction action = 1;</code>
       */
      public com.google.chat.v1.WidgetMarkup.FormAction.Builder getActionBuilder() {
        return getActionFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A form action is triggered by this `onclick` action if specified.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.FormAction action = 1;</code>
       */
      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.FormActionOrBuilder getActionOrBuilder() {
        if ((dataCase_ == 1) && (actionBuilder_ != null)) {
          return actionBuilder_.getMessageOrBuilder();
        } else {
          if (dataCase_ == 1) {
            return (com.google.chat.v1.WidgetMarkup.FormAction) data_;
          }
          return com.google.chat.v1.WidgetMarkup.FormAction.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A form action is triggered by this `onclick` action if specified.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.FormAction action = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.WidgetMarkup.FormAction,
              com.google.chat.v1.WidgetMarkup.FormAction.Builder,
              com.google.chat.v1.WidgetMarkup.FormActionOrBuilder>
          getActionFieldBuilder() {
        if (actionBuilder_ == null) {
          if (!(dataCase_ == 1)) {
            data_ = com.google.chat.v1.WidgetMarkup.FormAction.getDefaultInstance();
          }
          actionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.chat.v1.WidgetMarkup.FormAction,
                  com.google.chat.v1.WidgetMarkup.FormAction.Builder,
                  com.google.chat.v1.WidgetMarkup.FormActionOrBuilder>(
                  (com.google.chat.v1.WidgetMarkup.FormAction) data_,
                  getParentForChildren(),
                  isClean());
          data_ = null;
        }
        dataCase_ = 1;
        onChanged();
        return actionBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.WidgetMarkup.OpenLink,
              com.google.chat.v1.WidgetMarkup.OpenLink.Builder,
              com.google.chat.v1.WidgetMarkup.OpenLinkOrBuilder>
          openLinkBuilder_;
      /**
       *
       *
       * <pre>
       * This `onclick` action triggers an open link action if specified.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OpenLink open_link = 2;</code>
       *
       * @return Whether the openLink field is set.
       */
      @java.lang.Override
      public boolean hasOpenLink() {
        return dataCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * This `onclick` action triggers an open link action if specified.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OpenLink open_link = 2;</code>
       *
       * @return The openLink.
       */
      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.OpenLink getOpenLink() {
        if (openLinkBuilder_ == null) {
          if (dataCase_ == 2) {
            return (com.google.chat.v1.WidgetMarkup.OpenLink) data_;
          }
          return com.google.chat.v1.WidgetMarkup.OpenLink.getDefaultInstance();
        } else {
          if (dataCase_ == 2) {
            return openLinkBuilder_.getMessage();
          }
          return com.google.chat.v1.WidgetMarkup.OpenLink.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * This `onclick` action triggers an open link action if specified.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OpenLink open_link = 2;</code>
       */
      public Builder setOpenLink(com.google.chat.v1.WidgetMarkup.OpenLink value) {
        if (openLinkBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          data_ = value;
          onChanged();
        } else {
          openLinkBuilder_.setMessage(value);
        }
        dataCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * This `onclick` action triggers an open link action if specified.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OpenLink open_link = 2;</code>
       */
      public Builder setOpenLink(com.google.chat.v1.WidgetMarkup.OpenLink.Builder builderForValue) {
        if (openLinkBuilder_ == null) {
          data_ = builderForValue.build();
          onChanged();
        } else {
          openLinkBuilder_.setMessage(builderForValue.build());
        }
        dataCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * This `onclick` action triggers an open link action if specified.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OpenLink open_link = 2;</code>
       */
      public Builder mergeOpenLink(com.google.chat.v1.WidgetMarkup.OpenLink value) {
        if (openLinkBuilder_ == null) {
          if (dataCase_ == 2
              && data_ != com.google.chat.v1.WidgetMarkup.OpenLink.getDefaultInstance()) {
            data_ =
                com.google.chat.v1.WidgetMarkup.OpenLink.newBuilder(
                        (com.google.chat.v1.WidgetMarkup.OpenLink) data_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            data_ = value;
          }
          onChanged();
        } else {
          if (dataCase_ == 2) {
            openLinkBuilder_.mergeFrom(value);
          } else {
            openLinkBuilder_.setMessage(value);
          }
        }
        dataCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * This `onclick` action triggers an open link action if specified.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OpenLink open_link = 2;</code>
       */
      public Builder clearOpenLink() {
        if (openLinkBuilder_ == null) {
          if (dataCase_ == 2) {
            dataCase_ = 0;
            data_ = null;
            onChanged();
          }
        } else {
          if (dataCase_ == 2) {
            dataCase_ = 0;
            data_ = null;
          }
          openLinkBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This `onclick` action triggers an open link action if specified.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OpenLink open_link = 2;</code>
       */
      public com.google.chat.v1.WidgetMarkup.OpenLink.Builder getOpenLinkBuilder() {
        return getOpenLinkFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * This `onclick` action triggers an open link action if specified.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OpenLink open_link = 2;</code>
       */
      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.OpenLinkOrBuilder getOpenLinkOrBuilder() {
        if ((dataCase_ == 2) && (openLinkBuilder_ != null)) {
          return openLinkBuilder_.getMessageOrBuilder();
        } else {
          if (dataCase_ == 2) {
            return (com.google.chat.v1.WidgetMarkup.OpenLink) data_;
          }
          return com.google.chat.v1.WidgetMarkup.OpenLink.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * This `onclick` action triggers an open link action if specified.
       * </pre>
       *
       * <code>.google.chat.v1.WidgetMarkup.OpenLink open_link = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.WidgetMarkup.OpenLink,
              com.google.chat.v1.WidgetMarkup.OpenLink.Builder,
              com.google.chat.v1.WidgetMarkup.OpenLinkOrBuilder>
          getOpenLinkFieldBuilder() {
        if (openLinkBuilder_ == null) {
          if (!(dataCase_ == 2)) {
            data_ = com.google.chat.v1.WidgetMarkup.OpenLink.getDefaultInstance();
          }
          openLinkBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.chat.v1.WidgetMarkup.OpenLink,
                  com.google.chat.v1.WidgetMarkup.OpenLink.Builder,
                  com.google.chat.v1.WidgetMarkup.OpenLinkOrBuilder>(
                  (com.google.chat.v1.WidgetMarkup.OpenLink) data_,
                  getParentForChildren(),
                  isClean());
          data_ = null;
        }
        dataCase_ = 2;
        onChanged();
        return openLinkBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.chat.v1.WidgetMarkup.OnClick)
    }

    // @@protoc_insertion_point(class_scope:google.chat.v1.WidgetMarkup.OnClick)
    private static final com.google.chat.v1.WidgetMarkup.OnClick DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.chat.v1.WidgetMarkup.OnClick();
    }

    public static com.google.chat.v1.WidgetMarkup.OnClick getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OnClick> PARSER =
        new com.google.protobuf.AbstractParser<OnClick>() {
          @java.lang.Override
          public OnClick parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OnClick> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OnClick> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.OnClick getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface OpenLinkOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.chat.v1.WidgetMarkup.OpenLink)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The URL to open.
     * </pre>
     *
     * <code>string url = 1;</code>
     *
     * @return The url.
     */
    java.lang.String getUrl();
    /**
     *
     *
     * <pre>
     * The URL to open.
     * </pre>
     *
     * <code>string url = 1;</code>
     *
     * @return The bytes for url.
     */
    com.google.protobuf.ByteString getUrlBytes();
  }
  /**
   *
   *
   * <pre>
   * A link that opens a new window.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.WidgetMarkup.OpenLink}
   */
  public static final class OpenLink extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.chat.v1.WidgetMarkup.OpenLink)
      OpenLinkOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OpenLink.newBuilder() to construct.
    private OpenLink(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OpenLink() {
      url_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OpenLink();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.WidgetsProto
          .internal_static_google_chat_v1_WidgetMarkup_OpenLink_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.WidgetsProto
          .internal_static_google_chat_v1_WidgetMarkup_OpenLink_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.WidgetMarkup.OpenLink.class,
              com.google.chat.v1.WidgetMarkup.OpenLink.Builder.class);
    }

    public static final int URL_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object url_ = "";
    /**
     *
     *
     * <pre>
     * The URL to open.
     * </pre>
     *
     * <code>string url = 1;</code>
     *
     * @return The url.
     */
    @java.lang.Override
    public java.lang.String getUrl() {
      java.lang.Object ref = url_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        url_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL to open.
     * </pre>
     *
     * <code>string url = 1;</code>
     *
     * @return The bytes for url.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUrlBytes() {
      java.lang.Object ref = url_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        url_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, url_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, url_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.chat.v1.WidgetMarkup.OpenLink)) {
        return super.equals(obj);
      }
      com.google.chat.v1.WidgetMarkup.OpenLink other =
          (com.google.chat.v1.WidgetMarkup.OpenLink) obj;

      if (!getUrl().equals(other.getUrl())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + URL_FIELD_NUMBER;
      hash = (53 * hash) + getUrl().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.chat.v1.WidgetMarkup.OpenLink parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.OpenLink parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.OpenLink parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.OpenLink parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.OpenLink parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.OpenLink parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.OpenLink parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.OpenLink parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.OpenLink parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.OpenLink parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.OpenLink parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.OpenLink parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.chat.v1.WidgetMarkup.OpenLink prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A link that opens a new window.
     * </pre>
     *
     * Protobuf type {@code google.chat.v1.WidgetMarkup.OpenLink}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.chat.v1.WidgetMarkup.OpenLink)
        com.google.chat.v1.WidgetMarkup.OpenLinkOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_OpenLink_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_OpenLink_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.chat.v1.WidgetMarkup.OpenLink.class,
                com.google.chat.v1.WidgetMarkup.OpenLink.Builder.class);
      }

      // Construct using com.google.chat.v1.WidgetMarkup.OpenLink.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        url_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_OpenLink_descriptor;
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.OpenLink getDefaultInstanceForType() {
        return com.google.chat.v1.WidgetMarkup.OpenLink.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.OpenLink build() {
        com.google.chat.v1.WidgetMarkup.OpenLink result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.OpenLink buildPartial() {
        com.google.chat.v1.WidgetMarkup.OpenLink result =
            new com.google.chat.v1.WidgetMarkup.OpenLink(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.chat.v1.WidgetMarkup.OpenLink result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.url_ = url_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.chat.v1.WidgetMarkup.OpenLink) {
          return mergeFrom((com.google.chat.v1.WidgetMarkup.OpenLink) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.chat.v1.WidgetMarkup.OpenLink other) {
        if (other == com.google.chat.v1.WidgetMarkup.OpenLink.getDefaultInstance()) return this;
        if (!other.getUrl().isEmpty()) {
          url_ = other.url_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  url_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object url_ = "";
      /**
       *
       *
       * <pre>
       * The URL to open.
       * </pre>
       *
       * <code>string url = 1;</code>
       *
       * @return The url.
       */
      public java.lang.String getUrl() {
        java.lang.Object ref = url_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          url_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The URL to open.
       * </pre>
       *
       * <code>string url = 1;</code>
       *
       * @return The bytes for url.
       */
      public com.google.protobuf.ByteString getUrlBytes() {
        java.lang.Object ref = url_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          url_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The URL to open.
       * </pre>
       *
       * <code>string url = 1;</code>
       *
       * @param value The url to set.
       * @return This builder for chaining.
       */
      public Builder setUrl(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        url_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The URL to open.
       * </pre>
       *
       * <code>string url = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUrl() {
        url_ = getDefaultInstance().getUrl();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The URL to open.
       * </pre>
       *
       * <code>string url = 1;</code>
       *
       * @param value The bytes for url to set.
       * @return This builder for chaining.
       */
      public Builder setUrlBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        url_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.chat.v1.WidgetMarkup.OpenLink)
    }

    // @@protoc_insertion_point(class_scope:google.chat.v1.WidgetMarkup.OpenLink)
    private static final com.google.chat.v1.WidgetMarkup.OpenLink DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.chat.v1.WidgetMarkup.OpenLink();
    }

    public static com.google.chat.v1.WidgetMarkup.OpenLink getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OpenLink> PARSER =
        new com.google.protobuf.AbstractParser<OpenLink>() {
          @java.lang.Override
          public OpenLink parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OpenLink> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OpenLink> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.OpenLink getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FormActionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.chat.v1.WidgetMarkup.FormAction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The method name is used to identify which part of the form triggered the
     * form submission. This information is echoed back to the Chat app as part
     * of the card click event. You can use the same method name for several
     * elements that trigger a common behavior.
     * </pre>
     *
     * <code>string action_method_name = 1;</code>
     *
     * @return The actionMethodName.
     */
    java.lang.String getActionMethodName();
    /**
     *
     *
     * <pre>
     * The method name is used to identify which part of the form triggered the
     * form submission. This information is echoed back to the Chat app as part
     * of the card click event. You can use the same method name for several
     * elements that trigger a common behavior.
     * </pre>
     *
     * <code>string action_method_name = 1;</code>
     *
     * @return The bytes for actionMethodName.
     */
    com.google.protobuf.ByteString getActionMethodNameBytes();

    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;</code>
     */
    java.util.List<com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter> getParametersList();
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;</code>
     */
    com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter getParameters(int index);
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;</code>
     */
    int getParametersCount();
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;</code>
     */
    java.util.List<? extends com.google.chat.v1.WidgetMarkup.FormAction.ActionParameterOrBuilder>
        getParametersOrBuilderList();
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;</code>
     */
    com.google.chat.v1.WidgetMarkup.FormAction.ActionParameterOrBuilder getParametersOrBuilder(
        int index);
  }
  /**
   *
   *
   * <pre>
   * A form action describes the behavior when the form is submitted.
   * For example, you can invoke Apps Script to handle the form.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.WidgetMarkup.FormAction}
   */
  public static final class FormAction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.chat.v1.WidgetMarkup.FormAction)
      FormActionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FormAction.newBuilder() to construct.
    private FormAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FormAction() {
      actionMethodName_ = "";
      parameters_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FormAction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.WidgetsProto
          .internal_static_google_chat_v1_WidgetMarkup_FormAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.WidgetsProto
          .internal_static_google_chat_v1_WidgetMarkup_FormAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.WidgetMarkup.FormAction.class,
              com.google.chat.v1.WidgetMarkup.FormAction.Builder.class);
    }

    public interface ActionParameterOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.chat.v1.WidgetMarkup.FormAction.ActionParameter)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The name of the parameter for the action script.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The key.
       */
      java.lang.String getKey();
      /**
       *
       *
       * <pre>
       * The name of the parameter for the action script.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The bytes for key.
       */
      com.google.protobuf.ByteString getKeyBytes();

      /**
       *
       *
       * <pre>
       * The value of the parameter.
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @return The value.
       */
      java.lang.String getValue();
      /**
       *
       *
       * <pre>
       * The value of the parameter.
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @return The bytes for value.
       */
      com.google.protobuf.ByteString getValueBytes();
    }
    /**
     *
     *
     * <pre>
     * List of string parameters to supply when the action method is invoked.
     * For example, consider three snooze buttons: snooze now, snooze one day,
     * snooze next week. You might use `action method = snooze()`, passing the
     * snooze type and snooze time in the list of string parameters.
     * </pre>
     *
     * Protobuf type {@code google.chat.v1.WidgetMarkup.FormAction.ActionParameter}
     */
    public static final class ActionParameter extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.chat.v1.WidgetMarkup.FormAction.ActionParameter)
        ActionParameterOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ActionParameter.newBuilder() to construct.
      private ActionParameter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ActionParameter() {
        key_ = "";
        value_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ActionParameter();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_FormAction_ActionParameter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_FormAction_ActionParameter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter.class,
                com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter.Builder.class);
      }

      public static final int KEY_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object key_ = "";
      /**
       *
       *
       * <pre>
       * The name of the parameter for the action script.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The key.
       */
      @java.lang.Override
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          key_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the parameter for the action script.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The bytes for key.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int VALUE_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object value_ = "";
      /**
       *
       *
       * <pre>
       * The value of the parameter.
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @return The value.
       */
      @java.lang.Override
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          value_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The value of the parameter.
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @return The bytes for value.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, key_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, value_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, key_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, value_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter)) {
          return super.equals(obj);
        }
        com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter other =
            (com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter) obj;

        if (!getKey().equals(other.getKey())) return false;
        if (!getValue().equals(other.getValue())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + KEY_FIELD_NUMBER;
        hash = (53 * hash) + getKey().hashCode();
        hash = (37 * hash) + VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getValue().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * List of string parameters to supply when the action method is invoked.
       * For example, consider three snooze buttons: snooze now, snooze one day,
       * snooze next week. You might use `action method = snooze()`, passing the
       * snooze type and snooze time in the list of string parameters.
       * </pre>
       *
       * Protobuf type {@code google.chat.v1.WidgetMarkup.FormAction.ActionParameter}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.chat.v1.WidgetMarkup.FormAction.ActionParameter)
          com.google.chat.v1.WidgetMarkup.FormAction.ActionParameterOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.chat.v1.WidgetsProto
              .internal_static_google_chat_v1_WidgetMarkup_FormAction_ActionParameter_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.chat.v1.WidgetsProto
              .internal_static_google_chat_v1_WidgetMarkup_FormAction_ActionParameter_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter.class,
                  com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter.Builder.class);
        }

        // Construct using com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          key_ = "";
          value_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.chat.v1.WidgetsProto
              .internal_static_google_chat_v1_WidgetMarkup_FormAction_ActionParameter_descriptor;
        }

        @java.lang.Override
        public com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter
            getDefaultInstanceForType() {
          return com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter build() {
          com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter buildPartial() {
          com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter result =
              new com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.key_ = key_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.value_ = value_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter) {
            return mergeFrom((com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter other) {
          if (other
              == com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter.getDefaultInstance())
            return this;
          if (!other.getKey().isEmpty()) {
            key_ = other.key_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getValue().isEmpty()) {
            value_ = other.value_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    key_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    value_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object key_ = "";
        /**
         *
         *
         * <pre>
         * The name of the parameter for the action script.
         * </pre>
         *
         * <code>string key = 1;</code>
         *
         * @return The key.
         */
        public java.lang.String getKey() {
          java.lang.Object ref = key_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            key_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the parameter for the action script.
         * </pre>
         *
         * <code>string key = 1;</code>
         *
         * @return The bytes for key.
         */
        public com.google.protobuf.ByteString getKeyBytes() {
          java.lang.Object ref = key_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            key_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the parameter for the action script.
         * </pre>
         *
         * <code>string key = 1;</code>
         *
         * @param value The key to set.
         * @return This builder for chaining.
         */
        public Builder setKey(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          key_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the parameter for the action script.
         * </pre>
         *
         * <code>string key = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearKey() {
          key_ = getDefaultInstance().getKey();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the parameter for the action script.
         * </pre>
         *
         * <code>string key = 1;</code>
         *
         * @param value The bytes for key to set.
         * @return This builder for chaining.
         */
        public Builder setKeyBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          key_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object value_ = "";
        /**
         *
         *
         * <pre>
         * The value of the parameter.
         * </pre>
         *
         * <code>string value = 2;</code>
         *
         * @return The value.
         */
        public java.lang.String getValue() {
          java.lang.Object ref = value_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            value_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The value of the parameter.
         * </pre>
         *
         * <code>string value = 2;</code>
         *
         * @return The bytes for value.
         */
        public com.google.protobuf.ByteString getValueBytes() {
          java.lang.Object ref = value_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            value_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The value of the parameter.
         * </pre>
         *
         * <code>string value = 2;</code>
         *
         * @param value The value to set.
         * @return This builder for chaining.
         */
        public Builder setValue(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          value_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The value of the parameter.
         * </pre>
         *
         * <code>string value = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearValue() {
          value_ = getDefaultInstance().getValue();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The value of the parameter.
         * </pre>
         *
         * <code>string value = 2;</code>
         *
         * @param value The bytes for value to set.
         * @return This builder for chaining.
         */
        public Builder setValueBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          value_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.chat.v1.WidgetMarkup.FormAction.ActionParameter)
      }

      // @@protoc_insertion_point(class_scope:google.chat.v1.WidgetMarkup.FormAction.ActionParameter)
      private static final com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter();
      }

      public static com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ActionParameter> PARSER =
          new com.google.protobuf.AbstractParser<ActionParameter>() {
            @java.lang.Override
            public ActionParameter parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ActionParameter> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ActionParameter> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int ACTION_METHOD_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object actionMethodName_ = "";
    /**
     *
     *
     * <pre>
     * The method name is used to identify which part of the form triggered the
     * form submission. This information is echoed back to the Chat app as part
     * of the card click event. You can use the same method name for several
     * elements that trigger a common behavior.
     * </pre>
     *
     * <code>string action_method_name = 1;</code>
     *
     * @return The actionMethodName.
     */
    @java.lang.Override
    public java.lang.String getActionMethodName() {
      java.lang.Object ref = actionMethodName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        actionMethodName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The method name is used to identify which part of the form triggered the
     * form submission. This information is echoed back to the Chat app as part
     * of the card click event. You can use the same method name for several
     * elements that trigger a common behavior.
     * </pre>
     *
     * <code>string action_method_name = 1;</code>
     *
     * @return The bytes for actionMethodName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getActionMethodNameBytes() {
      java.lang.Object ref = actionMethodName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        actionMethodName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PARAMETERS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter> parameters_;
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter>
        getParametersList() {
      return parameters_;
    }
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;</code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.chat.v1.WidgetMarkup.FormAction.ActionParameterOrBuilder>
        getParametersOrBuilderList() {
      return parameters_;
    }
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;</code>
     */
    @java.lang.Override
    public int getParametersCount() {
      return parameters_.size();
    }
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter getParameters(int index) {
      return parameters_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.FormAction.ActionParameterOrBuilder
        getParametersOrBuilder(int index) {
      return parameters_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(actionMethodName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, actionMethodName_);
      }
      for (int i = 0; i < parameters_.size(); i++) {
        output.writeMessage(2, parameters_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(actionMethodName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, actionMethodName_);
      }
      for (int i = 0; i < parameters_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, parameters_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.chat.v1.WidgetMarkup.FormAction)) {
        return super.equals(obj);
      }
      com.google.chat.v1.WidgetMarkup.FormAction other =
          (com.google.chat.v1.WidgetMarkup.FormAction) obj;

      if (!getActionMethodName().equals(other.getActionMethodName())) return false;
      if (!getParametersList().equals(other.getParametersList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ACTION_METHOD_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getActionMethodName().hashCode();
      if (getParametersCount() > 0) {
        hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
        hash = (53 * hash) + getParametersList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.chat.v1.WidgetMarkup.FormAction parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.FormAction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.FormAction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.FormAction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.FormAction parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.WidgetMarkup.FormAction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.FormAction parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.FormAction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.FormAction parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.FormAction parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.WidgetMarkup.FormAction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.WidgetMarkup.FormAction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.chat.v1.WidgetMarkup.FormAction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A form action describes the behavior when the form is submitted.
     * For example, you can invoke Apps Script to handle the form.
     * </pre>
     *
     * Protobuf type {@code google.chat.v1.WidgetMarkup.FormAction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.chat.v1.WidgetMarkup.FormAction)
        com.google.chat.v1.WidgetMarkup.FormActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_FormAction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_FormAction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.chat.v1.WidgetMarkup.FormAction.class,
                com.google.chat.v1.WidgetMarkup.FormAction.Builder.class);
      }

      // Construct using com.google.chat.v1.WidgetMarkup.FormAction.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        actionMethodName_ = "";
        if (parametersBuilder_ == null) {
          parameters_ = java.util.Collections.emptyList();
        } else {
          parameters_ = null;
          parametersBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.chat.v1.WidgetsProto
            .internal_static_google_chat_v1_WidgetMarkup_FormAction_descriptor;
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.FormAction getDefaultInstanceForType() {
        return com.google.chat.v1.WidgetMarkup.FormAction.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.FormAction build() {
        com.google.chat.v1.WidgetMarkup.FormAction result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.chat.v1.WidgetMarkup.FormAction buildPartial() {
        com.google.chat.v1.WidgetMarkup.FormAction result =
            new com.google.chat.v1.WidgetMarkup.FormAction(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.google.chat.v1.WidgetMarkup.FormAction result) {
        if (parametersBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            parameters_ = java.util.Collections.unmodifiableList(parameters_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.parameters_ = parameters_;
        } else {
          result.parameters_ = parametersBuilder_.build();
        }
      }

      private void buildPartial0(com.google.chat.v1.WidgetMarkup.FormAction result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.actionMethodName_ = actionMethodName_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.chat.v1.WidgetMarkup.FormAction) {
          return mergeFrom((com.google.chat.v1.WidgetMarkup.FormAction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.chat.v1.WidgetMarkup.FormAction other) {
        if (other == com.google.chat.v1.WidgetMarkup.FormAction.getDefaultInstance()) return this;
        if (!other.getActionMethodName().isEmpty()) {
          actionMethodName_ = other.actionMethodName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (parametersBuilder_ == null) {
          if (!other.parameters_.isEmpty()) {
            if (parameters_.isEmpty()) {
              parameters_ = other.parameters_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureParametersIsMutable();
              parameters_.addAll(other.parameters_);
            }
            onChanged();
          }
        } else {
          if (!other.parameters_.isEmpty()) {
            if (parametersBuilder_.isEmpty()) {
              parametersBuilder_.dispose();
              parametersBuilder_ = null;
              parameters_ = other.parameters_;
              bitField0_ = (bitField0_ & ~0x00000002);
              parametersBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getParametersFieldBuilder()
                      : null;
            } else {
              parametersBuilder_.addAllMessages(other.parameters_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  actionMethodName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter m =
                      input.readMessage(
                          com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter.parser(),
                          extensionRegistry);
                  if (parametersBuilder_ == null) {
                    ensureParametersIsMutable();
                    parameters_.add(m);
                  } else {
                    parametersBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object actionMethodName_ = "";
      /**
       *
       *
       * <pre>
       * The method name is used to identify which part of the form triggered the
       * form submission. This information is echoed back to the Chat app as part
       * of the card click event. You can use the same method name for several
       * elements that trigger a common behavior.
       * </pre>
       *
       * <code>string action_method_name = 1;</code>
       *
       * @return The actionMethodName.
       */
      public java.lang.String getActionMethodName() {
        java.lang.Object ref = actionMethodName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          actionMethodName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The method name is used to identify which part of the form triggered the
       * form submission. This information is echoed back to the Chat app as part
       * of the card click event. You can use the same method name for several
       * elements that trigger a common behavior.
       * </pre>
       *
       * <code>string action_method_name = 1;</code>
       *
       * @return The bytes for actionMethodName.
       */
      public com.google.protobuf.ByteString getActionMethodNameBytes() {
        java.lang.Object ref = actionMethodName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          actionMethodName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The method name is used to identify which part of the form triggered the
       * form submission. This information is echoed back to the Chat app as part
       * of the card click event. You can use the same method name for several
       * elements that trigger a common behavior.
       * </pre>
       *
       * <code>string action_method_name = 1;</code>
       *
       * @param value The actionMethodName to set.
       * @return This builder for chaining.
       */
      public Builder setActionMethodName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        actionMethodName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The method name is used to identify which part of the form triggered the
       * form submission. This information is echoed back to the Chat app as part
       * of the card click event. You can use the same method name for several
       * elements that trigger a common behavior.
       * </pre>
       *
       * <code>string action_method_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearActionMethodName() {
        actionMethodName_ = getDefaultInstance().getActionMethodName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The method name is used to identify which part of the form triggered the
       * form submission. This information is echoed back to the Chat app as part
       * of the card click event. You can use the same method name for several
       * elements that trigger a common behavior.
       * </pre>
       *
       * <code>string action_method_name = 1;</code>
       *
       * @param value The bytes for actionMethodName to set.
       * @return This builder for chaining.
       */
      public Builder setActionMethodNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        actionMethodName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter>
          parameters_ = java.util.Collections.emptyList();

      private void ensureParametersIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          parameters_ =
              new java.util.ArrayList<com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter>(
                  parameters_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter,
              com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter.Builder,
              com.google.chat.v1.WidgetMarkup.FormAction.ActionParameterOrBuilder>
          parametersBuilder_;

      /**
       *
       *
       * <pre>
       * List of action parameters.
       * </pre>
       *
       * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;
       * </code>
       */
      public java.util.List<com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter>
          getParametersList() {
        if (parametersBuilder_ == null) {
          return java.util.Collections.unmodifiableList(parameters_);
        } else {
          return parametersBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * List of action parameters.
       * </pre>
       *
       * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;
       * </code>
       */
      public int getParametersCount() {
        if (parametersBuilder_ == null) {
          return parameters_.size();
        } else {
          return parametersBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * List of action parameters.
       * </pre>
       *
       * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;
       * </code>
       */
      public com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter getParameters(int index) {
        if (parametersBuilder_ == null) {
          return parameters_.get(index);
        } else {
          return parametersBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of action parameters.
       * </pre>
       *
       * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;
       * </code>
       */
      public Builder setParameters(
          int index, com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter value) {
        if (parametersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParametersIsMutable();
          parameters_.set(index, value);
          onChanged();
        } else {
          parametersBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of action parameters.
       * </pre>
       *
       * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;
       * </code>
       */
      public Builder setParameters(
          int index,
          com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter.Builder builderForValue) {
        if (parametersBuilder_ == null) {
          ensureParametersIsMutable();
          parameters_.set(index, builderForValue.build());
          onChanged();
        } else {
          parametersBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of action parameters.
       * </pre>
       *
       * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;
       * </code>
       */
      public Builder addParameters(
          com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter value) {
        if (parametersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParametersIsMutable();
          parameters_.add(value);
          onChanged();
        } else {
          parametersBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of action parameters.
       * </pre>
       *
       * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;
       * </code>
       */
      public Builder addParameters(
          int index, com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter value) {
        if (parametersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParametersIsMutable();
          parameters_.add(index, value);
          onChanged();
        } else {
          parametersBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of action parameters.
       * </pre>
       *
       * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;
       * </code>
       */
      public Builder addParameters(
          com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter.Builder builderForValue) {
        if (parametersBuilder_ == null) {
          ensureParametersIsMutable();
          parameters_.add(builderForValue.build());
          onChanged();
        } else {
          parametersBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of action parameters.
       * </pre>
       *
       * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;
       * </code>
       */
      public Builder addParameters(
          int index,
          com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter.Builder builderForValue) {
        if (parametersBuilder_ == null) {
          ensureParametersIsMutable();
          parameters_.add(index, builderForValue.build());
          onChanged();
        } else {
          parametersBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of action parameters.
       * </pre>
       *
       * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;
       * </code>
       */
      public Builder addAllParameters(
          java.lang.Iterable<? extends com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter>
              values) {
        if (parametersBuilder_ == null) {
          ensureParametersIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, parameters_);
          onChanged();
        } else {
          parametersBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of action parameters.
       * </pre>
       *
       * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;
       * </code>
       */
      public Builder clearParameters() {
        if (parametersBuilder_ == null) {
          parameters_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          parametersBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of action parameters.
       * </pre>
       *
       * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;
       * </code>
       */
      public Builder removeParameters(int index) {
        if (parametersBuilder_ == null) {
          ensureParametersIsMutable();
          parameters_.remove(index);
          onChanged();
        } else {
          parametersBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of action parameters.
       * </pre>
       *
       * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;
       * </code>
       */
      public com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter.Builder
          getParametersBuilder(int index) {
        return getParametersFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * List of action parameters.
       * </pre>
       *
       * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;
       * </code>
       */
      public com.google.chat.v1.WidgetMarkup.FormAction.ActionParameterOrBuilder
          getParametersOrBuilder(int index) {
        if (parametersBuilder_ == null) {
          return parameters_.get(index);
        } else {
          return parametersBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of action parameters.
       * </pre>
       *
       * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;
       * </code>
       */
      public java.util.List<
              ? extends com.google.chat.v1.WidgetMarkup.FormAction.ActionParameterOrBuilder>
          getParametersOrBuilderList() {
        if (parametersBuilder_ != null) {
          return parametersBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(parameters_);
        }
      }
      /**
       *
       *
       * <pre>
       * List of action parameters.
       * </pre>
       *
       * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;
       * </code>
       */
      public com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter.Builder
          addParametersBuilder() {
        return getParametersFieldBuilder()
            .addBuilder(
                com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of action parameters.
       * </pre>
       *
       * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;
       * </code>
       */
      public com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter.Builder
          addParametersBuilder(int index) {
        return getParametersFieldBuilder()
            .addBuilder(
                index,
                com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of action parameters.
       * </pre>
       *
       * <code>repeated .google.chat.v1.WidgetMarkup.FormAction.ActionParameter parameters = 2;
       * </code>
       */
      public java.util.List<com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter.Builder>
          getParametersBuilderList() {
        return getParametersFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter,
              com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter.Builder,
              com.google.chat.v1.WidgetMarkup.FormAction.ActionParameterOrBuilder>
          getParametersFieldBuilder() {
        if (parametersBuilder_ == null) {
          parametersBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter,
                  com.google.chat.v1.WidgetMarkup.FormAction.ActionParameter.Builder,
                  com.google.chat.v1.WidgetMarkup.FormAction.ActionParameterOrBuilder>(
                  parameters_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          parameters_ = null;
        }
        return parametersBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.chat.v1.WidgetMarkup.FormAction)
    }

    // @@protoc_insertion_point(class_scope:google.chat.v1.WidgetMarkup.FormAction)
    private static final com.google.chat.v1.WidgetMarkup.FormAction DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.chat.v1.WidgetMarkup.FormAction();
    }

    public static com.google.chat.v1.WidgetMarkup.FormAction getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FormAction> PARSER =
        new com.google.protobuf.AbstractParser<FormAction>() {
          @java.lang.Override
          public FormAction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FormAction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FormAction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.FormAction getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int dataCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object data_;

  public enum DataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TEXT_PARAGRAPH(1),
    IMAGE(2),
    KEY_VALUE(3),
    DATA_NOT_SET(0);
    private final int value;

    private DataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataCase valueOf(int value) {
      return forNumber(value);
    }

    public static DataCase forNumber(int value) {
      switch (value) {
        case 1:
          return TEXT_PARAGRAPH;
        case 2:
          return IMAGE;
        case 3:
          return KEY_VALUE;
        case 0:
          return DATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DataCase getDataCase() {
    return DataCase.forNumber(dataCase_);
  }

  public static final int TEXT_PARAGRAPH_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Display a text paragraph in this widget.
   * </pre>
   *
   * <code>.google.chat.v1.WidgetMarkup.TextParagraph text_paragraph = 1;</code>
   *
   * @return Whether the textParagraph field is set.
   */
  @java.lang.Override
  public boolean hasTextParagraph() {
    return dataCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Display a text paragraph in this widget.
   * </pre>
   *
   * <code>.google.chat.v1.WidgetMarkup.TextParagraph text_paragraph = 1;</code>
   *
   * @return The textParagraph.
   */
  @java.lang.Override
  public com.google.chat.v1.WidgetMarkup.TextParagraph getTextParagraph() {
    if (dataCase_ == 1) {
      return (com.google.chat.v1.WidgetMarkup.TextParagraph) data_;
    }
    return com.google.chat.v1.WidgetMarkup.TextParagraph.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display a text paragraph in this widget.
   * </pre>
   *
   * <code>.google.chat.v1.WidgetMarkup.TextParagraph text_paragraph = 1;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.WidgetMarkup.TextParagraphOrBuilder getTextParagraphOrBuilder() {
    if (dataCase_ == 1) {
      return (com.google.chat.v1.WidgetMarkup.TextParagraph) data_;
    }
    return com.google.chat.v1.WidgetMarkup.TextParagraph.getDefaultInstance();
  }

  public static final int IMAGE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Display an image in this widget.
   * </pre>
   *
   * <code>.google.chat.v1.WidgetMarkup.Image image = 2;</code>
   *
   * @return Whether the image field is set.
   */
  @java.lang.Override
  public boolean hasImage() {
    return dataCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Display an image in this widget.
   * </pre>
   *
   * <code>.google.chat.v1.WidgetMarkup.Image image = 2;</code>
   *
   * @return The image.
   */
  @java.lang.Override
  public com.google.chat.v1.WidgetMarkup.Image getImage() {
    if (dataCase_ == 2) {
      return (com.google.chat.v1.WidgetMarkup.Image) data_;
    }
    return com.google.chat.v1.WidgetMarkup.Image.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display an image in this widget.
   * </pre>
   *
   * <code>.google.chat.v1.WidgetMarkup.Image image = 2;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.WidgetMarkup.ImageOrBuilder getImageOrBuilder() {
    if (dataCase_ == 2) {
      return (com.google.chat.v1.WidgetMarkup.Image) data_;
    }
    return com.google.chat.v1.WidgetMarkup.Image.getDefaultInstance();
  }

  public static final int KEY_VALUE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Display a key value item in this widget.
   * </pre>
   *
   * <code>.google.chat.v1.WidgetMarkup.KeyValue key_value = 3;</code>
   *
   * @return Whether the keyValue field is set.
   */
  @java.lang.Override
  public boolean hasKeyValue() {
    return dataCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Display a key value item in this widget.
   * </pre>
   *
   * <code>.google.chat.v1.WidgetMarkup.KeyValue key_value = 3;</code>
   *
   * @return The keyValue.
   */
  @java.lang.Override
  public com.google.chat.v1.WidgetMarkup.KeyValue getKeyValue() {
    if (dataCase_ == 3) {
      return (com.google.chat.v1.WidgetMarkup.KeyValue) data_;
    }
    return com.google.chat.v1.WidgetMarkup.KeyValue.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display a key value item in this widget.
   * </pre>
   *
   * <code>.google.chat.v1.WidgetMarkup.KeyValue key_value = 3;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.WidgetMarkup.KeyValueOrBuilder getKeyValueOrBuilder() {
    if (dataCase_ == 3) {
      return (com.google.chat.v1.WidgetMarkup.KeyValue) data_;
    }
    return com.google.chat.v1.WidgetMarkup.KeyValue.getDefaultInstance();
  }

  public static final int BUTTONS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.chat.v1.WidgetMarkup.Button> buttons_;
  /**
   *
   *
   * <pre>
   * A list of buttons. Buttons is also `oneof data` and only one of these
   * fields should be set.
   * </pre>
   *
   * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.chat.v1.WidgetMarkup.Button> getButtonsList() {
    return buttons_;
  }
  /**
   *
   *
   * <pre>
   * A list of buttons. Buttons is also `oneof data` and only one of these
   * fields should be set.
   * </pre>
   *
   * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.chat.v1.WidgetMarkup.ButtonOrBuilder>
      getButtonsOrBuilderList() {
    return buttons_;
  }
  /**
   *
   *
   * <pre>
   * A list of buttons. Buttons is also `oneof data` and only one of these
   * fields should be set.
   * </pre>
   *
   * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
   */
  @java.lang.Override
  public int getButtonsCount() {
    return buttons_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of buttons. Buttons is also `oneof data` and only one of these
   * fields should be set.
   * </pre>
   *
   * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.WidgetMarkup.Button getButtons(int index) {
    return buttons_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of buttons. Buttons is also `oneof data` and only one of these
   * fields should be set.
   * </pre>
   *
   * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.WidgetMarkup.ButtonOrBuilder getButtonsOrBuilder(int index) {
    return buttons_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (dataCase_ == 1) {
      output.writeMessage(1, (com.google.chat.v1.WidgetMarkup.TextParagraph) data_);
    }
    if (dataCase_ == 2) {
      output.writeMessage(2, (com.google.chat.v1.WidgetMarkup.Image) data_);
    }
    if (dataCase_ == 3) {
      output.writeMessage(3, (com.google.chat.v1.WidgetMarkup.KeyValue) data_);
    }
    for (int i = 0; i < buttons_.size(); i++) {
      output.writeMessage(6, buttons_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (dataCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.chat.v1.WidgetMarkup.TextParagraph) data_);
    }
    if (dataCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.chat.v1.WidgetMarkup.Image) data_);
    }
    if (dataCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.chat.v1.WidgetMarkup.KeyValue) data_);
    }
    for (int i = 0; i < buttons_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, buttons_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.WidgetMarkup)) {
      return super.equals(obj);
    }
    com.google.chat.v1.WidgetMarkup other = (com.google.chat.v1.WidgetMarkup) obj;

    if (!getButtonsList().equals(other.getButtonsList())) return false;
    if (!getDataCase().equals(other.getDataCase())) return false;
    switch (dataCase_) {
      case 1:
        if (!getTextParagraph().equals(other.getTextParagraph())) return false;
        break;
      case 2:
        if (!getImage().equals(other.getImage())) return false;
        break;
      case 3:
        if (!getKeyValue().equals(other.getKeyValue())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getButtonsCount() > 0) {
      hash = (37 * hash) + BUTTONS_FIELD_NUMBER;
      hash = (53 * hash) + getButtonsList().hashCode();
    }
    switch (dataCase_) {
      case 1:
        hash = (37 * hash) + TEXT_PARAGRAPH_FIELD_NUMBER;
        hash = (53 * hash) + getTextParagraph().hashCode();
        break;
      case 2:
        hash = (37 * hash) + IMAGE_FIELD_NUMBER;
        hash = (53 * hash) + getImage().hashCode();
        break;
      case 3:
        hash = (37 * hash) + KEY_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getKeyValue().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.WidgetMarkup parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.WidgetMarkup parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.WidgetMarkup parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.WidgetMarkup parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.WidgetMarkup parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.WidgetMarkup parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.WidgetMarkup parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.WidgetMarkup parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.WidgetMarkup parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.WidgetMarkup parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.WidgetMarkup parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.WidgetMarkup parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.WidgetMarkup prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A widget is a UI element that presents text and images.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.WidgetMarkup}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.WidgetMarkup)
      com.google.chat.v1.WidgetMarkupOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.WidgetsProto.internal_static_google_chat_v1_WidgetMarkup_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.WidgetsProto
          .internal_static_google_chat_v1_WidgetMarkup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.WidgetMarkup.class, com.google.chat.v1.WidgetMarkup.Builder.class);
    }

    // Construct using com.google.chat.v1.WidgetMarkup.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (textParagraphBuilder_ != null) {
        textParagraphBuilder_.clear();
      }
      if (imageBuilder_ != null) {
        imageBuilder_.clear();
      }
      if (keyValueBuilder_ != null) {
        keyValueBuilder_.clear();
      }
      if (buttonsBuilder_ == null) {
        buttons_ = java.util.Collections.emptyList();
      } else {
        buttons_ = null;
        buttonsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      dataCase_ = 0;
      data_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.WidgetsProto.internal_static_google_chat_v1_WidgetMarkup_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup getDefaultInstanceForType() {
      return com.google.chat.v1.WidgetMarkup.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup build() {
      com.google.chat.v1.WidgetMarkup result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup buildPartial() {
      com.google.chat.v1.WidgetMarkup result = new com.google.chat.v1.WidgetMarkup(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.chat.v1.WidgetMarkup result) {
      if (buttonsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          buttons_ = java.util.Collections.unmodifiableList(buttons_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.buttons_ = buttons_;
      } else {
        result.buttons_ = buttonsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.chat.v1.WidgetMarkup result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.chat.v1.WidgetMarkup result) {
      result.dataCase_ = dataCase_;
      result.data_ = this.data_;
      if (dataCase_ == 1 && textParagraphBuilder_ != null) {
        result.data_ = textParagraphBuilder_.build();
      }
      if (dataCase_ == 2 && imageBuilder_ != null) {
        result.data_ = imageBuilder_.build();
      }
      if (dataCase_ == 3 && keyValueBuilder_ != null) {
        result.data_ = keyValueBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.WidgetMarkup) {
        return mergeFrom((com.google.chat.v1.WidgetMarkup) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.WidgetMarkup other) {
      if (other == com.google.chat.v1.WidgetMarkup.getDefaultInstance()) return this;
      if (buttonsBuilder_ == null) {
        if (!other.buttons_.isEmpty()) {
          if (buttons_.isEmpty()) {
            buttons_ = other.buttons_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureButtonsIsMutable();
            buttons_.addAll(other.buttons_);
          }
          onChanged();
        }
      } else {
        if (!other.buttons_.isEmpty()) {
          if (buttonsBuilder_.isEmpty()) {
            buttonsBuilder_.dispose();
            buttonsBuilder_ = null;
            buttons_ = other.buttons_;
            bitField0_ = (bitField0_ & ~0x00000008);
            buttonsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getButtonsFieldBuilder()
                    : null;
          } else {
            buttonsBuilder_.addAllMessages(other.buttons_);
          }
        }
      }
      switch (other.getDataCase()) {
        case TEXT_PARAGRAPH:
          {
            mergeTextParagraph(other.getTextParagraph());
            break;
          }
        case IMAGE:
          {
            mergeImage(other.getImage());
            break;
          }
        case KEY_VALUE:
          {
            mergeKeyValue(other.getKeyValue());
            break;
          }
        case DATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getTextParagraphFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getImageFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getKeyValueFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 3;
                break;
              } // case 26
            case 50:
              {
                com.google.chat.v1.WidgetMarkup.Button m =
                    input.readMessage(
                        com.google.chat.v1.WidgetMarkup.Button.parser(), extensionRegistry);
                if (buttonsBuilder_ == null) {
                  ensureButtonsIsMutable();
                  buttons_.add(m);
                } else {
                  buttonsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int dataCase_ = 0;
    private java.lang.Object data_;

    public DataCase getDataCase() {
      return DataCase.forNumber(dataCase_);
    }

    public Builder clearData() {
      dataCase_ = 0;
      data_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.WidgetMarkup.TextParagraph,
            com.google.chat.v1.WidgetMarkup.TextParagraph.Builder,
            com.google.chat.v1.WidgetMarkup.TextParagraphOrBuilder>
        textParagraphBuilder_;
    /**
     *
     *
     * <pre>
     * Display a text paragraph in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.TextParagraph text_paragraph = 1;</code>
     *
     * @return Whether the textParagraph field is set.
     */
    @java.lang.Override
    public boolean hasTextParagraph() {
      return dataCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Display a text paragraph in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.TextParagraph text_paragraph = 1;</code>
     *
     * @return The textParagraph.
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.TextParagraph getTextParagraph() {
      if (textParagraphBuilder_ == null) {
        if (dataCase_ == 1) {
          return (com.google.chat.v1.WidgetMarkup.TextParagraph) data_;
        }
        return com.google.chat.v1.WidgetMarkup.TextParagraph.getDefaultInstance();
      } else {
        if (dataCase_ == 1) {
          return textParagraphBuilder_.getMessage();
        }
        return com.google.chat.v1.WidgetMarkup.TextParagraph.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display a text paragraph in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.TextParagraph text_paragraph = 1;</code>
     */
    public Builder setTextParagraph(com.google.chat.v1.WidgetMarkup.TextParagraph value) {
      if (textParagraphBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        textParagraphBuilder_.setMessage(value);
      }
      dataCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display a text paragraph in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.TextParagraph text_paragraph = 1;</code>
     */
    public Builder setTextParagraph(
        com.google.chat.v1.WidgetMarkup.TextParagraph.Builder builderForValue) {
      if (textParagraphBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        textParagraphBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display a text paragraph in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.TextParagraph text_paragraph = 1;</code>
     */
    public Builder mergeTextParagraph(com.google.chat.v1.WidgetMarkup.TextParagraph value) {
      if (textParagraphBuilder_ == null) {
        if (dataCase_ == 1
            && data_ != com.google.chat.v1.WidgetMarkup.TextParagraph.getDefaultInstance()) {
          data_ =
              com.google.chat.v1.WidgetMarkup.TextParagraph.newBuilder(
                      (com.google.chat.v1.WidgetMarkup.TextParagraph) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 1) {
          textParagraphBuilder_.mergeFrom(value);
        } else {
          textParagraphBuilder_.setMessage(value);
        }
      }
      dataCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display a text paragraph in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.TextParagraph text_paragraph = 1;</code>
     */
    public Builder clearTextParagraph() {
      if (textParagraphBuilder_ == null) {
        if (dataCase_ == 1) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 1) {
          dataCase_ = 0;
          data_ = null;
        }
        textParagraphBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display a text paragraph in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.TextParagraph text_paragraph = 1;</code>
     */
    public com.google.chat.v1.WidgetMarkup.TextParagraph.Builder getTextParagraphBuilder() {
      return getTextParagraphFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display a text paragraph in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.TextParagraph text_paragraph = 1;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.TextParagraphOrBuilder getTextParagraphOrBuilder() {
      if ((dataCase_ == 1) && (textParagraphBuilder_ != null)) {
        return textParagraphBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 1) {
          return (com.google.chat.v1.WidgetMarkup.TextParagraph) data_;
        }
        return com.google.chat.v1.WidgetMarkup.TextParagraph.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display a text paragraph in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.TextParagraph text_paragraph = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.WidgetMarkup.TextParagraph,
            com.google.chat.v1.WidgetMarkup.TextParagraph.Builder,
            com.google.chat.v1.WidgetMarkup.TextParagraphOrBuilder>
        getTextParagraphFieldBuilder() {
      if (textParagraphBuilder_ == null) {
        if (!(dataCase_ == 1)) {
          data_ = com.google.chat.v1.WidgetMarkup.TextParagraph.getDefaultInstance();
        }
        textParagraphBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.WidgetMarkup.TextParagraph,
                com.google.chat.v1.WidgetMarkup.TextParagraph.Builder,
                com.google.chat.v1.WidgetMarkup.TextParagraphOrBuilder>(
                (com.google.chat.v1.WidgetMarkup.TextParagraph) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 1;
      onChanged();
      return textParagraphBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.WidgetMarkup.Image,
            com.google.chat.v1.WidgetMarkup.Image.Builder,
            com.google.chat.v1.WidgetMarkup.ImageOrBuilder>
        imageBuilder_;
    /**
     *
     *
     * <pre>
     * Display an image in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Image image = 2;</code>
     *
     * @return Whether the image field is set.
     */
    @java.lang.Override
    public boolean hasImage() {
      return dataCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Display an image in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Image image = 2;</code>
     *
     * @return The image.
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.Image getImage() {
      if (imageBuilder_ == null) {
        if (dataCase_ == 2) {
          return (com.google.chat.v1.WidgetMarkup.Image) data_;
        }
        return com.google.chat.v1.WidgetMarkup.Image.getDefaultInstance();
      } else {
        if (dataCase_ == 2) {
          return imageBuilder_.getMessage();
        }
        return com.google.chat.v1.WidgetMarkup.Image.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display an image in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Image image = 2;</code>
     */
    public Builder setImage(com.google.chat.v1.WidgetMarkup.Image value) {
      if (imageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        imageBuilder_.setMessage(value);
      }
      dataCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display an image in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Image image = 2;</code>
     */
    public Builder setImage(com.google.chat.v1.WidgetMarkup.Image.Builder builderForValue) {
      if (imageBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        imageBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display an image in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Image image = 2;</code>
     */
    public Builder mergeImage(com.google.chat.v1.WidgetMarkup.Image value) {
      if (imageBuilder_ == null) {
        if (dataCase_ == 2 && data_ != com.google.chat.v1.WidgetMarkup.Image.getDefaultInstance()) {
          data_ =
              com.google.chat.v1.WidgetMarkup.Image.newBuilder(
                      (com.google.chat.v1.WidgetMarkup.Image) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 2) {
          imageBuilder_.mergeFrom(value);
        } else {
          imageBuilder_.setMessage(value);
        }
      }
      dataCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display an image in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Image image = 2;</code>
     */
    public Builder clearImage() {
      if (imageBuilder_ == null) {
        if (dataCase_ == 2) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 2) {
          dataCase_ = 0;
          data_ = null;
        }
        imageBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display an image in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Image image = 2;</code>
     */
    public com.google.chat.v1.WidgetMarkup.Image.Builder getImageBuilder() {
      return getImageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display an image in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Image image = 2;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.ImageOrBuilder getImageOrBuilder() {
      if ((dataCase_ == 2) && (imageBuilder_ != null)) {
        return imageBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 2) {
          return (com.google.chat.v1.WidgetMarkup.Image) data_;
        }
        return com.google.chat.v1.WidgetMarkup.Image.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display an image in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.Image image = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.WidgetMarkup.Image,
            com.google.chat.v1.WidgetMarkup.Image.Builder,
            com.google.chat.v1.WidgetMarkup.ImageOrBuilder>
        getImageFieldBuilder() {
      if (imageBuilder_ == null) {
        if (!(dataCase_ == 2)) {
          data_ = com.google.chat.v1.WidgetMarkup.Image.getDefaultInstance();
        }
        imageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.WidgetMarkup.Image,
                com.google.chat.v1.WidgetMarkup.Image.Builder,
                com.google.chat.v1.WidgetMarkup.ImageOrBuilder>(
                (com.google.chat.v1.WidgetMarkup.Image) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 2;
      onChanged();
      return imageBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.WidgetMarkup.KeyValue,
            com.google.chat.v1.WidgetMarkup.KeyValue.Builder,
            com.google.chat.v1.WidgetMarkup.KeyValueOrBuilder>
        keyValueBuilder_;
    /**
     *
     *
     * <pre>
     * Display a key value item in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.KeyValue key_value = 3;</code>
     *
     * @return Whether the keyValue field is set.
     */
    @java.lang.Override
    public boolean hasKeyValue() {
      return dataCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Display a key value item in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.KeyValue key_value = 3;</code>
     *
     * @return The keyValue.
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.KeyValue getKeyValue() {
      if (keyValueBuilder_ == null) {
        if (dataCase_ == 3) {
          return (com.google.chat.v1.WidgetMarkup.KeyValue) data_;
        }
        return com.google.chat.v1.WidgetMarkup.KeyValue.getDefaultInstance();
      } else {
        if (dataCase_ == 3) {
          return keyValueBuilder_.getMessage();
        }
        return com.google.chat.v1.WidgetMarkup.KeyValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display a key value item in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.KeyValue key_value = 3;</code>
     */
    public Builder setKeyValue(com.google.chat.v1.WidgetMarkup.KeyValue value) {
      if (keyValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        keyValueBuilder_.setMessage(value);
      }
      dataCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display a key value item in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.KeyValue key_value = 3;</code>
     */
    public Builder setKeyValue(com.google.chat.v1.WidgetMarkup.KeyValue.Builder builderForValue) {
      if (keyValueBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        keyValueBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display a key value item in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.KeyValue key_value = 3;</code>
     */
    public Builder mergeKeyValue(com.google.chat.v1.WidgetMarkup.KeyValue value) {
      if (keyValueBuilder_ == null) {
        if (dataCase_ == 3
            && data_ != com.google.chat.v1.WidgetMarkup.KeyValue.getDefaultInstance()) {
          data_ =
              com.google.chat.v1.WidgetMarkup.KeyValue.newBuilder(
                      (com.google.chat.v1.WidgetMarkup.KeyValue) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 3) {
          keyValueBuilder_.mergeFrom(value);
        } else {
          keyValueBuilder_.setMessage(value);
        }
      }
      dataCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display a key value item in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.KeyValue key_value = 3;</code>
     */
    public Builder clearKeyValue() {
      if (keyValueBuilder_ == null) {
        if (dataCase_ == 3) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 3) {
          dataCase_ = 0;
          data_ = null;
        }
        keyValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display a key value item in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.KeyValue key_value = 3;</code>
     */
    public com.google.chat.v1.WidgetMarkup.KeyValue.Builder getKeyValueBuilder() {
      return getKeyValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display a key value item in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.KeyValue key_value = 3;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.WidgetMarkup.KeyValueOrBuilder getKeyValueOrBuilder() {
      if ((dataCase_ == 3) && (keyValueBuilder_ != null)) {
        return keyValueBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 3) {
          return (com.google.chat.v1.WidgetMarkup.KeyValue) data_;
        }
        return com.google.chat.v1.WidgetMarkup.KeyValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display a key value item in this widget.
     * </pre>
     *
     * <code>.google.chat.v1.WidgetMarkup.KeyValue key_value = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.WidgetMarkup.KeyValue,
            com.google.chat.v1.WidgetMarkup.KeyValue.Builder,
            com.google.chat.v1.WidgetMarkup.KeyValueOrBuilder>
        getKeyValueFieldBuilder() {
      if (keyValueBuilder_ == null) {
        if (!(dataCase_ == 3)) {
          data_ = com.google.chat.v1.WidgetMarkup.KeyValue.getDefaultInstance();
        }
        keyValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.WidgetMarkup.KeyValue,
                com.google.chat.v1.WidgetMarkup.KeyValue.Builder,
                com.google.chat.v1.WidgetMarkup.KeyValueOrBuilder>(
                (com.google.chat.v1.WidgetMarkup.KeyValue) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 3;
      onChanged();
      return keyValueBuilder_;
    }

    private java.util.List<com.google.chat.v1.WidgetMarkup.Button> buttons_ =
        java.util.Collections.emptyList();

    private void ensureButtonsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        buttons_ = new java.util.ArrayList<com.google.chat.v1.WidgetMarkup.Button>(buttons_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.chat.v1.WidgetMarkup.Button,
            com.google.chat.v1.WidgetMarkup.Button.Builder,
            com.google.chat.v1.WidgetMarkup.ButtonOrBuilder>
        buttonsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of buttons. Buttons is also `oneof data` and only one of these
     * fields should be set.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
     */
    public java.util.List<com.google.chat.v1.WidgetMarkup.Button> getButtonsList() {
      if (buttonsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(buttons_);
      } else {
        return buttonsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of buttons. Buttons is also `oneof data` and only one of these
     * fields should be set.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
     */
    public int getButtonsCount() {
      if (buttonsBuilder_ == null) {
        return buttons_.size();
      } else {
        return buttonsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of buttons. Buttons is also `oneof data` and only one of these
     * fields should be set.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
     */
    public com.google.chat.v1.WidgetMarkup.Button getButtons(int index) {
      if (buttonsBuilder_ == null) {
        return buttons_.get(index);
      } else {
        return buttonsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of buttons. Buttons is also `oneof data` and only one of these
     * fields should be set.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
     */
    public Builder setButtons(int index, com.google.chat.v1.WidgetMarkup.Button value) {
      if (buttonsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureButtonsIsMutable();
        buttons_.set(index, value);
        onChanged();
      } else {
        buttonsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of buttons. Buttons is also `oneof data` and only one of these
     * fields should be set.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
     */
    public Builder setButtons(
        int index, com.google.chat.v1.WidgetMarkup.Button.Builder builderForValue) {
      if (buttonsBuilder_ == null) {
        ensureButtonsIsMutable();
        buttons_.set(index, builderForValue.build());
        onChanged();
      } else {
        buttonsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of buttons. Buttons is also `oneof data` and only one of these
     * fields should be set.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
     */
    public Builder addButtons(com.google.chat.v1.WidgetMarkup.Button value) {
      if (buttonsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureButtonsIsMutable();
        buttons_.add(value);
        onChanged();
      } else {
        buttonsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of buttons. Buttons is also `oneof data` and only one of these
     * fields should be set.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
     */
    public Builder addButtons(int index, com.google.chat.v1.WidgetMarkup.Button value) {
      if (buttonsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureButtonsIsMutable();
        buttons_.add(index, value);
        onChanged();
      } else {
        buttonsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of buttons. Buttons is also `oneof data` and only one of these
     * fields should be set.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
     */
    public Builder addButtons(com.google.chat.v1.WidgetMarkup.Button.Builder builderForValue) {
      if (buttonsBuilder_ == null) {
        ensureButtonsIsMutable();
        buttons_.add(builderForValue.build());
        onChanged();
      } else {
        buttonsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of buttons. Buttons is also `oneof data` and only one of these
     * fields should be set.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
     */
    public Builder addButtons(
        int index, com.google.chat.v1.WidgetMarkup.Button.Builder builderForValue) {
      if (buttonsBuilder_ == null) {
        ensureButtonsIsMutable();
        buttons_.add(index, builderForValue.build());
        onChanged();
      } else {
        buttonsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of buttons. Buttons is also `oneof data` and only one of these
     * fields should be set.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
     */
    public Builder addAllButtons(
        java.lang.Iterable<? extends com.google.chat.v1.WidgetMarkup.Button> values) {
      if (buttonsBuilder_ == null) {
        ensureButtonsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, buttons_);
        onChanged();
      } else {
        buttonsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of buttons. Buttons is also `oneof data` and only one of these
     * fields should be set.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
     */
    public Builder clearButtons() {
      if (buttonsBuilder_ == null) {
        buttons_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        buttonsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of buttons. Buttons is also `oneof data` and only one of these
     * fields should be set.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
     */
    public Builder removeButtons(int index) {
      if (buttonsBuilder_ == null) {
        ensureButtonsIsMutable();
        buttons_.remove(index);
        onChanged();
      } else {
        buttonsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of buttons. Buttons is also `oneof data` and only one of these
     * fields should be set.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
     */
    public com.google.chat.v1.WidgetMarkup.Button.Builder getButtonsBuilder(int index) {
      return getButtonsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of buttons. Buttons is also `oneof data` and only one of these
     * fields should be set.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
     */
    public com.google.chat.v1.WidgetMarkup.ButtonOrBuilder getButtonsOrBuilder(int index) {
      if (buttonsBuilder_ == null) {
        return buttons_.get(index);
      } else {
        return buttonsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of buttons. Buttons is also `oneof data` and only one of these
     * fields should be set.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
     */
    public java.util.List<? extends com.google.chat.v1.WidgetMarkup.ButtonOrBuilder>
        getButtonsOrBuilderList() {
      if (buttonsBuilder_ != null) {
        return buttonsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(buttons_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of buttons. Buttons is also `oneof data` and only one of these
     * fields should be set.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
     */
    public com.google.chat.v1.WidgetMarkup.Button.Builder addButtonsBuilder() {
      return getButtonsFieldBuilder()
          .addBuilder(com.google.chat.v1.WidgetMarkup.Button.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of buttons. Buttons is also `oneof data` and only one of these
     * fields should be set.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
     */
    public com.google.chat.v1.WidgetMarkup.Button.Builder addButtonsBuilder(int index) {
      return getButtonsFieldBuilder()
          .addBuilder(index, com.google.chat.v1.WidgetMarkup.Button.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of buttons. Buttons is also `oneof data` and only one of these
     * fields should be set.
     * </pre>
     *
     * <code>repeated .google.chat.v1.WidgetMarkup.Button buttons = 6;</code>
     */
    public java.util.List<com.google.chat.v1.WidgetMarkup.Button.Builder> getButtonsBuilderList() {
      return getButtonsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.chat.v1.WidgetMarkup.Button,
            com.google.chat.v1.WidgetMarkup.Button.Builder,
            com.google.chat.v1.WidgetMarkup.ButtonOrBuilder>
        getButtonsFieldBuilder() {
      if (buttonsBuilder_ == null) {
        buttonsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.chat.v1.WidgetMarkup.Button,
                com.google.chat.v1.WidgetMarkup.Button.Builder,
                com.google.chat.v1.WidgetMarkup.ButtonOrBuilder>(
                buttons_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        buttons_ = null;
      }
      return buttonsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.WidgetMarkup)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.WidgetMarkup)
  private static final com.google.chat.v1.WidgetMarkup DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.WidgetMarkup();
  }

  public static com.google.chat.v1.WidgetMarkup getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WidgetMarkup> PARSER =
      new com.google.protobuf.AbstractParser<WidgetMarkup>() {
        @java.lang.Override
        public WidgetMarkup parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WidgetMarkup> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WidgetMarkup> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.WidgetMarkup getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
