/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/annotation.proto

// Protobuf Java Version: 3.25.5
package com.google.chat.v1;

/**
 *
 *
 * <pre>
 * Output only. Annotations associated with the plain-text body of the message.
 * To add basic formatting to a text message, see
 * [Format text
 * messages](https://developers.google.com/workspace/chat/format-messages).
 *
 * Example plain-text message body:
 * ```
 * Hello &#64;FooBot how are you!"
 * ```
 *
 * The corresponding annotations metadata:
 * ```
 * "annotations":[{
 *   "type":"USER_MENTION",
 *   "startIndex":6,
 *   "length":7,
 *   "userMention": {
 *     "user": {
 *       "name":"users/{user}",
 *       "displayName":"FooBot",
 *       "avatarUrl":"https://goo.gl/aeDtrS",
 *       "type":"BOT"
 *     },
 *     "type":"MENTION"
 *    }
 * }]
 * ```
 * </pre>
 *
 * Protobuf type {@code google.chat.v1.Annotation}
 */
public final class Annotation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.Annotation)
    AnnotationOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Annotation.newBuilder() to construct.
  private Annotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Annotation() {
    type_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Annotation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.AnnotationProto.internal_static_google_chat_v1_Annotation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.AnnotationProto
        .internal_static_google_chat_v1_Annotation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.Annotation.class, com.google.chat.v1.Annotation.Builder.class);
  }

  private int bitField0_;
  private int metadataCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object metadata_;

  public enum MetadataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    USER_MENTION(4),
    SLASH_COMMAND(5),
    RICH_LINK_METADATA(6),
    CUSTOM_EMOJI_METADATA(7),
    METADATA_NOT_SET(0);
    private final int value;

    private MetadataCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MetadataCase valueOf(int value) {
      return forNumber(value);
    }

    public static MetadataCase forNumber(int value) {
      switch (value) {
        case 4:
          return USER_MENTION;
        case 5:
          return SLASH_COMMAND;
        case 6:
          return RICH_LINK_METADATA;
        case 7:
          return CUSTOM_EMOJI_METADATA;
        case 0:
          return METADATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MetadataCase getMetadataCase() {
    return MetadataCase.forNumber(metadataCase_);
  }

  public static final int TYPE_FIELD_NUMBER = 1;
  private int type_ = 0;

  /**
   *
   *
   * <pre>
   * The type of this annotation.
   * </pre>
   *
   * <code>.google.chat.v1.AnnotationType type = 1;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }

  /**
   *
   *
   * <pre>
   * The type of this annotation.
   * </pre>
   *
   * <code>.google.chat.v1.AnnotationType type = 1;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.chat.v1.AnnotationType getType() {
    com.google.chat.v1.AnnotationType result = com.google.chat.v1.AnnotationType.forNumber(type_);
    return result == null ? com.google.chat.v1.AnnotationType.UNRECOGNIZED : result;
  }

  public static final int START_INDEX_FIELD_NUMBER = 2;
  private int startIndex_ = 0;

  /**
   *
   *
   * <pre>
   * Start index (0-based, inclusive) in the plain-text message body this
   * annotation corresponds to.
   * </pre>
   *
   * <code>optional int32 start_index = 2;</code>
   *
   * @return Whether the startIndex field is set.
   */
  @java.lang.Override
  public boolean hasStartIndex() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Start index (0-based, inclusive) in the plain-text message body this
   * annotation corresponds to.
   * </pre>
   *
   * <code>optional int32 start_index = 2;</code>
   *
   * @return The startIndex.
   */
  @java.lang.Override
  public int getStartIndex() {
    return startIndex_;
  }

  public static final int LENGTH_FIELD_NUMBER = 3;
  private int length_ = 0;

  /**
   *
   *
   * <pre>
   * Length of the substring in the plain-text message body this annotation
   * corresponds to.
   * </pre>
   *
   * <code>int32 length = 3;</code>
   *
   * @return The length.
   */
  @java.lang.Override
  public int getLength() {
    return length_;
  }

  public static final int USER_MENTION_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * The metadata of user mention.
   * </pre>
   *
   * <code>.google.chat.v1.UserMentionMetadata user_mention = 4;</code>
   *
   * @return Whether the userMention field is set.
   */
  @java.lang.Override
  public boolean hasUserMention() {
    return metadataCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * The metadata of user mention.
   * </pre>
   *
   * <code>.google.chat.v1.UserMentionMetadata user_mention = 4;</code>
   *
   * @return The userMention.
   */
  @java.lang.Override
  public com.google.chat.v1.UserMentionMetadata getUserMention() {
    if (metadataCase_ == 4) {
      return (com.google.chat.v1.UserMentionMetadata) metadata_;
    }
    return com.google.chat.v1.UserMentionMetadata.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The metadata of user mention.
   * </pre>
   *
   * <code>.google.chat.v1.UserMentionMetadata user_mention = 4;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.UserMentionMetadataOrBuilder getUserMentionOrBuilder() {
    if (metadataCase_ == 4) {
      return (com.google.chat.v1.UserMentionMetadata) metadata_;
    }
    return com.google.chat.v1.UserMentionMetadata.getDefaultInstance();
  }

  public static final int SLASH_COMMAND_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * The metadata for a slash command.
   * </pre>
   *
   * <code>.google.chat.v1.SlashCommandMetadata slash_command = 5;</code>
   *
   * @return Whether the slashCommand field is set.
   */
  @java.lang.Override
  public boolean hasSlashCommand() {
    return metadataCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * The metadata for a slash command.
   * </pre>
   *
   * <code>.google.chat.v1.SlashCommandMetadata slash_command = 5;</code>
   *
   * @return The slashCommand.
   */
  @java.lang.Override
  public com.google.chat.v1.SlashCommandMetadata getSlashCommand() {
    if (metadataCase_ == 5) {
      return (com.google.chat.v1.SlashCommandMetadata) metadata_;
    }
    return com.google.chat.v1.SlashCommandMetadata.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The metadata for a slash command.
   * </pre>
   *
   * <code>.google.chat.v1.SlashCommandMetadata slash_command = 5;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.SlashCommandMetadataOrBuilder getSlashCommandOrBuilder() {
    if (metadataCase_ == 5) {
      return (com.google.chat.v1.SlashCommandMetadata) metadata_;
    }
    return com.google.chat.v1.SlashCommandMetadata.getDefaultInstance();
  }

  public static final int RICH_LINK_METADATA_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * The metadata for a rich link.
   * </pre>
   *
   * <code>.google.chat.v1.RichLinkMetadata rich_link_metadata = 6;</code>
   *
   * @return Whether the richLinkMetadata field is set.
   */
  @java.lang.Override
  public boolean hasRichLinkMetadata() {
    return metadataCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * The metadata for a rich link.
   * </pre>
   *
   * <code>.google.chat.v1.RichLinkMetadata rich_link_metadata = 6;</code>
   *
   * @return The richLinkMetadata.
   */
  @java.lang.Override
  public com.google.chat.v1.RichLinkMetadata getRichLinkMetadata() {
    if (metadataCase_ == 6) {
      return (com.google.chat.v1.RichLinkMetadata) metadata_;
    }
    return com.google.chat.v1.RichLinkMetadata.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The metadata for a rich link.
   * </pre>
   *
   * <code>.google.chat.v1.RichLinkMetadata rich_link_metadata = 6;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.RichLinkMetadataOrBuilder getRichLinkMetadataOrBuilder() {
    if (metadataCase_ == 6) {
      return (com.google.chat.v1.RichLinkMetadata) metadata_;
    }
    return com.google.chat.v1.RichLinkMetadata.getDefaultInstance();
  }

  public static final int CUSTOM_EMOJI_METADATA_FIELD_NUMBER = 7;

  /**
   *
   *
   * <pre>
   * The metadata for a custom emoji.
   * </pre>
   *
   * <code>.google.chat.v1.CustomEmojiMetadata custom_emoji_metadata = 7;</code>
   *
   * @return Whether the customEmojiMetadata field is set.
   */
  @java.lang.Override
  public boolean hasCustomEmojiMetadata() {
    return metadataCase_ == 7;
  }

  /**
   *
   *
   * <pre>
   * The metadata for a custom emoji.
   * </pre>
   *
   * <code>.google.chat.v1.CustomEmojiMetadata custom_emoji_metadata = 7;</code>
   *
   * @return The customEmojiMetadata.
   */
  @java.lang.Override
  public com.google.chat.v1.CustomEmojiMetadata getCustomEmojiMetadata() {
    if (metadataCase_ == 7) {
      return (com.google.chat.v1.CustomEmojiMetadata) metadata_;
    }
    return com.google.chat.v1.CustomEmojiMetadata.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The metadata for a custom emoji.
   * </pre>
   *
   * <code>.google.chat.v1.CustomEmojiMetadata custom_emoji_metadata = 7;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.CustomEmojiMetadataOrBuilder getCustomEmojiMetadataOrBuilder() {
    if (metadataCase_ == 7) {
      return (com.google.chat.v1.CustomEmojiMetadata) metadata_;
    }
    return com.google.chat.v1.CustomEmojiMetadata.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (type_ != com.google.chat.v1.AnnotationType.ANNOTATION_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, type_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt32(2, startIndex_);
    }
    if (length_ != 0) {
      output.writeInt32(3, length_);
    }
    if (metadataCase_ == 4) {
      output.writeMessage(4, (com.google.chat.v1.UserMentionMetadata) metadata_);
    }
    if (metadataCase_ == 5) {
      output.writeMessage(5, (com.google.chat.v1.SlashCommandMetadata) metadata_);
    }
    if (metadataCase_ == 6) {
      output.writeMessage(6, (com.google.chat.v1.RichLinkMetadata) metadata_);
    }
    if (metadataCase_ == 7) {
      output.writeMessage(7, (com.google.chat.v1.CustomEmojiMetadata) metadata_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (type_ != com.google.chat.v1.AnnotationType.ANNOTATION_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, startIndex_);
    }
    if (length_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, length_);
    }
    if (metadataCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.chat.v1.UserMentionMetadata) metadata_);
    }
    if (metadataCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.chat.v1.SlashCommandMetadata) metadata_);
    }
    if (metadataCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.chat.v1.RichLinkMetadata) metadata_);
    }
    if (metadataCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.chat.v1.CustomEmojiMetadata) metadata_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.Annotation)) {
      return super.equals(obj);
    }
    com.google.chat.v1.Annotation other = (com.google.chat.v1.Annotation) obj;

    if (type_ != other.type_) return false;
    if (hasStartIndex() != other.hasStartIndex()) return false;
    if (hasStartIndex()) {
      if (getStartIndex() != other.getStartIndex()) return false;
    }
    if (getLength() != other.getLength()) return false;
    if (!getMetadataCase().equals(other.getMetadataCase())) return false;
    switch (metadataCase_) {
      case 4:
        if (!getUserMention().equals(other.getUserMention())) return false;
        break;
      case 5:
        if (!getSlashCommand().equals(other.getSlashCommand())) return false;
        break;
      case 6:
        if (!getRichLinkMetadata().equals(other.getRichLinkMetadata())) return false;
        break;
      case 7:
        if (!getCustomEmojiMetadata().equals(other.getCustomEmojiMetadata())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    if (hasStartIndex()) {
      hash = (37 * hash) + START_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getStartIndex();
    }
    hash = (37 * hash) + LENGTH_FIELD_NUMBER;
    hash = (53 * hash) + getLength();
    switch (metadataCase_) {
      case 4:
        hash = (37 * hash) + USER_MENTION_FIELD_NUMBER;
        hash = (53 * hash) + getUserMention().hashCode();
        break;
      case 5:
        hash = (37 * hash) + SLASH_COMMAND_FIELD_NUMBER;
        hash = (53 * hash) + getSlashCommand().hashCode();
        break;
      case 6:
        hash = (37 * hash) + RICH_LINK_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getRichLinkMetadata().hashCode();
        break;
      case 7:
        hash = (37 * hash) + CUSTOM_EMOJI_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getCustomEmojiMetadata().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.Annotation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.Annotation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.Annotation parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.Annotation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.Annotation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.Annotation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.Annotation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.Annotation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.Annotation parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.Annotation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.Annotation parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.Annotation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.Annotation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Output only. Annotations associated with the plain-text body of the message.
   * To add basic formatting to a text message, see
   * [Format text
   * messages](https://developers.google.com/workspace/chat/format-messages).
   *
   * Example plain-text message body:
   * ```
   * Hello &#64;FooBot how are you!"
   * ```
   *
   * The corresponding annotations metadata:
   * ```
   * "annotations":[{
   *   "type":"USER_MENTION",
   *   "startIndex":6,
   *   "length":7,
   *   "userMention": {
   *     "user": {
   *       "name":"users/{user}",
   *       "displayName":"FooBot",
   *       "avatarUrl":"https://goo.gl/aeDtrS",
   *       "type":"BOT"
   *     },
   *     "type":"MENTION"
   *    }
   * }]
   * ```
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.Annotation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.Annotation)
      com.google.chat.v1.AnnotationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.AnnotationProto
          .internal_static_google_chat_v1_Annotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.AnnotationProto
          .internal_static_google_chat_v1_Annotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.Annotation.class, com.google.chat.v1.Annotation.Builder.class);
    }

    // Construct using com.google.chat.v1.Annotation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      type_ = 0;
      startIndex_ = 0;
      length_ = 0;
      if (userMentionBuilder_ != null) {
        userMentionBuilder_.clear();
      }
      if (slashCommandBuilder_ != null) {
        slashCommandBuilder_.clear();
      }
      if (richLinkMetadataBuilder_ != null) {
        richLinkMetadataBuilder_.clear();
      }
      if (customEmojiMetadataBuilder_ != null) {
        customEmojiMetadataBuilder_.clear();
      }
      metadataCase_ = 0;
      metadata_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.AnnotationProto
          .internal_static_google_chat_v1_Annotation_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.Annotation getDefaultInstanceForType() {
      return com.google.chat.v1.Annotation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.Annotation build() {
      com.google.chat.v1.Annotation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.Annotation buildPartial() {
      com.google.chat.v1.Annotation result = new com.google.chat.v1.Annotation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.chat.v1.Annotation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.type_ = type_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.startIndex_ = startIndex_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.length_ = length_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.chat.v1.Annotation result) {
      result.metadataCase_ = metadataCase_;
      result.metadata_ = this.metadata_;
      if (metadataCase_ == 4 && userMentionBuilder_ != null) {
        result.metadata_ = userMentionBuilder_.build();
      }
      if (metadataCase_ == 5 && slashCommandBuilder_ != null) {
        result.metadata_ = slashCommandBuilder_.build();
      }
      if (metadataCase_ == 6 && richLinkMetadataBuilder_ != null) {
        result.metadata_ = richLinkMetadataBuilder_.build();
      }
      if (metadataCase_ == 7 && customEmojiMetadataBuilder_ != null) {
        result.metadata_ = customEmojiMetadataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.Annotation) {
        return mergeFrom((com.google.chat.v1.Annotation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.Annotation other) {
      if (other == com.google.chat.v1.Annotation.getDefaultInstance()) return this;
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.hasStartIndex()) {
        setStartIndex(other.getStartIndex());
      }
      if (other.getLength() != 0) {
        setLength(other.getLength());
      }
      switch (other.getMetadataCase()) {
        case USER_MENTION:
          {
            mergeUserMention(other.getUserMention());
            break;
          }
        case SLASH_COMMAND:
          {
            mergeSlashCommand(other.getSlashCommand());
            break;
          }
        case RICH_LINK_METADATA:
          {
            mergeRichLinkMetadata(other.getRichLinkMetadata());
            break;
          }
        case CUSTOM_EMOJI_METADATA:
          {
            mergeCustomEmojiMetadata(other.getCustomEmojiMetadata());
            break;
          }
        case METADATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                startIndex_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                length_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getUserMentionFieldBuilder().getBuilder(), extensionRegistry);
                metadataCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getSlashCommandFieldBuilder().getBuilder(), extensionRegistry);
                metadataCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getRichLinkMetadataFieldBuilder().getBuilder(), extensionRegistry);
                metadataCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getCustomEmojiMetadataFieldBuilder().getBuilder(), extensionRegistry);
                metadataCase_ = 7;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int metadataCase_ = 0;
    private java.lang.Object metadata_;

    public MetadataCase getMetadataCase() {
      return MetadataCase.forNumber(metadataCase_);
    }

    public Builder clearMetadata() {
      metadataCase_ = 0;
      metadata_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private int type_ = 0;

    /**
     *
     *
     * <pre>
     * The type of this annotation.
     * </pre>
     *
     * <code>.google.chat.v1.AnnotationType type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }

    /**
     *
     *
     * <pre>
     * The type of this annotation.
     * </pre>
     *
     * <code>.google.chat.v1.AnnotationType type = 1;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of this annotation.
     * </pre>
     *
     * <code>.google.chat.v1.AnnotationType type = 1;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.chat.v1.AnnotationType getType() {
      com.google.chat.v1.AnnotationType result = com.google.chat.v1.AnnotationType.forNumber(type_);
      return result == null ? com.google.chat.v1.AnnotationType.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * The type of this annotation.
     * </pre>
     *
     * <code>.google.chat.v1.AnnotationType type = 1;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.chat.v1.AnnotationType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      type_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of this annotation.
     * </pre>
     *
     * <code>.google.chat.v1.AnnotationType type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      type_ = 0;
      onChanged();
      return this;
    }

    private int startIndex_;

    /**
     *
     *
     * <pre>
     * Start index (0-based, inclusive) in the plain-text message body this
     * annotation corresponds to.
     * </pre>
     *
     * <code>optional int32 start_index = 2;</code>
     *
     * @return Whether the startIndex field is set.
     */
    @java.lang.Override
    public boolean hasStartIndex() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Start index (0-based, inclusive) in the plain-text message body this
     * annotation corresponds to.
     * </pre>
     *
     * <code>optional int32 start_index = 2;</code>
     *
     * @return The startIndex.
     */
    @java.lang.Override
    public int getStartIndex() {
      return startIndex_;
    }

    /**
     *
     *
     * <pre>
     * Start index (0-based, inclusive) in the plain-text message body this
     * annotation corresponds to.
     * </pre>
     *
     * <code>optional int32 start_index = 2;</code>
     *
     * @param value The startIndex to set.
     * @return This builder for chaining.
     */
    public Builder setStartIndex(int value) {

      startIndex_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Start index (0-based, inclusive) in the plain-text message body this
     * annotation corresponds to.
     * </pre>
     *
     * <code>optional int32 start_index = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStartIndex() {
      bitField0_ = (bitField0_ & ~0x00000002);
      startIndex_ = 0;
      onChanged();
      return this;
    }

    private int length_;

    /**
     *
     *
     * <pre>
     * Length of the substring in the plain-text message body this annotation
     * corresponds to.
     * </pre>
     *
     * <code>int32 length = 3;</code>
     *
     * @return The length.
     */
    @java.lang.Override
    public int getLength() {
      return length_;
    }

    /**
     *
     *
     * <pre>
     * Length of the substring in the plain-text message body this annotation
     * corresponds to.
     * </pre>
     *
     * <code>int32 length = 3;</code>
     *
     * @param value The length to set.
     * @return This builder for chaining.
     */
    public Builder setLength(int value) {

      length_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Length of the substring in the plain-text message body this annotation
     * corresponds to.
     * </pre>
     *
     * <code>int32 length = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLength() {
      bitField0_ = (bitField0_ & ~0x00000004);
      length_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.UserMentionMetadata,
            com.google.chat.v1.UserMentionMetadata.Builder,
            com.google.chat.v1.UserMentionMetadataOrBuilder>
        userMentionBuilder_;

    /**
     *
     *
     * <pre>
     * The metadata of user mention.
     * </pre>
     *
     * <code>.google.chat.v1.UserMentionMetadata user_mention = 4;</code>
     *
     * @return Whether the userMention field is set.
     */
    @java.lang.Override
    public boolean hasUserMention() {
      return metadataCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * The metadata of user mention.
     * </pre>
     *
     * <code>.google.chat.v1.UserMentionMetadata user_mention = 4;</code>
     *
     * @return The userMention.
     */
    @java.lang.Override
    public com.google.chat.v1.UserMentionMetadata getUserMention() {
      if (userMentionBuilder_ == null) {
        if (metadataCase_ == 4) {
          return (com.google.chat.v1.UserMentionMetadata) metadata_;
        }
        return com.google.chat.v1.UserMentionMetadata.getDefaultInstance();
      } else {
        if (metadataCase_ == 4) {
          return userMentionBuilder_.getMessage();
        }
        return com.google.chat.v1.UserMentionMetadata.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The metadata of user mention.
     * </pre>
     *
     * <code>.google.chat.v1.UserMentionMetadata user_mention = 4;</code>
     */
    public Builder setUserMention(com.google.chat.v1.UserMentionMetadata value) {
      if (userMentionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
        onChanged();
      } else {
        userMentionBuilder_.setMessage(value);
      }
      metadataCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata of user mention.
     * </pre>
     *
     * <code>.google.chat.v1.UserMentionMetadata user_mention = 4;</code>
     */
    public Builder setUserMention(com.google.chat.v1.UserMentionMetadata.Builder builderForValue) {
      if (userMentionBuilder_ == null) {
        metadata_ = builderForValue.build();
        onChanged();
      } else {
        userMentionBuilder_.setMessage(builderForValue.build());
      }
      metadataCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata of user mention.
     * </pre>
     *
     * <code>.google.chat.v1.UserMentionMetadata user_mention = 4;</code>
     */
    public Builder mergeUserMention(com.google.chat.v1.UserMentionMetadata value) {
      if (userMentionBuilder_ == null) {
        if (metadataCase_ == 4
            && metadata_ != com.google.chat.v1.UserMentionMetadata.getDefaultInstance()) {
          metadata_ =
              com.google.chat.v1.UserMentionMetadata.newBuilder(
                      (com.google.chat.v1.UserMentionMetadata) metadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metadata_ = value;
        }
        onChanged();
      } else {
        if (metadataCase_ == 4) {
          userMentionBuilder_.mergeFrom(value);
        } else {
          userMentionBuilder_.setMessage(value);
        }
      }
      metadataCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata of user mention.
     * </pre>
     *
     * <code>.google.chat.v1.UserMentionMetadata user_mention = 4;</code>
     */
    public Builder clearUserMention() {
      if (userMentionBuilder_ == null) {
        if (metadataCase_ == 4) {
          metadataCase_ = 0;
          metadata_ = null;
          onChanged();
        }
      } else {
        if (metadataCase_ == 4) {
          metadataCase_ = 0;
          metadata_ = null;
        }
        userMentionBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata of user mention.
     * </pre>
     *
     * <code>.google.chat.v1.UserMentionMetadata user_mention = 4;</code>
     */
    public com.google.chat.v1.UserMentionMetadata.Builder getUserMentionBuilder() {
      return getUserMentionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The metadata of user mention.
     * </pre>
     *
     * <code>.google.chat.v1.UserMentionMetadata user_mention = 4;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.UserMentionMetadataOrBuilder getUserMentionOrBuilder() {
      if ((metadataCase_ == 4) && (userMentionBuilder_ != null)) {
        return userMentionBuilder_.getMessageOrBuilder();
      } else {
        if (metadataCase_ == 4) {
          return (com.google.chat.v1.UserMentionMetadata) metadata_;
        }
        return com.google.chat.v1.UserMentionMetadata.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The metadata of user mention.
     * </pre>
     *
     * <code>.google.chat.v1.UserMentionMetadata user_mention = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.UserMentionMetadata,
            com.google.chat.v1.UserMentionMetadata.Builder,
            com.google.chat.v1.UserMentionMetadataOrBuilder>
        getUserMentionFieldBuilder() {
      if (userMentionBuilder_ == null) {
        if (!(metadataCase_ == 4)) {
          metadata_ = com.google.chat.v1.UserMentionMetadata.getDefaultInstance();
        }
        userMentionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.UserMentionMetadata,
                com.google.chat.v1.UserMentionMetadata.Builder,
                com.google.chat.v1.UserMentionMetadataOrBuilder>(
                (com.google.chat.v1.UserMentionMetadata) metadata_,
                getParentForChildren(),
                isClean());
        metadata_ = null;
      }
      metadataCase_ = 4;
      onChanged();
      return userMentionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.SlashCommandMetadata,
            com.google.chat.v1.SlashCommandMetadata.Builder,
            com.google.chat.v1.SlashCommandMetadataOrBuilder>
        slashCommandBuilder_;

    /**
     *
     *
     * <pre>
     * The metadata for a slash command.
     * </pre>
     *
     * <code>.google.chat.v1.SlashCommandMetadata slash_command = 5;</code>
     *
     * @return Whether the slashCommand field is set.
     */
    @java.lang.Override
    public boolean hasSlashCommand() {
      return metadataCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * The metadata for a slash command.
     * </pre>
     *
     * <code>.google.chat.v1.SlashCommandMetadata slash_command = 5;</code>
     *
     * @return The slashCommand.
     */
    @java.lang.Override
    public com.google.chat.v1.SlashCommandMetadata getSlashCommand() {
      if (slashCommandBuilder_ == null) {
        if (metadataCase_ == 5) {
          return (com.google.chat.v1.SlashCommandMetadata) metadata_;
        }
        return com.google.chat.v1.SlashCommandMetadata.getDefaultInstance();
      } else {
        if (metadataCase_ == 5) {
          return slashCommandBuilder_.getMessage();
        }
        return com.google.chat.v1.SlashCommandMetadata.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The metadata for a slash command.
     * </pre>
     *
     * <code>.google.chat.v1.SlashCommandMetadata slash_command = 5;</code>
     */
    public Builder setSlashCommand(com.google.chat.v1.SlashCommandMetadata value) {
      if (slashCommandBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
        onChanged();
      } else {
        slashCommandBuilder_.setMessage(value);
      }
      metadataCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata for a slash command.
     * </pre>
     *
     * <code>.google.chat.v1.SlashCommandMetadata slash_command = 5;</code>
     */
    public Builder setSlashCommand(
        com.google.chat.v1.SlashCommandMetadata.Builder builderForValue) {
      if (slashCommandBuilder_ == null) {
        metadata_ = builderForValue.build();
        onChanged();
      } else {
        slashCommandBuilder_.setMessage(builderForValue.build());
      }
      metadataCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata for a slash command.
     * </pre>
     *
     * <code>.google.chat.v1.SlashCommandMetadata slash_command = 5;</code>
     */
    public Builder mergeSlashCommand(com.google.chat.v1.SlashCommandMetadata value) {
      if (slashCommandBuilder_ == null) {
        if (metadataCase_ == 5
            && metadata_ != com.google.chat.v1.SlashCommandMetadata.getDefaultInstance()) {
          metadata_ =
              com.google.chat.v1.SlashCommandMetadata.newBuilder(
                      (com.google.chat.v1.SlashCommandMetadata) metadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metadata_ = value;
        }
        onChanged();
      } else {
        if (metadataCase_ == 5) {
          slashCommandBuilder_.mergeFrom(value);
        } else {
          slashCommandBuilder_.setMessage(value);
        }
      }
      metadataCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata for a slash command.
     * </pre>
     *
     * <code>.google.chat.v1.SlashCommandMetadata slash_command = 5;</code>
     */
    public Builder clearSlashCommand() {
      if (slashCommandBuilder_ == null) {
        if (metadataCase_ == 5) {
          metadataCase_ = 0;
          metadata_ = null;
          onChanged();
        }
      } else {
        if (metadataCase_ == 5) {
          metadataCase_ = 0;
          metadata_ = null;
        }
        slashCommandBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata for a slash command.
     * </pre>
     *
     * <code>.google.chat.v1.SlashCommandMetadata slash_command = 5;</code>
     */
    public com.google.chat.v1.SlashCommandMetadata.Builder getSlashCommandBuilder() {
      return getSlashCommandFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The metadata for a slash command.
     * </pre>
     *
     * <code>.google.chat.v1.SlashCommandMetadata slash_command = 5;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.SlashCommandMetadataOrBuilder getSlashCommandOrBuilder() {
      if ((metadataCase_ == 5) && (slashCommandBuilder_ != null)) {
        return slashCommandBuilder_.getMessageOrBuilder();
      } else {
        if (metadataCase_ == 5) {
          return (com.google.chat.v1.SlashCommandMetadata) metadata_;
        }
        return com.google.chat.v1.SlashCommandMetadata.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The metadata for a slash command.
     * </pre>
     *
     * <code>.google.chat.v1.SlashCommandMetadata slash_command = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.SlashCommandMetadata,
            com.google.chat.v1.SlashCommandMetadata.Builder,
            com.google.chat.v1.SlashCommandMetadataOrBuilder>
        getSlashCommandFieldBuilder() {
      if (slashCommandBuilder_ == null) {
        if (!(metadataCase_ == 5)) {
          metadata_ = com.google.chat.v1.SlashCommandMetadata.getDefaultInstance();
        }
        slashCommandBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.SlashCommandMetadata,
                com.google.chat.v1.SlashCommandMetadata.Builder,
                com.google.chat.v1.SlashCommandMetadataOrBuilder>(
                (com.google.chat.v1.SlashCommandMetadata) metadata_,
                getParentForChildren(),
                isClean());
        metadata_ = null;
      }
      metadataCase_ = 5;
      onChanged();
      return slashCommandBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.RichLinkMetadata,
            com.google.chat.v1.RichLinkMetadata.Builder,
            com.google.chat.v1.RichLinkMetadataOrBuilder>
        richLinkMetadataBuilder_;

    /**
     *
     *
     * <pre>
     * The metadata for a rich link.
     * </pre>
     *
     * <code>.google.chat.v1.RichLinkMetadata rich_link_metadata = 6;</code>
     *
     * @return Whether the richLinkMetadata field is set.
     */
    @java.lang.Override
    public boolean hasRichLinkMetadata() {
      return metadataCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * The metadata for a rich link.
     * </pre>
     *
     * <code>.google.chat.v1.RichLinkMetadata rich_link_metadata = 6;</code>
     *
     * @return The richLinkMetadata.
     */
    @java.lang.Override
    public com.google.chat.v1.RichLinkMetadata getRichLinkMetadata() {
      if (richLinkMetadataBuilder_ == null) {
        if (metadataCase_ == 6) {
          return (com.google.chat.v1.RichLinkMetadata) metadata_;
        }
        return com.google.chat.v1.RichLinkMetadata.getDefaultInstance();
      } else {
        if (metadataCase_ == 6) {
          return richLinkMetadataBuilder_.getMessage();
        }
        return com.google.chat.v1.RichLinkMetadata.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The metadata for a rich link.
     * </pre>
     *
     * <code>.google.chat.v1.RichLinkMetadata rich_link_metadata = 6;</code>
     */
    public Builder setRichLinkMetadata(com.google.chat.v1.RichLinkMetadata value) {
      if (richLinkMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
        onChanged();
      } else {
        richLinkMetadataBuilder_.setMessage(value);
      }
      metadataCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata for a rich link.
     * </pre>
     *
     * <code>.google.chat.v1.RichLinkMetadata rich_link_metadata = 6;</code>
     */
    public Builder setRichLinkMetadata(
        com.google.chat.v1.RichLinkMetadata.Builder builderForValue) {
      if (richLinkMetadataBuilder_ == null) {
        metadata_ = builderForValue.build();
        onChanged();
      } else {
        richLinkMetadataBuilder_.setMessage(builderForValue.build());
      }
      metadataCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata for a rich link.
     * </pre>
     *
     * <code>.google.chat.v1.RichLinkMetadata rich_link_metadata = 6;</code>
     */
    public Builder mergeRichLinkMetadata(com.google.chat.v1.RichLinkMetadata value) {
      if (richLinkMetadataBuilder_ == null) {
        if (metadataCase_ == 6
            && metadata_ != com.google.chat.v1.RichLinkMetadata.getDefaultInstance()) {
          metadata_ =
              com.google.chat.v1.RichLinkMetadata.newBuilder(
                      (com.google.chat.v1.RichLinkMetadata) metadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metadata_ = value;
        }
        onChanged();
      } else {
        if (metadataCase_ == 6) {
          richLinkMetadataBuilder_.mergeFrom(value);
        } else {
          richLinkMetadataBuilder_.setMessage(value);
        }
      }
      metadataCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata for a rich link.
     * </pre>
     *
     * <code>.google.chat.v1.RichLinkMetadata rich_link_metadata = 6;</code>
     */
    public Builder clearRichLinkMetadata() {
      if (richLinkMetadataBuilder_ == null) {
        if (metadataCase_ == 6) {
          metadataCase_ = 0;
          metadata_ = null;
          onChanged();
        }
      } else {
        if (metadataCase_ == 6) {
          metadataCase_ = 0;
          metadata_ = null;
        }
        richLinkMetadataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata for a rich link.
     * </pre>
     *
     * <code>.google.chat.v1.RichLinkMetadata rich_link_metadata = 6;</code>
     */
    public com.google.chat.v1.RichLinkMetadata.Builder getRichLinkMetadataBuilder() {
      return getRichLinkMetadataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The metadata for a rich link.
     * </pre>
     *
     * <code>.google.chat.v1.RichLinkMetadata rich_link_metadata = 6;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.RichLinkMetadataOrBuilder getRichLinkMetadataOrBuilder() {
      if ((metadataCase_ == 6) && (richLinkMetadataBuilder_ != null)) {
        return richLinkMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (metadataCase_ == 6) {
          return (com.google.chat.v1.RichLinkMetadata) metadata_;
        }
        return com.google.chat.v1.RichLinkMetadata.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The metadata for a rich link.
     * </pre>
     *
     * <code>.google.chat.v1.RichLinkMetadata rich_link_metadata = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.RichLinkMetadata,
            com.google.chat.v1.RichLinkMetadata.Builder,
            com.google.chat.v1.RichLinkMetadataOrBuilder>
        getRichLinkMetadataFieldBuilder() {
      if (richLinkMetadataBuilder_ == null) {
        if (!(metadataCase_ == 6)) {
          metadata_ = com.google.chat.v1.RichLinkMetadata.getDefaultInstance();
        }
        richLinkMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.RichLinkMetadata,
                com.google.chat.v1.RichLinkMetadata.Builder,
                com.google.chat.v1.RichLinkMetadataOrBuilder>(
                (com.google.chat.v1.RichLinkMetadata) metadata_, getParentForChildren(), isClean());
        metadata_ = null;
      }
      metadataCase_ = 6;
      onChanged();
      return richLinkMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.CustomEmojiMetadata,
            com.google.chat.v1.CustomEmojiMetadata.Builder,
            com.google.chat.v1.CustomEmojiMetadataOrBuilder>
        customEmojiMetadataBuilder_;

    /**
     *
     *
     * <pre>
     * The metadata for a custom emoji.
     * </pre>
     *
     * <code>.google.chat.v1.CustomEmojiMetadata custom_emoji_metadata = 7;</code>
     *
     * @return Whether the customEmojiMetadata field is set.
     */
    @java.lang.Override
    public boolean hasCustomEmojiMetadata() {
      return metadataCase_ == 7;
    }

    /**
     *
     *
     * <pre>
     * The metadata for a custom emoji.
     * </pre>
     *
     * <code>.google.chat.v1.CustomEmojiMetadata custom_emoji_metadata = 7;</code>
     *
     * @return The customEmojiMetadata.
     */
    @java.lang.Override
    public com.google.chat.v1.CustomEmojiMetadata getCustomEmojiMetadata() {
      if (customEmojiMetadataBuilder_ == null) {
        if (metadataCase_ == 7) {
          return (com.google.chat.v1.CustomEmojiMetadata) metadata_;
        }
        return com.google.chat.v1.CustomEmojiMetadata.getDefaultInstance();
      } else {
        if (metadataCase_ == 7) {
          return customEmojiMetadataBuilder_.getMessage();
        }
        return com.google.chat.v1.CustomEmojiMetadata.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The metadata for a custom emoji.
     * </pre>
     *
     * <code>.google.chat.v1.CustomEmojiMetadata custom_emoji_metadata = 7;</code>
     */
    public Builder setCustomEmojiMetadata(com.google.chat.v1.CustomEmojiMetadata value) {
      if (customEmojiMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
        onChanged();
      } else {
        customEmojiMetadataBuilder_.setMessage(value);
      }
      metadataCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata for a custom emoji.
     * </pre>
     *
     * <code>.google.chat.v1.CustomEmojiMetadata custom_emoji_metadata = 7;</code>
     */
    public Builder setCustomEmojiMetadata(
        com.google.chat.v1.CustomEmojiMetadata.Builder builderForValue) {
      if (customEmojiMetadataBuilder_ == null) {
        metadata_ = builderForValue.build();
        onChanged();
      } else {
        customEmojiMetadataBuilder_.setMessage(builderForValue.build());
      }
      metadataCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata for a custom emoji.
     * </pre>
     *
     * <code>.google.chat.v1.CustomEmojiMetadata custom_emoji_metadata = 7;</code>
     */
    public Builder mergeCustomEmojiMetadata(com.google.chat.v1.CustomEmojiMetadata value) {
      if (customEmojiMetadataBuilder_ == null) {
        if (metadataCase_ == 7
            && metadata_ != com.google.chat.v1.CustomEmojiMetadata.getDefaultInstance()) {
          metadata_ =
              com.google.chat.v1.CustomEmojiMetadata.newBuilder(
                      (com.google.chat.v1.CustomEmojiMetadata) metadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metadata_ = value;
        }
        onChanged();
      } else {
        if (metadataCase_ == 7) {
          customEmojiMetadataBuilder_.mergeFrom(value);
        } else {
          customEmojiMetadataBuilder_.setMessage(value);
        }
      }
      metadataCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata for a custom emoji.
     * </pre>
     *
     * <code>.google.chat.v1.CustomEmojiMetadata custom_emoji_metadata = 7;</code>
     */
    public Builder clearCustomEmojiMetadata() {
      if (customEmojiMetadataBuilder_ == null) {
        if (metadataCase_ == 7) {
          metadataCase_ = 0;
          metadata_ = null;
          onChanged();
        }
      } else {
        if (metadataCase_ == 7) {
          metadataCase_ = 0;
          metadata_ = null;
        }
        customEmojiMetadataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata for a custom emoji.
     * </pre>
     *
     * <code>.google.chat.v1.CustomEmojiMetadata custom_emoji_metadata = 7;</code>
     */
    public com.google.chat.v1.CustomEmojiMetadata.Builder getCustomEmojiMetadataBuilder() {
      return getCustomEmojiMetadataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The metadata for a custom emoji.
     * </pre>
     *
     * <code>.google.chat.v1.CustomEmojiMetadata custom_emoji_metadata = 7;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.CustomEmojiMetadataOrBuilder getCustomEmojiMetadataOrBuilder() {
      if ((metadataCase_ == 7) && (customEmojiMetadataBuilder_ != null)) {
        return customEmojiMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (metadataCase_ == 7) {
          return (com.google.chat.v1.CustomEmojiMetadata) metadata_;
        }
        return com.google.chat.v1.CustomEmojiMetadata.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The metadata for a custom emoji.
     * </pre>
     *
     * <code>.google.chat.v1.CustomEmojiMetadata custom_emoji_metadata = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.CustomEmojiMetadata,
            com.google.chat.v1.CustomEmojiMetadata.Builder,
            com.google.chat.v1.CustomEmojiMetadataOrBuilder>
        getCustomEmojiMetadataFieldBuilder() {
      if (customEmojiMetadataBuilder_ == null) {
        if (!(metadataCase_ == 7)) {
          metadata_ = com.google.chat.v1.CustomEmojiMetadata.getDefaultInstance();
        }
        customEmojiMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.CustomEmojiMetadata,
                com.google.chat.v1.CustomEmojiMetadata.Builder,
                com.google.chat.v1.CustomEmojiMetadataOrBuilder>(
                (com.google.chat.v1.CustomEmojiMetadata) metadata_,
                getParentForChildren(),
                isClean());
        metadata_ = null;
      }
      metadataCase_ = 7;
      onChanged();
      return customEmojiMetadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.Annotation)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.Annotation)
  private static final com.google.chat.v1.Annotation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.Annotation();
  }

  public static com.google.chat.v1.Annotation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Annotation> PARSER =
      new com.google.protobuf.AbstractParser<Annotation>() {
        @java.lang.Override
        public Annotation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Annotation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Annotation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.Annotation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
