/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/membership.proto

// Protobuf Java Version: 3.25.5
package com.google.chat.v1;

/**
 *
 *
 * <pre>
 * Request message for listing memberships.
 * </pre>
 *
 * Protobuf type {@code google.chat.v1.ListMembershipsRequest}
 */
public final class ListMembershipsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.ListMembershipsRequest)
    ListMembershipsRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ListMembershipsRequest.newBuilder() to construct.
  private ListMembershipsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListMembershipsRequest() {
    parent_ = "";
    pageToken_ = "";
    filter_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListMembershipsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.MembershipProto
        .internal_static_google_chat_v1_ListMembershipsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.MembershipProto
        .internal_static_google_chat_v1_ListMembershipsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.ListMembershipsRequest.class,
            com.google.chat.v1.ListMembershipsRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. The resource name of the space for which to fetch a membership
   * list.
   *
   * Format: spaces/{space}
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The resource name of the space for which to fetch a membership
   * list.
   *
   * Format: spaces/{space}
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 2;
  private int pageSize_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. The maximum number of memberships to return. The service might
   * return fewer than this value.
   *
   * If unspecified, at most 100 memberships are returned.
   *
   * The maximum value is 1000. If you use a value more than 1000, it's
   * automatically changed to 1000.
   *
   * Negative values return an `INVALID_ARGUMENT` error.
   * </pre>
   *
   * <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";

  /**
   *
   *
   * <pre>
   * Optional. A page token, received from a previous call to list memberships.
   * Provide this parameter to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided should match the call that
   * provided the page token. Passing different values to the other parameters
   * might lead to unexpected results.
   * </pre>
   *
   * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. A page token, received from a previous call to list memberships.
   * Provide this parameter to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided should match the call that
   * provided the page token. Passing different values to the other parameters
   * might lead to unexpected results.
   * </pre>
   *
   * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";

  /**
   *
   *
   * <pre>
   * Optional. A query filter.
   *
   * You can filter memberships by a member's role
   * ([`role`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members#membershiprole))
   * and type
   * ([`member.type`](https://developers.google.com/workspace/chat/api/reference/rest/v1/User#type)).
   *
   * To filter by role, set `role` to `ROLE_MEMBER` or `ROLE_MANAGER`.
   *
   * To filter by type, set `member.type` to `HUMAN` or `BOT`. You can also
   * filter for `member.type` using the `!=` operator.
   *
   * To filter by both role and type, use the `AND` operator. To filter by
   * either role or type, use the `OR` operator.
   *
   * Either `member.type = "HUMAN"` or `member.type != "BOT"` is required
   * when `use_admin_access` is set to true. Other member type filters will be
   * rejected.
   *
   * For example, the following queries are valid:
   *
   * ```
   * role = "ROLE_MANAGER" OR role = "ROLE_MEMBER"
   * member.type = "HUMAN" AND role = "ROLE_MANAGER"
   *
   * member.type != "BOT"
   * ```
   *
   * The following queries are invalid:
   *
   * ```
   * member.type = "HUMAN" AND member.type = "BOT"
   * role = "ROLE_MANAGER" AND role = "ROLE_MEMBER"
   * ```
   *
   * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
   * error.
   * </pre>
   *
   * <code>string filter = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. A query filter.
   *
   * You can filter memberships by a member's role
   * ([`role`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members#membershiprole))
   * and type
   * ([`member.type`](https://developers.google.com/workspace/chat/api/reference/rest/v1/User#type)).
   *
   * To filter by role, set `role` to `ROLE_MEMBER` or `ROLE_MANAGER`.
   *
   * To filter by type, set `member.type` to `HUMAN` or `BOT`. You can also
   * filter for `member.type` using the `!=` operator.
   *
   * To filter by both role and type, use the `AND` operator. To filter by
   * either role or type, use the `OR` operator.
   *
   * Either `member.type = "HUMAN"` or `member.type != "BOT"` is required
   * when `use_admin_access` is set to true. Other member type filters will be
   * rejected.
   *
   * For example, the following queries are valid:
   *
   * ```
   * role = "ROLE_MANAGER" OR role = "ROLE_MEMBER"
   * member.type = "HUMAN" AND role = "ROLE_MANAGER"
   *
   * member.type != "BOT"
   * ```
   *
   * The following queries are invalid:
   *
   * ```
   * member.type = "HUMAN" AND member.type = "BOT"
   * role = "ROLE_MANAGER" AND role = "ROLE_MEMBER"
   * ```
   *
   * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
   * error.
   * </pre>
   *
   * <code>string filter = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SHOW_GROUPS_FIELD_NUMBER = 6;
  private boolean showGroups_ = false;

  /**
   *
   *
   * <pre>
   * Optional. When `true`, also returns memberships associated with a
   * [Google Group][google.chat.v1.Membership.group_member], in
   * addition to other types of memberships. If a
   * [filter][google.chat.v1.ListMembershipsRequest.filter] is set,
   * [Google Group][google.chat.v1.Membership.group_member]
   * memberships that don't match the filter criteria aren't returned.
   * </pre>
   *
   * <code>bool show_groups = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The showGroups.
   */
  @java.lang.Override
  public boolean getShowGroups() {
    return showGroups_;
  }

  public static final int SHOW_INVITED_FIELD_NUMBER = 7;
  private boolean showInvited_ = false;

  /**
   *
   *
   * <pre>
   * Optional. When `true`, also returns memberships associated with
   * [invited][google.chat.v1.Membership.MembershipState.INVITED] members, in
   * addition to other types of memberships. If a
   * filter is set,
   * [invited][google.chat.v1.Membership.MembershipState.INVITED] memberships
   * that don't match the filter criteria aren't returned.
   *
   * Currently requires [user
   * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
   * </pre>
   *
   * <code>bool show_invited = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The showInvited.
   */
  @java.lang.Override
  public boolean getShowInvited() {
    return showInvited_;
  }

  public static final int USE_ADMIN_ACCESS_FIELD_NUMBER = 8;
  private boolean useAdminAccess_ = false;

  /**
   *
   *
   * <pre>
   * Optional. When `true`, the method runs using the user's Google Workspace
   * administrator privileges.
   *
   * The calling user must be a Google Workspace administrator with the
   * [manage chat and spaces conversations
   * privilege](https://support.google.com/a/answer/13369245).
   *
   * Requires either the `chat.admin.memberships.readonly` or
   * `chat.admin.memberships` [OAuth 2.0
   * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
   *
   * Listing app memberships in a space isn't supported when using admin access.
   * </pre>
   *
   * <code>bool use_admin_access = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The useAdminAccess.
   */
  @java.lang.Override
  public boolean getUseAdminAccess() {
    return useAdminAccess_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(2, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, filter_);
    }
    if (showGroups_ != false) {
      output.writeBool(6, showGroups_);
    }
    if (showInvited_ != false) {
      output.writeBool(7, showInvited_);
    }
    if (useAdminAccess_ != false) {
      output.writeBool(8, useAdminAccess_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, filter_);
    }
    if (showGroups_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, showGroups_);
    }
    if (showInvited_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, showInvited_);
    }
    if (useAdminAccess_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, useAdminAccess_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.ListMembershipsRequest)) {
      return super.equals(obj);
    }
    com.google.chat.v1.ListMembershipsRequest other =
        (com.google.chat.v1.ListMembershipsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (getShowGroups() != other.getShowGroups()) return false;
    if (getShowInvited() != other.getShowInvited()) return false;
    if (getUseAdminAccess() != other.getUseAdminAccess()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (37 * hash) + SHOW_GROUPS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getShowGroups());
    hash = (37 * hash) + SHOW_INVITED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getShowInvited());
    hash = (37 * hash) + USE_ADMIN_ACCESS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUseAdminAccess());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.ListMembershipsRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.ListMembershipsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.ListMembershipsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.ListMembershipsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.ListMembershipsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.ListMembershipsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.ListMembershipsRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.ListMembershipsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.ListMembershipsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.ListMembershipsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.ListMembershipsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.ListMembershipsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.ListMembershipsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for listing memberships.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.ListMembershipsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.ListMembershipsRequest)
      com.google.chat.v1.ListMembershipsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.MembershipProto
          .internal_static_google_chat_v1_ListMembershipsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.MembershipProto
          .internal_static_google_chat_v1_ListMembershipsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.ListMembershipsRequest.class,
              com.google.chat.v1.ListMembershipsRequest.Builder.class);
    }

    // Construct using com.google.chat.v1.ListMembershipsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      pageSize_ = 0;
      pageToken_ = "";
      filter_ = "";
      showGroups_ = false;
      showInvited_ = false;
      useAdminAccess_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.MembershipProto
          .internal_static_google_chat_v1_ListMembershipsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.ListMembershipsRequest getDefaultInstanceForType() {
      return com.google.chat.v1.ListMembershipsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.ListMembershipsRequest build() {
      com.google.chat.v1.ListMembershipsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.ListMembershipsRequest buildPartial() {
      com.google.chat.v1.ListMembershipsRequest result =
          new com.google.chat.v1.ListMembershipsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.chat.v1.ListMembershipsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pageToken_ = pageToken_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.showGroups_ = showGroups_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.showInvited_ = showInvited_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.useAdminAccess_ = useAdminAccess_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.ListMembershipsRequest) {
        return mergeFrom((com.google.chat.v1.ListMembershipsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.ListMembershipsRequest other) {
      if (other == com.google.chat.v1.ListMembershipsRequest.getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getShowGroups() != false) {
        setShowGroups(other.getShowGroups());
      }
      if (other.getShowInvited() != false) {
        setShowInvited(other.getShowInvited());
      }
      if (other.getUseAdminAccess() != false) {
        setUseAdminAccess(other.getUseAdminAccess());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 42:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 48:
              {
                showGroups_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            case 56:
              {
                showInvited_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 56
            case 64:
              {
                useAdminAccess_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 64
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. The resource name of the space for which to fetch a membership
     * list.
     *
     * Format: spaces/{space}
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the space for which to fetch a membership
     * list.
     *
     * Format: spaces/{space}
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the space for which to fetch a membership
     * list.
     *
     * Format: spaces/{space}
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the space for which to fetch a membership
     * list.
     *
     * Format: spaces/{space}
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the space for which to fetch a membership
     * list.
     *
     * Format: spaces/{space}
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int pageSize_;

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of memberships to return. The service might
     * return fewer than this value.
     *
     * If unspecified, at most 100 memberships are returned.
     *
     * The maximum value is 1000. If you use a value more than 1000, it's
     * automatically changed to 1000.
     *
     * Negative values return an `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of memberships to return. The service might
     * return fewer than this value.
     *
     * If unspecified, at most 100 memberships are returned.
     *
     * The maximum value is 1000. If you use a value more than 1000, it's
     * automatically changed to 1000.
     *
     * Negative values return an `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of memberships to return. The service might
     * return fewer than this value.
     *
     * If unspecified, at most 100 memberships are returned.
     *
     * The maximum value is 1000. If you use a value more than 1000, it's
     * automatically changed to 1000.
     *
     * Negative values return an `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000002);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";

    /**
     *
     *
     * <pre>
     * Optional. A page token, received from a previous call to list memberships.
     * Provide this parameter to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided should match the call that
     * provided the page token. Passing different values to the other parameters
     * might lead to unexpected results.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A page token, received from a previous call to list memberships.
     * Provide this parameter to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided should match the call that
     * provided the page token. Passing different values to the other parameters
     * might lead to unexpected results.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A page token, received from a previous call to list memberships.
     * Provide this parameter to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided should match the call that
     * provided the page token. Passing different values to the other parameters
     * might lead to unexpected results.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A page token, received from a previous call to list memberships.
     * Provide this parameter to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided should match the call that
     * provided the page token. Passing different values to the other parameters
     * might lead to unexpected results.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A page token, received from a previous call to list memberships.
     * Provide this parameter to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided should match the call that
     * provided the page token. Passing different values to the other parameters
     * might lead to unexpected results.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";

    /**
     *
     *
     * <pre>
     * Optional. A query filter.
     *
     * You can filter memberships by a member's role
     * ([`role`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members#membershiprole))
     * and type
     * ([`member.type`](https://developers.google.com/workspace/chat/api/reference/rest/v1/User#type)).
     *
     * To filter by role, set `role` to `ROLE_MEMBER` or `ROLE_MANAGER`.
     *
     * To filter by type, set `member.type` to `HUMAN` or `BOT`. You can also
     * filter for `member.type` using the `!=` operator.
     *
     * To filter by both role and type, use the `AND` operator. To filter by
     * either role or type, use the `OR` operator.
     *
     * Either `member.type = "HUMAN"` or `member.type != "BOT"` is required
     * when `use_admin_access` is set to true. Other member type filters will be
     * rejected.
     *
     * For example, the following queries are valid:
     *
     * ```
     * role = "ROLE_MANAGER" OR role = "ROLE_MEMBER"
     * member.type = "HUMAN" AND role = "ROLE_MANAGER"
     *
     * member.type != "BOT"
     * ```
     *
     * The following queries are invalid:
     *
     * ```
     * member.type = "HUMAN" AND member.type = "BOT"
     * role = "ROLE_MANAGER" AND role = "ROLE_MEMBER"
     * ```
     *
     * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
     * error.
     * </pre>
     *
     * <code>string filter = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A query filter.
     *
     * You can filter memberships by a member's role
     * ([`role`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members#membershiprole))
     * and type
     * ([`member.type`](https://developers.google.com/workspace/chat/api/reference/rest/v1/User#type)).
     *
     * To filter by role, set `role` to `ROLE_MEMBER` or `ROLE_MANAGER`.
     *
     * To filter by type, set `member.type` to `HUMAN` or `BOT`. You can also
     * filter for `member.type` using the `!=` operator.
     *
     * To filter by both role and type, use the `AND` operator. To filter by
     * either role or type, use the `OR` operator.
     *
     * Either `member.type = "HUMAN"` or `member.type != "BOT"` is required
     * when `use_admin_access` is set to true. Other member type filters will be
     * rejected.
     *
     * For example, the following queries are valid:
     *
     * ```
     * role = "ROLE_MANAGER" OR role = "ROLE_MEMBER"
     * member.type = "HUMAN" AND role = "ROLE_MANAGER"
     *
     * member.type != "BOT"
     * ```
     *
     * The following queries are invalid:
     *
     * ```
     * member.type = "HUMAN" AND member.type = "BOT"
     * role = "ROLE_MANAGER" AND role = "ROLE_MEMBER"
     * ```
     *
     * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
     * error.
     * </pre>
     *
     * <code>string filter = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A query filter.
     *
     * You can filter memberships by a member's role
     * ([`role`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members#membershiprole))
     * and type
     * ([`member.type`](https://developers.google.com/workspace/chat/api/reference/rest/v1/User#type)).
     *
     * To filter by role, set `role` to `ROLE_MEMBER` or `ROLE_MANAGER`.
     *
     * To filter by type, set `member.type` to `HUMAN` or `BOT`. You can also
     * filter for `member.type` using the `!=` operator.
     *
     * To filter by both role and type, use the `AND` operator. To filter by
     * either role or type, use the `OR` operator.
     *
     * Either `member.type = "HUMAN"` or `member.type != "BOT"` is required
     * when `use_admin_access` is set to true. Other member type filters will be
     * rejected.
     *
     * For example, the following queries are valid:
     *
     * ```
     * role = "ROLE_MANAGER" OR role = "ROLE_MEMBER"
     * member.type = "HUMAN" AND role = "ROLE_MANAGER"
     *
     * member.type != "BOT"
     * ```
     *
     * The following queries are invalid:
     *
     * ```
     * member.type = "HUMAN" AND member.type = "BOT"
     * role = "ROLE_MANAGER" AND role = "ROLE_MEMBER"
     * ```
     *
     * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
     * error.
     * </pre>
     *
     * <code>string filter = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A query filter.
     *
     * You can filter memberships by a member's role
     * ([`role`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members#membershiprole))
     * and type
     * ([`member.type`](https://developers.google.com/workspace/chat/api/reference/rest/v1/User#type)).
     *
     * To filter by role, set `role` to `ROLE_MEMBER` or `ROLE_MANAGER`.
     *
     * To filter by type, set `member.type` to `HUMAN` or `BOT`. You can also
     * filter for `member.type` using the `!=` operator.
     *
     * To filter by both role and type, use the `AND` operator. To filter by
     * either role or type, use the `OR` operator.
     *
     * Either `member.type = "HUMAN"` or `member.type != "BOT"` is required
     * when `use_admin_access` is set to true. Other member type filters will be
     * rejected.
     *
     * For example, the following queries are valid:
     *
     * ```
     * role = "ROLE_MANAGER" OR role = "ROLE_MEMBER"
     * member.type = "HUMAN" AND role = "ROLE_MANAGER"
     *
     * member.type != "BOT"
     * ```
     *
     * The following queries are invalid:
     *
     * ```
     * member.type = "HUMAN" AND member.type = "BOT"
     * role = "ROLE_MANAGER" AND role = "ROLE_MEMBER"
     * ```
     *
     * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
     * error.
     * </pre>
     *
     * <code>string filter = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A query filter.
     *
     * You can filter memberships by a member's role
     * ([`role`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members#membershiprole))
     * and type
     * ([`member.type`](https://developers.google.com/workspace/chat/api/reference/rest/v1/User#type)).
     *
     * To filter by role, set `role` to `ROLE_MEMBER` or `ROLE_MANAGER`.
     *
     * To filter by type, set `member.type` to `HUMAN` or `BOT`. You can also
     * filter for `member.type` using the `!=` operator.
     *
     * To filter by both role and type, use the `AND` operator. To filter by
     * either role or type, use the `OR` operator.
     *
     * Either `member.type = "HUMAN"` or `member.type != "BOT"` is required
     * when `use_admin_access` is set to true. Other member type filters will be
     * rejected.
     *
     * For example, the following queries are valid:
     *
     * ```
     * role = "ROLE_MANAGER" OR role = "ROLE_MEMBER"
     * member.type = "HUMAN" AND role = "ROLE_MANAGER"
     *
     * member.type != "BOT"
     * ```
     *
     * The following queries are invalid:
     *
     * ```
     * member.type = "HUMAN" AND member.type = "BOT"
     * role = "ROLE_MANAGER" AND role = "ROLE_MEMBER"
     * ```
     *
     * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
     * error.
     * </pre>
     *
     * <code>string filter = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean showGroups_;

    /**
     *
     *
     * <pre>
     * Optional. When `true`, also returns memberships associated with a
     * [Google Group][google.chat.v1.Membership.group_member], in
     * addition to other types of memberships. If a
     * [filter][google.chat.v1.ListMembershipsRequest.filter] is set,
     * [Google Group][google.chat.v1.Membership.group_member]
     * memberships that don't match the filter criteria aren't returned.
     * </pre>
     *
     * <code>bool show_groups = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The showGroups.
     */
    @java.lang.Override
    public boolean getShowGroups() {
      return showGroups_;
    }

    /**
     *
     *
     * <pre>
     * Optional. When `true`, also returns memberships associated with a
     * [Google Group][google.chat.v1.Membership.group_member], in
     * addition to other types of memberships. If a
     * [filter][google.chat.v1.ListMembershipsRequest.filter] is set,
     * [Google Group][google.chat.v1.Membership.group_member]
     * memberships that don't match the filter criteria aren't returned.
     * </pre>
     *
     * <code>bool show_groups = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The showGroups to set.
     * @return This builder for chaining.
     */
    public Builder setShowGroups(boolean value) {

      showGroups_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. When `true`, also returns memberships associated with a
     * [Google Group][google.chat.v1.Membership.group_member], in
     * addition to other types of memberships. If a
     * [filter][google.chat.v1.ListMembershipsRequest.filter] is set,
     * [Google Group][google.chat.v1.Membership.group_member]
     * memberships that don't match the filter criteria aren't returned.
     * </pre>
     *
     * <code>bool show_groups = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearShowGroups() {
      bitField0_ = (bitField0_ & ~0x00000010);
      showGroups_ = false;
      onChanged();
      return this;
    }

    private boolean showInvited_;

    /**
     *
     *
     * <pre>
     * Optional. When `true`, also returns memberships associated with
     * [invited][google.chat.v1.Membership.MembershipState.INVITED] members, in
     * addition to other types of memberships. If a
     * filter is set,
     * [invited][google.chat.v1.Membership.MembershipState.INVITED] memberships
     * that don't match the filter criteria aren't returned.
     *
     * Currently requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     * </pre>
     *
     * <code>bool show_invited = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The showInvited.
     */
    @java.lang.Override
    public boolean getShowInvited() {
      return showInvited_;
    }

    /**
     *
     *
     * <pre>
     * Optional. When `true`, also returns memberships associated with
     * [invited][google.chat.v1.Membership.MembershipState.INVITED] members, in
     * addition to other types of memberships. If a
     * filter is set,
     * [invited][google.chat.v1.Membership.MembershipState.INVITED] memberships
     * that don't match the filter criteria aren't returned.
     *
     * Currently requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     * </pre>
     *
     * <code>bool show_invited = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The showInvited to set.
     * @return This builder for chaining.
     */
    public Builder setShowInvited(boolean value) {

      showInvited_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. When `true`, also returns memberships associated with
     * [invited][google.chat.v1.Membership.MembershipState.INVITED] members, in
     * addition to other types of memberships. If a
     * filter is set,
     * [invited][google.chat.v1.Membership.MembershipState.INVITED] memberships
     * that don't match the filter criteria aren't returned.
     *
     * Currently requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     * </pre>
     *
     * <code>bool show_invited = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearShowInvited() {
      bitField0_ = (bitField0_ & ~0x00000020);
      showInvited_ = false;
      onChanged();
      return this;
    }

    private boolean useAdminAccess_;

    /**
     *
     *
     * <pre>
     * Optional. When `true`, the method runs using the user's Google Workspace
     * administrator privileges.
     *
     * The calling user must be a Google Workspace administrator with the
     * [manage chat and spaces conversations
     * privilege](https://support.google.com/a/answer/13369245).
     *
     * Requires either the `chat.admin.memberships.readonly` or
     * `chat.admin.memberships` [OAuth 2.0
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
     *
     * Listing app memberships in a space isn't supported when using admin access.
     * </pre>
     *
     * <code>bool use_admin_access = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The useAdminAccess.
     */
    @java.lang.Override
    public boolean getUseAdminAccess() {
      return useAdminAccess_;
    }

    /**
     *
     *
     * <pre>
     * Optional. When `true`, the method runs using the user's Google Workspace
     * administrator privileges.
     *
     * The calling user must be a Google Workspace administrator with the
     * [manage chat and spaces conversations
     * privilege](https://support.google.com/a/answer/13369245).
     *
     * Requires either the `chat.admin.memberships.readonly` or
     * `chat.admin.memberships` [OAuth 2.0
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
     *
     * Listing app memberships in a space isn't supported when using admin access.
     * </pre>
     *
     * <code>bool use_admin_access = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The useAdminAccess to set.
     * @return This builder for chaining.
     */
    public Builder setUseAdminAccess(boolean value) {

      useAdminAccess_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. When `true`, the method runs using the user's Google Workspace
     * administrator privileges.
     *
     * The calling user must be a Google Workspace administrator with the
     * [manage chat and spaces conversations
     * privilege](https://support.google.com/a/answer/13369245).
     *
     * Requires either the `chat.admin.memberships.readonly` or
     * `chat.admin.memberships` [OAuth 2.0
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
     *
     * Listing app memberships in a space isn't supported when using admin access.
     * </pre>
     *
     * <code>bool use_admin_access = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUseAdminAccess() {
      bitField0_ = (bitField0_ & ~0x00000040);
      useAdminAccess_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.ListMembershipsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.ListMembershipsRequest)
  private static final com.google.chat.v1.ListMembershipsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.ListMembershipsRequest();
  }

  public static com.google.chat.v1.ListMembershipsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListMembershipsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListMembershipsRequest>() {
        @java.lang.Override
        public ListMembershipsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListMembershipsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListMembershipsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.ListMembershipsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
