/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/message.proto

// Protobuf Java Version: 3.25.5
package com.google.chat.v1;

public interface ListMessagesRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.chat.v1.ListMessagesRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The resource name of the space to list messages from.
   *
   * Format: `spaces/{space}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();

  /**
   *
   *
   * <pre>
   * Required. The resource name of the space to list messages from.
   *
   * Format: `spaces/{space}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Optional. The maximum number of messages returned. The service might return
   * fewer messages than this value.
   *
   * If unspecified, at most 25 are returned.
   *
   * The maximum value is 1000. If you use a value more than 1000, it's
   * automatically changed to 1000.
   *
   * Negative values return an `INVALID_ARGUMENT` error.
   * </pre>
   *
   * <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageSize.
   */
  int getPageSize();

  /**
   *
   *
   * <pre>
   * Optional. A page token received from a previous list messages call. Provide
   * this parameter to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided should match the call that
   * provided the page token. Passing different values to the other parameters
   * might lead to unexpected results.
   * </pre>
   *
   * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageToken.
   */
  java.lang.String getPageToken();

  /**
   *
   *
   * <pre>
   * Optional. A page token received from a previous list messages call. Provide
   * this parameter to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided should match the call that
   * provided the page token. Passing different values to the other parameters
   * might lead to unexpected results.
   * </pre>
   *
   * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for pageToken.
   */
  com.google.protobuf.ByteString getPageTokenBytes();

  /**
   *
   *
   * <pre>
   * Optional. A query filter.
   *
   * You can filter messages by date (`create_time`) and thread (`thread.name`).
   *
   * To filter messages by the date they were created, specify the `create_time`
   * with a timestamp in [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339)
   * format and double quotation marks. For example,
   * `"2023-04-21T11:30:00-04:00"`. You can use the greater than operator `&gt;` to
   * list messages that were created after a timestamp, or the less than
   * operator `&lt;` to list messages that were created before a timestamp. To
   * filter messages within a time interval, use the `AND` operator between two
   * timestamps.
   *
   * To filter by thread, specify the `thread.name`, formatted as
   * `spaces/{space}/threads/{thread}`. You can only specify one
   * `thread.name` per query.
   *
   * To filter by both thread and date, use the `AND` operator in your query.
   *
   * For example, the following queries are valid:
   *
   * ```
   * create_time &gt; "2012-04-21T11:30:00-04:00"
   *
   * create_time &gt; "2012-04-21T11:30:00-04:00" AND
   *   thread.name = spaces/AAAAAAAAAAA/threads/123
   *
   * create_time &gt; "2012-04-21T11:30:00+00:00" AND
   *
   * create_time &lt; "2013-01-01T00:00:00+00:00" AND
   *   thread.name = spaces/AAAAAAAAAAA/threads/123
   *
   * thread.name = spaces/AAAAAAAAAAA/threads/123
   * ```
   *
   * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
   * error.
   * </pre>
   *
   * <code>string filter = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The filter.
   */
  java.lang.String getFilter();

  /**
   *
   *
   * <pre>
   * Optional. A query filter.
   *
   * You can filter messages by date (`create_time`) and thread (`thread.name`).
   *
   * To filter messages by the date they were created, specify the `create_time`
   * with a timestamp in [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339)
   * format and double quotation marks. For example,
   * `"2023-04-21T11:30:00-04:00"`. You can use the greater than operator `&gt;` to
   * list messages that were created after a timestamp, or the less than
   * operator `&lt;` to list messages that were created before a timestamp. To
   * filter messages within a time interval, use the `AND` operator between two
   * timestamps.
   *
   * To filter by thread, specify the `thread.name`, formatted as
   * `spaces/{space}/threads/{thread}`. You can only specify one
   * `thread.name` per query.
   *
   * To filter by both thread and date, use the `AND` operator in your query.
   *
   * For example, the following queries are valid:
   *
   * ```
   * create_time &gt; "2012-04-21T11:30:00-04:00"
   *
   * create_time &gt; "2012-04-21T11:30:00-04:00" AND
   *   thread.name = spaces/AAAAAAAAAAA/threads/123
   *
   * create_time &gt; "2012-04-21T11:30:00+00:00" AND
   *
   * create_time &lt; "2013-01-01T00:00:00+00:00" AND
   *   thread.name = spaces/AAAAAAAAAAA/threads/123
   *
   * thread.name = spaces/AAAAAAAAAAA/threads/123
   * ```
   *
   * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
   * error.
   * </pre>
   *
   * <code>string filter = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for filter.
   */
  com.google.protobuf.ByteString getFilterBytes();

  /**
   *
   *
   * <pre>
   * Optional. How the list of messages is ordered. Specify a value to order by
   * an ordering operation. Valid ordering operation values are as follows:
   *
   * - `ASC` for ascending.
   *
   * - `DESC` for descending.
   *
   * The default ordering is `create_time ASC`.
   * </pre>
   *
   * <code>string order_by = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The orderBy.
   */
  java.lang.String getOrderBy();

  /**
   *
   *
   * <pre>
   * Optional. How the list of messages is ordered. Specify a value to order by
   * an ordering operation. Valid ordering operation values are as follows:
   *
   * - `ASC` for ascending.
   *
   * - `DESC` for descending.
   *
   * The default ordering is `create_time ASC`.
   * </pre>
   *
   * <code>string order_by = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for orderBy.
   */
  com.google.protobuf.ByteString getOrderByBytes();

  /**
   *
   *
   * <pre>
   * Optional. Whether to include deleted messages. Deleted messages include
   * deleted time and metadata about their deletion, but message content is
   * unavailable.
   * </pre>
   *
   * <code>bool show_deleted = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The showDeleted.
   */
  boolean getShowDeleted();
}
