/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/space_event.proto

// Protobuf Java Version: 3.25.5
package com.google.chat.v1;

/**
 *
 *
 * <pre>
 * Request message for listing space events.
 * </pre>
 *
 * Protobuf type {@code google.chat.v1.ListSpaceEventsRequest}
 */
public final class ListSpaceEventsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.ListSpaceEventsRequest)
    ListSpaceEventsRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ListSpaceEventsRequest.newBuilder() to construct.
  private ListSpaceEventsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListSpaceEventsRequest() {
    parent_ = "";
    pageToken_ = "";
    filter_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListSpaceEventsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.SpaceEventProto
        .internal_static_google_chat_v1_ListSpaceEventsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.SpaceEventProto
        .internal_static_google_chat_v1_ListSpaceEventsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.ListSpaceEventsRequest.class,
            com.google.chat.v1.ListSpaceEventsRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. Resource name of the [Google Chat
   * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
   * where the events occurred.
   *
   * Format: `spaces/{space}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Resource name of the [Google Chat
   * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
   * where the events occurred.
   *
   * Format: `spaces/{space}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 5;
  private int pageSize_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. The maximum number of space events returned. The service might
   * return fewer than this value.
   *
   * Negative values return an `INVALID_ARGUMENT` error.
   * </pre>
   *
   * <code>int32 page_size = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";

  /**
   *
   *
   * <pre>
   * Optional. A page token, received from a previous list space events call.
   * Provide this to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided to list space events must
   * match the call that provided the page token. Passing different values to
   * the other parameters might lead to unexpected results.
   * </pre>
   *
   * <code>string page_token = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. A page token, received from a previous list space events call.
   * Provide this to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided to list space events must
   * match the call that provided the page token. Passing different values to
   * the other parameters might lead to unexpected results.
   * </pre>
   *
   * <code>string page_token = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";

  /**
   *
   *
   * <pre>
   * Required. A query filter.
   *
   * You must specify at least one event type (`event_type`)
   * using the has `:` operator. To filter by multiple event types, use the `OR`
   * operator. Omit batch event types in your filter. The request automatically
   * returns any related batch events. For example, if you filter by new
   * reactions
   * (`google.workspace.chat.reaction.v1.created`), the server also returns
   * batch new reactions events
   * (`google.workspace.chat.reaction.v1.batchCreated`). For a list of supported
   * event types, see the [`SpaceEvents` reference
   * documentation](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.spaceEvents#SpaceEvent.FIELDS.event_type).
   *
   * Optionally, you can also filter by start time (`start_time`) and
   * end time (`end_time`):
   *
   * * `start_time`: Exclusive timestamp from which to start listing space
   * events.
   *  You can list events that occurred up to 28 days ago. If unspecified, lists
   *  space events from the past 28 days.
   * * `end_time`: Inclusive timestamp until which space events are listed.
   *  If unspecified, lists events up to the time of the request.
   *
   * To specify a start or end time, use the equals `=` operator and format in
   * [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339). To filter by both
   * `start_time` and `end_time`, use the `AND` operator.
   *
   * For example, the following queries are valid:
   *
   * ```
   * start_time="2023-08-23T19:20:33+00:00" AND
   * end_time="2023-08-23T19:21:54+00:00"
   * ```
   * ```
   * start_time="2023-08-23T19:20:33+00:00" AND
   * (event_types:"google.workspace.chat.space.v1.updated" OR
   * event_types:"google.workspace.chat.message.v1.created")
   * ```
   *
   * The following queries are invalid:
   *
   * ```
   * start_time="2023-08-23T19:20:33+00:00" OR
   * end_time="2023-08-23T19:21:54+00:00"
   * ```
   * ```
   * event_types:"google.workspace.chat.space.v1.updated" AND
   * event_types:"google.workspace.chat.message.v1.created"
   * ```
   *
   * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
   * error.
   * </pre>
   *
   * <code>string filter = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. A query filter.
   *
   * You must specify at least one event type (`event_type`)
   * using the has `:` operator. To filter by multiple event types, use the `OR`
   * operator. Omit batch event types in your filter. The request automatically
   * returns any related batch events. For example, if you filter by new
   * reactions
   * (`google.workspace.chat.reaction.v1.created`), the server also returns
   * batch new reactions events
   * (`google.workspace.chat.reaction.v1.batchCreated`). For a list of supported
   * event types, see the [`SpaceEvents` reference
   * documentation](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.spaceEvents#SpaceEvent.FIELDS.event_type).
   *
   * Optionally, you can also filter by start time (`start_time`) and
   * end time (`end_time`):
   *
   * * `start_time`: Exclusive timestamp from which to start listing space
   * events.
   *  You can list events that occurred up to 28 days ago. If unspecified, lists
   *  space events from the past 28 days.
   * * `end_time`: Inclusive timestamp until which space events are listed.
   *  If unspecified, lists events up to the time of the request.
   *
   * To specify a start or end time, use the equals `=` operator and format in
   * [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339). To filter by both
   * `start_time` and `end_time`, use the `AND` operator.
   *
   * For example, the following queries are valid:
   *
   * ```
   * start_time="2023-08-23T19:20:33+00:00" AND
   * end_time="2023-08-23T19:21:54+00:00"
   * ```
   * ```
   * start_time="2023-08-23T19:20:33+00:00" AND
   * (event_types:"google.workspace.chat.space.v1.updated" OR
   * event_types:"google.workspace.chat.message.v1.created")
   * ```
   *
   * The following queries are invalid:
   *
   * ```
   * start_time="2023-08-23T19:20:33+00:00" OR
   * end_time="2023-08-23T19:21:54+00:00"
   * ```
   * ```
   * event_types:"google.workspace.chat.space.v1.updated" AND
   * event_types:"google.workspace.chat.message.v1.created"
   * ```
   *
   * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
   * error.
   * </pre>
   *
   * <code>string filter = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(5, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, filter_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, filter_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.ListSpaceEventsRequest)) {
      return super.equals(obj);
    }
    com.google.chat.v1.ListSpaceEventsRequest other =
        (com.google.chat.v1.ListSpaceEventsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.ListSpaceEventsRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.ListSpaceEventsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.ListSpaceEventsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.ListSpaceEventsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.ListSpaceEventsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.ListSpaceEventsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.ListSpaceEventsRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.ListSpaceEventsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.ListSpaceEventsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.ListSpaceEventsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.ListSpaceEventsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.ListSpaceEventsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.ListSpaceEventsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for listing space events.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.ListSpaceEventsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.ListSpaceEventsRequest)
      com.google.chat.v1.ListSpaceEventsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.SpaceEventProto
          .internal_static_google_chat_v1_ListSpaceEventsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.SpaceEventProto
          .internal_static_google_chat_v1_ListSpaceEventsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.ListSpaceEventsRequest.class,
              com.google.chat.v1.ListSpaceEventsRequest.Builder.class);
    }

    // Construct using com.google.chat.v1.ListSpaceEventsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      pageSize_ = 0;
      pageToken_ = "";
      filter_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.SpaceEventProto
          .internal_static_google_chat_v1_ListSpaceEventsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.ListSpaceEventsRequest getDefaultInstanceForType() {
      return com.google.chat.v1.ListSpaceEventsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.ListSpaceEventsRequest build() {
      com.google.chat.v1.ListSpaceEventsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.ListSpaceEventsRequest buildPartial() {
      com.google.chat.v1.ListSpaceEventsRequest result =
          new com.google.chat.v1.ListSpaceEventsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.chat.v1.ListSpaceEventsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pageToken_ = pageToken_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.filter_ = filter_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.ListSpaceEventsRequest) {
        return mergeFrom((com.google.chat.v1.ListSpaceEventsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.ListSpaceEventsRequest other) {
      if (other == com.google.chat.v1.ListSpaceEventsRequest.getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 40:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 40
            case 50:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 50
            case 66:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. Resource name of the [Google Chat
     * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
     * where the events occurred.
     *
     * Format: `spaces/{space}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Resource name of the [Google Chat
     * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
     * where the events occurred.
     *
     * Format: `spaces/{space}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Resource name of the [Google Chat
     * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
     * where the events occurred.
     *
     * Format: `spaces/{space}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Resource name of the [Google Chat
     * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
     * where the events occurred.
     *
     * Format: `spaces/{space}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Resource name of the [Google Chat
     * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
     * where the events occurred.
     *
     * Format: `spaces/{space}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int pageSize_;

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of space events returned. The service might
     * return fewer than this value.
     *
     * Negative values return an `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>int32 page_size = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of space events returned. The service might
     * return fewer than this value.
     *
     * Negative values return an `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>int32 page_size = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of space events returned. The service might
     * return fewer than this value.
     *
     * Negative values return an `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>int32 page_size = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000002);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";

    /**
     *
     *
     * <pre>
     * Optional. A page token, received from a previous list space events call.
     * Provide this to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided to list space events must
     * match the call that provided the page token. Passing different values to
     * the other parameters might lead to unexpected results.
     * </pre>
     *
     * <code>string page_token = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A page token, received from a previous list space events call.
     * Provide this to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided to list space events must
     * match the call that provided the page token. Passing different values to
     * the other parameters might lead to unexpected results.
     * </pre>
     *
     * <code>string page_token = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A page token, received from a previous list space events call.
     * Provide this to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided to list space events must
     * match the call that provided the page token. Passing different values to
     * the other parameters might lead to unexpected results.
     * </pre>
     *
     * <code>string page_token = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A page token, received from a previous list space events call.
     * Provide this to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided to list space events must
     * match the call that provided the page token. Passing different values to
     * the other parameters might lead to unexpected results.
     * </pre>
     *
     * <code>string page_token = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A page token, received from a previous list space events call.
     * Provide this to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided to list space events must
     * match the call that provided the page token. Passing different values to
     * the other parameters might lead to unexpected results.
     * </pre>
     *
     * <code>string page_token = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";

    /**
     *
     *
     * <pre>
     * Required. A query filter.
     *
     * You must specify at least one event type (`event_type`)
     * using the has `:` operator. To filter by multiple event types, use the `OR`
     * operator. Omit batch event types in your filter. The request automatically
     * returns any related batch events. For example, if you filter by new
     * reactions
     * (`google.workspace.chat.reaction.v1.created`), the server also returns
     * batch new reactions events
     * (`google.workspace.chat.reaction.v1.batchCreated`). For a list of supported
     * event types, see the [`SpaceEvents` reference
     * documentation](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.spaceEvents#SpaceEvent.FIELDS.event_type).
     *
     * Optionally, you can also filter by start time (`start_time`) and
     * end time (`end_time`):
     *
     * * `start_time`: Exclusive timestamp from which to start listing space
     * events.
     *  You can list events that occurred up to 28 days ago. If unspecified, lists
     *  space events from the past 28 days.
     * * `end_time`: Inclusive timestamp until which space events are listed.
     *  If unspecified, lists events up to the time of the request.
     *
     * To specify a start or end time, use the equals `=` operator and format in
     * [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339). To filter by both
     * `start_time` and `end_time`, use the `AND` operator.
     *
     * For example, the following queries are valid:
     *
     * ```
     * start_time="2023-08-23T19:20:33+00:00" AND
     * end_time="2023-08-23T19:21:54+00:00"
     * ```
     * ```
     * start_time="2023-08-23T19:20:33+00:00" AND
     * (event_types:"google.workspace.chat.space.v1.updated" OR
     * event_types:"google.workspace.chat.message.v1.created")
     * ```
     *
     * The following queries are invalid:
     *
     * ```
     * start_time="2023-08-23T19:20:33+00:00" OR
     * end_time="2023-08-23T19:21:54+00:00"
     * ```
     * ```
     * event_types:"google.workspace.chat.space.v1.updated" AND
     * event_types:"google.workspace.chat.message.v1.created"
     * ```
     *
     * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
     * error.
     * </pre>
     *
     * <code>string filter = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. A query filter.
     *
     * You must specify at least one event type (`event_type`)
     * using the has `:` operator. To filter by multiple event types, use the `OR`
     * operator. Omit batch event types in your filter. The request automatically
     * returns any related batch events. For example, if you filter by new
     * reactions
     * (`google.workspace.chat.reaction.v1.created`), the server also returns
     * batch new reactions events
     * (`google.workspace.chat.reaction.v1.batchCreated`). For a list of supported
     * event types, see the [`SpaceEvents` reference
     * documentation](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.spaceEvents#SpaceEvent.FIELDS.event_type).
     *
     * Optionally, you can also filter by start time (`start_time`) and
     * end time (`end_time`):
     *
     * * `start_time`: Exclusive timestamp from which to start listing space
     * events.
     *  You can list events that occurred up to 28 days ago. If unspecified, lists
     *  space events from the past 28 days.
     * * `end_time`: Inclusive timestamp until which space events are listed.
     *  If unspecified, lists events up to the time of the request.
     *
     * To specify a start or end time, use the equals `=` operator and format in
     * [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339). To filter by both
     * `start_time` and `end_time`, use the `AND` operator.
     *
     * For example, the following queries are valid:
     *
     * ```
     * start_time="2023-08-23T19:20:33+00:00" AND
     * end_time="2023-08-23T19:21:54+00:00"
     * ```
     * ```
     * start_time="2023-08-23T19:20:33+00:00" AND
     * (event_types:"google.workspace.chat.space.v1.updated" OR
     * event_types:"google.workspace.chat.message.v1.created")
     * ```
     *
     * The following queries are invalid:
     *
     * ```
     * start_time="2023-08-23T19:20:33+00:00" OR
     * end_time="2023-08-23T19:21:54+00:00"
     * ```
     * ```
     * event_types:"google.workspace.chat.space.v1.updated" AND
     * event_types:"google.workspace.chat.message.v1.created"
     * ```
     *
     * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
     * error.
     * </pre>
     *
     * <code>string filter = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. A query filter.
     *
     * You must specify at least one event type (`event_type`)
     * using the has `:` operator. To filter by multiple event types, use the `OR`
     * operator. Omit batch event types in your filter. The request automatically
     * returns any related batch events. For example, if you filter by new
     * reactions
     * (`google.workspace.chat.reaction.v1.created`), the server also returns
     * batch new reactions events
     * (`google.workspace.chat.reaction.v1.batchCreated`). For a list of supported
     * event types, see the [`SpaceEvents` reference
     * documentation](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.spaceEvents#SpaceEvent.FIELDS.event_type).
     *
     * Optionally, you can also filter by start time (`start_time`) and
     * end time (`end_time`):
     *
     * * `start_time`: Exclusive timestamp from which to start listing space
     * events.
     *  You can list events that occurred up to 28 days ago. If unspecified, lists
     *  space events from the past 28 days.
     * * `end_time`: Inclusive timestamp until which space events are listed.
     *  If unspecified, lists events up to the time of the request.
     *
     * To specify a start or end time, use the equals `=` operator and format in
     * [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339). To filter by both
     * `start_time` and `end_time`, use the `AND` operator.
     *
     * For example, the following queries are valid:
     *
     * ```
     * start_time="2023-08-23T19:20:33+00:00" AND
     * end_time="2023-08-23T19:21:54+00:00"
     * ```
     * ```
     * start_time="2023-08-23T19:20:33+00:00" AND
     * (event_types:"google.workspace.chat.space.v1.updated" OR
     * event_types:"google.workspace.chat.message.v1.created")
     * ```
     *
     * The following queries are invalid:
     *
     * ```
     * start_time="2023-08-23T19:20:33+00:00" OR
     * end_time="2023-08-23T19:21:54+00:00"
     * ```
     * ```
     * event_types:"google.workspace.chat.space.v1.updated" AND
     * event_types:"google.workspace.chat.message.v1.created"
     * ```
     *
     * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
     * error.
     * </pre>
     *
     * <code>string filter = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A query filter.
     *
     * You must specify at least one event type (`event_type`)
     * using the has `:` operator. To filter by multiple event types, use the `OR`
     * operator. Omit batch event types in your filter. The request automatically
     * returns any related batch events. For example, if you filter by new
     * reactions
     * (`google.workspace.chat.reaction.v1.created`), the server also returns
     * batch new reactions events
     * (`google.workspace.chat.reaction.v1.batchCreated`). For a list of supported
     * event types, see the [`SpaceEvents` reference
     * documentation](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.spaceEvents#SpaceEvent.FIELDS.event_type).
     *
     * Optionally, you can also filter by start time (`start_time`) and
     * end time (`end_time`):
     *
     * * `start_time`: Exclusive timestamp from which to start listing space
     * events.
     *  You can list events that occurred up to 28 days ago. If unspecified, lists
     *  space events from the past 28 days.
     * * `end_time`: Inclusive timestamp until which space events are listed.
     *  If unspecified, lists events up to the time of the request.
     *
     * To specify a start or end time, use the equals `=` operator and format in
     * [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339). To filter by both
     * `start_time` and `end_time`, use the `AND` operator.
     *
     * For example, the following queries are valid:
     *
     * ```
     * start_time="2023-08-23T19:20:33+00:00" AND
     * end_time="2023-08-23T19:21:54+00:00"
     * ```
     * ```
     * start_time="2023-08-23T19:20:33+00:00" AND
     * (event_types:"google.workspace.chat.space.v1.updated" OR
     * event_types:"google.workspace.chat.message.v1.created")
     * ```
     *
     * The following queries are invalid:
     *
     * ```
     * start_time="2023-08-23T19:20:33+00:00" OR
     * end_time="2023-08-23T19:21:54+00:00"
     * ```
     * ```
     * event_types:"google.workspace.chat.space.v1.updated" AND
     * event_types:"google.workspace.chat.message.v1.created"
     * ```
     *
     * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
     * error.
     * </pre>
     *
     * <code>string filter = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A query filter.
     *
     * You must specify at least one event type (`event_type`)
     * using the has `:` operator. To filter by multiple event types, use the `OR`
     * operator. Omit batch event types in your filter. The request automatically
     * returns any related batch events. For example, if you filter by new
     * reactions
     * (`google.workspace.chat.reaction.v1.created`), the server also returns
     * batch new reactions events
     * (`google.workspace.chat.reaction.v1.batchCreated`). For a list of supported
     * event types, see the [`SpaceEvents` reference
     * documentation](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.spaceEvents#SpaceEvent.FIELDS.event_type).
     *
     * Optionally, you can also filter by start time (`start_time`) and
     * end time (`end_time`):
     *
     * * `start_time`: Exclusive timestamp from which to start listing space
     * events.
     *  You can list events that occurred up to 28 days ago. If unspecified, lists
     *  space events from the past 28 days.
     * * `end_time`: Inclusive timestamp until which space events are listed.
     *  If unspecified, lists events up to the time of the request.
     *
     * To specify a start or end time, use the equals `=` operator and format in
     * [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339). To filter by both
     * `start_time` and `end_time`, use the `AND` operator.
     *
     * For example, the following queries are valid:
     *
     * ```
     * start_time="2023-08-23T19:20:33+00:00" AND
     * end_time="2023-08-23T19:21:54+00:00"
     * ```
     * ```
     * start_time="2023-08-23T19:20:33+00:00" AND
     * (event_types:"google.workspace.chat.space.v1.updated" OR
     * event_types:"google.workspace.chat.message.v1.created")
     * ```
     *
     * The following queries are invalid:
     *
     * ```
     * start_time="2023-08-23T19:20:33+00:00" OR
     * end_time="2023-08-23T19:21:54+00:00"
     * ```
     * ```
     * event_types:"google.workspace.chat.space.v1.updated" AND
     * event_types:"google.workspace.chat.message.v1.created"
     * ```
     *
     * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
     * error.
     * </pre>
     *
     * <code>string filter = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.ListSpaceEventsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.ListSpaceEventsRequest)
  private static final com.google.chat.v1.ListSpaceEventsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.ListSpaceEventsRequest();
  }

  public static com.google.chat.v1.ListSpaceEventsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListSpaceEventsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListSpaceEventsRequest>() {
        @java.lang.Override
        public ListSpaceEventsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListSpaceEventsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListSpaceEventsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.ListSpaceEventsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
