/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/membership.proto

// Protobuf Java Version: 3.25.5
package com.google.chat.v1;

/**
 *
 *
 * <pre>
 * Represents a membership relation in Google Chat, such as whether a user or
 * Chat app is invited to, part of, or absent from a space.
 * </pre>
 *
 * Protobuf type {@code google.chat.v1.Membership}
 */
public final class Membership extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.Membership)
    MembershipOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Membership.newBuilder() to construct.
  private Membership(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Membership() {
    name_ = "";
    state_ = 0;
    role_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Membership();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.MembershipProto.internal_static_google_chat_v1_Membership_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.MembershipProto
        .internal_static_google_chat_v1_Membership_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.Membership.class, com.google.chat.v1.Membership.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies the member's relationship with a space. Other membership states
   * might be supported in the future.
   * </pre>
   *
   * Protobuf enum {@code google.chat.v1.Membership.MembershipState}
   */
  public enum MembershipState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. Don't use.
     * </pre>
     *
     * <code>MEMBERSHIP_STATE_UNSPECIFIED = 0;</code>
     */
    MEMBERSHIP_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The user is added to the space, and can participate in the space.
     * </pre>
     *
     * <code>JOINED = 1;</code>
     */
    JOINED(1),
    /**
     *
     *
     * <pre>
     * The user is invited to join the space, but hasn't joined it.
     * </pre>
     *
     * <code>INVITED = 2;</code>
     */
    INVITED(2),
    /**
     *
     *
     * <pre>
     * The user doesn't belong to the space and doesn't have a pending
     * invitation to join the space.
     * </pre>
     *
     * <code>NOT_A_MEMBER = 3;</code>
     */
    NOT_A_MEMBER(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. Don't use.
     * </pre>
     *
     * <code>MEMBERSHIP_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int MEMBERSHIP_STATE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The user is added to the space, and can participate in the space.
     * </pre>
     *
     * <code>JOINED = 1;</code>
     */
    public static final int JOINED_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The user is invited to join the space, but hasn't joined it.
     * </pre>
     *
     * <code>INVITED = 2;</code>
     */
    public static final int INVITED_VALUE = 2;

    /**
     *
     *
     * <pre>
     * The user doesn't belong to the space and doesn't have a pending
     * invitation to join the space.
     * </pre>
     *
     * <code>NOT_A_MEMBER = 3;</code>
     */
    public static final int NOT_A_MEMBER_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MembershipState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MembershipState forNumber(int value) {
      switch (value) {
        case 0:
          return MEMBERSHIP_STATE_UNSPECIFIED;
        case 1:
          return JOINED;
        case 2:
          return INVITED;
        case 3:
          return NOT_A_MEMBER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MembershipState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MembershipState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<MembershipState>() {
              public MembershipState findValueByNumber(int number) {
                return MembershipState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.chat.v1.Membership.getDescriptor().getEnumTypes().get(0);
    }

    private static final MembershipState[] VALUES = values();

    public static MembershipState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MembershipState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.chat.v1.Membership.MembershipState)
  }

  /**
   *
   *
   * <pre>
   * Represents a user's permitted actions in a Chat space. More enum values
   * might be added in the future.
   * </pre>
   *
   * Protobuf enum {@code google.chat.v1.Membership.MembershipRole}
   */
  public enum MembershipRole implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. For [users][google.chat.v1.Membership.member]: they
     * aren't a member of the space, but can be invited. For
     * [Google Groups][google.chat.v1.Membership.group_member]: they're always
     *  assigned this role (other enum values might be used in the future).
     * </pre>
     *
     * <code>MEMBERSHIP_ROLE_UNSPECIFIED = 0;</code>
     */
    MEMBERSHIP_ROLE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * A member of the space. The user has basic permissions, like sending
     * messages to the space. In 1:1 and unnamed group conversations, everyone
     * has this role.
     * </pre>
     *
     * <code>ROLE_MEMBER = 1;</code>
     */
    ROLE_MEMBER(1),
    /**
     *
     *
     * <pre>
     * A space manager. The user has all basic permissions plus administrative
     * permissions that let them manage the space, like adding or removing
     * members. Only supported in
     * [SpaceType.SPACE][google.chat.v1.Space.SpaceType].
     * </pre>
     *
     * <code>ROLE_MANAGER = 2;</code>
     */
    ROLE_MANAGER(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. For [users][google.chat.v1.Membership.member]: they
     * aren't a member of the space, but can be invited. For
     * [Google Groups][google.chat.v1.Membership.group_member]: they're always
     *  assigned this role (other enum values might be used in the future).
     * </pre>
     *
     * <code>MEMBERSHIP_ROLE_UNSPECIFIED = 0;</code>
     */
    public static final int MEMBERSHIP_ROLE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * A member of the space. The user has basic permissions, like sending
     * messages to the space. In 1:1 and unnamed group conversations, everyone
     * has this role.
     * </pre>
     *
     * <code>ROLE_MEMBER = 1;</code>
     */
    public static final int ROLE_MEMBER_VALUE = 1;

    /**
     *
     *
     * <pre>
     * A space manager. The user has all basic permissions plus administrative
     * permissions that let them manage the space, like adding or removing
     * members. Only supported in
     * [SpaceType.SPACE][google.chat.v1.Space.SpaceType].
     * </pre>
     *
     * <code>ROLE_MANAGER = 2;</code>
     */
    public static final int ROLE_MANAGER_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MembershipRole valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MembershipRole forNumber(int value) {
      switch (value) {
        case 0:
          return MEMBERSHIP_ROLE_UNSPECIFIED;
        case 1:
          return ROLE_MEMBER;
        case 2:
          return ROLE_MANAGER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MembershipRole> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MembershipRole> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<MembershipRole>() {
          public MembershipRole findValueByNumber(int number) {
            return MembershipRole.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.chat.v1.Membership.getDescriptor().getEnumTypes().get(1);
    }

    private static final MembershipRole[] VALUES = values();

    public static MembershipRole valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MembershipRole(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.chat.v1.Membership.MembershipRole)
  }

  private int bitField0_;
  private int memberTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object memberType_;

  public enum MemberTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    MEMBER(3),
    GROUP_MEMBER(5),
    MEMBERTYPE_NOT_SET(0);
    private final int value;

    private MemberTypeCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MemberTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static MemberTypeCase forNumber(int value) {
      switch (value) {
        case 3:
          return MEMBER;
        case 5:
          return GROUP_MEMBER;
        case 0:
          return MEMBERTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MemberTypeCase getMemberTypeCase() {
    return MemberTypeCase.forNumber(memberTypeCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Identifier. Resource name of the membership, assigned by the server.
   *
   * Format: `spaces/{space}/members/{member}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Identifier. Resource name of the membership, assigned by the server.
   *
   * Format: `spaces/{space}/members/{member}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 2;
  private int state_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. State of the membership.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Membership.MembershipState state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }

  /**
   *
   *
   * <pre>
   * Output only. State of the membership.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Membership.MembershipState state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.chat.v1.Membership.MembershipState getState() {
    com.google.chat.v1.Membership.MembershipState result =
        com.google.chat.v1.Membership.MembershipState.forNumber(state_);
    return result == null ? com.google.chat.v1.Membership.MembershipState.UNRECOGNIZED : result;
  }

  public static final int ROLE_FIELD_NUMBER = 7;
  private int role_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. User's role within a Chat space, which determines their permitted
   * actions in the space.
   *
   * This field can only be used as input in `UpdateMembership`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Membership.MembershipRole role = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for role.
   */
  @java.lang.Override
  public int getRoleValue() {
    return role_;
  }

  /**
   *
   *
   * <pre>
   * Optional. User's role within a Chat space, which determines their permitted
   * actions in the space.
   *
   * This field can only be used as input in `UpdateMembership`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Membership.MembershipRole role = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The role.
   */
  @java.lang.Override
  public com.google.chat.v1.Membership.MembershipRole getRole() {
    com.google.chat.v1.Membership.MembershipRole result =
        com.google.chat.v1.Membership.MembershipRole.forNumber(role_);
    return result == null ? com.google.chat.v1.Membership.MembershipRole.UNRECOGNIZED : result;
  }

  public static final int MEMBER_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Optional. The Google Chat user or app the membership corresponds to.
   * If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the output populates the
   * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
   * `name` and `type`.
   * </pre>
   *
   * <code>.google.chat.v1.User member = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the member field is set.
   */
  @java.lang.Override
  public boolean hasMember() {
    return memberTypeCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Optional. The Google Chat user or app the membership corresponds to.
   * If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the output populates the
   * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
   * `name` and `type`.
   * </pre>
   *
   * <code>.google.chat.v1.User member = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The member.
   */
  @java.lang.Override
  public com.google.chat.v1.User getMember() {
    if (memberTypeCase_ == 3) {
      return (com.google.chat.v1.User) memberType_;
    }
    return com.google.chat.v1.User.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. The Google Chat user or app the membership corresponds to.
   * If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the output populates the
   * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
   * `name` and `type`.
   * </pre>
   *
   * <code>.google.chat.v1.User member = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public com.google.chat.v1.UserOrBuilder getMemberOrBuilder() {
    if (memberTypeCase_ == 3) {
      return (com.google.chat.v1.User) memberType_;
    }
    return com.google.chat.v1.User.getDefaultInstance();
  }

  public static final int GROUP_MEMBER_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * Optional. The Google Group the membership corresponds to.
   *
   * Reading or mutating memberships for Google Groups requires [user
   * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
   * </pre>
   *
   * <code>.google.chat.v1.Group group_member = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the groupMember field is set.
   */
  @java.lang.Override
  public boolean hasGroupMember() {
    return memberTypeCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * Optional. The Google Group the membership corresponds to.
   *
   * Reading or mutating memberships for Google Groups requires [user
   * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
   * </pre>
   *
   * <code>.google.chat.v1.Group group_member = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The groupMember.
   */
  @java.lang.Override
  public com.google.chat.v1.Group getGroupMember() {
    if (memberTypeCase_ == 5) {
      return (com.google.chat.v1.Group) memberType_;
    }
    return com.google.chat.v1.Group.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. The Google Group the membership corresponds to.
   *
   * Reading or mutating memberships for Google Groups requires [user
   * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
   * </pre>
   *
   * <code>.google.chat.v1.Group group_member = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public com.google.chat.v1.GroupOrBuilder getGroupMemberOrBuilder() {
    if (memberTypeCase_ == 5) {
      return (com.google.chat.v1.Group) memberType_;
    }
    return com.google.chat.v1.Group.getDefaultInstance();
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The creation time of the membership, such as when a
   * member joined or was invited to join a space. This field is output only,
   * except when used to import historical memberships in import mode spaces.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The creation time of the membership, such as when a
   * member joined or was invited to join a space. This field is output only,
   * except when used to import historical memberships in import mode spaces.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The creation time of the membership, such as when a
   * member joined or was invited to join a space. This field is output only,
   * except when used to import historical memberships in import mode spaces.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int DELETE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp deleteTime_;

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The deletion time of the membership, such as when a
   * member left or was removed from a space. This field is output only, except
   * when used to import historical memberships in import mode spaces.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the deleteTime field is set.
   */
  @java.lang.Override
  public boolean hasDeleteTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The deletion time of the membership, such as when a
   * member left or was removed from a space. This field is output only, except
   * when used to import historical memberships in import mode spaces.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The deleteTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDeleteTime() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The deletion time of the membership, such as when a
   * member left or was removed from a space. This field is output only, except
   * when used to import historical memberships in import mode spaces.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (state_
        != com.google.chat.v1.Membership.MembershipState.MEMBERSHIP_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, state_);
    }
    if (memberTypeCase_ == 3) {
      output.writeMessage(3, (com.google.chat.v1.User) memberType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getCreateTime());
    }
    if (memberTypeCase_ == 5) {
      output.writeMessage(5, (com.google.chat.v1.Group) memberType_);
    }
    if (role_
        != com.google.chat.v1.Membership.MembershipRole.MEMBERSHIP_ROLE_UNSPECIFIED.getNumber()) {
      output.writeEnum(7, role_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getDeleteTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (state_
        != com.google.chat.v1.Membership.MembershipState.MEMBERSHIP_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, state_);
    }
    if (memberTypeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.chat.v1.User) memberType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    if (memberTypeCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.chat.v1.Group) memberType_);
    }
    if (role_
        != com.google.chat.v1.Membership.MembershipRole.MEMBERSHIP_ROLE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, role_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getDeleteTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.Membership)) {
      return super.equals(obj);
    }
    com.google.chat.v1.Membership other = (com.google.chat.v1.Membership) obj;

    if (!getName().equals(other.getName())) return false;
    if (state_ != other.state_) return false;
    if (role_ != other.role_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasDeleteTime() != other.hasDeleteTime()) return false;
    if (hasDeleteTime()) {
      if (!getDeleteTime().equals(other.getDeleteTime())) return false;
    }
    if (!getMemberTypeCase().equals(other.getMemberTypeCase())) return false;
    switch (memberTypeCase_) {
      case 3:
        if (!getMember().equals(other.getMember())) return false;
        break;
      case 5:
        if (!getGroupMember().equals(other.getGroupMember())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + ROLE_FIELD_NUMBER;
    hash = (53 * hash) + role_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasDeleteTime()) {
      hash = (37 * hash) + DELETE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDeleteTime().hashCode();
    }
    switch (memberTypeCase_) {
      case 3:
        hash = (37 * hash) + MEMBER_FIELD_NUMBER;
        hash = (53 * hash) + getMember().hashCode();
        break;
      case 5:
        hash = (37 * hash) + GROUP_MEMBER_FIELD_NUMBER;
        hash = (53 * hash) + getGroupMember().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.Membership parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.Membership parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.Membership parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.Membership parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.Membership parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.Membership parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.Membership parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.Membership parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.Membership parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.Membership parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.Membership parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.Membership parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.Membership prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a membership relation in Google Chat, such as whether a user or
   * Chat app is invited to, part of, or absent from a space.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.Membership}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.Membership)
      com.google.chat.v1.MembershipOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.MembershipProto
          .internal_static_google_chat_v1_Membership_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.MembershipProto
          .internal_static_google_chat_v1_Membership_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.Membership.class, com.google.chat.v1.Membership.Builder.class);
    }

    // Construct using com.google.chat.v1.Membership.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getDeleteTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      state_ = 0;
      role_ = 0;
      if (memberBuilder_ != null) {
        memberBuilder_.clear();
      }
      if (groupMemberBuilder_ != null) {
        groupMemberBuilder_.clear();
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      memberTypeCase_ = 0;
      memberType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.MembershipProto
          .internal_static_google_chat_v1_Membership_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.Membership getDefaultInstanceForType() {
      return com.google.chat.v1.Membership.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.Membership build() {
      com.google.chat.v1.Membership result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.Membership buildPartial() {
      com.google.chat.v1.Membership result = new com.google.chat.v1.Membership(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.chat.v1.Membership result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.role_ = role_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.deleteTime_ = deleteTimeBuilder_ == null ? deleteTime_ : deleteTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.chat.v1.Membership result) {
      result.memberTypeCase_ = memberTypeCase_;
      result.memberType_ = this.memberType_;
      if (memberTypeCase_ == 3 && memberBuilder_ != null) {
        result.memberType_ = memberBuilder_.build();
      }
      if (memberTypeCase_ == 5 && groupMemberBuilder_ != null) {
        result.memberType_ = groupMemberBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.Membership) {
        return mergeFrom((com.google.chat.v1.Membership) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.Membership other) {
      if (other == com.google.chat.v1.Membership.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.role_ != 0) {
        setRoleValue(other.getRoleValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasDeleteTime()) {
        mergeDeleteTime(other.getDeleteTime());
      }
      switch (other.getMemberTypeCase()) {
        case MEMBER:
          {
            mergeMember(other.getMember());
            break;
          }
        case GROUP_MEMBER:
          {
            mergeGroupMember(other.getGroupMember());
            break;
          }
        case MEMBERTYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getMemberFieldBuilder().getBuilder(), extensionRegistry);
                memberTypeCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getGroupMemberFieldBuilder().getBuilder(), extensionRegistry);
                memberTypeCase_ = 5;
                break;
              } // case 42
            case 56:
              {
                role_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 56
            case 66:
              {
                input.readMessage(getDeleteTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int memberTypeCase_ = 0;
    private java.lang.Object memberType_;

    public MemberTypeCase getMemberTypeCase() {
      return MemberTypeCase.forNumber(memberTypeCase_);
    }

    public Builder clearMemberType() {
      memberTypeCase_ = 0;
      memberType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Identifier. Resource name of the membership, assigned by the server.
     *
     * Format: `spaces/{space}/members/{member}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. Resource name of the membership, assigned by the server.
     *
     * Format: `spaces/{space}/members/{member}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. Resource name of the membership, assigned by the server.
     *
     * Format: `spaces/{space}/members/{member}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. Resource name of the membership, assigned by the server.
     *
     * Format: `spaces/{space}/members/{member}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. Resource name of the membership, assigned by the server.
     *
     * Format: `spaces/{space}/members/{member}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. State of the membership.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Membership.MembershipState state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Output only. State of the membership.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Membership.MembershipState state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. State of the membership.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Membership.MembershipState state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.chat.v1.Membership.MembershipState getState() {
      com.google.chat.v1.Membership.MembershipState result =
          com.google.chat.v1.Membership.MembershipState.forNumber(state_);
      return result == null ? com.google.chat.v1.Membership.MembershipState.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. State of the membership.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Membership.MembershipState state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.chat.v1.Membership.MembershipState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      state_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. State of the membership.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Membership.MembershipState state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000002);
      state_ = 0;
      onChanged();
      return this;
    }

    private int role_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. User's role within a Chat space, which determines their permitted
     * actions in the space.
     *
     * This field can only be used as input in `UpdateMembership`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Membership.MembershipRole role = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for role.
     */
    @java.lang.Override
    public int getRoleValue() {
      return role_;
    }

    /**
     *
     *
     * <pre>
     * Optional. User's role within a Chat space, which determines their permitted
     * actions in the space.
     *
     * This field can only be used as input in `UpdateMembership`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Membership.MembershipRole role = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for role to set.
     * @return This builder for chaining.
     */
    public Builder setRoleValue(int value) {
      role_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User's role within a Chat space, which determines their permitted
     * actions in the space.
     *
     * This field can only be used as input in `UpdateMembership`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Membership.MembershipRole role = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The role.
     */
    @java.lang.Override
    public com.google.chat.v1.Membership.MembershipRole getRole() {
      com.google.chat.v1.Membership.MembershipRole result =
          com.google.chat.v1.Membership.MembershipRole.forNumber(role_);
      return result == null ? com.google.chat.v1.Membership.MembershipRole.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. User's role within a Chat space, which determines their permitted
     * actions in the space.
     *
     * This field can only be used as input in `UpdateMembership`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Membership.MembershipRole role = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The role to set.
     * @return This builder for chaining.
     */
    public Builder setRole(com.google.chat.v1.Membership.MembershipRole value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      role_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User's role within a Chat space, which determines their permitted
     * actions in the space.
     *
     * This field can only be used as input in `UpdateMembership`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Membership.MembershipRole role = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRole() {
      bitField0_ = (bitField0_ & ~0x00000004);
      role_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.User,
            com.google.chat.v1.User.Builder,
            com.google.chat.v1.UserOrBuilder>
        memberBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The Google Chat user or app the membership corresponds to.
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     * `name` and `type`.
     * </pre>
     *
     * <code>.google.chat.v1.User member = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the member field is set.
     */
    @java.lang.Override
    public boolean hasMember() {
      return memberTypeCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Google Chat user or app the membership corresponds to.
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     * `name` and `type`.
     * </pre>
     *
     * <code>.google.chat.v1.User member = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The member.
     */
    @java.lang.Override
    public com.google.chat.v1.User getMember() {
      if (memberBuilder_ == null) {
        if (memberTypeCase_ == 3) {
          return (com.google.chat.v1.User) memberType_;
        }
        return com.google.chat.v1.User.getDefaultInstance();
      } else {
        if (memberTypeCase_ == 3) {
          return memberBuilder_.getMessage();
        }
        return com.google.chat.v1.User.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The Google Chat user or app the membership corresponds to.
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     * `name` and `type`.
     * </pre>
     *
     * <code>.google.chat.v1.User member = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setMember(com.google.chat.v1.User value) {
      if (memberBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        memberType_ = value;
        onChanged();
      } else {
        memberBuilder_.setMessage(value);
      }
      memberTypeCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Google Chat user or app the membership corresponds to.
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     * `name` and `type`.
     * </pre>
     *
     * <code>.google.chat.v1.User member = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setMember(com.google.chat.v1.User.Builder builderForValue) {
      if (memberBuilder_ == null) {
        memberType_ = builderForValue.build();
        onChanged();
      } else {
        memberBuilder_.setMessage(builderForValue.build());
      }
      memberTypeCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Google Chat user or app the membership corresponds to.
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     * `name` and `type`.
     * </pre>
     *
     * <code>.google.chat.v1.User member = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder mergeMember(com.google.chat.v1.User value) {
      if (memberBuilder_ == null) {
        if (memberTypeCase_ == 3 && memberType_ != com.google.chat.v1.User.getDefaultInstance()) {
          memberType_ =
              com.google.chat.v1.User.newBuilder((com.google.chat.v1.User) memberType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          memberType_ = value;
        }
        onChanged();
      } else {
        if (memberTypeCase_ == 3) {
          memberBuilder_.mergeFrom(value);
        } else {
          memberBuilder_.setMessage(value);
        }
      }
      memberTypeCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Google Chat user or app the membership corresponds to.
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     * `name` and `type`.
     * </pre>
     *
     * <code>.google.chat.v1.User member = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder clearMember() {
      if (memberBuilder_ == null) {
        if (memberTypeCase_ == 3) {
          memberTypeCase_ = 0;
          memberType_ = null;
          onChanged();
        }
      } else {
        if (memberTypeCase_ == 3) {
          memberTypeCase_ = 0;
          memberType_ = null;
        }
        memberBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Google Chat user or app the membership corresponds to.
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     * `name` and `type`.
     * </pre>
     *
     * <code>.google.chat.v1.User member = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.google.chat.v1.User.Builder getMemberBuilder() {
      return getMemberFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The Google Chat user or app the membership corresponds to.
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     * `name` and `type`.
     * </pre>
     *
     * <code>.google.chat.v1.User member = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public com.google.chat.v1.UserOrBuilder getMemberOrBuilder() {
      if ((memberTypeCase_ == 3) && (memberBuilder_ != null)) {
        return memberBuilder_.getMessageOrBuilder();
      } else {
        if (memberTypeCase_ == 3) {
          return (com.google.chat.v1.User) memberType_;
        }
        return com.google.chat.v1.User.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The Google Chat user or app the membership corresponds to.
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     * `name` and `type`.
     * </pre>
     *
     * <code>.google.chat.v1.User member = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.User,
            com.google.chat.v1.User.Builder,
            com.google.chat.v1.UserOrBuilder>
        getMemberFieldBuilder() {
      if (memberBuilder_ == null) {
        if (!(memberTypeCase_ == 3)) {
          memberType_ = com.google.chat.v1.User.getDefaultInstance();
        }
        memberBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.User,
                com.google.chat.v1.User.Builder,
                com.google.chat.v1.UserOrBuilder>(
                (com.google.chat.v1.User) memberType_, getParentForChildren(), isClean());
        memberType_ = null;
      }
      memberTypeCase_ = 3;
      onChanged();
      return memberBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Group,
            com.google.chat.v1.Group.Builder,
            com.google.chat.v1.GroupOrBuilder>
        groupMemberBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The Google Group the membership corresponds to.
     *
     * Reading or mutating memberships for Google Groups requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     * </pre>
     *
     * <code>.google.chat.v1.Group group_member = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the groupMember field is set.
     */
    @java.lang.Override
    public boolean hasGroupMember() {
      return memberTypeCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Google Group the membership corresponds to.
     *
     * Reading or mutating memberships for Google Groups requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     * </pre>
     *
     * <code>.google.chat.v1.Group group_member = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The groupMember.
     */
    @java.lang.Override
    public com.google.chat.v1.Group getGroupMember() {
      if (groupMemberBuilder_ == null) {
        if (memberTypeCase_ == 5) {
          return (com.google.chat.v1.Group) memberType_;
        }
        return com.google.chat.v1.Group.getDefaultInstance();
      } else {
        if (memberTypeCase_ == 5) {
          return groupMemberBuilder_.getMessage();
        }
        return com.google.chat.v1.Group.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The Google Group the membership corresponds to.
     *
     * Reading or mutating memberships for Google Groups requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     * </pre>
     *
     * <code>.google.chat.v1.Group group_member = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGroupMember(com.google.chat.v1.Group value) {
      if (groupMemberBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        memberType_ = value;
        onChanged();
      } else {
        groupMemberBuilder_.setMessage(value);
      }
      memberTypeCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Google Group the membership corresponds to.
     *
     * Reading or mutating memberships for Google Groups requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     * </pre>
     *
     * <code>.google.chat.v1.Group group_member = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGroupMember(com.google.chat.v1.Group.Builder builderForValue) {
      if (groupMemberBuilder_ == null) {
        memberType_ = builderForValue.build();
        onChanged();
      } else {
        groupMemberBuilder_.setMessage(builderForValue.build());
      }
      memberTypeCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Google Group the membership corresponds to.
     *
     * Reading or mutating memberships for Google Groups requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     * </pre>
     *
     * <code>.google.chat.v1.Group group_member = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGroupMember(com.google.chat.v1.Group value) {
      if (groupMemberBuilder_ == null) {
        if (memberTypeCase_ == 5 && memberType_ != com.google.chat.v1.Group.getDefaultInstance()) {
          memberType_ =
              com.google.chat.v1.Group.newBuilder((com.google.chat.v1.Group) memberType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          memberType_ = value;
        }
        onChanged();
      } else {
        if (memberTypeCase_ == 5) {
          groupMemberBuilder_.mergeFrom(value);
        } else {
          groupMemberBuilder_.setMessage(value);
        }
      }
      memberTypeCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Google Group the membership corresponds to.
     *
     * Reading or mutating memberships for Google Groups requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     * </pre>
     *
     * <code>.google.chat.v1.Group group_member = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGroupMember() {
      if (groupMemberBuilder_ == null) {
        if (memberTypeCase_ == 5) {
          memberTypeCase_ = 0;
          memberType_ = null;
          onChanged();
        }
      } else {
        if (memberTypeCase_ == 5) {
          memberTypeCase_ = 0;
          memberType_ = null;
        }
        groupMemberBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Google Group the membership corresponds to.
     *
     * Reading or mutating memberships for Google Groups requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     * </pre>
     *
     * <code>.google.chat.v1.Group group_member = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.Group.Builder getGroupMemberBuilder() {
      return getGroupMemberFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The Google Group the membership corresponds to.
     *
     * Reading or mutating memberships for Google Groups requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     * </pre>
     *
     * <code>.google.chat.v1.Group group_member = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.chat.v1.GroupOrBuilder getGroupMemberOrBuilder() {
      if ((memberTypeCase_ == 5) && (groupMemberBuilder_ != null)) {
        return groupMemberBuilder_.getMessageOrBuilder();
      } else {
        if (memberTypeCase_ == 5) {
          return (com.google.chat.v1.Group) memberType_;
        }
        return com.google.chat.v1.Group.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The Google Group the membership corresponds to.
     *
     * Reading or mutating memberships for Google Groups requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     * </pre>
     *
     * <code>.google.chat.v1.Group group_member = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Group,
            com.google.chat.v1.Group.Builder,
            com.google.chat.v1.GroupOrBuilder>
        getGroupMemberFieldBuilder() {
      if (groupMemberBuilder_ == null) {
        if (!(memberTypeCase_ == 5)) {
          memberType_ = com.google.chat.v1.Group.getDefaultInstance();
        }
        groupMemberBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.Group,
                com.google.chat.v1.Group.Builder,
                com.google.chat.v1.GroupOrBuilder>(
                (com.google.chat.v1.Group) memberType_, getParentForChildren(), isClean());
        memberType_ = null;
      }
      memberTypeCase_ = 5;
      onChanged();
      return groupMemberBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The creation time of the membership, such as when a
     * member joined or was invited to join a space. This field is output only,
     * except when used to import historical memberships in import mode spaces.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The creation time of the membership, such as when a
     * member joined or was invited to join a space. This field is output only,
     * except when used to import historical memberships in import mode spaces.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The creation time of the membership, such as when a
     * member joined or was invited to join a space. This field is output only,
     * except when used to import historical memberships in import mode spaces.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The creation time of the membership, such as when a
     * member joined or was invited to join a space. This field is output only,
     * except when used to import historical memberships in import mode spaces.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The creation time of the membership, such as when a
     * member joined or was invited to join a space. This field is output only,
     * except when used to import historical memberships in import mode spaces.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The creation time of the membership, such as when a
     * member joined or was invited to join a space. This field is output only,
     * except when used to import historical memberships in import mode spaces.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The creation time of the membership, such as when a
     * member joined or was invited to join a space. This field is output only,
     * except when used to import historical memberships in import mode spaces.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The creation time of the membership, such as when a
     * member joined or was invited to join a space. This field is output only,
     * except when used to import historical memberships in import mode spaces.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The creation time of the membership, such as when a
     * member joined or was invited to join a space. This field is output only,
     * except when used to import historical memberships in import mode spaces.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp deleteTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        deleteTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The deletion time of the membership, such as when a
     * member left or was removed from a space. This field is output only, except
     * when used to import historical memberships in import mode spaces.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the deleteTime field is set.
     */
    public boolean hasDeleteTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The deletion time of the membership, such as when a
     * member left or was removed from a space. This field is output only, except
     * when used to import historical memberships in import mode spaces.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The deleteTime.
     */
    public com.google.protobuf.Timestamp getDeleteTime() {
      if (deleteTimeBuilder_ == null) {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      } else {
        return deleteTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The deletion time of the membership, such as when a
     * member left or was removed from a space. This field is output only, except
     * when used to import historical memberships in import mode spaces.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deleteTime_ = value;
      } else {
        deleteTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The deletion time of the membership, such as when a
     * member left or was removed from a space. This field is output only, except
     * when used to import historical memberships in import mode spaces.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (deleteTimeBuilder_ == null) {
        deleteTime_ = builderForValue.build();
      } else {
        deleteTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The deletion time of the membership, such as when a
     * member left or was removed from a space. This field is output only, except
     * when used to import historical memberships in import mode spaces.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && deleteTime_ != null
            && deleteTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDeleteTimeBuilder().mergeFrom(value);
        } else {
          deleteTime_ = value;
        }
      } else {
        deleteTimeBuilder_.mergeFrom(value);
      }
      if (deleteTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The deletion time of the membership, such as when a
     * member left or was removed from a space. This field is output only, except
     * when used to import historical memberships in import mode spaces.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDeleteTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The deletion time of the membership, such as when a
     * member left or was removed from a space. This field is output only, except
     * when used to import historical memberships in import mode spaces.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDeleteTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getDeleteTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The deletion time of the membership, such as when a
     * member left or was removed from a space. This field is output only, except
     * when used to import historical memberships in import mode spaces.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
      if (deleteTimeBuilder_ != null) {
        return deleteTimeBuilder_.getMessageOrBuilder();
      } else {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The deletion time of the membership, such as when a
     * member left or was removed from a space. This field is output only, except
     * when used to import historical memberships in import mode spaces.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDeleteTimeFieldBuilder() {
      if (deleteTimeBuilder_ == null) {
        deleteTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDeleteTime(), getParentForChildren(), isClean());
        deleteTime_ = null;
      }
      return deleteTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.Membership)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.Membership)
  private static final com.google.chat.v1.Membership DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.Membership();
  }

  public static com.google.chat.v1.Membership getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Membership> PARSER =
      new com.google.protobuf.AbstractParser<Membership>() {
        @java.lang.Override
        public Membership parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Membership> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Membership> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.Membership getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
