/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/membership.proto

// Protobuf Java Version: 3.25.5
package com.google.chat.v1;

public interface MembershipOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.chat.v1.Membership)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Identifier. Resource name of the membership, assigned by the server.
   *
   * Format: `spaces/{space}/members/{member}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Identifier. Resource name of the membership, assigned by the server.
   *
   * Format: `spaces/{space}/members/{member}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. State of the membership.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Membership.MembershipState state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();

  /**
   *
   *
   * <pre>
   * Output only. State of the membership.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Membership.MembershipState state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.chat.v1.Membership.MembershipState getState();

  /**
   *
   *
   * <pre>
   * Optional. User's role within a Chat space, which determines their permitted
   * actions in the space.
   *
   * This field can only be used as input in `UpdateMembership`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Membership.MembershipRole role = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for role.
   */
  int getRoleValue();

  /**
   *
   *
   * <pre>
   * Optional. User's role within a Chat space, which determines their permitted
   * actions in the space.
   *
   * This field can only be used as input in `UpdateMembership`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Membership.MembershipRole role = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The role.
   */
  com.google.chat.v1.Membership.MembershipRole getRole();

  /**
   *
   *
   * <pre>
   * Optional. The Google Chat user or app the membership corresponds to.
   * If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the output populates the
   * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
   * `name` and `type`.
   * </pre>
   *
   * <code>.google.chat.v1.User member = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the member field is set.
   */
  boolean hasMember();

  /**
   *
   *
   * <pre>
   * Optional. The Google Chat user or app the membership corresponds to.
   * If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the output populates the
   * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
   * `name` and `type`.
   * </pre>
   *
   * <code>.google.chat.v1.User member = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The member.
   */
  com.google.chat.v1.User getMember();

  /**
   *
   *
   * <pre>
   * Optional. The Google Chat user or app the membership corresponds to.
   * If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the output populates the
   * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
   * `name` and `type`.
   * </pre>
   *
   * <code>.google.chat.v1.User member = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  com.google.chat.v1.UserOrBuilder getMemberOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The Google Group the membership corresponds to.
   *
   * Reading or mutating memberships for Google Groups requires [user
   * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
   * </pre>
   *
   * <code>.google.chat.v1.Group group_member = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the groupMember field is set.
   */
  boolean hasGroupMember();

  /**
   *
   *
   * <pre>
   * Optional. The Google Group the membership corresponds to.
   *
   * Reading or mutating memberships for Google Groups requires [user
   * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
   * </pre>
   *
   * <code>.google.chat.v1.Group group_member = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The groupMember.
   */
  com.google.chat.v1.Group getGroupMember();

  /**
   *
   *
   * <pre>
   * Optional. The Google Group the membership corresponds to.
   *
   * Reading or mutating memberships for Google Groups requires [user
   * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
   * </pre>
   *
   * <code>.google.chat.v1.Group group_member = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  com.google.chat.v1.GroupOrBuilder getGroupMemberOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The creation time of the membership, such as when a
   * member joined or was invited to join a space. This field is output only,
   * except when used to import historical memberships in import mode spaces.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The creation time of the membership, such as when a
   * member joined or was invited to join a space. This field is output only,
   * except when used to import historical memberships in import mode spaces.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The creation time of the membership, such as when a
   * member joined or was invited to join a space. This field is output only,
   * except when used to import historical memberships in import mode spaces.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The deletion time of the membership, such as when a
   * member left or was removed from a space. This field is output only, except
   * when used to import historical memberships in import mode spaces.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the deleteTime field is set.
   */
  boolean hasDeleteTime();

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The deletion time of the membership, such as when a
   * member left or was removed from a space. This field is output only, except
   * when used to import historical memberships in import mode spaces.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The deleteTime.
   */
  com.google.protobuf.Timestamp getDeleteTime();

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The deletion time of the membership, such as when a
   * member left or was removed from a space. This field is output only, except
   * when used to import historical memberships in import mode spaces.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder();

  com.google.chat.v1.Membership.MemberTypeCase getMemberTypeCase();
}
