/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/message.proto

// Protobuf Java Version: 3.25.5
package com.google.chat.v1;

/**
 *
 *
 * <pre>
 * A message in a Google Chat space.
 * </pre>
 *
 * Protobuf type {@code google.chat.v1.Message}
 */
public final class Message extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.Message)
    MessageOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Message.newBuilder() to construct.
  private Message(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Message() {
    name_ = "";
    text_ = "";
    formattedText_ = "";
    cards_ = java.util.Collections.emptyList();
    cardsV2_ = java.util.Collections.emptyList();
    annotations_ = java.util.Collections.emptyList();
    fallbackText_ = "";
    argumentText_ = "";
    attachment_ = java.util.Collections.emptyList();
    clientAssignedMessageId_ = "";
    emojiReactionSummaries_ = java.util.Collections.emptyList();
    attachedGifs_ = java.util.Collections.emptyList();
    accessoryWidgets_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Message();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.MessageProto.internal_static_google_chat_v1_Message_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.MessageProto.internal_static_google_chat_v1_Message_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.Message.class, com.google.chat.v1.Message.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Identifier. Resource name of the message.
   *
   * Format: `spaces/{space}/messages/{message}`
   *
   *
   * Where `{space}` is the ID of the space where the message is posted and
   * `{message}` is a system-assigned ID for the message. For example,
   * `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`.
   *
   * If you set a custom ID when you create a message, you can use this ID to
   * specify the message in a request by replacing `{message}` with the value
   * from the `clientAssignedMessageId` field. For example,
   * `spaces/AAAAAAAAAAA/messages/client-custom-name`. For details, see [Name
   * a
   * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Identifier. Resource name of the message.
   *
   * Format: `spaces/{space}/messages/{message}`
   *
   *
   * Where `{space}` is the ID of the space where the message is posted and
   * `{message}` is a system-assigned ID for the message. For example,
   * `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`.
   *
   * If you set a custom ID when you create a message, you can use this ID to
   * specify the message in a request by replacing `{message}` with the value
   * from the `clientAssignedMessageId` field. For example,
   * `spaces/AAAAAAAAAAA/messages/client-custom-name`. For details, see [Name
   * a
   * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SENDER_FIELD_NUMBER = 2;
  private com.google.chat.v1.User sender_;

  /**
   *
   *
   * <pre>
   * Output only. The user who created the message.
   * If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the output populates the
   * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
   * `name` and `type`.
   * </pre>
   *
   * <code>.google.chat.v1.User sender = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the sender field is set.
   */
  @java.lang.Override
  public boolean hasSender() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The user who created the message.
   * If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the output populates the
   * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
   * `name` and `type`.
   * </pre>
   *
   * <code>.google.chat.v1.User sender = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The sender.
   */
  @java.lang.Override
  public com.google.chat.v1.User getSender() {
    return sender_ == null ? com.google.chat.v1.User.getDefaultInstance() : sender_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The user who created the message.
   * If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the output populates the
   * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
   * `name` and `type`.
   * </pre>
   *
   * <code>.google.chat.v1.User sender = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.chat.v1.UserOrBuilder getSenderOrBuilder() {
    return sender_ == null ? com.google.chat.v1.User.getDefaultInstance() : sender_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Optional. Immutable. For spaces created in Chat, the time at which the
   * message was created. This field is output only, except when used in import
   * mode spaces.
   *
   * For import mode spaces, set this field to the historical timestamp at which
   * the message was created in the source in order to preserve the original
   * creation time.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. For spaces created in Chat, the time at which the
   * message was created. This field is output only, except when used in import
   * mode spaces.
   *
   * For import mode spaces, set this field to the historical timestamp at which
   * the message was created in the source in order to preserve the original
   * creation time.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. For spaces created in Chat, the time at which the
   * message was created. This field is output only, except when used in import
   * mode spaces.
   *
   * For import mode spaces, set this field to the historical timestamp at which
   * the message was created in the source in order to preserve the original
   * creation time.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int LAST_UPDATE_TIME_FIELD_NUMBER = 23;
  private com.google.protobuf.Timestamp lastUpdateTime_;

  /**
   *
   *
   * <pre>
   * Output only. The time at which the message was last edited by a user. If
   * the message has never been edited, this field is empty.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_update_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastUpdateTime field is set.
   */
  @java.lang.Override
  public boolean hasLastUpdateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The time at which the message was last edited by a user. If
   * the message has never been edited, this field is empty.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_update_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastUpdateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastUpdateTime() {
    return lastUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastUpdateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The time at which the message was last edited by a user. If
   * the message has never been edited, this field is empty.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_update_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder() {
    return lastUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastUpdateTime_;
  }

  public static final int DELETE_TIME_FIELD_NUMBER = 26;
  private com.google.protobuf.Timestamp deleteTime_;

  /**
   *
   *
   * <pre>
   * Output only. The time at which the message was deleted in
   * Google Chat. If the message is never deleted, this field is empty.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deleteTime field is set.
   */
  @java.lang.Override
  public boolean hasDeleteTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The time at which the message was deleted in
   * Google Chat. If the message is never deleted, this field is empty.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deleteTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDeleteTime() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The time at which the message was deleted in
   * Google Chat. If the message is never deleted, this field is empty.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  public static final int TEXT_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object text_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Plain-text body of the message. The first link to an image,
   * video, or web page generates a [preview
   * chip](https://developers.google.com/workspace/chat/preview-links). You can
   * also [&#64;mention a Google Chat
   * user](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention),
   * or everyone in the space.
   *
   * To learn about creating text messages, see [Send a
   * message](https://developers.google.com/workspace/chat/create-messages).
   * </pre>
   *
   * <code>string text = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The text.
   */
  @java.lang.Override
  public java.lang.String getText() {
    java.lang.Object ref = text_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      text_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Plain-text body of the message. The first link to an image,
   * video, or web page generates a [preview
   * chip](https://developers.google.com/workspace/chat/preview-links). You can
   * also [&#64;mention a Google Chat
   * user](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention),
   * or everyone in the space.
   *
   * To learn about creating text messages, see [Send a
   * message](https://developers.google.com/workspace/chat/create-messages).
   * </pre>
   *
   * <code>string text = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for text.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTextBytes() {
    java.lang.Object ref = text_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      text_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FORMATTED_TEXT_FIELD_NUMBER = 43;

  @SuppressWarnings("serial")
  private volatile java.lang.Object formattedText_ = "";

  /**
   *
   *
   * <pre>
   * Output only. Contains the message `text` with markups added to communicate
   * formatting. This field might not capture all formatting visible in the UI,
   * but includes the following:
   *
   * * [Markup
   * syntax](https://developers.google.com/workspace/chat/format-messages)
   * for bold, italic, strikethrough, monospace, monospace block, and bulleted
   * list.
   *
   * * [User
   * mentions](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention)
   * using the format `&lt;users/{user}&gt;`.
   *
   * * Custom hyperlinks using the format `&lt;{url}|{rendered_text}&gt;` where the
   * first string is the URL and the second is the rendered text—for example,
   * `&lt;http://example.com|custom text&gt;`.
   *
   * * Custom emoji using the format `:{emoji_name}:`—for example, `:smile:`.
   * This doesn't apply to Unicode emoji, such as `U+1F600` for a grinning
   * face emoji.
   *
   * For more information, see [View text formatting sent in a
   * message](https://developers.google.com/workspace/chat/format-messages#view_text_formatting_sent_in_a_message)
   * </pre>
   *
   * <code>string formatted_text = 43 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The formattedText.
   */
  @java.lang.Override
  public java.lang.String getFormattedText() {
    java.lang.Object ref = formattedText_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      formattedText_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Contains the message `text` with markups added to communicate
   * formatting. This field might not capture all formatting visible in the UI,
   * but includes the following:
   *
   * * [Markup
   * syntax](https://developers.google.com/workspace/chat/format-messages)
   * for bold, italic, strikethrough, monospace, monospace block, and bulleted
   * list.
   *
   * * [User
   * mentions](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention)
   * using the format `&lt;users/{user}&gt;`.
   *
   * * Custom hyperlinks using the format `&lt;{url}|{rendered_text}&gt;` where the
   * first string is the URL and the second is the rendered text—for example,
   * `&lt;http://example.com|custom text&gt;`.
   *
   * * Custom emoji using the format `:{emoji_name}:`—for example, `:smile:`.
   * This doesn't apply to Unicode emoji, such as `U+1F600` for a grinning
   * face emoji.
   *
   * For more information, see [View text formatting sent in a
   * message](https://developers.google.com/workspace/chat/format-messages#view_text_formatting_sent_in_a_message)
   * </pre>
   *
   * <code>string formatted_text = 43 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for formattedText.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFormattedTextBytes() {
    java.lang.Object ref = formattedText_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      formattedText_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CARDS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.chat.v1.ContextualAddOnMarkup.Card> cards_;

  /**
   *
   *
   * <pre>
   * Deprecated: Use `cards_v2` instead.
   *
   * Rich, formatted, and interactive cards that you can use to display UI
   * elements such as: formatted texts, buttons, and clickable images. Cards are
   * normally displayed below the plain-text body of the message. `cards` and
   * `cards_v2` can have a maximum size of 32 KB.
   * </pre>
   *
   * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<com.google.chat.v1.ContextualAddOnMarkup.Card> getCardsList() {
    return cards_;
  }

  /**
   *
   *
   * <pre>
   * Deprecated: Use `cards_v2` instead.
   *
   * Rich, formatted, and interactive cards that you can use to display UI
   * elements such as: formatted texts, buttons, and clickable images. Cards are
   * normally displayed below the plain-text body of the message. `cards` and
   * `cards_v2` can have a maximum size of 32 KB.
   * </pre>
   *
   * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<? extends com.google.chat.v1.ContextualAddOnMarkup.CardOrBuilder>
      getCardsOrBuilderList() {
    return cards_;
  }

  /**
   *
   *
   * <pre>
   * Deprecated: Use `cards_v2` instead.
   *
   * Rich, formatted, and interactive cards that you can use to display UI
   * elements such as: formatted texts, buttons, and clickable images. Cards are
   * normally displayed below the plain-text body of the message. `cards` and
   * `cards_v2` can have a maximum size of 32 KB.
   * </pre>
   *
   * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getCardsCount() {
    return cards_.size();
  }

  /**
   *
   *
   * <pre>
   * Deprecated: Use `cards_v2` instead.
   *
   * Rich, formatted, and interactive cards that you can use to display UI
   * elements such as: formatted texts, buttons, and clickable images. Cards are
   * normally displayed below the plain-text body of the message. `cards` and
   * `cards_v2` can have a maximum size of 32 KB.
   * </pre>
   *
   * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.chat.v1.ContextualAddOnMarkup.Card getCards(int index) {
    return cards_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Deprecated: Use `cards_v2` instead.
   *
   * Rich, formatted, and interactive cards that you can use to display UI
   * elements such as: formatted texts, buttons, and clickable images. Cards are
   * normally displayed below the plain-text body of the message. `cards` and
   * `cards_v2` can have a maximum size of 32 KB.
   * </pre>
   *
   * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.chat.v1.ContextualAddOnMarkup.CardOrBuilder getCardsOrBuilder(int index) {
    return cards_.get(index);
  }

  public static final int CARDS_V2_FIELD_NUMBER = 22;

  @SuppressWarnings("serial")
  private java.util.List<com.google.chat.v1.CardWithId> cardsV2_;

  /**
   *
   *
   * <pre>
   * Optional. An array of
   * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
   *
   * Only Chat apps can create cards. If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the messages can't contain cards.
   *
   * To learn how to create a message that contains cards, see [Send a
   * message](https://developers.google.com/workspace/chat/create-messages).
   *
   * [Card builder](https://addons.gsuite.google.com/uikit/builder)
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.chat.v1.CardWithId> getCardsV2List() {
    return cardsV2_;
  }

  /**
   *
   *
   * <pre>
   * Optional. An array of
   * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
   *
   * Only Chat apps can create cards. If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the messages can't contain cards.
   *
   * To learn how to create a message that contains cards, see [Send a
   * message](https://developers.google.com/workspace/chat/create-messages).
   *
   * [Card builder](https://addons.gsuite.google.com/uikit/builder)
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.chat.v1.CardWithIdOrBuilder>
      getCardsV2OrBuilderList() {
    return cardsV2_;
  }

  /**
   *
   *
   * <pre>
   * Optional. An array of
   * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
   *
   * Only Chat apps can create cards. If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the messages can't contain cards.
   *
   * To learn how to create a message that contains cards, see [Send a
   * message](https://developers.google.com/workspace/chat/create-messages).
   *
   * [Card builder](https://addons.gsuite.google.com/uikit/builder)
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getCardsV2Count() {
    return cardsV2_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. An array of
   * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
   *
   * Only Chat apps can create cards. If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the messages can't contain cards.
   *
   * To learn how to create a message that contains cards, see [Send a
   * message](https://developers.google.com/workspace/chat/create-messages).
   *
   * [Card builder](https://addons.gsuite.google.com/uikit/builder)
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.CardWithId getCardsV2(int index) {
    return cardsV2_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. An array of
   * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
   *
   * Only Chat apps can create cards. If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the messages can't contain cards.
   *
   * To learn how to create a message that contains cards, see [Send a
   * message](https://developers.google.com/workspace/chat/create-messages).
   *
   * [Card builder](https://addons.gsuite.google.com/uikit/builder)
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.CardWithIdOrBuilder getCardsV2OrBuilder(int index) {
    return cardsV2_.get(index);
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.chat.v1.Annotation> annotations_;

  /**
   *
   *
   * <pre>
   * Output only. Annotations associated with the `text` in this message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.chat.v1.Annotation> getAnnotationsList() {
    return annotations_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Annotations associated with the `text` in this message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.chat.v1.AnnotationOrBuilder>
      getAnnotationsOrBuilderList() {
    return annotations_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Annotations associated with the `text` in this message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getAnnotationsCount() {
    return annotations_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. Annotations associated with the `text` in this message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.Annotation getAnnotations(int index) {
    return annotations_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. Annotations associated with the `text` in this message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.AnnotationOrBuilder getAnnotationsOrBuilder(int index) {
    return annotations_.get(index);
  }

  public static final int THREAD_FIELD_NUMBER = 11;
  private com.google.chat.v1.Thread thread_;

  /**
   *
   *
   * <pre>
   * The thread the message belongs to. For example usage, see
   * [Start or reply to a message
   * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
   * </pre>
   *
   * <code>.google.chat.v1.Thread thread = 11;</code>
   *
   * @return Whether the thread field is set.
   */
  @java.lang.Override
  public boolean hasThread() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * The thread the message belongs to. For example usage, see
   * [Start or reply to a message
   * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
   * </pre>
   *
   * <code>.google.chat.v1.Thread thread = 11;</code>
   *
   * @return The thread.
   */
  @java.lang.Override
  public com.google.chat.v1.Thread getThread() {
    return thread_ == null ? com.google.chat.v1.Thread.getDefaultInstance() : thread_;
  }

  /**
   *
   *
   * <pre>
   * The thread the message belongs to. For example usage, see
   * [Start or reply to a message
   * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
   * </pre>
   *
   * <code>.google.chat.v1.Thread thread = 11;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.ThreadOrBuilder getThreadOrBuilder() {
    return thread_ == null ? com.google.chat.v1.Thread.getDefaultInstance() : thread_;
  }

  public static final int SPACE_FIELD_NUMBER = 12;
  private com.google.chat.v1.Space space_;

  /**
   *
   *
   * <pre>
   * Output only. If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the output only populates the
   * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
   * `name`.
   * </pre>
   *
   * <code>.google.chat.v1.Space space = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the space field is set.
   */
  @java.lang.Override
  public boolean hasSpace() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the output only populates the
   * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
   * `name`.
   * </pre>
   *
   * <code>.google.chat.v1.Space space = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The space.
   */
  @java.lang.Override
  public com.google.chat.v1.Space getSpace() {
    return space_ == null ? com.google.chat.v1.Space.getDefaultInstance() : space_;
  }

  /**
   *
   *
   * <pre>
   * Output only. If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the output only populates the
   * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
   * `name`.
   * </pre>
   *
   * <code>.google.chat.v1.Space space = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.chat.v1.SpaceOrBuilder getSpaceOrBuilder() {
    return space_ == null ? com.google.chat.v1.Space.getDefaultInstance() : space_;
  }

  public static final int FALLBACK_TEXT_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fallbackText_ = "";

  /**
   *
   *
   * <pre>
   * Optional. A plain-text description of the message's cards, used when the
   * actual cards can't be displayed—for example, mobile notifications.
   * </pre>
   *
   * <code>string fallback_text = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The fallbackText.
   */
  @java.lang.Override
  public java.lang.String getFallbackText() {
    java.lang.Object ref = fallbackText_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fallbackText_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. A plain-text description of the message's cards, used when the
   * actual cards can't be displayed—for example, mobile notifications.
   * </pre>
   *
   * <code>string fallback_text = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for fallbackText.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFallbackTextBytes() {
    java.lang.Object ref = fallbackText_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fallbackText_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACTION_RESPONSE_FIELD_NUMBER = 14;
  private com.google.chat.v1.ActionResponse actionResponse_;

  /**
   *
   *
   * <pre>
   * Input only. Parameters that a Chat app can use to configure how its
   * response is posted.
   * </pre>
   *
   * <code>
   * .google.chat.v1.ActionResponse action_response = 14 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return Whether the actionResponse field is set.
   */
  @java.lang.Override
  public boolean hasActionResponse() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Input only. Parameters that a Chat app can use to configure how its
   * response is posted.
   * </pre>
   *
   * <code>
   * .google.chat.v1.ActionResponse action_response = 14 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The actionResponse.
   */
  @java.lang.Override
  public com.google.chat.v1.ActionResponse getActionResponse() {
    return actionResponse_ == null
        ? com.google.chat.v1.ActionResponse.getDefaultInstance()
        : actionResponse_;
  }

  /**
   *
   *
   * <pre>
   * Input only. Parameters that a Chat app can use to configure how its
   * response is posted.
   * </pre>
   *
   * <code>
   * .google.chat.v1.ActionResponse action_response = 14 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.ActionResponseOrBuilder getActionResponseOrBuilder() {
    return actionResponse_ == null
        ? com.google.chat.v1.ActionResponse.getDefaultInstance()
        : actionResponse_;
  }

  public static final int ARGUMENT_TEXT_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object argumentText_ = "";

  /**
   *
   *
   * <pre>
   * Output only. Plain-text body of the message with all Chat app mentions
   * stripped out.
   * </pre>
   *
   * <code>string argument_text = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The argumentText.
   */
  @java.lang.Override
  public java.lang.String getArgumentText() {
    java.lang.Object ref = argumentText_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      argumentText_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Plain-text body of the message with all Chat app mentions
   * stripped out.
   * </pre>
   *
   * <code>string argument_text = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for argumentText.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getArgumentTextBytes() {
    java.lang.Object ref = argumentText_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      argumentText_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SLASH_COMMAND_FIELD_NUMBER = 17;
  private com.google.chat.v1.SlashCommand slashCommand_;

  /**
   *
   *
   * <pre>
   * Output only. Slash command information, if applicable.
   * </pre>
   *
   * <code>
   * .google.chat.v1.SlashCommand slash_command = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the slashCommand field is set.
   */
  @java.lang.Override
  public boolean hasSlashCommand() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Slash command information, if applicable.
   * </pre>
   *
   * <code>
   * .google.chat.v1.SlashCommand slash_command = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The slashCommand.
   */
  @java.lang.Override
  public com.google.chat.v1.SlashCommand getSlashCommand() {
    return slashCommand_ == null
        ? com.google.chat.v1.SlashCommand.getDefaultInstance()
        : slashCommand_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Slash command information, if applicable.
   * </pre>
   *
   * <code>
   * .google.chat.v1.SlashCommand slash_command = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.SlashCommandOrBuilder getSlashCommandOrBuilder() {
    return slashCommand_ == null
        ? com.google.chat.v1.SlashCommand.getDefaultInstance()
        : slashCommand_;
  }

  public static final int ATTACHMENT_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private java.util.List<com.google.chat.v1.Attachment> attachment_;

  /**
   *
   *
   * <pre>
   * Optional. User-uploaded attachment.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.chat.v1.Attachment> getAttachmentList() {
    return attachment_;
  }

  /**
   *
   *
   * <pre>
   * Optional. User-uploaded attachment.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.chat.v1.AttachmentOrBuilder>
      getAttachmentOrBuilderList() {
    return attachment_;
  }

  /**
   *
   *
   * <pre>
   * Optional. User-uploaded attachment.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getAttachmentCount() {
    return attachment_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. User-uploaded attachment.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.Attachment getAttachment(int index) {
    return attachment_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. User-uploaded attachment.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.AttachmentOrBuilder getAttachmentOrBuilder(int index) {
    return attachment_.get(index);
  }

  public static final int MATCHED_URL_FIELD_NUMBER = 20;
  private com.google.chat.v1.MatchedUrl matchedUrl_;

  /**
   *
   *
   * <pre>
   * Output only. A URL in `spaces.messages.text` that matches a link preview
   * pattern. For more information, see [Preview
   * links](https://developers.google.com/workspace/chat/preview-links).
   * </pre>
   *
   * <code>.google.chat.v1.MatchedUrl matched_url = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the matchedUrl field is set.
   */
  @java.lang.Override
  public boolean hasMatchedUrl() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. A URL in `spaces.messages.text` that matches a link preview
   * pattern. For more information, see [Preview
   * links](https://developers.google.com/workspace/chat/preview-links).
   * </pre>
   *
   * <code>.google.chat.v1.MatchedUrl matched_url = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The matchedUrl.
   */
  @java.lang.Override
  public com.google.chat.v1.MatchedUrl getMatchedUrl() {
    return matchedUrl_ == null ? com.google.chat.v1.MatchedUrl.getDefaultInstance() : matchedUrl_;
  }

  /**
   *
   *
   * <pre>
   * Output only. A URL in `spaces.messages.text` that matches a link preview
   * pattern. For more information, see [Preview
   * links](https://developers.google.com/workspace/chat/preview-links).
   * </pre>
   *
   * <code>.google.chat.v1.MatchedUrl matched_url = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.MatchedUrlOrBuilder getMatchedUrlOrBuilder() {
    return matchedUrl_ == null ? com.google.chat.v1.MatchedUrl.getDefaultInstance() : matchedUrl_;
  }

  public static final int THREAD_REPLY_FIELD_NUMBER = 25;
  private boolean threadReply_ = false;

  /**
   *
   *
   * <pre>
   * Output only. When `true`, the message is a response in a reply thread. When
   * `false`, the message is visible in the space's top-level conversation as
   * either the first message of a thread or a message with no threaded replies.
   *
   * If the space doesn't support reply in threads, this field is always
   * `false`.
   * </pre>
   *
   * <code>bool thread_reply = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The threadReply.
   */
  @java.lang.Override
  public boolean getThreadReply() {
    return threadReply_;
  }

  public static final int CLIENT_ASSIGNED_MESSAGE_ID_FIELD_NUMBER = 32;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clientAssignedMessageId_ = "";

  /**
   *
   *
   * <pre>
   * Optional. A custom ID for the message. You can use field to identify a
   * message, or to get, delete, or update a message. To set a custom ID,
   * specify the
   * [`messageId`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages/create#body.QUERY_PARAMETERS.message_id)
   * field when you create the message. For details, see [Name a
   * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
   * </pre>
   *
   * <code>string client_assigned_message_id = 32 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The clientAssignedMessageId.
   */
  @java.lang.Override
  public java.lang.String getClientAssignedMessageId() {
    java.lang.Object ref = clientAssignedMessageId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clientAssignedMessageId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. A custom ID for the message. You can use field to identify a
   * message, or to get, delete, or update a message. To set a custom ID,
   * specify the
   * [`messageId`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages/create#body.QUERY_PARAMETERS.message_id)
   * field when you create the message. For details, see [Name a
   * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
   * </pre>
   *
   * <code>string client_assigned_message_id = 32 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for clientAssignedMessageId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClientAssignedMessageIdBytes() {
    java.lang.Object ref = clientAssignedMessageId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clientAssignedMessageId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EMOJI_REACTION_SUMMARIES_FIELD_NUMBER = 33;

  @SuppressWarnings("serial")
  private java.util.List<com.google.chat.v1.EmojiReactionSummary> emojiReactionSummaries_;

  /**
   *
   *
   * <pre>
   * Output only. The list of emoji reaction summaries on the message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.chat.v1.EmojiReactionSummary> getEmojiReactionSummariesList() {
    return emojiReactionSummaries_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The list of emoji reaction summaries on the message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.chat.v1.EmojiReactionSummaryOrBuilder>
      getEmojiReactionSummariesOrBuilderList() {
    return emojiReactionSummaries_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The list of emoji reaction summaries on the message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getEmojiReactionSummariesCount() {
    return emojiReactionSummaries_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. The list of emoji reaction summaries on the message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.EmojiReactionSummary getEmojiReactionSummaries(int index) {
    return emojiReactionSummaries_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. The list of emoji reaction summaries on the message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.EmojiReactionSummaryOrBuilder getEmojiReactionSummariesOrBuilder(
      int index) {
    return emojiReactionSummaries_.get(index);
  }

  public static final int PRIVATE_MESSAGE_VIEWER_FIELD_NUMBER = 36;
  private com.google.chat.v1.User privateMessageViewer_;

  /**
   *
   *
   * <pre>
   * Optional. Immutable. Input for creating a message, otherwise output only.
   * The user that can view the message. When set, the message is private and
   * only visible to the specified user and the Chat app. To include this field
   * in your request, you must call the Chat API using [app
   * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
   * and omit the following:
   *
   * * [Attachments](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.attachments)
   * * [Accessory
   * widgets](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#Message.AccessoryWidget)
   *
   * For details, see [Send a message
   * privately](https://developers.google.com/workspace/chat/create-messages#private).
   * </pre>
   *
   * <code>
   * .google.chat.v1.User private_message_viewer = 36 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the privateMessageViewer field is set.
   */
  @java.lang.Override
  public boolean hasPrivateMessageViewer() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. Input for creating a message, otherwise output only.
   * The user that can view the message. When set, the message is private and
   * only visible to the specified user and the Chat app. To include this field
   * in your request, you must call the Chat API using [app
   * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
   * and omit the following:
   *
   * * [Attachments](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.attachments)
   * * [Accessory
   * widgets](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#Message.AccessoryWidget)
   *
   * For details, see [Send a message
   * privately](https://developers.google.com/workspace/chat/create-messages#private).
   * </pre>
   *
   * <code>
   * .google.chat.v1.User private_message_viewer = 36 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The privateMessageViewer.
   */
  @java.lang.Override
  public com.google.chat.v1.User getPrivateMessageViewer() {
    return privateMessageViewer_ == null
        ? com.google.chat.v1.User.getDefaultInstance()
        : privateMessageViewer_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. Input for creating a message, otherwise output only.
   * The user that can view the message. When set, the message is private and
   * only visible to the specified user and the Chat app. To include this field
   * in your request, you must call the Chat API using [app
   * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
   * and omit the following:
   *
   * * [Attachments](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.attachments)
   * * [Accessory
   * widgets](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#Message.AccessoryWidget)
   *
   * For details, see [Send a message
   * privately](https://developers.google.com/workspace/chat/create-messages#private).
   * </pre>
   *
   * <code>
   * .google.chat.v1.User private_message_viewer = 36 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.UserOrBuilder getPrivateMessageViewerOrBuilder() {
    return privateMessageViewer_ == null
        ? com.google.chat.v1.User.getDefaultInstance()
        : privateMessageViewer_;
  }

  public static final int DELETION_METADATA_FIELD_NUMBER = 38;
  private com.google.chat.v1.DeletionMetadata deletionMetadata_;

  /**
   *
   *
   * <pre>
   * Output only. Information about a deleted message. A message is deleted when
   * `delete_time` is set.
   * </pre>
   *
   * <code>
   * .google.chat.v1.DeletionMetadata deletion_metadata = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deletionMetadata field is set.
   */
  @java.lang.Override
  public boolean hasDeletionMetadata() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Information about a deleted message. A message is deleted when
   * `delete_time` is set.
   * </pre>
   *
   * <code>
   * .google.chat.v1.DeletionMetadata deletion_metadata = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deletionMetadata.
   */
  @java.lang.Override
  public com.google.chat.v1.DeletionMetadata getDeletionMetadata() {
    return deletionMetadata_ == null
        ? com.google.chat.v1.DeletionMetadata.getDefaultInstance()
        : deletionMetadata_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Information about a deleted message. A message is deleted when
   * `delete_time` is set.
   * </pre>
   *
   * <code>
   * .google.chat.v1.DeletionMetadata deletion_metadata = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.DeletionMetadataOrBuilder getDeletionMetadataOrBuilder() {
    return deletionMetadata_ == null
        ? com.google.chat.v1.DeletionMetadata.getDefaultInstance()
        : deletionMetadata_;
  }

  public static final int QUOTED_MESSAGE_METADATA_FIELD_NUMBER = 39;
  private com.google.chat.v1.QuotedMessageMetadata quotedMessageMetadata_;

  /**
   *
   *
   * <pre>
   * Output only. Information about a message that's quoted by a Google Chat
   * user in a space. Google Chat users can quote a message to reply to it.
   * </pre>
   *
   * <code>
   * .google.chat.v1.QuotedMessageMetadata quoted_message_metadata = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the quotedMessageMetadata field is set.
   */
  @java.lang.Override
  public boolean hasQuotedMessageMetadata() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Information about a message that's quoted by a Google Chat
   * user in a space. Google Chat users can quote a message to reply to it.
   * </pre>
   *
   * <code>
   * .google.chat.v1.QuotedMessageMetadata quoted_message_metadata = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The quotedMessageMetadata.
   */
  @java.lang.Override
  public com.google.chat.v1.QuotedMessageMetadata getQuotedMessageMetadata() {
    return quotedMessageMetadata_ == null
        ? com.google.chat.v1.QuotedMessageMetadata.getDefaultInstance()
        : quotedMessageMetadata_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Information about a message that's quoted by a Google Chat
   * user in a space. Google Chat users can quote a message to reply to it.
   * </pre>
   *
   * <code>
   * .google.chat.v1.QuotedMessageMetadata quoted_message_metadata = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.QuotedMessageMetadataOrBuilder getQuotedMessageMetadataOrBuilder() {
    return quotedMessageMetadata_ == null
        ? com.google.chat.v1.QuotedMessageMetadata.getDefaultInstance()
        : quotedMessageMetadata_;
  }

  public static final int ATTACHED_GIFS_FIELD_NUMBER = 42;

  @SuppressWarnings("serial")
  private java.util.List<com.google.chat.v1.AttachedGif> attachedGifs_;

  /**
   *
   *
   * <pre>
   * Output only. GIF images that are attached to the message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.chat.v1.AttachedGif> getAttachedGifsList() {
    return attachedGifs_;
  }

  /**
   *
   *
   * <pre>
   * Output only. GIF images that are attached to the message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.chat.v1.AttachedGifOrBuilder>
      getAttachedGifsOrBuilderList() {
    return attachedGifs_;
  }

  /**
   *
   *
   * <pre>
   * Output only. GIF images that are attached to the message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getAttachedGifsCount() {
    return attachedGifs_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. GIF images that are attached to the message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.AttachedGif getAttachedGifs(int index) {
    return attachedGifs_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. GIF images that are attached to the message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.AttachedGifOrBuilder getAttachedGifsOrBuilder(int index) {
    return attachedGifs_.get(index);
  }

  public static final int ACCESSORY_WIDGETS_FIELD_NUMBER = 44;

  @SuppressWarnings("serial")
  private java.util.List<com.google.chat.v1.AccessoryWidget> accessoryWidgets_;

  /**
   *
   *
   * <pre>
   * Optional. One or more interactive widgets that appear at the bottom of a
   * message. You can add accessory widgets to messages that contain text,
   * cards, or both text and cards. Not supported for messages that contain
   * dialogs. For details, see [Add interactive widgets at the bottom of a
   * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
   *
   * Creating a message with accessory widgets requires [app
   * authentication]
   * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.chat.v1.AccessoryWidget> getAccessoryWidgetsList() {
    return accessoryWidgets_;
  }

  /**
   *
   *
   * <pre>
   * Optional. One or more interactive widgets that appear at the bottom of a
   * message. You can add accessory widgets to messages that contain text,
   * cards, or both text and cards. Not supported for messages that contain
   * dialogs. For details, see [Add interactive widgets at the bottom of a
   * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
   *
   * Creating a message with accessory widgets requires [app
   * authentication]
   * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.chat.v1.AccessoryWidgetOrBuilder>
      getAccessoryWidgetsOrBuilderList() {
    return accessoryWidgets_;
  }

  /**
   *
   *
   * <pre>
   * Optional. One or more interactive widgets that appear at the bottom of a
   * message. You can add accessory widgets to messages that contain text,
   * cards, or both text and cards. Not supported for messages that contain
   * dialogs. For details, see [Add interactive widgets at the bottom of a
   * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
   *
   * Creating a message with accessory widgets requires [app
   * authentication]
   * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getAccessoryWidgetsCount() {
    return accessoryWidgets_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. One or more interactive widgets that appear at the bottom of a
   * message. You can add accessory widgets to messages that contain text,
   * cards, or both text and cards. Not supported for messages that contain
   * dialogs. For details, see [Add interactive widgets at the bottom of a
   * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
   *
   * Creating a message with accessory widgets requires [app
   * authentication]
   * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.AccessoryWidget getAccessoryWidgets(int index) {
    return accessoryWidgets_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. One or more interactive widgets that appear at the bottom of a
   * message. You can add accessory widgets to messages that contain text,
   * cards, or both text and cards. Not supported for messages that contain
   * dialogs. For details, see [Add interactive widgets at the bottom of a
   * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
   *
   * Creating a message with accessory widgets requires [app
   * authentication]
   * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.AccessoryWidgetOrBuilder getAccessoryWidgetsOrBuilder(int index) {
    return accessoryWidgets_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getSender());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, text_);
    }
    for (int i = 0; i < cards_.size(); i++) {
      output.writeMessage(5, cards_.get(i));
    }
    for (int i = 0; i < annotations_.size(); i++) {
      output.writeMessage(10, annotations_.get(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(11, getThread());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(12, getSpace());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fallbackText_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, fallbackText_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(14, getActionResponse());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(argumentText_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, argumentText_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(17, getSlashCommand());
    }
    for (int i = 0; i < attachment_.size(); i++) {
      output.writeMessage(18, attachment_.get(i));
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(20, getMatchedUrl());
    }
    for (int i = 0; i < cardsV2_.size(); i++) {
      output.writeMessage(22, cardsV2_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(23, getLastUpdateTime());
    }
    if (threadReply_ != false) {
      output.writeBool(25, threadReply_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(26, getDeleteTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientAssignedMessageId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 32, clientAssignedMessageId_);
    }
    for (int i = 0; i < emojiReactionSummaries_.size(); i++) {
      output.writeMessage(33, emojiReactionSummaries_.get(i));
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(36, getPrivateMessageViewer());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(38, getDeletionMetadata());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeMessage(39, getQuotedMessageMetadata());
    }
    for (int i = 0; i < attachedGifs_.size(); i++) {
      output.writeMessage(42, attachedGifs_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(formattedText_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 43, formattedText_);
    }
    for (int i = 0; i < accessoryWidgets_.size(); i++) {
      output.writeMessage(44, accessoryWidgets_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSender());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, text_);
    }
    for (int i = 0; i < cards_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, cards_.get(i));
    }
    for (int i = 0; i < annotations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, annotations_.get(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getThread());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getSpace());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fallbackText_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, fallbackText_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getActionResponse());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(argumentText_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, argumentText_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getSlashCommand());
    }
    for (int i = 0; i < attachment_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, attachment_.get(i));
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getMatchedUrl());
    }
    for (int i = 0; i < cardsV2_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, cardsV2_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getLastUpdateTime());
    }
    if (threadReply_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(25, threadReply_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(26, getDeleteTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientAssignedMessageId_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(32, clientAssignedMessageId_);
    }
    for (int i = 0; i < emojiReactionSummaries_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              33, emojiReactionSummaries_.get(i));
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(36, getPrivateMessageViewer());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(38, getDeletionMetadata());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(39, getQuotedMessageMetadata());
    }
    for (int i = 0; i < attachedGifs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(42, attachedGifs_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(formattedText_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(43, formattedText_);
    }
    for (int i = 0; i < accessoryWidgets_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(44, accessoryWidgets_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.Message)) {
      return super.equals(obj);
    }
    com.google.chat.v1.Message other = (com.google.chat.v1.Message) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasSender() != other.hasSender()) return false;
    if (hasSender()) {
      if (!getSender().equals(other.getSender())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasLastUpdateTime() != other.hasLastUpdateTime()) return false;
    if (hasLastUpdateTime()) {
      if (!getLastUpdateTime().equals(other.getLastUpdateTime())) return false;
    }
    if (hasDeleteTime() != other.hasDeleteTime()) return false;
    if (hasDeleteTime()) {
      if (!getDeleteTime().equals(other.getDeleteTime())) return false;
    }
    if (!getText().equals(other.getText())) return false;
    if (!getFormattedText().equals(other.getFormattedText())) return false;
    if (!getCardsList().equals(other.getCardsList())) return false;
    if (!getCardsV2List().equals(other.getCardsV2List())) return false;
    if (!getAnnotationsList().equals(other.getAnnotationsList())) return false;
    if (hasThread() != other.hasThread()) return false;
    if (hasThread()) {
      if (!getThread().equals(other.getThread())) return false;
    }
    if (hasSpace() != other.hasSpace()) return false;
    if (hasSpace()) {
      if (!getSpace().equals(other.getSpace())) return false;
    }
    if (!getFallbackText().equals(other.getFallbackText())) return false;
    if (hasActionResponse() != other.hasActionResponse()) return false;
    if (hasActionResponse()) {
      if (!getActionResponse().equals(other.getActionResponse())) return false;
    }
    if (!getArgumentText().equals(other.getArgumentText())) return false;
    if (hasSlashCommand() != other.hasSlashCommand()) return false;
    if (hasSlashCommand()) {
      if (!getSlashCommand().equals(other.getSlashCommand())) return false;
    }
    if (!getAttachmentList().equals(other.getAttachmentList())) return false;
    if (hasMatchedUrl() != other.hasMatchedUrl()) return false;
    if (hasMatchedUrl()) {
      if (!getMatchedUrl().equals(other.getMatchedUrl())) return false;
    }
    if (getThreadReply() != other.getThreadReply()) return false;
    if (!getClientAssignedMessageId().equals(other.getClientAssignedMessageId())) return false;
    if (!getEmojiReactionSummariesList().equals(other.getEmojiReactionSummariesList()))
      return false;
    if (hasPrivateMessageViewer() != other.hasPrivateMessageViewer()) return false;
    if (hasPrivateMessageViewer()) {
      if (!getPrivateMessageViewer().equals(other.getPrivateMessageViewer())) return false;
    }
    if (hasDeletionMetadata() != other.hasDeletionMetadata()) return false;
    if (hasDeletionMetadata()) {
      if (!getDeletionMetadata().equals(other.getDeletionMetadata())) return false;
    }
    if (hasQuotedMessageMetadata() != other.hasQuotedMessageMetadata()) return false;
    if (hasQuotedMessageMetadata()) {
      if (!getQuotedMessageMetadata().equals(other.getQuotedMessageMetadata())) return false;
    }
    if (!getAttachedGifsList().equals(other.getAttachedGifsList())) return false;
    if (!getAccessoryWidgetsList().equals(other.getAccessoryWidgetsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasSender()) {
      hash = (37 * hash) + SENDER_FIELD_NUMBER;
      hash = (53 * hash) + getSender().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasLastUpdateTime()) {
      hash = (37 * hash) + LAST_UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastUpdateTime().hashCode();
    }
    if (hasDeleteTime()) {
      hash = (37 * hash) + DELETE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDeleteTime().hashCode();
    }
    hash = (37 * hash) + TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getText().hashCode();
    hash = (37 * hash) + FORMATTED_TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getFormattedText().hashCode();
    if (getCardsCount() > 0) {
      hash = (37 * hash) + CARDS_FIELD_NUMBER;
      hash = (53 * hash) + getCardsList().hashCode();
    }
    if (getCardsV2Count() > 0) {
      hash = (37 * hash) + CARDS_V2_FIELD_NUMBER;
      hash = (53 * hash) + getCardsV2List().hashCode();
    }
    if (getAnnotationsCount() > 0) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getAnnotationsList().hashCode();
    }
    if (hasThread()) {
      hash = (37 * hash) + THREAD_FIELD_NUMBER;
      hash = (53 * hash) + getThread().hashCode();
    }
    if (hasSpace()) {
      hash = (37 * hash) + SPACE_FIELD_NUMBER;
      hash = (53 * hash) + getSpace().hashCode();
    }
    hash = (37 * hash) + FALLBACK_TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getFallbackText().hashCode();
    if (hasActionResponse()) {
      hash = (37 * hash) + ACTION_RESPONSE_FIELD_NUMBER;
      hash = (53 * hash) + getActionResponse().hashCode();
    }
    hash = (37 * hash) + ARGUMENT_TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getArgumentText().hashCode();
    if (hasSlashCommand()) {
      hash = (37 * hash) + SLASH_COMMAND_FIELD_NUMBER;
      hash = (53 * hash) + getSlashCommand().hashCode();
    }
    if (getAttachmentCount() > 0) {
      hash = (37 * hash) + ATTACHMENT_FIELD_NUMBER;
      hash = (53 * hash) + getAttachmentList().hashCode();
    }
    if (hasMatchedUrl()) {
      hash = (37 * hash) + MATCHED_URL_FIELD_NUMBER;
      hash = (53 * hash) + getMatchedUrl().hashCode();
    }
    hash = (37 * hash) + THREAD_REPLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getThreadReply());
    hash = (37 * hash) + CLIENT_ASSIGNED_MESSAGE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getClientAssignedMessageId().hashCode();
    if (getEmojiReactionSummariesCount() > 0) {
      hash = (37 * hash) + EMOJI_REACTION_SUMMARIES_FIELD_NUMBER;
      hash = (53 * hash) + getEmojiReactionSummariesList().hashCode();
    }
    if (hasPrivateMessageViewer()) {
      hash = (37 * hash) + PRIVATE_MESSAGE_VIEWER_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateMessageViewer().hashCode();
    }
    if (hasDeletionMetadata()) {
      hash = (37 * hash) + DELETION_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getDeletionMetadata().hashCode();
    }
    if (hasQuotedMessageMetadata()) {
      hash = (37 * hash) + QUOTED_MESSAGE_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getQuotedMessageMetadata().hashCode();
    }
    if (getAttachedGifsCount() > 0) {
      hash = (37 * hash) + ATTACHED_GIFS_FIELD_NUMBER;
      hash = (53 * hash) + getAttachedGifsList().hashCode();
    }
    if (getAccessoryWidgetsCount() > 0) {
      hash = (37 * hash) + ACCESSORY_WIDGETS_FIELD_NUMBER;
      hash = (53 * hash) + getAccessoryWidgetsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.Message parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.Message parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.Message parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.Message parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.Message parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.Message parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.Message parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.Message parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.Message parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.Message parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.Message parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.Message parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.Message prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A message in a Google Chat space.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.Message}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.Message)
      com.google.chat.v1.MessageOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.MessageProto.internal_static_google_chat_v1_Message_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.MessageProto
          .internal_static_google_chat_v1_Message_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.Message.class, com.google.chat.v1.Message.Builder.class);
    }

    // Construct using com.google.chat.v1.Message.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSenderFieldBuilder();
        getCreateTimeFieldBuilder();
        getLastUpdateTimeFieldBuilder();
        getDeleteTimeFieldBuilder();
        getCardsFieldBuilder();
        getCardsV2FieldBuilder();
        getAnnotationsFieldBuilder();
        getThreadFieldBuilder();
        getSpaceFieldBuilder();
        getActionResponseFieldBuilder();
        getSlashCommandFieldBuilder();
        getAttachmentFieldBuilder();
        getMatchedUrlFieldBuilder();
        getEmojiReactionSummariesFieldBuilder();
        getPrivateMessageViewerFieldBuilder();
        getDeletionMetadataFieldBuilder();
        getQuotedMessageMetadataFieldBuilder();
        getAttachedGifsFieldBuilder();
        getAccessoryWidgetsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      sender_ = null;
      if (senderBuilder_ != null) {
        senderBuilder_.dispose();
        senderBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      lastUpdateTime_ = null;
      if (lastUpdateTimeBuilder_ != null) {
        lastUpdateTimeBuilder_.dispose();
        lastUpdateTimeBuilder_ = null;
      }
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      text_ = "";
      formattedText_ = "";
      if (cardsBuilder_ == null) {
        cards_ = java.util.Collections.emptyList();
      } else {
        cards_ = null;
        cardsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      if (cardsV2Builder_ == null) {
        cardsV2_ = java.util.Collections.emptyList();
      } else {
        cardsV2_ = null;
        cardsV2Builder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      if (annotationsBuilder_ == null) {
        annotations_ = java.util.Collections.emptyList();
      } else {
        annotations_ = null;
        annotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      thread_ = null;
      if (threadBuilder_ != null) {
        threadBuilder_.dispose();
        threadBuilder_ = null;
      }
      space_ = null;
      if (spaceBuilder_ != null) {
        spaceBuilder_.dispose();
        spaceBuilder_ = null;
      }
      fallbackText_ = "";
      actionResponse_ = null;
      if (actionResponseBuilder_ != null) {
        actionResponseBuilder_.dispose();
        actionResponseBuilder_ = null;
      }
      argumentText_ = "";
      slashCommand_ = null;
      if (slashCommandBuilder_ != null) {
        slashCommandBuilder_.dispose();
        slashCommandBuilder_ = null;
      }
      if (attachmentBuilder_ == null) {
        attachment_ = java.util.Collections.emptyList();
      } else {
        attachment_ = null;
        attachmentBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00010000);
      matchedUrl_ = null;
      if (matchedUrlBuilder_ != null) {
        matchedUrlBuilder_.dispose();
        matchedUrlBuilder_ = null;
      }
      threadReply_ = false;
      clientAssignedMessageId_ = "";
      if (emojiReactionSummariesBuilder_ == null) {
        emojiReactionSummaries_ = java.util.Collections.emptyList();
      } else {
        emojiReactionSummaries_ = null;
        emojiReactionSummariesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00100000);
      privateMessageViewer_ = null;
      if (privateMessageViewerBuilder_ != null) {
        privateMessageViewerBuilder_.dispose();
        privateMessageViewerBuilder_ = null;
      }
      deletionMetadata_ = null;
      if (deletionMetadataBuilder_ != null) {
        deletionMetadataBuilder_.dispose();
        deletionMetadataBuilder_ = null;
      }
      quotedMessageMetadata_ = null;
      if (quotedMessageMetadataBuilder_ != null) {
        quotedMessageMetadataBuilder_.dispose();
        quotedMessageMetadataBuilder_ = null;
      }
      if (attachedGifsBuilder_ == null) {
        attachedGifs_ = java.util.Collections.emptyList();
      } else {
        attachedGifs_ = null;
        attachedGifsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x01000000);
      if (accessoryWidgetsBuilder_ == null) {
        accessoryWidgets_ = java.util.Collections.emptyList();
      } else {
        accessoryWidgets_ = null;
        accessoryWidgetsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x02000000);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.MessageProto.internal_static_google_chat_v1_Message_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.Message getDefaultInstanceForType() {
      return com.google.chat.v1.Message.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.Message build() {
      com.google.chat.v1.Message result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.Message buildPartial() {
      com.google.chat.v1.Message result = new com.google.chat.v1.Message(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.chat.v1.Message result) {
      if (cardsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          cards_ = java.util.Collections.unmodifiableList(cards_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.cards_ = cards_;
      } else {
        result.cards_ = cardsBuilder_.build();
      }
      if (cardsV2Builder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          cardsV2_ = java.util.Collections.unmodifiableList(cardsV2_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.cardsV2_ = cardsV2_;
      } else {
        result.cardsV2_ = cardsV2Builder_.build();
      }
      if (annotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          annotations_ = java.util.Collections.unmodifiableList(annotations_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.annotations_ = annotations_;
      } else {
        result.annotations_ = annotationsBuilder_.build();
      }
      if (attachmentBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)) {
          attachment_ = java.util.Collections.unmodifiableList(attachment_);
          bitField0_ = (bitField0_ & ~0x00010000);
        }
        result.attachment_ = attachment_;
      } else {
        result.attachment_ = attachmentBuilder_.build();
      }
      if (emojiReactionSummariesBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)) {
          emojiReactionSummaries_ = java.util.Collections.unmodifiableList(emojiReactionSummaries_);
          bitField0_ = (bitField0_ & ~0x00100000);
        }
        result.emojiReactionSummaries_ = emojiReactionSummaries_;
      } else {
        result.emojiReactionSummaries_ = emojiReactionSummariesBuilder_.build();
      }
      if (attachedGifsBuilder_ == null) {
        if (((bitField0_ & 0x01000000) != 0)) {
          attachedGifs_ = java.util.Collections.unmodifiableList(attachedGifs_);
          bitField0_ = (bitField0_ & ~0x01000000);
        }
        result.attachedGifs_ = attachedGifs_;
      } else {
        result.attachedGifs_ = attachedGifsBuilder_.build();
      }
      if (accessoryWidgetsBuilder_ == null) {
        if (((bitField0_ & 0x02000000) != 0)) {
          accessoryWidgets_ = java.util.Collections.unmodifiableList(accessoryWidgets_);
          bitField0_ = (bitField0_ & ~0x02000000);
        }
        result.accessoryWidgets_ = accessoryWidgets_;
      } else {
        result.accessoryWidgets_ = accessoryWidgetsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.chat.v1.Message result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.sender_ = senderBuilder_ == null ? sender_ : senderBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.lastUpdateTime_ =
            lastUpdateTimeBuilder_ == null ? lastUpdateTime_ : lastUpdateTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.deleteTime_ = deleteTimeBuilder_ == null ? deleteTime_ : deleteTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.text_ = text_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.formattedText_ = formattedText_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.thread_ = threadBuilder_ == null ? thread_ : threadBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.space_ = spaceBuilder_ == null ? space_ : spaceBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.fallbackText_ = fallbackText_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.actionResponse_ =
            actionResponseBuilder_ == null ? actionResponse_ : actionResponseBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.argumentText_ = argumentText_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.slashCommand_ =
            slashCommandBuilder_ == null ? slashCommand_ : slashCommandBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.matchedUrl_ = matchedUrlBuilder_ == null ? matchedUrl_ : matchedUrlBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.threadReply_ = threadReply_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.clientAssignedMessageId_ = clientAssignedMessageId_;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.privateMessageViewer_ =
            privateMessageViewerBuilder_ == null
                ? privateMessageViewer_
                : privateMessageViewerBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.deletionMetadata_ =
            deletionMetadataBuilder_ == null ? deletionMetadata_ : deletionMetadataBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.quotedMessageMetadata_ =
            quotedMessageMetadataBuilder_ == null
                ? quotedMessageMetadata_
                : quotedMessageMetadataBuilder_.build();
        to_bitField0_ |= 0x00000800;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.Message) {
        return mergeFrom((com.google.chat.v1.Message) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.Message other) {
      if (other == com.google.chat.v1.Message.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasSender()) {
        mergeSender(other.getSender());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasLastUpdateTime()) {
        mergeLastUpdateTime(other.getLastUpdateTime());
      }
      if (other.hasDeleteTime()) {
        mergeDeleteTime(other.getDeleteTime());
      }
      if (!other.getText().isEmpty()) {
        text_ = other.text_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getFormattedText().isEmpty()) {
        formattedText_ = other.formattedText_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (cardsBuilder_ == null) {
        if (!other.cards_.isEmpty()) {
          if (cards_.isEmpty()) {
            cards_ = other.cards_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureCardsIsMutable();
            cards_.addAll(other.cards_);
          }
          onChanged();
        }
      } else {
        if (!other.cards_.isEmpty()) {
          if (cardsBuilder_.isEmpty()) {
            cardsBuilder_.dispose();
            cardsBuilder_ = null;
            cards_ = other.cards_;
            bitField0_ = (bitField0_ & ~0x00000080);
            cardsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCardsFieldBuilder()
                    : null;
          } else {
            cardsBuilder_.addAllMessages(other.cards_);
          }
        }
      }
      if (cardsV2Builder_ == null) {
        if (!other.cardsV2_.isEmpty()) {
          if (cardsV2_.isEmpty()) {
            cardsV2_ = other.cardsV2_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureCardsV2IsMutable();
            cardsV2_.addAll(other.cardsV2_);
          }
          onChanged();
        }
      } else {
        if (!other.cardsV2_.isEmpty()) {
          if (cardsV2Builder_.isEmpty()) {
            cardsV2Builder_.dispose();
            cardsV2Builder_ = null;
            cardsV2_ = other.cardsV2_;
            bitField0_ = (bitField0_ & ~0x00000100);
            cardsV2Builder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCardsV2FieldBuilder()
                    : null;
          } else {
            cardsV2Builder_.addAllMessages(other.cardsV2_);
          }
        }
      }
      if (annotationsBuilder_ == null) {
        if (!other.annotations_.isEmpty()) {
          if (annotations_.isEmpty()) {
            annotations_ = other.annotations_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureAnnotationsIsMutable();
            annotations_.addAll(other.annotations_);
          }
          onChanged();
        }
      } else {
        if (!other.annotations_.isEmpty()) {
          if (annotationsBuilder_.isEmpty()) {
            annotationsBuilder_.dispose();
            annotationsBuilder_ = null;
            annotations_ = other.annotations_;
            bitField0_ = (bitField0_ & ~0x00000200);
            annotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAnnotationsFieldBuilder()
                    : null;
          } else {
            annotationsBuilder_.addAllMessages(other.annotations_);
          }
        }
      }
      if (other.hasThread()) {
        mergeThread(other.getThread());
      }
      if (other.hasSpace()) {
        mergeSpace(other.getSpace());
      }
      if (!other.getFallbackText().isEmpty()) {
        fallbackText_ = other.fallbackText_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.hasActionResponse()) {
        mergeActionResponse(other.getActionResponse());
      }
      if (!other.getArgumentText().isEmpty()) {
        argumentText_ = other.argumentText_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasSlashCommand()) {
        mergeSlashCommand(other.getSlashCommand());
      }
      if (attachmentBuilder_ == null) {
        if (!other.attachment_.isEmpty()) {
          if (attachment_.isEmpty()) {
            attachment_ = other.attachment_;
            bitField0_ = (bitField0_ & ~0x00010000);
          } else {
            ensureAttachmentIsMutable();
            attachment_.addAll(other.attachment_);
          }
          onChanged();
        }
      } else {
        if (!other.attachment_.isEmpty()) {
          if (attachmentBuilder_.isEmpty()) {
            attachmentBuilder_.dispose();
            attachmentBuilder_ = null;
            attachment_ = other.attachment_;
            bitField0_ = (bitField0_ & ~0x00010000);
            attachmentBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAttachmentFieldBuilder()
                    : null;
          } else {
            attachmentBuilder_.addAllMessages(other.attachment_);
          }
        }
      }
      if (other.hasMatchedUrl()) {
        mergeMatchedUrl(other.getMatchedUrl());
      }
      if (other.getThreadReply() != false) {
        setThreadReply(other.getThreadReply());
      }
      if (!other.getClientAssignedMessageId().isEmpty()) {
        clientAssignedMessageId_ = other.clientAssignedMessageId_;
        bitField0_ |= 0x00080000;
        onChanged();
      }
      if (emojiReactionSummariesBuilder_ == null) {
        if (!other.emojiReactionSummaries_.isEmpty()) {
          if (emojiReactionSummaries_.isEmpty()) {
            emojiReactionSummaries_ = other.emojiReactionSummaries_;
            bitField0_ = (bitField0_ & ~0x00100000);
          } else {
            ensureEmojiReactionSummariesIsMutable();
            emojiReactionSummaries_.addAll(other.emojiReactionSummaries_);
          }
          onChanged();
        }
      } else {
        if (!other.emojiReactionSummaries_.isEmpty()) {
          if (emojiReactionSummariesBuilder_.isEmpty()) {
            emojiReactionSummariesBuilder_.dispose();
            emojiReactionSummariesBuilder_ = null;
            emojiReactionSummaries_ = other.emojiReactionSummaries_;
            bitField0_ = (bitField0_ & ~0x00100000);
            emojiReactionSummariesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEmojiReactionSummariesFieldBuilder()
                    : null;
          } else {
            emojiReactionSummariesBuilder_.addAllMessages(other.emojiReactionSummaries_);
          }
        }
      }
      if (other.hasPrivateMessageViewer()) {
        mergePrivateMessageViewer(other.getPrivateMessageViewer());
      }
      if (other.hasDeletionMetadata()) {
        mergeDeletionMetadata(other.getDeletionMetadata());
      }
      if (other.hasQuotedMessageMetadata()) {
        mergeQuotedMessageMetadata(other.getQuotedMessageMetadata());
      }
      if (attachedGifsBuilder_ == null) {
        if (!other.attachedGifs_.isEmpty()) {
          if (attachedGifs_.isEmpty()) {
            attachedGifs_ = other.attachedGifs_;
            bitField0_ = (bitField0_ & ~0x01000000);
          } else {
            ensureAttachedGifsIsMutable();
            attachedGifs_.addAll(other.attachedGifs_);
          }
          onChanged();
        }
      } else {
        if (!other.attachedGifs_.isEmpty()) {
          if (attachedGifsBuilder_.isEmpty()) {
            attachedGifsBuilder_.dispose();
            attachedGifsBuilder_ = null;
            attachedGifs_ = other.attachedGifs_;
            bitField0_ = (bitField0_ & ~0x01000000);
            attachedGifsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAttachedGifsFieldBuilder()
                    : null;
          } else {
            attachedGifsBuilder_.addAllMessages(other.attachedGifs_);
          }
        }
      }
      if (accessoryWidgetsBuilder_ == null) {
        if (!other.accessoryWidgets_.isEmpty()) {
          if (accessoryWidgets_.isEmpty()) {
            accessoryWidgets_ = other.accessoryWidgets_;
            bitField0_ = (bitField0_ & ~0x02000000);
          } else {
            ensureAccessoryWidgetsIsMutable();
            accessoryWidgets_.addAll(other.accessoryWidgets_);
          }
          onChanged();
        }
      } else {
        if (!other.accessoryWidgets_.isEmpty()) {
          if (accessoryWidgetsBuilder_.isEmpty()) {
            accessoryWidgetsBuilder_.dispose();
            accessoryWidgetsBuilder_ = null;
            accessoryWidgets_ = other.accessoryWidgets_;
            bitField0_ = (bitField0_ & ~0x02000000);
            accessoryWidgetsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAccessoryWidgetsFieldBuilder()
                    : null;
          } else {
            accessoryWidgetsBuilder_.addAllMessages(other.accessoryWidgets_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getSenderFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                text_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                com.google.chat.v1.ContextualAddOnMarkup.Card m =
                    input.readMessage(
                        com.google.chat.v1.ContextualAddOnMarkup.Card.parser(), extensionRegistry);
                if (cardsBuilder_ == null) {
                  ensureCardsIsMutable();
                  cards_.add(m);
                } else {
                  cardsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 82:
              {
                com.google.chat.v1.Annotation m =
                    input.readMessage(com.google.chat.v1.Annotation.parser(), extensionRegistry);
                if (annotationsBuilder_ == null) {
                  ensureAnnotationsIsMutable();
                  annotations_.add(m);
                } else {
                  annotationsBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getThreadFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getSpaceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 106:
              {
                fallbackText_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getActionResponseFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 114
            case 122:
              {
                argumentText_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 122
            case 138:
              {
                input.readMessage(getSlashCommandFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 138
            case 146:
              {
                com.google.chat.v1.Attachment m =
                    input.readMessage(com.google.chat.v1.Attachment.parser(), extensionRegistry);
                if (attachmentBuilder_ == null) {
                  ensureAttachmentIsMutable();
                  attachment_.add(m);
                } else {
                  attachmentBuilder_.addMessage(m);
                }
                break;
              } // case 146
            case 162:
              {
                input.readMessage(getMatchedUrlFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 162
            case 178:
              {
                com.google.chat.v1.CardWithId m =
                    input.readMessage(com.google.chat.v1.CardWithId.parser(), extensionRegistry);
                if (cardsV2Builder_ == null) {
                  ensureCardsV2IsMutable();
                  cardsV2_.add(m);
                } else {
                  cardsV2Builder_.addMessage(m);
                }
                break;
              } // case 178
            case 186:
              {
                input.readMessage(getLastUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 186
            case 200:
              {
                threadReply_ = input.readBool();
                bitField0_ |= 0x00040000;
                break;
              } // case 200
            case 210:
              {
                input.readMessage(getDeleteTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 210
            case 258:
              {
                clientAssignedMessageId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00080000;
                break;
              } // case 258
            case 266:
              {
                com.google.chat.v1.EmojiReactionSummary m =
                    input.readMessage(
                        com.google.chat.v1.EmojiReactionSummary.parser(), extensionRegistry);
                if (emojiReactionSummariesBuilder_ == null) {
                  ensureEmojiReactionSummariesIsMutable();
                  emojiReactionSummaries_.add(m);
                } else {
                  emojiReactionSummariesBuilder_.addMessage(m);
                }
                break;
              } // case 266
            case 290:
              {
                input.readMessage(
                    getPrivateMessageViewerFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00200000;
                break;
              } // case 290
            case 306:
              {
                input.readMessage(
                    getDeletionMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00400000;
                break;
              } // case 306
            case 314:
              {
                input.readMessage(
                    getQuotedMessageMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00800000;
                break;
              } // case 314
            case 338:
              {
                com.google.chat.v1.AttachedGif m =
                    input.readMessage(com.google.chat.v1.AttachedGif.parser(), extensionRegistry);
                if (attachedGifsBuilder_ == null) {
                  ensureAttachedGifsIsMutable();
                  attachedGifs_.add(m);
                } else {
                  attachedGifsBuilder_.addMessage(m);
                }
                break;
              } // case 338
            case 346:
              {
                formattedText_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 346
            case 354:
              {
                com.google.chat.v1.AccessoryWidget m =
                    input.readMessage(
                        com.google.chat.v1.AccessoryWidget.parser(), extensionRegistry);
                if (accessoryWidgetsBuilder_ == null) {
                  ensureAccessoryWidgetsIsMutable();
                  accessoryWidgets_.add(m);
                } else {
                  accessoryWidgetsBuilder_.addMessage(m);
                }
                break;
              } // case 354
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Identifier. Resource name of the message.
     *
     * Format: `spaces/{space}/messages/{message}`
     *
     *
     * Where `{space}` is the ID of the space where the message is posted and
     * `{message}` is a system-assigned ID for the message. For example,
     * `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`.
     *
     * If you set a custom ID when you create a message, you can use this ID to
     * specify the message in a request by replacing `{message}` with the value
     * from the `clientAssignedMessageId` field. For example,
     * `spaces/AAAAAAAAAAA/messages/client-custom-name`. For details, see [Name
     * a
     * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. Resource name of the message.
     *
     * Format: `spaces/{space}/messages/{message}`
     *
     *
     * Where `{space}` is the ID of the space where the message is posted and
     * `{message}` is a system-assigned ID for the message. For example,
     * `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`.
     *
     * If you set a custom ID when you create a message, you can use this ID to
     * specify the message in a request by replacing `{message}` with the value
     * from the `clientAssignedMessageId` field. For example,
     * `spaces/AAAAAAAAAAA/messages/client-custom-name`. For details, see [Name
     * a
     * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. Resource name of the message.
     *
     * Format: `spaces/{space}/messages/{message}`
     *
     *
     * Where `{space}` is the ID of the space where the message is posted and
     * `{message}` is a system-assigned ID for the message. For example,
     * `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`.
     *
     * If you set a custom ID when you create a message, you can use this ID to
     * specify the message in a request by replacing `{message}` with the value
     * from the `clientAssignedMessageId` field. For example,
     * `spaces/AAAAAAAAAAA/messages/client-custom-name`. For details, see [Name
     * a
     * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. Resource name of the message.
     *
     * Format: `spaces/{space}/messages/{message}`
     *
     *
     * Where `{space}` is the ID of the space where the message is posted and
     * `{message}` is a system-assigned ID for the message. For example,
     * `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`.
     *
     * If you set a custom ID when you create a message, you can use this ID to
     * specify the message in a request by replacing `{message}` with the value
     * from the `clientAssignedMessageId` field. For example,
     * `spaces/AAAAAAAAAAA/messages/client-custom-name`. For details, see [Name
     * a
     * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. Resource name of the message.
     *
     * Format: `spaces/{space}/messages/{message}`
     *
     *
     * Where `{space}` is the ID of the space where the message is posted and
     * `{message}` is a system-assigned ID for the message. For example,
     * `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`.
     *
     * If you set a custom ID when you create a message, you can use this ID to
     * specify the message in a request by replacing `{message}` with the value
     * from the `clientAssignedMessageId` field. For example,
     * `spaces/AAAAAAAAAAA/messages/client-custom-name`. For details, see [Name
     * a
     * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.chat.v1.User sender_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.User,
            com.google.chat.v1.User.Builder,
            com.google.chat.v1.UserOrBuilder>
        senderBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The user who created the message.
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     * `name` and `type`.
     * </pre>
     *
     * <code>.google.chat.v1.User sender = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the sender field is set.
     */
    public boolean hasSender() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The user who created the message.
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     * `name` and `type`.
     * </pre>
     *
     * <code>.google.chat.v1.User sender = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The sender.
     */
    public com.google.chat.v1.User getSender() {
      if (senderBuilder_ == null) {
        return sender_ == null ? com.google.chat.v1.User.getDefaultInstance() : sender_;
      } else {
        return senderBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The user who created the message.
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     * `name` and `type`.
     * </pre>
     *
     * <code>.google.chat.v1.User sender = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setSender(com.google.chat.v1.User value) {
      if (senderBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sender_ = value;
      } else {
        senderBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The user who created the message.
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     * `name` and `type`.
     * </pre>
     *
     * <code>.google.chat.v1.User sender = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setSender(com.google.chat.v1.User.Builder builderForValue) {
      if (senderBuilder_ == null) {
        sender_ = builderForValue.build();
      } else {
        senderBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The user who created the message.
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     * `name` and `type`.
     * </pre>
     *
     * <code>.google.chat.v1.User sender = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeSender(com.google.chat.v1.User value) {
      if (senderBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && sender_ != null
            && sender_ != com.google.chat.v1.User.getDefaultInstance()) {
          getSenderBuilder().mergeFrom(value);
        } else {
          sender_ = value;
        }
      } else {
        senderBuilder_.mergeFrom(value);
      }
      if (sender_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The user who created the message.
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     * `name` and `type`.
     * </pre>
     *
     * <code>.google.chat.v1.User sender = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearSender() {
      bitField0_ = (bitField0_ & ~0x00000002);
      sender_ = null;
      if (senderBuilder_ != null) {
        senderBuilder_.dispose();
        senderBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The user who created the message.
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     * `name` and `type`.
     * </pre>
     *
     * <code>.google.chat.v1.User sender = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.chat.v1.User.Builder getSenderBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getSenderFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The user who created the message.
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     * `name` and `type`.
     * </pre>
     *
     * <code>.google.chat.v1.User sender = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.chat.v1.UserOrBuilder getSenderOrBuilder() {
      if (senderBuilder_ != null) {
        return senderBuilder_.getMessageOrBuilder();
      } else {
        return sender_ == null ? com.google.chat.v1.User.getDefaultInstance() : sender_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The user who created the message.
     * If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output populates the
     * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
     * `name` and `type`.
     * </pre>
     *
     * <code>.google.chat.v1.User sender = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.User,
            com.google.chat.v1.User.Builder,
            com.google.chat.v1.UserOrBuilder>
        getSenderFieldBuilder() {
      if (senderBuilder_ == null) {
        senderBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.User,
                com.google.chat.v1.User.Builder,
                com.google.chat.v1.UserOrBuilder>(getSender(), getParentForChildren(), isClean());
        sender_ = null;
      }
      return senderBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time at which the
     * message was created. This field is output only, except when used in import
     * mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the message was created in the source in order to preserve the original
     * creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time at which the
     * message was created. This field is output only, except when used in import
     * mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the message was created in the source in order to preserve the original
     * creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time at which the
     * message was created. This field is output only, except when used in import
     * mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the message was created in the source in order to preserve the original
     * creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time at which the
     * message was created. This field is output only, except when used in import
     * mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the message was created in the source in order to preserve the original
     * creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time at which the
     * message was created. This field is output only, except when used in import
     * mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the message was created in the source in order to preserve the original
     * creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time at which the
     * message was created. This field is output only, except when used in import
     * mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the message was created in the source in order to preserve the original
     * creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time at which the
     * message was created. This field is output only, except when used in import
     * mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the message was created in the source in order to preserve the original
     * creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time at which the
     * message was created. This field is output only, except when used in import
     * mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the message was created in the source in order to preserve the original
     * creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time at which the
     * message was created. This field is output only, except when used in import
     * mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the message was created in the source in order to preserve the original
     * creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp lastUpdateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastUpdateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The time at which the message was last edited by a user. If
     * the message has never been edited, this field is empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastUpdateTime field is set.
     */
    public boolean hasLastUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the message was last edited by a user. If
     * the message has never been edited, this field is empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastUpdateTime.
     */
    public com.google.protobuf.Timestamp getLastUpdateTime() {
      if (lastUpdateTimeBuilder_ == null) {
        return lastUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastUpdateTime_;
      } else {
        return lastUpdateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the message was last edited by a user. If
     * the message has never been edited, this field is empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastUpdateTime(com.google.protobuf.Timestamp value) {
      if (lastUpdateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastUpdateTime_ = value;
      } else {
        lastUpdateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the message was last edited by a user. If
     * the message has never been edited, this field is empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastUpdateTimeBuilder_ == null) {
        lastUpdateTime_ = builderForValue.build();
      } else {
        lastUpdateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the message was last edited by a user. If
     * the message has never been edited, this field is empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLastUpdateTime(com.google.protobuf.Timestamp value) {
      if (lastUpdateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && lastUpdateTime_ != null
            && lastUpdateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastUpdateTimeBuilder().mergeFrom(value);
        } else {
          lastUpdateTime_ = value;
        }
      } else {
        lastUpdateTimeBuilder_.mergeFrom(value);
      }
      if (lastUpdateTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the message was last edited by a user. If
     * the message has never been edited, this field is empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      lastUpdateTime_ = null;
      if (lastUpdateTimeBuilder_ != null) {
        lastUpdateTimeBuilder_.dispose();
        lastUpdateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the message was last edited by a user. If
     * the message has never been edited, this field is empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getLastUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getLastUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the message was last edited by a user. If
     * the message has never been edited, this field is empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder() {
      if (lastUpdateTimeBuilder_ != null) {
        return lastUpdateTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastUpdateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the message was last edited by a user. If
     * the message has never been edited, this field is empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastUpdateTimeFieldBuilder() {
      if (lastUpdateTimeBuilder_ == null) {
        lastUpdateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastUpdateTime(), getParentForChildren(), isClean());
        lastUpdateTime_ = null;
      }
      return lastUpdateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp deleteTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        deleteTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The time at which the message was deleted in
     * Google Chat. If the message is never deleted, this field is empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deleteTime field is set.
     */
    public boolean hasDeleteTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the message was deleted in
     * Google Chat. If the message is never deleted, this field is empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deleteTime.
     */
    public com.google.protobuf.Timestamp getDeleteTime() {
      if (deleteTimeBuilder_ == null) {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      } else {
        return deleteTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the message was deleted in
     * Google Chat. If the message is never deleted, this field is empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deleteTime_ = value;
      } else {
        deleteTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the message was deleted in
     * Google Chat. If the message is never deleted, this field is empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (deleteTimeBuilder_ == null) {
        deleteTime_ = builderForValue.build();
      } else {
        deleteTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the message was deleted in
     * Google Chat. If the message is never deleted, this field is empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && deleteTime_ != null
            && deleteTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDeleteTimeBuilder().mergeFrom(value);
        } else {
          deleteTime_ = value;
        }
      } else {
        deleteTimeBuilder_.mergeFrom(value);
      }
      if (deleteTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the message was deleted in
     * Google Chat. If the message is never deleted, this field is empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeleteTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the message was deleted in
     * Google Chat. If the message is never deleted, this field is empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDeleteTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getDeleteTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the message was deleted in
     * Google Chat. If the message is never deleted, this field is empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
      if (deleteTimeBuilder_ != null) {
        return deleteTimeBuilder_.getMessageOrBuilder();
      } else {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the message was deleted in
     * Google Chat. If the message is never deleted, this field is empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDeleteTimeFieldBuilder() {
      if (deleteTimeBuilder_ == null) {
        deleteTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDeleteTime(), getParentForChildren(), isClean());
        deleteTime_ = null;
      }
      return deleteTimeBuilder_;
    }

    private java.lang.Object text_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Plain-text body of the message. The first link to an image,
     * video, or web page generates a [preview
     * chip](https://developers.google.com/workspace/chat/preview-links). You can
     * also [&#64;mention a Google Chat
     * user](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention),
     * or everyone in the space.
     *
     * To learn about creating text messages, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     * </pre>
     *
     * <code>string text = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The text.
     */
    public java.lang.String getText() {
      java.lang.Object ref = text_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        text_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Plain-text body of the message. The first link to an image,
     * video, or web page generates a [preview
     * chip](https://developers.google.com/workspace/chat/preview-links). You can
     * also [&#64;mention a Google Chat
     * user](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention),
     * or everyone in the space.
     *
     * To learn about creating text messages, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     * </pre>
     *
     * <code>string text = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for text.
     */
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = text_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        text_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Plain-text body of the message. The first link to an image,
     * video, or web page generates a [preview
     * chip](https://developers.google.com/workspace/chat/preview-links). You can
     * also [&#64;mention a Google Chat
     * user](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention),
     * or everyone in the space.
     *
     * To learn about creating text messages, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     * </pre>
     *
     * <code>string text = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The text to set.
     * @return This builder for chaining.
     */
    public Builder setText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      text_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Plain-text body of the message. The first link to an image,
     * video, or web page generates a [preview
     * chip](https://developers.google.com/workspace/chat/preview-links). You can
     * also [&#64;mention a Google Chat
     * user](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention),
     * or everyone in the space.
     *
     * To learn about creating text messages, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     * </pre>
     *
     * <code>string text = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearText() {
      text_ = getDefaultInstance().getText();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Plain-text body of the message. The first link to an image,
     * video, or web page generates a [preview
     * chip](https://developers.google.com/workspace/chat/preview-links). You can
     * also [&#64;mention a Google Chat
     * user](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention),
     * or everyone in the space.
     *
     * To learn about creating text messages, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     * </pre>
     *
     * <code>string text = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for text to set.
     * @return This builder for chaining.
     */
    public Builder setTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      text_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object formattedText_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Contains the message `text` with markups added to communicate
     * formatting. This field might not capture all formatting visible in the UI,
     * but includes the following:
     *
     * * [Markup
     * syntax](https://developers.google.com/workspace/chat/format-messages)
     * for bold, italic, strikethrough, monospace, monospace block, and bulleted
     * list.
     *
     * * [User
     * mentions](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention)
     * using the format `&lt;users/{user}&gt;`.
     *
     * * Custom hyperlinks using the format `&lt;{url}|{rendered_text}&gt;` where the
     * first string is the URL and the second is the rendered text—for example,
     * `&lt;http://example.com|custom text&gt;`.
     *
     * * Custom emoji using the format `:{emoji_name}:`—for example, `:smile:`.
     * This doesn't apply to Unicode emoji, such as `U+1F600` for a grinning
     * face emoji.
     *
     * For more information, see [View text formatting sent in a
     * message](https://developers.google.com/workspace/chat/format-messages#view_text_formatting_sent_in_a_message)
     * </pre>
     *
     * <code>string formatted_text = 43 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The formattedText.
     */
    public java.lang.String getFormattedText() {
      java.lang.Object ref = formattedText_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        formattedText_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Contains the message `text` with markups added to communicate
     * formatting. This field might not capture all formatting visible in the UI,
     * but includes the following:
     *
     * * [Markup
     * syntax](https://developers.google.com/workspace/chat/format-messages)
     * for bold, italic, strikethrough, monospace, monospace block, and bulleted
     * list.
     *
     * * [User
     * mentions](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention)
     * using the format `&lt;users/{user}&gt;`.
     *
     * * Custom hyperlinks using the format `&lt;{url}|{rendered_text}&gt;` where the
     * first string is the URL and the second is the rendered text—for example,
     * `&lt;http://example.com|custom text&gt;`.
     *
     * * Custom emoji using the format `:{emoji_name}:`—for example, `:smile:`.
     * This doesn't apply to Unicode emoji, such as `U+1F600` for a grinning
     * face emoji.
     *
     * For more information, see [View text formatting sent in a
     * message](https://developers.google.com/workspace/chat/format-messages#view_text_formatting_sent_in_a_message)
     * </pre>
     *
     * <code>string formatted_text = 43 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for formattedText.
     */
    public com.google.protobuf.ByteString getFormattedTextBytes() {
      java.lang.Object ref = formattedText_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        formattedText_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Contains the message `text` with markups added to communicate
     * formatting. This field might not capture all formatting visible in the UI,
     * but includes the following:
     *
     * * [Markup
     * syntax](https://developers.google.com/workspace/chat/format-messages)
     * for bold, italic, strikethrough, monospace, monospace block, and bulleted
     * list.
     *
     * * [User
     * mentions](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention)
     * using the format `&lt;users/{user}&gt;`.
     *
     * * Custom hyperlinks using the format `&lt;{url}|{rendered_text}&gt;` where the
     * first string is the URL and the second is the rendered text—for example,
     * `&lt;http://example.com|custom text&gt;`.
     *
     * * Custom emoji using the format `:{emoji_name}:`—for example, `:smile:`.
     * This doesn't apply to Unicode emoji, such as `U+1F600` for a grinning
     * face emoji.
     *
     * For more information, see [View text formatting sent in a
     * message](https://developers.google.com/workspace/chat/format-messages#view_text_formatting_sent_in_a_message)
     * </pre>
     *
     * <code>string formatted_text = 43 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The formattedText to set.
     * @return This builder for chaining.
     */
    public Builder setFormattedText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      formattedText_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Contains the message `text` with markups added to communicate
     * formatting. This field might not capture all formatting visible in the UI,
     * but includes the following:
     *
     * * [Markup
     * syntax](https://developers.google.com/workspace/chat/format-messages)
     * for bold, italic, strikethrough, monospace, monospace block, and bulleted
     * list.
     *
     * * [User
     * mentions](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention)
     * using the format `&lt;users/{user}&gt;`.
     *
     * * Custom hyperlinks using the format `&lt;{url}|{rendered_text}&gt;` where the
     * first string is the URL and the second is the rendered text—for example,
     * `&lt;http://example.com|custom text&gt;`.
     *
     * * Custom emoji using the format `:{emoji_name}:`—for example, `:smile:`.
     * This doesn't apply to Unicode emoji, such as `U+1F600` for a grinning
     * face emoji.
     *
     * For more information, see [View text formatting sent in a
     * message](https://developers.google.com/workspace/chat/format-messages#view_text_formatting_sent_in_a_message)
     * </pre>
     *
     * <code>string formatted_text = 43 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFormattedText() {
      formattedText_ = getDefaultInstance().getFormattedText();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Contains the message `text` with markups added to communicate
     * formatting. This field might not capture all formatting visible in the UI,
     * but includes the following:
     *
     * * [Markup
     * syntax](https://developers.google.com/workspace/chat/format-messages)
     * for bold, italic, strikethrough, monospace, monospace block, and bulleted
     * list.
     *
     * * [User
     * mentions](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention)
     * using the format `&lt;users/{user}&gt;`.
     *
     * * Custom hyperlinks using the format `&lt;{url}|{rendered_text}&gt;` where the
     * first string is the URL and the second is the rendered text—for example,
     * `&lt;http://example.com|custom text&gt;`.
     *
     * * Custom emoji using the format `:{emoji_name}:`—for example, `:smile:`.
     * This doesn't apply to Unicode emoji, such as `U+1F600` for a grinning
     * face emoji.
     *
     * For more information, see [View text formatting sent in a
     * message](https://developers.google.com/workspace/chat/format-messages#view_text_formatting_sent_in_a_message)
     * </pre>
     *
     * <code>string formatted_text = 43 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for formattedText to set.
     * @return This builder for chaining.
     */
    public Builder setFormattedTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      formattedText_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.util.List<com.google.chat.v1.ContextualAddOnMarkup.Card> cards_ =
        java.util.Collections.emptyList();

    private void ensureCardsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        cards_ = new java.util.ArrayList<com.google.chat.v1.ContextualAddOnMarkup.Card>(cards_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.chat.v1.ContextualAddOnMarkup.Card,
            com.google.chat.v1.ContextualAddOnMarkup.Card.Builder,
            com.google.chat.v1.ContextualAddOnMarkup.CardOrBuilder>
        cardsBuilder_;

    /**
     *
     *
     * <pre>
     * Deprecated: Use `cards_v2` instead.
     *
     * Rich, formatted, and interactive cards that you can use to display UI
     * elements such as: formatted texts, buttons, and clickable images. Cards are
     * normally displayed below the plain-text body of the message. `cards` and
     * `cards_v2` can have a maximum size of 32 KB.
     * </pre>
     *
     * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.chat.v1.ContextualAddOnMarkup.Card> getCardsList() {
      if (cardsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(cards_);
      } else {
        return cardsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Deprecated: Use `cards_v2` instead.
     *
     * Rich, formatted, and interactive cards that you can use to display UI
     * elements such as: formatted texts, buttons, and clickable images. Cards are
     * normally displayed below the plain-text body of the message. `cards` and
     * `cards_v2` can have a maximum size of 32 KB.
     * </pre>
     *
     * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public int getCardsCount() {
      if (cardsBuilder_ == null) {
        return cards_.size();
      } else {
        return cardsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Deprecated: Use `cards_v2` instead.
     *
     * Rich, formatted, and interactive cards that you can use to display UI
     * elements such as: formatted texts, buttons, and clickable images. Cards are
     * normally displayed below the plain-text body of the message. `cards` and
     * `cards_v2` can have a maximum size of 32 KB.
     * </pre>
     *
     * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.chat.v1.ContextualAddOnMarkup.Card getCards(int index) {
      if (cardsBuilder_ == null) {
        return cards_.get(index);
      } else {
        return cardsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Deprecated: Use `cards_v2` instead.
     *
     * Rich, formatted, and interactive cards that you can use to display UI
     * elements such as: formatted texts, buttons, and clickable images. Cards are
     * normally displayed below the plain-text body of the message. `cards` and
     * `cards_v2` can have a maximum size of 32 KB.
     * </pre>
     *
     * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setCards(int index, com.google.chat.v1.ContextualAddOnMarkup.Card value) {
      if (cardsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCardsIsMutable();
        cards_.set(index, value);
        onChanged();
      } else {
        cardsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: Use `cards_v2` instead.
     *
     * Rich, formatted, and interactive cards that you can use to display UI
     * elements such as: formatted texts, buttons, and clickable images. Cards are
     * normally displayed below the plain-text body of the message. `cards` and
     * `cards_v2` can have a maximum size of 32 KB.
     * </pre>
     *
     * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setCards(
        int index, com.google.chat.v1.ContextualAddOnMarkup.Card.Builder builderForValue) {
      if (cardsBuilder_ == null) {
        ensureCardsIsMutable();
        cards_.set(index, builderForValue.build());
        onChanged();
      } else {
        cardsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: Use `cards_v2` instead.
     *
     * Rich, formatted, and interactive cards that you can use to display UI
     * elements such as: formatted texts, buttons, and clickable images. Cards are
     * normally displayed below the plain-text body of the message. `cards` and
     * `cards_v2` can have a maximum size of 32 KB.
     * </pre>
     *
     * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addCards(com.google.chat.v1.ContextualAddOnMarkup.Card value) {
      if (cardsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCardsIsMutable();
        cards_.add(value);
        onChanged();
      } else {
        cardsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: Use `cards_v2` instead.
     *
     * Rich, formatted, and interactive cards that you can use to display UI
     * elements such as: formatted texts, buttons, and clickable images. Cards are
     * normally displayed below the plain-text body of the message. `cards` and
     * `cards_v2` can have a maximum size of 32 KB.
     * </pre>
     *
     * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addCards(int index, com.google.chat.v1.ContextualAddOnMarkup.Card value) {
      if (cardsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCardsIsMutable();
        cards_.add(index, value);
        onChanged();
      } else {
        cardsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: Use `cards_v2` instead.
     *
     * Rich, formatted, and interactive cards that you can use to display UI
     * elements such as: formatted texts, buttons, and clickable images. Cards are
     * normally displayed below the plain-text body of the message. `cards` and
     * `cards_v2` can have a maximum size of 32 KB.
     * </pre>
     *
     * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addCards(com.google.chat.v1.ContextualAddOnMarkup.Card.Builder builderForValue) {
      if (cardsBuilder_ == null) {
        ensureCardsIsMutable();
        cards_.add(builderForValue.build());
        onChanged();
      } else {
        cardsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: Use `cards_v2` instead.
     *
     * Rich, formatted, and interactive cards that you can use to display UI
     * elements such as: formatted texts, buttons, and clickable images. Cards are
     * normally displayed below the plain-text body of the message. `cards` and
     * `cards_v2` can have a maximum size of 32 KB.
     * </pre>
     *
     * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addCards(
        int index, com.google.chat.v1.ContextualAddOnMarkup.Card.Builder builderForValue) {
      if (cardsBuilder_ == null) {
        ensureCardsIsMutable();
        cards_.add(index, builderForValue.build());
        onChanged();
      } else {
        cardsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: Use `cards_v2` instead.
     *
     * Rich, formatted, and interactive cards that you can use to display UI
     * elements such as: formatted texts, buttons, and clickable images. Cards are
     * normally displayed below the plain-text body of the message. `cards` and
     * `cards_v2` can have a maximum size of 32 KB.
     * </pre>
     *
     * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addAllCards(
        java.lang.Iterable<? extends com.google.chat.v1.ContextualAddOnMarkup.Card> values) {
      if (cardsBuilder_ == null) {
        ensureCardsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, cards_);
        onChanged();
      } else {
        cardsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: Use `cards_v2` instead.
     *
     * Rich, formatted, and interactive cards that you can use to display UI
     * elements such as: formatted texts, buttons, and clickable images. Cards are
     * normally displayed below the plain-text body of the message. `cards` and
     * `cards_v2` can have a maximum size of 32 KB.
     * </pre>
     *
     * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearCards() {
      if (cardsBuilder_ == null) {
        cards_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        cardsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: Use `cards_v2` instead.
     *
     * Rich, formatted, and interactive cards that you can use to display UI
     * elements such as: formatted texts, buttons, and clickable images. Cards are
     * normally displayed below the plain-text body of the message. `cards` and
     * `cards_v2` can have a maximum size of 32 KB.
     * </pre>
     *
     * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder removeCards(int index) {
      if (cardsBuilder_ == null) {
        ensureCardsIsMutable();
        cards_.remove(index);
        onChanged();
      } else {
        cardsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: Use `cards_v2` instead.
     *
     * Rich, formatted, and interactive cards that you can use to display UI
     * elements such as: formatted texts, buttons, and clickable images. Cards are
     * normally displayed below the plain-text body of the message. `cards` and
     * `cards_v2` can have a maximum size of 32 KB.
     * </pre>
     *
     * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.chat.v1.ContextualAddOnMarkup.Card.Builder getCardsBuilder(int index) {
      return getCardsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Deprecated: Use `cards_v2` instead.
     *
     * Rich, formatted, and interactive cards that you can use to display UI
     * elements such as: formatted texts, buttons, and clickable images. Cards are
     * normally displayed below the plain-text body of the message. `cards` and
     * `cards_v2` can have a maximum size of 32 KB.
     * </pre>
     *
     * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.chat.v1.ContextualAddOnMarkup.CardOrBuilder getCardsOrBuilder(int index) {
      if (cardsBuilder_ == null) {
        return cards_.get(index);
      } else {
        return cardsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Deprecated: Use `cards_v2` instead.
     *
     * Rich, formatted, and interactive cards that you can use to display UI
     * elements such as: formatted texts, buttons, and clickable images. Cards are
     * normally displayed below the plain-text body of the message. `cards` and
     * `cards_v2` can have a maximum size of 32 KB.
     * </pre>
     *
     * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<? extends com.google.chat.v1.ContextualAddOnMarkup.CardOrBuilder>
        getCardsOrBuilderList() {
      if (cardsBuilder_ != null) {
        return cardsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(cards_);
      }
    }

    /**
     *
     *
     * <pre>
     * Deprecated: Use `cards_v2` instead.
     *
     * Rich, formatted, and interactive cards that you can use to display UI
     * elements such as: formatted texts, buttons, and clickable images. Cards are
     * normally displayed below the plain-text body of the message. `cards` and
     * `cards_v2` can have a maximum size of 32 KB.
     * </pre>
     *
     * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.chat.v1.ContextualAddOnMarkup.Card.Builder addCardsBuilder() {
      return getCardsFieldBuilder()
          .addBuilder(com.google.chat.v1.ContextualAddOnMarkup.Card.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Deprecated: Use `cards_v2` instead.
     *
     * Rich, formatted, and interactive cards that you can use to display UI
     * elements such as: formatted texts, buttons, and clickable images. Cards are
     * normally displayed below the plain-text body of the message. `cards` and
     * `cards_v2` can have a maximum size of 32 KB.
     * </pre>
     *
     * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.chat.v1.ContextualAddOnMarkup.Card.Builder addCardsBuilder(int index) {
      return getCardsFieldBuilder()
          .addBuilder(index, com.google.chat.v1.ContextualAddOnMarkup.Card.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Deprecated: Use `cards_v2` instead.
     *
     * Rich, formatted, and interactive cards that you can use to display UI
     * elements such as: formatted texts, buttons, and clickable images. Cards are
     * normally displayed below the plain-text body of the message. `cards` and
     * `cards_v2` can have a maximum size of 32 KB.
     * </pre>
     *
     * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.chat.v1.ContextualAddOnMarkup.Card.Builder>
        getCardsBuilderList() {
      return getCardsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.chat.v1.ContextualAddOnMarkup.Card,
            com.google.chat.v1.ContextualAddOnMarkup.Card.Builder,
            com.google.chat.v1.ContextualAddOnMarkup.CardOrBuilder>
        getCardsFieldBuilder() {
      if (cardsBuilder_ == null) {
        cardsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.chat.v1.ContextualAddOnMarkup.Card,
                com.google.chat.v1.ContextualAddOnMarkup.Card.Builder,
                com.google.chat.v1.ContextualAddOnMarkup.CardOrBuilder>(
                cards_, ((bitField0_ & 0x00000080) != 0), getParentForChildren(), isClean());
        cards_ = null;
      }
      return cardsBuilder_;
    }

    private java.util.List<com.google.chat.v1.CardWithId> cardsV2_ =
        java.util.Collections.emptyList();

    private void ensureCardsV2IsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        cardsV2_ = new java.util.ArrayList<com.google.chat.v1.CardWithId>(cardsV2_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.chat.v1.CardWithId,
            com.google.chat.v1.CardWithId.Builder,
            com.google.chat.v1.CardWithIdOrBuilder>
        cardsV2Builder_;

    /**
     *
     *
     * <pre>
     * Optional. An array of
     * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     *
     * Only Chat apps can create cards. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the messages can't contain cards.
     *
     * To learn how to create a message that contains cards, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     *
     * [Card builder](https://addons.gsuite.google.com/uikit/builder)
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.chat.v1.CardWithId> getCardsV2List() {
      if (cardsV2Builder_ == null) {
        return java.util.Collections.unmodifiableList(cardsV2_);
      } else {
        return cardsV2Builder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. An array of
     * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     *
     * Only Chat apps can create cards. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the messages can't contain cards.
     *
     * To learn how to create a message that contains cards, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     *
     * [Card builder](https://addons.gsuite.google.com/uikit/builder)
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getCardsV2Count() {
      if (cardsV2Builder_ == null) {
        return cardsV2_.size();
      } else {
        return cardsV2Builder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. An array of
     * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     *
     * Only Chat apps can create cards. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the messages can't contain cards.
     *
     * To learn how to create a message that contains cards, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     *
     * [Card builder](https://addons.gsuite.google.com/uikit/builder)
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.CardWithId getCardsV2(int index) {
      if (cardsV2Builder_ == null) {
        return cardsV2_.get(index);
      } else {
        return cardsV2Builder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. An array of
     * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     *
     * Only Chat apps can create cards. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the messages can't contain cards.
     *
     * To learn how to create a message that contains cards, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     *
     * [Card builder](https://addons.gsuite.google.com/uikit/builder)
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCardsV2(int index, com.google.chat.v1.CardWithId value) {
      if (cardsV2Builder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCardsV2IsMutable();
        cardsV2_.set(index, value);
        onChanged();
      } else {
        cardsV2Builder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An array of
     * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     *
     * Only Chat apps can create cards. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the messages can't contain cards.
     *
     * To learn how to create a message that contains cards, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     *
     * [Card builder](https://addons.gsuite.google.com/uikit/builder)
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCardsV2(int index, com.google.chat.v1.CardWithId.Builder builderForValue) {
      if (cardsV2Builder_ == null) {
        ensureCardsV2IsMutable();
        cardsV2_.set(index, builderForValue.build());
        onChanged();
      } else {
        cardsV2Builder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An array of
     * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     *
     * Only Chat apps can create cards. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the messages can't contain cards.
     *
     * To learn how to create a message that contains cards, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     *
     * [Card builder](https://addons.gsuite.google.com/uikit/builder)
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addCardsV2(com.google.chat.v1.CardWithId value) {
      if (cardsV2Builder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCardsV2IsMutable();
        cardsV2_.add(value);
        onChanged();
      } else {
        cardsV2Builder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An array of
     * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     *
     * Only Chat apps can create cards. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the messages can't contain cards.
     *
     * To learn how to create a message that contains cards, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     *
     * [Card builder](https://addons.gsuite.google.com/uikit/builder)
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addCardsV2(int index, com.google.chat.v1.CardWithId value) {
      if (cardsV2Builder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCardsV2IsMutable();
        cardsV2_.add(index, value);
        onChanged();
      } else {
        cardsV2Builder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An array of
     * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     *
     * Only Chat apps can create cards. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the messages can't contain cards.
     *
     * To learn how to create a message that contains cards, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     *
     * [Card builder](https://addons.gsuite.google.com/uikit/builder)
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addCardsV2(com.google.chat.v1.CardWithId.Builder builderForValue) {
      if (cardsV2Builder_ == null) {
        ensureCardsV2IsMutable();
        cardsV2_.add(builderForValue.build());
        onChanged();
      } else {
        cardsV2Builder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An array of
     * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     *
     * Only Chat apps can create cards. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the messages can't contain cards.
     *
     * To learn how to create a message that contains cards, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     *
     * [Card builder](https://addons.gsuite.google.com/uikit/builder)
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addCardsV2(int index, com.google.chat.v1.CardWithId.Builder builderForValue) {
      if (cardsV2Builder_ == null) {
        ensureCardsV2IsMutable();
        cardsV2_.add(index, builderForValue.build());
        onChanged();
      } else {
        cardsV2Builder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An array of
     * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     *
     * Only Chat apps can create cards. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the messages can't contain cards.
     *
     * To learn how to create a message that contains cards, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     *
     * [Card builder](https://addons.gsuite.google.com/uikit/builder)
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllCardsV2(
        java.lang.Iterable<? extends com.google.chat.v1.CardWithId> values) {
      if (cardsV2Builder_ == null) {
        ensureCardsV2IsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, cardsV2_);
        onChanged();
      } else {
        cardsV2Builder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An array of
     * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     *
     * Only Chat apps can create cards. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the messages can't contain cards.
     *
     * To learn how to create a message that contains cards, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     *
     * [Card builder](https://addons.gsuite.google.com/uikit/builder)
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCardsV2() {
      if (cardsV2Builder_ == null) {
        cardsV2_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        cardsV2Builder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An array of
     * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     *
     * Only Chat apps can create cards. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the messages can't contain cards.
     *
     * To learn how to create a message that contains cards, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     *
     * [Card builder](https://addons.gsuite.google.com/uikit/builder)
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeCardsV2(int index) {
      if (cardsV2Builder_ == null) {
        ensureCardsV2IsMutable();
        cardsV2_.remove(index);
        onChanged();
      } else {
        cardsV2Builder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An array of
     * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     *
     * Only Chat apps can create cards. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the messages can't contain cards.
     *
     * To learn how to create a message that contains cards, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     *
     * [Card builder](https://addons.gsuite.google.com/uikit/builder)
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.CardWithId.Builder getCardsV2Builder(int index) {
      return getCardsV2FieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. An array of
     * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     *
     * Only Chat apps can create cards. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the messages can't contain cards.
     *
     * To learn how to create a message that contains cards, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     *
     * [Card builder](https://addons.gsuite.google.com/uikit/builder)
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.CardWithIdOrBuilder getCardsV2OrBuilder(int index) {
      if (cardsV2Builder_ == null) {
        return cardsV2_.get(index);
      } else {
        return cardsV2Builder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. An array of
     * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     *
     * Only Chat apps can create cards. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the messages can't contain cards.
     *
     * To learn how to create a message that contains cards, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     *
     * [Card builder](https://addons.gsuite.google.com/uikit/builder)
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.chat.v1.CardWithIdOrBuilder>
        getCardsV2OrBuilderList() {
      if (cardsV2Builder_ != null) {
        return cardsV2Builder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(cardsV2_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. An array of
     * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     *
     * Only Chat apps can create cards. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the messages can't contain cards.
     *
     * To learn how to create a message that contains cards, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     *
     * [Card builder](https://addons.gsuite.google.com/uikit/builder)
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.CardWithId.Builder addCardsV2Builder() {
      return getCardsV2FieldBuilder()
          .addBuilder(com.google.chat.v1.CardWithId.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. An array of
     * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     *
     * Only Chat apps can create cards. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the messages can't contain cards.
     *
     * To learn how to create a message that contains cards, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     *
     * [Card builder](https://addons.gsuite.google.com/uikit/builder)
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.CardWithId.Builder addCardsV2Builder(int index) {
      return getCardsV2FieldBuilder()
          .addBuilder(index, com.google.chat.v1.CardWithId.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. An array of
     * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
     *
     * Only Chat apps can create cards. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the messages can't contain cards.
     *
     * To learn how to create a message that contains cards, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     *
     * [Card builder](https://addons.gsuite.google.com/uikit/builder)
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.chat.v1.CardWithId.Builder> getCardsV2BuilderList() {
      return getCardsV2FieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.chat.v1.CardWithId,
            com.google.chat.v1.CardWithId.Builder,
            com.google.chat.v1.CardWithIdOrBuilder>
        getCardsV2FieldBuilder() {
      if (cardsV2Builder_ == null) {
        cardsV2Builder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.chat.v1.CardWithId,
                com.google.chat.v1.CardWithId.Builder,
                com.google.chat.v1.CardWithIdOrBuilder>(
                cardsV2_, ((bitField0_ & 0x00000100) != 0), getParentForChildren(), isClean());
        cardsV2_ = null;
      }
      return cardsV2Builder_;
    }

    private java.util.List<com.google.chat.v1.Annotation> annotations_ =
        java.util.Collections.emptyList();

    private void ensureAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        annotations_ = new java.util.ArrayList<com.google.chat.v1.Annotation>(annotations_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.chat.v1.Annotation,
            com.google.chat.v1.Annotation.Builder,
            com.google.chat.v1.AnnotationOrBuilder>
        annotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Annotations associated with the `text` in this message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.chat.v1.Annotation> getAnnotationsList() {
      if (annotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(annotations_);
      } else {
        return annotationsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Annotations associated with the `text` in this message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getAnnotationsCount() {
      if (annotationsBuilder_ == null) {
        return annotations_.size();
      } else {
        return annotationsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Annotations associated with the `text` in this message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.Annotation getAnnotations(int index) {
      if (annotationsBuilder_ == null) {
        return annotations_.get(index);
      } else {
        return annotationsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Annotations associated with the `text` in this message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAnnotations(int index, com.google.chat.v1.Annotation value) {
      if (annotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnnotationsIsMutable();
        annotations_.set(index, value);
        onChanged();
      } else {
        annotationsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Annotations associated with the `text` in this message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAnnotations(
        int index, com.google.chat.v1.Annotation.Builder builderForValue) {
      if (annotationsBuilder_ == null) {
        ensureAnnotationsIsMutable();
        annotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        annotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Annotations associated with the `text` in this message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAnnotations(com.google.chat.v1.Annotation value) {
      if (annotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnnotationsIsMutable();
        annotations_.add(value);
        onChanged();
      } else {
        annotationsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Annotations associated with the `text` in this message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAnnotations(int index, com.google.chat.v1.Annotation value) {
      if (annotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnnotationsIsMutable();
        annotations_.add(index, value);
        onChanged();
      } else {
        annotationsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Annotations associated with the `text` in this message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAnnotations(com.google.chat.v1.Annotation.Builder builderForValue) {
      if (annotationsBuilder_ == null) {
        ensureAnnotationsIsMutable();
        annotations_.add(builderForValue.build());
        onChanged();
      } else {
        annotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Annotations associated with the `text` in this message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAnnotations(
        int index, com.google.chat.v1.Annotation.Builder builderForValue) {
      if (annotationsBuilder_ == null) {
        ensureAnnotationsIsMutable();
        annotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        annotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Annotations associated with the `text` in this message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllAnnotations(
        java.lang.Iterable<? extends com.google.chat.v1.Annotation> values) {
      if (annotationsBuilder_ == null) {
        ensureAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, annotations_);
        onChanged();
      } else {
        annotationsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Annotations associated with the `text` in this message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAnnotations() {
      if (annotationsBuilder_ == null) {
        annotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        annotationsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Annotations associated with the `text` in this message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeAnnotations(int index) {
      if (annotationsBuilder_ == null) {
        ensureAnnotationsIsMutable();
        annotations_.remove(index);
        onChanged();
      } else {
        annotationsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Annotations associated with the `text` in this message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.Annotation.Builder getAnnotationsBuilder(int index) {
      return getAnnotationsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. Annotations associated with the `text` in this message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.AnnotationOrBuilder getAnnotationsOrBuilder(int index) {
      if (annotationsBuilder_ == null) {
        return annotations_.get(index);
      } else {
        return annotationsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Annotations associated with the `text` in this message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.chat.v1.AnnotationOrBuilder>
        getAnnotationsOrBuilderList() {
      if (annotationsBuilder_ != null) {
        return annotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(annotations_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Annotations associated with the `text` in this message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.Annotation.Builder addAnnotationsBuilder() {
      return getAnnotationsFieldBuilder()
          .addBuilder(com.google.chat.v1.Annotation.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Annotations associated with the `text` in this message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.Annotation.Builder addAnnotationsBuilder(int index) {
      return getAnnotationsFieldBuilder()
          .addBuilder(index, com.google.chat.v1.Annotation.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Annotations associated with the `text` in this message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.chat.v1.Annotation.Builder> getAnnotationsBuilderList() {
      return getAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.chat.v1.Annotation,
            com.google.chat.v1.Annotation.Builder,
            com.google.chat.v1.AnnotationOrBuilder>
        getAnnotationsFieldBuilder() {
      if (annotationsBuilder_ == null) {
        annotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.chat.v1.Annotation,
                com.google.chat.v1.Annotation.Builder,
                com.google.chat.v1.AnnotationOrBuilder>(
                annotations_, ((bitField0_ & 0x00000200) != 0), getParentForChildren(), isClean());
        annotations_ = null;
      }
      return annotationsBuilder_;
    }

    private com.google.chat.v1.Thread thread_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Thread,
            com.google.chat.v1.Thread.Builder,
            com.google.chat.v1.ThreadOrBuilder>
        threadBuilder_;

    /**
     *
     *
     * <pre>
     * The thread the message belongs to. For example usage, see
     * [Start or reply to a message
     * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
     * </pre>
     *
     * <code>.google.chat.v1.Thread thread = 11;</code>
     *
     * @return Whether the thread field is set.
     */
    public boolean hasThread() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * The thread the message belongs to. For example usage, see
     * [Start or reply to a message
     * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
     * </pre>
     *
     * <code>.google.chat.v1.Thread thread = 11;</code>
     *
     * @return The thread.
     */
    public com.google.chat.v1.Thread getThread() {
      if (threadBuilder_ == null) {
        return thread_ == null ? com.google.chat.v1.Thread.getDefaultInstance() : thread_;
      } else {
        return threadBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The thread the message belongs to. For example usage, see
     * [Start or reply to a message
     * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
     * </pre>
     *
     * <code>.google.chat.v1.Thread thread = 11;</code>
     */
    public Builder setThread(com.google.chat.v1.Thread value) {
      if (threadBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        thread_ = value;
      } else {
        threadBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The thread the message belongs to. For example usage, see
     * [Start or reply to a message
     * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
     * </pre>
     *
     * <code>.google.chat.v1.Thread thread = 11;</code>
     */
    public Builder setThread(com.google.chat.v1.Thread.Builder builderForValue) {
      if (threadBuilder_ == null) {
        thread_ = builderForValue.build();
      } else {
        threadBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The thread the message belongs to. For example usage, see
     * [Start or reply to a message
     * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
     * </pre>
     *
     * <code>.google.chat.v1.Thread thread = 11;</code>
     */
    public Builder mergeThread(com.google.chat.v1.Thread value) {
      if (threadBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && thread_ != null
            && thread_ != com.google.chat.v1.Thread.getDefaultInstance()) {
          getThreadBuilder().mergeFrom(value);
        } else {
          thread_ = value;
        }
      } else {
        threadBuilder_.mergeFrom(value);
      }
      if (thread_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The thread the message belongs to. For example usage, see
     * [Start or reply to a message
     * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
     * </pre>
     *
     * <code>.google.chat.v1.Thread thread = 11;</code>
     */
    public Builder clearThread() {
      bitField0_ = (bitField0_ & ~0x00000400);
      thread_ = null;
      if (threadBuilder_ != null) {
        threadBuilder_.dispose();
        threadBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The thread the message belongs to. For example usage, see
     * [Start or reply to a message
     * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
     * </pre>
     *
     * <code>.google.chat.v1.Thread thread = 11;</code>
     */
    public com.google.chat.v1.Thread.Builder getThreadBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getThreadFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The thread the message belongs to. For example usage, see
     * [Start or reply to a message
     * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
     * </pre>
     *
     * <code>.google.chat.v1.Thread thread = 11;</code>
     */
    public com.google.chat.v1.ThreadOrBuilder getThreadOrBuilder() {
      if (threadBuilder_ != null) {
        return threadBuilder_.getMessageOrBuilder();
      } else {
        return thread_ == null ? com.google.chat.v1.Thread.getDefaultInstance() : thread_;
      }
    }

    /**
     *
     *
     * <pre>
     * The thread the message belongs to. For example usage, see
     * [Start or reply to a message
     * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
     * </pre>
     *
     * <code>.google.chat.v1.Thread thread = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Thread,
            com.google.chat.v1.Thread.Builder,
            com.google.chat.v1.ThreadOrBuilder>
        getThreadFieldBuilder() {
      if (threadBuilder_ == null) {
        threadBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.Thread,
                com.google.chat.v1.Thread.Builder,
                com.google.chat.v1.ThreadOrBuilder>(getThread(), getParentForChildren(), isClean());
        thread_ = null;
      }
      return threadBuilder_;
    }

    private com.google.chat.v1.Space space_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Space,
            com.google.chat.v1.Space.Builder,
            com.google.chat.v1.SpaceOrBuilder>
        spaceBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output only populates the
     * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
     * `name`.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the space field is set.
     */
    public boolean hasSpace() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output only populates the
     * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
     * `name`.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The space.
     */
    public com.google.chat.v1.Space getSpace() {
      if (spaceBuilder_ == null) {
        return space_ == null ? com.google.chat.v1.Space.getDefaultInstance() : space_;
      } else {
        return spaceBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output only populates the
     * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
     * `name`.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setSpace(com.google.chat.v1.Space value) {
      if (spaceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        space_ = value;
      } else {
        spaceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output only populates the
     * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
     * `name`.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setSpace(com.google.chat.v1.Space.Builder builderForValue) {
      if (spaceBuilder_ == null) {
        space_ = builderForValue.build();
      } else {
        spaceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output only populates the
     * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
     * `name`.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeSpace(com.google.chat.v1.Space value) {
      if (spaceBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && space_ != null
            && space_ != com.google.chat.v1.Space.getDefaultInstance()) {
          getSpaceBuilder().mergeFrom(value);
        } else {
          space_ = value;
        }
      } else {
        spaceBuilder_.mergeFrom(value);
      }
      if (space_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output only populates the
     * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
     * `name`.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearSpace() {
      bitField0_ = (bitField0_ & ~0x00000800);
      space_ = null;
      if (spaceBuilder_ != null) {
        spaceBuilder_.dispose();
        spaceBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output only populates the
     * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
     * `name`.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.chat.v1.Space.Builder getSpaceBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getSpaceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output only populates the
     * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
     * `name`.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.chat.v1.SpaceOrBuilder getSpaceOrBuilder() {
      if (spaceBuilder_ != null) {
        return spaceBuilder_.getMessageOrBuilder();
      } else {
        return space_ == null ? com.google.chat.v1.Space.getDefaultInstance() : space_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. If your Chat app [authenticates as a
     * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * the output only populates the
     * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
     * `name`.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Space,
            com.google.chat.v1.Space.Builder,
            com.google.chat.v1.SpaceOrBuilder>
        getSpaceFieldBuilder() {
      if (spaceBuilder_ == null) {
        spaceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.Space,
                com.google.chat.v1.Space.Builder,
                com.google.chat.v1.SpaceOrBuilder>(getSpace(), getParentForChildren(), isClean());
        space_ = null;
      }
      return spaceBuilder_;
    }

    private java.lang.Object fallbackText_ = "";

    /**
     *
     *
     * <pre>
     * Optional. A plain-text description of the message's cards, used when the
     * actual cards can't be displayed—for example, mobile notifications.
     * </pre>
     *
     * <code>string fallback_text = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The fallbackText.
     */
    public java.lang.String getFallbackText() {
      java.lang.Object ref = fallbackText_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fallbackText_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A plain-text description of the message's cards, used when the
     * actual cards can't be displayed—for example, mobile notifications.
     * </pre>
     *
     * <code>string fallback_text = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for fallbackText.
     */
    public com.google.protobuf.ByteString getFallbackTextBytes() {
      java.lang.Object ref = fallbackText_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fallbackText_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A plain-text description of the message's cards, used when the
     * actual cards can't be displayed—for example, mobile notifications.
     * </pre>
     *
     * <code>string fallback_text = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The fallbackText to set.
     * @return This builder for chaining.
     */
    public Builder setFallbackText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fallbackText_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A plain-text description of the message's cards, used when the
     * actual cards can't be displayed—for example, mobile notifications.
     * </pre>
     *
     * <code>string fallback_text = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFallbackText() {
      fallbackText_ = getDefaultInstance().getFallbackText();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A plain-text description of the message's cards, used when the
     * actual cards can't be displayed—for example, mobile notifications.
     * </pre>
     *
     * <code>string fallback_text = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for fallbackText to set.
     * @return This builder for chaining.
     */
    public Builder setFallbackTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fallbackText_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private com.google.chat.v1.ActionResponse actionResponse_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.ActionResponse,
            com.google.chat.v1.ActionResponse.Builder,
            com.google.chat.v1.ActionResponseOrBuilder>
        actionResponseBuilder_;

    /**
     *
     *
     * <pre>
     * Input only. Parameters that a Chat app can use to configure how its
     * response is posted.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse action_response = 14 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return Whether the actionResponse field is set.
     */
    public boolean hasActionResponse() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Input only. Parameters that a Chat app can use to configure how its
     * response is posted.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse action_response = 14 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The actionResponse.
     */
    public com.google.chat.v1.ActionResponse getActionResponse() {
      if (actionResponseBuilder_ == null) {
        return actionResponse_ == null
            ? com.google.chat.v1.ActionResponse.getDefaultInstance()
            : actionResponse_;
      } else {
        return actionResponseBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Input only. Parameters that a Chat app can use to configure how its
     * response is posted.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse action_response = 14 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setActionResponse(com.google.chat.v1.ActionResponse value) {
      if (actionResponseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        actionResponse_ = value;
      } else {
        actionResponseBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. Parameters that a Chat app can use to configure how its
     * response is posted.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse action_response = 14 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setActionResponse(com.google.chat.v1.ActionResponse.Builder builderForValue) {
      if (actionResponseBuilder_ == null) {
        actionResponse_ = builderForValue.build();
      } else {
        actionResponseBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. Parameters that a Chat app can use to configure how its
     * response is posted.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse action_response = 14 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder mergeActionResponse(com.google.chat.v1.ActionResponse value) {
      if (actionResponseBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && actionResponse_ != null
            && actionResponse_ != com.google.chat.v1.ActionResponse.getDefaultInstance()) {
          getActionResponseBuilder().mergeFrom(value);
        } else {
          actionResponse_ = value;
        }
      } else {
        actionResponseBuilder_.mergeFrom(value);
      }
      if (actionResponse_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. Parameters that a Chat app can use to configure how its
     * response is posted.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse action_response = 14 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder clearActionResponse() {
      bitField0_ = (bitField0_ & ~0x00002000);
      actionResponse_ = null;
      if (actionResponseBuilder_ != null) {
        actionResponseBuilder_.dispose();
        actionResponseBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. Parameters that a Chat app can use to configure how its
     * response is posted.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse action_response = 14 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.ActionResponse.Builder getActionResponseBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getActionResponseFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Input only. Parameters that a Chat app can use to configure how its
     * response is posted.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse action_response = 14 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.ActionResponseOrBuilder getActionResponseOrBuilder() {
      if (actionResponseBuilder_ != null) {
        return actionResponseBuilder_.getMessageOrBuilder();
      } else {
        return actionResponse_ == null
            ? com.google.chat.v1.ActionResponse.getDefaultInstance()
            : actionResponse_;
      }
    }

    /**
     *
     *
     * <pre>
     * Input only. Parameters that a Chat app can use to configure how its
     * response is posted.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse action_response = 14 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.ActionResponse,
            com.google.chat.v1.ActionResponse.Builder,
            com.google.chat.v1.ActionResponseOrBuilder>
        getActionResponseFieldBuilder() {
      if (actionResponseBuilder_ == null) {
        actionResponseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.ActionResponse,
                com.google.chat.v1.ActionResponse.Builder,
                com.google.chat.v1.ActionResponseOrBuilder>(
                getActionResponse(), getParentForChildren(), isClean());
        actionResponse_ = null;
      }
      return actionResponseBuilder_;
    }

    private java.lang.Object argumentText_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Plain-text body of the message with all Chat app mentions
     * stripped out.
     * </pre>
     *
     * <code>string argument_text = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The argumentText.
     */
    public java.lang.String getArgumentText() {
      java.lang.Object ref = argumentText_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        argumentText_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Plain-text body of the message with all Chat app mentions
     * stripped out.
     * </pre>
     *
     * <code>string argument_text = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for argumentText.
     */
    public com.google.protobuf.ByteString getArgumentTextBytes() {
      java.lang.Object ref = argumentText_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        argumentText_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Plain-text body of the message with all Chat app mentions
     * stripped out.
     * </pre>
     *
     * <code>string argument_text = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The argumentText to set.
     * @return This builder for chaining.
     */
    public Builder setArgumentText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      argumentText_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Plain-text body of the message with all Chat app mentions
     * stripped out.
     * </pre>
     *
     * <code>string argument_text = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArgumentText() {
      argumentText_ = getDefaultInstance().getArgumentText();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Plain-text body of the message with all Chat app mentions
     * stripped out.
     * </pre>
     *
     * <code>string argument_text = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for argumentText to set.
     * @return This builder for chaining.
     */
    public Builder setArgumentTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      argumentText_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private com.google.chat.v1.SlashCommand slashCommand_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.SlashCommand,
            com.google.chat.v1.SlashCommand.Builder,
            com.google.chat.v1.SlashCommandOrBuilder>
        slashCommandBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Slash command information, if applicable.
     * </pre>
     *
     * <code>
     * .google.chat.v1.SlashCommand slash_command = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the slashCommand field is set.
     */
    public boolean hasSlashCommand() {
      return ((bitField0_ & 0x00008000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Slash command information, if applicable.
     * </pre>
     *
     * <code>
     * .google.chat.v1.SlashCommand slash_command = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The slashCommand.
     */
    public com.google.chat.v1.SlashCommand getSlashCommand() {
      if (slashCommandBuilder_ == null) {
        return slashCommand_ == null
            ? com.google.chat.v1.SlashCommand.getDefaultInstance()
            : slashCommand_;
      } else {
        return slashCommandBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Slash command information, if applicable.
     * </pre>
     *
     * <code>
     * .google.chat.v1.SlashCommand slash_command = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSlashCommand(com.google.chat.v1.SlashCommand value) {
      if (slashCommandBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        slashCommand_ = value;
      } else {
        slashCommandBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Slash command information, if applicable.
     * </pre>
     *
     * <code>
     * .google.chat.v1.SlashCommand slash_command = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSlashCommand(com.google.chat.v1.SlashCommand.Builder builderForValue) {
      if (slashCommandBuilder_ == null) {
        slashCommand_ = builderForValue.build();
      } else {
        slashCommandBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Slash command information, if applicable.
     * </pre>
     *
     * <code>
     * .google.chat.v1.SlashCommand slash_command = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSlashCommand(com.google.chat.v1.SlashCommand value) {
      if (slashCommandBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && slashCommand_ != null
            && slashCommand_ != com.google.chat.v1.SlashCommand.getDefaultInstance()) {
          getSlashCommandBuilder().mergeFrom(value);
        } else {
          slashCommand_ = value;
        }
      } else {
        slashCommandBuilder_.mergeFrom(value);
      }
      if (slashCommand_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Slash command information, if applicable.
     * </pre>
     *
     * <code>
     * .google.chat.v1.SlashCommand slash_command = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSlashCommand() {
      bitField0_ = (bitField0_ & ~0x00008000);
      slashCommand_ = null;
      if (slashCommandBuilder_ != null) {
        slashCommandBuilder_.dispose();
        slashCommandBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Slash command information, if applicable.
     * </pre>
     *
     * <code>
     * .google.chat.v1.SlashCommand slash_command = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.SlashCommand.Builder getSlashCommandBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getSlashCommandFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Slash command information, if applicable.
     * </pre>
     *
     * <code>
     * .google.chat.v1.SlashCommand slash_command = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.SlashCommandOrBuilder getSlashCommandOrBuilder() {
      if (slashCommandBuilder_ != null) {
        return slashCommandBuilder_.getMessageOrBuilder();
      } else {
        return slashCommand_ == null
            ? com.google.chat.v1.SlashCommand.getDefaultInstance()
            : slashCommand_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Slash command information, if applicable.
     * </pre>
     *
     * <code>
     * .google.chat.v1.SlashCommand slash_command = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.SlashCommand,
            com.google.chat.v1.SlashCommand.Builder,
            com.google.chat.v1.SlashCommandOrBuilder>
        getSlashCommandFieldBuilder() {
      if (slashCommandBuilder_ == null) {
        slashCommandBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.SlashCommand,
                com.google.chat.v1.SlashCommand.Builder,
                com.google.chat.v1.SlashCommandOrBuilder>(
                getSlashCommand(), getParentForChildren(), isClean());
        slashCommand_ = null;
      }
      return slashCommandBuilder_;
    }

    private java.util.List<com.google.chat.v1.Attachment> attachment_ =
        java.util.Collections.emptyList();

    private void ensureAttachmentIsMutable() {
      if (!((bitField0_ & 0x00010000) != 0)) {
        attachment_ = new java.util.ArrayList<com.google.chat.v1.Attachment>(attachment_);
        bitField0_ |= 0x00010000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.chat.v1.Attachment,
            com.google.chat.v1.Attachment.Builder,
            com.google.chat.v1.AttachmentOrBuilder>
        attachmentBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. User-uploaded attachment.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.chat.v1.Attachment> getAttachmentList() {
      if (attachmentBuilder_ == null) {
        return java.util.Collections.unmodifiableList(attachment_);
      } else {
        return attachmentBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. User-uploaded attachment.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getAttachmentCount() {
      if (attachmentBuilder_ == null) {
        return attachment_.size();
      } else {
        return attachmentBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. User-uploaded attachment.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.Attachment getAttachment(int index) {
      if (attachmentBuilder_ == null) {
        return attachment_.get(index);
      } else {
        return attachmentBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. User-uploaded attachment.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAttachment(int index, com.google.chat.v1.Attachment value) {
      if (attachmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttachmentIsMutable();
        attachment_.set(index, value);
        onChanged();
      } else {
        attachmentBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-uploaded attachment.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAttachment(int index, com.google.chat.v1.Attachment.Builder builderForValue) {
      if (attachmentBuilder_ == null) {
        ensureAttachmentIsMutable();
        attachment_.set(index, builderForValue.build());
        onChanged();
      } else {
        attachmentBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-uploaded attachment.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAttachment(com.google.chat.v1.Attachment value) {
      if (attachmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttachmentIsMutable();
        attachment_.add(value);
        onChanged();
      } else {
        attachmentBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-uploaded attachment.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAttachment(int index, com.google.chat.v1.Attachment value) {
      if (attachmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttachmentIsMutable();
        attachment_.add(index, value);
        onChanged();
      } else {
        attachmentBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-uploaded attachment.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAttachment(com.google.chat.v1.Attachment.Builder builderForValue) {
      if (attachmentBuilder_ == null) {
        ensureAttachmentIsMutable();
        attachment_.add(builderForValue.build());
        onChanged();
      } else {
        attachmentBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-uploaded attachment.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAttachment(int index, com.google.chat.v1.Attachment.Builder builderForValue) {
      if (attachmentBuilder_ == null) {
        ensureAttachmentIsMutable();
        attachment_.add(index, builderForValue.build());
        onChanged();
      } else {
        attachmentBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-uploaded attachment.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllAttachment(
        java.lang.Iterable<? extends com.google.chat.v1.Attachment> values) {
      if (attachmentBuilder_ == null) {
        ensureAttachmentIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, attachment_);
        onChanged();
      } else {
        attachmentBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-uploaded attachment.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAttachment() {
      if (attachmentBuilder_ == null) {
        attachment_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00010000);
        onChanged();
      } else {
        attachmentBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-uploaded attachment.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAttachment(int index) {
      if (attachmentBuilder_ == null) {
        ensureAttachmentIsMutable();
        attachment_.remove(index);
        onChanged();
      } else {
        attachmentBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-uploaded attachment.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.Attachment.Builder getAttachmentBuilder(int index) {
      return getAttachmentFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. User-uploaded attachment.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.AttachmentOrBuilder getAttachmentOrBuilder(int index) {
      if (attachmentBuilder_ == null) {
        return attachment_.get(index);
      } else {
        return attachmentBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. User-uploaded attachment.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.chat.v1.AttachmentOrBuilder>
        getAttachmentOrBuilderList() {
      if (attachmentBuilder_ != null) {
        return attachmentBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(attachment_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. User-uploaded attachment.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.Attachment.Builder addAttachmentBuilder() {
      return getAttachmentFieldBuilder()
          .addBuilder(com.google.chat.v1.Attachment.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. User-uploaded attachment.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.Attachment.Builder addAttachmentBuilder(int index) {
      return getAttachmentFieldBuilder()
          .addBuilder(index, com.google.chat.v1.Attachment.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. User-uploaded attachment.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.chat.v1.Attachment.Builder> getAttachmentBuilderList() {
      return getAttachmentFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.chat.v1.Attachment,
            com.google.chat.v1.Attachment.Builder,
            com.google.chat.v1.AttachmentOrBuilder>
        getAttachmentFieldBuilder() {
      if (attachmentBuilder_ == null) {
        attachmentBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.chat.v1.Attachment,
                com.google.chat.v1.Attachment.Builder,
                com.google.chat.v1.AttachmentOrBuilder>(
                attachment_, ((bitField0_ & 0x00010000) != 0), getParentForChildren(), isClean());
        attachment_ = null;
      }
      return attachmentBuilder_;
    }

    private com.google.chat.v1.MatchedUrl matchedUrl_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MatchedUrl,
            com.google.chat.v1.MatchedUrl.Builder,
            com.google.chat.v1.MatchedUrlOrBuilder>
        matchedUrlBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. A URL in `spaces.messages.text` that matches a link preview
     * pattern. For more information, see [Preview
     * links](https://developers.google.com/workspace/chat/preview-links).
     * </pre>
     *
     * <code>
     * .google.chat.v1.MatchedUrl matched_url = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the matchedUrl field is set.
     */
    public boolean hasMatchedUrl() {
      return ((bitField0_ & 0x00020000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. A URL in `spaces.messages.text` that matches a link preview
     * pattern. For more information, see [Preview
     * links](https://developers.google.com/workspace/chat/preview-links).
     * </pre>
     *
     * <code>
     * .google.chat.v1.MatchedUrl matched_url = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The matchedUrl.
     */
    public com.google.chat.v1.MatchedUrl getMatchedUrl() {
      if (matchedUrlBuilder_ == null) {
        return matchedUrl_ == null
            ? com.google.chat.v1.MatchedUrl.getDefaultInstance()
            : matchedUrl_;
      } else {
        return matchedUrlBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A URL in `spaces.messages.text` that matches a link preview
     * pattern. For more information, see [Preview
     * links](https://developers.google.com/workspace/chat/preview-links).
     * </pre>
     *
     * <code>
     * .google.chat.v1.MatchedUrl matched_url = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMatchedUrl(com.google.chat.v1.MatchedUrl value) {
      if (matchedUrlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        matchedUrl_ = value;
      } else {
        matchedUrlBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A URL in `spaces.messages.text` that matches a link preview
     * pattern. For more information, see [Preview
     * links](https://developers.google.com/workspace/chat/preview-links).
     * </pre>
     *
     * <code>
     * .google.chat.v1.MatchedUrl matched_url = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMatchedUrl(com.google.chat.v1.MatchedUrl.Builder builderForValue) {
      if (matchedUrlBuilder_ == null) {
        matchedUrl_ = builderForValue.build();
      } else {
        matchedUrlBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A URL in `spaces.messages.text` that matches a link preview
     * pattern. For more information, see [Preview
     * links](https://developers.google.com/workspace/chat/preview-links).
     * </pre>
     *
     * <code>
     * .google.chat.v1.MatchedUrl matched_url = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeMatchedUrl(com.google.chat.v1.MatchedUrl value) {
      if (matchedUrlBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && matchedUrl_ != null
            && matchedUrl_ != com.google.chat.v1.MatchedUrl.getDefaultInstance()) {
          getMatchedUrlBuilder().mergeFrom(value);
        } else {
          matchedUrl_ = value;
        }
      } else {
        matchedUrlBuilder_.mergeFrom(value);
      }
      if (matchedUrl_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A URL in `spaces.messages.text` that matches a link preview
     * pattern. For more information, see [Preview
     * links](https://developers.google.com/workspace/chat/preview-links).
     * </pre>
     *
     * <code>
     * .google.chat.v1.MatchedUrl matched_url = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMatchedUrl() {
      bitField0_ = (bitField0_ & ~0x00020000);
      matchedUrl_ = null;
      if (matchedUrlBuilder_ != null) {
        matchedUrlBuilder_.dispose();
        matchedUrlBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A URL in `spaces.messages.text` that matches a link preview
     * pattern. For more information, see [Preview
     * links](https://developers.google.com/workspace/chat/preview-links).
     * </pre>
     *
     * <code>
     * .google.chat.v1.MatchedUrl matched_url = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.MatchedUrl.Builder getMatchedUrlBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getMatchedUrlFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. A URL in `spaces.messages.text` that matches a link preview
     * pattern. For more information, see [Preview
     * links](https://developers.google.com/workspace/chat/preview-links).
     * </pre>
     *
     * <code>
     * .google.chat.v1.MatchedUrl matched_url = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.MatchedUrlOrBuilder getMatchedUrlOrBuilder() {
      if (matchedUrlBuilder_ != null) {
        return matchedUrlBuilder_.getMessageOrBuilder();
      } else {
        return matchedUrl_ == null
            ? com.google.chat.v1.MatchedUrl.getDefaultInstance()
            : matchedUrl_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A URL in `spaces.messages.text` that matches a link preview
     * pattern. For more information, see [Preview
     * links](https://developers.google.com/workspace/chat/preview-links).
     * </pre>
     *
     * <code>
     * .google.chat.v1.MatchedUrl matched_url = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MatchedUrl,
            com.google.chat.v1.MatchedUrl.Builder,
            com.google.chat.v1.MatchedUrlOrBuilder>
        getMatchedUrlFieldBuilder() {
      if (matchedUrlBuilder_ == null) {
        matchedUrlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.MatchedUrl,
                com.google.chat.v1.MatchedUrl.Builder,
                com.google.chat.v1.MatchedUrlOrBuilder>(
                getMatchedUrl(), getParentForChildren(), isClean());
        matchedUrl_ = null;
      }
      return matchedUrlBuilder_;
    }

    private boolean threadReply_;

    /**
     *
     *
     * <pre>
     * Output only. When `true`, the message is a response in a reply thread. When
     * `false`, the message is visible in the space's top-level conversation as
     * either the first message of a thread or a message with no threaded replies.
     *
     * If the space doesn't support reply in threads, this field is always
     * `false`.
     * </pre>
     *
     * <code>bool thread_reply = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The threadReply.
     */
    @java.lang.Override
    public boolean getThreadReply() {
      return threadReply_;
    }

    /**
     *
     *
     * <pre>
     * Output only. When `true`, the message is a response in a reply thread. When
     * `false`, the message is visible in the space's top-level conversation as
     * either the first message of a thread or a message with no threaded replies.
     *
     * If the space doesn't support reply in threads, this field is always
     * `false`.
     * </pre>
     *
     * <code>bool thread_reply = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The threadReply to set.
     * @return This builder for chaining.
     */
    public Builder setThreadReply(boolean value) {

      threadReply_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. When `true`, the message is a response in a reply thread. When
     * `false`, the message is visible in the space's top-level conversation as
     * either the first message of a thread or a message with no threaded replies.
     *
     * If the space doesn't support reply in threads, this field is always
     * `false`.
     * </pre>
     *
     * <code>bool thread_reply = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearThreadReply() {
      bitField0_ = (bitField0_ & ~0x00040000);
      threadReply_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object clientAssignedMessageId_ = "";

    /**
     *
     *
     * <pre>
     * Optional. A custom ID for the message. You can use field to identify a
     * message, or to get, delete, or update a message. To set a custom ID,
     * specify the
     * [`messageId`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages/create#body.QUERY_PARAMETERS.message_id)
     * field when you create the message. For details, see [Name a
     * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     * </pre>
     *
     * <code>string client_assigned_message_id = 32 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The clientAssignedMessageId.
     */
    public java.lang.String getClientAssignedMessageId() {
      java.lang.Object ref = clientAssignedMessageId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clientAssignedMessageId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A custom ID for the message. You can use field to identify a
     * message, or to get, delete, or update a message. To set a custom ID,
     * specify the
     * [`messageId`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages/create#body.QUERY_PARAMETERS.message_id)
     * field when you create the message. For details, see [Name a
     * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     * </pre>
     *
     * <code>string client_assigned_message_id = 32 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bytes for clientAssignedMessageId.
     */
    public com.google.protobuf.ByteString getClientAssignedMessageIdBytes() {
      java.lang.Object ref = clientAssignedMessageId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clientAssignedMessageId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A custom ID for the message. You can use field to identify a
     * message, or to get, delete, or update a message. To set a custom ID,
     * specify the
     * [`messageId`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages/create#body.QUERY_PARAMETERS.message_id)
     * field when you create the message. For details, see [Name a
     * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     * </pre>
     *
     * <code>string client_assigned_message_id = 32 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The clientAssignedMessageId to set.
     * @return This builder for chaining.
     */
    public Builder setClientAssignedMessageId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clientAssignedMessageId_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A custom ID for the message. You can use field to identify a
     * message, or to get, delete, or update a message. To set a custom ID,
     * specify the
     * [`messageId`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages/create#body.QUERY_PARAMETERS.message_id)
     * field when you create the message. For details, see [Name a
     * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     * </pre>
     *
     * <code>string client_assigned_message_id = 32 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClientAssignedMessageId() {
      clientAssignedMessageId_ = getDefaultInstance().getClientAssignedMessageId();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A custom ID for the message. You can use field to identify a
     * message, or to get, delete, or update a message. To set a custom ID,
     * specify the
     * [`messageId`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages/create#body.QUERY_PARAMETERS.message_id)
     * field when you create the message. For details, see [Name a
     * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
     * </pre>
     *
     * <code>string client_assigned_message_id = 32 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes for clientAssignedMessageId to set.
     * @return This builder for chaining.
     */
    public Builder setClientAssignedMessageIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clientAssignedMessageId_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.chat.v1.EmojiReactionSummary> emojiReactionSummaries_ =
        java.util.Collections.emptyList();

    private void ensureEmojiReactionSummariesIsMutable() {
      if (!((bitField0_ & 0x00100000) != 0)) {
        emojiReactionSummaries_ =
            new java.util.ArrayList<com.google.chat.v1.EmojiReactionSummary>(
                emojiReactionSummaries_);
        bitField0_ |= 0x00100000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.chat.v1.EmojiReactionSummary,
            com.google.chat.v1.EmojiReactionSummary.Builder,
            com.google.chat.v1.EmojiReactionSummaryOrBuilder>
        emojiReactionSummariesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The list of emoji reaction summaries on the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.chat.v1.EmojiReactionSummary> getEmojiReactionSummariesList() {
      if (emojiReactionSummariesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(emojiReactionSummaries_);
      } else {
        return emojiReactionSummariesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The list of emoji reaction summaries on the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getEmojiReactionSummariesCount() {
      if (emojiReactionSummariesBuilder_ == null) {
        return emojiReactionSummaries_.size();
      } else {
        return emojiReactionSummariesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The list of emoji reaction summaries on the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.EmojiReactionSummary getEmojiReactionSummaries(int index) {
      if (emojiReactionSummariesBuilder_ == null) {
        return emojiReactionSummaries_.get(index);
      } else {
        return emojiReactionSummariesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The list of emoji reaction summaries on the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEmojiReactionSummaries(
        int index, com.google.chat.v1.EmojiReactionSummary value) {
      if (emojiReactionSummariesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEmojiReactionSummariesIsMutable();
        emojiReactionSummaries_.set(index, value);
        onChanged();
      } else {
        emojiReactionSummariesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The list of emoji reaction summaries on the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEmojiReactionSummaries(
        int index, com.google.chat.v1.EmojiReactionSummary.Builder builderForValue) {
      if (emojiReactionSummariesBuilder_ == null) {
        ensureEmojiReactionSummariesIsMutable();
        emojiReactionSummaries_.set(index, builderForValue.build());
        onChanged();
      } else {
        emojiReactionSummariesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The list of emoji reaction summaries on the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addEmojiReactionSummaries(com.google.chat.v1.EmojiReactionSummary value) {
      if (emojiReactionSummariesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEmojiReactionSummariesIsMutable();
        emojiReactionSummaries_.add(value);
        onChanged();
      } else {
        emojiReactionSummariesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The list of emoji reaction summaries on the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addEmojiReactionSummaries(
        int index, com.google.chat.v1.EmojiReactionSummary value) {
      if (emojiReactionSummariesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEmojiReactionSummariesIsMutable();
        emojiReactionSummaries_.add(index, value);
        onChanged();
      } else {
        emojiReactionSummariesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The list of emoji reaction summaries on the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addEmojiReactionSummaries(
        com.google.chat.v1.EmojiReactionSummary.Builder builderForValue) {
      if (emojiReactionSummariesBuilder_ == null) {
        ensureEmojiReactionSummariesIsMutable();
        emojiReactionSummaries_.add(builderForValue.build());
        onChanged();
      } else {
        emojiReactionSummariesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The list of emoji reaction summaries on the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addEmojiReactionSummaries(
        int index, com.google.chat.v1.EmojiReactionSummary.Builder builderForValue) {
      if (emojiReactionSummariesBuilder_ == null) {
        ensureEmojiReactionSummariesIsMutable();
        emojiReactionSummaries_.add(index, builderForValue.build());
        onChanged();
      } else {
        emojiReactionSummariesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The list of emoji reaction summaries on the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllEmojiReactionSummaries(
        java.lang.Iterable<? extends com.google.chat.v1.EmojiReactionSummary> values) {
      if (emojiReactionSummariesBuilder_ == null) {
        ensureEmojiReactionSummariesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, emojiReactionSummaries_);
        onChanged();
      } else {
        emojiReactionSummariesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The list of emoji reaction summaries on the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEmojiReactionSummaries() {
      if (emojiReactionSummariesBuilder_ == null) {
        emojiReactionSummaries_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00100000);
        onChanged();
      } else {
        emojiReactionSummariesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The list of emoji reaction summaries on the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeEmojiReactionSummaries(int index) {
      if (emojiReactionSummariesBuilder_ == null) {
        ensureEmojiReactionSummariesIsMutable();
        emojiReactionSummaries_.remove(index);
        onChanged();
      } else {
        emojiReactionSummariesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The list of emoji reaction summaries on the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.EmojiReactionSummary.Builder getEmojiReactionSummariesBuilder(
        int index) {
      return getEmojiReactionSummariesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. The list of emoji reaction summaries on the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.EmojiReactionSummaryOrBuilder getEmojiReactionSummariesOrBuilder(
        int index) {
      if (emojiReactionSummariesBuilder_ == null) {
        return emojiReactionSummaries_.get(index);
      } else {
        return emojiReactionSummariesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The list of emoji reaction summaries on the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.chat.v1.EmojiReactionSummaryOrBuilder>
        getEmojiReactionSummariesOrBuilderList() {
      if (emojiReactionSummariesBuilder_ != null) {
        return emojiReactionSummariesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(emojiReactionSummaries_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The list of emoji reaction summaries on the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.EmojiReactionSummary.Builder addEmojiReactionSummariesBuilder() {
      return getEmojiReactionSummariesFieldBuilder()
          .addBuilder(com.google.chat.v1.EmojiReactionSummary.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. The list of emoji reaction summaries on the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.EmojiReactionSummary.Builder addEmojiReactionSummariesBuilder(
        int index) {
      return getEmojiReactionSummariesFieldBuilder()
          .addBuilder(index, com.google.chat.v1.EmojiReactionSummary.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. The list of emoji reaction summaries on the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.chat.v1.EmojiReactionSummary.Builder>
        getEmojiReactionSummariesBuilderList() {
      return getEmojiReactionSummariesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.chat.v1.EmojiReactionSummary,
            com.google.chat.v1.EmojiReactionSummary.Builder,
            com.google.chat.v1.EmojiReactionSummaryOrBuilder>
        getEmojiReactionSummariesFieldBuilder() {
      if (emojiReactionSummariesBuilder_ == null) {
        emojiReactionSummariesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.chat.v1.EmojiReactionSummary,
                com.google.chat.v1.EmojiReactionSummary.Builder,
                com.google.chat.v1.EmojiReactionSummaryOrBuilder>(
                emojiReactionSummaries_,
                ((bitField0_ & 0x00100000) != 0),
                getParentForChildren(),
                isClean());
        emojiReactionSummaries_ = null;
      }
      return emojiReactionSummariesBuilder_;
    }

    private com.google.chat.v1.User privateMessageViewer_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.User,
            com.google.chat.v1.User.Builder,
            com.google.chat.v1.UserOrBuilder>
        privateMessageViewerBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Input for creating a message, otherwise output only.
     * The user that can view the message. When set, the message is private and
     * only visible to the specified user and the Chat app. To include this field
     * in your request, you must call the Chat API using [app
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * and omit the following:
     *
     * * [Attachments](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.attachments)
     * * [Accessory
     * widgets](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#Message.AccessoryWidget)
     *
     * For details, see [Send a message
     * privately](https://developers.google.com/workspace/chat/create-messages#private).
     * </pre>
     *
     * <code>
     * .google.chat.v1.User private_message_viewer = 36 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the privateMessageViewer field is set.
     */
    public boolean hasPrivateMessageViewer() {
      return ((bitField0_ & 0x00200000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Input for creating a message, otherwise output only.
     * The user that can view the message. When set, the message is private and
     * only visible to the specified user and the Chat app. To include this field
     * in your request, you must call the Chat API using [app
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * and omit the following:
     *
     * * [Attachments](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.attachments)
     * * [Accessory
     * widgets](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#Message.AccessoryWidget)
     *
     * For details, see [Send a message
     * privately](https://developers.google.com/workspace/chat/create-messages#private).
     * </pre>
     *
     * <code>
     * .google.chat.v1.User private_message_viewer = 36 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The privateMessageViewer.
     */
    public com.google.chat.v1.User getPrivateMessageViewer() {
      if (privateMessageViewerBuilder_ == null) {
        return privateMessageViewer_ == null
            ? com.google.chat.v1.User.getDefaultInstance()
            : privateMessageViewer_;
      } else {
        return privateMessageViewerBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Input for creating a message, otherwise output only.
     * The user that can view the message. When set, the message is private and
     * only visible to the specified user and the Chat app. To include this field
     * in your request, you must call the Chat API using [app
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * and omit the following:
     *
     * * [Attachments](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.attachments)
     * * [Accessory
     * widgets](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#Message.AccessoryWidget)
     *
     * For details, see [Send a message
     * privately](https://developers.google.com/workspace/chat/create-messages#private).
     * </pre>
     *
     * <code>
     * .google.chat.v1.User private_message_viewer = 36 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPrivateMessageViewer(com.google.chat.v1.User value) {
      if (privateMessageViewerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        privateMessageViewer_ = value;
      } else {
        privateMessageViewerBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Input for creating a message, otherwise output only.
     * The user that can view the message. When set, the message is private and
     * only visible to the specified user and the Chat app. To include this field
     * in your request, you must call the Chat API using [app
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * and omit the following:
     *
     * * [Attachments](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.attachments)
     * * [Accessory
     * widgets](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#Message.AccessoryWidget)
     *
     * For details, see [Send a message
     * privately](https://developers.google.com/workspace/chat/create-messages#private).
     * </pre>
     *
     * <code>
     * .google.chat.v1.User private_message_viewer = 36 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPrivateMessageViewer(com.google.chat.v1.User.Builder builderForValue) {
      if (privateMessageViewerBuilder_ == null) {
        privateMessageViewer_ = builderForValue.build();
      } else {
        privateMessageViewerBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Input for creating a message, otherwise output only.
     * The user that can view the message. When set, the message is private and
     * only visible to the specified user and the Chat app. To include this field
     * in your request, you must call the Chat API using [app
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * and omit the following:
     *
     * * [Attachments](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.attachments)
     * * [Accessory
     * widgets](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#Message.AccessoryWidget)
     *
     * For details, see [Send a message
     * privately](https://developers.google.com/workspace/chat/create-messages#private).
     * </pre>
     *
     * <code>
     * .google.chat.v1.User private_message_viewer = 36 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePrivateMessageViewer(com.google.chat.v1.User value) {
      if (privateMessageViewerBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)
            && privateMessageViewer_ != null
            && privateMessageViewer_ != com.google.chat.v1.User.getDefaultInstance()) {
          getPrivateMessageViewerBuilder().mergeFrom(value);
        } else {
          privateMessageViewer_ = value;
        }
      } else {
        privateMessageViewerBuilder_.mergeFrom(value);
      }
      if (privateMessageViewer_ != null) {
        bitField0_ |= 0x00200000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Input for creating a message, otherwise output only.
     * The user that can view the message. When set, the message is private and
     * only visible to the specified user and the Chat app. To include this field
     * in your request, you must call the Chat API using [app
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * and omit the following:
     *
     * * [Attachments](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.attachments)
     * * [Accessory
     * widgets](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#Message.AccessoryWidget)
     *
     * For details, see [Send a message
     * privately](https://developers.google.com/workspace/chat/create-messages#private).
     * </pre>
     *
     * <code>
     * .google.chat.v1.User private_message_viewer = 36 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPrivateMessageViewer() {
      bitField0_ = (bitField0_ & ~0x00200000);
      privateMessageViewer_ = null;
      if (privateMessageViewerBuilder_ != null) {
        privateMessageViewerBuilder_.dispose();
        privateMessageViewerBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Input for creating a message, otherwise output only.
     * The user that can view the message. When set, the message is private and
     * only visible to the specified user and the Chat app. To include this field
     * in your request, you must call the Chat API using [app
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * and omit the following:
     *
     * * [Attachments](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.attachments)
     * * [Accessory
     * widgets](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#Message.AccessoryWidget)
     *
     * For details, see [Send a message
     * privately](https://developers.google.com/workspace/chat/create-messages#private).
     * </pre>
     *
     * <code>
     * .google.chat.v1.User private_message_viewer = 36 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.User.Builder getPrivateMessageViewerBuilder() {
      bitField0_ |= 0x00200000;
      onChanged();
      return getPrivateMessageViewerFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Input for creating a message, otherwise output only.
     * The user that can view the message. When set, the message is private and
     * only visible to the specified user and the Chat app. To include this field
     * in your request, you must call the Chat API using [app
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * and omit the following:
     *
     * * [Attachments](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.attachments)
     * * [Accessory
     * widgets](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#Message.AccessoryWidget)
     *
     * For details, see [Send a message
     * privately](https://developers.google.com/workspace/chat/create-messages#private).
     * </pre>
     *
     * <code>
     * .google.chat.v1.User private_message_viewer = 36 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.UserOrBuilder getPrivateMessageViewerOrBuilder() {
      if (privateMessageViewerBuilder_ != null) {
        return privateMessageViewerBuilder_.getMessageOrBuilder();
      } else {
        return privateMessageViewer_ == null
            ? com.google.chat.v1.User.getDefaultInstance()
            : privateMessageViewer_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Input for creating a message, otherwise output only.
     * The user that can view the message. When set, the message is private and
     * only visible to the specified user and the Chat app. To include this field
     * in your request, you must call the Chat API using [app
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * and omit the following:
     *
     * * [Attachments](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.attachments)
     * * [Accessory
     * widgets](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#Message.AccessoryWidget)
     *
     * For details, see [Send a message
     * privately](https://developers.google.com/workspace/chat/create-messages#private).
     * </pre>
     *
     * <code>
     * .google.chat.v1.User private_message_viewer = 36 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.User,
            com.google.chat.v1.User.Builder,
            com.google.chat.v1.UserOrBuilder>
        getPrivateMessageViewerFieldBuilder() {
      if (privateMessageViewerBuilder_ == null) {
        privateMessageViewerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.User,
                com.google.chat.v1.User.Builder,
                com.google.chat.v1.UserOrBuilder>(
                getPrivateMessageViewer(), getParentForChildren(), isClean());
        privateMessageViewer_ = null;
      }
      return privateMessageViewerBuilder_;
    }

    private com.google.chat.v1.DeletionMetadata deletionMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.DeletionMetadata,
            com.google.chat.v1.DeletionMetadata.Builder,
            com.google.chat.v1.DeletionMetadataOrBuilder>
        deletionMetadataBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Information about a deleted message. A message is deleted when
     * `delete_time` is set.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DeletionMetadata deletion_metadata = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deletionMetadata field is set.
     */
    public boolean hasDeletionMetadata() {
      return ((bitField0_ & 0x00400000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about a deleted message. A message is deleted when
     * `delete_time` is set.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DeletionMetadata deletion_metadata = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deletionMetadata.
     */
    public com.google.chat.v1.DeletionMetadata getDeletionMetadata() {
      if (deletionMetadataBuilder_ == null) {
        return deletionMetadata_ == null
            ? com.google.chat.v1.DeletionMetadata.getDefaultInstance()
            : deletionMetadata_;
      } else {
        return deletionMetadataBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about a deleted message. A message is deleted when
     * `delete_time` is set.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DeletionMetadata deletion_metadata = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeletionMetadata(com.google.chat.v1.DeletionMetadata value) {
      if (deletionMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deletionMetadata_ = value;
      } else {
        deletionMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about a deleted message. A message is deleted when
     * `delete_time` is set.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DeletionMetadata deletion_metadata = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeletionMetadata(
        com.google.chat.v1.DeletionMetadata.Builder builderForValue) {
      if (deletionMetadataBuilder_ == null) {
        deletionMetadata_ = builderForValue.build();
      } else {
        deletionMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about a deleted message. A message is deleted when
     * `delete_time` is set.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DeletionMetadata deletion_metadata = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeletionMetadata(com.google.chat.v1.DeletionMetadata value) {
      if (deletionMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00400000) != 0)
            && deletionMetadata_ != null
            && deletionMetadata_ != com.google.chat.v1.DeletionMetadata.getDefaultInstance()) {
          getDeletionMetadataBuilder().mergeFrom(value);
        } else {
          deletionMetadata_ = value;
        }
      } else {
        deletionMetadataBuilder_.mergeFrom(value);
      }
      if (deletionMetadata_ != null) {
        bitField0_ |= 0x00400000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about a deleted message. A message is deleted when
     * `delete_time` is set.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DeletionMetadata deletion_metadata = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeletionMetadata() {
      bitField0_ = (bitField0_ & ~0x00400000);
      deletionMetadata_ = null;
      if (deletionMetadataBuilder_ != null) {
        deletionMetadataBuilder_.dispose();
        deletionMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about a deleted message. A message is deleted when
     * `delete_time` is set.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DeletionMetadata deletion_metadata = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.DeletionMetadata.Builder getDeletionMetadataBuilder() {
      bitField0_ |= 0x00400000;
      onChanged();
      return getDeletionMetadataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about a deleted message. A message is deleted when
     * `delete_time` is set.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DeletionMetadata deletion_metadata = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.DeletionMetadataOrBuilder getDeletionMetadataOrBuilder() {
      if (deletionMetadataBuilder_ != null) {
        return deletionMetadataBuilder_.getMessageOrBuilder();
      } else {
        return deletionMetadata_ == null
            ? com.google.chat.v1.DeletionMetadata.getDefaultInstance()
            : deletionMetadata_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about a deleted message. A message is deleted when
     * `delete_time` is set.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DeletionMetadata deletion_metadata = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.DeletionMetadata,
            com.google.chat.v1.DeletionMetadata.Builder,
            com.google.chat.v1.DeletionMetadataOrBuilder>
        getDeletionMetadataFieldBuilder() {
      if (deletionMetadataBuilder_ == null) {
        deletionMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.DeletionMetadata,
                com.google.chat.v1.DeletionMetadata.Builder,
                com.google.chat.v1.DeletionMetadataOrBuilder>(
                getDeletionMetadata(), getParentForChildren(), isClean());
        deletionMetadata_ = null;
      }
      return deletionMetadataBuilder_;
    }

    private com.google.chat.v1.QuotedMessageMetadata quotedMessageMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.QuotedMessageMetadata,
            com.google.chat.v1.QuotedMessageMetadata.Builder,
            com.google.chat.v1.QuotedMessageMetadataOrBuilder>
        quotedMessageMetadataBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Information about a message that's quoted by a Google Chat
     * user in a space. Google Chat users can quote a message to reply to it.
     * </pre>
     *
     * <code>
     * .google.chat.v1.QuotedMessageMetadata quoted_message_metadata = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the quotedMessageMetadata field is set.
     */
    public boolean hasQuotedMessageMetadata() {
      return ((bitField0_ & 0x00800000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about a message that's quoted by a Google Chat
     * user in a space. Google Chat users can quote a message to reply to it.
     * </pre>
     *
     * <code>
     * .google.chat.v1.QuotedMessageMetadata quoted_message_metadata = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The quotedMessageMetadata.
     */
    public com.google.chat.v1.QuotedMessageMetadata getQuotedMessageMetadata() {
      if (quotedMessageMetadataBuilder_ == null) {
        return quotedMessageMetadata_ == null
            ? com.google.chat.v1.QuotedMessageMetadata.getDefaultInstance()
            : quotedMessageMetadata_;
      } else {
        return quotedMessageMetadataBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about a message that's quoted by a Google Chat
     * user in a space. Google Chat users can quote a message to reply to it.
     * </pre>
     *
     * <code>
     * .google.chat.v1.QuotedMessageMetadata quoted_message_metadata = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setQuotedMessageMetadata(com.google.chat.v1.QuotedMessageMetadata value) {
      if (quotedMessageMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        quotedMessageMetadata_ = value;
      } else {
        quotedMessageMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about a message that's quoted by a Google Chat
     * user in a space. Google Chat users can quote a message to reply to it.
     * </pre>
     *
     * <code>
     * .google.chat.v1.QuotedMessageMetadata quoted_message_metadata = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setQuotedMessageMetadata(
        com.google.chat.v1.QuotedMessageMetadata.Builder builderForValue) {
      if (quotedMessageMetadataBuilder_ == null) {
        quotedMessageMetadata_ = builderForValue.build();
      } else {
        quotedMessageMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about a message that's quoted by a Google Chat
     * user in a space. Google Chat users can quote a message to reply to it.
     * </pre>
     *
     * <code>
     * .google.chat.v1.QuotedMessageMetadata quoted_message_metadata = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeQuotedMessageMetadata(com.google.chat.v1.QuotedMessageMetadata value) {
      if (quotedMessageMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00800000) != 0)
            && quotedMessageMetadata_ != null
            && quotedMessageMetadata_
                != com.google.chat.v1.QuotedMessageMetadata.getDefaultInstance()) {
          getQuotedMessageMetadataBuilder().mergeFrom(value);
        } else {
          quotedMessageMetadata_ = value;
        }
      } else {
        quotedMessageMetadataBuilder_.mergeFrom(value);
      }
      if (quotedMessageMetadata_ != null) {
        bitField0_ |= 0x00800000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about a message that's quoted by a Google Chat
     * user in a space. Google Chat users can quote a message to reply to it.
     * </pre>
     *
     * <code>
     * .google.chat.v1.QuotedMessageMetadata quoted_message_metadata = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearQuotedMessageMetadata() {
      bitField0_ = (bitField0_ & ~0x00800000);
      quotedMessageMetadata_ = null;
      if (quotedMessageMetadataBuilder_ != null) {
        quotedMessageMetadataBuilder_.dispose();
        quotedMessageMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about a message that's quoted by a Google Chat
     * user in a space. Google Chat users can quote a message to reply to it.
     * </pre>
     *
     * <code>
     * .google.chat.v1.QuotedMessageMetadata quoted_message_metadata = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.QuotedMessageMetadata.Builder getQuotedMessageMetadataBuilder() {
      bitField0_ |= 0x00800000;
      onChanged();
      return getQuotedMessageMetadataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about a message that's quoted by a Google Chat
     * user in a space. Google Chat users can quote a message to reply to it.
     * </pre>
     *
     * <code>
     * .google.chat.v1.QuotedMessageMetadata quoted_message_metadata = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.QuotedMessageMetadataOrBuilder getQuotedMessageMetadataOrBuilder() {
      if (quotedMessageMetadataBuilder_ != null) {
        return quotedMessageMetadataBuilder_.getMessageOrBuilder();
      } else {
        return quotedMessageMetadata_ == null
            ? com.google.chat.v1.QuotedMessageMetadata.getDefaultInstance()
            : quotedMessageMetadata_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about a message that's quoted by a Google Chat
     * user in a space. Google Chat users can quote a message to reply to it.
     * </pre>
     *
     * <code>
     * .google.chat.v1.QuotedMessageMetadata quoted_message_metadata = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.QuotedMessageMetadata,
            com.google.chat.v1.QuotedMessageMetadata.Builder,
            com.google.chat.v1.QuotedMessageMetadataOrBuilder>
        getQuotedMessageMetadataFieldBuilder() {
      if (quotedMessageMetadataBuilder_ == null) {
        quotedMessageMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.QuotedMessageMetadata,
                com.google.chat.v1.QuotedMessageMetadata.Builder,
                com.google.chat.v1.QuotedMessageMetadataOrBuilder>(
                getQuotedMessageMetadata(), getParentForChildren(), isClean());
        quotedMessageMetadata_ = null;
      }
      return quotedMessageMetadataBuilder_;
    }

    private java.util.List<com.google.chat.v1.AttachedGif> attachedGifs_ =
        java.util.Collections.emptyList();

    private void ensureAttachedGifsIsMutable() {
      if (!((bitField0_ & 0x01000000) != 0)) {
        attachedGifs_ = new java.util.ArrayList<com.google.chat.v1.AttachedGif>(attachedGifs_);
        bitField0_ |= 0x01000000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.chat.v1.AttachedGif,
            com.google.chat.v1.AttachedGif.Builder,
            com.google.chat.v1.AttachedGifOrBuilder>
        attachedGifsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. GIF images that are attached to the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.chat.v1.AttachedGif> getAttachedGifsList() {
      if (attachedGifsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(attachedGifs_);
      } else {
        return attachedGifsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. GIF images that are attached to the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getAttachedGifsCount() {
      if (attachedGifsBuilder_ == null) {
        return attachedGifs_.size();
      } else {
        return attachedGifsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. GIF images that are attached to the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.AttachedGif getAttachedGifs(int index) {
      if (attachedGifsBuilder_ == null) {
        return attachedGifs_.get(index);
      } else {
        return attachedGifsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. GIF images that are attached to the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAttachedGifs(int index, com.google.chat.v1.AttachedGif value) {
      if (attachedGifsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttachedGifsIsMutable();
        attachedGifs_.set(index, value);
        onChanged();
      } else {
        attachedGifsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. GIF images that are attached to the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAttachedGifs(
        int index, com.google.chat.v1.AttachedGif.Builder builderForValue) {
      if (attachedGifsBuilder_ == null) {
        ensureAttachedGifsIsMutable();
        attachedGifs_.set(index, builderForValue.build());
        onChanged();
      } else {
        attachedGifsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. GIF images that are attached to the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAttachedGifs(com.google.chat.v1.AttachedGif value) {
      if (attachedGifsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttachedGifsIsMutable();
        attachedGifs_.add(value);
        onChanged();
      } else {
        attachedGifsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. GIF images that are attached to the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAttachedGifs(int index, com.google.chat.v1.AttachedGif value) {
      if (attachedGifsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttachedGifsIsMutable();
        attachedGifs_.add(index, value);
        onChanged();
      } else {
        attachedGifsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. GIF images that are attached to the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAttachedGifs(com.google.chat.v1.AttachedGif.Builder builderForValue) {
      if (attachedGifsBuilder_ == null) {
        ensureAttachedGifsIsMutable();
        attachedGifs_.add(builderForValue.build());
        onChanged();
      } else {
        attachedGifsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. GIF images that are attached to the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAttachedGifs(
        int index, com.google.chat.v1.AttachedGif.Builder builderForValue) {
      if (attachedGifsBuilder_ == null) {
        ensureAttachedGifsIsMutable();
        attachedGifs_.add(index, builderForValue.build());
        onChanged();
      } else {
        attachedGifsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. GIF images that are attached to the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllAttachedGifs(
        java.lang.Iterable<? extends com.google.chat.v1.AttachedGif> values) {
      if (attachedGifsBuilder_ == null) {
        ensureAttachedGifsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, attachedGifs_);
        onChanged();
      } else {
        attachedGifsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. GIF images that are attached to the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAttachedGifs() {
      if (attachedGifsBuilder_ == null) {
        attachedGifs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x01000000);
        onChanged();
      } else {
        attachedGifsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. GIF images that are attached to the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeAttachedGifs(int index) {
      if (attachedGifsBuilder_ == null) {
        ensureAttachedGifsIsMutable();
        attachedGifs_.remove(index);
        onChanged();
      } else {
        attachedGifsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. GIF images that are attached to the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.AttachedGif.Builder getAttachedGifsBuilder(int index) {
      return getAttachedGifsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. GIF images that are attached to the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.AttachedGifOrBuilder getAttachedGifsOrBuilder(int index) {
      if (attachedGifsBuilder_ == null) {
        return attachedGifs_.get(index);
      } else {
        return attachedGifsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. GIF images that are attached to the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.chat.v1.AttachedGifOrBuilder>
        getAttachedGifsOrBuilderList() {
      if (attachedGifsBuilder_ != null) {
        return attachedGifsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(attachedGifs_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. GIF images that are attached to the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.AttachedGif.Builder addAttachedGifsBuilder() {
      return getAttachedGifsFieldBuilder()
          .addBuilder(com.google.chat.v1.AttachedGif.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. GIF images that are attached to the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.AttachedGif.Builder addAttachedGifsBuilder(int index) {
      return getAttachedGifsFieldBuilder()
          .addBuilder(index, com.google.chat.v1.AttachedGif.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. GIF images that are attached to the message.
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.chat.v1.AttachedGif.Builder> getAttachedGifsBuilderList() {
      return getAttachedGifsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.chat.v1.AttachedGif,
            com.google.chat.v1.AttachedGif.Builder,
            com.google.chat.v1.AttachedGifOrBuilder>
        getAttachedGifsFieldBuilder() {
      if (attachedGifsBuilder_ == null) {
        attachedGifsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.chat.v1.AttachedGif,
                com.google.chat.v1.AttachedGif.Builder,
                com.google.chat.v1.AttachedGifOrBuilder>(
                attachedGifs_, ((bitField0_ & 0x01000000) != 0), getParentForChildren(), isClean());
        attachedGifs_ = null;
      }
      return attachedGifsBuilder_;
    }

    private java.util.List<com.google.chat.v1.AccessoryWidget> accessoryWidgets_ =
        java.util.Collections.emptyList();

    private void ensureAccessoryWidgetsIsMutable() {
      if (!((bitField0_ & 0x02000000) != 0)) {
        accessoryWidgets_ =
            new java.util.ArrayList<com.google.chat.v1.AccessoryWidget>(accessoryWidgets_);
        bitField0_ |= 0x02000000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.chat.v1.AccessoryWidget,
            com.google.chat.v1.AccessoryWidget.Builder,
            com.google.chat.v1.AccessoryWidgetOrBuilder>
        accessoryWidgetsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. One or more interactive widgets that appear at the bottom of a
     * message. You can add accessory widgets to messages that contain text,
     * cards, or both text and cards. Not supported for messages that contain
     * dialogs. For details, see [Add interactive widgets at the bottom of a
     * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     *
     * Creating a message with accessory widgets requires [app
     * authentication]
     * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.chat.v1.AccessoryWidget> getAccessoryWidgetsList() {
      if (accessoryWidgetsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(accessoryWidgets_);
      } else {
        return accessoryWidgetsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. One or more interactive widgets that appear at the bottom of a
     * message. You can add accessory widgets to messages that contain text,
     * cards, or both text and cards. Not supported for messages that contain
     * dialogs. For details, see [Add interactive widgets at the bottom of a
     * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     *
     * Creating a message with accessory widgets requires [app
     * authentication]
     * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getAccessoryWidgetsCount() {
      if (accessoryWidgetsBuilder_ == null) {
        return accessoryWidgets_.size();
      } else {
        return accessoryWidgetsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. One or more interactive widgets that appear at the bottom of a
     * message. You can add accessory widgets to messages that contain text,
     * cards, or both text and cards. Not supported for messages that contain
     * dialogs. For details, see [Add interactive widgets at the bottom of a
     * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     *
     * Creating a message with accessory widgets requires [app
     * authentication]
     * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.AccessoryWidget getAccessoryWidgets(int index) {
      if (accessoryWidgetsBuilder_ == null) {
        return accessoryWidgets_.get(index);
      } else {
        return accessoryWidgetsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. One or more interactive widgets that appear at the bottom of a
     * message. You can add accessory widgets to messages that contain text,
     * cards, or both text and cards. Not supported for messages that contain
     * dialogs. For details, see [Add interactive widgets at the bottom of a
     * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     *
     * Creating a message with accessory widgets requires [app
     * authentication]
     * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAccessoryWidgets(int index, com.google.chat.v1.AccessoryWidget value) {
      if (accessoryWidgetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAccessoryWidgetsIsMutable();
        accessoryWidgets_.set(index, value);
        onChanged();
      } else {
        accessoryWidgetsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. One or more interactive widgets that appear at the bottom of a
     * message. You can add accessory widgets to messages that contain text,
     * cards, or both text and cards. Not supported for messages that contain
     * dialogs. For details, see [Add interactive widgets at the bottom of a
     * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     *
     * Creating a message with accessory widgets requires [app
     * authentication]
     * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAccessoryWidgets(
        int index, com.google.chat.v1.AccessoryWidget.Builder builderForValue) {
      if (accessoryWidgetsBuilder_ == null) {
        ensureAccessoryWidgetsIsMutable();
        accessoryWidgets_.set(index, builderForValue.build());
        onChanged();
      } else {
        accessoryWidgetsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. One or more interactive widgets that appear at the bottom of a
     * message. You can add accessory widgets to messages that contain text,
     * cards, or both text and cards. Not supported for messages that contain
     * dialogs. For details, see [Add interactive widgets at the bottom of a
     * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     *
     * Creating a message with accessory widgets requires [app
     * authentication]
     * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAccessoryWidgets(com.google.chat.v1.AccessoryWidget value) {
      if (accessoryWidgetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAccessoryWidgetsIsMutable();
        accessoryWidgets_.add(value);
        onChanged();
      } else {
        accessoryWidgetsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. One or more interactive widgets that appear at the bottom of a
     * message. You can add accessory widgets to messages that contain text,
     * cards, or both text and cards. Not supported for messages that contain
     * dialogs. For details, see [Add interactive widgets at the bottom of a
     * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     *
     * Creating a message with accessory widgets requires [app
     * authentication]
     * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAccessoryWidgets(int index, com.google.chat.v1.AccessoryWidget value) {
      if (accessoryWidgetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAccessoryWidgetsIsMutable();
        accessoryWidgets_.add(index, value);
        onChanged();
      } else {
        accessoryWidgetsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. One or more interactive widgets that appear at the bottom of a
     * message. You can add accessory widgets to messages that contain text,
     * cards, or both text and cards. Not supported for messages that contain
     * dialogs. For details, see [Add interactive widgets at the bottom of a
     * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     *
     * Creating a message with accessory widgets requires [app
     * authentication]
     * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAccessoryWidgets(com.google.chat.v1.AccessoryWidget.Builder builderForValue) {
      if (accessoryWidgetsBuilder_ == null) {
        ensureAccessoryWidgetsIsMutable();
        accessoryWidgets_.add(builderForValue.build());
        onChanged();
      } else {
        accessoryWidgetsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. One or more interactive widgets that appear at the bottom of a
     * message. You can add accessory widgets to messages that contain text,
     * cards, or both text and cards. Not supported for messages that contain
     * dialogs. For details, see [Add interactive widgets at the bottom of a
     * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     *
     * Creating a message with accessory widgets requires [app
     * authentication]
     * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAccessoryWidgets(
        int index, com.google.chat.v1.AccessoryWidget.Builder builderForValue) {
      if (accessoryWidgetsBuilder_ == null) {
        ensureAccessoryWidgetsIsMutable();
        accessoryWidgets_.add(index, builderForValue.build());
        onChanged();
      } else {
        accessoryWidgetsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. One or more interactive widgets that appear at the bottom of a
     * message. You can add accessory widgets to messages that contain text,
     * cards, or both text and cards. Not supported for messages that contain
     * dialogs. For details, see [Add interactive widgets at the bottom of a
     * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     *
     * Creating a message with accessory widgets requires [app
     * authentication]
     * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllAccessoryWidgets(
        java.lang.Iterable<? extends com.google.chat.v1.AccessoryWidget> values) {
      if (accessoryWidgetsBuilder_ == null) {
        ensureAccessoryWidgetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, accessoryWidgets_);
        onChanged();
      } else {
        accessoryWidgetsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. One or more interactive widgets that appear at the bottom of a
     * message. You can add accessory widgets to messages that contain text,
     * cards, or both text and cards. Not supported for messages that contain
     * dialogs. For details, see [Add interactive widgets at the bottom of a
     * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     *
     * Creating a message with accessory widgets requires [app
     * authentication]
     * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAccessoryWidgets() {
      if (accessoryWidgetsBuilder_ == null) {
        accessoryWidgets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x02000000);
        onChanged();
      } else {
        accessoryWidgetsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. One or more interactive widgets that appear at the bottom of a
     * message. You can add accessory widgets to messages that contain text,
     * cards, or both text and cards. Not supported for messages that contain
     * dialogs. For details, see [Add interactive widgets at the bottom of a
     * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     *
     * Creating a message with accessory widgets requires [app
     * authentication]
     * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAccessoryWidgets(int index) {
      if (accessoryWidgetsBuilder_ == null) {
        ensureAccessoryWidgetsIsMutable();
        accessoryWidgets_.remove(index);
        onChanged();
      } else {
        accessoryWidgetsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. One or more interactive widgets that appear at the bottom of a
     * message. You can add accessory widgets to messages that contain text,
     * cards, or both text and cards. Not supported for messages that contain
     * dialogs. For details, see [Add interactive widgets at the bottom of a
     * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     *
     * Creating a message with accessory widgets requires [app
     * authentication]
     * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.AccessoryWidget.Builder getAccessoryWidgetsBuilder(int index) {
      return getAccessoryWidgetsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. One or more interactive widgets that appear at the bottom of a
     * message. You can add accessory widgets to messages that contain text,
     * cards, or both text and cards. Not supported for messages that contain
     * dialogs. For details, see [Add interactive widgets at the bottom of a
     * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     *
     * Creating a message with accessory widgets requires [app
     * authentication]
     * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.AccessoryWidgetOrBuilder getAccessoryWidgetsOrBuilder(int index) {
      if (accessoryWidgetsBuilder_ == null) {
        return accessoryWidgets_.get(index);
      } else {
        return accessoryWidgetsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. One or more interactive widgets that appear at the bottom of a
     * message. You can add accessory widgets to messages that contain text,
     * cards, or both text and cards. Not supported for messages that contain
     * dialogs. For details, see [Add interactive widgets at the bottom of a
     * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     *
     * Creating a message with accessory widgets requires [app
     * authentication]
     * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.chat.v1.AccessoryWidgetOrBuilder>
        getAccessoryWidgetsOrBuilderList() {
      if (accessoryWidgetsBuilder_ != null) {
        return accessoryWidgetsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(accessoryWidgets_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. One or more interactive widgets that appear at the bottom of a
     * message. You can add accessory widgets to messages that contain text,
     * cards, or both text and cards. Not supported for messages that contain
     * dialogs. For details, see [Add interactive widgets at the bottom of a
     * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     *
     * Creating a message with accessory widgets requires [app
     * authentication]
     * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.AccessoryWidget.Builder addAccessoryWidgetsBuilder() {
      return getAccessoryWidgetsFieldBuilder()
          .addBuilder(com.google.chat.v1.AccessoryWidget.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. One or more interactive widgets that appear at the bottom of a
     * message. You can add accessory widgets to messages that contain text,
     * cards, or both text and cards. Not supported for messages that contain
     * dialogs. For details, see [Add interactive widgets at the bottom of a
     * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     *
     * Creating a message with accessory widgets requires [app
     * authentication]
     * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.AccessoryWidget.Builder addAccessoryWidgetsBuilder(int index) {
      return getAccessoryWidgetsFieldBuilder()
          .addBuilder(index, com.google.chat.v1.AccessoryWidget.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. One or more interactive widgets that appear at the bottom of a
     * message. You can add accessory widgets to messages that contain text,
     * cards, or both text and cards. Not supported for messages that contain
     * dialogs. For details, see [Add interactive widgets at the bottom of a
     * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
     *
     * Creating a message with accessory widgets requires [app
     * authentication]
     * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.chat.v1.AccessoryWidget.Builder>
        getAccessoryWidgetsBuilderList() {
      return getAccessoryWidgetsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.chat.v1.AccessoryWidget,
            com.google.chat.v1.AccessoryWidget.Builder,
            com.google.chat.v1.AccessoryWidgetOrBuilder>
        getAccessoryWidgetsFieldBuilder() {
      if (accessoryWidgetsBuilder_ == null) {
        accessoryWidgetsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.chat.v1.AccessoryWidget,
                com.google.chat.v1.AccessoryWidget.Builder,
                com.google.chat.v1.AccessoryWidgetOrBuilder>(
                accessoryWidgets_,
                ((bitField0_ & 0x02000000) != 0),
                getParentForChildren(),
                isClean());
        accessoryWidgets_ = null;
      }
      return accessoryWidgetsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.Message)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.Message)
  private static final com.google.chat.v1.Message DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.Message();
  }

  public static com.google.chat.v1.Message getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Message> PARSER =
      new com.google.protobuf.AbstractParser<Message>() {
        @java.lang.Override
        public Message parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Message> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Message> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.Message getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
