/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/message.proto

// Protobuf Java Version: 3.25.5
package com.google.chat.v1;

public interface MessageOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.chat.v1.Message)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Identifier. Resource name of the message.
   *
   * Format: `spaces/{space}/messages/{message}`
   *
   *
   * Where `{space}` is the ID of the space where the message is posted and
   * `{message}` is a system-assigned ID for the message. For example,
   * `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`.
   *
   * If you set a custom ID when you create a message, you can use this ID to
   * specify the message in a request by replacing `{message}` with the value
   * from the `clientAssignedMessageId` field. For example,
   * `spaces/AAAAAAAAAAA/messages/client-custom-name`. For details, see [Name
   * a
   * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Identifier. Resource name of the message.
   *
   * Format: `spaces/{space}/messages/{message}`
   *
   *
   * Where `{space}` is the ID of the space where the message is posted and
   * `{message}` is a system-assigned ID for the message. For example,
   * `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`.
   *
   * If you set a custom ID when you create a message, you can use this ID to
   * specify the message in a request by replacing `{message}` with the value
   * from the `clientAssignedMessageId` field. For example,
   * `spaces/AAAAAAAAAAA/messages/client-custom-name`. For details, see [Name
   * a
   * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. The user who created the message.
   * If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the output populates the
   * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
   * `name` and `type`.
   * </pre>
   *
   * <code>.google.chat.v1.User sender = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the sender field is set.
   */
  boolean hasSender();

  /**
   *
   *
   * <pre>
   * Output only. The user who created the message.
   * If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the output populates the
   * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
   * `name` and `type`.
   * </pre>
   *
   * <code>.google.chat.v1.User sender = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The sender.
   */
  com.google.chat.v1.User getSender();

  /**
   *
   *
   * <pre>
   * Output only. The user who created the message.
   * If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the output populates the
   * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
   * `name` and `type`.
   * </pre>
   *
   * <code>.google.chat.v1.User sender = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  com.google.chat.v1.UserOrBuilder getSenderOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Immutable. For spaces created in Chat, the time at which the
   * message was created. This field is output only, except when used in import
   * mode spaces.
   *
   * For import mode spaces, set this field to the historical timestamp at which
   * the message was created in the source in order to preserve the original
   * creation time.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();

  /**
   *
   *
   * <pre>
   * Optional. Immutable. For spaces created in Chat, the time at which the
   * message was created. This field is output only, except when used in import
   * mode spaces.
   *
   * For import mode spaces, set this field to the historical timestamp at which
   * the message was created in the source in order to preserve the original
   * creation time.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();

  /**
   *
   *
   * <pre>
   * Optional. Immutable. For spaces created in Chat, the time at which the
   * message was created. This field is output only, except when used in import
   * mode spaces.
   *
   * For import mode spaces, set this field to the historical timestamp at which
   * the message was created in the source in order to preserve the original
   * creation time.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The time at which the message was last edited by a user. If
   * the message has never been edited, this field is empty.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_update_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastUpdateTime field is set.
   */
  boolean hasLastUpdateTime();

  /**
   *
   *
   * <pre>
   * Output only. The time at which the message was last edited by a user. If
   * the message has never been edited, this field is empty.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_update_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastUpdateTime.
   */
  com.google.protobuf.Timestamp getLastUpdateTime();

  /**
   *
   *
   * <pre>
   * Output only. The time at which the message was last edited by a user. If
   * the message has never been edited, this field is empty.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_update_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The time at which the message was deleted in
   * Google Chat. If the message is never deleted, this field is empty.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deleteTime field is set.
   */
  boolean hasDeleteTime();

  /**
   *
   *
   * <pre>
   * Output only. The time at which the message was deleted in
   * Google Chat. If the message is never deleted, this field is empty.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deleteTime.
   */
  com.google.protobuf.Timestamp getDeleteTime();

  /**
   *
   *
   * <pre>
   * Output only. The time at which the message was deleted in
   * Google Chat. If the message is never deleted, this field is empty.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Plain-text body of the message. The first link to an image,
   * video, or web page generates a [preview
   * chip](https://developers.google.com/workspace/chat/preview-links). You can
   * also [&#64;mention a Google Chat
   * user](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention),
   * or everyone in the space.
   *
   * To learn about creating text messages, see [Send a
   * message](https://developers.google.com/workspace/chat/create-messages).
   * </pre>
   *
   * <code>string text = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The text.
   */
  java.lang.String getText();

  /**
   *
   *
   * <pre>
   * Optional. Plain-text body of the message. The first link to an image,
   * video, or web page generates a [preview
   * chip](https://developers.google.com/workspace/chat/preview-links). You can
   * also [&#64;mention a Google Chat
   * user](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention),
   * or everyone in the space.
   *
   * To learn about creating text messages, see [Send a
   * message](https://developers.google.com/workspace/chat/create-messages).
   * </pre>
   *
   * <code>string text = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for text.
   */
  com.google.protobuf.ByteString getTextBytes();

  /**
   *
   *
   * <pre>
   * Output only. Contains the message `text` with markups added to communicate
   * formatting. This field might not capture all formatting visible in the UI,
   * but includes the following:
   *
   * * [Markup
   * syntax](https://developers.google.com/workspace/chat/format-messages)
   * for bold, italic, strikethrough, monospace, monospace block, and bulleted
   * list.
   *
   * * [User
   * mentions](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention)
   * using the format `&lt;users/{user}&gt;`.
   *
   * * Custom hyperlinks using the format `&lt;{url}|{rendered_text}&gt;` where the
   * first string is the URL and the second is the rendered text—for example,
   * `&lt;http://example.com|custom text&gt;`.
   *
   * * Custom emoji using the format `:{emoji_name}:`—for example, `:smile:`.
   * This doesn't apply to Unicode emoji, such as `U+1F600` for a grinning
   * face emoji.
   *
   * For more information, see [View text formatting sent in a
   * message](https://developers.google.com/workspace/chat/format-messages#view_text_formatting_sent_in_a_message)
   * </pre>
   *
   * <code>string formatted_text = 43 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The formattedText.
   */
  java.lang.String getFormattedText();

  /**
   *
   *
   * <pre>
   * Output only. Contains the message `text` with markups added to communicate
   * formatting. This field might not capture all formatting visible in the UI,
   * but includes the following:
   *
   * * [Markup
   * syntax](https://developers.google.com/workspace/chat/format-messages)
   * for bold, italic, strikethrough, monospace, monospace block, and bulleted
   * list.
   *
   * * [User
   * mentions](https://developers.google.com/workspace/chat/format-messages#messages-&#64;mention)
   * using the format `&lt;users/{user}&gt;`.
   *
   * * Custom hyperlinks using the format `&lt;{url}|{rendered_text}&gt;` where the
   * first string is the URL and the second is the rendered text—for example,
   * `&lt;http://example.com|custom text&gt;`.
   *
   * * Custom emoji using the format `:{emoji_name}:`—for example, `:smile:`.
   * This doesn't apply to Unicode emoji, such as `U+1F600` for a grinning
   * face emoji.
   *
   * For more information, see [View text formatting sent in a
   * message](https://developers.google.com/workspace/chat/format-messages#view_text_formatting_sent_in_a_message)
   * </pre>
   *
   * <code>string formatted_text = 43 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for formattedText.
   */
  com.google.protobuf.ByteString getFormattedTextBytes();

  /**
   *
   *
   * <pre>
   * Deprecated: Use `cards_v2` instead.
   *
   * Rich, formatted, and interactive cards that you can use to display UI
   * elements such as: formatted texts, buttons, and clickable images. Cards are
   * normally displayed below the plain-text body of the message. `cards` and
   * `cards_v2` can have a maximum size of 32 KB.
   * </pre>
   *
   * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];</code>
   */
  @java.lang.Deprecated
  java.util.List<com.google.chat.v1.ContextualAddOnMarkup.Card> getCardsList();

  /**
   *
   *
   * <pre>
   * Deprecated: Use `cards_v2` instead.
   *
   * Rich, formatted, and interactive cards that you can use to display UI
   * elements such as: formatted texts, buttons, and clickable images. Cards are
   * normally displayed below the plain-text body of the message. `cards` and
   * `cards_v2` can have a maximum size of 32 KB.
   * </pre>
   *
   * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];</code>
   */
  @java.lang.Deprecated
  com.google.chat.v1.ContextualAddOnMarkup.Card getCards(int index);

  /**
   *
   *
   * <pre>
   * Deprecated: Use `cards_v2` instead.
   *
   * Rich, formatted, and interactive cards that you can use to display UI
   * elements such as: formatted texts, buttons, and clickable images. Cards are
   * normally displayed below the plain-text body of the message. `cards` and
   * `cards_v2` can have a maximum size of 32 KB.
   * </pre>
   *
   * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];</code>
   */
  @java.lang.Deprecated
  int getCardsCount();

  /**
   *
   *
   * <pre>
   * Deprecated: Use `cards_v2` instead.
   *
   * Rich, formatted, and interactive cards that you can use to display UI
   * elements such as: formatted texts, buttons, and clickable images. Cards are
   * normally displayed below the plain-text body of the message. `cards` and
   * `cards_v2` can have a maximum size of 32 KB.
   * </pre>
   *
   * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];</code>
   */
  @java.lang.Deprecated
  java.util.List<? extends com.google.chat.v1.ContextualAddOnMarkup.CardOrBuilder>
      getCardsOrBuilderList();

  /**
   *
   *
   * <pre>
   * Deprecated: Use `cards_v2` instead.
   *
   * Rich, formatted, and interactive cards that you can use to display UI
   * elements such as: formatted texts, buttons, and clickable images. Cards are
   * normally displayed below the plain-text body of the message. `cards` and
   * `cards_v2` can have a maximum size of 32 KB.
   * </pre>
   *
   * <code>repeated .google.chat.v1.ContextualAddOnMarkup.Card cards = 5 [deprecated = true];</code>
   */
  @java.lang.Deprecated
  com.google.chat.v1.ContextualAddOnMarkup.CardOrBuilder getCardsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Optional. An array of
   * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
   *
   * Only Chat apps can create cards. If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the messages can't contain cards.
   *
   * To learn how to create a message that contains cards, see [Send a
   * message](https://developers.google.com/workspace/chat/create-messages).
   *
   * [Card builder](https://addons.gsuite.google.com/uikit/builder)
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.chat.v1.CardWithId> getCardsV2List();

  /**
   *
   *
   * <pre>
   * Optional. An array of
   * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
   *
   * Only Chat apps can create cards. If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the messages can't contain cards.
   *
   * To learn how to create a message that contains cards, see [Send a
   * message](https://developers.google.com/workspace/chat/create-messages).
   *
   * [Card builder](https://addons.gsuite.google.com/uikit/builder)
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.chat.v1.CardWithId getCardsV2(int index);

  /**
   *
   *
   * <pre>
   * Optional. An array of
   * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
   *
   * Only Chat apps can create cards. If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the messages can't contain cards.
   *
   * To learn how to create a message that contains cards, see [Send a
   * message](https://developers.google.com/workspace/chat/create-messages).
   *
   * [Card builder](https://addons.gsuite.google.com/uikit/builder)
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getCardsV2Count();

  /**
   *
   *
   * <pre>
   * Optional. An array of
   * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
   *
   * Only Chat apps can create cards. If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the messages can't contain cards.
   *
   * To learn how to create a message that contains cards, see [Send a
   * message](https://developers.google.com/workspace/chat/create-messages).
   *
   * [Card builder](https://addons.gsuite.google.com/uikit/builder)
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.chat.v1.CardWithIdOrBuilder> getCardsV2OrBuilderList();

  /**
   *
   *
   * <pre>
   * Optional. An array of
   * [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
   *
   * Only Chat apps can create cards. If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the messages can't contain cards.
   *
   * To learn how to create a message that contains cards, see [Send a
   * message](https://developers.google.com/workspace/chat/create-messages).
   *
   * [Card builder](https://addons.gsuite.google.com/uikit/builder)
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.CardWithId cards_v2 = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.chat.v1.CardWithIdOrBuilder getCardsV2OrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Output only. Annotations associated with the `text` in this message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.chat.v1.Annotation> getAnnotationsList();

  /**
   *
   *
   * <pre>
   * Output only. Annotations associated with the `text` in this message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.chat.v1.Annotation getAnnotations(int index);

  /**
   *
   *
   * <pre>
   * Output only. Annotations associated with the `text` in this message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getAnnotationsCount();

  /**
   *
   *
   * <pre>
   * Output only. Annotations associated with the `text` in this message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.chat.v1.AnnotationOrBuilder> getAnnotationsOrBuilderList();

  /**
   *
   *
   * <pre>
   * Output only. Annotations associated with the `text` in this message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Annotation annotations = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.chat.v1.AnnotationOrBuilder getAnnotationsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * The thread the message belongs to. For example usage, see
   * [Start or reply to a message
   * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
   * </pre>
   *
   * <code>.google.chat.v1.Thread thread = 11;</code>
   *
   * @return Whether the thread field is set.
   */
  boolean hasThread();

  /**
   *
   *
   * <pre>
   * The thread the message belongs to. For example usage, see
   * [Start or reply to a message
   * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
   * </pre>
   *
   * <code>.google.chat.v1.Thread thread = 11;</code>
   *
   * @return The thread.
   */
  com.google.chat.v1.Thread getThread();

  /**
   *
   *
   * <pre>
   * The thread the message belongs to. For example usage, see
   * [Start or reply to a message
   * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
   * </pre>
   *
   * <code>.google.chat.v1.Thread thread = 11;</code>
   */
  com.google.chat.v1.ThreadOrBuilder getThreadOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the output only populates the
   * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
   * `name`.
   * </pre>
   *
   * <code>.google.chat.v1.Space space = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the space field is set.
   */
  boolean hasSpace();

  /**
   *
   *
   * <pre>
   * Output only. If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the output only populates the
   * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
   * `name`.
   * </pre>
   *
   * <code>.google.chat.v1.Space space = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The space.
   */
  com.google.chat.v1.Space getSpace();

  /**
   *
   *
   * <pre>
   * Output only. If your Chat app [authenticates as a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the output only populates the
   * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
   * `name`.
   * </pre>
   *
   * <code>.google.chat.v1.Space space = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  com.google.chat.v1.SpaceOrBuilder getSpaceOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. A plain-text description of the message's cards, used when the
   * actual cards can't be displayed—for example, mobile notifications.
   * </pre>
   *
   * <code>string fallback_text = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The fallbackText.
   */
  java.lang.String getFallbackText();

  /**
   *
   *
   * <pre>
   * Optional. A plain-text description of the message's cards, used when the
   * actual cards can't be displayed—for example, mobile notifications.
   * </pre>
   *
   * <code>string fallback_text = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for fallbackText.
   */
  com.google.protobuf.ByteString getFallbackTextBytes();

  /**
   *
   *
   * <pre>
   * Input only. Parameters that a Chat app can use to configure how its
   * response is posted.
   * </pre>
   *
   * <code>
   * .google.chat.v1.ActionResponse action_response = 14 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return Whether the actionResponse field is set.
   */
  boolean hasActionResponse();

  /**
   *
   *
   * <pre>
   * Input only. Parameters that a Chat app can use to configure how its
   * response is posted.
   * </pre>
   *
   * <code>
   * .google.chat.v1.ActionResponse action_response = 14 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The actionResponse.
   */
  com.google.chat.v1.ActionResponse getActionResponse();

  /**
   *
   *
   * <pre>
   * Input only. Parameters that a Chat app can use to configure how its
   * response is posted.
   * </pre>
   *
   * <code>
   * .google.chat.v1.ActionResponse action_response = 14 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  com.google.chat.v1.ActionResponseOrBuilder getActionResponseOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Plain-text body of the message with all Chat app mentions
   * stripped out.
   * </pre>
   *
   * <code>string argument_text = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The argumentText.
   */
  java.lang.String getArgumentText();

  /**
   *
   *
   * <pre>
   * Output only. Plain-text body of the message with all Chat app mentions
   * stripped out.
   * </pre>
   *
   * <code>string argument_text = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for argumentText.
   */
  com.google.protobuf.ByteString getArgumentTextBytes();

  /**
   *
   *
   * <pre>
   * Output only. Slash command information, if applicable.
   * </pre>
   *
   * <code>
   * .google.chat.v1.SlashCommand slash_command = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the slashCommand field is set.
   */
  boolean hasSlashCommand();

  /**
   *
   *
   * <pre>
   * Output only. Slash command information, if applicable.
   * </pre>
   *
   * <code>
   * .google.chat.v1.SlashCommand slash_command = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The slashCommand.
   */
  com.google.chat.v1.SlashCommand getSlashCommand();

  /**
   *
   *
   * <pre>
   * Output only. Slash command information, if applicable.
   * </pre>
   *
   * <code>
   * .google.chat.v1.SlashCommand slash_command = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.chat.v1.SlashCommandOrBuilder getSlashCommandOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. User-uploaded attachment.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.chat.v1.Attachment> getAttachmentList();

  /**
   *
   *
   * <pre>
   * Optional. User-uploaded attachment.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.chat.v1.Attachment getAttachment(int index);

  /**
   *
   *
   * <pre>
   * Optional. User-uploaded attachment.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getAttachmentCount();

  /**
   *
   *
   * <pre>
   * Optional. User-uploaded attachment.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.chat.v1.AttachmentOrBuilder> getAttachmentOrBuilderList();

  /**
   *
   *
   * <pre>
   * Optional. User-uploaded attachment.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Attachment attachment = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.chat.v1.AttachmentOrBuilder getAttachmentOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Output only. A URL in `spaces.messages.text` that matches a link preview
   * pattern. For more information, see [Preview
   * links](https://developers.google.com/workspace/chat/preview-links).
   * </pre>
   *
   * <code>.google.chat.v1.MatchedUrl matched_url = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the matchedUrl field is set.
   */
  boolean hasMatchedUrl();

  /**
   *
   *
   * <pre>
   * Output only. A URL in `spaces.messages.text` that matches a link preview
   * pattern. For more information, see [Preview
   * links](https://developers.google.com/workspace/chat/preview-links).
   * </pre>
   *
   * <code>.google.chat.v1.MatchedUrl matched_url = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The matchedUrl.
   */
  com.google.chat.v1.MatchedUrl getMatchedUrl();

  /**
   *
   *
   * <pre>
   * Output only. A URL in `spaces.messages.text` that matches a link preview
   * pattern. For more information, see [Preview
   * links](https://developers.google.com/workspace/chat/preview-links).
   * </pre>
   *
   * <code>.google.chat.v1.MatchedUrl matched_url = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.chat.v1.MatchedUrlOrBuilder getMatchedUrlOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. When `true`, the message is a response in a reply thread. When
   * `false`, the message is visible in the space's top-level conversation as
   * either the first message of a thread or a message with no threaded replies.
   *
   * If the space doesn't support reply in threads, this field is always
   * `false`.
   * </pre>
   *
   * <code>bool thread_reply = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The threadReply.
   */
  boolean getThreadReply();

  /**
   *
   *
   * <pre>
   * Optional. A custom ID for the message. You can use field to identify a
   * message, or to get, delete, or update a message. To set a custom ID,
   * specify the
   * [`messageId`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages/create#body.QUERY_PARAMETERS.message_id)
   * field when you create the message. For details, see [Name a
   * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
   * </pre>
   *
   * <code>string client_assigned_message_id = 32 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The clientAssignedMessageId.
   */
  java.lang.String getClientAssignedMessageId();

  /**
   *
   *
   * <pre>
   * Optional. A custom ID for the message. You can use field to identify a
   * message, or to get, delete, or update a message. To set a custom ID,
   * specify the
   * [`messageId`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages/create#body.QUERY_PARAMETERS.message_id)
   * field when you create the message. For details, see [Name a
   * message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
   * </pre>
   *
   * <code>string client_assigned_message_id = 32 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for clientAssignedMessageId.
   */
  com.google.protobuf.ByteString getClientAssignedMessageIdBytes();

  /**
   *
   *
   * <pre>
   * Output only. The list of emoji reaction summaries on the message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.chat.v1.EmojiReactionSummary> getEmojiReactionSummariesList();

  /**
   *
   *
   * <pre>
   * Output only. The list of emoji reaction summaries on the message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.chat.v1.EmojiReactionSummary getEmojiReactionSummaries(int index);

  /**
   *
   *
   * <pre>
   * Output only. The list of emoji reaction summaries on the message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getEmojiReactionSummariesCount();

  /**
   *
   *
   * <pre>
   * Output only. The list of emoji reaction summaries on the message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.chat.v1.EmojiReactionSummaryOrBuilder>
      getEmojiReactionSummariesOrBuilderList();

  /**
   *
   *
   * <pre>
   * Output only. The list of emoji reaction summaries on the message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.EmojiReactionSummary emoji_reaction_summaries = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.chat.v1.EmojiReactionSummaryOrBuilder getEmojiReactionSummariesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Optional. Immutable. Input for creating a message, otherwise output only.
   * The user that can view the message. When set, the message is private and
   * only visible to the specified user and the Chat app. To include this field
   * in your request, you must call the Chat API using [app
   * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
   * and omit the following:
   *
   * * [Attachments](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.attachments)
   * * [Accessory
   * widgets](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#Message.AccessoryWidget)
   *
   * For details, see [Send a message
   * privately](https://developers.google.com/workspace/chat/create-messages#private).
   * </pre>
   *
   * <code>
   * .google.chat.v1.User private_message_viewer = 36 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the privateMessageViewer field is set.
   */
  boolean hasPrivateMessageViewer();

  /**
   *
   *
   * <pre>
   * Optional. Immutable. Input for creating a message, otherwise output only.
   * The user that can view the message. When set, the message is private and
   * only visible to the specified user and the Chat app. To include this field
   * in your request, you must call the Chat API using [app
   * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
   * and omit the following:
   *
   * * [Attachments](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.attachments)
   * * [Accessory
   * widgets](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#Message.AccessoryWidget)
   *
   * For details, see [Send a message
   * privately](https://developers.google.com/workspace/chat/create-messages#private).
   * </pre>
   *
   * <code>
   * .google.chat.v1.User private_message_viewer = 36 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The privateMessageViewer.
   */
  com.google.chat.v1.User getPrivateMessageViewer();

  /**
   *
   *
   * <pre>
   * Optional. Immutable. Input for creating a message, otherwise output only.
   * The user that can view the message. When set, the message is private and
   * only visible to the specified user and the Chat app. To include this field
   * in your request, you must call the Chat API using [app
   * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
   * and omit the following:
   *
   * * [Attachments](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.attachments)
   * * [Accessory
   * widgets](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#Message.AccessoryWidget)
   *
   * For details, see [Send a message
   * privately](https://developers.google.com/workspace/chat/create-messages#private).
   * </pre>
   *
   * <code>
   * .google.chat.v1.User private_message_viewer = 36 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.chat.v1.UserOrBuilder getPrivateMessageViewerOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Information about a deleted message. A message is deleted when
   * `delete_time` is set.
   * </pre>
   *
   * <code>
   * .google.chat.v1.DeletionMetadata deletion_metadata = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deletionMetadata field is set.
   */
  boolean hasDeletionMetadata();

  /**
   *
   *
   * <pre>
   * Output only. Information about a deleted message. A message is deleted when
   * `delete_time` is set.
   * </pre>
   *
   * <code>
   * .google.chat.v1.DeletionMetadata deletion_metadata = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deletionMetadata.
   */
  com.google.chat.v1.DeletionMetadata getDeletionMetadata();

  /**
   *
   *
   * <pre>
   * Output only. Information about a deleted message. A message is deleted when
   * `delete_time` is set.
   * </pre>
   *
   * <code>
   * .google.chat.v1.DeletionMetadata deletion_metadata = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.chat.v1.DeletionMetadataOrBuilder getDeletionMetadataOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Information about a message that's quoted by a Google Chat
   * user in a space. Google Chat users can quote a message to reply to it.
   * </pre>
   *
   * <code>
   * .google.chat.v1.QuotedMessageMetadata quoted_message_metadata = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the quotedMessageMetadata field is set.
   */
  boolean hasQuotedMessageMetadata();

  /**
   *
   *
   * <pre>
   * Output only. Information about a message that's quoted by a Google Chat
   * user in a space. Google Chat users can quote a message to reply to it.
   * </pre>
   *
   * <code>
   * .google.chat.v1.QuotedMessageMetadata quoted_message_metadata = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The quotedMessageMetadata.
   */
  com.google.chat.v1.QuotedMessageMetadata getQuotedMessageMetadata();

  /**
   *
   *
   * <pre>
   * Output only. Information about a message that's quoted by a Google Chat
   * user in a space. Google Chat users can quote a message to reply to it.
   * </pre>
   *
   * <code>
   * .google.chat.v1.QuotedMessageMetadata quoted_message_metadata = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.chat.v1.QuotedMessageMetadataOrBuilder getQuotedMessageMetadataOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. GIF images that are attached to the message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.chat.v1.AttachedGif> getAttachedGifsList();

  /**
   *
   *
   * <pre>
   * Output only. GIF images that are attached to the message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.chat.v1.AttachedGif getAttachedGifs(int index);

  /**
   *
   *
   * <pre>
   * Output only. GIF images that are attached to the message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getAttachedGifsCount();

  /**
   *
   *
   * <pre>
   * Output only. GIF images that are attached to the message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.chat.v1.AttachedGifOrBuilder> getAttachedGifsOrBuilderList();

  /**
   *
   *
   * <pre>
   * Output only. GIF images that are attached to the message.
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.AttachedGif attached_gifs = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.chat.v1.AttachedGifOrBuilder getAttachedGifsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Optional. One or more interactive widgets that appear at the bottom of a
   * message. You can add accessory widgets to messages that contain text,
   * cards, or both text and cards. Not supported for messages that contain
   * dialogs. For details, see [Add interactive widgets at the bottom of a
   * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
   *
   * Creating a message with accessory widgets requires [app
   * authentication]
   * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.chat.v1.AccessoryWidget> getAccessoryWidgetsList();

  /**
   *
   *
   * <pre>
   * Optional. One or more interactive widgets that appear at the bottom of a
   * message. You can add accessory widgets to messages that contain text,
   * cards, or both text and cards. Not supported for messages that contain
   * dialogs. For details, see [Add interactive widgets at the bottom of a
   * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
   *
   * Creating a message with accessory widgets requires [app
   * authentication]
   * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.chat.v1.AccessoryWidget getAccessoryWidgets(int index);

  /**
   *
   *
   * <pre>
   * Optional. One or more interactive widgets that appear at the bottom of a
   * message. You can add accessory widgets to messages that contain text,
   * cards, or both text and cards. Not supported for messages that contain
   * dialogs. For details, see [Add interactive widgets at the bottom of a
   * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
   *
   * Creating a message with accessory widgets requires [app
   * authentication]
   * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getAccessoryWidgetsCount();

  /**
   *
   *
   * <pre>
   * Optional. One or more interactive widgets that appear at the bottom of a
   * message. You can add accessory widgets to messages that contain text,
   * cards, or both text and cards. Not supported for messages that contain
   * dialogs. For details, see [Add interactive widgets at the bottom of a
   * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
   *
   * Creating a message with accessory widgets requires [app
   * authentication]
   * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.chat.v1.AccessoryWidgetOrBuilder>
      getAccessoryWidgetsOrBuilderList();

  /**
   *
   *
   * <pre>
   * Optional. One or more interactive widgets that appear at the bottom of a
   * message. You can add accessory widgets to messages that contain text,
   * cards, or both text and cards. Not supported for messages that contain
   * dialogs. For details, see [Add interactive widgets at the bottom of a
   * message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
   *
   * Creating a message with accessory widgets requires [app
   * authentication]
   * (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.AccessoryWidget accessory_widgets = 44 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.chat.v1.AccessoryWidgetOrBuilder getAccessoryWidgetsOrBuilder(int index);
}
