/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/annotation.proto

// Protobuf Java Version: 3.25.5
package com.google.chat.v1;

/**
 *
 *
 * <pre>
 * A rich link to a resource.
 * </pre>
 *
 * Protobuf type {@code google.chat.v1.RichLinkMetadata}
 */
public final class RichLinkMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.RichLinkMetadata)
    RichLinkMetadataOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RichLinkMetadata.newBuilder() to construct.
  private RichLinkMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RichLinkMetadata() {
    uri_ = "";
    richLinkType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RichLinkMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.AnnotationProto
        .internal_static_google_chat_v1_RichLinkMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.AnnotationProto
        .internal_static_google_chat_v1_RichLinkMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.RichLinkMetadata.class,
            com.google.chat.v1.RichLinkMetadata.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The rich link type. More types might be added in the future.
   * </pre>
   *
   * Protobuf enum {@code google.chat.v1.RichLinkMetadata.RichLinkType}
   */
  public enum RichLinkType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value for the enum. Don't use.
     * </pre>
     *
     * <code>RICH_LINK_TYPE_UNSPECIFIED = 0;</code>
     */
    RICH_LINK_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * A Google Drive rich link type.
     * </pre>
     *
     * <code>DRIVE_FILE = 1;</code>
     */
    DRIVE_FILE(1),
    /**
     *
     *
     * <pre>
     * A Chat space rich link type. For example, a space smart chip.
     * </pre>
     *
     * <code>CHAT_SPACE = 2;</code>
     */
    CHAT_SPACE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value for the enum. Don't use.
     * </pre>
     *
     * <code>RICH_LINK_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int RICH_LINK_TYPE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * A Google Drive rich link type.
     * </pre>
     *
     * <code>DRIVE_FILE = 1;</code>
     */
    public static final int DRIVE_FILE_VALUE = 1;

    /**
     *
     *
     * <pre>
     * A Chat space rich link type. For example, a space smart chip.
     * </pre>
     *
     * <code>CHAT_SPACE = 2;</code>
     */
    public static final int CHAT_SPACE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RichLinkType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RichLinkType forNumber(int value) {
      switch (value) {
        case 0:
          return RICH_LINK_TYPE_UNSPECIFIED;
        case 1:
          return DRIVE_FILE;
        case 2:
          return CHAT_SPACE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RichLinkType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RichLinkType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RichLinkType>() {
          public RichLinkType findValueByNumber(int number) {
            return RichLinkType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.chat.v1.RichLinkMetadata.getDescriptor().getEnumTypes().get(0);
    }

    private static final RichLinkType[] VALUES = values();

    public static RichLinkType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RichLinkType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.chat.v1.RichLinkMetadata.RichLinkType)
  }

  private int dataCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object data_;

  public enum DataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DRIVE_LINK_DATA(3),
    CHAT_SPACE_LINK_DATA(4),
    DATA_NOT_SET(0);
    private final int value;

    private DataCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataCase valueOf(int value) {
      return forNumber(value);
    }

    public static DataCase forNumber(int value) {
      switch (value) {
        case 3:
          return DRIVE_LINK_DATA;
        case 4:
          return CHAT_SPACE_LINK_DATA;
        case 0:
          return DATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DataCase getDataCase() {
    return DataCase.forNumber(dataCase_);
  }

  public static final int URI_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uri_ = "";

  /**
   *
   *
   * <pre>
   * The URI of this link.
   * </pre>
   *
   * <code>string uri = 1;</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The URI of this link.
   * </pre>
   *
   * <code>string uri = 1;</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RICH_LINK_TYPE_FIELD_NUMBER = 2;
  private int richLinkType_ = 0;

  /**
   *
   *
   * <pre>
   * The rich link type.
   * </pre>
   *
   * <code>.google.chat.v1.RichLinkMetadata.RichLinkType rich_link_type = 2;</code>
   *
   * @return The enum numeric value on the wire for richLinkType.
   */
  @java.lang.Override
  public int getRichLinkTypeValue() {
    return richLinkType_;
  }

  /**
   *
   *
   * <pre>
   * The rich link type.
   * </pre>
   *
   * <code>.google.chat.v1.RichLinkMetadata.RichLinkType rich_link_type = 2;</code>
   *
   * @return The richLinkType.
   */
  @java.lang.Override
  public com.google.chat.v1.RichLinkMetadata.RichLinkType getRichLinkType() {
    com.google.chat.v1.RichLinkMetadata.RichLinkType result =
        com.google.chat.v1.RichLinkMetadata.RichLinkType.forNumber(richLinkType_);
    return result == null ? com.google.chat.v1.RichLinkMetadata.RichLinkType.UNRECOGNIZED : result;
  }

  public static final int DRIVE_LINK_DATA_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Data for a drive link.
   * </pre>
   *
   * <code>.google.chat.v1.DriveLinkData drive_link_data = 3;</code>
   *
   * @return Whether the driveLinkData field is set.
   */
  @java.lang.Override
  public boolean hasDriveLinkData() {
    return dataCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Data for a drive link.
   * </pre>
   *
   * <code>.google.chat.v1.DriveLinkData drive_link_data = 3;</code>
   *
   * @return The driveLinkData.
   */
  @java.lang.Override
  public com.google.chat.v1.DriveLinkData getDriveLinkData() {
    if (dataCase_ == 3) {
      return (com.google.chat.v1.DriveLinkData) data_;
    }
    return com.google.chat.v1.DriveLinkData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Data for a drive link.
   * </pre>
   *
   * <code>.google.chat.v1.DriveLinkData drive_link_data = 3;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.DriveLinkDataOrBuilder getDriveLinkDataOrBuilder() {
    if (dataCase_ == 3) {
      return (com.google.chat.v1.DriveLinkData) data_;
    }
    return com.google.chat.v1.DriveLinkData.getDefaultInstance();
  }

  public static final int CHAT_SPACE_LINK_DATA_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * Data for a chat space link.
   * </pre>
   *
   * <code>.google.chat.v1.ChatSpaceLinkData chat_space_link_data = 4;</code>
   *
   * @return Whether the chatSpaceLinkData field is set.
   */
  @java.lang.Override
  public boolean hasChatSpaceLinkData() {
    return dataCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * Data for a chat space link.
   * </pre>
   *
   * <code>.google.chat.v1.ChatSpaceLinkData chat_space_link_data = 4;</code>
   *
   * @return The chatSpaceLinkData.
   */
  @java.lang.Override
  public com.google.chat.v1.ChatSpaceLinkData getChatSpaceLinkData() {
    if (dataCase_ == 4) {
      return (com.google.chat.v1.ChatSpaceLinkData) data_;
    }
    return com.google.chat.v1.ChatSpaceLinkData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Data for a chat space link.
   * </pre>
   *
   * <code>.google.chat.v1.ChatSpaceLinkData chat_space_link_data = 4;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.ChatSpaceLinkDataOrBuilder getChatSpaceLinkDataOrBuilder() {
    if (dataCase_ == 4) {
      return (com.google.chat.v1.ChatSpaceLinkData) data_;
    }
    return com.google.chat.v1.ChatSpaceLinkData.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uri_);
    }
    if (richLinkType_
        != com.google.chat.v1.RichLinkMetadata.RichLinkType.RICH_LINK_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, richLinkType_);
    }
    if (dataCase_ == 3) {
      output.writeMessage(3, (com.google.chat.v1.DriveLinkData) data_);
    }
    if (dataCase_ == 4) {
      output.writeMessage(4, (com.google.chat.v1.ChatSpaceLinkData) data_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uri_);
    }
    if (richLinkType_
        != com.google.chat.v1.RichLinkMetadata.RichLinkType.RICH_LINK_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, richLinkType_);
    }
    if (dataCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.chat.v1.DriveLinkData) data_);
    }
    if (dataCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.chat.v1.ChatSpaceLinkData) data_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.RichLinkMetadata)) {
      return super.equals(obj);
    }
    com.google.chat.v1.RichLinkMetadata other = (com.google.chat.v1.RichLinkMetadata) obj;

    if (!getUri().equals(other.getUri())) return false;
    if (richLinkType_ != other.richLinkType_) return false;
    if (!getDataCase().equals(other.getDataCase())) return false;
    switch (dataCase_) {
      case 3:
        if (!getDriveLinkData().equals(other.getDriveLinkData())) return false;
        break;
      case 4:
        if (!getChatSpaceLinkData().equals(other.getChatSpaceLinkData())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + URI_FIELD_NUMBER;
    hash = (53 * hash) + getUri().hashCode();
    hash = (37 * hash) + RICH_LINK_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + richLinkType_;
    switch (dataCase_) {
      case 3:
        hash = (37 * hash) + DRIVE_LINK_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getDriveLinkData().hashCode();
        break;
      case 4:
        hash = (37 * hash) + CHAT_SPACE_LINK_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getChatSpaceLinkData().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.RichLinkMetadata parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.RichLinkMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.RichLinkMetadata parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.RichLinkMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.RichLinkMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.RichLinkMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.RichLinkMetadata parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.RichLinkMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.RichLinkMetadata parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.RichLinkMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.RichLinkMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.RichLinkMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.RichLinkMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A rich link to a resource.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.RichLinkMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.RichLinkMetadata)
      com.google.chat.v1.RichLinkMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.AnnotationProto
          .internal_static_google_chat_v1_RichLinkMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.AnnotationProto
          .internal_static_google_chat_v1_RichLinkMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.RichLinkMetadata.class,
              com.google.chat.v1.RichLinkMetadata.Builder.class);
    }

    // Construct using com.google.chat.v1.RichLinkMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      uri_ = "";
      richLinkType_ = 0;
      if (driveLinkDataBuilder_ != null) {
        driveLinkDataBuilder_.clear();
      }
      if (chatSpaceLinkDataBuilder_ != null) {
        chatSpaceLinkDataBuilder_.clear();
      }
      dataCase_ = 0;
      data_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.AnnotationProto
          .internal_static_google_chat_v1_RichLinkMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.RichLinkMetadata getDefaultInstanceForType() {
      return com.google.chat.v1.RichLinkMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.RichLinkMetadata build() {
      com.google.chat.v1.RichLinkMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.RichLinkMetadata buildPartial() {
      com.google.chat.v1.RichLinkMetadata result = new com.google.chat.v1.RichLinkMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.chat.v1.RichLinkMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.uri_ = uri_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.richLinkType_ = richLinkType_;
      }
    }

    private void buildPartialOneofs(com.google.chat.v1.RichLinkMetadata result) {
      result.dataCase_ = dataCase_;
      result.data_ = this.data_;
      if (dataCase_ == 3 && driveLinkDataBuilder_ != null) {
        result.data_ = driveLinkDataBuilder_.build();
      }
      if (dataCase_ == 4 && chatSpaceLinkDataBuilder_ != null) {
        result.data_ = chatSpaceLinkDataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.RichLinkMetadata) {
        return mergeFrom((com.google.chat.v1.RichLinkMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.RichLinkMetadata other) {
      if (other == com.google.chat.v1.RichLinkMetadata.getDefaultInstance()) return this;
      if (!other.getUri().isEmpty()) {
        uri_ = other.uri_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.richLinkType_ != 0) {
        setRichLinkTypeValue(other.getRichLinkTypeValue());
      }
      switch (other.getDataCase()) {
        case DRIVE_LINK_DATA:
          {
            mergeDriveLinkData(other.getDriveLinkData());
            break;
          }
        case CHAT_SPACE_LINK_DATA:
          {
            mergeChatSpaceLinkData(other.getChatSpaceLinkData());
            break;
          }
        case DATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                uri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                richLinkType_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getDriveLinkDataFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getChatSpaceLinkDataFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int dataCase_ = 0;
    private java.lang.Object data_;

    public DataCase getDataCase() {
      return DataCase.forNumber(dataCase_);
    }

    public Builder clearData() {
      dataCase_ = 0;
      data_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object uri_ = "";

    /**
     *
     *
     * <pre>
     * The URI of this link.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The URI of this link.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The URI of this link.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The URI of this link.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {
      uri_ = getDefaultInstance().getUri();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The URI of this link.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int richLinkType_ = 0;

    /**
     *
     *
     * <pre>
     * The rich link type.
     * </pre>
     *
     * <code>.google.chat.v1.RichLinkMetadata.RichLinkType rich_link_type = 2;</code>
     *
     * @return The enum numeric value on the wire for richLinkType.
     */
    @java.lang.Override
    public int getRichLinkTypeValue() {
      return richLinkType_;
    }

    /**
     *
     *
     * <pre>
     * The rich link type.
     * </pre>
     *
     * <code>.google.chat.v1.RichLinkMetadata.RichLinkType rich_link_type = 2;</code>
     *
     * @param value The enum numeric value on the wire for richLinkType to set.
     * @return This builder for chaining.
     */
    public Builder setRichLinkTypeValue(int value) {
      richLinkType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The rich link type.
     * </pre>
     *
     * <code>.google.chat.v1.RichLinkMetadata.RichLinkType rich_link_type = 2;</code>
     *
     * @return The richLinkType.
     */
    @java.lang.Override
    public com.google.chat.v1.RichLinkMetadata.RichLinkType getRichLinkType() {
      com.google.chat.v1.RichLinkMetadata.RichLinkType result =
          com.google.chat.v1.RichLinkMetadata.RichLinkType.forNumber(richLinkType_);
      return result == null
          ? com.google.chat.v1.RichLinkMetadata.RichLinkType.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * The rich link type.
     * </pre>
     *
     * <code>.google.chat.v1.RichLinkMetadata.RichLinkType rich_link_type = 2;</code>
     *
     * @param value The richLinkType to set.
     * @return This builder for chaining.
     */
    public Builder setRichLinkType(com.google.chat.v1.RichLinkMetadata.RichLinkType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      richLinkType_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The rich link type.
     * </pre>
     *
     * <code>.google.chat.v1.RichLinkMetadata.RichLinkType rich_link_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRichLinkType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      richLinkType_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.DriveLinkData,
            com.google.chat.v1.DriveLinkData.Builder,
            com.google.chat.v1.DriveLinkDataOrBuilder>
        driveLinkDataBuilder_;

    /**
     *
     *
     * <pre>
     * Data for a drive link.
     * </pre>
     *
     * <code>.google.chat.v1.DriveLinkData drive_link_data = 3;</code>
     *
     * @return Whether the driveLinkData field is set.
     */
    @java.lang.Override
    public boolean hasDriveLinkData() {
      return dataCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Data for a drive link.
     * </pre>
     *
     * <code>.google.chat.v1.DriveLinkData drive_link_data = 3;</code>
     *
     * @return The driveLinkData.
     */
    @java.lang.Override
    public com.google.chat.v1.DriveLinkData getDriveLinkData() {
      if (driveLinkDataBuilder_ == null) {
        if (dataCase_ == 3) {
          return (com.google.chat.v1.DriveLinkData) data_;
        }
        return com.google.chat.v1.DriveLinkData.getDefaultInstance();
      } else {
        if (dataCase_ == 3) {
          return driveLinkDataBuilder_.getMessage();
        }
        return com.google.chat.v1.DriveLinkData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Data for a drive link.
     * </pre>
     *
     * <code>.google.chat.v1.DriveLinkData drive_link_data = 3;</code>
     */
    public Builder setDriveLinkData(com.google.chat.v1.DriveLinkData value) {
      if (driveLinkDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        driveLinkDataBuilder_.setMessage(value);
      }
      dataCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Data for a drive link.
     * </pre>
     *
     * <code>.google.chat.v1.DriveLinkData drive_link_data = 3;</code>
     */
    public Builder setDriveLinkData(com.google.chat.v1.DriveLinkData.Builder builderForValue) {
      if (driveLinkDataBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        driveLinkDataBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Data for a drive link.
     * </pre>
     *
     * <code>.google.chat.v1.DriveLinkData drive_link_data = 3;</code>
     */
    public Builder mergeDriveLinkData(com.google.chat.v1.DriveLinkData value) {
      if (driveLinkDataBuilder_ == null) {
        if (dataCase_ == 3 && data_ != com.google.chat.v1.DriveLinkData.getDefaultInstance()) {
          data_ =
              com.google.chat.v1.DriveLinkData.newBuilder((com.google.chat.v1.DriveLinkData) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 3) {
          driveLinkDataBuilder_.mergeFrom(value);
        } else {
          driveLinkDataBuilder_.setMessage(value);
        }
      }
      dataCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Data for a drive link.
     * </pre>
     *
     * <code>.google.chat.v1.DriveLinkData drive_link_data = 3;</code>
     */
    public Builder clearDriveLinkData() {
      if (driveLinkDataBuilder_ == null) {
        if (dataCase_ == 3) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 3) {
          dataCase_ = 0;
          data_ = null;
        }
        driveLinkDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Data for a drive link.
     * </pre>
     *
     * <code>.google.chat.v1.DriveLinkData drive_link_data = 3;</code>
     */
    public com.google.chat.v1.DriveLinkData.Builder getDriveLinkDataBuilder() {
      return getDriveLinkDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Data for a drive link.
     * </pre>
     *
     * <code>.google.chat.v1.DriveLinkData drive_link_data = 3;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.DriveLinkDataOrBuilder getDriveLinkDataOrBuilder() {
      if ((dataCase_ == 3) && (driveLinkDataBuilder_ != null)) {
        return driveLinkDataBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 3) {
          return (com.google.chat.v1.DriveLinkData) data_;
        }
        return com.google.chat.v1.DriveLinkData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Data for a drive link.
     * </pre>
     *
     * <code>.google.chat.v1.DriveLinkData drive_link_data = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.DriveLinkData,
            com.google.chat.v1.DriveLinkData.Builder,
            com.google.chat.v1.DriveLinkDataOrBuilder>
        getDriveLinkDataFieldBuilder() {
      if (driveLinkDataBuilder_ == null) {
        if (!(dataCase_ == 3)) {
          data_ = com.google.chat.v1.DriveLinkData.getDefaultInstance();
        }
        driveLinkDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.DriveLinkData,
                com.google.chat.v1.DriveLinkData.Builder,
                com.google.chat.v1.DriveLinkDataOrBuilder>(
                (com.google.chat.v1.DriveLinkData) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 3;
      onChanged();
      return driveLinkDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.ChatSpaceLinkData,
            com.google.chat.v1.ChatSpaceLinkData.Builder,
            com.google.chat.v1.ChatSpaceLinkDataOrBuilder>
        chatSpaceLinkDataBuilder_;

    /**
     *
     *
     * <pre>
     * Data for a chat space link.
     * </pre>
     *
     * <code>.google.chat.v1.ChatSpaceLinkData chat_space_link_data = 4;</code>
     *
     * @return Whether the chatSpaceLinkData field is set.
     */
    @java.lang.Override
    public boolean hasChatSpaceLinkData() {
      return dataCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Data for a chat space link.
     * </pre>
     *
     * <code>.google.chat.v1.ChatSpaceLinkData chat_space_link_data = 4;</code>
     *
     * @return The chatSpaceLinkData.
     */
    @java.lang.Override
    public com.google.chat.v1.ChatSpaceLinkData getChatSpaceLinkData() {
      if (chatSpaceLinkDataBuilder_ == null) {
        if (dataCase_ == 4) {
          return (com.google.chat.v1.ChatSpaceLinkData) data_;
        }
        return com.google.chat.v1.ChatSpaceLinkData.getDefaultInstance();
      } else {
        if (dataCase_ == 4) {
          return chatSpaceLinkDataBuilder_.getMessage();
        }
        return com.google.chat.v1.ChatSpaceLinkData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Data for a chat space link.
     * </pre>
     *
     * <code>.google.chat.v1.ChatSpaceLinkData chat_space_link_data = 4;</code>
     */
    public Builder setChatSpaceLinkData(com.google.chat.v1.ChatSpaceLinkData value) {
      if (chatSpaceLinkDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        chatSpaceLinkDataBuilder_.setMessage(value);
      }
      dataCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Data for a chat space link.
     * </pre>
     *
     * <code>.google.chat.v1.ChatSpaceLinkData chat_space_link_data = 4;</code>
     */
    public Builder setChatSpaceLinkData(
        com.google.chat.v1.ChatSpaceLinkData.Builder builderForValue) {
      if (chatSpaceLinkDataBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        chatSpaceLinkDataBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Data for a chat space link.
     * </pre>
     *
     * <code>.google.chat.v1.ChatSpaceLinkData chat_space_link_data = 4;</code>
     */
    public Builder mergeChatSpaceLinkData(com.google.chat.v1.ChatSpaceLinkData value) {
      if (chatSpaceLinkDataBuilder_ == null) {
        if (dataCase_ == 4 && data_ != com.google.chat.v1.ChatSpaceLinkData.getDefaultInstance()) {
          data_ =
              com.google.chat.v1.ChatSpaceLinkData.newBuilder(
                      (com.google.chat.v1.ChatSpaceLinkData) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 4) {
          chatSpaceLinkDataBuilder_.mergeFrom(value);
        } else {
          chatSpaceLinkDataBuilder_.setMessage(value);
        }
      }
      dataCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Data for a chat space link.
     * </pre>
     *
     * <code>.google.chat.v1.ChatSpaceLinkData chat_space_link_data = 4;</code>
     */
    public Builder clearChatSpaceLinkData() {
      if (chatSpaceLinkDataBuilder_ == null) {
        if (dataCase_ == 4) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 4) {
          dataCase_ = 0;
          data_ = null;
        }
        chatSpaceLinkDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Data for a chat space link.
     * </pre>
     *
     * <code>.google.chat.v1.ChatSpaceLinkData chat_space_link_data = 4;</code>
     */
    public com.google.chat.v1.ChatSpaceLinkData.Builder getChatSpaceLinkDataBuilder() {
      return getChatSpaceLinkDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Data for a chat space link.
     * </pre>
     *
     * <code>.google.chat.v1.ChatSpaceLinkData chat_space_link_data = 4;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.ChatSpaceLinkDataOrBuilder getChatSpaceLinkDataOrBuilder() {
      if ((dataCase_ == 4) && (chatSpaceLinkDataBuilder_ != null)) {
        return chatSpaceLinkDataBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 4) {
          return (com.google.chat.v1.ChatSpaceLinkData) data_;
        }
        return com.google.chat.v1.ChatSpaceLinkData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Data for a chat space link.
     * </pre>
     *
     * <code>.google.chat.v1.ChatSpaceLinkData chat_space_link_data = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.ChatSpaceLinkData,
            com.google.chat.v1.ChatSpaceLinkData.Builder,
            com.google.chat.v1.ChatSpaceLinkDataOrBuilder>
        getChatSpaceLinkDataFieldBuilder() {
      if (chatSpaceLinkDataBuilder_ == null) {
        if (!(dataCase_ == 4)) {
          data_ = com.google.chat.v1.ChatSpaceLinkData.getDefaultInstance();
        }
        chatSpaceLinkDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.ChatSpaceLinkData,
                com.google.chat.v1.ChatSpaceLinkData.Builder,
                com.google.chat.v1.ChatSpaceLinkDataOrBuilder>(
                (com.google.chat.v1.ChatSpaceLinkData) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 4;
      onChanged();
      return chatSpaceLinkDataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.RichLinkMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.RichLinkMetadata)
  private static final com.google.chat.v1.RichLinkMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.RichLinkMetadata();
  }

  public static com.google.chat.v1.RichLinkMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RichLinkMetadata> PARSER =
      new com.google.protobuf.AbstractParser<RichLinkMetadata>() {
        @java.lang.Override
        public RichLinkMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RichLinkMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RichLinkMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.RichLinkMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
