/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/space.proto

// Protobuf Java Version: 3.25.5
package com.google.chat.v1;

/**
 *
 *
 * <pre>
 * Request to search for a list of spaces based on a query.
 * </pre>
 *
 * Protobuf type {@code google.chat.v1.SearchSpacesRequest}
 */
public final class SearchSpacesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.SearchSpacesRequest)
    SearchSpacesRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SearchSpacesRequest.newBuilder() to construct.
  private SearchSpacesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchSpacesRequest() {
    pageToken_ = "";
    query_ = "";
    orderBy_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchSpacesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.SpaceProto
        .internal_static_google_chat_v1_SearchSpacesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.SpaceProto
        .internal_static_google_chat_v1_SearchSpacesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.SearchSpacesRequest.class,
            com.google.chat.v1.SearchSpacesRequest.Builder.class);
  }

  public static final int USE_ADMIN_ACCESS_FIELD_NUMBER = 1;
  private boolean useAdminAccess_ = false;

  /**
   *
   *
   * <pre>
   * When `true`, the method runs using the user's Google Workspace
   * administrator privileges.
   *
   * The calling user must be a Google Workspace administrator with the
   * [manage chat and spaces conversations
   * privilege](https://support.google.com/a/answer/13369245).
   *
   * Requires either the `chat.admin.spaces.readonly` or `chat.admin.spaces`
   * [OAuth 2.0
   * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
   *
   * This method currently only supports admin access, thus only `true` is
   * accepted for this field.
   * </pre>
   *
   * <code>bool use_admin_access = 1;</code>
   *
   * @return The useAdminAccess.
   */
  @java.lang.Override
  public boolean getUseAdminAccess() {
    return useAdminAccess_;
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 2;
  private int pageSize_ = 0;

  /**
   *
   *
   * <pre>
   * The maximum number of spaces to return. The service may return fewer than
   * this value.
   *
   * If unspecified, at most 100 spaces are returned.
   *
   * The maximum value is 1000. If you use a value more than 1000, it's
   * automatically changed to 1000.
   * </pre>
   *
   * <code>int32 page_size = 2;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";

  /**
   *
   *
   * <pre>
   * A token, received from the previous search spaces call. Provide this
   * parameter to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided should match the call that
   * provided the page token. Passing different values to the other parameters
   * might lead to unexpected results.
   * </pre>
   *
   * <code>string page_token = 3;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A token, received from the previous search spaces call. Provide this
   * parameter to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided should match the call that
   * provided the page token. Passing different values to the other parameters
   * might lead to unexpected results.
   * </pre>
   *
   * <code>string page_token = 3;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object query_ = "";

  /**
   *
   *
   * <pre>
   * Required. A search query.
   *
   * You can search by using the following parameters:
   *
   * - `create_time`
   * - `customer`
   * - `display_name`
   * - `external_user_allowed`
   * - `last_active_time`
   * - `space_history_state`
   * - `space_type`
   *
   * `create_time` and `last_active_time` accept a timestamp in
   * [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339) format and the supported
   * comparison operators are: `=`, `&lt;`, `&gt;`, `&lt;=`, `&gt;=`.
   *
   * `customer` is required and is used to indicate which customer
   * to fetch spaces from. `customers/my_customer` is the only supported value.
   *
   * `display_name` only accepts the `HAS` (`:`) operator. The text to
   * match is first tokenized into tokens and each token is prefix-matched
   * case-insensitively and independently as a substring anywhere in the space's
   * `display_name`. For example, `Fun Eve` matches `Fun event` or `The
   * evening was fun`, but not `notFun event` or `even`.
   *
   * `external_user_allowed` accepts either `true` or `false`.
   *
   * `space_history_state` only accepts values from the [`historyState`]
   * (https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces#Space.HistoryState)
   * field of a `space` resource.
   *
   * `space_type` is required and the only valid value is `SPACE`.
   *
   * Across different fields, only `AND` operators are supported. A valid
   * example is `space_type = "SPACE" AND display_name:"Hello"` and an invalid
   * example is `space_type = "SPACE" OR display_name:"Hello"`.
   *
   * Among the same field,
   * `space_type` doesn't support `AND` or `OR` operators.
   * `display_name`, 'space_history_state', and 'external_user_allowed' only
   * support `OR` operators.
   * `last_active_time` and `create_time` support both `AND` and `OR` operators.
   * `AND` can only be used to represent an interval, such as `last_active_time
   * &lt; "2022-01-01T00:00:00+00:00" AND last_active_time &gt;
   * "2023-01-01T00:00:00+00:00"`.
   *
   * The following example queries are valid:
   *
   * ```
   * customer = "customers/my_customer" AND space_type = "SPACE"
   *
   * customer = "customers/my_customer" AND space_type = "SPACE" AND
   * display_name:"Hello World"
   *
   * customer = "customers/my_customer" AND space_type = "SPACE" AND
   * (last_active_time &lt; "2020-01-01T00:00:00+00:00" OR last_active_time &gt;
   * "2022-01-01T00:00:00+00:00")
   *
   * customer = "customers/my_customer" AND space_type = "SPACE" AND
   * (display_name:"Hello World" OR display_name:"Fun event") AND
   * (last_active_time &gt; "2020-01-01T00:00:00+00:00" AND last_active_time &lt;
   * "2022-01-01T00:00:00+00:00")
   *
   * customer = "customers/my_customer" AND space_type = "SPACE" AND
   * (create_time &gt; "2019-01-01T00:00:00+00:00" AND create_time &lt;
   * "2020-01-01T00:00:00+00:00") AND (external_user_allowed = "true") AND
   * (space_history_state = "HISTORY_ON" OR space_history_state = "HISTORY_OFF")
   * ```
   * </pre>
   *
   * <code>string query = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The query.
   */
  @java.lang.Override
  public java.lang.String getQuery() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      query_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. A search query.
   *
   * You can search by using the following parameters:
   *
   * - `create_time`
   * - `customer`
   * - `display_name`
   * - `external_user_allowed`
   * - `last_active_time`
   * - `space_history_state`
   * - `space_type`
   *
   * `create_time` and `last_active_time` accept a timestamp in
   * [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339) format and the supported
   * comparison operators are: `=`, `&lt;`, `&gt;`, `&lt;=`, `&gt;=`.
   *
   * `customer` is required and is used to indicate which customer
   * to fetch spaces from. `customers/my_customer` is the only supported value.
   *
   * `display_name` only accepts the `HAS` (`:`) operator. The text to
   * match is first tokenized into tokens and each token is prefix-matched
   * case-insensitively and independently as a substring anywhere in the space's
   * `display_name`. For example, `Fun Eve` matches `Fun event` or `The
   * evening was fun`, but not `notFun event` or `even`.
   *
   * `external_user_allowed` accepts either `true` or `false`.
   *
   * `space_history_state` only accepts values from the [`historyState`]
   * (https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces#Space.HistoryState)
   * field of a `space` resource.
   *
   * `space_type` is required and the only valid value is `SPACE`.
   *
   * Across different fields, only `AND` operators are supported. A valid
   * example is `space_type = "SPACE" AND display_name:"Hello"` and an invalid
   * example is `space_type = "SPACE" OR display_name:"Hello"`.
   *
   * Among the same field,
   * `space_type` doesn't support `AND` or `OR` operators.
   * `display_name`, 'space_history_state', and 'external_user_allowed' only
   * support `OR` operators.
   * `last_active_time` and `create_time` support both `AND` and `OR` operators.
   * `AND` can only be used to represent an interval, such as `last_active_time
   * &lt; "2022-01-01T00:00:00+00:00" AND last_active_time &gt;
   * "2023-01-01T00:00:00+00:00"`.
   *
   * The following example queries are valid:
   *
   * ```
   * customer = "customers/my_customer" AND space_type = "SPACE"
   *
   * customer = "customers/my_customer" AND space_type = "SPACE" AND
   * display_name:"Hello World"
   *
   * customer = "customers/my_customer" AND space_type = "SPACE" AND
   * (last_active_time &lt; "2020-01-01T00:00:00+00:00" OR last_active_time &gt;
   * "2022-01-01T00:00:00+00:00")
   *
   * customer = "customers/my_customer" AND space_type = "SPACE" AND
   * (display_name:"Hello World" OR display_name:"Fun event") AND
   * (last_active_time &gt; "2020-01-01T00:00:00+00:00" AND last_active_time &lt;
   * "2022-01-01T00:00:00+00:00")
   *
   * customer = "customers/my_customer" AND space_type = "SPACE" AND
   * (create_time &gt; "2019-01-01T00:00:00+00:00" AND create_time &lt;
   * "2020-01-01T00:00:00+00:00") AND (external_user_allowed = "true") AND
   * (space_history_state = "HISTORY_ON" OR space_history_state = "HISTORY_OFF")
   * ```
   * </pre>
   *
   * <code>string query = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for query.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQueryBytes() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      query_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORDER_BY_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object orderBy_ = "";

  /**
   *
   *
   * <pre>
   * Optional. How the list of spaces is ordered.
   *
   * Supported attributes to order by are:
   *
   * - `membership_count.joined_direct_human_user_count` — Denotes the count of
   * human users that have directly joined a space.
   * - `last_active_time` — Denotes the time when last eligible item is added to
   * any topic of this space.
   * - `create_time` — Denotes the time of the space creation.
   *
   * Valid ordering operation values are:
   *
   * - `ASC` for ascending. Default value.
   *
   * - `DESC` for descending.
   *
   * The supported syntax are:
   *
   * - `membership_count.joined_direct_human_user_count DESC`
   * - `membership_count.joined_direct_human_user_count ASC`
   * - `last_active_time DESC`
   * - `last_active_time ASC`
   * - `create_time DESC`
   * - `create_time ASC`
   * </pre>
   *
   * <code>string order_by = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The orderBy.
   */
  @java.lang.Override
  public java.lang.String getOrderBy() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      orderBy_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. How the list of spaces is ordered.
   *
   * Supported attributes to order by are:
   *
   * - `membership_count.joined_direct_human_user_count` — Denotes the count of
   * human users that have directly joined a space.
   * - `last_active_time` — Denotes the time when last eligible item is added to
   * any topic of this space.
   * - `create_time` — Denotes the time of the space creation.
   *
   * Valid ordering operation values are:
   *
   * - `ASC` for ascending. Default value.
   *
   * - `DESC` for descending.
   *
   * The supported syntax are:
   *
   * - `membership_count.joined_direct_human_user_count DESC`
   * - `membership_count.joined_direct_human_user_count ASC`
   * - `last_active_time DESC`
   * - `last_active_time ASC`
   * - `create_time DESC`
   * - `create_time ASC`
   * </pre>
   *
   * <code>string order_by = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for orderBy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOrderByBytes() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      orderBy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (useAdminAccess_ != false) {
      output.writeBool(1, useAdminAccess_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(2, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, query_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, orderBy_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (useAdminAccess_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, useAdminAccess_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, query_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, orderBy_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.SearchSpacesRequest)) {
      return super.equals(obj);
    }
    com.google.chat.v1.SearchSpacesRequest other = (com.google.chat.v1.SearchSpacesRequest) obj;

    if (getUseAdminAccess() != other.getUseAdminAccess()) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!getQuery().equals(other.getQuery())) return false;
    if (!getOrderBy().equals(other.getOrderBy())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + USE_ADMIN_ACCESS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUseAdminAccess());
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (37 * hash) + QUERY_FIELD_NUMBER;
    hash = (53 * hash) + getQuery().hashCode();
    hash = (37 * hash) + ORDER_BY_FIELD_NUMBER;
    hash = (53 * hash) + getOrderBy().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.SearchSpacesRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.SearchSpacesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.SearchSpacesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.SearchSpacesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.SearchSpacesRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.SearchSpacesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.SearchSpacesRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.SearchSpacesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.SearchSpacesRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.SearchSpacesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.SearchSpacesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.SearchSpacesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.SearchSpacesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request to search for a list of spaces based on a query.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.SearchSpacesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.SearchSpacesRequest)
      com.google.chat.v1.SearchSpacesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_SearchSpacesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_SearchSpacesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.SearchSpacesRequest.class,
              com.google.chat.v1.SearchSpacesRequest.Builder.class);
    }

    // Construct using com.google.chat.v1.SearchSpacesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      useAdminAccess_ = false;
      pageSize_ = 0;
      pageToken_ = "";
      query_ = "";
      orderBy_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_SearchSpacesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.SearchSpacesRequest getDefaultInstanceForType() {
      return com.google.chat.v1.SearchSpacesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.SearchSpacesRequest build() {
      com.google.chat.v1.SearchSpacesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.SearchSpacesRequest buildPartial() {
      com.google.chat.v1.SearchSpacesRequest result =
          new com.google.chat.v1.SearchSpacesRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.chat.v1.SearchSpacesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.useAdminAccess_ = useAdminAccess_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pageToken_ = pageToken_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.query_ = query_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.orderBy_ = orderBy_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.SearchSpacesRequest) {
        return mergeFrom((com.google.chat.v1.SearchSpacesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.SearchSpacesRequest other) {
      if (other == com.google.chat.v1.SearchSpacesRequest.getDefaultInstance()) return this;
      if (other.getUseAdminAccess() != false) {
        setUseAdminAccess(other.getUseAdminAccess());
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getQuery().isEmpty()) {
        query_ = other.query_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getOrderBy().isEmpty()) {
        orderBy_ = other.orderBy_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                useAdminAccess_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                query_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                orderBy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean useAdminAccess_;

    /**
     *
     *
     * <pre>
     * When `true`, the method runs using the user's Google Workspace
     * administrator privileges.
     *
     * The calling user must be a Google Workspace administrator with the
     * [manage chat and spaces conversations
     * privilege](https://support.google.com/a/answer/13369245).
     *
     * Requires either the `chat.admin.spaces.readonly` or `chat.admin.spaces`
     * [OAuth 2.0
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
     *
     * This method currently only supports admin access, thus only `true` is
     * accepted for this field.
     * </pre>
     *
     * <code>bool use_admin_access = 1;</code>
     *
     * @return The useAdminAccess.
     */
    @java.lang.Override
    public boolean getUseAdminAccess() {
      return useAdminAccess_;
    }

    /**
     *
     *
     * <pre>
     * When `true`, the method runs using the user's Google Workspace
     * administrator privileges.
     *
     * The calling user must be a Google Workspace administrator with the
     * [manage chat and spaces conversations
     * privilege](https://support.google.com/a/answer/13369245).
     *
     * Requires either the `chat.admin.spaces.readonly` or `chat.admin.spaces`
     * [OAuth 2.0
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
     *
     * This method currently only supports admin access, thus only `true` is
     * accepted for this field.
     * </pre>
     *
     * <code>bool use_admin_access = 1;</code>
     *
     * @param value The useAdminAccess to set.
     * @return This builder for chaining.
     */
    public Builder setUseAdminAccess(boolean value) {

      useAdminAccess_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * When `true`, the method runs using the user's Google Workspace
     * administrator privileges.
     *
     * The calling user must be a Google Workspace administrator with the
     * [manage chat and spaces conversations
     * privilege](https://support.google.com/a/answer/13369245).
     *
     * Requires either the `chat.admin.spaces.readonly` or `chat.admin.spaces`
     * [OAuth 2.0
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
     *
     * This method currently only supports admin access, thus only `true` is
     * accepted for this field.
     * </pre>
     *
     * <code>bool use_admin_access = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUseAdminAccess() {
      bitField0_ = (bitField0_ & ~0x00000001);
      useAdminAccess_ = false;
      onChanged();
      return this;
    }

    private int pageSize_;

    /**
     *
     *
     * <pre>
     * The maximum number of spaces to return. The service may return fewer than
     * this value.
     *
     * If unspecified, at most 100 spaces are returned.
     *
     * The maximum value is 1000. If you use a value more than 1000, it's
     * automatically changed to 1000.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }

    /**
     *
     *
     * <pre>
     * The maximum number of spaces to return. The service may return fewer than
     * this value.
     *
     * If unspecified, at most 100 spaces are returned.
     *
     * The maximum value is 1000. If you use a value more than 1000, it's
     * automatically changed to 1000.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The maximum number of spaces to return. The service may return fewer than
     * this value.
     *
     * If unspecified, at most 100 spaces are returned.
     *
     * The maximum value is 1000. If you use a value more than 1000, it's
     * automatically changed to 1000.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000002);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";

    /**
     *
     *
     * <pre>
     * A token, received from the previous search spaces call. Provide this
     * parameter to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided should match the call that
     * provided the page token. Passing different values to the other parameters
     * might lead to unexpected results.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A token, received from the previous search spaces call. Provide this
     * parameter to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided should match the call that
     * provided the page token. Passing different values to the other parameters
     * might lead to unexpected results.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A token, received from the previous search spaces call. Provide this
     * parameter to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided should match the call that
     * provided the page token. Passing different values to the other parameters
     * might lead to unexpected results.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A token, received from the previous search spaces call. Provide this
     * parameter to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided should match the call that
     * provided the page token. Passing different values to the other parameters
     * might lead to unexpected results.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A token, received from the previous search spaces call. Provide this
     * parameter to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided should match the call that
     * provided the page token. Passing different values to the other parameters
     * might lead to unexpected results.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object query_ = "";

    /**
     *
     *
     * <pre>
     * Required. A search query.
     *
     * You can search by using the following parameters:
     *
     * - `create_time`
     * - `customer`
     * - `display_name`
     * - `external_user_allowed`
     * - `last_active_time`
     * - `space_history_state`
     * - `space_type`
     *
     * `create_time` and `last_active_time` accept a timestamp in
     * [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339) format and the supported
     * comparison operators are: `=`, `&lt;`, `&gt;`, `&lt;=`, `&gt;=`.
     *
     * `customer` is required and is used to indicate which customer
     * to fetch spaces from. `customers/my_customer` is the only supported value.
     *
     * `display_name` only accepts the `HAS` (`:`) operator. The text to
     * match is first tokenized into tokens and each token is prefix-matched
     * case-insensitively and independently as a substring anywhere in the space's
     * `display_name`. For example, `Fun Eve` matches `Fun event` or `The
     * evening was fun`, but not `notFun event` or `even`.
     *
     * `external_user_allowed` accepts either `true` or `false`.
     *
     * `space_history_state` only accepts values from the [`historyState`]
     * (https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces#Space.HistoryState)
     * field of a `space` resource.
     *
     * `space_type` is required and the only valid value is `SPACE`.
     *
     * Across different fields, only `AND` operators are supported. A valid
     * example is `space_type = "SPACE" AND display_name:"Hello"` and an invalid
     * example is `space_type = "SPACE" OR display_name:"Hello"`.
     *
     * Among the same field,
     * `space_type` doesn't support `AND` or `OR` operators.
     * `display_name`, 'space_history_state', and 'external_user_allowed' only
     * support `OR` operators.
     * `last_active_time` and `create_time` support both `AND` and `OR` operators.
     * `AND` can only be used to represent an interval, such as `last_active_time
     * &lt; "2022-01-01T00:00:00+00:00" AND last_active_time &gt;
     * "2023-01-01T00:00:00+00:00"`.
     *
     * The following example queries are valid:
     *
     * ```
     * customer = "customers/my_customer" AND space_type = "SPACE"
     *
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * display_name:"Hello World"
     *
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (last_active_time &lt; "2020-01-01T00:00:00+00:00" OR last_active_time &gt;
     * "2022-01-01T00:00:00+00:00")
     *
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (display_name:"Hello World" OR display_name:"Fun event") AND
     * (last_active_time &gt; "2020-01-01T00:00:00+00:00" AND last_active_time &lt;
     * "2022-01-01T00:00:00+00:00")
     *
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (create_time &gt; "2019-01-01T00:00:00+00:00" AND create_time &lt;
     * "2020-01-01T00:00:00+00:00") AND (external_user_allowed = "true") AND
     * (space_history_state = "HISTORY_ON" OR space_history_state = "HISTORY_OFF")
     * ```
     * </pre>
     *
     * <code>string query = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The query.
     */
    public java.lang.String getQuery() {
      java.lang.Object ref = query_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        query_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. A search query.
     *
     * You can search by using the following parameters:
     *
     * - `create_time`
     * - `customer`
     * - `display_name`
     * - `external_user_allowed`
     * - `last_active_time`
     * - `space_history_state`
     * - `space_type`
     *
     * `create_time` and `last_active_time` accept a timestamp in
     * [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339) format and the supported
     * comparison operators are: `=`, `&lt;`, `&gt;`, `&lt;=`, `&gt;=`.
     *
     * `customer` is required and is used to indicate which customer
     * to fetch spaces from. `customers/my_customer` is the only supported value.
     *
     * `display_name` only accepts the `HAS` (`:`) operator. The text to
     * match is first tokenized into tokens and each token is prefix-matched
     * case-insensitively and independently as a substring anywhere in the space's
     * `display_name`. For example, `Fun Eve` matches `Fun event` or `The
     * evening was fun`, but not `notFun event` or `even`.
     *
     * `external_user_allowed` accepts either `true` or `false`.
     *
     * `space_history_state` only accepts values from the [`historyState`]
     * (https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces#Space.HistoryState)
     * field of a `space` resource.
     *
     * `space_type` is required and the only valid value is `SPACE`.
     *
     * Across different fields, only `AND` operators are supported. A valid
     * example is `space_type = "SPACE" AND display_name:"Hello"` and an invalid
     * example is `space_type = "SPACE" OR display_name:"Hello"`.
     *
     * Among the same field,
     * `space_type` doesn't support `AND` or `OR` operators.
     * `display_name`, 'space_history_state', and 'external_user_allowed' only
     * support `OR` operators.
     * `last_active_time` and `create_time` support both `AND` and `OR` operators.
     * `AND` can only be used to represent an interval, such as `last_active_time
     * &lt; "2022-01-01T00:00:00+00:00" AND last_active_time &gt;
     * "2023-01-01T00:00:00+00:00"`.
     *
     * The following example queries are valid:
     *
     * ```
     * customer = "customers/my_customer" AND space_type = "SPACE"
     *
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * display_name:"Hello World"
     *
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (last_active_time &lt; "2020-01-01T00:00:00+00:00" OR last_active_time &gt;
     * "2022-01-01T00:00:00+00:00")
     *
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (display_name:"Hello World" OR display_name:"Fun event") AND
     * (last_active_time &gt; "2020-01-01T00:00:00+00:00" AND last_active_time &lt;
     * "2022-01-01T00:00:00+00:00")
     *
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (create_time &gt; "2019-01-01T00:00:00+00:00" AND create_time &lt;
     * "2020-01-01T00:00:00+00:00") AND (external_user_allowed = "true") AND
     * (space_history_state = "HISTORY_ON" OR space_history_state = "HISTORY_OFF")
     * ```
     * </pre>
     *
     * <code>string query = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for query.
     */
    public com.google.protobuf.ByteString getQueryBytes() {
      java.lang.Object ref = query_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        query_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. A search query.
     *
     * You can search by using the following parameters:
     *
     * - `create_time`
     * - `customer`
     * - `display_name`
     * - `external_user_allowed`
     * - `last_active_time`
     * - `space_history_state`
     * - `space_type`
     *
     * `create_time` and `last_active_time` accept a timestamp in
     * [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339) format and the supported
     * comparison operators are: `=`, `&lt;`, `&gt;`, `&lt;=`, `&gt;=`.
     *
     * `customer` is required and is used to indicate which customer
     * to fetch spaces from. `customers/my_customer` is the only supported value.
     *
     * `display_name` only accepts the `HAS` (`:`) operator. The text to
     * match is first tokenized into tokens and each token is prefix-matched
     * case-insensitively and independently as a substring anywhere in the space's
     * `display_name`. For example, `Fun Eve` matches `Fun event` or `The
     * evening was fun`, but not `notFun event` or `even`.
     *
     * `external_user_allowed` accepts either `true` or `false`.
     *
     * `space_history_state` only accepts values from the [`historyState`]
     * (https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces#Space.HistoryState)
     * field of a `space` resource.
     *
     * `space_type` is required and the only valid value is `SPACE`.
     *
     * Across different fields, only `AND` operators are supported. A valid
     * example is `space_type = "SPACE" AND display_name:"Hello"` and an invalid
     * example is `space_type = "SPACE" OR display_name:"Hello"`.
     *
     * Among the same field,
     * `space_type` doesn't support `AND` or `OR` operators.
     * `display_name`, 'space_history_state', and 'external_user_allowed' only
     * support `OR` operators.
     * `last_active_time` and `create_time` support both `AND` and `OR` operators.
     * `AND` can only be used to represent an interval, such as `last_active_time
     * &lt; "2022-01-01T00:00:00+00:00" AND last_active_time &gt;
     * "2023-01-01T00:00:00+00:00"`.
     *
     * The following example queries are valid:
     *
     * ```
     * customer = "customers/my_customer" AND space_type = "SPACE"
     *
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * display_name:"Hello World"
     *
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (last_active_time &lt; "2020-01-01T00:00:00+00:00" OR last_active_time &gt;
     * "2022-01-01T00:00:00+00:00")
     *
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (display_name:"Hello World" OR display_name:"Fun event") AND
     * (last_active_time &gt; "2020-01-01T00:00:00+00:00" AND last_active_time &lt;
     * "2022-01-01T00:00:00+00:00")
     *
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (create_time &gt; "2019-01-01T00:00:00+00:00" AND create_time &lt;
     * "2020-01-01T00:00:00+00:00") AND (external_user_allowed = "true") AND
     * (space_history_state = "HISTORY_ON" OR space_history_state = "HISTORY_OFF")
     * ```
     * </pre>
     *
     * <code>string query = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The query to set.
     * @return This builder for chaining.
     */
    public Builder setQuery(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      query_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A search query.
     *
     * You can search by using the following parameters:
     *
     * - `create_time`
     * - `customer`
     * - `display_name`
     * - `external_user_allowed`
     * - `last_active_time`
     * - `space_history_state`
     * - `space_type`
     *
     * `create_time` and `last_active_time` accept a timestamp in
     * [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339) format and the supported
     * comparison operators are: `=`, `&lt;`, `&gt;`, `&lt;=`, `&gt;=`.
     *
     * `customer` is required and is used to indicate which customer
     * to fetch spaces from. `customers/my_customer` is the only supported value.
     *
     * `display_name` only accepts the `HAS` (`:`) operator. The text to
     * match is first tokenized into tokens and each token is prefix-matched
     * case-insensitively and independently as a substring anywhere in the space's
     * `display_name`. For example, `Fun Eve` matches `Fun event` or `The
     * evening was fun`, but not `notFun event` or `even`.
     *
     * `external_user_allowed` accepts either `true` or `false`.
     *
     * `space_history_state` only accepts values from the [`historyState`]
     * (https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces#Space.HistoryState)
     * field of a `space` resource.
     *
     * `space_type` is required and the only valid value is `SPACE`.
     *
     * Across different fields, only `AND` operators are supported. A valid
     * example is `space_type = "SPACE" AND display_name:"Hello"` and an invalid
     * example is `space_type = "SPACE" OR display_name:"Hello"`.
     *
     * Among the same field,
     * `space_type` doesn't support `AND` or `OR` operators.
     * `display_name`, 'space_history_state', and 'external_user_allowed' only
     * support `OR` operators.
     * `last_active_time` and `create_time` support both `AND` and `OR` operators.
     * `AND` can only be used to represent an interval, such as `last_active_time
     * &lt; "2022-01-01T00:00:00+00:00" AND last_active_time &gt;
     * "2023-01-01T00:00:00+00:00"`.
     *
     * The following example queries are valid:
     *
     * ```
     * customer = "customers/my_customer" AND space_type = "SPACE"
     *
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * display_name:"Hello World"
     *
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (last_active_time &lt; "2020-01-01T00:00:00+00:00" OR last_active_time &gt;
     * "2022-01-01T00:00:00+00:00")
     *
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (display_name:"Hello World" OR display_name:"Fun event") AND
     * (last_active_time &gt; "2020-01-01T00:00:00+00:00" AND last_active_time &lt;
     * "2022-01-01T00:00:00+00:00")
     *
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (create_time &gt; "2019-01-01T00:00:00+00:00" AND create_time &lt;
     * "2020-01-01T00:00:00+00:00") AND (external_user_allowed = "true") AND
     * (space_history_state = "HISTORY_ON" OR space_history_state = "HISTORY_OFF")
     * ```
     * </pre>
     *
     * <code>string query = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuery() {
      query_ = getDefaultInstance().getQuery();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A search query.
     *
     * You can search by using the following parameters:
     *
     * - `create_time`
     * - `customer`
     * - `display_name`
     * - `external_user_allowed`
     * - `last_active_time`
     * - `space_history_state`
     * - `space_type`
     *
     * `create_time` and `last_active_time` accept a timestamp in
     * [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339) format and the supported
     * comparison operators are: `=`, `&lt;`, `&gt;`, `&lt;=`, `&gt;=`.
     *
     * `customer` is required and is used to indicate which customer
     * to fetch spaces from. `customers/my_customer` is the only supported value.
     *
     * `display_name` only accepts the `HAS` (`:`) operator. The text to
     * match is first tokenized into tokens and each token is prefix-matched
     * case-insensitively and independently as a substring anywhere in the space's
     * `display_name`. For example, `Fun Eve` matches `Fun event` or `The
     * evening was fun`, but not `notFun event` or `even`.
     *
     * `external_user_allowed` accepts either `true` or `false`.
     *
     * `space_history_state` only accepts values from the [`historyState`]
     * (https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces#Space.HistoryState)
     * field of a `space` resource.
     *
     * `space_type` is required and the only valid value is `SPACE`.
     *
     * Across different fields, only `AND` operators are supported. A valid
     * example is `space_type = "SPACE" AND display_name:"Hello"` and an invalid
     * example is `space_type = "SPACE" OR display_name:"Hello"`.
     *
     * Among the same field,
     * `space_type` doesn't support `AND` or `OR` operators.
     * `display_name`, 'space_history_state', and 'external_user_allowed' only
     * support `OR` operators.
     * `last_active_time` and `create_time` support both `AND` and `OR` operators.
     * `AND` can only be used to represent an interval, such as `last_active_time
     * &lt; "2022-01-01T00:00:00+00:00" AND last_active_time &gt;
     * "2023-01-01T00:00:00+00:00"`.
     *
     * The following example queries are valid:
     *
     * ```
     * customer = "customers/my_customer" AND space_type = "SPACE"
     *
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * display_name:"Hello World"
     *
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (last_active_time &lt; "2020-01-01T00:00:00+00:00" OR last_active_time &gt;
     * "2022-01-01T00:00:00+00:00")
     *
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (display_name:"Hello World" OR display_name:"Fun event") AND
     * (last_active_time &gt; "2020-01-01T00:00:00+00:00" AND last_active_time &lt;
     * "2022-01-01T00:00:00+00:00")
     *
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (create_time &gt; "2019-01-01T00:00:00+00:00" AND create_time &lt;
     * "2020-01-01T00:00:00+00:00") AND (external_user_allowed = "true") AND
     * (space_history_state = "HISTORY_ON" OR space_history_state = "HISTORY_OFF")
     * ```
     * </pre>
     *
     * <code>string query = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for query to set.
     * @return This builder for chaining.
     */
    public Builder setQueryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      query_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object orderBy_ = "";

    /**
     *
     *
     * <pre>
     * Optional. How the list of spaces is ordered.
     *
     * Supported attributes to order by are:
     *
     * - `membership_count.joined_direct_human_user_count` — Denotes the count of
     * human users that have directly joined a space.
     * - `last_active_time` — Denotes the time when last eligible item is added to
     * any topic of this space.
     * - `create_time` — Denotes the time of the space creation.
     *
     * Valid ordering operation values are:
     *
     * - `ASC` for ascending. Default value.
     *
     * - `DESC` for descending.
     *
     * The supported syntax are:
     *
     * - `membership_count.joined_direct_human_user_count DESC`
     * - `membership_count.joined_direct_human_user_count ASC`
     * - `last_active_time DESC`
     * - `last_active_time ASC`
     * - `create_time DESC`
     * - `create_time ASC`
     * </pre>
     *
     * <code>string order_by = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The orderBy.
     */
    public java.lang.String getOrderBy() {
      java.lang.Object ref = orderBy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        orderBy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. How the list of spaces is ordered.
     *
     * Supported attributes to order by are:
     *
     * - `membership_count.joined_direct_human_user_count` — Denotes the count of
     * human users that have directly joined a space.
     * - `last_active_time` — Denotes the time when last eligible item is added to
     * any topic of this space.
     * - `create_time` — Denotes the time of the space creation.
     *
     * Valid ordering operation values are:
     *
     * - `ASC` for ascending. Default value.
     *
     * - `DESC` for descending.
     *
     * The supported syntax are:
     *
     * - `membership_count.joined_direct_human_user_count DESC`
     * - `membership_count.joined_direct_human_user_count ASC`
     * - `last_active_time DESC`
     * - `last_active_time ASC`
     * - `create_time DESC`
     * - `create_time ASC`
     * </pre>
     *
     * <code>string order_by = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for orderBy.
     */
    public com.google.protobuf.ByteString getOrderByBytes() {
      java.lang.Object ref = orderBy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        orderBy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. How the list of spaces is ordered.
     *
     * Supported attributes to order by are:
     *
     * - `membership_count.joined_direct_human_user_count` — Denotes the count of
     * human users that have directly joined a space.
     * - `last_active_time` — Denotes the time when last eligible item is added to
     * any topic of this space.
     * - `create_time` — Denotes the time of the space creation.
     *
     * Valid ordering operation values are:
     *
     * - `ASC` for ascending. Default value.
     *
     * - `DESC` for descending.
     *
     * The supported syntax are:
     *
     * - `membership_count.joined_direct_human_user_count DESC`
     * - `membership_count.joined_direct_human_user_count ASC`
     * - `last_active_time DESC`
     * - `last_active_time ASC`
     * - `create_time DESC`
     * - `create_time ASC`
     * </pre>
     *
     * <code>string order_by = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The orderBy to set.
     * @return This builder for chaining.
     */
    public Builder setOrderBy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      orderBy_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. How the list of spaces is ordered.
     *
     * Supported attributes to order by are:
     *
     * - `membership_count.joined_direct_human_user_count` — Denotes the count of
     * human users that have directly joined a space.
     * - `last_active_time` — Denotes the time when last eligible item is added to
     * any topic of this space.
     * - `create_time` — Denotes the time of the space creation.
     *
     * Valid ordering operation values are:
     *
     * - `ASC` for ascending. Default value.
     *
     * - `DESC` for descending.
     *
     * The supported syntax are:
     *
     * - `membership_count.joined_direct_human_user_count DESC`
     * - `membership_count.joined_direct_human_user_count ASC`
     * - `last_active_time DESC`
     * - `last_active_time ASC`
     * - `create_time DESC`
     * - `create_time ASC`
     * </pre>
     *
     * <code>string order_by = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOrderBy() {
      orderBy_ = getDefaultInstance().getOrderBy();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. How the list of spaces is ordered.
     *
     * Supported attributes to order by are:
     *
     * - `membership_count.joined_direct_human_user_count` — Denotes the count of
     * human users that have directly joined a space.
     * - `last_active_time` — Denotes the time when last eligible item is added to
     * any topic of this space.
     * - `create_time` — Denotes the time of the space creation.
     *
     * Valid ordering operation values are:
     *
     * - `ASC` for ascending. Default value.
     *
     * - `DESC` for descending.
     *
     * The supported syntax are:
     *
     * - `membership_count.joined_direct_human_user_count DESC`
     * - `membership_count.joined_direct_human_user_count ASC`
     * - `last_active_time DESC`
     * - `last_active_time ASC`
     * - `create_time DESC`
     * - `create_time ASC`
     * </pre>
     *
     * <code>string order_by = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for orderBy to set.
     * @return This builder for chaining.
     */
    public Builder setOrderByBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      orderBy_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.SearchSpacesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.SearchSpacesRequest)
  private static final com.google.chat.v1.SearchSpacesRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.SearchSpacesRequest();
  }

  public static com.google.chat.v1.SearchSpacesRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SearchSpacesRequest> PARSER =
      new com.google.protobuf.AbstractParser<SearchSpacesRequest>() {
        @java.lang.Override
        public SearchSpacesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SearchSpacesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchSpacesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.SearchSpacesRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
