/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/space.proto

// Protobuf Java Version: 3.25.5
package com.google.chat.v1;

/**
 *
 *
 * <pre>
 * A space in Google Chat. Spaces are conversations between two or more users
 * or 1:1 messages between a user and a Chat app.
 * </pre>
 *
 * Protobuf type {@code google.chat.v1.Space}
 */
public final class Space extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.Space)
    SpaceOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Space.newBuilder() to construct.
  private Space(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Space() {
    name_ = "";
    type_ = 0;
    spaceType_ = 0;
    displayName_ = "";
    spaceThreadingState_ = 0;
    spaceHistoryState_ = 0;
    spaceUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Space();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.SpaceProto.internal_static_google_chat_v1_Space_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.SpaceProto.internal_static_google_chat_v1_Space_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.Space.class, com.google.chat.v1.Space.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Deprecated: Use `SpaceType` instead.
   * </pre>
   *
   * Protobuf enum {@code google.chat.v1.Space.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Reserved.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Conversations between two or more humans.
     * </pre>
     *
     * <code>ROOM = 1;</code>
     */
    ROOM(1),
    /**
     *
     *
     * <pre>
     * 1:1 Direct Message between a human and a Chat app, where all messages are
     * flat. Note that this doesn't include direct messages between two humans.
     * </pre>
     *
     * <code>DM = 2;</code>
     */
    DM(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Reserved.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Conversations between two or more humans.
     * </pre>
     *
     * <code>ROOM = 1;</code>
     */
    public static final int ROOM_VALUE = 1;

    /**
     *
     *
     * <pre>
     * 1:1 Direct Message between a human and a Chat app, where all messages are
     * flat. Note that this doesn't include direct messages between two humans.
     * </pre>
     *
     * <code>DM = 2;</code>
     */
    public static final int DM_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return ROOM;
        case 2:
          return DM;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.chat.v1.Space.getDescriptor().getEnumTypes().get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.chat.v1.Space.Type)
  }

  /**
   *
   *
   * <pre>
   * The type of space. Required when creating or updating a space. Output only
   * for other usage.
   * </pre>
   *
   * Protobuf enum {@code google.chat.v1.Space.SpaceType}
   */
  public enum SpaceType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Reserved.
     * </pre>
     *
     * <code>SPACE_TYPE_UNSPECIFIED = 0;</code>
     */
    SPACE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * A place where people send messages, share files, and collaborate.
     * A `SPACE` can include Chat apps.
     * </pre>
     *
     * <code>SPACE = 1;</code>
     */
    SPACE(1),
    /**
     *
     *
     * <pre>
     * Group conversations between 3 or more people.
     * A `GROUP_CHAT` can include Chat apps.
     * </pre>
     *
     * <code>GROUP_CHAT = 2;</code>
     */
    GROUP_CHAT(2),
    /**
     *
     *
     * <pre>
     * 1:1 messages between two humans or a human and a Chat app.
     * </pre>
     *
     * <code>DIRECT_MESSAGE = 3;</code>
     */
    DIRECT_MESSAGE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Reserved.
     * </pre>
     *
     * <code>SPACE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int SPACE_TYPE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * A place where people send messages, share files, and collaborate.
     * A `SPACE` can include Chat apps.
     * </pre>
     *
     * <code>SPACE = 1;</code>
     */
    public static final int SPACE_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Group conversations between 3 or more people.
     * A `GROUP_CHAT` can include Chat apps.
     * </pre>
     *
     * <code>GROUP_CHAT = 2;</code>
     */
    public static final int GROUP_CHAT_VALUE = 2;

    /**
     *
     *
     * <pre>
     * 1:1 messages between two humans or a human and a Chat app.
     * </pre>
     *
     * <code>DIRECT_MESSAGE = 3;</code>
     */
    public static final int DIRECT_MESSAGE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SpaceType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SpaceType forNumber(int value) {
      switch (value) {
        case 0:
          return SPACE_TYPE_UNSPECIFIED;
        case 1:
          return SPACE;
        case 2:
          return GROUP_CHAT;
        case 3:
          return DIRECT_MESSAGE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SpaceType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SpaceType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<SpaceType>() {
          public SpaceType findValueByNumber(int number) {
            return SpaceType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.chat.v1.Space.getDescriptor().getEnumTypes().get(1);
    }

    private static final SpaceType[] VALUES = values();

    public static SpaceType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SpaceType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.chat.v1.Space.SpaceType)
  }

  /**
   *
   *
   * <pre>
   * Specifies the type of threading state in the Chat space.
   * </pre>
   *
   * Protobuf enum {@code google.chat.v1.Space.SpaceThreadingState}
   */
  public enum SpaceThreadingState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Reserved.
     * </pre>
     *
     * <code>SPACE_THREADING_STATE_UNSPECIFIED = 0;</code>
     */
    SPACE_THREADING_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Named spaces that support message threads. When users respond to a
     * message, they can reply in-thread, which keeps their response in the
     * context of the original message.
     * </pre>
     *
     * <code>THREADED_MESSAGES = 2;</code>
     */
    THREADED_MESSAGES(2),
    /**
     *
     *
     * <pre>
     * Named spaces where the conversation is organized by topic. Topics and
     * their replies are grouped together.
     * </pre>
     *
     * <code>GROUPED_MESSAGES = 3;</code>
     */
    GROUPED_MESSAGES(3),
    /**
     *
     *
     * <pre>
     * Direct messages (DMs) between two people and group conversations between
     * 3 or more people.
     * </pre>
     *
     * <code>UNTHREADED_MESSAGES = 4;</code>
     */
    UNTHREADED_MESSAGES(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Reserved.
     * </pre>
     *
     * <code>SPACE_THREADING_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int SPACE_THREADING_STATE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Named spaces that support message threads. When users respond to a
     * message, they can reply in-thread, which keeps their response in the
     * context of the original message.
     * </pre>
     *
     * <code>THREADED_MESSAGES = 2;</code>
     */
    public static final int THREADED_MESSAGES_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Named spaces where the conversation is organized by topic. Topics and
     * their replies are grouped together.
     * </pre>
     *
     * <code>GROUPED_MESSAGES = 3;</code>
     */
    public static final int GROUPED_MESSAGES_VALUE = 3;

    /**
     *
     *
     * <pre>
     * Direct messages (DMs) between two people and group conversations between
     * 3 or more people.
     * </pre>
     *
     * <code>UNTHREADED_MESSAGES = 4;</code>
     */
    public static final int UNTHREADED_MESSAGES_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SpaceThreadingState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SpaceThreadingState forNumber(int value) {
      switch (value) {
        case 0:
          return SPACE_THREADING_STATE_UNSPECIFIED;
        case 2:
          return THREADED_MESSAGES;
        case 3:
          return GROUPED_MESSAGES;
        case 4:
          return UNTHREADED_MESSAGES;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SpaceThreadingState>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SpaceThreadingState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SpaceThreadingState>() {
              public SpaceThreadingState findValueByNumber(int number) {
                return SpaceThreadingState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.chat.v1.Space.getDescriptor().getEnumTypes().get(2);
    }

    private static final SpaceThreadingState[] VALUES = values();

    public static SpaceThreadingState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SpaceThreadingState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.chat.v1.Space.SpaceThreadingState)
  }

  /**
   *
   *
   * <pre>
   * Predefined permission settings that you can only specify when creating a
   * named space. More settings might be added in the future.
   * For details about permission settings for named spaces, see [Learn about
   * spaces](https://support.google.com/chat/answer/7659784).
   * </pre>
   *
   * Protobuf enum {@code google.chat.v1.Space.PredefinedPermissionSettings}
   */
  public enum PredefinedPermissionSettings implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified. Don't use.
     * </pre>
     *
     * <code>PREDEFINED_PERMISSION_SETTINGS_UNSPECIFIED = 0;</code>
     */
    PREDEFINED_PERMISSION_SETTINGS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Setting to make the space a collaboration space where all members can
     * post messages.
     * </pre>
     *
     * <code>COLLABORATION_SPACE = 1;</code>
     */
    COLLABORATION_SPACE(1),
    /**
     *
     *
     * <pre>
     * Setting to make the space an announcement space where only space managers
     * can post messages.
     * </pre>
     *
     * <code>ANNOUNCEMENT_SPACE = 2;</code>
     */
    ANNOUNCEMENT_SPACE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified. Don't use.
     * </pre>
     *
     * <code>PREDEFINED_PERMISSION_SETTINGS_UNSPECIFIED = 0;</code>
     */
    public static final int PREDEFINED_PERMISSION_SETTINGS_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Setting to make the space a collaboration space where all members can
     * post messages.
     * </pre>
     *
     * <code>COLLABORATION_SPACE = 1;</code>
     */
    public static final int COLLABORATION_SPACE_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Setting to make the space an announcement space where only space managers
     * can post messages.
     * </pre>
     *
     * <code>ANNOUNCEMENT_SPACE = 2;</code>
     */
    public static final int ANNOUNCEMENT_SPACE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PredefinedPermissionSettings valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PredefinedPermissionSettings forNumber(int value) {
      switch (value) {
        case 0:
          return PREDEFINED_PERMISSION_SETTINGS_UNSPECIFIED;
        case 1:
          return COLLABORATION_SPACE;
        case 2:
          return ANNOUNCEMENT_SPACE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PredefinedPermissionSettings>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PredefinedPermissionSettings>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PredefinedPermissionSettings>() {
              public PredefinedPermissionSettings findValueByNumber(int number) {
                return PredefinedPermissionSettings.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.chat.v1.Space.getDescriptor().getEnumTypes().get(3);
    }

    private static final PredefinedPermissionSettings[] VALUES = values();

    public static PredefinedPermissionSettings valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PredefinedPermissionSettings(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.chat.v1.Space.PredefinedPermissionSettings)
  }

  public interface SpaceDetailsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.chat.v1.Space.SpaceDetails)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. A description of the space. For example, describe the space's
     * discussion topic, functional purpose, or participants.
     *
     * Supports up to 150 characters.
     * </pre>
     *
     * <code>string description = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    java.lang.String getDescription();

    /**
     *
     *
     * <pre>
     * Optional. A description of the space. For example, describe the space's
     * discussion topic, functional purpose, or participants.
     *
     * Supports up to 150 characters.
     * </pre>
     *
     * <code>string description = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString getDescriptionBytes();

    /**
     *
     *
     * <pre>
     * Optional. The space's rules, expectations, and etiquette.
     *
     * Supports up to 5,000 characters.
     * </pre>
     *
     * <code>string guidelines = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The guidelines.
     */
    java.lang.String getGuidelines();

    /**
     *
     *
     * <pre>
     * Optional. The space's rules, expectations, and etiquette.
     *
     * Supports up to 5,000 characters.
     * </pre>
     *
     * <code>string guidelines = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for guidelines.
     */
    com.google.protobuf.ByteString getGuidelinesBytes();
  }

  /**
   *
   *
   * <pre>
   * Details about the space including description and rules.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.Space.SpaceDetails}
   */
  public static final class SpaceDetails extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.chat.v1.Space.SpaceDetails)
      SpaceDetailsOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use SpaceDetails.newBuilder() to construct.
    private SpaceDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SpaceDetails() {
      description_ = "";
      guidelines_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SpaceDetails();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_Space_SpaceDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_Space_SpaceDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.Space.SpaceDetails.class,
              com.google.chat.v1.Space.SpaceDetails.Builder.class);
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * Optional. A description of the space. For example, describe the space's
     * discussion topic, functional purpose, or participants.
     *
     * Supports up to 150 characters.
     * </pre>
     *
     * <code>string description = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A description of the space. For example, describe the space's
     * discussion topic, functional purpose, or participants.
     *
     * Supports up to 150 characters.
     * </pre>
     *
     * <code>string description = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GUIDELINES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object guidelines_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The space's rules, expectations, and etiquette.
     *
     * Supports up to 5,000 characters.
     * </pre>
     *
     * <code>string guidelines = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The guidelines.
     */
    @java.lang.Override
    public java.lang.String getGuidelines() {
      java.lang.Object ref = guidelines_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        guidelines_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The space's rules, expectations, and etiquette.
     *
     * Supports up to 5,000 characters.
     * </pre>
     *
     * <code>string guidelines = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for guidelines.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGuidelinesBytes() {
      java.lang.Object ref = guidelines_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        guidelines_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, description_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(guidelines_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, guidelines_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, description_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(guidelines_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, guidelines_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.chat.v1.Space.SpaceDetails)) {
        return super.equals(obj);
      }
      com.google.chat.v1.Space.SpaceDetails other = (com.google.chat.v1.Space.SpaceDetails) obj;

      if (!getDescription().equals(other.getDescription())) return false;
      if (!getGuidelines().equals(other.getGuidelines())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      hash = (37 * hash) + GUIDELINES_FIELD_NUMBER;
      hash = (53 * hash) + getGuidelines().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.chat.v1.Space.SpaceDetails parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.Space.SpaceDetails parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.chat.v1.Space.SpaceDetails prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Details about the space including description and rules.
     * </pre>
     *
     * Protobuf type {@code google.chat.v1.Space.SpaceDetails}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.chat.v1.Space.SpaceDetails)
        com.google.chat.v1.Space.SpaceDetailsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.chat.v1.SpaceProto
            .internal_static_google_chat_v1_Space_SpaceDetails_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.chat.v1.SpaceProto
            .internal_static_google_chat_v1_Space_SpaceDetails_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.chat.v1.Space.SpaceDetails.class,
                com.google.chat.v1.Space.SpaceDetails.Builder.class);
      }

      // Construct using com.google.chat.v1.Space.SpaceDetails.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        description_ = "";
        guidelines_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.chat.v1.SpaceProto
            .internal_static_google_chat_v1_Space_SpaceDetails_descriptor;
      }

      @java.lang.Override
      public com.google.chat.v1.Space.SpaceDetails getDefaultInstanceForType() {
        return com.google.chat.v1.Space.SpaceDetails.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.chat.v1.Space.SpaceDetails build() {
        com.google.chat.v1.Space.SpaceDetails result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.chat.v1.Space.SpaceDetails buildPartial() {
        com.google.chat.v1.Space.SpaceDetails result =
            new com.google.chat.v1.Space.SpaceDetails(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.chat.v1.Space.SpaceDetails result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.description_ = description_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.guidelines_ = guidelines_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.chat.v1.Space.SpaceDetails) {
          return mergeFrom((com.google.chat.v1.Space.SpaceDetails) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.chat.v1.Space.SpaceDetails other) {
        if (other == com.google.chat.v1.Space.SpaceDetails.getDefaultInstance()) return this;
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getGuidelines().isEmpty()) {
          guidelines_ = other.guidelines_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  description_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  guidelines_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object description_ = "";

      /**
       *
       *
       * <pre>
       * Optional. A description of the space. For example, describe the space's
       * discussion topic, functional purpose, or participants.
       *
       * Supports up to 150 characters.
       * </pre>
       *
       * <code>string description = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. A description of the space. For example, describe the space's
       * discussion topic, functional purpose, or participants.
       *
       * Supports up to 150 characters.
       * </pre>
       *
       * <code>string description = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. A description of the space. For example, describe the space's
       * discussion topic, functional purpose, or participants.
       *
       * Supports up to 150 characters.
       * </pre>
       *
       * <code>string description = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        description_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. A description of the space. For example, describe the space's
       * discussion topic, functional purpose, or participants.
       *
       * Supports up to 150 characters.
       * </pre>
       *
       * <code>string description = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. A description of the space. For example, describe the space's
       * discussion topic, functional purpose, or participants.
       *
       * Supports up to 150 characters.
       * </pre>
       *
       * <code>string description = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object guidelines_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The space's rules, expectations, and etiquette.
       *
       * Supports up to 5,000 characters.
       * </pre>
       *
       * <code>string guidelines = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The guidelines.
       */
      public java.lang.String getGuidelines() {
        java.lang.Object ref = guidelines_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          guidelines_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The space's rules, expectations, and etiquette.
       *
       * Supports up to 5,000 characters.
       * </pre>
       *
       * <code>string guidelines = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for guidelines.
       */
      public com.google.protobuf.ByteString getGuidelinesBytes() {
        java.lang.Object ref = guidelines_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          guidelines_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The space's rules, expectations, and etiquette.
       *
       * Supports up to 5,000 characters.
       * </pre>
       *
       * <code>string guidelines = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The guidelines to set.
       * @return This builder for chaining.
       */
      public Builder setGuidelines(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        guidelines_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The space's rules, expectations, and etiquette.
       *
       * Supports up to 5,000 characters.
       * </pre>
       *
       * <code>string guidelines = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGuidelines() {
        guidelines_ = getDefaultInstance().getGuidelines();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The space's rules, expectations, and etiquette.
       *
       * Supports up to 5,000 characters.
       * </pre>
       *
       * <code>string guidelines = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for guidelines to set.
       * @return This builder for chaining.
       */
      public Builder setGuidelinesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        guidelines_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.chat.v1.Space.SpaceDetails)
    }

    // @@protoc_insertion_point(class_scope:google.chat.v1.Space.SpaceDetails)
    private static final com.google.chat.v1.Space.SpaceDetails DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.chat.v1.Space.SpaceDetails();
    }

    public static com.google.chat.v1.Space.SpaceDetails getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SpaceDetails> PARSER =
        new com.google.protobuf.AbstractParser<SpaceDetails>() {
          @java.lang.Override
          public SpaceDetails parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SpaceDetails> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SpaceDetails> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.chat.v1.Space.SpaceDetails getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MembershipCountOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.chat.v1.Space.MembershipCount)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Count of human users that have directly joined the space,
     * not counting users joined by having membership in a joined group.
     * </pre>
     *
     * <code>int32 joined_direct_human_user_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The joinedDirectHumanUserCount.
     */
    int getJoinedDirectHumanUserCount();

    /**
     *
     *
     * <pre>
     * Output only. Count of all groups that have directly joined the space.
     * </pre>
     *
     * <code>int32 joined_group_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The joinedGroupCount.
     */
    int getJoinedGroupCount();
  }

  /**
   *
   *
   * <pre>
   * Represents the count of memberships of a space, grouped into categories.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.Space.MembershipCount}
   */
  public static final class MembershipCount extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.chat.v1.Space.MembershipCount)
      MembershipCountOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use MembershipCount.newBuilder() to construct.
    private MembershipCount(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MembershipCount() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MembershipCount();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_Space_MembershipCount_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_Space_MembershipCount_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.Space.MembershipCount.class,
              com.google.chat.v1.Space.MembershipCount.Builder.class);
    }

    public static final int JOINED_DIRECT_HUMAN_USER_COUNT_FIELD_NUMBER = 4;
    private int joinedDirectHumanUserCount_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. Count of human users that have directly joined the space,
     * not counting users joined by having membership in a joined group.
     * </pre>
     *
     * <code>int32 joined_direct_human_user_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The joinedDirectHumanUserCount.
     */
    @java.lang.Override
    public int getJoinedDirectHumanUserCount() {
      return joinedDirectHumanUserCount_;
    }

    public static final int JOINED_GROUP_COUNT_FIELD_NUMBER = 5;
    private int joinedGroupCount_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. Count of all groups that have directly joined the space.
     * </pre>
     *
     * <code>int32 joined_group_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The joinedGroupCount.
     */
    @java.lang.Override
    public int getJoinedGroupCount() {
      return joinedGroupCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (joinedDirectHumanUserCount_ != 0) {
        output.writeInt32(4, joinedDirectHumanUserCount_);
      }
      if (joinedGroupCount_ != 0) {
        output.writeInt32(5, joinedGroupCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (joinedDirectHumanUserCount_ != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(4, joinedDirectHumanUserCount_);
      }
      if (joinedGroupCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, joinedGroupCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.chat.v1.Space.MembershipCount)) {
        return super.equals(obj);
      }
      com.google.chat.v1.Space.MembershipCount other =
          (com.google.chat.v1.Space.MembershipCount) obj;

      if (getJoinedDirectHumanUserCount() != other.getJoinedDirectHumanUserCount()) return false;
      if (getJoinedGroupCount() != other.getJoinedGroupCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + JOINED_DIRECT_HUMAN_USER_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getJoinedDirectHumanUserCount();
      hash = (37 * hash) + JOINED_GROUP_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getJoinedGroupCount();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.chat.v1.Space.MembershipCount parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.Space.MembershipCount parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.Space.MembershipCount parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.Space.MembershipCount parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.Space.MembershipCount parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.Space.MembershipCount parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.Space.MembershipCount parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.Space.MembershipCount parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.Space.MembershipCount parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.Space.MembershipCount parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.Space.MembershipCount parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.Space.MembershipCount parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.chat.v1.Space.MembershipCount prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Represents the count of memberships of a space, grouped into categories.
     * </pre>
     *
     * Protobuf type {@code google.chat.v1.Space.MembershipCount}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.chat.v1.Space.MembershipCount)
        com.google.chat.v1.Space.MembershipCountOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.chat.v1.SpaceProto
            .internal_static_google_chat_v1_Space_MembershipCount_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.chat.v1.SpaceProto
            .internal_static_google_chat_v1_Space_MembershipCount_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.chat.v1.Space.MembershipCount.class,
                com.google.chat.v1.Space.MembershipCount.Builder.class);
      }

      // Construct using com.google.chat.v1.Space.MembershipCount.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        joinedDirectHumanUserCount_ = 0;
        joinedGroupCount_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.chat.v1.SpaceProto
            .internal_static_google_chat_v1_Space_MembershipCount_descriptor;
      }

      @java.lang.Override
      public com.google.chat.v1.Space.MembershipCount getDefaultInstanceForType() {
        return com.google.chat.v1.Space.MembershipCount.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.chat.v1.Space.MembershipCount build() {
        com.google.chat.v1.Space.MembershipCount result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.chat.v1.Space.MembershipCount buildPartial() {
        com.google.chat.v1.Space.MembershipCount result =
            new com.google.chat.v1.Space.MembershipCount(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.chat.v1.Space.MembershipCount result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.joinedDirectHumanUserCount_ = joinedDirectHumanUserCount_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.joinedGroupCount_ = joinedGroupCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.chat.v1.Space.MembershipCount) {
          return mergeFrom((com.google.chat.v1.Space.MembershipCount) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.chat.v1.Space.MembershipCount other) {
        if (other == com.google.chat.v1.Space.MembershipCount.getDefaultInstance()) return this;
        if (other.getJoinedDirectHumanUserCount() != 0) {
          setJoinedDirectHumanUserCount(other.getJoinedDirectHumanUserCount());
        }
        if (other.getJoinedGroupCount() != 0) {
          setJoinedGroupCount(other.getJoinedGroupCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 32:
                {
                  joinedDirectHumanUserCount_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 32
              case 40:
                {
                  joinedGroupCount_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 40
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int joinedDirectHumanUserCount_;

      /**
       *
       *
       * <pre>
       * Output only. Count of human users that have directly joined the space,
       * not counting users joined by having membership in a joined group.
       * </pre>
       *
       * <code>
       * int32 joined_direct_human_user_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The joinedDirectHumanUserCount.
       */
      @java.lang.Override
      public int getJoinedDirectHumanUserCount() {
        return joinedDirectHumanUserCount_;
      }

      /**
       *
       *
       * <pre>
       * Output only. Count of human users that have directly joined the space,
       * not counting users joined by having membership in a joined group.
       * </pre>
       *
       * <code>
       * int32 joined_direct_human_user_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The joinedDirectHumanUserCount to set.
       * @return This builder for chaining.
       */
      public Builder setJoinedDirectHumanUserCount(int value) {

        joinedDirectHumanUserCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Count of human users that have directly joined the space,
       * not counting users joined by having membership in a joined group.
       * </pre>
       *
       * <code>
       * int32 joined_direct_human_user_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearJoinedDirectHumanUserCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        joinedDirectHumanUserCount_ = 0;
        onChanged();
        return this;
      }

      private int joinedGroupCount_;

      /**
       *
       *
       * <pre>
       * Output only. Count of all groups that have directly joined the space.
       * </pre>
       *
       * <code>int32 joined_group_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The joinedGroupCount.
       */
      @java.lang.Override
      public int getJoinedGroupCount() {
        return joinedGroupCount_;
      }

      /**
       *
       *
       * <pre>
       * Output only. Count of all groups that have directly joined the space.
       * </pre>
       *
       * <code>int32 joined_group_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The joinedGroupCount to set.
       * @return This builder for chaining.
       */
      public Builder setJoinedGroupCount(int value) {

        joinedGroupCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Count of all groups that have directly joined the space.
       * </pre>
       *
       * <code>int32 joined_group_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearJoinedGroupCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        joinedGroupCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.chat.v1.Space.MembershipCount)
    }

    // @@protoc_insertion_point(class_scope:google.chat.v1.Space.MembershipCount)
    private static final com.google.chat.v1.Space.MembershipCount DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.chat.v1.Space.MembershipCount();
    }

    public static com.google.chat.v1.Space.MembershipCount getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MembershipCount> PARSER =
        new com.google.protobuf.AbstractParser<MembershipCount>() {
          @java.lang.Override
          public MembershipCount parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MembershipCount> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MembershipCount> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.chat.v1.Space.MembershipCount getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AccessSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.chat.v1.Space.AccessSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Indicates the access state of the space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings.AccessState access_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for accessState.
     */
    int getAccessStateValue();

    /**
     *
     *
     * <pre>
     * Output only. Indicates the access state of the space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings.AccessState access_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The accessState.
     */
    com.google.chat.v1.Space.AccessSettings.AccessState getAccessState();

    /**
     *
     *
     * <pre>
     * Optional. The resource name of the [target
     * audience](https://support.google.com/a/answer/9934697) who can discover
     * the space, join the space, and preview the messages in the space. If
     * unset, only users or Google Groups who have been individually invited or
     * added to the space can access it. For details, see [Make a space
     * discoverable to a target
     * audience](https://developers.google.com/workspace/chat/space-target-audience).
     *
     * Format: `audiences/{audience}`
     *
     * To use the default target audience for the Google Workspace organization,
     * set to `audiences/default`.
     *
     * Reading the target audience supports:
     *
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     *
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with [administrator
     * approval](https://support.google.com/a?p=chat-app-auth)
     * with the `chat.app.spaces` scope in [Developer
     * Preview](https://developers.google.com/workspace/preview).
     *
     * This field is not populated when using the `chat.bot` scope with [app
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     *
     * Setting the target audience requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     * </pre>
     *
     * <code>string audience = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The audience.
     */
    java.lang.String getAudience();

    /**
     *
     *
     * <pre>
     * Optional. The resource name of the [target
     * audience](https://support.google.com/a/answer/9934697) who can discover
     * the space, join the space, and preview the messages in the space. If
     * unset, only users or Google Groups who have been individually invited or
     * added to the space can access it. For details, see [Make a space
     * discoverable to a target
     * audience](https://developers.google.com/workspace/chat/space-target-audience).
     *
     * Format: `audiences/{audience}`
     *
     * To use the default target audience for the Google Workspace organization,
     * set to `audiences/default`.
     *
     * Reading the target audience supports:
     *
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     *
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with [administrator
     * approval](https://support.google.com/a?p=chat-app-auth)
     * with the `chat.app.spaces` scope in [Developer
     * Preview](https://developers.google.com/workspace/preview).
     *
     * This field is not populated when using the `chat.bot` scope with [app
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     *
     * Setting the target audience requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     * </pre>
     *
     * <code>string audience = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for audience.
     */
    com.google.protobuf.ByteString getAudienceBytes();
  }

  /**
   *
   *
   * <pre>
   * Represents the [access
   * setting](https://support.google.com/chat/answer/11971020) of the space.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.Space.AccessSettings}
   */
  public static final class AccessSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.chat.v1.Space.AccessSettings)
      AccessSettingsOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use AccessSettings.newBuilder() to construct.
    private AccessSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AccessSettings() {
      accessState_ = 0;
      audience_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AccessSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_Space_AccessSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_Space_AccessSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.Space.AccessSettings.class,
              com.google.chat.v1.Space.AccessSettings.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Represents the access state of the space.
     * </pre>
     *
     * Protobuf enum {@code google.chat.v1.Space.AccessSettings.AccessState}
     */
    public enum AccessState implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Access state is unknown or not supported in this API.
       * </pre>
       *
       * <code>ACCESS_STATE_UNSPECIFIED = 0;</code>
       */
      ACCESS_STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Only users or Google Groups that have been individually added or
       * invited by other users or Google Workspace administrators can discover
       * and access the space.
       * </pre>
       *
       * <code>PRIVATE = 1;</code>
       */
      PRIVATE(1),
      /**
       *
       *
       * <pre>
       * A space manager has granted a target audience access to
       * the space. Users or Google Groups that have been individually added or
       * invited to the space can also discover and access the space. To learn
       * more, see [Make a space discoverable to specific
       * users](https://developers.google.com/workspace/chat/space-target-audience).
       *
       * Creating discoverable spaces requires [user
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
       * </pre>
       *
       * <code>DISCOVERABLE = 2;</code>
       */
      DISCOVERABLE(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Access state is unknown or not supported in this API.
       * </pre>
       *
       * <code>ACCESS_STATE_UNSPECIFIED = 0;</code>
       */
      public static final int ACCESS_STATE_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * Only users or Google Groups that have been individually added or
       * invited by other users or Google Workspace administrators can discover
       * and access the space.
       * </pre>
       *
       * <code>PRIVATE = 1;</code>
       */
      public static final int PRIVATE_VALUE = 1;

      /**
       *
       *
       * <pre>
       * A space manager has granted a target audience access to
       * the space. Users or Google Groups that have been individually added or
       * invited to the space can also discover and access the space. To learn
       * more, see [Make a space discoverable to specific
       * users](https://developers.google.com/workspace/chat/space-target-audience).
       *
       * Creating discoverable spaces requires [user
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
       * </pre>
       *
       * <code>DISCOVERABLE = 2;</code>
       */
      public static final int DISCOVERABLE_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static AccessState valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static AccessState forNumber(int value) {
        switch (value) {
          case 0:
            return ACCESS_STATE_UNSPECIFIED;
          case 1:
            return PRIVATE;
          case 2:
            return DISCOVERABLE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<AccessState> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<AccessState> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<AccessState>() {
            public AccessState findValueByNumber(int number) {
              return AccessState.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.chat.v1.Space.AccessSettings.getDescriptor().getEnumTypes().get(0);
      }

      private static final AccessState[] VALUES = values();

      public static AccessState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private AccessState(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.chat.v1.Space.AccessSettings.AccessState)
    }

    public static final int ACCESS_STATE_FIELD_NUMBER = 1;
    private int accessState_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. Indicates the access state of the space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings.AccessState access_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for accessState.
     */
    @java.lang.Override
    public int getAccessStateValue() {
      return accessState_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Indicates the access state of the space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings.AccessState access_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The accessState.
     */
    @java.lang.Override
    public com.google.chat.v1.Space.AccessSettings.AccessState getAccessState() {
      com.google.chat.v1.Space.AccessSettings.AccessState result =
          com.google.chat.v1.Space.AccessSettings.AccessState.forNumber(accessState_);
      return result == null
          ? com.google.chat.v1.Space.AccessSettings.AccessState.UNRECOGNIZED
          : result;
    }

    public static final int AUDIENCE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object audience_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The resource name of the [target
     * audience](https://support.google.com/a/answer/9934697) who can discover
     * the space, join the space, and preview the messages in the space. If
     * unset, only users or Google Groups who have been individually invited or
     * added to the space can access it. For details, see [Make a space
     * discoverable to a target
     * audience](https://developers.google.com/workspace/chat/space-target-audience).
     *
     * Format: `audiences/{audience}`
     *
     * To use the default target audience for the Google Workspace organization,
     * set to `audiences/default`.
     *
     * Reading the target audience supports:
     *
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     *
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with [administrator
     * approval](https://support.google.com/a?p=chat-app-auth)
     * with the `chat.app.spaces` scope in [Developer
     * Preview](https://developers.google.com/workspace/preview).
     *
     * This field is not populated when using the `chat.bot` scope with [app
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     *
     * Setting the target audience requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     * </pre>
     *
     * <code>string audience = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The audience.
     */
    @java.lang.Override
    public java.lang.String getAudience() {
      java.lang.Object ref = audience_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        audience_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The resource name of the [target
     * audience](https://support.google.com/a/answer/9934697) who can discover
     * the space, join the space, and preview the messages in the space. If
     * unset, only users or Google Groups who have been individually invited or
     * added to the space can access it. For details, see [Make a space
     * discoverable to a target
     * audience](https://developers.google.com/workspace/chat/space-target-audience).
     *
     * Format: `audiences/{audience}`
     *
     * To use the default target audience for the Google Workspace organization,
     * set to `audiences/default`.
     *
     * Reading the target audience supports:
     *
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     *
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with [administrator
     * approval](https://support.google.com/a?p=chat-app-auth)
     * with the `chat.app.spaces` scope in [Developer
     * Preview](https://developers.google.com/workspace/preview).
     *
     * This field is not populated when using the `chat.bot` scope with [app
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
     *
     * Setting the target audience requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     * </pre>
     *
     * <code>string audience = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for audience.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAudienceBytes() {
      java.lang.Object ref = audience_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        audience_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (accessState_
          != com.google.chat.v1.Space.AccessSettings.AccessState.ACCESS_STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, accessState_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audience_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, audience_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (accessState_
          != com.google.chat.v1.Space.AccessSettings.AccessState.ACCESS_STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, accessState_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audience_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, audience_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.chat.v1.Space.AccessSettings)) {
        return super.equals(obj);
      }
      com.google.chat.v1.Space.AccessSettings other = (com.google.chat.v1.Space.AccessSettings) obj;

      if (accessState_ != other.accessState_) return false;
      if (!getAudience().equals(other.getAudience())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ACCESS_STATE_FIELD_NUMBER;
      hash = (53 * hash) + accessState_;
      hash = (37 * hash) + AUDIENCE_FIELD_NUMBER;
      hash = (53 * hash) + getAudience().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.chat.v1.Space.AccessSettings parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.Space.AccessSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.Space.AccessSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.Space.AccessSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.Space.AccessSettings parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.Space.AccessSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.Space.AccessSettings parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.Space.AccessSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.Space.AccessSettings parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.Space.AccessSettings parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.Space.AccessSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.Space.AccessSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.chat.v1.Space.AccessSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Represents the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * </pre>
     *
     * Protobuf type {@code google.chat.v1.Space.AccessSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.chat.v1.Space.AccessSettings)
        com.google.chat.v1.Space.AccessSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.chat.v1.SpaceProto
            .internal_static_google_chat_v1_Space_AccessSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.chat.v1.SpaceProto
            .internal_static_google_chat_v1_Space_AccessSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.chat.v1.Space.AccessSettings.class,
                com.google.chat.v1.Space.AccessSettings.Builder.class);
      }

      // Construct using com.google.chat.v1.Space.AccessSettings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        accessState_ = 0;
        audience_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.chat.v1.SpaceProto
            .internal_static_google_chat_v1_Space_AccessSettings_descriptor;
      }

      @java.lang.Override
      public com.google.chat.v1.Space.AccessSettings getDefaultInstanceForType() {
        return com.google.chat.v1.Space.AccessSettings.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.chat.v1.Space.AccessSettings build() {
        com.google.chat.v1.Space.AccessSettings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.chat.v1.Space.AccessSettings buildPartial() {
        com.google.chat.v1.Space.AccessSettings result =
            new com.google.chat.v1.Space.AccessSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.chat.v1.Space.AccessSettings result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.accessState_ = accessState_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.audience_ = audience_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.chat.v1.Space.AccessSettings) {
          return mergeFrom((com.google.chat.v1.Space.AccessSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.chat.v1.Space.AccessSettings other) {
        if (other == com.google.chat.v1.Space.AccessSettings.getDefaultInstance()) return this;
        if (other.accessState_ != 0) {
          setAccessStateValue(other.getAccessStateValue());
        }
        if (!other.getAudience().isEmpty()) {
          audience_ = other.audience_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  accessState_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 26:
                {
                  audience_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int accessState_ = 0;

      /**
       *
       *
       * <pre>
       * Output only. Indicates the access state of the space.
       * </pre>
       *
       * <code>
       * .google.chat.v1.Space.AccessSettings.AccessState access_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for accessState.
       */
      @java.lang.Override
      public int getAccessStateValue() {
        return accessState_;
      }

      /**
       *
       *
       * <pre>
       * Output only. Indicates the access state of the space.
       * </pre>
       *
       * <code>
       * .google.chat.v1.Space.AccessSettings.AccessState access_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for accessState to set.
       * @return This builder for chaining.
       */
      public Builder setAccessStateValue(int value) {
        accessState_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Indicates the access state of the space.
       * </pre>
       *
       * <code>
       * .google.chat.v1.Space.AccessSettings.AccessState access_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The accessState.
       */
      @java.lang.Override
      public com.google.chat.v1.Space.AccessSettings.AccessState getAccessState() {
        com.google.chat.v1.Space.AccessSettings.AccessState result =
            com.google.chat.v1.Space.AccessSettings.AccessState.forNumber(accessState_);
        return result == null
            ? com.google.chat.v1.Space.AccessSettings.AccessState.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Output only. Indicates the access state of the space.
       * </pre>
       *
       * <code>
       * .google.chat.v1.Space.AccessSettings.AccessState access_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The accessState to set.
       * @return This builder for chaining.
       */
      public Builder setAccessState(com.google.chat.v1.Space.AccessSettings.AccessState value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        accessState_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Indicates the access state of the space.
       * </pre>
       *
       * <code>
       * .google.chat.v1.Space.AccessSettings.AccessState access_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAccessState() {
        bitField0_ = (bitField0_ & ~0x00000001);
        accessState_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object audience_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The resource name of the [target
       * audience](https://support.google.com/a/answer/9934697) who can discover
       * the space, join the space, and preview the messages in the space. If
       * unset, only users or Google Groups who have been individually invited or
       * added to the space can access it. For details, see [Make a space
       * discoverable to a target
       * audience](https://developers.google.com/workspace/chat/space-target-audience).
       *
       * Format: `audiences/{audience}`
       *
       * To use the default target audience for the Google Workspace organization,
       * set to `audiences/default`.
       *
       * Reading the target audience supports:
       *
       * - [User
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
       *
       * - [App
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
       * with [administrator
       * approval](https://support.google.com/a?p=chat-app-auth)
       * with the `chat.app.spaces` scope in [Developer
       * Preview](https://developers.google.com/workspace/preview).
       *
       * This field is not populated when using the `chat.bot` scope with [app
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
       *
       * Setting the target audience requires [user
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
       * </pre>
       *
       * <code>string audience = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The audience.
       */
      public java.lang.String getAudience() {
        java.lang.Object ref = audience_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          audience_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The resource name of the [target
       * audience](https://support.google.com/a/answer/9934697) who can discover
       * the space, join the space, and preview the messages in the space. If
       * unset, only users or Google Groups who have been individually invited or
       * added to the space can access it. For details, see [Make a space
       * discoverable to a target
       * audience](https://developers.google.com/workspace/chat/space-target-audience).
       *
       * Format: `audiences/{audience}`
       *
       * To use the default target audience for the Google Workspace organization,
       * set to `audiences/default`.
       *
       * Reading the target audience supports:
       *
       * - [User
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
       *
       * - [App
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
       * with [administrator
       * approval](https://support.google.com/a?p=chat-app-auth)
       * with the `chat.app.spaces` scope in [Developer
       * Preview](https://developers.google.com/workspace/preview).
       *
       * This field is not populated when using the `chat.bot` scope with [app
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
       *
       * Setting the target audience requires [user
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
       * </pre>
       *
       * <code>string audience = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for audience.
       */
      public com.google.protobuf.ByteString getAudienceBytes() {
        java.lang.Object ref = audience_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          audience_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The resource name of the [target
       * audience](https://support.google.com/a/answer/9934697) who can discover
       * the space, join the space, and preview the messages in the space. If
       * unset, only users or Google Groups who have been individually invited or
       * added to the space can access it. For details, see [Make a space
       * discoverable to a target
       * audience](https://developers.google.com/workspace/chat/space-target-audience).
       *
       * Format: `audiences/{audience}`
       *
       * To use the default target audience for the Google Workspace organization,
       * set to `audiences/default`.
       *
       * Reading the target audience supports:
       *
       * - [User
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
       *
       * - [App
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
       * with [administrator
       * approval](https://support.google.com/a?p=chat-app-auth)
       * with the `chat.app.spaces` scope in [Developer
       * Preview](https://developers.google.com/workspace/preview).
       *
       * This field is not populated when using the `chat.bot` scope with [app
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
       *
       * Setting the target audience requires [user
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
       * </pre>
       *
       * <code>string audience = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The audience to set.
       * @return This builder for chaining.
       */
      public Builder setAudience(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        audience_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The resource name of the [target
       * audience](https://support.google.com/a/answer/9934697) who can discover
       * the space, join the space, and preview the messages in the space. If
       * unset, only users or Google Groups who have been individually invited or
       * added to the space can access it. For details, see [Make a space
       * discoverable to a target
       * audience](https://developers.google.com/workspace/chat/space-target-audience).
       *
       * Format: `audiences/{audience}`
       *
       * To use the default target audience for the Google Workspace organization,
       * set to `audiences/default`.
       *
       * Reading the target audience supports:
       *
       * - [User
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
       *
       * - [App
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
       * with [administrator
       * approval](https://support.google.com/a?p=chat-app-auth)
       * with the `chat.app.spaces` scope in [Developer
       * Preview](https://developers.google.com/workspace/preview).
       *
       * This field is not populated when using the `chat.bot` scope with [app
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
       *
       * Setting the target audience requires [user
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
       * </pre>
       *
       * <code>string audience = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAudience() {
        audience_ = getDefaultInstance().getAudience();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The resource name of the [target
       * audience](https://support.google.com/a/answer/9934697) who can discover
       * the space, join the space, and preview the messages in the space. If
       * unset, only users or Google Groups who have been individually invited or
       * added to the space can access it. For details, see [Make a space
       * discoverable to a target
       * audience](https://developers.google.com/workspace/chat/space-target-audience).
       *
       * Format: `audiences/{audience}`
       *
       * To use the default target audience for the Google Workspace organization,
       * set to `audiences/default`.
       *
       * Reading the target audience supports:
       *
       * - [User
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
       *
       * - [App
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
       * with [administrator
       * approval](https://support.google.com/a?p=chat-app-auth)
       * with the `chat.app.spaces` scope in [Developer
       * Preview](https://developers.google.com/workspace/preview).
       *
       * This field is not populated when using the `chat.bot` scope with [app
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
       *
       * Setting the target audience requires [user
       * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
       * </pre>
       *
       * <code>string audience = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for audience to set.
       * @return This builder for chaining.
       */
      public Builder setAudienceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        audience_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.chat.v1.Space.AccessSettings)
    }

    // @@protoc_insertion_point(class_scope:google.chat.v1.Space.AccessSettings)
    private static final com.google.chat.v1.Space.AccessSettings DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.chat.v1.Space.AccessSettings();
    }

    public static com.google.chat.v1.Space.AccessSettings getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AccessSettings> PARSER =
        new com.google.protobuf.AbstractParser<AccessSettings>() {
          @java.lang.Override
          public AccessSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AccessSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AccessSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.chat.v1.Space.AccessSettings getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PermissionSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.chat.v1.Space.PermissionSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Setting for managing members and groups in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting manage_members_and_groups = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the manageMembersAndGroups field is set.
     */
    boolean hasManageMembersAndGroups();

    /**
     *
     *
     * <pre>
     * Optional. Setting for managing members and groups in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting manage_members_and_groups = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The manageMembersAndGroups.
     */
    com.google.chat.v1.Space.PermissionSetting getManageMembersAndGroups();

    /**
     *
     *
     * <pre>
     * Optional. Setting for managing members and groups in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting manage_members_and_groups = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.chat.v1.Space.PermissionSettingOrBuilder getManageMembersAndGroupsOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Setting for updating space name, avatar, description and
     * guidelines.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting modify_space_details = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the modifySpaceDetails field is set.
     */
    boolean hasModifySpaceDetails();

    /**
     *
     *
     * <pre>
     * Optional. Setting for updating space name, avatar, description and
     * guidelines.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting modify_space_details = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The modifySpaceDetails.
     */
    com.google.chat.v1.Space.PermissionSetting getModifySpaceDetails();

    /**
     *
     *
     * <pre>
     * Optional. Setting for updating space name, avatar, description and
     * guidelines.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting modify_space_details = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.chat.v1.Space.PermissionSettingOrBuilder getModifySpaceDetailsOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Setting for toggling space history on and off.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting toggle_history = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the toggleHistory field is set.
     */
    boolean hasToggleHistory();

    /**
     *
     *
     * <pre>
     * Optional. Setting for toggling space history on and off.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting toggle_history = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The toggleHistory.
     */
    com.google.chat.v1.Space.PermissionSetting getToggleHistory();

    /**
     *
     *
     * <pre>
     * Optional. Setting for toggling space history on and off.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting toggle_history = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.chat.v1.Space.PermissionSettingOrBuilder getToggleHistoryOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Setting for using &#64;all in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting use_at_mention_all = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the useAtMentionAll field is set.
     */
    boolean hasUseAtMentionAll();

    /**
     *
     *
     * <pre>
     * Optional. Setting for using &#64;all in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting use_at_mention_all = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The useAtMentionAll.
     */
    com.google.chat.v1.Space.PermissionSetting getUseAtMentionAll();

    /**
     *
     *
     * <pre>
     * Optional. Setting for using &#64;all in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting use_at_mention_all = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.chat.v1.Space.PermissionSettingOrBuilder getUseAtMentionAllOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Setting for managing apps in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting manage_apps = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the manageApps field is set.
     */
    boolean hasManageApps();

    /**
     *
     *
     * <pre>
     * Optional. Setting for managing apps in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting manage_apps = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The manageApps.
     */
    com.google.chat.v1.Space.PermissionSetting getManageApps();

    /**
     *
     *
     * <pre>
     * Optional. Setting for managing apps in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting manage_apps = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.chat.v1.Space.PermissionSettingOrBuilder getManageAppsOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Setting for managing webhooks in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting manage_webhooks = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the manageWebhooks field is set.
     */
    boolean hasManageWebhooks();

    /**
     *
     *
     * <pre>
     * Optional. Setting for managing webhooks in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting manage_webhooks = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The manageWebhooks.
     */
    com.google.chat.v1.Space.PermissionSetting getManageWebhooks();

    /**
     *
     *
     * <pre>
     * Optional. Setting for managing webhooks in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting manage_webhooks = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.chat.v1.Space.PermissionSettingOrBuilder getManageWebhooksOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. Setting for posting messages in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting post_messages = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the postMessages field is set.
     */
    boolean hasPostMessages();

    /**
     *
     *
     * <pre>
     * Output only. Setting for posting messages in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting post_messages = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The postMessages.
     */
    com.google.chat.v1.Space.PermissionSetting getPostMessages();

    /**
     *
     *
     * <pre>
     * Output only. Setting for posting messages in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting post_messages = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.chat.v1.Space.PermissionSettingOrBuilder getPostMessagesOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Setting for replying to messages in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting reply_messages = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the replyMessages field is set.
     */
    boolean hasReplyMessages();

    /**
     *
     *
     * <pre>
     * Optional. Setting for replying to messages in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting reply_messages = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The replyMessages.
     */
    com.google.chat.v1.Space.PermissionSetting getReplyMessages();

    /**
     *
     *
     * <pre>
     * Optional. Setting for replying to messages in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting reply_messages = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.chat.v1.Space.PermissionSettingOrBuilder getReplyMessagesOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * [Permission settings](https://support.google.com/chat/answer/13340792)
   * that you can specify when updating an existing named space.
   *
   * To set permission settings when creating a space, specify the
   * `PredefinedPermissionSettings` field in your request.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.Space.PermissionSettings}
   */
  public static final class PermissionSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.chat.v1.Space.PermissionSettings)
      PermissionSettingsOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use PermissionSettings.newBuilder() to construct.
    private PermissionSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PermissionSettings() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PermissionSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_Space_PermissionSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_Space_PermissionSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.Space.PermissionSettings.class,
              com.google.chat.v1.Space.PermissionSettings.Builder.class);
    }

    private int bitField0_;
    public static final int MANAGE_MEMBERS_AND_GROUPS_FIELD_NUMBER = 1;
    private com.google.chat.v1.Space.PermissionSetting manageMembersAndGroups_;

    /**
     *
     *
     * <pre>
     * Optional. Setting for managing members and groups in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting manage_members_and_groups = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the manageMembersAndGroups field is set.
     */
    @java.lang.Override
    public boolean hasManageMembersAndGroups() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Setting for managing members and groups in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting manage_members_and_groups = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The manageMembersAndGroups.
     */
    @java.lang.Override
    public com.google.chat.v1.Space.PermissionSetting getManageMembersAndGroups() {
      return manageMembersAndGroups_ == null
          ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
          : manageMembersAndGroups_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Setting for managing members and groups in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting manage_members_and_groups = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.chat.v1.Space.PermissionSettingOrBuilder
        getManageMembersAndGroupsOrBuilder() {
      return manageMembersAndGroups_ == null
          ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
          : manageMembersAndGroups_;
    }

    public static final int MODIFY_SPACE_DETAILS_FIELD_NUMBER = 2;
    private com.google.chat.v1.Space.PermissionSetting modifySpaceDetails_;

    /**
     *
     *
     * <pre>
     * Optional. Setting for updating space name, avatar, description and
     * guidelines.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting modify_space_details = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the modifySpaceDetails field is set.
     */
    @java.lang.Override
    public boolean hasModifySpaceDetails() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Setting for updating space name, avatar, description and
     * guidelines.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting modify_space_details = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The modifySpaceDetails.
     */
    @java.lang.Override
    public com.google.chat.v1.Space.PermissionSetting getModifySpaceDetails() {
      return modifySpaceDetails_ == null
          ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
          : modifySpaceDetails_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Setting for updating space name, avatar, description and
     * guidelines.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting modify_space_details = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.chat.v1.Space.PermissionSettingOrBuilder getModifySpaceDetailsOrBuilder() {
      return modifySpaceDetails_ == null
          ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
          : modifySpaceDetails_;
    }

    public static final int TOGGLE_HISTORY_FIELD_NUMBER = 3;
    private com.google.chat.v1.Space.PermissionSetting toggleHistory_;

    /**
     *
     *
     * <pre>
     * Optional. Setting for toggling space history on and off.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting toggle_history = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the toggleHistory field is set.
     */
    @java.lang.Override
    public boolean hasToggleHistory() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Setting for toggling space history on and off.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting toggle_history = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The toggleHistory.
     */
    @java.lang.Override
    public com.google.chat.v1.Space.PermissionSetting getToggleHistory() {
      return toggleHistory_ == null
          ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
          : toggleHistory_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Setting for toggling space history on and off.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting toggle_history = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.chat.v1.Space.PermissionSettingOrBuilder getToggleHistoryOrBuilder() {
      return toggleHistory_ == null
          ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
          : toggleHistory_;
    }

    public static final int USE_AT_MENTION_ALL_FIELD_NUMBER = 4;
    private com.google.chat.v1.Space.PermissionSetting useAtMentionAll_;

    /**
     *
     *
     * <pre>
     * Optional. Setting for using &#64;all in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting use_at_mention_all = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the useAtMentionAll field is set.
     */
    @java.lang.Override
    public boolean hasUseAtMentionAll() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Setting for using &#64;all in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting use_at_mention_all = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The useAtMentionAll.
     */
    @java.lang.Override
    public com.google.chat.v1.Space.PermissionSetting getUseAtMentionAll() {
      return useAtMentionAll_ == null
          ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
          : useAtMentionAll_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Setting for using &#64;all in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting use_at_mention_all = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.chat.v1.Space.PermissionSettingOrBuilder getUseAtMentionAllOrBuilder() {
      return useAtMentionAll_ == null
          ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
          : useAtMentionAll_;
    }

    public static final int MANAGE_APPS_FIELD_NUMBER = 5;
    private com.google.chat.v1.Space.PermissionSetting manageApps_;

    /**
     *
     *
     * <pre>
     * Optional. Setting for managing apps in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting manage_apps = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the manageApps field is set.
     */
    @java.lang.Override
    public boolean hasManageApps() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Setting for managing apps in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting manage_apps = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The manageApps.
     */
    @java.lang.Override
    public com.google.chat.v1.Space.PermissionSetting getManageApps() {
      return manageApps_ == null
          ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
          : manageApps_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Setting for managing apps in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting manage_apps = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.chat.v1.Space.PermissionSettingOrBuilder getManageAppsOrBuilder() {
      return manageApps_ == null
          ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
          : manageApps_;
    }

    public static final int MANAGE_WEBHOOKS_FIELD_NUMBER = 6;
    private com.google.chat.v1.Space.PermissionSetting manageWebhooks_;

    /**
     *
     *
     * <pre>
     * Optional. Setting for managing webhooks in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting manage_webhooks = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the manageWebhooks field is set.
     */
    @java.lang.Override
    public boolean hasManageWebhooks() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Setting for managing webhooks in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting manage_webhooks = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The manageWebhooks.
     */
    @java.lang.Override
    public com.google.chat.v1.Space.PermissionSetting getManageWebhooks() {
      return manageWebhooks_ == null
          ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
          : manageWebhooks_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Setting for managing webhooks in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting manage_webhooks = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.chat.v1.Space.PermissionSettingOrBuilder getManageWebhooksOrBuilder() {
      return manageWebhooks_ == null
          ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
          : manageWebhooks_;
    }

    public static final int POST_MESSAGES_FIELD_NUMBER = 7;
    private com.google.chat.v1.Space.PermissionSetting postMessages_;

    /**
     *
     *
     * <pre>
     * Output only. Setting for posting messages in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting post_messages = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the postMessages field is set.
     */
    @java.lang.Override
    public boolean hasPostMessages() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Setting for posting messages in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting post_messages = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The postMessages.
     */
    @java.lang.Override
    public com.google.chat.v1.Space.PermissionSetting getPostMessages() {
      return postMessages_ == null
          ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
          : postMessages_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Setting for posting messages in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting post_messages = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.chat.v1.Space.PermissionSettingOrBuilder getPostMessagesOrBuilder() {
      return postMessages_ == null
          ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
          : postMessages_;
    }

    public static final int REPLY_MESSAGES_FIELD_NUMBER = 8;
    private com.google.chat.v1.Space.PermissionSetting replyMessages_;

    /**
     *
     *
     * <pre>
     * Optional. Setting for replying to messages in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting reply_messages = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the replyMessages field is set.
     */
    @java.lang.Override
    public boolean hasReplyMessages() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Setting for replying to messages in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting reply_messages = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The replyMessages.
     */
    @java.lang.Override
    public com.google.chat.v1.Space.PermissionSetting getReplyMessages() {
      return replyMessages_ == null
          ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
          : replyMessages_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Setting for replying to messages in a space.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.Space.PermissionSetting reply_messages = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.chat.v1.Space.PermissionSettingOrBuilder getReplyMessagesOrBuilder() {
      return replyMessages_ == null
          ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
          : replyMessages_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getManageMembersAndGroups());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getModifySpaceDetails());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(3, getToggleHistory());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeMessage(4, getUseAtMentionAll());
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        output.writeMessage(5, getManageApps());
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        output.writeMessage(6, getManageWebhooks());
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        output.writeMessage(7, getPostMessages());
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        output.writeMessage(8, getReplyMessages());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, getManageMembersAndGroups());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, getModifySpaceDetails());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getToggleHistory());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUseAtMentionAll());
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getManageApps());
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getManageWebhooks());
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getPostMessages());
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getReplyMessages());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.chat.v1.Space.PermissionSettings)) {
        return super.equals(obj);
      }
      com.google.chat.v1.Space.PermissionSettings other =
          (com.google.chat.v1.Space.PermissionSettings) obj;

      if (hasManageMembersAndGroups() != other.hasManageMembersAndGroups()) return false;
      if (hasManageMembersAndGroups()) {
        if (!getManageMembersAndGroups().equals(other.getManageMembersAndGroups())) return false;
      }
      if (hasModifySpaceDetails() != other.hasModifySpaceDetails()) return false;
      if (hasModifySpaceDetails()) {
        if (!getModifySpaceDetails().equals(other.getModifySpaceDetails())) return false;
      }
      if (hasToggleHistory() != other.hasToggleHistory()) return false;
      if (hasToggleHistory()) {
        if (!getToggleHistory().equals(other.getToggleHistory())) return false;
      }
      if (hasUseAtMentionAll() != other.hasUseAtMentionAll()) return false;
      if (hasUseAtMentionAll()) {
        if (!getUseAtMentionAll().equals(other.getUseAtMentionAll())) return false;
      }
      if (hasManageApps() != other.hasManageApps()) return false;
      if (hasManageApps()) {
        if (!getManageApps().equals(other.getManageApps())) return false;
      }
      if (hasManageWebhooks() != other.hasManageWebhooks()) return false;
      if (hasManageWebhooks()) {
        if (!getManageWebhooks().equals(other.getManageWebhooks())) return false;
      }
      if (hasPostMessages() != other.hasPostMessages()) return false;
      if (hasPostMessages()) {
        if (!getPostMessages().equals(other.getPostMessages())) return false;
      }
      if (hasReplyMessages() != other.hasReplyMessages()) return false;
      if (hasReplyMessages()) {
        if (!getReplyMessages().equals(other.getReplyMessages())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasManageMembersAndGroups()) {
        hash = (37 * hash) + MANAGE_MEMBERS_AND_GROUPS_FIELD_NUMBER;
        hash = (53 * hash) + getManageMembersAndGroups().hashCode();
      }
      if (hasModifySpaceDetails()) {
        hash = (37 * hash) + MODIFY_SPACE_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getModifySpaceDetails().hashCode();
      }
      if (hasToggleHistory()) {
        hash = (37 * hash) + TOGGLE_HISTORY_FIELD_NUMBER;
        hash = (53 * hash) + getToggleHistory().hashCode();
      }
      if (hasUseAtMentionAll()) {
        hash = (37 * hash) + USE_AT_MENTION_ALL_FIELD_NUMBER;
        hash = (53 * hash) + getUseAtMentionAll().hashCode();
      }
      if (hasManageApps()) {
        hash = (37 * hash) + MANAGE_APPS_FIELD_NUMBER;
        hash = (53 * hash) + getManageApps().hashCode();
      }
      if (hasManageWebhooks()) {
        hash = (37 * hash) + MANAGE_WEBHOOKS_FIELD_NUMBER;
        hash = (53 * hash) + getManageWebhooks().hashCode();
      }
      if (hasPostMessages()) {
        hash = (37 * hash) + POST_MESSAGES_FIELD_NUMBER;
        hash = (53 * hash) + getPostMessages().hashCode();
      }
      if (hasReplyMessages()) {
        hash = (37 * hash) + REPLY_MESSAGES_FIELD_NUMBER;
        hash = (53 * hash) + getReplyMessages().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.chat.v1.Space.PermissionSettings parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.Space.PermissionSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.Space.PermissionSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.Space.PermissionSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.Space.PermissionSettings parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.Space.PermissionSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.Space.PermissionSettings parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.Space.PermissionSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.Space.PermissionSettings parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.Space.PermissionSettings parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.Space.PermissionSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.Space.PermissionSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.chat.v1.Space.PermissionSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * [Permission settings](https://support.google.com/chat/answer/13340792)
     * that you can specify when updating an existing named space.
     *
     * To set permission settings when creating a space, specify the
     * `PredefinedPermissionSettings` field in your request.
     * </pre>
     *
     * Protobuf type {@code google.chat.v1.Space.PermissionSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.chat.v1.Space.PermissionSettings)
        com.google.chat.v1.Space.PermissionSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.chat.v1.SpaceProto
            .internal_static_google_chat_v1_Space_PermissionSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.chat.v1.SpaceProto
            .internal_static_google_chat_v1_Space_PermissionSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.chat.v1.Space.PermissionSettings.class,
                com.google.chat.v1.Space.PermissionSettings.Builder.class);
      }

      // Construct using com.google.chat.v1.Space.PermissionSettings.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getManageMembersAndGroupsFieldBuilder();
          getModifySpaceDetailsFieldBuilder();
          getToggleHistoryFieldBuilder();
          getUseAtMentionAllFieldBuilder();
          getManageAppsFieldBuilder();
          getManageWebhooksFieldBuilder();
          getPostMessagesFieldBuilder();
          getReplyMessagesFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        manageMembersAndGroups_ = null;
        if (manageMembersAndGroupsBuilder_ != null) {
          manageMembersAndGroupsBuilder_.dispose();
          manageMembersAndGroupsBuilder_ = null;
        }
        modifySpaceDetails_ = null;
        if (modifySpaceDetailsBuilder_ != null) {
          modifySpaceDetailsBuilder_.dispose();
          modifySpaceDetailsBuilder_ = null;
        }
        toggleHistory_ = null;
        if (toggleHistoryBuilder_ != null) {
          toggleHistoryBuilder_.dispose();
          toggleHistoryBuilder_ = null;
        }
        useAtMentionAll_ = null;
        if (useAtMentionAllBuilder_ != null) {
          useAtMentionAllBuilder_.dispose();
          useAtMentionAllBuilder_ = null;
        }
        manageApps_ = null;
        if (manageAppsBuilder_ != null) {
          manageAppsBuilder_.dispose();
          manageAppsBuilder_ = null;
        }
        manageWebhooks_ = null;
        if (manageWebhooksBuilder_ != null) {
          manageWebhooksBuilder_.dispose();
          manageWebhooksBuilder_ = null;
        }
        postMessages_ = null;
        if (postMessagesBuilder_ != null) {
          postMessagesBuilder_.dispose();
          postMessagesBuilder_ = null;
        }
        replyMessages_ = null;
        if (replyMessagesBuilder_ != null) {
          replyMessagesBuilder_.dispose();
          replyMessagesBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.chat.v1.SpaceProto
            .internal_static_google_chat_v1_Space_PermissionSettings_descriptor;
      }

      @java.lang.Override
      public com.google.chat.v1.Space.PermissionSettings getDefaultInstanceForType() {
        return com.google.chat.v1.Space.PermissionSettings.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.chat.v1.Space.PermissionSettings build() {
        com.google.chat.v1.Space.PermissionSettings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.chat.v1.Space.PermissionSettings buildPartial() {
        com.google.chat.v1.Space.PermissionSettings result =
            new com.google.chat.v1.Space.PermissionSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.chat.v1.Space.PermissionSettings result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.manageMembersAndGroups_ =
              manageMembersAndGroupsBuilder_ == null
                  ? manageMembersAndGroups_
                  : manageMembersAndGroupsBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.modifySpaceDetails_ =
              modifySpaceDetailsBuilder_ == null
                  ? modifySpaceDetails_
                  : modifySpaceDetailsBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.toggleHistory_ =
              toggleHistoryBuilder_ == null ? toggleHistory_ : toggleHistoryBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.useAtMentionAll_ =
              useAtMentionAllBuilder_ == null ? useAtMentionAll_ : useAtMentionAllBuilder_.build();
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.manageApps_ =
              manageAppsBuilder_ == null ? manageApps_ : manageAppsBuilder_.build();
          to_bitField0_ |= 0x00000010;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.manageWebhooks_ =
              manageWebhooksBuilder_ == null ? manageWebhooks_ : manageWebhooksBuilder_.build();
          to_bitField0_ |= 0x00000020;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.postMessages_ =
              postMessagesBuilder_ == null ? postMessages_ : postMessagesBuilder_.build();
          to_bitField0_ |= 0x00000040;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.replyMessages_ =
              replyMessagesBuilder_ == null ? replyMessages_ : replyMessagesBuilder_.build();
          to_bitField0_ |= 0x00000080;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.chat.v1.Space.PermissionSettings) {
          return mergeFrom((com.google.chat.v1.Space.PermissionSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.chat.v1.Space.PermissionSettings other) {
        if (other == com.google.chat.v1.Space.PermissionSettings.getDefaultInstance()) return this;
        if (other.hasManageMembersAndGroups()) {
          mergeManageMembersAndGroups(other.getManageMembersAndGroups());
        }
        if (other.hasModifySpaceDetails()) {
          mergeModifySpaceDetails(other.getModifySpaceDetails());
        }
        if (other.hasToggleHistory()) {
          mergeToggleHistory(other.getToggleHistory());
        }
        if (other.hasUseAtMentionAll()) {
          mergeUseAtMentionAll(other.getUseAtMentionAll());
        }
        if (other.hasManageApps()) {
          mergeManageApps(other.getManageApps());
        }
        if (other.hasManageWebhooks()) {
          mergeManageWebhooks(other.getManageWebhooks());
        }
        if (other.hasPostMessages()) {
          mergePostMessages(other.getPostMessages());
        }
        if (other.hasReplyMessages()) {
          mergeReplyMessages(other.getReplyMessages());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getManageMembersAndGroupsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getModifySpaceDetailsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getToggleHistoryFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getUseAtMentionAllFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(getManageAppsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(
                      getManageWebhooksFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(getPostMessagesFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000040;
                  break;
                } // case 58
              case 66:
                {
                  input.readMessage(getReplyMessagesFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000080;
                  break;
                } // case 66
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.chat.v1.Space.PermissionSetting manageMembersAndGroups_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.Space.PermissionSetting,
              com.google.chat.v1.Space.PermissionSetting.Builder,
              com.google.chat.v1.Space.PermissionSettingOrBuilder>
          manageMembersAndGroupsBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing members and groups in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_members_and_groups = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the manageMembersAndGroups field is set.
       */
      public boolean hasManageMembersAndGroups() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing members and groups in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_members_and_groups = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The manageMembersAndGroups.
       */
      public com.google.chat.v1.Space.PermissionSetting getManageMembersAndGroups() {
        if (manageMembersAndGroupsBuilder_ == null) {
          return manageMembersAndGroups_ == null
              ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
              : manageMembersAndGroups_;
        } else {
          return manageMembersAndGroupsBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing members and groups in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_members_and_groups = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setManageMembersAndGroups(com.google.chat.v1.Space.PermissionSetting value) {
        if (manageMembersAndGroupsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          manageMembersAndGroups_ = value;
        } else {
          manageMembersAndGroupsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing members and groups in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_members_and_groups = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setManageMembersAndGroups(
          com.google.chat.v1.Space.PermissionSetting.Builder builderForValue) {
        if (manageMembersAndGroupsBuilder_ == null) {
          manageMembersAndGroups_ = builderForValue.build();
        } else {
          manageMembersAndGroupsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing members and groups in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_members_and_groups = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeManageMembersAndGroups(com.google.chat.v1.Space.PermissionSetting value) {
        if (manageMembersAndGroupsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && manageMembersAndGroups_ != null
              && manageMembersAndGroups_
                  != com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()) {
            getManageMembersAndGroupsBuilder().mergeFrom(value);
          } else {
            manageMembersAndGroups_ = value;
          }
        } else {
          manageMembersAndGroupsBuilder_.mergeFrom(value);
        }
        if (manageMembersAndGroups_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing members and groups in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_members_and_groups = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearManageMembersAndGroups() {
        bitField0_ = (bitField0_ & ~0x00000001);
        manageMembersAndGroups_ = null;
        if (manageMembersAndGroupsBuilder_ != null) {
          manageMembersAndGroupsBuilder_.dispose();
          manageMembersAndGroupsBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing members and groups in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_members_and_groups = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.chat.v1.Space.PermissionSetting.Builder getManageMembersAndGroupsBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getManageMembersAndGroupsFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing members and groups in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_members_and_groups = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.chat.v1.Space.PermissionSettingOrBuilder
          getManageMembersAndGroupsOrBuilder() {
        if (manageMembersAndGroupsBuilder_ != null) {
          return manageMembersAndGroupsBuilder_.getMessageOrBuilder();
        } else {
          return manageMembersAndGroups_ == null
              ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
              : manageMembersAndGroups_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing members and groups in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_members_and_groups = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.Space.PermissionSetting,
              com.google.chat.v1.Space.PermissionSetting.Builder,
              com.google.chat.v1.Space.PermissionSettingOrBuilder>
          getManageMembersAndGroupsFieldBuilder() {
        if (manageMembersAndGroupsBuilder_ == null) {
          manageMembersAndGroupsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.chat.v1.Space.PermissionSetting,
                  com.google.chat.v1.Space.PermissionSetting.Builder,
                  com.google.chat.v1.Space.PermissionSettingOrBuilder>(
                  getManageMembersAndGroups(), getParentForChildren(), isClean());
          manageMembersAndGroups_ = null;
        }
        return manageMembersAndGroupsBuilder_;
      }

      private com.google.chat.v1.Space.PermissionSetting modifySpaceDetails_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.Space.PermissionSetting,
              com.google.chat.v1.Space.PermissionSetting.Builder,
              com.google.chat.v1.Space.PermissionSettingOrBuilder>
          modifySpaceDetailsBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Setting for updating space name, avatar, description and
       * guidelines.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting modify_space_details = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the modifySpaceDetails field is set.
       */
      public boolean hasModifySpaceDetails() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for updating space name, avatar, description and
       * guidelines.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting modify_space_details = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The modifySpaceDetails.
       */
      public com.google.chat.v1.Space.PermissionSetting getModifySpaceDetails() {
        if (modifySpaceDetailsBuilder_ == null) {
          return modifySpaceDetails_ == null
              ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
              : modifySpaceDetails_;
        } else {
          return modifySpaceDetailsBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for updating space name, avatar, description and
       * guidelines.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting modify_space_details = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setModifySpaceDetails(com.google.chat.v1.Space.PermissionSetting value) {
        if (modifySpaceDetailsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          modifySpaceDetails_ = value;
        } else {
          modifySpaceDetailsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for updating space name, avatar, description and
       * guidelines.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting modify_space_details = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setModifySpaceDetails(
          com.google.chat.v1.Space.PermissionSetting.Builder builderForValue) {
        if (modifySpaceDetailsBuilder_ == null) {
          modifySpaceDetails_ = builderForValue.build();
        } else {
          modifySpaceDetailsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for updating space name, avatar, description and
       * guidelines.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting modify_space_details = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeModifySpaceDetails(com.google.chat.v1.Space.PermissionSetting value) {
        if (modifySpaceDetailsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && modifySpaceDetails_ != null
              && modifySpaceDetails_
                  != com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()) {
            getModifySpaceDetailsBuilder().mergeFrom(value);
          } else {
            modifySpaceDetails_ = value;
          }
        } else {
          modifySpaceDetailsBuilder_.mergeFrom(value);
        }
        if (modifySpaceDetails_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for updating space name, avatar, description and
       * guidelines.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting modify_space_details = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearModifySpaceDetails() {
        bitField0_ = (bitField0_ & ~0x00000002);
        modifySpaceDetails_ = null;
        if (modifySpaceDetailsBuilder_ != null) {
          modifySpaceDetailsBuilder_.dispose();
          modifySpaceDetailsBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for updating space name, avatar, description and
       * guidelines.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting modify_space_details = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.chat.v1.Space.PermissionSetting.Builder getModifySpaceDetailsBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getModifySpaceDetailsFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for updating space name, avatar, description and
       * guidelines.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting modify_space_details = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.chat.v1.Space.PermissionSettingOrBuilder getModifySpaceDetailsOrBuilder() {
        if (modifySpaceDetailsBuilder_ != null) {
          return modifySpaceDetailsBuilder_.getMessageOrBuilder();
        } else {
          return modifySpaceDetails_ == null
              ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
              : modifySpaceDetails_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for updating space name, avatar, description and
       * guidelines.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting modify_space_details = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.Space.PermissionSetting,
              com.google.chat.v1.Space.PermissionSetting.Builder,
              com.google.chat.v1.Space.PermissionSettingOrBuilder>
          getModifySpaceDetailsFieldBuilder() {
        if (modifySpaceDetailsBuilder_ == null) {
          modifySpaceDetailsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.chat.v1.Space.PermissionSetting,
                  com.google.chat.v1.Space.PermissionSetting.Builder,
                  com.google.chat.v1.Space.PermissionSettingOrBuilder>(
                  getModifySpaceDetails(), getParentForChildren(), isClean());
          modifySpaceDetails_ = null;
        }
        return modifySpaceDetailsBuilder_;
      }

      private com.google.chat.v1.Space.PermissionSetting toggleHistory_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.Space.PermissionSetting,
              com.google.chat.v1.Space.PermissionSetting.Builder,
              com.google.chat.v1.Space.PermissionSettingOrBuilder>
          toggleHistoryBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Setting for toggling space history on and off.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting toggle_history = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the toggleHistory field is set.
       */
      public boolean hasToggleHistory() {
        return ((bitField0_ & 0x00000004) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for toggling space history on and off.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting toggle_history = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The toggleHistory.
       */
      public com.google.chat.v1.Space.PermissionSetting getToggleHistory() {
        if (toggleHistoryBuilder_ == null) {
          return toggleHistory_ == null
              ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
              : toggleHistory_;
        } else {
          return toggleHistoryBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for toggling space history on and off.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting toggle_history = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setToggleHistory(com.google.chat.v1.Space.PermissionSetting value) {
        if (toggleHistoryBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          toggleHistory_ = value;
        } else {
          toggleHistoryBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for toggling space history on and off.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting toggle_history = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setToggleHistory(
          com.google.chat.v1.Space.PermissionSetting.Builder builderForValue) {
        if (toggleHistoryBuilder_ == null) {
          toggleHistory_ = builderForValue.build();
        } else {
          toggleHistoryBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for toggling space history on and off.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting toggle_history = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeToggleHistory(com.google.chat.v1.Space.PermissionSetting value) {
        if (toggleHistoryBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && toggleHistory_ != null
              && toggleHistory_
                  != com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()) {
            getToggleHistoryBuilder().mergeFrom(value);
          } else {
            toggleHistory_ = value;
          }
        } else {
          toggleHistoryBuilder_.mergeFrom(value);
        }
        if (toggleHistory_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for toggling space history on and off.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting toggle_history = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearToggleHistory() {
        bitField0_ = (bitField0_ & ~0x00000004);
        toggleHistory_ = null;
        if (toggleHistoryBuilder_ != null) {
          toggleHistoryBuilder_.dispose();
          toggleHistoryBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for toggling space history on and off.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting toggle_history = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.chat.v1.Space.PermissionSetting.Builder getToggleHistoryBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getToggleHistoryFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for toggling space history on and off.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting toggle_history = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.chat.v1.Space.PermissionSettingOrBuilder getToggleHistoryOrBuilder() {
        if (toggleHistoryBuilder_ != null) {
          return toggleHistoryBuilder_.getMessageOrBuilder();
        } else {
          return toggleHistory_ == null
              ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
              : toggleHistory_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for toggling space history on and off.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting toggle_history = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.Space.PermissionSetting,
              com.google.chat.v1.Space.PermissionSetting.Builder,
              com.google.chat.v1.Space.PermissionSettingOrBuilder>
          getToggleHistoryFieldBuilder() {
        if (toggleHistoryBuilder_ == null) {
          toggleHistoryBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.chat.v1.Space.PermissionSetting,
                  com.google.chat.v1.Space.PermissionSetting.Builder,
                  com.google.chat.v1.Space.PermissionSettingOrBuilder>(
                  getToggleHistory(), getParentForChildren(), isClean());
          toggleHistory_ = null;
        }
        return toggleHistoryBuilder_;
      }

      private com.google.chat.v1.Space.PermissionSetting useAtMentionAll_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.Space.PermissionSetting,
              com.google.chat.v1.Space.PermissionSetting.Builder,
              com.google.chat.v1.Space.PermissionSettingOrBuilder>
          useAtMentionAllBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Setting for using &#64;all in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting use_at_mention_all = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the useAtMentionAll field is set.
       */
      public boolean hasUseAtMentionAll() {
        return ((bitField0_ & 0x00000008) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for using &#64;all in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting use_at_mention_all = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The useAtMentionAll.
       */
      public com.google.chat.v1.Space.PermissionSetting getUseAtMentionAll() {
        if (useAtMentionAllBuilder_ == null) {
          return useAtMentionAll_ == null
              ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
              : useAtMentionAll_;
        } else {
          return useAtMentionAllBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for using &#64;all in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting use_at_mention_all = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setUseAtMentionAll(com.google.chat.v1.Space.PermissionSetting value) {
        if (useAtMentionAllBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          useAtMentionAll_ = value;
        } else {
          useAtMentionAllBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for using &#64;all in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting use_at_mention_all = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setUseAtMentionAll(
          com.google.chat.v1.Space.PermissionSetting.Builder builderForValue) {
        if (useAtMentionAllBuilder_ == null) {
          useAtMentionAll_ = builderForValue.build();
        } else {
          useAtMentionAllBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for using &#64;all in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting use_at_mention_all = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeUseAtMentionAll(com.google.chat.v1.Space.PermissionSetting value) {
        if (useAtMentionAllBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && useAtMentionAll_ != null
              && useAtMentionAll_
                  != com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()) {
            getUseAtMentionAllBuilder().mergeFrom(value);
          } else {
            useAtMentionAll_ = value;
          }
        } else {
          useAtMentionAllBuilder_.mergeFrom(value);
        }
        if (useAtMentionAll_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for using &#64;all in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting use_at_mention_all = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearUseAtMentionAll() {
        bitField0_ = (bitField0_ & ~0x00000008);
        useAtMentionAll_ = null;
        if (useAtMentionAllBuilder_ != null) {
          useAtMentionAllBuilder_.dispose();
          useAtMentionAllBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for using &#64;all in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting use_at_mention_all = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.chat.v1.Space.PermissionSetting.Builder getUseAtMentionAllBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getUseAtMentionAllFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for using &#64;all in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting use_at_mention_all = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.chat.v1.Space.PermissionSettingOrBuilder getUseAtMentionAllOrBuilder() {
        if (useAtMentionAllBuilder_ != null) {
          return useAtMentionAllBuilder_.getMessageOrBuilder();
        } else {
          return useAtMentionAll_ == null
              ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
              : useAtMentionAll_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for using &#64;all in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting use_at_mention_all = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.Space.PermissionSetting,
              com.google.chat.v1.Space.PermissionSetting.Builder,
              com.google.chat.v1.Space.PermissionSettingOrBuilder>
          getUseAtMentionAllFieldBuilder() {
        if (useAtMentionAllBuilder_ == null) {
          useAtMentionAllBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.chat.v1.Space.PermissionSetting,
                  com.google.chat.v1.Space.PermissionSetting.Builder,
                  com.google.chat.v1.Space.PermissionSettingOrBuilder>(
                  getUseAtMentionAll(), getParentForChildren(), isClean());
          useAtMentionAll_ = null;
        }
        return useAtMentionAllBuilder_;
      }

      private com.google.chat.v1.Space.PermissionSetting manageApps_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.Space.PermissionSetting,
              com.google.chat.v1.Space.PermissionSetting.Builder,
              com.google.chat.v1.Space.PermissionSettingOrBuilder>
          manageAppsBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing apps in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_apps = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the manageApps field is set.
       */
      public boolean hasManageApps() {
        return ((bitField0_ & 0x00000010) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing apps in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_apps = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The manageApps.
       */
      public com.google.chat.v1.Space.PermissionSetting getManageApps() {
        if (manageAppsBuilder_ == null) {
          return manageApps_ == null
              ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
              : manageApps_;
        } else {
          return manageAppsBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing apps in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_apps = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setManageApps(com.google.chat.v1.Space.PermissionSetting value) {
        if (manageAppsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          manageApps_ = value;
        } else {
          manageAppsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing apps in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_apps = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setManageApps(
          com.google.chat.v1.Space.PermissionSetting.Builder builderForValue) {
        if (manageAppsBuilder_ == null) {
          manageApps_ = builderForValue.build();
        } else {
          manageAppsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing apps in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_apps = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeManageApps(com.google.chat.v1.Space.PermissionSetting value) {
        if (manageAppsBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && manageApps_ != null
              && manageApps_ != com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()) {
            getManageAppsBuilder().mergeFrom(value);
          } else {
            manageApps_ = value;
          }
        } else {
          manageAppsBuilder_.mergeFrom(value);
        }
        if (manageApps_ != null) {
          bitField0_ |= 0x00000010;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing apps in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_apps = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearManageApps() {
        bitField0_ = (bitField0_ & ~0x00000010);
        manageApps_ = null;
        if (manageAppsBuilder_ != null) {
          manageAppsBuilder_.dispose();
          manageAppsBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing apps in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_apps = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.chat.v1.Space.PermissionSetting.Builder getManageAppsBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getManageAppsFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing apps in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_apps = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.chat.v1.Space.PermissionSettingOrBuilder getManageAppsOrBuilder() {
        if (manageAppsBuilder_ != null) {
          return manageAppsBuilder_.getMessageOrBuilder();
        } else {
          return manageApps_ == null
              ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
              : manageApps_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing apps in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_apps = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.Space.PermissionSetting,
              com.google.chat.v1.Space.PermissionSetting.Builder,
              com.google.chat.v1.Space.PermissionSettingOrBuilder>
          getManageAppsFieldBuilder() {
        if (manageAppsBuilder_ == null) {
          manageAppsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.chat.v1.Space.PermissionSetting,
                  com.google.chat.v1.Space.PermissionSetting.Builder,
                  com.google.chat.v1.Space.PermissionSettingOrBuilder>(
                  getManageApps(), getParentForChildren(), isClean());
          manageApps_ = null;
        }
        return manageAppsBuilder_;
      }

      private com.google.chat.v1.Space.PermissionSetting manageWebhooks_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.Space.PermissionSetting,
              com.google.chat.v1.Space.PermissionSetting.Builder,
              com.google.chat.v1.Space.PermissionSettingOrBuilder>
          manageWebhooksBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing webhooks in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_webhooks = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the manageWebhooks field is set.
       */
      public boolean hasManageWebhooks() {
        return ((bitField0_ & 0x00000020) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing webhooks in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_webhooks = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The manageWebhooks.
       */
      public com.google.chat.v1.Space.PermissionSetting getManageWebhooks() {
        if (manageWebhooksBuilder_ == null) {
          return manageWebhooks_ == null
              ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
              : manageWebhooks_;
        } else {
          return manageWebhooksBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing webhooks in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_webhooks = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setManageWebhooks(com.google.chat.v1.Space.PermissionSetting value) {
        if (manageWebhooksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          manageWebhooks_ = value;
        } else {
          manageWebhooksBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing webhooks in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_webhooks = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setManageWebhooks(
          com.google.chat.v1.Space.PermissionSetting.Builder builderForValue) {
        if (manageWebhooksBuilder_ == null) {
          manageWebhooks_ = builderForValue.build();
        } else {
          manageWebhooksBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing webhooks in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_webhooks = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeManageWebhooks(com.google.chat.v1.Space.PermissionSetting value) {
        if (manageWebhooksBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && manageWebhooks_ != null
              && manageWebhooks_
                  != com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()) {
            getManageWebhooksBuilder().mergeFrom(value);
          } else {
            manageWebhooks_ = value;
          }
        } else {
          manageWebhooksBuilder_.mergeFrom(value);
        }
        if (manageWebhooks_ != null) {
          bitField0_ |= 0x00000020;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing webhooks in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_webhooks = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearManageWebhooks() {
        bitField0_ = (bitField0_ & ~0x00000020);
        manageWebhooks_ = null;
        if (manageWebhooksBuilder_ != null) {
          manageWebhooksBuilder_.dispose();
          manageWebhooksBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing webhooks in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_webhooks = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.chat.v1.Space.PermissionSetting.Builder getManageWebhooksBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getManageWebhooksFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing webhooks in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_webhooks = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.chat.v1.Space.PermissionSettingOrBuilder getManageWebhooksOrBuilder() {
        if (manageWebhooksBuilder_ != null) {
          return manageWebhooksBuilder_.getMessageOrBuilder();
        } else {
          return manageWebhooks_ == null
              ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
              : manageWebhooks_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for managing webhooks in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting manage_webhooks = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.Space.PermissionSetting,
              com.google.chat.v1.Space.PermissionSetting.Builder,
              com.google.chat.v1.Space.PermissionSettingOrBuilder>
          getManageWebhooksFieldBuilder() {
        if (manageWebhooksBuilder_ == null) {
          manageWebhooksBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.chat.v1.Space.PermissionSetting,
                  com.google.chat.v1.Space.PermissionSetting.Builder,
                  com.google.chat.v1.Space.PermissionSettingOrBuilder>(
                  getManageWebhooks(), getParentForChildren(), isClean());
          manageWebhooks_ = null;
        }
        return manageWebhooksBuilder_;
      }

      private com.google.chat.v1.Space.PermissionSetting postMessages_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.Space.PermissionSetting,
              com.google.chat.v1.Space.PermissionSetting.Builder,
              com.google.chat.v1.Space.PermissionSettingOrBuilder>
          postMessagesBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. Setting for posting messages in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting post_messages = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the postMessages field is set.
       */
      public boolean hasPostMessages() {
        return ((bitField0_ & 0x00000040) != 0);
      }

      /**
       *
       *
       * <pre>
       * Output only. Setting for posting messages in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting post_messages = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The postMessages.
       */
      public com.google.chat.v1.Space.PermissionSetting getPostMessages() {
        if (postMessagesBuilder_ == null) {
          return postMessages_ == null
              ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
              : postMessages_;
        } else {
          return postMessagesBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Setting for posting messages in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting post_messages = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setPostMessages(com.google.chat.v1.Space.PermissionSetting value) {
        if (postMessagesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          postMessages_ = value;
        } else {
          postMessagesBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Setting for posting messages in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting post_messages = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setPostMessages(
          com.google.chat.v1.Space.PermissionSetting.Builder builderForValue) {
        if (postMessagesBuilder_ == null) {
          postMessages_ = builderForValue.build();
        } else {
          postMessagesBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Setting for posting messages in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting post_messages = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergePostMessages(com.google.chat.v1.Space.PermissionSetting value) {
        if (postMessagesBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)
              && postMessages_ != null
              && postMessages_ != com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()) {
            getPostMessagesBuilder().mergeFrom(value);
          } else {
            postMessages_ = value;
          }
        } else {
          postMessagesBuilder_.mergeFrom(value);
        }
        if (postMessages_ != null) {
          bitField0_ |= 0x00000040;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Setting for posting messages in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting post_messages = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearPostMessages() {
        bitField0_ = (bitField0_ & ~0x00000040);
        postMessages_ = null;
        if (postMessagesBuilder_ != null) {
          postMessagesBuilder_.dispose();
          postMessagesBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Setting for posting messages in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting post_messages = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.chat.v1.Space.PermissionSetting.Builder getPostMessagesBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getPostMessagesFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Output only. Setting for posting messages in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting post_messages = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.chat.v1.Space.PermissionSettingOrBuilder getPostMessagesOrBuilder() {
        if (postMessagesBuilder_ != null) {
          return postMessagesBuilder_.getMessageOrBuilder();
        } else {
          return postMessages_ == null
              ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
              : postMessages_;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Setting for posting messages in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting post_messages = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.Space.PermissionSetting,
              com.google.chat.v1.Space.PermissionSetting.Builder,
              com.google.chat.v1.Space.PermissionSettingOrBuilder>
          getPostMessagesFieldBuilder() {
        if (postMessagesBuilder_ == null) {
          postMessagesBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.chat.v1.Space.PermissionSetting,
                  com.google.chat.v1.Space.PermissionSetting.Builder,
                  com.google.chat.v1.Space.PermissionSettingOrBuilder>(
                  getPostMessages(), getParentForChildren(), isClean());
          postMessages_ = null;
        }
        return postMessagesBuilder_;
      }

      private com.google.chat.v1.Space.PermissionSetting replyMessages_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.Space.PermissionSetting,
              com.google.chat.v1.Space.PermissionSetting.Builder,
              com.google.chat.v1.Space.PermissionSettingOrBuilder>
          replyMessagesBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Setting for replying to messages in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting reply_messages = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the replyMessages field is set.
       */
      public boolean hasReplyMessages() {
        return ((bitField0_ & 0x00000080) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for replying to messages in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting reply_messages = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The replyMessages.
       */
      public com.google.chat.v1.Space.PermissionSetting getReplyMessages() {
        if (replyMessagesBuilder_ == null) {
          return replyMessages_ == null
              ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
              : replyMessages_;
        } else {
          return replyMessagesBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for replying to messages in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting reply_messages = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setReplyMessages(com.google.chat.v1.Space.PermissionSetting value) {
        if (replyMessagesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          replyMessages_ = value;
        } else {
          replyMessagesBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for replying to messages in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting reply_messages = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setReplyMessages(
          com.google.chat.v1.Space.PermissionSetting.Builder builderForValue) {
        if (replyMessagesBuilder_ == null) {
          replyMessages_ = builderForValue.build();
        } else {
          replyMessagesBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for replying to messages in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting reply_messages = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeReplyMessages(com.google.chat.v1.Space.PermissionSetting value) {
        if (replyMessagesBuilder_ == null) {
          if (((bitField0_ & 0x00000080) != 0)
              && replyMessages_ != null
              && replyMessages_
                  != com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()) {
            getReplyMessagesBuilder().mergeFrom(value);
          } else {
            replyMessages_ = value;
          }
        } else {
          replyMessagesBuilder_.mergeFrom(value);
        }
        if (replyMessages_ != null) {
          bitField0_ |= 0x00000080;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for replying to messages in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting reply_messages = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearReplyMessages() {
        bitField0_ = (bitField0_ & ~0x00000080);
        replyMessages_ = null;
        if (replyMessagesBuilder_ != null) {
          replyMessagesBuilder_.dispose();
          replyMessagesBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for replying to messages in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting reply_messages = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.chat.v1.Space.PermissionSetting.Builder getReplyMessagesBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getReplyMessagesFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for replying to messages in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting reply_messages = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.chat.v1.Space.PermissionSettingOrBuilder getReplyMessagesOrBuilder() {
        if (replyMessagesBuilder_ != null) {
          return replyMessagesBuilder_.getMessageOrBuilder();
        } else {
          return replyMessages_ == null
              ? com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()
              : replyMessages_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Setting for replying to messages in a space.
       * </pre>
       *
       * <code>
       * optional .google.chat.v1.Space.PermissionSetting reply_messages = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.Space.PermissionSetting,
              com.google.chat.v1.Space.PermissionSetting.Builder,
              com.google.chat.v1.Space.PermissionSettingOrBuilder>
          getReplyMessagesFieldBuilder() {
        if (replyMessagesBuilder_ == null) {
          replyMessagesBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.chat.v1.Space.PermissionSetting,
                  com.google.chat.v1.Space.PermissionSetting.Builder,
                  com.google.chat.v1.Space.PermissionSettingOrBuilder>(
                  getReplyMessages(), getParentForChildren(), isClean());
          replyMessages_ = null;
        }
        return replyMessagesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.chat.v1.Space.PermissionSettings)
    }

    // @@protoc_insertion_point(class_scope:google.chat.v1.Space.PermissionSettings)
    private static final com.google.chat.v1.Space.PermissionSettings DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.chat.v1.Space.PermissionSettings();
    }

    public static com.google.chat.v1.Space.PermissionSettings getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PermissionSettings> PARSER =
        new com.google.protobuf.AbstractParser<PermissionSettings>() {
          @java.lang.Override
          public PermissionSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PermissionSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PermissionSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.chat.v1.Space.PermissionSettings getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PermissionSettingOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.chat.v1.Space.PermissionSetting)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Whether spaces managers have this permission.
     * </pre>
     *
     * <code>bool managers_allowed = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The managersAllowed.
     */
    boolean getManagersAllowed();

    /**
     *
     *
     * <pre>
     * Optional. Whether non-manager members have this permission.
     * </pre>
     *
     * <code>bool members_allowed = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The membersAllowed.
     */
    boolean getMembersAllowed();
  }

  /**
   *
   *
   * <pre>
   * Represents a space permission setting.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.Space.PermissionSetting}
   */
  public static final class PermissionSetting extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.chat.v1.Space.PermissionSetting)
      PermissionSettingOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use PermissionSetting.newBuilder() to construct.
    private PermissionSetting(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PermissionSetting() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PermissionSetting();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_Space_PermissionSetting_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_Space_PermissionSetting_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.Space.PermissionSetting.class,
              com.google.chat.v1.Space.PermissionSetting.Builder.class);
    }

    public static final int MANAGERS_ALLOWED_FIELD_NUMBER = 1;
    private boolean managersAllowed_ = false;

    /**
     *
     *
     * <pre>
     * Optional. Whether spaces managers have this permission.
     * </pre>
     *
     * <code>bool managers_allowed = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The managersAllowed.
     */
    @java.lang.Override
    public boolean getManagersAllowed() {
      return managersAllowed_;
    }

    public static final int MEMBERS_ALLOWED_FIELD_NUMBER = 2;
    private boolean membersAllowed_ = false;

    /**
     *
     *
     * <pre>
     * Optional. Whether non-manager members have this permission.
     * </pre>
     *
     * <code>bool members_allowed = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The membersAllowed.
     */
    @java.lang.Override
    public boolean getMembersAllowed() {
      return membersAllowed_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (managersAllowed_ != false) {
        output.writeBool(1, managersAllowed_);
      }
      if (membersAllowed_ != false) {
        output.writeBool(2, membersAllowed_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (managersAllowed_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, managersAllowed_);
      }
      if (membersAllowed_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, membersAllowed_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.chat.v1.Space.PermissionSetting)) {
        return super.equals(obj);
      }
      com.google.chat.v1.Space.PermissionSetting other =
          (com.google.chat.v1.Space.PermissionSetting) obj;

      if (getManagersAllowed() != other.getManagersAllowed()) return false;
      if (getMembersAllowed() != other.getMembersAllowed()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MANAGERS_ALLOWED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getManagersAllowed());
      hash = (37 * hash) + MEMBERS_ALLOWED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getMembersAllowed());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.chat.v1.Space.PermissionSetting parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.Space.PermissionSetting parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.Space.PermissionSetting parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.Space.PermissionSetting parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.Space.PermissionSetting parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.Space.PermissionSetting parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.Space.PermissionSetting parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.Space.PermissionSetting parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.Space.PermissionSetting parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.Space.PermissionSetting parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.Space.PermissionSetting parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.Space.PermissionSetting parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.chat.v1.Space.PermissionSetting prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Represents a space permission setting.
     * </pre>
     *
     * Protobuf type {@code google.chat.v1.Space.PermissionSetting}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.chat.v1.Space.PermissionSetting)
        com.google.chat.v1.Space.PermissionSettingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.chat.v1.SpaceProto
            .internal_static_google_chat_v1_Space_PermissionSetting_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.chat.v1.SpaceProto
            .internal_static_google_chat_v1_Space_PermissionSetting_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.chat.v1.Space.PermissionSetting.class,
                com.google.chat.v1.Space.PermissionSetting.Builder.class);
      }

      // Construct using com.google.chat.v1.Space.PermissionSetting.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        managersAllowed_ = false;
        membersAllowed_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.chat.v1.SpaceProto
            .internal_static_google_chat_v1_Space_PermissionSetting_descriptor;
      }

      @java.lang.Override
      public com.google.chat.v1.Space.PermissionSetting getDefaultInstanceForType() {
        return com.google.chat.v1.Space.PermissionSetting.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.chat.v1.Space.PermissionSetting build() {
        com.google.chat.v1.Space.PermissionSetting result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.chat.v1.Space.PermissionSetting buildPartial() {
        com.google.chat.v1.Space.PermissionSetting result =
            new com.google.chat.v1.Space.PermissionSetting(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.chat.v1.Space.PermissionSetting result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.managersAllowed_ = managersAllowed_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.membersAllowed_ = membersAllowed_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.chat.v1.Space.PermissionSetting) {
          return mergeFrom((com.google.chat.v1.Space.PermissionSetting) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.chat.v1.Space.PermissionSetting other) {
        if (other == com.google.chat.v1.Space.PermissionSetting.getDefaultInstance()) return this;
        if (other.getManagersAllowed() != false) {
          setManagersAllowed(other.getManagersAllowed());
        }
        if (other.getMembersAllowed() != false) {
          setMembersAllowed(other.getMembersAllowed());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  managersAllowed_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  membersAllowed_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean managersAllowed_;

      /**
       *
       *
       * <pre>
       * Optional. Whether spaces managers have this permission.
       * </pre>
       *
       * <code>bool managers_allowed = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The managersAllowed.
       */
      @java.lang.Override
      public boolean getManagersAllowed() {
        return managersAllowed_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Whether spaces managers have this permission.
       * </pre>
       *
       * <code>bool managers_allowed = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The managersAllowed to set.
       * @return This builder for chaining.
       */
      public Builder setManagersAllowed(boolean value) {

        managersAllowed_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Whether spaces managers have this permission.
       * </pre>
       *
       * <code>bool managers_allowed = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearManagersAllowed() {
        bitField0_ = (bitField0_ & ~0x00000001);
        managersAllowed_ = false;
        onChanged();
        return this;
      }

      private boolean membersAllowed_;

      /**
       *
       *
       * <pre>
       * Optional. Whether non-manager members have this permission.
       * </pre>
       *
       * <code>bool members_allowed = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The membersAllowed.
       */
      @java.lang.Override
      public boolean getMembersAllowed() {
        return membersAllowed_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Whether non-manager members have this permission.
       * </pre>
       *
       * <code>bool members_allowed = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The membersAllowed to set.
       * @return This builder for chaining.
       */
      public Builder setMembersAllowed(boolean value) {

        membersAllowed_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Whether non-manager members have this permission.
       * </pre>
       *
       * <code>bool members_allowed = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMembersAllowed() {
        bitField0_ = (bitField0_ & ~0x00000002);
        membersAllowed_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.chat.v1.Space.PermissionSetting)
    }

    // @@protoc_insertion_point(class_scope:google.chat.v1.Space.PermissionSetting)
    private static final com.google.chat.v1.Space.PermissionSetting DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.chat.v1.Space.PermissionSetting();
    }

    public static com.google.chat.v1.Space.PermissionSetting getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PermissionSetting> PARSER =
        new com.google.protobuf.AbstractParser<PermissionSetting>() {
          @java.lang.Override
          public PermissionSetting parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PermissionSetting> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PermissionSetting> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.chat.v1.Space.PermissionSetting getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int spacePermissionSettingsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object spacePermissionSettings_;

  public enum SpacePermissionSettingsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PREDEFINED_PERMISSION_SETTINGS(26),
    PERMISSION_SETTINGS(27),
    SPACEPERMISSIONSETTINGS_NOT_SET(0);
    private final int value;

    private SpacePermissionSettingsCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SpacePermissionSettingsCase valueOf(int value) {
      return forNumber(value);
    }

    public static SpacePermissionSettingsCase forNumber(int value) {
      switch (value) {
        case 26:
          return PREDEFINED_PERMISSION_SETTINGS;
        case 27:
          return PERMISSION_SETTINGS;
        case 0:
          return SPACEPERMISSIONSETTINGS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SpacePermissionSettingsCase getSpacePermissionSettingsCase() {
    return SpacePermissionSettingsCase.forNumber(spacePermissionSettingsCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Identifier. Resource name of the space.
   *
   * Format: `spaces/{space}`
   *
   * Where `{space}` represents the system-assigned ID for the space. You can
   * obtain the space ID by calling the
   * [`spaces.list()`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/list)
   * method or from the space URL. For example, if the space URL
   * is `https://mail.google.com/mail/u/0/#chat/space/AAAAAAAAA`, the space ID
   * is `AAAAAAAAA`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Identifier. Resource name of the space.
   *
   * Format: `spaces/{space}`
   *
   * Where `{space}` represents the system-assigned ID for the space. You can
   * obtain the space ID by calling the
   * [`spaces.list()`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/list)
   * method or from the space URL. For example, if the space URL
   * is `https://mail.google.com/mail/u/0/#chat/space/AAAAAAAAA`, the space ID
   * is `AAAAAAAAA`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;
  private int type_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. Deprecated: Use `space_type` instead.
   * The type of a space.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.chat.v1.Space.type is deprecated. See google/chat/v1/space.proto;l=256
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getTypeValue() {
    return type_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Deprecated: Use `space_type` instead.
   * The type of a space.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.chat.v1.Space.type is deprecated. See google/chat/v1/space.proto;l=256
   * @return The type.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.chat.v1.Space.Type getType() {
    com.google.chat.v1.Space.Type result = com.google.chat.v1.Space.Type.forNumber(type_);
    return result == null ? com.google.chat.v1.Space.Type.UNRECOGNIZED : result;
  }

  public static final int SPACE_TYPE_FIELD_NUMBER = 10;
  private int spaceType_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. The type of space. Required when creating a space or updating the
   * space type of a space. Output only for other usage.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.SpaceType space_type = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for spaceType.
   */
  @java.lang.Override
  public int getSpaceTypeValue() {
    return spaceType_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The type of space. Required when creating a space or updating the
   * space type of a space. Output only for other usage.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.SpaceType space_type = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The spaceType.
   */
  @java.lang.Override
  public com.google.chat.v1.Space.SpaceType getSpaceType() {
    com.google.chat.v1.Space.SpaceType result =
        com.google.chat.v1.Space.SpaceType.forNumber(spaceType_);
    return result == null ? com.google.chat.v1.Space.SpaceType.UNRECOGNIZED : result;
  }

  public static final int SINGLE_USER_BOT_DM_FIELD_NUMBER = 4;
  private boolean singleUserBotDm_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Whether the space is a DM between a Chat app and a single
   * human.
   * </pre>
   *
   * <code>bool single_user_bot_dm = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The singleUserBotDm.
   */
  @java.lang.Override
  public boolean getSingleUserBotDm() {
    return singleUserBotDm_;
  }

  public static final int THREADED_FIELD_NUMBER = 5;
  private boolean threaded_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Deprecated: Use `spaceThreadingState` instead.
   * Whether messages are threaded in this space.
   * </pre>
   *
   * <code>bool threaded = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @deprecated google.chat.v1.Space.threaded is deprecated. See google/chat/v1/space.proto;l=268
   * @return The threaded.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean getThreaded() {
    return threaded_;
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The space's display name. Required when [creating a
   * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create)
   * with a `spaceType` of `SPACE`. If you receive the error message
   * `ALREADY_EXISTS` when creating a space or updating the `displayName`, try a
   * different `displayName`. An existing space within the Google Workspace
   * organization might already use this display name.
   *
   * For direct messages, this field might be empty.
   *
   * Supports up to 128 characters.
   * </pre>
   *
   * <code>string display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The space's display name. Required when [creating a
   * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create)
   * with a `spaceType` of `SPACE`. If you receive the error message
   * `ALREADY_EXISTS` when creating a space or updating the `displayName`, try a
   * different `displayName`. An existing space within the Google Workspace
   * organization might already use this display name.
   *
   * For direct messages, this field might be empty.
   *
   * Supports up to 128 characters.
   * </pre>
   *
   * <code>string display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXTERNAL_USER_ALLOWED_FIELD_NUMBER = 8;
  private boolean externalUserAllowed_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Immutable. Whether this space permits any Google Chat user as a
   * member. Input when creating a space in a Google Workspace organization.
   * Omit this field when creating spaces in the following conditions:
   *
   *   * The authenticated user uses a consumer account (unmanaged user
   *     account). By default, a space created by a consumer account permits any
   *     Google Chat user.
   *
   * For existing spaces, this field is output only.
   * </pre>
   *
   * <code>
   * bool external_user_allowed = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The externalUserAllowed.
   */
  @java.lang.Override
  public boolean getExternalUserAllowed() {
    return externalUserAllowed_;
  }

  public static final int SPACE_THREADING_STATE_FIELD_NUMBER = 9;
  private int spaceThreadingState_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. The threading state in the Chat space.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for spaceThreadingState.
   */
  @java.lang.Override
  public int getSpaceThreadingStateValue() {
    return spaceThreadingState_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The threading state in the Chat space.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The spaceThreadingState.
   */
  @java.lang.Override
  public com.google.chat.v1.Space.SpaceThreadingState getSpaceThreadingState() {
    com.google.chat.v1.Space.SpaceThreadingState result =
        com.google.chat.v1.Space.SpaceThreadingState.forNumber(spaceThreadingState_);
    return result == null ? com.google.chat.v1.Space.SpaceThreadingState.UNRECOGNIZED : result;
  }

  public static final int SPACE_DETAILS_FIELD_NUMBER = 11;
  private com.google.chat.v1.Space.SpaceDetails spaceDetails_;

  /**
   *
   *
   * <pre>
   * Optional. Details about the space including description and rules.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.SpaceDetails space_details = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the spaceDetails field is set.
   */
  @java.lang.Override
  public boolean hasSpaceDetails() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Details about the space including description and rules.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.SpaceDetails space_details = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The spaceDetails.
   */
  @java.lang.Override
  public com.google.chat.v1.Space.SpaceDetails getSpaceDetails() {
    return spaceDetails_ == null
        ? com.google.chat.v1.Space.SpaceDetails.getDefaultInstance()
        : spaceDetails_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Details about the space including description and rules.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.SpaceDetails space_details = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.Space.SpaceDetailsOrBuilder getSpaceDetailsOrBuilder() {
    return spaceDetails_ == null
        ? com.google.chat.v1.Space.SpaceDetails.getDefaultInstance()
        : spaceDetails_;
  }

  public static final int SPACE_HISTORY_STATE_FIELD_NUMBER = 13;
  private int spaceHistoryState_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. The message history state for messages and threads in this space.
   * </pre>
   *
   * <code>
   * .google.chat.v1.HistoryState space_history_state = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for spaceHistoryState.
   */
  @java.lang.Override
  public int getSpaceHistoryStateValue() {
    return spaceHistoryState_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The message history state for messages and threads in this space.
   * </pre>
   *
   * <code>
   * .google.chat.v1.HistoryState space_history_state = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The spaceHistoryState.
   */
  @java.lang.Override
  public com.google.chat.v1.HistoryState getSpaceHistoryState() {
    com.google.chat.v1.HistoryState result =
        com.google.chat.v1.HistoryState.forNumber(spaceHistoryState_);
    return result == null ? com.google.chat.v1.HistoryState.UNRECOGNIZED : result;
  }

  public static final int IMPORT_MODE_FIELD_NUMBER = 16;
  private boolean importMode_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Whether this space is created in `Import Mode` as part of a data
   * migration into Google Workspace. While spaces are being imported, they
   * aren't visible to users until the import is complete.
   *
   * Creating a space in `Import Mode`requires [user
   * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
   * </pre>
   *
   * <code>bool import_mode = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The importMode.
   */
  @java.lang.Override
  public boolean getImportMode() {
    return importMode_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 17;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Optional. Immutable. For spaces created in Chat, the time the space was
   * created. This field is output only, except when used in import mode spaces.
   *
   * For import mode spaces, set this field to the historical timestamp at which
   * the space was created in the source in order to preserve the original
   * creation time.
   *
   * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. For spaces created in Chat, the time the space was
   * created. This field is output only, except when used in import mode spaces.
   *
   * For import mode spaces, set this field to the historical timestamp at which
   * the space was created in the source in order to preserve the original
   * creation time.
   *
   * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. For spaces created in Chat, the time the space was
   * created. This field is output only, except when used in import mode spaces.
   *
   * For import mode spaces, set this field to the historical timestamp at which
   * the space was created in the source in order to preserve the original
   * creation time.
   *
   * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int LAST_ACTIVE_TIME_FIELD_NUMBER = 18;
  private com.google.protobuf.Timestamp lastActiveTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp of the last message in the space.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_active_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastActiveTime field is set.
   */
  @java.lang.Override
  public boolean hasLastActiveTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp of the last message in the space.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_active_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastActiveTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastActiveTime() {
    return lastActiveTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastActiveTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp of the last message in the space.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_active_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastActiveTimeOrBuilder() {
    return lastActiveTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastActiveTime_;
  }

  public static final int ADMIN_INSTALLED_FIELD_NUMBER = 19;
  private boolean adminInstalled_ = false;

  /**
   *
   *
   * <pre>
   * Output only. For direct message (DM) spaces with a Chat app, whether the
   * space was created by a Google Workspace administrator. Administrators can
   * install and set up a direct message with a Chat app on behalf of users in
   * their organization.
   *
   * To support admin install, your Chat app must feature direct messaging.
   * </pre>
   *
   * <code>bool admin_installed = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The adminInstalled.
   */
  @java.lang.Override
  public boolean getAdminInstalled() {
    return adminInstalled_;
  }

  public static final int MEMBERSHIP_COUNT_FIELD_NUMBER = 20;
  private com.google.chat.v1.Space.MembershipCount membershipCount_;

  /**
   *
   *
   * <pre>
   * Output only. The count of joined memberships grouped by member type.
   * Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
   * `GROUP_CHAT`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.MembershipCount membership_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the membershipCount field is set.
   */
  @java.lang.Override
  public boolean hasMembershipCount() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The count of joined memberships grouped by member type.
   * Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
   * `GROUP_CHAT`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.MembershipCount membership_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The membershipCount.
   */
  @java.lang.Override
  public com.google.chat.v1.Space.MembershipCount getMembershipCount() {
    return membershipCount_ == null
        ? com.google.chat.v1.Space.MembershipCount.getDefaultInstance()
        : membershipCount_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The count of joined memberships grouped by member type.
   * Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
   * `GROUP_CHAT`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.MembershipCount membership_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.Space.MembershipCountOrBuilder getMembershipCountOrBuilder() {
    return membershipCount_ == null
        ? com.google.chat.v1.Space.MembershipCount.getDefaultInstance()
        : membershipCount_;
  }

  public static final int ACCESS_SETTINGS_FIELD_NUMBER = 23;
  private com.google.chat.v1.Space.AccessSettings accessSettings_;

  /**
   *
   *
   * <pre>
   * Optional. Specifies the [access
   * setting](https://support.google.com/chat/answer/11971020) of the space.
   * Only populated when the `space_type` is `SPACE`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the accessSettings field is set.
   */
  @java.lang.Override
  public boolean hasAccessSettings() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Specifies the [access
   * setting](https://support.google.com/chat/answer/11971020) of the space.
   * Only populated when the `space_type` is `SPACE`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The accessSettings.
   */
  @java.lang.Override
  public com.google.chat.v1.Space.AccessSettings getAccessSettings() {
    return accessSettings_ == null
        ? com.google.chat.v1.Space.AccessSettings.getDefaultInstance()
        : accessSettings_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Specifies the [access
   * setting](https://support.google.com/chat/answer/11971020) of the space.
   * Only populated when the `space_type` is `SPACE`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.Space.AccessSettingsOrBuilder getAccessSettingsOrBuilder() {
    return accessSettings_ == null
        ? com.google.chat.v1.Space.AccessSettings.getDefaultInstance()
        : accessSettings_;
  }

  public static final int SPACE_URI_FIELD_NUMBER = 25;

  @SuppressWarnings("serial")
  private volatile java.lang.Object spaceUri_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The URI for a user to access the space.
   * </pre>
   *
   * <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The spaceUri.
   */
  @java.lang.Override
  public java.lang.String getSpaceUri() {
    java.lang.Object ref = spaceUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      spaceUri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The URI for a user to access the space.
   * </pre>
   *
   * <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for spaceUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSpaceUriBytes() {
    java.lang.Object ref = spaceUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      spaceUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREDEFINED_PERMISSION_SETTINGS_FIELD_NUMBER = 26;

  /**
   *
   *
   * <pre>
   * Optional. Input only. Predefined space permission settings, input only
   * when creating a space. If the field is not set, a collaboration space is
   * created. After you create the space, settings are populated in the
   * `PermissionSettings` field.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.PredefinedPermissionSettings predefined_permission_settings = 26 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the predefinedPermissionSettings field is set.
   */
  public boolean hasPredefinedPermissionSettings() {
    return spacePermissionSettingsCase_ == 26;
  }

  /**
   *
   *
   * <pre>
   * Optional. Input only. Predefined space permission settings, input only
   * when creating a space. If the field is not set, a collaboration space is
   * created. After you create the space, settings are populated in the
   * `PermissionSettings` field.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.PredefinedPermissionSettings predefined_permission_settings = 26 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for predefinedPermissionSettings.
   */
  public int getPredefinedPermissionSettingsValue() {
    if (spacePermissionSettingsCase_ == 26) {
      return (java.lang.Integer) spacePermissionSettings_;
    }
    return 0;
  }

  /**
   *
   *
   * <pre>
   * Optional. Input only. Predefined space permission settings, input only
   * when creating a space. If the field is not set, a collaboration space is
   * created. After you create the space, settings are populated in the
   * `PermissionSettings` field.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.PredefinedPermissionSettings predefined_permission_settings = 26 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The predefinedPermissionSettings.
   */
  public com.google.chat.v1.Space.PredefinedPermissionSettings getPredefinedPermissionSettings() {
    if (spacePermissionSettingsCase_ == 26) {
      com.google.chat.v1.Space.PredefinedPermissionSettings result =
          com.google.chat.v1.Space.PredefinedPermissionSettings.forNumber(
              (java.lang.Integer) spacePermissionSettings_);
      return result == null
          ? com.google.chat.v1.Space.PredefinedPermissionSettings.UNRECOGNIZED
          : result;
    }
    return com.google.chat.v1.Space.PredefinedPermissionSettings
        .PREDEFINED_PERMISSION_SETTINGS_UNSPECIFIED;
  }

  public static final int PERMISSION_SETTINGS_FIELD_NUMBER = 27;

  /**
   *
   *
   * <pre>
   * Optional. Space permission settings for existing spaces. Input for
   * updating exact space permission settings, where existing permission
   * settings are replaced. Output lists current permission settings.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.PermissionSettings permission_settings = 27 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the permissionSettings field is set.
   */
  @java.lang.Override
  public boolean hasPermissionSettings() {
    return spacePermissionSettingsCase_ == 27;
  }

  /**
   *
   *
   * <pre>
   * Optional. Space permission settings for existing spaces. Input for
   * updating exact space permission settings, where existing permission
   * settings are replaced. Output lists current permission settings.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.PermissionSettings permission_settings = 27 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The permissionSettings.
   */
  @java.lang.Override
  public com.google.chat.v1.Space.PermissionSettings getPermissionSettings() {
    if (spacePermissionSettingsCase_ == 27) {
      return (com.google.chat.v1.Space.PermissionSettings) spacePermissionSettings_;
    }
    return com.google.chat.v1.Space.PermissionSettings.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. Space permission settings for existing spaces. Input for
   * updating exact space permission settings, where existing permission
   * settings are replaced. Output lists current permission settings.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.PermissionSettings permission_settings = 27 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.Space.PermissionSettingsOrBuilder getPermissionSettingsOrBuilder() {
    if (spacePermissionSettingsCase_ == 27) {
      return (com.google.chat.v1.Space.PermissionSettings) spacePermissionSettings_;
    }
    return com.google.chat.v1.Space.PermissionSettings.getDefaultInstance();
  }

  public static final int IMPORT_MODE_EXPIRE_TIME_FIELD_NUMBER = 28;
  private com.google.protobuf.Timestamp importModeExpireTime_;

  /**
   *
   *
   * <pre>
   * Output only. The time when the space will be automatically deleted by the
   * system if it remains in import mode.
   *
   * Each space created in import mode must exit this mode before this expire
   * time using `spaces.completeImport`.
   *
   * This field is only populated for spaces that were created with import mode.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp import_mode_expire_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the importModeExpireTime field is set.
   */
  @java.lang.Override
  public boolean hasImportModeExpireTime() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The time when the space will be automatically deleted by the
   * system if it remains in import mode.
   *
   * Each space created in import mode must exit this mode before this expire
   * time using `spaces.completeImport`.
   *
   * This field is only populated for spaces that were created with import mode.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp import_mode_expire_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The importModeExpireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getImportModeExpireTime() {
    return importModeExpireTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : importModeExpireTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The time when the space will be automatically deleted by the
   * system if it remains in import mode.
   *
   * Each space created in import mode must exit this mode before this expire
   * time using `spaces.completeImport`.
   *
   * This field is only populated for spaces that were created with import mode.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp import_mode_expire_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getImportModeExpireTimeOrBuilder() {
    return importModeExpireTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : importModeExpireTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (type_ != com.google.chat.v1.Space.Type.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
    }
    if (singleUserBotDm_ != false) {
      output.writeBool(4, singleUserBotDm_);
    }
    if (threaded_ != false) {
      output.writeBool(5, threaded_);
    }
    if (externalUserAllowed_ != false) {
      output.writeBool(8, externalUserAllowed_);
    }
    if (spaceThreadingState_
        != com.google.chat.v1.Space.SpaceThreadingState.SPACE_THREADING_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(9, spaceThreadingState_);
    }
    if (spaceType_ != com.google.chat.v1.Space.SpaceType.SPACE_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(10, spaceType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(11, getSpaceDetails());
    }
    if (spaceHistoryState_
        != com.google.chat.v1.HistoryState.HISTORY_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(13, spaceHistoryState_);
    }
    if (importMode_ != false) {
      output.writeBool(16, importMode_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(17, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(18, getLastActiveTime());
    }
    if (adminInstalled_ != false) {
      output.writeBool(19, adminInstalled_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(20, getMembershipCount());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(23, getAccessSettings());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(spaceUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 25, spaceUri_);
    }
    if (spacePermissionSettingsCase_ == 26) {
      output.writeEnum(26, ((java.lang.Integer) spacePermissionSettings_));
    }
    if (spacePermissionSettingsCase_ == 27) {
      output.writeMessage(
          27, (com.google.chat.v1.Space.PermissionSettings) spacePermissionSettings_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(28, getImportModeExpireTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (type_ != com.google.chat.v1.Space.Type.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
    }
    if (singleUserBotDm_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, singleUserBotDm_);
    }
    if (threaded_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, threaded_);
    }
    if (externalUserAllowed_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, externalUserAllowed_);
    }
    if (spaceThreadingState_
        != com.google.chat.v1.Space.SpaceThreadingState.SPACE_THREADING_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, spaceThreadingState_);
    }
    if (spaceType_ != com.google.chat.v1.Space.SpaceType.SPACE_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, spaceType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getSpaceDetails());
    }
    if (spaceHistoryState_
        != com.google.chat.v1.HistoryState.HISTORY_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(13, spaceHistoryState_);
    }
    if (importMode_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(16, importMode_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getLastActiveTime());
    }
    if (adminInstalled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(19, adminInstalled_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getMembershipCount());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getAccessSettings());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(spaceUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(25, spaceUri_);
    }
    if (spacePermissionSettingsCase_ == 26) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(
              26, ((java.lang.Integer) spacePermissionSettings_));
    }
    if (spacePermissionSettingsCase_ == 27) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              27, (com.google.chat.v1.Space.PermissionSettings) spacePermissionSettings_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(28, getImportModeExpireTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.Space)) {
      return super.equals(obj);
    }
    com.google.chat.v1.Space other = (com.google.chat.v1.Space) obj;

    if (!getName().equals(other.getName())) return false;
    if (type_ != other.type_) return false;
    if (spaceType_ != other.spaceType_) return false;
    if (getSingleUserBotDm() != other.getSingleUserBotDm()) return false;
    if (getThreaded() != other.getThreaded()) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (getExternalUserAllowed() != other.getExternalUserAllowed()) return false;
    if (spaceThreadingState_ != other.spaceThreadingState_) return false;
    if (hasSpaceDetails() != other.hasSpaceDetails()) return false;
    if (hasSpaceDetails()) {
      if (!getSpaceDetails().equals(other.getSpaceDetails())) return false;
    }
    if (spaceHistoryState_ != other.spaceHistoryState_) return false;
    if (getImportMode() != other.getImportMode()) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasLastActiveTime() != other.hasLastActiveTime()) return false;
    if (hasLastActiveTime()) {
      if (!getLastActiveTime().equals(other.getLastActiveTime())) return false;
    }
    if (getAdminInstalled() != other.getAdminInstalled()) return false;
    if (hasMembershipCount() != other.hasMembershipCount()) return false;
    if (hasMembershipCount()) {
      if (!getMembershipCount().equals(other.getMembershipCount())) return false;
    }
    if (hasAccessSettings() != other.hasAccessSettings()) return false;
    if (hasAccessSettings()) {
      if (!getAccessSettings().equals(other.getAccessSettings())) return false;
    }
    if (!getSpaceUri().equals(other.getSpaceUri())) return false;
    if (hasImportModeExpireTime() != other.hasImportModeExpireTime()) return false;
    if (hasImportModeExpireTime()) {
      if (!getImportModeExpireTime().equals(other.getImportModeExpireTime())) return false;
    }
    if (!getSpacePermissionSettingsCase().equals(other.getSpacePermissionSettingsCase()))
      return false;
    switch (spacePermissionSettingsCase_) {
      case 26:
        if (getPredefinedPermissionSettingsValue() != other.getPredefinedPermissionSettingsValue())
          return false;
        break;
      case 27:
        if (!getPermissionSettings().equals(other.getPermissionSettings())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + SPACE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + spaceType_;
    hash = (37 * hash) + SINGLE_USER_BOT_DM_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSingleUserBotDm());
    hash = (37 * hash) + THREADED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getThreaded());
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + EXTERNAL_USER_ALLOWED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExternalUserAllowed());
    hash = (37 * hash) + SPACE_THREADING_STATE_FIELD_NUMBER;
    hash = (53 * hash) + spaceThreadingState_;
    if (hasSpaceDetails()) {
      hash = (37 * hash) + SPACE_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getSpaceDetails().hashCode();
    }
    hash = (37 * hash) + SPACE_HISTORY_STATE_FIELD_NUMBER;
    hash = (53 * hash) + spaceHistoryState_;
    hash = (37 * hash) + IMPORT_MODE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getImportMode());
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasLastActiveTime()) {
      hash = (37 * hash) + LAST_ACTIVE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastActiveTime().hashCode();
    }
    hash = (37 * hash) + ADMIN_INSTALLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAdminInstalled());
    if (hasMembershipCount()) {
      hash = (37 * hash) + MEMBERSHIP_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getMembershipCount().hashCode();
    }
    if (hasAccessSettings()) {
      hash = (37 * hash) + ACCESS_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getAccessSettings().hashCode();
    }
    hash = (37 * hash) + SPACE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getSpaceUri().hashCode();
    if (hasImportModeExpireTime()) {
      hash = (37 * hash) + IMPORT_MODE_EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getImportModeExpireTime().hashCode();
    }
    switch (spacePermissionSettingsCase_) {
      case 26:
        hash = (37 * hash) + PREDEFINED_PERMISSION_SETTINGS_FIELD_NUMBER;
        hash = (53 * hash) + getPredefinedPermissionSettingsValue();
        break;
      case 27:
        hash = (37 * hash) + PERMISSION_SETTINGS_FIELD_NUMBER;
        hash = (53 * hash) + getPermissionSettings().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.Space parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.Space parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.Space parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.Space parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.Space parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.Space parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.Space parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.Space parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.Space parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.Space parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.Space parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.Space parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.Space prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A space in Google Chat. Spaces are conversations between two or more users
   * or 1:1 messages between a user and a Chat app.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.Space}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.Space)
      com.google.chat.v1.SpaceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.SpaceProto.internal_static_google_chat_v1_Space_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.SpaceProto.internal_static_google_chat_v1_Space_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.Space.class, com.google.chat.v1.Space.Builder.class);
    }

    // Construct using com.google.chat.v1.Space.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSpaceDetailsFieldBuilder();
        getCreateTimeFieldBuilder();
        getLastActiveTimeFieldBuilder();
        getMembershipCountFieldBuilder();
        getAccessSettingsFieldBuilder();
        getImportModeExpireTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      type_ = 0;
      spaceType_ = 0;
      singleUserBotDm_ = false;
      threaded_ = false;
      displayName_ = "";
      externalUserAllowed_ = false;
      spaceThreadingState_ = 0;
      spaceDetails_ = null;
      if (spaceDetailsBuilder_ != null) {
        spaceDetailsBuilder_.dispose();
        spaceDetailsBuilder_ = null;
      }
      spaceHistoryState_ = 0;
      importMode_ = false;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      lastActiveTime_ = null;
      if (lastActiveTimeBuilder_ != null) {
        lastActiveTimeBuilder_.dispose();
        lastActiveTimeBuilder_ = null;
      }
      adminInstalled_ = false;
      membershipCount_ = null;
      if (membershipCountBuilder_ != null) {
        membershipCountBuilder_.dispose();
        membershipCountBuilder_ = null;
      }
      accessSettings_ = null;
      if (accessSettingsBuilder_ != null) {
        accessSettingsBuilder_.dispose();
        accessSettingsBuilder_ = null;
      }
      spaceUri_ = "";
      if (permissionSettingsBuilder_ != null) {
        permissionSettingsBuilder_.clear();
      }
      importModeExpireTime_ = null;
      if (importModeExpireTimeBuilder_ != null) {
        importModeExpireTimeBuilder_.dispose();
        importModeExpireTimeBuilder_ = null;
      }
      spacePermissionSettingsCase_ = 0;
      spacePermissionSettings_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.SpaceProto.internal_static_google_chat_v1_Space_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.Space getDefaultInstanceForType() {
      return com.google.chat.v1.Space.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.Space build() {
      com.google.chat.v1.Space result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.Space buildPartial() {
      com.google.chat.v1.Space result = new com.google.chat.v1.Space(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.chat.v1.Space result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.spaceType_ = spaceType_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.singleUserBotDm_ = singleUserBotDm_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.threaded_ = threaded_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.externalUserAllowed_ = externalUserAllowed_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.spaceThreadingState_ = spaceThreadingState_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.spaceDetails_ =
            spaceDetailsBuilder_ == null ? spaceDetails_ : spaceDetailsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.spaceHistoryState_ = spaceHistoryState_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.importMode_ = importMode_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.lastActiveTime_ =
            lastActiveTimeBuilder_ == null ? lastActiveTime_ : lastActiveTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.adminInstalled_ = adminInstalled_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.membershipCount_ =
            membershipCountBuilder_ == null ? membershipCount_ : membershipCountBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.accessSettings_ =
            accessSettingsBuilder_ == null ? accessSettings_ : accessSettingsBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.spaceUri_ = spaceUri_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.importModeExpireTime_ =
            importModeExpireTimeBuilder_ == null
                ? importModeExpireTime_
                : importModeExpireTimeBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.chat.v1.Space result) {
      result.spacePermissionSettingsCase_ = spacePermissionSettingsCase_;
      result.spacePermissionSettings_ = this.spacePermissionSettings_;
      if (spacePermissionSettingsCase_ == 27 && permissionSettingsBuilder_ != null) {
        result.spacePermissionSettings_ = permissionSettingsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.Space) {
        return mergeFrom((com.google.chat.v1.Space) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.Space other) {
      if (other == com.google.chat.v1.Space.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.spaceType_ != 0) {
        setSpaceTypeValue(other.getSpaceTypeValue());
      }
      if (other.getSingleUserBotDm() != false) {
        setSingleUserBotDm(other.getSingleUserBotDm());
      }
      if (other.getThreaded() != false) {
        setThreaded(other.getThreaded());
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.getExternalUserAllowed() != false) {
        setExternalUserAllowed(other.getExternalUserAllowed());
      }
      if (other.spaceThreadingState_ != 0) {
        setSpaceThreadingStateValue(other.getSpaceThreadingStateValue());
      }
      if (other.hasSpaceDetails()) {
        mergeSpaceDetails(other.getSpaceDetails());
      }
      if (other.spaceHistoryState_ != 0) {
        setSpaceHistoryStateValue(other.getSpaceHistoryStateValue());
      }
      if (other.getImportMode() != false) {
        setImportMode(other.getImportMode());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasLastActiveTime()) {
        mergeLastActiveTime(other.getLastActiveTime());
      }
      if (other.getAdminInstalled() != false) {
        setAdminInstalled(other.getAdminInstalled());
      }
      if (other.hasMembershipCount()) {
        mergeMembershipCount(other.getMembershipCount());
      }
      if (other.hasAccessSettings()) {
        mergeAccessSettings(other.getAccessSettings());
      }
      if (!other.getSpaceUri().isEmpty()) {
        spaceUri_ = other.spaceUri_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (other.hasImportModeExpireTime()) {
        mergeImportModeExpireTime(other.getImportModeExpireTime());
      }
      switch (other.getSpacePermissionSettingsCase()) {
        case PREDEFINED_PERMISSION_SETTINGS:
          {
            setPredefinedPermissionSettingsValue(other.getPredefinedPermissionSettingsValue());
            break;
          }
        case PERMISSION_SETTINGS:
          {
            mergePermissionSettings(other.getPermissionSettings());
            break;
          }
        case SPACEPERMISSIONSETTINGS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 26
            case 32:
              {
                singleUserBotDm_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                threaded_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 64:
              {
                externalUserAllowed_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 64
            case 72:
              {
                spaceThreadingState_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 72
            case 80:
              {
                spaceType_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 80
            case 90:
              {
                input.readMessage(getSpaceDetailsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 90
            case 104:
              {
                spaceHistoryState_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 104
            case 128:
              {
                importMode_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 128
            case 138:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(getLastActiveTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 146
            case 152:
              {
                adminInstalled_ = input.readBool();
                bitField0_ |= 0x00002000;
                break;
              } // case 152
            case 162:
              {
                input.readMessage(getMembershipCountFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 162
            case 186:
              {
                input.readMessage(getAccessSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 186
            case 202:
              {
                spaceUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 202
            case 208:
              {
                int rawValue = input.readEnum();
                spacePermissionSettingsCase_ = 26;
                spacePermissionSettings_ = rawValue;
                break;
              } // case 208
            case 218:
              {
                input.readMessage(
                    getPermissionSettingsFieldBuilder().getBuilder(), extensionRegistry);
                spacePermissionSettingsCase_ = 27;
                break;
              } // case 218
            case 226:
              {
                input.readMessage(
                    getImportModeExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 226
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int spacePermissionSettingsCase_ = 0;
    private java.lang.Object spacePermissionSettings_;

    public SpacePermissionSettingsCase getSpacePermissionSettingsCase() {
      return SpacePermissionSettingsCase.forNumber(spacePermissionSettingsCase_);
    }

    public Builder clearSpacePermissionSettings() {
      spacePermissionSettingsCase_ = 0;
      spacePermissionSettings_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Identifier. Resource name of the space.
     *
     * Format: `spaces/{space}`
     *
     * Where `{space}` represents the system-assigned ID for the space. You can
     * obtain the space ID by calling the
     * [`spaces.list()`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/list)
     * method or from the space URL. For example, if the space URL
     * is `https://mail.google.com/mail/u/0/#chat/space/AAAAAAAAA`, the space ID
     * is `AAAAAAAAA`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. Resource name of the space.
     *
     * Format: `spaces/{space}`
     *
     * Where `{space}` represents the system-assigned ID for the space. You can
     * obtain the space ID by calling the
     * [`spaces.list()`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/list)
     * method or from the space URL. For example, if the space URL
     * is `https://mail.google.com/mail/u/0/#chat/space/AAAAAAAAA`, the space ID
     * is `AAAAAAAAA`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. Resource name of the space.
     *
     * Format: `spaces/{space}`
     *
     * Where `{space}` represents the system-assigned ID for the space. You can
     * obtain the space ID by calling the
     * [`spaces.list()`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/list)
     * method or from the space URL. For example, if the space URL
     * is `https://mail.google.com/mail/u/0/#chat/space/AAAAAAAAA`, the space ID
     * is `AAAAAAAAA`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. Resource name of the space.
     *
     * Format: `spaces/{space}`
     *
     * Where `{space}` represents the system-assigned ID for the space. You can
     * obtain the space ID by calling the
     * [`spaces.list()`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/list)
     * method or from the space URL. For example, if the space URL
     * is `https://mail.google.com/mail/u/0/#chat/space/AAAAAAAAA`, the space ID
     * is `AAAAAAAAA`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. Resource name of the space.
     *
     * Format: `spaces/{space}`
     *
     * Where `{space}` represents the system-assigned ID for the space. You can
     * obtain the space ID by calling the
     * [`spaces.list()`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/list)
     * method or from the space URL. For example, if the space URL
     * is `https://mail.google.com/mail/u/0/#chat/space/AAAAAAAAA`, the space ID
     * is `AAAAAAAAA`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int type_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. Deprecated: Use `space_type` instead.
     * The type of a space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.chat.v1.Space.type is deprecated. See google/chat/v1/space.proto;l=256
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getTypeValue() {
      return type_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Deprecated: Use `space_type` instead.
     * The type of a space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.chat.v1.Space.type is deprecated. See google/chat/v1/space.proto;l=256
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Deprecated: Use `space_type` instead.
     * The type of a space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.chat.v1.Space.type is deprecated. See google/chat/v1/space.proto;l=256
     * @return The type.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.chat.v1.Space.Type getType() {
      com.google.chat.v1.Space.Type result = com.google.chat.v1.Space.Type.forNumber(type_);
      return result == null ? com.google.chat.v1.Space.Type.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. Deprecated: Use `space_type` instead.
     * The type of a space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.chat.v1.Space.type is deprecated. See google/chat/v1/space.proto;l=256
     * @param value The type to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setType(com.google.chat.v1.Space.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      type_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Deprecated: Use `space_type` instead.
     * The type of a space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.chat.v1.Space.type is deprecated. See google/chat/v1/space.proto;l=256
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      type_ = 0;
      onChanged();
      return this;
    }

    private int spaceType_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. The type of space. Required when creating a space or updating the
     * space type of a space. Output only for other usage.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceType space_type = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for spaceType.
     */
    @java.lang.Override
    public int getSpaceTypeValue() {
      return spaceType_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The type of space. Required when creating a space or updating the
     * space type of a space. Output only for other usage.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceType space_type = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for spaceType to set.
     * @return This builder for chaining.
     */
    public Builder setSpaceTypeValue(int value) {
      spaceType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The type of space. Required when creating a space or updating the
     * space type of a space. Output only for other usage.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceType space_type = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The spaceType.
     */
    @java.lang.Override
    public com.google.chat.v1.Space.SpaceType getSpaceType() {
      com.google.chat.v1.Space.SpaceType result =
          com.google.chat.v1.Space.SpaceType.forNumber(spaceType_);
      return result == null ? com.google.chat.v1.Space.SpaceType.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. The type of space. Required when creating a space or updating the
     * space type of a space. Output only for other usage.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceType space_type = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The spaceType to set.
     * @return This builder for chaining.
     */
    public Builder setSpaceType(com.google.chat.v1.Space.SpaceType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      spaceType_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The type of space. Required when creating a space or updating the
     * space type of a space. Output only for other usage.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceType space_type = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpaceType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      spaceType_ = 0;
      onChanged();
      return this;
    }

    private boolean singleUserBotDm_;

    /**
     *
     *
     * <pre>
     * Optional. Whether the space is a DM between a Chat app and a single
     * human.
     * </pre>
     *
     * <code>bool single_user_bot_dm = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The singleUserBotDm.
     */
    @java.lang.Override
    public boolean getSingleUserBotDm() {
      return singleUserBotDm_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether the space is a DM between a Chat app and a single
     * human.
     * </pre>
     *
     * <code>bool single_user_bot_dm = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The singleUserBotDm to set.
     * @return This builder for chaining.
     */
    public Builder setSingleUserBotDm(boolean value) {

      singleUserBotDm_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether the space is a DM between a Chat app and a single
     * human.
     * </pre>
     *
     * <code>bool single_user_bot_dm = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSingleUserBotDm() {
      bitField0_ = (bitField0_ & ~0x00000008);
      singleUserBotDm_ = false;
      onChanged();
      return this;
    }

    private boolean threaded_;

    /**
     *
     *
     * <pre>
     * Output only. Deprecated: Use `spaceThreadingState` instead.
     * Whether messages are threaded in this space.
     * </pre>
     *
     * <code>bool threaded = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.chat.v1.Space.threaded is deprecated. See google/chat/v1/space.proto;l=268
     * @return The threaded.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean getThreaded() {
      return threaded_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Deprecated: Use `spaceThreadingState` instead.
     * Whether messages are threaded in this space.
     * </pre>
     *
     * <code>bool threaded = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.chat.v1.Space.threaded is deprecated. See google/chat/v1/space.proto;l=268
     * @param value The threaded to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setThreaded(boolean value) {

      threaded_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Deprecated: Use `spaceThreadingState` instead.
     * Whether messages are threaded in this space.
     * </pre>
     *
     * <code>bool threaded = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.chat.v1.Space.threaded is deprecated. See google/chat/v1/space.proto;l=268
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearThreaded() {
      bitField0_ = (bitField0_ & ~0x00000010);
      threaded_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The space's display name. Required when [creating a
     * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create)
     * with a `spaceType` of `SPACE`. If you receive the error message
     * `ALREADY_EXISTS` when creating a space or updating the `displayName`, try a
     * different `displayName`. An existing space within the Google Workspace
     * organization might already use this display name.
     *
     * For direct messages, this field might be empty.
     *
     * Supports up to 128 characters.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The space's display name. Required when [creating a
     * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create)
     * with a `spaceType` of `SPACE`. If you receive the error message
     * `ALREADY_EXISTS` when creating a space or updating the `displayName`, try a
     * different `displayName`. An existing space within the Google Workspace
     * organization might already use this display name.
     *
     * For direct messages, this field might be empty.
     *
     * Supports up to 128 characters.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The space's display name. Required when [creating a
     * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create)
     * with a `spaceType` of `SPACE`. If you receive the error message
     * `ALREADY_EXISTS` when creating a space or updating the `displayName`, try a
     * different `displayName`. An existing space within the Google Workspace
     * organization might already use this display name.
     *
     * For direct messages, this field might be empty.
     *
     * Supports up to 128 characters.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The space's display name. Required when [creating a
     * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create)
     * with a `spaceType` of `SPACE`. If you receive the error message
     * `ALREADY_EXISTS` when creating a space or updating the `displayName`, try a
     * different `displayName`. An existing space within the Google Workspace
     * organization might already use this display name.
     *
     * For direct messages, this field might be empty.
     *
     * Supports up to 128 characters.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The space's display name. Required when [creating a
     * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create)
     * with a `spaceType` of `SPACE`. If you receive the error message
     * `ALREADY_EXISTS` when creating a space or updating the `displayName`, try a
     * different `displayName`. An existing space within the Google Workspace
     * organization might already use this display name.
     *
     * For direct messages, this field might be empty.
     *
     * Supports up to 128 characters.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private boolean externalUserAllowed_;

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Whether this space permits any Google Chat user as a
     * member. Input when creating a space in a Google Workspace organization.
     * Omit this field when creating spaces in the following conditions:
     *
     *   * The authenticated user uses a consumer account (unmanaged user
     *     account). By default, a space created by a consumer account permits any
     *     Google Chat user.
     *
     * For existing spaces, this field is output only.
     * </pre>
     *
     * <code>
     * bool external_user_allowed = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The externalUserAllowed.
     */
    @java.lang.Override
    public boolean getExternalUserAllowed() {
      return externalUserAllowed_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Whether this space permits any Google Chat user as a
     * member. Input when creating a space in a Google Workspace organization.
     * Omit this field when creating spaces in the following conditions:
     *
     *   * The authenticated user uses a consumer account (unmanaged user
     *     account). By default, a space created by a consumer account permits any
     *     Google Chat user.
     *
     * For existing spaces, this field is output only.
     * </pre>
     *
     * <code>
     * bool external_user_allowed = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The externalUserAllowed to set.
     * @return This builder for chaining.
     */
    public Builder setExternalUserAllowed(boolean value) {

      externalUserAllowed_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Whether this space permits any Google Chat user as a
     * member. Input when creating a space in a Google Workspace organization.
     * Omit this field when creating spaces in the following conditions:
     *
     *   * The authenticated user uses a consumer account (unmanaged user
     *     account). By default, a space created by a consumer account permits any
     *     Google Chat user.
     *
     * For existing spaces, this field is output only.
     * </pre>
     *
     * <code>
     * bool external_user_allowed = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExternalUserAllowed() {
      bitField0_ = (bitField0_ & ~0x00000040);
      externalUserAllowed_ = false;
      onChanged();
      return this;
    }

    private int spaceThreadingState_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. The threading state in the Chat space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for spaceThreadingState.
     */
    @java.lang.Override
    public int getSpaceThreadingStateValue() {
      return spaceThreadingState_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The threading state in the Chat space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for spaceThreadingState to set.
     * @return This builder for chaining.
     */
    public Builder setSpaceThreadingStateValue(int value) {
      spaceThreadingState_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The threading state in the Chat space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The spaceThreadingState.
     */
    @java.lang.Override
    public com.google.chat.v1.Space.SpaceThreadingState getSpaceThreadingState() {
      com.google.chat.v1.Space.SpaceThreadingState result =
          com.google.chat.v1.Space.SpaceThreadingState.forNumber(spaceThreadingState_);
      return result == null ? com.google.chat.v1.Space.SpaceThreadingState.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. The threading state in the Chat space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The spaceThreadingState to set.
     * @return This builder for chaining.
     */
    public Builder setSpaceThreadingState(com.google.chat.v1.Space.SpaceThreadingState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      spaceThreadingState_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The threading state in the Chat space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpaceThreadingState() {
      bitField0_ = (bitField0_ & ~0x00000080);
      spaceThreadingState_ = 0;
      onChanged();
      return this;
    }

    private com.google.chat.v1.Space.SpaceDetails spaceDetails_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Space.SpaceDetails,
            com.google.chat.v1.Space.SpaceDetails.Builder,
            com.google.chat.v1.Space.SpaceDetailsOrBuilder>
        spaceDetailsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Details about the space including description and rules.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceDetails space_details = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the spaceDetails field is set.
     */
    public boolean hasSpaceDetails() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Details about the space including description and rules.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceDetails space_details = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The spaceDetails.
     */
    public com.google.chat.v1.Space.SpaceDetails getSpaceDetails() {
      if (spaceDetailsBuilder_ == null) {
        return spaceDetails_ == null
            ? com.google.chat.v1.Space.SpaceDetails.getDefaultInstance()
            : spaceDetails_;
      } else {
        return spaceDetailsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Details about the space including description and rules.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceDetails space_details = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSpaceDetails(com.google.chat.v1.Space.SpaceDetails value) {
      if (spaceDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        spaceDetails_ = value;
      } else {
        spaceDetailsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Details about the space including description and rules.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceDetails space_details = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSpaceDetails(com.google.chat.v1.Space.SpaceDetails.Builder builderForValue) {
      if (spaceDetailsBuilder_ == null) {
        spaceDetails_ = builderForValue.build();
      } else {
        spaceDetailsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Details about the space including description and rules.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceDetails space_details = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSpaceDetails(com.google.chat.v1.Space.SpaceDetails value) {
      if (spaceDetailsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && spaceDetails_ != null
            && spaceDetails_ != com.google.chat.v1.Space.SpaceDetails.getDefaultInstance()) {
          getSpaceDetailsBuilder().mergeFrom(value);
        } else {
          spaceDetails_ = value;
        }
      } else {
        spaceDetailsBuilder_.mergeFrom(value);
      }
      if (spaceDetails_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Details about the space including description and rules.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceDetails space_details = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSpaceDetails() {
      bitField0_ = (bitField0_ & ~0x00000100);
      spaceDetails_ = null;
      if (spaceDetailsBuilder_ != null) {
        spaceDetailsBuilder_.dispose();
        spaceDetailsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Details about the space including description and rules.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceDetails space_details = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.Space.SpaceDetails.Builder getSpaceDetailsBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getSpaceDetailsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Details about the space including description and rules.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceDetails space_details = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.Space.SpaceDetailsOrBuilder getSpaceDetailsOrBuilder() {
      if (spaceDetailsBuilder_ != null) {
        return spaceDetailsBuilder_.getMessageOrBuilder();
      } else {
        return spaceDetails_ == null
            ? com.google.chat.v1.Space.SpaceDetails.getDefaultInstance()
            : spaceDetails_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Details about the space including description and rules.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.SpaceDetails space_details = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Space.SpaceDetails,
            com.google.chat.v1.Space.SpaceDetails.Builder,
            com.google.chat.v1.Space.SpaceDetailsOrBuilder>
        getSpaceDetailsFieldBuilder() {
      if (spaceDetailsBuilder_ == null) {
        spaceDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.Space.SpaceDetails,
                com.google.chat.v1.Space.SpaceDetails.Builder,
                com.google.chat.v1.Space.SpaceDetailsOrBuilder>(
                getSpaceDetails(), getParentForChildren(), isClean());
        spaceDetails_ = null;
      }
      return spaceDetailsBuilder_;
    }

    private int spaceHistoryState_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. The message history state for messages and threads in this space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.HistoryState space_history_state = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for spaceHistoryState.
     */
    @java.lang.Override
    public int getSpaceHistoryStateValue() {
      return spaceHistoryState_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The message history state for messages and threads in this space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.HistoryState space_history_state = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for spaceHistoryState to set.
     * @return This builder for chaining.
     */
    public Builder setSpaceHistoryStateValue(int value) {
      spaceHistoryState_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The message history state for messages and threads in this space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.HistoryState space_history_state = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The spaceHistoryState.
     */
    @java.lang.Override
    public com.google.chat.v1.HistoryState getSpaceHistoryState() {
      com.google.chat.v1.HistoryState result =
          com.google.chat.v1.HistoryState.forNumber(spaceHistoryState_);
      return result == null ? com.google.chat.v1.HistoryState.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. The message history state for messages and threads in this space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.HistoryState space_history_state = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The spaceHistoryState to set.
     * @return This builder for chaining.
     */
    public Builder setSpaceHistoryState(com.google.chat.v1.HistoryState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      spaceHistoryState_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The message history state for messages and threads in this space.
     * </pre>
     *
     * <code>
     * .google.chat.v1.HistoryState space_history_state = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpaceHistoryState() {
      bitField0_ = (bitField0_ & ~0x00000200);
      spaceHistoryState_ = 0;
      onChanged();
      return this;
    }

    private boolean importMode_;

    /**
     *
     *
     * <pre>
     * Optional. Whether this space is created in `Import Mode` as part of a data
     * migration into Google Workspace. While spaces are being imported, they
     * aren't visible to users until the import is complete.
     *
     * Creating a space in `Import Mode`requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     * </pre>
     *
     * <code>bool import_mode = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The importMode.
     */
    @java.lang.Override
    public boolean getImportMode() {
      return importMode_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether this space is created in `Import Mode` as part of a data
     * migration into Google Workspace. While spaces are being imported, they
     * aren't visible to users until the import is complete.
     *
     * Creating a space in `Import Mode`requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     * </pre>
     *
     * <code>bool import_mode = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The importMode to set.
     * @return This builder for chaining.
     */
    public Builder setImportMode(boolean value) {

      importMode_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether this space is created in `Import Mode` as part of a data
     * migration into Google Workspace. While spaces are being imported, they
     * aren't visible to users until the import is complete.
     *
     * Creating a space in `Import Mode`requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     * </pre>
     *
     * <code>bool import_mode = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportMode() {
      bitField0_ = (bitField0_ & ~0x00000400);
      importMode_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     *
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     *
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     *
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     *
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     *
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     *
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000800);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     *
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     *
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     *
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     *
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp lastActiveTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastActiveTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last message in the space.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_active_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastActiveTime field is set.
     */
    public boolean hasLastActiveTime() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last message in the space.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_active_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastActiveTime.
     */
    public com.google.protobuf.Timestamp getLastActiveTime() {
      if (lastActiveTimeBuilder_ == null) {
        return lastActiveTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastActiveTime_;
      } else {
        return lastActiveTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last message in the space.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_active_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastActiveTime(com.google.protobuf.Timestamp value) {
      if (lastActiveTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastActiveTime_ = value;
      } else {
        lastActiveTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last message in the space.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_active_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastActiveTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastActiveTimeBuilder_ == null) {
        lastActiveTime_ = builderForValue.build();
      } else {
        lastActiveTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last message in the space.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_active_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLastActiveTime(com.google.protobuf.Timestamp value) {
      if (lastActiveTimeBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && lastActiveTime_ != null
            && lastActiveTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastActiveTimeBuilder().mergeFrom(value);
        } else {
          lastActiveTime_ = value;
        }
      } else {
        lastActiveTimeBuilder_.mergeFrom(value);
      }
      if (lastActiveTime_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last message in the space.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_active_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastActiveTime() {
      bitField0_ = (bitField0_ & ~0x00001000);
      lastActiveTime_ = null;
      if (lastActiveTimeBuilder_ != null) {
        lastActiveTimeBuilder_.dispose();
        lastActiveTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last message in the space.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_active_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getLastActiveTimeBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getLastActiveTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last message in the space.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_active_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastActiveTimeOrBuilder() {
      if (lastActiveTimeBuilder_ != null) {
        return lastActiveTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastActiveTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastActiveTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last message in the space.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_active_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastActiveTimeFieldBuilder() {
      if (lastActiveTimeBuilder_ == null) {
        lastActiveTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastActiveTime(), getParentForChildren(), isClean());
        lastActiveTime_ = null;
      }
      return lastActiveTimeBuilder_;
    }

    private boolean adminInstalled_;

    /**
     *
     *
     * <pre>
     * Output only. For direct message (DM) spaces with a Chat app, whether the
     * space was created by a Google Workspace administrator. Administrators can
     * install and set up a direct message with a Chat app on behalf of users in
     * their organization.
     *
     * To support admin install, your Chat app must feature direct messaging.
     * </pre>
     *
     * <code>bool admin_installed = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The adminInstalled.
     */
    @java.lang.Override
    public boolean getAdminInstalled() {
      return adminInstalled_;
    }

    /**
     *
     *
     * <pre>
     * Output only. For direct message (DM) spaces with a Chat app, whether the
     * space was created by a Google Workspace administrator. Administrators can
     * install and set up a direct message with a Chat app on behalf of users in
     * their organization.
     *
     * To support admin install, your Chat app must feature direct messaging.
     * </pre>
     *
     * <code>bool admin_installed = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The adminInstalled to set.
     * @return This builder for chaining.
     */
    public Builder setAdminInstalled(boolean value) {

      adminInstalled_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. For direct message (DM) spaces with a Chat app, whether the
     * space was created by a Google Workspace administrator. Administrators can
     * install and set up a direct message with a Chat app on behalf of users in
     * their organization.
     *
     * To support admin install, your Chat app must feature direct messaging.
     * </pre>
     *
     * <code>bool admin_installed = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdminInstalled() {
      bitField0_ = (bitField0_ & ~0x00002000);
      adminInstalled_ = false;
      onChanged();
      return this;
    }

    private com.google.chat.v1.Space.MembershipCount membershipCount_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Space.MembershipCount,
            com.google.chat.v1.Space.MembershipCount.Builder,
            com.google.chat.v1.Space.MembershipCountOrBuilder>
        membershipCountBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The count of joined memberships grouped by member type.
     * Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
     * `GROUP_CHAT`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.MembershipCount membership_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the membershipCount field is set.
     */
    public boolean hasMembershipCount() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The count of joined memberships grouped by member type.
     * Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
     * `GROUP_CHAT`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.MembershipCount membership_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The membershipCount.
     */
    public com.google.chat.v1.Space.MembershipCount getMembershipCount() {
      if (membershipCountBuilder_ == null) {
        return membershipCount_ == null
            ? com.google.chat.v1.Space.MembershipCount.getDefaultInstance()
            : membershipCount_;
      } else {
        return membershipCountBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The count of joined memberships grouped by member type.
     * Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
     * `GROUP_CHAT`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.MembershipCount membership_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMembershipCount(com.google.chat.v1.Space.MembershipCount value) {
      if (membershipCountBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        membershipCount_ = value;
      } else {
        membershipCountBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The count of joined memberships grouped by member type.
     * Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
     * `GROUP_CHAT`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.MembershipCount membership_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMembershipCount(
        com.google.chat.v1.Space.MembershipCount.Builder builderForValue) {
      if (membershipCountBuilder_ == null) {
        membershipCount_ = builderForValue.build();
      } else {
        membershipCountBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The count of joined memberships grouped by member type.
     * Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
     * `GROUP_CHAT`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.MembershipCount membership_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeMembershipCount(com.google.chat.v1.Space.MembershipCount value) {
      if (membershipCountBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && membershipCount_ != null
            && membershipCount_ != com.google.chat.v1.Space.MembershipCount.getDefaultInstance()) {
          getMembershipCountBuilder().mergeFrom(value);
        } else {
          membershipCount_ = value;
        }
      } else {
        membershipCountBuilder_.mergeFrom(value);
      }
      if (membershipCount_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The count of joined memberships grouped by member type.
     * Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
     * `GROUP_CHAT`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.MembershipCount membership_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMembershipCount() {
      bitField0_ = (bitField0_ & ~0x00004000);
      membershipCount_ = null;
      if (membershipCountBuilder_ != null) {
        membershipCountBuilder_.dispose();
        membershipCountBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The count of joined memberships grouped by member type.
     * Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
     * `GROUP_CHAT`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.MembershipCount membership_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.Space.MembershipCount.Builder getMembershipCountBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getMembershipCountFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The count of joined memberships grouped by member type.
     * Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
     * `GROUP_CHAT`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.MembershipCount membership_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.Space.MembershipCountOrBuilder getMembershipCountOrBuilder() {
      if (membershipCountBuilder_ != null) {
        return membershipCountBuilder_.getMessageOrBuilder();
      } else {
        return membershipCount_ == null
            ? com.google.chat.v1.Space.MembershipCount.getDefaultInstance()
            : membershipCount_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The count of joined memberships grouped by member type.
     * Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
     * `GROUP_CHAT`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.MembershipCount membership_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Space.MembershipCount,
            com.google.chat.v1.Space.MembershipCount.Builder,
            com.google.chat.v1.Space.MembershipCountOrBuilder>
        getMembershipCountFieldBuilder() {
      if (membershipCountBuilder_ == null) {
        membershipCountBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.Space.MembershipCount,
                com.google.chat.v1.Space.MembershipCount.Builder,
                com.google.chat.v1.Space.MembershipCountOrBuilder>(
                getMembershipCount(), getParentForChildren(), isClean());
        membershipCount_ = null;
      }
      return membershipCountBuilder_;
    }

    private com.google.chat.v1.Space.AccessSettings accessSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Space.AccessSettings,
            com.google.chat.v1.Space.AccessSettings.Builder,
            com.google.chat.v1.Space.AccessSettingsOrBuilder>
        accessSettingsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the accessSettings field is set.
     */
    public boolean hasAccessSettings() {
      return ((bitField0_ & 0x00008000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The accessSettings.
     */
    public com.google.chat.v1.Space.AccessSettings getAccessSettings() {
      if (accessSettingsBuilder_ == null) {
        return accessSettings_ == null
            ? com.google.chat.v1.Space.AccessSettings.getDefaultInstance()
            : accessSettings_;
      } else {
        return accessSettingsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAccessSettings(com.google.chat.v1.Space.AccessSettings value) {
      if (accessSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        accessSettings_ = value;
      } else {
        accessSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAccessSettings(
        com.google.chat.v1.Space.AccessSettings.Builder builderForValue) {
      if (accessSettingsBuilder_ == null) {
        accessSettings_ = builderForValue.build();
      } else {
        accessSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAccessSettings(com.google.chat.v1.Space.AccessSettings value) {
      if (accessSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && accessSettings_ != null
            && accessSettings_ != com.google.chat.v1.Space.AccessSettings.getDefaultInstance()) {
          getAccessSettingsBuilder().mergeFrom(value);
        } else {
          accessSettings_ = value;
        }
      } else {
        accessSettingsBuilder_.mergeFrom(value);
      }
      if (accessSettings_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAccessSettings() {
      bitField0_ = (bitField0_ & ~0x00008000);
      accessSettings_ = null;
      if (accessSettingsBuilder_ != null) {
        accessSettingsBuilder_.dispose();
        accessSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.Space.AccessSettings.Builder getAccessSettingsBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getAccessSettingsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.Space.AccessSettingsOrBuilder getAccessSettingsOrBuilder() {
      if (accessSettingsBuilder_ != null) {
        return accessSettingsBuilder_.getMessageOrBuilder();
      } else {
        return accessSettings_ == null
            ? com.google.chat.v1.Space.AccessSettings.getDefaultInstance()
            : accessSettings_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Space.AccessSettings,
            com.google.chat.v1.Space.AccessSettings.Builder,
            com.google.chat.v1.Space.AccessSettingsOrBuilder>
        getAccessSettingsFieldBuilder() {
      if (accessSettingsBuilder_ == null) {
        accessSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.Space.AccessSettings,
                com.google.chat.v1.Space.AccessSettings.Builder,
                com.google.chat.v1.Space.AccessSettingsOrBuilder>(
                getAccessSettings(), getParentForChildren(), isClean());
        accessSettings_ = null;
      }
      return accessSettingsBuilder_;
    }

    private java.lang.Object spaceUri_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The URI for a user to access the space.
     * </pre>
     *
     * <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The spaceUri.
     */
    public java.lang.String getSpaceUri() {
      java.lang.Object ref = spaceUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        spaceUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The URI for a user to access the space.
     * </pre>
     *
     * <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for spaceUri.
     */
    public com.google.protobuf.ByteString getSpaceUriBytes() {
      java.lang.Object ref = spaceUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        spaceUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The URI for a user to access the space.
     * </pre>
     *
     * <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The spaceUri to set.
     * @return This builder for chaining.
     */
    public Builder setSpaceUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      spaceUri_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The URI for a user to access the space.
     * </pre>
     *
     * <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpaceUri() {
      spaceUri_ = getDefaultInstance().getSpaceUri();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The URI for a user to access the space.
     * </pre>
     *
     * <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for spaceUri to set.
     * @return This builder for chaining.
     */
    public Builder setSpaceUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      spaceUri_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. Predefined space permission settings, input only
     * when creating a space. If the field is not set, a collaboration space is
     * created. After you create the space, settings are populated in the
     * `PermissionSettings` field.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.PredefinedPermissionSettings predefined_permission_settings = 26 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the predefinedPermissionSettings field is set.
     */
    @java.lang.Override
    public boolean hasPredefinedPermissionSettings() {
      return spacePermissionSettingsCase_ == 26;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. Predefined space permission settings, input only
     * when creating a space. If the field is not set, a collaboration space is
     * created. After you create the space, settings are populated in the
     * `PermissionSettings` field.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.PredefinedPermissionSettings predefined_permission_settings = 26 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for predefinedPermissionSettings.
     */
    @java.lang.Override
    public int getPredefinedPermissionSettingsValue() {
      if (spacePermissionSettingsCase_ == 26) {
        return ((java.lang.Integer) spacePermissionSettings_).intValue();
      }
      return 0;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. Predefined space permission settings, input only
     * when creating a space. If the field is not set, a collaboration space is
     * created. After you create the space, settings are populated in the
     * `PermissionSettings` field.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.PredefinedPermissionSettings predefined_permission_settings = 26 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for predefinedPermissionSettings to set.
     * @return This builder for chaining.
     */
    public Builder setPredefinedPermissionSettingsValue(int value) {
      spacePermissionSettingsCase_ = 26;
      spacePermissionSettings_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. Predefined space permission settings, input only
     * when creating a space. If the field is not set, a collaboration space is
     * created. After you create the space, settings are populated in the
     * `PermissionSettings` field.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.PredefinedPermissionSettings predefined_permission_settings = 26 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The predefinedPermissionSettings.
     */
    @java.lang.Override
    public com.google.chat.v1.Space.PredefinedPermissionSettings getPredefinedPermissionSettings() {
      if (spacePermissionSettingsCase_ == 26) {
        com.google.chat.v1.Space.PredefinedPermissionSettings result =
            com.google.chat.v1.Space.PredefinedPermissionSettings.forNumber(
                (java.lang.Integer) spacePermissionSettings_);
        return result == null
            ? com.google.chat.v1.Space.PredefinedPermissionSettings.UNRECOGNIZED
            : result;
      }
      return com.google.chat.v1.Space.PredefinedPermissionSettings
          .PREDEFINED_PERMISSION_SETTINGS_UNSPECIFIED;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. Predefined space permission settings, input only
     * when creating a space. If the field is not set, a collaboration space is
     * created. After you create the space, settings are populated in the
     * `PermissionSettings` field.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.PredefinedPermissionSettings predefined_permission_settings = 26 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The predefinedPermissionSettings to set.
     * @return This builder for chaining.
     */
    public Builder setPredefinedPermissionSettings(
        com.google.chat.v1.Space.PredefinedPermissionSettings value) {
      if (value == null) {
        throw new NullPointerException();
      }
      spacePermissionSettingsCase_ = 26;
      spacePermissionSettings_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. Predefined space permission settings, input only
     * when creating a space. If the field is not set, a collaboration space is
     * created. After you create the space, settings are populated in the
     * `PermissionSettings` field.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.PredefinedPermissionSettings predefined_permission_settings = 26 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPredefinedPermissionSettings() {
      if (spacePermissionSettingsCase_ == 26) {
        spacePermissionSettingsCase_ = 0;
        spacePermissionSettings_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Space.PermissionSettings,
            com.google.chat.v1.Space.PermissionSettings.Builder,
            com.google.chat.v1.Space.PermissionSettingsOrBuilder>
        permissionSettingsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Space permission settings for existing spaces. Input for
     * updating exact space permission settings, where existing permission
     * settings are replaced. Output lists current permission settings.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.PermissionSettings permission_settings = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the permissionSettings field is set.
     */
    @java.lang.Override
    public boolean hasPermissionSettings() {
      return spacePermissionSettingsCase_ == 27;
    }

    /**
     *
     *
     * <pre>
     * Optional. Space permission settings for existing spaces. Input for
     * updating exact space permission settings, where existing permission
     * settings are replaced. Output lists current permission settings.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.PermissionSettings permission_settings = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The permissionSettings.
     */
    @java.lang.Override
    public com.google.chat.v1.Space.PermissionSettings getPermissionSettings() {
      if (permissionSettingsBuilder_ == null) {
        if (spacePermissionSettingsCase_ == 27) {
          return (com.google.chat.v1.Space.PermissionSettings) spacePermissionSettings_;
        }
        return com.google.chat.v1.Space.PermissionSettings.getDefaultInstance();
      } else {
        if (spacePermissionSettingsCase_ == 27) {
          return permissionSettingsBuilder_.getMessage();
        }
        return com.google.chat.v1.Space.PermissionSettings.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Space permission settings for existing spaces. Input for
     * updating exact space permission settings, where existing permission
     * settings are replaced. Output lists current permission settings.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.PermissionSettings permission_settings = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPermissionSettings(com.google.chat.v1.Space.PermissionSettings value) {
      if (permissionSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        spacePermissionSettings_ = value;
        onChanged();
      } else {
        permissionSettingsBuilder_.setMessage(value);
      }
      spacePermissionSettingsCase_ = 27;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Space permission settings for existing spaces. Input for
     * updating exact space permission settings, where existing permission
     * settings are replaced. Output lists current permission settings.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.PermissionSettings permission_settings = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPermissionSettings(
        com.google.chat.v1.Space.PermissionSettings.Builder builderForValue) {
      if (permissionSettingsBuilder_ == null) {
        spacePermissionSettings_ = builderForValue.build();
        onChanged();
      } else {
        permissionSettingsBuilder_.setMessage(builderForValue.build());
      }
      spacePermissionSettingsCase_ = 27;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Space permission settings for existing spaces. Input for
     * updating exact space permission settings, where existing permission
     * settings are replaced. Output lists current permission settings.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.PermissionSettings permission_settings = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePermissionSettings(com.google.chat.v1.Space.PermissionSettings value) {
      if (permissionSettingsBuilder_ == null) {
        if (spacePermissionSettingsCase_ == 27
            && spacePermissionSettings_
                != com.google.chat.v1.Space.PermissionSettings.getDefaultInstance()) {
          spacePermissionSettings_ =
              com.google.chat.v1.Space.PermissionSettings.newBuilder(
                      (com.google.chat.v1.Space.PermissionSettings) spacePermissionSettings_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          spacePermissionSettings_ = value;
        }
        onChanged();
      } else {
        if (spacePermissionSettingsCase_ == 27) {
          permissionSettingsBuilder_.mergeFrom(value);
        } else {
          permissionSettingsBuilder_.setMessage(value);
        }
      }
      spacePermissionSettingsCase_ = 27;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Space permission settings for existing spaces. Input for
     * updating exact space permission settings, where existing permission
     * settings are replaced. Output lists current permission settings.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.PermissionSettings permission_settings = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPermissionSettings() {
      if (permissionSettingsBuilder_ == null) {
        if (spacePermissionSettingsCase_ == 27) {
          spacePermissionSettingsCase_ = 0;
          spacePermissionSettings_ = null;
          onChanged();
        }
      } else {
        if (spacePermissionSettingsCase_ == 27) {
          spacePermissionSettingsCase_ = 0;
          spacePermissionSettings_ = null;
        }
        permissionSettingsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Space permission settings for existing spaces. Input for
     * updating exact space permission settings, where existing permission
     * settings are replaced. Output lists current permission settings.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.PermissionSettings permission_settings = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.Space.PermissionSettings.Builder getPermissionSettingsBuilder() {
      return getPermissionSettingsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Space permission settings for existing spaces. Input for
     * updating exact space permission settings, where existing permission
     * settings are replaced. Output lists current permission settings.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.PermissionSettings permission_settings = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.chat.v1.Space.PermissionSettingsOrBuilder getPermissionSettingsOrBuilder() {
      if ((spacePermissionSettingsCase_ == 27) && (permissionSettingsBuilder_ != null)) {
        return permissionSettingsBuilder_.getMessageOrBuilder();
      } else {
        if (spacePermissionSettingsCase_ == 27) {
          return (com.google.chat.v1.Space.PermissionSettings) spacePermissionSettings_;
        }
        return com.google.chat.v1.Space.PermissionSettings.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Space permission settings for existing spaces. Input for
     * updating exact space permission settings, where existing permission
     * settings are replaced. Output lists current permission settings.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Space.PermissionSettings permission_settings = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Space.PermissionSettings,
            com.google.chat.v1.Space.PermissionSettings.Builder,
            com.google.chat.v1.Space.PermissionSettingsOrBuilder>
        getPermissionSettingsFieldBuilder() {
      if (permissionSettingsBuilder_ == null) {
        if (!(spacePermissionSettingsCase_ == 27)) {
          spacePermissionSettings_ =
              com.google.chat.v1.Space.PermissionSettings.getDefaultInstance();
        }
        permissionSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.Space.PermissionSettings,
                com.google.chat.v1.Space.PermissionSettings.Builder,
                com.google.chat.v1.Space.PermissionSettingsOrBuilder>(
                (com.google.chat.v1.Space.PermissionSettings) spacePermissionSettings_,
                getParentForChildren(),
                isClean());
        spacePermissionSettings_ = null;
      }
      spacePermissionSettingsCase_ = 27;
      onChanged();
      return permissionSettingsBuilder_;
    }

    private com.google.protobuf.Timestamp importModeExpireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        importModeExpireTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The time when the space will be automatically deleted by the
     * system if it remains in import mode.
     *
     * Each space created in import mode must exit this mode before this expire
     * time using `spaces.completeImport`.
     *
     * This field is only populated for spaces that were created with import mode.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_mode_expire_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the importModeExpireTime field is set.
     */
    public boolean hasImportModeExpireTime() {
      return ((bitField0_ & 0x00080000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the space will be automatically deleted by the
     * system if it remains in import mode.
     *
     * Each space created in import mode must exit this mode before this expire
     * time using `spaces.completeImport`.
     *
     * This field is only populated for spaces that were created with import mode.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_mode_expire_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The importModeExpireTime.
     */
    public com.google.protobuf.Timestamp getImportModeExpireTime() {
      if (importModeExpireTimeBuilder_ == null) {
        return importModeExpireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : importModeExpireTime_;
      } else {
        return importModeExpireTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the space will be automatically deleted by the
     * system if it remains in import mode.
     *
     * Each space created in import mode must exit this mode before this expire
     * time using `spaces.completeImport`.
     *
     * This field is only populated for spaces that were created with import mode.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_mode_expire_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setImportModeExpireTime(com.google.protobuf.Timestamp value) {
      if (importModeExpireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        importModeExpireTime_ = value;
      } else {
        importModeExpireTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the space will be automatically deleted by the
     * system if it remains in import mode.
     *
     * Each space created in import mode must exit this mode before this expire
     * time using `spaces.completeImport`.
     *
     * This field is only populated for spaces that were created with import mode.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_mode_expire_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setImportModeExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (importModeExpireTimeBuilder_ == null) {
        importModeExpireTime_ = builderForValue.build();
      } else {
        importModeExpireTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the space will be automatically deleted by the
     * system if it remains in import mode.
     *
     * Each space created in import mode must exit this mode before this expire
     * time using `spaces.completeImport`.
     *
     * This field is only populated for spaces that were created with import mode.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_mode_expire_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeImportModeExpireTime(com.google.protobuf.Timestamp value) {
      if (importModeExpireTimeBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && importModeExpireTime_ != null
            && importModeExpireTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getImportModeExpireTimeBuilder().mergeFrom(value);
        } else {
          importModeExpireTime_ = value;
        }
      } else {
        importModeExpireTimeBuilder_.mergeFrom(value);
      }
      if (importModeExpireTime_ != null) {
        bitField0_ |= 0x00080000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the space will be automatically deleted by the
     * system if it remains in import mode.
     *
     * Each space created in import mode must exit this mode before this expire
     * time using `spaces.completeImport`.
     *
     * This field is only populated for spaces that were created with import mode.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_mode_expire_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearImportModeExpireTime() {
      bitField0_ = (bitField0_ & ~0x00080000);
      importModeExpireTime_ = null;
      if (importModeExpireTimeBuilder_ != null) {
        importModeExpireTimeBuilder_.dispose();
        importModeExpireTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the space will be automatically deleted by the
     * system if it remains in import mode.
     *
     * Each space created in import mode must exit this mode before this expire
     * time using `spaces.completeImport`.
     *
     * This field is only populated for spaces that were created with import mode.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_mode_expire_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getImportModeExpireTimeBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getImportModeExpireTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the space will be automatically deleted by the
     * system if it remains in import mode.
     *
     * Each space created in import mode must exit this mode before this expire
     * time using `spaces.completeImport`.
     *
     * This field is only populated for spaces that were created with import mode.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_mode_expire_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getImportModeExpireTimeOrBuilder() {
      if (importModeExpireTimeBuilder_ != null) {
        return importModeExpireTimeBuilder_.getMessageOrBuilder();
      } else {
        return importModeExpireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : importModeExpireTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the space will be automatically deleted by the
     * system if it remains in import mode.
     *
     * Each space created in import mode must exit this mode before this expire
     * time using `spaces.completeImport`.
     *
     * This field is only populated for spaces that were created with import mode.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_mode_expire_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getImportModeExpireTimeFieldBuilder() {
      if (importModeExpireTimeBuilder_ == null) {
        importModeExpireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getImportModeExpireTime(), getParentForChildren(), isClean());
        importModeExpireTime_ = null;
      }
      return importModeExpireTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.Space)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.Space)
  private static final com.google.chat.v1.Space DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.Space();
  }

  public static com.google.chat.v1.Space getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Space> PARSER =
      new com.google.protobuf.AbstractParser<Space>() {
        @java.lang.Override
        public Space parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Space> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Space> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.Space getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
