/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/space_event.proto

// Protobuf Java Version: 3.25.5
package com.google.chat.v1;

/**
 *
 *
 * <pre>
 * An event that represents a change or activity in a Google Chat space. To
 * learn more, see [Work with events from Google
 * Chat](https://developers.google.com/workspace/chat/events-overview).
 * </pre>
 *
 * Protobuf type {@code google.chat.v1.SpaceEvent}
 */
public final class SpaceEvent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.SpaceEvent)
    SpaceEventOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SpaceEvent.newBuilder() to construct.
  private SpaceEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SpaceEvent() {
    name_ = "";
    eventType_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SpaceEvent();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.SpaceEventProto.internal_static_google_chat_v1_SpaceEvent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.SpaceEventProto
        .internal_static_google_chat_v1_SpaceEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.SpaceEvent.class, com.google.chat.v1.SpaceEvent.Builder.class);
  }

  private int bitField0_;
  private int payloadCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object payload_;

  public enum PayloadCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    MESSAGE_CREATED_EVENT_DATA(12),
    MESSAGE_UPDATED_EVENT_DATA(13),
    MESSAGE_DELETED_EVENT_DATA(14),
    MESSAGE_BATCH_CREATED_EVENT_DATA(26),
    MESSAGE_BATCH_UPDATED_EVENT_DATA(27),
    MESSAGE_BATCH_DELETED_EVENT_DATA(28),
    SPACE_UPDATED_EVENT_DATA(15),
    SPACE_BATCH_UPDATED_EVENT_DATA(29),
    MEMBERSHIP_CREATED_EVENT_DATA(17),
    MEMBERSHIP_UPDATED_EVENT_DATA(18),
    MEMBERSHIP_DELETED_EVENT_DATA(219),
    MEMBERSHIP_BATCH_CREATED_EVENT_DATA(31),
    MEMBERSHIP_BATCH_UPDATED_EVENT_DATA(32),
    MEMBERSHIP_BATCH_DELETED_EVENT_DATA(33),
    REACTION_CREATED_EVENT_DATA(21),
    REACTION_DELETED_EVENT_DATA(22),
    REACTION_BATCH_CREATED_EVENT_DATA(34),
    REACTION_BATCH_DELETED_EVENT_DATA(35),
    PAYLOAD_NOT_SET(0);
    private final int value;

    private PayloadCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PayloadCase valueOf(int value) {
      return forNumber(value);
    }

    public static PayloadCase forNumber(int value) {
      switch (value) {
        case 12:
          return MESSAGE_CREATED_EVENT_DATA;
        case 13:
          return MESSAGE_UPDATED_EVENT_DATA;
        case 14:
          return MESSAGE_DELETED_EVENT_DATA;
        case 26:
          return MESSAGE_BATCH_CREATED_EVENT_DATA;
        case 27:
          return MESSAGE_BATCH_UPDATED_EVENT_DATA;
        case 28:
          return MESSAGE_BATCH_DELETED_EVENT_DATA;
        case 15:
          return SPACE_UPDATED_EVENT_DATA;
        case 29:
          return SPACE_BATCH_UPDATED_EVENT_DATA;
        case 17:
          return MEMBERSHIP_CREATED_EVENT_DATA;
        case 18:
          return MEMBERSHIP_UPDATED_EVENT_DATA;
        case 219:
          return MEMBERSHIP_DELETED_EVENT_DATA;
        case 31:
          return MEMBERSHIP_BATCH_CREATED_EVENT_DATA;
        case 32:
          return MEMBERSHIP_BATCH_UPDATED_EVENT_DATA;
        case 33:
          return MEMBERSHIP_BATCH_DELETED_EVENT_DATA;
        case 21:
          return REACTION_CREATED_EVENT_DATA;
        case 22:
          return REACTION_DELETED_EVENT_DATA;
        case 34:
          return REACTION_BATCH_CREATED_EVENT_DATA;
        case 35:
          return REACTION_BATCH_DELETED_EVENT_DATA;
        case 0:
          return PAYLOAD_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PayloadCase getPayloadCase() {
    return PayloadCase.forNumber(payloadCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Resource name of the space event.
   *
   * Format: `spaces/{space}/spaceEvents/{spaceEvent}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Resource name of the space event.
   *
   * Format: `spaces/{space}/spaceEvents/{spaceEvent}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EVENT_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp eventTime_;

  /**
   *
   *
   * <pre>
   * Time when the event occurred.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 3;</code>
   *
   * @return Whether the eventTime field is set.
   */
  @java.lang.Override
  public boolean hasEventTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Time when the event occurred.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 3;</code>
   *
   * @return The eventTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEventTime() {
    return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
  }

  /**
   *
   *
   * <pre>
   * Time when the event occurred.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEventTimeOrBuilder() {
    return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
  }

  public static final int EVENT_TYPE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object eventType_ = "";

  /**
   *
   *
   * <pre>
   * Type of space event. Each event type has a batch version, which
   * represents multiple instances of the event type that occur in a short
   * period of time. For `spaceEvents.list()` requests, omit batch event types
   * in your query filter. By default, the server returns both event type and
   * its batch version.
   *
   * Supported event types for
   * [messages](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages):
   *
   *    * New message: `google.workspace.chat.message.v1.created`
   *    * Updated message: `google.workspace.chat.message.v1.updated`
   *    * Deleted message: `google.workspace.chat.message.v1.deleted`
   *    * Multiple new messages: `google.workspace.chat.message.v1.batchCreated`
   *    * Multiple updated messages:
   *    `google.workspace.chat.message.v1.batchUpdated`
   *    * Multiple deleted messages:
   *    `google.workspace.chat.message.v1.batchDeleted`
   *
   * Supported event types for
   * [memberships](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members):
   *
   *   * New membership: `google.workspace.chat.membership.v1.created`
   *   * Updated membership: `google.workspace.chat.membership.v1.updated`
   *   * Deleted membership: `google.workspace.chat.membership.v1.deleted`
   *   * Multiple new memberships:
   *   `google.workspace.chat.membership.v1.batchCreated`
   *   * Multiple updated memberships:
   *   `google.workspace.chat.membership.v1.batchUpdated`
   *   * Multiple deleted memberships:
   *   `google.workspace.chat.membership.v1.batchDeleted`
   *
   * Supported event types for
   * [reactions](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.reactions):
   *
   *   * New reaction: `google.workspace.chat.reaction.v1.created`
   *   * Deleted reaction: `google.workspace.chat.reaction.v1.deleted`
   *   * Multiple new reactions:
   *   `google.workspace.chat.reaction.v1.batchCreated`
   *   * Multiple deleted reactions:
   *   `google.workspace.chat.reaction.v1.batchDeleted`
   *
   * Supported event types about the
   * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces):
   *
   *   * Updated space: `google.workspace.chat.space.v1.updated`
   *   * Multiple space updates: `google.workspace.chat.space.v1.batchUpdated`
   * </pre>
   *
   * <code>string event_type = 6;</code>
   *
   * @return The eventType.
   */
  @java.lang.Override
  public java.lang.String getEventType() {
    java.lang.Object ref = eventType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      eventType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Type of space event. Each event type has a batch version, which
   * represents multiple instances of the event type that occur in a short
   * period of time. For `spaceEvents.list()` requests, omit batch event types
   * in your query filter. By default, the server returns both event type and
   * its batch version.
   *
   * Supported event types for
   * [messages](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages):
   *
   *    * New message: `google.workspace.chat.message.v1.created`
   *    * Updated message: `google.workspace.chat.message.v1.updated`
   *    * Deleted message: `google.workspace.chat.message.v1.deleted`
   *    * Multiple new messages: `google.workspace.chat.message.v1.batchCreated`
   *    * Multiple updated messages:
   *    `google.workspace.chat.message.v1.batchUpdated`
   *    * Multiple deleted messages:
   *    `google.workspace.chat.message.v1.batchDeleted`
   *
   * Supported event types for
   * [memberships](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members):
   *
   *   * New membership: `google.workspace.chat.membership.v1.created`
   *   * Updated membership: `google.workspace.chat.membership.v1.updated`
   *   * Deleted membership: `google.workspace.chat.membership.v1.deleted`
   *   * Multiple new memberships:
   *   `google.workspace.chat.membership.v1.batchCreated`
   *   * Multiple updated memberships:
   *   `google.workspace.chat.membership.v1.batchUpdated`
   *   * Multiple deleted memberships:
   *   `google.workspace.chat.membership.v1.batchDeleted`
   *
   * Supported event types for
   * [reactions](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.reactions):
   *
   *   * New reaction: `google.workspace.chat.reaction.v1.created`
   *   * Deleted reaction: `google.workspace.chat.reaction.v1.deleted`
   *   * Multiple new reactions:
   *   `google.workspace.chat.reaction.v1.batchCreated`
   *   * Multiple deleted reactions:
   *   `google.workspace.chat.reaction.v1.batchDeleted`
   *
   * Supported event types about the
   * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces):
   *
   *   * Updated space: `google.workspace.chat.space.v1.updated`
   *   * Multiple space updates: `google.workspace.chat.space.v1.batchUpdated`
   * </pre>
   *
   * <code>string event_type = 6;</code>
   *
   * @return The bytes for eventType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEventTypeBytes() {
    java.lang.Object ref = eventType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      eventType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MESSAGE_CREATED_EVENT_DATA_FIELD_NUMBER = 12;

  /**
   *
   *
   * <pre>
   * Event payload for a new message.
   *
   * Event type: `google.workspace.chat.message.v1.created`
   * </pre>
   *
   * <code>.google.chat.v1.MessageCreatedEventData message_created_event_data = 12;</code>
   *
   * @return Whether the messageCreatedEventData field is set.
   */
  @java.lang.Override
  public boolean hasMessageCreatedEventData() {
    return payloadCase_ == 12;
  }

  /**
   *
   *
   * <pre>
   * Event payload for a new message.
   *
   * Event type: `google.workspace.chat.message.v1.created`
   * </pre>
   *
   * <code>.google.chat.v1.MessageCreatedEventData message_created_event_data = 12;</code>
   *
   * @return The messageCreatedEventData.
   */
  @java.lang.Override
  public com.google.chat.v1.MessageCreatedEventData getMessageCreatedEventData() {
    if (payloadCase_ == 12) {
      return (com.google.chat.v1.MessageCreatedEventData) payload_;
    }
    return com.google.chat.v1.MessageCreatedEventData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Event payload for a new message.
   *
   * Event type: `google.workspace.chat.message.v1.created`
   * </pre>
   *
   * <code>.google.chat.v1.MessageCreatedEventData message_created_event_data = 12;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.MessageCreatedEventDataOrBuilder getMessageCreatedEventDataOrBuilder() {
    if (payloadCase_ == 12) {
      return (com.google.chat.v1.MessageCreatedEventData) payload_;
    }
    return com.google.chat.v1.MessageCreatedEventData.getDefaultInstance();
  }

  public static final int MESSAGE_UPDATED_EVENT_DATA_FIELD_NUMBER = 13;

  /**
   *
   *
   * <pre>
   * Event payload for an updated message.
   *
   * Event type: `google.workspace.chat.message.v1.updated`
   * </pre>
   *
   * <code>.google.chat.v1.MessageUpdatedEventData message_updated_event_data = 13;</code>
   *
   * @return Whether the messageUpdatedEventData field is set.
   */
  @java.lang.Override
  public boolean hasMessageUpdatedEventData() {
    return payloadCase_ == 13;
  }

  /**
   *
   *
   * <pre>
   * Event payload for an updated message.
   *
   * Event type: `google.workspace.chat.message.v1.updated`
   * </pre>
   *
   * <code>.google.chat.v1.MessageUpdatedEventData message_updated_event_data = 13;</code>
   *
   * @return The messageUpdatedEventData.
   */
  @java.lang.Override
  public com.google.chat.v1.MessageUpdatedEventData getMessageUpdatedEventData() {
    if (payloadCase_ == 13) {
      return (com.google.chat.v1.MessageUpdatedEventData) payload_;
    }
    return com.google.chat.v1.MessageUpdatedEventData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Event payload for an updated message.
   *
   * Event type: `google.workspace.chat.message.v1.updated`
   * </pre>
   *
   * <code>.google.chat.v1.MessageUpdatedEventData message_updated_event_data = 13;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.MessageUpdatedEventDataOrBuilder getMessageUpdatedEventDataOrBuilder() {
    if (payloadCase_ == 13) {
      return (com.google.chat.v1.MessageUpdatedEventData) payload_;
    }
    return com.google.chat.v1.MessageUpdatedEventData.getDefaultInstance();
  }

  public static final int MESSAGE_DELETED_EVENT_DATA_FIELD_NUMBER = 14;

  /**
   *
   *
   * <pre>
   * Event payload for a deleted message.
   *
   * Event type: `google.workspace.chat.message.v1.deleted`
   * </pre>
   *
   * <code>.google.chat.v1.MessageDeletedEventData message_deleted_event_data = 14;</code>
   *
   * @return Whether the messageDeletedEventData field is set.
   */
  @java.lang.Override
  public boolean hasMessageDeletedEventData() {
    return payloadCase_ == 14;
  }

  /**
   *
   *
   * <pre>
   * Event payload for a deleted message.
   *
   * Event type: `google.workspace.chat.message.v1.deleted`
   * </pre>
   *
   * <code>.google.chat.v1.MessageDeletedEventData message_deleted_event_data = 14;</code>
   *
   * @return The messageDeletedEventData.
   */
  @java.lang.Override
  public com.google.chat.v1.MessageDeletedEventData getMessageDeletedEventData() {
    if (payloadCase_ == 14) {
      return (com.google.chat.v1.MessageDeletedEventData) payload_;
    }
    return com.google.chat.v1.MessageDeletedEventData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Event payload for a deleted message.
   *
   * Event type: `google.workspace.chat.message.v1.deleted`
   * </pre>
   *
   * <code>.google.chat.v1.MessageDeletedEventData message_deleted_event_data = 14;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.MessageDeletedEventDataOrBuilder getMessageDeletedEventDataOrBuilder() {
    if (payloadCase_ == 14) {
      return (com.google.chat.v1.MessageDeletedEventData) payload_;
    }
    return com.google.chat.v1.MessageDeletedEventData.getDefaultInstance();
  }

  public static final int MESSAGE_BATCH_CREATED_EVENT_DATA_FIELD_NUMBER = 26;

  /**
   *
   *
   * <pre>
   * Event payload for multiple new messages.
   *
   * Event type: `google.workspace.chat.message.v1.batchCreated`
   * </pre>
   *
   * <code>.google.chat.v1.MessageBatchCreatedEventData message_batch_created_event_data = 26;
   * </code>
   *
   * @return Whether the messageBatchCreatedEventData field is set.
   */
  @java.lang.Override
  public boolean hasMessageBatchCreatedEventData() {
    return payloadCase_ == 26;
  }

  /**
   *
   *
   * <pre>
   * Event payload for multiple new messages.
   *
   * Event type: `google.workspace.chat.message.v1.batchCreated`
   * </pre>
   *
   * <code>.google.chat.v1.MessageBatchCreatedEventData message_batch_created_event_data = 26;
   * </code>
   *
   * @return The messageBatchCreatedEventData.
   */
  @java.lang.Override
  public com.google.chat.v1.MessageBatchCreatedEventData getMessageBatchCreatedEventData() {
    if (payloadCase_ == 26) {
      return (com.google.chat.v1.MessageBatchCreatedEventData) payload_;
    }
    return com.google.chat.v1.MessageBatchCreatedEventData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Event payload for multiple new messages.
   *
   * Event type: `google.workspace.chat.message.v1.batchCreated`
   * </pre>
   *
   * <code>.google.chat.v1.MessageBatchCreatedEventData message_batch_created_event_data = 26;
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.MessageBatchCreatedEventDataOrBuilder
      getMessageBatchCreatedEventDataOrBuilder() {
    if (payloadCase_ == 26) {
      return (com.google.chat.v1.MessageBatchCreatedEventData) payload_;
    }
    return com.google.chat.v1.MessageBatchCreatedEventData.getDefaultInstance();
  }

  public static final int MESSAGE_BATCH_UPDATED_EVENT_DATA_FIELD_NUMBER = 27;

  /**
   *
   *
   * <pre>
   * Event payload for multiple updated messages.
   *
   * Event type: `google.workspace.chat.message.v1.batchUpdated`
   * </pre>
   *
   * <code>.google.chat.v1.MessageBatchUpdatedEventData message_batch_updated_event_data = 27;
   * </code>
   *
   * @return Whether the messageBatchUpdatedEventData field is set.
   */
  @java.lang.Override
  public boolean hasMessageBatchUpdatedEventData() {
    return payloadCase_ == 27;
  }

  /**
   *
   *
   * <pre>
   * Event payload for multiple updated messages.
   *
   * Event type: `google.workspace.chat.message.v1.batchUpdated`
   * </pre>
   *
   * <code>.google.chat.v1.MessageBatchUpdatedEventData message_batch_updated_event_data = 27;
   * </code>
   *
   * @return The messageBatchUpdatedEventData.
   */
  @java.lang.Override
  public com.google.chat.v1.MessageBatchUpdatedEventData getMessageBatchUpdatedEventData() {
    if (payloadCase_ == 27) {
      return (com.google.chat.v1.MessageBatchUpdatedEventData) payload_;
    }
    return com.google.chat.v1.MessageBatchUpdatedEventData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Event payload for multiple updated messages.
   *
   * Event type: `google.workspace.chat.message.v1.batchUpdated`
   * </pre>
   *
   * <code>.google.chat.v1.MessageBatchUpdatedEventData message_batch_updated_event_data = 27;
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.MessageBatchUpdatedEventDataOrBuilder
      getMessageBatchUpdatedEventDataOrBuilder() {
    if (payloadCase_ == 27) {
      return (com.google.chat.v1.MessageBatchUpdatedEventData) payload_;
    }
    return com.google.chat.v1.MessageBatchUpdatedEventData.getDefaultInstance();
  }

  public static final int MESSAGE_BATCH_DELETED_EVENT_DATA_FIELD_NUMBER = 28;

  /**
   *
   *
   * <pre>
   * Event payload for multiple deleted messages.
   *
   * Event type: `google.workspace.chat.message.v1.batchDeleted`
   * </pre>
   *
   * <code>.google.chat.v1.MessageBatchDeletedEventData message_batch_deleted_event_data = 28;
   * </code>
   *
   * @return Whether the messageBatchDeletedEventData field is set.
   */
  @java.lang.Override
  public boolean hasMessageBatchDeletedEventData() {
    return payloadCase_ == 28;
  }

  /**
   *
   *
   * <pre>
   * Event payload for multiple deleted messages.
   *
   * Event type: `google.workspace.chat.message.v1.batchDeleted`
   * </pre>
   *
   * <code>.google.chat.v1.MessageBatchDeletedEventData message_batch_deleted_event_data = 28;
   * </code>
   *
   * @return The messageBatchDeletedEventData.
   */
  @java.lang.Override
  public com.google.chat.v1.MessageBatchDeletedEventData getMessageBatchDeletedEventData() {
    if (payloadCase_ == 28) {
      return (com.google.chat.v1.MessageBatchDeletedEventData) payload_;
    }
    return com.google.chat.v1.MessageBatchDeletedEventData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Event payload for multiple deleted messages.
   *
   * Event type: `google.workspace.chat.message.v1.batchDeleted`
   * </pre>
   *
   * <code>.google.chat.v1.MessageBatchDeletedEventData message_batch_deleted_event_data = 28;
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.MessageBatchDeletedEventDataOrBuilder
      getMessageBatchDeletedEventDataOrBuilder() {
    if (payloadCase_ == 28) {
      return (com.google.chat.v1.MessageBatchDeletedEventData) payload_;
    }
    return com.google.chat.v1.MessageBatchDeletedEventData.getDefaultInstance();
  }

  public static final int SPACE_UPDATED_EVENT_DATA_FIELD_NUMBER = 15;

  /**
   *
   *
   * <pre>
   * Event payload for a space update.
   *
   * Event type: `google.workspace.chat.space.v1.updated`
   * </pre>
   *
   * <code>.google.chat.v1.SpaceUpdatedEventData space_updated_event_data = 15;</code>
   *
   * @return Whether the spaceUpdatedEventData field is set.
   */
  @java.lang.Override
  public boolean hasSpaceUpdatedEventData() {
    return payloadCase_ == 15;
  }

  /**
   *
   *
   * <pre>
   * Event payload for a space update.
   *
   * Event type: `google.workspace.chat.space.v1.updated`
   * </pre>
   *
   * <code>.google.chat.v1.SpaceUpdatedEventData space_updated_event_data = 15;</code>
   *
   * @return The spaceUpdatedEventData.
   */
  @java.lang.Override
  public com.google.chat.v1.SpaceUpdatedEventData getSpaceUpdatedEventData() {
    if (payloadCase_ == 15) {
      return (com.google.chat.v1.SpaceUpdatedEventData) payload_;
    }
    return com.google.chat.v1.SpaceUpdatedEventData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Event payload for a space update.
   *
   * Event type: `google.workspace.chat.space.v1.updated`
   * </pre>
   *
   * <code>.google.chat.v1.SpaceUpdatedEventData space_updated_event_data = 15;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.SpaceUpdatedEventDataOrBuilder getSpaceUpdatedEventDataOrBuilder() {
    if (payloadCase_ == 15) {
      return (com.google.chat.v1.SpaceUpdatedEventData) payload_;
    }
    return com.google.chat.v1.SpaceUpdatedEventData.getDefaultInstance();
  }

  public static final int SPACE_BATCH_UPDATED_EVENT_DATA_FIELD_NUMBER = 29;

  /**
   *
   *
   * <pre>
   * Event payload for multiple updates to a space.
   *
   * Event type: `google.workspace.chat.space.v1.batchUpdated`
   * </pre>
   *
   * <code>.google.chat.v1.SpaceBatchUpdatedEventData space_batch_updated_event_data = 29;</code>
   *
   * @return Whether the spaceBatchUpdatedEventData field is set.
   */
  @java.lang.Override
  public boolean hasSpaceBatchUpdatedEventData() {
    return payloadCase_ == 29;
  }

  /**
   *
   *
   * <pre>
   * Event payload for multiple updates to a space.
   *
   * Event type: `google.workspace.chat.space.v1.batchUpdated`
   * </pre>
   *
   * <code>.google.chat.v1.SpaceBatchUpdatedEventData space_batch_updated_event_data = 29;</code>
   *
   * @return The spaceBatchUpdatedEventData.
   */
  @java.lang.Override
  public com.google.chat.v1.SpaceBatchUpdatedEventData getSpaceBatchUpdatedEventData() {
    if (payloadCase_ == 29) {
      return (com.google.chat.v1.SpaceBatchUpdatedEventData) payload_;
    }
    return com.google.chat.v1.SpaceBatchUpdatedEventData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Event payload for multiple updates to a space.
   *
   * Event type: `google.workspace.chat.space.v1.batchUpdated`
   * </pre>
   *
   * <code>.google.chat.v1.SpaceBatchUpdatedEventData space_batch_updated_event_data = 29;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.SpaceBatchUpdatedEventDataOrBuilder
      getSpaceBatchUpdatedEventDataOrBuilder() {
    if (payloadCase_ == 29) {
      return (com.google.chat.v1.SpaceBatchUpdatedEventData) payload_;
    }
    return com.google.chat.v1.SpaceBatchUpdatedEventData.getDefaultInstance();
  }

  public static final int MEMBERSHIP_CREATED_EVENT_DATA_FIELD_NUMBER = 17;

  /**
   *
   *
   * <pre>
   * Event payload for a new membership.
   *
   * Event type: `google.workspace.chat.membership.v1.created`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipCreatedEventData membership_created_event_data = 17;</code>
   *
   * @return Whether the membershipCreatedEventData field is set.
   */
  @java.lang.Override
  public boolean hasMembershipCreatedEventData() {
    return payloadCase_ == 17;
  }

  /**
   *
   *
   * <pre>
   * Event payload for a new membership.
   *
   * Event type: `google.workspace.chat.membership.v1.created`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipCreatedEventData membership_created_event_data = 17;</code>
   *
   * @return The membershipCreatedEventData.
   */
  @java.lang.Override
  public com.google.chat.v1.MembershipCreatedEventData getMembershipCreatedEventData() {
    if (payloadCase_ == 17) {
      return (com.google.chat.v1.MembershipCreatedEventData) payload_;
    }
    return com.google.chat.v1.MembershipCreatedEventData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Event payload for a new membership.
   *
   * Event type: `google.workspace.chat.membership.v1.created`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipCreatedEventData membership_created_event_data = 17;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.MembershipCreatedEventDataOrBuilder
      getMembershipCreatedEventDataOrBuilder() {
    if (payloadCase_ == 17) {
      return (com.google.chat.v1.MembershipCreatedEventData) payload_;
    }
    return com.google.chat.v1.MembershipCreatedEventData.getDefaultInstance();
  }

  public static final int MEMBERSHIP_UPDATED_EVENT_DATA_FIELD_NUMBER = 18;

  /**
   *
   *
   * <pre>
   * Event payload for an updated membership.
   *
   * Event type: `google.workspace.chat.membership.v1.updated`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipUpdatedEventData membership_updated_event_data = 18;</code>
   *
   * @return Whether the membershipUpdatedEventData field is set.
   */
  @java.lang.Override
  public boolean hasMembershipUpdatedEventData() {
    return payloadCase_ == 18;
  }

  /**
   *
   *
   * <pre>
   * Event payload for an updated membership.
   *
   * Event type: `google.workspace.chat.membership.v1.updated`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipUpdatedEventData membership_updated_event_data = 18;</code>
   *
   * @return The membershipUpdatedEventData.
   */
  @java.lang.Override
  public com.google.chat.v1.MembershipUpdatedEventData getMembershipUpdatedEventData() {
    if (payloadCase_ == 18) {
      return (com.google.chat.v1.MembershipUpdatedEventData) payload_;
    }
    return com.google.chat.v1.MembershipUpdatedEventData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Event payload for an updated membership.
   *
   * Event type: `google.workspace.chat.membership.v1.updated`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipUpdatedEventData membership_updated_event_data = 18;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.MembershipUpdatedEventDataOrBuilder
      getMembershipUpdatedEventDataOrBuilder() {
    if (payloadCase_ == 18) {
      return (com.google.chat.v1.MembershipUpdatedEventData) payload_;
    }
    return com.google.chat.v1.MembershipUpdatedEventData.getDefaultInstance();
  }

  public static final int MEMBERSHIP_DELETED_EVENT_DATA_FIELD_NUMBER = 219;

  /**
   *
   *
   * <pre>
   * Event payload for a deleted membership.
   *
   * Event type: `google.workspace.chat.membership.v1.deleted`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipDeletedEventData membership_deleted_event_data = 219;</code>
   *
   * @return Whether the membershipDeletedEventData field is set.
   */
  @java.lang.Override
  public boolean hasMembershipDeletedEventData() {
    return payloadCase_ == 219;
  }

  /**
   *
   *
   * <pre>
   * Event payload for a deleted membership.
   *
   * Event type: `google.workspace.chat.membership.v1.deleted`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipDeletedEventData membership_deleted_event_data = 219;</code>
   *
   * @return The membershipDeletedEventData.
   */
  @java.lang.Override
  public com.google.chat.v1.MembershipDeletedEventData getMembershipDeletedEventData() {
    if (payloadCase_ == 219) {
      return (com.google.chat.v1.MembershipDeletedEventData) payload_;
    }
    return com.google.chat.v1.MembershipDeletedEventData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Event payload for a deleted membership.
   *
   * Event type: `google.workspace.chat.membership.v1.deleted`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipDeletedEventData membership_deleted_event_data = 219;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.MembershipDeletedEventDataOrBuilder
      getMembershipDeletedEventDataOrBuilder() {
    if (payloadCase_ == 219) {
      return (com.google.chat.v1.MembershipDeletedEventData) payload_;
    }
    return com.google.chat.v1.MembershipDeletedEventData.getDefaultInstance();
  }

  public static final int MEMBERSHIP_BATCH_CREATED_EVENT_DATA_FIELD_NUMBER = 31;

  /**
   *
   *
   * <pre>
   * Event payload for multiple new memberships.
   *
   * Event type: `google.workspace.chat.membership.v1.batchCreated`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipBatchCreatedEventData membership_batch_created_event_data = 31;
   * </code>
   *
   * @return Whether the membershipBatchCreatedEventData field is set.
   */
  @java.lang.Override
  public boolean hasMembershipBatchCreatedEventData() {
    return payloadCase_ == 31;
  }

  /**
   *
   *
   * <pre>
   * Event payload for multiple new memberships.
   *
   * Event type: `google.workspace.chat.membership.v1.batchCreated`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipBatchCreatedEventData membership_batch_created_event_data = 31;
   * </code>
   *
   * @return The membershipBatchCreatedEventData.
   */
  @java.lang.Override
  public com.google.chat.v1.MembershipBatchCreatedEventData getMembershipBatchCreatedEventData() {
    if (payloadCase_ == 31) {
      return (com.google.chat.v1.MembershipBatchCreatedEventData) payload_;
    }
    return com.google.chat.v1.MembershipBatchCreatedEventData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Event payload for multiple new memberships.
   *
   * Event type: `google.workspace.chat.membership.v1.batchCreated`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipBatchCreatedEventData membership_batch_created_event_data = 31;
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.MembershipBatchCreatedEventDataOrBuilder
      getMembershipBatchCreatedEventDataOrBuilder() {
    if (payloadCase_ == 31) {
      return (com.google.chat.v1.MembershipBatchCreatedEventData) payload_;
    }
    return com.google.chat.v1.MembershipBatchCreatedEventData.getDefaultInstance();
  }

  public static final int MEMBERSHIP_BATCH_UPDATED_EVENT_DATA_FIELD_NUMBER = 32;

  /**
   *
   *
   * <pre>
   * Event payload for multiple updated memberships.
   *
   * Event type: `google.workspace.chat.membership.v1.batchUpdated`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipBatchUpdatedEventData membership_batch_updated_event_data = 32;
   * </code>
   *
   * @return Whether the membershipBatchUpdatedEventData field is set.
   */
  @java.lang.Override
  public boolean hasMembershipBatchUpdatedEventData() {
    return payloadCase_ == 32;
  }

  /**
   *
   *
   * <pre>
   * Event payload for multiple updated memberships.
   *
   * Event type: `google.workspace.chat.membership.v1.batchUpdated`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipBatchUpdatedEventData membership_batch_updated_event_data = 32;
   * </code>
   *
   * @return The membershipBatchUpdatedEventData.
   */
  @java.lang.Override
  public com.google.chat.v1.MembershipBatchUpdatedEventData getMembershipBatchUpdatedEventData() {
    if (payloadCase_ == 32) {
      return (com.google.chat.v1.MembershipBatchUpdatedEventData) payload_;
    }
    return com.google.chat.v1.MembershipBatchUpdatedEventData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Event payload for multiple updated memberships.
   *
   * Event type: `google.workspace.chat.membership.v1.batchUpdated`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipBatchUpdatedEventData membership_batch_updated_event_data = 32;
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.MembershipBatchUpdatedEventDataOrBuilder
      getMembershipBatchUpdatedEventDataOrBuilder() {
    if (payloadCase_ == 32) {
      return (com.google.chat.v1.MembershipBatchUpdatedEventData) payload_;
    }
    return com.google.chat.v1.MembershipBatchUpdatedEventData.getDefaultInstance();
  }

  public static final int MEMBERSHIP_BATCH_DELETED_EVENT_DATA_FIELD_NUMBER = 33;

  /**
   *
   *
   * <pre>
   * Event payload for multiple deleted memberships.
   *
   * Event type: `google.workspace.chat.membership.v1.batchDeleted`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipBatchDeletedEventData membership_batch_deleted_event_data = 33;
   * </code>
   *
   * @return Whether the membershipBatchDeletedEventData field is set.
   */
  @java.lang.Override
  public boolean hasMembershipBatchDeletedEventData() {
    return payloadCase_ == 33;
  }

  /**
   *
   *
   * <pre>
   * Event payload for multiple deleted memberships.
   *
   * Event type: `google.workspace.chat.membership.v1.batchDeleted`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipBatchDeletedEventData membership_batch_deleted_event_data = 33;
   * </code>
   *
   * @return The membershipBatchDeletedEventData.
   */
  @java.lang.Override
  public com.google.chat.v1.MembershipBatchDeletedEventData getMembershipBatchDeletedEventData() {
    if (payloadCase_ == 33) {
      return (com.google.chat.v1.MembershipBatchDeletedEventData) payload_;
    }
    return com.google.chat.v1.MembershipBatchDeletedEventData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Event payload for multiple deleted memberships.
   *
   * Event type: `google.workspace.chat.membership.v1.batchDeleted`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipBatchDeletedEventData membership_batch_deleted_event_data = 33;
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.MembershipBatchDeletedEventDataOrBuilder
      getMembershipBatchDeletedEventDataOrBuilder() {
    if (payloadCase_ == 33) {
      return (com.google.chat.v1.MembershipBatchDeletedEventData) payload_;
    }
    return com.google.chat.v1.MembershipBatchDeletedEventData.getDefaultInstance();
  }

  public static final int REACTION_CREATED_EVENT_DATA_FIELD_NUMBER = 21;

  /**
   *
   *
   * <pre>
   * Event payload for a new reaction.
   *
   * Event type: `google.workspace.chat.reaction.v1.created`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionCreatedEventData reaction_created_event_data = 21;</code>
   *
   * @return Whether the reactionCreatedEventData field is set.
   */
  @java.lang.Override
  public boolean hasReactionCreatedEventData() {
    return payloadCase_ == 21;
  }

  /**
   *
   *
   * <pre>
   * Event payload for a new reaction.
   *
   * Event type: `google.workspace.chat.reaction.v1.created`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionCreatedEventData reaction_created_event_data = 21;</code>
   *
   * @return The reactionCreatedEventData.
   */
  @java.lang.Override
  public com.google.chat.v1.ReactionCreatedEventData getReactionCreatedEventData() {
    if (payloadCase_ == 21) {
      return (com.google.chat.v1.ReactionCreatedEventData) payload_;
    }
    return com.google.chat.v1.ReactionCreatedEventData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Event payload for a new reaction.
   *
   * Event type: `google.workspace.chat.reaction.v1.created`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionCreatedEventData reaction_created_event_data = 21;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.ReactionCreatedEventDataOrBuilder
      getReactionCreatedEventDataOrBuilder() {
    if (payloadCase_ == 21) {
      return (com.google.chat.v1.ReactionCreatedEventData) payload_;
    }
    return com.google.chat.v1.ReactionCreatedEventData.getDefaultInstance();
  }

  public static final int REACTION_DELETED_EVENT_DATA_FIELD_NUMBER = 22;

  /**
   *
   *
   * <pre>
   * Event payload for a deleted reaction.
   *
   * Event type: `google.workspace.chat.reaction.v1.deleted`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionDeletedEventData reaction_deleted_event_data = 22;</code>
   *
   * @return Whether the reactionDeletedEventData field is set.
   */
  @java.lang.Override
  public boolean hasReactionDeletedEventData() {
    return payloadCase_ == 22;
  }

  /**
   *
   *
   * <pre>
   * Event payload for a deleted reaction.
   *
   * Event type: `google.workspace.chat.reaction.v1.deleted`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionDeletedEventData reaction_deleted_event_data = 22;</code>
   *
   * @return The reactionDeletedEventData.
   */
  @java.lang.Override
  public com.google.chat.v1.ReactionDeletedEventData getReactionDeletedEventData() {
    if (payloadCase_ == 22) {
      return (com.google.chat.v1.ReactionDeletedEventData) payload_;
    }
    return com.google.chat.v1.ReactionDeletedEventData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Event payload for a deleted reaction.
   *
   * Event type: `google.workspace.chat.reaction.v1.deleted`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionDeletedEventData reaction_deleted_event_data = 22;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.ReactionDeletedEventDataOrBuilder
      getReactionDeletedEventDataOrBuilder() {
    if (payloadCase_ == 22) {
      return (com.google.chat.v1.ReactionDeletedEventData) payload_;
    }
    return com.google.chat.v1.ReactionDeletedEventData.getDefaultInstance();
  }

  public static final int REACTION_BATCH_CREATED_EVENT_DATA_FIELD_NUMBER = 34;

  /**
   *
   *
   * <pre>
   * Event payload for multiple new reactions.
   *
   * Event type: `google.workspace.chat.reaction.v1.batchCreated`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionBatchCreatedEventData reaction_batch_created_event_data = 34;
   * </code>
   *
   * @return Whether the reactionBatchCreatedEventData field is set.
   */
  @java.lang.Override
  public boolean hasReactionBatchCreatedEventData() {
    return payloadCase_ == 34;
  }

  /**
   *
   *
   * <pre>
   * Event payload for multiple new reactions.
   *
   * Event type: `google.workspace.chat.reaction.v1.batchCreated`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionBatchCreatedEventData reaction_batch_created_event_data = 34;
   * </code>
   *
   * @return The reactionBatchCreatedEventData.
   */
  @java.lang.Override
  public com.google.chat.v1.ReactionBatchCreatedEventData getReactionBatchCreatedEventData() {
    if (payloadCase_ == 34) {
      return (com.google.chat.v1.ReactionBatchCreatedEventData) payload_;
    }
    return com.google.chat.v1.ReactionBatchCreatedEventData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Event payload for multiple new reactions.
   *
   * Event type: `google.workspace.chat.reaction.v1.batchCreated`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionBatchCreatedEventData reaction_batch_created_event_data = 34;
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.ReactionBatchCreatedEventDataOrBuilder
      getReactionBatchCreatedEventDataOrBuilder() {
    if (payloadCase_ == 34) {
      return (com.google.chat.v1.ReactionBatchCreatedEventData) payload_;
    }
    return com.google.chat.v1.ReactionBatchCreatedEventData.getDefaultInstance();
  }

  public static final int REACTION_BATCH_DELETED_EVENT_DATA_FIELD_NUMBER = 35;

  /**
   *
   *
   * <pre>
   * Event payload for multiple deleted reactions.
   *
   * Event type: `google.workspace.chat.reaction.v1.batchDeleted`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionBatchDeletedEventData reaction_batch_deleted_event_data = 35;
   * </code>
   *
   * @return Whether the reactionBatchDeletedEventData field is set.
   */
  @java.lang.Override
  public boolean hasReactionBatchDeletedEventData() {
    return payloadCase_ == 35;
  }

  /**
   *
   *
   * <pre>
   * Event payload for multiple deleted reactions.
   *
   * Event type: `google.workspace.chat.reaction.v1.batchDeleted`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionBatchDeletedEventData reaction_batch_deleted_event_data = 35;
   * </code>
   *
   * @return The reactionBatchDeletedEventData.
   */
  @java.lang.Override
  public com.google.chat.v1.ReactionBatchDeletedEventData getReactionBatchDeletedEventData() {
    if (payloadCase_ == 35) {
      return (com.google.chat.v1.ReactionBatchDeletedEventData) payload_;
    }
    return com.google.chat.v1.ReactionBatchDeletedEventData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Event payload for multiple deleted reactions.
   *
   * Event type: `google.workspace.chat.reaction.v1.batchDeleted`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionBatchDeletedEventData reaction_batch_deleted_event_data = 35;
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.ReactionBatchDeletedEventDataOrBuilder
      getReactionBatchDeletedEventDataOrBuilder() {
    if (payloadCase_ == 35) {
      return (com.google.chat.v1.ReactionBatchDeletedEventData) payload_;
    }
    return com.google.chat.v1.ReactionBatchDeletedEventData.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getEventTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(eventType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, eventType_);
    }
    if (payloadCase_ == 12) {
      output.writeMessage(12, (com.google.chat.v1.MessageCreatedEventData) payload_);
    }
    if (payloadCase_ == 13) {
      output.writeMessage(13, (com.google.chat.v1.MessageUpdatedEventData) payload_);
    }
    if (payloadCase_ == 14) {
      output.writeMessage(14, (com.google.chat.v1.MessageDeletedEventData) payload_);
    }
    if (payloadCase_ == 15) {
      output.writeMessage(15, (com.google.chat.v1.SpaceUpdatedEventData) payload_);
    }
    if (payloadCase_ == 17) {
      output.writeMessage(17, (com.google.chat.v1.MembershipCreatedEventData) payload_);
    }
    if (payloadCase_ == 18) {
      output.writeMessage(18, (com.google.chat.v1.MembershipUpdatedEventData) payload_);
    }
    if (payloadCase_ == 21) {
      output.writeMessage(21, (com.google.chat.v1.ReactionCreatedEventData) payload_);
    }
    if (payloadCase_ == 22) {
      output.writeMessage(22, (com.google.chat.v1.ReactionDeletedEventData) payload_);
    }
    if (payloadCase_ == 26) {
      output.writeMessage(26, (com.google.chat.v1.MessageBatchCreatedEventData) payload_);
    }
    if (payloadCase_ == 27) {
      output.writeMessage(27, (com.google.chat.v1.MessageBatchUpdatedEventData) payload_);
    }
    if (payloadCase_ == 28) {
      output.writeMessage(28, (com.google.chat.v1.MessageBatchDeletedEventData) payload_);
    }
    if (payloadCase_ == 29) {
      output.writeMessage(29, (com.google.chat.v1.SpaceBatchUpdatedEventData) payload_);
    }
    if (payloadCase_ == 31) {
      output.writeMessage(31, (com.google.chat.v1.MembershipBatchCreatedEventData) payload_);
    }
    if (payloadCase_ == 32) {
      output.writeMessage(32, (com.google.chat.v1.MembershipBatchUpdatedEventData) payload_);
    }
    if (payloadCase_ == 33) {
      output.writeMessage(33, (com.google.chat.v1.MembershipBatchDeletedEventData) payload_);
    }
    if (payloadCase_ == 34) {
      output.writeMessage(34, (com.google.chat.v1.ReactionBatchCreatedEventData) payload_);
    }
    if (payloadCase_ == 35) {
      output.writeMessage(35, (com.google.chat.v1.ReactionBatchDeletedEventData) payload_);
    }
    if (payloadCase_ == 219) {
      output.writeMessage(219, (com.google.chat.v1.MembershipDeletedEventData) payload_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getEventTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(eventType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, eventType_);
    }
    if (payloadCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.chat.v1.MessageCreatedEventData) payload_);
    }
    if (payloadCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, (com.google.chat.v1.MessageUpdatedEventData) payload_);
    }
    if (payloadCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, (com.google.chat.v1.MessageDeletedEventData) payload_);
    }
    if (payloadCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, (com.google.chat.v1.SpaceUpdatedEventData) payload_);
    }
    if (payloadCase_ == 17) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, (com.google.chat.v1.MembershipCreatedEventData) payload_);
    }
    if (payloadCase_ == 18) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18, (com.google.chat.v1.MembershipUpdatedEventData) payload_);
    }
    if (payloadCase_ == 21) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              21, (com.google.chat.v1.ReactionCreatedEventData) payload_);
    }
    if (payloadCase_ == 22) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              22, (com.google.chat.v1.ReactionDeletedEventData) payload_);
    }
    if (payloadCase_ == 26) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              26, (com.google.chat.v1.MessageBatchCreatedEventData) payload_);
    }
    if (payloadCase_ == 27) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              27, (com.google.chat.v1.MessageBatchUpdatedEventData) payload_);
    }
    if (payloadCase_ == 28) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              28, (com.google.chat.v1.MessageBatchDeletedEventData) payload_);
    }
    if (payloadCase_ == 29) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              29, (com.google.chat.v1.SpaceBatchUpdatedEventData) payload_);
    }
    if (payloadCase_ == 31) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              31, (com.google.chat.v1.MembershipBatchCreatedEventData) payload_);
    }
    if (payloadCase_ == 32) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              32, (com.google.chat.v1.MembershipBatchUpdatedEventData) payload_);
    }
    if (payloadCase_ == 33) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              33, (com.google.chat.v1.MembershipBatchDeletedEventData) payload_);
    }
    if (payloadCase_ == 34) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              34, (com.google.chat.v1.ReactionBatchCreatedEventData) payload_);
    }
    if (payloadCase_ == 35) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              35, (com.google.chat.v1.ReactionBatchDeletedEventData) payload_);
    }
    if (payloadCase_ == 219) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              219, (com.google.chat.v1.MembershipDeletedEventData) payload_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.SpaceEvent)) {
      return super.equals(obj);
    }
    com.google.chat.v1.SpaceEvent other = (com.google.chat.v1.SpaceEvent) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasEventTime() != other.hasEventTime()) return false;
    if (hasEventTime()) {
      if (!getEventTime().equals(other.getEventTime())) return false;
    }
    if (!getEventType().equals(other.getEventType())) return false;
    if (!getPayloadCase().equals(other.getPayloadCase())) return false;
    switch (payloadCase_) {
      case 12:
        if (!getMessageCreatedEventData().equals(other.getMessageCreatedEventData())) return false;
        break;
      case 13:
        if (!getMessageUpdatedEventData().equals(other.getMessageUpdatedEventData())) return false;
        break;
      case 14:
        if (!getMessageDeletedEventData().equals(other.getMessageDeletedEventData())) return false;
        break;
      case 26:
        if (!getMessageBatchCreatedEventData().equals(other.getMessageBatchCreatedEventData()))
          return false;
        break;
      case 27:
        if (!getMessageBatchUpdatedEventData().equals(other.getMessageBatchUpdatedEventData()))
          return false;
        break;
      case 28:
        if (!getMessageBatchDeletedEventData().equals(other.getMessageBatchDeletedEventData()))
          return false;
        break;
      case 15:
        if (!getSpaceUpdatedEventData().equals(other.getSpaceUpdatedEventData())) return false;
        break;
      case 29:
        if (!getSpaceBatchUpdatedEventData().equals(other.getSpaceBatchUpdatedEventData()))
          return false;
        break;
      case 17:
        if (!getMembershipCreatedEventData().equals(other.getMembershipCreatedEventData()))
          return false;
        break;
      case 18:
        if (!getMembershipUpdatedEventData().equals(other.getMembershipUpdatedEventData()))
          return false;
        break;
      case 219:
        if (!getMembershipDeletedEventData().equals(other.getMembershipDeletedEventData()))
          return false;
        break;
      case 31:
        if (!getMembershipBatchCreatedEventData()
            .equals(other.getMembershipBatchCreatedEventData())) return false;
        break;
      case 32:
        if (!getMembershipBatchUpdatedEventData()
            .equals(other.getMembershipBatchUpdatedEventData())) return false;
        break;
      case 33:
        if (!getMembershipBatchDeletedEventData()
            .equals(other.getMembershipBatchDeletedEventData())) return false;
        break;
      case 21:
        if (!getReactionCreatedEventData().equals(other.getReactionCreatedEventData()))
          return false;
        break;
      case 22:
        if (!getReactionDeletedEventData().equals(other.getReactionDeletedEventData()))
          return false;
        break;
      case 34:
        if (!getReactionBatchCreatedEventData().equals(other.getReactionBatchCreatedEventData()))
          return false;
        break;
      case 35:
        if (!getReactionBatchDeletedEventData().equals(other.getReactionBatchDeletedEventData()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasEventTime()) {
      hash = (37 * hash) + EVENT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEventTime().hashCode();
    }
    hash = (37 * hash) + EVENT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getEventType().hashCode();
    switch (payloadCase_) {
      case 12:
        hash = (37 * hash) + MESSAGE_CREATED_EVENT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getMessageCreatedEventData().hashCode();
        break;
      case 13:
        hash = (37 * hash) + MESSAGE_UPDATED_EVENT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getMessageUpdatedEventData().hashCode();
        break;
      case 14:
        hash = (37 * hash) + MESSAGE_DELETED_EVENT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getMessageDeletedEventData().hashCode();
        break;
      case 26:
        hash = (37 * hash) + MESSAGE_BATCH_CREATED_EVENT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getMessageBatchCreatedEventData().hashCode();
        break;
      case 27:
        hash = (37 * hash) + MESSAGE_BATCH_UPDATED_EVENT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getMessageBatchUpdatedEventData().hashCode();
        break;
      case 28:
        hash = (37 * hash) + MESSAGE_BATCH_DELETED_EVENT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getMessageBatchDeletedEventData().hashCode();
        break;
      case 15:
        hash = (37 * hash) + SPACE_UPDATED_EVENT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getSpaceUpdatedEventData().hashCode();
        break;
      case 29:
        hash = (37 * hash) + SPACE_BATCH_UPDATED_EVENT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getSpaceBatchUpdatedEventData().hashCode();
        break;
      case 17:
        hash = (37 * hash) + MEMBERSHIP_CREATED_EVENT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getMembershipCreatedEventData().hashCode();
        break;
      case 18:
        hash = (37 * hash) + MEMBERSHIP_UPDATED_EVENT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getMembershipUpdatedEventData().hashCode();
        break;
      case 219:
        hash = (37 * hash) + MEMBERSHIP_DELETED_EVENT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getMembershipDeletedEventData().hashCode();
        break;
      case 31:
        hash = (37 * hash) + MEMBERSHIP_BATCH_CREATED_EVENT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getMembershipBatchCreatedEventData().hashCode();
        break;
      case 32:
        hash = (37 * hash) + MEMBERSHIP_BATCH_UPDATED_EVENT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getMembershipBatchUpdatedEventData().hashCode();
        break;
      case 33:
        hash = (37 * hash) + MEMBERSHIP_BATCH_DELETED_EVENT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getMembershipBatchDeletedEventData().hashCode();
        break;
      case 21:
        hash = (37 * hash) + REACTION_CREATED_EVENT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getReactionCreatedEventData().hashCode();
        break;
      case 22:
        hash = (37 * hash) + REACTION_DELETED_EVENT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getReactionDeletedEventData().hashCode();
        break;
      case 34:
        hash = (37 * hash) + REACTION_BATCH_CREATED_EVENT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getReactionBatchCreatedEventData().hashCode();
        break;
      case 35:
        hash = (37 * hash) + REACTION_BATCH_DELETED_EVENT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getReactionBatchDeletedEventData().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.SpaceEvent parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.SpaceEvent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.SpaceEvent parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.SpaceEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.SpaceEvent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.SpaceEvent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.SpaceEvent parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.SpaceEvent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.SpaceEvent parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.SpaceEvent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.SpaceEvent parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.SpaceEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.SpaceEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * An event that represents a change or activity in a Google Chat space. To
   * learn more, see [Work with events from Google
   * Chat](https://developers.google.com/workspace/chat/events-overview).
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.SpaceEvent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.SpaceEvent)
      com.google.chat.v1.SpaceEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.SpaceEventProto
          .internal_static_google_chat_v1_SpaceEvent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.SpaceEventProto
          .internal_static_google_chat_v1_SpaceEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.SpaceEvent.class, com.google.chat.v1.SpaceEvent.Builder.class);
    }

    // Construct using com.google.chat.v1.SpaceEvent.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEventTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      eventTime_ = null;
      if (eventTimeBuilder_ != null) {
        eventTimeBuilder_.dispose();
        eventTimeBuilder_ = null;
      }
      eventType_ = "";
      if (messageCreatedEventDataBuilder_ != null) {
        messageCreatedEventDataBuilder_.clear();
      }
      if (messageUpdatedEventDataBuilder_ != null) {
        messageUpdatedEventDataBuilder_.clear();
      }
      if (messageDeletedEventDataBuilder_ != null) {
        messageDeletedEventDataBuilder_.clear();
      }
      if (messageBatchCreatedEventDataBuilder_ != null) {
        messageBatchCreatedEventDataBuilder_.clear();
      }
      if (messageBatchUpdatedEventDataBuilder_ != null) {
        messageBatchUpdatedEventDataBuilder_.clear();
      }
      if (messageBatchDeletedEventDataBuilder_ != null) {
        messageBatchDeletedEventDataBuilder_.clear();
      }
      if (spaceUpdatedEventDataBuilder_ != null) {
        spaceUpdatedEventDataBuilder_.clear();
      }
      if (spaceBatchUpdatedEventDataBuilder_ != null) {
        spaceBatchUpdatedEventDataBuilder_.clear();
      }
      if (membershipCreatedEventDataBuilder_ != null) {
        membershipCreatedEventDataBuilder_.clear();
      }
      if (membershipUpdatedEventDataBuilder_ != null) {
        membershipUpdatedEventDataBuilder_.clear();
      }
      if (membershipDeletedEventDataBuilder_ != null) {
        membershipDeletedEventDataBuilder_.clear();
      }
      if (membershipBatchCreatedEventDataBuilder_ != null) {
        membershipBatchCreatedEventDataBuilder_.clear();
      }
      if (membershipBatchUpdatedEventDataBuilder_ != null) {
        membershipBatchUpdatedEventDataBuilder_.clear();
      }
      if (membershipBatchDeletedEventDataBuilder_ != null) {
        membershipBatchDeletedEventDataBuilder_.clear();
      }
      if (reactionCreatedEventDataBuilder_ != null) {
        reactionCreatedEventDataBuilder_.clear();
      }
      if (reactionDeletedEventDataBuilder_ != null) {
        reactionDeletedEventDataBuilder_.clear();
      }
      if (reactionBatchCreatedEventDataBuilder_ != null) {
        reactionBatchCreatedEventDataBuilder_.clear();
      }
      if (reactionBatchDeletedEventDataBuilder_ != null) {
        reactionBatchDeletedEventDataBuilder_.clear();
      }
      payloadCase_ = 0;
      payload_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.SpaceEventProto
          .internal_static_google_chat_v1_SpaceEvent_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.SpaceEvent getDefaultInstanceForType() {
      return com.google.chat.v1.SpaceEvent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.SpaceEvent build() {
      com.google.chat.v1.SpaceEvent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.SpaceEvent buildPartial() {
      com.google.chat.v1.SpaceEvent result = new com.google.chat.v1.SpaceEvent(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.chat.v1.SpaceEvent result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.eventTime_ = eventTimeBuilder_ == null ? eventTime_ : eventTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.eventType_ = eventType_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.chat.v1.SpaceEvent result) {
      result.payloadCase_ = payloadCase_;
      result.payload_ = this.payload_;
      if (payloadCase_ == 12 && messageCreatedEventDataBuilder_ != null) {
        result.payload_ = messageCreatedEventDataBuilder_.build();
      }
      if (payloadCase_ == 13 && messageUpdatedEventDataBuilder_ != null) {
        result.payload_ = messageUpdatedEventDataBuilder_.build();
      }
      if (payloadCase_ == 14 && messageDeletedEventDataBuilder_ != null) {
        result.payload_ = messageDeletedEventDataBuilder_.build();
      }
      if (payloadCase_ == 26 && messageBatchCreatedEventDataBuilder_ != null) {
        result.payload_ = messageBatchCreatedEventDataBuilder_.build();
      }
      if (payloadCase_ == 27 && messageBatchUpdatedEventDataBuilder_ != null) {
        result.payload_ = messageBatchUpdatedEventDataBuilder_.build();
      }
      if (payloadCase_ == 28 && messageBatchDeletedEventDataBuilder_ != null) {
        result.payload_ = messageBatchDeletedEventDataBuilder_.build();
      }
      if (payloadCase_ == 15 && spaceUpdatedEventDataBuilder_ != null) {
        result.payload_ = spaceUpdatedEventDataBuilder_.build();
      }
      if (payloadCase_ == 29 && spaceBatchUpdatedEventDataBuilder_ != null) {
        result.payload_ = spaceBatchUpdatedEventDataBuilder_.build();
      }
      if (payloadCase_ == 17 && membershipCreatedEventDataBuilder_ != null) {
        result.payload_ = membershipCreatedEventDataBuilder_.build();
      }
      if (payloadCase_ == 18 && membershipUpdatedEventDataBuilder_ != null) {
        result.payload_ = membershipUpdatedEventDataBuilder_.build();
      }
      if (payloadCase_ == 219 && membershipDeletedEventDataBuilder_ != null) {
        result.payload_ = membershipDeletedEventDataBuilder_.build();
      }
      if (payloadCase_ == 31 && membershipBatchCreatedEventDataBuilder_ != null) {
        result.payload_ = membershipBatchCreatedEventDataBuilder_.build();
      }
      if (payloadCase_ == 32 && membershipBatchUpdatedEventDataBuilder_ != null) {
        result.payload_ = membershipBatchUpdatedEventDataBuilder_.build();
      }
      if (payloadCase_ == 33 && membershipBatchDeletedEventDataBuilder_ != null) {
        result.payload_ = membershipBatchDeletedEventDataBuilder_.build();
      }
      if (payloadCase_ == 21 && reactionCreatedEventDataBuilder_ != null) {
        result.payload_ = reactionCreatedEventDataBuilder_.build();
      }
      if (payloadCase_ == 22 && reactionDeletedEventDataBuilder_ != null) {
        result.payload_ = reactionDeletedEventDataBuilder_.build();
      }
      if (payloadCase_ == 34 && reactionBatchCreatedEventDataBuilder_ != null) {
        result.payload_ = reactionBatchCreatedEventDataBuilder_.build();
      }
      if (payloadCase_ == 35 && reactionBatchDeletedEventDataBuilder_ != null) {
        result.payload_ = reactionBatchDeletedEventDataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.SpaceEvent) {
        return mergeFrom((com.google.chat.v1.SpaceEvent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.SpaceEvent other) {
      if (other == com.google.chat.v1.SpaceEvent.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasEventTime()) {
        mergeEventTime(other.getEventTime());
      }
      if (!other.getEventType().isEmpty()) {
        eventType_ = other.eventType_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      switch (other.getPayloadCase()) {
        case MESSAGE_CREATED_EVENT_DATA:
          {
            mergeMessageCreatedEventData(other.getMessageCreatedEventData());
            break;
          }
        case MESSAGE_UPDATED_EVENT_DATA:
          {
            mergeMessageUpdatedEventData(other.getMessageUpdatedEventData());
            break;
          }
        case MESSAGE_DELETED_EVENT_DATA:
          {
            mergeMessageDeletedEventData(other.getMessageDeletedEventData());
            break;
          }
        case MESSAGE_BATCH_CREATED_EVENT_DATA:
          {
            mergeMessageBatchCreatedEventData(other.getMessageBatchCreatedEventData());
            break;
          }
        case MESSAGE_BATCH_UPDATED_EVENT_DATA:
          {
            mergeMessageBatchUpdatedEventData(other.getMessageBatchUpdatedEventData());
            break;
          }
        case MESSAGE_BATCH_DELETED_EVENT_DATA:
          {
            mergeMessageBatchDeletedEventData(other.getMessageBatchDeletedEventData());
            break;
          }
        case SPACE_UPDATED_EVENT_DATA:
          {
            mergeSpaceUpdatedEventData(other.getSpaceUpdatedEventData());
            break;
          }
        case SPACE_BATCH_UPDATED_EVENT_DATA:
          {
            mergeSpaceBatchUpdatedEventData(other.getSpaceBatchUpdatedEventData());
            break;
          }
        case MEMBERSHIP_CREATED_EVENT_DATA:
          {
            mergeMembershipCreatedEventData(other.getMembershipCreatedEventData());
            break;
          }
        case MEMBERSHIP_UPDATED_EVENT_DATA:
          {
            mergeMembershipUpdatedEventData(other.getMembershipUpdatedEventData());
            break;
          }
        case MEMBERSHIP_DELETED_EVENT_DATA:
          {
            mergeMembershipDeletedEventData(other.getMembershipDeletedEventData());
            break;
          }
        case MEMBERSHIP_BATCH_CREATED_EVENT_DATA:
          {
            mergeMembershipBatchCreatedEventData(other.getMembershipBatchCreatedEventData());
            break;
          }
        case MEMBERSHIP_BATCH_UPDATED_EVENT_DATA:
          {
            mergeMembershipBatchUpdatedEventData(other.getMembershipBatchUpdatedEventData());
            break;
          }
        case MEMBERSHIP_BATCH_DELETED_EVENT_DATA:
          {
            mergeMembershipBatchDeletedEventData(other.getMembershipBatchDeletedEventData());
            break;
          }
        case REACTION_CREATED_EVENT_DATA:
          {
            mergeReactionCreatedEventData(other.getReactionCreatedEventData());
            break;
          }
        case REACTION_DELETED_EVENT_DATA:
          {
            mergeReactionDeletedEventData(other.getReactionDeletedEventData());
            break;
          }
        case REACTION_BATCH_CREATED_EVENT_DATA:
          {
            mergeReactionBatchCreatedEventData(other.getReactionBatchCreatedEventData());
            break;
          }
        case REACTION_BATCH_DELETED_EVENT_DATA:
          {
            mergeReactionBatchDeletedEventData(other.getReactionBatchDeletedEventData());
            break;
          }
        case PAYLOAD_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(getEventTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 50:
              {
                eventType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 50
            case 98:
              {
                input.readMessage(
                    getMessageCreatedEventDataFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getMessageUpdatedEventDataFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 13;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(
                    getMessageDeletedEventDataFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 14;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(
                    getSpaceUpdatedEventDataFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 15;
                break;
              } // case 122
            case 138:
              {
                input.readMessage(
                    getMembershipCreatedEventDataFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 17;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(
                    getMembershipUpdatedEventDataFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 18;
                break;
              } // case 146
            case 170:
              {
                input.readMessage(
                    getReactionCreatedEventDataFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 21;
                break;
              } // case 170
            case 178:
              {
                input.readMessage(
                    getReactionDeletedEventDataFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 22;
                break;
              } // case 178
            case 210:
              {
                input.readMessage(
                    getMessageBatchCreatedEventDataFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 26;
                break;
              } // case 210
            case 218:
              {
                input.readMessage(
                    getMessageBatchUpdatedEventDataFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 27;
                break;
              } // case 218
            case 226:
              {
                input.readMessage(
                    getMessageBatchDeletedEventDataFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 28;
                break;
              } // case 226
            case 234:
              {
                input.readMessage(
                    getSpaceBatchUpdatedEventDataFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 29;
                break;
              } // case 234
            case 250:
              {
                input.readMessage(
                    getMembershipBatchCreatedEventDataFieldBuilder().getBuilder(),
                    extensionRegistry);
                payloadCase_ = 31;
                break;
              } // case 250
            case 258:
              {
                input.readMessage(
                    getMembershipBatchUpdatedEventDataFieldBuilder().getBuilder(),
                    extensionRegistry);
                payloadCase_ = 32;
                break;
              } // case 258
            case 266:
              {
                input.readMessage(
                    getMembershipBatchDeletedEventDataFieldBuilder().getBuilder(),
                    extensionRegistry);
                payloadCase_ = 33;
                break;
              } // case 266
            case 274:
              {
                input.readMessage(
                    getReactionBatchCreatedEventDataFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 34;
                break;
              } // case 274
            case 282:
              {
                input.readMessage(
                    getReactionBatchDeletedEventDataFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 35;
                break;
              } // case 282
            case 1754:
              {
                input.readMessage(
                    getMembershipDeletedEventDataFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 219;
                break;
              } // case 1754
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int payloadCase_ = 0;
    private java.lang.Object payload_;

    public PayloadCase getPayloadCase() {
      return PayloadCase.forNumber(payloadCase_);
    }

    public Builder clearPayload() {
      payloadCase_ = 0;
      payload_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Resource name of the space event.
     *
     * Format: `spaces/{space}/spaceEvents/{spaceEvent}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Resource name of the space event.
     *
     * Format: `spaces/{space}/spaceEvents/{spaceEvent}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Resource name of the space event.
     *
     * Format: `spaces/{space}/spaceEvents/{spaceEvent}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Resource name of the space event.
     *
     * Format: `spaces/{space}/spaceEvents/{spaceEvent}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Resource name of the space event.
     *
     * Format: `spaces/{space}/spaceEvents/{spaceEvent}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp eventTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        eventTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Time when the event occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     *
     * @return Whether the eventTime field is set.
     */
    public boolean hasEventTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Time when the event occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     *
     * @return The eventTime.
     */
    public com.google.protobuf.Timestamp getEventTime() {
      if (eventTimeBuilder_ == null) {
        return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
      } else {
        return eventTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Time when the event occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    public Builder setEventTime(com.google.protobuf.Timestamp value) {
      if (eventTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        eventTime_ = value;
      } else {
        eventTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time when the event occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    public Builder setEventTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (eventTimeBuilder_ == null) {
        eventTime_ = builderForValue.build();
      } else {
        eventTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time when the event occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    public Builder mergeEventTime(com.google.protobuf.Timestamp value) {
      if (eventTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && eventTime_ != null
            && eventTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEventTimeBuilder().mergeFrom(value);
        } else {
          eventTime_ = value;
        }
      } else {
        eventTimeBuilder_.mergeFrom(value);
      }
      if (eventTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time when the event occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    public Builder clearEventTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      eventTime_ = null;
      if (eventTimeBuilder_ != null) {
        eventTimeBuilder_.dispose();
        eventTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time when the event occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEventTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getEventTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Time when the event occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEventTimeOrBuilder() {
      if (eventTimeBuilder_ != null) {
        return eventTimeBuilder_.getMessageOrBuilder();
      } else {
        return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Time when the event occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEventTimeFieldBuilder() {
      if (eventTimeBuilder_ == null) {
        eventTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEventTime(), getParentForChildren(), isClean());
        eventTime_ = null;
      }
      return eventTimeBuilder_;
    }

    private java.lang.Object eventType_ = "";

    /**
     *
     *
     * <pre>
     * Type of space event. Each event type has a batch version, which
     * represents multiple instances of the event type that occur in a short
     * period of time. For `spaceEvents.list()` requests, omit batch event types
     * in your query filter. By default, the server returns both event type and
     * its batch version.
     *
     * Supported event types for
     * [messages](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages):
     *
     *    * New message: `google.workspace.chat.message.v1.created`
     *    * Updated message: `google.workspace.chat.message.v1.updated`
     *    * Deleted message: `google.workspace.chat.message.v1.deleted`
     *    * Multiple new messages: `google.workspace.chat.message.v1.batchCreated`
     *    * Multiple updated messages:
     *    `google.workspace.chat.message.v1.batchUpdated`
     *    * Multiple deleted messages:
     *    `google.workspace.chat.message.v1.batchDeleted`
     *
     * Supported event types for
     * [memberships](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members):
     *
     *   * New membership: `google.workspace.chat.membership.v1.created`
     *   * Updated membership: `google.workspace.chat.membership.v1.updated`
     *   * Deleted membership: `google.workspace.chat.membership.v1.deleted`
     *   * Multiple new memberships:
     *   `google.workspace.chat.membership.v1.batchCreated`
     *   * Multiple updated memberships:
     *   `google.workspace.chat.membership.v1.batchUpdated`
     *   * Multiple deleted memberships:
     *   `google.workspace.chat.membership.v1.batchDeleted`
     *
     * Supported event types for
     * [reactions](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.reactions):
     *
     *   * New reaction: `google.workspace.chat.reaction.v1.created`
     *   * Deleted reaction: `google.workspace.chat.reaction.v1.deleted`
     *   * Multiple new reactions:
     *   `google.workspace.chat.reaction.v1.batchCreated`
     *   * Multiple deleted reactions:
     *   `google.workspace.chat.reaction.v1.batchDeleted`
     *
     * Supported event types about the
     * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces):
     *
     *   * Updated space: `google.workspace.chat.space.v1.updated`
     *   * Multiple space updates: `google.workspace.chat.space.v1.batchUpdated`
     * </pre>
     *
     * <code>string event_type = 6;</code>
     *
     * @return The eventType.
     */
    public java.lang.String getEventType() {
      java.lang.Object ref = eventType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        eventType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Type of space event. Each event type has a batch version, which
     * represents multiple instances of the event type that occur in a short
     * period of time. For `spaceEvents.list()` requests, omit batch event types
     * in your query filter. By default, the server returns both event type and
     * its batch version.
     *
     * Supported event types for
     * [messages](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages):
     *
     *    * New message: `google.workspace.chat.message.v1.created`
     *    * Updated message: `google.workspace.chat.message.v1.updated`
     *    * Deleted message: `google.workspace.chat.message.v1.deleted`
     *    * Multiple new messages: `google.workspace.chat.message.v1.batchCreated`
     *    * Multiple updated messages:
     *    `google.workspace.chat.message.v1.batchUpdated`
     *    * Multiple deleted messages:
     *    `google.workspace.chat.message.v1.batchDeleted`
     *
     * Supported event types for
     * [memberships](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members):
     *
     *   * New membership: `google.workspace.chat.membership.v1.created`
     *   * Updated membership: `google.workspace.chat.membership.v1.updated`
     *   * Deleted membership: `google.workspace.chat.membership.v1.deleted`
     *   * Multiple new memberships:
     *   `google.workspace.chat.membership.v1.batchCreated`
     *   * Multiple updated memberships:
     *   `google.workspace.chat.membership.v1.batchUpdated`
     *   * Multiple deleted memberships:
     *   `google.workspace.chat.membership.v1.batchDeleted`
     *
     * Supported event types for
     * [reactions](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.reactions):
     *
     *   * New reaction: `google.workspace.chat.reaction.v1.created`
     *   * Deleted reaction: `google.workspace.chat.reaction.v1.deleted`
     *   * Multiple new reactions:
     *   `google.workspace.chat.reaction.v1.batchCreated`
     *   * Multiple deleted reactions:
     *   `google.workspace.chat.reaction.v1.batchDeleted`
     *
     * Supported event types about the
     * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces):
     *
     *   * Updated space: `google.workspace.chat.space.v1.updated`
     *   * Multiple space updates: `google.workspace.chat.space.v1.batchUpdated`
     * </pre>
     *
     * <code>string event_type = 6;</code>
     *
     * @return The bytes for eventType.
     */
    public com.google.protobuf.ByteString getEventTypeBytes() {
      java.lang.Object ref = eventType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        eventType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Type of space event. Each event type has a batch version, which
     * represents multiple instances of the event type that occur in a short
     * period of time. For `spaceEvents.list()` requests, omit batch event types
     * in your query filter. By default, the server returns both event type and
     * its batch version.
     *
     * Supported event types for
     * [messages](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages):
     *
     *    * New message: `google.workspace.chat.message.v1.created`
     *    * Updated message: `google.workspace.chat.message.v1.updated`
     *    * Deleted message: `google.workspace.chat.message.v1.deleted`
     *    * Multiple new messages: `google.workspace.chat.message.v1.batchCreated`
     *    * Multiple updated messages:
     *    `google.workspace.chat.message.v1.batchUpdated`
     *    * Multiple deleted messages:
     *    `google.workspace.chat.message.v1.batchDeleted`
     *
     * Supported event types for
     * [memberships](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members):
     *
     *   * New membership: `google.workspace.chat.membership.v1.created`
     *   * Updated membership: `google.workspace.chat.membership.v1.updated`
     *   * Deleted membership: `google.workspace.chat.membership.v1.deleted`
     *   * Multiple new memberships:
     *   `google.workspace.chat.membership.v1.batchCreated`
     *   * Multiple updated memberships:
     *   `google.workspace.chat.membership.v1.batchUpdated`
     *   * Multiple deleted memberships:
     *   `google.workspace.chat.membership.v1.batchDeleted`
     *
     * Supported event types for
     * [reactions](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.reactions):
     *
     *   * New reaction: `google.workspace.chat.reaction.v1.created`
     *   * Deleted reaction: `google.workspace.chat.reaction.v1.deleted`
     *   * Multiple new reactions:
     *   `google.workspace.chat.reaction.v1.batchCreated`
     *   * Multiple deleted reactions:
     *   `google.workspace.chat.reaction.v1.batchDeleted`
     *
     * Supported event types about the
     * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces):
     *
     *   * Updated space: `google.workspace.chat.space.v1.updated`
     *   * Multiple space updates: `google.workspace.chat.space.v1.batchUpdated`
     * </pre>
     *
     * <code>string event_type = 6;</code>
     *
     * @param value The eventType to set.
     * @return This builder for chaining.
     */
    public Builder setEventType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      eventType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Type of space event. Each event type has a batch version, which
     * represents multiple instances of the event type that occur in a short
     * period of time. For `spaceEvents.list()` requests, omit batch event types
     * in your query filter. By default, the server returns both event type and
     * its batch version.
     *
     * Supported event types for
     * [messages](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages):
     *
     *    * New message: `google.workspace.chat.message.v1.created`
     *    * Updated message: `google.workspace.chat.message.v1.updated`
     *    * Deleted message: `google.workspace.chat.message.v1.deleted`
     *    * Multiple new messages: `google.workspace.chat.message.v1.batchCreated`
     *    * Multiple updated messages:
     *    `google.workspace.chat.message.v1.batchUpdated`
     *    * Multiple deleted messages:
     *    `google.workspace.chat.message.v1.batchDeleted`
     *
     * Supported event types for
     * [memberships](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members):
     *
     *   * New membership: `google.workspace.chat.membership.v1.created`
     *   * Updated membership: `google.workspace.chat.membership.v1.updated`
     *   * Deleted membership: `google.workspace.chat.membership.v1.deleted`
     *   * Multiple new memberships:
     *   `google.workspace.chat.membership.v1.batchCreated`
     *   * Multiple updated memberships:
     *   `google.workspace.chat.membership.v1.batchUpdated`
     *   * Multiple deleted memberships:
     *   `google.workspace.chat.membership.v1.batchDeleted`
     *
     * Supported event types for
     * [reactions](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.reactions):
     *
     *   * New reaction: `google.workspace.chat.reaction.v1.created`
     *   * Deleted reaction: `google.workspace.chat.reaction.v1.deleted`
     *   * Multiple new reactions:
     *   `google.workspace.chat.reaction.v1.batchCreated`
     *   * Multiple deleted reactions:
     *   `google.workspace.chat.reaction.v1.batchDeleted`
     *
     * Supported event types about the
     * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces):
     *
     *   * Updated space: `google.workspace.chat.space.v1.updated`
     *   * Multiple space updates: `google.workspace.chat.space.v1.batchUpdated`
     * </pre>
     *
     * <code>string event_type = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEventType() {
      eventType_ = getDefaultInstance().getEventType();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Type of space event. Each event type has a batch version, which
     * represents multiple instances of the event type that occur in a short
     * period of time. For `spaceEvents.list()` requests, omit batch event types
     * in your query filter. By default, the server returns both event type and
     * its batch version.
     *
     * Supported event types for
     * [messages](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages):
     *
     *    * New message: `google.workspace.chat.message.v1.created`
     *    * Updated message: `google.workspace.chat.message.v1.updated`
     *    * Deleted message: `google.workspace.chat.message.v1.deleted`
     *    * Multiple new messages: `google.workspace.chat.message.v1.batchCreated`
     *    * Multiple updated messages:
     *    `google.workspace.chat.message.v1.batchUpdated`
     *    * Multiple deleted messages:
     *    `google.workspace.chat.message.v1.batchDeleted`
     *
     * Supported event types for
     * [memberships](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members):
     *
     *   * New membership: `google.workspace.chat.membership.v1.created`
     *   * Updated membership: `google.workspace.chat.membership.v1.updated`
     *   * Deleted membership: `google.workspace.chat.membership.v1.deleted`
     *   * Multiple new memberships:
     *   `google.workspace.chat.membership.v1.batchCreated`
     *   * Multiple updated memberships:
     *   `google.workspace.chat.membership.v1.batchUpdated`
     *   * Multiple deleted memberships:
     *   `google.workspace.chat.membership.v1.batchDeleted`
     *
     * Supported event types for
     * [reactions](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.reactions):
     *
     *   * New reaction: `google.workspace.chat.reaction.v1.created`
     *   * Deleted reaction: `google.workspace.chat.reaction.v1.deleted`
     *   * Multiple new reactions:
     *   `google.workspace.chat.reaction.v1.batchCreated`
     *   * Multiple deleted reactions:
     *   `google.workspace.chat.reaction.v1.batchDeleted`
     *
     * Supported event types about the
     * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces):
     *
     *   * Updated space: `google.workspace.chat.space.v1.updated`
     *   * Multiple space updates: `google.workspace.chat.space.v1.batchUpdated`
     * </pre>
     *
     * <code>string event_type = 6;</code>
     *
     * @param value The bytes for eventType to set.
     * @return This builder for chaining.
     */
    public Builder setEventTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      eventType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MessageCreatedEventData,
            com.google.chat.v1.MessageCreatedEventData.Builder,
            com.google.chat.v1.MessageCreatedEventDataOrBuilder>
        messageCreatedEventDataBuilder_;

    /**
     *
     *
     * <pre>
     * Event payload for a new message.
     *
     * Event type: `google.workspace.chat.message.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.MessageCreatedEventData message_created_event_data = 12;</code>
     *
     * @return Whether the messageCreatedEventData field is set.
     */
    @java.lang.Override
    public boolean hasMessageCreatedEventData() {
      return payloadCase_ == 12;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new message.
     *
     * Event type: `google.workspace.chat.message.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.MessageCreatedEventData message_created_event_data = 12;</code>
     *
     * @return The messageCreatedEventData.
     */
    @java.lang.Override
    public com.google.chat.v1.MessageCreatedEventData getMessageCreatedEventData() {
      if (messageCreatedEventDataBuilder_ == null) {
        if (payloadCase_ == 12) {
          return (com.google.chat.v1.MessageCreatedEventData) payload_;
        }
        return com.google.chat.v1.MessageCreatedEventData.getDefaultInstance();
      } else {
        if (payloadCase_ == 12) {
          return messageCreatedEventDataBuilder_.getMessage();
        }
        return com.google.chat.v1.MessageCreatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new message.
     *
     * Event type: `google.workspace.chat.message.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.MessageCreatedEventData message_created_event_data = 12;</code>
     */
    public Builder setMessageCreatedEventData(com.google.chat.v1.MessageCreatedEventData value) {
      if (messageCreatedEventDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        messageCreatedEventDataBuilder_.setMessage(value);
      }
      payloadCase_ = 12;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new message.
     *
     * Event type: `google.workspace.chat.message.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.MessageCreatedEventData message_created_event_data = 12;</code>
     */
    public Builder setMessageCreatedEventData(
        com.google.chat.v1.MessageCreatedEventData.Builder builderForValue) {
      if (messageCreatedEventDataBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        messageCreatedEventDataBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 12;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new message.
     *
     * Event type: `google.workspace.chat.message.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.MessageCreatedEventData message_created_event_data = 12;</code>
     */
    public Builder mergeMessageCreatedEventData(com.google.chat.v1.MessageCreatedEventData value) {
      if (messageCreatedEventDataBuilder_ == null) {
        if (payloadCase_ == 12
            && payload_ != com.google.chat.v1.MessageCreatedEventData.getDefaultInstance()) {
          payload_ =
              com.google.chat.v1.MessageCreatedEventData.newBuilder(
                      (com.google.chat.v1.MessageCreatedEventData) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 12) {
          messageCreatedEventDataBuilder_.mergeFrom(value);
        } else {
          messageCreatedEventDataBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 12;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new message.
     *
     * Event type: `google.workspace.chat.message.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.MessageCreatedEventData message_created_event_data = 12;</code>
     */
    public Builder clearMessageCreatedEventData() {
      if (messageCreatedEventDataBuilder_ == null) {
        if (payloadCase_ == 12) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 12) {
          payloadCase_ = 0;
          payload_ = null;
        }
        messageCreatedEventDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new message.
     *
     * Event type: `google.workspace.chat.message.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.MessageCreatedEventData message_created_event_data = 12;</code>
     */
    public com.google.chat.v1.MessageCreatedEventData.Builder getMessageCreatedEventDataBuilder() {
      return getMessageCreatedEventDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new message.
     *
     * Event type: `google.workspace.chat.message.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.MessageCreatedEventData message_created_event_data = 12;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.MessageCreatedEventDataOrBuilder
        getMessageCreatedEventDataOrBuilder() {
      if ((payloadCase_ == 12) && (messageCreatedEventDataBuilder_ != null)) {
        return messageCreatedEventDataBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 12) {
          return (com.google.chat.v1.MessageCreatedEventData) payload_;
        }
        return com.google.chat.v1.MessageCreatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new message.
     *
     * Event type: `google.workspace.chat.message.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.MessageCreatedEventData message_created_event_data = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MessageCreatedEventData,
            com.google.chat.v1.MessageCreatedEventData.Builder,
            com.google.chat.v1.MessageCreatedEventDataOrBuilder>
        getMessageCreatedEventDataFieldBuilder() {
      if (messageCreatedEventDataBuilder_ == null) {
        if (!(payloadCase_ == 12)) {
          payload_ = com.google.chat.v1.MessageCreatedEventData.getDefaultInstance();
        }
        messageCreatedEventDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.MessageCreatedEventData,
                com.google.chat.v1.MessageCreatedEventData.Builder,
                com.google.chat.v1.MessageCreatedEventDataOrBuilder>(
                (com.google.chat.v1.MessageCreatedEventData) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 12;
      onChanged();
      return messageCreatedEventDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MessageUpdatedEventData,
            com.google.chat.v1.MessageUpdatedEventData.Builder,
            com.google.chat.v1.MessageUpdatedEventDataOrBuilder>
        messageUpdatedEventDataBuilder_;

    /**
     *
     *
     * <pre>
     * Event payload for an updated message.
     *
     * Event type: `google.workspace.chat.message.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageUpdatedEventData message_updated_event_data = 13;</code>
     *
     * @return Whether the messageUpdatedEventData field is set.
     */
    @java.lang.Override
    public boolean hasMessageUpdatedEventData() {
      return payloadCase_ == 13;
    }

    /**
     *
     *
     * <pre>
     * Event payload for an updated message.
     *
     * Event type: `google.workspace.chat.message.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageUpdatedEventData message_updated_event_data = 13;</code>
     *
     * @return The messageUpdatedEventData.
     */
    @java.lang.Override
    public com.google.chat.v1.MessageUpdatedEventData getMessageUpdatedEventData() {
      if (messageUpdatedEventDataBuilder_ == null) {
        if (payloadCase_ == 13) {
          return (com.google.chat.v1.MessageUpdatedEventData) payload_;
        }
        return com.google.chat.v1.MessageUpdatedEventData.getDefaultInstance();
      } else {
        if (payloadCase_ == 13) {
          return messageUpdatedEventDataBuilder_.getMessage();
        }
        return com.google.chat.v1.MessageUpdatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for an updated message.
     *
     * Event type: `google.workspace.chat.message.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageUpdatedEventData message_updated_event_data = 13;</code>
     */
    public Builder setMessageUpdatedEventData(com.google.chat.v1.MessageUpdatedEventData value) {
      if (messageUpdatedEventDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        messageUpdatedEventDataBuilder_.setMessage(value);
      }
      payloadCase_ = 13;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for an updated message.
     *
     * Event type: `google.workspace.chat.message.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageUpdatedEventData message_updated_event_data = 13;</code>
     */
    public Builder setMessageUpdatedEventData(
        com.google.chat.v1.MessageUpdatedEventData.Builder builderForValue) {
      if (messageUpdatedEventDataBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        messageUpdatedEventDataBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 13;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for an updated message.
     *
     * Event type: `google.workspace.chat.message.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageUpdatedEventData message_updated_event_data = 13;</code>
     */
    public Builder mergeMessageUpdatedEventData(com.google.chat.v1.MessageUpdatedEventData value) {
      if (messageUpdatedEventDataBuilder_ == null) {
        if (payloadCase_ == 13
            && payload_ != com.google.chat.v1.MessageUpdatedEventData.getDefaultInstance()) {
          payload_ =
              com.google.chat.v1.MessageUpdatedEventData.newBuilder(
                      (com.google.chat.v1.MessageUpdatedEventData) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 13) {
          messageUpdatedEventDataBuilder_.mergeFrom(value);
        } else {
          messageUpdatedEventDataBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 13;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for an updated message.
     *
     * Event type: `google.workspace.chat.message.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageUpdatedEventData message_updated_event_data = 13;</code>
     */
    public Builder clearMessageUpdatedEventData() {
      if (messageUpdatedEventDataBuilder_ == null) {
        if (payloadCase_ == 13) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 13) {
          payloadCase_ = 0;
          payload_ = null;
        }
        messageUpdatedEventDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for an updated message.
     *
     * Event type: `google.workspace.chat.message.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageUpdatedEventData message_updated_event_data = 13;</code>
     */
    public com.google.chat.v1.MessageUpdatedEventData.Builder getMessageUpdatedEventDataBuilder() {
      return getMessageUpdatedEventDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Event payload for an updated message.
     *
     * Event type: `google.workspace.chat.message.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageUpdatedEventData message_updated_event_data = 13;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.MessageUpdatedEventDataOrBuilder
        getMessageUpdatedEventDataOrBuilder() {
      if ((payloadCase_ == 13) && (messageUpdatedEventDataBuilder_ != null)) {
        return messageUpdatedEventDataBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 13) {
          return (com.google.chat.v1.MessageUpdatedEventData) payload_;
        }
        return com.google.chat.v1.MessageUpdatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for an updated message.
     *
     * Event type: `google.workspace.chat.message.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageUpdatedEventData message_updated_event_data = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MessageUpdatedEventData,
            com.google.chat.v1.MessageUpdatedEventData.Builder,
            com.google.chat.v1.MessageUpdatedEventDataOrBuilder>
        getMessageUpdatedEventDataFieldBuilder() {
      if (messageUpdatedEventDataBuilder_ == null) {
        if (!(payloadCase_ == 13)) {
          payload_ = com.google.chat.v1.MessageUpdatedEventData.getDefaultInstance();
        }
        messageUpdatedEventDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.MessageUpdatedEventData,
                com.google.chat.v1.MessageUpdatedEventData.Builder,
                com.google.chat.v1.MessageUpdatedEventDataOrBuilder>(
                (com.google.chat.v1.MessageUpdatedEventData) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 13;
      onChanged();
      return messageUpdatedEventDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MessageDeletedEventData,
            com.google.chat.v1.MessageDeletedEventData.Builder,
            com.google.chat.v1.MessageDeletedEventDataOrBuilder>
        messageDeletedEventDataBuilder_;

    /**
     *
     *
     * <pre>
     * Event payload for a deleted message.
     *
     * Event type: `google.workspace.chat.message.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.MessageDeletedEventData message_deleted_event_data = 14;</code>
     *
     * @return Whether the messageDeletedEventData field is set.
     */
    @java.lang.Override
    public boolean hasMessageDeletedEventData() {
      return payloadCase_ == 14;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted message.
     *
     * Event type: `google.workspace.chat.message.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.MessageDeletedEventData message_deleted_event_data = 14;</code>
     *
     * @return The messageDeletedEventData.
     */
    @java.lang.Override
    public com.google.chat.v1.MessageDeletedEventData getMessageDeletedEventData() {
      if (messageDeletedEventDataBuilder_ == null) {
        if (payloadCase_ == 14) {
          return (com.google.chat.v1.MessageDeletedEventData) payload_;
        }
        return com.google.chat.v1.MessageDeletedEventData.getDefaultInstance();
      } else {
        if (payloadCase_ == 14) {
          return messageDeletedEventDataBuilder_.getMessage();
        }
        return com.google.chat.v1.MessageDeletedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted message.
     *
     * Event type: `google.workspace.chat.message.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.MessageDeletedEventData message_deleted_event_data = 14;</code>
     */
    public Builder setMessageDeletedEventData(com.google.chat.v1.MessageDeletedEventData value) {
      if (messageDeletedEventDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        messageDeletedEventDataBuilder_.setMessage(value);
      }
      payloadCase_ = 14;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted message.
     *
     * Event type: `google.workspace.chat.message.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.MessageDeletedEventData message_deleted_event_data = 14;</code>
     */
    public Builder setMessageDeletedEventData(
        com.google.chat.v1.MessageDeletedEventData.Builder builderForValue) {
      if (messageDeletedEventDataBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        messageDeletedEventDataBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 14;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted message.
     *
     * Event type: `google.workspace.chat.message.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.MessageDeletedEventData message_deleted_event_data = 14;</code>
     */
    public Builder mergeMessageDeletedEventData(com.google.chat.v1.MessageDeletedEventData value) {
      if (messageDeletedEventDataBuilder_ == null) {
        if (payloadCase_ == 14
            && payload_ != com.google.chat.v1.MessageDeletedEventData.getDefaultInstance()) {
          payload_ =
              com.google.chat.v1.MessageDeletedEventData.newBuilder(
                      (com.google.chat.v1.MessageDeletedEventData) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 14) {
          messageDeletedEventDataBuilder_.mergeFrom(value);
        } else {
          messageDeletedEventDataBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 14;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted message.
     *
     * Event type: `google.workspace.chat.message.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.MessageDeletedEventData message_deleted_event_data = 14;</code>
     */
    public Builder clearMessageDeletedEventData() {
      if (messageDeletedEventDataBuilder_ == null) {
        if (payloadCase_ == 14) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 14) {
          payloadCase_ = 0;
          payload_ = null;
        }
        messageDeletedEventDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted message.
     *
     * Event type: `google.workspace.chat.message.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.MessageDeletedEventData message_deleted_event_data = 14;</code>
     */
    public com.google.chat.v1.MessageDeletedEventData.Builder getMessageDeletedEventDataBuilder() {
      return getMessageDeletedEventDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted message.
     *
     * Event type: `google.workspace.chat.message.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.MessageDeletedEventData message_deleted_event_data = 14;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.MessageDeletedEventDataOrBuilder
        getMessageDeletedEventDataOrBuilder() {
      if ((payloadCase_ == 14) && (messageDeletedEventDataBuilder_ != null)) {
        return messageDeletedEventDataBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 14) {
          return (com.google.chat.v1.MessageDeletedEventData) payload_;
        }
        return com.google.chat.v1.MessageDeletedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted message.
     *
     * Event type: `google.workspace.chat.message.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.MessageDeletedEventData message_deleted_event_data = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MessageDeletedEventData,
            com.google.chat.v1.MessageDeletedEventData.Builder,
            com.google.chat.v1.MessageDeletedEventDataOrBuilder>
        getMessageDeletedEventDataFieldBuilder() {
      if (messageDeletedEventDataBuilder_ == null) {
        if (!(payloadCase_ == 14)) {
          payload_ = com.google.chat.v1.MessageDeletedEventData.getDefaultInstance();
        }
        messageDeletedEventDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.MessageDeletedEventData,
                com.google.chat.v1.MessageDeletedEventData.Builder,
                com.google.chat.v1.MessageDeletedEventDataOrBuilder>(
                (com.google.chat.v1.MessageDeletedEventData) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 14;
      onChanged();
      return messageDeletedEventDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MessageBatchCreatedEventData,
            com.google.chat.v1.MessageBatchCreatedEventData.Builder,
            com.google.chat.v1.MessageBatchCreatedEventDataOrBuilder>
        messageBatchCreatedEventDataBuilder_;

    /**
     *
     *
     * <pre>
     * Event payload for multiple new messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchCreated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchCreatedEventData message_batch_created_event_data = 26;
     * </code>
     *
     * @return Whether the messageBatchCreatedEventData field is set.
     */
    @java.lang.Override
    public boolean hasMessageBatchCreatedEventData() {
      return payloadCase_ == 26;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchCreated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchCreatedEventData message_batch_created_event_data = 26;
     * </code>
     *
     * @return The messageBatchCreatedEventData.
     */
    @java.lang.Override
    public com.google.chat.v1.MessageBatchCreatedEventData getMessageBatchCreatedEventData() {
      if (messageBatchCreatedEventDataBuilder_ == null) {
        if (payloadCase_ == 26) {
          return (com.google.chat.v1.MessageBatchCreatedEventData) payload_;
        }
        return com.google.chat.v1.MessageBatchCreatedEventData.getDefaultInstance();
      } else {
        if (payloadCase_ == 26) {
          return messageBatchCreatedEventDataBuilder_.getMessage();
        }
        return com.google.chat.v1.MessageBatchCreatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchCreated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchCreatedEventData message_batch_created_event_data = 26;
     * </code>
     */
    public Builder setMessageBatchCreatedEventData(
        com.google.chat.v1.MessageBatchCreatedEventData value) {
      if (messageBatchCreatedEventDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        messageBatchCreatedEventDataBuilder_.setMessage(value);
      }
      payloadCase_ = 26;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchCreated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchCreatedEventData message_batch_created_event_data = 26;
     * </code>
     */
    public Builder setMessageBatchCreatedEventData(
        com.google.chat.v1.MessageBatchCreatedEventData.Builder builderForValue) {
      if (messageBatchCreatedEventDataBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        messageBatchCreatedEventDataBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 26;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchCreated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchCreatedEventData message_batch_created_event_data = 26;
     * </code>
     */
    public Builder mergeMessageBatchCreatedEventData(
        com.google.chat.v1.MessageBatchCreatedEventData value) {
      if (messageBatchCreatedEventDataBuilder_ == null) {
        if (payloadCase_ == 26
            && payload_ != com.google.chat.v1.MessageBatchCreatedEventData.getDefaultInstance()) {
          payload_ =
              com.google.chat.v1.MessageBatchCreatedEventData.newBuilder(
                      (com.google.chat.v1.MessageBatchCreatedEventData) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 26) {
          messageBatchCreatedEventDataBuilder_.mergeFrom(value);
        } else {
          messageBatchCreatedEventDataBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 26;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchCreated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchCreatedEventData message_batch_created_event_data = 26;
     * </code>
     */
    public Builder clearMessageBatchCreatedEventData() {
      if (messageBatchCreatedEventDataBuilder_ == null) {
        if (payloadCase_ == 26) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 26) {
          payloadCase_ = 0;
          payload_ = null;
        }
        messageBatchCreatedEventDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchCreated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchCreatedEventData message_batch_created_event_data = 26;
     * </code>
     */
    public com.google.chat.v1.MessageBatchCreatedEventData.Builder
        getMessageBatchCreatedEventDataBuilder() {
      return getMessageBatchCreatedEventDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchCreated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchCreatedEventData message_batch_created_event_data = 26;
     * </code>
     */
    @java.lang.Override
    public com.google.chat.v1.MessageBatchCreatedEventDataOrBuilder
        getMessageBatchCreatedEventDataOrBuilder() {
      if ((payloadCase_ == 26) && (messageBatchCreatedEventDataBuilder_ != null)) {
        return messageBatchCreatedEventDataBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 26) {
          return (com.google.chat.v1.MessageBatchCreatedEventData) payload_;
        }
        return com.google.chat.v1.MessageBatchCreatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchCreated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchCreatedEventData message_batch_created_event_data = 26;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MessageBatchCreatedEventData,
            com.google.chat.v1.MessageBatchCreatedEventData.Builder,
            com.google.chat.v1.MessageBatchCreatedEventDataOrBuilder>
        getMessageBatchCreatedEventDataFieldBuilder() {
      if (messageBatchCreatedEventDataBuilder_ == null) {
        if (!(payloadCase_ == 26)) {
          payload_ = com.google.chat.v1.MessageBatchCreatedEventData.getDefaultInstance();
        }
        messageBatchCreatedEventDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.MessageBatchCreatedEventData,
                com.google.chat.v1.MessageBatchCreatedEventData.Builder,
                com.google.chat.v1.MessageBatchCreatedEventDataOrBuilder>(
                (com.google.chat.v1.MessageBatchCreatedEventData) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 26;
      onChanged();
      return messageBatchCreatedEventDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MessageBatchUpdatedEventData,
            com.google.chat.v1.MessageBatchUpdatedEventData.Builder,
            com.google.chat.v1.MessageBatchUpdatedEventDataOrBuilder>
        messageBatchUpdatedEventDataBuilder_;

    /**
     *
     *
     * <pre>
     * Event payload for multiple updated messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchUpdated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchUpdatedEventData message_batch_updated_event_data = 27;
     * </code>
     *
     * @return Whether the messageBatchUpdatedEventData field is set.
     */
    @java.lang.Override
    public boolean hasMessageBatchUpdatedEventData() {
      return payloadCase_ == 27;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updated messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchUpdated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchUpdatedEventData message_batch_updated_event_data = 27;
     * </code>
     *
     * @return The messageBatchUpdatedEventData.
     */
    @java.lang.Override
    public com.google.chat.v1.MessageBatchUpdatedEventData getMessageBatchUpdatedEventData() {
      if (messageBatchUpdatedEventDataBuilder_ == null) {
        if (payloadCase_ == 27) {
          return (com.google.chat.v1.MessageBatchUpdatedEventData) payload_;
        }
        return com.google.chat.v1.MessageBatchUpdatedEventData.getDefaultInstance();
      } else {
        if (payloadCase_ == 27) {
          return messageBatchUpdatedEventDataBuilder_.getMessage();
        }
        return com.google.chat.v1.MessageBatchUpdatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updated messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchUpdated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchUpdatedEventData message_batch_updated_event_data = 27;
     * </code>
     */
    public Builder setMessageBatchUpdatedEventData(
        com.google.chat.v1.MessageBatchUpdatedEventData value) {
      if (messageBatchUpdatedEventDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        messageBatchUpdatedEventDataBuilder_.setMessage(value);
      }
      payloadCase_ = 27;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updated messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchUpdated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchUpdatedEventData message_batch_updated_event_data = 27;
     * </code>
     */
    public Builder setMessageBatchUpdatedEventData(
        com.google.chat.v1.MessageBatchUpdatedEventData.Builder builderForValue) {
      if (messageBatchUpdatedEventDataBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        messageBatchUpdatedEventDataBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 27;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updated messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchUpdated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchUpdatedEventData message_batch_updated_event_data = 27;
     * </code>
     */
    public Builder mergeMessageBatchUpdatedEventData(
        com.google.chat.v1.MessageBatchUpdatedEventData value) {
      if (messageBatchUpdatedEventDataBuilder_ == null) {
        if (payloadCase_ == 27
            && payload_ != com.google.chat.v1.MessageBatchUpdatedEventData.getDefaultInstance()) {
          payload_ =
              com.google.chat.v1.MessageBatchUpdatedEventData.newBuilder(
                      (com.google.chat.v1.MessageBatchUpdatedEventData) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 27) {
          messageBatchUpdatedEventDataBuilder_.mergeFrom(value);
        } else {
          messageBatchUpdatedEventDataBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 27;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updated messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchUpdated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchUpdatedEventData message_batch_updated_event_data = 27;
     * </code>
     */
    public Builder clearMessageBatchUpdatedEventData() {
      if (messageBatchUpdatedEventDataBuilder_ == null) {
        if (payloadCase_ == 27) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 27) {
          payloadCase_ = 0;
          payload_ = null;
        }
        messageBatchUpdatedEventDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updated messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchUpdated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchUpdatedEventData message_batch_updated_event_data = 27;
     * </code>
     */
    public com.google.chat.v1.MessageBatchUpdatedEventData.Builder
        getMessageBatchUpdatedEventDataBuilder() {
      return getMessageBatchUpdatedEventDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updated messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchUpdated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchUpdatedEventData message_batch_updated_event_data = 27;
     * </code>
     */
    @java.lang.Override
    public com.google.chat.v1.MessageBatchUpdatedEventDataOrBuilder
        getMessageBatchUpdatedEventDataOrBuilder() {
      if ((payloadCase_ == 27) && (messageBatchUpdatedEventDataBuilder_ != null)) {
        return messageBatchUpdatedEventDataBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 27) {
          return (com.google.chat.v1.MessageBatchUpdatedEventData) payload_;
        }
        return com.google.chat.v1.MessageBatchUpdatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updated messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchUpdated`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchUpdatedEventData message_batch_updated_event_data = 27;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MessageBatchUpdatedEventData,
            com.google.chat.v1.MessageBatchUpdatedEventData.Builder,
            com.google.chat.v1.MessageBatchUpdatedEventDataOrBuilder>
        getMessageBatchUpdatedEventDataFieldBuilder() {
      if (messageBatchUpdatedEventDataBuilder_ == null) {
        if (!(payloadCase_ == 27)) {
          payload_ = com.google.chat.v1.MessageBatchUpdatedEventData.getDefaultInstance();
        }
        messageBatchUpdatedEventDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.MessageBatchUpdatedEventData,
                com.google.chat.v1.MessageBatchUpdatedEventData.Builder,
                com.google.chat.v1.MessageBatchUpdatedEventDataOrBuilder>(
                (com.google.chat.v1.MessageBatchUpdatedEventData) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 27;
      onChanged();
      return messageBatchUpdatedEventDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MessageBatchDeletedEventData,
            com.google.chat.v1.MessageBatchDeletedEventData.Builder,
            com.google.chat.v1.MessageBatchDeletedEventDataOrBuilder>
        messageBatchDeletedEventDataBuilder_;

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchDeleted`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchDeletedEventData message_batch_deleted_event_data = 28;
     * </code>
     *
     * @return Whether the messageBatchDeletedEventData field is set.
     */
    @java.lang.Override
    public boolean hasMessageBatchDeletedEventData() {
      return payloadCase_ == 28;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchDeleted`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchDeletedEventData message_batch_deleted_event_data = 28;
     * </code>
     *
     * @return The messageBatchDeletedEventData.
     */
    @java.lang.Override
    public com.google.chat.v1.MessageBatchDeletedEventData getMessageBatchDeletedEventData() {
      if (messageBatchDeletedEventDataBuilder_ == null) {
        if (payloadCase_ == 28) {
          return (com.google.chat.v1.MessageBatchDeletedEventData) payload_;
        }
        return com.google.chat.v1.MessageBatchDeletedEventData.getDefaultInstance();
      } else {
        if (payloadCase_ == 28) {
          return messageBatchDeletedEventDataBuilder_.getMessage();
        }
        return com.google.chat.v1.MessageBatchDeletedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchDeleted`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchDeletedEventData message_batch_deleted_event_data = 28;
     * </code>
     */
    public Builder setMessageBatchDeletedEventData(
        com.google.chat.v1.MessageBatchDeletedEventData value) {
      if (messageBatchDeletedEventDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        messageBatchDeletedEventDataBuilder_.setMessage(value);
      }
      payloadCase_ = 28;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchDeleted`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchDeletedEventData message_batch_deleted_event_data = 28;
     * </code>
     */
    public Builder setMessageBatchDeletedEventData(
        com.google.chat.v1.MessageBatchDeletedEventData.Builder builderForValue) {
      if (messageBatchDeletedEventDataBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        messageBatchDeletedEventDataBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 28;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchDeleted`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchDeletedEventData message_batch_deleted_event_data = 28;
     * </code>
     */
    public Builder mergeMessageBatchDeletedEventData(
        com.google.chat.v1.MessageBatchDeletedEventData value) {
      if (messageBatchDeletedEventDataBuilder_ == null) {
        if (payloadCase_ == 28
            && payload_ != com.google.chat.v1.MessageBatchDeletedEventData.getDefaultInstance()) {
          payload_ =
              com.google.chat.v1.MessageBatchDeletedEventData.newBuilder(
                      (com.google.chat.v1.MessageBatchDeletedEventData) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 28) {
          messageBatchDeletedEventDataBuilder_.mergeFrom(value);
        } else {
          messageBatchDeletedEventDataBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 28;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchDeleted`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchDeletedEventData message_batch_deleted_event_data = 28;
     * </code>
     */
    public Builder clearMessageBatchDeletedEventData() {
      if (messageBatchDeletedEventDataBuilder_ == null) {
        if (payloadCase_ == 28) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 28) {
          payloadCase_ = 0;
          payload_ = null;
        }
        messageBatchDeletedEventDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchDeleted`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchDeletedEventData message_batch_deleted_event_data = 28;
     * </code>
     */
    public com.google.chat.v1.MessageBatchDeletedEventData.Builder
        getMessageBatchDeletedEventDataBuilder() {
      return getMessageBatchDeletedEventDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchDeleted`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchDeletedEventData message_batch_deleted_event_data = 28;
     * </code>
     */
    @java.lang.Override
    public com.google.chat.v1.MessageBatchDeletedEventDataOrBuilder
        getMessageBatchDeletedEventDataOrBuilder() {
      if ((payloadCase_ == 28) && (messageBatchDeletedEventDataBuilder_ != null)) {
        return messageBatchDeletedEventDataBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 28) {
          return (com.google.chat.v1.MessageBatchDeletedEventData) payload_;
        }
        return com.google.chat.v1.MessageBatchDeletedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted messages.
     *
     * Event type: `google.workspace.chat.message.v1.batchDeleted`
     * </pre>
     *
     * <code>.google.chat.v1.MessageBatchDeletedEventData message_batch_deleted_event_data = 28;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MessageBatchDeletedEventData,
            com.google.chat.v1.MessageBatchDeletedEventData.Builder,
            com.google.chat.v1.MessageBatchDeletedEventDataOrBuilder>
        getMessageBatchDeletedEventDataFieldBuilder() {
      if (messageBatchDeletedEventDataBuilder_ == null) {
        if (!(payloadCase_ == 28)) {
          payload_ = com.google.chat.v1.MessageBatchDeletedEventData.getDefaultInstance();
        }
        messageBatchDeletedEventDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.MessageBatchDeletedEventData,
                com.google.chat.v1.MessageBatchDeletedEventData.Builder,
                com.google.chat.v1.MessageBatchDeletedEventDataOrBuilder>(
                (com.google.chat.v1.MessageBatchDeletedEventData) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 28;
      onChanged();
      return messageBatchDeletedEventDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.SpaceUpdatedEventData,
            com.google.chat.v1.SpaceUpdatedEventData.Builder,
            com.google.chat.v1.SpaceUpdatedEventDataOrBuilder>
        spaceUpdatedEventDataBuilder_;

    /**
     *
     *
     * <pre>
     * Event payload for a space update.
     *
     * Event type: `google.workspace.chat.space.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.SpaceUpdatedEventData space_updated_event_data = 15;</code>
     *
     * @return Whether the spaceUpdatedEventData field is set.
     */
    @java.lang.Override
    public boolean hasSpaceUpdatedEventData() {
      return payloadCase_ == 15;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a space update.
     *
     * Event type: `google.workspace.chat.space.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.SpaceUpdatedEventData space_updated_event_data = 15;</code>
     *
     * @return The spaceUpdatedEventData.
     */
    @java.lang.Override
    public com.google.chat.v1.SpaceUpdatedEventData getSpaceUpdatedEventData() {
      if (spaceUpdatedEventDataBuilder_ == null) {
        if (payloadCase_ == 15) {
          return (com.google.chat.v1.SpaceUpdatedEventData) payload_;
        }
        return com.google.chat.v1.SpaceUpdatedEventData.getDefaultInstance();
      } else {
        if (payloadCase_ == 15) {
          return spaceUpdatedEventDataBuilder_.getMessage();
        }
        return com.google.chat.v1.SpaceUpdatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for a space update.
     *
     * Event type: `google.workspace.chat.space.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.SpaceUpdatedEventData space_updated_event_data = 15;</code>
     */
    public Builder setSpaceUpdatedEventData(com.google.chat.v1.SpaceUpdatedEventData value) {
      if (spaceUpdatedEventDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        spaceUpdatedEventDataBuilder_.setMessage(value);
      }
      payloadCase_ = 15;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a space update.
     *
     * Event type: `google.workspace.chat.space.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.SpaceUpdatedEventData space_updated_event_data = 15;</code>
     */
    public Builder setSpaceUpdatedEventData(
        com.google.chat.v1.SpaceUpdatedEventData.Builder builderForValue) {
      if (spaceUpdatedEventDataBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        spaceUpdatedEventDataBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 15;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a space update.
     *
     * Event type: `google.workspace.chat.space.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.SpaceUpdatedEventData space_updated_event_data = 15;</code>
     */
    public Builder mergeSpaceUpdatedEventData(com.google.chat.v1.SpaceUpdatedEventData value) {
      if (spaceUpdatedEventDataBuilder_ == null) {
        if (payloadCase_ == 15
            && payload_ != com.google.chat.v1.SpaceUpdatedEventData.getDefaultInstance()) {
          payload_ =
              com.google.chat.v1.SpaceUpdatedEventData.newBuilder(
                      (com.google.chat.v1.SpaceUpdatedEventData) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 15) {
          spaceUpdatedEventDataBuilder_.mergeFrom(value);
        } else {
          spaceUpdatedEventDataBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 15;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a space update.
     *
     * Event type: `google.workspace.chat.space.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.SpaceUpdatedEventData space_updated_event_data = 15;</code>
     */
    public Builder clearSpaceUpdatedEventData() {
      if (spaceUpdatedEventDataBuilder_ == null) {
        if (payloadCase_ == 15) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 15) {
          payloadCase_ = 0;
          payload_ = null;
        }
        spaceUpdatedEventDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a space update.
     *
     * Event type: `google.workspace.chat.space.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.SpaceUpdatedEventData space_updated_event_data = 15;</code>
     */
    public com.google.chat.v1.SpaceUpdatedEventData.Builder getSpaceUpdatedEventDataBuilder() {
      return getSpaceUpdatedEventDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Event payload for a space update.
     *
     * Event type: `google.workspace.chat.space.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.SpaceUpdatedEventData space_updated_event_data = 15;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.SpaceUpdatedEventDataOrBuilder getSpaceUpdatedEventDataOrBuilder() {
      if ((payloadCase_ == 15) && (spaceUpdatedEventDataBuilder_ != null)) {
        return spaceUpdatedEventDataBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 15) {
          return (com.google.chat.v1.SpaceUpdatedEventData) payload_;
        }
        return com.google.chat.v1.SpaceUpdatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for a space update.
     *
     * Event type: `google.workspace.chat.space.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.SpaceUpdatedEventData space_updated_event_data = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.SpaceUpdatedEventData,
            com.google.chat.v1.SpaceUpdatedEventData.Builder,
            com.google.chat.v1.SpaceUpdatedEventDataOrBuilder>
        getSpaceUpdatedEventDataFieldBuilder() {
      if (spaceUpdatedEventDataBuilder_ == null) {
        if (!(payloadCase_ == 15)) {
          payload_ = com.google.chat.v1.SpaceUpdatedEventData.getDefaultInstance();
        }
        spaceUpdatedEventDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.SpaceUpdatedEventData,
                com.google.chat.v1.SpaceUpdatedEventData.Builder,
                com.google.chat.v1.SpaceUpdatedEventDataOrBuilder>(
                (com.google.chat.v1.SpaceUpdatedEventData) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 15;
      onChanged();
      return spaceUpdatedEventDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.SpaceBatchUpdatedEventData,
            com.google.chat.v1.SpaceBatchUpdatedEventData.Builder,
            com.google.chat.v1.SpaceBatchUpdatedEventDataOrBuilder>
        spaceBatchUpdatedEventDataBuilder_;

    /**
     *
     *
     * <pre>
     * Event payload for multiple updates to a space.
     *
     * Event type: `google.workspace.chat.space.v1.batchUpdated`
     * </pre>
     *
     * <code>.google.chat.v1.SpaceBatchUpdatedEventData space_batch_updated_event_data = 29;</code>
     *
     * @return Whether the spaceBatchUpdatedEventData field is set.
     */
    @java.lang.Override
    public boolean hasSpaceBatchUpdatedEventData() {
      return payloadCase_ == 29;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updates to a space.
     *
     * Event type: `google.workspace.chat.space.v1.batchUpdated`
     * </pre>
     *
     * <code>.google.chat.v1.SpaceBatchUpdatedEventData space_batch_updated_event_data = 29;</code>
     *
     * @return The spaceBatchUpdatedEventData.
     */
    @java.lang.Override
    public com.google.chat.v1.SpaceBatchUpdatedEventData getSpaceBatchUpdatedEventData() {
      if (spaceBatchUpdatedEventDataBuilder_ == null) {
        if (payloadCase_ == 29) {
          return (com.google.chat.v1.SpaceBatchUpdatedEventData) payload_;
        }
        return com.google.chat.v1.SpaceBatchUpdatedEventData.getDefaultInstance();
      } else {
        if (payloadCase_ == 29) {
          return spaceBatchUpdatedEventDataBuilder_.getMessage();
        }
        return com.google.chat.v1.SpaceBatchUpdatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updates to a space.
     *
     * Event type: `google.workspace.chat.space.v1.batchUpdated`
     * </pre>
     *
     * <code>.google.chat.v1.SpaceBatchUpdatedEventData space_batch_updated_event_data = 29;</code>
     */
    public Builder setSpaceBatchUpdatedEventData(
        com.google.chat.v1.SpaceBatchUpdatedEventData value) {
      if (spaceBatchUpdatedEventDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        spaceBatchUpdatedEventDataBuilder_.setMessage(value);
      }
      payloadCase_ = 29;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updates to a space.
     *
     * Event type: `google.workspace.chat.space.v1.batchUpdated`
     * </pre>
     *
     * <code>.google.chat.v1.SpaceBatchUpdatedEventData space_batch_updated_event_data = 29;</code>
     */
    public Builder setSpaceBatchUpdatedEventData(
        com.google.chat.v1.SpaceBatchUpdatedEventData.Builder builderForValue) {
      if (spaceBatchUpdatedEventDataBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        spaceBatchUpdatedEventDataBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 29;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updates to a space.
     *
     * Event type: `google.workspace.chat.space.v1.batchUpdated`
     * </pre>
     *
     * <code>.google.chat.v1.SpaceBatchUpdatedEventData space_batch_updated_event_data = 29;</code>
     */
    public Builder mergeSpaceBatchUpdatedEventData(
        com.google.chat.v1.SpaceBatchUpdatedEventData value) {
      if (spaceBatchUpdatedEventDataBuilder_ == null) {
        if (payloadCase_ == 29
            && payload_ != com.google.chat.v1.SpaceBatchUpdatedEventData.getDefaultInstance()) {
          payload_ =
              com.google.chat.v1.SpaceBatchUpdatedEventData.newBuilder(
                      (com.google.chat.v1.SpaceBatchUpdatedEventData) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 29) {
          spaceBatchUpdatedEventDataBuilder_.mergeFrom(value);
        } else {
          spaceBatchUpdatedEventDataBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 29;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updates to a space.
     *
     * Event type: `google.workspace.chat.space.v1.batchUpdated`
     * </pre>
     *
     * <code>.google.chat.v1.SpaceBatchUpdatedEventData space_batch_updated_event_data = 29;</code>
     */
    public Builder clearSpaceBatchUpdatedEventData() {
      if (spaceBatchUpdatedEventDataBuilder_ == null) {
        if (payloadCase_ == 29) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 29) {
          payloadCase_ = 0;
          payload_ = null;
        }
        spaceBatchUpdatedEventDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updates to a space.
     *
     * Event type: `google.workspace.chat.space.v1.batchUpdated`
     * </pre>
     *
     * <code>.google.chat.v1.SpaceBatchUpdatedEventData space_batch_updated_event_data = 29;</code>
     */
    public com.google.chat.v1.SpaceBatchUpdatedEventData.Builder
        getSpaceBatchUpdatedEventDataBuilder() {
      return getSpaceBatchUpdatedEventDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updates to a space.
     *
     * Event type: `google.workspace.chat.space.v1.batchUpdated`
     * </pre>
     *
     * <code>.google.chat.v1.SpaceBatchUpdatedEventData space_batch_updated_event_data = 29;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.SpaceBatchUpdatedEventDataOrBuilder
        getSpaceBatchUpdatedEventDataOrBuilder() {
      if ((payloadCase_ == 29) && (spaceBatchUpdatedEventDataBuilder_ != null)) {
        return spaceBatchUpdatedEventDataBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 29) {
          return (com.google.chat.v1.SpaceBatchUpdatedEventData) payload_;
        }
        return com.google.chat.v1.SpaceBatchUpdatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updates to a space.
     *
     * Event type: `google.workspace.chat.space.v1.batchUpdated`
     * </pre>
     *
     * <code>.google.chat.v1.SpaceBatchUpdatedEventData space_batch_updated_event_data = 29;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.SpaceBatchUpdatedEventData,
            com.google.chat.v1.SpaceBatchUpdatedEventData.Builder,
            com.google.chat.v1.SpaceBatchUpdatedEventDataOrBuilder>
        getSpaceBatchUpdatedEventDataFieldBuilder() {
      if (spaceBatchUpdatedEventDataBuilder_ == null) {
        if (!(payloadCase_ == 29)) {
          payload_ = com.google.chat.v1.SpaceBatchUpdatedEventData.getDefaultInstance();
        }
        spaceBatchUpdatedEventDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.SpaceBatchUpdatedEventData,
                com.google.chat.v1.SpaceBatchUpdatedEventData.Builder,
                com.google.chat.v1.SpaceBatchUpdatedEventDataOrBuilder>(
                (com.google.chat.v1.SpaceBatchUpdatedEventData) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 29;
      onChanged();
      return spaceBatchUpdatedEventDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MembershipCreatedEventData,
            com.google.chat.v1.MembershipCreatedEventData.Builder,
            com.google.chat.v1.MembershipCreatedEventDataOrBuilder>
        membershipCreatedEventDataBuilder_;

    /**
     *
     *
     * <pre>
     * Event payload for a new membership.
     *
     * Event type: `google.workspace.chat.membership.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipCreatedEventData membership_created_event_data = 17;</code>
     *
     * @return Whether the membershipCreatedEventData field is set.
     */
    @java.lang.Override
    public boolean hasMembershipCreatedEventData() {
      return payloadCase_ == 17;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new membership.
     *
     * Event type: `google.workspace.chat.membership.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipCreatedEventData membership_created_event_data = 17;</code>
     *
     * @return The membershipCreatedEventData.
     */
    @java.lang.Override
    public com.google.chat.v1.MembershipCreatedEventData getMembershipCreatedEventData() {
      if (membershipCreatedEventDataBuilder_ == null) {
        if (payloadCase_ == 17) {
          return (com.google.chat.v1.MembershipCreatedEventData) payload_;
        }
        return com.google.chat.v1.MembershipCreatedEventData.getDefaultInstance();
      } else {
        if (payloadCase_ == 17) {
          return membershipCreatedEventDataBuilder_.getMessage();
        }
        return com.google.chat.v1.MembershipCreatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new membership.
     *
     * Event type: `google.workspace.chat.membership.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipCreatedEventData membership_created_event_data = 17;</code>
     */
    public Builder setMembershipCreatedEventData(
        com.google.chat.v1.MembershipCreatedEventData value) {
      if (membershipCreatedEventDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        membershipCreatedEventDataBuilder_.setMessage(value);
      }
      payloadCase_ = 17;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new membership.
     *
     * Event type: `google.workspace.chat.membership.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipCreatedEventData membership_created_event_data = 17;</code>
     */
    public Builder setMembershipCreatedEventData(
        com.google.chat.v1.MembershipCreatedEventData.Builder builderForValue) {
      if (membershipCreatedEventDataBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        membershipCreatedEventDataBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 17;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new membership.
     *
     * Event type: `google.workspace.chat.membership.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipCreatedEventData membership_created_event_data = 17;</code>
     */
    public Builder mergeMembershipCreatedEventData(
        com.google.chat.v1.MembershipCreatedEventData value) {
      if (membershipCreatedEventDataBuilder_ == null) {
        if (payloadCase_ == 17
            && payload_ != com.google.chat.v1.MembershipCreatedEventData.getDefaultInstance()) {
          payload_ =
              com.google.chat.v1.MembershipCreatedEventData.newBuilder(
                      (com.google.chat.v1.MembershipCreatedEventData) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 17) {
          membershipCreatedEventDataBuilder_.mergeFrom(value);
        } else {
          membershipCreatedEventDataBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 17;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new membership.
     *
     * Event type: `google.workspace.chat.membership.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipCreatedEventData membership_created_event_data = 17;</code>
     */
    public Builder clearMembershipCreatedEventData() {
      if (membershipCreatedEventDataBuilder_ == null) {
        if (payloadCase_ == 17) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 17) {
          payloadCase_ = 0;
          payload_ = null;
        }
        membershipCreatedEventDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new membership.
     *
     * Event type: `google.workspace.chat.membership.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipCreatedEventData membership_created_event_data = 17;</code>
     */
    public com.google.chat.v1.MembershipCreatedEventData.Builder
        getMembershipCreatedEventDataBuilder() {
      return getMembershipCreatedEventDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new membership.
     *
     * Event type: `google.workspace.chat.membership.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipCreatedEventData membership_created_event_data = 17;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.MembershipCreatedEventDataOrBuilder
        getMembershipCreatedEventDataOrBuilder() {
      if ((payloadCase_ == 17) && (membershipCreatedEventDataBuilder_ != null)) {
        return membershipCreatedEventDataBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 17) {
          return (com.google.chat.v1.MembershipCreatedEventData) payload_;
        }
        return com.google.chat.v1.MembershipCreatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new membership.
     *
     * Event type: `google.workspace.chat.membership.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipCreatedEventData membership_created_event_data = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MembershipCreatedEventData,
            com.google.chat.v1.MembershipCreatedEventData.Builder,
            com.google.chat.v1.MembershipCreatedEventDataOrBuilder>
        getMembershipCreatedEventDataFieldBuilder() {
      if (membershipCreatedEventDataBuilder_ == null) {
        if (!(payloadCase_ == 17)) {
          payload_ = com.google.chat.v1.MembershipCreatedEventData.getDefaultInstance();
        }
        membershipCreatedEventDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.MembershipCreatedEventData,
                com.google.chat.v1.MembershipCreatedEventData.Builder,
                com.google.chat.v1.MembershipCreatedEventDataOrBuilder>(
                (com.google.chat.v1.MembershipCreatedEventData) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 17;
      onChanged();
      return membershipCreatedEventDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MembershipUpdatedEventData,
            com.google.chat.v1.MembershipUpdatedEventData.Builder,
            com.google.chat.v1.MembershipUpdatedEventDataOrBuilder>
        membershipUpdatedEventDataBuilder_;

    /**
     *
     *
     * <pre>
     * Event payload for an updated membership.
     *
     * Event type: `google.workspace.chat.membership.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipUpdatedEventData membership_updated_event_data = 18;</code>
     *
     * @return Whether the membershipUpdatedEventData field is set.
     */
    @java.lang.Override
    public boolean hasMembershipUpdatedEventData() {
      return payloadCase_ == 18;
    }

    /**
     *
     *
     * <pre>
     * Event payload for an updated membership.
     *
     * Event type: `google.workspace.chat.membership.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipUpdatedEventData membership_updated_event_data = 18;</code>
     *
     * @return The membershipUpdatedEventData.
     */
    @java.lang.Override
    public com.google.chat.v1.MembershipUpdatedEventData getMembershipUpdatedEventData() {
      if (membershipUpdatedEventDataBuilder_ == null) {
        if (payloadCase_ == 18) {
          return (com.google.chat.v1.MembershipUpdatedEventData) payload_;
        }
        return com.google.chat.v1.MembershipUpdatedEventData.getDefaultInstance();
      } else {
        if (payloadCase_ == 18) {
          return membershipUpdatedEventDataBuilder_.getMessage();
        }
        return com.google.chat.v1.MembershipUpdatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for an updated membership.
     *
     * Event type: `google.workspace.chat.membership.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipUpdatedEventData membership_updated_event_data = 18;</code>
     */
    public Builder setMembershipUpdatedEventData(
        com.google.chat.v1.MembershipUpdatedEventData value) {
      if (membershipUpdatedEventDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        membershipUpdatedEventDataBuilder_.setMessage(value);
      }
      payloadCase_ = 18;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for an updated membership.
     *
     * Event type: `google.workspace.chat.membership.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipUpdatedEventData membership_updated_event_data = 18;</code>
     */
    public Builder setMembershipUpdatedEventData(
        com.google.chat.v1.MembershipUpdatedEventData.Builder builderForValue) {
      if (membershipUpdatedEventDataBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        membershipUpdatedEventDataBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 18;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for an updated membership.
     *
     * Event type: `google.workspace.chat.membership.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipUpdatedEventData membership_updated_event_data = 18;</code>
     */
    public Builder mergeMembershipUpdatedEventData(
        com.google.chat.v1.MembershipUpdatedEventData value) {
      if (membershipUpdatedEventDataBuilder_ == null) {
        if (payloadCase_ == 18
            && payload_ != com.google.chat.v1.MembershipUpdatedEventData.getDefaultInstance()) {
          payload_ =
              com.google.chat.v1.MembershipUpdatedEventData.newBuilder(
                      (com.google.chat.v1.MembershipUpdatedEventData) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 18) {
          membershipUpdatedEventDataBuilder_.mergeFrom(value);
        } else {
          membershipUpdatedEventDataBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 18;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for an updated membership.
     *
     * Event type: `google.workspace.chat.membership.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipUpdatedEventData membership_updated_event_data = 18;</code>
     */
    public Builder clearMembershipUpdatedEventData() {
      if (membershipUpdatedEventDataBuilder_ == null) {
        if (payloadCase_ == 18) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 18) {
          payloadCase_ = 0;
          payload_ = null;
        }
        membershipUpdatedEventDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for an updated membership.
     *
     * Event type: `google.workspace.chat.membership.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipUpdatedEventData membership_updated_event_data = 18;</code>
     */
    public com.google.chat.v1.MembershipUpdatedEventData.Builder
        getMembershipUpdatedEventDataBuilder() {
      return getMembershipUpdatedEventDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Event payload for an updated membership.
     *
     * Event type: `google.workspace.chat.membership.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipUpdatedEventData membership_updated_event_data = 18;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.MembershipUpdatedEventDataOrBuilder
        getMembershipUpdatedEventDataOrBuilder() {
      if ((payloadCase_ == 18) && (membershipUpdatedEventDataBuilder_ != null)) {
        return membershipUpdatedEventDataBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 18) {
          return (com.google.chat.v1.MembershipUpdatedEventData) payload_;
        }
        return com.google.chat.v1.MembershipUpdatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for an updated membership.
     *
     * Event type: `google.workspace.chat.membership.v1.updated`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipUpdatedEventData membership_updated_event_data = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MembershipUpdatedEventData,
            com.google.chat.v1.MembershipUpdatedEventData.Builder,
            com.google.chat.v1.MembershipUpdatedEventDataOrBuilder>
        getMembershipUpdatedEventDataFieldBuilder() {
      if (membershipUpdatedEventDataBuilder_ == null) {
        if (!(payloadCase_ == 18)) {
          payload_ = com.google.chat.v1.MembershipUpdatedEventData.getDefaultInstance();
        }
        membershipUpdatedEventDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.MembershipUpdatedEventData,
                com.google.chat.v1.MembershipUpdatedEventData.Builder,
                com.google.chat.v1.MembershipUpdatedEventDataOrBuilder>(
                (com.google.chat.v1.MembershipUpdatedEventData) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 18;
      onChanged();
      return membershipUpdatedEventDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MembershipDeletedEventData,
            com.google.chat.v1.MembershipDeletedEventData.Builder,
            com.google.chat.v1.MembershipDeletedEventDataOrBuilder>
        membershipDeletedEventDataBuilder_;

    /**
     *
     *
     * <pre>
     * Event payload for a deleted membership.
     *
     * Event type: `google.workspace.chat.membership.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipDeletedEventData membership_deleted_event_data = 219;</code>
     *
     * @return Whether the membershipDeletedEventData field is set.
     */
    @java.lang.Override
    public boolean hasMembershipDeletedEventData() {
      return payloadCase_ == 219;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted membership.
     *
     * Event type: `google.workspace.chat.membership.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipDeletedEventData membership_deleted_event_data = 219;</code>
     *
     * @return The membershipDeletedEventData.
     */
    @java.lang.Override
    public com.google.chat.v1.MembershipDeletedEventData getMembershipDeletedEventData() {
      if (membershipDeletedEventDataBuilder_ == null) {
        if (payloadCase_ == 219) {
          return (com.google.chat.v1.MembershipDeletedEventData) payload_;
        }
        return com.google.chat.v1.MembershipDeletedEventData.getDefaultInstance();
      } else {
        if (payloadCase_ == 219) {
          return membershipDeletedEventDataBuilder_.getMessage();
        }
        return com.google.chat.v1.MembershipDeletedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted membership.
     *
     * Event type: `google.workspace.chat.membership.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipDeletedEventData membership_deleted_event_data = 219;</code>
     */
    public Builder setMembershipDeletedEventData(
        com.google.chat.v1.MembershipDeletedEventData value) {
      if (membershipDeletedEventDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        membershipDeletedEventDataBuilder_.setMessage(value);
      }
      payloadCase_ = 219;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted membership.
     *
     * Event type: `google.workspace.chat.membership.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipDeletedEventData membership_deleted_event_data = 219;</code>
     */
    public Builder setMembershipDeletedEventData(
        com.google.chat.v1.MembershipDeletedEventData.Builder builderForValue) {
      if (membershipDeletedEventDataBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        membershipDeletedEventDataBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 219;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted membership.
     *
     * Event type: `google.workspace.chat.membership.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipDeletedEventData membership_deleted_event_data = 219;</code>
     */
    public Builder mergeMembershipDeletedEventData(
        com.google.chat.v1.MembershipDeletedEventData value) {
      if (membershipDeletedEventDataBuilder_ == null) {
        if (payloadCase_ == 219
            && payload_ != com.google.chat.v1.MembershipDeletedEventData.getDefaultInstance()) {
          payload_ =
              com.google.chat.v1.MembershipDeletedEventData.newBuilder(
                      (com.google.chat.v1.MembershipDeletedEventData) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 219) {
          membershipDeletedEventDataBuilder_.mergeFrom(value);
        } else {
          membershipDeletedEventDataBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 219;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted membership.
     *
     * Event type: `google.workspace.chat.membership.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipDeletedEventData membership_deleted_event_data = 219;</code>
     */
    public Builder clearMembershipDeletedEventData() {
      if (membershipDeletedEventDataBuilder_ == null) {
        if (payloadCase_ == 219) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 219) {
          payloadCase_ = 0;
          payload_ = null;
        }
        membershipDeletedEventDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted membership.
     *
     * Event type: `google.workspace.chat.membership.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipDeletedEventData membership_deleted_event_data = 219;</code>
     */
    public com.google.chat.v1.MembershipDeletedEventData.Builder
        getMembershipDeletedEventDataBuilder() {
      return getMembershipDeletedEventDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted membership.
     *
     * Event type: `google.workspace.chat.membership.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipDeletedEventData membership_deleted_event_data = 219;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.MembershipDeletedEventDataOrBuilder
        getMembershipDeletedEventDataOrBuilder() {
      if ((payloadCase_ == 219) && (membershipDeletedEventDataBuilder_ != null)) {
        return membershipDeletedEventDataBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 219) {
          return (com.google.chat.v1.MembershipDeletedEventData) payload_;
        }
        return com.google.chat.v1.MembershipDeletedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted membership.
     *
     * Event type: `google.workspace.chat.membership.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.MembershipDeletedEventData membership_deleted_event_data = 219;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MembershipDeletedEventData,
            com.google.chat.v1.MembershipDeletedEventData.Builder,
            com.google.chat.v1.MembershipDeletedEventDataOrBuilder>
        getMembershipDeletedEventDataFieldBuilder() {
      if (membershipDeletedEventDataBuilder_ == null) {
        if (!(payloadCase_ == 219)) {
          payload_ = com.google.chat.v1.MembershipDeletedEventData.getDefaultInstance();
        }
        membershipDeletedEventDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.MembershipDeletedEventData,
                com.google.chat.v1.MembershipDeletedEventData.Builder,
                com.google.chat.v1.MembershipDeletedEventDataOrBuilder>(
                (com.google.chat.v1.MembershipDeletedEventData) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 219;
      onChanged();
      return membershipDeletedEventDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MembershipBatchCreatedEventData,
            com.google.chat.v1.MembershipBatchCreatedEventData.Builder,
            com.google.chat.v1.MembershipBatchCreatedEventDataOrBuilder>
        membershipBatchCreatedEventDataBuilder_;

    /**
     *
     *
     * <pre>
     * Event payload for multiple new memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchCreated`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchCreatedEventData membership_batch_created_event_data = 31;
     * </code>
     *
     * @return Whether the membershipBatchCreatedEventData field is set.
     */
    @java.lang.Override
    public boolean hasMembershipBatchCreatedEventData() {
      return payloadCase_ == 31;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchCreated`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchCreatedEventData membership_batch_created_event_data = 31;
     * </code>
     *
     * @return The membershipBatchCreatedEventData.
     */
    @java.lang.Override
    public com.google.chat.v1.MembershipBatchCreatedEventData getMembershipBatchCreatedEventData() {
      if (membershipBatchCreatedEventDataBuilder_ == null) {
        if (payloadCase_ == 31) {
          return (com.google.chat.v1.MembershipBatchCreatedEventData) payload_;
        }
        return com.google.chat.v1.MembershipBatchCreatedEventData.getDefaultInstance();
      } else {
        if (payloadCase_ == 31) {
          return membershipBatchCreatedEventDataBuilder_.getMessage();
        }
        return com.google.chat.v1.MembershipBatchCreatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchCreated`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchCreatedEventData membership_batch_created_event_data = 31;
     * </code>
     */
    public Builder setMembershipBatchCreatedEventData(
        com.google.chat.v1.MembershipBatchCreatedEventData value) {
      if (membershipBatchCreatedEventDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        membershipBatchCreatedEventDataBuilder_.setMessage(value);
      }
      payloadCase_ = 31;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchCreated`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchCreatedEventData membership_batch_created_event_data = 31;
     * </code>
     */
    public Builder setMembershipBatchCreatedEventData(
        com.google.chat.v1.MembershipBatchCreatedEventData.Builder builderForValue) {
      if (membershipBatchCreatedEventDataBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        membershipBatchCreatedEventDataBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 31;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchCreated`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchCreatedEventData membership_batch_created_event_data = 31;
     * </code>
     */
    public Builder mergeMembershipBatchCreatedEventData(
        com.google.chat.v1.MembershipBatchCreatedEventData value) {
      if (membershipBatchCreatedEventDataBuilder_ == null) {
        if (payloadCase_ == 31
            && payload_
                != com.google.chat.v1.MembershipBatchCreatedEventData.getDefaultInstance()) {
          payload_ =
              com.google.chat.v1.MembershipBatchCreatedEventData.newBuilder(
                      (com.google.chat.v1.MembershipBatchCreatedEventData) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 31) {
          membershipBatchCreatedEventDataBuilder_.mergeFrom(value);
        } else {
          membershipBatchCreatedEventDataBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 31;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchCreated`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchCreatedEventData membership_batch_created_event_data = 31;
     * </code>
     */
    public Builder clearMembershipBatchCreatedEventData() {
      if (membershipBatchCreatedEventDataBuilder_ == null) {
        if (payloadCase_ == 31) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 31) {
          payloadCase_ = 0;
          payload_ = null;
        }
        membershipBatchCreatedEventDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchCreated`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchCreatedEventData membership_batch_created_event_data = 31;
     * </code>
     */
    public com.google.chat.v1.MembershipBatchCreatedEventData.Builder
        getMembershipBatchCreatedEventDataBuilder() {
      return getMembershipBatchCreatedEventDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchCreated`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchCreatedEventData membership_batch_created_event_data = 31;
     * </code>
     */
    @java.lang.Override
    public com.google.chat.v1.MembershipBatchCreatedEventDataOrBuilder
        getMembershipBatchCreatedEventDataOrBuilder() {
      if ((payloadCase_ == 31) && (membershipBatchCreatedEventDataBuilder_ != null)) {
        return membershipBatchCreatedEventDataBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 31) {
          return (com.google.chat.v1.MembershipBatchCreatedEventData) payload_;
        }
        return com.google.chat.v1.MembershipBatchCreatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchCreated`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchCreatedEventData membership_batch_created_event_data = 31;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MembershipBatchCreatedEventData,
            com.google.chat.v1.MembershipBatchCreatedEventData.Builder,
            com.google.chat.v1.MembershipBatchCreatedEventDataOrBuilder>
        getMembershipBatchCreatedEventDataFieldBuilder() {
      if (membershipBatchCreatedEventDataBuilder_ == null) {
        if (!(payloadCase_ == 31)) {
          payload_ = com.google.chat.v1.MembershipBatchCreatedEventData.getDefaultInstance();
        }
        membershipBatchCreatedEventDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.MembershipBatchCreatedEventData,
                com.google.chat.v1.MembershipBatchCreatedEventData.Builder,
                com.google.chat.v1.MembershipBatchCreatedEventDataOrBuilder>(
                (com.google.chat.v1.MembershipBatchCreatedEventData) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 31;
      onChanged();
      return membershipBatchCreatedEventDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MembershipBatchUpdatedEventData,
            com.google.chat.v1.MembershipBatchUpdatedEventData.Builder,
            com.google.chat.v1.MembershipBatchUpdatedEventDataOrBuilder>
        membershipBatchUpdatedEventDataBuilder_;

    /**
     *
     *
     * <pre>
     * Event payload for multiple updated memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchUpdated`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchUpdatedEventData membership_batch_updated_event_data = 32;
     * </code>
     *
     * @return Whether the membershipBatchUpdatedEventData field is set.
     */
    @java.lang.Override
    public boolean hasMembershipBatchUpdatedEventData() {
      return payloadCase_ == 32;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updated memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchUpdated`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchUpdatedEventData membership_batch_updated_event_data = 32;
     * </code>
     *
     * @return The membershipBatchUpdatedEventData.
     */
    @java.lang.Override
    public com.google.chat.v1.MembershipBatchUpdatedEventData getMembershipBatchUpdatedEventData() {
      if (membershipBatchUpdatedEventDataBuilder_ == null) {
        if (payloadCase_ == 32) {
          return (com.google.chat.v1.MembershipBatchUpdatedEventData) payload_;
        }
        return com.google.chat.v1.MembershipBatchUpdatedEventData.getDefaultInstance();
      } else {
        if (payloadCase_ == 32) {
          return membershipBatchUpdatedEventDataBuilder_.getMessage();
        }
        return com.google.chat.v1.MembershipBatchUpdatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updated memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchUpdated`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchUpdatedEventData membership_batch_updated_event_data = 32;
     * </code>
     */
    public Builder setMembershipBatchUpdatedEventData(
        com.google.chat.v1.MembershipBatchUpdatedEventData value) {
      if (membershipBatchUpdatedEventDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        membershipBatchUpdatedEventDataBuilder_.setMessage(value);
      }
      payloadCase_ = 32;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updated memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchUpdated`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchUpdatedEventData membership_batch_updated_event_data = 32;
     * </code>
     */
    public Builder setMembershipBatchUpdatedEventData(
        com.google.chat.v1.MembershipBatchUpdatedEventData.Builder builderForValue) {
      if (membershipBatchUpdatedEventDataBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        membershipBatchUpdatedEventDataBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 32;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updated memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchUpdated`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchUpdatedEventData membership_batch_updated_event_data = 32;
     * </code>
     */
    public Builder mergeMembershipBatchUpdatedEventData(
        com.google.chat.v1.MembershipBatchUpdatedEventData value) {
      if (membershipBatchUpdatedEventDataBuilder_ == null) {
        if (payloadCase_ == 32
            && payload_
                != com.google.chat.v1.MembershipBatchUpdatedEventData.getDefaultInstance()) {
          payload_ =
              com.google.chat.v1.MembershipBatchUpdatedEventData.newBuilder(
                      (com.google.chat.v1.MembershipBatchUpdatedEventData) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 32) {
          membershipBatchUpdatedEventDataBuilder_.mergeFrom(value);
        } else {
          membershipBatchUpdatedEventDataBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 32;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updated memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchUpdated`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchUpdatedEventData membership_batch_updated_event_data = 32;
     * </code>
     */
    public Builder clearMembershipBatchUpdatedEventData() {
      if (membershipBatchUpdatedEventDataBuilder_ == null) {
        if (payloadCase_ == 32) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 32) {
          payloadCase_ = 0;
          payload_ = null;
        }
        membershipBatchUpdatedEventDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updated memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchUpdated`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchUpdatedEventData membership_batch_updated_event_data = 32;
     * </code>
     */
    public com.google.chat.v1.MembershipBatchUpdatedEventData.Builder
        getMembershipBatchUpdatedEventDataBuilder() {
      return getMembershipBatchUpdatedEventDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updated memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchUpdated`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchUpdatedEventData membership_batch_updated_event_data = 32;
     * </code>
     */
    @java.lang.Override
    public com.google.chat.v1.MembershipBatchUpdatedEventDataOrBuilder
        getMembershipBatchUpdatedEventDataOrBuilder() {
      if ((payloadCase_ == 32) && (membershipBatchUpdatedEventDataBuilder_ != null)) {
        return membershipBatchUpdatedEventDataBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 32) {
          return (com.google.chat.v1.MembershipBatchUpdatedEventData) payload_;
        }
        return com.google.chat.v1.MembershipBatchUpdatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple updated memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchUpdated`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchUpdatedEventData membership_batch_updated_event_data = 32;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MembershipBatchUpdatedEventData,
            com.google.chat.v1.MembershipBatchUpdatedEventData.Builder,
            com.google.chat.v1.MembershipBatchUpdatedEventDataOrBuilder>
        getMembershipBatchUpdatedEventDataFieldBuilder() {
      if (membershipBatchUpdatedEventDataBuilder_ == null) {
        if (!(payloadCase_ == 32)) {
          payload_ = com.google.chat.v1.MembershipBatchUpdatedEventData.getDefaultInstance();
        }
        membershipBatchUpdatedEventDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.MembershipBatchUpdatedEventData,
                com.google.chat.v1.MembershipBatchUpdatedEventData.Builder,
                com.google.chat.v1.MembershipBatchUpdatedEventDataOrBuilder>(
                (com.google.chat.v1.MembershipBatchUpdatedEventData) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 32;
      onChanged();
      return membershipBatchUpdatedEventDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MembershipBatchDeletedEventData,
            com.google.chat.v1.MembershipBatchDeletedEventData.Builder,
            com.google.chat.v1.MembershipBatchDeletedEventDataOrBuilder>
        membershipBatchDeletedEventDataBuilder_;

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchDeleted`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchDeletedEventData membership_batch_deleted_event_data = 33;
     * </code>
     *
     * @return Whether the membershipBatchDeletedEventData field is set.
     */
    @java.lang.Override
    public boolean hasMembershipBatchDeletedEventData() {
      return payloadCase_ == 33;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchDeleted`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchDeletedEventData membership_batch_deleted_event_data = 33;
     * </code>
     *
     * @return The membershipBatchDeletedEventData.
     */
    @java.lang.Override
    public com.google.chat.v1.MembershipBatchDeletedEventData getMembershipBatchDeletedEventData() {
      if (membershipBatchDeletedEventDataBuilder_ == null) {
        if (payloadCase_ == 33) {
          return (com.google.chat.v1.MembershipBatchDeletedEventData) payload_;
        }
        return com.google.chat.v1.MembershipBatchDeletedEventData.getDefaultInstance();
      } else {
        if (payloadCase_ == 33) {
          return membershipBatchDeletedEventDataBuilder_.getMessage();
        }
        return com.google.chat.v1.MembershipBatchDeletedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchDeleted`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchDeletedEventData membership_batch_deleted_event_data = 33;
     * </code>
     */
    public Builder setMembershipBatchDeletedEventData(
        com.google.chat.v1.MembershipBatchDeletedEventData value) {
      if (membershipBatchDeletedEventDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        membershipBatchDeletedEventDataBuilder_.setMessage(value);
      }
      payloadCase_ = 33;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchDeleted`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchDeletedEventData membership_batch_deleted_event_data = 33;
     * </code>
     */
    public Builder setMembershipBatchDeletedEventData(
        com.google.chat.v1.MembershipBatchDeletedEventData.Builder builderForValue) {
      if (membershipBatchDeletedEventDataBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        membershipBatchDeletedEventDataBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 33;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchDeleted`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchDeletedEventData membership_batch_deleted_event_data = 33;
     * </code>
     */
    public Builder mergeMembershipBatchDeletedEventData(
        com.google.chat.v1.MembershipBatchDeletedEventData value) {
      if (membershipBatchDeletedEventDataBuilder_ == null) {
        if (payloadCase_ == 33
            && payload_
                != com.google.chat.v1.MembershipBatchDeletedEventData.getDefaultInstance()) {
          payload_ =
              com.google.chat.v1.MembershipBatchDeletedEventData.newBuilder(
                      (com.google.chat.v1.MembershipBatchDeletedEventData) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 33) {
          membershipBatchDeletedEventDataBuilder_.mergeFrom(value);
        } else {
          membershipBatchDeletedEventDataBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 33;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchDeleted`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchDeletedEventData membership_batch_deleted_event_data = 33;
     * </code>
     */
    public Builder clearMembershipBatchDeletedEventData() {
      if (membershipBatchDeletedEventDataBuilder_ == null) {
        if (payloadCase_ == 33) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 33) {
          payloadCase_ = 0;
          payload_ = null;
        }
        membershipBatchDeletedEventDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchDeleted`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchDeletedEventData membership_batch_deleted_event_data = 33;
     * </code>
     */
    public com.google.chat.v1.MembershipBatchDeletedEventData.Builder
        getMembershipBatchDeletedEventDataBuilder() {
      return getMembershipBatchDeletedEventDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchDeleted`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchDeletedEventData membership_batch_deleted_event_data = 33;
     * </code>
     */
    @java.lang.Override
    public com.google.chat.v1.MembershipBatchDeletedEventDataOrBuilder
        getMembershipBatchDeletedEventDataOrBuilder() {
      if ((payloadCase_ == 33) && (membershipBatchDeletedEventDataBuilder_ != null)) {
        return membershipBatchDeletedEventDataBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 33) {
          return (com.google.chat.v1.MembershipBatchDeletedEventData) payload_;
        }
        return com.google.chat.v1.MembershipBatchDeletedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted memberships.
     *
     * Event type: `google.workspace.chat.membership.v1.batchDeleted`
     * </pre>
     *
     * <code>
     * .google.chat.v1.MembershipBatchDeletedEventData membership_batch_deleted_event_data = 33;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.MembershipBatchDeletedEventData,
            com.google.chat.v1.MembershipBatchDeletedEventData.Builder,
            com.google.chat.v1.MembershipBatchDeletedEventDataOrBuilder>
        getMembershipBatchDeletedEventDataFieldBuilder() {
      if (membershipBatchDeletedEventDataBuilder_ == null) {
        if (!(payloadCase_ == 33)) {
          payload_ = com.google.chat.v1.MembershipBatchDeletedEventData.getDefaultInstance();
        }
        membershipBatchDeletedEventDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.MembershipBatchDeletedEventData,
                com.google.chat.v1.MembershipBatchDeletedEventData.Builder,
                com.google.chat.v1.MembershipBatchDeletedEventDataOrBuilder>(
                (com.google.chat.v1.MembershipBatchDeletedEventData) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 33;
      onChanged();
      return membershipBatchDeletedEventDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.ReactionCreatedEventData,
            com.google.chat.v1.ReactionCreatedEventData.Builder,
            com.google.chat.v1.ReactionCreatedEventDataOrBuilder>
        reactionCreatedEventDataBuilder_;

    /**
     *
     *
     * <pre>
     * Event payload for a new reaction.
     *
     * Event type: `google.workspace.chat.reaction.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionCreatedEventData reaction_created_event_data = 21;</code>
     *
     * @return Whether the reactionCreatedEventData field is set.
     */
    @java.lang.Override
    public boolean hasReactionCreatedEventData() {
      return payloadCase_ == 21;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new reaction.
     *
     * Event type: `google.workspace.chat.reaction.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionCreatedEventData reaction_created_event_data = 21;</code>
     *
     * @return The reactionCreatedEventData.
     */
    @java.lang.Override
    public com.google.chat.v1.ReactionCreatedEventData getReactionCreatedEventData() {
      if (reactionCreatedEventDataBuilder_ == null) {
        if (payloadCase_ == 21) {
          return (com.google.chat.v1.ReactionCreatedEventData) payload_;
        }
        return com.google.chat.v1.ReactionCreatedEventData.getDefaultInstance();
      } else {
        if (payloadCase_ == 21) {
          return reactionCreatedEventDataBuilder_.getMessage();
        }
        return com.google.chat.v1.ReactionCreatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new reaction.
     *
     * Event type: `google.workspace.chat.reaction.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionCreatedEventData reaction_created_event_data = 21;</code>
     */
    public Builder setReactionCreatedEventData(com.google.chat.v1.ReactionCreatedEventData value) {
      if (reactionCreatedEventDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        reactionCreatedEventDataBuilder_.setMessage(value);
      }
      payloadCase_ = 21;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new reaction.
     *
     * Event type: `google.workspace.chat.reaction.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionCreatedEventData reaction_created_event_data = 21;</code>
     */
    public Builder setReactionCreatedEventData(
        com.google.chat.v1.ReactionCreatedEventData.Builder builderForValue) {
      if (reactionCreatedEventDataBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        reactionCreatedEventDataBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 21;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new reaction.
     *
     * Event type: `google.workspace.chat.reaction.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionCreatedEventData reaction_created_event_data = 21;</code>
     */
    public Builder mergeReactionCreatedEventData(
        com.google.chat.v1.ReactionCreatedEventData value) {
      if (reactionCreatedEventDataBuilder_ == null) {
        if (payloadCase_ == 21
            && payload_ != com.google.chat.v1.ReactionCreatedEventData.getDefaultInstance()) {
          payload_ =
              com.google.chat.v1.ReactionCreatedEventData.newBuilder(
                      (com.google.chat.v1.ReactionCreatedEventData) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 21) {
          reactionCreatedEventDataBuilder_.mergeFrom(value);
        } else {
          reactionCreatedEventDataBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 21;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new reaction.
     *
     * Event type: `google.workspace.chat.reaction.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionCreatedEventData reaction_created_event_data = 21;</code>
     */
    public Builder clearReactionCreatedEventData() {
      if (reactionCreatedEventDataBuilder_ == null) {
        if (payloadCase_ == 21) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 21) {
          payloadCase_ = 0;
          payload_ = null;
        }
        reactionCreatedEventDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new reaction.
     *
     * Event type: `google.workspace.chat.reaction.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionCreatedEventData reaction_created_event_data = 21;</code>
     */
    public com.google.chat.v1.ReactionCreatedEventData.Builder
        getReactionCreatedEventDataBuilder() {
      return getReactionCreatedEventDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new reaction.
     *
     * Event type: `google.workspace.chat.reaction.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionCreatedEventData reaction_created_event_data = 21;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.ReactionCreatedEventDataOrBuilder
        getReactionCreatedEventDataOrBuilder() {
      if ((payloadCase_ == 21) && (reactionCreatedEventDataBuilder_ != null)) {
        return reactionCreatedEventDataBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 21) {
          return (com.google.chat.v1.ReactionCreatedEventData) payload_;
        }
        return com.google.chat.v1.ReactionCreatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for a new reaction.
     *
     * Event type: `google.workspace.chat.reaction.v1.created`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionCreatedEventData reaction_created_event_data = 21;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.ReactionCreatedEventData,
            com.google.chat.v1.ReactionCreatedEventData.Builder,
            com.google.chat.v1.ReactionCreatedEventDataOrBuilder>
        getReactionCreatedEventDataFieldBuilder() {
      if (reactionCreatedEventDataBuilder_ == null) {
        if (!(payloadCase_ == 21)) {
          payload_ = com.google.chat.v1.ReactionCreatedEventData.getDefaultInstance();
        }
        reactionCreatedEventDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.ReactionCreatedEventData,
                com.google.chat.v1.ReactionCreatedEventData.Builder,
                com.google.chat.v1.ReactionCreatedEventDataOrBuilder>(
                (com.google.chat.v1.ReactionCreatedEventData) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 21;
      onChanged();
      return reactionCreatedEventDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.ReactionDeletedEventData,
            com.google.chat.v1.ReactionDeletedEventData.Builder,
            com.google.chat.v1.ReactionDeletedEventDataOrBuilder>
        reactionDeletedEventDataBuilder_;

    /**
     *
     *
     * <pre>
     * Event payload for a deleted reaction.
     *
     * Event type: `google.workspace.chat.reaction.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionDeletedEventData reaction_deleted_event_data = 22;</code>
     *
     * @return Whether the reactionDeletedEventData field is set.
     */
    @java.lang.Override
    public boolean hasReactionDeletedEventData() {
      return payloadCase_ == 22;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted reaction.
     *
     * Event type: `google.workspace.chat.reaction.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionDeletedEventData reaction_deleted_event_data = 22;</code>
     *
     * @return The reactionDeletedEventData.
     */
    @java.lang.Override
    public com.google.chat.v1.ReactionDeletedEventData getReactionDeletedEventData() {
      if (reactionDeletedEventDataBuilder_ == null) {
        if (payloadCase_ == 22) {
          return (com.google.chat.v1.ReactionDeletedEventData) payload_;
        }
        return com.google.chat.v1.ReactionDeletedEventData.getDefaultInstance();
      } else {
        if (payloadCase_ == 22) {
          return reactionDeletedEventDataBuilder_.getMessage();
        }
        return com.google.chat.v1.ReactionDeletedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted reaction.
     *
     * Event type: `google.workspace.chat.reaction.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionDeletedEventData reaction_deleted_event_data = 22;</code>
     */
    public Builder setReactionDeletedEventData(com.google.chat.v1.ReactionDeletedEventData value) {
      if (reactionDeletedEventDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        reactionDeletedEventDataBuilder_.setMessage(value);
      }
      payloadCase_ = 22;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted reaction.
     *
     * Event type: `google.workspace.chat.reaction.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionDeletedEventData reaction_deleted_event_data = 22;</code>
     */
    public Builder setReactionDeletedEventData(
        com.google.chat.v1.ReactionDeletedEventData.Builder builderForValue) {
      if (reactionDeletedEventDataBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        reactionDeletedEventDataBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 22;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted reaction.
     *
     * Event type: `google.workspace.chat.reaction.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionDeletedEventData reaction_deleted_event_data = 22;</code>
     */
    public Builder mergeReactionDeletedEventData(
        com.google.chat.v1.ReactionDeletedEventData value) {
      if (reactionDeletedEventDataBuilder_ == null) {
        if (payloadCase_ == 22
            && payload_ != com.google.chat.v1.ReactionDeletedEventData.getDefaultInstance()) {
          payload_ =
              com.google.chat.v1.ReactionDeletedEventData.newBuilder(
                      (com.google.chat.v1.ReactionDeletedEventData) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 22) {
          reactionDeletedEventDataBuilder_.mergeFrom(value);
        } else {
          reactionDeletedEventDataBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 22;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted reaction.
     *
     * Event type: `google.workspace.chat.reaction.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionDeletedEventData reaction_deleted_event_data = 22;</code>
     */
    public Builder clearReactionDeletedEventData() {
      if (reactionDeletedEventDataBuilder_ == null) {
        if (payloadCase_ == 22) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 22) {
          payloadCase_ = 0;
          payload_ = null;
        }
        reactionDeletedEventDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted reaction.
     *
     * Event type: `google.workspace.chat.reaction.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionDeletedEventData reaction_deleted_event_data = 22;</code>
     */
    public com.google.chat.v1.ReactionDeletedEventData.Builder
        getReactionDeletedEventDataBuilder() {
      return getReactionDeletedEventDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted reaction.
     *
     * Event type: `google.workspace.chat.reaction.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionDeletedEventData reaction_deleted_event_data = 22;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.ReactionDeletedEventDataOrBuilder
        getReactionDeletedEventDataOrBuilder() {
      if ((payloadCase_ == 22) && (reactionDeletedEventDataBuilder_ != null)) {
        return reactionDeletedEventDataBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 22) {
          return (com.google.chat.v1.ReactionDeletedEventData) payload_;
        }
        return com.google.chat.v1.ReactionDeletedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for a deleted reaction.
     *
     * Event type: `google.workspace.chat.reaction.v1.deleted`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionDeletedEventData reaction_deleted_event_data = 22;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.ReactionDeletedEventData,
            com.google.chat.v1.ReactionDeletedEventData.Builder,
            com.google.chat.v1.ReactionDeletedEventDataOrBuilder>
        getReactionDeletedEventDataFieldBuilder() {
      if (reactionDeletedEventDataBuilder_ == null) {
        if (!(payloadCase_ == 22)) {
          payload_ = com.google.chat.v1.ReactionDeletedEventData.getDefaultInstance();
        }
        reactionDeletedEventDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.ReactionDeletedEventData,
                com.google.chat.v1.ReactionDeletedEventData.Builder,
                com.google.chat.v1.ReactionDeletedEventDataOrBuilder>(
                (com.google.chat.v1.ReactionDeletedEventData) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 22;
      onChanged();
      return reactionDeletedEventDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.ReactionBatchCreatedEventData,
            com.google.chat.v1.ReactionBatchCreatedEventData.Builder,
            com.google.chat.v1.ReactionBatchCreatedEventDataOrBuilder>
        reactionBatchCreatedEventDataBuilder_;

    /**
     *
     *
     * <pre>
     * Event payload for multiple new reactions.
     *
     * Event type: `google.workspace.chat.reaction.v1.batchCreated`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionBatchCreatedEventData reaction_batch_created_event_data = 34;
     * </code>
     *
     * @return Whether the reactionBatchCreatedEventData field is set.
     */
    @java.lang.Override
    public boolean hasReactionBatchCreatedEventData() {
      return payloadCase_ == 34;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new reactions.
     *
     * Event type: `google.workspace.chat.reaction.v1.batchCreated`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionBatchCreatedEventData reaction_batch_created_event_data = 34;
     * </code>
     *
     * @return The reactionBatchCreatedEventData.
     */
    @java.lang.Override
    public com.google.chat.v1.ReactionBatchCreatedEventData getReactionBatchCreatedEventData() {
      if (reactionBatchCreatedEventDataBuilder_ == null) {
        if (payloadCase_ == 34) {
          return (com.google.chat.v1.ReactionBatchCreatedEventData) payload_;
        }
        return com.google.chat.v1.ReactionBatchCreatedEventData.getDefaultInstance();
      } else {
        if (payloadCase_ == 34) {
          return reactionBatchCreatedEventDataBuilder_.getMessage();
        }
        return com.google.chat.v1.ReactionBatchCreatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new reactions.
     *
     * Event type: `google.workspace.chat.reaction.v1.batchCreated`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionBatchCreatedEventData reaction_batch_created_event_data = 34;
     * </code>
     */
    public Builder setReactionBatchCreatedEventData(
        com.google.chat.v1.ReactionBatchCreatedEventData value) {
      if (reactionBatchCreatedEventDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        reactionBatchCreatedEventDataBuilder_.setMessage(value);
      }
      payloadCase_ = 34;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new reactions.
     *
     * Event type: `google.workspace.chat.reaction.v1.batchCreated`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionBatchCreatedEventData reaction_batch_created_event_data = 34;
     * </code>
     */
    public Builder setReactionBatchCreatedEventData(
        com.google.chat.v1.ReactionBatchCreatedEventData.Builder builderForValue) {
      if (reactionBatchCreatedEventDataBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        reactionBatchCreatedEventDataBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 34;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new reactions.
     *
     * Event type: `google.workspace.chat.reaction.v1.batchCreated`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionBatchCreatedEventData reaction_batch_created_event_data = 34;
     * </code>
     */
    public Builder mergeReactionBatchCreatedEventData(
        com.google.chat.v1.ReactionBatchCreatedEventData value) {
      if (reactionBatchCreatedEventDataBuilder_ == null) {
        if (payloadCase_ == 34
            && payload_ != com.google.chat.v1.ReactionBatchCreatedEventData.getDefaultInstance()) {
          payload_ =
              com.google.chat.v1.ReactionBatchCreatedEventData.newBuilder(
                      (com.google.chat.v1.ReactionBatchCreatedEventData) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 34) {
          reactionBatchCreatedEventDataBuilder_.mergeFrom(value);
        } else {
          reactionBatchCreatedEventDataBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 34;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new reactions.
     *
     * Event type: `google.workspace.chat.reaction.v1.batchCreated`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionBatchCreatedEventData reaction_batch_created_event_data = 34;
     * </code>
     */
    public Builder clearReactionBatchCreatedEventData() {
      if (reactionBatchCreatedEventDataBuilder_ == null) {
        if (payloadCase_ == 34) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 34) {
          payloadCase_ = 0;
          payload_ = null;
        }
        reactionBatchCreatedEventDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new reactions.
     *
     * Event type: `google.workspace.chat.reaction.v1.batchCreated`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionBatchCreatedEventData reaction_batch_created_event_data = 34;
     * </code>
     */
    public com.google.chat.v1.ReactionBatchCreatedEventData.Builder
        getReactionBatchCreatedEventDataBuilder() {
      return getReactionBatchCreatedEventDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new reactions.
     *
     * Event type: `google.workspace.chat.reaction.v1.batchCreated`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionBatchCreatedEventData reaction_batch_created_event_data = 34;
     * </code>
     */
    @java.lang.Override
    public com.google.chat.v1.ReactionBatchCreatedEventDataOrBuilder
        getReactionBatchCreatedEventDataOrBuilder() {
      if ((payloadCase_ == 34) && (reactionBatchCreatedEventDataBuilder_ != null)) {
        return reactionBatchCreatedEventDataBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 34) {
          return (com.google.chat.v1.ReactionBatchCreatedEventData) payload_;
        }
        return com.google.chat.v1.ReactionBatchCreatedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple new reactions.
     *
     * Event type: `google.workspace.chat.reaction.v1.batchCreated`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionBatchCreatedEventData reaction_batch_created_event_data = 34;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.ReactionBatchCreatedEventData,
            com.google.chat.v1.ReactionBatchCreatedEventData.Builder,
            com.google.chat.v1.ReactionBatchCreatedEventDataOrBuilder>
        getReactionBatchCreatedEventDataFieldBuilder() {
      if (reactionBatchCreatedEventDataBuilder_ == null) {
        if (!(payloadCase_ == 34)) {
          payload_ = com.google.chat.v1.ReactionBatchCreatedEventData.getDefaultInstance();
        }
        reactionBatchCreatedEventDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.ReactionBatchCreatedEventData,
                com.google.chat.v1.ReactionBatchCreatedEventData.Builder,
                com.google.chat.v1.ReactionBatchCreatedEventDataOrBuilder>(
                (com.google.chat.v1.ReactionBatchCreatedEventData) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 34;
      onChanged();
      return reactionBatchCreatedEventDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.ReactionBatchDeletedEventData,
            com.google.chat.v1.ReactionBatchDeletedEventData.Builder,
            com.google.chat.v1.ReactionBatchDeletedEventDataOrBuilder>
        reactionBatchDeletedEventDataBuilder_;

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted reactions.
     *
     * Event type: `google.workspace.chat.reaction.v1.batchDeleted`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionBatchDeletedEventData reaction_batch_deleted_event_data = 35;
     * </code>
     *
     * @return Whether the reactionBatchDeletedEventData field is set.
     */
    @java.lang.Override
    public boolean hasReactionBatchDeletedEventData() {
      return payloadCase_ == 35;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted reactions.
     *
     * Event type: `google.workspace.chat.reaction.v1.batchDeleted`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionBatchDeletedEventData reaction_batch_deleted_event_data = 35;
     * </code>
     *
     * @return The reactionBatchDeletedEventData.
     */
    @java.lang.Override
    public com.google.chat.v1.ReactionBatchDeletedEventData getReactionBatchDeletedEventData() {
      if (reactionBatchDeletedEventDataBuilder_ == null) {
        if (payloadCase_ == 35) {
          return (com.google.chat.v1.ReactionBatchDeletedEventData) payload_;
        }
        return com.google.chat.v1.ReactionBatchDeletedEventData.getDefaultInstance();
      } else {
        if (payloadCase_ == 35) {
          return reactionBatchDeletedEventDataBuilder_.getMessage();
        }
        return com.google.chat.v1.ReactionBatchDeletedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted reactions.
     *
     * Event type: `google.workspace.chat.reaction.v1.batchDeleted`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionBatchDeletedEventData reaction_batch_deleted_event_data = 35;
     * </code>
     */
    public Builder setReactionBatchDeletedEventData(
        com.google.chat.v1.ReactionBatchDeletedEventData value) {
      if (reactionBatchDeletedEventDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        reactionBatchDeletedEventDataBuilder_.setMessage(value);
      }
      payloadCase_ = 35;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted reactions.
     *
     * Event type: `google.workspace.chat.reaction.v1.batchDeleted`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionBatchDeletedEventData reaction_batch_deleted_event_data = 35;
     * </code>
     */
    public Builder setReactionBatchDeletedEventData(
        com.google.chat.v1.ReactionBatchDeletedEventData.Builder builderForValue) {
      if (reactionBatchDeletedEventDataBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        reactionBatchDeletedEventDataBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 35;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted reactions.
     *
     * Event type: `google.workspace.chat.reaction.v1.batchDeleted`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionBatchDeletedEventData reaction_batch_deleted_event_data = 35;
     * </code>
     */
    public Builder mergeReactionBatchDeletedEventData(
        com.google.chat.v1.ReactionBatchDeletedEventData value) {
      if (reactionBatchDeletedEventDataBuilder_ == null) {
        if (payloadCase_ == 35
            && payload_ != com.google.chat.v1.ReactionBatchDeletedEventData.getDefaultInstance()) {
          payload_ =
              com.google.chat.v1.ReactionBatchDeletedEventData.newBuilder(
                      (com.google.chat.v1.ReactionBatchDeletedEventData) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 35) {
          reactionBatchDeletedEventDataBuilder_.mergeFrom(value);
        } else {
          reactionBatchDeletedEventDataBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 35;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted reactions.
     *
     * Event type: `google.workspace.chat.reaction.v1.batchDeleted`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionBatchDeletedEventData reaction_batch_deleted_event_data = 35;
     * </code>
     */
    public Builder clearReactionBatchDeletedEventData() {
      if (reactionBatchDeletedEventDataBuilder_ == null) {
        if (payloadCase_ == 35) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 35) {
          payloadCase_ = 0;
          payload_ = null;
        }
        reactionBatchDeletedEventDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted reactions.
     *
     * Event type: `google.workspace.chat.reaction.v1.batchDeleted`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionBatchDeletedEventData reaction_batch_deleted_event_data = 35;
     * </code>
     */
    public com.google.chat.v1.ReactionBatchDeletedEventData.Builder
        getReactionBatchDeletedEventDataBuilder() {
      return getReactionBatchDeletedEventDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted reactions.
     *
     * Event type: `google.workspace.chat.reaction.v1.batchDeleted`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionBatchDeletedEventData reaction_batch_deleted_event_data = 35;
     * </code>
     */
    @java.lang.Override
    public com.google.chat.v1.ReactionBatchDeletedEventDataOrBuilder
        getReactionBatchDeletedEventDataOrBuilder() {
      if ((payloadCase_ == 35) && (reactionBatchDeletedEventDataBuilder_ != null)) {
        return reactionBatchDeletedEventDataBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 35) {
          return (com.google.chat.v1.ReactionBatchDeletedEventData) payload_;
        }
        return com.google.chat.v1.ReactionBatchDeletedEventData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Event payload for multiple deleted reactions.
     *
     * Event type: `google.workspace.chat.reaction.v1.batchDeleted`
     * </pre>
     *
     * <code>.google.chat.v1.ReactionBatchDeletedEventData reaction_batch_deleted_event_data = 35;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.ReactionBatchDeletedEventData,
            com.google.chat.v1.ReactionBatchDeletedEventData.Builder,
            com.google.chat.v1.ReactionBatchDeletedEventDataOrBuilder>
        getReactionBatchDeletedEventDataFieldBuilder() {
      if (reactionBatchDeletedEventDataBuilder_ == null) {
        if (!(payloadCase_ == 35)) {
          payload_ = com.google.chat.v1.ReactionBatchDeletedEventData.getDefaultInstance();
        }
        reactionBatchDeletedEventDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.ReactionBatchDeletedEventData,
                com.google.chat.v1.ReactionBatchDeletedEventData.Builder,
                com.google.chat.v1.ReactionBatchDeletedEventDataOrBuilder>(
                (com.google.chat.v1.ReactionBatchDeletedEventData) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 35;
      onChanged();
      return reactionBatchDeletedEventDataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.SpaceEvent)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.SpaceEvent)
  private static final com.google.chat.v1.SpaceEvent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.SpaceEvent();
  }

  public static com.google.chat.v1.SpaceEvent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SpaceEvent> PARSER =
      new com.google.protobuf.AbstractParser<SpaceEvent>() {
        @java.lang.Override
        public SpaceEvent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SpaceEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SpaceEvent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.SpaceEvent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
