/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/space_event.proto

// Protobuf Java Version: 3.25.5
package com.google.chat.v1;

public interface SpaceEventOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.chat.v1.SpaceEvent)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Resource name of the space event.
   *
   * Format: `spaces/{space}/spaceEvents/{spaceEvent}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Resource name of the space event.
   *
   * Format: `spaces/{space}/spaceEvents/{spaceEvent}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Time when the event occurred.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 3;</code>
   *
   * @return Whether the eventTime field is set.
   */
  boolean hasEventTime();

  /**
   *
   *
   * <pre>
   * Time when the event occurred.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 3;</code>
   *
   * @return The eventTime.
   */
  com.google.protobuf.Timestamp getEventTime();

  /**
   *
   *
   * <pre>
   * Time when the event occurred.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 3;</code>
   */
  com.google.protobuf.TimestampOrBuilder getEventTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Type of space event. Each event type has a batch version, which
   * represents multiple instances of the event type that occur in a short
   * period of time. For `spaceEvents.list()` requests, omit batch event types
   * in your query filter. By default, the server returns both event type and
   * its batch version.
   *
   * Supported event types for
   * [messages](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages):
   *
   *    * New message: `google.workspace.chat.message.v1.created`
   *    * Updated message: `google.workspace.chat.message.v1.updated`
   *    * Deleted message: `google.workspace.chat.message.v1.deleted`
   *    * Multiple new messages: `google.workspace.chat.message.v1.batchCreated`
   *    * Multiple updated messages:
   *    `google.workspace.chat.message.v1.batchUpdated`
   *    * Multiple deleted messages:
   *    `google.workspace.chat.message.v1.batchDeleted`
   *
   * Supported event types for
   * [memberships](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members):
   *
   *   * New membership: `google.workspace.chat.membership.v1.created`
   *   * Updated membership: `google.workspace.chat.membership.v1.updated`
   *   * Deleted membership: `google.workspace.chat.membership.v1.deleted`
   *   * Multiple new memberships:
   *   `google.workspace.chat.membership.v1.batchCreated`
   *   * Multiple updated memberships:
   *   `google.workspace.chat.membership.v1.batchUpdated`
   *   * Multiple deleted memberships:
   *   `google.workspace.chat.membership.v1.batchDeleted`
   *
   * Supported event types for
   * [reactions](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.reactions):
   *
   *   * New reaction: `google.workspace.chat.reaction.v1.created`
   *   * Deleted reaction: `google.workspace.chat.reaction.v1.deleted`
   *   * Multiple new reactions:
   *   `google.workspace.chat.reaction.v1.batchCreated`
   *   * Multiple deleted reactions:
   *   `google.workspace.chat.reaction.v1.batchDeleted`
   *
   * Supported event types about the
   * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces):
   *
   *   * Updated space: `google.workspace.chat.space.v1.updated`
   *   * Multiple space updates: `google.workspace.chat.space.v1.batchUpdated`
   * </pre>
   *
   * <code>string event_type = 6;</code>
   *
   * @return The eventType.
   */
  java.lang.String getEventType();

  /**
   *
   *
   * <pre>
   * Type of space event. Each event type has a batch version, which
   * represents multiple instances of the event type that occur in a short
   * period of time. For `spaceEvents.list()` requests, omit batch event types
   * in your query filter. By default, the server returns both event type and
   * its batch version.
   *
   * Supported event types for
   * [messages](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages):
   *
   *    * New message: `google.workspace.chat.message.v1.created`
   *    * Updated message: `google.workspace.chat.message.v1.updated`
   *    * Deleted message: `google.workspace.chat.message.v1.deleted`
   *    * Multiple new messages: `google.workspace.chat.message.v1.batchCreated`
   *    * Multiple updated messages:
   *    `google.workspace.chat.message.v1.batchUpdated`
   *    * Multiple deleted messages:
   *    `google.workspace.chat.message.v1.batchDeleted`
   *
   * Supported event types for
   * [memberships](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members):
   *
   *   * New membership: `google.workspace.chat.membership.v1.created`
   *   * Updated membership: `google.workspace.chat.membership.v1.updated`
   *   * Deleted membership: `google.workspace.chat.membership.v1.deleted`
   *   * Multiple new memberships:
   *   `google.workspace.chat.membership.v1.batchCreated`
   *   * Multiple updated memberships:
   *   `google.workspace.chat.membership.v1.batchUpdated`
   *   * Multiple deleted memberships:
   *   `google.workspace.chat.membership.v1.batchDeleted`
   *
   * Supported event types for
   * [reactions](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.reactions):
   *
   *   * New reaction: `google.workspace.chat.reaction.v1.created`
   *   * Deleted reaction: `google.workspace.chat.reaction.v1.deleted`
   *   * Multiple new reactions:
   *   `google.workspace.chat.reaction.v1.batchCreated`
   *   * Multiple deleted reactions:
   *   `google.workspace.chat.reaction.v1.batchDeleted`
   *
   * Supported event types about the
   * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces):
   *
   *   * Updated space: `google.workspace.chat.space.v1.updated`
   *   * Multiple space updates: `google.workspace.chat.space.v1.batchUpdated`
   * </pre>
   *
   * <code>string event_type = 6;</code>
   *
   * @return The bytes for eventType.
   */
  com.google.protobuf.ByteString getEventTypeBytes();

  /**
   *
   *
   * <pre>
   * Event payload for a new message.
   *
   * Event type: `google.workspace.chat.message.v1.created`
   * </pre>
   *
   * <code>.google.chat.v1.MessageCreatedEventData message_created_event_data = 12;</code>
   *
   * @return Whether the messageCreatedEventData field is set.
   */
  boolean hasMessageCreatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for a new message.
   *
   * Event type: `google.workspace.chat.message.v1.created`
   * </pre>
   *
   * <code>.google.chat.v1.MessageCreatedEventData message_created_event_data = 12;</code>
   *
   * @return The messageCreatedEventData.
   */
  com.google.chat.v1.MessageCreatedEventData getMessageCreatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for a new message.
   *
   * Event type: `google.workspace.chat.message.v1.created`
   * </pre>
   *
   * <code>.google.chat.v1.MessageCreatedEventData message_created_event_data = 12;</code>
   */
  com.google.chat.v1.MessageCreatedEventDataOrBuilder getMessageCreatedEventDataOrBuilder();

  /**
   *
   *
   * <pre>
   * Event payload for an updated message.
   *
   * Event type: `google.workspace.chat.message.v1.updated`
   * </pre>
   *
   * <code>.google.chat.v1.MessageUpdatedEventData message_updated_event_data = 13;</code>
   *
   * @return Whether the messageUpdatedEventData field is set.
   */
  boolean hasMessageUpdatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for an updated message.
   *
   * Event type: `google.workspace.chat.message.v1.updated`
   * </pre>
   *
   * <code>.google.chat.v1.MessageUpdatedEventData message_updated_event_data = 13;</code>
   *
   * @return The messageUpdatedEventData.
   */
  com.google.chat.v1.MessageUpdatedEventData getMessageUpdatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for an updated message.
   *
   * Event type: `google.workspace.chat.message.v1.updated`
   * </pre>
   *
   * <code>.google.chat.v1.MessageUpdatedEventData message_updated_event_data = 13;</code>
   */
  com.google.chat.v1.MessageUpdatedEventDataOrBuilder getMessageUpdatedEventDataOrBuilder();

  /**
   *
   *
   * <pre>
   * Event payload for a deleted message.
   *
   * Event type: `google.workspace.chat.message.v1.deleted`
   * </pre>
   *
   * <code>.google.chat.v1.MessageDeletedEventData message_deleted_event_data = 14;</code>
   *
   * @return Whether the messageDeletedEventData field is set.
   */
  boolean hasMessageDeletedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for a deleted message.
   *
   * Event type: `google.workspace.chat.message.v1.deleted`
   * </pre>
   *
   * <code>.google.chat.v1.MessageDeletedEventData message_deleted_event_data = 14;</code>
   *
   * @return The messageDeletedEventData.
   */
  com.google.chat.v1.MessageDeletedEventData getMessageDeletedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for a deleted message.
   *
   * Event type: `google.workspace.chat.message.v1.deleted`
   * </pre>
   *
   * <code>.google.chat.v1.MessageDeletedEventData message_deleted_event_data = 14;</code>
   */
  com.google.chat.v1.MessageDeletedEventDataOrBuilder getMessageDeletedEventDataOrBuilder();

  /**
   *
   *
   * <pre>
   * Event payload for multiple new messages.
   *
   * Event type: `google.workspace.chat.message.v1.batchCreated`
   * </pre>
   *
   * <code>.google.chat.v1.MessageBatchCreatedEventData message_batch_created_event_data = 26;
   * </code>
   *
   * @return Whether the messageBatchCreatedEventData field is set.
   */
  boolean hasMessageBatchCreatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for multiple new messages.
   *
   * Event type: `google.workspace.chat.message.v1.batchCreated`
   * </pre>
   *
   * <code>.google.chat.v1.MessageBatchCreatedEventData message_batch_created_event_data = 26;
   * </code>
   *
   * @return The messageBatchCreatedEventData.
   */
  com.google.chat.v1.MessageBatchCreatedEventData getMessageBatchCreatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for multiple new messages.
   *
   * Event type: `google.workspace.chat.message.v1.batchCreated`
   * </pre>
   *
   * <code>.google.chat.v1.MessageBatchCreatedEventData message_batch_created_event_data = 26;
   * </code>
   */
  com.google.chat.v1.MessageBatchCreatedEventDataOrBuilder
      getMessageBatchCreatedEventDataOrBuilder();

  /**
   *
   *
   * <pre>
   * Event payload for multiple updated messages.
   *
   * Event type: `google.workspace.chat.message.v1.batchUpdated`
   * </pre>
   *
   * <code>.google.chat.v1.MessageBatchUpdatedEventData message_batch_updated_event_data = 27;
   * </code>
   *
   * @return Whether the messageBatchUpdatedEventData field is set.
   */
  boolean hasMessageBatchUpdatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for multiple updated messages.
   *
   * Event type: `google.workspace.chat.message.v1.batchUpdated`
   * </pre>
   *
   * <code>.google.chat.v1.MessageBatchUpdatedEventData message_batch_updated_event_data = 27;
   * </code>
   *
   * @return The messageBatchUpdatedEventData.
   */
  com.google.chat.v1.MessageBatchUpdatedEventData getMessageBatchUpdatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for multiple updated messages.
   *
   * Event type: `google.workspace.chat.message.v1.batchUpdated`
   * </pre>
   *
   * <code>.google.chat.v1.MessageBatchUpdatedEventData message_batch_updated_event_data = 27;
   * </code>
   */
  com.google.chat.v1.MessageBatchUpdatedEventDataOrBuilder
      getMessageBatchUpdatedEventDataOrBuilder();

  /**
   *
   *
   * <pre>
   * Event payload for multiple deleted messages.
   *
   * Event type: `google.workspace.chat.message.v1.batchDeleted`
   * </pre>
   *
   * <code>.google.chat.v1.MessageBatchDeletedEventData message_batch_deleted_event_data = 28;
   * </code>
   *
   * @return Whether the messageBatchDeletedEventData field is set.
   */
  boolean hasMessageBatchDeletedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for multiple deleted messages.
   *
   * Event type: `google.workspace.chat.message.v1.batchDeleted`
   * </pre>
   *
   * <code>.google.chat.v1.MessageBatchDeletedEventData message_batch_deleted_event_data = 28;
   * </code>
   *
   * @return The messageBatchDeletedEventData.
   */
  com.google.chat.v1.MessageBatchDeletedEventData getMessageBatchDeletedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for multiple deleted messages.
   *
   * Event type: `google.workspace.chat.message.v1.batchDeleted`
   * </pre>
   *
   * <code>.google.chat.v1.MessageBatchDeletedEventData message_batch_deleted_event_data = 28;
   * </code>
   */
  com.google.chat.v1.MessageBatchDeletedEventDataOrBuilder
      getMessageBatchDeletedEventDataOrBuilder();

  /**
   *
   *
   * <pre>
   * Event payload for a space update.
   *
   * Event type: `google.workspace.chat.space.v1.updated`
   * </pre>
   *
   * <code>.google.chat.v1.SpaceUpdatedEventData space_updated_event_data = 15;</code>
   *
   * @return Whether the spaceUpdatedEventData field is set.
   */
  boolean hasSpaceUpdatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for a space update.
   *
   * Event type: `google.workspace.chat.space.v1.updated`
   * </pre>
   *
   * <code>.google.chat.v1.SpaceUpdatedEventData space_updated_event_data = 15;</code>
   *
   * @return The spaceUpdatedEventData.
   */
  com.google.chat.v1.SpaceUpdatedEventData getSpaceUpdatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for a space update.
   *
   * Event type: `google.workspace.chat.space.v1.updated`
   * </pre>
   *
   * <code>.google.chat.v1.SpaceUpdatedEventData space_updated_event_data = 15;</code>
   */
  com.google.chat.v1.SpaceUpdatedEventDataOrBuilder getSpaceUpdatedEventDataOrBuilder();

  /**
   *
   *
   * <pre>
   * Event payload for multiple updates to a space.
   *
   * Event type: `google.workspace.chat.space.v1.batchUpdated`
   * </pre>
   *
   * <code>.google.chat.v1.SpaceBatchUpdatedEventData space_batch_updated_event_data = 29;</code>
   *
   * @return Whether the spaceBatchUpdatedEventData field is set.
   */
  boolean hasSpaceBatchUpdatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for multiple updates to a space.
   *
   * Event type: `google.workspace.chat.space.v1.batchUpdated`
   * </pre>
   *
   * <code>.google.chat.v1.SpaceBatchUpdatedEventData space_batch_updated_event_data = 29;</code>
   *
   * @return The spaceBatchUpdatedEventData.
   */
  com.google.chat.v1.SpaceBatchUpdatedEventData getSpaceBatchUpdatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for multiple updates to a space.
   *
   * Event type: `google.workspace.chat.space.v1.batchUpdated`
   * </pre>
   *
   * <code>.google.chat.v1.SpaceBatchUpdatedEventData space_batch_updated_event_data = 29;</code>
   */
  com.google.chat.v1.SpaceBatchUpdatedEventDataOrBuilder getSpaceBatchUpdatedEventDataOrBuilder();

  /**
   *
   *
   * <pre>
   * Event payload for a new membership.
   *
   * Event type: `google.workspace.chat.membership.v1.created`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipCreatedEventData membership_created_event_data = 17;</code>
   *
   * @return Whether the membershipCreatedEventData field is set.
   */
  boolean hasMembershipCreatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for a new membership.
   *
   * Event type: `google.workspace.chat.membership.v1.created`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipCreatedEventData membership_created_event_data = 17;</code>
   *
   * @return The membershipCreatedEventData.
   */
  com.google.chat.v1.MembershipCreatedEventData getMembershipCreatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for a new membership.
   *
   * Event type: `google.workspace.chat.membership.v1.created`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipCreatedEventData membership_created_event_data = 17;</code>
   */
  com.google.chat.v1.MembershipCreatedEventDataOrBuilder getMembershipCreatedEventDataOrBuilder();

  /**
   *
   *
   * <pre>
   * Event payload for an updated membership.
   *
   * Event type: `google.workspace.chat.membership.v1.updated`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipUpdatedEventData membership_updated_event_data = 18;</code>
   *
   * @return Whether the membershipUpdatedEventData field is set.
   */
  boolean hasMembershipUpdatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for an updated membership.
   *
   * Event type: `google.workspace.chat.membership.v1.updated`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipUpdatedEventData membership_updated_event_data = 18;</code>
   *
   * @return The membershipUpdatedEventData.
   */
  com.google.chat.v1.MembershipUpdatedEventData getMembershipUpdatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for an updated membership.
   *
   * Event type: `google.workspace.chat.membership.v1.updated`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipUpdatedEventData membership_updated_event_data = 18;</code>
   */
  com.google.chat.v1.MembershipUpdatedEventDataOrBuilder getMembershipUpdatedEventDataOrBuilder();

  /**
   *
   *
   * <pre>
   * Event payload for a deleted membership.
   *
   * Event type: `google.workspace.chat.membership.v1.deleted`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipDeletedEventData membership_deleted_event_data = 219;</code>
   *
   * @return Whether the membershipDeletedEventData field is set.
   */
  boolean hasMembershipDeletedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for a deleted membership.
   *
   * Event type: `google.workspace.chat.membership.v1.deleted`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipDeletedEventData membership_deleted_event_data = 219;</code>
   *
   * @return The membershipDeletedEventData.
   */
  com.google.chat.v1.MembershipDeletedEventData getMembershipDeletedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for a deleted membership.
   *
   * Event type: `google.workspace.chat.membership.v1.deleted`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipDeletedEventData membership_deleted_event_data = 219;</code>
   */
  com.google.chat.v1.MembershipDeletedEventDataOrBuilder getMembershipDeletedEventDataOrBuilder();

  /**
   *
   *
   * <pre>
   * Event payload for multiple new memberships.
   *
   * Event type: `google.workspace.chat.membership.v1.batchCreated`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipBatchCreatedEventData membership_batch_created_event_data = 31;
   * </code>
   *
   * @return Whether the membershipBatchCreatedEventData field is set.
   */
  boolean hasMembershipBatchCreatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for multiple new memberships.
   *
   * Event type: `google.workspace.chat.membership.v1.batchCreated`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipBatchCreatedEventData membership_batch_created_event_data = 31;
   * </code>
   *
   * @return The membershipBatchCreatedEventData.
   */
  com.google.chat.v1.MembershipBatchCreatedEventData getMembershipBatchCreatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for multiple new memberships.
   *
   * Event type: `google.workspace.chat.membership.v1.batchCreated`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipBatchCreatedEventData membership_batch_created_event_data = 31;
   * </code>
   */
  com.google.chat.v1.MembershipBatchCreatedEventDataOrBuilder
      getMembershipBatchCreatedEventDataOrBuilder();

  /**
   *
   *
   * <pre>
   * Event payload for multiple updated memberships.
   *
   * Event type: `google.workspace.chat.membership.v1.batchUpdated`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipBatchUpdatedEventData membership_batch_updated_event_data = 32;
   * </code>
   *
   * @return Whether the membershipBatchUpdatedEventData field is set.
   */
  boolean hasMembershipBatchUpdatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for multiple updated memberships.
   *
   * Event type: `google.workspace.chat.membership.v1.batchUpdated`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipBatchUpdatedEventData membership_batch_updated_event_data = 32;
   * </code>
   *
   * @return The membershipBatchUpdatedEventData.
   */
  com.google.chat.v1.MembershipBatchUpdatedEventData getMembershipBatchUpdatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for multiple updated memberships.
   *
   * Event type: `google.workspace.chat.membership.v1.batchUpdated`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipBatchUpdatedEventData membership_batch_updated_event_data = 32;
   * </code>
   */
  com.google.chat.v1.MembershipBatchUpdatedEventDataOrBuilder
      getMembershipBatchUpdatedEventDataOrBuilder();

  /**
   *
   *
   * <pre>
   * Event payload for multiple deleted memberships.
   *
   * Event type: `google.workspace.chat.membership.v1.batchDeleted`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipBatchDeletedEventData membership_batch_deleted_event_data = 33;
   * </code>
   *
   * @return Whether the membershipBatchDeletedEventData field is set.
   */
  boolean hasMembershipBatchDeletedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for multiple deleted memberships.
   *
   * Event type: `google.workspace.chat.membership.v1.batchDeleted`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipBatchDeletedEventData membership_batch_deleted_event_data = 33;
   * </code>
   *
   * @return The membershipBatchDeletedEventData.
   */
  com.google.chat.v1.MembershipBatchDeletedEventData getMembershipBatchDeletedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for multiple deleted memberships.
   *
   * Event type: `google.workspace.chat.membership.v1.batchDeleted`
   * </pre>
   *
   * <code>.google.chat.v1.MembershipBatchDeletedEventData membership_batch_deleted_event_data = 33;
   * </code>
   */
  com.google.chat.v1.MembershipBatchDeletedEventDataOrBuilder
      getMembershipBatchDeletedEventDataOrBuilder();

  /**
   *
   *
   * <pre>
   * Event payload for a new reaction.
   *
   * Event type: `google.workspace.chat.reaction.v1.created`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionCreatedEventData reaction_created_event_data = 21;</code>
   *
   * @return Whether the reactionCreatedEventData field is set.
   */
  boolean hasReactionCreatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for a new reaction.
   *
   * Event type: `google.workspace.chat.reaction.v1.created`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionCreatedEventData reaction_created_event_data = 21;</code>
   *
   * @return The reactionCreatedEventData.
   */
  com.google.chat.v1.ReactionCreatedEventData getReactionCreatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for a new reaction.
   *
   * Event type: `google.workspace.chat.reaction.v1.created`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionCreatedEventData reaction_created_event_data = 21;</code>
   */
  com.google.chat.v1.ReactionCreatedEventDataOrBuilder getReactionCreatedEventDataOrBuilder();

  /**
   *
   *
   * <pre>
   * Event payload for a deleted reaction.
   *
   * Event type: `google.workspace.chat.reaction.v1.deleted`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionDeletedEventData reaction_deleted_event_data = 22;</code>
   *
   * @return Whether the reactionDeletedEventData field is set.
   */
  boolean hasReactionDeletedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for a deleted reaction.
   *
   * Event type: `google.workspace.chat.reaction.v1.deleted`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionDeletedEventData reaction_deleted_event_data = 22;</code>
   *
   * @return The reactionDeletedEventData.
   */
  com.google.chat.v1.ReactionDeletedEventData getReactionDeletedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for a deleted reaction.
   *
   * Event type: `google.workspace.chat.reaction.v1.deleted`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionDeletedEventData reaction_deleted_event_data = 22;</code>
   */
  com.google.chat.v1.ReactionDeletedEventDataOrBuilder getReactionDeletedEventDataOrBuilder();

  /**
   *
   *
   * <pre>
   * Event payload for multiple new reactions.
   *
   * Event type: `google.workspace.chat.reaction.v1.batchCreated`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionBatchCreatedEventData reaction_batch_created_event_data = 34;
   * </code>
   *
   * @return Whether the reactionBatchCreatedEventData field is set.
   */
  boolean hasReactionBatchCreatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for multiple new reactions.
   *
   * Event type: `google.workspace.chat.reaction.v1.batchCreated`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionBatchCreatedEventData reaction_batch_created_event_data = 34;
   * </code>
   *
   * @return The reactionBatchCreatedEventData.
   */
  com.google.chat.v1.ReactionBatchCreatedEventData getReactionBatchCreatedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for multiple new reactions.
   *
   * Event type: `google.workspace.chat.reaction.v1.batchCreated`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionBatchCreatedEventData reaction_batch_created_event_data = 34;
   * </code>
   */
  com.google.chat.v1.ReactionBatchCreatedEventDataOrBuilder
      getReactionBatchCreatedEventDataOrBuilder();

  /**
   *
   *
   * <pre>
   * Event payload for multiple deleted reactions.
   *
   * Event type: `google.workspace.chat.reaction.v1.batchDeleted`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionBatchDeletedEventData reaction_batch_deleted_event_data = 35;
   * </code>
   *
   * @return Whether the reactionBatchDeletedEventData field is set.
   */
  boolean hasReactionBatchDeletedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for multiple deleted reactions.
   *
   * Event type: `google.workspace.chat.reaction.v1.batchDeleted`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionBatchDeletedEventData reaction_batch_deleted_event_data = 35;
   * </code>
   *
   * @return The reactionBatchDeletedEventData.
   */
  com.google.chat.v1.ReactionBatchDeletedEventData getReactionBatchDeletedEventData();

  /**
   *
   *
   * <pre>
   * Event payload for multiple deleted reactions.
   *
   * Event type: `google.workspace.chat.reaction.v1.batchDeleted`
   * </pre>
   *
   * <code>.google.chat.v1.ReactionBatchDeletedEventData reaction_batch_deleted_event_data = 35;
   * </code>
   */
  com.google.chat.v1.ReactionBatchDeletedEventDataOrBuilder
      getReactionBatchDeletedEventDataOrBuilder();

  com.google.chat.v1.SpaceEvent.PayloadCase getPayloadCase();
}
