/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/space_notification_setting.proto

// Protobuf Java Version: 3.25.5
package com.google.chat.v1;

/**
 *
 *
 * <pre>
 * The notification setting of a user in a space.
 * </pre>
 *
 * Protobuf type {@code google.chat.v1.SpaceNotificationSetting}
 */
public final class SpaceNotificationSetting extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.SpaceNotificationSetting)
    SpaceNotificationSettingOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SpaceNotificationSetting.newBuilder() to construct.
  private SpaceNotificationSetting(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SpaceNotificationSetting() {
    name_ = "";
    notificationSetting_ = 0;
    muteSetting_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SpaceNotificationSetting();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.SpaceNotificationSettingProto
        .internal_static_google_chat_v1_SpaceNotificationSetting_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.SpaceNotificationSettingProto
        .internal_static_google_chat_v1_SpaceNotificationSetting_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.SpaceNotificationSetting.class,
            com.google.chat.v1.SpaceNotificationSetting.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The notification setting types. Other types might be supported in the
   * future.
   * </pre>
   *
   * Protobuf enum {@code google.chat.v1.SpaceNotificationSetting.NotificationSetting}
   */
  public enum NotificationSetting implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Reserved.
     * </pre>
     *
     * <code>NOTIFICATION_SETTING_UNSPECIFIED = 0;</code>
     */
    NOTIFICATION_SETTING_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Notifications are triggered by &#64;mentions, followed threads, first
     * message of new threads. All new threads are automatically followed,
     * unless manually unfollowed by the user.
     * </pre>
     *
     * <code>ALL = 1;</code>
     */
    ALL(1),
    /**
     *
     *
     * <pre>
     * The notification is triggered by &#64;mentions, followed threads, first
     * message of new threads. Not available for 1:1 direct messages.
     * </pre>
     *
     * <code>MAIN_CONVERSATIONS = 2;</code>
     */
    MAIN_CONVERSATIONS(2),
    /**
     *
     *
     * <pre>
     * The notification is triggered by &#64;mentions, followed threads. Not
     * available for 1:1 direct messages.
     * </pre>
     *
     * <code>FOR_YOU = 3;</code>
     */
    FOR_YOU(3),
    /**
     *
     *
     * <pre>
     * Notification is off.
     * </pre>
     *
     * <code>OFF = 4;</code>
     */
    OFF(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Reserved.
     * </pre>
     *
     * <code>NOTIFICATION_SETTING_UNSPECIFIED = 0;</code>
     */
    public static final int NOTIFICATION_SETTING_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Notifications are triggered by &#64;mentions, followed threads, first
     * message of new threads. All new threads are automatically followed,
     * unless manually unfollowed by the user.
     * </pre>
     *
     * <code>ALL = 1;</code>
     */
    public static final int ALL_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The notification is triggered by &#64;mentions, followed threads, first
     * message of new threads. Not available for 1:1 direct messages.
     * </pre>
     *
     * <code>MAIN_CONVERSATIONS = 2;</code>
     */
    public static final int MAIN_CONVERSATIONS_VALUE = 2;

    /**
     *
     *
     * <pre>
     * The notification is triggered by &#64;mentions, followed threads. Not
     * available for 1:1 direct messages.
     * </pre>
     *
     * <code>FOR_YOU = 3;</code>
     */
    public static final int FOR_YOU_VALUE = 3;

    /**
     *
     *
     * <pre>
     * Notification is off.
     * </pre>
     *
     * <code>OFF = 4;</code>
     */
    public static final int OFF_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NotificationSetting valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static NotificationSetting forNumber(int value) {
      switch (value) {
        case 0:
          return NOTIFICATION_SETTING_UNSPECIFIED;
        case 1:
          return ALL;
        case 2:
          return MAIN_CONVERSATIONS;
        case 3:
          return FOR_YOU;
        case 4:
          return OFF;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<NotificationSetting>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<NotificationSetting>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<NotificationSetting>() {
              public NotificationSetting findValueByNumber(int number) {
                return NotificationSetting.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.chat.v1.SpaceNotificationSetting.getDescriptor().getEnumTypes().get(0);
    }

    private static final NotificationSetting[] VALUES = values();

    public static NotificationSetting valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private NotificationSetting(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.chat.v1.SpaceNotificationSetting.NotificationSetting)
  }

  /**
   *
   *
   * <pre>
   * The space notification mute setting types.
   * </pre>
   *
   * Protobuf enum {@code google.chat.v1.SpaceNotificationSetting.MuteSetting}
   */
  public enum MuteSetting implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Reserved.
     * </pre>
     *
     * <code>MUTE_SETTING_UNSPECIFIED = 0;</code>
     */
    MUTE_SETTING_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The user will receive notifications for the space based on the
     * notification setting.
     * </pre>
     *
     * <code>UNMUTED = 1;</code>
     */
    UNMUTED(1),
    /**
     *
     *
     * <pre>
     * The user will not receive any notifications for the space, regardless of
     * the notification setting.
     * </pre>
     *
     * <code>MUTED = 2;</code>
     */
    MUTED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Reserved.
     * </pre>
     *
     * <code>MUTE_SETTING_UNSPECIFIED = 0;</code>
     */
    public static final int MUTE_SETTING_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The user will receive notifications for the space based on the
     * notification setting.
     * </pre>
     *
     * <code>UNMUTED = 1;</code>
     */
    public static final int UNMUTED_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The user will not receive any notifications for the space, regardless of
     * the notification setting.
     * </pre>
     *
     * <code>MUTED = 2;</code>
     */
    public static final int MUTED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MuteSetting valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MuteSetting forNumber(int value) {
      switch (value) {
        case 0:
          return MUTE_SETTING_UNSPECIFIED;
        case 1:
          return UNMUTED;
        case 2:
          return MUTED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MuteSetting> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MuteSetting> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<MuteSetting>() {
          public MuteSetting findValueByNumber(int number) {
            return MuteSetting.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.chat.v1.SpaceNotificationSetting.getDescriptor().getEnumTypes().get(1);
    }

    private static final MuteSetting[] VALUES = values();

    public static MuteSetting valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MuteSetting(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.chat.v1.SpaceNotificationSetting.MuteSetting)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Identifier. The resource name of the space notification setting.
   * Format: `users/{user}/spaces/{space}/spaceNotificationSetting`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Identifier. The resource name of the space notification setting.
   * Format: `users/{user}/spaces/{space}/spaceNotificationSetting`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NOTIFICATION_SETTING_FIELD_NUMBER = 2;
  private int notificationSetting_ = 0;

  /**
   *
   *
   * <pre>
   * The notification setting.
   * </pre>
   *
   * <code>
   * optional .google.chat.v1.SpaceNotificationSetting.NotificationSetting notification_setting = 2;
   * </code>
   *
   * @return Whether the notificationSetting field is set.
   */
  @java.lang.Override
  public boolean hasNotificationSetting() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The notification setting.
   * </pre>
   *
   * <code>
   * optional .google.chat.v1.SpaceNotificationSetting.NotificationSetting notification_setting = 2;
   * </code>
   *
   * @return The enum numeric value on the wire for notificationSetting.
   */
  @java.lang.Override
  public int getNotificationSettingValue() {
    return notificationSetting_;
  }

  /**
   *
   *
   * <pre>
   * The notification setting.
   * </pre>
   *
   * <code>
   * optional .google.chat.v1.SpaceNotificationSetting.NotificationSetting notification_setting = 2;
   * </code>
   *
   * @return The notificationSetting.
   */
  @java.lang.Override
  public com.google.chat.v1.SpaceNotificationSetting.NotificationSetting getNotificationSetting() {
    com.google.chat.v1.SpaceNotificationSetting.NotificationSetting result =
        com.google.chat.v1.SpaceNotificationSetting.NotificationSetting.forNumber(
            notificationSetting_);
    return result == null
        ? com.google.chat.v1.SpaceNotificationSetting.NotificationSetting.UNRECOGNIZED
        : result;
  }

  public static final int MUTE_SETTING_FIELD_NUMBER = 3;
  private int muteSetting_ = 0;

  /**
   *
   *
   * <pre>
   * The space notification mute setting.
   * </pre>
   *
   * <code>optional .google.chat.v1.SpaceNotificationSetting.MuteSetting mute_setting = 3;</code>
   *
   * @return Whether the muteSetting field is set.
   */
  @java.lang.Override
  public boolean hasMuteSetting() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The space notification mute setting.
   * </pre>
   *
   * <code>optional .google.chat.v1.SpaceNotificationSetting.MuteSetting mute_setting = 3;</code>
   *
   * @return The enum numeric value on the wire for muteSetting.
   */
  @java.lang.Override
  public int getMuteSettingValue() {
    return muteSetting_;
  }

  /**
   *
   *
   * <pre>
   * The space notification mute setting.
   * </pre>
   *
   * <code>optional .google.chat.v1.SpaceNotificationSetting.MuteSetting mute_setting = 3;</code>
   *
   * @return The muteSetting.
   */
  @java.lang.Override
  public com.google.chat.v1.SpaceNotificationSetting.MuteSetting getMuteSetting() {
    com.google.chat.v1.SpaceNotificationSetting.MuteSetting result =
        com.google.chat.v1.SpaceNotificationSetting.MuteSetting.forNumber(muteSetting_);
    return result == null
        ? com.google.chat.v1.SpaceNotificationSetting.MuteSetting.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeEnum(2, notificationSetting_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeEnum(3, muteSetting_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, notificationSetting_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, muteSetting_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.SpaceNotificationSetting)) {
      return super.equals(obj);
    }
    com.google.chat.v1.SpaceNotificationSetting other =
        (com.google.chat.v1.SpaceNotificationSetting) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasNotificationSetting() != other.hasNotificationSetting()) return false;
    if (hasNotificationSetting()) {
      if (notificationSetting_ != other.notificationSetting_) return false;
    }
    if (hasMuteSetting() != other.hasMuteSetting()) return false;
    if (hasMuteSetting()) {
      if (muteSetting_ != other.muteSetting_) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasNotificationSetting()) {
      hash = (37 * hash) + NOTIFICATION_SETTING_FIELD_NUMBER;
      hash = (53 * hash) + notificationSetting_;
    }
    if (hasMuteSetting()) {
      hash = (37 * hash) + MUTE_SETTING_FIELD_NUMBER;
      hash = (53 * hash) + muteSetting_;
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.SpaceNotificationSetting parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.SpaceNotificationSetting parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.SpaceNotificationSetting parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.SpaceNotificationSetting parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.SpaceNotificationSetting parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.SpaceNotificationSetting parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.SpaceNotificationSetting parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.SpaceNotificationSetting parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.SpaceNotificationSetting parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.SpaceNotificationSetting parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.SpaceNotificationSetting parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.SpaceNotificationSetting parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.SpaceNotificationSetting prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The notification setting of a user in a space.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.SpaceNotificationSetting}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.SpaceNotificationSetting)
      com.google.chat.v1.SpaceNotificationSettingOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.SpaceNotificationSettingProto
          .internal_static_google_chat_v1_SpaceNotificationSetting_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.SpaceNotificationSettingProto
          .internal_static_google_chat_v1_SpaceNotificationSetting_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.SpaceNotificationSetting.class,
              com.google.chat.v1.SpaceNotificationSetting.Builder.class);
    }

    // Construct using com.google.chat.v1.SpaceNotificationSetting.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      notificationSetting_ = 0;
      muteSetting_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.SpaceNotificationSettingProto
          .internal_static_google_chat_v1_SpaceNotificationSetting_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.SpaceNotificationSetting getDefaultInstanceForType() {
      return com.google.chat.v1.SpaceNotificationSetting.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.SpaceNotificationSetting build() {
      com.google.chat.v1.SpaceNotificationSetting result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.SpaceNotificationSetting buildPartial() {
      com.google.chat.v1.SpaceNotificationSetting result =
          new com.google.chat.v1.SpaceNotificationSetting(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.chat.v1.SpaceNotificationSetting result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.notificationSetting_ = notificationSetting_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.muteSetting_ = muteSetting_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.SpaceNotificationSetting) {
        return mergeFrom((com.google.chat.v1.SpaceNotificationSetting) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.SpaceNotificationSetting other) {
      if (other == com.google.chat.v1.SpaceNotificationSetting.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasNotificationSetting()) {
        setNotificationSetting(other.getNotificationSetting());
      }
      if (other.hasMuteSetting()) {
        setMuteSetting(other.getMuteSetting());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                notificationSetting_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                muteSetting_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the space notification setting.
     * Format: `users/{user}/spaces/{space}/spaceNotificationSetting`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the space notification setting.
     * Format: `users/{user}/spaces/{space}/spaceNotificationSetting`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the space notification setting.
     * Format: `users/{user}/spaces/{space}/spaceNotificationSetting`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the space notification setting.
     * Format: `users/{user}/spaces/{space}/spaceNotificationSetting`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the space notification setting.
     * Format: `users/{user}/spaces/{space}/spaceNotificationSetting`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int notificationSetting_ = 0;

    /**
     *
     *
     * <pre>
     * The notification setting.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.SpaceNotificationSetting.NotificationSetting notification_setting = 2;
     * </code>
     *
     * @return Whether the notificationSetting field is set.
     */
    @java.lang.Override
    public boolean hasNotificationSetting() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The notification setting.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.SpaceNotificationSetting.NotificationSetting notification_setting = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for notificationSetting.
     */
    @java.lang.Override
    public int getNotificationSettingValue() {
      return notificationSetting_;
    }

    /**
     *
     *
     * <pre>
     * The notification setting.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.SpaceNotificationSetting.NotificationSetting notification_setting = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for notificationSetting to set.
     * @return This builder for chaining.
     */
    public Builder setNotificationSettingValue(int value) {
      notificationSetting_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The notification setting.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.SpaceNotificationSetting.NotificationSetting notification_setting = 2;
     * </code>
     *
     * @return The notificationSetting.
     */
    @java.lang.Override
    public com.google.chat.v1.SpaceNotificationSetting.NotificationSetting
        getNotificationSetting() {
      com.google.chat.v1.SpaceNotificationSetting.NotificationSetting result =
          com.google.chat.v1.SpaceNotificationSetting.NotificationSetting.forNumber(
              notificationSetting_);
      return result == null
          ? com.google.chat.v1.SpaceNotificationSetting.NotificationSetting.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * The notification setting.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.SpaceNotificationSetting.NotificationSetting notification_setting = 2;
     * </code>
     *
     * @param value The notificationSetting to set.
     * @return This builder for chaining.
     */
    public Builder setNotificationSetting(
        com.google.chat.v1.SpaceNotificationSetting.NotificationSetting value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      notificationSetting_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The notification setting.
     * </pre>
     *
     * <code>
     * optional .google.chat.v1.SpaceNotificationSetting.NotificationSetting notification_setting = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNotificationSetting() {
      bitField0_ = (bitField0_ & ~0x00000002);
      notificationSetting_ = 0;
      onChanged();
      return this;
    }

    private int muteSetting_ = 0;

    /**
     *
     *
     * <pre>
     * The space notification mute setting.
     * </pre>
     *
     * <code>optional .google.chat.v1.SpaceNotificationSetting.MuteSetting mute_setting = 3;</code>
     *
     * @return Whether the muteSetting field is set.
     */
    @java.lang.Override
    public boolean hasMuteSetting() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * The space notification mute setting.
     * </pre>
     *
     * <code>optional .google.chat.v1.SpaceNotificationSetting.MuteSetting mute_setting = 3;</code>
     *
     * @return The enum numeric value on the wire for muteSetting.
     */
    @java.lang.Override
    public int getMuteSettingValue() {
      return muteSetting_;
    }

    /**
     *
     *
     * <pre>
     * The space notification mute setting.
     * </pre>
     *
     * <code>optional .google.chat.v1.SpaceNotificationSetting.MuteSetting mute_setting = 3;</code>
     *
     * @param value The enum numeric value on the wire for muteSetting to set.
     * @return This builder for chaining.
     */
    public Builder setMuteSettingValue(int value) {
      muteSetting_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The space notification mute setting.
     * </pre>
     *
     * <code>optional .google.chat.v1.SpaceNotificationSetting.MuteSetting mute_setting = 3;</code>
     *
     * @return The muteSetting.
     */
    @java.lang.Override
    public com.google.chat.v1.SpaceNotificationSetting.MuteSetting getMuteSetting() {
      com.google.chat.v1.SpaceNotificationSetting.MuteSetting result =
          com.google.chat.v1.SpaceNotificationSetting.MuteSetting.forNumber(muteSetting_);
      return result == null
          ? com.google.chat.v1.SpaceNotificationSetting.MuteSetting.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * The space notification mute setting.
     * </pre>
     *
     * <code>optional .google.chat.v1.SpaceNotificationSetting.MuteSetting mute_setting = 3;</code>
     *
     * @param value The muteSetting to set.
     * @return This builder for chaining.
     */
    public Builder setMuteSetting(com.google.chat.v1.SpaceNotificationSetting.MuteSetting value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      muteSetting_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The space notification mute setting.
     * </pre>
     *
     * <code>optional .google.chat.v1.SpaceNotificationSetting.MuteSetting mute_setting = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMuteSetting() {
      bitField0_ = (bitField0_ & ~0x00000004);
      muteSetting_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.SpaceNotificationSetting)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.SpaceNotificationSetting)
  private static final com.google.chat.v1.SpaceNotificationSetting DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.SpaceNotificationSetting();
  }

  public static com.google.chat.v1.SpaceNotificationSetting getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SpaceNotificationSetting> PARSER =
      new com.google.protobuf.AbstractParser<SpaceNotificationSetting>() {
        @java.lang.Override
        public SpaceNotificationSetting parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SpaceNotificationSetting> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SpaceNotificationSetting> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.SpaceNotificationSetting getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
