/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/space.proto

// Protobuf Java Version: 3.25.5
package com.google.chat.v1;

public interface SpaceOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.chat.v1.Space)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Identifier. Resource name of the space.
   *
   * Format: `spaces/{space}`
   *
   * Where `{space}` represents the system-assigned ID for the space. You can
   * obtain the space ID by calling the
   * [`spaces.list()`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/list)
   * method or from the space URL. For example, if the space URL
   * is `https://mail.google.com/mail/u/0/#chat/space/AAAAAAAAA`, the space ID
   * is `AAAAAAAAA`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Identifier. Resource name of the space.
   *
   * Format: `spaces/{space}`
   *
   * Where `{space}` represents the system-assigned ID for the space. You can
   * obtain the space ID by calling the
   * [`spaces.list()`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/list)
   * method or from the space URL. For example, if the space URL
   * is `https://mail.google.com/mail/u/0/#chat/space/AAAAAAAAA`, the space ID
   * is `AAAAAAAAA`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. Deprecated: Use `space_type` instead.
   * The type of a space.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.chat.v1.Space.type is deprecated. See google/chat/v1/space.proto;l=256
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Deprecated
  int getTypeValue();

  /**
   *
   *
   * <pre>
   * Output only. Deprecated: Use `space_type` instead.
   * The type of a space.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.chat.v1.Space.type is deprecated. See google/chat/v1/space.proto;l=256
   * @return The type.
   */
  @java.lang.Deprecated
  com.google.chat.v1.Space.Type getType();

  /**
   *
   *
   * <pre>
   * Optional. The type of space. Required when creating a space or updating the
   * space type of a space. Output only for other usage.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.SpaceType space_type = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for spaceType.
   */
  int getSpaceTypeValue();

  /**
   *
   *
   * <pre>
   * Optional. The type of space. Required when creating a space or updating the
   * space type of a space. Output only for other usage.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.SpaceType space_type = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The spaceType.
   */
  com.google.chat.v1.Space.SpaceType getSpaceType();

  /**
   *
   *
   * <pre>
   * Optional. Whether the space is a DM between a Chat app and a single
   * human.
   * </pre>
   *
   * <code>bool single_user_bot_dm = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The singleUserBotDm.
   */
  boolean getSingleUserBotDm();

  /**
   *
   *
   * <pre>
   * Output only. Deprecated: Use `spaceThreadingState` instead.
   * Whether messages are threaded in this space.
   * </pre>
   *
   * <code>bool threaded = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @deprecated google.chat.v1.Space.threaded is deprecated. See google/chat/v1/space.proto;l=268
   * @return The threaded.
   */
  @java.lang.Deprecated
  boolean getThreaded();

  /**
   *
   *
   * <pre>
   * Optional. The space's display name. Required when [creating a
   * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create)
   * with a `spaceType` of `SPACE`. If you receive the error message
   * `ALREADY_EXISTS` when creating a space or updating the `displayName`, try a
   * different `displayName`. An existing space within the Google Workspace
   * organization might already use this display name.
   *
   * For direct messages, this field might be empty.
   *
   * Supports up to 128 characters.
   * </pre>
   *
   * <code>string display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The displayName.
   */
  java.lang.String getDisplayName();

  /**
   *
   *
   * <pre>
   * Optional. The space's display name. Required when [creating a
   * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create)
   * with a `spaceType` of `SPACE`. If you receive the error message
   * `ALREADY_EXISTS` when creating a space or updating the `displayName`, try a
   * different `displayName`. An existing space within the Google Workspace
   * organization might already use this display name.
   *
   * For direct messages, this field might be empty.
   *
   * Supports up to 128 characters.
   * </pre>
   *
   * <code>string display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for displayName.
   */
  com.google.protobuf.ByteString getDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * Optional. Immutable. Whether this space permits any Google Chat user as a
   * member. Input when creating a space in a Google Workspace organization.
   * Omit this field when creating spaces in the following conditions:
   *
   *   * The authenticated user uses a consumer account (unmanaged user
   *     account). By default, a space created by a consumer account permits any
   *     Google Chat user.
   *
   * For existing spaces, this field is output only.
   * </pre>
   *
   * <code>
   * bool external_user_allowed = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The externalUserAllowed.
   */
  boolean getExternalUserAllowed();

  /**
   *
   *
   * <pre>
   * Output only. The threading state in the Chat space.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for spaceThreadingState.
   */
  int getSpaceThreadingStateValue();

  /**
   *
   *
   * <pre>
   * Output only. The threading state in the Chat space.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The spaceThreadingState.
   */
  com.google.chat.v1.Space.SpaceThreadingState getSpaceThreadingState();

  /**
   *
   *
   * <pre>
   * Optional. Details about the space including description and rules.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.SpaceDetails space_details = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the spaceDetails field is set.
   */
  boolean hasSpaceDetails();

  /**
   *
   *
   * <pre>
   * Optional. Details about the space including description and rules.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.SpaceDetails space_details = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The spaceDetails.
   */
  com.google.chat.v1.Space.SpaceDetails getSpaceDetails();

  /**
   *
   *
   * <pre>
   * Optional. Details about the space including description and rules.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.SpaceDetails space_details = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.chat.v1.Space.SpaceDetailsOrBuilder getSpaceDetailsOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The message history state for messages and threads in this space.
   * </pre>
   *
   * <code>
   * .google.chat.v1.HistoryState space_history_state = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for spaceHistoryState.
   */
  int getSpaceHistoryStateValue();

  /**
   *
   *
   * <pre>
   * Optional. The message history state for messages and threads in this space.
   * </pre>
   *
   * <code>
   * .google.chat.v1.HistoryState space_history_state = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The spaceHistoryState.
   */
  com.google.chat.v1.HistoryState getSpaceHistoryState();

  /**
   *
   *
   * <pre>
   * Optional. Whether this space is created in `Import Mode` as part of a data
   * migration into Google Workspace. While spaces are being imported, they
   * aren't visible to users until the import is complete.
   *
   * Creating a space in `Import Mode`requires [user
   * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
   * </pre>
   *
   * <code>bool import_mode = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The importMode.
   */
  boolean getImportMode();

  /**
   *
   *
   * <pre>
   * Optional. Immutable. For spaces created in Chat, the time the space was
   * created. This field is output only, except when used in import mode spaces.
   *
   * For import mode spaces, set this field to the historical timestamp at which
   * the space was created in the source in order to preserve the original
   * creation time.
   *
   * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();

  /**
   *
   *
   * <pre>
   * Optional. Immutable. For spaces created in Chat, the time the space was
   * created. This field is output only, except when used in import mode spaces.
   *
   * For import mode spaces, set this field to the historical timestamp at which
   * the space was created in the source in order to preserve the original
   * creation time.
   *
   * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();

  /**
   *
   *
   * <pre>
   * Optional. Immutable. For spaces created in Chat, the time the space was
   * created. This field is output only, except when used in import mode spaces.
   *
   * For import mode spaces, set this field to the historical timestamp at which
   * the space was created in the source in order to preserve the original
   * creation time.
   *
   * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp of the last message in the space.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_active_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastActiveTime field is set.
   */
  boolean hasLastActiveTime();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp of the last message in the space.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_active_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastActiveTime.
   */
  com.google.protobuf.Timestamp getLastActiveTime();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp of the last message in the space.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_active_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getLastActiveTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. For direct message (DM) spaces with a Chat app, whether the
   * space was created by a Google Workspace administrator. Administrators can
   * install and set up a direct message with a Chat app on behalf of users in
   * their organization.
   *
   * To support admin install, your Chat app must feature direct messaging.
   * </pre>
   *
   * <code>bool admin_installed = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The adminInstalled.
   */
  boolean getAdminInstalled();

  /**
   *
   *
   * <pre>
   * Output only. The count of joined memberships grouped by member type.
   * Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
   * `GROUP_CHAT`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.MembershipCount membership_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the membershipCount field is set.
   */
  boolean hasMembershipCount();

  /**
   *
   *
   * <pre>
   * Output only. The count of joined memberships grouped by member type.
   * Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
   * `GROUP_CHAT`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.MembershipCount membership_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The membershipCount.
   */
  com.google.chat.v1.Space.MembershipCount getMembershipCount();

  /**
   *
   *
   * <pre>
   * Output only. The count of joined memberships grouped by member type.
   * Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
   * `GROUP_CHAT`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.MembershipCount membership_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.chat.v1.Space.MembershipCountOrBuilder getMembershipCountOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Specifies the [access
   * setting](https://support.google.com/chat/answer/11971020) of the space.
   * Only populated when the `space_type` is `SPACE`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the accessSettings field is set.
   */
  boolean hasAccessSettings();

  /**
   *
   *
   * <pre>
   * Optional. Specifies the [access
   * setting](https://support.google.com/chat/answer/11971020) of the space.
   * Only populated when the `space_type` is `SPACE`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The accessSettings.
   */
  com.google.chat.v1.Space.AccessSettings getAccessSettings();

  /**
   *
   *
   * <pre>
   * Optional. Specifies the [access
   * setting](https://support.google.com/chat/answer/11971020) of the space.
   * Only populated when the `space_type` is `SPACE`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.chat.v1.Space.AccessSettingsOrBuilder getAccessSettingsOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The URI for a user to access the space.
   * </pre>
   *
   * <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The spaceUri.
   */
  java.lang.String getSpaceUri();

  /**
   *
   *
   * <pre>
   * Output only. The URI for a user to access the space.
   * </pre>
   *
   * <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for spaceUri.
   */
  com.google.protobuf.ByteString getSpaceUriBytes();

  /**
   *
   *
   * <pre>
   * Optional. Input only. Predefined space permission settings, input only
   * when creating a space. If the field is not set, a collaboration space is
   * created. After you create the space, settings are populated in the
   * `PermissionSettings` field.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.PredefinedPermissionSettings predefined_permission_settings = 26 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the predefinedPermissionSettings field is set.
   */
  boolean hasPredefinedPermissionSettings();

  /**
   *
   *
   * <pre>
   * Optional. Input only. Predefined space permission settings, input only
   * when creating a space. If the field is not set, a collaboration space is
   * created. After you create the space, settings are populated in the
   * `PermissionSettings` field.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.PredefinedPermissionSettings predefined_permission_settings = 26 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for predefinedPermissionSettings.
   */
  int getPredefinedPermissionSettingsValue();

  /**
   *
   *
   * <pre>
   * Optional. Input only. Predefined space permission settings, input only
   * when creating a space. If the field is not set, a collaboration space is
   * created. After you create the space, settings are populated in the
   * `PermissionSettings` field.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.PredefinedPermissionSettings predefined_permission_settings = 26 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The predefinedPermissionSettings.
   */
  com.google.chat.v1.Space.PredefinedPermissionSettings getPredefinedPermissionSettings();

  /**
   *
   *
   * <pre>
   * Optional. Space permission settings for existing spaces. Input for
   * updating exact space permission settings, where existing permission
   * settings are replaced. Output lists current permission settings.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.PermissionSettings permission_settings = 27 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the permissionSettings field is set.
   */
  boolean hasPermissionSettings();

  /**
   *
   *
   * <pre>
   * Optional. Space permission settings for existing spaces. Input for
   * updating exact space permission settings, where existing permission
   * settings are replaced. Output lists current permission settings.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.PermissionSettings permission_settings = 27 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The permissionSettings.
   */
  com.google.chat.v1.Space.PermissionSettings getPermissionSettings();

  /**
   *
   *
   * <pre>
   * Optional. Space permission settings for existing spaces. Input for
   * updating exact space permission settings, where existing permission
   * settings are replaced. Output lists current permission settings.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Space.PermissionSettings permission_settings = 27 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.chat.v1.Space.PermissionSettingsOrBuilder getPermissionSettingsOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The time when the space will be automatically deleted by the
   * system if it remains in import mode.
   *
   * Each space created in import mode must exit this mode before this expire
   * time using `spaces.completeImport`.
   *
   * This field is only populated for spaces that were created with import mode.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp import_mode_expire_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the importModeExpireTime field is set.
   */
  boolean hasImportModeExpireTime();

  /**
   *
   *
   * <pre>
   * Output only. The time when the space will be automatically deleted by the
   * system if it remains in import mode.
   *
   * Each space created in import mode must exit this mode before this expire
   * time using `spaces.completeImport`.
   *
   * This field is only populated for spaces that were created with import mode.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp import_mode_expire_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The importModeExpireTime.
   */
  com.google.protobuf.Timestamp getImportModeExpireTime();

  /**
   *
   *
   * <pre>
   * Output only. The time when the space will be automatically deleted by the
   * system if it remains in import mode.
   *
   * Each space created in import mode must exit this mode before this expire
   * time using `spaces.completeImport`.
   *
   * This field is only populated for spaces that were created with import mode.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp import_mode_expire_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getImportModeExpireTimeOrBuilder();

  com.google.chat.v1.Space.SpacePermissionSettingsCase getSpacePermissionSettingsCase();
}
