/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/space.proto

// Protobuf Java Version: 3.25.5
package com.google.chat.v1;

public interface UpdateSpaceRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.chat.v1.UpdateSpaceRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. Space with fields to be updated. `Space.name` must be
   * populated in the form of `spaces/{space}`. Only fields
   * specified by `update_mask` are updated.
   * </pre>
   *
   * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the space field is set.
   */
  boolean hasSpace();

  /**
   *
   *
   * <pre>
   * Required. Space with fields to be updated. `Space.name` must be
   * populated in the form of `spaces/{space}`. Only fields
   * specified by `update_mask` are updated.
   * </pre>
   *
   * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The space.
   */
  com.google.chat.v1.Space getSpace();

  /**
   *
   *
   * <pre>
   * Required. Space with fields to be updated. `Space.name` must be
   * populated in the form of `spaces/{space}`. Only fields
   * specified by `update_mask` are updated.
   * </pre>
   *
   * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  com.google.chat.v1.SpaceOrBuilder getSpaceOrBuilder();

  /**
   *
   *
   * <pre>
   * Required. The updated field paths, comma separated if there are
   * multiple.
   *
   * You can update the following fields for a space:
   *
   * `space_details`: Updates the space's description. Supports up to 150
   * characters.
   *
   * `display_name`: Only supports updating the display name for spaces where
   * `spaceType` field is `SPACE`.
   *  If you receive the error message `ALREADY_EXISTS`, try a different
   *  value. An existing space within the
   * Google Workspace organization might already use this display name.
   *
   * `space_type`: Only supports changing a `GROUP_CHAT` space type to
   * `SPACE`. Include `display_name` together
   * with `space_type` in the update mask and ensure that the specified space
   * has a non-empty display name and the `SPACE` space type. Including the
   * `space_type` mask and the `SPACE` type in the specified space when updating
   * the display name is optional if the existing space already has the `SPACE`
   * type. Trying to update the space type in other ways results in an invalid
   * argument error.
   * `space_type` is not supported with `useAdminAccess`.
   *
   * `space_history_state`: Updates [space history
   * settings](https://support.google.com/chat/answer/7664687) by turning
   * history on or off for the space. Only supported if history settings are
   * enabled for the Google Workspace organization. To update the
   * space history state, you must omit all other field masks in your request.
   * `space_history_state` is not supported with `useAdminAccess`.
   *
   * `access_settings.audience`: Updates the [access
   * setting](https://support.google.com/chat/answer/11971020) of who can
   * discover the space, join the space, and preview the messages in named space
   * where `spaceType` field is `SPACE`. If the existing space has a
   * target audience, you can remove the audience and restrict space access by
   * omitting a value for this field mask. To update access settings for a
   * space, the authenticating user must be a space manager and omit all other
   * field masks in your request. You can't update this field if the space is in
   * [import
   * mode](https://developers.google.com/workspace/chat/import-data-overview).
   * To learn more, see [Make a space discoverable to specific
   * users](https://developers.google.com/workspace/chat/space-target-audience).
   * `access_settings.audience` is not supported with `useAdminAccess`.
   *
   * `permission_settings`: Supports changing the
   * [permission settings](https://support.google.com/chat/answer/13340792)
   * of a space.
   * When updating permission settings, you can only specify
   * `permissionSettings` field masks; you cannot update other field masks
   * at the same time. `permissionSettings` is not supported with
   * `useAdminAccess`.
   * The supported field masks include:
   *
   * - `permission_settings.manageMembersAndGroups`
   * - `permission_settings.modifySpaceDetails`
   * - `permission_settings.toggleHistory`
   * - `permission_settings.useAtMentionAll`
   * - `permission_settings.manageApps`
   * - `permission_settings.manageWebhooks`
   * - `permission_settings.replyMessages`
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the updateMask field is set.
   */
  boolean hasUpdateMask();

  /**
   *
   *
   * <pre>
   * Required. The updated field paths, comma separated if there are
   * multiple.
   *
   * You can update the following fields for a space:
   *
   * `space_details`: Updates the space's description. Supports up to 150
   * characters.
   *
   * `display_name`: Only supports updating the display name for spaces where
   * `spaceType` field is `SPACE`.
   *  If you receive the error message `ALREADY_EXISTS`, try a different
   *  value. An existing space within the
   * Google Workspace organization might already use this display name.
   *
   * `space_type`: Only supports changing a `GROUP_CHAT` space type to
   * `SPACE`. Include `display_name` together
   * with `space_type` in the update mask and ensure that the specified space
   * has a non-empty display name and the `SPACE` space type. Including the
   * `space_type` mask and the `SPACE` type in the specified space when updating
   * the display name is optional if the existing space already has the `SPACE`
   * type. Trying to update the space type in other ways results in an invalid
   * argument error.
   * `space_type` is not supported with `useAdminAccess`.
   *
   * `space_history_state`: Updates [space history
   * settings](https://support.google.com/chat/answer/7664687) by turning
   * history on or off for the space. Only supported if history settings are
   * enabled for the Google Workspace organization. To update the
   * space history state, you must omit all other field masks in your request.
   * `space_history_state` is not supported with `useAdminAccess`.
   *
   * `access_settings.audience`: Updates the [access
   * setting](https://support.google.com/chat/answer/11971020) of who can
   * discover the space, join the space, and preview the messages in named space
   * where `spaceType` field is `SPACE`. If the existing space has a
   * target audience, you can remove the audience and restrict space access by
   * omitting a value for this field mask. To update access settings for a
   * space, the authenticating user must be a space manager and omit all other
   * field masks in your request. You can't update this field if the space is in
   * [import
   * mode](https://developers.google.com/workspace/chat/import-data-overview).
   * To learn more, see [Make a space discoverable to specific
   * users](https://developers.google.com/workspace/chat/space-target-audience).
   * `access_settings.audience` is not supported with `useAdminAccess`.
   *
   * `permission_settings`: Supports changing the
   * [permission settings](https://support.google.com/chat/answer/13340792)
   * of a space.
   * When updating permission settings, you can only specify
   * `permissionSettings` field masks; you cannot update other field masks
   * at the same time. `permissionSettings` is not supported with
   * `useAdminAccess`.
   * The supported field masks include:
   *
   * - `permission_settings.manageMembersAndGroups`
   * - `permission_settings.modifySpaceDetails`
   * - `permission_settings.toggleHistory`
   * - `permission_settings.useAtMentionAll`
   * - `permission_settings.manageApps`
   * - `permission_settings.manageWebhooks`
   * - `permission_settings.replyMessages`
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The updateMask.
   */
  com.google.protobuf.FieldMask getUpdateMask();

  /**
   *
   *
   * <pre>
   * Required. The updated field paths, comma separated if there are
   * multiple.
   *
   * You can update the following fields for a space:
   *
   * `space_details`: Updates the space's description. Supports up to 150
   * characters.
   *
   * `display_name`: Only supports updating the display name for spaces where
   * `spaceType` field is `SPACE`.
   *  If you receive the error message `ALREADY_EXISTS`, try a different
   *  value. An existing space within the
   * Google Workspace organization might already use this display name.
   *
   * `space_type`: Only supports changing a `GROUP_CHAT` space type to
   * `SPACE`. Include `display_name` together
   * with `space_type` in the update mask and ensure that the specified space
   * has a non-empty display name and the `SPACE` space type. Including the
   * `space_type` mask and the `SPACE` type in the specified space when updating
   * the display name is optional if the existing space already has the `SPACE`
   * type. Trying to update the space type in other ways results in an invalid
   * argument error.
   * `space_type` is not supported with `useAdminAccess`.
   *
   * `space_history_state`: Updates [space history
   * settings](https://support.google.com/chat/answer/7664687) by turning
   * history on or off for the space. Only supported if history settings are
   * enabled for the Google Workspace organization. To update the
   * space history state, you must omit all other field masks in your request.
   * `space_history_state` is not supported with `useAdminAccess`.
   *
   * `access_settings.audience`: Updates the [access
   * setting](https://support.google.com/chat/answer/11971020) of who can
   * discover the space, join the space, and preview the messages in named space
   * where `spaceType` field is `SPACE`. If the existing space has a
   * target audience, you can remove the audience and restrict space access by
   * omitting a value for this field mask. To update access settings for a
   * space, the authenticating user must be a space manager and omit all other
   * field masks in your request. You can't update this field if the space is in
   * [import
   * mode](https://developers.google.com/workspace/chat/import-data-overview).
   * To learn more, see [Make a space discoverable to specific
   * users](https://developers.google.com/workspace/chat/space-target-audience).
   * `access_settings.audience` is not supported with `useAdminAccess`.
   *
   * `permission_settings`: Supports changing the
   * [permission settings](https://support.google.com/chat/answer/13340792)
   * of a space.
   * When updating permission settings, you can only specify
   * `permissionSettings` field masks; you cannot update other field masks
   * at the same time. `permissionSettings` is not supported with
   * `useAdminAccess`.
   * The supported field masks include:
   *
   * - `permission_settings.manageMembersAndGroups`
   * - `permission_settings.modifySpaceDetails`
   * - `permission_settings.toggleHistory`
   * - `permission_settings.useAtMentionAll`
   * - `permission_settings.manageApps`
   * - `permission_settings.manageWebhooks`
   * - `permission_settings.replyMessages`
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. When `true`, the method runs using the user's Google Workspace
   * administrator privileges.
   *
   * The calling user must be a Google Workspace administrator with the
   * [manage chat and spaces conversations
   * privilege](https://support.google.com/a/answer/13369245).
   *
   * Requires the `chat.admin.spaces` [OAuth 2.0
   * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
   *
   * Some `FieldMask` values are not supported using admin access. For details,
   * see the description of `update_mask`.
   * </pre>
   *
   * <code>bool use_admin_access = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The useAdminAccess.
   */
  boolean getUseAdminAccess();
}
