/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/user.proto

// Protobuf Java Version: 3.25.5
package com.google.chat.v1;

/**
 *
 *
 * <pre>
 * A user in Google Chat.
 * When returned as an output from a request, if your Chat app [authenticates as
 * a
 * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
 * the output for a `User` resource only populates the user's `name` and `type`.
 * </pre>
 *
 * Protobuf type {@code google.chat.v1.User}
 */
public final class User extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.User)
    UserOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use User.newBuilder() to construct.
  private User(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private User() {
    name_ = "";
    displayName_ = "";
    domainId_ = "";
    type_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new User();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.UserProto.internal_static_google_chat_v1_User_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.UserProto.internal_static_google_chat_v1_User_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.User.class, com.google.chat.v1.User.Builder.class);
  }

  /** Protobuf enum {@code google.chat.v1.User.Type} */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value for the enum. DO NOT USE.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Human user.
     * </pre>
     *
     * <code>HUMAN = 1;</code>
     */
    HUMAN(1),
    /**
     *
     *
     * <pre>
     * Chat app user.
     * </pre>
     *
     * <code>BOT = 2;</code>
     */
    BOT(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value for the enum. DO NOT USE.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Human user.
     * </pre>
     *
     * <code>HUMAN = 1;</code>
     */
    public static final int HUMAN_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Chat app user.
     * </pre>
     *
     * <code>BOT = 2;</code>
     */
    public static final int BOT_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return HUMAN;
        case 2:
          return BOT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.chat.v1.User.getDescriptor().getEnumTypes().get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.chat.v1.User.Type)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Resource name for a Google Chat [user][google.chat.v1.User].
   *
   * Format: `users/{user}`. `users/app` can be used as an alias for the calling
   * app [bot][google.chat.v1.User.Type.BOT] user.
   *
   * For [human users][google.chat.v1.User.Type.HUMAN], `{user}` is the same
   * user identifier as:
   *
   * - the `id` for the
   * [Person](https://developers.google.com/people/api/rest/v1/people) in the
   * People API. For example, `users/123456789` in Chat API represents the same
   * person as the `123456789` Person profile ID in People API.
   *
   * - the `id` for a
   * [user](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users)
   * in the Admin SDK Directory API.
   *
   * - the user's email address can be used as an alias for `{user}` in API
   * requests. For example, if the People API Person profile ID for
   * `user&#64;example.com` is `123456789`, you can use `users/user&#64;example.com` as
   * an alias to reference `users/123456789`. Only the canonical resource name
   * (for example `users/123456789`) will be returned from the API.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Resource name for a Google Chat [user][google.chat.v1.User].
   *
   * Format: `users/{user}`. `users/app` can be used as an alias for the calling
   * app [bot][google.chat.v1.User.Type.BOT] user.
   *
   * For [human users][google.chat.v1.User.Type.HUMAN], `{user}` is the same
   * user identifier as:
   *
   * - the `id` for the
   * [Person](https://developers.google.com/people/api/rest/v1/people) in the
   * People API. For example, `users/123456789` in Chat API represents the same
   * person as the `123456789` Person profile ID in People API.
   *
   * - the `id` for a
   * [user](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users)
   * in the Admin SDK Directory API.
   *
   * - the user's email address can be used as an alias for `{user}` in API
   * requests. For example, if the People API Person profile ID for
   * `user&#64;example.com` is `123456789`, you can use `users/user&#64;example.com` as
   * an alias to reference `users/123456789`. Only the canonical resource name
   * (for example `users/123456789`) will be returned from the API.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The user's display name.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The user's display name.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOMAIN_ID_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object domainId_ = "";

  /**
   *
   *
   * <pre>
   * Unique identifier of the user's Google Workspace domain.
   * </pre>
   *
   * <code>string domain_id = 6;</code>
   *
   * @return The domainId.
   */
  @java.lang.Override
  public java.lang.String getDomainId() {
    java.lang.Object ref = domainId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      domainId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Unique identifier of the user's Google Workspace domain.
   * </pre>
   *
   * <code>string domain_id = 6;</code>
   *
   * @return The bytes for domainId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDomainIdBytes() {
    java.lang.Object ref = domainId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      domainId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 5;
  private int type_ = 0;

  /**
   *
   *
   * <pre>
   * User type.
   * </pre>
   *
   * <code>.google.chat.v1.User.Type type = 5;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }

  /**
   *
   *
   * <pre>
   * User type.
   * </pre>
   *
   * <code>.google.chat.v1.User.Type type = 5;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.chat.v1.User.Type getType() {
    com.google.chat.v1.User.Type result = com.google.chat.v1.User.Type.forNumber(type_);
    return result == null ? com.google.chat.v1.User.Type.UNRECOGNIZED : result;
  }

  public static final int IS_ANONYMOUS_FIELD_NUMBER = 7;
  private boolean isAnonymous_ = false;

  /**
   *
   *
   * <pre>
   * Output only. When `true`, the user is deleted or their profile is not
   * visible.
   * </pre>
   *
   * <code>bool is_anonymous = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The isAnonymous.
   */
  @java.lang.Override
  public boolean getIsAnonymous() {
    return isAnonymous_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (type_ != com.google.chat.v1.User.Type.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domainId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, domainId_);
    }
    if (isAnonymous_ != false) {
      output.writeBool(7, isAnonymous_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (type_ != com.google.chat.v1.User.Type.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domainId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, domainId_);
    }
    if (isAnonymous_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, isAnonymous_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.User)) {
      return super.equals(obj);
    }
    com.google.chat.v1.User other = (com.google.chat.v1.User) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDomainId().equals(other.getDomainId())) return false;
    if (type_ != other.type_) return false;
    if (getIsAnonymous() != other.getIsAnonymous()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DOMAIN_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDomainId().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + IS_ANONYMOUS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsAnonymous());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.User parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.User parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.User parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.User parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.User parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.User parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.User parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.User parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.User parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.User parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.User parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.User parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.User prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A user in Google Chat.
   * When returned as an output from a request, if your Chat app [authenticates as
   * a
   * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
   * the output for a `User` resource only populates the user's `name` and `type`.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.User}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.User)
      com.google.chat.v1.UserOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.UserProto.internal_static_google_chat_v1_User_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.UserProto.internal_static_google_chat_v1_User_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.User.class, com.google.chat.v1.User.Builder.class);
    }

    // Construct using com.google.chat.v1.User.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      domainId_ = "";
      type_ = 0;
      isAnonymous_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.UserProto.internal_static_google_chat_v1_User_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.User getDefaultInstanceForType() {
      return com.google.chat.v1.User.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.User build() {
      com.google.chat.v1.User result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.User buildPartial() {
      com.google.chat.v1.User result = new com.google.chat.v1.User(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.chat.v1.User result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.domainId_ = domainId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.isAnonymous_ = isAnonymous_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.User) {
        return mergeFrom((com.google.chat.v1.User) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.User other) {
      if (other == com.google.chat.v1.User.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDomainId().isEmpty()) {
        domainId_ = other.domainId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.getIsAnonymous() != false) {
        setIsAnonymous(other.getIsAnonymous());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 40:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            case 50:
              {
                domainId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 50
            case 56:
              {
                isAnonymous_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Resource name for a Google Chat [user][google.chat.v1.User].
     *
     * Format: `users/{user}`. `users/app` can be used as an alias for the calling
     * app [bot][google.chat.v1.User.Type.BOT] user.
     *
     * For [human users][google.chat.v1.User.Type.HUMAN], `{user}` is the same
     * user identifier as:
     *
     * - the `id` for the
     * [Person](https://developers.google.com/people/api/rest/v1/people) in the
     * People API. For example, `users/123456789` in Chat API represents the same
     * person as the `123456789` Person profile ID in People API.
     *
     * - the `id` for a
     * [user](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users)
     * in the Admin SDK Directory API.
     *
     * - the user's email address can be used as an alias for `{user}` in API
     * requests. For example, if the People API Person profile ID for
     * `user&#64;example.com` is `123456789`, you can use `users/user&#64;example.com` as
     * an alias to reference `users/123456789`. Only the canonical resource name
     * (for example `users/123456789`) will be returned from the API.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Resource name for a Google Chat [user][google.chat.v1.User].
     *
     * Format: `users/{user}`. `users/app` can be used as an alias for the calling
     * app [bot][google.chat.v1.User.Type.BOT] user.
     *
     * For [human users][google.chat.v1.User.Type.HUMAN], `{user}` is the same
     * user identifier as:
     *
     * - the `id` for the
     * [Person](https://developers.google.com/people/api/rest/v1/people) in the
     * People API. For example, `users/123456789` in Chat API represents the same
     * person as the `123456789` Person profile ID in People API.
     *
     * - the `id` for a
     * [user](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users)
     * in the Admin SDK Directory API.
     *
     * - the user's email address can be used as an alias for `{user}` in API
     * requests. For example, if the People API Person profile ID for
     * `user&#64;example.com` is `123456789`, you can use `users/user&#64;example.com` as
     * an alias to reference `users/123456789`. Only the canonical resource name
     * (for example `users/123456789`) will be returned from the API.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Resource name for a Google Chat [user][google.chat.v1.User].
     *
     * Format: `users/{user}`. `users/app` can be used as an alias for the calling
     * app [bot][google.chat.v1.User.Type.BOT] user.
     *
     * For [human users][google.chat.v1.User.Type.HUMAN], `{user}` is the same
     * user identifier as:
     *
     * - the `id` for the
     * [Person](https://developers.google.com/people/api/rest/v1/people) in the
     * People API. For example, `users/123456789` in Chat API represents the same
     * person as the `123456789` Person profile ID in People API.
     *
     * - the `id` for a
     * [user](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users)
     * in the Admin SDK Directory API.
     *
     * - the user's email address can be used as an alias for `{user}` in API
     * requests. For example, if the People API Person profile ID for
     * `user&#64;example.com` is `123456789`, you can use `users/user&#64;example.com` as
     * an alias to reference `users/123456789`. Only the canonical resource name
     * (for example `users/123456789`) will be returned from the API.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Resource name for a Google Chat [user][google.chat.v1.User].
     *
     * Format: `users/{user}`. `users/app` can be used as an alias for the calling
     * app [bot][google.chat.v1.User.Type.BOT] user.
     *
     * For [human users][google.chat.v1.User.Type.HUMAN], `{user}` is the same
     * user identifier as:
     *
     * - the `id` for the
     * [Person](https://developers.google.com/people/api/rest/v1/people) in the
     * People API. For example, `users/123456789` in Chat API represents the same
     * person as the `123456789` Person profile ID in People API.
     *
     * - the `id` for a
     * [user](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users)
     * in the Admin SDK Directory API.
     *
     * - the user's email address can be used as an alias for `{user}` in API
     * requests. For example, if the People API Person profile ID for
     * `user&#64;example.com` is `123456789`, you can use `users/user&#64;example.com` as
     * an alias to reference `users/123456789`. Only the canonical resource name
     * (for example `users/123456789`) will be returned from the API.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Resource name for a Google Chat [user][google.chat.v1.User].
     *
     * Format: `users/{user}`. `users/app` can be used as an alias for the calling
     * app [bot][google.chat.v1.User.Type.BOT] user.
     *
     * For [human users][google.chat.v1.User.Type.HUMAN], `{user}` is the same
     * user identifier as:
     *
     * - the `id` for the
     * [Person](https://developers.google.com/people/api/rest/v1/people) in the
     * People API. For example, `users/123456789` in Chat API represents the same
     * person as the `123456789` Person profile ID in People API.
     *
     * - the `id` for a
     * [user](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users)
     * in the Admin SDK Directory API.
     *
     * - the user's email address can be used as an alias for `{user}` in API
     * requests. For example, if the People API Person profile ID for
     * `user&#64;example.com` is `123456789`, you can use `users/user&#64;example.com` as
     * an alias to reference `users/123456789`. Only the canonical resource name
     * (for example `users/123456789`) will be returned from the API.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The user's display name.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The user's display name.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The user's display name.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The user's display name.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The user's display name.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object domainId_ = "";

    /**
     *
     *
     * <pre>
     * Unique identifier of the user's Google Workspace domain.
     * </pre>
     *
     * <code>string domain_id = 6;</code>
     *
     * @return The domainId.
     */
    public java.lang.String getDomainId() {
      java.lang.Object ref = domainId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        domainId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Unique identifier of the user's Google Workspace domain.
     * </pre>
     *
     * <code>string domain_id = 6;</code>
     *
     * @return The bytes for domainId.
     */
    public com.google.protobuf.ByteString getDomainIdBytes() {
      java.lang.Object ref = domainId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        domainId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Unique identifier of the user's Google Workspace domain.
     * </pre>
     *
     * <code>string domain_id = 6;</code>
     *
     * @param value The domainId to set.
     * @return This builder for chaining.
     */
    public Builder setDomainId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      domainId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Unique identifier of the user's Google Workspace domain.
     * </pre>
     *
     * <code>string domain_id = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDomainId() {
      domainId_ = getDefaultInstance().getDomainId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Unique identifier of the user's Google Workspace domain.
     * </pre>
     *
     * <code>string domain_id = 6;</code>
     *
     * @param value The bytes for domainId to set.
     * @return This builder for chaining.
     */
    public Builder setDomainIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      domainId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int type_ = 0;

    /**
     *
     *
     * <pre>
     * User type.
     * </pre>
     *
     * <code>.google.chat.v1.User.Type type = 5;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }

    /**
     *
     *
     * <pre>
     * User type.
     * </pre>
     *
     * <code>.google.chat.v1.User.Type type = 5;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * User type.
     * </pre>
     *
     * <code>.google.chat.v1.User.Type type = 5;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.chat.v1.User.Type getType() {
      com.google.chat.v1.User.Type result = com.google.chat.v1.User.Type.forNumber(type_);
      return result == null ? com.google.chat.v1.User.Type.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * User type.
     * </pre>
     *
     * <code>.google.chat.v1.User.Type type = 5;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.chat.v1.User.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      type_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * User type.
     * </pre>
     *
     * <code>.google.chat.v1.User.Type type = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000008);
      type_ = 0;
      onChanged();
      return this;
    }

    private boolean isAnonymous_;

    /**
     *
     *
     * <pre>
     * Output only. When `true`, the user is deleted or their profile is not
     * visible.
     * </pre>
     *
     * <code>bool is_anonymous = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The isAnonymous.
     */
    @java.lang.Override
    public boolean getIsAnonymous() {
      return isAnonymous_;
    }

    /**
     *
     *
     * <pre>
     * Output only. When `true`, the user is deleted or their profile is not
     * visible.
     * </pre>
     *
     * <code>bool is_anonymous = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The isAnonymous to set.
     * @return This builder for chaining.
     */
    public Builder setIsAnonymous(boolean value) {

      isAnonymous_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. When `true`, the user is deleted or their profile is not
     * visible.
     * </pre>
     *
     * <code>bool is_anonymous = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsAnonymous() {
      bitField0_ = (bitField0_ & ~0x00000010);
      isAnonymous_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.User)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.User)
  private static final com.google.chat.v1.User DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.User();
  }

  public static com.google.chat.v1.User getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<User> PARSER =
      new com.google.protobuf.AbstractParser<User>() {
        @java.lang.Override
        public User parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<User> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<User> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.User getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
