/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/user.proto

// Protobuf Java Version: 3.25.5
package com.google.chat.v1;

public interface UserOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.chat.v1.User)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Resource name for a Google Chat [user][google.chat.v1.User].
   *
   * Format: `users/{user}`. `users/app` can be used as an alias for the calling
   * app [bot][google.chat.v1.User.Type.BOT] user.
   *
   * For [human users][google.chat.v1.User.Type.HUMAN], `{user}` is the same
   * user identifier as:
   *
   * - the `id` for the
   * [Person](https://developers.google.com/people/api/rest/v1/people) in the
   * People API. For example, `users/123456789` in Chat API represents the same
   * person as the `123456789` Person profile ID in People API.
   *
   * - the `id` for a
   * [user](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users)
   * in the Admin SDK Directory API.
   *
   * - the user's email address can be used as an alias for `{user}` in API
   * requests. For example, if the People API Person profile ID for
   * `user&#64;example.com` is `123456789`, you can use `users/user&#64;example.com` as
   * an alias to reference `users/123456789`. Only the canonical resource name
   * (for example `users/123456789`) will be returned from the API.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Resource name for a Google Chat [user][google.chat.v1.User].
   *
   * Format: `users/{user}`. `users/app` can be used as an alias for the calling
   * app [bot][google.chat.v1.User.Type.BOT] user.
   *
   * For [human users][google.chat.v1.User.Type.HUMAN], `{user}` is the same
   * user identifier as:
   *
   * - the `id` for the
   * [Person](https://developers.google.com/people/api/rest/v1/people) in the
   * People API. For example, `users/123456789` in Chat API represents the same
   * person as the `123456789` Person profile ID in People API.
   *
   * - the `id` for a
   * [user](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users)
   * in the Admin SDK Directory API.
   *
   * - the user's email address can be used as an alias for `{user}` in API
   * requests. For example, if the People API Person profile ID for
   * `user&#64;example.com` is `123456789`, you can use `users/user&#64;example.com` as
   * an alias to reference `users/123456789`. Only the canonical resource name
   * (for example `users/123456789`) will be returned from the API.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. The user's display name.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The displayName.
   */
  java.lang.String getDisplayName();

  /**
   *
   *
   * <pre>
   * Output only. The user's display name.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for displayName.
   */
  com.google.protobuf.ByteString getDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * Unique identifier of the user's Google Workspace domain.
   * </pre>
   *
   * <code>string domain_id = 6;</code>
   *
   * @return The domainId.
   */
  java.lang.String getDomainId();

  /**
   *
   *
   * <pre>
   * Unique identifier of the user's Google Workspace domain.
   * </pre>
   *
   * <code>string domain_id = 6;</code>
   *
   * @return The bytes for domainId.
   */
  com.google.protobuf.ByteString getDomainIdBytes();

  /**
   *
   *
   * <pre>
   * User type.
   * </pre>
   *
   * <code>.google.chat.v1.User.Type type = 5;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  int getTypeValue();

  /**
   *
   *
   * <pre>
   * User type.
   * </pre>
   *
   * <code>.google.chat.v1.User.Type type = 5;</code>
   *
   * @return The type.
   */
  com.google.chat.v1.User.Type getType();

  /**
   *
   *
   * <pre>
   * Output only. When `true`, the user is deleted or their profile is not
   * visible.
   * </pre>
   *
   * <code>bool is_anonymous = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The isAnonymous.
   */
  boolean getIsAnonymous();
}
