/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/commerce/consumer/procurement/v1/order.proto

package com.google.cloud.commerce.consumer.procurement.v1;

/**
 *
 *
 * <pre>
 * A single item within an order.
 * </pre>
 *
 * Protobuf type {@code google.cloud.commerce.consumer.procurement.v1.LineItem}
 */
public final class LineItem extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.commerce.consumer.procurement.v1.LineItem)
    LineItemOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LineItem.newBuilder() to construct.
  private LineItem(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LineItem() {
    lineItemId_ = "";
    changeHistory_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LineItem();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.commerce.consumer.procurement.v1.OrderOuterClass
        .internal_static_google_cloud_commerce_consumer_procurement_v1_LineItem_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.commerce.consumer.procurement.v1.OrderOuterClass
        .internal_static_google_cloud_commerce_consumer_procurement_v1_LineItem_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.commerce.consumer.procurement.v1.LineItem.class,
            com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder.class);
  }

  public static final int LINE_ITEM_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lineItemId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Line item ID.
   * </pre>
   *
   * <code>string line_item_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The lineItemId.
   */
  @java.lang.Override
  public java.lang.String getLineItemId() {
    java.lang.Object ref = lineItemId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lineItemId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Line item ID.
   * </pre>
   *
   * <code>string line_item_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for lineItemId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLineItemIdBytes() {
    java.lang.Object ref = lineItemId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lineItemId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LINE_ITEM_INFO_FIELD_NUMBER = 2;
  private com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo lineItemInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Current state and information of this item. It tells what,
   * e.g. which offer, is currently effective.
   * </pre>
   *
   * <code>
   * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lineItemInfo field is set.
   */
  @java.lang.Override
  public boolean hasLineItemInfo() {
    return lineItemInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Current state and information of this item. It tells what,
   * e.g. which offer, is currently effective.
   * </pre>
   *
   * <code>
   * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lineItemInfo.
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo getLineItemInfo() {
    return lineItemInfo_ == null
        ? com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.getDefaultInstance()
        : lineItemInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Current state and information of this item. It tells what,
   * e.g. which offer, is currently effective.
   * </pre>
   *
   * <code>
   * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder
      getLineItemInfoOrBuilder() {
    return lineItemInfo_ == null
        ? com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.getDefaultInstance()
        : lineItemInfo_;
  }

  public static final int PENDING_CHANGE_FIELD_NUMBER = 3;
  private com.google.cloud.commerce.consumer.procurement.v1.LineItemChange pendingChange_;
  /**
   *
   *
   * <pre>
   * Output only. A change made on the item which is pending and not yet
   * effective. Absence of this field indicates the line item is not undergoing
   * a change.
   * </pre>
   *
   * <code>
   * .google.cloud.commerce.consumer.procurement.v1.LineItemChange pending_change = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the pendingChange field is set.
   */
  @java.lang.Override
  public boolean hasPendingChange() {
    return pendingChange_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. A change made on the item which is pending and not yet
   * effective. Absence of this field indicates the line item is not undergoing
   * a change.
   * </pre>
   *
   * <code>
   * .google.cloud.commerce.consumer.procurement.v1.LineItemChange pending_change = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The pendingChange.
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItemChange getPendingChange() {
    return pendingChange_ == null
        ? com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.getDefaultInstance()
        : pendingChange_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A change made on the item which is pending and not yet
   * effective. Absence of this field indicates the line item is not undergoing
   * a change.
   * </pre>
   *
   * <code>
   * .google.cloud.commerce.consumer.procurement.v1.LineItemChange pending_change = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeOrBuilder
      getPendingChangeOrBuilder() {
    return pendingChange_ == null
        ? com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.getDefaultInstance()
        : pendingChange_;
  }

  public static final int CHANGE_HISTORY_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.commerce.consumer.procurement.v1.LineItemChange>
      changeHistory_;
  /**
   *
   *
   * <pre>
   * Output only. Changes made on the item that are not pending anymore which
   * might be because they already took effect, were reverted by the customer,
   * or were rejected by the partner. No more operations are allowed on these
   * changes.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.commerce.consumer.procurement.v1.LineItemChange>
      getChangeHistoryList() {
    return changeHistory_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Changes made on the item that are not pending anymore which
   * might be because they already took effect, were reverted by the customer,
   * or were rejected by the partner. No more operations are allowed on these
   * changes.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeOrBuilder>
      getChangeHistoryOrBuilderList() {
    return changeHistory_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Changes made on the item that are not pending anymore which
   * might be because they already took effect, were reverted by the customer,
   * or were rejected by the partner. No more operations are allowed on these
   * changes.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getChangeHistoryCount() {
    return changeHistory_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Changes made on the item that are not pending anymore which
   * might be because they already took effect, were reverted by the customer,
   * or were rejected by the partner. No more operations are allowed on these
   * changes.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItemChange getChangeHistory(
      int index) {
    return changeHistory_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Changes made on the item that are not pending anymore which
   * might be because they already took effect, were reverted by the customer,
   * or were rejected by the partner. No more operations are allowed on these
   * changes.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeOrBuilder
      getChangeHistoryOrBuilder(int index) {
    return changeHistory_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lineItemId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, lineItemId_);
    }
    if (lineItemInfo_ != null) {
      output.writeMessage(2, getLineItemInfo());
    }
    if (pendingChange_ != null) {
      output.writeMessage(3, getPendingChange());
    }
    for (int i = 0; i < changeHistory_.size(); i++) {
      output.writeMessage(4, changeHistory_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lineItemId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, lineItemId_);
    }
    if (lineItemInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getLineItemInfo());
    }
    if (pendingChange_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getPendingChange());
    }
    for (int i = 0; i < changeHistory_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, changeHistory_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.commerce.consumer.procurement.v1.LineItem)) {
      return super.equals(obj);
    }
    com.google.cloud.commerce.consumer.procurement.v1.LineItem other =
        (com.google.cloud.commerce.consumer.procurement.v1.LineItem) obj;

    if (!getLineItemId().equals(other.getLineItemId())) return false;
    if (hasLineItemInfo() != other.hasLineItemInfo()) return false;
    if (hasLineItemInfo()) {
      if (!getLineItemInfo().equals(other.getLineItemInfo())) return false;
    }
    if (hasPendingChange() != other.hasPendingChange()) return false;
    if (hasPendingChange()) {
      if (!getPendingChange().equals(other.getPendingChange())) return false;
    }
    if (!getChangeHistoryList().equals(other.getChangeHistoryList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + LINE_ITEM_ID_FIELD_NUMBER;
    hash = (53 * hash) + getLineItemId().hashCode();
    if (hasLineItemInfo()) {
      hash = (37 * hash) + LINE_ITEM_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getLineItemInfo().hashCode();
    }
    if (hasPendingChange()) {
      hash = (37 * hash) + PENDING_CHANGE_FIELD_NUMBER;
      hash = (53 * hash) + getPendingChange().hashCode();
    }
    if (getChangeHistoryCount() > 0) {
      hash = (37 * hash) + CHANGE_HISTORY_FIELD_NUMBER;
      hash = (53 * hash) + getChangeHistoryList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItem parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItem parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItem parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItem parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItem parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItem parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItem parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItem parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItem parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItem parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItem parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItem parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.commerce.consumer.procurement.v1.LineItem prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A single item within an order.
   * </pre>
   *
   * Protobuf type {@code google.cloud.commerce.consumer.procurement.v1.LineItem}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.commerce.consumer.procurement.v1.LineItem)
      com.google.cloud.commerce.consumer.procurement.v1.LineItemOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.commerce.consumer.procurement.v1.OrderOuterClass
          .internal_static_google_cloud_commerce_consumer_procurement_v1_LineItem_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.commerce.consumer.procurement.v1.OrderOuterClass
          .internal_static_google_cloud_commerce_consumer_procurement_v1_LineItem_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.commerce.consumer.procurement.v1.LineItem.class,
              com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder.class);
    }

    // Construct using com.google.cloud.commerce.consumer.procurement.v1.LineItem.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      lineItemId_ = "";
      lineItemInfo_ = null;
      if (lineItemInfoBuilder_ != null) {
        lineItemInfoBuilder_.dispose();
        lineItemInfoBuilder_ = null;
      }
      pendingChange_ = null;
      if (pendingChangeBuilder_ != null) {
        pendingChangeBuilder_.dispose();
        pendingChangeBuilder_ = null;
      }
      if (changeHistoryBuilder_ == null) {
        changeHistory_ = java.util.Collections.emptyList();
      } else {
        changeHistory_ = null;
        changeHistoryBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.commerce.consumer.procurement.v1.OrderOuterClass
          .internal_static_google_cloud_commerce_consumer_procurement_v1_LineItem_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.commerce.consumer.procurement.v1.LineItem getDefaultInstanceForType() {
      return com.google.cloud.commerce.consumer.procurement.v1.LineItem.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.commerce.consumer.procurement.v1.LineItem build() {
      com.google.cloud.commerce.consumer.procurement.v1.LineItem result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.commerce.consumer.procurement.v1.LineItem buildPartial() {
      com.google.cloud.commerce.consumer.procurement.v1.LineItem result =
          new com.google.cloud.commerce.consumer.procurement.v1.LineItem(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.commerce.consumer.procurement.v1.LineItem result) {
      if (changeHistoryBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          changeHistory_ = java.util.Collections.unmodifiableList(changeHistory_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.changeHistory_ = changeHistory_;
      } else {
        result.changeHistory_ = changeHistoryBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.commerce.consumer.procurement.v1.LineItem result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.lineItemId_ = lineItemId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.lineItemInfo_ =
            lineItemInfoBuilder_ == null ? lineItemInfo_ : lineItemInfoBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pendingChange_ =
            pendingChangeBuilder_ == null ? pendingChange_ : pendingChangeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.commerce.consumer.procurement.v1.LineItem) {
        return mergeFrom((com.google.cloud.commerce.consumer.procurement.v1.LineItem) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.commerce.consumer.procurement.v1.LineItem other) {
      if (other == com.google.cloud.commerce.consumer.procurement.v1.LineItem.getDefaultInstance())
        return this;
      if (!other.getLineItemId().isEmpty()) {
        lineItemId_ = other.lineItemId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasLineItemInfo()) {
        mergeLineItemInfo(other.getLineItemInfo());
      }
      if (other.hasPendingChange()) {
        mergePendingChange(other.getPendingChange());
      }
      if (changeHistoryBuilder_ == null) {
        if (!other.changeHistory_.isEmpty()) {
          if (changeHistory_.isEmpty()) {
            changeHistory_ = other.changeHistory_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureChangeHistoryIsMutable();
            changeHistory_.addAll(other.changeHistory_);
          }
          onChanged();
        }
      } else {
        if (!other.changeHistory_.isEmpty()) {
          if (changeHistoryBuilder_.isEmpty()) {
            changeHistoryBuilder_.dispose();
            changeHistoryBuilder_ = null;
            changeHistory_ = other.changeHistory_;
            bitField0_ = (bitField0_ & ~0x00000008);
            changeHistoryBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getChangeHistoryFieldBuilder()
                    : null;
          } else {
            changeHistoryBuilder_.addAllMessages(other.changeHistory_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                lineItemId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getLineItemInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getPendingChangeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.commerce.consumer.procurement.v1.LineItemChange m =
                    input.readMessage(
                        com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.parser(),
                        extensionRegistry);
                if (changeHistoryBuilder_ == null) {
                  ensureChangeHistoryIsMutable();
                  changeHistory_.add(m);
                } else {
                  changeHistoryBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object lineItemId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Line item ID.
     * </pre>
     *
     * <code>string line_item_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The lineItemId.
     */
    public java.lang.String getLineItemId() {
      java.lang.Object ref = lineItemId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lineItemId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Line item ID.
     * </pre>
     *
     * <code>string line_item_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for lineItemId.
     */
    public com.google.protobuf.ByteString getLineItemIdBytes() {
      java.lang.Object ref = lineItemId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lineItemId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Line item ID.
     * </pre>
     *
     * <code>string line_item_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The lineItemId to set.
     * @return This builder for chaining.
     */
    public Builder setLineItemId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lineItemId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Line item ID.
     * </pre>
     *
     * <code>string line_item_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLineItemId() {
      lineItemId_ = getDefaultInstance().getLineItemId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Line item ID.
     * </pre>
     *
     * <code>string line_item_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for lineItemId to set.
     * @return This builder for chaining.
     */
    public Builder setLineItemIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lineItemId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo lineItemInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder>
        lineItemInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Current state and information of this item. It tells what,
     * e.g. which offer, is currently effective.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lineItemInfo field is set.
     */
    public boolean hasLineItemInfo() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state and information of this item. It tells what,
     * e.g. which offer, is currently effective.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lineItemInfo.
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo getLineItemInfo() {
      if (lineItemInfoBuilder_ == null) {
        return lineItemInfo_ == null
            ? com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.getDefaultInstance()
            : lineItemInfo_;
      } else {
        return lineItemInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state and information of this item. It tells what,
     * e.g. which offer, is currently effective.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLineItemInfo(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo value) {
      if (lineItemInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lineItemInfo_ = value;
      } else {
        lineItemInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state and information of this item. It tells what,
     * e.g. which offer, is currently effective.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLineItemInfo(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder builderForValue) {
      if (lineItemInfoBuilder_ == null) {
        lineItemInfo_ = builderForValue.build();
      } else {
        lineItemInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state and information of this item. It tells what,
     * e.g. which offer, is currently effective.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLineItemInfo(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo value) {
      if (lineItemInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && lineItemInfo_ != null
            && lineItemInfo_
                != com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo
                    .getDefaultInstance()) {
          getLineItemInfoBuilder().mergeFrom(value);
        } else {
          lineItemInfo_ = value;
        }
      } else {
        lineItemInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state and information of this item. It tells what,
     * e.g. which offer, is currently effective.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLineItemInfo() {
      bitField0_ = (bitField0_ & ~0x00000002);
      lineItemInfo_ = null;
      if (lineItemInfoBuilder_ != null) {
        lineItemInfoBuilder_.dispose();
        lineItemInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state and information of this item. It tells what,
     * e.g. which offer, is currently effective.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder
        getLineItemInfoBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getLineItemInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state and information of this item. It tells what,
     * e.g. which offer, is currently effective.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder
        getLineItemInfoOrBuilder() {
      if (lineItemInfoBuilder_ != null) {
        return lineItemInfoBuilder_.getMessageOrBuilder();
      } else {
        return lineItemInfo_ == null
            ? com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.getDefaultInstance()
            : lineItemInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state and information of this item. It tells what,
     * e.g. which offer, is currently effective.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder>
        getLineItemInfoFieldBuilder() {
      if (lineItemInfoBuilder_ == null) {
        lineItemInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo,
                com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder,
                com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder>(
                getLineItemInfo(), getParentForChildren(), isClean());
        lineItemInfo_ = null;
      }
      return lineItemInfoBuilder_;
    }

    private com.google.cloud.commerce.consumer.procurement.v1.LineItemChange pendingChange_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.commerce.consumer.procurement.v1.LineItemChange,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.Builder,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeOrBuilder>
        pendingChangeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. A change made on the item which is pending and not yet
     * effective. Absence of this field indicates the line item is not undergoing
     * a change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChange pending_change = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the pendingChange field is set.
     */
    public boolean hasPendingChange() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. A change made on the item which is pending and not yet
     * effective. Absence of this field indicates the line item is not undergoing
     * a change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChange pending_change = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The pendingChange.
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemChange getPendingChange() {
      if (pendingChangeBuilder_ == null) {
        return pendingChange_ == null
            ? com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.getDefaultInstance()
            : pendingChange_;
      } else {
        return pendingChangeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A change made on the item which is pending and not yet
     * effective. Absence of this field indicates the line item is not undergoing
     * a change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChange pending_change = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPendingChange(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemChange value) {
      if (pendingChangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pendingChange_ = value;
      } else {
        pendingChangeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A change made on the item which is pending and not yet
     * effective. Absence of this field indicates the line item is not undergoing
     * a change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChange pending_change = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPendingChange(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.Builder builderForValue) {
      if (pendingChangeBuilder_ == null) {
        pendingChange_ = builderForValue.build();
      } else {
        pendingChangeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A change made on the item which is pending and not yet
     * effective. Absence of this field indicates the line item is not undergoing
     * a change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChange pending_change = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePendingChange(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemChange value) {
      if (pendingChangeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && pendingChange_ != null
            && pendingChange_
                != com.google.cloud.commerce.consumer.procurement.v1.LineItemChange
                    .getDefaultInstance()) {
          getPendingChangeBuilder().mergeFrom(value);
        } else {
          pendingChange_ = value;
        }
      } else {
        pendingChangeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A change made on the item which is pending and not yet
     * effective. Absence of this field indicates the line item is not undergoing
     * a change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChange pending_change = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPendingChange() {
      bitField0_ = (bitField0_ & ~0x00000004);
      pendingChange_ = null;
      if (pendingChangeBuilder_ != null) {
        pendingChangeBuilder_.dispose();
        pendingChangeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A change made on the item which is pending and not yet
     * effective. Absence of this field indicates the line item is not undergoing
     * a change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChange pending_change = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.Builder
        getPendingChangeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getPendingChangeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. A change made on the item which is pending and not yet
     * effective. Absence of this field indicates the line item is not undergoing
     * a change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChange pending_change = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeOrBuilder
        getPendingChangeOrBuilder() {
      if (pendingChangeBuilder_ != null) {
        return pendingChangeBuilder_.getMessageOrBuilder();
      } else {
        return pendingChange_ == null
            ? com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.getDefaultInstance()
            : pendingChange_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A change made on the item which is pending and not yet
     * effective. Absence of this field indicates the line item is not undergoing
     * a change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChange pending_change = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.commerce.consumer.procurement.v1.LineItemChange,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.Builder,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeOrBuilder>
        getPendingChangeFieldBuilder() {
      if (pendingChangeBuilder_ == null) {
        pendingChangeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.commerce.consumer.procurement.v1.LineItemChange,
                com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.Builder,
                com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeOrBuilder>(
                getPendingChange(), getParentForChildren(), isClean());
        pendingChange_ = null;
      }
      return pendingChangeBuilder_;
    }

    private java.util.List<com.google.cloud.commerce.consumer.procurement.v1.LineItemChange>
        changeHistory_ = java.util.Collections.emptyList();

    private void ensureChangeHistoryIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        changeHistory_ =
            new java.util.ArrayList<
                com.google.cloud.commerce.consumer.procurement.v1.LineItemChange>(changeHistory_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.commerce.consumer.procurement.v1.LineItemChange,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.Builder,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeOrBuilder>
        changeHistoryBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Changes made on the item that are not pending anymore which
     * might be because they already took effect, were reverted by the customer,
     * or were rejected by the partner. No more operations are allowed on these
     * changes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.commerce.consumer.procurement.v1.LineItemChange>
        getChangeHistoryList() {
      if (changeHistoryBuilder_ == null) {
        return java.util.Collections.unmodifiableList(changeHistory_);
      } else {
        return changeHistoryBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Changes made on the item that are not pending anymore which
     * might be because they already took effect, were reverted by the customer,
     * or were rejected by the partner. No more operations are allowed on these
     * changes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getChangeHistoryCount() {
      if (changeHistoryBuilder_ == null) {
        return changeHistory_.size();
      } else {
        return changeHistoryBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Changes made on the item that are not pending anymore which
     * might be because they already took effect, were reverted by the customer,
     * or were rejected by the partner. No more operations are allowed on these
     * changes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemChange getChangeHistory(
        int index) {
      if (changeHistoryBuilder_ == null) {
        return changeHistory_.get(index);
      } else {
        return changeHistoryBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Changes made on the item that are not pending anymore which
     * might be because they already took effect, were reverted by the customer,
     * or were rejected by the partner. No more operations are allowed on these
     * changes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setChangeHistory(
        int index, com.google.cloud.commerce.consumer.procurement.v1.LineItemChange value) {
      if (changeHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChangeHistoryIsMutable();
        changeHistory_.set(index, value);
        onChanged();
      } else {
        changeHistoryBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Changes made on the item that are not pending anymore which
     * might be because they already took effect, were reverted by the customer,
     * or were rejected by the partner. No more operations are allowed on these
     * changes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setChangeHistory(
        int index,
        com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.Builder builderForValue) {
      if (changeHistoryBuilder_ == null) {
        ensureChangeHistoryIsMutable();
        changeHistory_.set(index, builderForValue.build());
        onChanged();
      } else {
        changeHistoryBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Changes made on the item that are not pending anymore which
     * might be because they already took effect, were reverted by the customer,
     * or were rejected by the partner. No more operations are allowed on these
     * changes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addChangeHistory(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemChange value) {
      if (changeHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChangeHistoryIsMutable();
        changeHistory_.add(value);
        onChanged();
      } else {
        changeHistoryBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Changes made on the item that are not pending anymore which
     * might be because they already took effect, were reverted by the customer,
     * or were rejected by the partner. No more operations are allowed on these
     * changes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addChangeHistory(
        int index, com.google.cloud.commerce.consumer.procurement.v1.LineItemChange value) {
      if (changeHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChangeHistoryIsMutable();
        changeHistory_.add(index, value);
        onChanged();
      } else {
        changeHistoryBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Changes made on the item that are not pending anymore which
     * might be because they already took effect, were reverted by the customer,
     * or were rejected by the partner. No more operations are allowed on these
     * changes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addChangeHistory(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.Builder builderForValue) {
      if (changeHistoryBuilder_ == null) {
        ensureChangeHistoryIsMutable();
        changeHistory_.add(builderForValue.build());
        onChanged();
      } else {
        changeHistoryBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Changes made on the item that are not pending anymore which
     * might be because they already took effect, were reverted by the customer,
     * or were rejected by the partner. No more operations are allowed on these
     * changes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addChangeHistory(
        int index,
        com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.Builder builderForValue) {
      if (changeHistoryBuilder_ == null) {
        ensureChangeHistoryIsMutable();
        changeHistory_.add(index, builderForValue.build());
        onChanged();
      } else {
        changeHistoryBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Changes made on the item that are not pending anymore which
     * might be because they already took effect, were reverted by the customer,
     * or were rejected by the partner. No more operations are allowed on these
     * changes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllChangeHistory(
        java.lang.Iterable<
                ? extends com.google.cloud.commerce.consumer.procurement.v1.LineItemChange>
            values) {
      if (changeHistoryBuilder_ == null) {
        ensureChangeHistoryIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, changeHistory_);
        onChanged();
      } else {
        changeHistoryBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Changes made on the item that are not pending anymore which
     * might be because they already took effect, were reverted by the customer,
     * or were rejected by the partner. No more operations are allowed on these
     * changes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearChangeHistory() {
      if (changeHistoryBuilder_ == null) {
        changeHistory_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        changeHistoryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Changes made on the item that are not pending anymore which
     * might be because they already took effect, were reverted by the customer,
     * or were rejected by the partner. No more operations are allowed on these
     * changes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeChangeHistory(int index) {
      if (changeHistoryBuilder_ == null) {
        ensureChangeHistoryIsMutable();
        changeHistory_.remove(index);
        onChanged();
      } else {
        changeHistoryBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Changes made on the item that are not pending anymore which
     * might be because they already took effect, were reverted by the customer,
     * or were rejected by the partner. No more operations are allowed on these
     * changes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.Builder
        getChangeHistoryBuilder(int index) {
      return getChangeHistoryFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Changes made on the item that are not pending anymore which
     * might be because they already took effect, were reverted by the customer,
     * or were rejected by the partner. No more operations are allowed on these
     * changes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeOrBuilder
        getChangeHistoryOrBuilder(int index) {
      if (changeHistoryBuilder_ == null) {
        return changeHistory_.get(index);
      } else {
        return changeHistoryBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Changes made on the item that are not pending anymore which
     * might be because they already took effect, were reverted by the customer,
     * or were rejected by the partner. No more operations are allowed on these
     * changes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeOrBuilder>
        getChangeHistoryOrBuilderList() {
      if (changeHistoryBuilder_ != null) {
        return changeHistoryBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(changeHistory_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Changes made on the item that are not pending anymore which
     * might be because they already took effect, were reverted by the customer,
     * or were rejected by the partner. No more operations are allowed on these
     * changes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.Builder
        addChangeHistoryBuilder() {
      return getChangeHistoryFieldBuilder()
          .addBuilder(
              com.google.cloud.commerce.consumer.procurement.v1.LineItemChange
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Changes made on the item that are not pending anymore which
     * might be because they already took effect, were reverted by the customer,
     * or were rejected by the partner. No more operations are allowed on these
     * changes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.Builder
        addChangeHistoryBuilder(int index) {
      return getChangeHistoryFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.commerce.consumer.procurement.v1.LineItemChange
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Changes made on the item that are not pending anymore which
     * might be because they already took effect, were reverted by the customer,
     * or were rejected by the partner. No more operations are allowed on these
     * changes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemChange change_history = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.Builder>
        getChangeHistoryBuilderList() {
      return getChangeHistoryFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.commerce.consumer.procurement.v1.LineItemChange,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.Builder,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeOrBuilder>
        getChangeHistoryFieldBuilder() {
      if (changeHistoryBuilder_ == null) {
        changeHistoryBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.commerce.consumer.procurement.v1.LineItemChange,
                com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.Builder,
                com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeOrBuilder>(
                changeHistory_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        changeHistory_ = null;
      }
      return changeHistoryBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.commerce.consumer.procurement.v1.LineItem)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.commerce.consumer.procurement.v1.LineItem)
  private static final com.google.cloud.commerce.consumer.procurement.v1.LineItem DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.commerce.consumer.procurement.v1.LineItem();
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItem getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LineItem> PARSER =
      new com.google.protobuf.AbstractParser<LineItem>() {
        @java.lang.Override
        public LineItem parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LineItem> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LineItem> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItem getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
