/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/commerce/consumer/procurement/v1/order.proto

package com.google.cloud.commerce.consumer.procurement.v1;

/**
 *
 *
 * <pre>
 * Represents a purchase made by a customer on Cloud Marketplace.
 * Creating an order makes sure that both the Google backend systems
 * as well as external service provider's systems (if needed) allow use of
 * purchased products and ensures the appropriate billing events occur.
 *
 * An Order can be made against one Product with multiple add-ons (optional) or
 * one Quote which might reference multiple products.
 *
 * Customers typically choose a price plan for each Product purchased when
 * they create an order and can change their plan later, if the product allows.
 * </pre>
 *
 * Protobuf type {@code google.cloud.commerce.consumer.procurement.v1.Order}
 */
public final class Order extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.commerce.consumer.procurement.v1.Order)
    OrderOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Order.newBuilder() to construct.
  private Order(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Order() {
    name_ = "";
    displayName_ = "";
    lineItems_ = java.util.Collections.emptyList();
    cancelledLineItems_ = java.util.Collections.emptyList();
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Order();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.commerce.consumer.procurement.v1.OrderOuterClass
        .internal_static_google_cloud_commerce_consumer_procurement_v1_Order_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.commerce.consumer.procurement.v1.OrderOuterClass
        .internal_static_google_cloud_commerce_consumer_procurement_v1_Order_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.commerce.consumer.procurement.v1.Order.class,
            com.google.cloud.commerce.consumer.procurement.v1.Order.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the order.
   * Has the form
   * `billingAccounts/{billing_account}/orders/{order}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the order.
   * Has the form
   * `billingAccounts/{billing_account}/orders/{order}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The user-specified name of the order.
   * </pre>
   *
   * <code>string display_name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The user-specified name of the order.
   * </pre>
   *
   * <code>string display_name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LINE_ITEMS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.commerce.consumer.procurement.v1.LineItem> lineItems_;
  /**
   *
   *
   * <pre>
   * Output only. The items being purchased.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.commerce.consumer.procurement.v1.LineItem>
      getLineItemsList() {
    return lineItems_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The items being purchased.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.commerce.consumer.procurement.v1.LineItemOrBuilder>
      getLineItemsOrBuilderList() {
    return lineItems_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The items being purchased.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getLineItemsCount() {
    return lineItems_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The items being purchased.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItem getLineItems(int index) {
    return lineItems_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The items being purchased.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItemOrBuilder getLineItemsOrBuilder(
      int index) {
    return lineItems_.get(index);
  }

  public static final int CANCELLED_LINE_ITEMS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.commerce.consumer.procurement.v1.LineItem>
      cancelledLineItems_;
  /**
   *
   *
   * <pre>
   * Output only. Line items that were cancelled.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.commerce.consumer.procurement.v1.LineItem>
      getCancelledLineItemsList() {
    return cancelledLineItems_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Line items that were cancelled.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.commerce.consumer.procurement.v1.LineItemOrBuilder>
      getCancelledLineItemsOrBuilderList() {
    return cancelledLineItems_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Line items that were cancelled.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getCancelledLineItemsCount() {
    return cancelledLineItems_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Line items that were cancelled.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItem getCancelledLineItems(
      int index) {
    return cancelledLineItems_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Line items that were cancelled.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItemOrBuilder
      getCancelledLineItemsOrBuilder(int index) {
    return cancelledLineItems_.get(index);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int ETAG_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * The weak etag of the order.
   * </pre>
   *
   * <code>string etag = 11;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The weak etag of the order.
   * </pre>
   *
   * <code>string etag = 11;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < lineItems_.size(); i++) {
      output.writeMessage(6, lineItems_.get(i));
    }
    for (int i = 0; i < cancelledLineItems_.size(); i++) {
      output.writeMessage(7, cancelledLineItems_.get(i));
    }
    if (createTime_ != null) {
      output.writeMessage(8, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(9, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, etag_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (int i = 0; i < lineItems_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, lineItems_.get(i));
    }
    for (int i = 0; i < cancelledLineItems_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(7, cancelledLineItems_.get(i));
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, etag_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.commerce.consumer.procurement.v1.Order)) {
      return super.equals(obj);
    }
    com.google.cloud.commerce.consumer.procurement.v1.Order other =
        (com.google.cloud.commerce.consumer.procurement.v1.Order) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getLineItemsList().equals(other.getLineItemsList())) return false;
    if (!getCancelledLineItemsList().equals(other.getCancelledLineItemsList())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (getLineItemsCount() > 0) {
      hash = (37 * hash) + LINE_ITEMS_FIELD_NUMBER;
      hash = (53 * hash) + getLineItemsList().hashCode();
    }
    if (getCancelledLineItemsCount() > 0) {
      hash = (37 * hash) + CANCELLED_LINE_ITEMS_FIELD_NUMBER;
      hash = (53 * hash) + getCancelledLineItemsList().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.Order parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.Order parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.Order parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.Order parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.Order parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.Order parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.Order parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.Order parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.Order parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.Order parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.Order parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.Order parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.commerce.consumer.procurement.v1.Order prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a purchase made by a customer on Cloud Marketplace.
   * Creating an order makes sure that both the Google backend systems
   * as well as external service provider's systems (if needed) allow use of
   * purchased products and ensures the appropriate billing events occur.
   *
   * An Order can be made against one Product with multiple add-ons (optional) or
   * one Quote which might reference multiple products.
   *
   * Customers typically choose a price plan for each Product purchased when
   * they create an order and can change their plan later, if the product allows.
   * </pre>
   *
   * Protobuf type {@code google.cloud.commerce.consumer.procurement.v1.Order}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.commerce.consumer.procurement.v1.Order)
      com.google.cloud.commerce.consumer.procurement.v1.OrderOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.commerce.consumer.procurement.v1.OrderOuterClass
          .internal_static_google_cloud_commerce_consumer_procurement_v1_Order_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.commerce.consumer.procurement.v1.OrderOuterClass
          .internal_static_google_cloud_commerce_consumer_procurement_v1_Order_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.commerce.consumer.procurement.v1.Order.class,
              com.google.cloud.commerce.consumer.procurement.v1.Order.Builder.class);
    }

    // Construct using com.google.cloud.commerce.consumer.procurement.v1.Order.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      if (lineItemsBuilder_ == null) {
        lineItems_ = java.util.Collections.emptyList();
      } else {
        lineItems_ = null;
        lineItemsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (cancelledLineItemsBuilder_ == null) {
        cancelledLineItems_ = java.util.Collections.emptyList();
      } else {
        cancelledLineItems_ = null;
        cancelledLineItemsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      etag_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.commerce.consumer.procurement.v1.OrderOuterClass
          .internal_static_google_cloud_commerce_consumer_procurement_v1_Order_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.commerce.consumer.procurement.v1.Order getDefaultInstanceForType() {
      return com.google.cloud.commerce.consumer.procurement.v1.Order.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.commerce.consumer.procurement.v1.Order build() {
      com.google.cloud.commerce.consumer.procurement.v1.Order result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.commerce.consumer.procurement.v1.Order buildPartial() {
      com.google.cloud.commerce.consumer.procurement.v1.Order result =
          new com.google.cloud.commerce.consumer.procurement.v1.Order(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.commerce.consumer.procurement.v1.Order result) {
      if (lineItemsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          lineItems_ = java.util.Collections.unmodifiableList(lineItems_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.lineItems_ = lineItems_;
      } else {
        result.lineItems_ = lineItemsBuilder_.build();
      }
      if (cancelledLineItemsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          cancelledLineItems_ = java.util.Collections.unmodifiableList(cancelledLineItems_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.cancelledLineItems_ = cancelledLineItems_;
      } else {
        result.cancelledLineItems_ = cancelledLineItemsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.commerce.consumer.procurement.v1.Order result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.etag_ = etag_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.commerce.consumer.procurement.v1.Order) {
        return mergeFrom((com.google.cloud.commerce.consumer.procurement.v1.Order) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.commerce.consumer.procurement.v1.Order other) {
      if (other == com.google.cloud.commerce.consumer.procurement.v1.Order.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (lineItemsBuilder_ == null) {
        if (!other.lineItems_.isEmpty()) {
          if (lineItems_.isEmpty()) {
            lineItems_ = other.lineItems_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureLineItemsIsMutable();
            lineItems_.addAll(other.lineItems_);
          }
          onChanged();
        }
      } else {
        if (!other.lineItems_.isEmpty()) {
          if (lineItemsBuilder_.isEmpty()) {
            lineItemsBuilder_.dispose();
            lineItemsBuilder_ = null;
            lineItems_ = other.lineItems_;
            bitField0_ = (bitField0_ & ~0x00000004);
            lineItemsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLineItemsFieldBuilder()
                    : null;
          } else {
            lineItemsBuilder_.addAllMessages(other.lineItems_);
          }
        }
      }
      if (cancelledLineItemsBuilder_ == null) {
        if (!other.cancelledLineItems_.isEmpty()) {
          if (cancelledLineItems_.isEmpty()) {
            cancelledLineItems_ = other.cancelledLineItems_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureCancelledLineItemsIsMutable();
            cancelledLineItems_.addAll(other.cancelledLineItems_);
          }
          onChanged();
        }
      } else {
        if (!other.cancelledLineItems_.isEmpty()) {
          if (cancelledLineItemsBuilder_.isEmpty()) {
            cancelledLineItemsBuilder_.dispose();
            cancelledLineItemsBuilder_ = null;
            cancelledLineItems_ = other.cancelledLineItems_;
            bitField0_ = (bitField0_ & ~0x00000008);
            cancelledLineItemsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCancelledLineItemsFieldBuilder()
                    : null;
          } else {
            cancelledLineItemsBuilder_.addAllMessages(other.cancelledLineItems_);
          }
        }
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 50:
              {
                com.google.cloud.commerce.consumer.procurement.v1.LineItem m =
                    input.readMessage(
                        com.google.cloud.commerce.consumer.procurement.v1.LineItem.parser(),
                        extensionRegistry);
                if (lineItemsBuilder_ == null) {
                  ensureLineItemsIsMutable();
                  lineItems_.add(m);
                } else {
                  lineItemsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                com.google.cloud.commerce.consumer.procurement.v1.LineItem m =
                    input.readMessage(
                        com.google.cloud.commerce.consumer.procurement.v1.LineItem.parser(),
                        extensionRegistry);
                if (cancelledLineItemsBuilder_ == null) {
                  ensureCancelledLineItemsIsMutable();
                  cancelledLineItems_.add(m);
                } else {
                  cancelledLineItemsBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 74
            case 82:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 82
            case 90:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the order.
     * Has the form
     * `billingAccounts/{billing_account}/orders/{order}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the order.
     * Has the form
     * `billingAccounts/{billing_account}/orders/{order}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the order.
     * Has the form
     * `billingAccounts/{billing_account}/orders/{order}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the order.
     * Has the form
     * `billingAccounts/{billing_account}/orders/{order}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the order.
     * Has the form
     * `billingAccounts/{billing_account}/orders/{order}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The user-specified name of the order.
     * </pre>
     *
     * <code>string display_name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The user-specified name of the order.
     * </pre>
     *
     * <code>string display_name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The user-specified name of the order.
     * </pre>
     *
     * <code>string display_name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The user-specified name of the order.
     * </pre>
     *
     * <code>string display_name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The user-specified name of the order.
     * </pre>
     *
     * <code>string display_name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.commerce.consumer.procurement.v1.LineItem> lineItems_ =
        java.util.Collections.emptyList();

    private void ensureLineItemsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        lineItems_ =
            new java.util.ArrayList<com.google.cloud.commerce.consumer.procurement.v1.LineItem>(
                lineItems_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.commerce.consumer.procurement.v1.LineItem,
            com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemOrBuilder>
        lineItemsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The items being purchased.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.commerce.consumer.procurement.v1.LineItem>
        getLineItemsList() {
      if (lineItemsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(lineItems_);
      } else {
        return lineItemsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The items being purchased.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getLineItemsCount() {
      if (lineItemsBuilder_ == null) {
        return lineItems_.size();
      } else {
        return lineItemsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The items being purchased.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItem getLineItems(int index) {
      if (lineItemsBuilder_ == null) {
        return lineItems_.get(index);
      } else {
        return lineItemsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The items being purchased.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLineItems(
        int index, com.google.cloud.commerce.consumer.procurement.v1.LineItem value) {
      if (lineItemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLineItemsIsMutable();
        lineItems_.set(index, value);
        onChanged();
      } else {
        lineItemsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The items being purchased.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLineItems(
        int index,
        com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder builderForValue) {
      if (lineItemsBuilder_ == null) {
        ensureLineItemsIsMutable();
        lineItems_.set(index, builderForValue.build());
        onChanged();
      } else {
        lineItemsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The items being purchased.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addLineItems(com.google.cloud.commerce.consumer.procurement.v1.LineItem value) {
      if (lineItemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLineItemsIsMutable();
        lineItems_.add(value);
        onChanged();
      } else {
        lineItemsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The items being purchased.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addLineItems(
        int index, com.google.cloud.commerce.consumer.procurement.v1.LineItem value) {
      if (lineItemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLineItemsIsMutable();
        lineItems_.add(index, value);
        onChanged();
      } else {
        lineItemsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The items being purchased.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addLineItems(
        com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder builderForValue) {
      if (lineItemsBuilder_ == null) {
        ensureLineItemsIsMutable();
        lineItems_.add(builderForValue.build());
        onChanged();
      } else {
        lineItemsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The items being purchased.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addLineItems(
        int index,
        com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder builderForValue) {
      if (lineItemsBuilder_ == null) {
        ensureLineItemsIsMutable();
        lineItems_.add(index, builderForValue.build());
        onChanged();
      } else {
        lineItemsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The items being purchased.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllLineItems(
        java.lang.Iterable<? extends com.google.cloud.commerce.consumer.procurement.v1.LineItem>
            values) {
      if (lineItemsBuilder_ == null) {
        ensureLineItemsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, lineItems_);
        onChanged();
      } else {
        lineItemsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The items being purchased.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLineItems() {
      if (lineItemsBuilder_ == null) {
        lineItems_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        lineItemsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The items being purchased.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeLineItems(int index) {
      if (lineItemsBuilder_ == null) {
        ensureLineItemsIsMutable();
        lineItems_.remove(index);
        onChanged();
      } else {
        lineItemsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The items being purchased.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder getLineItemsBuilder(
        int index) {
      return getLineItemsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The items being purchased.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemOrBuilder
        getLineItemsOrBuilder(int index) {
      if (lineItemsBuilder_ == null) {
        return lineItems_.get(index);
      } else {
        return lineItemsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The items being purchased.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.commerce.consumer.procurement.v1.LineItemOrBuilder>
        getLineItemsOrBuilderList() {
      if (lineItemsBuilder_ != null) {
        return lineItemsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(lineItems_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The items being purchased.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder
        addLineItemsBuilder() {
      return getLineItemsFieldBuilder()
          .addBuilder(
              com.google.cloud.commerce.consumer.procurement.v1.LineItem.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The items being purchased.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder addLineItemsBuilder(
        int index) {
      return getLineItemsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.commerce.consumer.procurement.v1.LineItem.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The items being purchased.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder>
        getLineItemsBuilderList() {
      return getLineItemsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.commerce.consumer.procurement.v1.LineItem,
            com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemOrBuilder>
        getLineItemsFieldBuilder() {
      if (lineItemsBuilder_ == null) {
        lineItemsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.commerce.consumer.procurement.v1.LineItem,
                com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder,
                com.google.cloud.commerce.consumer.procurement.v1.LineItemOrBuilder>(
                lineItems_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        lineItems_ = null;
      }
      return lineItemsBuilder_;
    }

    private java.util.List<com.google.cloud.commerce.consumer.procurement.v1.LineItem>
        cancelledLineItems_ = java.util.Collections.emptyList();

    private void ensureCancelledLineItemsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        cancelledLineItems_ =
            new java.util.ArrayList<com.google.cloud.commerce.consumer.procurement.v1.LineItem>(
                cancelledLineItems_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.commerce.consumer.procurement.v1.LineItem,
            com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemOrBuilder>
        cancelledLineItemsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Line items that were cancelled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.commerce.consumer.procurement.v1.LineItem>
        getCancelledLineItemsList() {
      if (cancelledLineItemsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(cancelledLineItems_);
      } else {
        return cancelledLineItemsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Line items that were cancelled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getCancelledLineItemsCount() {
      if (cancelledLineItemsBuilder_ == null) {
        return cancelledLineItems_.size();
      } else {
        return cancelledLineItemsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Line items that were cancelled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItem getCancelledLineItems(
        int index) {
      if (cancelledLineItemsBuilder_ == null) {
        return cancelledLineItems_.get(index);
      } else {
        return cancelledLineItemsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Line items that were cancelled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCancelledLineItems(
        int index, com.google.cloud.commerce.consumer.procurement.v1.LineItem value) {
      if (cancelledLineItemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCancelledLineItemsIsMutable();
        cancelledLineItems_.set(index, value);
        onChanged();
      } else {
        cancelledLineItemsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Line items that were cancelled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCancelledLineItems(
        int index,
        com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder builderForValue) {
      if (cancelledLineItemsBuilder_ == null) {
        ensureCancelledLineItemsIsMutable();
        cancelledLineItems_.set(index, builderForValue.build());
        onChanged();
      } else {
        cancelledLineItemsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Line items that were cancelled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCancelledLineItems(
        com.google.cloud.commerce.consumer.procurement.v1.LineItem value) {
      if (cancelledLineItemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCancelledLineItemsIsMutable();
        cancelledLineItems_.add(value);
        onChanged();
      } else {
        cancelledLineItemsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Line items that were cancelled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCancelledLineItems(
        int index, com.google.cloud.commerce.consumer.procurement.v1.LineItem value) {
      if (cancelledLineItemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCancelledLineItemsIsMutable();
        cancelledLineItems_.add(index, value);
        onChanged();
      } else {
        cancelledLineItemsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Line items that were cancelled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCancelledLineItems(
        com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder builderForValue) {
      if (cancelledLineItemsBuilder_ == null) {
        ensureCancelledLineItemsIsMutable();
        cancelledLineItems_.add(builderForValue.build());
        onChanged();
      } else {
        cancelledLineItemsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Line items that were cancelled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCancelledLineItems(
        int index,
        com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder builderForValue) {
      if (cancelledLineItemsBuilder_ == null) {
        ensureCancelledLineItemsIsMutable();
        cancelledLineItems_.add(index, builderForValue.build());
        onChanged();
      } else {
        cancelledLineItemsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Line items that were cancelled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllCancelledLineItems(
        java.lang.Iterable<? extends com.google.cloud.commerce.consumer.procurement.v1.LineItem>
            values) {
      if (cancelledLineItemsBuilder_ == null) {
        ensureCancelledLineItemsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, cancelledLineItems_);
        onChanged();
      } else {
        cancelledLineItemsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Line items that were cancelled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCancelledLineItems() {
      if (cancelledLineItemsBuilder_ == null) {
        cancelledLineItems_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        cancelledLineItemsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Line items that were cancelled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeCancelledLineItems(int index) {
      if (cancelledLineItemsBuilder_ == null) {
        ensureCancelledLineItemsIsMutable();
        cancelledLineItems_.remove(index);
        onChanged();
      } else {
        cancelledLineItemsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Line items that were cancelled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder
        getCancelledLineItemsBuilder(int index) {
      return getCancelledLineItemsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Line items that were cancelled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemOrBuilder
        getCancelledLineItemsOrBuilder(int index) {
      if (cancelledLineItemsBuilder_ == null) {
        return cancelledLineItems_.get(index);
      } else {
        return cancelledLineItemsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Line items that were cancelled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.commerce.consumer.procurement.v1.LineItemOrBuilder>
        getCancelledLineItemsOrBuilderList() {
      if (cancelledLineItemsBuilder_ != null) {
        return cancelledLineItemsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(cancelledLineItems_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Line items that were cancelled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder
        addCancelledLineItemsBuilder() {
      return getCancelledLineItemsFieldBuilder()
          .addBuilder(
              com.google.cloud.commerce.consumer.procurement.v1.LineItem.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Line items that were cancelled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder
        addCancelledLineItemsBuilder(int index) {
      return getCancelledLineItemsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.commerce.consumer.procurement.v1.LineItem.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Line items that were cancelled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder>
        getCancelledLineItemsBuilderList() {
      return getCancelledLineItemsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.commerce.consumer.procurement.v1.LineItem,
            com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemOrBuilder>
        getCancelledLineItemsFieldBuilder() {
      if (cancelledLineItemsBuilder_ == null) {
        cancelledLineItemsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.commerce.consumer.procurement.v1.LineItem,
                com.google.cloud.commerce.consumer.procurement.v1.LineItem.Builder,
                com.google.cloud.commerce.consumer.procurement.v1.LineItemOrBuilder>(
                cancelledLineItems_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        cancelledLineItems_ = null;
      }
      return cancelledLineItemsBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * The weak etag of the order.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The weak etag of the order.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The weak etag of the order.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The weak etag of the order.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The weak etag of the order.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.commerce.consumer.procurement.v1.Order)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.commerce.consumer.procurement.v1.Order)
  private static final com.google.cloud.commerce.consumer.procurement.v1.Order DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.commerce.consumer.procurement.v1.Order();
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.Order getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Order> PARSER =
      new com.google.protobuf.AbstractParser<Order>() {
        @java.lang.Override
        public Order parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Order> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Order> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.Order getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
