/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/commerce/consumer/procurement/v1/procurement_service.proto

package com.google.cloud.commerce.consumer.procurement.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [ConsumerProcurementService.PlaceOrder][google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService.PlaceOrder].
 * </pre>
 *
 * Protobuf type {@code google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest}
 */
public final class PlaceOrderRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest)
    PlaceOrderRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PlaceOrderRequest.newBuilder() to construct.
  private PlaceOrderRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PlaceOrderRequest() {
    parent_ = "";
    displayName_ = "";
    lineItemInfo_ = java.util.Collections.emptyList();
    requestId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PlaceOrderRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.commerce.consumer.procurement.v1.ProcurementService
        .internal_static_google_cloud_commerce_consumer_procurement_v1_PlaceOrderRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.commerce.consumer.procurement.v1.ProcurementService
        .internal_static_google_cloud_commerce_consumer_procurement_v1_PlaceOrderRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest.class,
            com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the parent resource.
   * This field has the form  `billingAccounts/{billing-account-id}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the parent resource.
   * This field has the form  `billingAccounts/{billing-account-id}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The user-specified name of the order being placed.
   * </pre>
   *
   * <code>string display_name = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The user-specified name of the order being placed.
   * </pre>
   *
   * <code>string display_name = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LINE_ITEM_INFO_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo>
      lineItemInfo_;
  /**
   *
   *
   * <pre>
   * Optional. Places order for offer. Required when an offer-based order is
   * being placed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo>
      getLineItemInfoList() {
    return lineItemInfo_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Places order for offer. Required when an offer-based order is
   * being placed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder>
      getLineItemInfoOrBuilderList() {
    return lineItemInfo_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Places order for offer. Required when an offer-based order is
   * being placed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getLineItemInfoCount() {
    return lineItemInfo_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Places order for offer. Required when an offer-based order is
   * being placed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo getLineItemInfo(int index) {
    return lineItemInfo_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Places order for offer. Required when an offer-based order is
   * being placed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder
      getLineItemInfoOrBuilder(int index) {
    return lineItemInfo_.get(index);
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for this request.
   * The server will ignore subsequent requests that provide a duplicate request
   * ID for at least 120 minutes after the first request.
   *
   * The request ID must be a valid
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
   * </pre>
   *
   * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for this request.
   * The server will ignore subsequent requests that provide a duplicate request
   * ID for at least 120 minutes after the first request.
   *
   * The request ID must be a valid
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
   * </pre>
   *
   * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, requestId_);
    }
    for (int i = 0; i < lineItemInfo_.size(); i++) {
      output.writeMessage(10, lineItemInfo_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, requestId_);
    }
    for (int i = 0; i < lineItemInfo_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, lineItemInfo_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest other =
        (com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getLineItemInfoList().equals(other.getLineItemInfoList())) return false;
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (getLineItemInfoCount() > 0) {
      hash = (37 * hash) + LINE_ITEM_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getLineItemInfoList().hashCode();
    }
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [ConsumerProcurementService.PlaceOrder][google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService.PlaceOrder].
   * </pre>
   *
   * Protobuf type {@code google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest)
      com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.commerce.consumer.procurement.v1.ProcurementService
          .internal_static_google_cloud_commerce_consumer_procurement_v1_PlaceOrderRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.commerce.consumer.procurement.v1.ProcurementService
          .internal_static_google_cloud_commerce_consumer_procurement_v1_PlaceOrderRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest.class,
              com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      displayName_ = "";
      if (lineItemInfoBuilder_ == null) {
        lineItemInfo_ = java.util.Collections.emptyList();
      } else {
        lineItemInfo_ = null;
        lineItemInfoBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      requestId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.commerce.consumer.procurement.v1.ProcurementService
          .internal_static_google_cloud_commerce_consumer_procurement_v1_PlaceOrderRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest
        getDefaultInstanceForType() {
      return com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest build() {
      com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest buildPartial() {
      com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest result =
          new com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest result) {
      if (lineItemInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          lineItemInfo_ = java.util.Collections.unmodifiableList(lineItemInfo_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.lineItemInfo_ = lineItemInfo_;
      } else {
        result.lineItemInfo_ = lineItemInfoBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.requestId_ = requestId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest) {
        return mergeFrom(
            (com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest other) {
      if (other
          == com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest
              .getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (lineItemInfoBuilder_ == null) {
        if (!other.lineItemInfo_.isEmpty()) {
          if (lineItemInfo_.isEmpty()) {
            lineItemInfo_ = other.lineItemInfo_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureLineItemInfoIsMutable();
            lineItemInfo_.addAll(other.lineItemInfo_);
          }
          onChanged();
        }
      } else {
        if (!other.lineItemInfo_.isEmpty()) {
          if (lineItemInfoBuilder_.isEmpty()) {
            lineItemInfoBuilder_.dispose();
            lineItemInfoBuilder_ = null;
            lineItemInfo_ = other.lineItemInfo_;
            bitField0_ = (bitField0_ & ~0x00000004);
            lineItemInfoBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLineItemInfoFieldBuilder()
                    : null;
          } else {
            lineItemInfoBuilder_.addAllMessages(other.lineItemInfo_);
          }
        }
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 50:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 50
            case 58:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 58
            case 82:
              {
                com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo m =
                    input.readMessage(
                        com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.parser(),
                        extensionRegistry);
                if (lineItemInfoBuilder_ == null) {
                  ensureLineItemInfoIsMutable();
                  lineItemInfo_.add(m);
                } else {
                  lineItemInfoBuilder_.addMessage(m);
                }
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the parent resource.
     * This field has the form  `billingAccounts/{billing-account-id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the parent resource.
     * This field has the form  `billingAccounts/{billing-account-id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the parent resource.
     * This field has the form  `billingAccounts/{billing-account-id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the parent resource.
     * This field has the form  `billingAccounts/{billing-account-id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the parent resource.
     * This field has the form  `billingAccounts/{billing-account-id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The user-specified name of the order being placed.
     * </pre>
     *
     * <code>string display_name = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The user-specified name of the order being placed.
     * </pre>
     *
     * <code>string display_name = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The user-specified name of the order being placed.
     * </pre>
     *
     * <code>string display_name = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The user-specified name of the order being placed.
     * </pre>
     *
     * <code>string display_name = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The user-specified name of the order being placed.
     * </pre>
     *
     * <code>string display_name = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo>
        lineItemInfo_ = java.util.Collections.emptyList();

    private void ensureLineItemInfoIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        lineItemInfo_ =
            new java.util.ArrayList<com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo>(
                lineItemInfo_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder>
        lineItemInfoBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Places order for offer. Required when an offer-based order is
     * being placed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo>
        getLineItemInfoList() {
      if (lineItemInfoBuilder_ == null) {
        return java.util.Collections.unmodifiableList(lineItemInfo_);
      } else {
        return lineItemInfoBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Places order for offer. Required when an offer-based order is
     * being placed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getLineItemInfoCount() {
      if (lineItemInfoBuilder_ == null) {
        return lineItemInfo_.size();
      } else {
        return lineItemInfoBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Places order for offer. Required when an offer-based order is
     * being placed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo getLineItemInfo(
        int index) {
      if (lineItemInfoBuilder_ == null) {
        return lineItemInfo_.get(index);
      } else {
        return lineItemInfoBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Places order for offer. Required when an offer-based order is
     * being placed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLineItemInfo(
        int index, com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo value) {
      if (lineItemInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLineItemInfoIsMutable();
        lineItemInfo_.set(index, value);
        onChanged();
      } else {
        lineItemInfoBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Places order for offer. Required when an offer-based order is
     * being placed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLineItemInfo(
        int index,
        com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder builderForValue) {
      if (lineItemInfoBuilder_ == null) {
        ensureLineItemInfoIsMutable();
        lineItemInfo_.set(index, builderForValue.build());
        onChanged();
      } else {
        lineItemInfoBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Places order for offer. Required when an offer-based order is
     * being placed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addLineItemInfo(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo value) {
      if (lineItemInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLineItemInfoIsMutable();
        lineItemInfo_.add(value);
        onChanged();
      } else {
        lineItemInfoBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Places order for offer. Required when an offer-based order is
     * being placed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addLineItemInfo(
        int index, com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo value) {
      if (lineItemInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLineItemInfoIsMutable();
        lineItemInfo_.add(index, value);
        onChanged();
      } else {
        lineItemInfoBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Places order for offer. Required when an offer-based order is
     * being placed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addLineItemInfo(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder builderForValue) {
      if (lineItemInfoBuilder_ == null) {
        ensureLineItemInfoIsMutable();
        lineItemInfo_.add(builderForValue.build());
        onChanged();
      } else {
        lineItemInfoBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Places order for offer. Required when an offer-based order is
     * being placed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addLineItemInfo(
        int index,
        com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder builderForValue) {
      if (lineItemInfoBuilder_ == null) {
        ensureLineItemInfoIsMutable();
        lineItemInfo_.add(index, builderForValue.build());
        onChanged();
      } else {
        lineItemInfoBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Places order for offer. Required when an offer-based order is
     * being placed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllLineItemInfo(
        java.lang.Iterable<? extends com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo>
            values) {
      if (lineItemInfoBuilder_ == null) {
        ensureLineItemInfoIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, lineItemInfo_);
        onChanged();
      } else {
        lineItemInfoBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Places order for offer. Required when an offer-based order is
     * being placed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearLineItemInfo() {
      if (lineItemInfoBuilder_ == null) {
        lineItemInfo_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        lineItemInfoBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Places order for offer. Required when an offer-based order is
     * being placed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeLineItemInfo(int index) {
      if (lineItemInfoBuilder_ == null) {
        ensureLineItemInfoIsMutable();
        lineItemInfo_.remove(index);
        onChanged();
      } else {
        lineItemInfoBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Places order for offer. Required when an offer-based order is
     * being placed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder
        getLineItemInfoBuilder(int index) {
      return getLineItemInfoFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Places order for offer. Required when an offer-based order is
     * being placed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder
        getLineItemInfoOrBuilder(int index) {
      if (lineItemInfoBuilder_ == null) {
        return lineItemInfo_.get(index);
      } else {
        return lineItemInfoBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Places order for offer. Required when an offer-based order is
     * being placed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder>
        getLineItemInfoOrBuilderList() {
      if (lineItemInfoBuilder_ != null) {
        return lineItemInfoBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(lineItemInfo_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Places order for offer. Required when an offer-based order is
     * being placed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder
        addLineItemInfoBuilder() {
      return getLineItemInfoFieldBuilder()
          .addBuilder(
              com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Places order for offer. Required when an offer-based order is
     * being placed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder
        addLineItemInfoBuilder(int index) {
      return getLineItemInfoFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Places order for offer. Required when an offer-based order is
     * being placed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.LineItemInfo line_item_info = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder>
        getLineItemInfoBuilderList() {
      return getLineItemInfoFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder>
        getLineItemInfoFieldBuilder() {
      if (lineItemInfoBuilder_ == null) {
        lineItemInfoBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo,
                com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder,
                com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder>(
                lineItemInfo_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        lineItemInfo_ = null;
      }
      return lineItemInfoBuilder_;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request.
     * The server will ignore subsequent requests that provide a duplicate request
     * ID for at least 120 minutes after the first request.
     *
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
     * </pre>
     *
     * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request.
     * The server will ignore subsequent requests that provide a duplicate request
     * ID for at least 120 minutes after the first request.
     *
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
     * </pre>
     *
     * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request.
     * The server will ignore subsequent requests that provide a duplicate request
     * ID for at least 120 minutes after the first request.
     *
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
     * </pre>
     *
     * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request.
     * The server will ignore subsequent requests that provide a duplicate request
     * ID for at least 120 minutes after the first request.
     *
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
     * </pre>
     *
     * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request.
     * The server will ignore subsequent requests that provide a duplicate request
     * ID for at least 120 minutes after the first request.
     *
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
     * </pre>
     *
     * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest)
  private static final com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest();
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PlaceOrderRequest> PARSER =
      new com.google.protobuf.AbstractParser<PlaceOrderRequest>() {
        @java.lang.Override
        public PlaceOrderRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PlaceOrderRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PlaceOrderRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
