/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/commerce/consumer/procurement/v1/order.proto

package com.google.cloud.commerce.consumer.procurement.v1;

/**
 *
 *
 * <pre>
 * A change made on a line item.
 * </pre>
 *
 * Protobuf type {@code google.cloud.commerce.consumer.procurement.v1.LineItemChange}
 */
public final class LineItemChange extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.commerce.consumer.procurement.v1.LineItemChange)
    LineItemChangeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LineItemChange.newBuilder() to construct.
  private LineItemChange(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LineItemChange() {
    changeId_ = "";
    changeType_ = 0;
    changeState_ = 0;
    stateReason_ = "";
    changeStateReasonType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LineItemChange();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.commerce.consumer.procurement.v1.OrderOuterClass
        .internal_static_google_cloud_commerce_consumer_procurement_v1_LineItemChange_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.commerce.consumer.procurement.v1.OrderOuterClass
        .internal_static_google_cloud_commerce_consumer_procurement_v1_LineItemChange_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.class,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.Builder.class);
  }

  public static final int CHANGE_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object changeId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Change ID.
   * All changes made within one order update operation have the same change_id.
   * </pre>
   *
   * <code>string change_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The changeId.
   */
  @java.lang.Override
  public java.lang.String getChangeId() {
    java.lang.Object ref = changeId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      changeId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Change ID.
   * All changes made within one order update operation have the same change_id.
   * </pre>
   *
   * <code>string change_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for changeId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getChangeIdBytes() {
    java.lang.Object ref = changeId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      changeId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CHANGE_TYPE_FIELD_NUMBER = 2;
  private int changeType_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Type of the change to make.
   * </pre>
   *
   * <code>
   * .google.cloud.commerce.consumer.procurement.v1.LineItemChangeType change_type = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for changeType.
   */
  @java.lang.Override
  public int getChangeTypeValue() {
    return changeType_;
  }
  /**
   *
   *
   * <pre>
   * Required. Type of the change to make.
   * </pre>
   *
   * <code>
   * .google.cloud.commerce.consumer.procurement.v1.LineItemChangeType change_type = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The changeType.
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeType getChangeType() {
    com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeType result =
        com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeType.forNumber(changeType_);
    return result == null
        ? com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeType.UNRECOGNIZED
        : result;
  }

  public static final int OLD_LINE_ITEM_INFO_FIELD_NUMBER = 3;
  private com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo oldLineItemInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Line item info before the change.
   * </pre>
   *
   * <code>
   * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo old_line_item_info = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the oldLineItemInfo field is set.
   */
  @java.lang.Override
  public boolean hasOldLineItemInfo() {
    return oldLineItemInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Line item info before the change.
   * </pre>
   *
   * <code>
   * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo old_line_item_info = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The oldLineItemInfo.
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo getOldLineItemInfo() {
    return oldLineItemInfo_ == null
        ? com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.getDefaultInstance()
        : oldLineItemInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Line item info before the change.
   * </pre>
   *
   * <code>
   * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo old_line_item_info = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder
      getOldLineItemInfoOrBuilder() {
    return oldLineItemInfo_ == null
        ? com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.getDefaultInstance()
        : oldLineItemInfo_;
  }

  public static final int NEW_LINE_ITEM_INFO_FIELD_NUMBER = 4;
  private com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo newLineItemInfo_;
  /**
   *
   *
   * <pre>
   * Line item info after the change.
   * </pre>
   *
   * <code>.google.cloud.commerce.consumer.procurement.v1.LineItemInfo new_line_item_info = 4;
   * </code>
   *
   * @return Whether the newLineItemInfo field is set.
   */
  @java.lang.Override
  public boolean hasNewLineItemInfo() {
    return newLineItemInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Line item info after the change.
   * </pre>
   *
   * <code>.google.cloud.commerce.consumer.procurement.v1.LineItemInfo new_line_item_info = 4;
   * </code>
   *
   * @return The newLineItemInfo.
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo getNewLineItemInfo() {
    return newLineItemInfo_ == null
        ? com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.getDefaultInstance()
        : newLineItemInfo_;
  }
  /**
   *
   *
   * <pre>
   * Line item info after the change.
   * </pre>
   *
   * <code>.google.cloud.commerce.consumer.procurement.v1.LineItemInfo new_line_item_info = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder
      getNewLineItemInfoOrBuilder() {
    return newLineItemInfo_ == null
        ? com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.getDefaultInstance()
        : newLineItemInfo_;
  }

  public static final int CHANGE_STATE_FIELD_NUMBER = 5;
  private int changeState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. State of the change.
   * </pre>
   *
   * <code>
   * .google.cloud.commerce.consumer.procurement.v1.LineItemChangeState change_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for changeState.
   */
  @java.lang.Override
  public int getChangeStateValue() {
    return changeState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the change.
   * </pre>
   *
   * <code>
   * .google.cloud.commerce.consumer.procurement.v1.LineItemChangeState change_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The changeState.
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeState getChangeState() {
    com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeState result =
        com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeState.forNumber(
            changeState_);
    return result == null
        ? com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeState.UNRECOGNIZED
        : result;
  }

  public static final int STATE_REASON_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object stateReason_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Provider-supplied message explaining the LineItemChange's
   * state. Mainly used to communicate progress and ETA for provisioning in the
   * case of `PENDING_APPROVAL`, and to explain why the change request was
   * denied or canceled in the case of `REJECTED` and `CANCELED` states.
   * </pre>
   *
   * <code>string state_reason = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The stateReason.
   */
  @java.lang.Override
  public java.lang.String getStateReason() {
    java.lang.Object ref = stateReason_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stateReason_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Provider-supplied message explaining the LineItemChange's
   * state. Mainly used to communicate progress and ETA for provisioning in the
   * case of `PENDING_APPROVAL`, and to explain why the change request was
   * denied or canceled in the case of `REJECTED` and `CANCELED` states.
   * </pre>
   *
   * <code>string state_reason = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for stateReason.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateReasonBytes() {
    java.lang.Object ref = stateReason_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stateReason_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CHANGE_STATE_REASON_TYPE_FIELD_NUMBER = 10;
  private int changeStateReasonType_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Predefined enum types for why this line item change is in
   * current state. For example, a line item change's state could be
   * `LINE_ITEM_CHANGE_STATE_COMPLETED` because of end-of-term expiration,
   * immediate cancellation initiated by the user, or system-initiated
   * cancellation.
   * </pre>
   *
   * <code>
   * .google.cloud.commerce.consumer.procurement.v1.LineItemChangeStateReasonType change_state_reason_type = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for changeStateReasonType.
   */
  @java.lang.Override
  public int getChangeStateReasonTypeValue() {
    return changeStateReasonType_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Predefined enum types for why this line item change is in
   * current state. For example, a line item change's state could be
   * `LINE_ITEM_CHANGE_STATE_COMPLETED` because of end-of-term expiration,
   * immediate cancellation initiated by the user, or system-initiated
   * cancellation.
   * </pre>
   *
   * <code>
   * .google.cloud.commerce.consumer.procurement.v1.LineItemChangeStateReasonType change_state_reason_type = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The changeStateReasonType.
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeStateReasonType
      getChangeStateReasonType() {
    com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeStateReasonType result =
        com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeStateReasonType.forNumber(
            changeStateReasonType_);
    return result == null
        ? com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeStateReasonType
            .UNRECOGNIZED
        : result;
  }

  public static final int CHANGE_EFFECTIVE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp changeEffectiveTime_;
  /**
   *
   *
   * <pre>
   * Output only. A time at which the change became or will become (in case of
   * pending change) effective.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp change_effective_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the changeEffectiveTime field is set.
   */
  @java.lang.Override
  public boolean hasChangeEffectiveTime() {
    return changeEffectiveTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. A time at which the change became or will become (in case of
   * pending change) effective.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp change_effective_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The changeEffectiveTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getChangeEffectiveTime() {
    return changeEffectiveTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : changeEffectiveTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A time at which the change became or will become (in case of
   * pending change) effective.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp change_effective_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getChangeEffectiveTimeOrBuilder() {
    return changeEffectiveTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : changeEffectiveTime_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when change was initiated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when change was initiated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when change was initiated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when change was updated, e.g. approved/rejected by
   * partners or cancelled by the user.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when change was updated, e.g. approved/rejected by
   * partners or cancelled by the user.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when change was updated, e.g. approved/rejected by
   * partners or cancelled by the user.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(changeId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, changeId_);
    }
    if (changeType_
        != com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeType
            .LINE_ITEM_CHANGE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, changeType_);
    }
    if (oldLineItemInfo_ != null) {
      output.writeMessage(3, getOldLineItemInfo());
    }
    if (newLineItemInfo_ != null) {
      output.writeMessage(4, getNewLineItemInfo());
    }
    if (changeState_
        != com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeState
            .LINE_ITEM_CHANGE_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, changeState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateReason_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, stateReason_);
    }
    if (changeEffectiveTime_ != null) {
      output.writeMessage(7, getChangeEffectiveTime());
    }
    if (createTime_ != null) {
      output.writeMessage(8, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(9, getUpdateTime());
    }
    if (changeStateReasonType_
        != com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeStateReasonType
            .LINE_ITEM_CHANGE_STATE_REASON_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(10, changeStateReasonType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(changeId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, changeId_);
    }
    if (changeType_
        != com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeType
            .LINE_ITEM_CHANGE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, changeType_);
    }
    if (oldLineItemInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getOldLineItemInfo());
    }
    if (newLineItemInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getNewLineItemInfo());
    }
    if (changeState_
        != com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeState
            .LINE_ITEM_CHANGE_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, changeState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateReason_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, stateReason_);
    }
    if (changeEffectiveTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getChangeEffectiveTime());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getUpdateTime());
    }
    if (changeStateReasonType_
        != com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeStateReasonType
            .LINE_ITEM_CHANGE_STATE_REASON_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, changeStateReasonType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.commerce.consumer.procurement.v1.LineItemChange)) {
      return super.equals(obj);
    }
    com.google.cloud.commerce.consumer.procurement.v1.LineItemChange other =
        (com.google.cloud.commerce.consumer.procurement.v1.LineItemChange) obj;

    if (!getChangeId().equals(other.getChangeId())) return false;
    if (changeType_ != other.changeType_) return false;
    if (hasOldLineItemInfo() != other.hasOldLineItemInfo()) return false;
    if (hasOldLineItemInfo()) {
      if (!getOldLineItemInfo().equals(other.getOldLineItemInfo())) return false;
    }
    if (hasNewLineItemInfo() != other.hasNewLineItemInfo()) return false;
    if (hasNewLineItemInfo()) {
      if (!getNewLineItemInfo().equals(other.getNewLineItemInfo())) return false;
    }
    if (changeState_ != other.changeState_) return false;
    if (!getStateReason().equals(other.getStateReason())) return false;
    if (changeStateReasonType_ != other.changeStateReasonType_) return false;
    if (hasChangeEffectiveTime() != other.hasChangeEffectiveTime()) return false;
    if (hasChangeEffectiveTime()) {
      if (!getChangeEffectiveTime().equals(other.getChangeEffectiveTime())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CHANGE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getChangeId().hashCode();
    hash = (37 * hash) + CHANGE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + changeType_;
    if (hasOldLineItemInfo()) {
      hash = (37 * hash) + OLD_LINE_ITEM_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getOldLineItemInfo().hashCode();
    }
    if (hasNewLineItemInfo()) {
      hash = (37 * hash) + NEW_LINE_ITEM_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getNewLineItemInfo().hashCode();
    }
    hash = (37 * hash) + CHANGE_STATE_FIELD_NUMBER;
    hash = (53 * hash) + changeState_;
    hash = (37 * hash) + STATE_REASON_FIELD_NUMBER;
    hash = (53 * hash) + getStateReason().hashCode();
    hash = (37 * hash) + CHANGE_STATE_REASON_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + changeStateReasonType_;
    if (hasChangeEffectiveTime()) {
      hash = (37 * hash) + CHANGE_EFFECTIVE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getChangeEffectiveTime().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemChange parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemChange parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemChange parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemChange parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemChange parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemChange parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemChange parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemChange parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemChange parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemChange parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemChange parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemChange parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.commerce.consumer.procurement.v1.LineItemChange prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A change made on a line item.
   * </pre>
   *
   * Protobuf type {@code google.cloud.commerce.consumer.procurement.v1.LineItemChange}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.commerce.consumer.procurement.v1.LineItemChange)
      com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.commerce.consumer.procurement.v1.OrderOuterClass
          .internal_static_google_cloud_commerce_consumer_procurement_v1_LineItemChange_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.commerce.consumer.procurement.v1.OrderOuterClass
          .internal_static_google_cloud_commerce_consumer_procurement_v1_LineItemChange_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.class,
              com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.Builder.class);
    }

    // Construct using com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      changeId_ = "";
      changeType_ = 0;
      oldLineItemInfo_ = null;
      if (oldLineItemInfoBuilder_ != null) {
        oldLineItemInfoBuilder_.dispose();
        oldLineItemInfoBuilder_ = null;
      }
      newLineItemInfo_ = null;
      if (newLineItemInfoBuilder_ != null) {
        newLineItemInfoBuilder_.dispose();
        newLineItemInfoBuilder_ = null;
      }
      changeState_ = 0;
      stateReason_ = "";
      changeStateReasonType_ = 0;
      changeEffectiveTime_ = null;
      if (changeEffectiveTimeBuilder_ != null) {
        changeEffectiveTimeBuilder_.dispose();
        changeEffectiveTimeBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.commerce.consumer.procurement.v1.OrderOuterClass
          .internal_static_google_cloud_commerce_consumer_procurement_v1_LineItemChange_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemChange
        getDefaultInstanceForType() {
      return com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemChange build() {
      com.google.cloud.commerce.consumer.procurement.v1.LineItemChange result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemChange buildPartial() {
      com.google.cloud.commerce.consumer.procurement.v1.LineItemChange result =
          new com.google.cloud.commerce.consumer.procurement.v1.LineItemChange(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemChange result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.changeId_ = changeId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.changeType_ = changeType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.oldLineItemInfo_ =
            oldLineItemInfoBuilder_ == null ? oldLineItemInfo_ : oldLineItemInfoBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.newLineItemInfo_ =
            newLineItemInfoBuilder_ == null ? newLineItemInfo_ : newLineItemInfoBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.changeState_ = changeState_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.stateReason_ = stateReason_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.changeStateReasonType_ = changeStateReasonType_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.changeEffectiveTime_ =
            changeEffectiveTimeBuilder_ == null
                ? changeEffectiveTime_
                : changeEffectiveTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.commerce.consumer.procurement.v1.LineItemChange) {
        return mergeFrom((com.google.cloud.commerce.consumer.procurement.v1.LineItemChange) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemChange other) {
      if (other
          == com.google.cloud.commerce.consumer.procurement.v1.LineItemChange.getDefaultInstance())
        return this;
      if (!other.getChangeId().isEmpty()) {
        changeId_ = other.changeId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.changeType_ != 0) {
        setChangeTypeValue(other.getChangeTypeValue());
      }
      if (other.hasOldLineItemInfo()) {
        mergeOldLineItemInfo(other.getOldLineItemInfo());
      }
      if (other.hasNewLineItemInfo()) {
        mergeNewLineItemInfo(other.getNewLineItemInfo());
      }
      if (other.changeState_ != 0) {
        setChangeStateValue(other.getChangeStateValue());
      }
      if (!other.getStateReason().isEmpty()) {
        stateReason_ = other.stateReason_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.changeStateReasonType_ != 0) {
        setChangeStateReasonTypeValue(other.getChangeStateReasonTypeValue());
      }
      if (other.hasChangeEffectiveTime()) {
        mergeChangeEffectiveTime(other.getChangeEffectiveTime());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                changeId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                changeType_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getOldLineItemInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getNewLineItemInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                changeState_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                stateReason_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getChangeEffectiveTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 74
            case 80:
              {
                changeStateReasonType_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 80
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object changeId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Change ID.
     * All changes made within one order update operation have the same change_id.
     * </pre>
     *
     * <code>string change_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The changeId.
     */
    public java.lang.String getChangeId() {
      java.lang.Object ref = changeId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        changeId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Change ID.
     * All changes made within one order update operation have the same change_id.
     * </pre>
     *
     * <code>string change_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for changeId.
     */
    public com.google.protobuf.ByteString getChangeIdBytes() {
      java.lang.Object ref = changeId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        changeId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Change ID.
     * All changes made within one order update operation have the same change_id.
     * </pre>
     *
     * <code>string change_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The changeId to set.
     * @return This builder for chaining.
     */
    public Builder setChangeId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      changeId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Change ID.
     * All changes made within one order update operation have the same change_id.
     * </pre>
     *
     * <code>string change_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChangeId() {
      changeId_ = getDefaultInstance().getChangeId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Change ID.
     * All changes made within one order update operation have the same change_id.
     * </pre>
     *
     * <code>string change_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for changeId to set.
     * @return This builder for chaining.
     */
    public Builder setChangeIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      changeId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int changeType_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Type of the change to make.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChangeType change_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for changeType.
     */
    @java.lang.Override
    public int getChangeTypeValue() {
      return changeType_;
    }
    /**
     *
     *
     * <pre>
     * Required. Type of the change to make.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChangeType change_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for changeType to set.
     * @return This builder for chaining.
     */
    public Builder setChangeTypeValue(int value) {
      changeType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Type of the change to make.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChangeType change_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The changeType.
     */
    @java.lang.Override
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeType getChangeType() {
      com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeType result =
          com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeType.forNumber(
              changeType_);
      return result == null
          ? com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Type of the change to make.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChangeType change_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The changeType to set.
     * @return This builder for chaining.
     */
    public Builder setChangeType(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      changeType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Type of the change to make.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChangeType change_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChangeType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      changeType_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo oldLineItemInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder>
        oldLineItemInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Line item info before the change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo old_line_item_info = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the oldLineItemInfo field is set.
     */
    public boolean hasOldLineItemInfo() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Line item info before the change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo old_line_item_info = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The oldLineItemInfo.
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo getOldLineItemInfo() {
      if (oldLineItemInfoBuilder_ == null) {
        return oldLineItemInfo_ == null
            ? com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.getDefaultInstance()
            : oldLineItemInfo_;
      } else {
        return oldLineItemInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Line item info before the change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo old_line_item_info = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOldLineItemInfo(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo value) {
      if (oldLineItemInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        oldLineItemInfo_ = value;
      } else {
        oldLineItemInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Line item info before the change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo old_line_item_info = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOldLineItemInfo(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder builderForValue) {
      if (oldLineItemInfoBuilder_ == null) {
        oldLineItemInfo_ = builderForValue.build();
      } else {
        oldLineItemInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Line item info before the change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo old_line_item_info = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeOldLineItemInfo(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo value) {
      if (oldLineItemInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && oldLineItemInfo_ != null
            && oldLineItemInfo_
                != com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo
                    .getDefaultInstance()) {
          getOldLineItemInfoBuilder().mergeFrom(value);
        } else {
          oldLineItemInfo_ = value;
        }
      } else {
        oldLineItemInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Line item info before the change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo old_line_item_info = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearOldLineItemInfo() {
      bitField0_ = (bitField0_ & ~0x00000004);
      oldLineItemInfo_ = null;
      if (oldLineItemInfoBuilder_ != null) {
        oldLineItemInfoBuilder_.dispose();
        oldLineItemInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Line item info before the change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo old_line_item_info = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder
        getOldLineItemInfoBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getOldLineItemInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Line item info before the change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo old_line_item_info = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder
        getOldLineItemInfoOrBuilder() {
      if (oldLineItemInfoBuilder_ != null) {
        return oldLineItemInfoBuilder_.getMessageOrBuilder();
      } else {
        return oldLineItemInfo_ == null
            ? com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.getDefaultInstance()
            : oldLineItemInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Line item info before the change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemInfo old_line_item_info = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder>
        getOldLineItemInfoFieldBuilder() {
      if (oldLineItemInfoBuilder_ == null) {
        oldLineItemInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo,
                com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder,
                com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder>(
                getOldLineItemInfo(), getParentForChildren(), isClean());
        oldLineItemInfo_ = null;
      }
      return oldLineItemInfoBuilder_;
    }

    private com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo newLineItemInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder>
        newLineItemInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Line item info after the change.
     * </pre>
     *
     * <code>.google.cloud.commerce.consumer.procurement.v1.LineItemInfo new_line_item_info = 4;
     * </code>
     *
     * @return Whether the newLineItemInfo field is set.
     */
    public boolean hasNewLineItemInfo() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Line item info after the change.
     * </pre>
     *
     * <code>.google.cloud.commerce.consumer.procurement.v1.LineItemInfo new_line_item_info = 4;
     * </code>
     *
     * @return The newLineItemInfo.
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo getNewLineItemInfo() {
      if (newLineItemInfoBuilder_ == null) {
        return newLineItemInfo_ == null
            ? com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.getDefaultInstance()
            : newLineItemInfo_;
      } else {
        return newLineItemInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Line item info after the change.
     * </pre>
     *
     * <code>.google.cloud.commerce.consumer.procurement.v1.LineItemInfo new_line_item_info = 4;
     * </code>
     */
    public Builder setNewLineItemInfo(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo value) {
      if (newLineItemInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        newLineItemInfo_ = value;
      } else {
        newLineItemInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Line item info after the change.
     * </pre>
     *
     * <code>.google.cloud.commerce.consumer.procurement.v1.LineItemInfo new_line_item_info = 4;
     * </code>
     */
    public Builder setNewLineItemInfo(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder builderForValue) {
      if (newLineItemInfoBuilder_ == null) {
        newLineItemInfo_ = builderForValue.build();
      } else {
        newLineItemInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Line item info after the change.
     * </pre>
     *
     * <code>.google.cloud.commerce.consumer.procurement.v1.LineItemInfo new_line_item_info = 4;
     * </code>
     */
    public Builder mergeNewLineItemInfo(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo value) {
      if (newLineItemInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && newLineItemInfo_ != null
            && newLineItemInfo_
                != com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo
                    .getDefaultInstance()) {
          getNewLineItemInfoBuilder().mergeFrom(value);
        } else {
          newLineItemInfo_ = value;
        }
      } else {
        newLineItemInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Line item info after the change.
     * </pre>
     *
     * <code>.google.cloud.commerce.consumer.procurement.v1.LineItemInfo new_line_item_info = 4;
     * </code>
     */
    public Builder clearNewLineItemInfo() {
      bitField0_ = (bitField0_ & ~0x00000008);
      newLineItemInfo_ = null;
      if (newLineItemInfoBuilder_ != null) {
        newLineItemInfoBuilder_.dispose();
        newLineItemInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Line item info after the change.
     * </pre>
     *
     * <code>.google.cloud.commerce.consumer.procurement.v1.LineItemInfo new_line_item_info = 4;
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder
        getNewLineItemInfoBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getNewLineItemInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Line item info after the change.
     * </pre>
     *
     * <code>.google.cloud.commerce.consumer.procurement.v1.LineItemInfo new_line_item_info = 4;
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder
        getNewLineItemInfoOrBuilder() {
      if (newLineItemInfoBuilder_ != null) {
        return newLineItemInfoBuilder_.getMessageOrBuilder();
      } else {
        return newLineItemInfo_ == null
            ? com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.getDefaultInstance()
            : newLineItemInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Line item info after the change.
     * </pre>
     *
     * <code>.google.cloud.commerce.consumer.procurement.v1.LineItemInfo new_line_item_info = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder>
        getNewLineItemInfoFieldBuilder() {
      if (newLineItemInfoBuilder_ == null) {
        newLineItemInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo,
                com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder,
                com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder>(
                getNewLineItemInfo(), getParentForChildren(), isClean());
        newLineItemInfo_ = null;
      }
      return newLineItemInfoBuilder_;
    }

    private int changeState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. State of the change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChangeState change_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for changeState.
     */
    @java.lang.Override
    public int getChangeStateValue() {
      return changeState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChangeState change_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for changeState to set.
     * @return This builder for chaining.
     */
    public Builder setChangeStateValue(int value) {
      changeState_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChangeState change_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The changeState.
     */
    @java.lang.Override
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeState getChangeState() {
      com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeState result =
          com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeState.forNumber(
              changeState_);
      return result == null
          ? com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChangeState change_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The changeState to set.
     * @return This builder for chaining.
     */
    public Builder setChangeState(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      changeState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the change.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChangeState change_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChangeState() {
      bitField0_ = (bitField0_ & ~0x00000010);
      changeState_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object stateReason_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Provider-supplied message explaining the LineItemChange's
     * state. Mainly used to communicate progress and ETA for provisioning in the
     * case of `PENDING_APPROVAL`, and to explain why the change request was
     * denied or canceled in the case of `REJECTED` and `CANCELED` states.
     * </pre>
     *
     * <code>string state_reason = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stateReason.
     */
    public java.lang.String getStateReason() {
      java.lang.Object ref = stateReason_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stateReason_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Provider-supplied message explaining the LineItemChange's
     * state. Mainly used to communicate progress and ETA for provisioning in the
     * case of `PENDING_APPROVAL`, and to explain why the change request was
     * denied or canceled in the case of `REJECTED` and `CANCELED` states.
     * </pre>
     *
     * <code>string state_reason = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stateReason.
     */
    public com.google.protobuf.ByteString getStateReasonBytes() {
      java.lang.Object ref = stateReason_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stateReason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Provider-supplied message explaining the LineItemChange's
     * state. Mainly used to communicate progress and ETA for provisioning in the
     * case of `PENDING_APPROVAL`, and to explain why the change request was
     * denied or canceled in the case of `REJECTED` and `CANCELED` states.
     * </pre>
     *
     * <code>string state_reason = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The stateReason to set.
     * @return This builder for chaining.
     */
    public Builder setStateReason(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      stateReason_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provider-supplied message explaining the LineItemChange's
     * state. Mainly used to communicate progress and ETA for provisioning in the
     * case of `PENDING_APPROVAL`, and to explain why the change request was
     * denied or canceled in the case of `REJECTED` and `CANCELED` states.
     * </pre>
     *
     * <code>string state_reason = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStateReason() {
      stateReason_ = getDefaultInstance().getStateReason();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provider-supplied message explaining the LineItemChange's
     * state. Mainly used to communicate progress and ETA for provisioning in the
     * case of `PENDING_APPROVAL`, and to explain why the change request was
     * denied or canceled in the case of `REJECTED` and `CANCELED` states.
     * </pre>
     *
     * <code>string state_reason = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for stateReason to set.
     * @return This builder for chaining.
     */
    public Builder setStateReasonBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      stateReason_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private int changeStateReasonType_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Predefined enum types for why this line item change is in
     * current state. For example, a line item change's state could be
     * `LINE_ITEM_CHANGE_STATE_COMPLETED` because of end-of-term expiration,
     * immediate cancellation initiated by the user, or system-initiated
     * cancellation.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChangeStateReasonType change_state_reason_type = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for changeStateReasonType.
     */
    @java.lang.Override
    public int getChangeStateReasonTypeValue() {
      return changeStateReasonType_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Predefined enum types for why this line item change is in
     * current state. For example, a line item change's state could be
     * `LINE_ITEM_CHANGE_STATE_COMPLETED` because of end-of-term expiration,
     * immediate cancellation initiated by the user, or system-initiated
     * cancellation.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChangeStateReasonType change_state_reason_type = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for changeStateReasonType to set.
     * @return This builder for chaining.
     */
    public Builder setChangeStateReasonTypeValue(int value) {
      changeStateReasonType_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Predefined enum types for why this line item change is in
     * current state. For example, a line item change's state could be
     * `LINE_ITEM_CHANGE_STATE_COMPLETED` because of end-of-term expiration,
     * immediate cancellation initiated by the user, or system-initiated
     * cancellation.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChangeStateReasonType change_state_reason_type = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The changeStateReasonType.
     */
    @java.lang.Override
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeStateReasonType
        getChangeStateReasonType() {
      com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeStateReasonType result =
          com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeStateReasonType.forNumber(
              changeStateReasonType_);
      return result == null
          ? com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeStateReasonType
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Predefined enum types for why this line item change is in
     * current state. For example, a line item change's state could be
     * `LINE_ITEM_CHANGE_STATE_COMPLETED` because of end-of-term expiration,
     * immediate cancellation initiated by the user, or system-initiated
     * cancellation.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChangeStateReasonType change_state_reason_type = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The changeStateReasonType to set.
     * @return This builder for chaining.
     */
    public Builder setChangeStateReasonType(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemChangeStateReasonType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      changeStateReasonType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Predefined enum types for why this line item change is in
     * current state. For example, a line item change's state could be
     * `LINE_ITEM_CHANGE_STATE_COMPLETED` because of end-of-term expiration,
     * immediate cancellation initiated by the user, or system-initiated
     * cancellation.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.LineItemChangeStateReasonType change_state_reason_type = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChangeStateReasonType() {
      bitField0_ = (bitField0_ & ~0x00000040);
      changeStateReasonType_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp changeEffectiveTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        changeEffectiveTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. A time at which the change became or will become (in case of
     * pending change) effective.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp change_effective_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the changeEffectiveTime field is set.
     */
    public boolean hasChangeEffectiveTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. A time at which the change became or will become (in case of
     * pending change) effective.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp change_effective_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The changeEffectiveTime.
     */
    public com.google.protobuf.Timestamp getChangeEffectiveTime() {
      if (changeEffectiveTimeBuilder_ == null) {
        return changeEffectiveTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : changeEffectiveTime_;
      } else {
        return changeEffectiveTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A time at which the change became or will become (in case of
     * pending change) effective.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp change_effective_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setChangeEffectiveTime(com.google.protobuf.Timestamp value) {
      if (changeEffectiveTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        changeEffectiveTime_ = value;
      } else {
        changeEffectiveTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A time at which the change became or will become (in case of
     * pending change) effective.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp change_effective_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setChangeEffectiveTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (changeEffectiveTimeBuilder_ == null) {
        changeEffectiveTime_ = builderForValue.build();
      } else {
        changeEffectiveTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A time at which the change became or will become (in case of
     * pending change) effective.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp change_effective_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeChangeEffectiveTime(com.google.protobuf.Timestamp value) {
      if (changeEffectiveTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && changeEffectiveTime_ != null
            && changeEffectiveTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getChangeEffectiveTimeBuilder().mergeFrom(value);
        } else {
          changeEffectiveTime_ = value;
        }
      } else {
        changeEffectiveTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A time at which the change became or will become (in case of
     * pending change) effective.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp change_effective_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearChangeEffectiveTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      changeEffectiveTime_ = null;
      if (changeEffectiveTimeBuilder_ != null) {
        changeEffectiveTimeBuilder_.dispose();
        changeEffectiveTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A time at which the change became or will become (in case of
     * pending change) effective.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp change_effective_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getChangeEffectiveTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getChangeEffectiveTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. A time at which the change became or will become (in case of
     * pending change) effective.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp change_effective_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getChangeEffectiveTimeOrBuilder() {
      if (changeEffectiveTimeBuilder_ != null) {
        return changeEffectiveTimeBuilder_.getMessageOrBuilder();
      } else {
        return changeEffectiveTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : changeEffectiveTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A time at which the change became or will become (in case of
     * pending change) effective.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp change_effective_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getChangeEffectiveTimeFieldBuilder() {
      if (changeEffectiveTimeBuilder_ == null) {
        changeEffectiveTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getChangeEffectiveTime(), getParentForChildren(), isClean());
        changeEffectiveTime_ = null;
      }
      return changeEffectiveTimeBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when change was initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when change was initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when change was initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when change was initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when change was initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when change was initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when change was initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when change was initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when change was initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when change was updated, e.g. approved/rejected by
     * partners or cancelled by the user.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when change was updated, e.g. approved/rejected by
     * partners or cancelled by the user.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when change was updated, e.g. approved/rejected by
     * partners or cancelled by the user.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when change was updated, e.g. approved/rejected by
     * partners or cancelled by the user.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when change was updated, e.g. approved/rejected by
     * partners or cancelled by the user.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when change was updated, e.g. approved/rejected by
     * partners or cancelled by the user.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when change was updated, e.g. approved/rejected by
     * partners or cancelled by the user.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when change was updated, e.g. approved/rejected by
     * partners or cancelled by the user.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when change was updated, e.g. approved/rejected by
     * partners or cancelled by the user.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.commerce.consumer.procurement.v1.LineItemChange)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.commerce.consumer.procurement.v1.LineItemChange)
  private static final com.google.cloud.commerce.consumer.procurement.v1.LineItemChange
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.commerce.consumer.procurement.v1.LineItemChange();
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemChange
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LineItemChange> PARSER =
      new com.google.protobuf.AbstractParser<LineItemChange>() {
        @java.lang.Override
        public LineItemChange parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LineItemChange> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LineItemChange> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItemChange
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
