/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/commerce/consumer/procurement/v1/order.proto

package com.google.cloud.commerce.consumer.procurement.v1;

/**
 *
 *
 * <pre>
 * State of a change.
 * </pre>
 *
 * Protobuf enum {@code google.cloud.commerce.consumer.procurement.v1.LineItemChangeState}
 */
public enum LineItemChangeState implements com.google.protobuf.ProtocolMessageEnum {
  /**
   *
   *
   * <pre>
   * Sentinel value. Do not use.
   * </pre>
   *
   * <code>LINE_ITEM_CHANGE_STATE_UNSPECIFIED = 0;</code>
   */
  LINE_ITEM_CHANGE_STATE_UNSPECIFIED(0),
  /**
   *
   *
   * <pre>
   * Change is in this state when a change is initiated and waiting for
   * partner approval.
   * </pre>
   *
   * <code>LINE_ITEM_CHANGE_STATE_PENDING_APPROVAL = 1;</code>
   */
  LINE_ITEM_CHANGE_STATE_PENDING_APPROVAL(1),
  /**
   *
   *
   * <pre>
   * Change is in this state after it's approved by the partner or auto-approved
   * but before it takes effect. The change can be overwritten
   * or cancelled depending on the new line item info property (pending Private
   * Offer change cannot be cancelled and can only be overwritten by another
   * Private Offer).
   * </pre>
   *
   * <code>LINE_ITEM_CHANGE_STATE_APPROVED = 2;</code>
   */
  LINE_ITEM_CHANGE_STATE_APPROVED(2),
  /**
   *
   *
   * <pre>
   * Change is in this state after it's been activated.
   * </pre>
   *
   * <code>LINE_ITEM_CHANGE_STATE_COMPLETED = 3;</code>
   */
  LINE_ITEM_CHANGE_STATE_COMPLETED(3),
  /**
   *
   *
   * <pre>
   * Change is in this state if it was rejected by the partner.
   * </pre>
   *
   * <code>LINE_ITEM_CHANGE_STATE_REJECTED = 4;</code>
   */
  LINE_ITEM_CHANGE_STATE_REJECTED(4),
  /**
   *
   *
   * <pre>
   * Change is in this state if it was abandoned by the user.
   * </pre>
   *
   * <code>LINE_ITEM_CHANGE_STATE_ABANDONED = 5;</code>
   */
  LINE_ITEM_CHANGE_STATE_ABANDONED(5),
  /**
   *
   *
   * <pre>
   * Change is in this state if it's currently being provisioned downstream. The
   * change can't be overwritten or cancelled when it's in this state.
   * </pre>
   *
   * <code>LINE_ITEM_CHANGE_STATE_ACTIVATING = 6;</code>
   */
  LINE_ITEM_CHANGE_STATE_ACTIVATING(6),
  UNRECOGNIZED(-1),
  ;

  /**
   *
   *
   * <pre>
   * Sentinel value. Do not use.
   * </pre>
   *
   * <code>LINE_ITEM_CHANGE_STATE_UNSPECIFIED = 0;</code>
   */
  public static final int LINE_ITEM_CHANGE_STATE_UNSPECIFIED_VALUE = 0;
  /**
   *
   *
   * <pre>
   * Change is in this state when a change is initiated and waiting for
   * partner approval.
   * </pre>
   *
   * <code>LINE_ITEM_CHANGE_STATE_PENDING_APPROVAL = 1;</code>
   */
  public static final int LINE_ITEM_CHANGE_STATE_PENDING_APPROVAL_VALUE = 1;
  /**
   *
   *
   * <pre>
   * Change is in this state after it's approved by the partner or auto-approved
   * but before it takes effect. The change can be overwritten
   * or cancelled depending on the new line item info property (pending Private
   * Offer change cannot be cancelled and can only be overwritten by another
   * Private Offer).
   * </pre>
   *
   * <code>LINE_ITEM_CHANGE_STATE_APPROVED = 2;</code>
   */
  public static final int LINE_ITEM_CHANGE_STATE_APPROVED_VALUE = 2;
  /**
   *
   *
   * <pre>
   * Change is in this state after it's been activated.
   * </pre>
   *
   * <code>LINE_ITEM_CHANGE_STATE_COMPLETED = 3;</code>
   */
  public static final int LINE_ITEM_CHANGE_STATE_COMPLETED_VALUE = 3;
  /**
   *
   *
   * <pre>
   * Change is in this state if it was rejected by the partner.
   * </pre>
   *
   * <code>LINE_ITEM_CHANGE_STATE_REJECTED = 4;</code>
   */
  public static final int LINE_ITEM_CHANGE_STATE_REJECTED_VALUE = 4;
  /**
   *
   *
   * <pre>
   * Change is in this state if it was abandoned by the user.
   * </pre>
   *
   * <code>LINE_ITEM_CHANGE_STATE_ABANDONED = 5;</code>
   */
  public static final int LINE_ITEM_CHANGE_STATE_ABANDONED_VALUE = 5;
  /**
   *
   *
   * <pre>
   * Change is in this state if it's currently being provisioned downstream. The
   * change can't be overwritten or cancelled when it's in this state.
   * </pre>
   *
   * <code>LINE_ITEM_CHANGE_STATE_ACTIVATING = 6;</code>
   */
  public static final int LINE_ITEM_CHANGE_STATE_ACTIVATING_VALUE = 6;

  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static LineItemChangeState valueOf(int value) {
    return forNumber(value);
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   */
  public static LineItemChangeState forNumber(int value) {
    switch (value) {
      case 0:
        return LINE_ITEM_CHANGE_STATE_UNSPECIFIED;
      case 1:
        return LINE_ITEM_CHANGE_STATE_PENDING_APPROVAL;
      case 2:
        return LINE_ITEM_CHANGE_STATE_APPROVED;
      case 3:
        return LINE_ITEM_CHANGE_STATE_COMPLETED;
      case 4:
        return LINE_ITEM_CHANGE_STATE_REJECTED;
      case 5:
        return LINE_ITEM_CHANGE_STATE_ABANDONED;
      case 6:
        return LINE_ITEM_CHANGE_STATE_ACTIVATING;
      default:
        return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<LineItemChangeState>
      internalGetValueMap() {
    return internalValueMap;
  }

  private static final com.google.protobuf.Internal.EnumLiteMap<LineItemChangeState>
      internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<LineItemChangeState>() {
            public LineItemChangeState findValueByNumber(int number) {
              return LineItemChangeState.forNumber(number);
            }
          };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalStateException(
          "Can't get the descriptor of an unrecognized enum value.");
    }
    return getDescriptor().getValues().get(ordinal());
  }

  public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
    return getDescriptor();
  }

  public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
    return com.google.cloud.commerce.consumer.procurement.v1.OrderOuterClass.getDescriptor()
        .getEnumTypes()
        .get(1);
  }

  private static final LineItemChangeState[] VALUES = values();

  public static LineItemChangeState valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private LineItemChangeState(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:google.cloud.commerce.consumer.procurement.v1.LineItemChangeState)
}
