/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/commerce/consumer/procurement/v1/order.proto

package com.google.cloud.commerce.consumer.procurement.v1;

/**
 *
 *
 * <pre>
 * Line item information.
 * </pre>
 *
 * Protobuf type {@code google.cloud.commerce.consumer.procurement.v1.LineItemInfo}
 */
public final class LineItemInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.commerce.consumer.procurement.v1.LineItemInfo)
    LineItemInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LineItemInfo.newBuilder() to construct.
  private LineItemInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LineItemInfo() {
    offer_ = "";
    parameters_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LineItemInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.commerce.consumer.procurement.v1.OrderOuterClass
        .internal_static_google_cloud_commerce_consumer_procurement_v1_LineItemInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.commerce.consumer.procurement.v1.OrderOuterClass
        .internal_static_google_cloud_commerce_consumer_procurement_v1_LineItemInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.class,
            com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder.class);
  }

  public static final int OFFER_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object offer_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The name of the offer can have either of these formats:
   * 'billingAccounts/{billing_account}/offers/{offer}',
   * or 'services/{service}/standardOffers/{offer}'.
   * </pre>
   *
   * <code>
   * string offer = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The offer.
   */
  @java.lang.Override
  public java.lang.String getOffer() {
    java.lang.Object ref = offer_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      offer_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of the offer can have either of these formats:
   * 'billingAccounts/{billing_account}/offers/{offer}',
   * or 'services/{service}/standardOffers/{offer}'.
   * </pre>
   *
   * <code>
   * string offer = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for offer.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOfferBytes() {
    java.lang.Object ref = offer_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      offer_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARAMETERS_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.commerce.consumer.procurement.v1.Parameter> parameters_;
  /**
   *
   *
   * <pre>
   * Optional. User-provided parameters.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.commerce.consumer.procurement.v1.Parameter>
      getParametersList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * Optional. User-provided parameters.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.commerce.consumer.procurement.v1.ParameterOrBuilder>
      getParametersOrBuilderList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * Optional. User-provided parameters.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getParametersCount() {
    return parameters_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. User-provided parameters.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.Parameter getParameters(int index) {
    return parameters_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. User-provided parameters.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.ParameterOrBuilder
      getParametersOrBuilder(int index) {
    return parameters_.get(index);
  }

  public static final int SUBSCRIPTION_FIELD_NUMBER = 10;
  private com.google.cloud.commerce.consumer.procurement.v1.Subscription subscription_;
  /**
   *
   *
   * <pre>
   * Output only. Information about the subscription created, if applicable.
   * </pre>
   *
   * <code>
   * .google.cloud.commerce.consumer.procurement.v1.Subscription subscription = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the subscription field is set.
   */
  @java.lang.Override
  public boolean hasSubscription() {
    return subscription_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information about the subscription created, if applicable.
   * </pre>
   *
   * <code>
   * .google.cloud.commerce.consumer.procurement.v1.Subscription subscription = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The subscription.
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.Subscription getSubscription() {
    return subscription_ == null
        ? com.google.cloud.commerce.consumer.procurement.v1.Subscription.getDefaultInstance()
        : subscription_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information about the subscription created, if applicable.
   * </pre>
   *
   * <code>
   * .google.cloud.commerce.consumer.procurement.v1.Subscription subscription = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.SubscriptionOrBuilder
      getSubscriptionOrBuilder() {
    return subscription_ == null
        ? com.google.cloud.commerce.consumer.procurement.v1.Subscription.getDefaultInstance()
        : subscription_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < parameters_.size(); i++) {
      output.writeMessage(9, parameters_.get(i));
    }
    if (subscription_ != null) {
      output.writeMessage(10, getSubscription());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(offer_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, offer_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < parameters_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, parameters_.get(i));
    }
    if (subscription_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getSubscription());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(offer_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, offer_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo other =
        (com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo) obj;

    if (!getOffer().equals(other.getOffer())) return false;
    if (!getParametersList().equals(other.getParametersList())) return false;
    if (hasSubscription() != other.hasSubscription()) return false;
    if (hasSubscription()) {
      if (!getSubscription().equals(other.getSubscription())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + OFFER_FIELD_NUMBER;
    hash = (53 * hash) + getOffer().hashCode();
    if (getParametersCount() > 0) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParametersList().hashCode();
    }
    if (hasSubscription()) {
      hash = (37 * hash) + SUBSCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getSubscription().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Line item information.
   * </pre>
   *
   * Protobuf type {@code google.cloud.commerce.consumer.procurement.v1.LineItemInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.commerce.consumer.procurement.v1.LineItemInfo)
      com.google.cloud.commerce.consumer.procurement.v1.LineItemInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.commerce.consumer.procurement.v1.OrderOuterClass
          .internal_static_google_cloud_commerce_consumer_procurement_v1_LineItemInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.commerce.consumer.procurement.v1.OrderOuterClass
          .internal_static_google_cloud_commerce_consumer_procurement_v1_LineItemInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.class,
              com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.Builder.class);
    }

    // Construct using com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      offer_ = "";
      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
      } else {
        parameters_ = null;
        parametersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      subscription_ = null;
      if (subscriptionBuilder_ != null) {
        subscriptionBuilder_.dispose();
        subscriptionBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.commerce.consumer.procurement.v1.OrderOuterClass
          .internal_static_google_cloud_commerce_consumer_procurement_v1_LineItemInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo
        getDefaultInstanceForType() {
      return com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo build() {
      com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo buildPartial() {
      com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo result =
          new com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo result) {
      if (parametersBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          parameters_ = java.util.Collections.unmodifiableList(parameters_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.parameters_ = parameters_;
      } else {
        result.parameters_ = parametersBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.offer_ = offer_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.subscription_ =
            subscriptionBuilder_ == null ? subscription_ : subscriptionBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo) {
        return mergeFrom((com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo other) {
      if (other
          == com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo.getDefaultInstance())
        return this;
      if (!other.getOffer().isEmpty()) {
        offer_ = other.offer_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (parametersBuilder_ == null) {
        if (!other.parameters_.isEmpty()) {
          if (parameters_.isEmpty()) {
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureParametersIsMutable();
            parameters_.addAll(other.parameters_);
          }
          onChanged();
        }
      } else {
        if (!other.parameters_.isEmpty()) {
          if (parametersBuilder_.isEmpty()) {
            parametersBuilder_.dispose();
            parametersBuilder_ = null;
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000002);
            parametersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getParametersFieldBuilder()
                    : null;
          } else {
            parametersBuilder_.addAllMessages(other.parameters_);
          }
        }
      }
      if (other.hasSubscription()) {
        mergeSubscription(other.getSubscription());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 74:
              {
                com.google.cloud.commerce.consumer.procurement.v1.Parameter m =
                    input.readMessage(
                        com.google.cloud.commerce.consumer.procurement.v1.Parameter.parser(),
                        extensionRegistry);
                if (parametersBuilder_ == null) {
                  ensureParametersIsMutable();
                  parameters_.add(m);
                } else {
                  parametersBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getSubscriptionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 82
            case 106:
              {
                offer_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object offer_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The name of the offer can have either of these formats:
     * 'billingAccounts/{billing_account}/offers/{offer}',
     * or 'services/{service}/standardOffers/{offer}'.
     * </pre>
     *
     * <code>
     * string offer = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The offer.
     */
    public java.lang.String getOffer() {
      java.lang.Object ref = offer_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        offer_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the offer can have either of these formats:
     * 'billingAccounts/{billing_account}/offers/{offer}',
     * or 'services/{service}/standardOffers/{offer}'.
     * </pre>
     *
     * <code>
     * string offer = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for offer.
     */
    public com.google.protobuf.ByteString getOfferBytes() {
      java.lang.Object ref = offer_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        offer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the offer can have either of these formats:
     * 'billingAccounts/{billing_account}/offers/{offer}',
     * or 'services/{service}/standardOffers/{offer}'.
     * </pre>
     *
     * <code>
     * string offer = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The offer to set.
     * @return This builder for chaining.
     */
    public Builder setOffer(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      offer_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the offer can have either of these formats:
     * 'billingAccounts/{billing_account}/offers/{offer}',
     * or 'services/{service}/standardOffers/{offer}'.
     * </pre>
     *
     * <code>
     * string offer = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOffer() {
      offer_ = getDefaultInstance().getOffer();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the offer can have either of these formats:
     * 'billingAccounts/{billing_account}/offers/{offer}',
     * or 'services/{service}/standardOffers/{offer}'.
     * </pre>
     *
     * <code>
     * string offer = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for offer to set.
     * @return This builder for chaining.
     */
    public Builder setOfferBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      offer_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.commerce.consumer.procurement.v1.Parameter>
        parameters_ = java.util.Collections.emptyList();

    private void ensureParametersIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        parameters_ =
            new java.util.ArrayList<com.google.cloud.commerce.consumer.procurement.v1.Parameter>(
                parameters_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.commerce.consumer.procurement.v1.Parameter,
            com.google.cloud.commerce.consumer.procurement.v1.Parameter.Builder,
            com.google.cloud.commerce.consumer.procurement.v1.ParameterOrBuilder>
        parametersBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. User-provided parameters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.commerce.consumer.procurement.v1.Parameter>
        getParametersList() {
      if (parametersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(parameters_);
      } else {
        return parametersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided parameters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getParametersCount() {
      if (parametersBuilder_ == null) {
        return parameters_.size();
      } else {
        return parametersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided parameters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.Parameter getParameters(int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided parameters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setParameters(
        int index, com.google.cloud.commerce.consumer.procurement.v1.Parameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.set(index, value);
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided parameters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setParameters(
        int index,
        com.google.cloud.commerce.consumer.procurement.v1.Parameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.set(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided parameters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addParameters(
        com.google.cloud.commerce.consumer.procurement.v1.Parameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided parameters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addParameters(
        int index, com.google.cloud.commerce.consumer.procurement.v1.Parameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(index, value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided parameters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addParameters(
        com.google.cloud.commerce.consumer.procurement.v1.Parameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided parameters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addParameters(
        int index,
        com.google.cloud.commerce.consumer.procurement.v1.Parameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided parameters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllParameters(
        java.lang.Iterable<? extends com.google.cloud.commerce.consumer.procurement.v1.Parameter>
            values) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, parameters_);
        onChanged();
      } else {
        parametersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided parameters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearParameters() {
      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        parametersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided parameters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeParameters(int index) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.remove(index);
        onChanged();
      } else {
        parametersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided parameters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.Parameter.Builder getParametersBuilder(
        int index) {
      return getParametersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided parameters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.ParameterOrBuilder
        getParametersOrBuilder(int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided parameters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.commerce.consumer.procurement.v1.ParameterOrBuilder>
        getParametersOrBuilderList() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(parameters_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided parameters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.Parameter.Builder
        addParametersBuilder() {
      return getParametersFieldBuilder()
          .addBuilder(
              com.google.cloud.commerce.consumer.procurement.v1.Parameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided parameters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.Parameter.Builder addParametersBuilder(
        int index) {
      return getParametersFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.commerce.consumer.procurement.v1.Parameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided parameters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.commerce.consumer.procurement.v1.Parameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.commerce.consumer.procurement.v1.Parameter.Builder>
        getParametersBuilderList() {
      return getParametersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.commerce.consumer.procurement.v1.Parameter,
            com.google.cloud.commerce.consumer.procurement.v1.Parameter.Builder,
            com.google.cloud.commerce.consumer.procurement.v1.ParameterOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.commerce.consumer.procurement.v1.Parameter,
                com.google.cloud.commerce.consumer.procurement.v1.Parameter.Builder,
                com.google.cloud.commerce.consumer.procurement.v1.ParameterOrBuilder>(
                parameters_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    private com.google.cloud.commerce.consumer.procurement.v1.Subscription subscription_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.commerce.consumer.procurement.v1.Subscription,
            com.google.cloud.commerce.consumer.procurement.v1.Subscription.Builder,
            com.google.cloud.commerce.consumer.procurement.v1.SubscriptionOrBuilder>
        subscriptionBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information about the subscription created, if applicable.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.Subscription subscription = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the subscription field is set.
     */
    public boolean hasSubscription() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about the subscription created, if applicable.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.Subscription subscription = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The subscription.
     */
    public com.google.cloud.commerce.consumer.procurement.v1.Subscription getSubscription() {
      if (subscriptionBuilder_ == null) {
        return subscription_ == null
            ? com.google.cloud.commerce.consumer.procurement.v1.Subscription.getDefaultInstance()
            : subscription_;
      } else {
        return subscriptionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about the subscription created, if applicable.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.Subscription subscription = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSubscription(
        com.google.cloud.commerce.consumer.procurement.v1.Subscription value) {
      if (subscriptionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        subscription_ = value;
      } else {
        subscriptionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about the subscription created, if applicable.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.Subscription subscription = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSubscription(
        com.google.cloud.commerce.consumer.procurement.v1.Subscription.Builder builderForValue) {
      if (subscriptionBuilder_ == null) {
        subscription_ = builderForValue.build();
      } else {
        subscriptionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about the subscription created, if applicable.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.Subscription subscription = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSubscription(
        com.google.cloud.commerce.consumer.procurement.v1.Subscription value) {
      if (subscriptionBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && subscription_ != null
            && subscription_
                != com.google.cloud.commerce.consumer.procurement.v1.Subscription
                    .getDefaultInstance()) {
          getSubscriptionBuilder().mergeFrom(value);
        } else {
          subscription_ = value;
        }
      } else {
        subscriptionBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about the subscription created, if applicable.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.Subscription subscription = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSubscription() {
      bitField0_ = (bitField0_ & ~0x00000004);
      subscription_ = null;
      if (subscriptionBuilder_ != null) {
        subscriptionBuilder_.dispose();
        subscriptionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about the subscription created, if applicable.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.Subscription subscription = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.Subscription.Builder
        getSubscriptionBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getSubscriptionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about the subscription created, if applicable.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.Subscription subscription = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.commerce.consumer.procurement.v1.SubscriptionOrBuilder
        getSubscriptionOrBuilder() {
      if (subscriptionBuilder_ != null) {
        return subscriptionBuilder_.getMessageOrBuilder();
      } else {
        return subscription_ == null
            ? com.google.cloud.commerce.consumer.procurement.v1.Subscription.getDefaultInstance()
            : subscription_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about the subscription created, if applicable.
     * </pre>
     *
     * <code>
     * .google.cloud.commerce.consumer.procurement.v1.Subscription subscription = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.commerce.consumer.procurement.v1.Subscription,
            com.google.cloud.commerce.consumer.procurement.v1.Subscription.Builder,
            com.google.cloud.commerce.consumer.procurement.v1.SubscriptionOrBuilder>
        getSubscriptionFieldBuilder() {
      if (subscriptionBuilder_ == null) {
        subscriptionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.commerce.consumer.procurement.v1.Subscription,
                com.google.cloud.commerce.consumer.procurement.v1.Subscription.Builder,
                com.google.cloud.commerce.consumer.procurement.v1.SubscriptionOrBuilder>(
                getSubscription(), getParentForChildren(), isClean());
        subscription_ = null;
      }
      return subscriptionBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.commerce.consumer.procurement.v1.LineItemInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.commerce.consumer.procurement.v1.LineItemInfo)
  private static final com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo();
  }

  public static com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LineItemInfo> PARSER =
      new com.google.protobuf.AbstractParser<LineItemInfo>() {
        @java.lang.Override
        public LineItemInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LineItemInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LineItemInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.commerce.consumer.procurement.v1.LineItemInfo
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
