/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * An instance-attached disk resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.AttachedDisk}
 */
public final class AttachedDisk extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.AttachedDisk)
    AttachedDiskOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AttachedDisk.newBuilder() to construct.
  private AttachedDisk(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AttachedDisk() {
    architecture_ = "";
    deviceName_ = "";
    guestOsFeatures_ = java.util.Collections.emptyList();
    interface_ = "";
    kind_ = "";
    licenses_ = com.google.protobuf.LazyStringArrayList.emptyList();
    mode_ = "";
    savedState_ = "";
    source_ = "";
    type_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AttachedDisk();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_AttachedDisk_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_AttachedDisk_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.AttachedDisk.class,
            com.google.cloud.compute.v1.AttachedDisk.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The architecture of the attached disk. Valid values are ARM64 or X86_64.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.AttachedDisk.Architecture}
   */
  public enum Architecture implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ARCHITECTURE = 0;</code>
     */
    UNDEFINED_ARCHITECTURE(0),
    /**
     *
     *
     * <pre>
     * Default value indicating Architecture is not set.
     * </pre>
     *
     * <code>ARCHITECTURE_UNSPECIFIED = 394750507;</code>
     */
    ARCHITECTURE_UNSPECIFIED(394750507),
    /**
     *
     *
     * <pre>
     * Machines with architecture ARM64
     * </pre>
     *
     * <code>ARM64 = 62547450;</code>
     */
    ARM64(62547450),
    /**
     *
     *
     * <pre>
     * Machines with architecture X86_64
     * </pre>
     *
     * <code>X86_64 = 425300551;</code>
     */
    X86_64(425300551),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ARCHITECTURE = 0;</code>
     */
    public static final int UNDEFINED_ARCHITECTURE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Default value indicating Architecture is not set.
     * </pre>
     *
     * <code>ARCHITECTURE_UNSPECIFIED = 394750507;</code>
     */
    public static final int ARCHITECTURE_UNSPECIFIED_VALUE = 394750507;
    /**
     *
     *
     * <pre>
     * Machines with architecture ARM64
     * </pre>
     *
     * <code>ARM64 = 62547450;</code>
     */
    public static final int ARM64_VALUE = 62547450;
    /**
     *
     *
     * <pre>
     * Machines with architecture X86_64
     * </pre>
     *
     * <code>X86_64 = 425300551;</code>
     */
    public static final int X86_64_VALUE = 425300551;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Architecture valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Architecture forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ARCHITECTURE;
        case 394750507:
          return ARCHITECTURE_UNSPECIFIED;
        case 62547450:
          return ARM64;
        case 425300551:
          return X86_64;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Architecture> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Architecture> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Architecture>() {
          public Architecture findValueByNumber(int number) {
            return Architecture.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.AttachedDisk.getDescriptor().getEnumTypes().get(0);
    }

    private static final Architecture[] VALUES = values();

    public static Architecture valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Architecture(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.AttachedDisk.Architecture)
  }

  /**
   *
   *
   * <pre>
   * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. For most machine types, the default is SCSI. Local SSDs can use either NVME or SCSI. In certain configurations, persistent disks can use NVMe. For more information, see About persistent disks.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.AttachedDisk.Interface}
   */
  public enum Interface implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_INTERFACE = 0;</code>
     */
    UNDEFINED_INTERFACE(0),
    /** <code>NVME = 2408800;</code> */
    NVME(2408800),
    /** <code>SCSI = 2539686;</code> */
    SCSI(2539686),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_INTERFACE = 0;</code>
     */
    public static final int UNDEFINED_INTERFACE_VALUE = 0;
    /** <code>NVME = 2408800;</code> */
    public static final int NVME_VALUE = 2408800;
    /** <code>SCSI = 2539686;</code> */
    public static final int SCSI_VALUE = 2539686;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Interface valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Interface forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_INTERFACE;
        case 2408800:
          return NVME;
        case 2539686:
          return SCSI;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Interface> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Interface> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Interface>() {
          public Interface findValueByNumber(int number) {
            return Interface.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.AttachedDisk.getDescriptor().getEnumTypes().get(1);
    }

    private static final Interface[] VALUES = values();

    public static Interface valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Interface(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.AttachedDisk.Interface)
  }

  /**
   *
   *
   * <pre>
   * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.AttachedDisk.Mode}
   */
  public enum Mode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MODE = 0;</code>
     */
    UNDEFINED_MODE(0),
    /**
     *
     *
     * <pre>
     * Attaches this disk in read-only mode. Multiple virtual machines can use a disk in read-only mode at a time.
     * </pre>
     *
     * <code>READ_ONLY = 91950261;</code>
     */
    READ_ONLY(91950261),
    /**
     *
     *
     * <pre>
     * *[Default]* Attaches this disk in read-write mode. Only one virtual machine at a time can be attached to a disk in read-write mode.
     * </pre>
     *
     * <code>READ_WRITE = 173607894;</code>
     */
    READ_WRITE(173607894),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MODE = 0;</code>
     */
    public static final int UNDEFINED_MODE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Attaches this disk in read-only mode. Multiple virtual machines can use a disk in read-only mode at a time.
     * </pre>
     *
     * <code>READ_ONLY = 91950261;</code>
     */
    public static final int READ_ONLY_VALUE = 91950261;
    /**
     *
     *
     * <pre>
     * *[Default]* Attaches this disk in read-write mode. Only one virtual machine at a time can be attached to a disk in read-write mode.
     * </pre>
     *
     * <code>READ_WRITE = 173607894;</code>
     */
    public static final int READ_WRITE_VALUE = 173607894;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Mode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Mode forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_MODE;
        case 91950261:
          return READ_ONLY;
        case 173607894:
          return READ_WRITE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Mode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Mode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Mode>() {
          public Mode findValueByNumber(int number) {
            return Mode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.AttachedDisk.getDescriptor().getEnumTypes().get(2);
    }

    private static final Mode[] VALUES = values();

    public static Mode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Mode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.AttachedDisk.Mode)
  }

  /**
   *
   *
   * <pre>
   * For LocalSSD disks on VM Instances in STOPPED or SUSPENDED state, this field is set to PRESERVED if the LocalSSD data has been saved to a persistent location by customer request. (see the discard_local_ssd option on Stop/Suspend). Read-only in the api.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.AttachedDisk.SavedState}
   */
  public enum SavedState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_SAVED_STATE = 0;</code>
     */
    UNDEFINED_SAVED_STATE(0),
    /**
     *
     *
     * <pre>
     * *[Default]* Disk state has not been preserved.
     * </pre>
     *
     * <code>DISK_SAVED_STATE_UNSPECIFIED = 391290831;</code>
     */
    DISK_SAVED_STATE_UNSPECIFIED(391290831),
    /**
     *
     *
     * <pre>
     * Disk state has been preserved.
     * </pre>
     *
     * <code>PRESERVED = 254159736;</code>
     */
    PRESERVED(254159736),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_SAVED_STATE = 0;</code>
     */
    public static final int UNDEFINED_SAVED_STATE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * *[Default]* Disk state has not been preserved.
     * </pre>
     *
     * <code>DISK_SAVED_STATE_UNSPECIFIED = 391290831;</code>
     */
    public static final int DISK_SAVED_STATE_UNSPECIFIED_VALUE = 391290831;
    /**
     *
     *
     * <pre>
     * Disk state has been preserved.
     * </pre>
     *
     * <code>PRESERVED = 254159736;</code>
     */
    public static final int PRESERVED_VALUE = 254159736;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SavedState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SavedState forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_SAVED_STATE;
        case 391290831:
          return DISK_SAVED_STATE_UNSPECIFIED;
        case 254159736:
          return PRESERVED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SavedState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SavedState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<SavedState>() {
          public SavedState findValueByNumber(int number) {
            return SavedState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.AttachedDisk.getDescriptor().getEnumTypes().get(3);
    }

    private static final SavedState[] VALUES = values();

    public static SavedState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SavedState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.AttachedDisk.SavedState)
  }

  /**
   *
   *
   * <pre>
   * Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.AttachedDisk.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    UNDEFINED_TYPE(0),
    /** <code>PERSISTENT = 460683927;</code> */
    PERSISTENT(460683927),
    /** <code>SCRATCH = 496778970;</code> */
    SCRATCH(496778970),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    public static final int UNDEFINED_TYPE_VALUE = 0;
    /** <code>PERSISTENT = 460683927;</code> */
    public static final int PERSISTENT_VALUE = 460683927;
    /** <code>SCRATCH = 496778970;</code> */
    public static final int SCRATCH_VALUE = 496778970;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_TYPE;
        case 460683927:
          return PERSISTENT;
        case 496778970:
          return SCRATCH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.AttachedDisk.getDescriptor().getEnumTypes().get(4);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.AttachedDisk.Type)
  }

  private int bitField0_;
  public static final int ARCHITECTURE_FIELD_NUMBER = 302803283;

  @SuppressWarnings("serial")
  private volatile java.lang.Object architecture_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The architecture of the attached disk. Valid values are ARM64 or X86_64.
   * Check the Architecture enum for the list of possible values.
   * </pre>
   *
   * <code>optional string architecture = 302803283;</code>
   *
   * @return Whether the architecture field is set.
   */
  @java.lang.Override
  public boolean hasArchitecture() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The architecture of the attached disk. Valid values are ARM64 or X86_64.
   * Check the Architecture enum for the list of possible values.
   * </pre>
   *
   * <code>optional string architecture = 302803283;</code>
   *
   * @return The architecture.
   */
  @java.lang.Override
  public java.lang.String getArchitecture() {
    java.lang.Object ref = architecture_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      architecture_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The architecture of the attached disk. Valid values are ARM64 or X86_64.
   * Check the Architecture enum for the list of possible values.
   * </pre>
   *
   * <code>optional string architecture = 302803283;</code>
   *
   * @return The bytes for architecture.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getArchitectureBytes() {
    java.lang.Object ref = architecture_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      architecture_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUTO_DELETE_FIELD_NUMBER = 464761403;
  private boolean autoDelete_ = false;
  /**
   *
   *
   * <pre>
   * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
   * </pre>
   *
   * <code>optional bool auto_delete = 464761403;</code>
   *
   * @return Whether the autoDelete field is set.
   */
  @java.lang.Override
  public boolean hasAutoDelete() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
   * </pre>
   *
   * <code>optional bool auto_delete = 464761403;</code>
   *
   * @return The autoDelete.
   */
  @java.lang.Override
  public boolean getAutoDelete() {
    return autoDelete_;
  }

  public static final int BOOT_FIELD_NUMBER = 3029746;
  private boolean boot_ = false;
  /**
   *
   *
   * <pre>
   * Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
   * </pre>
   *
   * <code>optional bool boot = 3029746;</code>
   *
   * @return Whether the boot field is set.
   */
  @java.lang.Override
  public boolean hasBoot() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
   * </pre>
   *
   * <code>optional bool boot = 3029746;</code>
   *
   * @return The boot.
   */
  @java.lang.Override
  public boolean getBoot() {
    return boot_;
  }

  public static final int DEVICE_NAME_FIELD_NUMBER = 67541716;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deviceName_ = "";
  /**
   *
   *
   * <pre>
   * Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
   * </pre>
   *
   * <code>optional string device_name = 67541716;</code>
   *
   * @return Whether the deviceName field is set.
   */
  @java.lang.Override
  public boolean hasDeviceName() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
   * </pre>
   *
   * <code>optional string device_name = 67541716;</code>
   *
   * @return The deviceName.
   */
  @java.lang.Override
  public java.lang.String getDeviceName() {
    java.lang.Object ref = deviceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deviceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
   * </pre>
   *
   * <code>optional string device_name = 67541716;</code>
   *
   * @return The bytes for deviceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeviceNameBytes() {
    java.lang.Object ref = deviceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deviceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISK_ENCRYPTION_KEY_FIELD_NUMBER = 271660677;
  private com.google.cloud.compute.v1.CustomerEncryptionKey diskEncryptionKey_;
  /**
   *
   *
   * <pre>
   * Encrypts or decrypts a disk using a customer-supplied encryption key. If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key. If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance. If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later. Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 271660677;
   * </code>
   *
   * @return Whether the diskEncryptionKey field is set.
   */
  @java.lang.Override
  public boolean hasDiskEncryptionKey() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Encrypts or decrypts a disk using a customer-supplied encryption key. If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key. If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance. If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later. Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 271660677;
   * </code>
   *
   * @return The diskEncryptionKey.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomerEncryptionKey getDiskEncryptionKey() {
    return diskEncryptionKey_ == null
        ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
        : diskEncryptionKey_;
  }
  /**
   *
   *
   * <pre>
   * Encrypts or decrypts a disk using a customer-supplied encryption key. If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key. If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance. If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later. Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 271660677;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder
      getDiskEncryptionKeyOrBuilder() {
    return diskEncryptionKey_ == null
        ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
        : diskEncryptionKey_;
  }

  public static final int DISK_SIZE_GB_FIELD_NUMBER = 316263735;
  private long diskSizeGb_ = 0L;
  /**
   *
   *
   * <pre>
   * The size of the disk in GB.
   * </pre>
   *
   * <code>optional int64 disk_size_gb = 316263735;</code>
   *
   * @return Whether the diskSizeGb field is set.
   */
  @java.lang.Override
  public boolean hasDiskSizeGb() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * The size of the disk in GB.
   * </pre>
   *
   * <code>optional int64 disk_size_gb = 316263735;</code>
   *
   * @return The diskSizeGb.
   */
  @java.lang.Override
  public long getDiskSizeGb() {
    return diskSizeGb_;
  }

  public static final int FORCE_ATTACH_FIELD_NUMBER = 142758425;
  private boolean forceAttach_ = false;
  /**
   *
   *
   * <pre>
   * [Input Only] Whether to force attach the regional disk even if it's currently attached to another instance. If you try to force attach a zonal disk to an instance, you will receive an error.
   * </pre>
   *
   * <code>optional bool force_attach = 142758425;</code>
   *
   * @return Whether the forceAttach field is set.
   */
  @java.lang.Override
  public boolean hasForceAttach() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Input Only] Whether to force attach the regional disk even if it's currently attached to another instance. If you try to force attach a zonal disk to an instance, you will receive an error.
   * </pre>
   *
   * <code>optional bool force_attach = 142758425;</code>
   *
   * @return The forceAttach.
   */
  @java.lang.Override
  public boolean getForceAttach() {
    return forceAttach_;
  }

  public static final int GUEST_OS_FEATURES_FIELD_NUMBER = 79294545;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.GuestOsFeature> guestOsFeatures_;
  /**
   *
   *
   * <pre>
   * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.GuestOsFeature> getGuestOsFeaturesList() {
    return guestOsFeatures_;
  }
  /**
   *
   *
   * <pre>
   * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.GuestOsFeatureOrBuilder>
      getGuestOsFeaturesOrBuilderList() {
    return guestOsFeatures_;
  }
  /**
   *
   *
   * <pre>
   * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
   */
  @java.lang.Override
  public int getGuestOsFeaturesCount() {
    return guestOsFeatures_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.GuestOsFeature getGuestOsFeatures(int index) {
    return guestOsFeatures_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.GuestOsFeatureOrBuilder getGuestOsFeaturesOrBuilder(
      int index) {
    return guestOsFeatures_.get(index);
  }

  public static final int INDEX_FIELD_NUMBER = 100346066;
  private int index_ = 0;
  /**
   *
   *
   * <pre>
   * [Output Only] A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
   * </pre>
   *
   * <code>optional int32 index = 100346066;</code>
   *
   * @return Whether the index field is set.
   */
  @java.lang.Override
  public boolean hasIndex() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
   * </pre>
   *
   * <code>optional int32 index = 100346066;</code>
   *
   * @return The index.
   */
  @java.lang.Override
  public int getIndex() {
    return index_;
  }

  public static final int INITIALIZE_PARAMS_FIELD_NUMBER = 17697045;
  private com.google.cloud.compute.v1.AttachedDiskInitializeParams initializeParams_;
  /**
   *
   *
   * <pre>
   * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.AttachedDiskInitializeParams initialize_params = 17697045;
   * </code>
   *
   * @return Whether the initializeParams field is set.
   */
  @java.lang.Override
  public boolean hasInitializeParams() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.AttachedDiskInitializeParams initialize_params = 17697045;
   * </code>
   *
   * @return The initializeParams.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AttachedDiskInitializeParams getInitializeParams() {
    return initializeParams_ == null
        ? com.google.cloud.compute.v1.AttachedDiskInitializeParams.getDefaultInstance()
        : initializeParams_;
  }
  /**
   *
   *
   * <pre>
   * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.AttachedDiskInitializeParams initialize_params = 17697045;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AttachedDiskInitializeParamsOrBuilder
      getInitializeParamsOrBuilder() {
    return initializeParams_ == null
        ? com.google.cloud.compute.v1.AttachedDiskInitializeParams.getDefaultInstance()
        : initializeParams_;
  }

  public static final int INTERFACE_FIELD_NUMBER = 502623545;

  @SuppressWarnings("serial")
  private volatile java.lang.Object interface_ = "";
  /**
   *
   *
   * <pre>
   * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. For most machine types, the default is SCSI. Local SSDs can use either NVME or SCSI. In certain configurations, persistent disks can use NVMe. For more information, see About persistent disks.
   * Check the Interface enum for the list of possible values.
   * </pre>
   *
   * <code>optional string interface = 502623545;</code>
   *
   * @return Whether the interface field is set.
   */
  @java.lang.Override
  public boolean hasInterface() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. For most machine types, the default is SCSI. Local SSDs can use either NVME or SCSI. In certain configurations, persistent disks can use NVMe. For more information, see About persistent disks.
   * Check the Interface enum for the list of possible values.
   * </pre>
   *
   * <code>optional string interface = 502623545;</code>
   *
   * @return The interface.
   */
  @java.lang.Override
  public java.lang.String getInterface() {
    java.lang.Object ref = interface_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      interface_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. For most machine types, the default is SCSI. Local SSDs can use either NVME or SCSI. In certain configurations, persistent disks can use NVMe. For more information, see About persistent disks.
   * Check the Interface enum for the list of possible values.
   * </pre>
   *
   * <code>optional string interface = 502623545;</code>
   *
   * @return The bytes for interface.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInterfaceBytes() {
    java.lang.Object ref = interface_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      interface_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LICENSES_FIELD_NUMBER = 337642578;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList licenses_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * [Output Only] Any valid publicly visible licenses.
   * </pre>
   *
   * <code>repeated string licenses = 337642578;</code>
   *
   * @return A list containing the licenses.
   */
  public com.google.protobuf.ProtocolStringList getLicensesList() {
    return licenses_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Any valid publicly visible licenses.
   * </pre>
   *
   * <code>repeated string licenses = 337642578;</code>
   *
   * @return The count of licenses.
   */
  public int getLicensesCount() {
    return licenses_.size();
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Any valid publicly visible licenses.
   * </pre>
   *
   * <code>repeated string licenses = 337642578;</code>
   *
   * @param index The index of the element to return.
   * @return The licenses at the given index.
   */
  public java.lang.String getLicenses(int index) {
    return licenses_.get(index);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Any valid publicly visible licenses.
   * </pre>
   *
   * <code>repeated string licenses = 337642578;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the licenses at the given index.
   */
  public com.google.protobuf.ByteString getLicensesBytes(int index) {
    return licenses_.getByteString(index);
  }

  public static final int MODE_FIELD_NUMBER = 3357091;

  @SuppressWarnings("serial")
  private volatile java.lang.Object mode_ = "";
  /**
   *
   *
   * <pre>
   * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
   * Check the Mode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string mode = 3357091;</code>
   *
   * @return Whether the mode field is set.
   */
  @java.lang.Override
  public boolean hasMode() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
   * Check the Mode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string mode = 3357091;</code>
   *
   * @return The mode.
   */
  @java.lang.Override
  public java.lang.String getMode() {
    java.lang.Object ref = mode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      mode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
   * Check the Mode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string mode = 3357091;</code>
   *
   * @return The bytes for mode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModeBytes() {
    java.lang.Object ref = mode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      mode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SAVED_STATE_FIELD_NUMBER = 411587801;

  @SuppressWarnings("serial")
  private volatile java.lang.Object savedState_ = "";
  /**
   *
   *
   * <pre>
   * For LocalSSD disks on VM Instances in STOPPED or SUSPENDED state, this field is set to PRESERVED if the LocalSSD data has been saved to a persistent location by customer request. (see the discard_local_ssd option on Stop/Suspend). Read-only in the api.
   * Check the SavedState enum for the list of possible values.
   * </pre>
   *
   * <code>optional string saved_state = 411587801;</code>
   *
   * @return Whether the savedState field is set.
   */
  @java.lang.Override
  public boolean hasSavedState() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * For LocalSSD disks on VM Instances in STOPPED or SUSPENDED state, this field is set to PRESERVED if the LocalSSD data has been saved to a persistent location by customer request. (see the discard_local_ssd option on Stop/Suspend). Read-only in the api.
   * Check the SavedState enum for the list of possible values.
   * </pre>
   *
   * <code>optional string saved_state = 411587801;</code>
   *
   * @return The savedState.
   */
  @java.lang.Override
  public java.lang.String getSavedState() {
    java.lang.Object ref = savedState_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      savedState_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * For LocalSSD disks on VM Instances in STOPPED or SUSPENDED state, this field is set to PRESERVED if the LocalSSD data has been saved to a persistent location by customer request. (see the discard_local_ssd option on Stop/Suspend). Read-only in the api.
   * Check the SavedState enum for the list of possible values.
   * </pre>
   *
   * <code>optional string saved_state = 411587801;</code>
   *
   * @return The bytes for savedState.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSavedStateBytes() {
    java.lang.Object ref = savedState_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      savedState_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SHIELDED_INSTANCE_INITIAL_STATE_FIELD_NUMBER = 192356867;
  private com.google.cloud.compute.v1.InitialStateConfig shieldedInstanceInitialState_;
  /**
   *
   *
   * <pre>
   * [Output Only] shielded vm initial state stored on disk
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InitialStateConfig shielded_instance_initial_state = 192356867;
   * </code>
   *
   * @return Whether the shieldedInstanceInitialState field is set.
   */
  @java.lang.Override
  public boolean hasShieldedInstanceInitialState() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] shielded vm initial state stored on disk
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InitialStateConfig shielded_instance_initial_state = 192356867;
   * </code>
   *
   * @return The shieldedInstanceInitialState.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InitialStateConfig getShieldedInstanceInitialState() {
    return shieldedInstanceInitialState_ == null
        ? com.google.cloud.compute.v1.InitialStateConfig.getDefaultInstance()
        : shieldedInstanceInitialState_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] shielded vm initial state stored on disk
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InitialStateConfig shielded_instance_initial_state = 192356867;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InitialStateConfigOrBuilder
      getShieldedInstanceInitialStateOrBuilder() {
    return shieldedInstanceInitialState_ == null
        ? com.google.cloud.compute.v1.InitialStateConfig.getDefaultInstance()
        : shieldedInstanceInitialState_;
  }

  public static final int SOURCE_FIELD_NUMBER = 177235995;

  @SuppressWarnings("serial")
  private volatile java.lang.Object source_ = "";
  /**
   *
   *
   * <pre>
   * Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks. Note that for InstanceTemplate, specify the disk name for zonal disk, and the URL for regional disk.
   * </pre>
   *
   * <code>optional string source = 177235995;</code>
   *
   * @return Whether the source field is set.
   */
  @java.lang.Override
  public boolean hasSource() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks. Note that for InstanceTemplate, specify the disk name for zonal disk, and the URL for regional disk.
   * </pre>
   *
   * <code>optional string source = 177235995;</code>
   *
   * @return The source.
   */
  @java.lang.Override
  public java.lang.String getSource() {
    java.lang.Object ref = source_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      source_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks. Note that for InstanceTemplate, specify the disk name for zonal disk, and the URL for regional disk.
   * </pre>
   *
   * <code>optional string source = 177235995;</code>
   *
   * @return The bytes for source.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceBytes() {
    java.lang.Object ref = source_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      source_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 3575610;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";
  /**
   *
   *
   * <pre>
   * Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return Whether the type field is set.
   */
  @java.lang.Override
  public boolean hasType() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeBool(3029746, boot_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3357091, mode_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3575610, type_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(17697045, getInitializeParams());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 67541716, deviceName_);
    }
    for (int i = 0; i < guestOsFeatures_.size(); i++) {
      output.writeMessage(79294545, guestOsFeatures_.get(i));
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeInt32(100346066, index_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeBool(142758425, forceAttach_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 177235995, source_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeMessage(192356867, getShieldedInstanceInitialState());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(271660677, getDiskEncryptionKey());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 302803283, architecture_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeInt64(316263735, diskSizeGb_);
    }
    for (int i = 0; i < licenses_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 337642578, licenses_.getRaw(i));
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 411587801, savedState_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(464761403, autoDelete_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 502623545, interface_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3029746, boot_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3357091, mode_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3575610, type_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(17697045, getInitializeParams());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(67541716, deviceName_);
    }
    for (int i = 0; i < guestOsFeatures_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              79294545, guestOsFeatures_.get(i));
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(100346066, index_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(142758425, forceAttach_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(177235995, source_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              192356867, getShieldedInstanceInitialState());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              271660677, getDiskEncryptionKey());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(302803283, architecture_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(316263735, diskSizeGb_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < licenses_.size(); i++) {
        dataSize += computeStringSizeNoTag(licenses_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getLicensesList().size();
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(411587801, savedState_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(464761403, autoDelete_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(502623545, interface_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.AttachedDisk)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.AttachedDisk other = (com.google.cloud.compute.v1.AttachedDisk) obj;

    if (hasArchitecture() != other.hasArchitecture()) return false;
    if (hasArchitecture()) {
      if (!getArchitecture().equals(other.getArchitecture())) return false;
    }
    if (hasAutoDelete() != other.hasAutoDelete()) return false;
    if (hasAutoDelete()) {
      if (getAutoDelete() != other.getAutoDelete()) return false;
    }
    if (hasBoot() != other.hasBoot()) return false;
    if (hasBoot()) {
      if (getBoot() != other.getBoot()) return false;
    }
    if (hasDeviceName() != other.hasDeviceName()) return false;
    if (hasDeviceName()) {
      if (!getDeviceName().equals(other.getDeviceName())) return false;
    }
    if (hasDiskEncryptionKey() != other.hasDiskEncryptionKey()) return false;
    if (hasDiskEncryptionKey()) {
      if (!getDiskEncryptionKey().equals(other.getDiskEncryptionKey())) return false;
    }
    if (hasDiskSizeGb() != other.hasDiskSizeGb()) return false;
    if (hasDiskSizeGb()) {
      if (getDiskSizeGb() != other.getDiskSizeGb()) return false;
    }
    if (hasForceAttach() != other.hasForceAttach()) return false;
    if (hasForceAttach()) {
      if (getForceAttach() != other.getForceAttach()) return false;
    }
    if (!getGuestOsFeaturesList().equals(other.getGuestOsFeaturesList())) return false;
    if (hasIndex() != other.hasIndex()) return false;
    if (hasIndex()) {
      if (getIndex() != other.getIndex()) return false;
    }
    if (hasInitializeParams() != other.hasInitializeParams()) return false;
    if (hasInitializeParams()) {
      if (!getInitializeParams().equals(other.getInitializeParams())) return false;
    }
    if (hasInterface() != other.hasInterface()) return false;
    if (hasInterface()) {
      if (!getInterface().equals(other.getInterface())) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (!getLicensesList().equals(other.getLicensesList())) return false;
    if (hasMode() != other.hasMode()) return false;
    if (hasMode()) {
      if (!getMode().equals(other.getMode())) return false;
    }
    if (hasSavedState() != other.hasSavedState()) return false;
    if (hasSavedState()) {
      if (!getSavedState().equals(other.getSavedState())) return false;
    }
    if (hasShieldedInstanceInitialState() != other.hasShieldedInstanceInitialState()) return false;
    if (hasShieldedInstanceInitialState()) {
      if (!getShieldedInstanceInitialState().equals(other.getShieldedInstanceInitialState()))
        return false;
    }
    if (hasSource() != other.hasSource()) return false;
    if (hasSource()) {
      if (!getSource().equals(other.getSource())) return false;
    }
    if (hasType() != other.hasType()) return false;
    if (hasType()) {
      if (!getType().equals(other.getType())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasArchitecture()) {
      hash = (37 * hash) + ARCHITECTURE_FIELD_NUMBER;
      hash = (53 * hash) + getArchitecture().hashCode();
    }
    if (hasAutoDelete()) {
      hash = (37 * hash) + AUTO_DELETE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAutoDelete());
    }
    if (hasBoot()) {
      hash = (37 * hash) + BOOT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getBoot());
    }
    if (hasDeviceName()) {
      hash = (37 * hash) + DEVICE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDeviceName().hashCode();
    }
    if (hasDiskEncryptionKey()) {
      hash = (37 * hash) + DISK_ENCRYPTION_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getDiskEncryptionKey().hashCode();
    }
    if (hasDiskSizeGb()) {
      hash = (37 * hash) + DISK_SIZE_GB_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getDiskSizeGb());
    }
    if (hasForceAttach()) {
      hash = (37 * hash) + FORCE_ATTACH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getForceAttach());
    }
    if (getGuestOsFeaturesCount() > 0) {
      hash = (37 * hash) + GUEST_OS_FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getGuestOsFeaturesList().hashCode();
    }
    if (hasIndex()) {
      hash = (37 * hash) + INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getIndex();
    }
    if (hasInitializeParams()) {
      hash = (37 * hash) + INITIALIZE_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getInitializeParams().hashCode();
    }
    if (hasInterface()) {
      hash = (37 * hash) + INTERFACE_FIELD_NUMBER;
      hash = (53 * hash) + getInterface().hashCode();
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (getLicensesCount() > 0) {
      hash = (37 * hash) + LICENSES_FIELD_NUMBER;
      hash = (53 * hash) + getLicensesList().hashCode();
    }
    if (hasMode()) {
      hash = (37 * hash) + MODE_FIELD_NUMBER;
      hash = (53 * hash) + getMode().hashCode();
    }
    if (hasSavedState()) {
      hash = (37 * hash) + SAVED_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getSavedState().hashCode();
    }
    if (hasShieldedInstanceInitialState()) {
      hash = (37 * hash) + SHIELDED_INSTANCE_INITIAL_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getShieldedInstanceInitialState().hashCode();
    }
    if (hasSource()) {
      hash = (37 * hash) + SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getSource().hashCode();
    }
    if (hasType()) {
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.AttachedDisk parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AttachedDisk parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AttachedDisk parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AttachedDisk parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AttachedDisk parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AttachedDisk parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AttachedDisk parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AttachedDisk parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AttachedDisk parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AttachedDisk parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AttachedDisk parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AttachedDisk parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.AttachedDisk prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An instance-attached disk resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.AttachedDisk}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.AttachedDisk)
      com.google.cloud.compute.v1.AttachedDiskOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AttachedDisk_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AttachedDisk_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.AttachedDisk.class,
              com.google.cloud.compute.v1.AttachedDisk.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.AttachedDisk.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDiskEncryptionKeyFieldBuilder();
        getGuestOsFeaturesFieldBuilder();
        getInitializeParamsFieldBuilder();
        getShieldedInstanceInitialStateFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      architecture_ = "";
      autoDelete_ = false;
      boot_ = false;
      deviceName_ = "";
      diskEncryptionKey_ = null;
      if (diskEncryptionKeyBuilder_ != null) {
        diskEncryptionKeyBuilder_.dispose();
        diskEncryptionKeyBuilder_ = null;
      }
      diskSizeGb_ = 0L;
      forceAttach_ = false;
      if (guestOsFeaturesBuilder_ == null) {
        guestOsFeatures_ = java.util.Collections.emptyList();
      } else {
        guestOsFeatures_ = null;
        guestOsFeaturesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      index_ = 0;
      initializeParams_ = null;
      if (initializeParamsBuilder_ != null) {
        initializeParamsBuilder_.dispose();
        initializeParamsBuilder_ = null;
      }
      interface_ = "";
      kind_ = "";
      licenses_ = com.google.protobuf.LazyStringArrayList.emptyList();
      mode_ = "";
      savedState_ = "";
      shieldedInstanceInitialState_ = null;
      if (shieldedInstanceInitialStateBuilder_ != null) {
        shieldedInstanceInitialStateBuilder_.dispose();
        shieldedInstanceInitialStateBuilder_ = null;
      }
      source_ = "";
      type_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AttachedDisk_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AttachedDisk getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.AttachedDisk.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AttachedDisk build() {
      com.google.cloud.compute.v1.AttachedDisk result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AttachedDisk buildPartial() {
      com.google.cloud.compute.v1.AttachedDisk result =
          new com.google.cloud.compute.v1.AttachedDisk(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.AttachedDisk result) {
      if (guestOsFeaturesBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          guestOsFeatures_ = java.util.Collections.unmodifiableList(guestOsFeatures_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.guestOsFeatures_ = guestOsFeatures_;
      } else {
        result.guestOsFeatures_ = guestOsFeaturesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.AttachedDisk result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.architecture_ = architecture_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.autoDelete_ = autoDelete_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.boot_ = boot_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.deviceName_ = deviceName_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.diskEncryptionKey_ =
            diskEncryptionKeyBuilder_ == null
                ? diskEncryptionKey_
                : diskEncryptionKeyBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.diskSizeGb_ = diskSizeGb_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.forceAttach_ = forceAttach_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.index_ = index_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.initializeParams_ =
            initializeParamsBuilder_ == null ? initializeParams_ : initializeParamsBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.interface_ = interface_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        licenses_.makeImmutable();
        result.licenses_ = licenses_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.mode_ = mode_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.savedState_ = savedState_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.shieldedInstanceInitialState_ =
            shieldedInstanceInitialStateBuilder_ == null
                ? shieldedInstanceInitialState_
                : shieldedInstanceInitialStateBuilder_.build();
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.source_ = source_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.type_ = type_;
        to_bitField0_ |= 0x00008000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.AttachedDisk) {
        return mergeFrom((com.google.cloud.compute.v1.AttachedDisk) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.AttachedDisk other) {
      if (other == com.google.cloud.compute.v1.AttachedDisk.getDefaultInstance()) return this;
      if (other.hasArchitecture()) {
        architecture_ = other.architecture_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasAutoDelete()) {
        setAutoDelete(other.getAutoDelete());
      }
      if (other.hasBoot()) {
        setBoot(other.getBoot());
      }
      if (other.hasDeviceName()) {
        deviceName_ = other.deviceName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasDiskEncryptionKey()) {
        mergeDiskEncryptionKey(other.getDiskEncryptionKey());
      }
      if (other.hasDiskSizeGb()) {
        setDiskSizeGb(other.getDiskSizeGb());
      }
      if (other.hasForceAttach()) {
        setForceAttach(other.getForceAttach());
      }
      if (guestOsFeaturesBuilder_ == null) {
        if (!other.guestOsFeatures_.isEmpty()) {
          if (guestOsFeatures_.isEmpty()) {
            guestOsFeatures_ = other.guestOsFeatures_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureGuestOsFeaturesIsMutable();
            guestOsFeatures_.addAll(other.guestOsFeatures_);
          }
          onChanged();
        }
      } else {
        if (!other.guestOsFeatures_.isEmpty()) {
          if (guestOsFeaturesBuilder_.isEmpty()) {
            guestOsFeaturesBuilder_.dispose();
            guestOsFeaturesBuilder_ = null;
            guestOsFeatures_ = other.guestOsFeatures_;
            bitField0_ = (bitField0_ & ~0x00000080);
            guestOsFeaturesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGuestOsFeaturesFieldBuilder()
                    : null;
          } else {
            guestOsFeaturesBuilder_.addAllMessages(other.guestOsFeatures_);
          }
        }
      }
      if (other.hasIndex()) {
        setIndex(other.getIndex());
      }
      if (other.hasInitializeParams()) {
        mergeInitializeParams(other.getInitializeParams());
      }
      if (other.hasInterface()) {
        interface_ = other.interface_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (!other.licenses_.isEmpty()) {
        if (licenses_.isEmpty()) {
          licenses_ = other.licenses_;
          bitField0_ |= 0x00001000;
        } else {
          ensureLicensesIsMutable();
          licenses_.addAll(other.licenses_);
        }
        onChanged();
      }
      if (other.hasMode()) {
        mode_ = other.mode_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasSavedState()) {
        savedState_ = other.savedState_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasShieldedInstanceInitialState()) {
        mergeShieldedInstanceInitialState(other.getShieldedInstanceInitialState());
      }
      if (other.hasSource()) {
        source_ = other.source_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (other.hasType()) {
        type_ = other.type_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 24237968:
              {
                boot_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24237968
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 26336418
            case 26856730:
              {
                mode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 26856730
            case 28604882:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case 28604882
            case 141576362:
              {
                input.readMessage(
                    getInitializeParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 141576362
            case 540333730:
              {
                deviceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 540333730
            case 634356362:
              {
                com.google.cloud.compute.v1.GuestOsFeature m =
                    input.readMessage(
                        com.google.cloud.compute.v1.GuestOsFeature.parser(), extensionRegistry);
                if (guestOsFeaturesBuilder_ == null) {
                  ensureGuestOsFeaturesIsMutable();
                  guestOsFeatures_.add(m);
                } else {
                  guestOsFeaturesBuilder_.addMessage(m);
                }
                break;
              } // case 634356362
            case 802768528:
              {
                index_ = input.readInt32();
                bitField0_ |= 0x00000100;
                break;
              } // case 802768528
            case 1142067400:
              {
                forceAttach_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 1142067400
            case 1417887962:
              {
                source_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 1417887962
            case 1538854938:
              {
                input.readMessage(
                    getShieldedInstanceInitialStateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 1538854938
            case -2121681878:
              {
                input.readMessage(
                    getDiskEncryptionKeyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case -2121681878
            case -1872541030:
              {
                architecture_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -1872541030
            case -1764857416:
              {
                diskSizeGb_ = input.readInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case -1764857416
            case -1593826670:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureLicensesIsMutable();
                licenses_.add(s);
                break;
              } // case -1593826670
            case -1002264886:
              {
                savedState_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case -1002264886
            case -576876072:
              {
                autoDelete_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case -576876072
            case -273978934:
              {
                interface_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case -273978934
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object architecture_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the attached disk. Valid values are ARM64 or X86_64.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @return Whether the architecture field is set.
     */
    public boolean hasArchitecture() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the attached disk. Valid values are ARM64 or X86_64.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @return The architecture.
     */
    public java.lang.String getArchitecture() {
      java.lang.Object ref = architecture_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        architecture_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the attached disk. Valid values are ARM64 or X86_64.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @return The bytes for architecture.
     */
    public com.google.protobuf.ByteString getArchitectureBytes() {
      java.lang.Object ref = architecture_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        architecture_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the attached disk. Valid values are ARM64 or X86_64.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @param value The architecture to set.
     * @return This builder for chaining.
     */
    public Builder setArchitecture(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      architecture_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the attached disk. Valid values are ARM64 or X86_64.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArchitecture() {
      architecture_ = getDefaultInstance().getArchitecture();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the attached disk. Valid values are ARM64 or X86_64.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @param value The bytes for architecture to set.
     * @return This builder for chaining.
     */
    public Builder setArchitectureBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      architecture_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private boolean autoDelete_;
    /**
     *
     *
     * <pre>
     * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
     * </pre>
     *
     * <code>optional bool auto_delete = 464761403;</code>
     *
     * @return Whether the autoDelete field is set.
     */
    @java.lang.Override
    public boolean hasAutoDelete() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
     * </pre>
     *
     * <code>optional bool auto_delete = 464761403;</code>
     *
     * @return The autoDelete.
     */
    @java.lang.Override
    public boolean getAutoDelete() {
      return autoDelete_;
    }
    /**
     *
     *
     * <pre>
     * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
     * </pre>
     *
     * <code>optional bool auto_delete = 464761403;</code>
     *
     * @param value The autoDelete to set.
     * @return This builder for chaining.
     */
    public Builder setAutoDelete(boolean value) {

      autoDelete_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
     * </pre>
     *
     * <code>optional bool auto_delete = 464761403;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutoDelete() {
      bitField0_ = (bitField0_ & ~0x00000002);
      autoDelete_ = false;
      onChanged();
      return this;
    }

    private boolean boot_;
    /**
     *
     *
     * <pre>
     * Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
     * </pre>
     *
     * <code>optional bool boot = 3029746;</code>
     *
     * @return Whether the boot field is set.
     */
    @java.lang.Override
    public boolean hasBoot() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
     * </pre>
     *
     * <code>optional bool boot = 3029746;</code>
     *
     * @return The boot.
     */
    @java.lang.Override
    public boolean getBoot() {
      return boot_;
    }
    /**
     *
     *
     * <pre>
     * Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
     * </pre>
     *
     * <code>optional bool boot = 3029746;</code>
     *
     * @param value The boot to set.
     * @return This builder for chaining.
     */
    public Builder setBoot(boolean value) {

      boot_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
     * </pre>
     *
     * <code>optional bool boot = 3029746;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBoot() {
      bitField0_ = (bitField0_ & ~0x00000004);
      boot_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object deviceName_ = "";
    /**
     *
     *
     * <pre>
     * Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
     * </pre>
     *
     * <code>optional string device_name = 67541716;</code>
     *
     * @return Whether the deviceName field is set.
     */
    public boolean hasDeviceName() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
     * </pre>
     *
     * <code>optional string device_name = 67541716;</code>
     *
     * @return The deviceName.
     */
    public java.lang.String getDeviceName() {
      java.lang.Object ref = deviceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deviceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
     * </pre>
     *
     * <code>optional string device_name = 67541716;</code>
     *
     * @return The bytes for deviceName.
     */
    public com.google.protobuf.ByteString getDeviceNameBytes() {
      java.lang.Object ref = deviceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deviceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
     * </pre>
     *
     * <code>optional string device_name = 67541716;</code>
     *
     * @param value The deviceName to set.
     * @return This builder for chaining.
     */
    public Builder setDeviceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deviceName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
     * </pre>
     *
     * <code>optional string device_name = 67541716;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeviceName() {
      deviceName_ = getDefaultInstance().getDeviceName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
     * </pre>
     *
     * <code>optional string device_name = 67541716;</code>
     *
     * @param value The bytes for deviceName to set.
     * @return This builder for chaining.
     */
    public Builder setDeviceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deviceName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.CustomerEncryptionKey diskEncryptionKey_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CustomerEncryptionKey,
            com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
            com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>
        diskEncryptionKeyBuilder_;
    /**
     *
     *
     * <pre>
     * Encrypts or decrypts a disk using a customer-supplied encryption key. If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key. If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance. If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later. Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 271660677;
     * </code>
     *
     * @return Whether the diskEncryptionKey field is set.
     */
    public boolean hasDiskEncryptionKey() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Encrypts or decrypts a disk using a customer-supplied encryption key. If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key. If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance. If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later. Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 271660677;
     * </code>
     *
     * @return The diskEncryptionKey.
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKey getDiskEncryptionKey() {
      if (diskEncryptionKeyBuilder_ == null) {
        return diskEncryptionKey_ == null
            ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
            : diskEncryptionKey_;
      } else {
        return diskEncryptionKeyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Encrypts or decrypts a disk using a customer-supplied encryption key. If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key. If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance. If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later. Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 271660677;
     * </code>
     */
    public Builder setDiskEncryptionKey(com.google.cloud.compute.v1.CustomerEncryptionKey value) {
      if (diskEncryptionKeyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        diskEncryptionKey_ = value;
      } else {
        diskEncryptionKeyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encrypts or decrypts a disk using a customer-supplied encryption key. If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key. If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance. If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later. Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 271660677;
     * </code>
     */
    public Builder setDiskEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey.Builder builderForValue) {
      if (diskEncryptionKeyBuilder_ == null) {
        diskEncryptionKey_ = builderForValue.build();
      } else {
        diskEncryptionKeyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encrypts or decrypts a disk using a customer-supplied encryption key. If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key. If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance. If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later. Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 271660677;
     * </code>
     */
    public Builder mergeDiskEncryptionKey(com.google.cloud.compute.v1.CustomerEncryptionKey value) {
      if (diskEncryptionKeyBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && diskEncryptionKey_ != null
            && diskEncryptionKey_
                != com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()) {
          getDiskEncryptionKeyBuilder().mergeFrom(value);
        } else {
          diskEncryptionKey_ = value;
        }
      } else {
        diskEncryptionKeyBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encrypts or decrypts a disk using a customer-supplied encryption key. If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key. If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance. If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later. Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 271660677;
     * </code>
     */
    public Builder clearDiskEncryptionKey() {
      bitField0_ = (bitField0_ & ~0x00000010);
      diskEncryptionKey_ = null;
      if (diskEncryptionKeyBuilder_ != null) {
        diskEncryptionKeyBuilder_.dispose();
        diskEncryptionKeyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encrypts or decrypts a disk using a customer-supplied encryption key. If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key. If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance. If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later. Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 271660677;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKey.Builder getDiskEncryptionKeyBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getDiskEncryptionKeyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Encrypts or decrypts a disk using a customer-supplied encryption key. If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key. If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance. If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later. Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 271660677;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder
        getDiskEncryptionKeyOrBuilder() {
      if (diskEncryptionKeyBuilder_ != null) {
        return diskEncryptionKeyBuilder_.getMessageOrBuilder();
      } else {
        return diskEncryptionKey_ == null
            ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
            : diskEncryptionKey_;
      }
    }
    /**
     *
     *
     * <pre>
     * Encrypts or decrypts a disk using a customer-supplied encryption key. If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key. If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance. If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later. Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 271660677;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CustomerEncryptionKey,
            com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
            com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>
        getDiskEncryptionKeyFieldBuilder() {
      if (diskEncryptionKeyBuilder_ == null) {
        diskEncryptionKeyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.CustomerEncryptionKey,
                com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
                com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>(
                getDiskEncryptionKey(), getParentForChildren(), isClean());
        diskEncryptionKey_ = null;
      }
      return diskEncryptionKeyBuilder_;
    }

    private long diskSizeGb_;
    /**
     *
     *
     * <pre>
     * The size of the disk in GB.
     * </pre>
     *
     * <code>optional int64 disk_size_gb = 316263735;</code>
     *
     * @return Whether the diskSizeGb field is set.
     */
    @java.lang.Override
    public boolean hasDiskSizeGb() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The size of the disk in GB.
     * </pre>
     *
     * <code>optional int64 disk_size_gb = 316263735;</code>
     *
     * @return The diskSizeGb.
     */
    @java.lang.Override
    public long getDiskSizeGb() {
      return diskSizeGb_;
    }
    /**
     *
     *
     * <pre>
     * The size of the disk in GB.
     * </pre>
     *
     * <code>optional int64 disk_size_gb = 316263735;</code>
     *
     * @param value The diskSizeGb to set.
     * @return This builder for chaining.
     */
    public Builder setDiskSizeGb(long value) {

      diskSizeGb_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The size of the disk in GB.
     * </pre>
     *
     * <code>optional int64 disk_size_gb = 316263735;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiskSizeGb() {
      bitField0_ = (bitField0_ & ~0x00000020);
      diskSizeGb_ = 0L;
      onChanged();
      return this;
    }

    private boolean forceAttach_;
    /**
     *
     *
     * <pre>
     * [Input Only] Whether to force attach the regional disk even if it's currently attached to another instance. If you try to force attach a zonal disk to an instance, you will receive an error.
     * </pre>
     *
     * <code>optional bool force_attach = 142758425;</code>
     *
     * @return Whether the forceAttach field is set.
     */
    @java.lang.Override
    public boolean hasForceAttach() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Input Only] Whether to force attach the regional disk even if it's currently attached to another instance. If you try to force attach a zonal disk to an instance, you will receive an error.
     * </pre>
     *
     * <code>optional bool force_attach = 142758425;</code>
     *
     * @return The forceAttach.
     */
    @java.lang.Override
    public boolean getForceAttach() {
      return forceAttach_;
    }
    /**
     *
     *
     * <pre>
     * [Input Only] Whether to force attach the regional disk even if it's currently attached to another instance. If you try to force attach a zonal disk to an instance, you will receive an error.
     * </pre>
     *
     * <code>optional bool force_attach = 142758425;</code>
     *
     * @param value The forceAttach to set.
     * @return This builder for chaining.
     */
    public Builder setForceAttach(boolean value) {

      forceAttach_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Input Only] Whether to force attach the regional disk even if it's currently attached to another instance. If you try to force attach a zonal disk to an instance, you will receive an error.
     * </pre>
     *
     * <code>optional bool force_attach = 142758425;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearForceAttach() {
      bitField0_ = (bitField0_ & ~0x00000040);
      forceAttach_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.GuestOsFeature> guestOsFeatures_ =
        java.util.Collections.emptyList();

    private void ensureGuestOsFeaturesIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        guestOsFeatures_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.GuestOsFeature>(guestOsFeatures_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.GuestOsFeature,
            com.google.cloud.compute.v1.GuestOsFeature.Builder,
            com.google.cloud.compute.v1.GuestOsFeatureOrBuilder>
        guestOsFeaturesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.GuestOsFeature> getGuestOsFeaturesList() {
      if (guestOsFeaturesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(guestOsFeatures_);
      } else {
        return guestOsFeaturesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public int getGuestOsFeaturesCount() {
      if (guestOsFeaturesBuilder_ == null) {
        return guestOsFeatures_.size();
      } else {
        return guestOsFeaturesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public com.google.cloud.compute.v1.GuestOsFeature getGuestOsFeatures(int index) {
      if (guestOsFeaturesBuilder_ == null) {
        return guestOsFeatures_.get(index);
      } else {
        return guestOsFeaturesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public Builder setGuestOsFeatures(int index, com.google.cloud.compute.v1.GuestOsFeature value) {
      if (guestOsFeaturesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGuestOsFeaturesIsMutable();
        guestOsFeatures_.set(index, value);
        onChanged();
      } else {
        guestOsFeaturesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public Builder setGuestOsFeatures(
        int index, com.google.cloud.compute.v1.GuestOsFeature.Builder builderForValue) {
      if (guestOsFeaturesBuilder_ == null) {
        ensureGuestOsFeaturesIsMutable();
        guestOsFeatures_.set(index, builderForValue.build());
        onChanged();
      } else {
        guestOsFeaturesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public Builder addGuestOsFeatures(com.google.cloud.compute.v1.GuestOsFeature value) {
      if (guestOsFeaturesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGuestOsFeaturesIsMutable();
        guestOsFeatures_.add(value);
        onChanged();
      } else {
        guestOsFeaturesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public Builder addGuestOsFeatures(int index, com.google.cloud.compute.v1.GuestOsFeature value) {
      if (guestOsFeaturesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGuestOsFeaturesIsMutable();
        guestOsFeatures_.add(index, value);
        onChanged();
      } else {
        guestOsFeaturesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public Builder addGuestOsFeatures(
        com.google.cloud.compute.v1.GuestOsFeature.Builder builderForValue) {
      if (guestOsFeaturesBuilder_ == null) {
        ensureGuestOsFeaturesIsMutable();
        guestOsFeatures_.add(builderForValue.build());
        onChanged();
      } else {
        guestOsFeaturesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public Builder addGuestOsFeatures(
        int index, com.google.cloud.compute.v1.GuestOsFeature.Builder builderForValue) {
      if (guestOsFeaturesBuilder_ == null) {
        ensureGuestOsFeaturesIsMutable();
        guestOsFeatures_.add(index, builderForValue.build());
        onChanged();
      } else {
        guestOsFeaturesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public Builder addAllGuestOsFeatures(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.GuestOsFeature> values) {
      if (guestOsFeaturesBuilder_ == null) {
        ensureGuestOsFeaturesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, guestOsFeatures_);
        onChanged();
      } else {
        guestOsFeaturesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public Builder clearGuestOsFeatures() {
      if (guestOsFeaturesBuilder_ == null) {
        guestOsFeatures_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        guestOsFeaturesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public Builder removeGuestOsFeatures(int index) {
      if (guestOsFeaturesBuilder_ == null) {
        ensureGuestOsFeaturesIsMutable();
        guestOsFeatures_.remove(index);
        onChanged();
      } else {
        guestOsFeaturesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public com.google.cloud.compute.v1.GuestOsFeature.Builder getGuestOsFeaturesBuilder(int index) {
      return getGuestOsFeaturesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public com.google.cloud.compute.v1.GuestOsFeatureOrBuilder getGuestOsFeaturesOrBuilder(
        int index) {
      if (guestOsFeaturesBuilder_ == null) {
        return guestOsFeatures_.get(index);
      } else {
        return guestOsFeaturesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.GuestOsFeatureOrBuilder>
        getGuestOsFeaturesOrBuilderList() {
      if (guestOsFeaturesBuilder_ != null) {
        return guestOsFeaturesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(guestOsFeatures_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public com.google.cloud.compute.v1.GuestOsFeature.Builder addGuestOsFeaturesBuilder() {
      return getGuestOsFeaturesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.GuestOsFeature.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public com.google.cloud.compute.v1.GuestOsFeature.Builder addGuestOsFeaturesBuilder(int index) {
      return getGuestOsFeaturesFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.GuestOsFeature.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.GuestOsFeature.Builder>
        getGuestOsFeaturesBuilderList() {
      return getGuestOsFeaturesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.GuestOsFeature,
            com.google.cloud.compute.v1.GuestOsFeature.Builder,
            com.google.cloud.compute.v1.GuestOsFeatureOrBuilder>
        getGuestOsFeaturesFieldBuilder() {
      if (guestOsFeaturesBuilder_ == null) {
        guestOsFeaturesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.GuestOsFeature,
                com.google.cloud.compute.v1.GuestOsFeature.Builder,
                com.google.cloud.compute.v1.GuestOsFeatureOrBuilder>(
                guestOsFeatures_,
                ((bitField0_ & 0x00000080) != 0),
                getParentForChildren(),
                isClean());
        guestOsFeatures_ = null;
      }
      return guestOsFeaturesBuilder_;
    }

    private int index_;
    /**
     *
     *
     * <pre>
     * [Output Only] A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
     * </pre>
     *
     * <code>optional int32 index = 100346066;</code>
     *
     * @return Whether the index field is set.
     */
    @java.lang.Override
    public boolean hasIndex() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
     * </pre>
     *
     * <code>optional int32 index = 100346066;</code>
     *
     * @return The index.
     */
    @java.lang.Override
    public int getIndex() {
      return index_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
     * </pre>
     *
     * <code>optional int32 index = 100346066;</code>
     *
     * @param value The index to set.
     * @return This builder for chaining.
     */
    public Builder setIndex(int value) {

      index_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
     * </pre>
     *
     * <code>optional int32 index = 100346066;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndex() {
      bitField0_ = (bitField0_ & ~0x00000100);
      index_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.AttachedDiskInitializeParams initializeParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.AttachedDiskInitializeParams,
            com.google.cloud.compute.v1.AttachedDiskInitializeParams.Builder,
            com.google.cloud.compute.v1.AttachedDiskInitializeParamsOrBuilder>
        initializeParamsBuilder_;
    /**
     *
     *
     * <pre>
     * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AttachedDiskInitializeParams initialize_params = 17697045;
     * </code>
     *
     * @return Whether the initializeParams field is set.
     */
    public boolean hasInitializeParams() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AttachedDiskInitializeParams initialize_params = 17697045;
     * </code>
     *
     * @return The initializeParams.
     */
    public com.google.cloud.compute.v1.AttachedDiskInitializeParams getInitializeParams() {
      if (initializeParamsBuilder_ == null) {
        return initializeParams_ == null
            ? com.google.cloud.compute.v1.AttachedDiskInitializeParams.getDefaultInstance()
            : initializeParams_;
      } else {
        return initializeParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AttachedDiskInitializeParams initialize_params = 17697045;
     * </code>
     */
    public Builder setInitializeParams(
        com.google.cloud.compute.v1.AttachedDiskInitializeParams value) {
      if (initializeParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        initializeParams_ = value;
      } else {
        initializeParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AttachedDiskInitializeParams initialize_params = 17697045;
     * </code>
     */
    public Builder setInitializeParams(
        com.google.cloud.compute.v1.AttachedDiskInitializeParams.Builder builderForValue) {
      if (initializeParamsBuilder_ == null) {
        initializeParams_ = builderForValue.build();
      } else {
        initializeParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AttachedDiskInitializeParams initialize_params = 17697045;
     * </code>
     */
    public Builder mergeInitializeParams(
        com.google.cloud.compute.v1.AttachedDiskInitializeParams value) {
      if (initializeParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && initializeParams_ != null
            && initializeParams_
                != com.google.cloud.compute.v1.AttachedDiskInitializeParams.getDefaultInstance()) {
          getInitializeParamsBuilder().mergeFrom(value);
        } else {
          initializeParams_ = value;
        }
      } else {
        initializeParamsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AttachedDiskInitializeParams initialize_params = 17697045;
     * </code>
     */
    public Builder clearInitializeParams() {
      bitField0_ = (bitField0_ & ~0x00000200);
      initializeParams_ = null;
      if (initializeParamsBuilder_ != null) {
        initializeParamsBuilder_.dispose();
        initializeParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AttachedDiskInitializeParams initialize_params = 17697045;
     * </code>
     */
    public com.google.cloud.compute.v1.AttachedDiskInitializeParams.Builder
        getInitializeParamsBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getInitializeParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AttachedDiskInitializeParams initialize_params = 17697045;
     * </code>
     */
    public com.google.cloud.compute.v1.AttachedDiskInitializeParamsOrBuilder
        getInitializeParamsOrBuilder() {
      if (initializeParamsBuilder_ != null) {
        return initializeParamsBuilder_.getMessageOrBuilder();
      } else {
        return initializeParams_ == null
            ? com.google.cloud.compute.v1.AttachedDiskInitializeParams.getDefaultInstance()
            : initializeParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AttachedDiskInitializeParams initialize_params = 17697045;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.AttachedDiskInitializeParams,
            com.google.cloud.compute.v1.AttachedDiskInitializeParams.Builder,
            com.google.cloud.compute.v1.AttachedDiskInitializeParamsOrBuilder>
        getInitializeParamsFieldBuilder() {
      if (initializeParamsBuilder_ == null) {
        initializeParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.AttachedDiskInitializeParams,
                com.google.cloud.compute.v1.AttachedDiskInitializeParams.Builder,
                com.google.cloud.compute.v1.AttachedDiskInitializeParamsOrBuilder>(
                getInitializeParams(), getParentForChildren(), isClean());
        initializeParams_ = null;
      }
      return initializeParamsBuilder_;
    }

    private java.lang.Object interface_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. For most machine types, the default is SCSI. Local SSDs can use either NVME or SCSI. In certain configurations, persistent disks can use NVMe. For more information, see About persistent disks.
     * Check the Interface enum for the list of possible values.
     * </pre>
     *
     * <code>optional string interface = 502623545;</code>
     *
     * @return Whether the interface field is set.
     */
    public boolean hasInterface() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. For most machine types, the default is SCSI. Local SSDs can use either NVME or SCSI. In certain configurations, persistent disks can use NVMe. For more information, see About persistent disks.
     * Check the Interface enum for the list of possible values.
     * </pre>
     *
     * <code>optional string interface = 502623545;</code>
     *
     * @return The interface.
     */
    public java.lang.String getInterface() {
      java.lang.Object ref = interface_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        interface_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. For most machine types, the default is SCSI. Local SSDs can use either NVME or SCSI. In certain configurations, persistent disks can use NVMe. For more information, see About persistent disks.
     * Check the Interface enum for the list of possible values.
     * </pre>
     *
     * <code>optional string interface = 502623545;</code>
     *
     * @return The bytes for interface.
     */
    public com.google.protobuf.ByteString getInterfaceBytes() {
      java.lang.Object ref = interface_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        interface_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. For most machine types, the default is SCSI. Local SSDs can use either NVME or SCSI. In certain configurations, persistent disks can use NVMe. For more information, see About persistent disks.
     * Check the Interface enum for the list of possible values.
     * </pre>
     *
     * <code>optional string interface = 502623545;</code>
     *
     * @param value The interface to set.
     * @return This builder for chaining.
     */
    public Builder setInterface(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      interface_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. For most machine types, the default is SCSI. Local SSDs can use either NVME or SCSI. In certain configurations, persistent disks can use NVMe. For more information, see About persistent disks.
     * Check the Interface enum for the list of possible values.
     * </pre>
     *
     * <code>optional string interface = 502623545;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInterface() {
      interface_ = getDefaultInstance().getInterface();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. For most machine types, the default is SCSI. Local SSDs can use either NVME or SCSI. In certain configurations, persistent disks can use NVMe. For more information, see About persistent disks.
     * Check the Interface enum for the list of possible values.
     * </pre>
     *
     * <code>optional string interface = 502623545;</code>
     *
     * @param value The bytes for interface to set.
     * @return This builder for chaining.
     */
    public Builder setInterfaceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      interface_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList licenses_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureLicensesIsMutable() {
      if (!licenses_.isModifiable()) {
        licenses_ = new com.google.protobuf.LazyStringArrayList(licenses_);
      }
      bitField0_ |= 0x00001000;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Any valid publicly visible licenses.
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @return A list containing the licenses.
     */
    public com.google.protobuf.ProtocolStringList getLicensesList() {
      licenses_.makeImmutable();
      return licenses_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Any valid publicly visible licenses.
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @return The count of licenses.
     */
    public int getLicensesCount() {
      return licenses_.size();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Any valid publicly visible licenses.
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @param index The index of the element to return.
     * @return The licenses at the given index.
     */
    public java.lang.String getLicenses(int index) {
      return licenses_.get(index);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Any valid publicly visible licenses.
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the licenses at the given index.
     */
    public com.google.protobuf.ByteString getLicensesBytes(int index) {
      return licenses_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Any valid publicly visible licenses.
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @param index The index to set the value at.
     * @param value The licenses to set.
     * @return This builder for chaining.
     */
    public Builder setLicenses(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLicensesIsMutable();
      licenses_.set(index, value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Any valid publicly visible licenses.
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @param value The licenses to add.
     * @return This builder for chaining.
     */
    public Builder addLicenses(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLicensesIsMutable();
      licenses_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Any valid publicly visible licenses.
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @param values The licenses to add.
     * @return This builder for chaining.
     */
    public Builder addAllLicenses(java.lang.Iterable<java.lang.String> values) {
      ensureLicensesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, licenses_);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Any valid publicly visible licenses.
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLicenses() {
      licenses_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00001000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Any valid publicly visible licenses.
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @param value The bytes of the licenses to add.
     * @return This builder for chaining.
     */
    public Builder addLicensesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureLicensesIsMutable();
      licenses_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object mode_ = "";
    /**
     *
     *
     * <pre>
     * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
     * Check the Mode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string mode = 3357091;</code>
     *
     * @return Whether the mode field is set.
     */
    public boolean hasMode() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
     * Check the Mode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string mode = 3357091;</code>
     *
     * @return The mode.
     */
    public java.lang.String getMode() {
      java.lang.Object ref = mode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
     * Check the Mode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string mode = 3357091;</code>
     *
     * @return The bytes for mode.
     */
    public com.google.protobuf.ByteString getModeBytes() {
      java.lang.Object ref = mode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
     * Check the Mode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string mode = 3357091;</code>
     *
     * @param value The mode to set.
     * @return This builder for chaining.
     */
    public Builder setMode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      mode_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
     * Check the Mode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string mode = 3357091;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMode() {
      mode_ = getDefaultInstance().getMode();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
     * Check the Mode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string mode = 3357091;</code>
     *
     * @param value The bytes for mode to set.
     * @return This builder for chaining.
     */
    public Builder setModeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      mode_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object savedState_ = "";
    /**
     *
     *
     * <pre>
     * For LocalSSD disks on VM Instances in STOPPED or SUSPENDED state, this field is set to PRESERVED if the LocalSSD data has been saved to a persistent location by customer request. (see the discard_local_ssd option on Stop/Suspend). Read-only in the api.
     * Check the SavedState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string saved_state = 411587801;</code>
     *
     * @return Whether the savedState field is set.
     */
    public boolean hasSavedState() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * For LocalSSD disks on VM Instances in STOPPED or SUSPENDED state, this field is set to PRESERVED if the LocalSSD data has been saved to a persistent location by customer request. (see the discard_local_ssd option on Stop/Suspend). Read-only in the api.
     * Check the SavedState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string saved_state = 411587801;</code>
     *
     * @return The savedState.
     */
    public java.lang.String getSavedState() {
      java.lang.Object ref = savedState_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        savedState_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * For LocalSSD disks on VM Instances in STOPPED or SUSPENDED state, this field is set to PRESERVED if the LocalSSD data has been saved to a persistent location by customer request. (see the discard_local_ssd option on Stop/Suspend). Read-only in the api.
     * Check the SavedState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string saved_state = 411587801;</code>
     *
     * @return The bytes for savedState.
     */
    public com.google.protobuf.ByteString getSavedStateBytes() {
      java.lang.Object ref = savedState_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        savedState_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * For LocalSSD disks on VM Instances in STOPPED or SUSPENDED state, this field is set to PRESERVED if the LocalSSD data has been saved to a persistent location by customer request. (see the discard_local_ssd option on Stop/Suspend). Read-only in the api.
     * Check the SavedState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string saved_state = 411587801;</code>
     *
     * @param value The savedState to set.
     * @return This builder for chaining.
     */
    public Builder setSavedState(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      savedState_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For LocalSSD disks on VM Instances in STOPPED or SUSPENDED state, this field is set to PRESERVED if the LocalSSD data has been saved to a persistent location by customer request. (see the discard_local_ssd option on Stop/Suspend). Read-only in the api.
     * Check the SavedState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string saved_state = 411587801;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSavedState() {
      savedState_ = getDefaultInstance().getSavedState();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For LocalSSD disks on VM Instances in STOPPED or SUSPENDED state, this field is set to PRESERVED if the LocalSSD data has been saved to a persistent location by customer request. (see the discard_local_ssd option on Stop/Suspend). Read-only in the api.
     * Check the SavedState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string saved_state = 411587801;</code>
     *
     * @param value The bytes for savedState to set.
     * @return This builder for chaining.
     */
    public Builder setSavedStateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      savedState_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.InitialStateConfig shieldedInstanceInitialState_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InitialStateConfig,
            com.google.cloud.compute.v1.InitialStateConfig.Builder,
            com.google.cloud.compute.v1.InitialStateConfigOrBuilder>
        shieldedInstanceInitialStateBuilder_;
    /**
     *
     *
     * <pre>
     * [Output Only] shielded vm initial state stored on disk
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InitialStateConfig shielded_instance_initial_state = 192356867;
     * </code>
     *
     * @return Whether the shieldedInstanceInitialState field is set.
     */
    public boolean hasShieldedInstanceInitialState() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] shielded vm initial state stored on disk
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InitialStateConfig shielded_instance_initial_state = 192356867;
     * </code>
     *
     * @return The shieldedInstanceInitialState.
     */
    public com.google.cloud.compute.v1.InitialStateConfig getShieldedInstanceInitialState() {
      if (shieldedInstanceInitialStateBuilder_ == null) {
        return shieldedInstanceInitialState_ == null
            ? com.google.cloud.compute.v1.InitialStateConfig.getDefaultInstance()
            : shieldedInstanceInitialState_;
      } else {
        return shieldedInstanceInitialStateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] shielded vm initial state stored on disk
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InitialStateConfig shielded_instance_initial_state = 192356867;
     * </code>
     */
    public Builder setShieldedInstanceInitialState(
        com.google.cloud.compute.v1.InitialStateConfig value) {
      if (shieldedInstanceInitialStateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        shieldedInstanceInitialState_ = value;
      } else {
        shieldedInstanceInitialStateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] shielded vm initial state stored on disk
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InitialStateConfig shielded_instance_initial_state = 192356867;
     * </code>
     */
    public Builder setShieldedInstanceInitialState(
        com.google.cloud.compute.v1.InitialStateConfig.Builder builderForValue) {
      if (shieldedInstanceInitialStateBuilder_ == null) {
        shieldedInstanceInitialState_ = builderForValue.build();
      } else {
        shieldedInstanceInitialStateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] shielded vm initial state stored on disk
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InitialStateConfig shielded_instance_initial_state = 192356867;
     * </code>
     */
    public Builder mergeShieldedInstanceInitialState(
        com.google.cloud.compute.v1.InitialStateConfig value) {
      if (shieldedInstanceInitialStateBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && shieldedInstanceInitialState_ != null
            && shieldedInstanceInitialState_
                != com.google.cloud.compute.v1.InitialStateConfig.getDefaultInstance()) {
          getShieldedInstanceInitialStateBuilder().mergeFrom(value);
        } else {
          shieldedInstanceInitialState_ = value;
        }
      } else {
        shieldedInstanceInitialStateBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] shielded vm initial state stored on disk
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InitialStateConfig shielded_instance_initial_state = 192356867;
     * </code>
     */
    public Builder clearShieldedInstanceInitialState() {
      bitField0_ = (bitField0_ & ~0x00008000);
      shieldedInstanceInitialState_ = null;
      if (shieldedInstanceInitialStateBuilder_ != null) {
        shieldedInstanceInitialStateBuilder_.dispose();
        shieldedInstanceInitialStateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] shielded vm initial state stored on disk
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InitialStateConfig shielded_instance_initial_state = 192356867;
     * </code>
     */
    public com.google.cloud.compute.v1.InitialStateConfig.Builder
        getShieldedInstanceInitialStateBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getShieldedInstanceInitialStateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] shielded vm initial state stored on disk
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InitialStateConfig shielded_instance_initial_state = 192356867;
     * </code>
     */
    public com.google.cloud.compute.v1.InitialStateConfigOrBuilder
        getShieldedInstanceInitialStateOrBuilder() {
      if (shieldedInstanceInitialStateBuilder_ != null) {
        return shieldedInstanceInitialStateBuilder_.getMessageOrBuilder();
      } else {
        return shieldedInstanceInitialState_ == null
            ? com.google.cloud.compute.v1.InitialStateConfig.getDefaultInstance()
            : shieldedInstanceInitialState_;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] shielded vm initial state stored on disk
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InitialStateConfig shielded_instance_initial_state = 192356867;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InitialStateConfig,
            com.google.cloud.compute.v1.InitialStateConfig.Builder,
            com.google.cloud.compute.v1.InitialStateConfigOrBuilder>
        getShieldedInstanceInitialStateFieldBuilder() {
      if (shieldedInstanceInitialStateBuilder_ == null) {
        shieldedInstanceInitialStateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InitialStateConfig,
                com.google.cloud.compute.v1.InitialStateConfig.Builder,
                com.google.cloud.compute.v1.InitialStateConfigOrBuilder>(
                getShieldedInstanceInitialState(), getParentForChildren(), isClean());
        shieldedInstanceInitialState_ = null;
      }
      return shieldedInstanceInitialStateBuilder_;
    }

    private java.lang.Object source_ = "";
    /**
     *
     *
     * <pre>
     * Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks. Note that for InstanceTemplate, specify the disk name for zonal disk, and the URL for regional disk.
     * </pre>
     *
     * <code>optional string source = 177235995;</code>
     *
     * @return Whether the source field is set.
     */
    public boolean hasSource() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks. Note that for InstanceTemplate, specify the disk name for zonal disk, and the URL for regional disk.
     * </pre>
     *
     * <code>optional string source = 177235995;</code>
     *
     * @return The source.
     */
    public java.lang.String getSource() {
      java.lang.Object ref = source_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        source_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks. Note that for InstanceTemplate, specify the disk name for zonal disk, and the URL for regional disk.
     * </pre>
     *
     * <code>optional string source = 177235995;</code>
     *
     * @return The bytes for source.
     */
    public com.google.protobuf.ByteString getSourceBytes() {
      java.lang.Object ref = source_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        source_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks. Note that for InstanceTemplate, specify the disk name for zonal disk, and the URL for regional disk.
     * </pre>
     *
     * <code>optional string source = 177235995;</code>
     *
     * @param value The source to set.
     * @return This builder for chaining.
     */
    public Builder setSource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      source_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks. Note that for InstanceTemplate, specify the disk name for zonal disk, and the URL for regional disk.
     * </pre>
     *
     * <code>optional string source = 177235995;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSource() {
      source_ = getDefaultInstance().getSource();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks. Note that for InstanceTemplate, specify the disk name for zonal disk, and the URL for regional disk.
     * </pre>
     *
     * <code>optional string source = 177235995;</code>
     *
     * @param value The bytes for source to set.
     * @return This builder for chaining.
     */
    public Builder setSourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      source_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return Whether the type field is set.
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.AttachedDisk)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.AttachedDisk)
  private static final com.google.cloud.compute.v1.AttachedDisk DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.AttachedDisk();
  }

  public static com.google.cloud.compute.v1.AttachedDisk getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AttachedDisk> PARSER =
      new com.google.protobuf.AbstractParser<AttachedDisk>() {
        @java.lang.Override
        public AttachedDisk parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AttachedDisk> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AttachedDisk> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.AttachedDisk getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
